
SUBROUTINE SAV_PALLET
!******************************************************************************
!*                                                                            *
!*  THIS SUBROUTINE SAVES A PALETTE DATA FILE.  IF THE FILE ALREADU EXISTS A  *
!*  MESSAGE BOX IS DISPLAYED ASKING IF THE FILE SHOULD BE OVERWRITTEN.  IF YES*
!*  IS CHOSEN THE THE FIEL IS OVERWRITTEN.  IF NO OR CANCEL IS CHOSEN THE     *
!*  NOTHING HAPPENS															  *
!*                                                                            *
!******************************************************************************

  USE MSFLIB
  USE INPUTINFO
  USE PALET

  IMPLICIT NONE


  NAMELIST /PALLETINPUT/ LCHG, RPHS, BPHS, GPHS, RDELTHE, BDELTHE, GDELTHE, &
                  LSEE, RMAX, BMAX, GMAX, IRDELAY, IBDELAY, IGDELAY,        &
				  REDSTART, REDEND, GREENSTART, GREENEND, BLUESTART,        &
				  BLUEEND, LNRED, LNGREEN, LNBLUE


  CHARACTER(LEN=100)MSG0, MSG1
  INTEGER(KIND=4)IRET, IERR

!* OPEN INPUT FILE
  OPEN(UNIT = 100, FILE = PALLET_SAV, STATUS = 'NEW', IOSTAT = IERR)
  IF(IERR .NE. 0)THEN
    MSG0 = ' THE FILE ALREADY EXISTS. DO YOU WANT TO OVERWRITE IT?'C
	MSG1 = ' ERROR OPENING FILE 'C
	IRET = MESSAGEBOXQQ(MSG0, MSG1, MB$ICONEXCLAMATION .OR. MB$YESNOCANCEL)
	IF(IRET == MB$IDYES)THEN
      OPEN(UNIT = 100, FILE = PALLET_SAV, STATUS = 'OLD', IOSTAT = IERR)
	  REWIND(100)
    ELSE
      RETURN
	ENDIF
  ENDIF
!* 
!* WRITE OUT INFOPRMATION
!*

  WRITE(100,PALLETINPUT, IOSTAT = IERR)
  IF(IERR .NE. 0)THEN
    MSG0 = ' ERROR WRITING TO OUTPUT FILE '//TRIM(PALLET_SAV)//' 'C
	MSG1 = ' ERROR WRITING FILE 'C
	IRET = MESSAGEBOXQQ(MSG0, MSG1, MB$ICONEXCLAMATION .OR. MB$OK)
	RETURN
  ENDIF

  CLOSE(UNIT=100)

RETURN
END
