SUBROUTINE SAV_CHAOS
!******************************************************************************
!*                                                                            *
!*  THIS SUBROUTINE SAVES A CHAOS DATA FILE.  IF THE FILE ALREADU EXISTS A    *
!*  MESSAGE BOX IS DISPLAYED ASKING IF THE FILE SHOULD BE OVERWRITTEN.  IF YES*
!*  IS CHOSEN THE THE FIEL IS OVERWRITTEN.  IF NO OR CANCEL IS CHOSEN THE     *
!*  NOTHING HAPPENS															  *
!*                                                                            *
!******************************************************************************

  USE MSFLIB
  USE CHAOSCOM
  USE INPUTINFO

  IMPLICIT NONE

  NAMELIST /CHAOSINPUT/ NUMXPIXELS, NUMYPIXELS, NUMCOLORS, A, B, C, D, &
                        X1_INP, Y1_INP, IWASTE, IMINMAX, IIMAGE,       &
						LROTAT, ROTMAG, SCALMM, IDIV, ICHAOS

  CHARACTER(LEN=60)MSG0, MSG1
  INTEGER(KIND=4)IRET, IERR

!* OPEN INPUT FILE
  OPEN(UNIT = 100, FILE = CHAOS_SAV, STATUS = 'NEW', IOSTAT = IERR)
  IF(IERR .NE. 0)THEN
    MSG0 = ' THE FILE ALREADY EXISTS. DO YOU WANT TO OVERWRITE IT?'C
	MSG1 = ' ERROR OPENING FILE 'C
	IRET = MESSAGEBOXQQ(MSG0, MSG1, MB$ICONEXCLAMATION .OR. MB$YESNOCANCEL)
	IF(IRET == MB$IDYES)THEN
      OPEN(UNIT = 100, FILE = CHAOS_SAV, STATUS = 'OLD', IOSTAT = IERR)
	  REWIND(100)
    ELSE
      RETURN
	ENDIF
  ENDIF
!* 
!* READ IN INFOPRMATION
!*

  WRITE(100,CHAOSINPUT, IOSTAT = IERR)
  IF(IERR .NE. 0)THEN
    MSG0 = ' ERROR WRITING OUTPUT FILE '//CHAOS_SAV//' 'C
	MSG1 = ' ERROR WRITING FILE 'C
	IRET = MESSAGEBOXQQ(MSG0, MSG1, MB$ICONEXCLAMATION .OR. MB$OK)
	RETURN
  ENDIF

  CLOSE(UNIT=100)

  RETURN
END
