SUBROUTINE ROTATE(CHECKED)
!**************************************************************************
!*
!*  THIS SUBROUTINE CREATES A DIALOG BOX THAT ALLOWS THE USER TO INPUT A
!*  ROTATION PARAMETER TO CREATE A MORE INTERESTING IMAGE.  IT ALSO SETS
!*  THE CALLBACK ROUTINES FOR THE HELP AND OK BUTTONS.  IT ALSO SETS UP
!*  CALLBACK ROUTINES TO CONVERT THE INFORMATION FROM DEGREES TO RADIANS OR 
!*  VISA-VERSUA DEPENDING ON WHICH RADIO BUTTON IS SELECTED
!*
!**************************************************************************

  USE MSFLIB
  USE DIALOGM
  USE CHAOSCOM

  IMPLICIT NONE
  INCLUDE 'RESOURCE.FD'

  TYPE(DIALOG)DLG

  LOGICAL(KIND=4)RET, RETLOG, LRAD, LDEG
  INTEGER(KIND=4)IRET, IERR
  CHARACTER(LEN=55) MSG0, MSG1, CTEMP
  EXTERNAL ROTATE_HELP, ROTATE_OK, ROTATE_DEG, ROTATE_RAD
  LOGICAL(KIND=4)CHECKED

  CALL UNUSEDQQ(CHECKED)
  IERR = 0
  MSG0 = ''C
  MSG1 = ''C

!* INITIALIZE THE DIALOG BOX
  RET = DLGINIT(IDD_ROTATE, DLG)
!* CALL BACK ROUTINES FOR HELP AND OK, AND RADIAN AND DEGREES BUTTONS

  RET = DLGSETSUB(DLG, IDHELP_ROTATE, ROTATE_HELP)
  RET = DLGSETSUB(DLG, IDOK, ROTATE_OK)
  RET = DLGSETSUB(DLG, IDC_RADIO_ROTATE_DEG, ROTATE_DEG)
  RET = DLGSETSUB(DLG, IDC_RADIO_ROTATE_RAD, ROTATE_RAD)
!* SEE WHAT RADIO BUTTON IS PRESSED
  RET = DLGGET(DLG, IDC_RADIO_ROTATE_DEG, LDEG)
  RET = DLGGET(DLG, IDC_RADIO_ROTATE_RAD, LRAD)
!* INITIALIZE ALL CHECKBOXES AND RADI BUTTONS
  RETLOG = DLGSET(DLG, IDC_CHECK_ROTATE, LROTAT)
  RETLOG = DLGSET(DLG, IDC_RADIO_ROTATE_DEG, LDEG)
  RETLOG = DLGSET(DLG, IDC_RADIO_ROTATE_RAD, LRAD)
  LDEG = .TRUE.

!* GET THE CURRENT VALUES  AND PUT IT IN THE 
!* EDIT FIELD
  IF(LDEG)THEN
    WRITE(CTEMP,*)ROTMAG*57.2957795131E+00
  ELSE IF(LRAD)THEN
    WRITE(CTEMP,*)ROTMAG
  ENDIF
  RETLOG = DLGSET(DLG, IDC_EDIT_ROTATE_ANG, CTEMP)

!* BRING UP THE DIALOG BOX

  IRET = DLGMODAL(DLG)

!* DESTROY AND RELEASE THE DIALOG RESOURCES

  CALL DLGUNINIT(DLG)

  RETURN
END SUBROUTINE ROTATE
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
SUBROUTINE ROTATE_HELP(DLGPARENT, ID, CALLBACKTYPE)
!***********************************************************************************
!*
!* THIS CALLBACK ROUTINE BRINGS UP A HELP DIALOG WHEN THE HELP BUTTON IS PRESED IN 
!* THE ROTATE IMAGE DIALOG BOX
!*
!***********************************************************************************
  USE MSFLIB
  USE DIALOGM

  IMPLICIT NONE

  INCLUDE 'RESOURCE.FD'

  TYPE(DIALOG)DLG2
  TYPE(DIALOG)DLGPARENT

  LOGICAL(KIND=4)RET
  INTEGER(KIND=4)IRET, ID, CALLBACKTYPE
  
  CALL UNUSEDQQ(DLGPARENT, ID, CALLBACKTYPE)



!* INITIALIZE THE DIALOG BOX
  RET = DLGINIT(IDD_ROTATE_HELP, DLG2)

  IRET = DLGMODAL(DLG2)

  CALL DLGUNINIT(DLG2)
  
  RETURN
END SUBROUTINE ROTATE_HELP
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
SUBROUTINE ROTATE_OK(DLG, ID, CALLBACKTYPE)
!***********************************************************************************
!*
!* THIS CALLBACK ROUTINE IS EXECUTED EHRN THE OK BUTTON IS PRESED IN 
!* THE ROTATE IMAGE DIALOG BOX.  THERE IS LOGIC TO SEE IF THE DEGREE OR RADIAN RADIO 
!* BUTTON HAS BEEN PRESSED.  IF THE DEGREES RADIO BUTTON HAS BEEN PRESSED, ALL INPUT 
!* IS CONVERETED TO RADIANS AND SAVED.  THERE IS ALSO ERROR DECTECTION LOGIC IF AN 
!* INVALID ENTRY IS MADE IN THE EDIT BOX.  iF AN ERROR OCCURS, A MESSAGE IS DISPLAYED
!* AND THE ORIGINAL VALU IS RESTORED
!*
!***********************************************************************************
  USE MSFLIB
  USE DIALOGM
  USE CHAOSCOM

  IMPLICIT NONE

  INCLUDE 'RESOURCE.FD'
  TYPE(DIALOG)DLG

  LOGICAL(KIND=4)RET, LERR, LRAD, LDEG
  INTEGER(KIND=4)IRET, ID, CALLBACKTYPE, IERR
  CHARACTER(LEN=55) CTEMP, MSG0, MSG1


  CALL UNUSEDQQ(ID, CALLBACKTYPE)
  LERR = .FALSE.
!* GET THE NEW INFORMATION
  RET = DLGGET(DLG, IDC_CHECK_ROTATE, LROTAT)
  IF(LROTAT)THEN
!* GET THE DEGREES AND RADIANS FLAGS
    RET = DLGGET(DLG, IDC_RADIO_ROTATE_DEG, LDEG)
    RET = DLGGET(DLG, IDC_RADIO_ROTATE_RAD, LRAD)
    IF(LDEG)THEN
      RET = DLGGET(DLG, IDC_EDIT_ROTATE_ANG, CTEMP)
	  READ(CTEMP,*,IOSTAT = IERR)ROTMAG
      IF(IERR /= 0)THEN
!* ERROR CONDITION, PRINT MESSAGE, DESTRO BOX AND RECREATE
        MSG0 = 'ERROR READING INFORMATION IN EDIT FIELD'C
	    MSG1 = 'ERROR READING INFORMATION' C
        IRET = MESSAGEBOXQQ(MSG0, MSG1,MB$ICONEXCLAMATION .OR. MB$OK)
		LERR = .TRUE.
        WRITE(CTEMP,*)ROTMAG*57.2957795131E+00
        RET = DLGSET(DLG, IDC_EDIT_ROTATE_ANG, CTEMP)
	  ELSE
	    ROTMAG = ROTMAG/57.2957795131E+00
	  ENDIF
	ELSE IF(LRAD) THEN
      RET = DLGGET(DLG, IDC_EDIT_ROTATE_ANG, CTEMP)
	  READ(CTEMP,*,IOSTAT = IERR)ROTMAG
	  IF(IERR /= 0)THEN
!* ERROR CONDITION, PRINT MESSAGE, DESTRO BOX AND RECREATE
        MSG0 = 'ERROR READING INFORMATION IN EDIT FIELD'C
	    MSG1 = 'ERROR READING INFORMATION'C
        IRET = MESSAGEBOXQQ(MSG0, MSG1,MB$ICONEXCLAMATION .OR. MB$OK)
		LERR = .TRUE.
	    ROTMAG = ROTMAG
        WRITE(CTEMP,*)ROTMAG
        RET = DLGSET(DLG, IDC_EDIT_ROTATE_ANG, CTEMP)
	  ENDIF
    ELSE
	  MSG0 = ' NONE OF THE RADIO BUTTONS WERE PUSHED, PLEASE TRY AGAIN'C	  
	  MSG1 = ' ROTATE ANGLE'C
	  IRET = MESSAGEBOXQQ(' NONE OF THE RADIO BUTTONS WERE PUSHED, PLEASE TRY AGAIN'C , &
	                      ' ROTATE ANGLE'C,MB$ICONEXCLAMATION .OR. MB$OK)
	  LERR = .TRUE.
    ENDIF
  ENDIF


  IF(.NOT. LERR)THEN
	CALL DLGSETRETURN(DLG, IDOK)
    CALL DLGEXIT(DLG)
  ENDIF
  RETURN
END SUBROUTINE ROTATE_OK
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
SUBROUTINE ROTATE_DEG(DLG, ID, CALLBACKTYPE)
!***********************************************************************************
!*
!* THIS CALLBACK ROUTINE IS EXECUTED WHRN THE DEGREES RADIO  BUTTON IS PRESSED IN 
!* THE ROTATE IMAGE DIALOG BOX.  IF THE RADIO BUTTON HAS BEEN PUSHED, ALL INFORMATION
!* IS CONVERTED TO DEGREES
!*
!***********************************************************************************
  USE MSFLIB
  USE DIALOGM
  USE CHAOSCOM

  IMPLICIT NONE

  INCLUDE 'RESOURCE.FD'
  TYPE(DIALOG)DLG

  LOGICAL(KIND=4)RET, LERR
  INTEGER(KIND=4)ID, CALLBACKTYPE
  CHARACTER(LEN=55) CTEMP

  CALL UNUSEDQQ(ID, CALLBACKTYPE)
  LERR = .FALSE.

  WRITE(CTEMP,*)ROTMAG*57.2957795131E+00
  RET = DLGSET(DLG, IDC_EDIT_ROTATE_ANG, CTEMP)

  RETURN
END SUBROUTINE ROTATE_DEG
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
SUBROUTINE ROTATE_RAD(DLG, ID, CALLBACKTYPE)
!***********************************************************************************
!*
!* THIS CALLBACK ROUTINE IS EXECUTED WHRN THE RADIANS RADIO  BUTTON IS PRESSED IN 
!* THE ROTATE IMAGE DIALOG BOX.  IF THE RADIO BUTTON HAS BEEN PUSHED, ALL INFORMATION
!* IS CONVERTED TO RADIANS
!*
!***********************************************************************************
  USE MSFLIB
  USE DIALOGM
  USE CHAOSCOM

  IMPLICIT NONE

  INCLUDE 'RESOURCE.FD'
  TYPE(DIALOG)DLG

  LOGICAL(KIND=4)RET, LERR
  INTEGER(KIND=4)ID, CALLBACKTYPE
  CHARACTER(LEN=55) CTEMP

  CALL UNUSEDQQ(ID, CALLBACKTYPE)
  LERR = .FALSE.

  WRITE(CTEMP,*)ROTMAG
  RET = DLGSET(DLG, IDC_EDIT_ROTATE_ANG, CTEMP)
  
  RETURN
END SUBROUTINE ROTATE_RAD
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

