SUBROUTINE QUANTCOL(CHECKED)
!**************************************************************************
!*
!*  THIS SUBROUTINE CREATES A DIALOG BOX THAT ALLOWS THE USER TO INPUT THE
!*   THE QUANTCOL
!*
!**************************************************************************

  USE MSFLIB
  USE DIALOGM
  USE CHAOSCOM

  IMPLICIT NONE

  INCLUDE 'RESOURCE.FD'

  TYPE(DIALOG)DLG

  LOGICAL(KIND=4)RET, RETLOG
  INTEGER(KIND=4)IRET, IERR
  CHARACTER(LEN=55) CTEMP, MSG0, MSG1
  EXTERNAL QUANTCOL_HELP, QUANTCOL_OK
  LOGICAL(KIND=4)CHECKED

  CALL UNUSEDQQ(CHECKED)

  IERR = 0
  MSG0 = ''C
  MSG1 = ''C

!* INITIALIZE THE DIALOG BOX
  RET = DLGINIT(IDD_QUANTCOL, DLG)
!* SET UP OK AND HELP BUTTON CALLBACKS
  RET = DLGSETSUB(DLG, IDHELP_QUANTCOL, QUANTCOL_HELP)
  RET = DLGSETSUB(DLG, IDOK, QUANTCOL_OK)

!* GET THE CURRENT VALUES OF THE NUMBER OF POINTS AND PUT IT IN THE 
!* EDIT FIELD
  WRITE(CTEMP,*)IDIV
  RETLOG = DLGSET(DLG, IDC_EDIT_QUANTCOL, CTEMP)

!* BRING UP THE DIALOG BOX
  IRET = DLGMODAL(DLG)

!* DESTROY AND RELEASE THE DIALOG RESOURCES
  CALL DLGUNINIT(DLG)

  RETURN
END SUBROUTINE QUANTCOL
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!**************************************************************************
!*
!*  tHIS SUBROUTINE CREATES A DIALOG BOX THAT DISPLAYS HELP FOR COLOR STEPPING
!*
!**************************************************************************
SUBROUTINE QUANTCOL_HELP(DLGPARENT, ID, CALLBACKTYPE)
  USE MSFLIB
  USE DIALOGM

  IMPLICIT NONE

  INCLUDE 'RESOURCE.FD'

  TYPE(DIALOG)DLG2
  TYPE(DIALOG)DLGPARENT

  LOGICAL(KIND=4)RET
  INTEGER(KIND=4)IRET, ID, CALLBACKTYPE
  
  CALL UNUSEDQQ(DLGPARENT, ID, CALLBACKTYPE)

!* INITIALIZE THE DIALOG BOX
  RET = DLGINIT(IDD_QUANTCOL_HELP, DLG2)

  IRET = DLGMODAL(DLG2)

  CALL DLGUNINIT(DLG2)

  RETURN
  END SUBROUTINE QUANTCOL_HELP
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
SUBROUTINE QUANTCOL_OK(DLG, ID, CALLBACKTYPE)
!**************************************************************************
!*
!*  THIS SUBROUTINE IS CALLED WHEN THE OK BUTTON IS PRESED IN THE COLOR STEPPING
!*  DIALOG BOX
!*
!**************************************************************************
  USE MSFLIB
  USE DIALOGM
  USE CHAOSCOM

  IMPLICIT NONE

  INCLUDE 'RESOURCE.FD'
  TYPE(DIALOG)DLG

  LOGICAL(KIND=4)RET, LERR
  INTEGER(KIND=4)IRET, ID, CALLBACKTYPE, IERR
  CHARACTER(LEN=55) CTEMP, MSG0, MSG1

  CALL UNUSEDQQ(ID, CALLBACKTYPE)
  LERR = .FALSE.

!* GET THE NEW INFORMATION
  RET = DLGGET(DLG, IDC_EDIT_QUANTCOL, CTEMP)
  READ(CTEMP,*,IOSTAT = IERR)IDIV
  IF(IERR /= 0)THEN
!* ERROR CONDITION, PRINT MESSAGE, RESTORE VALUE
    MSG0 = 'ERROR READING INFORMATION IN EDIT FIELD'C
    MSG1 = 'ERROR READING INFORMATION'C
    IRET = MESSAGEBOXQQ(MSG0, MSG1,MB$ICONEXCLAMATION .OR. MB$OK)
    WRITE(CTEMP,*)IDIV
    RET = DLGSET(DLG, IDC_EDIT_QUANTCOL, CTEMP)
	LERR = .TRUE.
  ENDIF
!* SET THE RETURN VALUE TO THE OK ID AND EXIT DIALOG
  IF(.NOT. LERR)THEN
	CALL DLGSETRETURN(DLG, IDOK)
    CALL DLGEXIT(DLG)
  ENDIF
  RETURN
END SUBROUTINE QUANTCOL_OK
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!


