SUBROUTINE PALLET_PARMS(CHECKED)
!******************************************************************************
!*                                                                            *
!*  THIS SUBROUTINE CREATES A DIALOG BOX THAT ALLOWS THE USER TO INPUT        *
!*  USER DEFINED PARAMETERS FOR PALETTE GENERATION                            *
!*                                                                            *
!******************************************************************************

  USE MSFLIB
  USE DIALOGM
  USE PALET
  IMPLICIT NONE

  INCLUDE 'RESOURCE.FD'

  TYPE(DIALOG)DLG

  LOGICAL(KIND=4)RET, RETLOG
  INTEGER(KIND=4)IRET, IERR
  CHARACTER(LEN=55)CTEMP
  EXTERNAL PALLET_PARMS_HELP, PALLET_PARMS_OK, PALLET_PARMS_DEG, PALLET_PARMS_RAD
  LOGICAL(KIND=4)CHECKED

  CALL UNUSEDQQ(CHECKED)


  LCHG = .FALSE.
  IERR = 0

!* INITIALIZE THE DIALOG BOX
  RET = DLGINIT(IDD_PALLET_PARAMS2, DLG)
!* SET UP CALL BACK ROUTINES FOR THE BUTTONS
  RET = DLGSETSUB(DLG, IDHELP_PALLET_PARAMS2,PALLET_PARMS_HELP)
  RET = DLGSETSUB(DLG, IDOK, PALLET_PARMS_OK)
  RET = DLGSETSUB(DLG, IDC_RADIO_PALLET_DEG2, PALLET_PARMS_DEG)
  RET = DLGSETSUB(DLG, IDC_RADIO_PALLET_RAD2, PALLET_PARMS_RAD)

!* INITIALIZE ALL CHECKBOXES AND RADIO BUTTONS
  RETLOG = DLGSET(DLG, IDC_RADIO_PALLET_DEG2, .TRUE.)
  RETLOG = DLGSET(DLG, IDC_RADIO_PALLET_RAD2, .FALSE.)
  RETLOG = DLGSET(DLG, IDC_CHECK_NORMAL_RED2, LNRED)
  RETLOG = DLGSET(DLG, IDC_CHECK_NORMAL_BLUE2, LNBLUE)
  RETLOG = DLGSET(DLG, IDC_CHECK_NORMAL_GREEN2, LNGREEN)

!* GET THE CURRENT VALUES  AND PUT IT IN THE 
!* EDIT FIELD
  WRITE(CTEMP,*)REDSTART*57.2957795131E+00
  RETLOG = DLGSET(DLG, IDC_EDIT_RED_START2, CTEMP)
  WRITE(CTEMP,*)REDEND*57.2957795131E+00
  RETLOG = DLGSET(DLG, IDC_EDIT_RED_END2, CTEMP)
  WRITE(CTEMP,*)RPHS*57.2957795131E+00
  RETLOG = DLGSET(DLG, IDC_EDIT_RED_PHASE2, CTEMP)
  WRITE(CTEMP,*)RMAX
  RETLOG = DLGSET(DLG, IDC_EDIT_RED_INTNS2, CTEMP)
  WRITE(CTEMP,*)IRDELAY
  RETLOG = DLGSET(DLG, IDC_EDIT_RED_DELAY2, CTEMP)
  WRITE(CTEMP,*)GREENSTART*57.2957795131E+00
  RETLOG = DLGSET(DLG, IDC_EDIT_GREEN_START2, CTEMP)
  WRITE(CTEMP,*)GREENEND*57.2957795131E+00
  RETLOG = DLGSET(DLG, IDC_EDIT_GREEN_END2, CTEMP)
  WRITE(CTEMP,*)GPHS*57.2957795131E+00
  RETLOG = DLGSET(DLG, IDC_EDIT_GREEN_PHASE2, CTEMP)
  WRITE(CTEMP,*)GMAX
  RETLOG = DLGSET(DLG, IDC_EDIT_GREEN_INTNS2, CTEMP)
  WRITE(CTEMP,*)IGDELAY
  RETLOG = DLGSET(DLG, IDC_EDIT_GREEN_DELAY2, CTEMP)
  WRITE(CTEMP,*)BLUESTART*57.2957795131E+00
  RETLOG = DLGSET(DLG, IDC_EDIT_BLUE_START2, CTEMP)
  WRITE(CTEMP,*)BLUEEND*57.2957795131E+00
  RETLOG = DLGSET(DLG, IDC_EDIT_BLUE_END2, CTEMP)
  WRITE(CTEMP,*)BPHS*57.2957795131E+00
  RETLOG = DLGSET(DLG, IDC_EDIT_BLUE_PHASE2, CTEMP)
  WRITE(CTEMP,*)BMAX
  RETLOG = DLGSET(DLG, IDC_EDIT_BLUE_INTNS2, CTEMP)
  WRITE(CTEMP,*)IBDELAY
  RETLOG = DLGSET(DLG, IDC_EDIT_BLUE_DELAY2, CTEMP)

!* BRING UP THE DIALOG BOX
  IRET = DLGMODAL(DLG)

!* DESTROY AND RELEASE THE DIALOG RESOURCES
  CALL DLGUNINIT(DLG)
  
  IF(LCHG)THEN
    CALL PALLET
	CALL CREATE_PALLET
  ENDIF

  RETURN
END SUBROUTINE PALLET_PARMS
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
SUBROUTINE PALLET_PARMS_HELP(DLGPARENT, ID, CALLBACKTYPE)
!**********************************************************************************
!*
!*  THIS SUBROUTINE IS THE CALLBACK ROUTINE THAT IS CVALLED WHEN THE HELP BUTTON 
!*  IS PUSHED.  IT CREATES A DIALOG THAT GICS HELP FOR THE PALETTE PARAMETER DIALOG
!*  BOX
!*
!**********************************************************************************

  USE MSFLIB
  USE DIALOGM

  IMPLICIT NONE

  INCLUDE 'RESOURCE.FD'

  TYPE(DIALOG)DLG2
  TYPE(DIALOG)DLGPARENT

  LOGICAL(KIND=4)RET
  INTEGER(KIND=4)IRET, ID, CALLBACKTYPE

  CALL UNUSEDQQ(DLGPARENT, ID, CALLBACKTYPE)

!* INITIALIZE THE DIALOG BOX
  RET = DLGINIT(IDD_PALLET_PARAMS_HELP, DLG2)

  IRET = DLGMODAL(DLG2)

  CALL DLGUNINIT(DLG2)

  RETURN
  END SUBROUTINE PALLET_PARMS_HELP
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
SUBROUTINE PALLET_PARMS_OK(DLG, ID, CALLBACKTYPE)
!**********************************************************************************
!*
!*  THIS SUBROUTINE IS THE CALLBACK ROUTINE THAT IS CALLED WHEN THE OK BUTTON 
!*  IS PUSHED.  IT SETS THE INPUT THAT HAS BEEN ENTERED INTO THE EDIT BOXES OF THE 
!*  DIALOG.  THERE IS ERROR DECETTION AND CONVERSION DETECTION FOR DEGREES AND RADIANS
!*
!**********************************************************************************
  USE MSFLIB
  USE DIALOGM
  USE PALET

  IMPLICIT NONE

  INCLUDE 'RESOURCE.FD'
  TYPE(DIALOG)DLG

  LOGICAL(KIND=4)RETLOG, LRAD, LDEG, LNREDP, LNGREENP, LNBLUEP, LERR
  INTEGER(KIND=4)IRET, IRDELAYP, IGDELAYP, IBDELAYP, IERR
  INTEGER(KIND=4)ID, CALLBACKTYPE, ID_LOCAL, LOCAL_CALLBACKTYPE
  CHARACTER(LEN=55) MSG0, MSG1, CTEMP
  REAL(KIND = 4) RPHSP, RMAXP, GPHSP, GMAXP, BPHSP, BMAXP,   &
                 REDSTARTP, REDENDP, GREENSTARTP, GREENENDP, BLUESTARTP, BLUEENDP

  ID_LOCAL = ID
  LOCAL_CALLBACKTYPE = CALLBACKTYPE
  LERR = .FALSE.

!* GET THE NEW INFORMATION
  LCHG = .TRUE.

	
  REDSTARTP = REDSTART
  REDENDP = REDEND
  GREENSTARTP = GREENSTART
  GREENENDP = GREENEND
  BLUESTARTP = BLUESTART
  BLUEENDP = BLUEEND
  RPHSP = RPHS
  GPHSP = GPHS
  BPHSP = BPHS
  RMAXP = RMAX
  GMAXP = GMAX
  BMAXP = BMAX
  IRDELAYP = IRDELAY
  IGDELAYP = IGDELAY
  IBDELAYP = IBDELAY
  LNREDP = LNRED
  LNBLUEP = LNBLUE
  LNGREENP = LNGREEN
!* GET THE DEGREES AND RADIANS FLAGS
  RETLOG = DLGGET(DLG, IDC_RADIO_PALLET_DEG2, LDEG)
  RETLOG = DLGGET(DLG, IDC_RADIO_PALLET_RAD2, LRAD)
  RETLOG = DLGGET(DLG, IDC_CHECK_NORMAL_RED2, LNRED)
  RETLOG = DLGGET(DLG, IDC_CHECK_NORMAL_GREEN2, LNGREEN)
  RETLOG = DLGGET(DLG, IDC_CHECK_NORMAL_BLUE2, LNBLUE)

  IF(LDEG)THEN
    RETLOG = DLGGET(DLG, IDC_EDIT_RED_START2, CTEMP)
    READ(CTEMP,*,IOSTAT = IERR)REDSTART
    IF(IERR /= 0)THEN
!* ERROR CONDITION, PRINT MESSAGE, DESTRO BOX AND RECREATE
      MSG0 = 'ERROR READING INFORMATION IN EDIT FIELD RED START'C
      MSG1 = 'ERROR READING INFORMATION'C
      IRET = MESSAGEBOXQQ(MSG0, MSG1,MB$ICONEXCLAMATION .OR. MB$OK)
      LCHG = .FALSE.
	  LERR = .TRUE.
      WRITE(CTEMP,*)REDSTART*57.2957795131E+00
      RETLOG = DLGSET(DLG, IDC_EDIT_RED_START2, CTEMP)
    ELSE
	  REDSTART=REDSTART/57.2957795131E+00
	ENDIF

    RETLOG = DLGGET(DLG, IDC_EDIT_RED_END2, CTEMP)
    READ(CTEMP,*,IOSTAT = IERR)REDEND
    IF(IERR /= 0)THEN
!* ERROR CONDITION, PRINT MESSAGE, DESTRO BOX AND RECREATE
      MSG0 = 'ERROR READING INFORMATION IN EDIT FIELD RED END'C
	  MSG1 = 'ERROR READING INFORMATION'C
      IRET = MESSAGEBOXQQ(MSG0, MSG1,MB$ICONEXCLAMATION .OR. MB$OK)
	  LCHG = .FALSE.
      WRITE(CTEMP,*)REDEND*57.2957795131E+00
      RETLOG = DLGSET(DLG, IDC_EDIT_RED_END2, CTEMP)
	  LERR = .TRUE.
    ELSE
      REDEND=REDEND/57.2957795131E+00
	ENDIF

    RETLOG = DLGGET(DLG, IDC_EDIT_RED_PHASE2, CTEMP)
    READ(CTEMP,*,IOSTAT = IERR)RPHS
    IF(IERR /= 0)THEN
!* ERROR CONDITION, PRINT MESSAGE, DESTRO BOX AND RECREATE
      MSG0 = 'ERROR READING INFORMATION IN EDIT FIELD RED PHASE'C
	  MSG1 = 'ERROR READING INFORMATION'C
      IRET = MESSAGEBOXQQ(MSG0, MSG1,MB$ICONEXCLAMATION .OR. MB$OK)
	  LCHG = .FALSE.
      WRITE(CTEMP,*)RPHS*57.2957795131E+00
      RETLOG = DLGSET(DLG, IDC_EDIT_RED_PHASE2, CTEMP)
	  LERR = .TRUE.
    ELSE
      RPHS = RPHS/57.2957795131E+00
	ENDIF

    RETLOG = DLGGET(DLG, IDC_EDIT_RED_INTNS2, CTEMP)
    READ(CTEMP,*,IOSTAT = IERR)RMAX
    IF(IERR /= 0)THEN
!* ERROR CONDITION, PRINT MESSAGE, DESTRO BOX AND RECREATE
      MSG0 = 'ERROR READING INFORMATION IN EDIT FIELD RED MAX'C
	  MSG1 = 'ERROR READING INFORMATION'C
      IRET = MESSAGEBOXQQ(MSG0, MSG1,MB$ICONEXCLAMATION .OR. MB$OK)
	  LCHG = .FALSE.
      WRITE(CTEMP,*)RMAX
      RETLOG = DLGSET(DLG, IDC_EDIT_RED_INTNS2, CTEMP)
	  LERR = .TRUE.
	ENDIF

    RETLOG = DLGGET(DLG, IDC_EDIT_RED_DELAY2, CTEMP)
    READ(CTEMP,*,IOSTAT = IERR)IRDELAY
    IF(IERR /= 0)THEN
!* ERROR CONDITION, PRINT MESSAGE, DESTRO BOX AND RECREATE
      MSG0 = 'ERROR READING INFORMATION IN EDIT FIELD RED DELAY'C
	  MSG1 = 'ERROR READING INFORMATION'C
      IRET = MESSAGEBOXQQ(MSG0, MSG1,MB$ICONEXCLAMATION .OR. MB$OK)
	  LCHG = .FALSE.
      WRITE(CTEMP,*)RMAX
      WRITE(CTEMP,*)IRDELAY
      RETLOG = DLGSET(DLG, IDC_EDIT_RED_DELAY2, CTEMP)
	  LERR = .TRUE.
	ENDIF


    RETLOG = DLGGET(DLG, IDC_EDIT_BLUE_START2, CTEMP)
    READ(CTEMP,*,IOSTAT = IERR)BLUESTART
    IF(IERR /= 0)THEN
!* ERROR CONDITION, PRINT MESSAGE, DESTRO BOX AND RECREATE
      MSG0 = 'ERROR READING INFORMATION IN EDIT FIELD BLUE START'C
	  MSG1 = 'ERROR READING INFORMATION'C
      IRET = MESSAGEBOXQQ(MSG0, MSG1,MB$ICONEXCLAMATION .OR. MB$OK)
	  LCHG = .FALSE.
      WRITE(CTEMP,*)BLUESTART*57.2957795131E+00
      RETLOG = DLGSET(DLG, IDC_EDIT_BLUE_START2, CTEMP)
	  LERR = .TRUE.
    ELSE
      BLUESTART=BLUESTART/57.2957795131E+00
	ENDIF

    RETLOG = DLGGET(DLG, IDC_EDIT_BLUE_END2, CTEMP)
    READ(CTEMP,*,IOSTAT = IERR)BLUEEND
    IF(IERR /= 0)THEN
!* ERROR CONDITION, PRINT MESSAGE, DESTRO BOX AND RECREATE
      MSG0 = 'ERROR READING INFORMATION IN EDIT FIELD BLUE END'C
	  MSG1 = 'ERROR READING INFORMATION'C
      IRET = MESSAGEBOXQQ(MSG0, MSG1,MB$ICONEXCLAMATION .OR. MB$OK)
	  LCHG = .FALSE.
      WRITE(CTEMP,*)BLUEEND*57.2957795131E+00
      RETLOG = DLGSET(DLG, IDC_EDIT_BLUE_END2, CTEMP)
	  LERR = .TRUE.
    ELSE
      BLUEEND=BLUEEND/57.2957795131E+00
	ENDIF

    RETLOG = DLGGET(DLG, IDC_EDIT_BLUE_PHASE2, CTEMP)
    READ(CTEMP,*,IOSTAT = IERR)BPHS
    IF(IERR /= 0)THEN
!* ERROR CONDITION, PRINT MESSAGE, DESTRO BOX AND RECREATE
      MSG0 = 'ERROR READING INFORMATION IN EDIT FIELD BLUE PHASE'C
	  MSG1 = 'ERROR READING INFORMATION'C
      IRET = MESSAGEBOXQQ(MSG0, MSG1,MB$ICONEXCLAMATION .OR. MB$OK)
	  LCHG = .FALSE.
      WRITE(CTEMP,*)BPHS*57.2957795131E+00
      RETLOG = DLGSET(DLG, IDC_EDIT_BLUE_PHASE2, CTEMP)
	  LERR = .TRUE.
    ELSE
      BPHS = BPHS/57.2957795131E+00
	ENDIF

    RETLOG = DLGGET(DLG, IDC_EDIT_BLUE_INTNS2, CTEMP)
    READ(CTEMP,*,IOSTAT = IERR)BMAX
    IF(IERR /= 0)THEN
!* ERROR CONDITION, PRINT MESSAGE, DESTRO BOX AND RECREATE
      MSG0 = 'ERROR READING INFORMATION IN EDIT FIELD BLUE MAX'C
	  MSG1 = 'ERROR READING INFORMATION'C
      IRET = MESSAGEBOXQQ(MSG0, MSG1,MB$ICONEXCLAMATION .OR. MB$OK)
	  LCHG = .FALSE.
      WRITE(CTEMP,*)BMAX
      RETLOG = DLGSET(DLG, IDC_EDIT_BLUE_INTNS2, CTEMP)
	  LERR = .TRUE.
	ENDIF

    RETLOG = DLGGET(DLG, IDC_EDIT_BLUE_DELAY2, CTEMP)
    READ(CTEMP,*,IOSTAT = IERR)IBDELAY
    IF(IERR /= 0)THEN
!* ERROR CONDITION, PRINT MESSAGE, DESTRO BOX AND RECREATE
      MSG0 = 'ERROR READING INFORMATION IN EDIT FIELD BLUE DELAY'C
	  MSG1 = 'ERROR READING INFORMATION'C
      IRET = MESSAGEBOXQQ(MSG0, MSG1,MB$ICONEXCLAMATION .OR. MB$OK)
	  LCHG = .FALSE.
      WRITE(CTEMP,*)IBDELAY
      RETLOG = DLGSET(DLG, IDC_EDIT_BLUE_DELAY2, CTEMP)
	  LERR = .TRUE.
	ENDIF


    RETLOG = DLGGET(DLG, IDC_EDIT_GREEN_START2, CTEMP)
    READ(CTEMP,*,IOSTAT = IERR)GREENSTART
    IF(IERR /= 0)THEN
!* ERROR CONDITION, PRINT MESSAGE, DESTRO BOX AND RECREATE
      MSG0 = 'ERROR READING INFORMATION IN EDIT FIELD GREEN START'C
	  MSG1 = 'ERROR READING INFORMATION'C
      IRET = MESSAGEBOXQQ(MSG0, MSG1,MB$ICONEXCLAMATION .OR. MB$OK)
	  LCHG = .FALSE.
      WRITE(CTEMP,*)GREENSTART*57.2957795131E+00
      RETLOG = DLGSET(DLG, IDC_EDIT_GREEN_START2, CTEMP)
	  LERR = .TRUE.
    ELSE
      GREENSTART=GREENSTART/57.2957795131E+00
	ENDIF

    RETLOG = DLGGET(DLG, IDC_EDIT_GREEN_END2, CTEMP)
    READ(CTEMP,*,IOSTAT = IERR)GREENEND
    IF(IERR /= 0)THEN
!* ERROR CONDITION, PRINT MESSAGE, DESTRO BOX AND RECREATE
      MSG0 = 'ERROR READING INFORMATION IN EDIT FIELD GREEN END'C
	  MSG1 = 'ERROR READING INFORMATION'C
      IRET = MESSAGEBOXQQ(MSG0, MSG1,MB$ICONEXCLAMATION .OR. MB$OK)
	  LCHG = .FALSE.
      WRITE(CTEMP,*)GREENEND*57.2957795131E+00
      RETLOG = DLGSET(DLG, IDC_EDIT_GREEN_END2, CTEMP)
	  LERR = .TRUE.
    ELSE
      GREENEND=GREENEND/57.2957795131E+00
	ENDIF

    RETLOG = DLGGET(DLG, IDC_EDIT_GREEN_PHASE2, CTEMP)
    READ(CTEMP,*,IOSTAT = IERR)GPHS
    IF(IERR /= 0)THEN
!* ERROR CONDITION, PRINT MESSAGE, DESTRO BOX AND RECREATE
      MSG0 = 'ERROR READING INFORMATION IN EDIT FIELD GREEN PHASE'C
	  MSG1 = 'ERROR READING INFORMATION'C
      IRET = MESSAGEBOXQQ(MSG0, MSG1,MB$ICONEXCLAMATION .OR. MB$OK)
	  LCHG = .FALSE.
      WRITE(CTEMP,*)GPHS*57.2957795131E+00
      RETLOG = DLGSET(DLG, IDC_EDIT_GREEN_PHASE2, CTEMP)
	  LERR = .TRUE.
    ELSE
      GPHS = GPHS/57.2957795131E+00
	ENDIF

    RETLOG = DLGGET(DLG, IDC_EDIT_GREEN_INTNS2, CTEMP)
    READ(CTEMP,*,IOSTAT = IERR)GMAX
    IF(IERR /= 0)THEN
!* ERROR CONDITION, PRINT MESSAGE, DESTRO BOX AND RECREATE
      MSG0 = 'ERROR READING INFORMATION IN EDIT FIELD GREEN MAX'C
	  MSG1 = 'ERROR READING INFORMATION'C
      IRET = MESSAGEBOXQQ(MSG0, MSG1,MB$ICONEXCLAMATION .OR. MB$OK)
	  LCHG = .FALSE.
      WRITE(CTEMP,*)GMAX
      RETLOG = DLGSET(DLG, IDC_EDIT_GREEN_INTNS2, CTEMP)
	  LERR = .TRUE.
	ENDIF

    RETLOG = DLGGET(DLG, IDC_EDIT_GREEN_DELAY2, CTEMP)
    READ(CTEMP,*,IOSTAT = IERR)IGDELAY
    IF(IERR /= 0)THEN
!* ERROR CONDITION, PRINT MESSAGE, DESTRO BOX AND RECREATE
      MSG0 = 'ERROR READING INFORMATION IN EDIT FIELD GREEN DELAY'C
	  MSG1 = 'ERROR READING INFORMATION'C
      IRET = MESSAGEBOXQQ(MSG0, MSG1,MB$ICONEXCLAMATION .OR. MB$OK)
      LCHG = .FALSE.
      WRITE(CTEMP,*)IGDELAY
      RETLOG = DLGSET(DLG, IDC_EDIT_GREEN_DELAY2, CTEMP)
	  LERR = .TRUE.
	ENDIF

  ELSE IF(LRAD) THEN
    RETLOG = DLGGET(DLG, IDC_EDIT_RED_START2, CTEMP)
    READ(CTEMP,*,IOSTAT = IERR)REDSTART
    IF(IERR /= 0)THEN
!* ERROR CONDITION, PRINT MESSAGE, DESTRO BOX AND RECREATE
      MSG0 = 'ERROR READING INFORMATION IN EDIT FIELD RED START'C
      MSG1 = 'ERROR READING INFORMATION'C
      IRET = MESSAGEBOXQQ(MSG0, MSG1,MB$ICONEXCLAMATION .OR. MB$OK)
      LCHG = .FALSE.
	  LERR = .TRUE.
      WRITE(CTEMP,*)REDSTART
      RETLOG = DLGSET(DLG, IDC_EDIT_RED_START2, CTEMP)
    ELSE
	  REDSTART=REDSTART
	ENDIF

    RETLOG = DLGGET(DLG, IDC_EDIT_RED_END2, CTEMP)
    READ(CTEMP,*,IOSTAT = IERR)REDEND
    IF(IERR /= 0)THEN
!* ERROR CONDITION, PRINT MESSAGE, DESTRO BOX AND RECREATE
      MSG0 = 'ERROR READING INFORMATION IN EDIT FIELD RED END'C
	  MSG1 = 'ERROR READING INFORMATION'C
      IRET = MESSAGEBOXQQ(MSG0, MSG1,MB$ICONEXCLAMATION .OR. MB$OK)
	  LCHG = .FALSE.
      WRITE(CTEMP,*)REDEND
      RETLOG = DLGSET(DLG, IDC_EDIT_RED_END2, CTEMP)
	  LERR = .TRUE.
    ELSE
      REDEND=REDEND
	ENDIF

    RETLOG = DLGGET(DLG, IDC_EDIT_RED_PHASE2, CTEMP)
    READ(CTEMP,*,IOSTAT = IERR)RPHS
    IF(IERR /= 0)THEN
!* ERROR CONDITION, PRINT MESSAGE, DESTRO BOX AND RECREATE
      MSG0 = 'ERROR READING INFORMATION IN EDIT FIELD RED PHASE'C
	  MSG1 = 'ERROR READING INFORMATION'C
      IRET = MESSAGEBOXQQ(MSG0, MSG1,MB$ICONEXCLAMATION .OR. MB$OK)
	  LCHG = .FALSE.
      WRITE(CTEMP,*)RPHS
      RETLOG = DLGSET(DLG, IDC_EDIT_RED_PHASE2, CTEMP)
	  LERR = .TRUE.
    ELSE
      RPHS = RPHS
	ENDIF

    RETLOG = DLGGET(DLG, IDC_EDIT_RED_INTNS2, CTEMP)
    READ(CTEMP,*,IOSTAT = IERR)RMAX
    IF(IERR /= 0)THEN
!* ERROR CONDITION, PRINT MESSAGE, DESTRO BOX AND RECREATE
      MSG0 = 'ERROR READING INFORMATION IN EDIT FIELD RED MAX'C
	  MSG1 = 'ERROR READING INFORMATION'C
      IRET = MESSAGEBOXQQ(MSG0, MSG1,MB$ICONEXCLAMATION .OR. MB$OK)
	  LCHG = .FALSE.
      WRITE(CTEMP,*)RMAX
      RETLOG = DLGSET(DLG, IDC_EDIT_RED_INTNS2, CTEMP)
	  LERR = .TRUE.
	ENDIF

    RETLOG = DLGGET(DLG, IDC_EDIT_RED_DELAY2, CTEMP)
    READ(CTEMP,*,IOSTAT = IERR)IRDELAY
    IF(IERR /= 0)THEN
!* ERROR CONDITION, PRINT MESSAGE, DESTRO BOX AND RECREATE
      MSG0 = 'ERROR READING INFORMATION IN EDIT FIELD RED DELAY'C
	  MSG1 = 'ERROR READING INFORMATION'C
      IRET = MESSAGEBOXQQ(MSG0, MSG1,MB$ICONEXCLAMATION .OR. MB$OK)
	  LCHG = .FALSE.
      WRITE(CTEMP,*)RMAX
      WRITE(CTEMP,*)IRDELAY
      RETLOG = DLGSET(DLG, IDC_EDIT_RED_DELAY2, CTEMP)
	  LERR = .TRUE.
	ENDIF


    RETLOG = DLGGET(DLG, IDC_EDIT_BLUE_START2, CTEMP)
    READ(CTEMP,*,IOSTAT = IERR)BLUESTART
    IF(IERR /= 0)THEN
!* ERROR CONDITION, PRINT MESSAGE, DESTRO BOX AND RECREATE
      MSG0 = 'ERROR READING INFORMATION IN EDIT FIELD BLUE START'C
	  MSG1 = 'ERROR READING INFORMATION'C
      IRET = MESSAGEBOXQQ(MSG0, MSG1,MB$ICONEXCLAMATION .OR. MB$OK)
	  LCHG = .FALSE.
      WRITE(CTEMP,*)BLUESTART
      RETLOG = DLGSET(DLG, IDC_EDIT_BLUE_START2, CTEMP)
	  LERR = .TRUE.
    ELSE
      BLUESTART=BLUESTART
	ENDIF

    RETLOG = DLGGET(DLG, IDC_EDIT_BLUE_END2, CTEMP)
    READ(CTEMP,*,IOSTAT = IERR)BLUEEND
    IF(IERR /= 0)THEN
!* ERROR CONDITION, PRINT MESSAGE, DESTRO BOX AND RECREATE
      MSG0 = 'ERROR READING INFORMATION IN EDIT FIELD BLUE END'C
	  MSG1 = 'ERROR READING INFORMATION'C
      IRET = MESSAGEBOXQQ(MSG0, MSG1,MB$ICONEXCLAMATION .OR. MB$OK)
	  LCHG = .FALSE.
      WRITE(CTEMP,*)BLUEEND
      RETLOG = DLGSET(DLG, IDC_EDIT_BLUE_END2, CTEMP)
	  LERR = .TRUE.
    ELSE
      BLUEEND=BLUEEND
	ENDIF

    RETLOG = DLGGET(DLG, IDC_EDIT_BLUE_PHASE2, CTEMP)
    READ(CTEMP,*,IOSTAT = IERR)BPHS
    IF(IERR /= 0)THEN
!* ERROR CONDITION, PRINT MESSAGE, DESTRO BOX AND RECREATE
      MSG0 = 'ERROR READING INFORMATION IN EDIT FIELD BLUE PHASE'C
	  MSG1 = 'ERROR READING INFORMATION'C
      IRET = MESSAGEBOXQQ(MSG0, MSG1,MB$ICONEXCLAMATION .OR. MB$OK)
	  LCHG = .FALSE.
      WRITE(CTEMP,*)BPHS
      RETLOG = DLGSET(DLG, IDC_EDIT_BLUE_PHASE2, CTEMP)
	  LERR = .TRUE.
    ELSE
      BPHS = BPHS
	ENDIF

    RETLOG = DLGGET(DLG, IDC_EDIT_BLUE_INTNS2, CTEMP)
    READ(CTEMP,*,IOSTAT = IERR)BMAX
    IF(IERR /= 0)THEN
!* ERROR CONDITION, PRINT MESSAGE, DESTRO BOX AND RECREATE
      MSG0 = 'ERROR READING INFORMATION IN EDIT FIELD BLUE MAX'C
	  MSG1 = 'ERROR READING INFORMATION'C
      IRET = MESSAGEBOXQQ(MSG0, MSG1,MB$ICONEXCLAMATION .OR. MB$OK)
	  LCHG = .FALSE.
      WRITE(CTEMP,*)BMAX
      RETLOG = DLGSET(DLG, IDC_EDIT_BLUE_INTNS2, CTEMP)
	  LERR = .TRUE.
	ENDIF

    RETLOG = DLGGET(DLG, IDC_EDIT_BLUE_DELAY2, CTEMP)
    READ(CTEMP,*,IOSTAT = IERR)IBDELAY
    IF(IERR /= 0)THEN
!* ERROR CONDITION, PRINT MESSAGE, DESTRO BOX AND RECREATE
      MSG0 = 'ERROR READING INFORMATION IN EDIT FIELD BLUE DELAY'C
	  MSG1 = 'ERROR READING INFORMATION'C
      IRET = MESSAGEBOXQQ(MSG0, MSG1,MB$ICONEXCLAMATION .OR. MB$OK)
	  LCHG = .FALSE.
      WRITE(CTEMP,*)IBDELAY
      RETLOG = DLGSET(DLG, IDC_EDIT_BLUE_DELAY2, CTEMP)
	  LERR = .TRUE.
	ENDIF


    RETLOG = DLGGET(DLG, IDC_EDIT_GREEN_START2, CTEMP)
    READ(CTEMP,*,IOSTAT = IERR)GREENSTART
    IF(IERR /= 0)THEN
!* ERROR CONDITION, PRINT MESSAGE, DESTRO BOX AND RECREATE
      MSG0 = 'ERROR READING INFORMATION IN EDIT FIELD GREEN START'C
	  MSG1 = 'ERROR READING INFORMATION'C
      IRET = MESSAGEBOXQQ(MSG0, MSG1,MB$ICONEXCLAMATION .OR. MB$OK)
	  LCHG = .FALSE.
      WRITE(CTEMP,*)GREENSTART
      RETLOG = DLGSET(DLG, IDC_EDIT_GREEN_START2, CTEMP)
	  LERR = .TRUE.
    ELSE
      GREENSTART=GREENSTART
	ENDIF

    RETLOG = DLGGET(DLG, IDC_EDIT_GREEN_END2, CTEMP)
    READ(CTEMP,*,IOSTAT = IERR)GREENEND
    IF(IERR /= 0)THEN
!* ERROR CONDITION, PRINT MESSAGE, DESTRO BOX AND RECREATE
      MSG0 = 'ERROR READING INFORMATION IN EDIT FIELD GREEN END'C
	  MSG1 = 'ERROR READING INFORMATION'C
      IRET = MESSAGEBOXQQ(MSG0, MSG1,MB$ICONEXCLAMATION .OR. MB$OK)
	  LCHG = .FALSE.
      WRITE(CTEMP,*)GREENEND
      RETLOG = DLGSET(DLG, IDC_EDIT_GREEN_END2, CTEMP)
	  LERR = .TRUE.
    ELSE
      GREENEND=GREENEND
	ENDIF

    RETLOG = DLGGET(DLG, IDC_EDIT_GREEN_PHASE2, CTEMP)
    READ(CTEMP,*,IOSTAT = IERR)GPHS
    IF(IERR /= 0)THEN
!* ERROR CONDITION, PRINT MESSAGE, DESTRO BOX AND RECREATE
      MSG0 = 'ERROR READING INFORMATION IN EDIT FIELD GREEN PHASE'C
	  MSG1 = 'ERROR READING INFORMATION'C
      IRET = MESSAGEBOXQQ(MSG0, MSG1,MB$ICONEXCLAMATION .OR. MB$OK)
	  LCHG = .FALSE.
      WRITE(CTEMP,*)GPHS
      RETLOG = DLGSET(DLG, IDC_EDIT_GREEN_PHASE2, CTEMP)
	  LERR = .TRUE.
    ELSE
      GPHS = GPHS
	ENDIF

    RETLOG = DLGGET(DLG, IDC_EDIT_GREEN_INTNS2, CTEMP)
    READ(CTEMP,*,IOSTAT = IERR)GMAX
    IF(IERR /= 0)THEN
!* ERROR CONDITION, PRINT MESSAGE, DESTRO BOX AND RECREATE
      MSG0 = 'ERROR READING INFORMATION IN EDIT FIELD GREEN MAX'C
	  MSG1 = 'ERROR READING INFORMATION'C
      IRET = MESSAGEBOXQQ(MSG0, MSG1,MB$ICONEXCLAMATION .OR. MB$OK)
	  LCHG = .FALSE.
      WRITE(CTEMP,*)GMAX
      RETLOG = DLGSET(DLG, IDC_EDIT_GREEN_INTNS2, CTEMP)
	  LERR = .TRUE.
	ENDIF

    RETLOG = DLGGET(DLG, IDC_EDIT_GREEN_DELAY2, CTEMP)
    READ(CTEMP,*,IOSTAT = IERR)IGDELAY
    IF(IERR /= 0)THEN
!* ERROR CONDITION, PRINT MESSAGE, DESTRO BOX AND RECREATE
      MSG0 = 'ERROR READING INFORMATION IN EDIT FIELD GREEN DELAY'C
	  MSG1 = 'ERROR READING INFORMATION'C
      IRET = MESSAGEBOXQQ(MSG0, MSG1,MB$ICONEXCLAMATION .OR. MB$OK)
      LCHG = .FALSE.
      WRITE(CTEMP,*)IGDELAY
      RETLOG = DLGSET(DLG, IDC_EDIT_GREEN_DELAY2, CTEMP)
	  LERR = .TRUE.
	ENDIF


  ELSE
    MSG0 = ' NONE OF THE RADIO BUTTONS WERE PUSHED, PLEASE TRY AGAIN'C	  
    MSG1 = ' PALLET_PARAMS ANGLE'C
    IRET = MESSAGEBOXQQ(MSG0, MSG1, MB$ICONEXCLAMATION .OR. MB$OK)
  ENDIF

  IF((REDSTARTP == REDSTART) .AND.                                                      & 
     (GREENSTARTP == GREENSTART) .AND.                                                  &
     (BLUESTARTP == BLUESTART) .AND.                                                    &
     (REDENDP == REDEND) .AND.                                                          &
     (GREENENDP == GREENEND) .AND.                                                      &
     (BLUEENDP == BLUEEND) .AND.                                                        &
     (RPHSP == RPHS) .AND.                                                              &
     (GPHSP == GPHS) .AND.                                                              &
     (BPHSP == BPHS) .AND.                                                              &
     (RMAXP == RMAX) .AND.                                                              &
     (GMAXP == GMAX) .AND.                                                              &
     (BMAXP == BMAX) .AND.                                                              &
     (IRDELAYP == IRDELAY) .AND.                                                        &
     (IGDELAYP == IGDELAY) .AND.                                                        &
     (IBDELAYP == IBDELAY) .AND.                                                        &
     (LNREDP .EQV. LNRED) .AND.                                                         &
     (LNGREENP .EQV. LNGREEN) .AND.                                                     &
     (LNBLUEP .EQV. LNBLUE))THEN                                                 
	 LCHG = .FALSE.
  ENDIF

  IF(.NOT. LERR)THEN
	CALL DLGSETRETURN(DLG, IDOK)
    CALL DLGEXIT(DLG)
  ENDIF
  RETURN
END SUBROUTINE PALLET_PARMS_OK
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
SUBROUTINE PALLET_PARMS_DEG(DLG, ID, CALLBACKTYPE)
!**********************************************************************************
!*
!*  THIS SUBROUTINE IS THE CALLBACK ROUTINE THAT IS CALLED WHEN THE DEGREES BUTTON 
!*  IS PUSHED.  IT CONVERTS THE USER INPUT TO DEGREES FROM RADIANS WHEN THE 
!*  BUTTON IS PUSHED
!*
!**********************************************************************************
  USE MSFLIB
  USE DIALOGM
  USE PALET

  IMPLICIT NONE

  INCLUDE 'RESOURCE.FD'
  TYPE(DIALOG)DLG

  LOGICAL(KIND=4)RETLOG, LERR
  INTEGER(KIND=4)ID, CALLBACKTYPE
  CHARACTER(LEN=55) CTEMP

  CALL UNUSEDQQ(ID, CALLBACKTYPE)
  LERR = .FALSE.

!* GET THE CURRENT VALUES  AND PUT IT IN THE 
!* EDIT FIELD
  WRITE(CTEMP,*)REDSTART*57.2957795131E+00
  RETLOG = DLGSET(DLG, IDC_EDIT_RED_START2, CTEMP)
  WRITE(CTEMP,*)REDEND*57.2957795131E+00
  RETLOG = DLGSET(DLG, IDC_EDIT_RED_END2, CTEMP)
  WRITE(CTEMP,*)RPHS*57.2957795131E+00
  RETLOG = DLGSET(DLG, IDC_EDIT_RED_PHASE2, CTEMP)
  WRITE(CTEMP,*)RMAX
  RETLOG = DLGSET(DLG, IDC_EDIT_RED_INTNS2, CTEMP)
  WRITE(CTEMP,*)IRDELAY
  RETLOG = DLGSET(DLG, IDC_EDIT_RED_DELAY2, CTEMP)
  WRITE(CTEMP,*)GREENSTART*57.2957795131E+00
  RETLOG = DLGSET(DLG, IDC_EDIT_GREEN_START2, CTEMP)
  WRITE(CTEMP,*)GREENEND*57.2957795131E+00
  RETLOG = DLGSET(DLG, IDC_EDIT_GREEN_END2, CTEMP)
  WRITE(CTEMP,*)GPHS*57.2957795131E+00
  RETLOG = DLGSET(DLG, IDC_EDIT_GREEN_PHASE2, CTEMP)
  WRITE(CTEMP,*)GMAX
  RETLOG = DLGSET(DLG, IDC_EDIT_GREEN_INTNS2, CTEMP)
  WRITE(CTEMP,*)IGDELAY
  RETLOG = DLGSET(DLG, IDC_EDIT_GREEN_DELAY2, CTEMP)
  WRITE(CTEMP,*)BLUESTART*57.2957795131E+00
  RETLOG = DLGSET(DLG, IDC_EDIT_BLUE_START2, CTEMP)
  WRITE(CTEMP,*)BLUEEND*57.2957795131E+00
  RETLOG = DLGSET(DLG, IDC_EDIT_BLUE_END2, CTEMP)
  WRITE(CTEMP,*)BPHS*57.2957795131E+00
  RETLOG = DLGSET(DLG, IDC_EDIT_BLUE_PHASE2, CTEMP)
  WRITE(CTEMP,*)BMAX
  RETLOG = DLGSET(DLG, IDC_EDIT_BLUE_INTNS2, CTEMP)
  WRITE(CTEMP,*)IBDELAY
  RETLOG = DLGSET(DLG, IDC_EDIT_BLUE_DELAY2, CTEMP)

  RETURN
END SUBROUTINE PALLET_PARMS_DEG
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
SUBROUTINE PALLET_PARMS_RAD(DLG, ID, CALLBACKTYPE)
!**********************************************************************************
!*
!*  THIS SUBROUTINE IS THE CALLBACK ROUTINE THAT IS CALLED WHEN THE RADIANS BUTTON 
!*  IS PUSHED.  IT CONVERTS THE USER INPUT FROM DEGREES TO RADIANS WHEN THE 
!*  BUTTON IS PUSHED
!*
!**********************************************************************************
  USE MSFLIB
  USE DIALOGM
  USE PALET

  IMPLICIT NONE

  INCLUDE 'RESOURCE.FD'
  TYPE(DIALOG)DLG

  LOGICAL(KIND=4)RETLOG, LERR
  INTEGER(KIND=4)ID, CALLBACKTYPE
  CHARACTER(LEN=55) CTEMP

  CALL UNUSEDQQ(ID, CALLBACKTYPE)
  LERR = .FALSE.

!* GET THE CURRENT VALUES  AND PUT IT IN THE 
!* EDIT FIELD
  WRITE(CTEMP,*)REDSTART
  RETLOG = DLGSET(DLG, IDC_EDIT_RED_START2, CTEMP)
  WRITE(CTEMP,*)REDEND
  RETLOG = DLGSET(DLG, IDC_EDIT_RED_END2, CTEMP)
  WRITE(CTEMP,*)RPHS
  RETLOG = DLGSET(DLG, IDC_EDIT_RED_PHASE2, CTEMP)
  WRITE(CTEMP,*)RMAX
  RETLOG = DLGSET(DLG, IDC_EDIT_RED_INTNS2, CTEMP)
  WRITE(CTEMP,*)IRDELAY
  RETLOG = DLGSET(DLG, IDC_EDIT_RED_DELAY2, CTEMP)
  WRITE(CTEMP,*)GREENSTART
  RETLOG = DLGSET(DLG, IDC_EDIT_GREEN_START2, CTEMP)
  WRITE(CTEMP,*)GREENEND
  RETLOG = DLGSET(DLG, IDC_EDIT_GREEN_END2, CTEMP)
  WRITE(CTEMP,*)GPHS
  RETLOG = DLGSET(DLG, IDC_EDIT_GREEN_PHASE2, CTEMP)
  WRITE(CTEMP,*)GMAX
  RETLOG = DLGSET(DLG, IDC_EDIT_GREEN_INTNS2, CTEMP)
  WRITE(CTEMP,*)IGDELAY
  RETLOG = DLGSET(DLG, IDC_EDIT_GREEN_DELAY2, CTEMP)
  WRITE(CTEMP,*)BLUESTART
  RETLOG = DLGSET(DLG, IDC_EDIT_BLUE_START2, CTEMP)
  WRITE(CTEMP,*)BLUEEND
  RETLOG = DLGSET(DLG, IDC_EDIT_BLUE_END2, CTEMP)
  WRITE(CTEMP,*)BPHS
  RETLOG = DLGSET(DLG, IDC_EDIT_BLUE_PHASE2, CTEMP)
  WRITE(CTEMP,*)BMAX
  RETLOG = DLGSET(DLG, IDC_EDIT_BLUE_INTNS2, CTEMP)
  WRITE(CTEMP,*)IBDELAY
  RETLOG = DLGSET(DLG, IDC_EDIT_BLUE_DELAY2, CTEMP)
  
  RETURN
END SUBROUTINE PALLET_PARMS_RAD
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!



