SUBROUTINE MINMAX(CHECKED)
!******************************************************************************
!*                                                                            *
!*  THIS SUBROUTINE CREATES A DIALOG BOX THAT ALLOWS THE USER TO IMPUT THE    *
!*  NUMBER OF POINTS TO USE TO GENERATE THE MINMAX                            *
!*                                                                            *
!******************************************************************************

  USE MSFLIB
  USE DIALOGM
  USE CHAOSCOM

  IMPLICIT NONE

  INCLUDE 'RESOURCE.FD'

  TYPE(DIALOG)DLG

  LOGICAL(KIND=4)RET, RETLOG
  INTEGER(KIND=4)IRET, IERR
  CHARACTER(LEN=55)CTEMP, MSG0, MSG1
  EXTERNAL MINMAX_HELP, MINMAX_OK
  LOGICAL(KIND=4)CHECKED

  CALL UNUSEDQQ(CHECKED)

  IERR = 0
  MSG0 = ''C
  MSG1 = ''C

!* INITIALIZE THE DIALOG BOX
  RET = DLGINIT(IDD_MINMAX, DLG)
  RET = DLGSETSUB(DLG, IDHELP_MINMAX, MINMAX_HELP)
  RET = DLGSETSUB(DLG, IDOK, MINMAX_OK)

!* GET THE CURRENT VALUES OF THE NUMBER OF POINTS AND PUT IT IN THE 
!* EDIT FIELD
  WRITE(CTEMP,*)IMINMAX
  RETLOG = DLGSET(DLG, IDC_EDIT_MINMAX, CTEMP)

!* BRING UP THE DIALOG BOX
  IRET = DLGMODAL(DLG)

!* DESTROY AND RELEASE THE DIALOG RESOURCES
  CALL DLGUNINIT(DLG)

  RETURN
END SUBROUTINE MINMAX
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
SUBROUTINE MINMAX_HELP(DLGPARENT, ID, CALLBACKTYPE)
  USE MSFLIB
  USE DIALOGM

  IMPLICIT NONE

  INCLUDE 'RESOURCE.FD'

  TYPE(DIALOG)DLG2
  TYPE(DIALOG)DLGPARENT

  LOGICAL(KIND=4)RET
  INTEGER(KIND=4)IRET, ID, CALLBACKTYPE
  
  CALL UNUSEDQQ(DLGPARENT, ID, CALLBACKTYPE)

!* INITIALIZE THE DIALOG BOX
  RET = DLGINIT(IDD_MINMAX_HELP, DLG2)

  IRET = DLGMODAL(DLG2)

  CALL DLGUNINIT(DLG2)
  RETURN
  END SUBROUTINE MINMAX_HELP
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
SUBROUTINE MINMAX_OK(DLG, ID, CALLBACKTYPE)
  USE MSFLIB
  USE DIALOGM
  USE CHAOSCOM

  IMPLICIT NONE

  INCLUDE 'RESOURCE.FD'
  TYPE(DIALOG)DLG

  LOGICAL(KIND=4)RET, LERR
  INTEGER(KIND=4)IRET, ID, CALLBACKTYPE, IERR
  CHARACTER(LEN=55) CTEMP, MSG0, MSG1

  CALL UNUSEDQQ(ID, CALLBACKTYPE)
  LERR = .FALSE.

!* GET THE NEW INFORMATION
  RET = DLGGET(DLG, IDC_EDIT_MINMAX, CTEMP)
  READ(CTEMP,*,IOSTAT = IERR)IMINMAX
  IF(IERR /= 0)THEN
!* ERROR CONDITION, PRINT MESSAGE, DESTRO BOX AND RECREATE
    MSG0 = 'ERROR READING INFORMATION IN EDIT FIELD'C
    MSG1 = 'ERROR READING INFORMATION'C
    IRET = MESSAGEBOXQQ(MSG0, MSG1,MB$ICONEXCLAMATION .OR. MB$OK)
    WRITE(CTEMP,*)IMINMAX
    RET = DLGSET(DLG, IDC_EDIT_MINMAX, CTEMP)
    LERR = .TRUE.
  ENDIF
  

  IF(.NOT. LERR)THEN
	CALL DLGSETRETURN(DLG, IDOK)
    CALL DLGEXIT(DLG)
  ENDIF
  RETURN
END SUBROUTINE MINMAX_OK
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

