SUBROUTINE MATHERRQQ(NAME, LENGTH, INFO, RETCODE)
!************************************************************************************
!*
!* THIS SUBROUTINE DETECTS VARIOUS RUNTIME ERROR AND INFORMS THE USER OF THIS WITHOUT
!* TERMINATING THE PROGRAM
!*
!************************************************************************************
  USE MSFLIB

  INTEGER(KIND=2) LENGTH, RETCODE
  INTEGER(KIND=4) IRET
  CHARACTER(LEN=LENGTH)NAME
  TYPE(MTH$E_INFO)INFO
  
  CALL UNUSEDQQ(NAME)
  SELECT CASE(INFO%ERRCODE)

  CASE (MTH$E_DOMAIN)
    IRET = MESSAGEBOXQQ('DOMAIN ERROR'C,'MATHERRQQ'C, MB$ICONHAND .OR. MB$OK)
	RETCODE = MTH$E_DOMAIN

  CASE (MTH$E_SINGULARITY)
    IRET = MESSAGEBOXQQ('SINGULARITY ERROR'C,'MATHERRQQ'C, MB$ICONHAND .OR. MB$OK)
	RETCODE = MTH$E_SINGULARITY

  CASE (MTH$E_OVERFLOW)
    IRET = MESSAGEBOXQQ('OVERFLOW ERROR'C,'MATHERRQQ'C, MB$ICONHAND .OR. MB$OK)
	RETCODE = MTH$E_OVERFLOW

  CASE (MTH$E_UNDERFLOW)
    IRET = MESSAGEBOXQQ('UNDERFLOW ERROR'C,'MATHERRQQ'C, MB$ICONHAND .OR. MB$OK)
	RETCODE = MTH$E_UNDERFLOW

  CASE (MTH$E_TLOSS)
    IRET = MESSAGEBOXQQ('TOTAL LOSS OF SIGNIFICANCE ERROR'C,'MATHERRQQ'C, MB$ICONHAND .OR. MB$OK)
	RETCODE = MTH$E_TLOSS

  CASE (MTH$E_PLOSS)
    IRET = MESSAGEBOXQQ('PARTIAL LOSS OF SIGNIFICANCE ERROR'C,'MATHERRQQ'C, MB$ICONHAND .OR. MB$OK)
	RETCODE = MTH$E_PLOSS

  CASE DEFAULT
    IRET = MESSAGEBOXQQ('UNKNOWN ERROR'C,'MATHERRQQ'C, MB$ICONHAND .OR. MB$OK)
	RETCODE = 0

  END SELECT

  RETURN
END SUBROUTINE MATHERRQQ