SUBROUTINE LOOK(CHECKED)
!******************************************************************************
!*                                                                            *
!*  DESCRIPTION FOR SUBROUTINE LOOK(CHECKED)                                  *
!*                                                                            *
!*  THIS SUBROUTINE IS USED TO LOOK AT THE TIME OF THE RUN AND THE NUMBER OF  *
!*  POINTS PLOTTED AS THE CHAOS PROGRAM IS RUNNING                            *
!*                                                                            *
!******************************************************************************


  USE MSFLIB
  USE DIALOGM
  USE GETWIN
  USE CHAOSCOM

  IMPLICIT NONE

  INCLUDE 'RESOURCE.FD'

  TYPE(DIALOG)DLG

  INTEGER(KIND=4)IRET
  LOGICAL(KIND=4)RET, RETLOG
  LOGICAL(KIND=4)CHECKED
  INTEGER(KIND=4)ISTOP, IDIFF
  REAL(KIND=4)SDIFF, PNTSSEC
  CHARACTER(LEN=55)CTEMP
  EXTERNAL LOOK_HELP

  CALL UNUSEDQQ(CHECKED)

  IF(.NOT.OUT)THEN
    ISTOP = GETTICKCOUNT()
  ENDIF
  IDIFF = ISTOP - ISTART
  SDIFF = REAL(IDIFF)/1000.00E+00
  IF(ISTART == 0 .OR. IDIFF < 0)THEN
    SDIFF = 0.00E+00
	PNTSSEC = 0.00E+00
  ELSE
    PNTSSEC = REAL(INUM)/SDIFF
  ENDIF

  RET = DLGINIT(IDD_VIEW_STATS, DLG)
  RET = DLGSETSUB(DLG, IDHELP_VIEW_STATS, LOOK_HELP)

  WRITE(CTEMP,*)INUM
  RETLOG = DLGSET(DLG, IDC_EDIT_VIEW_STATS_NPTS, CTEMP)
  WRITE(CTEMP,*)SDIFF
  RETLOG = DLGSET(DLG, IDC_EDIT_VIEW_STATS_NSEC, CTEMP)
  WRITE(CTEMP,*)PNTSSEC
  RETLOG = DLGSET(DLG, IDC_EDIT_VIEW_STATS_NPTSSEC, CTEMP)

  IRET = DLGMODAL(DLG)

  CALL DLGUNINIT(DLG)

  RETURN
END SUBROUTINE LOOK
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
SUBROUTINE LOOK_HELP(DLGPARENT, ID, CALLBACKTYPE)
  USE MSFLIB
  USE DIALOGM

  IMPLICIT NONE

  INCLUDE 'RESOURCE.FD'

  TYPE(DIALOG)DLG2
  TYPE(DIALOG)DLGPARENT

  LOGICAL(KIND=4)RET
  INTEGER(KIND=4)IRET, ID, CALLBACKTYPE

  CALL UNUSEDQQ(DLGPARENT, ID, CALLBACKTYPE)

!* INITIALIZE THE DIALOG BOX
  RET = DLGINIT(IDD_VIEW_STATS_HELP, DLG2)

  IRET = DLGMODAL(DLG2)

  CALL DLGUNINIT(DLG2)
  RETURN
END SUBROUTINE LOOK_HELP

