SUBROUTINE INITIALXY(CHECKED)
!******************************************************************************
!*                                                                            *
!*  THIS SUBROUTINE CREATES A DIALOG BOX THAT ALLOWS THE USER TO INPUT THE    *
!*  INITIAL X AND Y CONDITIONS FOR THE CHAOS EQUATION                         *
!*                                                                            *
!******************************************************************************

  USE MSFLIB
  USE DIALOGM
  USE CHAOSCOM

  IMPLICIT NONE

  INCLUDE 'RESOURCE.FD'

  TYPE(DIALOG)DLG

  LOGICAL(KIND=4)RET, RETLOG
  INTEGER(KIND=4)IRET, IERR
  CHARACTER(LEN=55) CTEMP, MSG0, MSG1
  EXTERNAL INITIALXY_HELP, INITIALXY_OK
  LOGICAL(KIND=4)CHECKED

  CALL UNUSEDQQ(CHECKED)

  IERR = 0
  MSG1 = ''C
  MSG0 = ''C

!* INITIALIZE THE DIALOG BOX
  RET = DLGINIT(IDD_INITIALXY, DLG)
  RET = DLGSETSUB(DLG, IDHELP_INITIALXY, INITIALXY_HELP)
  RET = DLGSETSUB(DLG, IDOK, INITIALXY_OK)

!* GET THE CURRENT VALUES  AND PUT IT IN THE 
!* EDIT FIELD
  WRITE(CTEMP,*)X1_INP
  RETLOG = DLGSET(DLG, IDC_EDIT_INITIAL_X, CTEMP)
  WRITE(CTEMP,*)Y1_INP
  RETLOG = DLGSET(DLG, IDC_EDIT_INITIAL_Y, CTEMP)

!* BRING UP THE DIALOG BOX
  IRET = DLGMODAL(DLG)

  CALL DLGUNINIT(DLG)

  RETURN
END SUBROUTINE INITIALXY
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
SUBROUTINE INITIALXY_HELP(DLGPARENT, ID, CALLBACKTYPE)
  USE MSFLIB
  USE DIALOGM

  IMPLICIT NONE

  INCLUDE 'RESOURCE.FD'

  TYPE(DIALOG)DLG2
  TYPE(DIALOG)DLGPARENT

  LOGICAL(KIND=4)RET
  INTEGER(KIND=4)IRET, ID, CALLBACKTYPE
  
  CALL UNUSEDQQ(DLGPARENT, ID, CALLBACKTYPE)

!* INITIALIZE THE DIALOG BOX
  RET = DLGINIT(IDD_INITIALXY_HELP, DLG2)

  IRET = DLGMODAL(DLG2)

  CALL DLGUNINIT(DLG2)

  RETURN
  END SUBROUTINE INITIALXY_HELP
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
SUBROUTINE INITIALXY_OK(DLG, ID, CALLBACKTYPE)
  USE MSFLIB
  USE DIALOGM
  USE CHAOSCOM

  IMPLICIT NONE

  INCLUDE 'RESOURCE.FD'
  TYPE(DIALOG)DLG

  LOGICAL(KIND=4)RET, LERR
  INTEGER(KIND=4)IRET, ID, CALLBACKTYPE, IERR
  CHARACTER(LEN=55) CTEMP, MSG0, MSG1

  CALL UNUSEDQQ(ID, CALLBACKTYPE)
  LERR = .FALSE.

!* GET THE NEW INFORMATION
  RET = DLGGET(DLG, IDC_EDIT_INITIAL_X, CTEMP)
  READ(CTEMP,*,IOSTAT = IERR)X1_INP
  IF(IERR /= 0)THEN
!* ERROR CONDITION, PRINT MESSAGE, DESTRO BOX AND RECREATE
    MSG0 = 'ERROR READING INFORMATION IN EDIT FIELD INITIAL X VALUE'C
    MSG1 = 'ERROR READING INFORMATION'C
    IRET = MESSAGEBOXQQ(MSG0, MSG1,MB$ICONEXCLAMATION .OR. MB$OK)
    WRITE(CTEMP,*)X1_INP
    RET = DLGSET(DLG, IDC_EDIT_INITIAL_X, CTEMP)
	LERR = .TRUE.
  ENDIF
  RET = DLGGET(DLG, IDC_EDIT_INITIAL_Y, CTEMP)
  READ(CTEMP,*,IOSTAT = IERR)Y1_INP
  IF(IERR /= 0)THEN
!* ERROR CONDITION, PRINT MESSAGE, DESTRO BOX AND RECREATE
    MSG0 = 'ERROR READING INFORMATION IN EDIT FIELD INITIAL Y VALUE'C
    MSG1 = 'ERROR READING INFORMATION'C
    IRET = MESSAGEBOXQQ(MSG0, MSG1,MB$ICONEXCLAMATION .OR. MB$OK)
    WRITE(CTEMP,*)Y1_INP
    RET = DLGSET(DLG, IDC_EDIT_INITIAL_Y, CTEMP)
	LERR = .TRUE.
  ENDIF

  IF(.NOT. LERR)THEN
	CALL DLGSETRETURN(DLG, IDOK)
    CALL DLGEXIT(DLG)
  ENDIF
  RETURN
END SUBROUTINE INITIALXY_OK
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

