C   Compile this program with this line:
C
C      FTN77 STATS -LGO
C
C======================================================================
C  This program is a simple statistics calculator used to demonstrate
C  the capabilities of FTN77/386, the Salford Software Ltd Fortan 77
C  compiler for 386-based PCs and IBM PS/2 systems.
C
C  Before compiling and executing this program, please review the
C  READ.ME file which is supplied on this demonstration disk.
C
C  PLEASE NOTE THAT THE VERSION OF FTN77/386 SUPPLIED ON THE
C  DEMONSTRATION DISK WILL NOT COMPILE MAIN PROGRAMS, SUBROUTINES
C  OR FUNCTIONS OF MORE THAN 50 LINES.
C======================================================================
C
C  The remainder of this file is a main program, followed by several
C  subroutines. It reads some sets of exam marks and computes a set
C  of descriptive statistics.
C
C----------------------------------------------------------------------
      REAL MARKS(100)
      INTEGER NMARKS
C   Read input data.  The data is read in list-directed (free) format.
C   The first value read is a count of the number of marks following.
C   The file containing the input data is MARKS.DAT.
C
      OPEN(UNIT=5,FILE='MARKS.DAT')
      READ(5,*)NMARKS
      READ(5,*)(MARKS(I),I=1,NMARKS)
      CLOSE(5)
C  List the data of the screen
      PRINT *,NMARKS,' values read as follows:'
      WRITE(*,200)(MARKS(I),I=1,NMARKS)
200   FORMAT(8F8.0)
C   Now calculate statistics
      CALL CALC(MARKS,NMARKS,XMEAN,XMED,XSD,XMAX,XMIN)
C   Print results
      PRINT *
      PRINT *,'Maximum:            ',XMAX
      PRINT *,'Minumum:            ',XMIN
      PRINT *,'Mean:               ',XMEAN
      PRINT *,'Median:             ',XMED
      PRINT *,'Standard deviation: ',XSD
      PRINT *
      PRINT *,'Program complete'
      END
      SUBROUTINE CALC(VALUES,NVALUES,XMEAN,XMED,XSD,XMAX,XMIN)
C======================================================================
C   Subroutine to calculate statistics
C
C   Input arguments:
C         VALUES   Array holding values
C         NVALUES  Number of values
C   Output arguments:
C         XMEAN   Arithmetic mean
C         XMED    Median
C         XSD     Standard deviation
C         XMAX    Maximum value
C         XMIN    Minium value
C======================================================================
      REAL VALUES(*),XMEAN,XMED,XSD,XMAX,XMIN
      INTEGER NVALUES
C
      CALL MEAN(VALUES,NVALUES,XMEAN)
      CALL MEDIAN(VALUES,NVALUES,XMED)
      XSD=STDEV(VALUES,NVALUES)
      CALL MAXMIN(VALUES,NVALUES,XMAX,XMIN)
      END
      SUBROUTINE MEAN(VALUES,NVALUES,XMEAN)
C======================================================================
C   Subroutine to calculate mean of a series of values
C   Input arguments:
C         VALUES   Array holding values
C         NVALUES  Number of values
C   Output arguments:
C         XMEAN   Arithmetic mean
C======================================================================
      REAL VALUES(*),XMEAN
      INTEGER NVALUES
      X=0.0
      DO 1 I=1,NVALUE
          X=X+VALUES(I)
1     CONTINUE
      XMEAN=X/NVALUES
      END
      SUBROUTINE MEDIAN(VALUES,NVALUES,XMED)
C======================================================================
C   Subroutine to calculate median of a series of values
C   Input arguments:
C         VALUES   Array holding values
C         NVALUES  Number of values
C   Output arguments:
C         XMED   Median
C======================================================================
      REAL VALUES(*),XMED
      INTEGER NVALUES
      LOGICAL OK
C   Sort values (simple bubble sort)
2     OK=.TRUE.
      DO 1 I=2,NVALUES
      IF(VALUES(I-1).GT.VALUES(I))THEN
         T=VALUES(I)
         VALUES(I)=VALUES(I-1)
         VALUES(I-1)=T
         OK=.FALSE.
      ENDIF
1     CONTINUE
      IF(.NOT.OK)GOTO 2
C   If NVALUES is odd, use middle value. If NVALUES is even, take average
C   of two middle values.
      MID=NVALUES/2
      IF(MID*2.NE.NVALUES)THEN
         XMED=VALUES(MID+1)
      ELSE
         XMED=(VALUES(MID)+VALUES(MID+1))/2.0
      ENDIF
      END
      REAL FUNCTION STDEV(VALUES,NVALUES)
C======================================================================
C   Funtion to calculate standard deviation of a series of values
C   Input arguments:
C         VALUES   Array holding values
C         NVALUES  Number of values
C======================================================================
      REAL VALUES(*)
      INTEGER NVALUES
      X=0.
      X2=0.
      DO 1 I=1,NVALUES
         X=X+VALUES(I)
         X2=X2+VALUES(I)*VALUES(I)
1     CONTINUE
      V=NVALUES
      STDEV=SQRT((V*X2-X*X)/(V*(V-1)))
      END
      SUBROUTINE MAXMIN(VALUES,NVALUES,XMAX,XMIN)
      REAL VALUES(*)
      XMAX=VALUES(1)
      XMIN=VALUES(1)
      DO77I=2,NVALUES
      XMAX=MAX(XMAX,VALUES(I))
77    XMIN=MIN(XMIN,VALUES(I))
      END
