C  
C     PROGRAM: GWIN.FOR
C
C     COPYRIGHT: SALFORD SOFTWARE LIMITED 1991
C
C     This program illustrates how a windows management system can be
C     incorporated into a FTN77/x86 program. It uses routines from the
C     FORTRAN run-time library to achieve this.
C
      INCLUDE 'GWINCOM.INS',NOLIST
      INTEGER*2 FORE,BACK,ERROR,STATUS,SELECT,ICOL,IERR
      INTEGER*2 I,J,K,L,M,IH,IV,SELECTH,SELECTV,COLOUR,X1,Y1,X2,Y2
      INTEGER*4 PCX_BUFFER
      INTEGER*1 DACS(768),PAL(17)
      CHARACTER*80 STRING,PALETTE*17
      LOGICAL LINE_COL_SELECT,FILL_COL_SELECT,PLOT_COL_SELECT
      DATA FORE,BACK/0,3/
***********************************************************************
*                                                                     *
* General notes concerning this program.                              *
* This program is intended to demonstrate the use of pop up graphics  *
* menus and is entirely mouse driven, excepting for the entry of      * 
* filenames for .PCX files. Its purpose is instructive and is not to  * 
* the most efficient or best featured drawing package in existence.   * 
* The drawing functionality is merely a vehicle around which the      * 
* mouse handling and menu building and handling routines have been    * 
* constructed. You may use this source as you like provided that      * 
* the program is not used or reproduced in its entireity.             * 
*                                                                     *
* The general techniques are:                                         *
*                                                                     *
* 1: Pre construct all menus and message boxes                        *
*                                                                     *
* 2: Have generalised menu handling. All menus are assumed to be      *
*    rectangular. Horizontal and vertical menus are merely special    *
*    cases of these                                                   *
*                                                                     *
* 3: Show current choices or defaults by positioning the mouse cursor *
*    over the appropriate menu item                                   *
*                                                                     *
* note:                                                               *
*                                                                     *
* 1: The area under the window is stored away BEFORE the window is    *
*    shown. A pointer to this area is identified with the window      *
*    number                                                           *
*                                                                     *
* 2: The mouse cursor and magnify window are hidden during drawing    *
*    operations                                                       *
*                                                                     *
* 3: There are two mouse debounce routines. When a mouse button is    *
*    pressed there may be many button press events queued. Usually,   *
*    these extra events need to be sucked out so that it doesn't      *
*    appear as if the mouse button has been depressed many times.     *
*    However, the SKETCH option in the draw menu needs to know if the *
*    button is up or down so this requires a separate handler.        *
*                                                                     *
* 4: A window is killed by restoring the area the was saved when the  *
*    window was brought up                                            *
*                                                                     *
* 5: Rubber banding is achieved by XOR drawing. To specify XOR        *
*    drawing, add 128 to the 0-15 pixel colour value.                 *
*                                                                     *
* 6: Since the wire frame selection bar needs to appear in intense    *
*    white the colour that the frame is xor drawn in needs to be      *
*    calculated from the background colour of the window. The         *
*    calculation itself is simple, and is:                            *
*                                                                     *
*    colour=xor(intense_white,background_colour) + 128                *
*                                                                     *
*    128 has to be added to flag the drawing operation as XOR.        *
*                                                                     *
* 7: The only exception to preconstructed windows is the MAGNIFY      *
*    box which is handled dynamically. This is done partly for        *
*    variety and partly because the "super pixels" must be drawn      *
*    dynamically                                                      *
*                                                                     *
***********************************************************************
      FILL_STATUS=.FALSE.
      LINE_COLOUR=15
      FILL_COLOUR=15
      PLOT_COLOUR=15
      LAST_IH=-1
      LAST_IV=-1
      MAG_VISIBLE=.FALSE.
      SHOW_MAG=.FALSE.
      MAG_ACTIVE=.FALSE.
      MAG_BUFFER=-1L
      MAG_X=500                                              
      MAG_Y=0
      CALL INITIALISE_MOUSE@
C
C     The library routine INITIALISE_MOUSE@ initialises the mouse driver
C     and resets to mouse. This should always be called before the first
C     use of the mouse.
C
      CALL MAKE_GWINDOW(640,20,1,FORE,BACK,0,0)
C
C     The subroutine MAKE_GWINDOW is explained fully later. In brief, the
C     above call would create a menu with the elements:
C
C              640,20,     -     dimensions 640 x 20 pixels
C              1,          -     assign it as window 1
C              FORE,       -     use the value of this as the
C                                foreground colour
C              BACK,       -     and this as the background colour
C              0,0         -     to be put on screen at the top left
C                                corner, 0,0.
C
C     This is the definition of the main menu, which is displayed when the
C     program is initiated.
C
      CALL WRITE_GWINDOW(1,'Import',5+8,2,15)
C
C     Again, the subroutine WRITE_GWINDOW will be given only a short
C     description here. It is used to insert a menu option into the
C     designated menu.
C
C     Where x positions are given in the form of I+J this is to 
C     indicate that I is the left edge of the cell and J is the offset 
C     from that required to centre the text in the cell. ALL cells in a 
C     menu are assumed to be the same width and height 
C     
C
C              1,          -     use window 1
C              'Import',   -     the text to be displayed
C              5+8,2       -     the position inside the window
C              15          -     colour of text
C
      CALL WRITE_GWINDOW(1,'Draw',75+16,2,15)
      CALL WRITE_GWINDOW(1,'Clean',145+12,2,15)
      CALL WRITE_GWINDOW(1,'Fill',215+16,2,15)
      CALL WRITE_GWINDOW(1,'Copy',285+16,2,15)
      CALL WRITE_GWINDOW(1,'Magnify',355+4,2,15)
      CALL WRITE_GWINDOW(1,'Save',425+16,2,15)
      CALL WRITE_GWINDOW(1,'Colours',495+4,2,15)
      CALL WRITE_GWINDOW(1,'Quit',565+16,2,15)
C
C     The following definitions are all used by the window manager, a
C     brief description of each is given.
C
      FIELD_WIDTH(1)=70
C
C     FIELD_WIDTH(I)       -     the width of each cell in the menu
C
      FIELD_DEPTH(1)=14
C
C     FIELD_DEPTH(I)       -     the height of each cell in the menu
C
      TEXT_LOFFSET(1)=5
C
C     TEXT_LOFFSET(I)      -     allows room at the left of the menu 
C                                for descriptive text before menu 
C                                items start 
C
      TEXT_TOFFSET(1)=1
C
C     TEXT_TOFFSET(I)      -     allows room at the top of the menu 
C                                for descriptive text before menu 
C                                items start 
C
C
      BAR_LOFFSET(1)=0
C
C     BAR_LOFFSET(I)       -     the left offset of the highlight box
C                                from the position of the cell
C
      BAR_TOFFSET(1)=-1
C
C     BAR_TOFFSET(I)       -     the top offset of the highlight box
C                                from the position of the cell
      BAR_WIDTH(1)=64
C
C     BAR_WIDTH(I)         -     the width of the highlight box
C
      BAR_DEPTH(1)=14
C
C     BAR_DEPTH(I)         -     the height of the highlight box
C
      HCHOICES(1)=9
C
C     HCHOICES(I)          -     the number of horizontal options in the
C                                menu
C        
      VCHOICES(1)=0
C
C     VCHOICES(I)          -     the number of vertical options in the
C                                menu
C
      BACK_COL(1)=BACK
C
C     BACK_COL(I)          -     the background colour of the menu
C
C
      CALL MAKE_GWINDOW(640,20,2,FORE,BACK,0,0)
C
C     This is the window for the 'Import' option. The two following windows
C     are also used by the 'Import' option.
C
      CALL WRITE_GWINDOW(2,'PCX file: ',10,2,15)
      TEXT_LOFFSET(2)=100
      HCHOICES(2)=0
C
      CALL MAKE_GWINDOW(640,20,3,FORE,BACK,0,0)
      CALL WRITE_GWINDOW(3,
     +'Click on top left corner for load position: ',10,2,15)
      TEXT_LOFFSET(3)=10
      HCHOICES(3)=0
C
      CALL MAKE_GWINDOW(228,20,4,FORE,BACK,0,0)
      CALL WRITE_GWINDOW(4,'Load failed:',10,2,15)
      CALL WRITE_GWINDOW(4,'Retry',120,2,15)
      CALL WRITE_GWINDOW(4,'Abort',170,2,15)
      FIELD_WIDTH(4)=50
      FIELD_DEPTH(4)=14
      TEXT_LOFFSET(4)=120
      TEXT_TOFFSET(4)=1
      BAR_LOFFSET(4)=4
      BAR_TOFFSET(4)=-1
      BAR_WIDTH(4)=48
      BAR_DEPTH(4)=14
      HCHOICES(4)=2
      VCHOICES(4)=0
      BACK_COL(4)=BACK
C
      CALL MAKE_GWINDOW(92,132,5,FORE,BACK,90,0)
C
C     This is the window for the 'Draw' option.
C
      CALL WRITE_GWINDOW(5,'Draw:',10,10,15)
      CALL WRITE_GWINDOW(5,'Polyline',10,24,15)
      CALL WRITE_GWINDOW(5,'Polygon',10,38,15)
      CALL WRITE_GWINDOW(5,'Rectangle',10,52,15)
      CALL WRITE_GWINDOW(5,'Circle',10,66,15)
      CALL WRITE_GWINDOW(5,'Ellipse',10,80,15)
      CALL WRITE_GWINDOW(5,'Sketch',10,94,15)
      CALL WRITE_GWINDOW(5,'Plot',10,108,15)
      FIELD_WIDTH(5)=50
      FIELD_DEPTH(5)=14
      TEXT_LOFFSET(5)=10
      TEXT_TOFFSET(5)=24
      BAR_LOFFSET(5)=4
      BAR_TOFFSET(5)=1
      BAR_WIDTH(5)=78
      BAR_DEPTH(5)=16
      HCHOICES(5)=0
      VCHOICES(5)=7
      BACK_COL(5)=BACK
C
      CALL MAKE_GWINDOW(68,62,6,FORE,BACK,250,0)
C
C     This is the window for the 'Fill' option.
C
      CALL WRITE_GWINDOW(6,'Fill:',10,10,15)
      CALL WRITE_GWINDOW(6,'Hollow',10,24,15)
      CALL WRITE_GWINDOW(6,'Solid',10,38,15)
      FIELD_WIDTH(6)=24
      FIELD_DEPTH(6)=14
      TEXT_LOFFSET(6)=10
      TEXT_TOFFSET(6)=24
      BAR_LOFFSET(6)=4
      BAR_TOFFSET(6)=1
      BAR_WIDTH(6)=56
      BAR_DEPTH(6)=16
      HCHOICES(6)=0
      VCHOICES(6)=2
      BACK_COL(6)=BACK
C
      CALL MAKE_GWINDOW(640,20,7,FORE,BACK,0,0)
C
C     This, and the next three windows are used from the 'Draw' options.
C
      CALL WRITE_GWINDOW(7,'Click left button to set vertex,',10,2,15)
      CALL WRITE_GWINDOW(7,
     +' right button to set vertex and exit',264,2,15)
      TEXT_LOFFSET(7)=10
      HCHOICES(7)=0
C
      CALL MAKE_GWINDOW(640,20,8,FORE,BACK,0,0)
      CALL WRITE_GWINDOW(8,'Click left button to set corner,',10,2,15)
      CALL WRITE_GWINDOW(8,
     +' right button to set opposite corner and exit',264,2,15)
      TEXT_LOFFSET(8)=10
      HCHOICES(8)=0
C
      CALL MAKE_GWINDOW(640,20,9,FORE,BACK,0,0)
      CALL WRITE_GWINDOW(9,'Click left button to set centre,',10,2,15)
      CALL WRITE_GWINDOW(9,
     +' right button to set edge and exit',264,2,15)
      TEXT_LOFFSET(9)=10
      HCHOICES(9)=0
C
      CALL MAKE_GWINDOW(430,41,10,FORE,BACK,0,0)
      CALL WRITE_GWINDOW(10,'Click left button to set centre',10,2,15)
      CALL WRITE_GWINDOW(10,'and horizontal axis',264,2,15)
      CALL WRITE_GWINDOW(10,'right button to set vertical',10,16,15)
      CALL WRITE_GWINDOW(10,' axis and exit',234,16,15)
      TEXT_LOFFSET(10)=10
      HCHOICES(10)=0
C
      CALL MAKE_GWINDOW(84,67,11,FORE,BACK,490,0)
C
C     This is the window for the 'Colours' option.
C
      CALL WRITE_GWINDOW(11,'Colours:',10,2,15)
      CALL WRITE_GWINDOW(11,'Lines',10,16,15)
      CALL WRITE_GWINDOW(11,'Fill',10,30,15)
      CALL WRITE_GWINDOW(11,'Plot',10,44,15)
      FIELD_WIDTH(11)=24
      FIELD_DEPTH(11)=14
      TEXT_LOFFSET(11)=10
      TEXT_TOFFSET(11)=16
      BAR_LOFFSET(11)=4
      BAR_TOFFSET(11)=1
      BAR_WIDTH(11)=48
      BAR_DEPTH(11)=16
      HCHOICES(11)=0
      VCHOICES(11)=3
      BACK_COL(11)=BACK
C
      X1=7
      Y1=7
C
      X2=39+7
      Y2=39+7
C
      CALL MAKE_GWINDOW(220,220,12,15,0,419,0)
C
C     This is the window from where colours can be chosen.
C
      CALL OPEN_VSCREEN@(BUFFER(12),ERROR)
      CALL DRAW_LINE@(55,1,55,218,15)
      CALL DRAW_LINE@(110,1,110,218,15)
      CALL DRAW_LINE@(165,1,165,218,15)
      CALL DRAW_LINE@(1,55,218,55,15)
      CALL DRAW_LINE@(1,110,218,110,15)
      CALL DRAW_LINE@(1,165,218,165,15)
      ICOL=0
      DO 72 I=1,4
         DO 73 J=1,4
            CALL FILL_RECTANGLE@(X1,Y1,X2,Y2,ICOL)
            ICOL=ICOL+1
            X1=X1+55
            X2=X2+55
73          CONTINUE
         X1=7
         X2=39+7
         Y1=Y1+55
         Y2=Y2+55
72       CONTINUE
      CALL CLOSE_VSCREEN@
      FIELD_WIDTH(12)=55
      FIELD_DEPTH(12)=55
      TEXT_LOFFSET(12)=0
      TEXT_TOFFSET(12)=0
      BAR_LOFFSET(12)=-4
      BAR_TOFFSET(12)=-4
      BAR_WIDTH(12)=46
      BAR_DEPTH(12)=46
      HCHOICES(12)=4
      VCHOICES(12)=4
      BACK_COL(12)=0
C
      CALL MAKE_GWINDOW(68,62,13,FORE,BACK,410,0)
C
C     This is the window for the 'Save' option.
C
      CALL WRITE_GWINDOW(13,'Save:',10,10,15)
      CALL WRITE_GWINDOW(13,'Entire',10,24,15)
      CALL WRITE_GWINDOW(13,'Part',10,38,15)
      FIELD_WIDTH(13)=24
      FIELD_DEPTH(13)=14
      TEXT_LOFFSET(13)=10
      TEXT_TOFFSET(13)=24
      BAR_LOFFSET(13)=4
      BAR_TOFFSET(13)=1
      BAR_WIDTH(13)=56
      BAR_DEPTH(13)=16
      HCHOICES(13)=0
      VCHOICES(13)=2
      BACK_COL(13)=BACK
C
      CALL MAKE_GWINDOW(640,20,14,FORE,BACK,0,0)
      CALL WRITE_GWINDOW(14,'Click left button to set corner,',10,2,15)
      CALL WRITE_GWINDOW(14,
     +' right button to set opposite corner',264,2,15)
      TEXT_LOFFSET(14)=10
      HCHOICES(14)=0
C
      CALL MAKE_GWINDOW(220,41,15,FORE,BACK,0,0)
      CALL WRITE_GWINDOW(15,'Click left button to copy',10,2,15)
      CALL WRITE_GWINDOW(15,'right button to exit',10,16,15)
      TEXT_LOFFSET(15)=10
      HCHOICES(15)=0
C
      CALL MAKE_GWINDOW(396,20,16,FORE,BACK,0,0)
      CALL WRITE_GWINDOW(16,'Press left button to draw,',10,2,15)
      CALL WRITE_GWINDOW(16,
     +' right button to exit',218,2,15)
      TEXT_LOFFSET(16)=10
      HCHOICES(16)=0
C
      CALL MAKE_GWINDOW(100,62,17,FORE,BACK,355,0)
C
C     This is the window for the 'Magnify' option.
C
      CALL WRITE_GWINDOW(17,'Magnify:',10,10,15)
      CALL WRITE_GWINDOW(17,'Reposition',10,24,15)
      CALL WRITE_GWINDOW(17,'On/Off',10,38,15)
      FIELD_WIDTH(17)=80
      FIELD_DEPTH(17)=14
      TEXT_LOFFSET(17)=10
      TEXT_TOFFSET(17)=24
      BAR_LOFFSET(17)=4
      BAR_TOFFSET(17)=1
      BAR_WIDTH(17)=88
      BAR_DEPTH(17)=16
      HCHOICES(17)=0
      VCHOICES(17)=2
      BACK_COL(17)=BACK
C
      CALL MAKE_GWINDOW(252,41,18,FORE,BACK,0,0)
C
C     This window is used from the 'Magnify' option.
C
      CALL WRITE_GWINDOW(18,'Click left button to position',10,2,15)
      CALL WRITE_GWINDOW(18,'right button to abort',10,16,15)
      TEXT_LOFFSET(18)=10
      HCHOICES(18)=0
C

      CALL MAKE_GWINDOW(132,34,19,FORE,BACK,157,0)
C
C     This is the window for the 'Clean' option.
C
      CALL WRITE_GWINDOW(19,'Confirm clean:',10,2,15)
      CALL WRITE_GWINDOW(19,'No',10,16,15)
      CALL WRITE_GWINDOW(19,'Yes',42,16,15)
      FIELD_WIDTH(19)=32
      FIELD_DEPTH(19)=14
      TEXT_LOFFSET(19)=10
      TEXT_TOFFSET(19)=15
      BAR_LOFFSET(19)=4
      BAR_TOFFSET(19)=-1
      BAR_WIDTH(19)=32
      BAR_DEPTH(19)=14
      HCHOICES(19)=2
      VCHOICES(19)=0
      BACK_COL(19)=BACK
C
      CALL VGA@
      CALL SET_MOUSE_BOUNDS@(0,0,639,479)
      CALL DRAWING_MOUSE
      CALL DISPLAY_CURSOR
C
C     Switch to VGA mode, 640x480.
C     Set the mouse boundarys to the full screen.
C     Setup the mouse pointer.
C     Display the mouse pointer on the screen
C
      K=0
      STATUS=-1
      WHILE(K.NE.27)DO
C
C        The subroutine FETCH_MOUSE_POS appears later. It returns
C        the current mouse position in IH and IV. STATUS returns the
C        button status, which is zero if no buttons are pressed.
C
         IF(STATUS.NE.0)THEN
            IF (STATUS.NE.-1) CALL DEBOUNCE_BUTTONS
C
C           The subroutine DEBOUNCE_BUTTONS absorbs button presses
C           until a change is found.
C
            CALL SELECT_GWINDOW(1,SELECT,SELECTV)
C
C           This call to SELECT_GWINDOW displays the main menu and returns
C           the value of the option selected in SELECT.
C
            IF(SELECT.EQ.1)THEN
C
C           Import a PCX file.
C
2              CALL HIDE_CURSOR
C
C              The mouse pointer is hidden.
C
               SHOW_MAG=.FALSE.
C
C              The magnification box is forced off.
C
               CALL BRINGUP_GWINDOW(2)
C
C              The window prompting for a filename is displayed.
C
               CALL GET_INPUT(2,FORE,BACK,STRING)
C
C              A string is read into STRING using colours FORE and BACK in
C              window 2. Subroutine GET_INPUT is described fully later.
C
               CALL KILL_GWINDOW(2)
C
C              Window 2 is removed from the screen. Subroutine KILL_GWINDOW
C              is explained later.
C
               CALL DISPLAY_CURSOR
C
C              The mouse pointer is redisplayed
C
               CALL UPCASE(STRING)
               M=LENG(STRING)
               L=MAX(1,M-3)
               IF(STRING(L:).NE.'.PCX')THEN
                  ERROR=1
               ELSE
                  CALL PCX_TO_SCREEN_BLOCK@(STRING(:M),PCX_BUFFER,
     +PALETTE,ERROR)
C
C                 PCX_TO_SCREEN_BLOCK@ loads a PCX format file into a screen
C                 block. Returns a pointer to a screen block and the palette
C                 specified in the PCX file.
C
               ENDIF
               SHOW_MAG=MAG_ACTIVE
               IF(ERROR.EQ.0)THEN
                  CALL BRINGUP_GWINDOW(3)
C
C                 If there was no error the screen block may be put down where
C                 the mouse is next clicked. A message is displayed informing
C                 this.
C
                  STATUS=0
                  WHILE(STATUS.EQ.0)DO
                     CALL FETCH_MOUSE_POS(IH,IV,STATUS)
                     ENDWHILE
C
C                 The above waits for the mouse button to be pressed.
C
                  CALL DEBOUNCE_BUTTONS
                  CALL KILL_GWINDOW(3)
                  CALL HIDE_CURSOR
C
C                 The message is removed, along with the mouse pointer.
C
C                 Fetches the dac and palette values required to faithfully
C                 reproduce the colours of the original image
                  CALL GET_DACS_FROM_SCREEN_BLOCK@(PCX_BUFFER,PAL
     +                                             ,DACS,IERR)
C
C                 The palette is copied from the screen block.
C
                  CALL SET_ALL_PALETTE_REGS@(PAL)
                  CALL SET_VIDEO_DAC_BLOCK@(0,256,DACS)
C
C                 Then the palette registers are set up accordingly.
C
                  CALL RESTORE_SCREEN_BLOCK@(IH,IV,PCX_BUFFER,0,ERROR)
C
C                 The PCX file is then copied to the screen with the top
C                 left corner where the mouse was clicked.
C
                  CALL RETURN_STORAGE@(PCX_BUFFER)
C
C                 The PCX buffer is then freed.
C
                  CALL DISPLAY_CURSOR
C
C                 The mouse pointer can now be redisplayed.
C
               ELSE
C           Position the mouse cursor over the RETRY option in
C           the load fail menu
                  IH=SAVE_X1(4)+TEXT_LOFFSET(4)+BAR_WIDTH(4)
     -                                         -BAR_LOFFSET(4)
                  IV=SAVE_Y1(4)+7
                  CALL SET_MOUSE_POSITION@(IH,IV)
                  CALL SELECT_GWINDOW(4,SELECT,SELECTV)
                  IF(SELECT.EQ.1)GOTO2
C
C                 If an error occured there is a prompt to retry or abort.
C
               ENDIF
            ELSEIF(SELECT.EQ.2)THEN
C
C           DRAW option from main menu.
C
               CALL SELECT_GWINDOW(5,SELECTH,SELECT)
               IF(SELECT.EQ.1)THEN
C
C              POLYLINE option
C
                  CALL DO_POLYLINE
               ELSEIF(SELECT.EQ.2)THEN
C
C              POLYGON option
C
                  CALL DO_POLYGON
               ELSEIF(SELECT.EQ.3)THEN
C
C              RECTANGLE option
C
                  CALL DO_RECTANGLE
               ELSEIF(SELECT.EQ.4)THEN
C
C              CIRCLE option
C
                  CALL DO_CIRCLE
               ELSEIF(SELECT.EQ.5)THEN
C
C              ELLIPSE option
C
                  CALL DO_ELLIPSE
               ELSEIF(SELECT.EQ.6)THEN
C
C              SKETCH option
C
                  CALL DO_SKETCH
               ELSEIF(SELECT.EQ.7)THEN
C
C              PLOT option
C
                  CALL DO_PLOT
               ENDIF
            ELSEIF(SELECT.EQ.3)THEN
C
C           CLEAN option from main menu
C
C          Position cursor over the NO option in the confirm clean menu
C 
               IH=SAVE_X1(19)+TEXT_LOFFSET(19)+BAR_WIDTH(19)
     -                                         -BAR_LOFFSET(19)-8
               IV=SAVE_Y1(19)+25
                  CALL SET_MOUSE_POSITION@(IH,IV)
               CALL SELECT_GWINDOW(19,SELECT,SELECTV)
               IF(SELECT.EQ.2)THEN
                  CALL HIDE_CURSOR
                  CALL CLEAR_SCREEN@
                  CALL DISPLAY_CURSOR
               ENDIF
            ELSEIF(SELECT.EQ.4)THEN
C
C           FILL option from main menu
C
C           Position cursor over the current FILL status
               IH=SAVE_X2(6)-8
               IV=SAVE_Y1(6)+TEXT_TOFFSET(6)+7
               IF(FILL_STATUS)IV=IV+14
               CALL SET_MOUSE_POSITION@(IH,IV)
               CALL SELECT_GWINDOW(6,SELECTH,SELECT)
               IF(SELECT.EQ.1)THEN
                  FILL_STATUS=.FALSE.
               ELSEIF(SELECT.EQ.2)THEN
                  FILL_STATUS=.TRUE.
               ENDIF
            ELSEIF(SELECT.EQ.5)THEN
C
C           COPY option from main menu
C
               CALL MARK_RECTANGLE(X1,Y1,X2,Y2)
               CALL HIDE_CURSOR
               CALL GET_SCREEN_BLOCK@(X1,Y1,X2,Y2,PCX_BUFFER)
               CALL DISPLAY_CURSOR
               CALL MOVE_RECTANGLE(X1,Y1,X2,Y2,PCX_BUFFER)
               CALL RETURN_STORAGE@(PCX_BUFFER)
            ELSEIF(SELECT.EQ.6)THEN
C
C           MAGNIFY option from main menu
C
C           Position mouse cursor over the ON/OFF option
C            
               IH=SAVE_X2(17)-8
               IV=SAVE_Y1(17)+TEXT_TOFFSET(17)+7
               CALL SET_MOUSE_POSITION@(IH,IV)
               CALL SELECT_GWINDOW(17,SELECTH,SELECT)
               IF(SELECT.EQ.1)THEN
C           MAGNIFY window REPOSITION chosen, so move window
                  CALL POSITION_MAG
               ELSE
C           MAGNIFY window ON/OFF chosen so toggle current state
                  MAG_ACTIVE=.NOT.MAG_ACTIVE
                  SHOW_MAG=MAG_ACTIVE
               ENDIF
            ELSEIF(SELECT.EQ.7)THEN
C
C           SAVE option from main menu
C
               CALL SELECT_GWINDOW(13,SELECTH,SELECT)
               IF(SELECT.NE.0)THEN
                  IF(SELECT.EQ.1)THEN
                     X1=0
                     Y1=0
                     X2=639
                     Y2=479
                  ELSE
                     CALL MARK_RECTANGLE(X1,Y1,X2,Y2)
                  ENDIF
                  CALL HIDE_CURSOR
                  CALL GET_SCREEN_BLOCK@(X1,Y1,X2,Y2,PCX_BUFFER)
                  CALL DISPLAY_CURSOR
61                CALL BRINGUP_GWINDOW(2)
                  CALL HIDE_CURSOR
                  CALL GET_INPUT(2,FORE,BACK,STRING)
                  CALL DISPLAY_CURSOR
                  CALL KILL_GWINDOW(2)
                  CALL UPCASE(STRING)
                  M=LENG(STRING)
                  L=MAX(1,M-3)
                  IF(STRING(L:).NE.'.PCX')THEN
                     ERROR=1
                  ELSE
                     CALL SCREEN_BLOCK_TO_PCX@(STRING(:M),PCX_BUFFER,
     +                                                         ERROR)
                  ENDIF
                  IF(ERROR.EQ.0)THEN
                     CALL RETURN_STORAGE@(PCX_BUFFER)
                  ELSE
                     IH=SAVE_X1(4)+TEXT_LOFFSET(4)+BAR_WIDTH(4)
     -                                           -BAR_LOFFSET(4)
                     IV=SAVE_Y1(4)+7
                     CALL SET_MOUSE_POSITION@(IH,IV)
                     CALL SELECT_GWINDOW(4,SELECT,SELECTV)
                     IF(SELECT.EQ.1)GOTO61
                  ENDIF
               ENDIF
            ELSEIF(SELECT.EQ.8)THEN
C
C           COLOURS option from main menu
C
C           Position cursor over the first item in the colours menu
               IH=SAVE_X1(11)+TEXT_LOFFSET(11)+BAR_WIDTH(11)
     -            -BAR_LOFFSET(11)
               IV=SAVE_Y1(11)+TEXT_TOFFSET(11)+7
               CALL SET_MOUSE_POSITION@(IH,IV)
               CALL SELECT_GWINDOW(11,SELECTH,SELECT)
               LINE_COL_SELECT=.FALSE.
               FILL_COL_SELECT=.FALSE.
               PLOT_COL_SELECT=.FALSE.
               IF(SELECT.EQ.1)THEN
                  LINE_COL_SELECT=.TRUE.
                  COLOUR=LINE_COLOUR
               ELSEIF(SELECT.EQ.2)THEN
                  FILL_COL_SELECT=.TRUE.
                  COLOUR=FILL_COLOUR
               ELSEIF(SELECT.EQ.3)THEN
                  PLOT_COL_SELECT=.TRUE.
                  COLOUR=PLOT_COLOUR
               ENDIF
               IF(SELECT.NE.0)THEN
C           Depending upon whether LINE, FILL, or PLOT colours are being
C           chosen position the cursor over the current colour
                  IH=MOD(COLOUR,4)
                  IV=COLOUR/4
                  IH=SAVE_X1(12)+IH*FIELD_WIDTH(12)+FIELD_WIDTH(12)/2
                  IV=SAVE_Y1(12)+IV*FIELD_DEPTH(12)+FIELD_DEPTH(12)/2
                  CALL SET_MOUSE_POSITION@(IH,IV)
                  CALL SELECT_GWINDOW(12,SELECTH,SELECTV)
                  IF(SELECTV.NE.0)THEN
                     SELECT=(SELECTV-1)*4+SELECTH-1
                     IF(LINE_COL_SELECT)THEN
                        LINE_COLOUR=SELECT
                     ELSEIF(FILL_COL_SELECT)THEN
                        FILL_COLOUR=SELECT
                     ELSEIF(PLOT_COL_SELECT)THEN
                        PLOT_COLOUR=SELECT
                     ENDIF
                  ENDIF
               ENDIF
            ELSEIF(SELECT.EQ.9)THEN
C
C           EXIT option from main menu
C
               GOTO 1
            ENDIF
         ENDIF
         CALL FETCH_MOUSE_POS(IH,IV,STATUS)
         CALL GET_KEY1@(K)
         ENDWHILE
1     CALL TEXT_MODE@
      END

      SUBROUTINE MAKE_GWINDOW(HRES,VRES,WNUM,FORE,BACK,IX,IY)
C
C     This subroutine creates the screen block used when displaying a menu.
C
C     HRES and VRES are taken as the horizontal and vertical size of the
C     box, into which the menu options are written.
C
C     WNUM is the number used to identify the menu.
C
C     FORE and BACK are the foreground and background colours of the text
C     within the box.
C
C     IX and IY point to where on the screen the menu should be displayed.
C
      INCLUDE 'GWINCOM.INS',NOLIST
      INTEGER*2 HRES,VRES,WNUM,FORE,BACK,IX,IY
      INTEGER*2 ERROR
C
      CALL CREATE_SCREEN_BLOCK@(HRES,VRES,4,BUFFER(WNUM))
      IF(BUFFER(WNUM).EQ.-1L)STOP 'CP 1'
C
C     A screen block is requested. BUFFER(WNUM) should be a pointer to the
C     requested block. A value of -1 usually means there is not enough
C     memory left to create the block.
C
      CALL OPEN_VSCREEN@(BUFFER(WNUM),ERROR)
C
C     OPEN_VSCREEN causes graphics normally sent to the screen to be written
C     into the designated screen block.
C
      CALL FILL_RECTANGLE@(0,0,HRES-1,VRES-1,BACK)
      CALL RECTANGLE@(1,1,HRES-2,VRES-2,FORE)
C
C     A filled box is written to the screen block in the selected colours.
C
      CALL CLOSE_VSCREEN@
C
C     Normal screen operation is reinstated.
C
C     Register the size of the window and its position
C
      SAVE_X1(WNUM)=IX
      SAVE_X2(WNUM)=HRES-1+IX
      SAVE_Y1(WNUM)=IY
      SAVE_Y2(WNUM)=VRES-1+IY
      END

      SUBROUTINE WRITE_GWINDOW(WNUM,STRING,IH,IV,ICOL)
C
C     This subroutine writes a string of characters into a specified windows
C     screen block.
C
C     WNUM is the window to write to.
C
C     STRING is the string to be written
C
C     IH,IV is the position to write the string.
C
C     ICOL is the colour to use when writing.
C
      INCLUDE 'GWINCOM.INS',NOLIST
      INTEGER*2 WNUM,IH,IV,ICOL
      CHARACTER*(*) STRING
      INTEGER*2 ERROR
C
C     The screen block is activated. The string is written. Then the screen
C     block is deactivated.
C
      CALL OPEN_VSCREEN@(BUFFER(WNUM),ERROR)
      CALL DRAW_TEXT@(STRING,IH,IV,ICOL)
      CALL CLOSE_VSCREEN@
      END

      SUBROUTINE BRINGUP_GWINDOW(WNUM)
C
C     This subroutine displays the specified windows screen block, after
C     saving what was previously behind the screen block.
C
C     WNUM specifies which window to use.
C
      INCLUDE 'GWINCOM.INS',NOLIST
      INTEGER*2 WNUM
      INTEGER*2 X1,X2,Y1,Y2,RX,RY,ERROR
C
C     Coordinates of area under window to be saved
C
      X1=SAVE_X1(WNUM)
      X2=SAVE_X2(WNUM)
      Y1=SAVE_Y1(WNUM)
      Y2=SAVE_Y2(WNUM)
C
C     Top left coordinates of restore position
C
      RX=SAVE_X1(WNUM)
      RY=SAVE_Y1(WNUM)
C
C
C     The mouse pointer is hidden.
C
      CALL HIDE_CURSOR
C
C     The area where the screen block is to be put is saved first.
C     Then the window is put onto the screen
C
      CALL GET_SCREEN_BLOCK@(X1,Y1,X2,Y2,SAVE_BUFFER(WNUM))
      CALL RESTORE_SCREEN_BLOCK@(RX,RY,BUFFER(WNUM),0,ERROR)
      IF(ERROR.NE.0)THEN
         CALL TEXT_MODE@
         PRINT *,ERROR
         STOP
      ENDIF
C
C     The mouse pointer is redisplayed.
C
      CALL DISPLAY_CURSOR
      END

      SUBROUTINE KILL_GWINDOW(WNUM)
C
C     This subroutine removes a windows screen block from the screen by
C     replacing what was previously there.
C
C     WNUM specifies which window to use.
C
      INCLUDE 'GWINCOM.INS',NOLIST
      INTEGER*2 WNUM
      INTEGER*2 RX,RY,ERROR
C
C     Top left coordinates of area to be restored
C
      RX=SAVE_X1(WNUM)
      RY=SAVE_Y1(WNUM)
C
C
C     The mouse pointer is removed.
C
      CALL HIDE_CURSOR
C
C     The original screen block is replaced.
C
      CALL RESTORE_SCREEN_BLOCK@(RX,RY,SAVE_BUFFER(WNUM),0,ERROR)
C
C     The allocated memory for the screen block is restored.
C
      CALL RETURN_STORAGE@(SAVE_BUFFER(WNUM))
C
C     The mouse pointer is redisplayed.
C
      CALL DISPLAY_CURSOR
      END

      SUBROUTINE SELECT_GWINDOW(WNUM,SELECTH,SELECTV)
C
C     This subroutine is for displaying a menu on the screen and
C     allowing you to choose one of the options.
C
C     On entry WNUM is the window to choose from.
C
C     On exit (SELECTH,SELECTV) are the cell coordinates of the
C     option chosen vertical option chosen.
C
      INCLUDE 'GWINCOM.INS',NOLIST
      INTEGER*2 WNUM,SELECTH,SELECTV
      INTEGER*2 IH,IV,STATUS,X1,X2,Y1,Y2,CURRENT,XC,YC,
     +THIS,OLD_X,OLD_IH,OLD_IV,LOFFSET,TOFFSET,HBARS,
     +VBARS,F_WIDTH,B_LOFFSET,B_WIDTH,THISH,THISV,C_HPOS,C_VPOS,F_DEPTH,
     +OLD_Y,B_TOFFSET,B_DEPTH,IC,IX1,IX2,IY1,IY2
      LOGICAL IN_WINDOW,TEMP_MAG
      INTERNAL PROCEDURE CURSOR
C
C  Flag magnify window as not active
C
      SHOW_MAG=.FALSE.
      TEMP_MAG=MAG_ACTIVE
      MAG_ACTIVE=.FALSE.
C
C  Display menu
C
      CALL BRINGUP_GWINDOW(WNUM)
C
C  Change cursor shape form the drawing cursor to the menu cursor
C
      CALL MENU_MOUSE
C
C  Window dimensions
C
      X1=SAVE_X1(WNUM)
      X2=SAVE_X2(WNUM)
      Y1=SAVE_Y1(WNUM)
      Y2=SAVE_Y2(WNUM)
C
C  Part of the menu are may be left or top descriptive text
C
      LOFFSET=TEXT_LOFFSET(WNUM)
      TOFFSET=TEXT_TOFFSET(WNUM)
C
C  Number of horizontal and vertical cells
C
      HBARS=HCHOICES(WNUM)
      VBARS=VCHOICES(WNUM)
C
      CURRENT=-1
      THIS=-1
      OLD_IH=-1
      OLD_IV=-1
C
C Cell size
C
      F_WIDTH=FIELD_WIDTH(WNUM)
      F_DEPTH=FIELD_DEPTH(WNUM)
C
C Selection bar is slightly outside of cell
C
      B_LOFFSET=BAR_LOFFSET(WNUM)
      B_WIDTH=BAR_WIDTH(WNUM)
      B_DEPTH=BAR_DEPTH(WNUM)
      B_TOFFSET=BAR_TOFFSET(WNUM)
C
C XOR colour of selection bar
C
      IC=XOR(15,BACK_COL(WNUM))+128
      STATUS=0
C
C Go through selection procedure until a mouse button is pressed
C
      WHILE(STATUS.EQ.0)DO
C
C Mouse position is fetched
C
         CALL FETCH_MOUSE_POS(IH,IV,STATUS)
C
C Selection bar is only displayed if cursor is within the menu area
C
         IN_WINDOW=IV.GE.Y1.AND.IV.LE.Y2.AND.IH.GE.X1.AND.IH.LE.X2
C
C Do nothing unless mouse position has changed
C
         IF(OLD_IH.NE.IH.OR.OLD_IV.NE.IV)THEN
            IF(IN_WINDOW)THEN
C
C Calculate current cell position of mouse
C
               THISH=(IH-X1-LOFFSET)/F_WIDTH
               THISH=MIN(MAX(0,HBARS-1),MAX(0,THISH))
               C_HPOS=X1+LOFFSET+THISH*F_WIDTH
C
               THISV=(IV-Y1-TOFFSET)/F_DEPTH
               THISV=MIN(MAX(0,VBARS-1),MAX(0,THISV))
               C_VPOS=Y1+TOFFSET+THISV*F_DEPTH
C
C For convenience combine the x and y cell positions
C
               THIS=THISV*256+THISH
C
C If cell coordinates have changed move selection bar
C
               IF(THIS.NE.CURRENT)THEN
C
C Remove old bar if displayed
C
                  IF(CURRENT.NE.-1)THEN
                     XC=OLD_X
                     YC=OLD_Y
                     INVOKE CURSOR
                  ENDIF
C
C Show new bar if displayed
C
                  IF(THIS.NE.-1)THEN
                     XC=C_HPOS
                     YC=C_VPOS
                     INVOKE CURSOR
                  ENDIF
C
C Update the old cell position
C
                  OLD_X=C_HPOS
                  OLD_Y=C_VPOS
               ENDIF
            ELSE
C
C Cursor not in menu area so choices invalid
C
               THIS=-1
               IF(CURRENT.NE.-1)THEN
C
C Remove old bar if displayed
C
                  XC=OLD_X
                  YC=OLD_Y
                  INVOKE CURSOR
               ENDIF
            ENDIF
            CURRENT=THIS
         ENDIF
         ENDWHILE
C Button press has happened
C Absorb all pending button presses
      CALL DEBOUNCE_BUTTONS
C Only return a valid cell position if mouse cursor
C was within the menu area
      IF(IN_WINDOW)THEN
         SELECTH=THISH+1
         SELECTV=THISV+1
      ELSE
C Mark choices is invalid
         SELECTH=0
         SELECTV=0
      ENDIF
C Flag magnify window to its old status
      MAG_ACTIVE=TEMP_MAG
      SHOW_MAG=MAG_ACTIVE
C
C     The menu is removed from the screen.
C
      CALL KILL_GWINDOW(WNUM)
C
C     The mouse is changed back to a drawing pointer.
C
      CALL DRAWING_MOUSE
      RETURN
C
      PROCEDURE CURSOR
C
C     This procedure is used to draw the highlight box around the options
C     in the menu.
C
      IX1=XC-B_LOFFSET
      IY1=YC-B_TOFFSET
      IX2=IX1+B_WIDTH
      IY2=IY1+B_DEPTH
      CALL HIDE_CURSOR
      CALL RECTANGLE@(IX1,IY1,IX2,IY2,IC)
      CALL DISPLAY_CURSOR
      EXIT CURSOR
      END

      SUBROUTINE ABSORB_BUTTONS
C
C     This subroutine will absorb all mouse buttons pressed until there is
C     some change in the mouse status, or the position of the mouse changes.
C
      INTEGER*2 OLD_IH,OLD_IV,OLD_STATUS,IH,IV,STATUS
      CALL FETCH_MOUSE_POS(OLD_IH,OLD_IV,OLD_STATUS)
      STATUS=OLD_STATUS
      IH=OLD_IH
      IV=OLD_IV
      WHILE(STATUS.EQ.OLD_STATUS.AND.
     +      IH.EQ.OLD_IH.AND.IV.EQ.OLD_IV)DO
         CALL FETCH_MOUSE_POS(IH,IV,STATUS)
         ENDWHILE
      END

      SUBROUTINE GET_INPUT(WNUM,FORE,BACK,STRING)
C
C     This subroutine reads a line of text from the keyboard and displays
C     it in a window.
C
C     WNUM is the window to use.
C
C     FORE and BACK are the colours to write in.
C
C     STRING is the string returned to the caller.
C
      INCLUDE 'GWINCOM.INS',NOLIST
      INTEGER*2 WNUM,FORE,BACK
      CHARACTER*(*) STRING
      INTEGER*2 X1,Y1,OFFSET,PTR,K
      CHARACTER INPUT*60,BLANKS*60,SEND*60,EXT*4
      EXT='.PCX'
      INPUT=' '
      OFFSET=TEXT_LOFFSET(WNUM)
      X1=SAVE_X1(WNUM)+OFFSET
      Y1=SAVE_Y1(WNUM)+2
      CALL FILL@(BLANKS,60L,219)
      STRING=' '
      EXT='.PCX'
1     PTR=LENG(INPUT)
C
C Wipe area uder the string
C
      CALL DRAW_TEXT@(BLANKS,X1,Y1,BACK)
C 
C Add the .PCX extension to the input
C
      SEND=INPUT(:PTR)//EXT
C 
C Write current filename.PCX
C 
      CALL DRAW_TEXT@(SEND(:LENG(SEND)),X1,Y1,FORE)
C 
C Draw in the input cursor
C 
      CALL DRAW_TEXT@(CHAR(219),X1+8*PTR,Y1,143)
C 
C Fetch a key
C 
      CALL GET_KEY@(K)
      IF(K.GT.0)THEN
         IF(K.EQ.13)THEN
C 
C If <CR> update input name and exit
C 
            INPUT(PTR+1:)=EXT
            GOTO 2
         ELSEIF(K.EQ.8.OR.K.EQ.255)THEN
C Backspace and DEL key
            INPUT(PTR:)=' '
         ELSEIF(K.LT.255)THEN
C Add character to string
            INPUT(PTR+1:)=CHAR(K)
         ENDIF
      ENDIF
      GOTO 1
2     STRING=INPUT
      END

      SUBROUTINE DO_POLYLINE
C This routine handles polyline and polygon drawing, filling the
C polygon if necessary
C
C After the first point has been anchored, the line is rubber banded
C to the previous vertex in intense white until it is redrawn in
C the current line colour
C
      INCLUDE 'GWINCOM.INS',NOLIST
      INTEGER*2 MAXVERTS
      PARAMETER (MAXVERTS=2000)
      INTEGER*2 IH,IV,OLD_IX,OLD_IY,STATUS,LASTX,LASTY,IC,XC,YC
      INTEGER*2 PX(MAXVERTS),PY(MAXVERTS),NVERTS,ERROR,HANDLE
      INTEGER*2 XORCOL,DRAWCOL
      LOGICAL FIRST_PRESS,POLYGON
      INTERNAL PROCEDURE LINE
C
      POLYGON=.FALSE.
      DRAWCOL=LINE_COLOUR
      GOTO 5
C
      ENTRY DO_POLYGON
      POLYGON=.TRUE.
      IF(FILL_STATUS)THEN
         DRAWCOL=255
      ELSE
         DRAWCOL=LINE_COLOUR
      ENDIF
C
5     FIRST_PRESS=.TRUE.
C
C Bring up the message window, telling how to control mouse
C
      CALL BRINGUP_GWINDOW(7)
C
C Mark no previos vertex
C
      OLD_IX=-1
      OLD_IY=-1
      STATUS=0
      NVERTS=0
      XORCOL=255
C
C Make sure no button presses are queued
C
      CALL ABSORB_BUTTONS
C Loop until right button pressed
      WHILE(AND(STATUS,2).EQ.0)DO
         CALL FETCH_MOUSE_POS(IH,IV,STATUS)
         IF(STATUS.NE.0)THEN
C
C Kill the message window at first button press
C
            CALL ABSORB_BUTTONS
            IF(FIRST_PRESS)THEN
               CALL KILL_GWINDOW(7)
               FIRST_PRESS=.FALSE.
            ENDIF
         ENDIF
C
C Only do something if mouse position has changed or
C a button has been pressed
C
         IF(OLD_IX.NE.IH.OR.OLD_IY.NE.IV.OR.STATUS.NE.0)THEN
C
C OLD_IX=-1 means that there is no first anchor point yet
C
            IF(OLD_IX.NE.-1)THEN
C
C Rubber band last line segment
C
               XC=OLD_IX
               YC=OLD_IY
               IC=XORCOL
               INVOKE LINE
               XC=IH
               YC=IV
               INVOKE LINE
C
C If this vertex has been fixed by a button press, remove the
C rubber band and redraw in the chosen colour, add to vertex list
C
               IF(STATUS.NE.0)THEN
                  IC=XORCOL
                  INVOKE LINE
                  IC=DRAWCOL
                  INVOKE LINE
                  LASTX=IH
                  LASTY=IV
                  NVERTS=NVERTS+1
                  PX(NVERTS)=IH
                  PY(NVERTS)=IV
               ENDIF
               OLD_IX=IH
               OLD_IY=IV
            ELSE
C
C Make the first vertex
C 
               IF(STATUS.NE.0)THEN
                  OLD_IX=IH
                  OLD_IY=IV
                  LASTX=IH
                  LASTY=IV
                  NVERTS=1
                  PX(NVERTS)=IH
                  PY(NVERTS)=IV
               ENDIF
            ENDIF
         ENDIF
         ENDWHILE
C
C Right mouse button pressed
C
      IF(POLYGON)THEN
C
C Complete the polygon by drawing the from last to
C the first vertex
C
         LASTX=PX(1)
         LASTY=PY(1)
         XC=PX(NVERTS)
         YC=PY(NVERTS)
         NVERTS=NVERTS+1
         PX(NVERTS)=LASTX
         PY(NVERTS)=LASTY
         INVOKE LINE
         IF(FILL_STATUS)THEN
C
C Polygon needs filling, create polygon definition, fill it
C edge the polygon and delete polygon definition
C
            CALL CREATE_POLYGON@(PX,PY,NVERTS,HANDLE,ERROR)
            CALL HIDE_CURSOR
            CALL POLYLINE@(PX,PY,NVERTS,DRAWCOL)
            CALL FILL_POLYGON@(HANDLE,FILL_COLOUR,ERROR)
            CALL POLYLINE@(PX,PY,NVERTS,FILL_COLOUR)
            CALL DISPLAY_CURSOR
            CALL DELETE_POLYGON_DEFINITION@(HANDLE,ERROR)
         ENDIF
      ENDIF
      RETURN
C
      PROCEDURE LINE
C
C Hide cursor, draw line and display cursor
C
      CALL HIDE_CURSOR
      CALL DRAW_LINE@(LASTX,LASTY,XC,YC,IC)
      CALL DISPLAY_CURSOR
      EXIT LINE
      END

      SUBROUTINE DO_RECTANGLE
C
C This routine handles both circles and rectangles
C
      INCLUDE 'GWINCOM.INS',NOLIST
      INTEGER*2 FIRSTX,FIRSTY,R,WNUM
      INTEGER*2 IH,IV,OLD_IX,OLD_IY,STATUS,IC,XC,YC
      REAL*4 FX,FY
      LOGICAL FIRST_PRESS,CIRCLE
      INTERNAL PROCEDURE BOX,DRAW_CIRCLE
      WNUM=8
      CIRCLE=.FALSE.
      GOTO 5
C
      ENTRY DO_CIRCLE
      WNUM=9
      CIRCLE=.TRUE.
C
C Make sure no button presses are queued
C
5     CALL ABSORB_BUTTONS
C
C Display appropriate message box
C
      CALL BRINGUP_GWINDOW(WNUM)
      FIRSTX=-1
      FIRSTY=-1
      OLD_IX=-1
      OLD_IY=-1
      FIRST_PRESS=.TRUE.
      STATUS=0
C
C Loop until right button pressed
C
      WHILE(AND(STATUS,2).EQ.0)DO
         CALL FETCH_MOUSE_POS(IH,IV,STATUS)
         IF(STATUS.NE.0)THEN
            CALL ABSORB_BUTTONS
            IF(FIRST_PRESS)THEN
               CALL KILL_GWINDOW(WNUM)
               FIRST_PRESS=.FALSE.
            ENDIF
         ENDIF
         IF(OLD_IX.NE.IH.OR.OLD_IY.NE.IV.OR.STATUS.NE.0)THEN
            IF(OLD_IX.NE.-1)THEN
C
C First anchor point exists so rubber band circle or rectangle
C to new position
C

               XC=OLD_IX
               YC=OLD_IY
               IC=LINE_COLOUR+128
               INVOKE BOX
               XC=IH
               YC=IV
               INVOKE BOX
               OLD_IX=IH
               OLD_IY=IV
            ELSE
               IF(STATUS.NE.0)THEN
C
C Make first anchor point ie centre of circle or first vertex
C of rectangle
C
                  OLD_IX=IH
                  OLD_IY=IV
                  FIRSTX=IH
                  FIRSTY=IV
               ENDIF
            ENDIF
         ENDIF
         ENDWHILE
         IF(CIRCLE)THEN
C
C Draw filled or unfilled circle
C
            CALL HIDE_CURSOR
            IF(FILL_STATUS)THEN
               CALL FILL_ELLIPSE@(FIRSTX,FIRSTY,R,R,FILL_COLOUR)
            ELSE
               CALL ELLIPSE@(FIRSTX,FIRSTY,R,R,LINE_COLOUR)
            ENDIF
            CALL DISPLAY_CURSOR
         ELSE      
C
C Draw filled or unfilled rectangle
C
            IF(FILL_STATUS)THEN
               CALL HIDE_CURSOR
               CALL FILL_RECTANGLE@(FIRSTX,FIRSTY,IH,IV,FILL_COLOUR)
               CALL DISPLAY_CURSOR
            ELSE
               CALL HIDE_CURSOR
               CALL RECTANGLE@(FIRSTX,FIRSTY,IH,IV,LINE_COLOUR)
               CALL DISPLAY_CURSOR
            ENDIF
         ENDIF
      RETURN
C
      PROCEDURE BOX
C
C Draw unfilled circle or rectangle
C
      IF(CIRCLE)THEN
         INVOKE DRAW_CIRCLE
         EXIT BOX
      ENDIF
C
      CALL HIDE_CURSOR
      CALL RECTANGLE@(FIRSTX,FIRSTY,XC,YC,IC)
      CALL DISPLAY_CURSOR
      EXIT BOX
C
      PROCEDURE DRAW_CIRCLE
      FX=FIRSTX-XC
      FY=FIRSTY-YC
C
C Calculate radius of circle
C
      R=NINT(SQRT(FX*FX+FY*FY))
C
C Draw unfilled circle
C
      CALL HIDE_CURSOR
      CALL ELLIPSE@(FIRSTX,FIRSTY,R,R,IC)
      CALL DISPLAY_CURSOR
      EXIT DRAW_CIRCLE
      END

      SUBROUTINE DO_ELLIPSE
      INCLUDE 'GWINCOM.INS',NOLIST
      INTEGER*2 WNUM,VY,HX
      INTEGER*2 IH,IV,OLD_IX,OLD_IY,STATUS,IC,XC,YC,OX,OY,IA,IB
      LOGICAL FIRST_MOVE
      INTERNAL PROCEDURE CROSS,HLINE,VLINE
      WNUM=10
C
C Make sure no button presses are queued
C
      CALL ABSORB_BUTTONS
      OLD_IX=-1
      OLD_IY=-1
      FIRST_MOVE=.TRUE.
      STATUS=0
C
C Display message window
C
      CALL BRINGUP_GWINDOW(WNUM)
      IC=LINE_COLOUR+128
C
C Fix centre of ellipse by pressing button
C
      WHILE(STATUS.EQ.0)DO
         CALL FETCH_MOUSE_POS(IH,IV,STATUS)
         IF(IH.NE.OLD_IX.OR.IV.NE.OLD_IY)THEN
            OLD_IX=IH
            OLD_IY=IV
         ENDIF
         ENDWHILE
C
C Make sure no button presses are queued
C
      CALL ABSORB_BUTTONS
C
C Remove message window
C
      CALL KILL_GWINDOW(WNUM)
C
C Exit if right mouse button pressed
C
      IF(AND(STATUS,2).NE.0)RETURN
      OX=IH
      OY=IV
C
C Constrain mouse cursor to move horizontally
C through ellipse centre
C
      CALL SET_MOUSE_BOUNDS@(0,OY,639,OY)
C
C Mark centre with a cross
C
      INVOKE CROSS
      FIRST_MOVE=.TRUE.
      OLD_IX=OX
      OLD_IY=OY
      STATUS=0
C
C Loop until button pressed
C
      WHILE(STATUS.EQ.0)DO
         CALL FETCH_MOUSE_POS(IH,IV,STATUS)
         IF(STATUS.NE.0)CALL ABSORB_BUTTONS
         IF(OLD_IX.NE.IH.OR.OLD_IY.NE.IV.OR.STATUS.NE.0)THEN
C
C If mouse moved draw symmetrical horizontal
C line though ellipse centre
C
            XC=OLD_IX
            YC=OLD_IY
            IC=LINE_COLOUR+128
            INVOKE HLINE
            XC=IH
            YC=IV
            INVOKE HLINE
            OLD_IX=IH
            OLD_IY=IV
         ENDIF
         ENDWHILE
C
C Exit or horizontal axis fixed
C
C
C Make sure no button presses are queued
C
      CALL DEBOUNCE_BUTTONS
      IF(AND(STATUS,2).NE.0)THEN
C
C Right button pressed, restore mouse movements and screen state
C then exit
C
         INVOKE HLINE
         INVOKE CROSS
         CALL SET_MOUSE_BOUNDS@(0,0,639,479)
         RETURN
      ENDIF
C
C IA is the length of the horizontal semi axis
C
      IA=ABS(OX-IH)
      HX=IH
C
C Constrain mouse only to move vertically
C
      CALL SET_MOUSE_BOUNDS@(OX,0,OX,479)
      FIRST_MOVE=.TRUE.
      OLD_IX=OX
      OLD_IY=OY
      STATUS=0
C
C Loop until button pressed
C
      WHILE(AND(STATUS,2).EQ.0)DO
         CALL FETCH_MOUSE_POS(IH,IV,STATUS)
         IF(STATUS.NE.0)CALL ABSORB_BUTTONS
         IF(OLD_IX.NE.IH.OR.OLD_IY.NE.IV.OR.STATUS.NE.0)THEN
            XC=OLD_IX
            YC=OLD_IY
C
C If mouse moved draw symmetrical vertical
C line though ellipse centre
C
            INVOKE VLINE
            XC=IH
            YC=IV
            INVOKE VLINE
            OLD_IX=IH
            OLD_IY=IV
         ENDIF
         ENDWHILE
C
C IB is length of vertical semi axis
C
         IB=ABS(OY-IV)
C
C Remove horizontal and vertical axes from display
C
         VY=IV
         YC=VY
         INVOKE VLINE
         XC=HX
         INVOKE HLINE
C
C Undraw centre cross
C
         INVOKE CROSS
C
C Restore full screen mouse movement
C
         CALL SET_MOUSE_BOUNDS@(0,0,639,479)
         CALL HIDE_CURSOR
C
C Draw filled or unfilled ellipse
C
         IF(FILL_STATUS)THEN
            CALL FILL_ELLIPSE@(OX,OY,IA,IB,FILL_COLOUR)
         ELSE
            CALL ELLIPSE@(OX,OY,IA,IB,LINE_COLOUR)
         ENDIF
         CALL DISPLAY_CURSOR
         CALL DEBOUNCE_BUTTONS
         RETURN
C
      PROCEDURE CROSS
C
C Draws a diagonal cross
C
      CALL HIDE_CURSOR
      CALL DRAW_LINE@(OX-10,OY-10,OX+10,OY+10,IC)
      CALL DRAW_LINE@(OX+10,OY-10,OX-10,OY+10,IC)
      CALL DISPLAY_CURSOR
      EXIT CROSS
C
      PROCEDURE HLINE
C
C Draws a horizontal line extended symmetrically
C through ellipse centre
C
      CALL HIDE_CURSOR
      CALL DRAW_LINE@(OX+OX-XC,OY,XC,OY,IC)
      CALL DISPLAY_CURSOR
      EXIT HLINE
C
      PROCEDURE VLINE
C
C Draws a vertical line extended symmetrically
C through ellipse centre
C
      CALL HIDE_CURSOR
      CALL DRAW_LINE@(OX,OY+OY-YC,OX,YC,IC)
      CALL DISPLAY_CURSOR
      EXIT VLINE
C
      END

      SUBROUTINE DO_SKETCH
C
C Implements the sketch drawing option,
C Draws whilst the left button is depressed,
C Exits when the right button is depressed
C
      INCLUDE 'GWINCOM.INS',NOLIST
      INTEGER*2 OLD_X,OLD_Y,IH,IV,STATUS
      LOGICAL FIRST_PRESS
      STATUS=0
      OLD_X=-1
      OLD_Y=-1
C
C Display message window
C
      CALL BRINGUP_GWINDOW(16)
      FIRST_PRESS=.TRUE.
C
C Make sure no button presses are queued
C
      CALL ABSORB_BUTTONS
      WHILE(AND(STATUS,2).EQ.0)DO
         CALL FETCH_MOUSE_POS(IH,IV,STATUS)
         IF(IH.NE.OLD_X.OR.IV.NE.OLD_Y.AND.AND(STATUS,1).EQ.1)THEN
            IF(OLD_X.EQ.-1)THEN
               IF(STATUS.NE.0)THEN
                  OLD_X=IH
                  OLD_Y=IV
               ENDIF
            ELSE
               IF(FIRST_PRESS)THEN
C
C Remove message window at first button press
C
                  CALL KILL_GWINDOW(16)
                  FIRST_PRESS=.FALSE.
               ENDIF
C
C Mouse button depressed so draw a line segment in
C current line colour form old to new position
C
               CALL HIDE_CURSOR
               CALL DRAW_LINE@(OLD_X,OLD_Y,IH,IV,LINE_COLOUR)
               CALL DISPLAY_CURSOR
               OLD_X=IH
               OLD_Y=IV
            ENDIF
         ELSE
            OLD_X=-1
            OLD_Y=-1
         ENDIF
C
C Make sure no button presses are queued for this position
C
         CALL ABSORB_BUTTONS
         ENDWHILE
C
C Make sure no button presses are queued
C
      CALL ABSORB_BUTTONS
C
C Remove message window if not already done so
C
      IF(FIRST_PRESS)CALL KILL_GWINDOW(16)
      END

      SUBROUTINE DO_PLOT
C
C Implements the plot drawing function,
C a point is plotted every time the left mouse
C button is pressed
C
      INCLUDE 'GWINCOM.INS',NOLIST
      INTEGER*2 IH,IV,STATUS
      LOGICAL FIRST_PRESS
      STATUS=0
      CALL BRINGUP_GWINDOW(16)
      FIRST_PRESS=.TRUE.
      CALL DEBOUNCE_BUTTONS
      WHILE(AND(STATUS,2).EQ.0)DO
         CALL FETCH_MOUSE_POS(IH,IV,STATUS)
         IF(AND(STATUS,1).EQ.1)THEN
            IF(FIRST_PRESS)THEN
C
C Remove message window on first button press
C
               CALL KILL_GWINDOW(16)
               FIRST_PRESS=.FALSE.
            ENDIF
C
C Plot the pixel
C
            CALL HIDE_CURSOR
            CALL SET_PIXEL@(IH,IV,PLOT_COLOUR)
            CALL DISPLAY_CURSOR
         CALL DEBOUNCE_BUTTONS
         ENDIF
         ENDWHILE
      CALL DEBOUNCE_BUTTONS
C
C Remove message window if not already done so
C
      IF(FIRST_PRESS)CALL KILL_GWINDOW(16)
      END

      SUBROUTINE MARK_RECTANGLE(X1,Y1,X2,Y2)
C
C This routine provides a service to other routines
C It asks the user to mark a rectangle the coordinates of which
C are returned to the caller
C
      INCLUDE 'GWINCOM.INS',NOLIST
      INTEGER*2 X1,Y1,X2,Y2
      INTEGER*2 FIRSTX,FIRSTY,WNUM
      INTEGER*2 IH,IV,OLD_IX,OLD_IY,STATUS,IC,XC,YC
      LOGICAL FIRST_PRESS
      INTERNAL PROCEDURE BOX
      WNUM=14
      IC=143
C
      CALL ABSORB_BUTTONS
C
C Display message window
C
      CALL BRINGUP_GWINDOW(WNUM)
      FIRSTX=-1
      FIRSTY=-1
      OLD_IX=-1
      OLD_IY=-1
      FIRST_PRESS=.TRUE.
      STATUS=0
C
C Loop until right button pressed
C
      WHILE(AND(STATUS,2).EQ.0)DO
         CALL FETCH_MOUSE_POS(IH,IV,STATUS)
         IF(STATUS.NE.0)THEN
            CALL ABSORB_BUTTONS
            IF(FIRST_PRESS)THEN
               CALL KILL_GWINDOW(WNUM)
               FIRST_PRESS=.FALSE.
            ENDIF
         ENDIF
         IF(OLD_IX.NE.IH.OR.OLD_IY.NE.IV.OR.STATUS.NE.0)THEN
            IF(OLD_IX.NE.-1)THEN
               XC=OLD_IX
               YC=OLD_IY
               INVOKE BOX
               XC=IH
               YC=IV
               INVOKE BOX
               OLD_IX=IH
               OLD_IY=IV
            ELSE
               IF(STATUS.NE.0)THEN
                  OLD_IX=IH
                  OLD_IY=IV
                  FIRSTX=IH
                  FIRSTY=IV
               ENDIF
            ENDIF
         ENDIF
         ENDWHILE
      IF(FIRSTX.GT.IH)THEN
         OLD_IX=IH
         IH=FIRSTX
         FIRSTX=OLD_IX
      ENDIF
      IF(FIRSTY.GT.IV)THEN
         OLD_IY=IV
         IV=FIRSTY
         FIRSTY=OLD_IY
      ENDIF
      XC=IH
      YC=IV
      INVOKE BOX
      X1=FIRSTX
      Y1=FIRSTY
      X2=XC
      Y2=YC
      RETURN
C
      PROCEDURE BOX
C
      CALL HIDE_CURSOR
      CALL RECTANGLE@(FIRSTX,FIRSTY,XC,YC,143)
      CALL DISPLAY_CURSOR
      EXIT BOX
C
      END

      SUBROUTINE MOVE_RECTANGLE(X1,Y1,X2,Y2,IBUFF)
C
C This routine provides a service to other routines
C A wire frame rectangle is dragged around the screen following
C the mouse cursor. The screen block pointed at by IBUFF is loaded
C to the screen whenever the left mouse button is pressed
C
      INCLUDE 'GWINCOM.INS',NOLIST
      INTEGER*2 X1,Y1,X2,Y2
      INTEGER*4 IBUFF
      INTEGER*2 OLD_X,OLD_Y,XC,YC,FIRSTX,FIRSTY,DX,DY,IC
      INTEGER*2 STATUS,IH,IV,ERROR
      LOGICAL FIRST_LOAD
      INTERNAL PROCEDURE BOX,LOAD
      IC=143
      DX=X2-X1
      DY=Y2-Y1
      FIRSTX=X1
      FIRSTY=Y1
      OLD_X=X1
      OLD_Y=Y1
      XC=X1
      YC=Y1
      CALL HIDE_CURSOR
      CALL SET_MOUSE_POSITION@(X1,Y1)
      CALL DISPLAY_CURSOR
      CALL BRINGUP_GWINDOW(15)
      FIRST_LOAD=.TRUE.
      STATUS=0
      INVOKE BOX
      WHILE(AND(STATUS,2).EQ.0)DO
         CALL FETCH_MOUSE_POS(IH,IV,STATUS)
         IF(IH.NE.OLD_X.OR.IV.NE.OLD_Y)THEN
            XC=OLD_X
            YC=OLD_Y
            INVOKE BOX
            XC=IH
            YC=IV
            INVOKE BOX
            OLD_X=IH
            OLD_Y=IV
         ENDIF
         IF(AND(STATUS,1).EQ.1)THEN
            IF(FIRST_LOAD)THEN
               INVOKE BOX
               CALL KILL_GWINDOW(15)
               INVOKE BOX
               FIRST_LOAD=.FALSE.
            ENDIF
            INVOKE LOAD
         ENDIF
         CALL ABSORB_BUTTONS
         ENDWHILE
      INVOKE BOX
      IF(FIRST_LOAD)CALL KILL_GWINDOW(15)
      RETURN

      PROCEDURE BOX
C
      CALL HIDE_CURSOR
      CALL RECTANGLE@(XC,YC,XC+DX,YC+DY,IC)
      CALL DISPLAY_CURSOR
      EXIT BOX
C
      PROCEDURE LOAD
      CALL HIDE_CURSOR
      CALL RESTORE_SCREEN_BLOCK@(XC,YC,IBUFF,0,ERROR)
      CALL DISPLAY_CURSOR
      INVOKE BOX
      EXIT LOAD
C
      END

      SUBROUTINE POSITION_MAG
C
C This routine implements the reposition magnify window function
C A wire frame the size of the magnify window is dragged around until
C the user presses a mouse button. If the left button was pressed then
C The mouse position becomes the position of the top left of the
C magnify window
C
      INCLUDE 'GWINCOM.INS',NOLIST
      INTEGER*2 X1,Y1
      INTEGER*2 OLD_X,OLD_Y,XC,YC
      INTEGER*2 STATUS,IH,IV,IC
      LOGICAL TEMP_MAG
      INTERNAL PROCEDURE BOX
C
C Make sure the mouse cannot move to a position where any part
C of the magnify window would be off-screen
C
      CALL SET_MOUSE_BOUNDS@(0,0,639-117,479-117)
C
C Flag the magnify window as not displayed
C
      SHOW_MAG=.FALSE.
      TEMP_MAG=MAG_ACTIVE
      MAG_ACTIVE=.FALSE.
C
C Display message box
C
      CALL BRINGUP_GWINDOW(18)
      CALL HIDE_CURSOR
C
C Cursor position initialised at top left position of
C magnify window
C
      X1=MAG_X
      Y1=MAG_Y
      OLD_X=X1
      OLD_Y=Y1
      IC=143
      CALL SET_MOUSE_POSITION@(X1,Y1)
      CALL DISPLAY_CURSOR
      STATUS=0
      XC=X1
      YC=Y1
      INVOKE BOX
      WHILE(STATUS.EQ.0)DO
         CALL FETCH_MOUSE_POS(IH,IV,STATUS)
         IF(IH.NE.OLD_X.OR.IV.NE.OLD_Y)THEN
            XC=OLD_X
            YC=OLD_Y
            INVOKE BOX
            XC=IH
            YC=IV
            INVOKE BOX
            OLD_X=IH
            OLD_Y=IV
         ENDIF
         ENDWHILE
C
C If left button was pressed, make the current position
C the position of the top left of magnify window
C
      IF(AND(STATUS,1).EQ.1)THEN
         MAG_X=IH
         MAG_Y=IV
      ENDIF
      INVOKE BOX
      CALL KILL_GWINDOW(18)
      CALL DEBOUNCE_BUTTONS
C
C Restore mouse movements to full screen
C
      CALL SET_MOUSE_BOUNDS@(0,0,639,479)
C
C Restore magnify window staus
C
      MAG_ACTIVE=TEMP_MAG
      SHOW_MAG=MAG_ACTIVE
      RETURN

      PROCEDURE BOX
C
      CALL HIDE_CURSOR
      CALL RECTANGLE@(XC,YC,XC+117,YC+117,IC)
      CALL DISPLAY_CURSOR
      EXIT BOX
C
      END

      SUBROUTINE MENU_MOUSE
C
C     This subroutine configures the mouse pointer as an arrow.
C
      INTEGER*2 CURDEF(32),HOT_X,HOT_Y
      HOT_X=0
      HOT_Y=0
      CURDEF( 1)=B'0011111111111111'
      CURDEF( 2)=B'0001111111111111'
      CURDEF( 3)=B'0000111111111111'
      CURDEF( 4)=B'0000011111111111'
      CURDEF( 5)=B'0000001111111111'
      CURDEF( 6)=B'0000000111111111'
      CURDEF( 7)=B'0000000011111111'
      CURDEF( 8)=B'0000000001111111'
      CURDEF( 9)=B'0000000000111111'
      CURDEF(10)=B'0000000000011111'
      CURDEF(11)=B'0000000111111111'
      CURDEF(12)=B'0001000011111111'
      CURDEF(13)=B'0011000011111111'
      CURDEF(14)=B'1111100001111111'
      CURDEF(15)=B'1111100001111111'
      CURDEF(16)=B'1111110001111111'
C
      CURDEF(17)=B'0000000000000000'
      CURDEF(18)=B'0100000000000000'
      CURDEF(19)=B'0110000000000000'
      CURDEF(20)=B'0111000000000000'
      CURDEF(21)=B'0111100000000000'
      CURDEF(22)=B'0111110000000000'
      CURDEF(23)=B'0111111000000000'
      CURDEF(24)=B'0111111100000000'
      CURDEF(25)=B'0111111110000000'
      CURDEF(26)=B'0111110000000000'
      CURDEF(27)=B'0110110000000000'
      CURDEF(28)=B'0100011000000000'
      CURDEF(29)=B'0000011000000000'
      CURDEF(30)=B'0000001100000000'
      CURDEF(31)=B'0000001100000000'
      CURDEF(32)=B'0000000000000000'
      CALL HIDE_CURSOR
      CALL SET_MOUSE_GRAPHICS_CURSOR@(HOT_X,HOT_Y,CURDEF)
      CALL DISPLAY_CURSOR
      END

      SUBROUTINE DRAWING_MOUSE
C
C     This subroutine configures the mouse pointer as a star.
C
      INTEGER*2 CURDEF(32),HOT_X,HOT_Y
      HOT_X=7
      HOT_Y=8
      CURDEF( 1)=-1
      CURDEF( 2)=-1
      CURDEF( 3)=-1
      CURDEF( 4)=-1
      CURDEF( 5)=-1
      CURDEF( 6)=-1
      CURDEF( 7)=-1
      CURDEF( 8)=-1
      CURDEF( 9)=-1
      CURDEF(10)=-1
      CURDEF(11)=-1
      CURDEF(12)=-1
      CURDEF(13)=-1
      CURDEF(14)=-1
      CURDEF(15)=-1
      CURDEF(16)=-1
C
      CURDEF(17)=B'0000000000000000'
      CURDEF(18)=B'1000000100000010'
      CURDEF(19)=B'0100000100000100'
      CURDEF(20)=B'0010000100001000'
      CURDEF(21)=B'0001111111110000'
      CURDEF(22)=B'0001111111110000'
      CURDEF(23)=B'0001100000110000'
      CURDEF(24)=B'0001100000110000'
      CURDEF(25)=B'1111100000111111'
      CURDEF(26)=B'0001100000110000'
      CURDEF(27)=B'0001100000110000'
      CURDEF(28)=B'0001111111110000'
      CURDEF(29)=B'0001111111110000'
      CURDEF(30)=B'0010000100001000'
      CURDEF(31)=B'0100000100000100'
      CURDEF(32)=B'1000000100000010'
C
      CALL HIDE_CURSOR
      CALL SET_MOUSE_GRAPHICS_CURSOR@(HOT_X,HOT_Y,CURDEF)
      CALL DISPLAY_CURSOR
      END

      SUBROUTINE FETCH_MOUSE_POS(IH,IV,STATUS)
C
C     This subroutine returns the position of the mouse pointer
C     and the status of the mouse buttons. It also handles the
C     display of the magnify window
C
C     IH,IV is the position of the pointer on the screen.
C
C     STATUS is the status of the buttons.
C
      INCLUDE 'GWINCOM.INS',NOLIST
      INTEGER*2 IH,IV,STATUS,ICOL(5,5),IX,IY,IC,I,J
      INTERNAL PROCEDURE UPDATE_MAG,GET_COLOURS,WRITE_COLOURS
      CALL GET_MOUSE_POSITION@(IH,IV,STATUS)
      IF(SHOW_MAG)THEN
C
C Magnify window needs to be shown
C
         IF(.NOT.MAG_VISIBLE)THEN
C
C Magnify window is not on_screen so needs to be built
C
            CALL BUILD_MAG
            INVOKE UPDATE_MAG
         ELSEIF(IH.NE.LAST_IH.OR.IV.NE.LAST_IV)THEN
C
C Magnify window is on screen so update it
C
            INVOKE UPDATE_MAG
         ENDIF   
      ELSE
C
C Magnify window needs to be removed
C
         CALL REMOVE_MAG
      ENDIF
      LAST_IH=IH
      LAST_IV=IV
      RETURN

      PROCEDURE UPDATE_MAG
C
C Scans the rectangular area inside the drawing cursor
C and writes the results as square "super pixels" of the
C correct colour
C
      CALL HIDE_MOUSE_CURSOR@
      INVOKE GET_COLOURS
      INVOKE WRITE_COLOURS
      CALL DISPLAY_MOUSE_CURSOR@
      EXIT UPDATE_MAG

      PROCEDURE GET_COLOURS
C
C Reads the 5x5 block of pixel values inside the drawing cursor
C
      IY=IV-3
      DO 1 I=1,5
         IY=IY+1
         IX=IH-2
         DO 1 J=1,5
            IF(IX.LT.0.OR.IX.GE.640.OR.IY.LT.0.OR.IY.GE.480)THEN
               IC=0
            ELSE
               CALL GET_PIXEL@(IX,IY,IC)
            ENDIF
            ICOL(I,J)=AND(IC,127)
            IX=IX+1
1           CONTINUE
      EXIT GET_COLOURS
      
      PROCEDURE WRITE_COLOURS
C
C Writes 5x5 square "super pixels" into the magnify window grid
C
      IY=MAG_Y+3
      DO 2 I=1,5
         IX=MAG_X+3
         DO 3 J=1,5
            CALL FILL_RECTANGLE@(IX,IY,IX+19,IY+19,ICOL(I,J))
            IX=IX+23
3           CONTINUE
         IY=IY+23
2        CONTINUE
      EXIT WRITE_COLOURS    
      END

      SUBROUTINE BUILD_MAG
C
C Builds the magnify window grid at the current position
C The centre "super pixel" is emphasised with a double frame
C as it is the current cursor position
C
      INCLUDE 'GWINCOM.INS',NOLIST
      INTEGER*2 IY,IX,I
      CALL HIDE_MOUSE_CURSOR@
C
C Save screen underneath where the magnify window will occupy
C
      CALL GET_SCREEN_BLOCK@(MAG_X,MAG_Y,MAG_X+117,MAG_Y+117,MAG_BUFFER)
C
C Clear the area underneath the magnify window to black
C
      CALL FILL_RECTANGLE@(MAG_X,MAG_Y,MAG_X+117,MAG_Y+117,0)
      IY=MAG_Y+1
C
C Draw in grid lines
C
      DO 1 I=1,6
         CALL DRAW_LINE@(MAG_X+1,IY,MAG_X+116,IY,15)
         IY=IY+23
1     CONTINUE
      IX=MAG_X+1
      DO 2 I=1,6
         CALL DRAW_LINE@(IX,MAG_Y+1,IX,MAG_Y+116,15)
         IX=IX+23
2     CONTINUE
      IX=MAG_X+2+46
      IY=MAG_Y+2+46
C
C Double frame around centre "super pixel"
C
      CALL RECTANGLE@(IX,IY,IX+21,IY+21,15)
      CALL DISPLAY_MOUSE_CURSOR@
      MAG_VISIBLE=.TRUE.
      LAST_IH=-1
      LAST_IV=-1
      END   

      SUBROUTINE REMOVE_MAG
C
C Remove magnify window by restoring the screen area underneath it
C
      INCLUDE 'GWINCOM.INS',NOLIST
      INTEGER*2 ERROR
      IF(MAG_BUFFER.EQ.-1L)RETURN
      CALL HIDE_MOUSE_CURSOR@
      CALL RESTORE_SCREEN_BLOCK@(MAG_X,MAG_Y,MAG_BUFFER,0,ERROR)
      CALL RETURN_STORAGE@(MAG_BUFFER)
      MAG_BUFFER=-1L
      CALL DISPLAY_MOUSE_CURSOR@
      MAG_VISIBLE=.FALSE.
      END

      SUBROUTINE HIDE_CURSOR
C
C     This subroutine hides the mouse pointer and removes
C     the magnification box, if there is one, from the screen.
C
      INCLUDE 'GWINCOM.INS',NOLIST
      CALL REMOVE_MAG
      CALL HIDE_MOUSE_CURSOR@
      END

      SUBROUTINE DISPLAY_CURSOR
C
C     This subroutine displays the mouse pointer on the screen,
C     and updates the magnification box if it is enabled.
C
      INCLUDE 'GWINCOM.INS',NOLIST
      IF(SHOW_MAG)CALL BUILD_MAG
      CALL DISPLAY_MOUSE_CURSOR@
      END

      SUBROUTINE DEBOUNCE_BUTTONS
C
C     This subroutine will absorb all mouse button presses
C     until there is some change in the button status.
C
      INTEGER*2 OLD_STATUS,IH,IV,STATUS
      CALL FETCH_MOUSE_POS(IH,IV,OLD_STATUS)
      STATUS=OLD_STATUS
      WHILE(STATUS.EQ.OLD_STATUS.AND.STATUS.NE.0)DO
         CALL GET_MOUSE_POSITION@(IH,IV,STATUS)
         ENDWHILE
      END
