C
C     ******************************************************************
C     * 							       *
C     *  THIS PROGRAM ILLUSTRATES THE USE OF A NUMBER OF	       *
C     *  LOW LEVEL GRAPHICS PRIMITIVES WHICH ARE NOT		       *
C     *  DESCRIBED IN VERSION A OF THE MANUAL			       *
C     *  IN THE INTERESTS OF SIMPLICITY SUBROUTINE GRAPH	       *
C     *  IS NOT A FULLY SMOOTHED OFF SUBROUTINE AND IS MEANT	       *
C     *  TO BE USED AS AN ILLUSTRATION OF WHAT IS POSSIBLE	       *
C     *  THIS PROGRAM REQUIRES AN EGA OR VGA COLOUR SCREEN	       *
C     *  .							       *
C     *  THE FOLLOWING ADDITIONAL ROUTINES ARE DESCRIBED:	       *
C     *  .							       *
C     *  SUBROUTINE VGA@					       *
C     *  SWITCHES THE SCREEN TO VGA GRAPHICS MODE (18)		       *
C     *  (640 x 480 POINTS,16 COLOURS)				       *
C     *  .							       *
C     *  SUBROUTINE EGA@					       *
C     *  SWITCHES THE SCREEN TO EGA GRAPHICS MODE (16)		       *
C     *  (640 x 350 POINTS,16 COLOURS)				       *
C     *  .							       *
C     *  SUBROUTINE TEXT_MODE@					       *
C     *  SWITCHES BACK TO TEXT MODE. BECAUSE MS-DOS DOES NOT SCROLL    *
C     *  WELL IN VGA GRAPHICS MODE IT IS DESIRABLE TO RETURN TO TEXT   *
C     *  MODE BEFORE LEAVING THE PROGRAM. THE PROGRAM WAITS FOR        *
C     *  YOU TO PRESS A KEY BEFORE CALLING THIS ROUTINE 	       *
C     *  .							       *
C     *  SUBROUTINE DRAW_LINE@(IX1,IY1,IX2,IY2,COLOUR)		       *
C     *  INTEGER*2 IX1,IY1,IX2,IY2,COLOUR			       *
C     *  DRAWS A LINE FROM (IX1,IY1) TO (IX2,IY2) IN THE GIVEN	       *
C     *  COLOUR. SEE THE VGA/EGA MANUAL FOR A DESCRIPTION OF POSSIBLE  *
C     *  COLOUR VALUES, OR USE THE PARAMETERS IN THIS FILE	       *
C     *  NOTE THAT THE COORDINATE SYSTEM STARTS IN THE UPPER	       *
C     *  LEFT HAND CORNER					       *
C     *  .							       *
C     *  SUBROUTINE DRAW_TEXT@(STRING,IX1,IY1,COLOUR)		       *
C     *  INTEGER*2 IX1,IY1,COLOUR				       *
C     *  CHARACTER*(*) STRING					       *
C     *  DRAWS A TEXT STRING ON THE GRAPHICS SCREEN AT THE	       *
C     *  SPECIFIED POINT (TOP LEFT HAND CORNER OF FIRST CHARACTER)     *
C     *  NOTE: THIS ROUTINE IS ACCURATE TO ONE PIXEL POSITION	       *
C     *  BECAUSE IT DOES NOT GO THROUGH BIOS!			       *
C     * 							       *
C     ******************************************************************
C
      CHARACTER*4 SCREEN
      INTEGER*2 XMAX,YMAX
      PARAMETER(NPOINTS=200)
      CHARACTER*20 TITLES(3)
      REAL X(NPOINTS),Y(NPOINTS,3)
      DATA TITLES/'SIN(X)','EXP(-X)','EXP(-X)*SIN(10*X)'/
C
C     ASK THE USER WHAT SORT OF SCREEN HE HAS
C
1     CALL COUA('Say whether EGA or VGA screen: ')
      READ(*,'(A)')SCREEN
      CALL UPCASE(SCREEN)
      IF(SCREEN.EQ.'VGA')THEN
      ELSEIF(SCREEN.EQ.'EGA')THEN
      ELSE
	 GOTO 1
      ENDIF
C
C     PREPARE THE DATA
C
      DO 2 I=1,NPOINTS
	 X(I)=(I-1)/20.0
	 Y(I,1)=SIN(X(I))
	 Y(I,2)=EXP(-X(I))
	 Y(I,3)=EXP(-X(I))*SIN(X(I)*10)
2	 CONTINUE
C
C     SET THE SCREEN IN THE APPROPRIATE MODE
C
      IF(SCREEN.EQ.'VGA')THEN
	 CALL VGA@
      ELSE
	 CALL EGA@
      ENDIF
C
C     DO THE GRAPHS
C
      CALL GRAPH(X,Y,NPOINTS,3,SCREEN,TITLES)
C
C     WAIT FOR THE USER TO PRESS A KEY AND RETURN TO TEXT MODE
C
      CALL GET_KEY@(KEY)
      CALL TEXT_MODE@
      END
      SUBROUTINE GRAPH(X,Y,NPOINTS,NGRAPHS,SCREEN,TITLES)
C
C     ****************************************************
C     * 						 *
C     *  OUTPUT ONE OR MORE GRAPHS TO THE SCREEN	 *
C     *  SCALING ACCORDINGLY				 *
C     *  THIS ROUTINE IS FOR ILLUSTRATIVE PURPOSES ONLY  *
C     *  IT ASSUMES THE X-DATA IS SORTED		 *
C     * 						 *
C     ****************************************************
C
      CHARACTER*(*) SCREEN
      CHARACTER*(*) TITLES(NGRAPHS)
      REAL X(NPOINTS),Y(NPOINTS,NGRAPHS),XMIN,XMAX,YMIN,YMAX
      INTEGER*2 COLOUR(6)
      INTEGER*2 BLACK,BLUE,INVERSE_BLUE,GREEN,INVERSE_GREEN,
     +CYAN,INVERSE_CYAN,RED,INVERSE_RED,MAGENTA,INVERSE_MAGENTA,
     +BROWN,INVERSE_BROWN,YELLOW,INVERSE_YELLOW,WHITE,INVERSE_WHITE,
     +INTENSE,BLINKING
      PARAMETER(BLACK=0)
      PARAMETER(BLUE=1,INVERSE_BLUE=16)
      PARAMETER(GREEN=2,INVERSE_GREEN=32)
      PARAMETER(CYAN=3,INVERSE_CYAN=48)
      PARAMETER(RED=4,INVERSE_RED=64)
      PARAMETER(MAGENTA=5,INVERSE_MAGENTA=80)
      PARAMETER(BROWN=6,INVERSE_BROWN=96)
      PARAMETER(YELLOW=14,INVERSE_YELLOW=8+96)
      PARAMETER(WHITE=7,INVERSE_WHITE=7*16)
      PARAMETER(INTENSE=8)
      PARAMETER(BLINKING=128)
      DATA COLOUR/RED,YELLOW,GREEN,CYAN,BROWN,WHITE/
C
C    DETERMINE THE DATA RANGE
C
      XMAX=X(1)
      YMAX=Y(1,1)
      XMIN=XMAX
      YMIN=YMAX
      DO 1 I=1,NPOINTS
	 XMAX=MAX(XMAX,X(I))
	 XMIN=MIN(XMIN,X(I))
	 DO 1 J=1,NGRAPHS
	    YMAX=MAX(YMAX,Y(I,J))
	    YMIN=MIN(YMIN,Y(I,J))
1	    CONTINUE
C
C     DECIDE WHERE TO PUT THE ORIGIN
C
      IF(XMIN.LT.0)THEN
	 XMAX=MAX(ABS(XMAX),ABS(XMIN))
	 XMIN=-XMAX
	 IX0=640/2
      ELSE
	 XMIN=0
	 IX0=0
      ENDIF
      IF(YMIN.LT.0)THEN
	 YMAX=MAX(ABS(YMAX),ABS(YMIN))
	 YMIN=-YMAX
      ELSE
	 YMIN=0
      ENDIF
      XSCALE=640/(XMAX-XMIN)
      IF(SCREEN.EQ.'VGA')THEN
	 YSCALE=480/(YMAX-YMIN)
	 NYPOINTS=480
      ELSE
	 YSCALE=350/(YMAX-YMIN)
	 NYPOINTS=350
      ENDIF
      IF(YMAX.EQ.0)THEN
	 IY0=0
      ELSE
	 IY0=NYPOINTS/2
      ENDIF
C
C     DRAW THE AXES
C
      CALL DRAW_LINE@(IX0,0,IX0,NYPOINTS-1,WHITE)
      CALL DRAW_LINE@(0,IY0,639,IY0,WHITE)
C
C     AND TICKS
C
      IEPS=10
      DO 2 I=1,10
	 CALL DRAW_LINE@(IX0+IEPS,I*NYPOINTS/10-1,IX0,I*NYPOINTS/10-1,WH
     +ITE)
2	 CALL DRAW_LINE@(I*80-1,IY0+IEPS,I*80-1,IY0,WHITE)
C
C     DRAW THE GRAPHS
C
      DO 4 I=2,NPOINTS
	 IX1=(X(I-1)-XMIN)*XSCALE+0.5
	 IX2=(X(I)-XMIN)*XSCALE+0.5
	 DO 3 J=1,NGRAPHS
	    IY1=(Y(I-1,J)-YMIN)*YSCALE+0.5
	    IY1=NYPOINTS-1-IY1
	    IY2=(Y(I,J)-YMIN)*YSCALE+0.5
	    IY2=NYPOINTS-1-IY2
	    CALL DRAW_LINE@(IX1,IY1,IX2,IY2,COLOUR(J))
3	    CONTINUE
4	 CONTINUE
      IY=NYPOINTS*2/3
      IX=500
      DO 5 J=1,NGRAPHS
	 CALL DRAW_TEXT@(TITLES(J),IX,IY,COLOUR(J))
5	 IY=IY+20
      END
