//
//  Real mode library sample code.
//
#include <stdio.h>

//
//  Data structure used to communicate between real and protected mode.
//  It is very important that this structure is correctly alligned with
//  the common block in the protected mode program.
//
#pragma pack(1)
static struct
{
    long    service_number;
    union
        {
        char    string[10];
        long    integer;
        } u;
}   communication_block;

extern void far FTN77WTC(void *);

void main(void)
{
    puts("\nReal mode library has been loaded.\n");
    while (1)
        {
        FTN77WTC(&communication_block);     // Wait on the protected mode code.
        printf("\nEntered real mode library\n");
        switch (communication_block.service_number)
            {
            case 1:
                puts("Initialisation service");
                break;
            case 2:
                puts("Service 2 called");
                printf("integer = %ld\n", communication_block.u.integer);
                break;
            case 3:
                puts("Service 3 called");
                printf("string = '%s'\n", communication_block.u.string);
                break;
            default:
                printf("Unknown service %d\n", communication_block.service_number);
                break;
            }
        }
}
