;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;     This program can form the basis of a terminate and stay		   ;
;     resident program which is callable from DBOS, and hence from	   ;
;     user fortran code running in protected mode			   ;
;     The program stays resident after obtaining the address of 	   ;
;     the DOSCOM segment, which is also available in protected mode	   ;
;     This code uses int 79 (any unused interrupt could be used)	   ;
;     which is then callable from Fortran thus: 			   ;
;     CODE								   ;
;     <fill DOSCOM with required information>				   ;
;     PUSH  EBX%							   ;
;     PUSH  EBP%							   ;
;     <load registers with any additional information>			   ;
;     SVC   3								   ;
;     DB    z'78'                                                          ;
;     POP   EBP%							   ;
;     POP   EBX%							   ;
;     <save away any results as required>				   ;
;     EDOC								   ;
;									   ;
;     PLEASE NOTE THE FOLLOWING:					   ;
;									   ;
;     a)	DBOS must be resident first				   ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
stack	   segment   para stack 'stack'
	   db	     64 dup('stack   ')
stkend	   db	     0
stack	   ends
cseg	   segment   para public 'code'
start	   proc      far
key_int    equ	     16h
interface_int equ    79h
	   assume    cs:cseg,ss:stack,es:nothing
	   jmp	     go
;
;      data placed here to avoid phase errors!
;
adoscom dw	     0,0
psploc	dw	     0
go:	   push      ds 	     ;Set return segment addr to stack
	   sub	     ax,ax	     ;Clear a reg
	   push      ax 	     ;Put zero return addr to stack
	   mov	     ax,cseg	     ;Get location of workarea
	   mov	     bx,ds	     ;Save pointer to PSP
	   mov	     ds,ax	     ;Set segreg base of data workarea
	   mov	     cs:psploc,bx
	   push      bp
      mov	ax,0
      mov	es,ax
      mov	cx,es:[(interface_int*4)]
      mov	dx,es:[(interface_int*4+2)]
      mov	word ptr es:[(interface_int*4)],offset interface
      mov	word ptr es:[interface_int*4+2],cseg
;
;     record the location of the doscom segment
;
      mov	ah,1dh	       ;Code to ask for DOSCOM address in ES:BP
      int	78h	       ;Warning! DBOS must be loaded
      mov	adoscom,bp
      mov	adoscom[2],es
;
;     terminate and stay resident
;
      mov	dx,offset top_of_memory
      add	dx,15
      mov	cl,4
      shr	dx,cl
      mov	bx,cs
      add	dx,bx
      sub	dx,psploc
      mov	ax,3100h ;terminate and stay resident
      int	21h

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;									  ;
;     THIS IS THE INT 79 INTERFACE WHICH USES INFORMATION PLACED	  ;
;     IN THE 16-BIT REGISTERS BY THE USER'S PROGRAM EXECUTING IN          ;
;     PROTECTED MODE, PLUS THE INFORMATION STORED BY THE USER'S           ;
;     PROGRAM IN DOSCOM INFORMATION CAN BE RETURNED TO THE PROGRAM	  ;
;     BY THE SAME MEANS 						  ;
;									  ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

interface:
      int	5		;just testing!
      iret			;return to DBOS
top_of_memory db     0
start	   endp
cseg	   ends
	   end	     start
