'------------------------------------------------------------------------------
'
' WININET.INC -- 32-bit Windows API Declarations for PowerBASIC
'
' Copyright (C) 1999-2001 PowerBASIC, Inc.
' Portions Copyright (C) 1994-1999 Microsoft Corporation
'
' Last Update: December 7, 2001
'
'------------------------------------------------------------------------------

#IF NOT %DEF(%WININET_INC)

%WININET_INC = 1

#IF NOT %DEF(%WINAPI)
    #INCLUDE "WIN32API.INC"
#ENDIF



'
' common per-API flags (new APIs)
'

%WININET_API_FLAG_ASYNC       = &H00000001  ' force async operation
%WININET_API_FLAG_SYNC        = &H00000004  ' force sync operation
%WININET_API_FLAG_USE_CONTEXT = &H00000008  ' use value supplied in dwContext (even if 0)

%FTP_TRANSFER_TYPE_UNKNOWN    = &H00000000
%FTP_TRANSFER_TYPE_ASCII      = &H00000001
%FTP_TRANSFER_TYPE_BINARY     = &H00000002

%FTP_TRANSFER_TYPE_MASK       = %FTP_TRANSFER_TYPE_ASCII _
                             OR %FTP_TRANSFER_TYPE_BINARY

'
' the default major/minor HTTP version numbers
'

%HTTP_MAJOR_VERSION      = 1
%HTTP_MINOR_VERSION      = 0

$HTTP_VERSION            = "HTTP/1.0"

'
' HttpQueryInfo info levels. Generally, there is one info level
' for each potential RFC822/HTTP/MIME header that an HTTP server
' may send as part of a request response.
'
' The HTTP_QUERY_RAW_HEADERS info level is provided for clients
' that choose to perform their own header parsing.
'

%HTTP_QUERY_MIME_VERSION                 = 0
%HTTP_QUERY_CONTENT_TYPE                 = 1
%HTTP_QUERY_CONTENT_TRANSFER_ENCODING    = 2
%HTTP_QUERY_CONTENT_ID                   = 3
%HTTP_QUERY_CONTENT_DESCRIPTION          = 4
%HTTP_QUERY_CONTENT_LENGTH               = 5
%HTTP_QUERY_CONTENT_LANGUAGE             = 6
%HTTP_QUERY_ALLOW                        = 7
%HTTP_QUERY_PUBLIC                       = 8
%HTTP_QUERY_DATE                         = 9
%HTTP_QUERY_EXPIRES                      = 10
%HTTP_QUERY_LAST_MODIFIED                = 11
%HTTP_QUERY_MESSAGE_ID                   = 12
%HTTP_QUERY_URI                          = 13
%HTTP_QUERY_DERIVED_FROM                 = 14
%HTTP_QUERY_COST                         = 15
%HTTP_QUERY_LINK                         = 16
%HTTP_QUERY_PRAGMA                       = 17
%HTTP_QUERY_VERSION                      = 18  ' special: part of status line
%HTTP_QUERY_STATUS_CODE                  = 19  ' special: part of status line
%HTTP_QUERY_STATUS_TEXT                  = 20  ' special: part of status line
%HTTP_QUERY_RAW_HEADERS                  = 21  ' special: all headers as ASCIIZ
%HTTP_QUERY_RAW_HEADERS_CRLF             = 22  ' special: all headers
%HTTP_QUERY_CONNECTION                   = 23
%HTTP_QUERY_ACCEPT                       = 24
%HTTP_QUERY_ACCEPT_CHARSET               = 25
%HTTP_QUERY_ACCEPT_ENCODING              = 26
%HTTP_QUERY_ACCEPT_LANGUAGE              = 27
%HTTP_QUERY_AUTHORIZATION                = 28
%HTTP_QUERY_CONTENT_ENCODING             = 29
%HTTP_QUERY_FORWARDED                    = 30
%HTTP_QUERY_FROM                         = 31
%HTTP_QUERY_IF_MODIFIED_SINCE            = 32
%HTTP_QUERY_LOCATION                     = 33
%HTTP_QUERY_ORIG_URI                     = 34
%HTTP_QUERY_REFERER                      = 35
%HTTP_QUERY_RETRY_AFTER                  = 36
%HTTP_QUERY_SERVER                       = 37
%HTTP_QUERY_TITLE                        = 38
%HTTP_QUERY_USER_AGENT                   = 39
%HTTP_QUERY_WWW_AUTHENTICATE             = 40
%HTTP_QUERY_PROXY_AUTHENTICATE           = 41
%HTTP_QUERY_ACCEPT_RANGES                = 42
%HTTP_QUERY_SET_COOKIE                   = 43
%HTTP_QUERY_COOKIE                       = 44
%HTTP_QUERY_REQUEST_METHOD               = 45  ' special: GET/POST etc.
%HTTP_QUERY_REFRESH                      = 46
%HTTP_QUERY_CONTENT_DISPOSITION          = 47

'
' HTTP 1.1 defined headers
'

%HTTP_QUERY_AGE                          = 48
%HTTP_QUERY_CACHE_CONTROL                = 49
%HTTP_QUERY_CONTENT_BASE                 = 50
%HTTP_QUERY_CONTENT_LOCATION             = 51
%HTTP_QUERY_CONTENT_MD5                  = 52
%HTTP_QUERY_CONTENT_RANGE                = 53
%HTTP_QUERY_ETAG                         = 54
%HTTP_QUERY_HOST                         = 55
%HTTP_QUERY_IF_MATCH                     = 56
%HTTP_QUERY_IF_NONE_MATCH                = 57
%HTTP_QUERY_IF_RANGE                     = 58
%HTTP_QUERY_IF_UNMODIFIED_SINCE          = 59
%HTTP_QUERY_MAX_FORWARDS                 = 60
%HTTP_QUERY_PROXY_AUTHORIZATION          = 61
%HTTP_QUERY_RANGE                        = 62
%HTTP_QUERY_TRANSFER_ENCODING            = 63
%HTTP_QUERY_UPGRADE                      = 64
%HTTP_QUERY_VARY                         = 65
%HTTP_QUERY_VIA                          = 66
%HTTP_QUERY_WARNING                      = 67

%HTTP_QUERY_MAX                          = 67

'
' HTTP_QUERY_CUSTOM - if this special value is supplied as the dwInfoLevel
' parameter of HttpQueryInfo() then the lpBuffer parameter contains the name
' of the header we are to query
'

%HTTP_QUERY_CUSTOM                       = 65535

'
' HTTP_QUERY_FLAG_REQUEST_HEADERS - if this bit is set in the dwInfoLevel
' parameter of HttpQueryInfo() then the request headers will be queried for the
' request information
'

%HTTP_QUERY_FLAG_REQUEST_HEADERS         = &H80000000

'
' HTTP_QUERY_FLAG_SYSTEMTIME - if this bit is set in the dwInfoLevel parameter
' of HttpQueryInfo() AND the header being queried contains date information,
' e.g. the "Expires:" header then lpBuffer will contain a SYSTEMTIME structure
' containing the date and time information converted from the header string
'

%HTTP_QUERY_FLAG_SYSTEMTIME              = &H40000000

'
' HTTP_QUERY_FLAG_NUMBER - if this bit is set in the dwInfoLevel parameter of
' HttpQueryInfo(), then the value of the header will be converted to a number
' before being returned to the caller, if applicable
'

%HTTP_QUERY_FLAG_NUMBER                  = &H20000000

'
' HTTP_QUERY_FLAG_COALESCE - combine the values from several headers of the
' same name into the output buffer
'

%HTTP_QUERY_FLAG_COALESCE                = &H10000000


%HTTP_QUERY_MODIFIER_FLAGS_MASK          = %HTTP_QUERY_FLAG_REQUEST_HEADERS _
                                         OR %HTTP_QUERY_FLAG_SYSTEMTIME     _
                                         OR %HTTP_QUERY_FLAG_NUMBER         _
                                         OR %HTTP_QUERY_FLAG_COALESCE

%HTTP_QUERY_HEADER_MASK                  = NOT %HTTP_QUERY_MODIFIER_FLAGS_MASK

'
' HTTP Response Status Codes:
'

%HTTP_STATUS_CONTINUE            = 100 ' OK to continue with request
%HTTP_STATUS_SWITCH_PROTOCOLS    = 101 ' server has switched protocols in upgrade header

%HTTP_STATUS_OK                  = 200 ' request completed
%HTTP_STATUS_CREATED             = 201 ' object created, reason = new URI
%HTTP_STATUS_ACCEPTED            = 202 ' async completion (TBS)
%HTTP_STATUS_PARTIAL             = 203 ' partial completion
%HTTP_STATUS_NO_CONTENT          = 204 ' no info to return
%HTTP_STATUS_RESET_CONTENT       = 205 ' request completed, but clear form
%HTTP_STATUS_PARTIAL_CONTENT     = 206 ' partial GET furfilled

%HTTP_STATUS_AMBIGUOUS           = 300 ' server couldn't decide what to return
%HTTP_STATUS_MOVED               = 301 ' object permanently moved
%HTTP_STATUS_REDIRECT            = 302 ' object temporarily moved
%HTTP_STATUS_REDIRECT_METHOD     = 303 ' redirection w/ new access method
%HTTP_STATUS_NOT_MODIFIED        = 304 ' if-modified-since was not modified
%HTTP_STATUS_USE_PROXY           = 305 ' redirection to proxy, location header specifies proxy to use
%HTTP_STATUS_REDIRECT_KEEP_VERB  = 307 ' HTTP/1.1: keep same verb

%HTTP_STATUS_BAD_REQUEST         = 400 ' invalid syntax
%HTTP_STATUS_DENIED              = 401 ' access denied
%HTTP_STATUS_PAYMENT_REQ         = 402 ' payment required
%HTTP_STATUS_FORBIDDEN           = 403 ' request forbidden
%HTTP_STATUS_NOT_FOUND           = 404 ' object not found
%HTTP_STATUS_BAD_METHOD          = 405 ' method is not allowed
%HTTP_STATUS_NONE_ACCEPTABLE     = 406 ' no response acceptable to client found
%HTTP_STATUS_PROXY_AUTH_REQ      = 407 ' proxy authentication required
%HTTP_STATUS_REQUEST_TIMEOUT     = 408 ' server timed out waiting for request
%HTTP_STATUS_CONFLICT            = 409 ' user should resubmit with more info
%HTTP_STATUS_GONE                = 410 ' the resource is no longer available
%HTTP_STATUS_LENGTH_REQUIRED     = 411 ' the server refused to accept request w/o a length
%HTTP_STATUS_PRECOND_FAILED      = 412 ' precondition given in request failed
%HTTP_STATUS_REQUEST_TOO_LARGE   = 413 ' request entity was too large
%HTTP_STATUS_URI_TOO_LONG        = 414 ' request URI too long
%HTTP_STATUS_UNSUPPORTED_MEDIA   = 415 ' unsupported media type

%HTTP_STATUS_SERVER_ERROR        = 500 ' internal server error
%HTTP_STATUS_NOT_SUPPORTED       = 501 ' required not supported
%HTTP_STATUS_BAD_GATEWAY         = 502 ' error response received from gateway
%HTTP_STATUS_SERVICE_UNAVAIL     = 503 ' temporarily overloaded
%HTTP_STATUS_GATEWAY_TIMEOUT     = 504 ' timed out waiting for gateway
%HTTP_STATUS_VERSION_NOT_SUP     = 505 ' HTTP version not supported

%HTTP_STATUS_FIRST               = %HTTP_STATUS_CONTINUE
%HTTP_STATUS_LAST                = %HTTP_STATUS_VERSION_NOT_SUP

'
' values for dwModifiers parameter of HttpAddRequestHeaders()
'

%HTTP_ADDREQ_INDEX_MASK      = &H0000FFFF
%HTTP_ADDREQ_FLAGS_MASK      = &HFFFF0000

'
' HTTP_ADDREQ_FLAG_ADD_IF_NEW - the header will only be added if it doesn't
' already exist
'

%HTTP_ADDREQ_FLAG_ADD_IF_NEW = &H10000000

'
' HTTP_ADDREQ_FLAG_ADD - if HTTP_ADDREQ_FLAG_REPLACE is set but the header is
' not found then if this flag is set, the header is added anyway, so long as
' there is a valid header-value
'

%HTTP_ADDREQ_FLAG_ADD        = &H20000000

'
' HTTP_ADDREQ_FLAG_COALESCE - coalesce headers with same name. e.g.
' "Accept: text/*" and "Accept: audio/*" with this flag results in a single
' header: "Accept: text/*, audio/*"
'

%HTTP_ADDREQ_FLAG_COALESCE_WITH_COMMA       = &H40000000
%HTTP_ADDREQ_FLAG_COALESCE_WITH_SEMICOLON   = &H01000000
%HTTP_ADDREQ_FLAG_COALESCE                  = %HTTP_ADDREQ_FLAG_COALESCE_WITH_COMMA

'
' HTTP_ADDREQ_FLAG_REPLACE - replaces the specified header. Only one header can
' be supplied in the buffer. If the header to be replaced is not the first
' in a list of headers with the same name, then the relative index should be
' supplied in the low 8 bits of the dwModifiers parameter. If the header-value
' part is missing, then the header is removed
'

%HTTP_ADDREQ_FLAG_REPLACE    = &H80000000

'
' flags for HttpSendRequestEx(), HttpEndRequest()
'

%HSR_ASYNC       = %WININET_API_FLAG_ASYNC         ' force async
%HSR_SYNC        = %WININET_API_FLAG_SYNC          ' force sync
%HSR_USE_CONTEXT = %WININET_API_FLAG_USE_CONTEXT   ' use dwContext value
%HSR_INITIATE    = &H00000008                      ' iterative operation (completed by HttpEndRequest)
%HSR_DOWNLOAD    = &H00000010                      ' download to file
%HSR_CHUNKED     = &H00000020                      ' operation is send of chunked data

%FLAG_ICC_FORCE_CONNECTION       = &H00000001

'
' Internet API error returns
'

%INTERNET_ERROR_BASE                     = 12000

%ERROR_INTERNET_OUT_OF_HANDLES           = %INTERNET_ERROR_BASE + 1
%ERROR_INTERNET_TIMEOUT                  = %INTERNET_ERROR_BASE + 2
%ERROR_INTERNET_EXTENDED_ERROR           = %INTERNET_ERROR_BASE + 3
%ERROR_INTERNET_INTERNAL_ERROR           = %INTERNET_ERROR_BASE + 4
%ERROR_INTERNET_INVALID_URL              = %INTERNET_ERROR_BASE + 5
%ERROR_INTERNET_UNRECOGNIZED_SCHEME      = %INTERNET_ERROR_BASE + 6
%ERROR_INTERNET_NAME_NOT_RESOLVED        = %INTERNET_ERROR_BASE + 7
%ERROR_INTERNET_PROTOCOL_NOT_FOUND       = %INTERNET_ERROR_BASE + 8
%ERROR_INTERNET_INVALID_OPTION           = %INTERNET_ERROR_BASE + 9
%ERROR_INTERNET_BAD_OPTION_LENGTH        = %INTERNET_ERROR_BASE + 10
%ERROR_INTERNET_OPTION_NOT_SETTABLE      = %INTERNET_ERROR_BASE + 11
%ERROR_INTERNET_SHUTDOWN                 = %INTERNET_ERROR_BASE + 12
%ERROR_INTERNET_INCORRECT_USER_NAME      = %INTERNET_ERROR_BASE + 13
%ERROR_INTERNET_INCORRECT_PASSWORD       = %INTERNET_ERROR_BASE + 14
%ERROR_INTERNET_LOGIN_FAILURE            = %INTERNET_ERROR_BASE + 15
%ERROR_INTERNET_INVALID_OPERATION        = %INTERNET_ERROR_BASE + 16
%ERROR_INTERNET_OPERATION_CANCELLED      = %INTERNET_ERROR_BASE + 17
%ERROR_INTERNET_INCORRECT_HANDLE_TYPE    = %INTERNET_ERROR_BASE + 18
%ERROR_INTERNET_INCORRECT_HANDLE_STATE   = %INTERNET_ERROR_BASE + 19
%ERROR_INTERNET_NOT_PROXY_REQUEST        = %INTERNET_ERROR_BASE + 20
%ERROR_INTERNET_REGISTRY_VALUE_NOT_FOUND = %INTERNET_ERROR_BASE + 21
%ERROR_INTERNET_BAD_REGISTRY_PARAMETER   = %INTERNET_ERROR_BASE + 22
%ERROR_INTERNET_NO_DIRECT_ACCESS         = %INTERNET_ERROR_BASE + 23
%ERROR_INTERNET_NO_CONTEXT               = %INTERNET_ERROR_BASE + 24
%ERROR_INTERNET_NO_CALLBACK              = %INTERNET_ERROR_BASE + 25
%ERROR_INTERNET_REQUEST_PENDING          = %INTERNET_ERROR_BASE + 26
%ERROR_INTERNET_INCORRECT_FORMAT         = %INTERNET_ERROR_BASE + 27
%ERROR_INTERNET_ITEM_NOT_FOUND           = %INTERNET_ERROR_BASE + 28
%ERROR_INTERNET_CANNOT_CONNECT           = %INTERNET_ERROR_BASE + 29
%ERROR_INTERNET_CONNECTION_ABORTED       = %INTERNET_ERROR_BASE + 30
%ERROR_INTERNET_CONNECTION_RESET         = %INTERNET_ERROR_BASE + 31
%ERROR_INTERNET_FORCE_RETRY              = %INTERNET_ERROR_BASE + 32
%ERROR_INTERNET_INVALID_PROXY_REQUEST    = %INTERNET_ERROR_BASE + 33
%ERROR_INTERNET_NEED_UI                  = %INTERNET_ERROR_BASE + 34

%ERROR_INTERNET_HANDLE_EXISTS            = %INTERNET_ERROR_BASE + 36
%ERROR_INTERNET_SEC_CERT_DATE_INVALID    = %INTERNET_ERROR_BASE + 37
%ERROR_INTERNET_SEC_CERT_CN_INVALID      = %INTERNET_ERROR_BASE + 38
%ERROR_INTERNET_HTTP_TO_HTTPS_ON_REDIR   = %INTERNET_ERROR_BASE + 39
%ERROR_INTERNET_HTTPS_TO_HTTP_ON_REDIR   = %INTERNET_ERROR_BASE + 40
%ERROR_INTERNET_MIXED_SECURITY           = %INTERNET_ERROR_BASE + 41
%ERROR_INTERNET_CHG_POST_IS_NON_SECURE   = %INTERNET_ERROR_BASE + 42
%ERROR_INTERNET_POST_IS_NON_SECURE       = %INTERNET_ERROR_BASE + 43
%ERROR_INTERNET_CLIENT_AUTH_CERT_NEEDED  = %INTERNET_ERROR_BASE + 44
%ERROR_INTERNET_INVALID_CA               = %INTERNET_ERROR_BASE + 45
%ERROR_INTERNET_CLIENT_AUTH_NOT_SETUP    = %INTERNET_ERROR_BASE + 46
%ERROR_INTERNET_ASYNC_THREAD_FAILED      = %INTERNET_ERROR_BASE + 47
%ERROR_INTERNET_REDIRECT_SCHEME_CHANGE   = %INTERNET_ERROR_BASE + 48
%ERROR_INTERNET_DIALOG_PENDING           = %INTERNET_ERROR_BASE + 49
%ERROR_INTERNET_RETRY_DIALOG             = %INTERNET_ERROR_BASE + 50
%ERROR_INTERNET_HTTPS_HTTP_SUBMIT_REDIR  = %INTERNET_ERROR_BASE + 52
%ERROR_INTERNET_INSERT_CDROM             = %INTERNET_ERROR_BASE + 53


'
' FTP API errors
'

%ERROR_FTP_TRANSFER_IN_PROGRESS          = %INTERNET_ERROR_BASE + 110
%ERROR_FTP_DROPPED                       = %INTERNET_ERROR_BASE + 111
%ERROR_FTP_NO_PASSIVE_MODE               = %INTERNET_ERROR_BASE + 112

'
' gopher API errors
'

%ERROR_GOPHER_PROTOCOL_ERROR             = %INTERNET_ERROR_BASE + 130
%ERROR_GOPHER_NOT_FILE                   = %INTERNET_ERROR_BASE + 131
%ERROR_GOPHER_DATA_ERROR                 = %INTERNET_ERROR_BASE + 132
%ERROR_GOPHER_END_OF_DATA                = %INTERNET_ERROR_BASE + 133
%ERROR_GOPHER_INVALID_LOCATOR            = %INTERNET_ERROR_BASE + 134
%ERROR_GOPHER_INCORRECT_LOCATOR_TYPE     = %INTERNET_ERROR_BASE + 135
%ERROR_GOPHER_NOT_GOPHER_PLUS            = %INTERNET_ERROR_BASE + 136
%ERROR_GOPHER_ATTRIBUTE_NOT_FOUND        = %INTERNET_ERROR_BASE + 137
%ERROR_GOPHER_UNKNOWN_LOCATOR            = %INTERNET_ERROR_BASE + 138

'
' HTTP API errors
'

%ERROR_HTTP_HEADER_NOT_FOUND             = %INTERNET_ERROR_BASE + 150
%ERROR_HTTP_DOWNLEVEL_SERVER             = %INTERNET_ERROR_BASE + 151
%ERROR_HTTP_INVALID_SERVER_RESPONSE      = %INTERNET_ERROR_BASE + 152
%ERROR_HTTP_INVALID_HEADER               = %INTERNET_ERROR_BASE + 153
%ERROR_HTTP_INVALID_QUERY_REQUEST        = %INTERNET_ERROR_BASE + 154
%ERROR_HTTP_HEADER_ALREADY_EXISTS        = %INTERNET_ERROR_BASE + 155
%ERROR_HTTP_REDIRECT_FAILED              = %INTERNET_ERROR_BASE + 156
%ERROR_HTTP_NOT_REDIRECTED               = %INTERNET_ERROR_BASE + 160
%ERROR_HTTP_COOKIE_NEEDS_CONFIRMATION    = %INTERNET_ERROR_BASE + 161
%ERROR_HTTP_COOKIE_DECLINED              = %INTERNET_ERROR_BASE + 162
%ERROR_HTTP_REDIRECT_NEEDS_CONFIRMATION  = %INTERNET_ERROR_BASE + 168

'
' additional Internet API error codes
'

%ERROR_INTERNET_SECURITY_CHANNEL_ERROR   = %INTERNET_ERROR_BASE + 157
%ERROR_INTERNET_UNABLE_TO_CACHE_FILE     = %INTERNET_ERROR_BASE + 158
%ERROR_INTERNET_TCPIP_NOT_INSTALLED      = %INTERNET_ERROR_BASE + 159
%ERROR_INTERNET_DISCONNECTED             = %INTERNET_ERROR_BASE + 163
%ERROR_INTERNET_SERVER_UNREACHABLE       = %INTERNET_ERROR_BASE + 164
%ERROR_INTERNET_PROXY_SERVER_UNREACHABLE = %INTERNET_ERROR_BASE + 165

%ERROR_INTERNET_BAD_AUTO_PROXY_SCRIPT    = %INTERNET_ERROR_BASE + 166
%ERROR_INTERNET_UNABLE_TO_DOWNLOAD_SCRIPT = %INTERNET_ERROR_BASE + 167
%ERROR_INTERNET_SEC_INVALID_CERT    = %INTERNET_ERROR_BASE + 169
%ERROR_INTERNET_SEC_CERT_REVOKED    = %INTERNET_ERROR_BASE + 170

' InternetAutodial specific errors

%ERROR_INTERNET_FAILED_DUETOSECURITYCHECK  = %INTERNET_ERROR_BASE + 171

%INTERNET_ERROR_LAST        = %ERROR_INTERNET_FAILED_DUETOSECURITYCHECK


'
' URLCACHE APIs
'

'
' datatype definitions.
'

'
' cache entry type flags.
'

%NORMAL_CACHE_ENTRY              = &H00000001
%COOKIE_CACHE_ENTRY              = &H00100000
%URLHISTORY_CACHE_ENTRY          = &H00200000
%TRACK_OFFLINE_CACHE_ENTRY       = &H00000010
%TRACK_ONLINE_CACHE_ENTRY        = &H00000020
%STICKY_CACHE_ENTRY              = &H00000004
%SPARSE_CACHE_ENTRY              = &H00010000



%URLCACHE_FIND_DEFAULT_FILTER    = %NORMAL_CACHE_ENTRY _
                                   OR %COOKIE_CACHE_ENTRY _
                                   OR %URLHISTORY_CACHE_ENTRY _
                                   OR %TRACK_OFFLINE_CACHE_ENTRY _
                                   OR %TRACK_ONLINE_CACHE_ENTRY _
                                   OR %STICKY_CACHE_ENTRY

%CACHE_ENTRY_ATTRIBUTE_FC    = &H00000004
%CACHE_ENTRY_HITRATE_FC      = &H00000010
%CACHE_ENTRY_MODTIME_FC      = &H00000040
%CACHE_ENTRY_EXPTIME_FC      = &H00000080
%CACHE_ENTRY_ACCTIME_FC      = &H00000100
%CACHE_ENTRY_SYNCTIME_FC     = &H00000200
%CACHE_ENTRY_HEADERINFO_FC   = &H00000400
%CACHE_ENTRY_EXEMPT_DELTA_FC = &H00000800

' Flags for SetUrlCacheEntryGroup
%INTERNET_CACHE_GROUP_ADD      = 0
%INTERNET_CACHE_GROUP_REMOVE   = 1

' Flags for InternetDial - must not conflict with InternetAutodial flags
'                          as they are valid here also.

%INTERNET_DIAL_UNATTENDED       = &H8000

%INTERENT_GOONLINE_REFRESH = &H00000001
%INTERENT_GOONLINE_MASK = &H00000001

' Flags for InternetAutodial
%INTERNET_AUTODIAL_FORCE_ONLINE          = 1
%INTERNET_AUTODIAL_FORCE_UNATTENDED      = 2
%INTERNET_AUTODIAL_FAILIFSECURITYCHECK   = 4

%INTERNET_AUTODIAL_FLAGS_MASK        = %INTERNET_AUTODIAL_FORCE_ONLINE _
                                    OR %INTERNET_AUTODIAL_FORCE_UNATTENDED _
                                    OR %INTERNET_AUTODIAL_FAILIFSECURITYCHECK

' Flags for InternetGetConnectedState
%INTERNET_CONNECTION_MODEM           = 1
%INTERNET_CONNECTION_LAN             = 2
%INTERNET_CONNECTION_PROXY           = 4
%INTERNET_CONNECTION_MODEM_BUSY      = 8

'
' Custom dial handler functions
'

' Flags for custom dial handler
%INTERNET_CUSTOMDIAL_CONNECT         = 0
%INTERNET_CUSTOMDIAL_UNATTENDED      = 1
%INTERNET_CUSTOMDIAL_DISCONNECT      = 2
%INTERNET_CUSTOMDIAL_SHOWOFFLINE     = 4

' Custom dial handler supported functionality flags
%INTERNET_CUSTOMDIAL_SAFE_FOR_UNATTENDED = 1
%INTERNET_CUSTOMDIAL_WILL_SUPPLY_STATE   = 2
%INTERNET_CUSTOMDIAL_CAN_HANGUP          = 4

' States for InternetSetDialState
%INTERNET_DIALSTATE_DISCONNECTED     = 1

%INTERNET_INVALID_PORT_NUMBER  = 0       ' use the protocol-specific default

%INTERNET_DEFAULT_FTP_PORT     = 21      ' default for FTP servers
%INTERNET_DEFAULT_GOPHER_PORT  = 70      '    "     "  gopher "
%INTERNET_DEFAULT_HTTP_PORT    = 80      '    "     "  HTTP   "
%INTERNET_DEFAULT_HTTPS_PORT   = 443     '    "     "  HTTPS  "
%INTERNET_DEFAULT_SOCKS_PORT   = 1080    ' default for SOCKS firewall servers.


'
' maximum field lengths (arbitrary)
'

%INTERNET_MAX_HOST_NAME_LENGTH   = 256
%INTERNET_MAX_USER_NAME_LENGTH   = 128
%INTERNET_MAX_PASSWORD_LENGTH    = 128
%INTERNET_MAX_PORT_NUMBER_LENGTH = 5     ' %INTERNET_PORT is unsigned short
%INTERNET_MAX_PORT_NUMBER_VALUE  = 65535 ' maximum unsigned short value
%INTERNET_MAX_PATH_LENGTH        = 2048
%INTERNET_MAX_SCHEME_LENGTH      = 32    ' longest protocol name length
%INTERNET_MAX_URL_LENGTH         = (%INTERNET_MAX_SCHEME_LENGTH _
                                        + 3 _ ' sizeof("://")
                                        + %INTERNET_MAX_PATH_LENGTH)

'
' values returned by InternetQueryOption() with INTERNET_OPTION_KEEP_CONNECTION:
'

%INTERNET_KEEP_ALIVE_UNKNOWN     = &HFFFFFFFF???   ' ((DWORD)-1)
%INTERNET_KEEP_ALIVE_ENABLED     = 1
%INTERNET_KEEP_ALIVE_DISABLED    = 0

'
' flags returned by InternetQueryOption() with INTERNET_OPTION_REQUEST_FLAGS
'

%INTERNET_REQFLAG_FROM_CACHE     = &H00000001  ' response came from cache
%INTERNET_REQFLAG_ASYNC          = &H00000002  ' request was made asynchronously
%INTERNET_REQFLAG_VIA_PROXY      = &H00000004  ' request was made via a proxy
%INTERNET_REQFLAG_NO_HEADERS     = &H00000008  ' orginal response contained no headers
%INTERNET_REQFLAG_PASSIVE        = &H00000010  ' FTP: passive-mode connection
%INTERNET_REQFLAG_CACHE_WRITE_DISABLED = &H00000040  ' HTTPS: this request not cacheable

'
' flags common to open functions (not InternetOpen()):
'

%INTERNET_FLAG_RELOAD            = &H80000000  ' retrieve the original item

'
' flags for InternetOpenUrl():
'

%INTERNET_FLAG_RAW_DATA          = &H40000000  ' FTP/gopher find: receive the item as raw (structured) data
%INTERNET_FLAG_EXISTING_CONNECT  = &H20000000  ' FTP: use existing InternetConnect handle for server if possible

'
' flags for InternetOpen():
'

%INTERNET_FLAG_ASYNC             = &H10000000  ' this request is asynchronous (where supported)

'
' protocol-specific flags:
'

%INTERNET_FLAG_PASSIVE           = &H08000000  ' used for FTP connections

'
' additional cache flags
'

%INTERNET_FLAG_NO_CACHE_WRITE    = &H04000000  ' don't write this item to the cache
%INTERNET_FLAG_DONT_CACHE        = %INTERNET_FLAG_NO_CACHE_WRITE
%INTERNET_FLAG_MAKE_PERSISTENT   = &H02000000  ' make this item persistent in cache
%INTERNET_FLAG_FROM_CACHE        = &H01000000  ' use offline semantics
%INTERNET_FLAG_OFFLINE           = %INTERNET_FLAG_FROM_CACHE

'
' additional flags
'

%INTERNET_FLAG_SECURE            = &H00800000  ' use PCT/SSL if applicable (HTTP)
%INTERNET_FLAG_KEEP_CONNECTION   = &H00400000  ' use keep-alive semantics
%INTERNET_FLAG_NO_AUTO_REDIRECT  = &H00200000  ' don't handle redirections automatically
%INTERNET_FLAG_READ_PREFETCH     = &H00100000  ' do background read prefetch
%INTERNET_FLAG_NO_COOKIES        = &H00080000  ' no automatic cookie handling
%INTERNET_FLAG_NO_AUTH           = &H00040000  ' no automatic authentication handling
%INTERNET_FLAG_CACHE_IF_NET_FAIL = &H00010000  ' return cache file if net request fails

'
' Security Ignore Flags, Allow HttpOpenRequest to overide
'  Secure Channel (SSL/PCT) failures of the following types.
'

%INTERNET_FLAG_IGNORE_REDIRECT_TO_HTTP   = &H00008000 ' ex: https:// to http://
%INTERNET_FLAG_IGNORE_REDIRECT_TO_HTTPS  = &H00004000 ' ex: http:// to https://
%INTERNET_FLAG_IGNORE_CERT_DATE_INVALID  = &H00002000 ' expired X509 Cert.
%INTERNET_FLAG_IGNORE_CERT_CN_INVALID    = &H00001000 ' bad common name in X509 Cert.

'
' more caching flags
'

%INTERNET_FLAG_RESYNCHRONIZE     = &H00000800  ' asking wininet to update an item if it is newer
%INTERNET_FLAG_HYPERLINK         = &H00000400  ' asking wininet to do hyperlinking semantic which works right for scripts
%INTERNET_FLAG_NO_UI             = &H00000200  ' no cookie popup
%INTERNET_FLAG_PRAGMA_NOCACHE    = &H00000100  ' asking wininet to add "pragma: no-cache"
%INTERNET_FLAG_CACHE_ASYNC       = &H00000080  ' ok to perform lazy cache-write
%INTERNET_FLAG_FORMS_SUBMIT      = &H00000040  ' this is a forms submit
%INTERNET_FLAG_NEED_FILE         = &H00000010  ' need a file for this request
%INTERNET_FLAG_MUST_CACHE_REQUEST = %INTERNET_FLAG_NEED_FILE

'
' flags for FTP
'

%INTERNET_FLAG_TRANSFER_ASCII    = %FTP_TRANSFER_TYPE_ASCII     ' &H00000001
%INTERNET_FLAG_TRANSFER_BINARY   = %FTP_TRANSFER_TYPE_BINARY    ' &H00000002

'
' flags field masks
'

%SECURITY_INTERNET_MASK  = %INTERNET_FLAG_IGNORE_CERT_CN_INVALID    OR  _
                           %INTERNET_FLAG_IGNORE_CERT_DATE_INVALID  OR  _
                           %INTERNET_FLAG_IGNORE_REDIRECT_TO_HTTPS  OR  _
                           %INTERNET_FLAG_IGNORE_REDIRECT_TO_HTTP

%INTERNET_FLAGS_MASK     = %INTERNET_FLAG_RELOAD               _
                           OR %INTERNET_FLAG_RAW_DATA          _
                           OR %INTERNET_FLAG_EXISTING_CONNECT  _
                           OR %INTERNET_FLAG_ASYNC             _
                           OR %INTERNET_FLAG_PASSIVE           _
                           OR %INTERNET_FLAG_NO_CACHE_WRITE    _
                           OR %INTERNET_FLAG_MAKE_PERSISTENT   _
                           OR %INTERNET_FLAG_FROM_CACHE        _
                           OR %INTERNET_FLAG_SECURE            _
                           OR %INTERNET_FLAG_KEEP_CONNECTION   _
                           OR %INTERNET_FLAG_NO_AUTO_REDIRECT  _
                           OR %INTERNET_FLAG_READ_PREFETCH     _
                           OR %INTERNET_FLAG_NO_COOKIES        _
                           OR %INTERNET_FLAG_NO_AUTH           _
                           OR %INTERNET_FLAG_CACHE_IF_NET_FAIL _
                           OR %SECURITY_INTERNET_MASK          _
                           OR %INTERNET_FLAG_RESYNCHRONIZE     _
                           OR %INTERNET_FLAG_HYPERLINK         _
                           OR %INTERNET_FLAG_NO_UI             _
                           OR %INTERNET_FLAG_PRAGMA_NOCACHE    _
                           OR %INTERNET_FLAG_CACHE_ASYNC       _
                           OR %INTERNET_FLAG_FORMS_SUBMIT      _
                           OR %INTERNET_FLAG_NEED_FILE         _
                           OR %INTERNET_FLAG_TRANSFER_BINARY   _
                           OR %INTERNET_FLAG_TRANSFER_ASCII

%INTERNET_ERROR_MASK_INSERT_CDROM     = &H1

%INTERNET_OPTIONS_MASK    = NOT %INTERNET_FLAGS_MASK

'
' INTERNET_NO_CALLBACK - if this value is presented as the dwContext parameter
' then no call-backs will be made for that API
'

%INTERNET_NO_CALLBACK            = 0

'
' structures/types
'

'
' INTERNET_SCHEME - enumerated URL scheme type
'

%INTERNET_SCHEME_PARTIAL  = -2
%INTERNET_SCHEME_UNKNOWN  = -1
%INTERNET_SCHEME_DEFAULT  = 0
%INTERNET_SCHEME_FTP      = 1
%INTERNET_SCHEME_GOPHER   = 2
%INTERNET_SCHEME_HTTP     = 3
%INTERNET_SCHEME_HTTPS    = 4
%INTERNET_SCHEME_FILE     = 5
%INTERNET_SCHEME_NEWS     = 6
%INTERNET_SCHEME_MAILTO   = 7
%INTERNET_SCHEME_SOCKS    = 8
%INTERNET_SCHEME_FIRST    = %INTERNET_SCHEME_FTP
%INTERNET_SCHEME_LAST     = %INTERNET_SCHEME_SOCKS

'
' flags for INTERNET_CONNECTED_INFO dwFlags
'

'
' ISO_FORCE_DISCONNECTED - if set when putting Wininet into disconnected mode,
' all outstanding requests will be aborted with a cancelled error
'

%ISO_FORCE_DISCONNECTED = &H00000001


'
' Internet UI
'

'
' InternetErrorDlg - Provides UI for certain Errors.
'

%FLAGS_ERROR_UI_FILTER_FOR_ERRORS        = &H01
%FLAGS_ERROR_UI_FLAGS_CHANGE_OPTIONS     = &H02
%FLAGS_ERROR_UI_FLAGS_GENERATE_DATA      = &H04
%FLAGS_ERROR_UI_FLAGS_NO_UI              = &H08
%FLAGS_ERROR_UI_SERIALIZE_DIALOGS        = &H10

'
' constants for InternetTimeFromSystemTime
'

%INTERNET_RFC1123_FORMAT     = 0
%INTERNET_RFC1123_BUFSIZE   = 30

'
' flags for InternetCrackUrl() and InternetCreateUrl()
'

%ICU_ESCAPE      = &H80000000  ' (un)escape URL characters
%ICU_USERNAME    = &H40000000  ' use internal username & password

'
' flags for InternetCanonicalizeUrl() and InternetCombineUrl()
'

%ICU_NO_ENCODE   = &H20000000  ' Don't convert unsafe characters to escape sequence
%ICU_DECODE      = &H10000000  ' Convert %XX escape sequences to characters
%ICU_NO_META     = &H08000000  ' Don't convert .. etc. meta path sequences
%ICU_ENCODE_SPACES_ONLY = &H04000000  ' Encode spaces only
%ICU_BROWSER_MODE = &H02000000 ' Special encode/decode rules for browser

'
' access types for InternetOpen()
'

%INTERNET_OPEN_TYPE_PRECONFIG                    = 0   ' use registry configuration
%INTERNET_OPEN_TYPE_DIRECT                       = 1   ' direct to net
%INTERNET_OPEN_TYPE_PROXY                        = 3   ' via named proxy
%INTERNET_OPEN_TYPE_PRECONFIG_WITH_NO_AUTOPROXY  = 4   ' prevent using java/script/INS

'
' old names for access types
'

%PRE_CONFIG_INTERNET_ACCESS  = %INTERNET_OPEN_TYPE_PRECONFIG
%LOCAL_INTERNET_ACCESS       = %INTERNET_OPEN_TYPE_DIRECT
%CERN_PROXY_INTERNET_ACCESS  = %INTERNET_OPEN_TYPE_PROXY


'
' service types for InternetConnect()
'

%INTERNET_SERVICE_URL    = 0
%INTERNET_SERVICE_FTP    = 1
%INTERNET_SERVICE_GOPHER = 2
%INTERNET_SERVICE_HTTP   = 3

'
' flags for InternetSetOptionEx()
'

%ISO_GLOBAL      = &H00000001  ' modify option globally
%ISO_REGISTRY    = &H00000002  ' write option to registry (where applicable)

%ISO_VALID_FLAGS = %ISO_GLOBAL OR %ISO_REGISTRY

'
' options manifests for Internet{Query OR Set}Option
'

%INTERNET_OPTION_CALLBACK                = 1
%INTERNET_OPTION_CONNECT_TIMEOUT         = 2
%INTERNET_OPTION_CONNECT_RETRIES         = 3
%INTERNET_OPTION_CONNECT_BACKOFF         = 4
%INTERNET_OPTION_SEND_TIMEOUT            = 5
%INTERNET_OPTION_CONTROL_SEND_TIMEOUT    = %INTERNET_OPTION_SEND_TIMEOUT
%INTERNET_OPTION_RECEIVE_TIMEOUT         = 6
%INTERNET_OPTION_CONTROL_RECEIVE_TIMEOUT = %INTERNET_OPTION_RECEIVE_TIMEOUT
%INTERNET_OPTION_DATA_SEND_TIMEOUT       = 7
%INTERNET_OPTION_DATA_RECEIVE_TIMEOUT    = 8
%INTERNET_OPTION_HANDLE_TYPE             = 9
%INTERNET_OPTION_LISTEN_TIMEOUT          = 11
%INTERNET_OPTION_READ_BUFFER_SIZE        = 12
%INTERNET_OPTION_WRITE_BUFFER_SIZE       = 13

%INTERNET_OPTION_ASYNC_ID                = 15
%INTERNET_OPTION_ASYNC_PRIORITY          = 16

%INTERNET_OPTION_PARENT_HANDLE           = 21
%INTERNET_OPTION_KEEP_CONNECTION         = 22
%INTERNET_OPTION_REQUEST_FLAGS           = 23
%INTERNET_OPTION_EXTENDED_ERROR          = 24

%INTERNET_OPTION_OFFLINE_MODE            = 26
%INTERNET_OPTION_CACHE_STREAM_HANDLE     = 27
%INTERNET_OPTION_USERNAME                = 28
%INTERNET_OPTION_PASSWORD                = 29
%INTERNET_OPTION_ASYNC                   = 30
%INTERNET_OPTION_SECURITY_FLAGS          = 31
%INTERNET_OPTION_SECURITY_CERTIFICATE_STRUCT = 32
%INTERNET_OPTION_DATAFILE_NAME           = 33
%INTERNET_OPTION_URL                     = 34
%INTERNET_OPTION_SECURITY_CERTIFICATE    = 35
%INTERNET_OPTION_SECURITY_KEY_BITNESS    = 36
%INTERNET_OPTION_REFRESH                 = 37
%INTERNET_OPTION_PROXY                   = 38
%INTERNET_OPTION_SETTINGS_CHANGED        = 39
%INTERNET_OPTION_VERSION                 = 40
%INTERNET_OPTION_USER_AGENT              = 41
%INTERNET_OPTION_END_BROWSER_SESSION     = 42
%INTERNET_OPTION_PROXY_USERNAME          = 43
%INTERNET_OPTION_PROXY_PASSWORD          = 44
%INTERNET_OPTION_CONTEXT_VALUE           = 45
%INTERNET_OPTION_CONNECT_LIMIT           = 46
%INTERNET_OPTION_SECURITY_SELECT_CLIENT_CERT = 47
%INTERNET_OPTION_POLICY                  = 48
%INTERNET_OPTION_DISCONNECTED_TIMEOUT    = 49
%INTERNET_OPTION_CONNECTED_STATE         = 50
%INTERNET_OPTION_IDLE_STATE              = 51
%INTERNET_OPTION_OFFLINE_SEMANTICS       = 52
%INTERNET_OPTION_SECONDARY_CACHE_KEY     = 53
%INTERNET_OPTION_CALLBACK_FILTER         = 54
%INTERNET_OPTION_CONNECT_TIME            = 55
%INTERNET_OPTION_SEND_THROUGHPUT         = 56
%INTERNET_OPTION_RECEIVE_THROUGHPUT      = 57
%INTERNET_OPTION_REQUEST_PRIORITY        = 58
%INTERNET_OPTION_HTTP_VERSION            = 59
%INTERNET_OPTION_RESET_URLCACHE_SESSION  = 60
%INTERNET_OPTION_ERROR_MASK              = 62

%INTERNET_FIRST_OPTION                   = %INTERNET_OPTION_CALLBACK
%INTERNET_LAST_OPTION                    = %INTERNET_OPTION_ERROR_MASK


'
' values for INTERNET_OPTION_PRIORITY
'

%INTERNET_PRIORITY_FOREGROUND            = 1000

'
' handle types
'

%INTERNET_HANDLE_TYPE_INTERNET           = 1
%INTERNET_HANDLE_TYPE_CONNECT_FTP        = 2
%INTERNET_HANDLE_TYPE_CONNECT_GOPHER     = 3
%INTERNET_HANDLE_TYPE_CONNECT_HTTP       = 4
%INTERNET_HANDLE_TYPE_FTP_FIND           = 5
%INTERNET_HANDLE_TYPE_FTP_FIND_HTML      = 6
%INTERNET_HANDLE_TYPE_FTP_FILE           = 7
%INTERNET_HANDLE_TYPE_FTP_FILE_HTML      = 8
%INTERNET_HANDLE_TYPE_GOPHER_FIND        = 9
%INTERNET_HANDLE_TYPE_GOPHER_FIND_HTML   = 10
%INTERNET_HANDLE_TYPE_GOPHER_FILE        = 11
%INTERNET_HANDLE_TYPE_GOPHER_FILE_HTML   = 12
%INTERNET_HANDLE_TYPE_HTTP_REQUEST       = 13

'
' values for %INTERNET_OPTION_SECURITY_FLAGS
'

' query only
%SECURITY_FLAG_SECURE                    = &H00000001 ' can query only
%SECURITY_FLAG_STRENGTH_WEAK             = &H10000000
%SECURITY_FLAG_STRENGTH_MEDIUM           = &H40000000
%SECURITY_FLAG_STRENGTH_STRONG           = &H20000000
%SECURITY_FLAG_UNKNOWNBIT                = &H80000000
%SECURITY_FLAG_NORMALBITNESS             = %SECURITY_FLAG_STRENGTH_WEAK



' The following are unused
%SECURITY_FLAG_SSL                       = &H00000002
%SECURITY_FLAG_SSL3                      = &H00000004
%SECURITY_FLAG_PCT                       = &H00000008
%SECURITY_FLAG_PCT4                      = &H00000010
%SECURITY_FLAG_IETFSSL4                  = &H00000020

' The following are for backwards compatability only.
%SECURITY_FLAG_40BIT                     = %SECURITY_FLAG_STRENGTH_WEAK
%SECURITY_FLAG_128BIT                    = %SECURITY_FLAG_STRENGTH_STRONG
%SECURITY_FLAG_56BIT                     = %SECURITY_FLAG_STRENGTH_MEDIUM


' setable flags
%SECURITY_FLAG_IGNORE_REVOCATION         = &H00000080
%SECURITY_FLAG_IGNORE_UNKNOWN_CA         = &H00000100
%SECURITY_FLAG_IGNORE_WRONG_USAGE        = &H00000200

%SECURITY_FLAG_IGNORE_CERT_CN_INVALID    = %INTERNET_FLAG_IGNORE_CERT_CN_INVALID
%SECURITY_FLAG_IGNORE_CERT_DATE_INVALID  = %INTERNET_FLAG_IGNORE_CERT_DATE_INVALID


%SECURITY_FLAG_IGNORE_REDIRECT_TO_HTTPS  = %INTERNET_FLAG_IGNORE_REDIRECT_TO_HTTPS
%SECURITY_FLAG_IGNORE_REDIRECT_TO_HTTP   = %INTERNET_FLAG_IGNORE_REDIRECT_TO_HTTP



%SECURITY_SET_MASK       = %SECURITY_FLAG_IGNORE_REVOCATION  OR _
                           %SECURITY_FLAG_IGNORE_UNKNOWN_CA  OR _
                           %SECURITY_FLAG_IGNORE_CERT_CN_INVALID  OR _
                           %SECURITY_FLAG_IGNORE_CERT_DATE_INVALID  OR _
                           %SECURITY_FLAG_IGNORE_WRONG_USAGE

'
' flags for InternetReadFileEx()
'

%IRF_ASYNC       = %WININET_API_FLAG_ASYNC
%IRF_SYNC        = %WININET_API_FLAG_SYNC
%IRF_USE_CONTEXT = %WININET_API_FLAG_USE_CONTEXT
%IRF_NO_WAIT     = &H00000008

'
' status manifests for Internet status callback
'

%INTERNET_STATUS_RESOLVING_NAME          = 10
%INTERNET_STATUS_NAME_RESOLVED           = 11
%INTERNET_STATUS_CONNECTING_TO_SERVER    = 20
%INTERNET_STATUS_CONNECTED_TO_SERVER     = 21
%INTERNET_STATUS_SENDING_REQUEST         = 30
%INTERNET_STATUS_REQUEST_SENT            = 31
%INTERNET_STATUS_RECEIVING_RESPONSE      = 40
%INTERNET_STATUS_RESPONSE_RECEIVED       = 41
%INTERNET_STATUS_CTL_RESPONSE_RECEIVED   = 42
%INTERNET_STATUS_PREFETCH                = 43
%INTERNET_STATUS_CLOSING_CONNECTION      = 50
%INTERNET_STATUS_CONNECTION_CLOSED       = 51
%INTERNET_STATUS_HANDLE_CREATED          = 60
%INTERNET_STATUS_HANDLE_CLOSING          = 70
%INTERNET_STATUS_REQUEST_COMPLETE        = 100
%INTERNET_STATUS_REDIRECT                = 110
%INTERNET_STATUS_INTERMEDIATE_RESPONSE   = 120
%INTERNET_STATUS_STATE_CHANGE            = 200

'
' the following can be indicated in a state change notification:
'

%INTERNET_STATE_CONNECTED                = &H00000001  ' connected state (mutually exclusive with disconnected)
%INTERNET_STATE_DISCONNECTED             = &H00000002  ' disconnected from network
%INTERNET_STATE_DISCONNECTED_BY_USER     = &H00000010  ' disconnected by user request
%INTERNET_STATE_IDLE                     = &H00000100  ' no network requests being made (by Wininet)
%INTERNET_STATE_BUSY                     = &H00000200  ' network requests being made (by Wininet)


'
' if the following value is returned by InternetSetStatusCallback, then
' probably an invalid (non-code) address was supplied for the callback
'

%INTERNET_INVALID_STATUS_CALLBACK        = -1&


'
' Gopher
'

'
' string field lengths (in characters, not bytes)
'

%MAX_GOPHER_DISPLAY_TEXT     = 128
%MAX_GOPHER_SELECTOR_TEXT    = 256
%MAX_GOPHER_HOST_NAME        = %INTERNET_MAX_HOST_NAME_LENGTH
%MAX_GOPHER_LOCATOR_LENGTH   = 1                                   _
                               + %MAX_GOPHER_DISPLAY_TEXT          _
                               + 1                                 _
                               + %MAX_GOPHER_SELECTOR_TEXT         _
                               + 1                                 _
                               + %MAX_GOPHER_HOST_NAME             _
                               + 1                                 _
                               + %INTERNET_MAX_PORT_NUMBER_LENGTH  _
                               + 1                                 _
                               + 1                                 _
                               + 2

'
' manifests for GopherType
'

%GOPHER_TYPE_TEXT_FILE       = &H00000001
%GOPHER_TYPE_DIRECTORY       = &H00000002
%GOPHER_TYPE_CSO             = &H00000004
%GOPHER_TYPE_ERROR           = &H00000008
%GOPHER_TYPE_MAC_BINHEX      = &H00000010
%GOPHER_TYPE_DOS_ARCHIVE     = &H00000020
%GOPHER_TYPE_UNIX_UUENCODED  = &H00000040
%GOPHER_TYPE_INDEX_SERVER    = &H00000080
%GOPHER_TYPE_TELNET          = &H00000100
%GOPHER_TYPE_BINARY          = &H00000200
%GOPHER_TYPE_REDUNDANT       = &H00000400
%GOPHER_TYPE_TN3270          = &H00000800
%GOPHER_TYPE_GIF             = &H00001000
%GOPHER_TYPE_IMAGE           = &H00002000
%GOPHER_TYPE_BITMAP          = &H00004000
%GOPHER_TYPE_MOVIE           = &H00008000
%GOPHER_TYPE_SOUND           = &H00010000
%GOPHER_TYPE_HTML            = &H00020000
%GOPHER_TYPE_PDF             = &H00040000
%GOPHER_TYPE_CALENDAR        = &H00080000
%GOPHER_TYPE_INLINE          = &H00100000
%GOPHER_TYPE_UNKNOWN         = &H20000000
%GOPHER_TYPE_ASK             = &H40000000
%GOPHER_TYPE_GOPHER_PLUS     = &H80000000

%MAX_GOPHER_CATEGORY_NAME    = 128     ' arbitrary
%MAX_GOPHER_ATTRIBUTE_NAME   = 128     '     "
%MIN_GOPHER_ATTRIBUTE_LENGTH = 256     '     "

'
' known gopher attribute categories. See below for ordinals
'

$GOPHER_INFO_CATEGORY        = "+INFO"
$GOPHER_ADMIN_CATEGORY       = "+ADMIN"
$GOPHER_VIEWS_CATEGORY       = "+VIEWS"
$GOPHER_ABSTRACT_CATEGORY    = "+ABSTRACT"
$GOPHER_VERONICA_CATEGORY    = "+VERONICA"

'
' known gopher attributes. These are the attribute names as defined in the
' gopher+ protocol document
'

$GOPHER_ADMIN_ATTRIBUTE      = "Admin"
$GOPHER_MOD_DATE_ATTRIBUTE   = "Mod-Date"
$GOPHER_TTL_ATTRIBUTE        = "TTL"
$GOPHER_SCORE_ATTRIBUTE      = "Score"
$GOPHER_RANGE_ATTRIBUTE      = "Score-range"
$GOPHER_SITE_ATTRIBUTE       = "Site"
$GOPHER_ORG_ATTRIBUTE        = "Org"
$GOPHER_LOCATION_ATTRIBUTE   = "Loc"
$GOPHER_GEOG_ATTRIBUTE       = "Geog"
$GOPHER_TIMEZONE_ATTRIBUTE   = "TZ"
$GOPHER_PROVIDER_ATTRIBUTE   = "Provider"
$GOPHER_VERSION_ATTRIBUTE    = "Version"
$GOPHER_ABSTRACT_ATTRIBUTE   = "Abstract"
$GOPHER_VIEW_ATTRIBUTE       = "View"
$GOPHER_TREEWALK_ATTRIBUTE   = "treewalk"

'
' identifiers for attribute strings
'

%GOPHER_ATTRIBUTE_ID_BASE        = &Habcccc00

%GOPHER_CATEGORY_ID_ALL          = %GOPHER_ATTRIBUTE_ID_BASE + 1

%GOPHER_CATEGORY_ID_INFO         = %GOPHER_ATTRIBUTE_ID_BASE + 2
%GOPHER_CATEGORY_ID_ADMIN        = %GOPHER_ATTRIBUTE_ID_BASE + 3
%GOPHER_CATEGORY_ID_VIEWS        = %GOPHER_ATTRIBUTE_ID_BASE + 4
%GOPHER_CATEGORY_ID_ABSTRACT     = %GOPHER_ATTRIBUTE_ID_BASE + 5
%GOPHER_CATEGORY_ID_VERONICA     = %GOPHER_ATTRIBUTE_ID_BASE + 6
%GOPHER_CATEGORY_ID_ASK          = %GOPHER_ATTRIBUTE_ID_BASE + 7

%GOPHER_CATEGORY_ID_UNKNOWN      = %GOPHER_ATTRIBUTE_ID_BASE + 8

%GOPHER_ATTRIBUTE_ID_ALL         = %GOPHER_ATTRIBUTE_ID_BASE + 9

%GOPHER_ATTRIBUTE_ID_ADMIN       = %GOPHER_ATTRIBUTE_ID_BASE + 10
%GOPHER_ATTRIBUTE_ID_MOD_DATE    = %GOPHER_ATTRIBUTE_ID_BASE + 11
%GOPHER_ATTRIBUTE_ID_TTL         = %GOPHER_ATTRIBUTE_ID_BASE + 12
%GOPHER_ATTRIBUTE_ID_SCORE       = %GOPHER_ATTRIBUTE_ID_BASE + 13
%GOPHER_ATTRIBUTE_ID_RANGE       = %GOPHER_ATTRIBUTE_ID_BASE + 14
%GOPHER_ATTRIBUTE_ID_SITE        = %GOPHER_ATTRIBUTE_ID_BASE + 15
%GOPHER_ATTRIBUTE_ID_ORG         = %GOPHER_ATTRIBUTE_ID_BASE + 16
%GOPHER_ATTRIBUTE_ID_LOCATION    = %GOPHER_ATTRIBUTE_ID_BASE + 17
%GOPHER_ATTRIBUTE_ID_GEOG        = %GOPHER_ATTRIBUTE_ID_BASE + 18
%GOPHER_ATTRIBUTE_ID_TIMEZONE    = %GOPHER_ATTRIBUTE_ID_BASE + 19
%GOPHER_ATTRIBUTE_ID_PROVIDER    = %GOPHER_ATTRIBUTE_ID_BASE + 20
%GOPHER_ATTRIBUTE_ID_VERSION     = %GOPHER_ATTRIBUTE_ID_BASE + 21
%GOPHER_ATTRIBUTE_ID_ABSTRACT    = %GOPHER_ATTRIBUTE_ID_BASE + 22
%GOPHER_ATTRIBUTE_ID_VIEW        = %GOPHER_ATTRIBUTE_ID_BASE + 23
%GOPHER_ATTRIBUTE_ID_TREEWALK    = %GOPHER_ATTRIBUTE_ID_BASE + 24

%GOPHER_ATTRIBUTE_ID_UNKNOWN     = %GOPHER_ATTRIBUTE_ID_BASE + 25

'
' GOPHER_TYPE_FILE_MASK - use this to determine if a locator identifies a
' (known) file type
'

%GOPHER_TYPE_FILE_MASK       = %GOPHER_TYPE_TEXT_FILE          _
                             OR %GOPHER_TYPE_MAC_BINHEX        _
                             OR %GOPHER_TYPE_DOS_ARCHIVE       _
                             OR %GOPHER_TYPE_UNIX_UUENCODED    _
                             OR %GOPHER_TYPE_BINARY            _
                             OR %GOPHER_TYPE_GIF               _
                             OR %GOPHER_TYPE_IMAGE             _
                             OR %GOPHER_TYPE_BITMAP            _
                             OR %GOPHER_TYPE_MOVIE             _
                             OR %GOPHER_TYPE_SOUND             _
                             OR %GOPHER_TYPE_HTML              _
                             OR %GOPHER_TYPE_PDF               _
                             OR %GOPHER_TYPE_CALENDAR          _
                             OR %GOPHER_TYPE_INLINE

'
' If SERIALIZE_DIALOGS flag set, client should implement thread-safe non-blocking callback...
'

'
' ... and last parameter of InternetErrorDlg should point to...
'

TYPE INTERNET_AUTH_NOTIFY_DATA
    cbStruct AS DWORD             ' size of this structure
    dwOptions AS DWORD            ' reserved: must be set to 0
    pfnNotify AS DWORD            ' notification callback to retry InternetErrorDlg
    dwContext AS DWORD            ' context to pass to to notification function
END TYPE


TYPE INTERNET_CACHE_ENTRY_INFO
    dwStructSize AS DWORD             ' version of cache system.
    lpszSourceUrlName AS ASCIIZ PTR   ' embedded pointer to the URL name string.
    lpszLocalFileName AS ASCIIZ PTR   ' embedded pointer to the local file name.
    CacheEntryType AS DWORD           ' cache type bit mask.
    dwUseCount AS DWORD               ' current users count of the cache entry.
    dwHitRate AS DWORD                ' num of times the cache entry was retrieved.
    dwSizeLow AS DWORD                ' low DWORD of the file size.
    dwSizeHigh AS DWORD               ' high DWORD of the file size.
    LastModifiedTime AS FILETIME      ' last modified time of the file in GMT format.
    ExpireTime AS FILETIME            ' expire time of the file in GMT format
    LastAccessTime AS FILETIME        ' last accessed time in GMT format
    LastSyncTime AS FILETIME          ' last time the URL was synchronized with the source
    lpHeaderInfo AS BYTE PTR          ' embedded pointer to the header info.
    dwHeaderInfoSize AS DWORD         ' size of the above header.
    lpszFileExtension AS ASCIIZ PTR   ' File extension used to retrieve the urldata as a file.
    dwExemptDelta AS DWORD            ' Exemption delta from last access time.
END TYPE

' INTERNET_ASYNC_RESULT - this structure is returned to the application via
' the callback with INTERNET_STATUS_REQUEST_COMPLETE. It is not sufficient to
' just return the result of the async operation. If the API failed then the
' app cannot call GetLastError() because the thread context will be incorrect.
' Both the value returned by the async API and any resultant error code are
' made available. The app need not check dwError if dwResult indicates that
' the API succeeded (in this case dwError will be ERROR_SUCCESS)

TYPE INTERNET_ASYNC_RESULT DWORD
    dwResult AS DWORD   ' the HINTERNET, DWORD, or BOOL return code from an async API
    dwError  AS DWORD   ' the error code if the API failed
END TYPE


' INTERNET_PROXY_INFO - structure supplied with INTERNET_OPTION_PROXY to get/
' set proxy information on a InternetOpen() handle

TYPE INTERNET_PROXY_INFO DWORD
    dwAccessType AS DWORD         ' dwAccessType - INTERNET_OPEN_TYPE_DIRECT,
                                  '                INTERNET_OPEN_TYPE_PROXY,
                                  '             or INTERNET_OPEN_TYPE_PRECONFIG
                                  ' (set only)
    lpszProxy AS ASCIIZ PTR       ' lpszProxy - proxy server list
    lpszProxyBypass AS ASCIIZ PTR ' lpszProxyBypass - proxy bypass list
END TYPE


'
' INTERNET_VERSION_INFO - version information returned via
' InternetQueryOption(..., INTERNET_OPTION_VERSION, ...)
'

TYPE INTERNET_VERSION_INFO DWORD
    dwMajorVersion AS DWORD
    dwMinorVersion AS DWORD
END TYPE


'
' HTTP_VERSION_INFO - query or set global HTTP version (1.0 or 1.1)
'

TYPE HTTP_VERSION_INFO DWORD
    dwMajorVersion AS DWORD
    dwMinorVersion AS DWORD
END TYPE

'
' INTERNET_CONNECTED_INFO - information used to set the global connected state
'

TYPE INTERNET_CONNECTED_INFO DWORD
    '
    ' dwConnectedState - new connected/disconnected state.
    ' See INTERNET_STATE_CONNECTED, etc.
    '
    dwConnectedState AS DWORD
    '
    ' dwFlags - flags controlling connected->disconnected (or disconnected->
    ' connected) transition. See below
    '
    dwFlags AS DWORD
END TYPE

'
' URL_COMPONENTS - the constituent parts of an URL. Used in InternetCrackUrl()
' and InternetCreateUrl()
'
' For InternetCrackUrl(), if a pointer field and its corresponding length field
' are both 0 then that component is not returned. If the pointer field is NULL
' but the length field is not zero, then both the pointer and length fields are
' returned if both pointer and corresponding length fields are non-zero then
' the pointer field points to a buffer where the component is copied. The
' component may be un-escaped, depending on dwFlags
'
' For InternetCreateUrl(), the pointer fields should be NULL if the component
' is not required. If the corresponding length field is zero then the pointer
' field is the address of a zero-terminated string. If the length field is not
' zero then it is the string length of the corresponding pointer field
'

TYPE URL_COMPONENTS DWORD
    dwStructSize AS DWORD       ' size of this structure. Used in version check
    lpszScheme AS ASCIIZ PTR    ' pointer to scheme name
    dwSchemeLength AS DWORD     ' length of scheme name
    nScheme AS DWORD            ' enumerated scheme type (if known)
    lpszHostName AS ASCIIZ PTR  ' pointer to host name
    dwHostNameLength AS DWORD   ' length of host name
    nPort AS WORD               ' converted port number
    lpszUserName AS ASCIIZ PTR  ' pointer to user name
    dwUserNameLength AS DWORD   ' length of user name
    lpszPassword AS ASCIIZ PTR  ' pointer to password
    dwPasswordLength AS DWORD   ' length of password
    lpszUrlPath AS ASCIIZ PTR   ' pointer to URL-path
    dwUrlPathLength AS DWORD    ' length of URL-path
    lpszExtraInfo AS ASCIIZ PTR ' pointer to extra information (e.g. ?foo or #foo)
    dwExtraInfoLength AS DWORD  ' length of extra information
END TYPE


'
' INTERNET_CERTIFICATE_INFO lpBuffer - contains the certificate returned from
' the server
'

TYPE INTERNET_CERTIFICATE_INFO DWORD
    '
    ' ftExpiry - date the certificate expires.
    '

    ftExpiry AS FILETIME

    '
    ' ftStart - date the certificate becomes valid.
    '

    ftStart AS FILETIME

    '
    ' lpszSubjectInfo - the name of organization, site, and server
    '   the cert. was issued for.
    '

    lpszSubjectInfo AS ASCIIZ PTR

    '
    ' lpszIssuerInfo - the name of orgainzation, site, and server
    '   the cert was issues by.
    '

    lpszIssuerInfo AS ASCIIZ PTR

    '
    ' lpszProtocolName - the name of the protocol used to provide the secure
    '   connection.
    '

    lpszProtocolName AS ASCIIZ PTR

    '
    ' lpszSignatureAlgName - the name of the algorithm used for signing
    '  the certificate.
    '

    lpszSignatureAlgName AS ASCIIZ PTR

    '
    ' lpszEncryptionAlgName - the name of the algorithm used for
    '  doing encryption over the secure channel (SSL/PCT) connection.
    '

    lpszEncryptionAlgName AS ASCIIZ PTR

    '
    ' dwKeySize - size of the key.
    '

    dwKeySize AS DWORD

END TYPE


'
' INTERNET_BUFFERS - combines headers and data. May be chained for e.g. file
' upload or scatter/gather operations. For chunked read/write, lpcszHeader
' contains the chunked-ext
'

TYPE INTERNET_BUFFERS DWORD
    dwStructSize AS DWORD          ' used for API versioning. Set to sizeof(INTERNET_BUFFERS)
    pNext AS INTERNET_BUFFERS PTR  ' chain of buffers
    lpcszHeader AS ASCIIZ PTR      ' pointer to headers (may be NULL)
    dwHeadersLength AS DWORD       ' length of headers if not NULL
    dwHeadersTotal AS DWORD        ' size of headers if not enough buffer
    lpvBuffer AS BYTE PTR          ' pointer to data buffer (may be NULL)
    dwBufferLength AS DWORD        ' length of data buffer if not NULL
    dwBufferTotal AS DWORD         ' total size of chunk, or content-length if not chunked
    dwOffsetLow AS DWORD           ' used for read-ranges (only used in HttpSendRequest2)
    dwOffsetHigh AS DWORD
END TYPE

'
' GOPHER_FIND_DATA - returns the results of a GopherFindFirstFile()/
' InternetFindNextFile() request
'

TYPE GOPHER_FIND_DATA
    DisplayString AS ASCIIZ * %MAX_GOPHER_DISPLAY_TEXT + 1
    GopherType AS DWORD
    SizeLow AS DWORD
    SizeHigh AS DWORD
    LastModificationTime AS FILETIME
    Locator AS ASCIIZ * %MAX_GOPHER_LOCATOR_LENGTH + 1
END TYPE

'
' structured gopher attributes (as defined in gopher+ protocol document)
'

TYPE GOPHER_ADMIN_ATTRIBUTE_TYPE DWORD
    Comment AS ASCIIZ PTR
    EmailAddress AS ASCIIZ PTR
END TYPE

TYPE GOPHER_MOD_DATE_ATTRIBUTE_TYPE DWORD
    DateAndTime AS FILETIME
END TYPE

TYPE GOPHER_TTL_ATTRIBUTE_TYPE DWORD
    Ttl AS DWORD
END TYPE

TYPE GOPHER_SCORE_ATTRIBUTE_TYPE DWORD
    Score AS INTEGER
END TYPE

TYPE GOPHER_SCORE_RANGE_ATTRIBUTE_TYPE DWORD
    LowerBound AS INTEGER
    UpperBound AS INTEGER
END TYPE

TYPE GOPHER_SITE_ATTRIBUTE_TYPE DWORD
    Site AS ASCIIZ PTR
END TYPE

TYPE GOPHER_ORGANIZATION_ATTRIBUTE_TYPE DWORD
    Organization AS ASCIIZ PTR
END TYPE

TYPE GOPHER_LOCATION_ATTRIBUTE_TYPE DWORD
    Location AS ASCIIZ PTR
END TYPE

TYPE GOPHER_GEOGRAPHICAL_LOCATION_ATTRIBUTE_TYPE DWORD
    DegreesNorth AS INTEGER
    MinutesNorth AS INTEGER
    SecondsNorth AS INTEGER
    DegreesEast AS INTEGER
    MinutesEast AS INTEGER
    SecondsEast AS INTEGER
END TYPE

TYPE GOPHER_TIMEZONE_ATTRIBUTE_TYPE DWORD
    Zone AS INTEGER
END TYPE

TYPE GOPHER_PROVIDER_ATTRIBUTE_TYPE DWORD
    Provider AS ASCIIZ PTR
END TYPE

TYPE GOPHER_VERSION_ATTRIBUTE_TYPE DWORD
    Version AS ASCIIZ PTR
END TYPE

TYPE GOPHER_ABSTRACT_ATTRIBUTE_TYPE DWORD
    ShortAbstract AS ASCIIZ PTR
    AbstractFile AS ASCIIZ PTR
END TYPE

TYPE GOPHER_VIEW_ATTRIBUTE_TYPE DWORD
    ContentType AS ASCIIZ PTR
    Language AS ASCIIZ PTR
    Size AS DWORD
END TYPE

TYPE GOPHER_VERONICA_ATTRIBUTE_TYPE DWORD
    TreeWalk AS LONG
END TYPE

TYPE GOPHER_ASK_ATTRIBUTE_TYPE DWORD
    QuestionType AS ASCIIZ PTR
    QuestionText AS ASCIIZ PTR
END TYPE

'
' GOPHER_UNKNOWN_ATTRIBUTE_TYPE - this is returned if we retrieve an attribute
' that is not specified in the current gopher/gopher+ documentation. It is up
' to the application to parse the information
'

TYPE GOPHER_UNKNOWN_ATTRIBUTE_TYPE DWORD
    Text AS ASCIIZ PTR
END TYPE

'
' GOPHER_ATTRIBUTE_TYPE - returned in the user's buffer when an enumerated
' GopherGetAttribute call is made
'

UNION GOPHER_ATTRIBUTE_TYPE_UNION
    Admin AS GOPHER_ADMIN_ATTRIBUTE_TYPE
    ModDate AS GOPHER_MOD_DATE_ATTRIBUTE_TYPE
    Ttl AS GOPHER_TTL_ATTRIBUTE_TYPE
    Score AS GOPHER_SCORE_ATTRIBUTE_TYPE
    ScoreRange AS GOPHER_SCORE_RANGE_ATTRIBUTE_TYPE
    Site AS GOPHER_SITE_ATTRIBUTE_TYPE
    Organization AS GOPHER_ORGANIZATION_ATTRIBUTE_TYPE
    Location AS GOPHER_LOCATION_ATTRIBUTE_TYPE
    GeographicalLocation AS GOPHER_GEOGRAPHICAL_LOCATION_ATTRIBUTE_TYPE
    TimeZone AS GOPHER_TIMEZONE_ATTRIBUTE_TYPE
    Provider AS GOPHER_PROVIDER_ATTRIBUTE_TYPE
    Version AS GOPHER_VERSION_ATTRIBUTE_TYPE
    Abstract AS GOPHER_ABSTRACT_ATTRIBUTE_TYPE
    View AS GOPHER_VIEW_ATTRIBUTE_TYPE
    Veronica AS GOPHER_VERONICA_ATTRIBUTE_TYPE
    Ask AS GOPHER_ASK_ATTRIBUTE_TYPE
    Unknown AS GOPHER_UNKNOWN_ATTRIBUTE_TYPE
END UNION

TYPE GOPHER_ATTRIBUTE_TYPE DWORD
    CategoryId AS DWORD   ' e.g. GOPHER_CATEGORY_ID_ADMIN
    AttributeId AS DWORD  ' e.g. GOPHER_ATTRIBUTE_ID_ADMIN
    AttributeType AS GOPHER_ATTRIBUTE_TYPE_UNION
END TYPE




DECLARE FUNCTION FtpFindFirstFile LIB "wininet.dll" _
   ALIAS "FtpFindFirstFileA" _
   ( _
    BYVAL hConnect AS DWORD, _            ' in
    lpszSearchFile AS ASCIIZ, _           ' in
    lpFindFileData AS WIN32_FIND_DATA, _  ' out
    BYVAL dwFlags AS DWORD, _             ' in
    BYVAL dwContext AS DWORD _
   ) _
   AS DWORD

DECLARE FUNCTION FtpGetFile LIB "wininet.dll" ALIAS "FtpGetFileA" _
   ( _
    BYVAL hConnect AS DWORD, _              ' in
    lpszRemoteFile AS ASCIIZ, _             ' in
    lpszNewFile AS ASCIIZ, _                ' in
    BYVAL fFailIfExists AS LONG, _          ' in
    BYVAL dwFlagsAndAttributes AS DWORD, _  ' in
    BYVAL dwFlags AS DWORD, _               ' in
    BYVAL dwContext AS DWORD _              ' in
   ) _
   AS LONG

DECLARE FUNCTION FtpPutFile LIB "wininet.dll" ALIAS "FtpPutFileA" _
   ( _
    BYVAL hConnect AS DWORD, _              ' in
    lpszLocalFile AS ASCIIZ, _              ' in
    lpszNewRemoteFile AS ASCIIZ, _          ' in
    BYVAL dwFlags AS DWORD, _               ' in
    BYVAL dwContext AS DWORD _              ' in
   ) _
   AS LONG

DECLARE FUNCTION FtpDeleteFile LIB "wininet.dll" ALIAS "FtpDeleteFileA" _
   ( _
    BYVAL hConnect AS DWORD, _              ' in
    lpszFileName AS ASCIIZ _                ' in
   ) _
   AS LONG

DECLARE FUNCTION FtpRenameFile LIB "wininet.dll" ALIAS "FtpRenameFileA" _
   ( _
    BYVAL hConnect AS DWORD, _              ' in
    lpszExisting AS ASCIIZ, _               ' in
    lpszNew AS ASCIIZ _                     ' in
   ) _
   AS LONG

DECLARE FUNCTION FtpOpenFile LIB "wininet.dll" ALIAS "FtpOpenFileA" _
   ( _
    BYVAL hConnect AS DWORD, _              ' in
    lpszFileName AS ASCIIZ, _               ' in
    BYVAL dwAccess AS DWORD, _              ' in
    BYVAL dwFlags AS DWORD, _               ' in
    BYVAL dwContext AS DWORD _              ' in
   ) _
   AS DWORD

DECLARE FUNCTION FtpCreateDirectory LIB "wininet.dll" _
   ALIAS "FtpCreateDirectoryA" _
   ( _
    BYVAL hConnect AS DWORD, _              ' in
    lpszDirectory AS ASCIIZ _               ' in
   ) _
   AS LONG

DECLARE FUNCTION FtpRemoveDirectory LIB "wininet.dll" _
   ALIAS "FtpRemoveDirectoryA" _
   ( _
    BYVAL hConnect AS DWORD, _              ' in
    lpszDirectory AS ASCIIZ _               ' in
   ) _
   AS LONG

DECLARE FUNCTION FtpSetCurrentDirectory LIB "wininet.dll" _
   ALIAS "FtpSetCurrentDirectoryA" _
   ( _
    BYVAL hConnect AS DWORD, _              ' in
    lpszDirectory AS ASCIIZ _               ' in
   ) _
   AS LONG

DECLARE FUNCTION FtpGetCurrentDirectory LIB "wininet.dll" _
   ALIAS "FtpGetCurrentDirectoryA" _
   ( _
    BYVAL hConnect AS DWORD, _              ' in
    lpszCurrentDirectory AS ASCIIZ, _       ' out
    lpdwCurrentDirectory AS DWORD _         ' in, out
   ) _
   AS LONG


'
' HTTP
'

'
' manifests
'

'
' prototypes
'

#IF %DEF(%NOBYVALPTR)
    DECLARE FUNCTION HttpOpenRequest LIB "wininet.dll" _
       ALIAS "HttpOpenRequestA" _
       ( _
        BYVAL hConnect AS DWORD, _                ' in
        lpszVerb AS ASCIIZ, _                     ' in
        lpszObjectName AS ASCIIZ, _               ' in
        lpszVersion AS ASCIIZ, _                  ' in
        lpszReferrer AS ASCIIZ, _                 ' in
        lplpszAcceptTypes AS ASCIIZ PTR, _        ' in
        BYVAL dwFlags AS DWORD, _                 ' in
        BYVAL dwContext AS DWORD _                ' in
       ) _
       AS DWORD
#ELSE
    DECLARE FUNCTION HttpOpenRequest LIB "wininet.dll" _
       ALIAS "HttpOpenRequestA" _
       ( _
        BYVAL hConnect AS DWORD, _                ' in
        lpszVerb AS ASCIIZ, _                     ' in
        lpszObjectName AS ASCIIZ, _               ' in
        lpszVersion AS ASCIIZ, _                  ' in
        lpszReferrer AS ASCIIZ, _                 ' in
        BYVAL lplpszAcceptTypes AS ASCIIZ PTR, _  ' in
        BYVAL dwFlags AS DWORD, _                 ' in
        BYVAL dwContext AS DWORD _                ' in
       ) _
       AS DWORD
#ENDIF

DECLARE FUNCTION HttpAddRequestHeaders LIB "wininet.dll" _
   ALIAS "HttpAddRequestHeadersA" _
   ( _
    BYVAL hRequest AS DWORD, _              ' in
    lpszHeaders AS ASCIIZ, _                ' in
    BYVAL dwHeadersLength AS DWORD, _       ' in
    BYVAL dwModifiers AS DWORD _            ' in
   ) _
   AS LONG

DECLARE FUNCTION HttpSendRequest LIB "wininet.dll" ALIAS "HttpSendRequestA" _
   ( _
    BYVAL hRequest AS DWORD, _              ' in
    lpszHeaders AS ASCIIZ, _                ' in
    BYVAL dwHeadersLength AS DWORD, _       ' in
    BYVAL lpOptional AS BYTE PTR, _         ' in
    BYVAL dwOptionalLength AS DWORD _       ' in
   ) _
   AS LONG

DECLARE FUNCTION HttpSendRequestEx LIB "wininet.dll" _
   ALIAS "HttpSendRequestExA" _
   ( _
    BYVAL hRequest AS DWORD, _              ' in
    lpBuffersIn AS INTERNET_BUFFERS, _      ' in
    lpBuffersOut AS INTERNET_BUFFERS, _     ' out
    BYVAL dwFlags AS DWORD, _               ' in
    BYVAL dwContext AS DWORD _              ' in
   ) _
   AS LONG

DECLARE FUNCTION HttpEndRequest LIB "wininet.dll" ALIAS "HttpEndRequestA" _
   ( _
    BYVAL hRequest AS DWORD, _              ' in
    lpBuffersOut AS INTERNET_BUFFERS, _     ' out
    BYVAL dwFlags AS DWORD, _               ' in
    BYVAL dwContext AS DWORD _              ' in
   ) _
   AS LONG

DECLARE FUNCTION HttpQueryInfo LIB "wininet.dll" ALIAS "HttpQueryInfoA" _
   ( _
    BYVAL hRequest AS DWORD, _              ' in
    BYVAL dwInfoLevel AS DWORD, _           ' in
    BYVAL lpBuffer AS BYTE PTR, _           ' in, out
    lpdwBufferLength AS DWORD, _            ' in, out
    BYVAL lpdwIndex AS DWORD PTR _          ' in, out
   ) _
   AS LONG

'
' Cookie APIs
'


DECLARE FUNCTION InternetSetCookie LIB "wininet.dll" _
   ALIAS "InternetSetCookieA" _
   ( _
    lpszUrl AS ASCIIZ, _                    ' in
    lpszCookieName AS ASCIIZ, _             ' in
    lpszCookieData AS ASCIIZ _              ' in
   ) _
   AS LONG

DECLARE FUNCTION InternetGetCookie LIB "wininet.dll" _
   ALIAS "InternetGetCookieA" _
   ( _
    lpszUrl AS ASCIIZ, _                    ' in
    lpszCookieName AS ASCIIZ, _             ' in
    lpCookieData AS ASCIIZ, _               ' out
    lpdwSize AS DWORD _                     ' in, out
   ) _
   AS LONG


'
' offline browsing
'

DECLARE FUNCTION InternetAttemptConnect LIB "wininet.dll" _
   ALIAS "InternetAttemptConnect" _
   ( _
    BYVAL dwReserved AS DWORD _             ' in
   ) _
   AS DWORD

DECLARE FUNCTION InternetCheckConnection LIB "wininet.dll" _
   ALIAS "InternetCheckConnectionA" _
   ( _
    lpszUrl AS ASCIIZ, _                    ' in
    BYVAL dwFlags AS DWORD, _               ' in
    BYVAL dwReserved AS DWORD _             ' in
   ) _
   AS LONG

DECLARE FUNCTION InternetErrorDlg LIB "wininet.dll" _
   ALIAS "InternetErrorDlg" _
   ( _
    BYVAL hWnd AS DWORD, _                  ' in
    hRequest AS DWORD, _                    ' in, out
    BYVAL dwError AS DWORD, _               ' in
    BYVAL dwFlags AS DWORD, _               ' in
    BYVAL lppvData AS BYTE PTR _            ' in, out
   ) _
   AS DWORD


DECLARE FUNCTION InternetConfirmZoneCrossing LIB "wininet.dll" _
   ALIAS "InternetConfirmZoneCrossing" _
   ( _
    BYVAL hWnd AS DWORD, _                  ' in
    szUrlPrev AS ASCIIZ, _                  ' in
    szUrlNew AS ASCIIZ, _                   ' in
    BYVAL bPost AS LONG _                   ' in
   ) _
   AS DWORD


'
' Cache APIs
'

DECLARE FUNCTION CreateUrlCacheEntry LIB "wininet.dll" _
   ALIAS "CreateUrlCacheEntryA" _
   ( _
    lpszUrlName AS ASCIIZ, _                  ' in
    BYVAL dwExpectedFileSize AS DWORD, _      ' in
    lpszFileExtension AS ASCIIZ, _            ' in
    lpszFileName AS ASCIIZ, _                 ' out
    BYVAL dwReserved AS DWORD _
   ) _
   AS LONG

DECLARE FUNCTION CommitUrlCacheEntry LIB "wininet.dll" _
   ALIAS "CommitUrlCacheEntryA" _
   ( _
    lpszUrlName AS ASCIIZ, _                  ' in
    lpszLocalFileName AS ASCIIZ, _            ' in
    BYVAL ExpireTime AS QUAD, _               ' in
    BYVAL LastModifiedTime AS QUAD, _         ' in
    BYVAL CacheEntryType AS DWORD, _          ' in
    BYVAL lpHeaderInfo AS BYTE PTR, _         ' in
    BYVAL dwHeaderSize AS DWORD, _            ' in
    lpszFileExtension AS ASCIIZ, _            ' in
    BYVAL dwReserved AS DWORD _               ' in
   ) _
   AS LONG

DECLARE FUNCTION RetrieveUrlCacheEntryFile LIB "wininet.dll" _
   ALIAS "RetrieveUrlCacheEntryFileA" _
   ( _
    lpszUrlName AS ASCIIZ, _                           ' in
    lpCacheEntryInfo AS INTERNET_CACHE_ENTRY_INFO, _   ' out
    lpdwCacheEntryInfoBufferSize AS DWORD, _           ' in, out
    BYVAL dwReserved AS DWORD _                        ' in
   ) _
   AS LONG

DECLARE FUNCTION UnlockUrlCacheEntryFile LIB "wininet.dll" _
   ALIAS "UnlockUrlCacheEntryFile" _
   ( _
    lpszUrlName AS ASCIIZ, _           ' in
    BYVAL dwReserved AS DWORD _        ' in
   ) _
   AS LONG

DECLARE FUNCTION RetrieveUrlCacheEntryStream LIB "wininet.dll" _
   ALIAS "RetrieveUrlCacheEntryStreamA" _
   ( _
    lpszUrlName AS ASCIIZ, _                           ' in
    lpCacheEntryInfo AS INTERNET_CACHE_ENTRY_INFO, _   ' out
    lpdwCacheEntryInfoBufferSize AS DWORD, _           ' in, out
    BYVAL fRandomRead AS LONG, _                       ' in
    BYVAL dwReserved AS DWORD _                        ' in
   ) _
   AS DWORD

DECLARE FUNCTION ReadUrlCacheEntryStream LIB "wininet.dll" _
   ALIAS "ReadUrlCacheEntryStream" _
   ( _
    BYVAL hUrlCacheStream AS DWORD, _  ' in
    BYVAL dwLocation AS DWORD, _       ' in
    BYVAL lpBuffer AS BYTE PTR, _      ' in, out
    lpdwLen AS DWORD, _                ' in, out
    BYVAL dwReserved AS DWORD _        ' in
   ) _
   AS LONG

DECLARE FUNCTION UnlockUrlCacheEntryStream LIB "wininet.dll" _
   ALIAS "UnlockUrlCacheEntryStream" _
   ( _
    BYVAL hUrlCacheStream AS DWORD, _  ' in
    BYVAL dwReserved AS DWORD _        ' in
   ) _
   AS LONG

DECLARE FUNCTION GetUrlCacheEntryInfo LIB "wininet.dll" _
   ALIAS "GetUrlCacheEntryInfoA" _
   ( _
    lpszUrlName AS ASCIIZ, _                           ' in
    lpCacheEntryInfo AS INTERNET_CACHE_ENTRY_INFO, _   ' out
    lpdwCacheEntryInfoBufferSize AS DWORD _            ' in, out
   ) _
   AS LONG

DECLARE FUNCTION GetUrlCacheEntryInfoEx LIB "wininet.dll" _
   ALIAS "GetUrlCacheEntryInfoExA" _
   ( _
    lpszUrl AS ASCIIZ, _                               ' in
    lpCacheEntryInfo AS INTERNET_CACHE_ENTRY_INFO, _   ' out
    lpdwCacheEntryInfoBufSize AS DWORD, _              ' in, out
    lpszReserved AS ASCIIZ, _                          ' must pass null
    lpdwReserved AS DWORD, _                           ' must pass null
    lpReserved AS DWORD, _                             ' must pass null
    BYVAL dwFlags AS DWORD _                           ' reserved
   ) _
   AS LONG


DECLARE FUNCTION SetUrlCacheEntryInfo LIB "wininet.dll" _
   ALIAS "SetUrlCacheEntryInfoA" _
   ( _
    lpszUrlName AS ASCIIZ, _                           ' in
    lpCacheEntryInfo AS INTERNET_CACHE_ENTRY_INFO, _   ' in
    BYVAL dwFieldControl AS DWORD _                    ' in
   ) _
   AS LONG

'
' Cache Group Functions
'

DECLARE FUNCTION CreateUrlCacheGroup LIB "wininet.dll" _
   ALIAS "CreateUrlCacheGroup" _
   ( _
    BYVAL dwFlags AS DWORD, _     ' in
    lpReserved AS DWORD _         ' must pass NULL
   ) _
   AS QUAD

DECLARE FUNCTION DeleteUrlCacheGroup LIB "wininet.dll" _
   ALIAS "DeleteUrlCacheGroup" _
   ( _
    BYVAL GroupId AS QUAD, _      ' in
    BYVAL dwFlags AS DWORD, _     ' must pass 0
    lpReserved AS DWORD _         ' must pass NULL
   ) _
   AS LONG

DECLARE FUNCTION SetUrlCacheEntryGroup LIB "wininet.dll" _
   ALIAS "SetUrlCacheEntryGroup" _
   ( _
    lpszUrlName AS ASCIIZ, _                     ' in
    BYVAL dwFlags AS DWORD, _                    ' in
    BYVAL GroupId AS QUAD, _                     ' in
    pbGroupAttributes AS DWORD, _                ' must pass NULL
    BYVAL cbGroupAttributes AS DWORD, _          ' must pass 0
    lpReserved AS DWORD _                        ' must pass NULL
   ) _
   AS LONG

DECLARE FUNCTION FindFirstUrlCacheEntryEx LIB "wininet.dll" _
   ALIAS "FindFirstUrlCacheEntryExA" _
   ( _
    lpszUrlSearchPattern AS ASCIIZ, _                      ' in
    BYVAL dwFlags AS DWORD, _                              ' in
    BYVAL dwFilter AS DWORD, _                             ' in
    BYVAL GroupId AS QUAD, _                               ' in
    lpFirstCacheEntryInfo AS INTERNET_CACHE_ENTRY_INFO, _  ' out
    lpdwFirstCacheEntryInfoBufferSize AS DWORD, _          ' in, out
    lpGroupAttributes AS DWORD, _                          ' must pass NULL
    pcbGroupAttributes AS DWORD, _                         ' must pass NULL
    lpReserved AS DWORD _                                  ' must pass NULL
   ) _
   AS LONG

DECLARE FUNCTION FindNextUrlCacheEntryEx LIB "wininet.dll" _
   ALIAS "FindNextUrlCacheEntryExA" _
   ( _
    BYVAL hEnumHandle AS DWORD, _                          ' in
    lpFirstCacheEntryInfo AS INTERNET_CACHE_ENTRY_INFO, _  ' out
    lpdwFirstCacheEntryInfoBufferSize AS DWORD, _          ' in, out
    lpGroupAttributes AS DWORD, _                          ' must pass NULL
    pcbGroupAttributes AS DWORD, _                         ' must pass NULL
    lpReserved AS DWORD _                                  ' must pass NULL
   ) _
   AS LONG

DECLARE FUNCTION FindFirstUrlCacheEntry LIB "wininet.dll" _
   ALIAS "FindFirstUrlCacheEntryA" _
   ( _
    lpszUrlSearchPattern AS ASCIIZ, _                      ' in
    lpFirstCacheEntryInfo AS INTERNET_CACHE_ENTRY_INFO, _  ' out
    lpdwFirstCacheEntryInfoBufferSize AS DWORD _           ' in, out
   ) _
   AS LONG

DECLARE FUNCTION FindNextUrlCacheEntry LIB "wininet.dll" _
   ALIAS "FindNextUrlCacheEntryA" _
   ( _
    BYVAL hEnumHandle AS DWORD, _                          ' in
    lpNextCacheEntryInfo AS INTERNET_CACHE_ENTRY_INFO, _   ' out
    lpdwNextCacheEntryInfoBufferSize AS DWORD _            ' in, out
   ) _
   AS LONG

DECLARE FUNCTION FindCloseUrlCache LIB "wininet.dll" _
   ALIAS "FindCloseUrlCache" _
   ( _
    BYVAL hEnumHandle AS DWORD _       ' in
   ) _
   AS LONG

DECLARE FUNCTION DeleteUrlCacheEntry LIB "wininet.dll" _
   ALIAS "DeleteUrlCacheEntry" _
   ( _
    lpszUrlName AS ASCIIZ _            ' in
   ) _
   AS LONG


'
' Autodial APIs
'

DECLARE FUNCTION InternetDial LIB "wininet.dll" _
   ALIAS "InternetDial" _
   ( _
    BYVAL hwndParent AS DWORD, _       ' in
    lpszConnectoid AS ASCIIZ, _        ' in
    BYVAL dwFlags AS DWORD, _          ' in
    lpdwConnection AS DWORD, _         ' out
    BYVAL dwReserved AS DWORD _        ' in
   ) _
   AS DWORD

DECLARE FUNCTION InternetHangUp LIB "wininet.dll" _
   ALIAS "InternetHangUp" _
   ( _
    BYVAL dwConnection AS DWORD, _     ' in
    BYVAL dwReserved AS DWORD _        ' in
   ) _
   AS DWORD

DECLARE FUNCTION InternetGoOnline LIB "wininet.dll" _
   ALIAS "InternetGoOnline" _
   ( _
    lpszURL AS ASCIIZ, _               ' in
    BYVAL hwndParent AS DWORD, _       ' in
    BYVAL dwFlags AS DWORD _           ' in
   ) _
   AS LONG

DECLARE FUNCTION InternetAutodial LIB "wininet.dll" _
   ALIAS "InternetAutodial" _
   ( _
    BYVAL dwFlags AS DWORD, _          ' in
    BYVAL dwReserved AS DWORD _        ' in
   ) _
   AS LONG

DECLARE FUNCTION InternetAutodialHangup LIB "wininet.dll" _
   ALIAS "InternetAutodialHangup" _
   ( _
    BYVAL dwReserved AS DWORD _        ' in
   ) _
   AS LONG

DECLARE FUNCTION InternetGetConnectedState LIB "wininet.dll" _
   ALIAS "InternetGetConnectedState" _
   ( _
    lpdwFlags AS DWORD, _              ' out
    BYVAL dwReserved AS DWORD _        ' in
   ) _
   AS LONG

DECLARE FUNCTION InternetSetDialState LIB "wininet.dll" _
   ALIAS "InternetSetDialState" _
   ( _
    lpszConnectoid AS ASCIIZ, _        ' in
    BYVAL dwState AS DWORD, _          ' in
    BYVAL dwReserved AS DWORD _        ' in
   ) _
   AS LONG

'
' Internet APIs
'




DECLARE FUNCTION InternetTimeFromSystemTime LIB "wininet.dll" _
   ALIAS "InternetTimeFromSystemTimeA" _
   ( _
    pst AS SYSTEMTIME, _     ' input GMT time
    BYVAL dwRFC AS DWORD,_   ' RFC format
    lpszTime AS ASCIIZ, _    ' output string buffer
    BYVAL cbTime AS DWORD _  ' output buffer size
   ) _
   AS LONG

DECLARE FUNCTION InternetTimeToSystemTime LIB "wininet.dll" _
   ALIAS "InternetTimeToSystemTimeA" _
   ( _
    lpszTime AS ASCIIZ, _    ' NULL terminated string
    pst AS SYSTEMTIME, _     ' output in GMT time
    BYVAL dwReserved AS DWORD _
   ) _
   AS LONG

DECLARE FUNCTION InternetCrackUrl LIB "wininet.dll" ALIAS "InternetCrackUrlA" _
   ( _
    lpszUrl AS ASCIIZ, _                 ' in
    BYVAL dwUrlLength AS DWORD, _        ' in
    BYVAL dwFlags AS DWORD, _            ' in
    lpUrlComponents AS URL_COMPONENTS _  ' in/out
   ) _
   AS LONG

DECLARE FUNCTION InternetCreateUrl LIB "wininet.dll" _
   ALIAS "InternetCreateUrlA" _
   ( _
    lpUrlComponents AS URL_COMPONENTS, _ ' in
    BYVAL dwFlags AS DWORD, _            ' in
    lpszUrl AS ASCIIZ, _                 ' out
    lpdwUrlLength AS DWORD _             ' in/out
   ) _
   AS LONG

DECLARE FUNCTION InternetCanonicalizeUrl LIB "wininet.dll" _
   ALIAS "InternetCanonicalizeUrlA" _
   ( _
    lpszUrl AS ASCIIZ, _                 ' in
    lpszBuffer AS ASCIIZ, _              ' out
    lpdwBufferLength AS DWORD, _         ' in/out
    BYVAL dwFlags AS DWORD _             ' in
   ) _
   AS LONG

DECLARE FUNCTION InternetCombineUrl LIB "wininet.dll" _
   ALIAS "InternetCombineUrlA" _
   ( _
    lpszBaseUrl AS ASCIIZ, _             ' in
    lpszRelativeUrl AS ASCIIZ, _         ' in
    lpszBuffer AS ASCIIZ, _              ' out
    lpdwBufferLength AS DWORD, _         ' in/out
    BYVAL dwFlags AS DWORD _             ' in
   ) _
   AS LONG

DECLARE FUNCTION InternetOpen LIB "wininet.dll" ALIAS "InternetOpenA" _
   ( _
    lpszAgent AS ASCIIZ, _               ' in
    BYVAL dwAccessType AS DWORD, _       ' in
    lpszProxy AS ASCIIZ, _               ' in
    lpszProxyBypass AS ASCIIZ, _         ' in
    BYVAL dwFlags AS DWORD _             ' in
   ) _
   AS DWORD


DECLARE FUNCTION InternetCloseHandle LIB "wininet.dll" _
   ALIAS "InternetCloseHandle" _
   ( _
    BYVAL hInternet AS DWORD _    ' in
   ) _
   AS LONG


DECLARE FUNCTION InternetConnect LIB "wininet.dll" ALIAS "InternetConnectA" _
   ( _
    BYVAL hInternet AS DWORD, _   ' in
    lpszServerName AS ASCIIZ, _   ' in
    BYVAL nServerPort AS WORD, _  ' in
    lpszUserName AS ASCIIZ, _     ' in
    lpszPassword AS ASCIIZ, _     ' in
    BYVAL dwService AS DWORD, _   ' in
    BYVAL dwFlags AS DWORD, _     ' in
    BYVAL dwContext AS DWORD _    ' in
   ) _
   AS DWORD


'
' InternetConnectUrl() - a macro which allows you to specify an URL instead of
' the component parts to InternetConnect(). If any API which uses the returned
' connect handle specifies a NULL path then the URL-path part of the URL
' specified in InternetConnectUrl() will be used
'

FUNCTION InternetConnectUrl (BYVAL hInternet AS DWORD, _
                             lpszUrl AS ASCIIZ, _
                             BYVAL dwFlags AS DWORD, _
                             BYVAL dwContext AS DWORD) AS DWORD
    FUNCTION = InternetConnect(hInternet, lpszUrl, _
       %INTERNET_INVALID_PORT_NUMBER, BYVAL %NULL, BYVAL %NULL, _
       %INTERNET_SERVICE_URL, dwFlags, dwContext)
END FUNCTION

DECLARE FUNCTION InternetOpenUrl LIB "wininet.dll" ALIAS "InternetOpenUrlA" _
   ( _
    BYVAL hInternet AS DWORD, _          ' in
    lpszUrl AS ASCIIZ, _                 ' in
    lpszHeaders AS ASCIIZ, _             ' in
    BYVAL dwHeadersLength AS DWORD, _    ' in
    BYVAL dwFlags AS DWORD, _            ' in
    BYVAL dwContext AS DWORD _           ' in
   ) _
   AS DWORD

DECLARE FUNCTION InternetReadFile LIB "wininet.dll" ALIAS "InternetReadFile" _
   ( _
    BYVAL hFile AS DWORD, _                  ' in
    BYVAL lpBuffer AS BYTE PTR, _            ' in
    BYVAL dwNumberOfBytesToRead AS DWORD, _  ' in
    lpdwNumberOfBytesRead AS DWORD _         ' out
   ) _
   AS LONG

DECLARE FUNCTION InternetReadFileEx LIB "wininet.dll" _
   ALIAS "InternetReadFileExA" _
   ( _
    BYVAL hFile AS DWORD, _                  ' in
    lpBuffersOut AS INTERNET_BUFFERS, _      ' out
    BYVAL dwFlags AS DWORD, _                ' in
    BYVAL dwContext AS DWORD _               ' in
   ) _
   AS LONG


DECLARE FUNCTION InternetSetFilePointer LIB "wininet.dll" _
   ALIAS "InternetSetFilePointer" _
   ( _
    BYVAL hFile AS DWORD, _              ' in
    BYVAL lDistanceToMove AS LONG, _     ' in
    BYVAL pReserved AS BYTE PTR, _       ' in
    BYVAL dwMoveMethod AS DWORD, _       ' in
    BYVAL dwContext AS DWORD _           ' in
   ) _
   AS DWORD

DECLARE FUNCTION InternetWriteFile LIB "wininet.dll" _
   ALIAS "InternetWriteFile" _
   ( _
    BYVAL hFile AS DWORD, _                   ' in
    BYVAL lpBuffer AS BYTE PTR, _             ' in
    BYVAL dwNumberOfBytesToWrite AS DWORD, _  ' in
    lpdwNumberOfBytesWritten AS DWORD _       ' out
   ) _
   AS LONG

DECLARE FUNCTION InternetQueryDataAvailable LIB "wininet.dll" _
   ALIAS "InternetQueryDataAvailable" _
   ( _
    BYVAL hFile AS DWORD, _                   ' in
    lpdwNumberOfBytesAvailable AS DWORD, _    ' out
    BYVAL dwFlags AS DWORD, _                 ' in
    BYVAL dwContext AS DWORD _                ' in
   ) _
   AS LONG

DECLARE FUNCTION InternetFindNextFile LIB "wininet.dll" _
   ALIAS "InternetFindNextFileA" _
   ( _
    BYVAL hFind AS DWORD, _         ' in
    BYVAL lpvFindData AS BYTE PTR _ ' out
   ) _
   AS LONG

DECLARE FUNCTION InternetQueryOption LIB "wininet.dll" _
   ALIAS "InternetQueryOptionA" _
   ( _
    BYVAL hInternet AS DWORD, _        ' in
    BYVAL dwOption AS DWORD, _         ' in
    BYVAL lpBuffer AS BYTE PTR, _      ' out
    lpdwBufferLength AS DWORD _        ' in, out
   ) _
   AS LONG

DECLARE FUNCTION InternetSetOption LIB "wininet.dll" _
   ALIAS "InternetSetOptionA" _
   ( _
    BYVAL hInternet AS DWORD, _        ' in
    BYVAL dwOption AS DWORD, _         ' in
    BYVAL lpBuffer AS BYTE PTR, _      ' in
    BYVAL dwBufferLength AS DWORD _    ' in
   ) _
   AS LONG

DECLARE FUNCTION InternetSetOptionEx LIB "wininet.dll" _
   ALIAS "InternetSetOptionExA" _
   ( _
    BYVAL hInternet AS DWORD, _        ' in
    BYVAL dwOption AS DWORD, _         ' in
    BYVAL lpBuffer AS BYTE PTR, _      ' in
    BYVAL dwBufferLength AS DWORD, _   ' in
    BYVAL dwFlags AS DWORD _           ' in
   ) _
   AS LONG

DECLARE FUNCTION InternetLockRequestFile LIB "wininet.dll" _
   ALIAS "InternetLockRequestFile" _
   ( _
    BYVAL hInternet AS LONG, _         ' in
    lphLockRequestInfo AS DWORD _      ' out
   ) _
   AS LONG

DECLARE FUNCTION InternetUnlockRequestFile LIB "wininet.dll" _
   ALIAS "InternetUnlockRequestFile" _
   ( _
    BYVAL hLockRequestInfo AS DWORD _  ' in
   ) _
   AS LONG



DECLARE FUNCTION InternetGetLastResponsInfo LIB "wininet.dll" _
   ALIAS "InternetGetLastResponseInfoA" _
   ( _
    lpdwError AS DWORD, _         ' out
    lpszBuffer AS ASCIIZ, _       ' out
    lpdwBufferLength AS DWORD _   ' in, out
   ) _
   AS LONG

DECLARE FUNCTION InternetSetStatusCallback LIB "wininet.dll" _
   ALIAS "InternetSetStatusCallback" _
   ( _
    BYVAL hInternet AS DWORD, _              ' in
    BYVAL lpfnInternetCallback AS DWORD _    ' in
   ) _
   AS DWORD


' gopher type macros
'

FUNCTION IS_GOPHER_FILE (BYVAL nType AS DWORD) AS LONG
    FUNCTION = ((nType AND %GOPHER_TYPE_FILE_MASK) <> 0)
END FUNCTION

FUNCTION IS_GOPHER_DIRECTORY (BYVAL nType AS DWORD) AS LONG
    FUNCTION = ((nType AND %GOPHER_TYPE_DIRECTORY) <> 0)
END FUNCTION

FUNCTION IS_GOPHER_PHONE_SERVER (BYVAL nType AS DWORD) AS LONG
    FUNCTION = ((nType AND %GOPHER_TYPE_CSO) <> 0)
END FUNCTION

FUNCTION IS_GOPHER_ERROR (BYVAL nType AS DWORD) AS LONG
    FUNCTION = ((nType AND %GOPHER_TYPE_ERROR) <> 0)
END FUNCTION

FUNCTION IS_GOPHER_INDEX_SERVER (BYVAL nType AS DWORD) AS LONG
    FUNCTION = ((nType AND %GOPHER_TYPE_INDEX_SERVER) <> 0)
END FUNCTION

FUNCTION IS_GOPHER_TELNET_SESSION (BYVAL nType AS DWORD) AS LONG
    FUNCTION = ((nType AND %GOPHER_TYPE_TELNET) <> 0)
END FUNCTION

FUNCTION IS_GOPHER_BACKUP_SERVER (BYVAL nType AS DWORD) AS LONG
    FUNCTION = ((nType AND %GOPHER_TYPE_REDUNDANT) <> 0)
END FUNCTION

FUNCTION IS_GOPHER_TN3280_SESSION (BYVAL nType AS DWORD) AS LONG
    FUNCTION = ((nType AND %GOPHER_TYPE_TN3270) <> 0)
END FUNCTION

FUNCTION IS_GOPHER_ASK (BYVAL nType AS DWORD) AS LONG
    FUNCTION = ((nType AND %GOPHER_TYPE_ASK) <> 0)
END FUNCTION

FUNCTION IS_GOPHER_PLUS (BYVAL nType AS DWORD) AS LONG
    FUNCTION = ((nType AND %GOPHER_TYPE_GOPHER_PLUS) <> 0)
END FUNCTION

FUNCTION IS_GOPHER_TYPE_KNOWN (BYVAL nType AS DWORD) AS LONG
    FUNCTION = ((nType AND %GOPHER_TYPE_UNKNOWN) = 0)
END FUNCTION


DECLARE FUNCTION GopherCreateLocator LIB "wininet.dll" _
   ALIAS "GopherCreateLocatorA" _
   ( _
    lpszHost AS ASCIIZ, _                   ' in
    BYVAL nServerPost AS WORD, _            ' in
    lpszDisplayString AS ASCIIZ, _          ' in
    lpszSelectorString AS ASCIIZ, _         ' in
    BYVAL dwGopherType AS DWORD, _          ' in
    lpszLocator AS ASCIIZ, _                ' out
    lpdwBufferLength AS DWORD _             ' in, out
   ) _
   AS LONG

DECLARE FUNCTION GopherGetLocatorType LIB "wininet.dll" _
   ALIAS "GopherGetLocatorTypeA" _
   ( _
    lpszLocator AS ASCIIZ, _                ' in
    lpdwGopherType AS DWORD _               ' out
   ) _
   AS LONG

DECLARE FUNCTION GopherFindFirstFile LIB "wininet.dll" _
   ALIAS "GopherFindFirstFileA" _
   ( _
    BYVAL hConnect AS DWORD, _              ' in
    lpszLocator AS ASCIIZ, _                ' in
    lpszSearchString AS ASCIIZ, _           ' in
    lpFindData AS GOPHER_FIND_DATA, _       ' out
    BYVAL dwFlags AS DWORD, _               ' in
    BYVAL dwContext AS DWORD _              ' in
   ) _
   AS DWORD

DECLARE FUNCTION GopherOpenFile LIB "wininet.dll" ALIAS "GopherOpenFileA" _
   ( _
    BYVAL hConnect AS DWORD, _              ' in
    lpszLocator AS ASCIIZ, _                ' in
    lpszView AS ASCIIZ, _                   ' in
    BYVAL dwFlags AS DWORD, _               ' in
    BYVAL dwContext AS DWORD _              ' in
   ) _
   AS DWORD

DECLARE FUNCTION GopherGetAttribute LIB "wininet.dll" _
   ALIAS "GopherGetAttributeA" _
   ( _
    BYVAL hConnect AS DWORD, _              ' in
    lpszLocator AS ASCIIZ, _                ' in
    lpszAttributeName AS ASCIIZ, _          ' in
    BYVAL lpBuffer AS BYTE PTR, _           ' out
    BYVAL dwBufferLength AS DWORD, _        ' in
    lpdwCharactersReturned AS DWORD, _      ' out
    BYVAL lpfnEnumerator AS DWORD, _        ' in
    BYVAL dwContext AS DWORD _              ' in
   ) _
   AS LONG



#ENDIF
