'------------------------------------------------------------------------------
'
'  WIN32API.INC -- Win32 API Declarations for PowerBASIC
'  Copyright (C) 1997-2001 PowerBASIC, Inc.
'  Portions Copyright (C) 1985-1999 Microsoft Corporation
'
'  Last Update: December 7, 2001
'
'  This file contains Equate, Type, and Declare statements for Win32 APIs.
'
' *****************************************************************************
' * NOTE that many variables (and some equates) that were previously declared *
' * AS LONG are now correctly defined AS DWORD, which may cause compatibility *
' * issues with existing programs. In particular, %INVALID_HANDLE_VALUE is    *
' * &HFFFFFFFF??? rather than -1& now.                                        *
' *****************************************************************************
'
'  You have a royalty-free right to use, modify, reproduce and distribute
'  this file (and/or any modified version) in any way you find useful,
'  provided that you agree that both PowerBASIC and Microsoft have no
'  warranty, obligation or liability for its contents.  Refer to the
'  PowerBASIC DLL Compiler Reference Guide for further information.
'
'  IMPORTANT:  This file is not compatible with PB/DLL 5.0 or PB/CC 1.0
'              as-is.  It uses string equates which are only available in
'              PB/CC 2.0 or later and PB/DLL 6.0 or later.  You will need
'              to comment out the string equates to use this file with
'              the earlier compilers.
'
'  If you are using the PowerBASIC Console Compiler for Windows, several of
'  the GDI functions have been commented out so that the code will not be
'  added to your programs.  If you need to access these functions you will
'  need to add the line:
'
'    %CCWIN = 1
'
'  Before the #INCLUDE "WIN32API.INC" line.  This will re-enable those calls
'  for your PB/CC application.
'
'  If you don't need all of the functionality supported by these APIs
'  (and who does?), you can selectively turn off various modules by putting
'  the following constants in your program BEFORE you #include "win32api.inc":
'
'  --- Graphics: ---
'  %NOGDI = 1     ' no GDI (Graphics Device Interface) functions
'  --- Multimedia: ---
'  %NOMMIDS = 1   ' no Multimedia ID definitions
'  %NONEWWAVE = 1 ' no new waveform types except WAVEFORMATEX are defined
'  %NONEWRIFF = 1 ' no new RIFF formats are defined
'  %NOJPEGDIB = 1 ' no JPEG DIB definitions
'  %NONEWIC = 1   ' no new Image Compressor types are defined
'  %NOBITMAP = 1  ' no extended bitmap info header definition
'
'------------------------------------------------------------------------------

#IF NOT %DEF(%WINAPI)

%WINAPI = 1

' To avoid redundant code, we make sure %CCWIN is always defined for PB/DLL.
#IF NOT %DEF(%PB_CC32)
  #IF NOT %DEF(%CCWIN)
    %CCWIN = 1
  #ENDIF
#ENDIF

' Define %NOBYVALPTR for PB/CC 2.00 and PB/DLL 6.00, so we can use the
' appropriate BYVAL..PTR and []/OPTIONAL declaration syntax.
#IF %DEF(%PB_CC32)
    #IF %PB_REVISION - &H200
    #ELSE
        %NOBYVALPTR = 1
    #ENDIF
#ELSEIF %DEF(%PB_DLL32)
    #IF %PB_REVISION - &H600
    #ELSE
        %NOBYVALPTR = 1
    #ENDIF
#ENDIF

%TRUE   = 1
%FALSE  = 0
%NULL   = 0

' Constants from winerror.h ===================================================

#IF NOT %DEF(%WINERROR_INC)

%FACILITY_WINDOWS     = 8
%FACILITY_URT         = 19
%FACILITY_STORAGE     = 3
%FACILITY_SSPI        = 9
%FACILITY_SCARD       = 16
%FACILITY_SETUPAPI    = 15
%FACILITY_SECURITY    = 9
%FACILITY_RPC         = 1
%FACILITY_WIN32       = 7
%FACILITY_CONTROL     = 10
%FACILITY_NULL        = 0
%FACILITY_MSMQ        = 14
%FACILITY_MEDIASERVER = 13
%FACILITY_INTERNET    = 12
%FACILITY_ITF         = 4
%FACILITY_DISPATCH    = 2
%FACILITY_COMPLUS     = 17
%FACILITY_CERT        = 11
%FACILITY_AAF         = 18

%ERROR_SUCCESS                 = 0&
%NO_ERROR                      = 0&      '  dderror

%SEC_E_OK                      = 0???

%ERROR_INVALID_FUNCTION           = 1&     ' dderror
%ERROR_FILE_NOT_FOUND             = 2&
%ERROR_PATH_NOT_FOUND             = 3&
%ERROR_TOO_MANY_OPEN_FILES        = 4&
%ERROR_ACCESS_DENIED              = 5&
%ERROR_INVALID_HANDLE             = 6&
%ERROR_ARENA_TRASHED              = 7&
%ERROR_NOT_ENOUGH_MEMORY          = 8&     ' dderror
%ERROR_INVALID_BLOCK              = 9&
%ERROR_BAD_ENVIRONMENT            = 10&
%ERROR_BAD_FORMAT                 = 11&
%ERROR_INVALID_ACCESS             = 12&
%ERROR_INVALID_DATA               = 13&
%ERROR_OUTOFMEMORY                = 14&
%ERROR_INVALID_DRIVE              = 15&
%ERROR_CURRENT_DIRECTORY          = 16&
%ERROR_NOT_SAME_DEVICE            = 17&
%ERROR_NO_MORE_FILES              = 18&
%ERROR_WRITE_PROTECT              = 19&
%ERROR_BAD_UNIT                   = 20&
%ERROR_NOT_READY                  = 21&
%ERROR_BAD_COMMAND                = 22&
%ERROR_CRC                        = 23&
%ERROR_BAD_LENGTH                 = 24&
%ERROR_SEEK                       = 25&
%ERROR_NOT_DOS_DISK               = 26&
%ERROR_SECTOR_NOT_FOUND           = 27&
%ERROR_OUT_OF_PAPER               = 28&
%ERROR_WRITE_FAULT                = 29&
%ERROR_READ_FAULT                 = 30&
%ERROR_GEN_FAILURE                = 31&
%ERROR_SHARING_VIOLATION          = 32&
%ERROR_LOCK_VIOLATION             = 33&
%ERROR_WRONG_DISK                 = 34&
%ERROR_SHARING_BUFFER_EXCEEDED    = 36&
%ERROR_HANDLE_EOF                 = 38&
%ERROR_HANDLE_DISK_FULL           = 39&
%ERROR_NOT_SUPPORTED              = 50&
%ERROR_REM_NOT_LIST               = 51&
%ERROR_DUP_NAME                   = 52&
%ERROR_BAD_NETPATH                = 53&
%ERROR_NETWORK_BUSY               = 54&
%ERROR_DEV_NOT_EXIST              = 55&     ' dderror
%ERROR_TOO_MANY_CMDS              = 56&
%ERROR_ADAP_HDW_ERR               = 57&
%ERROR_BAD_NET_RESP               = 58&
%ERROR_UNEXP_NET_ERR              = 59&
%ERROR_BAD_REM_ADAP               = 60&
%ERROR_PRINTQ_FULL                = 61&
%ERROR_NO_SPOOL_SPACE             = 62&
%ERROR_PRINT_CANCELLED            = 63&
%ERROR_NETNAME_DELETED            = 64&
%ERROR_NETWORK_ACCESS_DENIED      = 65&
%ERROR_BAD_DEV_TYPE               = 66&
%ERROR_BAD_NET_NAME               = 67&
%ERROR_TOO_MANY_NAMES             = 68&
%ERROR_TOO_MANY_SESS              = 69&
%ERROR_SHARING_PAUSED             = 70&
%ERROR_REQ_NOT_ACCEP              = 71&
%ERROR_REDIR_PAUSED               = 72&
%ERROR_FILE_EXISTS                = 80&
%ERROR_CANNOT_MAKE                = 82&
%ERROR_FAIL_I24                   = 83&
%ERROR_OUT_OF_STRUCTURES          = 84&
%ERROR_ALREADY_ASSIGNED           = 85&
%ERROR_INVALID_PASSWORD           = 86&
%ERROR_INVALID_PARAMETER          = 87&     ' dderror
%ERROR_NET_WRITE_FAULT            = 88&
%ERROR_NO_PROC_SLOTS              = 89&
%ERROR_TOO_MANY_SEMAPHORES        = 100&
%ERROR_EXCL_SEM_ALREADY_OWNED     = 101&
%ERROR_SEM_IS_SET                 = 102&
%ERROR_TOO_MANY_SEM_REQUESTS      = 103&
%ERROR_INVALID_AT_INTERRUPT_TIME  = 104&
%ERROR_SEM_OWNER_DIED             = 105&
%ERROR_SEM_USER_LIMIT             = 106&
%ERROR_DISK_CHANGE                = 107&
%ERROR_DRIVE_LOCKED               = 108&
%ERROR_BROKEN_PIPE                = 109&
%ERROR_OPEN_FAILED                = 110&
%ERROR_BUFFER_OVERFLOW            = 111&
%ERROR_DISK_FULL                  = 112&
%ERROR_NO_MORE_SEARCH_HANDLES     = 113&
%ERROR_INVALID_TARGET_HANDLE      = 114&
%ERROR_INVALID_CATEGORY           = 117&
%ERROR_INVALID_VERIFY_SWITCH      = 118&
%ERROR_BAD_DRIVER_LEVEL           = 119&
%ERROR_CALL_NOT_IMPLEMENTED       = 120&
%ERROR_SEM_TIMEOUT                = 121&
%ERROR_INSUFFICIENT_BUFFER        = 122&     ' dderror
%ERROR_INVALID_NAME               = 123&     ' dderror
%ERROR_INVALID_LEVEL              = 124&
%ERROR_NO_VOLUME_LABEL            = 125&
%ERROR_MOD_NOT_FOUND              = 126&
%ERROR_PROC_NOT_FOUND             = 127&
%ERROR_WAIT_NO_CHILDREN           = 128&
%ERROR_CHILD_NOT_COMPLETE         = 129&
%ERROR_DIRECT_ACCESS_HANDLE       = 130&
%ERROR_NEGATIVE_SEEK              = 131&
%ERROR_SEEK_ON_DEVICE             = 132&
%ERROR_IS_JOIN_TARGET             = 133&
%ERROR_IS_JOINED                  = 134&
%ERROR_IS_SUBSTED                 = 135&
%ERROR_NOT_JOINED                 = 136&
%ERROR_NOT_SUBSTED                = 137&
%ERROR_JOIN_TO_JOIN               = 138&
%ERROR_SUBST_TO_SUBST             = 139&
%ERROR_JOIN_TO_SUBST              = 140&
%ERROR_SUBST_TO_JOIN              = 141&
%ERROR_BUSY_DRIVE                 = 142&
%ERROR_SAME_DRIVE                 = 143&
%ERROR_DIR_NOT_ROOT               = 144&
%ERROR_DIR_NOT_EMPTY              = 145&
%ERROR_IS_SUBST_PATH              = 146&
%ERROR_IS_JOIN_PATH               = 147&
%ERROR_PATH_BUSY                  = 148&
%ERROR_IS_SUBST_TARGET            = 149&
%ERROR_SYSTEM_TRACE               = 150&
%ERROR_INVALID_EVENT_COUNT        = 151&
%ERROR_TOO_MANY_MUXWAITERS        = 152&
%ERROR_INVALID_LIST_FORMAT        = 153&
%ERROR_LABEL_TOO_LONG             = 154&
%ERROR_TOO_MANY_TCBS              = 155&
%ERROR_SIGNAL_REFUSED             = 156&
%ERROR_DISCARDED                  = 157&
%ERROR_NOT_LOCKED                 = 158&
%ERROR_BAD_THREADID_ADDR          = 159&
%ERROR_BAD_ARGUMENTS              = 160&
%ERROR_BAD_PATHNAME               = 161&
%ERROR_SIGNAL_PENDING             = 162&
%ERROR_MAX_THRDS_REACHED          = 164&
%ERROR_LOCK_FAILED                = 167&
%ERROR_BUSY                       = 170&
%ERROR_CANCEL_VIOLATION           = 173&
%ERROR_ATOMIC_LOCKS_NOT_SUPPORTED = 174&
%ERROR_INVALID_SEGMENT_NUMBER     = 180&
%ERROR_INVALID_ORDINAL            = 182&
%ERROR_ALREADY_EXISTS             = 183&
%ERROR_INVALID_FLAG_NUMBER        = 186&
%ERROR_SEM_NOT_FOUND              = 187&
%ERROR_INVALID_STARTING_CODESEG   = 188&
%ERROR_INVALID_STACKSEG           = 189&
%ERROR_INVALID_MODULETYPE         = 190&
%ERROR_INVALID_EXE_SIGNATURE      = 191&
%ERROR_EXE_MARKED_INVALID         = 192&
%ERROR_BAD_EXE_FORMAT             = 193&
%ERROR_ITERATED_DATA_EXCEEDS_64k  = 194&
%ERROR_INVALID_MINALLOCSIZE       = 195&
%ERROR_DYNLINK_FROM_INVALID_RING  = 196&
%ERROR_IOPL_NOT_ENABLED           = 197&
%ERROR_INVALID_SEGDPL             = 198&
%ERROR_AUTODATASEG_EXCEEDS_64k    = 199&
%ERROR_RING2SEG_MUST_BE_MOVABLE   = 200&
%ERROR_RELOC_CHAIN_XEEDS_SEGLIM   = 201&
%ERROR_INFLOOP_IN_RELOC_CHAIN     = 202&
%ERROR_ENVVAR_NOT_FOUND           = 203&
%ERROR_NO_SIGNAL_SENT             = 205&
%ERROR_FILENAME_EXCED_RANGE       = 206&
%ERROR_RING2_STACK_IN_USE         = 207&
%ERROR_META_EXPANSION_TOO_LONG    = 208&
%ERROR_INVALID_SIGNAL_NUMBER      = 209&
%ERROR_THREAD_1_INACTIVE          = 210&
%ERROR_LOCKED                     = 212&
%ERROR_TOO_MANY_MODULES           = 214&
%ERROR_NESTING_NOT_ALLOWED        = 215&
%ERROR_EXE_MACHINE_TYPE_MISMATCH  = 216&
%ERROR_BAD_PIPE                   = 230&
%ERROR_PIPE_BUSY                  = 231&
%ERROR_NO_DATA                    = 232&
%ERROR_PIPE_NOT_CONNECTED         = 233&
%ERROR_MORE_DATA                  = 234&     ' dderror
%ERROR_VC_DISCONNECTED            = 240&
%ERROR_INVALID_EA_NAME            = 254&
%ERROR_EA_LIST_INCONSISTENT       = 255&
%WAIT_TIMEOUT                     = 258&
%ERROR_NO_MORE_ITEMS              = 259&
%ERROR_CANNOT_COPY                = 266&
%ERROR_DIRECTORY                  = 267&
%ERROR_EAS_DIDNT_FIT              = 275&
%ERROR_EA_FILE_CORRUPT            = 276&
%ERROR_EA_TABLE_FULL              = 277&
%ERROR_INVALID_EA_HANDLE          = 278&
%ERROR_EAS_NOT_SUPPORTED          = 282&
%ERROR_NOT_OWNER                  = 288&
%ERROR_TOO_MANY_POSTS             = 298&
%ERROR_PARTIAL_COPY               = 299&
%ERROR_OPLOCK_NOT_GRANTED         = 300&
%ERROR_INVALID_OPLOCK_PROTOCOL    = 301&
%ERROR_MR_MID_NOT_FOUND           = 317&
%ERROR_INVALID_ADDRESS            = 487&
%ERROR_ARITHMETIC_OVERFLOW        = 534&
%ERROR_PIPE_CONNECTED             = 535&
%ERROR_PIPE_LISTENING             = 536&
%ERROR_EA_ACCESS_DENIED           = 994&
%ERROR_OPERATION_ABORTED          = 995&
%ERROR_IO_INCOMPLETE              = 996&
%ERROR_IO_PENDING                 = 997&     ' dderror
%ERROR_NOACCESS                   = 998&
%ERROR_SWAPERROR                  = 999&
%ERROR_STACK_OVERFLOW             = 1001&
%ERROR_INVALID_MESSAGE            = 1002&
%ERROR_CAN_NOT_COMPLETE           = 1003&
%ERROR_INVALID_FLAGS              = 1004&
%ERROR_UNRECOGNIZED_VOLUME        = 1005&
%ERROR_FILE_INVALID               = 1006&
%ERROR_FULLSCREEN_MODE            = 1007&
%ERROR_NO_TOKEN                   = 1008&
%ERROR_BADDB                      = 1009&
%ERROR_BADKEY                     = 1010&
%ERROR_CANTOPEN                   = 1011&
%ERROR_CANTREAD                   = 1012&
%ERROR_CANTWRITE                  = 1013&
%ERROR_REGISTRY_RECOVERED         = 1014&
%ERROR_REGISTRY_CORRUPT           = 1015&
%ERROR_REGISTRY_IO_FAILED         = 1016&
%ERROR_NOT_REGISTRY_FILE          = 1017&
%ERROR_KEY_DELETED                = 1018&
%ERROR_NO_LOG_SPACE               = 1019&
%ERROR_KEY_HAS_CHILDREN           = 1020&
%ERROR_CHILD_MUST_BE_VOLATILE     = 1021&
%ERROR_NOTIFY_ENUM_DIR            = 1022&
%ERROR_DEPENDENT_SERVICES_RUNNING = 1051&
%ERROR_INVALID_SERVICE_CONTROL    = 1052&
%ERROR_SERVICE_REQUEST_TIMEOUT    = 1053&
%ERROR_SERVICE_NO_THREAD          = 1054&
%ERROR_SERVICE_DATABASE_LOCKED    = 1055&
%ERROR_SERVICE_ALREADY_RUNNING    = 1056&
%ERROR_INVALID_SERVICE_ACCOUNT    = 1057&
%ERROR_SERVICE_DISABLED           = 1058&
%ERROR_CIRCULAR_DEPENDENCY        = 1059&
%ERROR_SERVICE_DOES_NOT_EXIST     = 1060&
%ERROR_SERVICE_CANNOT_ACCEPT_CTRL = 1061&
%ERROR_SERVICE_NOT_ACTIVE         = 1062&
%ERROR_FAILED_SERVICE_CONTROLLER_CONNECT = 1063&
%ERROR_EXCEPTION_IN_SERVICE       = 1064&
%ERROR_DATABASE_DOES_NOT_EXIST    = 1065&
%ERROR_SERVICE_SPECIFIC_ERROR     = 1066&
%ERROR_PROCESS_ABORTED            = 1067&
%ERROR_SERVICE_DEPENDENCY_FAIL    = 1068&
%ERROR_SERVICE_LOGON_FAILED       = 1069&
%ERROR_SERVICE_START_HANG         = 1070&
%ERROR_INVALID_SERVICE_LOCK       = 1071&
%ERROR_SERVICE_MARKED_FOR_DELETE  = 1072&
%ERROR_SERVICE_EXISTS             = 1073&
%ERROR_ALREADY_RUNNING_LKG        = 1074&
%ERROR_SERVICE_DEPENDENCY_DELETED = 1075&
%ERROR_BOOT_ALREADY_ACCEPTED      = 1076&
%ERROR_SERVICE_NEVER_STARTED      = 1077&
%ERROR_DUPLICATE_SERVICE_NAME     = 1078&
%ERROR_DIFFERENT_SERVICE_ACCOUNT  = 1079&
%ERROR_CANNOT_DETECT_DRIVER_FAILURE = 1080&
%ERROR_CANNOT_DETECT_PROCESS_ABORT = 1081&
%ERROR_NO_RECOVERY_PROGRAM        = 1082&
%ERROR_SERVICE_NOT_IN_EXE         = 1083&
%ERROR_END_OF_MEDIA               = 1100&
%ERROR_FILEMARK_DETECTED          = 1101&
%ERROR_BEGINNING_OF_MEDIA         = 1102&
%ERROR_SETMARK_DETECTED           = 1103&
%ERROR_NO_DATA_DETECTED           = 1104&
%ERROR_PARTITION_FAILURE          = 1105&
%ERROR_INVALID_BLOCK_LENGTH       = 1106&
%ERROR_DEVICE_NOT_PARTITIONED     = 1107&
%ERROR_UNABLE_TO_LOCK_MEDIA       = 1108&
%ERROR_UNABLE_TO_UNLOAD_MEDIA     = 1109&
%ERROR_MEDIA_CHANGED              = 1110&
%ERROR_BUS_RESET                  = 1111&
%ERROR_NO_MEDIA_IN_DRIVE          = 1112&
%ERROR_NO_UNICODE_TRANSLATION     = 1113&
%ERROR_DLL_INIT_FAILED            = 1114&
%ERROR_SHUTDOWN_IN_PROGRESS       = 1115&
%ERROR_NO_SHUTDOWN_IN_PROGRESS    = 1116&
%ERROR_IO_DEVICE                  = 1117&
%ERROR_SERIAL_NO_DEVICE           = 1118&
%ERROR_IRQ_BUSY                   = 1119&
%ERROR_MORE_WRITES                = 1120&
%ERROR_COUNTER_TIMEOUT            = 1121&
%ERROR_FLOPPY_ID_MARK_NOT_FOUND   = 1122&
%ERROR_FLOPPY_WRONG_CYLINDER      = 1123&
%ERROR_FLOPPY_UNKNOWN_ERROR       = 1124&
%ERROR_FLOPPY_BAD_REGISTERS       = 1125&
%ERROR_DISK_RECALIBRATE_FAILED    = 1126&
%ERROR_DISK_OPERATION_FAILED      = 1127&
%ERROR_DISK_RESET_FAILED          = 1128&
%ERROR_EOM_OVERFLOW               = 1129&
%ERROR_NOT_ENOUGH_SERVER_MEMORY   = 1130&
%ERROR_POSSIBLE_DEADLOCK          = 1131&
%ERROR_MAPPED_ALIGNMENT           = 1132&
%ERROR_SET_POWER_STATE_VETOED     = 1140&
%ERROR_SET_POWER_STATE_FAILED     = 1141&
%ERROR_TOO_MANY_LINKS             = 1142&
%ERROR_OLD_WIN_VERSION            = 1150&
%ERROR_APP_WRONG_OS               = 1151&
%ERROR_SINGLE_INSTANCE_APP        = 1152&
%ERROR_RMODE_APP                  = 1153&
%ERROR_INVALID_DLL                = 1154&
%ERROR_NO_ASSOCIATION             = 1155&
%ERROR_DDE_FAIL                   = 1156&
%ERROR_DLL_NOT_FOUND              = 1157&
%ERROR_NO_MORE_USER_HANDLES       = 1158&
%ERROR_MESSAGE_SYNC_ONLY          = 1159&
%ERROR_SOURCE_ELEMENT_EMPTY       = 1160&
%ERROR_DESTINATION_ELEMENT_FULL   = 1161&
%ERROR_ILLEGAL_ELEMENT_ADDRESS    = 1162&
%ERROR_MAGAZINE_NOT_PRESENT       = 1163&
%ERROR_DEVICE_REINITIALIZATION_NEEDED = 1164&     ' dderror
%ERROR_DEVICE_REQUIRES_CLEANING   = 1165&
%ERROR_DEVICE_DOOR_OPEN           = 1166&
%ERROR_DEVICE_NOT_CONNECTED       = 1167&
%ERROR_NOT_FOUND                  = 1168&
%ERROR_NO_MATCH                   = 1169&
%ERROR_SET_NOT_FOUND              = 1170&
%ERROR_POINT_NOT_FOUND            = 1171&
%ERROR_NO_TRACKING_SERVICE        = 1172&
%ERROR_NO_VOLUME_ID               = 1173&
%ERROR_INVALID_VLM_OPERATION      = 1174&
%ERROR_UNABLE_TO_REMOVE_REPLACED  = 1175&
%ERROR_UNABLE_TO_MOVE_REPLACEMENT = 1176&
%ERROR_UNABLE_TO_MOVE_REPLACEMENT_2 = 1177&
%ERROR_JOURNAL_DELETE_IN_PROGRESS = 1178&
%ERROR_JOURNAL_NOT_ACTIVE         = 1179&
%ERROR_POTENTIAL_FILE_FOUND       = 1180&
%ERROR_JOURNAL_ENTRY_DELETED      = 1181&
%ERROR_BAD_DEVICE                 = 1200&
%ERROR_CONNECTION_UNAVAIL         = 1201&
%ERROR_DEVICE_ALREADY_REMEMBERED  = 1202&
%ERROR_NO_NET_OR_BAD_PATH         = 1203&
%ERROR_BAD_PROVIDER               = 1204&
%ERROR_CANNOT_OPEN_PROFILE        = 1205&
%ERROR_BAD_PROFILE                = 1206&
%ERROR_NOT_CONTAINER              = 1207&
%ERROR_EXTENDED_ERROR             = 1208&
%ERROR_INVALID_GROUPNAME          = 1209&
%ERROR_INVALID_COMPUTERNAME       = 1210&
%ERROR_INVALID_EVENTNAME          = 1211&
%ERROR_INVALID_DOMAINNAME         = 1212&
%ERROR_INVALID_SERVICENAME        = 1213&
%ERROR_INVALID_NETNAME            = 1214&
%ERROR_INVALID_SHARENAME          = 1215&
%ERROR_INVALID_PASSWORDNAME       = 1216&
%ERROR_INVALID_MESSAGENAME        = 1217&
%ERROR_INVALID_MESSAGEDEST        = 1218&
%ERROR_SESSION_CREDENTIAL_CONFLICT = 1219&
%ERROR_REMOTE_SESSION_LIMIT_EXCEEDED = 1220&
%ERROR_DUP_DOMAINNAME             = 1221&
%ERROR_NO_NETWORK                 = 1222&
%ERROR_CANCELLED                  = 1223&
%ERROR_USER_MAPPED_FILE           = 1224&
%ERROR_CONNECTION_REFUSED         = 1225&
%ERROR_GRACEFUL_DISCONNECT        = 1226&
%ERROR_ADDRESS_ALREADY_ASSOCIATED = 1227&
%ERROR_ADDRESS_NOT_ASSOCIATED     = 1228&
%ERROR_CONNECTION_INVALID         = 1229&
%ERROR_CONNECTION_ACTIVE          = 1230&
%ERROR_NETWORK_UNREACHABLE        = 1231&
%ERROR_HOST_UNREACHABLE           = 1232&
%ERROR_PROTOCOL_UNREACHABLE       = 1233&
%ERROR_PORT_UNREACHABLE           = 1234&
%ERROR_REQUEST_ABORTED            = 1235&
%ERROR_CONNECTION_ABORTED         = 1236&
%ERROR_RETRY                      = 1237&
%ERROR_CONNECTION_COUNT_LIMIT     = 1238&
%ERROR_LOGIN_TIME_RESTRICTION     = 1239&
%ERROR_LOGIN_WKSTA_RESTRICTION    = 1240&
%ERROR_INCORRECT_ADDRESS          = 1241&
%ERROR_ALREADY_REGISTERED         = 1242&
%ERROR_SERVICE_NOT_FOUND          = 1243&
%ERROR_NOT_AUTHENTICATED          = 1244&
%ERROR_NOT_LOGGED_ON              = 1245&
%ERROR_CONTINUE                   = 1246&     ' dderror
%ERROR_ALREADY_INITIALIZED        = 1247&
%ERROR_NO_MORE_DEVICES            = 1248&     ' dderror
%ERROR_NO_SUCH_SITE               = 1249&
%ERROR_DOMAIN_CONTROLLER_EXISTS   = 1250&
%ERROR_ONLY_IF_CONNECTED          = 1251&
%ERROR_OVERRIDE_NOCHANGES         = 1252&
%ERROR_BAD_USER_PROFILE           = 1253&
%ERROR_NOT_SUPPORTED_ON_SBS       = 1254&
%ERROR_NOT_ALL_ASSIGNED           = 1300&
%ERROR_SOME_NOT_MAPPED            = 1301&
%ERROR_NO_QUOTAS_FOR_ACCOUNT      = 1302&
%ERROR_LOCAL_USER_SESSION_KEY     = 1303&
%ERROR_NULL_LM_PASSWORD           = 1304&
%ERROR_UNKNOWN_REVISION           = 1305&
%ERROR_REVISION_MISMATCH          = 1306&
%ERROR_INVALID_OWNER              = 1307&
%ERROR_INVALID_PRIMARY_GROUP      = 1308&
%ERROR_NO_IMPERSONATION_TOKEN     = 1309&
%ERROR_CANT_DISABLE_MANDATORY     = 1310&
%ERROR_NO_LOGON_SERVERS           = 1311&
%ERROR_NO_SUCH_LOGON_SESSION      = 1312&
%ERROR_NO_SUCH_PRIVILEGE          = 1313&
%ERROR_PRIVILEGE_NOT_HELD         = 1314&
%ERROR_INVALID_ACCOUNT_NAME       = 1315&
%ERROR_USER_EXISTS                = 1316&
%ERROR_NO_SUCH_USER               = 1317&
%ERROR_GROUP_EXISTS               = 1318&
%ERROR_NO_SUCH_GROUP              = 1319&
%ERROR_MEMBER_IN_GROUP            = 1320&
%ERROR_MEMBER_NOT_IN_GROUP        = 1321&
%ERROR_LAST_ADMIN                 = 1322&
%ERROR_WRONG_PASSWORD             = 1323&
%ERROR_ILL_FORMED_PASSWORD        = 1324&
%ERROR_PASSWORD_RESTRICTION       = 1325&
%ERROR_LOGON_FAILURE              = 1326&
%ERROR_ACCOUNT_RESTRICTION        = 1327&
%ERROR_INVALID_LOGON_HOURS        = 1328&
%ERROR_INVALID_WORKSTATION        = 1329&
%ERROR_PASSWORD_EXPIRED           = 1330&
%ERROR_ACCOUNT_DISABLED           = 1331&
%ERROR_NONE_MAPPED                = 1332&
%ERROR_TOO_MANY_LUIDS_REQUESTED   = 1333&
%ERROR_LUIDS_EXHAUSTED            = 1334&
%ERROR_INVALID_SUB_AUTHORITY      = 1335&
%ERROR_INVALID_ACL                = 1336&
%ERROR_INVALID_SID                = 1337&
%ERROR_INVALID_SECURITY_DESCR     = 1338&
%ERROR_BAD_INHERITANCE_ACL        = 1340&
%ERROR_SERVER_DISABLED            = 1341&
%ERROR_SERVER_NOT_DISABLED        = 1342&
%ERROR_INVALID_ID_AUTHORITY       = 1343&
%ERROR_ALLOTTED_SPACE_EXCEEDED    = 1344&
%ERROR_INVALID_GROUP_ATTRIBUTES   = 1345&
%ERROR_BAD_IMPERSONATION_LEVEL    = 1346&
%ERROR_CANT_OPEN_ANONYMOUS        = 1347&
%ERROR_BAD_VALIDATION_CLASS       = 1348&
%ERROR_BAD_TOKEN_TYPE             = 1349&
%ERROR_NO_SECURITY_ON_OBJECT      = 1350&
%ERROR_CANT_ACCESS_DOMAIN_INFO    = 1351&
%ERROR_INVALID_SERVER_STATE       = 1352&
%ERROR_INVALID_DOMAIN_STATE       = 1353&
%ERROR_INVALID_DOMAIN_ROLE        = 1354&
%ERROR_NO_SUCH_DOMAIN             = 1355&
%ERROR_DOMAIN_EXISTS              = 1356&
%ERROR_DOMAIN_LIMIT_EXCEEDED      = 1357&
%ERROR_INTERNAL_DB_CORRUPTION     = 1358&
%ERROR_INTERNAL_ERROR             = 1359&
%ERROR_GENERIC_NOT_MAPPED         = 1360&
%ERROR_BAD_DESCRIPTOR_FORMAT      = 1361&
%ERROR_NOT_LOGON_PROCESS          = 1362&
%ERROR_LOGON_SESSION_EXISTS       = 1363&
%ERROR_NO_SUCH_PACKAGE            = 1364&
%ERROR_BAD_LOGON_SESSION_STATE    = 1365&
%ERROR_LOGON_SESSION_COLLISION    = 1366&
%ERROR_INVALID_LOGON_TYPE         = 1367&
%ERROR_CANNOT_IMPERSONATE         = 1368&
%ERROR_RXACT_INVALID_STATE        = 1369&
%ERROR_RXACT_COMMIT_FAILURE       = 1370&
%ERROR_SPECIAL_ACCOUNT            = 1371&
%ERROR_SPECIAL_GROUP              = 1372&
%ERROR_SPECIAL_USER               = 1373&
%ERROR_MEMBERS_PRIMARY_GROUP      = 1374&
%ERROR_TOKEN_ALREADY_IN_USE       = 1375&
%ERROR_NO_SUCH_ALIAS              = 1376&
%ERROR_MEMBER_NOT_IN_ALIAS        = 1377&
%ERROR_MEMBER_IN_ALIAS            = 1378&
%ERROR_ALIAS_EXISTS               = 1379&
%ERROR_LOGON_NOT_GRANTED          = 1380&
%ERROR_TOO_MANY_SECRETS           = 1381&
%ERROR_SECRET_TOO_LONG            = 1382&
%ERROR_INTERNAL_DB_ERROR          = 1383&
%ERROR_TOO_MANY_CONTEXT_IDS       = 1384&
%ERROR_LOGON_TYPE_NOT_GRANTED     = 1385&
%ERROR_NT_CROSS_ENCRYPTION_REQUIRED = 1386&
%ERROR_NO_SUCH_MEMBER             = 1387&
%ERROR_INVALID_MEMBER             = 1388&
%ERROR_TOO_MANY_SIDS              = 1389&
%ERROR_LM_CROSS_ENCRYPTION_REQUIRED = 1390&
%ERROR_NO_INHERITANCE             = 1391&
%ERROR_FILE_CORRUPT               = 1392&
%ERROR_DISK_CORRUPT               = 1393&
%ERROR_NO_USER_SESSION_KEY        = 1394&
%ERROR_LICENSE_QUOTA_EXCEEDED     = 1395&
%ERROR_WRONG_TARGET_NAME          = 1396&
%ERROR_MUTUAL_AUTH_FAILED         = 1397&
%ERROR_TIME_SKEW                  = 1398&
%ERROR_INVALID_WINDOW_HANDLE      = 1400&
%ERROR_INVALID_MENU_HANDLE        = 1401&
%ERROR_INVALID_CURSOR_HANDLE      = 1402&
%ERROR_INVALID_ACCEL_HANDLE       = 1403&
%ERROR_INVALID_HOOK_HANDLE        = 1404&
%ERROR_INVALID_DWP_HANDLE         = 1405&
%ERROR_TLW_WITH_WSCHILD           = 1406&
%ERROR_CANNOT_FIND_WND_CLASS      = 1407&
%ERROR_WINDOW_OF_OTHER_THREAD     = 1408&
%ERROR_HOTKEY_ALREADY_REGISTERED  = 1409&
%ERROR_CLASS_ALREADY_EXISTS       = 1410&
%ERROR_CLASS_DOES_NOT_EXIST       = 1411&
%ERROR_CLASS_HAS_WINDOWS          = 1412&
%ERROR_INVALID_INDEX              = 1413&
%ERROR_INVALID_ICON_HANDLE        = 1414&
%ERROR_PRIVATE_DIALOG_INDEX       = 1415&
%ERROR_LISTBOX_ID_NOT_FOUND       = 1416&
%ERROR_NO_WILDCARD_CHARACTERS     = 1417&
%ERROR_CLIPBOARD_NOT_OPEN         = 1418&
%ERROR_HOTKEY_NOT_REGISTERED      = 1419&
%ERROR_WINDOW_NOT_DIALOG          = 1420&
%ERROR_CONTROL_ID_NOT_FOUND       = 1421&
%ERROR_INVALID_COMBOBOX_MESSAGE   = 1422&
%ERROR_WINDOW_NOT_COMBOBOX        = 1423&
%ERROR_INVALID_EDIT_HEIGHT        = 1424&
%ERROR_DC_NOT_FOUND               = 1425&
%ERROR_INVALID_HOOK_FILTER        = 1426&
%ERROR_INVALID_FILTER_PROC        = 1427&
%ERROR_HOOK_NEEDS_HMOD            = 1428&
%ERROR_GLOBAL_ONLY_HOOK           = 1429&
%ERROR_PUBLIC_ONLY_HOOK           = 1429&
%ERROR_JOURNAL_HOOK_SET           = 1430&
%ERROR_HOOK_NOT_INSTALLED         = 1431&
%ERROR_INVALID_LB_MESSAGE         = 1432&
%ERROR_SETCOUNT_ON_BAD_LB         = 1433&
%ERROR_LB_WITHOUT_TABSTOPS        = 1434&
%ERROR_DESTROY_OBJECT_OF_OTHER_THREAD = 1435&
%ERROR_CHILD_WINDOW_MENU          = 1436&
%ERROR_NO_SYSTEM_MENU             = 1437&
%ERROR_INVALID_MSGBOX_STYLE       = 1438&
%ERROR_INVALID_SPI_VALUE          = 1439&
%ERROR_SCREEN_ALREADY_LOCKED      = 1440&
%ERROR_HWNDS_HAVE_DIFF_PARENT     = 1441&
%ERROR_NOT_CHILD_WINDOW           = 1442&
%ERROR_INVALID_GW_COMMAND         = 1443&
%ERROR_INVALID_THREAD_ID          = 1444&
%ERROR_NON_MDICHILD_WINDOW        = 1445&
%ERROR_POPUP_ALREADY_ACTIVE       = 1446&
%ERROR_NO_SCROLLBARS              = 1447&
%ERROR_INVALID_SCROLLBAR_RANGE    = 1448&
%ERROR_INVALID_SHOWWIN_COMMAND    = 1449&
%ERROR_NO_SYSTEM_RESOURCES        = 1450&
%ERROR_NONPAGED_SYSTEM_RESOURCES  = 1451&
%ERROR_PAGED_SYSTEM_RESOURCES     = 1452&
%ERROR_WORKING_SET_QUOTA          = 1453&
%ERROR_PAGEFILE_QUOTA             = 1454&
%ERROR_COMMITMENT_LIMIT           = 1455&
%ERROR_MENU_ITEM_NOT_FOUND        = 1456&
%ERROR_INVALID_KEYBOARD_HANDLE    = 1457&
%ERROR_HOOK_TYPE_NOT_ALLOWED      = 1458&
%ERROR_REQUIRES_INTERACTIVE_WINDOWSTATION = 1459&
%ERROR_TIMEOUT                    = 1460&
%ERROR_INVALID_MONITOR_HANDLE     = 1461&
%ERROR_EVENTLOG_FILE_CORRUPT      = 1500&
%ERROR_EVENTLOG_CANT_START        = 1501&
%ERROR_LOG_FILE_FULL              = 1502&
%ERROR_EVENTLOG_FILE_CHANGED      = 1503&
%ERROR_INSTALL_SERVICE_FAILURE    = 1601&
%ERROR_INSTALL_USEREXIT           = 1602&
%ERROR_INSTALL_FAILURE            = 1603&
%ERROR_INSTALL_SUSPEND            = 1604&
%ERROR_UNKNOWN_PRODUCT            = 1605&
%ERROR_UNKNOWN_FEATURE            = 1606&
%ERROR_UNKNOWN_COMPONENT          = 1607&
%ERROR_UNKNOWN_PROPERTY           = 1608&
%ERROR_INVALID_HANDLE_STATE       = 1609&
%ERROR_BAD_CONFIGURATION          = 1610&
%ERROR_INDEX_ABSENT               = 1611&
%ERROR_INSTALL_SOURCE_ABSENT      = 1612&
%ERROR_INSTALL_PACKAGE_VERSION    = 1613&
%ERROR_PRODUCT_UNINSTALLED        = 1614&
%ERROR_BAD_QUERY_SYNTAX           = 1615&
%ERROR_INVALID_FIELD              = 1616&
%ERROR_DEVICE_REMOVED             = 1617&
%ERROR_INSTALL_ALREADY_RUNNING    = 1618&
%ERROR_INSTALL_PACKAGE_OPEN_FAILED = 1619&
%ERROR_INSTALL_PACKAGE_INVALID    = 1620&
%ERROR_INSTALL_UI_FAILURE         = 1621&
%ERROR_INSTALL_LOG_FAILURE        = 1622&
%ERROR_INSTALL_LANGUAGE_UNSUPPORTED = 1623&
%ERROR_INSTALL_TRANSFORM_FAILURE  = 1624&
%ERROR_INSTALL_PACKAGE_REJECTED   = 1625&
%ERROR_FUNCTION_NOT_CALLED        = 1626&
%ERROR_FUNCTION_FAILED            = 1627&
%ERROR_INVALID_TABLE              = 1628&
%ERROR_DATATYPE_MISMATCH          = 1629&
%ERROR_UNSUPPORTED_TYPE           = 1630&
%ERROR_CREATE_FAILED              = 1631&
%ERROR_INSTALL_TEMP_UNWRITABLE    = 1632&
%ERROR_INSTALL_PLATFORM_UNSUPPORTED = 1633&
%ERROR_INSTALL_NOTUSED            = 1634&
%ERROR_PATCH_PACKAGE_OPEN_FAILED  = 1635&
%ERROR_PATCH_PACKAGE_INVALID      = 1636&
%ERROR_PATCH_PACKAGE_UNSUPPORTED  = 1637&
%ERROR_PRODUCT_VERSION            = 1638&
%ERROR_INVALID_COMMAND_LINE       = 1639&
%ERROR_INSTALL_REMOTE_DISALLOWED  = 1640&
%ERROR_SUCCESS_REBOOT_INITIATED   = 1641&
%ERROR_PATCH_TARGET_NOT_FOUND     = 1642&
%RPC_S_INVALID_STRING_BINDING     = 1700&
%RPC_S_WRONG_KIND_OF_BINDING      = 1701&
%RPC_S_INVALID_BINDING            = 1702&
%RPC_S_PROTSEQ_NOT_SUPPORTED      = 1703&
%RPC_S_INVALID_RPC_PROTSEQ        = 1704&
%RPC_S_INVALID_STRING_UUID        = 1705&
%RPC_S_INVALID_ENDPOINT_FORMAT    = 1706&
%RPC_S_INVALID_NET_ADDR           = 1707&
%RPC_S_NO_ENDPOINT_FOUND          = 1708&
%RPC_S_INVALID_TIMEOUT            = 1709&
%RPC_S_OBJECT_NOT_FOUND           = 1710&
%RPC_S_ALREADY_REGISTERED         = 1711&
%RPC_S_TYPE_ALREADY_REGISTERED    = 1712&
%RPC_S_ALREADY_LISTENING          = 1713&
%RPC_S_NO_PROTSEQS_REGISTERED     = 1714&
%RPC_S_NOT_LISTENING              = 1715&
%RPC_S_UNKNOWN_MGR_TYPE           = 1716&
%RPC_S_UNKNOWN_IF                 = 1717&
%RPC_S_NO_BINDINGS                = 1718&
%RPC_S_NO_PROTSEQS                = 1719&
%RPC_S_CANT_CREATE_ENDPOINT       = 1720&
%RPC_S_OUT_OF_RESOURCES           = 1721&
%RPC_S_SERVER_UNAVAILABLE         = 1722&
%RPC_S_SERVER_TOO_BUSY            = 1723&
%RPC_S_INVALID_NETWORK_OPTIONS    = 1724&
%RPC_S_NO_CALL_ACTIVE             = 1725&
%RPC_S_CALL_FAILED                = 1726&
%RPC_S_CALL_FAILED_DNE            = 1727&
%RPC_S_PROTOCOL_ERROR             = 1728&
%RPC_S_UNSUPPORTED_TRANS_SYN      = 1730&
%RPC_S_UNSUPPORTED_TYPE           = 1732&
%RPC_S_INVALID_TAG                = 1733&
%RPC_S_INVALID_BOUND              = 1734&
%RPC_S_NO_ENTRY_NAME              = 1735&
%RPC_S_INVALID_NAME_SYNTAX        = 1736&
%RPC_S_UNSUPPORTED_NAME_SYNTAX    = 1737&
%RPC_S_UUID_NO_ADDRESS            = 1739&
%RPC_S_DUPLICATE_ENDPOINT         = 1740&
%RPC_S_UNKNOWN_AUTHN_TYPE         = 1741&
%RPC_S_MAX_CALLS_TOO_SMALL        = 1742&
%RPC_S_STRING_TOO_LONG            = 1743&
%RPC_S_PROTSEQ_NOT_FOUND          = 1744&
%RPC_S_PROCNUM_OUT_OF_RANGE       = 1745&
%RPC_S_BINDING_HAS_NO_AUTH        = 1746&
%RPC_S_UNKNOWN_AUTHN_SERVICE      = 1747&
%RPC_S_UNKNOWN_AUTHN_LEVEL        = 1748&
%RPC_S_INVALID_AUTH_IDENTITY      = 1749&
%RPC_S_UNKNOWN_AUTHZ_SERVICE      = 1750&
%EPT_S_INVALID_ENTRY              = 1751&
%EPT_S_CANT_PERFORM_OP            = 1752&
%EPT_S_NOT_REGISTERED             = 1753&
%RPC_S_NOTHING_TO_EXPORT          = 1754&
%RPC_S_INCOMPLETE_NAME            = 1755&
%RPC_S_INVALID_VERS_OPTION        = 1756&
%RPC_S_NO_MORE_MEMBERS            = 1757&
%RPC_S_NOT_ALL_OBJS_UNEXPORTED    = 1758&
%RPC_S_INTERFACE_NOT_FOUND        = 1759&
%RPC_S_ENTRY_ALREADY_EXISTS       = 1760&
%RPC_S_ENTRY_NOT_FOUND            = 1761&
%RPC_S_NAME_SERVICE_UNAVAILABLE   = 1762&
%RPC_S_INVALID_NAF_ID             = 1763&
%RPC_S_CANNOT_SUPPORT             = 1764&
%RPC_S_NO_CONTEXT_AVAILABLE       = 1765&
%RPC_S_INTERNAL_ERROR             = 1766&
%RPC_S_ZERO_DIVIDE                = 1767&
%RPC_S_ADDRESS_ERROR              = 1768&
%RPC_S_FP_DIV_ZERO                = 1769&
%RPC_S_FP_UNDERFLOW               = 1770&
%RPC_S_FP_OVERFLOW                = 1771&
%RPC_X_NO_MORE_ENTRIES            = 1772&
%RPC_X_SS_CHAR_TRANS_OPEN_FAIL    = 1773&
%RPC_X_SS_CHAR_TRANS_SHORT_FILE   = 1774&
%RPC_X_SS_IN_NULL_CONTEXT         = 1775&
%RPC_X_SS_CONTEXT_DAMAGED         = 1777&
%RPC_X_SS_HANDLES_MISMATCH        = 1778&
%RPC_X_SS_CANNOT_GET_CALL_HANDLE  = 1779&
%RPC_X_NULL_REF_POINTER           = 1780&
%RPC_X_ENUM_VALUE_OUT_OF_RANGE    = 1781&
%RPC_X_BYTE_COUNT_TOO_SMALL       = 1782&
%RPC_X_BAD_STUB_DATA              = 1783&
%ERROR_INVALID_USER_BUFFER        = 1784&
%ERROR_UNRECOGNIZED_MEDIA         = 1785&
%ERROR_NO_TRUST_LSA_SECRET        = 1786&
%ERROR_NO_TRUST_SAM_ACCOUNT       = 1787&
%ERROR_TRUSTED_DOMAIN_FAILURE     = 1788&
%ERROR_TRUSTED_RELATIONSHIP_FAILURE = 1789&
%ERROR_TRUST_FAILURE              = 1790&
%RPC_S_CALL_IN_PROGRESS           = 1791&
%ERROR_NETLOGON_NOT_STARTED       = 1792&
%ERROR_ACCOUNT_EXPIRED            = 1793&
%ERROR_REDIRECTOR_HAS_OPEN_HANDLES = 1794&
%ERROR_PRINTER_DRIVER_ALREADY_INSTALLED = 1795&
%ERROR_UNKNOWN_PORT               = 1796&
%ERROR_UNKNOWN_PRINTER_DRIVER     = 1797&
%ERROR_UNKNOWN_PRINTPROCESSOR     = 1798&
%ERROR_INVALID_SEPARATOR_FILE     = 1799&
%ERROR_INVALID_PRIORITY           = 1800&
%ERROR_INVALID_PRINTER_NAME       = 1801&
%ERROR_PRINTER_ALREADY_EXISTS     = 1802&
%ERROR_INVALID_PRINTER_COMMAND    = 1803&
%ERROR_INVALID_DATATYPE           = 1804&
%ERROR_INVALID_ENVIRONMENT        = 1805&
%RPC_S_NO_MORE_BINDINGS           = 1806&
%ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT = 1807&
%ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT = 1808&
%ERROR_NOLOGON_SERVER_TRUST_ACCOUNT = 1809&
%ERROR_DOMAIN_TRUST_INCONSISTENT  = 1810&
%ERROR_SERVER_HAS_OPEN_HANDLES    = 1811&
%ERROR_RESOURCE_DATA_NOT_FOUND    = 1812&
%ERROR_RESOURCE_TYPE_NOT_FOUND    = 1813&
%ERROR_RESOURCE_NAME_NOT_FOUND    = 1814&
%ERROR_RESOURCE_LANG_NOT_FOUND    = 1815&
%ERROR_NOT_ENOUGH_QUOTA           = 1816&
%RPC_S_NO_INTERFACES              = 1817&
%RPC_S_CALL_CANCELLED             = 1818&
%RPC_S_BINDING_INCOMPLETE         = 1819&
%RPC_S_COMM_FAILURE               = 1820&
%RPC_S_UNSUPPORTED_AUTHN_LEVEL    = 1821&
%RPC_S_NO_PRINC_NAME              = 1822&
%RPC_S_NOT_RPC_ERROR              = 1823&
%RPC_S_UUID_LOCAL_ONLY            = 1824&
%RPC_S_SEC_PKG_ERROR              = 1825&
%RPC_S_NOT_CANCELLED              = 1826&
%RPC_X_INVALID_ES_ACTION          = 1827&
%RPC_X_WRONG_ES_VERSION           = 1828&
%RPC_X_WRONG_STUB_VERSION         = 1829&
%RPC_X_INVALID_PIPE_OBJECT        = 1830&
%RPC_X_WRONG_PIPE_ORDER           = 1831&
%RPC_X_WRONG_PIPE_VERSION         = 1832&
%RPC_S_GROUP_MEMBER_NOT_FOUND     = 1898&
%EPT_S_CANT_CREATE                = 1899&
%RPC_S_INVALID_OBJECT             = 1900&
%ERROR_INVALID_TIME               = 1901&
%ERROR_INVALID_FORM_NAME          = 1902&
%ERROR_INVALID_FORM_SIZE          = 1903&
%ERROR_ALREADY_WAITING            = 1904&
%ERROR_PRINTER_DELETED            = 1905&
%ERROR_INVALID_PRINTER_STATE      = 1906&
%ERROR_PASSWORD_MUST_CHANGE       = 1907&
%ERROR_DOMAIN_CONTROLLER_NOT_FOUND = 1908&
%ERROR_ACCOUNT_LOCKED_OUT         = 1909&
%OR_INVALID_OXID                  = 1910&
%OR_INVALID_OID                   = 1911&
%OR_INVALID_SET                   = 1912&
%RPC_S_SEND_INCOMPLETE            = 1913&
%RPC_S_INVALID_ASYNC_HANDLE       = 1914&
%RPC_S_INVALID_ASYNC_CALL         = 1915&
%RPC_X_PIPE_CLOSED                = 1916&
%RPC_X_PIPE_DISCIPLINE_ERROR      = 1917&
%RPC_X_PIPE_EMPTY                 = 1918&
%ERROR_NO_SITENAME                = 1919&
%ERROR_CANT_ACCESS_FILE           = 1920&
%ERROR_CANT_RESOLVE_FILENAME      = 1921&
%RPC_S_ENTRY_TYPE_MISMATCH        = 1922&
%RPC_S_NOT_ALL_OBJS_EXPORTED      = 1923&
%RPC_S_INTERFACE_NOT_EXPORTED     = 1924&
%RPC_S_PROFILE_NOT_ADDED          = 1925&
%RPC_S_PRF_ELT_NOT_ADDED          = 1926&
%RPC_S_PRF_ELT_NOT_REMOVED        = 1927&
%RPC_S_GRP_ELT_NOT_ADDED          = 1928&
%RPC_S_GRP_ELT_NOT_REMOVED        = 1929&
%ERROR_NO_BROWSER_SERVERS_FOUND   = 6118&
%ERROR_INVALID_PIXEL_FORMAT       = 2000&
%ERROR_BAD_DRIVER                 = 2001&
%ERROR_INVALID_WINDOW_STYLE       = 2002&
%ERROR_METAFILE_NOT_SUPPORTED     = 2003&
%ERROR_TRANSFORM_NOT_SUPPORTED    = 2004&
%ERROR_CLIPPING_NOT_SUPPORTED     = 2005&
%ERROR_INVALID_CMM                = 2010&
%ERROR_INVALID_PROFILE            = 2011&
%ERROR_TAG_NOT_FOUND              = 2012&
%ERROR_TAG_NOT_PRESENT            = 2013&
%ERROR_DUPLICATE_TAG              = 2014&
%ERROR_PROFILE_NOT_ASSOCIATED_WITH_DEVICE = 2015&
%ERROR_PROFILE_NOT_FOUND          = 2016&
%ERROR_INVALID_COLORSPACE         = 2017&
%ERROR_ICM_NOT_ENABLED            = 2018&
%ERROR_DELETING_ICM_XFORM         = 2019&
%ERROR_INVALID_TRANSFORM          = 2020&
%ERROR_COLORSPACE_MISMATCH        = 2021&
%ERROR_INVALID_COLORINDEX         = 2022&
%ERROR_CONNECTED_OTHER_PASSWORD   = 2108&
%ERROR_BAD_USERNAME               = 2202&
%ERROR_NOT_CONNECTED              = 2250&
%ERROR_OPEN_FILES                 = 2401&
%ERROR_ACTIVE_CONNECTIONS         = 2402&
%ERROR_DEVICE_IN_USE              = 2404&
%ERROR_UNKNOWN_PRINT_MONITOR      = 3000&
%ERROR_PRINTER_DRIVER_IN_USE      = 3001&
%ERROR_SPOOL_FILE_NOT_FOUND       = 3002&
%ERROR_SPL_NO_STARTDOC            = 3003&
%ERROR_SPL_NO_ADDJOB              = 3004&
%ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED = 3005&
%ERROR_PRINT_MONITOR_ALREADY_INSTALLED = 3006&
%ERROR_INVALID_PRINT_MONITOR      = 3007&
%ERROR_PRINT_MONITOR_IN_USE       = 3008&
%ERROR_PRINTER_HAS_JOBS_QUEUED    = 3009&
%ERROR_SUCCESS_REBOOT_REQUIRED    = 3010&
%ERROR_SUCCESS_RESTART_REQUIRED   = 3011&
%ERROR_PRINTER_NOT_FOUND          = 3012&
%ERROR_WINS_INTERNAL              = 4000&
%ERROR_CAN_NOT_DEL_LOCAL_WINS     = 4001&
%ERROR_STATIC_INIT                = 4002&
%ERROR_INC_BACKUP                 = 4003&
%ERROR_FULL_BACKUP                = 4004&
%ERROR_REC_NON_EXISTENT           = 4005&
%ERROR_RPL_NOT_ALLOWED            = 4006&
%ERROR_DHCP_ADDRESS_CONFLICT      = 4100&
%ERROR_WMI_GUID_NOT_FOUND         = 4200&
%ERROR_WMI_INSTANCE_NOT_FOUND     = 4201&
%ERROR_WMI_ITEMID_NOT_FOUND       = 4202&
%ERROR_WMI_TRY_AGAIN              = 4203&
%ERROR_WMI_DP_NOT_FOUND           = 4204&
%ERROR_WMI_UNRESOLVED_INSTANCE_REF = 4205&
%ERROR_WMI_ALREADY_ENABLED        = 4206&
%ERROR_WMI_GUID_DISCONNECTED      = 4207&
%ERROR_WMI_SERVER_UNAVAILABLE     = 4208&
%ERROR_WMI_DP_FAILED              = 4209&
%ERROR_WMI_INVALID_MOF            = 4210&
%ERROR_WMI_INVALID_REGINFO        = 4211&
%ERROR_WMI_ALREADY_DISABLED       = 4212&
%ERROR_WMI_READ_ONLY              = 4213&
%ERROR_WMI_SET_FAILURE            = 4214&
%ERROR_INVALID_MEDIA              = 4300&
%ERROR_INVALID_LIBRARY            = 4301&
%ERROR_INVALID_MEDIA_POOL         = 4302&
%ERROR_DRIVE_MEDIA_MISMATCH       = 4303&
%ERROR_MEDIA_OFFLINE              = 4304&
%ERROR_LIBRARY_OFFLINE            = 4305&
%ERROR_EMPTY                      = 4306&
%ERROR_NOT_EMPTY                  = 4307&
%ERROR_MEDIA_UNAVAILABLE          = 4308&
%ERROR_RESOURCE_DISABLED          = 4309&
%ERROR_INVALID_CLEANER            = 4310&
%ERROR_UNABLE_TO_CLEAN            = 4311&
%ERROR_OBJECT_NOT_FOUND           = 4312&
%ERROR_DATABASE_FAILURE           = 4313&
%ERROR_DATABASE_FULL              = 4314&
%ERROR_MEDIA_INCOMPATIBLE         = 4315&
%ERROR_RESOURCE_NOT_PRESENT       = 4316&
%ERROR_INVALID_OPERATION          = 4317&
%ERROR_MEDIA_NOT_AVAILABLE        = 4318&
%ERROR_DEVICE_NOT_AVAILABLE       = 4319&
%ERROR_REQUEST_REFUSED            = 4320&
%ERROR_INVALID_DRIVE_OBJECT       = 4321&
%ERROR_LIBRARY_FULL               = 4322&
%ERROR_MEDIUM_NOT_ACCESSIBLE      = 4323&
%ERROR_UNABLE_TO_LOAD_MEDIUM      = 4324&
%ERROR_UNABLE_TO_INVENTORY_DRIVE  = 4325&
%ERROR_UNABLE_TO_INVENTORY_SLOT   = 4326&
%ERROR_UNABLE_TO_INVENTORY_TRANSPORT = 4327&
%ERROR_TRANSPORT_FULL             = 4328&
%ERROR_CONTROLLING_IEPORT         = 4329&
%ERROR_UNABLE_TO_EJECT_MOUNTED_MEDIA = 4330&
%ERROR_CLEANER_SLOT_SET           = 4331&
%ERROR_CLEANER_SLOT_NOT_SET       = 4332&
%ERROR_CLEANER_CARTRIDGE_SPENT    = 4333&
%ERROR_UNEXPECTED_OMID            = 4334&
%ERROR_CANT_DELETE_LAST_ITEM      = 4335&
%ERROR_MESSAGE_EXCEEDS_MAX_SIZE   = 4336&
%ERROR_VOLUME_CONTAINS_SYS_FILES  = 4337&
%ERROR_INDIGENOUS_TYPE            = 4338&
%ERROR_NO_SUPPORTING_DRIVES       = 4339&
%ERROR_FILE_OFFLINE               = 4350&
%ERROR_REMOTE_STORAGE_NOT_ACTIVE  = 4351&
%ERROR_REMOTE_STORAGE_MEDIA_ERROR = 4352&
%ERROR_NOT_A_REPARSE_POINT        = 4390&
%ERROR_REPARSE_ATTRIBUTE_CONFLICT = 4391&
%ERROR_INVALID_REPARSE_DATA       = 4392&
%ERROR_REPARSE_TAG_INVALID        = 4393&
%ERROR_REPARSE_TAG_MISMATCH       = 4394&
%ERROR_VOLUME_NOT_SIS_ENABLED     = 4500&
%ERROR_DEPENDENT_RESOURCE_EXISTS  = 5001&
%ERROR_DEPENDENCY_NOT_FOUND       = 5002&
%ERROR_DEPENDENCY_ALREADY_EXISTS  = 5003&
%ERROR_RESOURCE_NOT_ONLINE        = 5004&
%ERROR_HOST_NODE_NOT_AVAILABLE    = 5005&
%ERROR_RESOURCE_NOT_AVAILABLE     = 5006&
%ERROR_RESOURCE_NOT_FOUND         = 5007&
%ERROR_SHUTDOWN_CLUSTER           = 5008&
%ERROR_CANT_EVICT_ACTIVE_NODE     = 5009&
%ERROR_OBJECT_ALREADY_EXISTS      = 5010&
%ERROR_OBJECT_IN_LIST             = 5011&
%ERROR_GROUP_NOT_AVAILABLE        = 5012&
%ERROR_GROUP_NOT_FOUND            = 5013&
%ERROR_GROUP_NOT_ONLINE           = 5014&
%ERROR_HOST_NODE_NOT_RESOURCE_OWNER = 5015&
%ERROR_HOST_NODE_NOT_GROUP_OWNER  = 5016&
%ERROR_RESMON_CREATE_FAILED       = 5017&
%ERROR_RESMON_ONLINE_FAILED       = 5018&
%ERROR_RESOURCE_ONLINE            = 5019&
%ERROR_QUORUM_RESOURCE            = 5020&
%ERROR_NOT_QUORUM_CAPABLE         = 5021&
%ERROR_CLUSTER_SHUTTING_DOWN      = 5022&
%ERROR_INVALID_STATE              = 5023&
%ERROR_RESOURCE_PROPERTIES_STORED = 5024&
%ERROR_NOT_QUORUM_CLASS           = 5025&
%ERROR_CORE_RESOURCE              = 5026&
%ERROR_QUORUM_RESOURCE_ONLINE_FAILED = 5027&
%ERROR_QUORUMLOG_OPEN_FAILED      = 5028&
%ERROR_CLUSTERLOG_CORRUPT         = 5029&
%ERROR_CLUSTERLOG_RECORD_EXCEEDS_MAXSIZE = 5030&
%ERROR_CLUSTERLOG_EXCEEDS_MAXSIZE = 5031&
%ERROR_CLUSTERLOG_CHKPOINT_NOT_FOUND = 5032&
%ERROR_CLUSTERLOG_NOT_ENOUGH_SPACE = 5033&
%ERROR_QUORUM_OWNER_ALIVE         = 5034&
%ERROR_NETWORK_NOT_AVAILABLE      = 5035&
%ERROR_NODE_NOT_AVAILABLE         = 5036&
%ERROR_ALL_NODES_NOT_AVAILABLE    = 5037&
%ERROR_RESOURCE_FAILED            = 5038&
%ERROR_CLUSTER_INVALID_NODE       = 5039&
%ERROR_CLUSTER_NODE_EXISTS        = 5040&
%ERROR_CLUSTER_JOIN_IN_PROGRESS   = 5041&
%ERROR_CLUSTER_NODE_NOT_FOUND     = 5042&
%ERROR_CLUSTER_LOCAL_NODE_NOT_FOUND = 5043&
%ERROR_CLUSTER_NETWORK_EXISTS     = 5044&
%ERROR_CLUSTER_NETWORK_NOT_FOUND  = 5045&
%ERROR_CLUSTER_NETINTERFACE_EXISTS = 5046&
%ERROR_CLUSTER_NETINTERFACE_NOT_FOUND = 5047&
%ERROR_CLUSTER_INVALID_REQUEST    = 5048&
%ERROR_CLUSTER_INVALID_NETWORK_PROVIDER = 5049&
%ERROR_CLUSTER_NODE_DOWN          = 5050&
%ERROR_CLUSTER_NODE_UNREACHABLE   = 5051&
%ERROR_CLUSTER_NODE_NOT_MEMBER    = 5052&
%ERROR_CLUSTER_JOIN_NOT_IN_PROGRESS = 5053&
%ERROR_CLUSTER_INVALID_NETWORK    = 5054&
%ERROR_CLUSTER_NODE_UP            = 5056&
%ERROR_CLUSTER_IPADDR_IN_USE      = 5057&
%ERROR_CLUSTER_NODE_NOT_PAUSED    = 5058&
%ERROR_CLUSTER_NO_SECURITY_CONTEXT = 5059&
%ERROR_CLUSTER_NETWORK_NOT_INTERNAL = 5060&
%ERROR_CLUSTER_NODE_ALREADY_UP    = 5061&
%ERROR_CLUSTER_NODE_ALREADY_DOWN  = 5062&
%ERROR_CLUSTER_NETWORK_ALREADY_ONLINE = 5063&
%ERROR_CLUSTER_NETWORK_ALREADY_OFFLINE = 5064&
%ERROR_CLUSTER_NODE_ALREADY_MEMBER = 5065&
%ERROR_CLUSTER_LAST_INTERNAL_NETWORK = 5066&
%ERROR_CLUSTER_NETWORK_HAS_DEPENDENTS = 5067&
%ERROR_INVALID_OPERATION_ON_QUORUM = 5068&
%ERROR_DEPENDENCY_NOT_ALLOWED     = 5069&
%ERROR_CLUSTER_NODE_PAUSED        = 5070&
%ERROR_NODE_CANT_HOST_RESOURCE    = 5071&
%ERROR_CLUSTER_NODE_NOT_READY     = 5072&
%ERROR_CLUSTER_NODE_SHUTTING_DOWN = 5073&
%ERROR_CLUSTER_JOIN_ABORTED       = 5074&
%ERROR_CLUSTER_INCOMPATIBLE_VERSIONS = 5075&
%ERROR_CLUSTER_MAXNUM_OF_RESOURCES_EXCEEDED = 5076&
%ERROR_CLUSTER_SYSTEM_CONFIG_CHANGED = 5077&
%ERROR_CLUSTER_RESOURCE_TYPE_NOT_FOUND = 5078&
%ERROR_CLUSTER_RESTYPE_NOT_SUPPORTED = 5079&
%ERROR_CLUSTER_RESNAME_NOT_FOUND  = 5080&
%ERROR_CLUSTER_NO_RPC_PACKAGES_REGISTERED = 5081&
%ERROR_CLUSTER_OWNER_NOT_IN_PREFLIST = 5082&
%ERROR_CLUSTER_DATABASE_SEQMISMATCH = 5083&
%ERROR_RESMON_INVALID_STATE       = 5084&
%ERROR_CLUSTER_GUM_NOT_LOCKER     = 5085&
%ERROR_QUORUM_DISK_NOT_FOUND      = 5086&
%ERROR_DATABASE_BACKUP_CORRUPT    = 5087&
%ERROR_CLUSTER_NODE_ALREADY_HAS_DFS_ROOT = 5088&
%ERROR_RESOURCE_PROPERTY_UNCHANGEABLE = 5089&
%ERROR_ENCRYPTION_FAILED          = 6000&
%ERROR_DECRYPTION_FAILED          = 6001&
%ERROR_FILE_ENCRYPTED             = 6002&
%ERROR_NO_RECOVERY_POLICY         = 6003&
%ERROR_NO_EFS                     = 6004&
%ERROR_WRONG_EFS                  = 6005&
%ERROR_NO_USER_KEYS               = 6006&
%ERROR_FILE_NOT_ENCRYPTED         = 6007&
%ERROR_NOT_EXPORT_FORMAT          = 6008&
%ERROR_FILE_READ_ONLY             = 6009&
%ERROR_DIR_EFS_DISALLOWED         = 6010&
%ERROR_EFS_SERVER_NOT_TRUSTED     = 6011&
%SCHED_E_SERVICE_NOT_LOCALSYSTEM  = 6200&
%ERROR_CTX_WINSTATION_NAME_INVALID = 7001&
%ERROR_CTX_INVALID_PD             = 7002&
%ERROR_CTX_PD_NOT_FOUND           = 7003&
%ERROR_CTX_WD_NOT_FOUND           = 7004&
%ERROR_CTX_CANNOT_MAKE_EVENTLOG_ENTRY = 7005&
%ERROR_CTX_SERVICE_NAME_COLLISION = 7006&
%ERROR_CTX_CLOSE_PENDING          = 7007&
%ERROR_CTX_NO_OUTBUF              = 7008&
%ERROR_CTX_MODEM_INF_NOT_FOUND    = 7009&
%ERROR_CTX_INVALID_MODEMNAME      = 7010&
%ERROR_CTX_MODEM_RESPONSE_ERROR   = 7011&
%ERROR_CTX_MODEM_RESPONSE_TIMEOUT = 7012&
%ERROR_CTX_MODEM_RESPONSE_NO_CARRIER = 7013&
%ERROR_CTX_MODEM_RESPONSE_NO_DIALTONE = 7014&
%ERROR_CTX_MODEM_RESPONSE_BUSY    = 7015&
%ERROR_CTX_MODEM_RESPONSE_VOICE   = 7016&
%ERROR_CTX_TD_ERROR               = 7017&
%ERROR_CTX_WINSTATION_NOT_FOUND   = 7022&
%ERROR_CTX_WINSTATION_ALREADY_EXISTS = 7023&
%ERROR_CTX_WINSTATION_BUSY        = 7024&
%ERROR_CTX_BAD_VIDEO_MODE         = 7025&
%ERROR_CTX_GRAPHICS_INVALID       = 7035&
%ERROR_CTX_LOGON_DISABLED         = 7037&
%ERROR_CTX_NOT_CONSOLE            = 7038&
%ERROR_CTX_CLIENT_QUERY_TIMEOUT   = 7040&
%ERROR_CTX_CONSOLE_DISCONNECT     = 7041&
%ERROR_CTX_CONSOLE_CONNECT        = 7042&
%ERROR_CTX_SHADOW_DENIED          = 7044&
%ERROR_CTX_WINSTATION_ACCESS_DENIED = 7045&
%ERROR_CTX_INVALID_WD             = 7049&
%ERROR_CTX_SHADOW_INVALID         = 7050&
%ERROR_CTX_SHADOW_DISABLED        = 7051&
%ERROR_CTX_CLIENT_LICENSE_IN_USE  = 7052&
%ERROR_CTX_CLIENT_LICENSE_NOT_SET = 7053&
%ERROR_CTX_LICENSE_NOT_AVAILABLE  = 7054&
%ERROR_CTX_LICENSE_CLIENT_INVALID = 7055&
%ERROR_CTX_LICENSE_EXPIRED        = 7056&
%FRS_ERR_INVALID_API_SEQUENCE     = 8001&
%FRS_ERR_STARTING_SERVICE         = 8002&
%FRS_ERR_STOPPING_SERVICE         = 8003&
%FRS_ERR_INTERNAL_API             = 8004&
%FRS_ERR_INTERNAL                 = 8005&
%FRS_ERR_SERVICE_COMM             = 8006&
%FRS_ERR_INSUFFICIENT_PRIV        = 8007&
%FRS_ERR_AUTHENTICATION           = 8008&
%FRS_ERR_PARENT_INSUFFICIENT_PRIV = 8009&
%FRS_ERR_PARENT_AUTHENTICATION    = 8010&
%FRS_ERR_CHILD_TO_PARENT_COMM     = 8011&
%FRS_ERR_PARENT_TO_CHILD_COMM     = 8012&
%FRS_ERR_SYSVOL_POPULATE          = 8013&
%FRS_ERR_SYSVOL_POPULATE_TIMEOUT  = 8014&
%FRS_ERR_SYSVOL_IS_BUSY           = 8015&
%FRS_ERR_SYSVOL_DEMOTE            = 8016&
%FRS_ERR_INVALID_SERVICE_PARAMETER = 8017&
%DS_S_SUCCESS                      = %NO_ERROR
%ERROR_DS_NOT_INSTALLED            = 8200&
%ERROR_DS_MEMBERSHIP_EVALUATED_LOCALLY = 8201&
%ERROR_DS_NO_ATTRIBUTE_OR_VALUE    = 8202&
%ERROR_DS_INVALID_ATTRIBUTE_SYNTAX = 8203&
%ERROR_DS_ATTRIBUTE_TYPE_UNDEFINED = 8204&
%ERROR_DS_ATTRIBUTE_OR_VALUE_EXISTS = 8205&
%ERROR_DS_BUSY                    = 8206&
%ERROR_DS_UNAVAILABLE             = 8207&
%ERROR_DS_NO_RIDS_ALLOCATED       = 8208&
%ERROR_DS_NO_MORE_RIDS            = 8209&
%ERROR_DS_INCORRECT_ROLE_OWNER    = 8210&
%ERROR_DS_RIDMGR_INIT_ERROR       = 8211&
%ERROR_DS_OBJ_CLASS_VIOLATION     = 8212&
%ERROR_DS_CANT_ON_NON_LEAF        = 8213&
%ERROR_DS_CANT_ON_RDN             = 8214&
%ERROR_DS_CANT_MOD_OBJ_CLASS      = 8215&
%ERROR_DS_CROSS_DOM_MOVE_ERROR    = 8216&
%ERROR_DS_GC_NOT_AVAILABLE        = 8217&
%ERROR_SHARED_POLICY              = 8218&
%ERROR_POLICY_OBJECT_NOT_FOUND    = 8219&
%ERROR_POLICY_ONLY_IN_DS          = 8220&
%ERROR_PROMOTION_ACTIVE           = 8221&
%ERROR_NO_PROMOTION_ACTIVE        = 8222&
%ERROR_DS_OPERATIONS_ERROR        = 8224&
%ERROR_DS_PROTOCOL_ERROR          = 8225&
%ERROR_DS_TIMELIMIT_EXCEEDED      = 8226&
%ERROR_DS_SIZELIMIT_EXCEEDED      = 8227&
%ERROR_DS_ADMIN_LIMIT_EXCEEDED    = 8228&
%ERROR_DS_COMPARE_FALSE           = 8229&
%ERROR_DS_COMPARE_TRUE            = 8230&
%ERROR_DS_AUTH_METHOD_NOT_SUPPORTED = 8231&
%ERROR_DS_STRONG_AUTH_REQUIRED    = 8232&
%ERROR_DS_INAPPROPRIATE_AUTH      = 8233&
%ERROR_DS_AUTH_UNKNOWN            = 8234&
%ERROR_DS_REFERRAL                = 8235&
%ERROR_DS_UNAVAILABLE_CRIT_EXTENSION = 8236&
%ERROR_DS_CONFIDENTIALITY_REQUIRED = 8237&
%ERROR_DS_INAPPROPRIATE_MATCHING  = 8238&
%ERROR_DS_CONSTRAINT_VIOLATION    = 8239&
%ERROR_DS_NO_SUCH_OBJECT          = 8240&
%ERROR_DS_ALIAS_PROBLEM           = 8241&
%ERROR_DS_INVALID_DN_SYNTAX       = 8242&
%ERROR_DS_IS_LEAF                 = 8243&
%ERROR_DS_ALIAS_DEREF_PROBLEM     = 8244&
%ERROR_DS_UNWILLING_TO_PERFORM    = 8245&
%ERROR_DS_LOOP_DETECT             = 8246&
%ERROR_DS_NAMING_VIOLATION        = 8247&
%ERROR_DS_OBJECT_RESULTS_TOO_LARGE = 8248&
%ERROR_DS_AFFECTS_MULTIPLE_DSAS   = 8249&
%ERROR_DS_SERVER_DOWN             = 8250&
%ERROR_DS_LOCAL_ERROR             = 8251&
%ERROR_DS_ENCODING_ERROR          = 8252&
%ERROR_DS_DECODING_ERROR          = 8253&
%ERROR_DS_FILTER_UNKNOWN          = 8254&
%ERROR_DS_PARAM_ERROR             = 8255&
%ERROR_DS_NOT_SUPPORTED           = 8256&
%ERROR_DS_NO_RESULTS_RETURNED     = 8257&
%ERROR_DS_CONTROL_NOT_FOUND       = 8258&
%ERROR_DS_CLIENT_LOOP             = 8259&
%ERROR_DS_REFERRAL_LIMIT_EXCEEDED = 8260&
%ERROR_DS_ROOT_MUST_BE_NC         = 8301&
%ERROR_DS_ADD_REPLICA_INHIBITED   = 8302&
%ERROR_DS_ATT_NOT_DEF_IN_SCHEMA   = 8303&
%ERROR_DS_MAX_OBJ_SIZE_EXCEEDED   = 8304&
%ERROR_DS_OBJ_STRING_NAME_EXISTS  = 8305&
%ERROR_DS_NO_RDN_DEFINED_IN_SCHEMA = 8306&
%ERROR_DS_RDN_DOESNT_MATCH_SCHEMA = 8307&
%ERROR_DS_NO_REQUESTED_ATTS_FOUND = 8308&
%ERROR_DS_USER_BUFFER_TO_SMALL    = 8309&
%ERROR_DS_ATT_IS_NOT_ON_OBJ       = 8310&
%ERROR_DS_ILLEGAL_MOD_OPERATION   = 8311&
%ERROR_DS_OBJ_TOO_LARGE           = 8312&
%ERROR_DS_BAD_INSTANCE_TYPE       = 8313&
%ERROR_DS_MASTERDSA_REQUIRED      = 8314&
%ERROR_DS_OBJECT_CLASS_REQUIRED   = 8315&
%ERROR_DS_MISSING_REQUIRED_ATT    = 8316&
%ERROR_DS_ATT_NOT_DEF_FOR_CLASS   = 8317&
%ERROR_DS_ATT_ALREADY_EXISTS      = 8318&
%ERROR_DS_CANT_ADD_ATT_VALUES     = 8320&
%ERROR_DS_SINGLE_VALUE_CONSTRAINT = 8321&
%ERROR_DS_RANGE_CONSTRAINT        = 8322&
%ERROR_DS_ATT_VAL_ALREADY_EXISTS  = 8323&
%ERROR_DS_CANT_REM_MISSING_ATT    = 8324&
%ERROR_DS_CANT_REM_MISSING_ATT_VAL = 8325&
%ERROR_DS_ROOT_CANT_BE_SUBREF     = 8326&
%ERROR_DS_NO_CHAINING             = 8327&
%ERROR_DS_NO_CHAINED_EVAL         = 8328&
%ERROR_DS_NO_PARENT_OBJECT        = 8329&
%ERROR_DS_PARENT_IS_AN_ALIAS      = 8330&
%ERROR_DS_CANT_MIX_MASTER_AND_REPS = 8331&
%ERROR_DS_CHILDREN_EXIST          = 8332&
%ERROR_DS_OBJ_NOT_FOUND           = 8333&
%ERROR_DS_ALIASED_OBJ_MISSING     = 8334&
%ERROR_DS_BAD_NAME_SYNTAX         = 8335&
%ERROR_DS_ALIAS_POINTS_TO_ALIAS   = 8336&
%ERROR_DS_CANT_DEREF_ALIAS        = 8337&
%ERROR_DS_OUT_OF_SCOPE            = 8338&
%ERROR_DS_CANT_DELETE_DSA_OBJ     = 8340&
%ERROR_DS_GENERIC_ERROR           = 8341&
%ERROR_DS_DSA_MUST_BE_INT_MASTER  = 8342&
%ERROR_DS_CLASS_NOT_DSA           = 8343&
%ERROR_DS_INSUFF_ACCESS_RIGHTS    = 8344&
%ERROR_DS_ILLEGAL_SUPERIOR        = 8345&
%ERROR_DS_ATTRIBUTE_OWNED_BY_SAM  = 8346&
%ERROR_DS_NAME_TOO_MANY_PARTS     = 8347&
%ERROR_DS_NAME_TOO_LONG           = 8348&
%ERROR_DS_NAME_VALUE_TOO_LONG     = 8349&
%ERROR_DS_NAME_UNPARSEABLE        = 8350&
%ERROR_DS_NAME_TYPE_UNKNOWN       = 8351&
%ERROR_DS_NOT_AN_OBJECT           = 8352&
%ERROR_DS_SEC_DESC_TOO_SHORT      = 8353&
%ERROR_DS_SEC_DESC_INVALID        = 8354&
%ERROR_DS_NO_DELETED_NAME         = 8355&
%ERROR_DS_SUBREF_MUST_HAVE_PARENT = 8356&
%ERROR_DS_NCNAME_MUST_BE_NC       = 8357&
%ERROR_DS_CANT_ADD_SYSTEM_ONLY    = 8358&
%ERROR_DS_CLASS_MUST_BE_CONCRETE  = 8359&
%ERROR_DS_INVALID_DMD             = 8360&
%ERROR_DS_OBJ_GUID_EXISTS         = 8361&
%ERROR_DS_NOT_ON_BACKLINK         = 8362&
%ERROR_DS_NO_CROSSREF_FOR_NC      = 8363&
%ERROR_DS_SHUTTING_DOWN           = 8364&
%ERROR_DS_UNKNOWN_OPERATION       = 8365&
%ERROR_DS_INVALID_ROLE_OWNER      = 8366&
%ERROR_DS_COULDNT_CONTACT_FSMO    = 8367&
%ERROR_DS_CROSS_NC_DN_RENAME      = 8368&
%ERROR_DS_CANT_MOD_SYSTEM_ONLY    = 8369&
%ERROR_DS_REPLICATOR_ONLY         = 8370&
%ERROR_DS_OBJ_CLASS_NOT_DEFINED   = 8371&
%ERROR_DS_OBJ_CLASS_NOT_SUBCLASS  = 8372&
%ERROR_DS_NAME_REFERENCE_INVALID  = 8373&
%ERROR_DS_CROSS_REF_EXISTS        = 8374&
%ERROR_DS_CANT_DEL_MASTER_CROSSREF = 8375&
%ERROR_DS_SUBTREE_NOTIFY_NOT_NC_HEAD = 8376&
%ERROR_DS_NOTIFY_FILTER_TOO_COMPLEX = 8377&
%ERROR_DS_DUP_RDN                 = 8378&
%ERROR_DS_DUP_OID                 = 8379&
%ERROR_DS_DUP_MAPI_ID             = 8380&
%ERROR_DS_DUP_SCHEMA_ID_GUID      = 8381&
%ERROR_DS_DUP_LDAP_DISPLAY_NAME   = 8382&
%ERROR_DS_SEMANTIC_ATT_TEST       = 8383&
%ERROR_DS_SYNTAX_MISMATCH         = 8384&
%ERROR_DS_EXISTS_IN_MUST_HAVE     = 8385&
%ERROR_DS_EXISTS_IN_MAY_HAVE      = 8386&
%ERROR_DS_NONEXISTENT_MAY_HAVE    = 8387&
%ERROR_DS_NONEXISTENT_MUST_HAVE   = 8388&
%ERROR_DS_AUX_CLS_TEST_FAIL       = 8389&
%ERROR_DS_NONEXISTENT_POSS_SUP    = 8390&
%ERROR_DS_SUB_CLS_TEST_FAIL       = 8391&
%ERROR_DS_BAD_RDN_ATT_ID_SYNTAX   = 8392&
%ERROR_DS_EXISTS_IN_AUX_CLS       = 8393&
%ERROR_DS_EXISTS_IN_SUB_CLS       = 8394&
%ERROR_DS_EXISTS_IN_POSS_SUP      = 8395&
%ERROR_DS_RECALCSCHEMA_FAILED     = 8396&
%ERROR_DS_TREE_DELETE_NOT_FINISHED = 8397&
%ERROR_DS_CANT_DELETE             = 8398&
%ERROR_DS_ATT_SCHEMA_REQ_ID       = 8399&
%ERROR_DS_BAD_ATT_SCHEMA_SYNTAX   = 8400&
%ERROR_DS_CANT_CACHE_ATT          = 8401&
%ERROR_DS_CANT_CACHE_CLASS        = 8402&
%ERROR_DS_CANT_REMOVE_ATT_CACHE   = 8403&
%ERROR_DS_CANT_REMOVE_CLASS_CACHE = 8404&
%ERROR_DS_CANT_RETRIEVE_DN        = 8405&
%ERROR_DS_MISSING_SUPREF          = 8406&
%ERROR_DS_CANT_RETRIEVE_INSTANCE  = 8407&
%ERROR_DS_CODE_INCONSISTENCY      = 8408&
%ERROR_DS_DATABASE_ERROR          = 8409&
%ERROR_DS_GOVERNSID_MISSING       = 8410&
%ERROR_DS_MISSING_EXPECTED_ATT    = 8411&
%ERROR_DS_NCNAME_MISSING_CR_REF   = 8412&
%ERROR_DS_SECURITY_CHECKING_ERROR = 8413&
%ERROR_DS_SCHEMA_NOT_LOADED       = 8414&
%ERROR_DS_SCHEMA_ALLOC_FAILED     = 8415&
%ERROR_DS_ATT_SCHEMA_REQ_SYNTAX   = 8416&
%ERROR_DS_GCVERIFY_ERROR          = 8417&
%ERROR_DS_DRA_SCHEMA_MISMATCH     = 8418&
%ERROR_DS_CANT_FIND_DSA_OBJ       = 8419&
%ERROR_DS_CANT_FIND_EXPECTED_NC   = 8420&
%ERROR_DS_CANT_FIND_NC_IN_CACHE   = 8421&
%ERROR_DS_CANT_RETRIEVE_CHILD     = 8422&
%ERROR_DS_SECURITY_ILLEGAL_MODIFY = 8423&
%ERROR_DS_CANT_REPLACE_HIDDEN_REC = 8424&
%ERROR_DS_BAD_HIERARCHY_FILE      = 8425&
%ERROR_DS_BUILD_HIERARCHY_TABLE_FAILED = 8426&
%ERROR_DS_CONFIG_PARAM_MISSING    = 8427&
%ERROR_DS_COUNTING_AB_INDICES_FAILED = 8428&
%ERROR_DS_HIERARCHY_TABLE_MALLOC_FAILED = 8429&
%ERROR_DS_INTERNAL_FAILURE        = 8430&
%ERROR_DS_UNKNOWN_ERROR           = 8431&
%ERROR_DS_ROOT_REQUIRES_CLASS_TOP = 8432&
%ERROR_DS_REFUSING_FSMO_ROLES     = 8433&
%ERROR_DS_MISSING_FSMO_SETTINGS   = 8434&
%ERROR_DS_UNABLE_TO_SURRENDER_ROLES = 8435&
%ERROR_DS_DRA_GENERIC             = 8436&
%ERROR_DS_DRA_INVALID_PARAMETER   = 8437&
%ERROR_DS_DRA_BUSY                = 8438&
%ERROR_DS_DRA_BAD_DN              = 8439&
%ERROR_DS_DRA_BAD_NC              = 8440&
%ERROR_DS_DRA_DN_EXISTS           = 8441&
%ERROR_DS_DRA_INTERNAL_ERROR      = 8442&
%ERROR_DS_DRA_INCONSISTENT_DIT    = 8443&
%ERROR_DS_DRA_CONNECTION_FAILED   = 8444&
%ERROR_DS_DRA_BAD_INSTANCE_TYPE   = 8445&
%ERROR_DS_DRA_OUT_OF_MEM          = 8446&
%ERROR_DS_DRA_MAIL_PROBLEM        = 8447&
%ERROR_DS_DRA_REF_ALREADY_EXISTS  = 8448&
%ERROR_DS_DRA_REF_NOT_FOUND       = 8449&
%ERROR_DS_DRA_OBJ_IS_REP_SOURCE   = 8450&
%ERROR_DS_DRA_DB_ERROR            = 8451&
%ERROR_DS_DRA_NO_REPLICA          = 8452&
%ERROR_DS_DRA_ACCESS_DENIED       = 8453&
%ERROR_DS_DRA_NOT_SUPPORTED       = 8454&
%ERROR_DS_DRA_RPC_CANCELLED       = 8455&
%ERROR_DS_DRA_SOURCE_DISABLED     = 8456&
%ERROR_DS_DRA_SINK_DISABLED       = 8457&
%ERROR_DS_DRA_NAME_COLLISION      = 8458&
%ERROR_DS_DRA_SOURCE_REINSTALLED  = 8459&
%ERROR_DS_DRA_MISSING_PARENT      = 8460&
%ERROR_DS_DRA_PREEMPTED           = 8461&
%ERROR_DS_DRA_ABANDON_SYNC        = 8462&
%ERROR_DS_DRA_SHUTDOWN            = 8463&
%ERROR_DS_DRA_INCOMPATIBLE_PARTIAL_SET = 8464&
%ERROR_DS_DRA_SOURCE_IS_PARTIAL_REPLICA = 8465&
%ERROR_DS_DRA_EXTN_CONNECTION_FAILED = 8466&
%ERROR_DS_INSTALL_SCHEMA_MISMATCH = 8467&
%ERROR_DS_DUP_LINK_ID             = 8468&
%ERROR_DS_NAME_ERROR_RESOLVING    = 8469&
%ERROR_DS_NAME_ERROR_NOT_FOUND    = 8470&
%ERROR_DS_NAME_ERROR_NOT_UNIQUE   = 8471&
%ERROR_DS_NAME_ERROR_NO_MAPPING   = 8472&
%ERROR_DS_NAME_ERROR_DOMAIN_ONLY  = 8473&
%ERROR_DS_NAME_ERROR_NO_SYNTACTICAL_MAPPING = 8474&
%ERROR_DS_CONSTRUCTED_ATT_MOD     = 8475&
%ERROR_DS_WRONG_OM_OBJ_CLASS      = 8476&
%ERROR_DS_DRA_REPL_PENDING        = 8477&
%ERROR_DS_DS_REQUIRED             = 8478&
%ERROR_DS_INVALID_LDAP_DISPLAY_NAME = 8479&
%ERROR_DS_NON_BASE_SEARCH         = 8480&
%ERROR_DS_CANT_RETRIEVE_ATTS      = 8481&
%ERROR_DS_BACKLINK_WITHOUT_LINK   = 8482&
%ERROR_DS_EPOCH_MISMATCH          = 8483&
%ERROR_DS_SRC_NAME_MISMATCH       = 8484&
%ERROR_DS_SRC_AND_DST_NC_IDENTICAL = 8485&
%ERROR_DS_DST_NC_MISMATCH         = 8486&
%ERROR_DS_NOT_AUTHORITIVE_FOR_DST_NC = 8487&
%ERROR_DS_SRC_GUID_MISMATCH       = 8488&
%ERROR_DS_CANT_MOVE_DELETED_OBJECT = 8489&
%ERROR_DS_PDC_OPERATION_IN_PROGRESS = 8490&
%ERROR_DS_CROSS_DOMAIN_CLEANUP_REQD = 8491&
%ERROR_DS_ILLEGAL_XDOM_MOVE_OPERATION = 8492&
%ERROR_DS_CANT_WITH_ACCT_GROUP_MEMBERSHPS = 8493&
%ERROR_DS_NC_MUST_HAVE_NC_PARENT  = 8494&
%ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE = 8495&
%ERROR_DS_DST_DOMAIN_NOT_NATIVE   = 8496&
%ERROR_DS_MISSING_INFRASTRUCTURE_CONTAINER = 8497&
%ERROR_DS_CANT_MOVE_ACCOUNT_GROUP = 8498&
%ERROR_DS_CANT_MOVE_RESOURCE_GROUP = 8499&
%ERROR_DS_INVALID_SEARCH_FLAG     = 8500&
%ERROR_DS_NO_TREE_DELETE_ABOVE_NC = 8501&
%ERROR_DS_COULDNT_LOCK_TREE_FOR_DELETE = 8502&
%ERROR_DS_COULDNT_IDENTIFY_OBJECTS_FOR_TREE_DELETE = 8503&
%ERROR_DS_SAM_INIT_FAILURE        = 8504&
%ERROR_DS_SENSITIVE_GROUP_VIOLATION = 8505&
%ERROR_DS_CANT_MOD_PRIMARYGROUPID = 8506&
%ERROR_DS_ILLEGAL_BASE_SCHEMA_MOD = 8507&
%ERROR_DS_NONSAFE_SCHEMA_CHANGE   = 8508&
%ERROR_DS_SCHEMA_UPDATE_DISALLOWED = 8509&
%ERROR_DS_CANT_CREATE_UNDER_SCHEMA = 8510&
%ERROR_DS_INSTALL_NO_SRC_SCH_VERSION = 8511&
%ERROR_DS_INSTALL_NO_SCH_VERSION_IN_INIFILE = 8512&
%ERROR_DS_INVALID_GROUP_TYPE      = 8513&
%ERROR_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN = 8514&
%ERROR_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN = 8515&
%ERROR_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER = 8516&
%ERROR_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER = 8517&
%ERROR_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER = 8518&
%ERROR_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER = 8519&
%ERROR_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER = 8520&
%ERROR_DS_HAVE_PRIMARY_MEMBERS    = 8521&
%ERROR_DS_STRING_SD_CONVERSION_FAILED = 8522&
%ERROR_DS_NAMING_MASTER_GC        = 8523&
%ERROR_DS_DNS_LOOKUP_FAILURE      = 8524&
%ERROR_DS_COULDNT_UPDATE_SPNS     = 8525&
%ERROR_DS_CANT_RETRIEVE_SD        = 8526&
%ERROR_DS_KEY_NOT_UNIQUE          = 8527&
%ERROR_DS_WRONG_LINKED_ATT_SYNTAX = 8528&
%ERROR_DS_SAM_NEED_BOOTKEY_PASSWORD = 8529&
%ERROR_DS_SAM_NEED_BOOTKEY_FLOPPY = 8530&
%ERROR_DS_CANT_START              = 8531&
%ERROR_DS_INIT_FAILURE            = 8532&
%ERROR_DS_NO_PKT_PRIVACY_ON_CONNECTION = 8533&
%ERROR_DS_SOURCE_DOMAIN_IN_FOREST = 8534&
%ERROR_DS_DESTINATION_DOMAIN_NOT_IN_FOREST = 8535&
%ERROR_DS_DESTINATION_AUDITING_NOT_ENABLED = 8536&
%ERROR_DS_CANT_FIND_DC_FOR_SRC_DOMAIN = 8537&
%ERROR_DS_SRC_OBJ_NOT_GROUP_OR_USER = 8538&
%ERROR_DS_SRC_SID_EXISTS_IN_FOREST = 8539&
%ERROR_DS_SRC_AND_DST_OBJECT_CLASS_MISMATCH = 8540&
%ERROR_SAM_INIT_FAILURE           = 8541&
%ERROR_DS_DRA_SCHEMA_INFO_SHIP    = 8542&
%ERROR_DS_DRA_SCHEMA_CONFLICT     = 8543&
%ERROR_DS_DRA_EARLIER_SCHEMA_CONFLICT = 8544&
%ERROR_DS_DRA_OBJ_NC_MISMATCH     = 8545&
%ERROR_DS_NC_STILL_HAS_DSAS       = 8546&
%ERROR_DS_GC_REQUIRED             = 8547&
%ERROR_DS_LOCAL_MEMBER_OF_LOCAL_ONLY = 8548&
%ERROR_DS_NO_FPO_IN_UNIVERSAL_GROUPS = 8549&
%ERROR_DS_CANT_ADD_TO_GC          = 8550&
%ERROR_DS_NO_CHECKPOINT_WITH_PDC  = 8551&
%ERROR_DS_SOURCE_AUDITING_NOT_ENABLED = 8552&
%ERROR_DS_CANT_CREATE_IN_NONDOMAIN_NC = 8553&
%ERROR_DS_INVALID_NAME_FOR_SPN    = 8554&
%ERROR_DS_FILTER_USES_CONTRUCTED_ATTRS = 8555&
%ERROR_DS_UNICODEPWD_NOT_IN_QUOTES = 8556&
%ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED = 8557&
%ERROR_DS_MUST_BE_RUN_ON_DST_DC   = 8558&
%ERROR_DS_SRC_DC_MUST_BE_SP4_OR_GREATER = 8559&
%ERROR_DS_CANT_TREE_DELETE_CRITICAL_OBJ = 8560&
%DNS_ERROR_RESPONSE_CODES_BASE = 9000
%DNS_ERROR_RCODE_NO_ERROR         = %NO_ERROR
%DNS_ERROR_MASK                   = &H00002328 ' 9000 or %DNS_ERROR_RESPONSE_CODES_BASE
%DNS_ERROR_RCODE_FORMAT_ERROR     = 9001&
%DNS_ERROR_RCODE_SERVER_FAILURE   = 9002&
%DNS_ERROR_RCODE_NAME_ERROR       = 9003&
%DNS_ERROR_RCODE_NOT_IMPLEMENTED  = 9004&
%DNS_ERROR_RCODE_REFUSED          = 9005&
%DNS_ERROR_RCODE_YXDOMAIN         = 9006&
%DNS_ERROR_RCODE_YXRRSET          = 9007&
%DNS_ERROR_RCODE_NXRRSET          = 9008&
%DNS_ERROR_RCODE_NOTAUTH          = 9009&
%DNS_ERROR_RCODE_NOTZONE          = 9010&
%DNS_ERROR_RCODE_BADSIG           = 9016&
%DNS_ERROR_RCODE_BADKEY           = 9017&
%DNS_ERROR_RCODE_BADTIME          = 9018&
%DNS_ERROR_RCODE_LAST             = %DNS_ERROR_RCODE_BADTIME
%DNS_ERROR_PACKET_FMT_BASE        = 9500&
%DNS_INFO_NO_RECORDS              = 9501&
%DNS_ERROR_BAD_PACKET             = 9502&
%DNS_ERROR_NO_PACKET              = 9503&
%DNS_ERROR_RCODE                  = 9504&
%DNS_ERROR_UNSECURE_PACKET        = 9505&
%DNS_STATUS_PACKET_UNSECURE       = %DNS_ERROR_UNSECURE_PACKET
%DNS_ERROR_NO_MEMORY              = %ERROR_OUTOFMEMORY
%DNS_ERROR_INVALID_NAME           = %ERROR_INVALID_NAME
%DNS_ERROR_INVALID_DATA           = %ERROR_INVALID_DATA
%DNS_ERROR_GENERAL_API_BASE       = 9550&
%DNS_ERROR_INVALID_TYPE           = 9551&
%DNS_ERROR_INVALID_IP_ADDRESS     = 9552&
%DNS_ERROR_INVALID_PROPERTY       = 9553&
%DNS_ERROR_TRY_AGAIN_LATER        = 9554&
%DNS_ERROR_NOT_UNIQUE             = 9555&
%DNS_ERROR_NON_RFC_NAME           = 9556&
%DNS_STATUS_FQDN                  = 9557&
%DNS_STATUS_DOTTED_NAME           = 9558&
%DNS_STATUS_SINGLE_PART_NAME      = 9559&
%DNS_ERROR_INVALID_NAME_CHAR      = 9560&
%DNS_ERROR_NUMERIC_NAME           = 9561&
%DNS_ERROR_ZONE_BASE              = 9600&
%DNS_ERROR_ZONE_DOES_NOT_EXIST    = 9601&
%DNS_ERROR_NO_ZONE_INFO           = 9602&
%DNS_ERROR_INVALID_ZONE_OPERATION = 9603&
%DNS_ERROR_ZONE_CONFIGURATION_ERROR = 9604&
%DNS_ERROR_ZONE_HAS_NO_SOA_RECORD = 9605&
%DNS_ERROR_ZONE_HAS_NO_NS_RECORDS = 9606&
%DNS_ERROR_ZONE_LOCKED            = 9607&
%DNS_ERROR_ZONE_CREATION_FAILED   = 9608&
%DNS_ERROR_ZONE_ALREADY_EXISTS    = 9609&
%DNS_ERROR_AUTOZONE_ALREADY_EXISTS = 9610&
%DNS_ERROR_INVALID_ZONE_TYPE      = 9611&
%DNS_ERROR_SECONDARY_REQUIRES_MASTER_IP = 9612&
%DNS_ERROR_ZONE_NOT_SECONDARY     = 9613&
%DNS_ERROR_NEED_SECONDARY_ADDRESSES = 9614&
%DNS_ERROR_WINS_INIT_FAILED       = 9615&
%DNS_ERROR_NEED_WINS_SERVERS      = 9616&
%DNS_ERROR_NBSTAT_INIT_FAILED     = 9617&
%DNS_ERROR_SOA_DELETE_INVALID     = 9618&
%DNS_ERROR_DATAFILE_BASE          = 9650&
%DNS_ERROR_PRIMARY_REQUIRES_DATAFILE = 9651&
%DNS_ERROR_INVALID_DATAFILE_NAME  = 9652&
%DNS_ERROR_DATAFILE_OPEN_FAILURE  = 9653&
%DNS_ERROR_FILE_WRITEBACK_FAILED  = 9654&
%DNS_ERROR_DATAFILE_PARSING       = 9655&
%DNS_ERROR_DATABASE_BASE          = 9700&
%DNS_ERROR_RECORD_DOES_NOT_EXIST  = 9701&
%DNS_ERROR_RECORD_FORMAT          = 9702&
%DNS_ERROR_NODE_CREATION_FAILED   = 9703&
%DNS_ERROR_UNKNOWN_RECORD_TYPE    = 9704&
%DNS_ERROR_RECORD_TIMED_OUT       = 9705&
%DNS_ERROR_NAME_NOT_IN_ZONE       = 9706&
%DNS_ERROR_CNAME_LOOP             = 9707&
%DNS_ERROR_NODE_IS_CNAME          = 9708&
%DNS_ERROR_CNAME_COLLISION        = 9709&
%DNS_ERROR_RECORD_ONLY_AT_ZONE_ROOT = 9710&
%DNS_ERROR_RECORD_ALREADY_EXISTS  = 9711&
%DNS_ERROR_SECONDARY_DATA         = 9712&
%DNS_ERROR_NO_CREATE_CACHE_DATA   = 9713&
%DNS_ERROR_NAME_DOES_NOT_EXIST    = 9714&
%DNS_WARNING_PTR_CREATE_FAILED    = 9715&
%DNS_WARNING_DOMAIN_UNDELETED     = 9716&
%DNS_ERROR_DS_UNAVAILABLE         = 9717&
%DNS_ERROR_DS_ZONE_ALREADY_EXISTS = 9718&
%DNS_ERROR_NO_BOOTFILE_IF_DS_ZONE = 9719&
%DNS_ERROR_OPERATION_BASE         = 9750&
%DNS_INFO_AXFR_COMPLETE           = 9751&
%DNS_ERROR_AXFR                   = 9752&
%DNS_INFO_ADDED_LOCAL_WINS        = 9753&
%DNS_ERROR_SECURE_BASE            = 9800&
%DNS_STATUS_CONTINUE_NEEDED       = 9801&
%DNS_ERROR_SETUP_BASE             = 9850&
%DNS_ERROR_NO_TCPIP               = 9851&
%DNS_ERROR_NO_DNS_SERVERS         = 9852&

#IF NOT %DEF(%WSABASEERR) '----------------------------------------------------
%WSABASEERR                 = 10000&
%WSAEINTR                   = 10004&
%WSAEBADF                   = 10009&
%WSAEACCES                  = 10013&
%WSAEFAULT                  = 10014&
%WSAEINVAL                  = 10022&
%WSAEMFILE                  = 10024&
%WSAEWOULDBLOCK             = 10035&
%WSAEINPROGRESS             = 10036&
%WSAEALREADY                = 10037&
%WSAENOTSOCK                = 10038&
%WSAEDESTADDRREQ            = 10039&
%WSAEMSGSIZE                = 10040&
%WSAEPROTOTYPE              = 10041&
%WSAENOPROTOOPT             = 10042&
%WSAEPROTONOSUPPORT         = 10043&
%WSAESOCKTNOSUPPORT         = 10044&
%WSAEOPNOTSUPP              = 10045&
%WSAEPFNOSUPPORT            = 10046&
%WSAEAFNOSUPPORT            = 10047&
%WSAEADDRINUSE              = 10048&
%WSAEADDRNOTAVAIL           = 10049&
%WSAENETDOWN                = 10050&
%WSAENETUNREACH             = 10051&
%WSAENETRESET               = 10052&
%WSAECONNABORTED            = 10053&
%WSAECONNRESET              = 10054&
%WSAENOBUFS                 = 10055&
%WSAEISCONN                 = 10056&
%WSAENOTCONN                = 10057&
%WSAESHUTDOWN               = 10058&
%WSAETOOMANYREFS            = 10059&
%WSAETIMEDOUT               = 10060&
%WSAECONNREFUSED            = 10061&
%WSAELOOP                   = 10062&
%WSAENAMETOOLONG            = 10063&
%WSAEHOSTDOWN               = 10064&
%WSAEHOSTUNREACH            = 10065&
%WSAENOTEMPTY               = 10066&
%WSAEPROCLIM                = 10067&
%WSAEUSERS                  = 10068&
%WSAEDQUOT                  = 10069&
%WSAESTALE                  = 10070&
%WSAEREMOTE                 = 10071&
%WSASYSNOTREADY             = 10091&
%WSAVERNOTSUPPORTED         = 10092&
%WSANOTINITIALISED          = 10093&
%WSAEDISCON                 = 10101&
%WSAENOMORE                 = 10102&
%WSAECANCELLED              = 10103&
%WSAEINVALIDPROCTABLE       = 10104&
%WSAEINVALIDPROVIDER        = 10105&
%WSAEPROVIDERFAILEDINIT     = 10106&
%WSASYSCALLFAILURE          = 10107&
%WSASERVICE_NOT_FOUND       = 10108&
%WSATYPE_NOT_FOUND          = 10109&
%WSA_E_NO_MORE              = 10110&
%WSA_E_CANCELLED            = 10111&
%WSAEREFUSED                = 10112&
%WSAHOST_NOT_FOUND          = 11001&
%WSATRY_AGAIN               = 11002&
%WSANO_RECOVERY             = 11003&
%WSANO_DATA                 = 11004&
%WSA_QOS_RECEIVERS          = 11005&
%WSA_QOS_SENDERS            = 11006&
%WSA_QOS_NO_SENDERS         = 11007&
%WSA_QOS_NO_RECEIVERS       = 11008&
%WSA_QOS_REQUEST_CONFIRMED  = 11009&
%WSA_QOS_ADMISSION_FAILURE  = 11010&
%WSA_QOS_POLICY_FAILURE     = 11011&
%WSA_QOS_BAD_STYLE          = 11012&
%WSA_QOS_BAD_OBJECT         = 11013&
%WSA_QOS_TRAFFIC_CTRL_ERROR = 11014&
%WSA_QOS_GENERIC_ERROR      = 11015&
%WSA_QOS_ESERVICETYPE       = 11016&
%WSA_QOS_EFLOWSPEC          = 11017&
%WSA_QOS_EPROVSPECBUF       = 11018&
%WSA_QOS_EFILTERSTYLE       = 11019&
%WSA_QOS_EFILTERTYPE        = 11020&
%WSA_QOS_EFILTERCOUNT       = 11021&
%WSA_QOS_EOBJLENGTH         = 11022&
%WSA_QOS_EFLOWCOUNT         = 11023&
%WSA_QOS_EUNKOWNPSOBJ       = 11024&
%WSA_QOS_EPOLICYOBJ         = 11025&
%WSA_QOS_EFLOWDESC          = 11026&
%WSA_QOS_EPSFLOWSPEC        = 11027&
%WSA_QOS_EPSFILTERSPEC      = 11028&
%WSA_QOS_ESDMODEOBJ         = 11029&
%WSA_QOS_ESHAPERATEOBJ      = 11030&
%WSA_QOS_RESERVED_PETYPE    = 11031&
#ENDIF ' #IF NOT %DEF(%WSABASEERR) --------------------------------------------

%SEVERITY_SUCCESS = 0
%SEVERITY_ERROR   = 1
%FACILITY_NT_BIT  = &H10000000
%NOERROR          = 0

%E_UNEXPECTED                     = &H8000FFFF&
%E_NOTIMPL                        = &H80004001&
%E_OUTOFMEMORY                    = &H8007000E&
%E_INVALIDARG                     = &H80070057&
%E_NOINTERFACE                    = &H80004002&
%E_POINTER                        = &H80004003&
%E_HANDLE                         = &H80070006&
%E_ABORT                          = &H80004004&
%E_FAIL                           = &H80004005&
%E_ACCESSDENIED                   = &H80070005&
%E_PENDING                        = &H8000000A&

%CO_E_INIT_TLS                    = &H80004006&
%CO_E_INIT_SHARED_ALLOCATOR       = &H80004007&
%CO_E_INIT_MEMORY_ALLOCATOR       = &H80004008&
%CO_E_INIT_CLASS_CACHE            = &H80004009&
%CO_E_INIT_RPC_CHANNEL            = &H8000400A&
%CO_E_INIT_TLS_SET_CHANNEL_CONTROL = &H8000400B&
%CO_E_INIT_TLS_CHANNEL_CONTROL    = &H8000400C&
%CO_E_INIT_UNACCEPTED_USER_ALLOCATOR = &H8000400D&
%CO_E_INIT_SCM_MUTEX_EXISTS       = &H8000400E&
%CO_E_INIT_SCM_FILE_MAPPING_EXISTS = &H8000400F&
%CO_E_INIT_SCM_MAP_VIEW_OF_FILE   = &H80004010&
%CO_E_INIT_SCM_EXEC_FAILURE       = &H80004011&
%CO_E_INIT_ONLY_SINGLE_THREADED   = &H80004012&
%CO_E_CANT_REMOTE                 = &H80004013&
%CO_E_BAD_SERVER_NAME             = &H80004014&
%CO_E_WRONG_SERVER_IDENTITY       = &H80004015&
%CO_E_OLE1DDE_DISABLED            = &H80004016&
%CO_E_RUNAS_SYNTAX                = &H80004017&
%CO_E_CREATEPROCESS_FAILURE       = &H80004018&
%CO_E_RUNAS_CREATEPROCESS_FAILURE = &H80004019&
%CO_E_RUNAS_LOGON_FAILURE         = &H8000401A&
%CO_E_LAUNCH_PERMSSION_DENIED     = &H8000401B&
%CO_E_START_SERVICE_FAILURE       = &H8000401C&
%CO_E_REMOTE_COMMUNICATION_FAILURE = &H8000401D&
%CO_E_SERVER_START_TIMEOUT        = &H8000401E&
%CO_E_CLSREG_INCONSISTENT         = &H8000401F&
%CO_E_IIDREG_INCONSISTENT         = &H80004020&
%CO_E_NOT_SUPPORTED               = &H80004021&
%CO_E_RELOAD_DLL                  = &H80004022&
%CO_E_MSI_ERROR                   = &H80004023&
%CO_E_ATTEMPT_TO_CREATE_OUTSIDE_CLIENT_CONTEXT = &H80004024&

%S_OK    = &H00000000&
%S_FALSE = &H00000001&

%OLE_E_FIRST               = &H80040000&
%OLE_E_LAST                = &H800400FF&
%OLE_S_FIRST               = &H00040000&
%OLE_S_LAST                = &H000400FF&
%OLE_E_OLEVERB             = &H80040000&
%OLE_E_ADVF                = &H80040001&
%OLE_E_ENUM_NOMORE         = &H80040002&
%OLE_E_ADVISENOTSUPPORTED  = &H80040003&
%OLE_E_NOCONNECTION        = &H80040004&
%OLE_E_NOTRUNNING          = &H80040005&
%OLE_E_NOCACHE             = &H80040006&
%OLE_E_BLANK               = &H80040007&
%OLE_E_CLASSDIFF           = &H80040008&
%OLE_E_CANT_GETMONIKER     = &H80040009&
%OLE_E_CANT_BINDTOSOURCE   = &H8004000A&
%OLE_E_STATIC              = &H8004000B&
%OLE_E_PROMPTSAVECANCELLED = &H8004000C&
%OLE_E_INVALIDRECT         = &H8004000D&
%OLE_E_WRONGCOMPOBJ        = &H8004000E&
%OLE_E_INVALIDHWND         = &H8004000F&
%OLE_E_NOT_INPLACEACTIVE   = &H80040010&
%OLE_E_CANTCONVERT         = &H80040011&
%OLE_E_NOSTORAGE           = &H80040012&

%DV_E_FORMATETC            = &H80040064&
%DV_E_DVTARGETDEVICE       = &H80040065&
%DV_E_STGMEDIUM            = &H80040066&
%DV_E_STATDATA             = &H80040067&
%DV_E_LINDEX               = &H80040068&
%DV_E_TYMED                = &H80040069&
%DV_E_CLIPFORMAT           = &H8004006A&
%DV_E_DVASPECT             = &H8004006B&
%DV_E_DVTARGETDEVICE_SIZE  = &H8004006C&
%DV_E_NOIVIEWOBJECT        = &H8004006D&

%DRAGDROP_E_FIRST             = &H80040100&
%DRAGDROP_E_LAST              = &H8004010F&
%DRAGDROP_S_FIRST             = &H00040100&
%DRAGDROP_S_LAST              = &H0004010F&
%DRAGDROP_E_NOTREGISTERED     = &H80040100&
%DRAGDROP_E_ALREADYREGISTERED = &H80040101&
%DRAGDROP_E_INVALIDHWND       = &H80040102&

%CLASSFACTORY_E_FIRST = &H80040110&
%CLASSFACTORY_E_LAST  = &H8004011F&
%CLASSFACTORY_S_FIRST = &H00040110&
%CLASSFACTORY_S_LAST  = &H0004011F&

%CLASS_E_NOAGGREGATION     = &H80040110&
%CLASS_E_CLASSNOTAVAILABLE = &H80040111&
%CLASS_E_NOTLICENSED       = &H80040112&

%MARSHAL_E_FIRST = &H80040120&
%MARSHAL_E_LAST  = &H8004012F&
%MARSHAL_S_FIRST = &H00040120&
%MARSHAL_S_LAST  = &H0004012F&

%DATA_E_FIRST = &H80040130&
%DATA_E_LAST  = &H8004013F&
%DATA_S_FIRST = &H00040130&
%DATA_S_LAST  = &H0004013F&

%VIEW_E_FIRST = &H80040140&
%VIEW_E_LAST  = &H8004014F&
%VIEW_S_FIRST = &H00040140&
%VIEW_S_LAST  = &H0004014F&
%VIEW_E_DRAW  = &H80040140&

%REGDB_E_FIRST             = &H80040150&
%REGDB_E_LAST              = &H8004015F&
%REGDB_S_FIRST             = &H00040150&
%REGDB_S_LAST              = &H0004015F&
%REGDB_E_READREGDB         = &H80040150&
%REGDB_E_WRITEREGDB        = &H80040151&
%REGDB_E_KEYMISSING        = &H80040152&
%REGDB_E_INVALIDVALUE      = &H80040153&
%REGDB_E_CLASSNOTREG       = &H80040154&
%REGDB_E_IIDNOTREG         = &H80040155&
%REGDB_E_BADTHREADINGMODEL = &H80040156&

%CAT_E_FIRST         = &H80040160&
%CAT_E_LAST          = &H80040161&
%CAT_E_CATIDNOEXIST  = &H80040160&
%CAT_E_NODESCRIPTION = &H80040161&

%CS_E_FIRST                 = &H80040164&
%CS_E_LAST                  = &H8004016F&
%CS_E_PACKAGE_NOTFOUND      = &H80040164&
%CS_E_NOT_DELETABLE         = &H80040165&
%CS_E_CLASS_NOTFOUND        = &H80040166&
%CS_E_INVALID_VERSION       = &H80040167&
%CS_E_NO_CLASSSTORE         = &H80040168&
%CS_E_OBJECT_NOTFOUND       = &H80040169&
%CS_E_OBJECT_ALREADY_EXISTS = &H8004016A&
%CS_E_INVALID_PATH          = &H8004016B&
%CS_E_NETWORK_ERROR         = &H8004016C&
%CS_E_ADMIN_LIMIT_EXCEEDED  = &H8004016D&
%CS_E_SCHEMA_MISMATCH       = &H8004016E&
%CS_E_INTERNAL_ERROR        = &H8004016F&

%CACHE_E_FIRST           = &H80040170&
%CACHE_E_LAST            = &H8004017F&
%CACHE_S_FIRST           = &H00040170&
%CACHE_S_LAST            = &H0004017F&
%CACHE_E_NOCACHE_UPDATED = &H80040170&

%OLEOBJ_E_FIRST       = &H80040180&
%OLEOBJ_E_LAST        = &H8004018F&
%OLEOBJ_S_FIRST       = &H00040180&
%OLEOBJ_S_LAST        = &H0004018F&
%OLEOBJ_E_NOVERBS     = &H80040180&
%OLEOBJ_E_INVALIDVERB = &H80040181&

%CLIENTSITE_E_FIRST = &H80040190&
%CLIENTSITE_E_LAST  = &H8004019F&
%CLIENTSITE_S_FIRST = &H00040190&
%CLIENTSITE_S_LAST  = &H0004019F&

%INPLACE_E_NOTUNDOABLE = &H800401A0&
%INPLACE_E_NOTOOLSPACE = &H800401A1&
%INPLACE_E_FIRST       = &H800401A0&
%INPLACE_E_LAST        = &H800401AF&
%INPLACE_S_FIRST       = &H000401A0&
%INPLACE_S_LAST        = &H000401AF&

%ENUM_E_FIRST = &H800401B0&
%ENUM_E_LAST  = &H800401BF&
%ENUM_S_FIRST = &H000401B0&
%ENUM_S_LAST  = &H000401BF&

%CONVERT10_E_FIRST         = &H800401C0&
%CONVERT10_E_LAST          = &H800401CF&
%CONVERT10_S_FIRST         = &H000401C0&
%CONVERT10_S_LAST          = &H000401CF&
%CONVERT10_E_OLESTREAM_GET = &H800401C0&
%CONVERT10_E_OLESTREAM_PUT = &H800401C1&
%CONVERT10_E_OLESTREAM_FMT = &H800401C2&
%CONVERT10_E_OLESTREAM_BITMAP_TO_DIB = &H800401C3&
%CONVERT10_E_STG_FMT                 = &H800401C4&
%CONVERT10_E_STG_NO_STD_STREAM       = &H800401C5&
%CONVERT10_E_STG_DIB_TO_BITMAP       = &H800401C6&

%CLIPBRD_E_FIRST      = &H800401D0&
%CLIPBRD_E_LAST       = &H800401DF&
%CLIPBRD_S_FIRST      = &H000401D0&
%CLIPBRD_S_LAST       = &H000401DF&
%CLIPBRD_E_CANT_OPEN  = &H800401D0&
%CLIPBRD_E_CANT_EMPTY = &H800401D1&
%CLIPBRD_E_CANT_SET   = &H800401D2&
%CLIPBRD_E_BAD_DATA   = &H800401D3&
%CLIPBRD_E_CANT_CLOSE = &H800401D4&

%MK_E_FIRST        = &H800401E0&
%MK_E_LAST         = &H800401EF&
%MK_S_FIRST        = &H000401E0&
%MK_S_LAST         = &H000401EF&
%MK_E_CONNECTMANUALLY             = &H800401E0&
%MK_E_EXCEEDEDDEADLINE            = &H800401E1&
%MK_E_NEEDGENERIC                 = &H800401E2&
%MK_E_UNAVAILABLE                 = &H800401E3&
%MK_E_SYNTAX                      = &H800401E4&
%MK_E_NOOBJECT                    = &H800401E5&
%MK_E_INVALIDEXTENSION            = &H800401E6&
%MK_E_INTERMEDIATEINTERFACENOTSUPPORTED = &H800401E7&
%MK_E_NOTBINDABLE                 = &H800401E8&
%MK_E_NOTBOUND                    = &H800401E9&
%MK_E_CANTOPENFILE                = &H800401EA&
%MK_E_MUSTBOTHERUSER              = &H800401EB&
%MK_E_NOINVERSE                   = &H800401EC&
%MK_E_NOSTORAGE                   = &H800401ED&
%MK_E_NOPREFIX                    = &H800401EE&
%MK_E_ENUMERATION_FAILED          = &H800401EF&

%CO_E_FIRST              = &H800401F0&
%CO_E_LAST               = &H800401FF&
%CO_S_FIRST              = &H000401F0&
%CO_S_LAST               = &H000401FF&
%CO_E_NOTINITIALIZED     = &H800401F0&
%CO_E_ALREADYINITIALIZED = &H800401F1&
%CO_E_CANTDETERMINECLASS = &H800401F2&
%CO_E_CLASSSTRING        = &H800401F3&
%CO_E_IIDSTRING          = &H800401F4&
%CO_E_APPNOTFOUND        = &H800401F5&
%CO_E_APPSINGLEUSE       = &H800401F6&
%CO_E_ERRORINAPP         = &H800401F7&
%CO_E_DLLNOTFOUND        = &H800401F8&
%CO_E_ERRORINDLL         = &H800401F9&
%CO_E_WRONGOSFORAPP      = &H800401FA&
%CO_E_OBJNOTREG          = &H800401FB&
%CO_E_OBJISREG           = &H800401FC&
%CO_E_OBJNOTCONNECTED    = &H800401FD&
%CO_E_APPDIDNTREG        = &H800401FE&
%CO_E_RELEASED           = &H800401FF&

%EVENT_E_FIRST                   = &H80040200&
%EVENT_E_LAST                    = &H8004021F&
%EVENT_S_FIRST                   = &H00040200&
%EVENT_S_LAST                    = &H0004021F&
%EVENT_S_SOME_SUBSCRIBERS_FAILED = &H00040200&
%EVENT_E_ALL_SUBSCRIBERS_FAILED  = &H80040201&
%EVENT_S_NOSUBSCRIBERS           = &H00040202&
%EVENT_E_QUERYSYNTAX             = &H80040203&
%EVENT_E_QUERYFIELD              = &H80040204&
%EVENT_E_INTERNALEXCEPTION       = &H80040205&
%EVENT_E_INTERNALERROR           = &H80040206&
%EVENT_E_INVALID_PER_USER_SID    = &H80040207&
%EVENT_E_USER_EXCEPTION          = &H80040208&
%EVENT_E_TOO_MANY_METHODS        = &H80040209&
%EVENT_E_MISSING_EVENTCLASS      = &H8004020A&
%EVENT_E_NOT_ALL_REMOVED         = &H8004020B&
%EVENT_E_COMPLUS_NOT_INSTALLED   = &H8004020C&

%CONTEXT_E_FIRST          = &H8004E000&
%CONTEXT_E_LAST           = &H8004E02F&
%CONTEXT_S_FIRST          = &H0004E000&
%CONTEXT_S_LAST           = &H0004E02F&
%CONTEXT_E_ABORTED        = &H8004E002&
%CONTEXT_E_ABORTING       = &H8004E003&
%CONTEXT_E_NOCONTEXT      = &H8004E004&
%CONTEXT_E_SYNCH_TIMEOUT  = &H8004E006&
%CONTEXT_E_OLDREF         = &H8004E007&
%CONTEXT_E_ROLENOTFOUND   = &H8004E00C&
%CONTEXT_E_TMNOTAVAILABLE = &H8004E00F&

%CO_E_ACTIVATIONFAILED              = &H8004E021&
%CO_E_ACTIVATIONFAILED_EVENTLOGGED  = &H8004E022&
%CO_E_ACTIVATIONFAILED_CATALOGERROR = &H8004E023&
%CO_E_ACTIVATIONFAILED_TIMEOUT      = &H8004E024&
%CO_E_INITIALIZATIONFAILED          = &H8004E025&

%CONTEXT_E_NOJIT         = &H8004E026&
%CONTEXT_E_NOTRANSACTION = &H8004E027&

%CO_E_THREADINGMODEL_CHANGED = &H8004E028&

%OLE_S_USEREG         = &H00040000&
%OLE_S_STATIC         = &H00040001&
%OLE_S_MAC_CLIPFORMAT = &H00040002&

%DRAGDROP_S_DROP              = &H00040100&
%DRAGDROP_S_CANCEL            = &H00040101&
%DRAGDROP_S_USEDEFAULTCURSORS = &H00040102&

%DATA_S_SAMEFORMATETC = &H00040130&

%VIEW_S_ALREADY_FROZEN = &H00040140&

%CACHE_S_FORMATETC_NOTSUPPORTED = &H00040170&
%CACHE_S_SAMECACHE              = &H00040171&
%CACHE_S_SOMECACHES_NOTUPDATED  = &H00040172&

%OLEOBJ_S_INVALIDVERB       = &H00040180&
%OLEOBJ_S_CANNOT_DOVERB_NOW = &H00040181&
%OLEOBJ_S_INVALIDHWND       = &H00040182&

%INPLACE_S_TRUNCATED = &H000401A0&

%CONVERT10_S_NO_PRESENTATION = &H000401C0&

%MK_S_REDUCED_TO_SELF          = &H000401E2&
%MK_S_ME                       = &H000401E4&
%MK_S_HIM                      = &H000401E5&
%MK_S_US                       = &H000401E6&
%MK_S_MONIKERALREADYREGISTERED = &H000401E7&

%SCHED_S_TASK_READY               = &H00041300&
%SCHED_S_TASK_RUNNING             = &H00041301&
%SCHED_S_TASK_DISABLED            = &H00041302&
%SCHED_S_TASK_HAS_NOT_RUN         = &H00041303&
%SCHED_S_TASK_NO_MORE_RUNS        = &H00041304&
%SCHED_S_TASK_NOT_SCHEDULED       = &H00041305&
%SCHED_S_TASK_TERMINATED          = &H00041306&
%SCHED_S_TASK_NO_VALID_TRIGGERS   = &H00041307&
%SCHED_S_EVENT_TRIGGER            = &H00041308&
%SCHED_E_TRIGGER_NOT_FOUND        = &H80041309&
%SCHED_E_TASK_NOT_READY           = &H8004130A&
%SCHED_E_TASK_NOT_RUNNING         = &H8004130B&
%SCHED_E_SERVICE_NOT_INSTALLED    = &H8004130C&
%SCHED_E_CANNOT_OPEN_TASK         = &H8004130D&
%SCHED_E_INVALID_TASK             = &H8004130E&
%SCHED_E_ACCOUNT_INFORMATION_NOT_SET = &H8004130F&
%SCHED_E_ACCOUNT_NAME_NOT_FOUND   = &H80041310&
%SCHED_E_ACCOUNT_DBASE_CORRUPT    = &H80041311&
%SCHED_E_NO_SECURITY_SERVICES     = &H80041312&
%SCHED_E_UNKNOWN_OBJECT_VERSION   = &H80041313&
%SCHED_E_UNSUPPORTED_ACCOUNT_OPTION = &H80041314&
%SCHED_E_SERVICE_NOT_RUNNING      = &H80041315&

%CO_E_CLASS_CREATE_FAILED = &H80080001&
%CO_E_SCM_ERROR           = &H80080002&
%CO_E_SCM_RPC_FAILURE     = &H80080003&
%CO_E_BAD_PATH            = &H80080004&
%CO_E_SERVER_EXEC_FAILURE = &H80080005&
%CO_E_OBJSRV_RPC_FAILURE  = &H80080006&

%MK_E_NO_NORMALIZED = &H80080007&

%CO_E_SERVER_STOPPING     = &H80080008&

%MEM_E_INVALID_ROOT = &H80080009&
%MEM_E_INVALID_LINK = &H80080010&
%MEM_E_INVALID_SIZE = &H80080011&

%CO_S_NOTALLINTERFACES = &H00080012&

%DISP_E_UNKNOWNINTERFACE = &H80020001&
%DISP_E_MEMBERNOTFOUND   = &H80020003&
%DISP_E_PARAMNOTFOUND    = &H80020004&
%DISP_E_TYPEMISMATCH     = &H80020005&
%DISP_E_UNKNOWNNAME      = &H80020006&
%DISP_E_NONAMEDARGS      = &H80020007&
%DISP_E_BADVARTYPE       = &H80020008&
%DISP_E_EXCEPTION        = &H80020009&
%DISP_E_OVERFLOW         = &H8002000A&
%DISP_E_BADINDEX         = &H8002000B&
%DISP_E_UNKNOWNLCID      = &H8002000C&
%DISP_E_ARRAYISLOCKED    = &H8002000D&
%DISP_E_BADPARAMCOUNT    = &H8002000E&
%DISP_E_PARAMNOTOPTIONAL = &H8002000F&
%DISP_E_BADCALLEE        = &H80020010&
%DISP_E_NOTACOLLECTION   = &H80020011&
%DISP_E_DIVBYZERO        = &H80020012&
%DISP_E_BUFFERTOOSMALL   = &H80020013&

%TYPE_E_BUFFERTOOSMALL          = &H80028016&
%TYPE_E_FIELDNOTFOUND           = &H80028017&
%TYPE_E_INVDATAREAD             = &H80028018&
%TYPE_E_UNSUPFORMAT             = &H80028019&
%TYPE_E_REGISTRYACCESS          = &H8002801C&
%TYPE_E_LIBNOTREGISTERED        = &H8002801D&
%TYPE_E_UNDEFINEDTYPE           = &H80028027&
%TYPE_E_QUALIFIEDNAMEDISALLOWED = &H80028028&
%TYPE_E_INVALIDSTATE            = &H80028029&
%TYPE_E_WRONGTYPEKIND           = &H8002802A&
%TYPE_E_ELEMENTNOTFOUND         = &H8002802B&
%TYPE_E_AMBIGUOUSNAME           = &H8002802C&
%TYPE_E_NAMECONFLICT            = &H8002802D&
%TYPE_E_UNKNOWNLCID             = &H8002802E&
%TYPE_E_DLLFUNCTIONNOTFOUND     = &H8002802F&
%TYPE_E_BADMODULEKIND           = &H800288BD&
%TYPE_E_SIZETOOBIG              = &H800288C5&
%TYPE_E_DUPLICATEID             = &H800288C6&
%TYPE_E_INVALIDID               = &H800288CF&
%TYPE_E_TYPEMISMATCH            = &H80028CA0&
%TYPE_E_OUTOFBOUNDS             = &H80028CA1&
%TYPE_E_IOERROR                 = &H80028CA2&
%TYPE_E_CANTCREATETMPFILE       = &H80028CA3&
%TYPE_E_CANTLOADLIBRARY         = &H80029C4A&
%TYPE_E_INCONSISTENTPROPFUNCS   = &H80029C83&
%TYPE_E_CIRCULARTYPE            = &H80029C84&

%STG_E_INVALIDFUNCTION       = &H80030001&
%STG_E_FILENOTFOUND          = &H80030002&
%STG_E_PATHNOTFOUND          = &H80030003&
%STG_E_TOOMANYOPENFILES      = &H80030004&
%STG_E_ACCESSDENIED          = &H80030005&
%STG_E_INVALIDHANDLE         = &H80030006&
%STG_E_INSUFFICIENTMEMORY    = &H80030008&
%STG_E_INVALIDPOINTER        = &H80030009&
%STG_E_NOMOREFILES           = &H80030012&
%STG_E_DISKISWRITEPROTECTED  = &H80030013&
%STG_E_SEEKERROR             = &H80030019&
%STG_E_WRITEFAULT            = &H8003001D&
%STG_E_READFAULT             = &H8003001E&
%STG_E_SHAREVIOLATION        = &H80030020&
%STG_E_LOCKVIOLATION         = &H80030021&
%STG_E_FILEALREADYEXISTS     = &H80030050&
%STG_E_INVALIDPARAMETER      = &H80030057&
%STG_E_MEDIUMFULL            = &H80030070&
%STG_E_PROPSETMISMATCHED     = &H800300F0&
%STG_E_ABNORMALAPIEXIT       = &H800300FA&
%STG_E_INVALIDHEADER         = &H800300FB&
%STG_E_INVALIDNAME           = &H800300FC&
%STG_E_UNKNOWN               = &H800300FD&
%STG_E_UNIMPLEMENTEDFUNCTION = &H800300FE&
%STG_E_INVALIDFLAG           = &H800300FF&
%STG_E_INUSE                 = &H80030100&
%STG_E_NOTCURRENT            = &H80030101&
%STG_E_REVERTED              = &H80030102&
%STG_E_CANTSAVE              = &H80030103&
%STG_E_OLDFORMAT             = &H80030104&
%STG_E_OLDDLL                = &H80030105&
%STG_E_SHAREREQUIRED         = &H80030106&
%STG_E_NOTFILEBASEDSTORAGE   = &H80030107&
%STG_E_EXTANTMARSHALLINGS    = &H80030108&
%STG_E_DOCFILECORRUPT        = &H80030109&
%STG_E_BADBASEADDRESS        = &H80030110&
%STG_E_DOCFILETOOLARGE       = &H80030111&
%STG_E_NOTSIMPLEFORMAT       = &H80030112&
%STG_E_INCOMPLETE            = &H80030201&
%STG_E_TERMINATED            = &H80030202&
%STG_S_CONVERTED             = &H00030200&
%STG_S_BLOCK                 = &H00030201&
%STG_S_RETRYNOW              = &H00030202&
%STG_S_MONITORING            = &H00030203&
%STG_S_MULTIPLEOPENS         = &H00030204&
%STG_S_CONSOLIDATIONFAILED   = &H00030205&
%STG_S_CANNOTCONSOLIDATE     = &H00030206&

%RPC_E_CALL_REJECTED              = &H80010001&
%RPC_E_CALL_CANCELED              = &H80010002&
%RPC_E_CANTPOST_INSENDCALL        = &H80010003&
%RPC_E_CANTCALLOUT_INASYNCCALL    = &H80010004&
%RPC_E_CANTCALLOUT_INEXTERNALCALL = &H80010005&
%RPC_E_CONNECTION_TERMINATED      = &H80010006&
%RPC_E_SERVER_DIED                = &H80010007&
%RPC_E_CLIENT_DIED                = &H80010008&
%RPC_E_INVALID_DATAPACKET         = &H80010009&
%RPC_E_CANTTRANSMIT_CALL          = &H8001000A&
%RPC_E_CLIENT_CANTMARSHAL_DATA    = &H8001000B&
%RPC_E_CLIENT_CANTUNMARSHAL_DATA  = &H8001000C&
%RPC_E_SERVER_CANTMARSHAL_DATA    = &H8001000D&
%RPC_E_SERVER_CANTUNMARSHAL_DATA  = &H8001000E&
%RPC_E_INVALID_DATA               = &H8001000F&
%RPC_E_INVALID_PARAMETER          = &H80010010&
%RPC_E_CANTCALLOUT_AGAIN          = &H80010011&
%RPC_E_SERVER_DIED_DNE            = &H80010012&
%RPC_E_SYS_CALL_FAILED            = &H80010100&
%RPC_E_OUT_OF_RESOURCES           = &H80010101&
%RPC_E_ATTEMPTED_MULTITHREAD      = &H80010102&
%RPC_E_NOT_REGISTERED             = &H80010103&
%RPC_E_FAULT                      = &H80010104&
%RPC_E_SERVERFAULT                = &H80010105&
%RPC_E_CHANGED_MODE               = &H80010106&
%RPC_E_INVALIDMETHOD              = &H80010107&
%RPC_E_DISCONNECTED               = &H80010108&
%RPC_E_RETRY                      = &H80010109&
%RPC_E_SERVERCALL_RETRYLATER      = &H8001010A&
%RPC_E_SERVERCALL_REJECTED        = &H8001010B&
%RPC_E_INVALID_CALLDATA           = &H8001010C&
%RPC_E_CANTCALLOUT_ININPUTSYNCCALL = &H8001010D&
%RPC_E_WRONG_THREAD               = &H8001010E&
%RPC_E_THREAD_NOT_INIT            = &H8001010F&
%RPC_E_VERSION_MISMATCH           = &H80010110&
%RPC_E_INVALID_HEADER             = &H80010111&
%RPC_E_INVALID_EXTENSION          = &H80010112&
%RPC_E_INVALID_IPID               = &H80010113&
%RPC_E_INVALID_OBJECT             = &H80010114&
%RPC_S_CALLPENDING                = &H80010115&
%RPC_S_WAITONTIMER                = &H80010116&
%RPC_E_CALL_COMPLETE              = &H80010117&
%RPC_E_UNSECURE_CALL              = &H80010118&
%RPC_E_TOO_LATE                   = &H80010119&
%RPC_E_NO_GOOD_SECURITY_PACKAGES  = &H8001011A&
%RPC_E_ACCESS_DENIED              = &H8001011B&
%RPC_E_REMOTE_DISABLED            = &H8001011C&
%RPC_E_INVALID_OBJREF             = &H8001011D&
%RPC_E_NO_CONTEXT                 = &H8001011E&
%RPC_E_TIMEOUT                    = &H8001011F&
%RPC_E_NO_SYNC                    = &H80010120&
%RPC_E_FULLSIC_REQUIRED           = &H80010121&
%RPC_E_INVALID_STD_NAME           = &H80010122&

%CO_E_FAILEDTOIMPERSONATE        = &H80010123&
%CO_E_FAILEDTOGETSECCTX          = &H80010124&
%CO_E_FAILEDTOOPENTHREADTOKEN    = &H80010125&
%CO_E_FAILEDTOGETTOKENINFO       = &H80010126&
%CO_E_TRUSTEEDOESNTMATCHCLIENT   = &H80010127&
%CO_E_FAILEDTOQUERYCLIENTBLANKET = &H80010128&
%CO_E_FAILEDTOSETDACL            = &H80010129&
%CO_E_ACCESSCHECKFAILED          = &H8001012A&
%CO_E_NETACCESSAPIFAILED         = &H8001012B&
%CO_E_WRONGTRUSTEENAMESYNTAX     = &H8001012C&
%CO_E_INVALIDSID                 = &H8001012D&
%CO_E_CONVERSIONFAILED           = &H8001012E&
%CO_E_NOMATCHINGSIDFOUND         = &H8001012F&
%CO_E_LOOKUPACCSIDFAILED         = &H80010130&
%CO_E_NOMATCHINGNAMEFOUND        = &H80010131&
%CO_E_LOOKUPACCNAMEFAILED        = &H80010132&
%CO_E_SETSERLHNDLFAILED          = &H80010133&
%CO_E_FAILEDTOGETWINDIR          = &H80010134&
%CO_E_PATHTOOLONG                = &H80010135&
%CO_E_FAILEDTOGENUUID            = &H80010136&
%CO_E_FAILEDTOCREATEFILE         = &H80010137&
%CO_E_FAILEDTOCLOSEHANDLE        = &H80010138&
%CO_E_EXCEEDSYSACLLIMIT          = &H80010139&
%CO_E_ACESINWRONGORDER           = &H8001013A&
%CO_E_INCOMPATIBLESTREAMVERSION  = &H8001013B&
%CO_E_FAILEDTOOPENPROCESSTOKEN   = &H8001013C&
%CO_E_DECODEFAILED               = &H8001013D&
%CO_E_ACNOTINITIALIZED           = &H8001013F&
%CO_E_CANCEL_DISABLED            = &H80010140&

%RPC_E_UNEXPECTED = &H8001FFFF&

' FACILITY_SSPI

%NTE_BAD_UID                      = &H80090001&
%NTE_BAD_HASH                     = &H80090002&
%NTE_BAD_KEY                      = &H80090003&
%NTE_BAD_LEN                      = &H80090004&
%NTE_BAD_DATA                     = &H80090005&
%NTE_BAD_SIGNATURE                = &H80090006&
%NTE_BAD_VER                      = &H80090007&
%NTE_BAD_ALGID                    = &H80090008&
%NTE_BAD_FLAGS                    = &H80090009&
%NTE_BAD_TYPE                     = &H8009000A&
%NTE_BAD_KEY_STATE                = &H8009000B&
%NTE_BAD_HASH_STATE               = &H8009000C&
%NTE_NO_KEY                       = &H8009000D&
%NTE_NO_MEMORY                    = &H8009000E&
%NTE_EXISTS                       = &H8009000F&
%NTE_PERM                         = &H80090010&
%NTE_NOT_FOUND                    = &H80090011&
%NTE_DOUBLE_ENCRYPT               = &H80090012&
%NTE_BAD_PROVIDER                 = &H80090013&
%NTE_BAD_PROV_TYPE                = &H80090014&
%NTE_BAD_PUBLIC_KEY               = &H80090015&
%NTE_BAD_KEYSET                   = &H80090016&
%NTE_PROV_TYPE_NOT_DEF            = &H80090017&
%NTE_PROV_TYPE_ENTRY_BAD          = &H80090018&
%NTE_KEYSET_NOT_DEF               = &H80090019&
%NTE_KEYSET_ENTRY_BAD             = &H8009001A&
%NTE_PROV_TYPE_NO_MATCH           = &H8009001B&
%NTE_SIGNATURE_FILE_BAD           = &H8009001C&
%NTE_PROVIDER_DLL_FAIL            = &H8009001D&
%NTE_PROV_DLL_NOT_FOUND           = &H8009001E&
%NTE_BAD_KEYSET_PARAM             = &H8009001F&
%NTE_FAIL                         = &H80090020&
%NTE_SYS_ERR                      = &H80090021&
%NTE_SILENT_CONTEXT               = &H80090022&
%NTE_TOKEN_KEYSET_STORAGE_FULL    = &H80090023&
%NTE_TEMPORARY_PROFILE            = &H80090024&
%NTE_FIXEDPARAMETER               = &H80090025&

%SEC_E_INSUFFICIENT_MEMORY        = &H80090300&
%SEC_E_INVALID_HANDLE             = &H80090301&
%SEC_E_UNSUPPORTED_FUNCTION       = &H80090302&
%SEC_E_TARGET_UNKNOWN             = &H80090303&
%SEC_E_INTERNAL_ERROR             = &H80090304&
%SEC_E_SECPKG_NOT_FOUND           = &H80090305&
%SEC_E_NOT_OWNER                  = &H80090306&
%SEC_E_CANNOT_INSTALL             = &H80090307&
%SEC_E_INVALID_TOKEN              = &H80090308&
%SEC_E_CANNOT_PACK                = &H80090309&
%SEC_E_QOP_NOT_SUPPORTED          = &H8009030A&
%SEC_E_NO_IMPERSONATION           = &H8009030B&
%SEC_E_LOGON_DENIED               = &H8009030C&
%SEC_E_UNKNOWN_CREDENTIALS        = &H8009030D&
%SEC_E_NO_CREDENTIALS             = &H8009030E&
%SEC_E_MESSAGE_ALTERED            = &H8009030F&
%SEC_E_OUT_OF_SEQUENCE            = &H80090310&
%SEC_E_NO_AUTHENTICATING_AUTHORITY = &H80090311&
%SEC_I_CONTINUE_NEEDED            = &H00090312&
%SEC_I_COMPLETE_NEEDED            = &H00090313&
%SEC_I_COMPLETE_AND_CONTINUE      = &H00090314&
%SEC_I_LOCAL_LOGON                = &H00090315&
%SEC_E_BAD_PKGID                  = &H80090316&
%SEC_E_CONTEXT_EXPIRED            = &H80090317&
%SEC_E_INCOMPLETE_MESSAGE         = &H80090318&
%SEC_E_INCOMPLETE_CREDENTIALS     = &H80090320&
%SEC_E_BUFFER_TOO_SMALL           = &H80090321&
%SEC_I_INCOMPLETE_CREDENTIALS     = &H00090320&
%SEC_I_RENEGOTIATE                = &H00090321&
%SEC_E_WRONG_PRINCIPAL            = &H80090322&
%SEC_I_NO_LSA_CONTEXT             = &H00090323&
%SEC_E_TIME_SKEW                  = &H80090324&
%SEC_E_UNTRUSTED_ROOT             = &H80090325&
%SEC_E_ILLEGAL_MESSAGE            = &H80090326&
%SEC_E_CERT_UNKNOWN               = &H80090327&
%SEC_E_CERT_EXPIRED               = &H80090328&
%SEC_E_ENCRYPT_FAILURE            = &H80090329&
%SEC_E_DECRYPT_FAILURE            = &H80090330&
%SEC_E_ALGORITHM_MISMATCH         = &H80090331&
%SEC_E_SECURITY_QOS_FAILED        = &H80090332&
%SEC_E_NO_SPM                     = %SEC_E_INTERNAL_ERROR
%SEC_E_NOT_SUPPORTED              = %SEC_E_UNSUPPORTED_FUNCTION

%CRYPT_E_MSG_ERROR                = &H80091001&
%CRYPT_E_UNKNOWN_ALGO             = &H80091002&
%CRYPT_E_OID_FORMAT               = &H80091003&
%CRYPT_E_INVALID_MSG_TYPE         = &H80091004&
%CRYPT_E_UNEXPECTED_ENCODING      = &H80091005&
%CRYPT_E_AUTH_ATTR_MISSING        = &H80091006&
%CRYPT_E_HASH_VALUE               = &H80091007&
%CRYPT_E_INVALID_INDEX            = &H80091008&
%CRYPT_E_ALREADY_DECRYPTED        = &H80091009&
%CRYPT_E_NOT_DECRYPTED            = &H8009100A&
%CRYPT_E_RECIPIENT_NOT_FOUND      = &H8009100B&
%CRYPT_E_CONTROL_TYPE             = &H8009100C&
%CRYPT_E_ISSUER_SERIALNUMBER      = &H8009100D&
%CRYPT_E_SIGNER_NOT_FOUND         = &H8009100E&
%CRYPT_E_ATTRIBUTES_MISSING       = &H8009100F&
%CRYPT_E_STREAM_MSG_NOT_READY     = &H80091010&
%CRYPT_E_STREAM_INSUFFICIENT_DATA = &H80091011&
%CRYPT_E_BAD_LEN                  = &H80092001&
%CRYPT_E_BAD_ENCODE               = &H80092002&
%CRYPT_E_FILE_ERROR               = &H80092003&
%CRYPT_E_NOT_FOUND                = &H80092004&
%CRYPT_E_EXISTS                   = &H80092005&
%CRYPT_E_NO_PROVIDER              = &H80092006&
%CRYPT_E_SELF_SIGNED              = &H80092007&
%CRYPT_E_DELETED_PREV             = &H80092008&
%CRYPT_E_NO_MATCH                 = &H80092009&
%CRYPT_E_UNEXPECTED_MSG_TYPE      = &H8009200A&
%CRYPT_E_NO_KEY_PROPERTY          = &H8009200B&
%CRYPT_E_NO_DECRYPT_CERT          = &H8009200C&
%CRYPT_E_BAD_MSG                  = &H8009200D&
%CRYPT_E_NO_SIGNER                = &H8009200E&
%CRYPT_E_PENDING_CLOSE            = &H8009200F&
%CRYPT_E_REVOKED                  = &H80092010&
%CRYPT_E_NO_REVOCATION_DLL        = &H80092011&
%CRYPT_E_NO_REVOCATION_CHECK      = &H80092012&
%CRYPT_E_REVOCATION_OFFLINE       = &H80092013&
%CRYPT_E_NOT_IN_REVOCATION_DATABASE = &H80092014&
%CRYPT_E_INVALID_NUMERIC_STRING   = &H80092020&
%CRYPT_E_INVALID_PRINTABLE_STRING = &H80092021&
%CRYPT_E_INVALID_IA5_STRING       = &H80092022&
%CRYPT_E_INVALID_X500_STRING      = &H80092023&
%CRYPT_E_NOT_CHAR_STRING          = &H80092024&
%CRYPT_E_FILERESIZED              = &H80092025&
%CRYPT_E_SECURITY_SETTINGS        = &H80092026&
%CRYPT_E_NO_VERIFY_USAGE_DLL      = &H80092027&
%CRYPT_E_NO_VERIFY_USAGE_CHECK    = &H80092028&
%CRYPT_E_VERIFY_USAGE_OFFLINE     = &H80092029&
%CRYPT_E_NOT_IN_CTL               = &H8009202A&
%CRYPT_E_NO_TRUSTED_SIGNER        = &H8009202B&
%CRYPT_E_MISSING_PUBKEY_PARA      = &H8009202C&
%CRYPT_E_OSS_ERROR                = &H80093000&

%OSS_MORE_BUF                     = &H80093001&
%OSS_NEGATIVE_UINTEGER            = &H80093002&
%OSS_PDU_RANGE                    = &H80093003&
%OSS_MORE_INPUT                   = &H80093004&
%OSS_DATA_ERROR                   = &H80093005&
%OSS_BAD_ARG                      = &H80093006&
%OSS_BAD_VERSION                  = &H80093007&
%OSS_OUT_MEMORY                   = &H80093008&
%OSS_PDU_MISMATCH                 = &H80093009&
%OSS_LIMITED                      = &H8009300A&
%OSS_BAD_PTR                      = &H8009300B&
%OSS_BAD_TIME                     = &H8009300C&
%OSS_INDEFINITE_NOT_SUPPORTED     = &H8009300D&
%OSS_MEM_ERROR                    = &H8009300E&
%OSS_BAD_TABLE                    = &H8009300F&
%OSS_TOO_LONG                     = &H80093010&
%OSS_CONSTRAINT_VIOLATED          = &H80093011&
%OSS_FATAL_ERROR                  = &H80093012&
%OSS_ACCESS_SERIALIZATION_ERROR   = &H80093013&
%OSS_NULL_TBL                     = &H80093014&
%OSS_NULL_FCN                     = &H80093015&
%OSS_BAD_ENCRULES                 = &H80093016&
%OSS_UNAVAIL_ENCRULES             = &H80093017&
%OSS_CANT_OPEN_TRACE_WINDOW       = &H80093018&
%OSS_UNIMPLEMENTED                = &H80093019&
%OSS_OID_DLL_NOT_LINKED           = &H8009301A&
%OSS_CANT_OPEN_TRACE_FILE         = &H8009301B&
%OSS_TRACE_FILE_ALREADY_OPEN      = &H8009301C&
%OSS_TABLE_MISMATCH               = &H8009301D&
%OSS_TYPE_NOT_SUPPORTED           = &H8009301E&
%OSS_REAL_DLL_NOT_LINKED          = &H8009301F&
%OSS_REAL_CODE_NOT_LINKED         = &H80093020&
%OSS_OUT_OF_RANGE                 = &H80093021&
%OSS_COPIER_DLL_NOT_LINKED        = &H80093022&
%OSS_CONSTRAINT_DLL_NOT_LINKED    = &H80093023&
%OSS_COMPARATOR_DLL_NOT_LINKED    = &H80093024&
%OSS_COMPARATOR_CODE_NOT_LINKED   = &H80093025&
%OSS_MEM_MGR_DLL_NOT_LINKED       = &H80093026&
%OSS_PDV_DLL_NOT_LINKED           = &H80093027&
%OSS_PDV_CODE_NOT_LINKED          = &H80093028&
%OSS_API_DLL_NOT_LINKED           = &H80093029&
%OSS_BERDER_DLL_NOT_LINKED        = &H8009302A&
%OSS_PER_DLL_NOT_LINKED           = &H8009302B&
%OSS_OPEN_TYPE_ERROR              = &H8009302C&
%OSS_MUTEX_NOT_CREATED            = &H8009302D&
%OSS_CANT_CLOSE_TRACE_FILE        = &H8009302E&

%CRYPT_E_ASN1_ERROR               = &H80093100&
%CRYPT_E_ASN1_INTERNAL            = &H80093101&
%CRYPT_E_ASN1_EOD                 = &H80093102&
%CRYPT_E_ASN1_CORRUPT             = &H80093103&
%CRYPT_E_ASN1_LARGE               = &H80093104&
%CRYPT_E_ASN1_CONSTRAINT          = &H80093105&
%CRYPT_E_ASN1_MEMORY              = &H80093106&
%CRYPT_E_ASN1_OVERFLOW            = &H80093107&
%CRYPT_E_ASN1_BADPDU              = &H80093108&
%CRYPT_E_ASN1_BADARGS             = &H80093109&
%CRYPT_E_ASN1_BADREAL             = &H8009310A&
%CRYPT_E_ASN1_BADTAG              = &H8009310B&
%CRYPT_E_ASN1_CHOICE              = &H8009310C&
%CRYPT_E_ASN1_RULE                = &H8009310D&
%CRYPT_E_ASN1_UTF8                = &H8009310E&
%CRYPT_E_ASN1_PDU_TYPE            = &H80093133&
%CRYPT_E_ASN1_NYI                 = &H80093134&
%CRYPT_E_ASN1_EXTENDED            = &H80093201&
%CRYPT_E_ASN1_NOEOD               = &H80093202&

%CERTSRV_E_BAD_REQUESTSUBJECT     = &H80094001&
%CERTSRV_E_NO_REQUEST             = &H80094002&
%CERTSRV_E_BAD_REQUESTSTATUS      = &H80094003&
%CERTSRV_E_PROPERTY_EMPTY         = &H80094004&
%CERTSRV_E_INVALID_CA_CERTIFICATE = &H80094005&
%CERTSRV_E_SERVER_SUSPENDED       = &H80094006&
%CERTSRV_E_ENCODING_LENGTH        = &H80094007&
%CERTSRV_E_UNSUPPORTED_CERT_TYPE  = &H80094800&
%CERTSRV_E_NO_CERT_TYPE           = &H80094801&

%TRUST_E_SYSTEM_ERROR             = &H80096001&
%TRUST_E_NO_SIGNER_CERT           = &H80096002&
%TRUST_E_COUNTER_SIGNER           = &H80096003&
%TRUST_E_CERT_SIGNATURE           = &H80096004&
%TRUST_E_TIME_STAMP               = &H80096005&
%TRUST_E_BAD_DIGEST               = &H80096010&
%TRUST_E_BASIC_CONSTRAINTS        = &H80096019&
%TRUST_E_FINANCIAL_CRITERIA       = &H8009601E&

%MSSIPOTF_E_OUTOFMEMRANGE         = &H80097001&
%MSSIPOTF_E_CANTGETOBJECT         = &H80097002&
%MSSIPOTF_E_NOHEADTABLE           = &H80097003&
%MSSIPOTF_E_BAD_MAGICNUMBER       = &H80097004&
%MSSIPOTF_E_BAD_OFFSET_TABLE      = &H80097005&
%MSSIPOTF_E_TABLE_TAGORDER        = &H80097006&
%MSSIPOTF_E_TABLE_LONGWORD        = &H80097007&
%MSSIPOTF_E_BAD_FIRST_TABLE_PLACEMENT = &H80097008&
%MSSIPOTF_E_TABLES_OVERLAP        = &H80097009&
%MSSIPOTF_E_TABLE_PADBYTES        = &H8009700A&
%MSSIPOTF_E_FILETOOSMALL          = &H8009700B&
%MSSIPOTF_E_TABLE_CHECKSUM        = &H8009700C&
%MSSIPOTF_E_FILE_CHECKSUM         = &H8009700D&
%MSSIPOTF_E_FAILED_POLICY         = &H80097010&
%MSSIPOTF_E_FAILED_HINTS_CHECK    = &H80097011&
%MSSIPOTF_E_NOT_OPENTYPE          = &H80097012&
%MSSIPOTF_E_FILE                  = &H80097013&
%MSSIPOTF_E_CRYPT                 = &H80097014&
%MSSIPOTF_E_BADVERSION            = &H80097015&
%MSSIPOTF_E_DSIG_STRUCTURE        = &H80097016&
%MSSIPOTF_E_PCONST_CHECK          = &H80097017&
%MSSIPOTF_E_STRUCTURE             = &H80097018&

%NTE_OP_OK = 0

%TRUST_E_PROVIDER_UNKNOWN         = &H800B0001&
%TRUST_E_ACTION_UNKNOWN           = &H800B0002&
%TRUST_E_SUBJECT_FORM_UNKNOWN     = &H800B0003&
%TRUST_E_SUBJECT_NOT_TRUSTED      = &H800B0004&

%DIGSIG_E_ENCODE                  = &H800B0005&
%DIGSIG_E_DECODE                  = &H800B0006&
%DIGSIG_E_EXTENSIBILITY           = &H800B0007&
%DIGSIG_E_CRYPTO                  = &H800B0008&

%PERSIST_E_SIZEDEFINITE           = &H800B0009&
%PERSIST_E_SIZEINDEFINITE         = &H800B000A&
%PERSIST_E_NOTSELFSIZING          = &H800B000B&

%TRUST_E_NOSIGNATURE              = &H800B0100&

%CERT_E_EXPIRED                   = &H800B0101&
%CERT_E_VALIDITYPERIODNESTING     = &H800B0102&
%CERT_E_ROLE                      = &H800B0103&
%CERT_E_PATHLENCONST              = &H800B0104&
%CERT_E_CRITICAL                  = &H800B0105&
%CERT_E_PURPOSE                   = &H800B0106&
%CERT_E_ISSUERCHAINING            = &H800B0107&
%CERT_E_MALFORMED                 = &H800B0108&
%CERT_E_UNTRUSTEDROOT             = &H800B0109&
%CERT_E_CHAINING                  = &H800B010A&

%TRUST_E_FAIL                     = &H800B010B&

%CERT_E_REVOKED                   = &H800B010C&
%CERT_E_UNTRUSTEDTESTROOT         = &H800B010D&
%CERT_E_REVOCATION_FAILURE        = &H800B010E&
%CERT_E_CN_NO_MATCH               = &H800B010F&
%CERT_E_WRONG_USAGE               = &H800B0110&

%TRUST_E_EXPLICIT_DISTRUST        = &H800B0111&

%CERT_E_UNTRUSTEDCA               = &H800B0112&

%SPAPI_E_EXPECTED_SECTION_NAME       = &H800F0000&
%SPAPI_E_BAD_SECTION_NAME_LINE       = &H800F0001&
%SPAPI_E_SECTION_NAME_TOO_LONG       = &H800F0002&
%SPAPI_E_GENERAL_SYNTAX              = &H800F0003&
%SPAPI_E_WRONG_INF_STYLE             = &H800F0100&
%SPAPI_E_SECTION_NOT_FOUND           = &H800F0101&
%SPAPI_E_LINE_NOT_FOUND              = &H800F0102&
%SPAPI_E_NO_BACKUP                   = &H800F0103&
%SPAPI_E_NO_ASSOCIATED_CLASS         = &H800F0200&
%SPAPI_E_CLASS_MISMATCH              = &H800F0201&
%SPAPI_E_DUPLICATE_FOUND             = &H800F0202&
%SPAPI_E_NO_DRIVER_SELECTED          = &H800F0203&
%SPAPI_E_KEY_DOES_NOT_EXIST          = &H800F0204&
%SPAPI_E_INVALID_DEVINST_NAME        = &H800F0205&
%SPAPI_E_INVALID_CLASS               = &H800F0206&
%SPAPI_E_DEVINST_ALREADY_EXISTS      = &H800F0207&
%SPAPI_E_DEVINFO_NOT_REGISTERED      = &H800F0208&
%SPAPI_E_INVALID_REG_PROPERTY        = &H800F0209&
%SPAPI_E_NO_INF                      = &H800F020A&
%SPAPI_E_NO_SUCH_DEVINST             = &H800F020B&
%SPAPI_E_CANT_LOAD_CLASS_ICON        = &H800F020C&
%SPAPI_E_INVALID_CLASS_INSTALLER     = &H800F020D&
%SPAPI_E_DI_DO_DEFAULT               = &H800F020E&
%SPAPI_E_DI_NOFILECOPY               = &H800F020F&
%SPAPI_E_INVALID_HWPROFILE           = &H800F0210&
%SPAPI_E_NO_DEVICE_SELECTED          = &H800F0211&
%SPAPI_E_DEVINFO_LIST_LOCKED         = &H800F0212&
%SPAPI_E_DEVINFO_DATA_LOCKED         = &H800F0213&
%SPAPI_E_DI_BAD_PATH                 = &H800F0214&
%SPAPI_E_NO_CLASSINSTALL_PARAMS      = &H800F0215&
%SPAPI_E_FILEQUEUE_LOCKED            = &H800F0216&
%SPAPI_E_BAD_SERVICE_INSTALLSECT     = &H800F0217&
%SPAPI_E_NO_CLASS_DRIVER_LIST        = &H800F0218&
%SPAPI_E_NO_ASSOCIATED_SERVICE       = &H800F0219&
%SPAPI_E_NO_DEFAULT_DEVICE_INTERFACE = &H800F021A&
%SPAPI_E_DEVICE_INTERFACE_ACTIVE     = &H800F021B&
%SPAPI_E_DEVICE_INTERFACE_REMOVED    = &H800F021C&
%SPAPI_E_BAD_INTERFACE_INSTALLSECT   = &H800F021D&
%SPAPI_E_NO_SUCH_INTERFACE_CLASS     = &H800F021E&
%SPAPI_E_INVALID_REFERENCE_STRING    = &H800F021F&
%SPAPI_E_INVALID_MACHINENAME         = &H800F0220&
%SPAPI_E_REMOTE_COMM_FAILURE         = &H800F0221&
%SPAPI_E_MACHINE_UNAVAILABLE         = &H800F0222&
%SPAPI_E_NO_CONFIGMGR_SERVICES       = &H800F0223&
%SPAPI_E_INVALID_PROPPAGE_PROVIDER   = &H800F0224&
%SPAPI_E_NO_SUCH_DEVICE_INTERFACE    = &H800F0225&
%SPAPI_E_DI_POSTPROCESSING_REQUIRED  = &H800F0226&
%SPAPI_E_INVALID_COINSTALLER         = &H800F0227&
%SPAPI_E_NO_COMPAT_DRIVERS           = &H800F0228&
%SPAPI_E_NO_DEVICE_ICON              = &H800F0229&
%SPAPI_E_INVALID_INF_LOGCONFIG       = &H800F022A&
%SPAPI_E_DI_DONT_INSTALL             = &H800F022B&
%SPAPI_E_INVALID_FILTER_DRIVER       = &H800F022C&
%SPAPI_E_NON_WINDOWS_NT_DRIVER       = &H800F022D&
%SPAPI_E_NON_WINDOWS_DRIVER          = &H800F022E&
%SPAPI_E_NO_CATALOG_FOR_OEM_INF      = &H800F022F&
%SPAPI_E_DEVINSTALL_QUEUE_NONNATIVE  = &H800F0230&
%SPAPI_E_NOT_DISABLEABLE             = &H800F0231&
%SPAPI_E_CANT_REMOVE_DEVINST         = &H800F0232&
%SPAPI_E_ERROR_NOT_INSTALLED         = &H800F1000&

%SCARD_S_SUCCESS                  = %NO_ERROR
%SCARD_F_INTERNAL_ERROR           = &H80100001&
%SCARD_E_CANCELLED                = &H80100002&
%SCARD_E_INVALID_HANDLE           = &H80100003&
%SCARD_E_INVALID_PARAMETER        = &H80100004&
%SCARD_E_INVALID_TARGET           = &H80100005&
%SCARD_E_NO_MEMORY                = &H80100006&
%SCARD_F_WAITED_TOO_LONG          = &H80100007&
%SCARD_E_INSUFFICIENT_BUFFER      = &H80100008&
%SCARD_E_UNKNOWN_READER           = &H80100009&
%SCARD_E_TIMEOUT                  = &H8010000A&
%SCARD_E_SHARING_VIOLATION        = &H8010000B&
%SCARD_E_NO_SMARTCARD             = &H8010000C&
%SCARD_E_UNKNOWN_CARD             = &H8010000D&
%SCARD_E_CANT_DISPOSE             = &H8010000E&
%SCARD_E_PROTO_MISMATCH           = &H8010000F&
%SCARD_E_NOT_READY                = &H80100010&
%SCARD_E_INVALID_VALUE            = &H80100011&
%SCARD_E_SYSTEM_CANCELLED         = &H80100012&
%SCARD_F_COMM_ERROR               = &H80100013&
%SCARD_F_UNKNOWN_ERROR            = &H80100014&
%SCARD_E_INVALID_ATR              = &H80100015&
%SCARD_E_NOT_TRANSACTED           = &H80100016&
%SCARD_E_READER_UNAVAILABLE       = &H80100017&
%SCARD_P_SHUTDOWN                 = &H80100018&
%SCARD_E_PCI_TOO_SMALL            = &H80100019&
%SCARD_E_READER_UNSUPPORTED       = &H8010001A&
%SCARD_E_DUPLICATE_READER         = &H8010001B&
%SCARD_E_CARD_UNSUPPORTED         = &H8010001C&
%SCARD_E_NO_SERVICE               = &H8010001D&
%SCARD_E_SERVICE_STOPPED          = &H8010001E&
%SCARD_E_UNEXPECTED               = &H8010001F&
%SCARD_E_ICC_INSTALLATION         = &H80100020&
%SCARD_E_ICC_CREATEORDER          = &H80100021&
%SCARD_E_UNSUPPORTED_FEATURE      = &H80100022&
%SCARD_E_DIR_NOT_FOUND            = &H80100023&
%SCARD_E_FILE_NOT_FOUND           = &H80100024&
%SCARD_E_NO_DIR                   = &H80100025&
%SCARD_E_NO_FILE                  = &H80100026&
%SCARD_E_NO_ACCESS                = &H80100027&
%SCARD_E_WRITE_TOO_MANY           = &H80100028&
%SCARD_E_BAD_SEEK                 = &H80100029&
%SCARD_E_INVALID_CHV              = &H8010002A&
%SCARD_E_UNKNOWN_RES_MNG          = &H8010002B&
%SCARD_E_NO_SUCH_CERTIFICATE      = &H8010002C&
%SCARD_E_CERTIFICATE_UNAVAILABLE  = &H8010002D&
%SCARD_E_NO_READERS_AVAILABLE     = &H8010002E&
%SCARD_E_COMM_DATA_LOST           = &H8010002F&
%SCARD_W_UNSUPPORTED_CARD         = &H80100065&
%SCARD_W_UNRESPONSIVE_CARD        = &H80100066&
%SCARD_W_UNPOWERED_CARD           = &H80100067&
%SCARD_W_RESET_CARD               = &H80100068&
%SCARD_W_REMOVED_CARD             = &H80100069&
%SCARD_W_SECURITY_VIOLATION       = &H8010006A&
%SCARD_W_WRONG_CHV                = &H8010006B&
%SCARD_W_CHV_BLOCKED              = &H8010006C&
%SCARD_W_EOF                      = &H8010006D&
%SCARD_W_CANCELLED_BY_USER        = &H8010006E&

%COMADMIN_E_OBJECTERRORS                = &H80110401&
%COMADMIN_E_OBJECTINVALID               = &H80110402&
%COMADMIN_E_KEYMISSING                  = &H80110403&
%COMADMIN_E_ALREADYINSTALLED            = &H80110404&
%COMADMIN_E_APP_FILE_WRITEFAIL          = &H80110407&
%COMADMIN_E_APP_FILE_READFAIL           = &H80110408&
%COMADMIN_E_APP_FILE_VERSION            = &H80110409&
%COMADMIN_E_BADPATH                     = &H8011040A&
%COMADMIN_E_APPLICATIONEXISTS           = &H8011040B&
%COMADMIN_E_ROLEEXISTS                  = &H8011040C&
%COMADMIN_E_CANTCOPYFILE                = &H8011040D&
%COMADMIN_E_NOUSER                      = &H8011040F&
%COMADMIN_E_INVALIDUSERIDS              = &H80110410&
%COMADMIN_E_NOREGISTRYCLSID             = &H80110411&
%COMADMIN_E_BADREGISTRYPROGID           = &H80110412&
%COMADMIN_E_AUTHENTICATIONLEVEL         = &H80110413&
%COMADMIN_E_USERPASSWDNOTVALID          = &H80110414&
%COMADMIN_E_CLSIDORIIDMISMATCH          = &H80110418&
%COMADMIN_E_REMOTEINTERFACE             = &H80110419&
%COMADMIN_E_DLLREGISTERSERVER           = &H8011041A&
%COMADMIN_E_NOSERVERSHARE               = &H8011041B&
%COMADMIN_E_DLLLOADFAILED               = &H8011041D&
%COMADMIN_E_BADREGISTRYLIBID            = &H8011041E&
%COMADMIN_E_APPDIRNOTFOUND              = &H8011041F&
%COMADMIN_E_REGISTRARFAILED             = &H80110423&
%COMADMIN_E_COMPFILE_DOESNOTEXIST       = &H80110424&
%COMADMIN_E_COMPFILE_LOADDLLFAIL        = &H80110425&
%COMADMIN_E_COMPFILE_GETCLASSOBJ        = &H80110426&
%COMADMIN_E_COMPFILE_CLASSNOTAVAIL      = &H80110427&
%COMADMIN_E_COMPFILE_BADTLB             = &H80110428&
%COMADMIN_E_COMPFILE_NOTINSTALLABLE     = &H80110429&
%COMADMIN_E_NOTCHANGEABLE               = &H8011042A&
%COMADMIN_E_NOTDELETEABLE               = &H8011042B&
%COMADMIN_E_SESSION                     = &H8011042C&
%COMADMIN_E_COMP_MOVE_LOCKED            = &H8011042D&
%COMADMIN_E_COMP_MOVE_BAD_DEST          = &H8011042E&
%COMADMIN_E_REGISTERTLB                 = &H80110430&
%COMADMIN_E_SYSTEMAPP                   = &H80110433&
%COMADMIN_E_COMPFILE_NOREGISTRAR        = &H80110434&
%COMADMIN_E_COREQCOMPINSTALLED          = &H80110435&
%COMADMIN_E_SERVICENOTINSTALLED         = &H80110436&
%COMADMIN_E_PROPERTYSAVEFAILED          = &H80110437&
%COMADMIN_E_OBJECTEXISTS                = &H80110438&
%COMADMIN_E_REGFILE_CORRUPT             = &H8011043B&
%COMADMIN_E_PROPERTY_OVERFLOW           = &H8011043C&
%COMADMIN_E_NOTINREGISTRY               = &H8011043E&
%COMADMIN_E_OBJECTNOTPOOLABLE           = &H8011043F&
%COMADMIN_E_APPLID_MATCHES_CLSID        = &H80110446&
%COMADMIN_E_ROLE_DOES_NOT_EXIST         = &H80110447&
%COMADMIN_E_START_APP_NEEDS_COMPONENTS  = &H80110448&
%COMADMIN_E_REQUIRES_DIFFERENT_PLATFORM = &H80110449&
%COMADMIN_E_CAN_NOT_EXPORT_APP_PROXY    = &H8011044A&
%COMADMIN_E_CAN_NOT_START_APP           = &H8011044B&
%COMADMIN_E_CAN_NOT_EXPORT_SYS_APP      = &H8011044C&
%COMADMIN_E_CANT_SUBSCRIBE_TO_COMPONENT = &H8011044D&
%COMADMIN_E_OBJECT_PARENT_MISSING       = &H80110808&
%COMADMIN_E_OBJECT_DOES_NOT_EXIST       = &H80110809&

%COMQC_E_APPLICATION_NOT_QUEUED         = &H80110600&
%COMQC_E_NO_QUEUEABLE_INTERFACES        = &H80110601&
%COMQC_E_QUEUING_SERVICE_NOT_AVAILABLE  = &H80110602&

#ENDIF ' #IF NOT %DEF(%WINERROR_INC)

' End of constants from winerror.h ============================================

' Constants from sensapi.h ====================================================

%NETWORK_ALIVE_LAN = &H00000001
%NETWORK_ALIVE_WAN = &H00000002
%NETWORK_ALIVE_AOL = &H00000004

' End of constants from sensapi.h =============================================

' Constants from winnt.h ======================================================

%ANYSIZE_ARRAY = 1

%MAX_NATURAL_ALIGNMENT = 4   ' SIZEOF(DWORD)

%APPLICATION_ERROR_MASK       = &H20000000&
%ERROR_SEVERITY_SUCCESS       = &H00000000&
%ERROR_SEVERITY_INFORMATIONAL = &H40000000&
%ERROR_SEVERITY_WARNING       = &H80000000&
%ERROR_SEVERITY_ERROR         = &HC0000000&

%MINCHAR  = &H80?
%MAXCHAR  = &H7F?
%MINSHORT = &H8000%
%MAXSHORT = &H7FFF%
%MINLONG  = &H80000000&
%MAXBYTE  = &HFF?
%MAXWORD  = &HFFFF??
%MAXDWORD = &HFFFFFFFF???

'
' Language IDs.
'
' The following two combinations of primary language ID and
' sublanguage ID have special semantics:
'
'   Primary Language ID   Sublanguage ID        Result
'   -------------------   ---------------       ------------------------
'   %LANG_NEUTRAL         %SUBLANG_NEUTRAL      Language neutral
'   %LANG_NEUTRAL         %SUBLANG_DEFAULT      User default language
'   %LANG_NEUTRAL         %SUBLANG_SYS_DEFAULT  System default language
'

'
'  Primary language IDs.
'

%LANG_NEUTRAL   = &H00

%LANG_AFRIKAANS  = &H36
%LANG_ALBANIAN   = &H1c
%LANG_ARABIC     = &H01
%LANG_ARMENIAN   = &H2b
%LANG_ASSAMESE   = &H4d
%LANG_AZERI      = &H2c
%LANG_BASQUE     = &H2d
%LANG_BELARUSIAN = &H23
%LANG_BENGALI    = &H45
%LANG_BULGARIAN  = &H02
%LANG_CATALAN    = &H03
%LANG_CHINESE    = &H04
%LANG_CROATIAN   = &H1a
%LANG_CZECH      = &H05
%LANG_DANISH     = &H06
%LANG_DUTCH      = &H13
%LANG_ENGLISH    = &H09
%LANG_ESTONIAN   = &H25
%LANG_FAEROESE   = &H38
%LANG_FARSI      = &H29
%LANG_FINNISH    = &H0b
%LANG_FRENCH     = &H0c
%LANG_GEORGIAN   = &H37
%LANG_GERMAN     = &H07
%LANG_GREEK      = &H08
%LANG_GUJARATI   = &H47
%LANG_HEBREW     = &H0d
%LANG_HINDI      = &H39
%LANG_HUNGARIAN  = &H0e
%LANG_ICELANDIC  = &H0f
%LANG_INDONESIAN = &H21
%LANG_ITALIAN    = &H10
%LANG_JAPANESE   = &H11
%LANG_KANNADA    = &H4b
%LANG_KASHMIRI   = &H60
%LANG_KAZAK      = &H3f
%LANG_KONKANI    = &H57
%LANG_KOREAN     = &H12
%LANG_LATVIAN    = &H26
%LANG_LITHUANIAN = &H27
%LANG_MACEDONIAN = &H2f
%LANG_MALAY      = &H3e
%LANG_MALAYALAM  = &H4c
%LANG_MANIPURI   = &H58
%LANG_MARATHI    = &H4e
%LANG_NEPALI     = &H61
%LANG_NORWEGIAN  = &H14
%LANG_ORIYA      = &H48
%LANG_POLISH     = &H15
%LANG_PORTUGUESE = &H16
%LANG_PUNJABI    = &H46
%LANG_ROMANIAN   = &H18
%LANG_RUSSIAN    = &H19
%LANG_SANSKRIT   = &H4f
%LANG_SERBIAN    = &H1a
%LANG_SINDHI     = &H59
%LANG_SLOVAK     = &H1b
%LANG_SLOVENIAN  = &H24
%LANG_SPANISH    = &H0a
%LANG_SWAHILI    = &H41
%LANG_SWEDISH    = &H1d
%LANG_TAMIL      = &H49
%LANG_TATAR      = &H44
%LANG_TELUGU     = &H4a
%LANG_THAI       = &H1e
%LANG_TURKISH    = &H1f
%LANG_UKRAINIAN  = &H22
%LANG_URDU       = &H20
%LANG_UZBEK      = &H43
%LANG_VIETNAMESE = &H2a


'
' Sublanguage IDs.
'
' The name immediately following SUBLANG_ dictates which primary
' language ID that sublanguage ID can be combined with to form a
' valid language ID.
'

%SUBLANG_NEUTRAL                  = &H00  ' language neutral
%SUBLANG_DEFAULT                  = &H01  ' user default
%SUBLANG_SYS_DEFAULT              = &H02  ' system default

%SUBLANG_ARABIC_SAUDI_ARABIA      = &H01  ' Arabic (Saudi Arabia)
%SUBLANG_ARABIC_IRAQ              = &H02  ' Arabic (Iraq)
%SUBLANG_ARABIC_EGYPT             = &H03  ' Arabic (Egypt)
%SUBLANG_ARABIC_LIBYA             = &H04  ' Arabic (Libya)
%SUBLANG_ARABIC_ALGERIA           = &H05  ' Arabic (Algeria)
%SUBLANG_ARABIC_MOROCCO           = &H06  ' Arabic (Morocco)
%SUBLANG_ARABIC_TUNISIA           = &H07  ' Arabic (Tunisia)
%SUBLANG_ARABIC_OMAN              = &H08  ' Arabic (Oman)
%SUBLANG_ARABIC_YEMEN             = &H09  ' Arabic (Yemen)
%SUBLANG_ARABIC_SYRIA             = &H0a  ' Arabic (Syria)
%SUBLANG_ARABIC_JORDAN            = &H0b  ' Arabic (Jordan)
%SUBLANG_ARABIC_LEBANON           = &H0c  ' Arabic (Lebanon)
%SUBLANG_ARABIC_KUWAIT            = &H0d  ' Arabic (Kuwait)
%SUBLANG_ARABIC_UAE               = &H0e  ' Arabic (U.A.E)
%SUBLANG_ARABIC_BAHRAIN           = &H0f  ' Arabic (Bahrain)
%SUBLANG_ARABIC_QATAR             = &H10  ' Arabic (Qatar)
%SUBLANG_AZERI_LATIN              = &H01  ' Azeri (Latin)
%SUBLANG_AZERI_CYRILLIC           = &H02  ' Azeri (Cyrillic)
%SUBLANG_CHINESE_TRADITIONAL      = &H01  ' Chinese (Taiwan Region)
%SUBLANG_CHINESE_SIMPLIFIED       = &H02  ' Chinese (PR China)
%SUBLANG_CHINESE_HONGKONG         = &H03  ' Chinese (Hong Kong)
%SUBLANG_CHINESE_SINGAPORE        = &H04  ' Chinese (Singapore)
%SUBLANG_CHINESE_MACAU            = &H05  ' Chinese (Macau)
%SUBLANG_DUTCH                    = &H01  ' Dutch
%SUBLANG_DUTCH_BELGIAN            = &H02  ' Dutch (Belgian)
%SUBLANG_ENGLISH_US               = &H01  ' English (USA)
%SUBLANG_ENGLISH_UK               = &H02  ' English (UK)
%SUBLANG_ENGLISH_AUS              = &H03  ' English (Australian)
%SUBLANG_ENGLISH_CAN              = &H04  ' English (Canadian)
%SUBLANG_ENGLISH_NZ               = &H05  ' English (New Zealand)
%SUBLANG_ENGLISH_EIRE             = &H06  ' English (Irish)
%SUBLANG_ENGLISH_SOUTH_AFRICA     = &H07  ' English (South Africa)
%SUBLANG_ENGLISH_JAMAICA          = &H08  ' English (Jamaica)
%SUBLANG_ENGLISH_CARIBBEAN        = &H09  ' English (Caribbean)
%SUBLANG_ENGLISH_BELIZE           = &H0a  ' English (Belize)
%SUBLANG_ENGLISH_TRINIDAD         = &H0b  ' English (Trinidad)
%SUBLANG_ENGLISH_ZIMBABWE         = &H0c  ' English (Zimbabwe)
%SUBLANG_ENGLISH_PHILIPPINES      = &H0d  ' English (Philippines)
%SUBLANG_FRENCH                   = &H01  ' French
%SUBLANG_FRENCH_BELGIAN           = &H02  ' French (Belgian)
%SUBLANG_FRENCH_CANADIAN          = &H03  ' French (Canadian)
%SUBLANG_FRENCH_SWISS             = &H04  ' French (Swiss)
%SUBLANG_FRENCH_LUXEMBOURG        = &H05  ' French (Luxembourg)
%SUBLANG_FRENCH_MONACO            = &H06  ' French (Monaco)
%SUBLANG_GERMAN                   = &H01  ' German
%SUBLANG_GERMAN_SWISS             = &H02  ' German (Swiss)
%SUBLANG_GERMAN_AUSTRIAN          = &H03  ' German (Austrian)
%SUBLANG_GERMAN_LUXEMBOURG        = &H04  ' German (Luxembourg)
%SUBLANG_GERMAN_LIECHTENSTEIN     = &H05  ' German (Liechtenstein)
%SUBLANG_ITALIAN                  = &H01  ' Italian
%SUBLANG_ITALIAN_SWISS            = &H02  ' Italian (Swiss)
%SUBLANG_KASHMIRI_INDIA           = &H02  ' Kashmiri (India)
%SUBLANG_KOREAN                   = &H01  ' Korean (Extended Wansung)
%SUBLANG_LITHUANIAN               = &H01  ' Lithuanian
%SUBLANG_LITHUANIAN_CLASSIC       = &H02  ' Lithuanian (Classic)
%SUBLANG_MALAY_MALAYSIA           = &H01  ' Malay (Malaysia)
%SUBLANG_MALAY_BRUNEI_DARUSSALAM  = &H02  ' Malay (Brunei Darussalam)
%SUBLANG_NEPALI_INDIA             = &H02  ' Nepali (India)
%SUBLANG_NORWEGIAN_BOKMAL         = &H01  ' Norwegian (Bokmal)
%SUBLANG_NORWEGIAN_NYNORSK        = &H02  ' Norwegian (Nynorsk)
%SUBLANG_PORTUGUESE               = &H02  ' Portuguese
%SUBLANG_PORTUGUESE_BRAZILIAN     = &H01  ' Portuguese (Brazilian)
%SUBLANG_SERBIAN_LATIN            = &H02  ' Serbian (Latin)
%SUBLANG_SERBIAN_CYRILLIC         = &H03  ' Serbian (Cyrillic)
%SUBLANG_SPANISH                  = &H01  ' Spanish (Castilian)
%SUBLANG_SPANISH_MEXICAN          = &H02  ' Spanish (Mexican)
%SUBLANG_SPANISH_MODERN           = &H03  ' Spanish (Modern)
%SUBLANG_SPANISH_GUATEMALA        = &H04  ' Spanish (Guatemala)
%SUBLANG_SPANISH_COSTA_RICA       = &H05  ' Spanish (Costa Rica)
%SUBLANG_SPANISH_PANAMA           = &H06  ' Spanish (Panama)
%SUBLANG_SPANISH_DOMINICAN_REPUBLIC = &H07  ' Spanish (Dominican Republic)
%SUBLANG_SPANISH_VENEZUELA        = &H08  ' Spanish (Venezuela)
%SUBLANG_SPANISH_COLOMBIA         = &H09  ' Spanish (Colombia)
%SUBLANG_SPANISH_PERU             = &H0a  ' Spanish (Peru)
%SUBLANG_SPANISH_ARGENTINA        = &H0b  ' Spanish (Argentina)
%SUBLANG_SPANISH_ECUADOR          = &H0c  ' Spanish (Ecuador)
%SUBLANG_SPANISH_CHILE            = &H0d  ' Spanish (Chile)
%SUBLANG_SPANISH_URUGUAY          = &H0e  ' Spanish (Uruguay)
%SUBLANG_SPANISH_PARAGUAY         = &H0f  ' Spanish (Paraguay)
%SUBLANG_SPANISH_BOLIVIA          = &H10  ' Spanish (Bolivia)
%SUBLANG_SPANISH_EL_SALVADOR      = &H11  ' Spanish (El Salvador)
%SUBLANG_SPANISH_HONDURAS         = &H12  ' Spanish (Honduras)
%SUBLANG_SPANISH_NICARAGUA        = &H13  ' Spanish (Nicaragua)
%SUBLANG_SPANISH_PUERTO_RICO      = &H14  ' Spanish (Puerto Rico)
%SUBLANG_SWEDISH                  = &H01  ' Swedish
%SUBLANG_SWEDISH_FINLAND          = &H02  ' Swedish (Finland)
%SUBLANG_URDU_PAKISTAN            = &H01  ' Urdu (Pakistan)
%SUBLANG_URDU_INDIA               = &H02  ' Urdu (India)
%SUBLANG_UZBEK_LATIN              = &H01  ' Uzbek (Latin)
%SUBLANG_UZBEK_CYRILLIC           = &H02  ' Uzbek (Cyrillic)

'
' Sorting IDs.
'

%SORT_DEFAULT              = &H0  ' sorting default

%SORT_JAPANESE_XJIS        = &H0  ' Japanese JIS order
%SORT_JAPANESE_UNICODE     = &H1  ' Japanese Unicode order

%SORT_CHINESE_BIG5         = &H0  ' Chinese BIG5 order
%SORT_CHINESE_PRCP         = &H0  ' PRC Chinese Phonetic order
%SORT_CHINESE_UNICODE      = &H1  ' Chinese Unicode order
%SORT_CHINESE_PRC          = &H2  ' PRC Chinese Stroke Count order
%SORT_CHINESE_BOPOMOFO     = &H3  ' Traditional Chinese Bopomofo order

%SORT_KOREAN_KSC           = &H0  ' Korean KSC order
%SORT_KOREAN_UNICODE       = &H1  ' Korean Unicode order

%SORT_GERMAN_PHONE_BOOK    = &H1  ' German Phone Book order

%SORT_HUNGARIAN_DEFAULT    = &H0  ' Hungarian Default order
%SORT_HUNGARIAN_TECHNICAL  = &H1  ' Hungarian Technical order

%SORT_GEORGIAN_TRADITIONAL = &H0  ' Georgian Traditional order
%SORT_GEORGIAN_MODERN      = &H1  ' Georgian Modern order

#IF NOT %DEF(%WIN32_NO_STATUS) '-----------------------------------------------
%STATUS_WAIT_0                   = &H00000000&
%STATUS_ABANDONED_WAIT_0         = &H00000080&
%STATUS_USER_APC                 = &H000000C0&
%STATUS_TIMEOUT                  = &H00000102&
%STATUS_PENDING                  = &H00000103&
%STILL_ACTIVE                    = %STATUS_PENDING
%STATUS_DATATYPE_MISALIGNMENT    = &H80000002&
%STATUS_BREAKPOINT               = &H80000003&
%STATUS_SINGLE_STEP              = &H80000004&
%STATUS_ACCESS_VIOLATION         = &HC0000005&
%STATUS_IN_PAGE_ERROR            = &HC0000006&
%STATUS_INVALID_HANDLE           = &HC0000008&
%STATUS_NO_MEMORY                = &HC0000017&
%STATUS_ILLEGAL_INSTRUCTION      = &HC000001D&
%STATUS_NONCONTINUABLE_EXCEPTION = &HC0000025&
%STATUS_INVALID_DISPOSITION      = &HC0000026&
%STATUS_ARRAY_BOUNDS_EXCEEDED    = &HC000008C&
%STATUS_FLOAT_DENORMAL_OPERAND   = &HC000008D&
%STATUS_FLOAT_DIVIDE_BY_ZERO     = &HC000008E&
%STATUS_FLOAT_INEXACT_RESULT     = &HC000008F&
%STATUS_FLOAT_INVALID_OPERATION  = &HC0000090&
%STATUS_FLOAT_OVERFLOW           = &HC0000091&
%STATUS_FLOAT_STACK_CHECK        = &HC0000092&
%STATUS_FLOAT_UNDERFLOW          = &HC0000093&
%STATUS_INTEGER_DIVIDE_BY_ZERO   = &HC0000094&
%STATUS_INTEGER_OVERFLOW         = &HC0000095&
%STATUS_PRIVILEGED_INSTRUCTION   = &HC0000096&
%STATUS_STACK_OVERFLOW           = &HC00000FD&
%STATUS_CONTROL_C_EXIT           = &HC000013A&
%STATUS_FLOAT_MULTIPLE_FAULTS    = &HC00002B4&
%STATUS_FLOAT_MULTIPLE_TRAPS     = &HC00002B5&
%STATUS_ILLEGAL_VLM_REFERENCE    = &HC00002C0&
#ENDIF ' #IF NOT %DEF(%WIN32_NO_STATUS) ---------------------------------------

%MAXIMUM_WAIT_OBJECTS = 64  ' Maximum number of wait objects

%MAXIMUM_SUSPEND_COUNT = %MAXCHAR  ' Maximum times thread can be suspended

'
'  Define the size of the 80387 save area, which is in the context frame.
'
%SIZE_OF_80387_REGISTERS = 80

'
' The following flags control the contents of the CONTEXT structure.
'

%CONTEXT_i386            = &H00010000    ' this assumes that i386 and
%CONTEXT_i486            = &H00010000    ' i486 have identical context records

%CONTEXT_CONTROL         = %CONTEXT_i386 OR &H00000001& ' SS:SP, CS:IP, FLAGS, BP
%CONTEXT_INTEGER         = %CONTEXT_i386 OR &H00000002& ' AX, BX, CX, DX, SI, DI
%CONTEXT_SEGMENTS        = %CONTEXT_i386 OR &H00000004& ' DS, ES, FS, GS
%CONTEXT_FLOATING_POINT  = %CONTEXT_i386 OR &H00000008& ' 387 state
%CONTEXT_DEBUG_REGISTERS = %CONTEXT_i386 OR &H00000010& ' DB 0-3,6,7

%CONTEXT_FULL            = %CONTEXT_CONTROL OR %CONTEXT_INTEGER OR %CONTEXT_SEGMENTS

%MAXIMUM_SUPPORTED_EXTENSION = 512

%EXCEPTION_NONCONTINUABLE     = &H1  ' Noncontinuable exception
%EXCEPTION_MAXIMUM_PARAMETERS = 15   ' maximum number of exception parameters

'
' The following are masks for the predefined standard access types
'

%DELETE                   = &H00010000
%READ_CONTROL             = &H00020000
%WRITE_DAC                = &H00040000
%WRITE_OWNER              = &H00080000
%SYNCHRONIZE              = &H00100000

%STANDARD_RIGHTS_REQUIRED = &H000F0000

%STANDARD_RIGHTS_READ     = %READ_CONTROL
%STANDARD_RIGHTS_WRITE    = %READ_CONTROL
%STANDARD_RIGHTS_EXECUTE  = %READ_CONTROL

%STANDARD_RIGHTS_ALL      = &H001F0000

%SPECIFIC_RIGHTS_ALL      = &H0000FFFF

'
' AccessSystemAcl access type
'

%ACCESS_SYSTEM_SECURITY = &H01000000&

'
' MaximumAllowed access type
'

%MAXIMUM_ALLOWED        = &H02000000&

'
' These are the generic rights.
'

%GENERIC_READ           = &H80000000&
%GENERIC_WRITE          = &H40000000&
%GENERIC_EXECUTE        = &H20000000&
%GENERIC_ALL            = &H10000000&

%SID_REVISION                    = 1     ' Current revision level
%SID_MAX_SUB_AUTHORITIES         = 15
%SID_RECOMMENDED_SUB_AUTHORITIES = 1     ' Will change to around 6 in a future release.

' In the SDK, these are from the enumerated type _SID_NAME_USE
'
%SidTypeUser           = 1
%SidTypeGroup          = 2
%SidTypeDomain         = 3
%SidTypeAlias          = 4
%SidTypeWellKnownGroup = 5
%SidTypeDeletedaccount = 6
%SidTypeInvalid        = 7
%SidTypeUnknown        = 8
%SidTypeComputer       = 9

%SECURITY_NULL_RID                   = &H00000000&
%SECURITY_WORLD_RID                  = &H00000000&
%SECURITY_LOCAL_RID                  = &H00000000&

%SECURITY_CREATOR_OWNER_RID          = &H00000000&
%SECURITY_CREATOR_GROUP_RID          = &H00000001&

%SECURITY_CREATOR_OWNER_SERVER_RID   = &H00000000&
%SECURITY_CREATOR_GROUP_SERVER_RID   = &H00000001&

%SECURITY_DIALUP_RID             = &H00000001&
%SECURITY_NETWORK_RID            = &H00000002&
%SECURITY_BATCH_RID              = &H00000003&
%SECURITY_INTERACTIVE_RID        = &H00000004&
%SECURITY_SERVICE_RID            = &H00000006&
%SECURITY_ANONYMOUS_LOGON_RID    = &H00000007&
%SECURITY_PROXY_RID              = &H00000008&
%SECURITY_ENTERPRISE_CONTROLLERS_RID = &H00000009&
%SECURITY_SERVER_LOGON_RID       = %SECURITY_ENTERPRISE_CONTROLLERS_RID
%SECURITY_PRINCIPAL_SELF_RID     = &H0000000A&
%SECURITY_AUTHENTICATED_USER_RID = &H0000000B&
%SECURITY_RESTRICTED_CODE_RID    = &H0000000C&

%SECURITY_LOGON_IDS_RID          = &H00000005&
%SECURITY_LOGON_IDS_RID_COUNT    = 3&

%SECURITY_LOCAL_SYSTEM_RID       = &H00000012&

%SECURITY_NT_NON_UNIQUE          = &H00000015&

%SECURITY_BUILTIN_DOMAIN_RID     = &H00000020&

' Well-known users ...

%DOMAIN_USER_RID_ADMIN        = &H000001F4&
%DOMAIN_USER_RID_GUEST        = &H000001F5&
%DOMAIN_USER_RID_KRBTGT       = &H000001F6&

' Well-known groups ...

%DOMAIN_GROUP_RID_ADMINS        = &H00000200&
%DOMAIN_GROUP_RID_USERS         = &H00000201&
%DOMAIN_GROUP_RID_GUESTS        = &H00000202&
%DOMAIN_GROUP_RID_COMPUTERS     = &H00000202&
%DOMAIN_GROUP_RID_CONTROLLERS   = &H00000202&
%DOMAIN_GROUP_RID_CERT_ADMINS   = &H00000202&
%DOMAIN_GROUP_RID_SCHEMA_ADMINS = &H00000202&

' Well-known aliases ...

%DOMAIN_ALIAS_RID_ADMINS      = &H00000220&
%DOMAIN_ALIAS_RID_USERS       = &H00000221&
%DOMAIN_ALIAS_RID_GUESTS      = &H00000222&
%DOMAIN_ALIAS_RID_POWER_USERS = &H00000223&

%DOMAIN_ALIAS_RID_ACCOUNT_OPS = &H00000224&
%DOMAIN_ALIAS_RID_SYSTEM_OPS  = &H00000225&
%DOMAIN_ALIAS_RID_PRINT_OPS   = &H00000226&
%DOMAIN_ALIAS_RID_BACKUP_OPS  = &H00000227&

%DOMAIN_ALIAS_RID_REPLICATOR  = &H00000228&

'
' Group attributes
'

%SE_GROUP_MANDATORY          = &H00000001&
%SE_GROUP_ENABLED_BY_DEFAULT = &H00000002&
%SE_GROUP_ENABLED            = &H00000004&
%SE_GROUP_OWNER              = &H00000008&
%SE_GROU_USE_FOR_DENY_ONLY   = &H00000010&
%SE_GROUP_LOGON_ID           = &HC0000000&

'
' User attributes
'

' (None yet defined.)

' This is the *current* ACL revision

%ACL_REVISION     = 2
%ACL_REVISION_DS  = 4

' This is the history of ACL revisions.  Add a new one whenever
' ACL_REVISION is updated

%ACL_REVISION1    = 1
%ACL_REVISION2    = 2
%MIN_ACL_REVISION = %ACL_REVISION2
%ACL_REVISION3    = 3
%ACL_REVISION4    = 4
%MAX_ACL_REVISION = %ACL_REVISION4

'
' The following are the predefined ace types that go into the AceType
' field of an Ace header.
'

%ACCESS_MIN_MS_ACE_TYPE           = &H0
%ACCESS_ALLOWED_ACE_TYPE          = &H0
%ACCESS_DENIED_ACE_TYPE           = &H1
%SYSTEM_AUDIT_ACE_TYPE            = &H2
%SYSTEM_ALARM_ACE_TYPE            = &H3
%ACCESS_MAX_MS_V2_ACE_TYPE        = &H3

%ACCESS_ALLOWED_COMPOUND_ACE_TYPE = &H4
%ACCESS_MAX_MS_V3_ACE_TYPE        = &H4

%ACCESS_MIN_MS_OBJECT_ACE_TYPE    = &H5
%ACCESS_ALLOWED_OBJECT_ACE_TYPE   = &H5
%ACCESS_DENIED_OBJECT_ACE_TYPE    = &H6
%SYSTEM_AUDIT_OBJECT_ACE_TYPE     = &H7
%SYSTEM_ALARM_OBJECT_ACE_TYPE     = &H8
%ACCESS_MAX_MS_OBJECT_ACE_TYPE    = &H8

%ACCESS_MAX_MS_V4_ACE_TYPE        = &H8
%ACCESS_MAX_MS_ACE_TYPE           = &H8

'
' The following are the inherit flags that go into the AceFlags field
' of an Ace header.
'

%OBJECT_INHERIT_ACE       = &H1
%CONTAINER_INHERIT_ACE    = &H2
%NO_PROPAGATE_INHERIT_ACE = &H4
%INHERIT_ONLY_ACE         = &H8
%INHERITED_ACE            = &H10
%VALID_INHERIT_FLAGS      = &H1F

' The following are the currently defined ACE flags that go into the
' AceFlags field of an ACE header.  Each ACE type has its own set of
' AceFlags.
'
' SUCCESSFUL_ACCESS_ACE_FLAG - used only with system audit and alarm ACE
' types to indicate that a message is generated for successful accesses.
'
' FAILED_ACCESS_ACE_FLAG - used only with system audit and alarm ACE types
' to indicate that a message is generated for failed accesses.
'

'
' SYSTEM_AUDIT and SYSTEM_ALARM AceFlags
'
' These control the signaling of audit and alarms for success or failure.
'

%SUCCESSFUL_ACCESS_ACE_FLAG = &H40
%FAILED_ACCESS_ACE_FLAG     = &H80

'
' Currently define Flags for "OBJECT" ACE types.
'

%ACE_OBJECT_TYPE_PRESENT           = &H1
%ACE_INHERITED_OBJECT_TYPE_PRESENT = &H2

%AclRevisionInformation = 1
%AclSizeInformation     = 2

'
' Current security descriptor revision value
'

%SECURITY_DESCRIPTOR_REVISION   = 1
%SECURITY_DESCRIPTOR_REVISION1  = 1

%SECURITY_DESCRIPTOR_MIN_LENGTH = 20  ' SIZEOF(SECURITY_DESCRIPTOR)

%SE_OWNER_DEFAULTED       = &H0001
%SE_GROUP_DEFAULTED       = &H0002
%SE_DACL_PRESENT          = &H0004
%SE_DACL_DEFAULTED        = &H0008
%SE_SACL_PRESENT          = &H0010
%SE_SACL_DEFAULTED        = &H0020
%SE_DACL_AUTO_INHERIT_REQ = &H0100
%SE_SACL_AUTO_INHERIT_REQ = &H0200
%SE_DACL_AUTO_INHERITED   = &H0400
%SE_SACL_AUTO_INHERITED   = &H0800
%SE_DACL_PROTECTED        = &H1000
%SE_SACL_PROTECTED        = &H2000
%SE_SELF_RELATIVE         = &H8000

'
' DS values for Level
'

%ACCESS_OBJECT_GUID       = 0
%ACCESS_PROPERTY_SET_GUID = 1
%ACCESS_PROPERTY_GUID     = 2
%ACCESS_MAX_LEVEL         = 4

'
' Parameters to NtAccessCheckByTypeAndAuditAlarm
'
%AuditEventObjectAccess           = 0
%AuditEventDirectoryServiceAccess = 1


%AUDIT_ALLOW_NO_PRIVILEGE = &H1

'
' DS values for Source and ObjectTypeName
'

$ACCESS_DS_SOURCE           = "DS"
$ACCESS_DS_OBJECT_TYPE_NAME = "Directory Service Object"

'
' Privilege attributes
'

%SE_PRIVILEGE_ENABLED_BY_DEFAULT = &H00000001
%SE_PRIVILEGE_ENABLED            = &H00000002
%SE_PRIVILEGE_USED_FOR_ACCESS    = &H80000000

'
' Privilege Set Control flags
'

%PRIVILEGE_SET_ALL_NECESSARY = 1

'
' NT Defined Privileges
'

$SE_CREATE_TOKEN_NAME       = "SeCreateTokenPrivilege"
$SE_ASSIGNPRIMARYTOKEN_NAME = "SeAssignPrimaryTokenPrivilege"
$SE_LOCK_MEMORY_NAME        = "SeLockMemoryPrivilege"
$SE_INCREASE_QUOTA_NAME     = "SeIncreaseQuotaPrivilege"
$SE_UNSOLICITED_INPUT_NAME  = "SeUnsolicitedInputPrivilege"
$SE_MACHINE_ACCOUNT_NAME    = "SeMachineAccountPrivilege"
$SE_TCB_NAME                = "SeTcbPrivilege"
$SE_SECURITY_NAME           = "SeSecurityPrivilege"
$SE_TAKE_OWNERSHIP_NAME     = "SeTakeOwnershipPrivilege"
$SE_LOAD_DRIVER_NAME        = "SeLoadDriverPrivilege"
$SE_SYSTEM_PROFILE_NAME     = "SeSystemProfilePrivilege"
$SE_SYSTEMTIME_NAME         = "SeSystemtimePrivilege"
$SE_PROF_SINGLE_PROCESS_NAME= "SeProfileSingleProcessPrivilege"
$SE_INC_BASE_PRIORITY_NAME  = "SeIncreaseBasePriorityPrivilege"
$SE_CREATE_PAGEFILE_NAME    = "SeCreatePagefilePrivilege"
$SE_CREATE_PERMANENT_NAME   = "SeCreatePermanentPrivilege"
$SE_BACKUP_NAME             = "SeBackupPrivilege"
$SE_RESTORE_NAME            = "SeRestorePrivilege"
$SE_SHUTDOWN_NAME           = "SeShutdownPrivilege"
$SE_DEBUG_NAME              = "SeDebugPrivilege"
$SE_AUDIT_NAME              = "SeAuditPrivilege"
$SE_SYSTEM_ENVIRONMENT_NAME = "SeSystemEnvironmentPrivilege"
$SE_CHANGE_NOTIFY_NAME      = "SeChangeNotifyPrivilege"
$SE_REMOTE_SHUTDOWN_NAME    = "SeRemoteShutdownPrivilege"

' Security Quality Of Service

' Impersonation Level
'
' Impersonation level is represented by a pair of bits in Windows.
' If a new impersonation level is added or lowest value is changed from
' 0 to something else, fix the Windows CreateFile call.
'
' These constants derive from the SECURITY_IMPERSONATION_LEVEL enumerated type
'
%SecurityAnonymous      = 0
%SecurityIdentification = 1
%SecurityImpersonation  = 2
%SecurityDelegation     = 3

%SECURITY_MAX_IMPERSONATION_LEVEL = %SecurityDelegation
%DEFAULT_IMPERSONATION_LEVEL      = %SecurityImpersonation

' Token Object Definitions

' Token Specific Access Rights.

%TOKEN_ASSIGN_PRIMARY    = &H0001
%TOKEN_DUPLICATE         = &H0002
%TOKEN_IMPERSONATE       = &H0004
%TOKEN_QUERY             = &H0008
%TOKEN_QUERY_SOURCE      = &H0010
%TOKEN_ADJUST_PRIVILEGES = &H0020
%TOKEN_ADJUST_GROUPS     = &H0040
%TOKEN_ADJUST_DEFAULT    = &H0080
%TOKEN_ADJUST_SESSIONID  = &H0100

%TOKEN_ALL_ACCESS = %STANDARD_RIGHTS_REQUIRED  OR _
                          %TOKEN_ASSIGN_PRIMARY      OR _
                          %TOKEN_DUPLICATE           OR _
                          %TOKEN_IMPERSONATE         OR _
                          %TOKEN_QUERY               OR _
                          %TOKEN_QUERY_SOURCE        OR _
                          %TOKEN_ADJUST_PRIVILEGES   OR _
                          %TOKEN_ADJUST_GROUPS       OR _
                          %TOKEN_ADJUST_SESSIONID    OR _
                          %TOKEN_ADJUST_DEFAULT

%TOKEN_READ       = %STANDARD_RIGHTS_READ      OR _
                          %TOKEN_QUERY

%TOKEN_WRITE      = %STANDARD_RIGHTS_WRITE     OR _
                          %TOKEN_ADJUST_PRIVILEGES   OR _
                          %TOKEN_ADJUST_GROUPS       OR _
                          %TOKEN_ADJUST_DEFAULT

%TOKEN_EXECUTE    = %STANDARD_RIGHTS_EXECUTE

' Token Types / enumerated type TOKEN_TYPE

%TokenPrimary       = 1
%TokenImpersonation = 2

' Token Information Classes. / enumerated type TOKEN_INFORMATION_CLASS

%TokenUser               = 1
%TokenGroups             = 2
%TokenPrivileges         = 3
%TokenOwner              = 4
%TokenPrimaryGroup       = 5
%TokenDefaultDacl        = 6
%TokenSource             = 7
%TokenType               = 8
%TokenImpersonationLevel = 9
%TokenStatistics         = 10
%TokenRestrictedSids     = 11
%TokenSessionId          = 12

%TOKEN_SOURCE_LENGTH = 8

' Security Tracking Mode

%SECURITY_DYNAMIC_TRACKING = 1
%SECURITY_STATIC_TRACKING  = 0

%DISABLE_MAX_PRIVILEGE = &H1

%OWNER_SECURITY_INFORMATION = &H00000001&
%GROUP_SECURITY_INFORMATION = &H00000002&
%DACL_SECURITY_INFORMATION  = &H00000004&
%SACL_SECURITY_INFORMATION  = &H00000008&

%PROTECTED_DACL_SECURITY_INFORMATION   = &H80000000&
%PROTECTED_SACL_SECURITY_INFORMATION   = &H40000000&
%UNPROTECTED_DACL_SECURITY_INFORMATION = &H20000000&
%UNPROTECTED_SACL_SECURITY_INFORMATION = &H10000000&

%PROCESS_TERMINATE         = &H0001
%PROCESS_CREATE_THREAD     = &H0002
%PROCESS_SET_SESSIONID     = &H0004
%PROCESS_VM_OPERATION      = &H0008
%PROCESS_VM_READ           = &H0010
%PROCESS_VM_WRITE          = &H0020
%PROCESS_DUP_HANDLE        = &H0040
%PROCESS_CREATE_PROCESS    = &H0080
%PROCESS_SET_QUOTA         = &H0100
%PROCESS_SET_INFORMATION   = &H0200
%PROCESS_QUERY_INFORMATION = &H0400
%PROCESS_ALL_ACCESS = %STANDARD_RIGHTS_REQUIRED OR %SYNCHRONIZE OR &H0FFF

%MAXIMUM_PROCESSORS = 32

%THREAD_TERMINATE            = &H0001
%THREAD_SUSPEND_RESUME       = &H0002
%THREAD_GET_CONTEXT          = &H0008
%THREAD_SET_CONTEXT          = &H0010
%THREAD_SET_INFORMATION      = &H0020
%THREAD_QUERY_INFORMATION    = &H0040
%THREAD_SET_THREAD_TOKEN     = &H0080
%THREAD_IMPERSONATE          = &H0100
%THREAD_DIRECT_IMPERSONATION = &H0200

%THREAD_ALL_ACCESS = %STANDARD_RIGHTS_REQUIRED OR %SYNCHRONIZE OR &H03FF

%JOB_OBJECT_ASSIGN_PROCESS           = &H0001
%JOB_OBJECT_SET_ATTRIBUTES           = &H0002
%JOB_OBJECT_QUERY                    = &H0004
%JOB_OBJECT_TERMINATE                = &H0008
%JOB_OBJECT_SET_SECURITY_ATTRIBUTES  = &H0010
%JOB_OBJECT_ALL_ACCESS = %STANDARD_RIGHTS_REQUIRED OR %SYNCHRONIZE OR &H1F
%TLS_MINIMUM_AVAILABLE = 64

'
' Completion Port Messages for job objects
'
' These values are returned via the lpNumberOfBytesTransferred parameter
'

%JOB_OBJECT_MSG_END_OF_JOB_TIME       = 1
%JOB_OBJECT_MSG_END_OF_PROCESS_TIME   = 2
%JOB_OBJECT_MSG_ACTIVE_PROCESS_LIMIT  = 3
%JOB_OBJECT_MSG_ACTIVE_PROCESS_ZERO   = 4
%JOB_OBJECT_MSG_NEW_PROCESS           = 6
%JOB_OBJECT_MSG_EXIT_PROCESS          = 7
%JOB_OBJECT_MSG_ABNORMAL_EXIT_PROCESS = 8
%JOB_OBJECT_MSG_PROCESS_MEMORY_LIMIT  = 9
%JOB_OBJECT_MSG_JOB_MEMORY_LIMIT      = 10

'
' Basic Limits
'
%JOB_OBJECT_LIMIT_WORKINGSET        = &H00000001
%JOB_OBJECT_LIMIT_PROCESS_TIME      = &H00000002
%JOB_OBJECT_LIMIT_JOB_TIME          = &H00000004
%JOB_OBJECT_LIMIT_ACTIVE_PROCESS    = &H00000008
%JOB_OBJECT_LIMIT_AFFINITY          = &H00000010
%JOB_OBJECT_LIMIT_PRIORITY_CLASS    = &H00000020
%JOB_OBJECT_LIMIT_PRESERVE_JOB_TIME = &H00000040
%JOB_OBJECT_LIMIT_SCHEDULING_CLASS  = &H00000080

'
' Extended Limits
'
%JOB_OBJECT_LIMIT_PROCESS_MEMORY             = &H00000100
%JOB_OBJECT_LIMIT_JOB_MEMORY                 = &H00000200
%JOB_OBJECT_LIMIT_DIE_ON_UNHANDLED_EXCEPTION = &H00000400
%JOB_OBJECT_LIMIT_BREAKAWAY_OK               = &H00000800
%JOB_OBJECT_LIMIT_SILENT_BREAKAWAY_OK        = &H00001000

%JOB_OBJECT_LIMIT_RESERVED1                  = &H00002000
%JOB_OBJECT_LIMIT_RESERVED2                  = &H00004000
%JOB_OBJECT_LIMIT_RESERVED3                  = &H00008000
%JOB_OBJECT_LIMIT_RESERVED4                  = &H00010000
%JOB_OBJECT_LIMIT_RESERVED5                  = &H00020000
%JOB_OBJECT_LIMIT_RESERVED6                  = &H00040000

%JOB_OBJECT_LIMIT_VALID_FLAGS          = &H0007ffff

%JOB_OBJECT_BASIC_LIMIT_VALID_FLAGS    = &H000000ff
%JOB_OBJECT_EXTENDED_LIMIT_VALID_FLAGS = &H00001fff
%JOB_OBJECT_RESERVED_LIMIT_VALID_FLAGS = &H0007ffff

'
' UI restrictions for jobs
'

%JOB_OBJECT_UILIMIT_NONE             = &H00000000

%JOB_OBJECT_UILIMIT_HANDLES          = &H00000001
%JOB_OBJECT_UILIMIT_READCLIPBOARD    = &H00000002
%JOB_OBJECT_UILIMIT_WRITECLIPBOARD   = &H00000004
%JOB_OBJECT_UILIMIT_SYSTEMPARAMETERS = &H00000008
%JOB_OBJECT_UILIMIT_DISPLAYSETTINGS  = &H00000010
%JOB_OBJECT_UILIMIT_GLOBALATOMS      = &H00000020
%JOB_OBJECT_UILIMIT_DESKTOP          = &H00000040
%JOB_OBJECT_UILIMIT_EXITWINDOWS      = &H00000080

%JOB_OBJECT_UILIMIT_ALL              = &H000000FF

%JOB_OBJECT_UI_VALID_FLAGS           = &H000000FF

%JOB_OBJECT_SECURITY_NO_ADMIN         = &H00000001
%JOB_OBJECT_SECURITY_RESTRICTED_TOKEN = &H00000002
%JOB_OBJECT_SECURITY_ONLY_TOKEN       = &H00000004
%JOB_OBJECT_SECURITY_FILTER_TOKENS    = &H00000008

%JOB_OBJECT_SECURITY_VALID_FLAGS      = &H0000000f

' enumerated type JOBOBJECTINFOCLASS
%JobObjectBasicAccountingInformation         = 1
%JobObjectBasicLimitInformation              = 2
%JobObjectBasicProcessIdList                 = 3
%JobObjectBasicUIRestrictions                = 4
%JobObjectSecurityLimitInformation           = 5
%JobObjectEndOfJobTimeInformation            = 6
%JobObjectAssociateCompletionPortInformation = 7
%JobObjectBasicAndIoAccountingInformation    = 8
%JobObjectExtendedLimitInformation           = 9
%MaxJobObjectInfoClass                       = 10

%EVENT_MODIFY_STATE      = &H0002
%EVENT_ALL_ACCESS = %STANDARD_RIGHTS_REQUIRED OR %SYNCHRONIZE OR &H3
%MUTANT_QUERY_STATE      = &H0001

%MUTANT_ALL_ACCESS = %STANDARD_RIGHTS_REQUIRED OR %SYNCHRONIZE OR _
                          %MUTANT_QUERY_STATE
%SEMAPHORE_MODIFY_STATE      = &H0002
%SEMAPHORE_ALL_ACCESS = %STANDARD_RIGHTS_REQUIRED OR %SYNCHRONIZE OR &H3
'
' Timer Specific Access Rights.
'

%TIMER_QUERY_STATE       = &H0001
%TIMER_MODIFY_STATE      = &H0002

%TIMER_ALL_ACCESS = %STANDARD_RIGHTS_REQUIRED OR %SYNCHRONIZE OR _
                          %TIMER_QUERY_STATE OR %TIMER_MODIFY_STATE

%PROCESSOR_INTEL_386     = 386
%PROCESSOR_INTEL_486     = 486
%PROCESSOR_INTEL_PENTIUM = 586
%PROCESSOR_INTEL_IA64    = 2200
%PROCESSOR_MIPS_R4000    = 4000    ' incl R4101 & R3910 for Windows CE
%PROCESSOR_ALPHA_21064   = 21064
%PROCESSOR_PPC_601       = 601
%PROCESSOR_PPC_603       = 603
%PROCESSOR_PPC_604       = 604
%PROCESSOR_PPC_620       = 620
%PROCESSOR_HITACHI_SH3   = 10003   ' Windows CE
%PROCESSOR_HITACHI_SH3E  = 10004   ' Windows CE
%PROCESSOR_HITACHI_SH4   = 10005   ' Windows CE
%PROCESSOR_MOTOROLA_821  = 821     ' Windows CE
%PROCESSOR_SHx_SH3       = 103     ' Windows CE
%PROCESSOR_SHx_SH4       = 104     ' Windows CE
%PROCESSOR_STRONGARM     = 2577    ' Windows CE - = &HA11
%PROCESSOR_ARM720        = 1824    ' Windows CE - = &H720
%PROCESSOR_ARM820        = 2080    ' Windows CE - = &H820
%PROCESSOR_ARM920        = 2336    ' Windows CE - = &H920
%PROCESSOR_ARM_7TDMI     = 70001   ' Windows CE
%PROCESSOR_OPTIL         = &H494f  ' MSIL

%PROCESSOR_ARCHITECTURE_INTEL   = 0
%PROCESSOR_ARCHITECTURE_MIPS    = 1
%PROCESSOR_ARCHITECTURE_ALPHA   = 2
%PROCESSOR_ARCHITECTURE_PPC     = 3
%PROCESSOR_ARCHITECTURE_SHX     = 4
%PROCESSOR_ARCHITECTURE_ARM     = 5
%PROCESSOR_ARCHITECTURE_IA64    = 6
%PROCESSOR_ARCHITECTURE_ALPHA64 = 7
%PROCESSOR_ARCHITECTURE_MSIL    = 8

%PROCESSOR_ARCHITECTURE_UNKNOWN = &HFFFF??

%PF_FLOATING_POINT_PRECISION_ERRATA = 0
%PF_FLOATING_POINT_EMULATED         = 1
%PF_COMPARE_EXCHANGE_DOUBLE         = 2
%PF_MMX_INSTRUCTIONS_AVAILABLE      = 3
%PF_PPC_MOVEMEM_64BIT_OK            = 4
%PF_ALPHA_BYTE_INSTRUCTIONS         = 5
%PF_XMMI_INSTRUCTIONS_AVAILABLE     = 6
%PF_3DNOW_INSTRUCTIONS_AVAILABLE    = 7
%PF_RDTSC_INSTRUCTION_AVAILABLE     = 8
%PF_PAE_ENABLED                     = 9

%SECTION_QUERY       = &H0001
%SECTION_MAP_WRITE   = &H0002
%SECTION_MAP_READ    = &H0004
%SECTION_MAP_EXECUTE = &H0008
%SECTION_EXTEND_SIZE = &H0010

%SECTION_ALL_ACCESS  = %STANDARD_RIGHTS_REQUIRED OR %SECTION_QUERY _
                       OR %SECTION_MAP_WRITE _
                       OR %SECTION_MAP_READ _
                       OR %SECTION_MAP_EXECUTE _
                       OR %SECTION_EXTEND_SIZE

%PAGE_NOACCESS          = &H01
%PAGE_READONLY          = &H02
%PAGE_READWRITE         = &H04
%PAGE_WRITECOPY         = &H08
%PAGE_EXECUTE           = &H10
%PAGE_EXECUTE_READ      = &H20
%PAGE_EXECUTE_READWRITE = &H40
%PAGE_EXECUTE_WRITECOPY = &H80
%PAGE_GUARD             = &H100
%PAGE_NOCACHE           = &H200
%PAGE_WRITECOMBINE      = &H400
%MEM_COMMIT             = &H1000
%MEM_RESERVE            = &H2000
%MEM_DECOMMIT           = &H4000
%MEM_RELEASE            = &H8000
%MEM_FREE               = &H10000
%MEM_PRIVATE            = &H20000
%MEM_MAPPED             = &H40000
%MEM_RESET              = &H80000
%MEM_TOP_DOWN           = &H100000
%MEM_WRITE_WATCH        = &H200000
%MEM_PHYSICAL           = &H400000
%SEC_FILE               = &H800000
%SEC_IMAGE              = &H1000000
%SEC_VLM                = &H2000000
%SEC_RESERVE            = &H4000000
%SEC_COMMIT             = &H8000000
%SEC_NOCACHE            = &H10000000
%MEM_IMAGE              = %SEC_IMAGE
%WRITE_WATCH_FLAG_RESET = &H01

'
' Define access rights to files and directories
'

'
' The FILE_READ_DATA and FILE_WRITE_DATA constants are also defined in
' devioctl.h as FILE_READ_ACCESS and FILE_WRITE_ACCESS. The values for these
' constants *MUST* always be in sync.
' The values are redefined in devioctl.h because they must be available to
' both DOS and NT.
'

%FILE_READ_DATA            = &H0001    ' file & pipe
%FILE_LIST_DIRECTORY       = &H0001    ' directory

%FILE_WRITE_DATA           = &H0002    ' file & pipe
%FILE_ADD_FILE             = &H0002    ' directory

%FILE_APPEND_DATA          = &H0004    ' file
%FILE_ADD_SUBDIRECTORY     = &H0004    ' directory
%FILE_CREATE_PIPE_INSTANCE = &H0004    ' named pipe


%FILE_READ_EA              = &H0008    ' file & directory

%FILE_WRITE_EA             = &H0010    ' file & directory

%FILE_EXECUTE              = &H0020    ' file
%FILE_TRAVERSE             = &H0020    ' directory

%FILE_DELETE_CHILD         = &H0040    ' directory

%FILE_READ_ATTRIBUTES      = &H0080    ' all

%FILE_WRITE_ATTRIBUTES     = &H0100    ' all

%FILE_ALL_ACCESS = %STANDARD_RIGHTS_REQUIRED OR %SYNCHRONIZE OR &H1FF

%FILE_GENERIC_READ =   %STANDARD_RIGHTS_READ OR _
                       %FILE_READ_DATA       OR _
                       %FILE_READ_ATTRIBUTES OR _
                       %FILE_READ_EA         OR _
                       %SYNCHRONIZE


%FILE_GENERIC_WRITE =  %STANDARD_RIGHTS_WRITE OR _
                       %FILE_WRITE_DATA       OR _
                       %FILE_WRITE_ATTRIBUTES OR _
                       %FILE_WRITE_EA         OR _
                       %FILE_APPEND_DATA      OR _
                       %SYNCHRONIZE


%FILE_GENERIC_EXECUTE = %STANDARD_RIGHTS_EXECUTE OR _
                        %FILE_READ_ATTRIBUTES    OR _
                        %FILE_EXECUTE            OR _
                        %SYNCHRONIZE

%FILE_SHARE_READ               = &H00000001
%FILE_SHARE_WRITE              = &H00000002
%FILE_SHARE_DELETE             = &H00000004
%FILE_ATTRIBUTE_READONLY            = &H00000001
%FILE_ATTRIBUTE_HIDDEN              = &H00000002
%FILE_ATTRIBUTE_SYSTEM              = &H00000004
%FILE_ATTRIBUTE_DIRECTORY           = &H00000010
%FILE_ATTRIBUTE_ARCHIVE             = &H00000020
%FILE_ATTRIBUTE_DEVICE              = &H00000040
%FILE_ATTRIBUTE_NORMAL              = &H00000080
%FILE_ATTRIBUTE_TEMPORARY           = &H00000100
%FILE_ATTRIBUTE_SPARSE_FILE         = &H00000200
%FILE_ATTRIBUTE_REPARSE_POINT       = &H00000400
%FILE_ATTRIBUTE_COMPRESSED          = &H00000800
%FILE_ATTRIBUTE_OFFLINE             = &H00001000
%FILE_ATTRIBUTE_NOT_CONTENT_INDEXED = &H00002000
%FILE_ATTRIBUTE_ENCRYPTED           = &H00004000
%FILE_NOTIFY_CHANGE_FILE_NAME  = &H00000001
%FILE_NOTIFY_CHANGE_DIR_NAME   = &H00000002
%FILE_NOTIFY_CHANGE_ATTRIBUTES = &H00000004
%FILE_NOTIFY_CHANGE_SIZE       = &H00000008
%FILE_NOTIFY_CHANGE_LAST_WRITE = &H00000010
%FILE_NOTIFY_CHANGE_LAST_ACCESS= &H00000020
%FILE_NOTIFY_CHANGE_CREATION   = &H00000040
%FILE_NOTIFY_CHANGE_SECURITY   = &H00000100
%FILE_ACTION_ADDED                 = &H00000001
%FILE_ACTION_REMOVED               = &H00000002
%FILE_ACTION_MODIFIED              = &H00000003
%FILE_ACTION_RENAMED_OLD_NAME      = &H00000004
%FILE_ACTION_RENAMED_NEW_NAME      = &H00000005
%MAILSLOT_NO_MESSAGE           = &HFFFFFFFF&
%MAILSLOT_WAIT_FOREVER         = &HFFFFFFFF&
%FILE_CASE_SENSITIVE_SEARCH    = &H00000001
%FILE_CASE_PRESERVED_NAMES     = &H00000002
%FILE_UNICODE_ON_DISK          = &H00000004
%FILE_PERSISTENT_ACLS          = &H00000008
%FILE_FILE_COMPRESSION         = &H00000010
%FILE_VOLUME_QUOTAS            = &H00000020
%FILE_SUPPORTS_SPARSE_FILES    = &H00000040
%FILE_SUPPORTS_REPARSE_POINTS  = &H00000080
%FILE_SUPPORTS_REMOTE_STORAGE  = &H00000100
%FILE_VOLUME_IS_COMPRESSED     = &H00008000
%FILE_SUPPORTS_OBJECT_IDS      = &H00010000
%FILE_SUPPORTS_ENCRYPTION      = &H00020000
%FILE_NAMED_STREAMS            = &H00040000

' The below may vary according to the alignment of REPARSE_GUID_DATA_BUFFER.
%REPARSE_GUID_DATA_BUFFER_HEADER_SIZE = 24

'
' Maximum allowed size of the reparse data.
'

%MAXIMUM_REPARSE_DATA_BUFFER_SIZE = 16 * 1024

'
' Predefined reparse tags.
' These tags need to avoid conflicting with IO_REMOUNT defined in ntos\inc\io.h
'

%IO_REPARSE_TAG_RESERVED_ZERO = 0
%IO_REPARSE_TAG_RESERVED_ONE  = 1

'
' The value of the following constant needs to satisfy the following conditions:
'  (1) Be at least as large as the largest of the reserved tags.
'  (2) Be strictly smaller than all the tags in use.
'

%IO_REPARSE_TAG_RESERVED_RANGE = %IO_REPARSE_TAG_RESERVED_ONE

%IO_REPARSE_TAG_MOUNT_POINT = &HA0000003
%IO_REPARSE_TAG_HSM         = &HC0000004
%IO_REPARSE_TAG_SIS         = &H80000007
%IO_COMPLETION_MODIFY_STATE = &H0002
%IO_COMPLETION_ALL_ACCESS   = %STANDARD_RIGHTS_REQUIRED OR %SYNCHRONIZE OR &H3
%DUPLICATE_CLOSE_SOURCE     = &H00000001
%DUPLICATE_SAME_ACCESS      = &H00000002

%ES_SYSTEM_REQUIRED  = &H00000001
%ES_DISPLAY_REQUIRED = &H00000002
%ES_USER_PRESENT     = &H00000004
%ES_CONTINUOUS       = &H80000000&

%LT_DONT_CARE      = 0
%LT_LOWEST_LATENCY = 1

%IMAGE_DOS_SIGNATURE    = &H5A4D      ' MZ
%IMAGE_OS2_SIGNATURE    = &H454E      ' NE
%IMAGE_OS2_SIGNATURE_LE = &H454C      ' LE
%IMAGE_VXD_SIGNATURE    = &H454C      ' LE
%IMAGE_NT_SIGNATURE     = &H00004550  ' PE00

%IMAGE_SIZEOF_FILE_HEADER = 20

%IMAGE_FILE_RELOCS_STRIPPED         = &H0001  ' Relocation info stripped from file.
%IMAGE_FILE_EXECUTABLE_IMAGE        = &H0002  ' File is executable  (i.e. no unresolved externel references).
%IMAGE_FILE_LINE_NUMS_STRIPPED      = &H0004  ' Line nunbers stripped from file.
%IMAGE_FILE_LOCAL_SYMS_STRIPPED     = &H0008  ' Local symbols stripped from file.
%IMAGE_FILE_AGGRESIVE_WS_TRIM       = &H0010  ' Agressively trim working set
%IMAGE_FILE_LARGE_ADDRESS_AWARE     = &H0020  ' App can handle >2gb addresses
%IMAGE_FILE_BYTES_REVERSED_LO       = &H0080  ' Bytes of machine word are reversed.
%IMAGE_FILE_32BIT_MACHINE           = &H0100  ' 32 bit word machine.
%IMAGE_FILE_DEBUG_STRIPPED          = &H0200  ' Debugging info stripped from file in .DBG file
%IMAGE_FILE_REMOVABLE_RUN_FROM_SWAP = &H0400  ' If Image is on removable media, copy and run from the swap file.
%IMAGE_FILE_NET_RUN_FROM_SWAP       = &H0800  ' If Image is on Net, copy and run from the swap file.
%IMAGE_FILE_SYSTEM                  = &H1000  ' System File.
%IMAGE_FILE_DLL                     = &H2000  ' File is a DLL.
%IMAGE_FILE_UP_SYSTEM_ONLY          = &H4000  ' File should only be run on a UP machine
%IMAGE_FILE_BYTES_REVERSED_HI       = &H8000  ' Bytes of machine word are reversed.

%IMAGE_FILE_MACHINE_UNKNOWN         = 0
%IMAGE_FILE_MACHINE_I386            = &H014c  ' Intel 386.
%IMAGE_FILE_MACHINE_R3000           = &H0162  ' MIPS little-endian, = &H160 big-endian
%IMAGE_FILE_MACHINE_R4000           = &H0166  ' MIPS little-endian
%IMAGE_FILE_MACHINE_R10000          = &H0168  ' MIPS little-endian
%IMAGE_FILE_MACHINE_WCEMIPSV2       = &H0169  ' MIPS little-endian WCE v2
%IMAGE_FILE_MACHINE_ALPHA           = &H0184  ' Alpha_AXP
%IMAGE_FILE_MACHINE_POWERPC         = &H01F0  ' IBM PowerPC Little-Endian
%IMAGE_FILE_MACHINE_SH3             = &H01a2  ' SH3 little-endian
%IMAGE_FILE_MACHINE_SH3E            = &H01a4  ' SH3E little-endian
%IMAGE_FILE_MACHINE_SH4             = &H01a6  ' SH4 little-endian
%IMAGE_FILE_MACHINE_ARM             = &H01c0  ' ARM Little-Endian
%IMAGE_FILE_MACHINE_THUMB           = &H01c2
%IMAGE_FILE_MACHINE_IA64            = &H0200  ' Intel 64
%IMAGE_FILE_MACHINE_MIPS16          = &H0266  ' MIPS
%IMAGE_FILE_MACHINE_MIPSFPU         = &H0366  ' MIPS
%IMAGE_FILE_MACHINE_MIPSFPU16       = &H0466  ' MIPS
%IMAGE_FILE_MACHINE_ALPHA64         = &H0284  ' ALPHA64
%IMAGE_FILE_MACHINE_AXP64           = %IMAGE_FILE_MACHINE_ALPHA64

%IMAGE_SIZEOF_ROM_OPTIONAL_HEADER  =  56
%IMAGE_SIZEOF_STD_OPTIONAL_HEADER  =  28
%IMAGE_SIZEOF_NT_OPTIONAL32_HEADER = 224
%IMAGE_SIZEOF_NT_OPTIONAL64_HEADER = 240

%IMAGE_NT_OPTIONAL_HDR32_MAGIC     = &H10b
%IMAGE_NT_OPTIONAL_HDR64_MAGIC     = &H20b
%IMAGE_ROM_OPTIONAL_HDR_MAGIC      = &H107

%IMAGE_SUBSYSTEM_UNKNOWN           =  0   ' Unknown subsystem.
%IMAGE_SUBSYSTEM_NATIVE            =  1   ' Image doesn't require a subsystem.
%IMAGE_SUBSYSTEM_WINDOWS_GUI       =  2   ' Image runs in the Windows GUI subsystem.
%IMAGE_SUBSYSTEM_WINDOWS_CUI       =  3   ' Image runs in the Windows character subsystem.
%IMAGE_SUBSYSTEM_OS2_CUI           =  5   ' image runs in the OS/2 character subsystem.
%IMAGE_SUBSYSTEM_POSIX_CUI         =  7   ' image runs in the Posix character subsystem.
%IMAGE_SUBSYSTEM_NATIVE_WINDOWS    =  8   ' image is a native Win9x driver.
%IMAGE_SUBSYSTEM_WINDOWS_CE_GUI    =  9   ' Image runs in the Windows CE subsystem.
%IMAGE_SUBSYSTEM_EFI_APPLICATION   = 10   '
%IMAGE_SUBSYSTEM_EFI_BOOT_SERVICE_DRIVER = 11
%IMAGE_SUBSYSTEM_EFI_RUNTIME_DRIVER = 12

' DllCharacteristics Entries

'     %IMAGE_LIBRARY_PROCESS_INIT         = &H0001     ' Reserved.
'     %IMAGE_LIBRARY_PROCESS_TERM         = &H0002     ' Reserved.
'     %IMAGE_LIBRARY_THREAD_INIT          = &H0004     ' Reserved.
'     %IMAGE_LIBRARY_THREAD_TERM          = &H0008     ' Reserved.
%IMAGE_DLLCHARACTERISTICS_NO_BIND    = &H0800     ' Do not bind this image.
'                                           &H1000     ' Reserved.
%IMAGE_DLLCHARACTERISTICS_WDM_DRIVER = &H2000     ' Driver uses WDM model
'                                           &H4000     ' Reserved.
%IMAGE_DLLCHARACTERISTICS_TERMINAL_SERVER_AWARE = &H8000

%IMAGE_SIZEOF_SHORT_NAME = 8

%IMAGE_SIZEOF_SECTION_HEADER = 40

'
' Section characteristics.
'
'      IMAGE_SCN_TYPE_REG                  = &H00000000  ' Reserved.
'      IMAGE_SCN_TYPE_DSECT                = &H00000001  ' Reserved.
'      IMAGE_SCN_TYPE_NOLOAD               = &H00000002  ' Reserved.
'      IMAGE_SCN_TYPE_GROUP                = &H00000004  ' Reserved.
%IMAGE_SCN_TYPE_NO_PAD               = &H00000008  ' Reserved.
'      IMAGE_SCN_TYPE_COPY                 = &H00000010  ' Reserved.

%IMAGE_SCN_CNT_CODE                  = &H00000020  ' Section contains code.
%IMAGE_SCN_CNT_INITIALIZED_DATA      = &H00000040  ' Section contains initialized data.
%IMAGE_SCN_CNT_UNINITIALIZED_DATA    = &H00000080  ' Section contains uninitialized data.

%IMAGE_SCN_LNK_OTHER                 = &H00000100  ' Reserved.
%IMAGE_SCN_LNK_INFO                  = &H00000200  ' Section contains comments or some other type of information.
'      IMAGE_SCN_TYPE_OVER                 = &H00000400  ' Reserved.
%IMAGE_SCN_LNK_REMOVE                = &H00000800  ' Section contents will not become part of image.
%IMAGE_SCN_LNK_COMDAT                = &H00001000  ' Section contents comdat.
'                                          = &H00002000  ' Reserved.
'      IMAGE_SCN_MEM_PROTECTED - Obsolete  = &H00004000
%IMAGE_SCN_NO_DEFER_SPEC_EXC         = &H00004000  ' Reset speculative exceptions handling bits in the TLB entries for this section.
%IMAGE_SCN_GPREL                     = &H00008000  ' Section content can be accessed relative to GP
%IMAGE_SCN_MEM_FARDATA               = &H00008000
'      IMAGE_SCN_MEM_SYSHEAP  - Obsolete   = &H00010000
%IMAGE_SCN_MEM_PURGEABLE             = &H00020000
%IMAGE_SCN_MEM_16BIT                 = &H00020000
%IMAGE_SCN_MEM_LOCKED                = &H00040000
%IMAGE_SCN_MEM_PRELOAD               = &H00080000

%IMAGE_SCN_ALIGN_1BYTES              = &H00100000  '
%IMAGE_SCN_ALIGN_2BYTES              = &H00200000  '
%IMAGE_SCN_ALIGN_4BYTES              = &H00300000  '
%IMAGE_SCN_ALIGN_8BYTES              = &H00400000  '
%IMAGE_SCN_ALIGN_16BYTES             = &H00500000  ' Default alignment if no others are specified.
%IMAGE_SCN_ALIGN_32BYTES             = &H00600000  '
%IMAGE_SCN_ALIGN_64BYTES             = &H00700000  '
%IMAGE_SCN_ALIGN_128BYTES            = &H00800000  '
%IMAGE_SCN_ALIGN_256BYTES            = &H00900000  '
%IMAGE_SCN_ALIGN_512BYTES            = &H00A00000  '
%IMAGE_SCN_ALIGN_1024BYTES           = &H00B00000  '
%IMAGE_SCN_ALIGN_2048BYTES           = &H00C00000  '
%IMAGE_SCN_ALIGN_4096BYTES           = &H00D00000  '
%IMAGE_SCN_ALIGN_8192BYTES           = &H00E00000  '
' Unused                                   = &H00F00000
%IMAGE_SCN_ALIGN_MASK                = &H00F00000

%IMAGE_SCN_LNK_NRELOC_OVFL           = &H01000000  ' Section contains extended relocations.
%IMAGE_SCN_MEM_DISCARDABLE           = &H02000000  ' Section can be discarded.
%IMAGE_SCN_MEM_NOT_CACHED            = &H04000000  ' Section is not cachable.
%IMAGE_SCN_MEM_NOT_PAGED             = &H08000000  ' Section is not pageable.
%IMAGE_SCN_MEM_SHARED                = &H10000000  ' Section is shareable.
%IMAGE_SCN_MEM_EXECUTE               = &H20000000  ' Section is executable.
%IMAGE_SCN_MEM_READ                  = &H40000000  ' Section is readable.
%IMAGE_SCN_MEM_WRITE                 = &H80000000  ' Section is writeable.

'
' TLS Characteristic Flags
'
%IMAGE_SCN_SCALE_INDEX               = &H00000001  ' Tls index is scaled

%IMAGE_SIZEOF_SYMBOL = 18

'
' Section values.
'
' Symbols have a section number of the section in which they are
' defined. Otherwise, section numbers have the following meanings:
'

%IMAGE_SYM_UNDEFINED = 0%    ' Symbol is undefined or is common.
%IMAGE_SYM_ABSOLUTE  = -1%   ' Symbol is an absolute value.
%IMAGE_SYM_DEBUG     = -2%   ' Symbol is a special debug item.

'
' Type (fundamental) values.
'

%IMAGE_SYM_TYPE_NULL   = &H0000  ' no type.
%IMAGE_SYM_TYPE_VOID   = &H0001  '
%IMAGE_SYM_TYPE_CHAR   = &H0002  ' type character.
%IMAGE_SYM_TYPE_SHORT  = &H0003  ' type short integer.
%IMAGE_SYM_TYPE_INT    = &H0004  '
%IMAGE_SYM_TYPE_LONG   = &H0005  '
%IMAGE_SYM_TYPE_FLOAT  = &H0006  '
%IMAGE_SYM_TYPE_DOUBLE = &H0007  '
%IMAGE_SYM_TYPE_STRUCT = &H0008  '
%IMAGE_SYM_TYPE_UNION  = &H0009  '
%IMAGE_SYM_TYPE_ENUM   = &H000A  ' enumeration.
%IMAGE_SYM_TYPE_MOE    = &H000B  ' member of enumeration.
%IMAGE_SYM_TYPE_BYTE   = &H000C  '
%IMAGE_SYM_TYPE_WORD   = &H000D  '
%IMAGE_SYM_TYPE_UINT   = &H000E  '
%IMAGE_SYM_TYPE_DWORD  = &H000F  '
%IMAGE_SYM_TYPE_PCODE  = &H8000  '
'
' Type (derived) values.
'

%IMAGE_SYM_DTYPE_NULL     = 0       ' no derived type.
%IMAGE_SYM_DTYPE_POINTER  = 1       ' pointer.
%IMAGE_SYM_DTYPE_FUNCTION = 2       ' function.
%IMAGE_SYM_DTYPE_ARRAY    = 3       ' array.

'
' Storage classes.
'
%IMAGE_SYM_CLASS_END_OF_FUNCTION  = &HFF?
%IMAGE_SYM_CLASS_NULL             = &H0000
%IMAGE_SYM_CLASS_AUTOMATIC        = &H0001
%IMAGE_SYM_CLASS_EXTERNAL         = &H0002
%IMAGE_SYM_CLASS_STATIC           = &H0003
%IMAGE_SYM_CLASS_REGISTER         = &H0004
%IMAGE_SYM_CLASS_EXTERNAL_DEF     = &H0005
%IMAGE_SYM_CLASS_LABEL            = &H0006
%IMAGE_SYM_CLASS_UNDEFINED_LABEL  = &H0007
%IMAGE_SYM_CLASS_MEMBER_OF_STRUCT = &H0008
%IMAGE_SYM_CLASS_ARGUMENT         = &H0009
%IMAGE_SYM_CLASS_STRUCT_TAG       = &H000A
%IMAGE_SYM_CLASS_MEMBER_OF_UNION  = &H000B
%IMAGE_SYM_CLASS_UNION_TAG        = &H000C
%IMAGE_SYM_CLASS_TYPE_DEFINITION  = &H000D
%IMAGE_SYM_CLASS_UNDEFINED_STATIC = &H000E
%IMAGE_SYM_CLASS_ENUM_TAG         = &H000F
%IMAGE_SYM_CLASS_MEMBER_OF_ENUM   = &H0010
%IMAGE_SYM_CLASS_REGISTER_PARAM   = &H0011
%IMAGE_SYM_CLASS_BIT_FIELD        = &H0012

%IMAGE_SYM_CLASS_FAR_EXTERNAL     = &H0044  '

%IMAGE_SYM_CLASS_BLOCK            = &H0064
%IMAGE_SYM_CLASS_FUNCTION         = &H0065
%IMAGE_SYM_CLASS_END_OF_STRUCT    = &H0066
%IMAGE_SYM_CLASS_FILE             = &H0067
' new
%IMAGE_SYM_CLASS_SECTION          = &H0068
%IMAGE_SYM_CLASS_WEAK_EXTERNAL    = &H0069

' type packing constants

%N_BTMASK = &H000F
%N_TMASK  = &H0030
%N_TMASK1 = &H00C0
%N_TMASK2 = &H00F0
%N_BTSHFT = 4
%N_TSHIFT = 2

%IMAGE_SIZEOF_AUX_SYMBOL           = 18

'
' Communal selection types.
'

%IMAGE_COMDAT_SELECT_NODUPLICATES  = 1
%IMAGE_COMDAT_SELECT_ANY           = 2
%IMAGE_COMDAT_SELECT_SAME_SIZE     = 3
%IMAGE_COMDAT_SELECT_EXACT_MATCH   = 4
%IMAGE_COMDAT_SELECT_ASSOCIATIVE   = 5
%IMAGE_COMDAT_SELECT_LARGEST       = 6
%IMAGE_COMDAT_SELECT_NEWEST        = 7

%IMAGE_WEAK_EXTERN_SEARCH_NOLIBRARY = 1
%IMAGE_WEAK_EXTERN_SEARCH_LIBRARY   = 2
%IMAGE_WEAK_EXTERN_SEARCH_ALIAS     = 3

%IMAGE_SIZEOF_RELOCATION = 10

'
' I386 relocation types.
'
%IMAGE_REL_I386_ABSOLUTE = &H0000  ' Reference is absolute, no relocation is necessary
%IMAGE_REL_I386_DIR16    = &H0001  ' Direct 16-bit reference to the symbols virtual address
%IMAGE_REL_I386_REL16    = &H0002  ' PC-relative 16-bit reference to the symbols virtual address
%IMAGE_REL_I386_DIR32    = &H0006  ' Direct 32-bit reference to the symbols virtual address
%IMAGE_REL_I386_DIR32NB  = &H0007  ' Direct 32-bit reference to the symbols virtual address, base not included
%IMAGE_REL_I386_SEG12    = &H0009  ' Direct 16-bit reference to the segment-selector bits of a 32-bit virtual address
%IMAGE_REL_I386_SECTION  = &H000A
%IMAGE_REL_I386_SECREL   = &H000B
%IMAGE_REL_I386_REL32    = &H0014  ' PC-relative 32-bit reference to the symbols virtual address

'
' MIPS relocation types.
'

%IMAGE_REL_MIPS_ABSOLUTE  = &H0000  ' Reference is absolute, no relocation is necessary
%IMAGE_REL_MIPS_REFHALF   = &H0001
%IMAGE_REL_MIPS_REFWORD   = &H0002
%IMAGE_REL_MIPS_JMPADDR   = &H0003
%IMAGE_REL_MIPS_REFHI     = &H0004
%IMAGE_REL_MIPS_REFLO     = &H0005
%IMAGE_REL_MIPS_GPREL     = &H0006
%IMAGE_REL_MIPS_LITERAL   = &H0007
%IMAGE_REL_MIPS_SECTION   = &H000A
%IMAGE_REL_MIPS_SECREL    = &H000B
%IMAGE_REL_MIPS_SECRELLO  = &H000C  ' Low 16-bit section relative referemce (used for >32k TLS)
%IMAGE_REL_MIPS_SECRELHI  = &H000D  ' High 16-bit section relative reference (used for >32k TLS)
%IMAGE_REL_MIPS_JMPADDR16 = &H0010
%IMAGE_REL_MIPS_REFWORDNB = &H0022
%IMAGE_REL_MIPS_PAIR      = &H0025

'
' Alpha Relocation types.
'

%IMAGE_REL_ALPHA_ABSOLUTE       = &H0000
%IMAGE_REL_ALPHA_REFLONG        = &H0001
%IMAGE_REL_ALPHA_REFQUAD        = &H0002
%IMAGE_REL_ALPHA_GPREL32        = &H0003
%IMAGE_REL_ALPHA_LITERAL        = &H0004
%IMAGE_REL_ALPHA_LITUSE         = &H0005
%IMAGE_REL_ALPHA_GPDISP         = &H0006
%IMAGE_REL_ALPHA_BRADDR         = &H0007
%IMAGE_REL_ALPHA_HINT           = &H0008
%IMAGE_REL_ALPHA_INLINE_REFLONG = &H0009
%IMAGE_REL_ALPHA_REFHI          = &H000A
%IMAGE_REL_ALPHA_REFLO          = &H000B
%IMAGE_REL_ALPHA_PAIR           = &H000C
%IMAGE_REL_ALPHA_MATCH          = &H000D
%IMAGE_REL_ALPHA_SECTION        = &H000E
%IMAGE_REL_ALPHA_SECREL         = &H000F
%IMAGE_REL_ALPHA_REFLONGNB      = &H0010
%IMAGE_REL_ALPHA_SECRELLO       = &H0011  ' Low 16-bit section relative reference
%IMAGE_REL_ALPHA_SECRELHI       = &H0012  ' High 16-bit section relative reference
%IMAGE_REL_ALPHA_REFQ3          = &H0013  ' High 16 bits of 48 bit reference
%IMAGE_REL_ALPHA_REFQ2          = &H0014  ' Middle 16 bits of 48 bit reference
%IMAGE_REL_ALPHA_REFQ1          = &H0015  ' Low 16 bits of 48 bit reference
%IMAGE_REL_ALPHA_GPRELLO        = &H0016  ' Low 16-bit GP relative reference
%IMAGE_REL_ALPHA_GPRELHI        = &H0017  ' High 16-bit GP relative reference


'
' IBM PowerPC relocation types.
'

%IMAGE_REL_PPC_ABSOLUTE = &H0000  ' NOP
%IMAGE_REL_PPC_ADDR64   = &H0001  ' 64-bit address
%IMAGE_REL_PPC_ADDR32   = &H0002  ' 32-bit address
%IMAGE_REL_PPC_ADDR24   = &H0003  ' 26-bit address, shifted left 2 (branch absolute)
%IMAGE_REL_PPC_ADDR16   = &H0004  ' 16-bit address
%IMAGE_REL_PPC_ADDR14   = &H0005  ' 16-bit address, shifted left 2 (load doubleword)
%IMAGE_REL_PPC_REL24    = &H0006  ' 26-bit PC-relative offset, shifted left 2 (branch relative)
%IMAGE_REL_PPC_REL14    = &H0007  ' 16-bit PC-relative offset, shifted left 2 (br cond relative)
%IMAGE_REL_PPC_TOCREL16 = &H0008  ' 16-bit offset from TOC base
%IMAGE_REL_PPC_TOCREL14 = &H0009  ' 16-bit offset from TOC base, shifted left 2 (load doubleword)

%IMAGE_REL_PPC_ADDR32NB = &H000A  ' 32-bit addr w/o image base
%IMAGE_REL_PPC_SECREL   = &H000B  ' va of containing section (as in an image sectionhdr)
%IMAGE_REL_PPC_SECTION  = &H000C  ' sectionheader number
%IMAGE_REL_PPC_IFGLUE   = &H000D  ' substitute TOC restore instruction iff symbol is glue code
%IMAGE_REL_PPC_IMGLUE   = &H000E  ' symbol is glue code; virtual address is TOC restore instruction
%IMAGE_REL_PPC_SECREL16 = &H000F  ' va of containing section (limited to 16 bits)
%IMAGE_REL_PPC_REFHI    = &H0010
%IMAGE_REL_PPC_REFLO    = &H0011
%IMAGE_REL_PPC_PAIR     = &H0012
%IMAGE_REL_PPC_SECRELLO = &H0013  ' Low 16-bit section relative reference (used for >32k TLS)
%IMAGE_REL_PPC_SECRELHI = &H0014  ' High 16-bit section relative reference (used for >32k TLS)
%IMAGE_REL_PPC_GPREL    = &H0015

%IMAGE_REL_PPC_TYPEMASK = &H00FF  ' mask to isolate above values in IMAGE_RELOCATION.Type

' Flag bits in IMAGE_RELOCATION.TYPE

%IMAGE_REL_PPC_NEG      = &H0100  ' subtract reloc value rather than adding it
%IMAGE_REL_PPC_BRTAKEN  = &H0200  ' fix branch prediction bit to predict branch taken
%IMAGE_REL_PPC_BRNTAKEN = &H0400  ' fix branch prediction bit to predict branch not taken
%IMAGE_REL_PPC_TOCDEFN  = &H0800  ' toc slot defined in file (or, data in toc)

'
' Hitachi SH3 relocation types.
'
%IMAGE_REL_SH3_ABSOLUTE        = &H0000  ' No relocation
%IMAGE_REL_SH3_DIRECT16        = &H0001  ' 16 bit direct
%IMAGE_REL_SH3_DIRECT32        = &H0002  ' 32 bit direct
%IMAGE_REL_SH3_DIRECT8         = &H0003  ' 8 bit direct, -128..255
%IMAGE_REL_SH3_DIRECT8_WORD    = &H0004  ' 8 bit direct .W (0 ext.)
%IMAGE_REL_SH3_DIRECT8_LONG    = &H0005  ' 8 bit direct .L (0 ext.)
%IMAGE_REL_SH3_DIRECT4         = &H0006  ' 4 bit direct (0 ext.)
%IMAGE_REL_SH3_DIRECT4_WORD    = &H0007  ' 4 bit direct .W (0 ext.)
%IMAGE_REL_SH3_DIRECT4_LONG    = &H0008  ' 4 bit direct .L (0 ext.)
%IMAGE_REL_SH3_PCREL8_WORD     = &H0009  ' 8 bit PC relative .W
%IMAGE_REL_SH3_PCREL8_LONG     = &H000A  ' 8 bit PC relative .L
%IMAGE_REL_SH3_PCREL12_WORD    = &H000B  ' 12 LSB PC relative .W
%IMAGE_REL_SH3_STARTOF_SECTION = &H000C  ' Start of EXE section
%IMAGE_REL_SH3_SIZEOF_SECTION  = &H000D  ' Size of EXE section
%IMAGE_REL_SH3_SECTION         = &H000E  ' Section table index
%IMAGE_REL_SH3_SECREL          = &H000F  ' Offset within section
%IMAGE_REL_SH3_DIRECT32_NB     = &H0010  ' 32 bit direct not based

%IMAGE_REL_ARM_ABSOLUTE        = &H0000  ' No relocation required
%IMAGE_REL_ARM_ADDR32          = &H0001  ' 32 bit address
%IMAGE_REL_ARM_ADDR32NB        = &H0002  ' 32 bit address w/o image base
%IMAGE_REL_ARM_BRANCH24        = &H0003  ' 24 bit offset << 2 & sign ext.
%IMAGE_REL_ARM_BRANCH11        = &H0004  ' Thumb: 2 11 bit offsets
%IMAGE_REL_ARM_GPREL12         = &H0006  ' GP-relative addressing (ARM)
%IMAGE_REL_ARM_GPREL7          = &H0007  ' GP-relative addressing (Thumb)
%IMAGE_REL_ARM_SECTION         = &H000E  ' Section table index
%IMAGE_REL_ARM_SECREL          = &H000F  ' Offset within section

'
' IA64 relocation types.
'

%IMAGE_REL_IA64_ABSOLUTE  = &H0000
%IMAGE_REL_IA64_IMM14     = &H0001
%IMAGE_REL_IA64_IMM22     = &H0002
%IMAGE_REL_IA64_IMM64     = &H0003
%IMAGE_REL_IA64_DIR32     = &H0004
%IMAGE_REL_IA64_DIR64     = &H0005
%IMAGE_REL_IA64_PCREL21B  = &H0006
%IMAGE_REL_IA64_PCREL21M  = &H0007
%IMAGE_REL_IA64_PCREL21F  = &H0008
%IMAGE_REL_IA64_GPREL22   = &H0009
%IMAGE_REL_IA64_LTOFF22   = &H000A
%IMAGE_REL_IA64_SECTION   = &H000B
%IMAGE_REL_IA64_SECREL22  = &H000C
%IMAGE_REL_IA64_SECREL64I = &H000D
%IMAGE_REL_IA64_SECREL32  = &H000E
%IMAGE_REL_IA64_LTOFF64   = &H000F
%IMAGE_REL_IA64_DIR32NB   = &H0010
%IMAGE_REL_IA64_ADDEND    = &H001F

' End of constants from winnt.h ===============================================



' File attributes
%Normal   = &B000000
%ReadOnly = &B000001
%Hidden   = &B000010
%System   = &B000100
%vLabel   = &B001000
%SubDir   = &B010000
%Archive  = &B100000

'Common RGB Colors
%Black   = &H000000???
%Blue    = &HFF0000???
%Green   = &H00FF00???
%Cyan    = &HFFFF00???
%Red     = &H0000FF???
%Magenta = &HFF00FF???
%Yellow  = &H00FFFF???
%White   = &HFFFFFF???
%Gray    = &H808080???
%LtGray  = &HC0C0C0???

%INVALID_HANDLE_VALUE = &HFFFFFFFF???

%SV_HIDDEN  = 1
%SV_VISIBLE = 0

%SERVICE_WIN32_OWN_PROCESS   = &H00000010
%SERVICE_WIN32_SHARE_PROCESS = &H00000020
%SERVICE_WIN32               = (%SERVICE_WIN32_OWN_PROCESS OR %SERVICE_WIN32_SHARE_PROCESS)

'start types
%SERVICE_BOOT_START     = &H00000000
%SERVICE_SYSTEM_START   = &H00000001
%SERVICE_AUTO_START     = &H00000002
%SERVICE_DEMAND_START   = &H00000003
%SERVICE_DISABLED       = &H00000004

' Error control type

%SERVICE_ERROR_IGNORE   = &H00000000
%SERVICE_ERROR_NORMAL   = &H00000001
%SERVICE_ERROR_SEVERE   = &H00000002
%SERVICE_ERROR_CRITICAL = &H00000003

%USER_PRIV_GUEST = 0
%USER_PRIV_USER  = 1
%USER_PRIV_ADMIN = 2

' Defines for the READ flags for Eventlogging

%EVENTLOG_SEQUENTIAL_READ = &H0001
%EVENTLOG_SEEK_READ       = &H0002
%EVENTLOG_FORWARDS_READ   = &H0004
%EVENTLOG_BACKWARDS_READ  = &H0008

' The types of events that can be logged.

%EVENTLOG_SUCCESS               = &H0000
%EVENTLOG_ERROR_TYPE            = &H0001
%EVENTLOG_WARNING_TYPE          = &H0002
%EVENTLOG_INFORMATION_TYPE      = &H0004
%EVENTLOG_AUDIT_SUCCESS         = &H0008
%EVENTLOG_AUDIT_FAILURE         = &H0010

' Defines for the WRITE flags used by Auditing for paired events
' These are not implemented in Product 1

%EVENTLOG_START_PAIRED_EVENT    = &H0001
%EVENTLOG_END_PAIRED_EVENT      = &H0002
%EVENTLOG_END_ALL_PAIRED_EVENTS = &H0004
%EVENTLOG_PAIRED_EVENT_ACTIVE   = &H0008
%EVENTLOG_PAIRED_EVENT_INACTIVE = &H0010

%FILE_BEGIN   = 0
%FILE_CURRENT = 1
%FILE_END     = 2

%FILE_FLAG_POSIX_SEMANTICS  = &H01000000
%FILE_FLAG_BACKUP_SEMANTICS = &H02000000
%FILE_FLAG_DELETE_ON_CLOSE  = &H04000000
%FILE_FLAG_SEQUENTIAL_SCAN  = &H08000000
%FILE_FLAG_RANDOM_ACCESS    = &H10000000
%FILE_FLAG_NO_BUFFERING     = &H20000000
%FILE_FLAG_OVERLAPPED       = &H40000000
%FILE_FLAG_WRITE_THROUGH    = &H80000000

%CREATE_NEW        = 1
%CREATE_ALWAYS     = 2
%OPEN_EXISTING     = 3
%OPEN_ALWAYS       = 4
%TRUNCATE_EXISTING = 5

%FIND_FIRST_EX_CASE_SENSITIVE = &H00000001

' Define possible return codes from the CopyFileEx callback routine

%PROGRESS_CONTINUE = 0
%PROGRESS_CANCEL   = 1
%PROGRESS_STOP     = 2
%PROGRESS_QUIET    = 3

' Define CopyFileEx callback routine state change values

%CALLBACK_CHUNK_FINISHED  = &H00000000
%CALLBACK_STREAM_FINISHED = &H00000001

' Define CopyFileEx option flags

%COPY_FILE_FAIL_IF_EXISTS        = &H00000001
%COPY_FILE_RESTARTABLE           = &H00000002
%COPY_FILE_OPEN_SOURCE_FOR_WRITE = &H00000004

%VWIN32_DIOC_DOS_IOCTL     = 1 ' DOS IOCTL commands
%VWIN32_DIOC_DOS_INT25     = 2 ' absolute disk read
%VWIN32_DIOC_DOS_INT26     = 3 ' absolute disk write
%VWIN32_DIOC_DOS_INT13     = 4 ' INT 13
%VWIN32_DIOC_DOS_DRIVEINFO = 6 ' Win95B or later

%FILE_DEVICE_DISK         = &H07
%FILE_DEVICE_FILE_SYSTEM  = &H09
%FILE_DEVICE_BATTERY      = &H29
%FILE_DEVICE_BUS_EXTENDER = &H2A
%FILE_DEVICE_MODEM        = &H2B
%FILE_DEVICE_VDM          = &H2C
%FILE_DEVICE_MASS_STORAGE = &H2D

%METHOD_BUFFERED   = 0
%METHOD_IN_DIRECT  = 1
%METHOD_OUT_DIRECT = 2
%METHOD_NEITHER    = 3

%IOCTL_DISK_BASE               = %FILE_DEVICE_DISK
%IOCTL_DISK_GET_DRIVE_GEOMETRY = &H00070000
%IOCTL_DISK_VERIFY             = &H00070014
%IOCTL_DISK_IS_WRITABLE        = &H00070024
%IOCTL_DISK_GET_MEDIA_TYPES    = &H00070C00
%IOCTL_DISK_GET_PARTITION_INFO = &H00074004
%IOCTL_DISK_SET_PARTITION_INFO = &H0007C008
%IOCTL_DISK_FORMAT_TRACKS      = &H0007C018
%IOCTL_DISK_FORMAT_TRACKS_EX   = &H0007C02C

%IOCTL_STORAGE_BASE               = %FILE_DEVICE_MASS_STORAGE
%IOCTL_STORAGE_GET_MEDIA_TYPES    = &H002D0C00
%IOCTL_STORAGE_GET_MEDIA_TYPES_EX = &H002D0C04
%IOCTL_STORAGE_CHECK_VERIFY       = &H002D4800
%IOCTL_STORAGE_MEDIA_REMOVAL      = &H002D4801
%IOCTL_STORAGE_EJECT_MEDIA        = &H002D4808
%IOCTL_STORAGE_LOAD_MEDIA         = &H002D480C
%IOCTL_STORAGE_RESERVE            = &H002D4810
%IOCTL_STORAGE_RELEASE            = &H002D4814
%IOCTL_STORAGE_FIND_NEW_DEVICES   = &H002D4818
%IOCTL_STORAGE_RESET_BUS          = &H002D5000
%IOCTL_STORAGE_RESET_DEVICE       = &H002D5004

%FSCTL_LOCK_VOLUME               = &H00090018
%FSCTL_UNLOCK_VOLUME             = &H0009001C
%FSCTL_DISMOUNT_VOLUME           = &H00090020

%FSCTL_REQUEST_OPLOCK_LEVEL_1    = &H00090000
%FSCTL_OPBATCH_ACK_CLOSE_PENDING = &H00090000
%FSCTL_ALLOW_EXTENDED_DASD_IO    = &H0009000C
%FSCTL_REQUEST_OPLOCK_LEVEL_2    = &H00094000
%FSCTL_OPLOCK_BREAK_NOTIFY       = &H00094000
%FSCTL_READ_PROPERTY_DATA        = &H0009400C
%FSCTL_DUMP_PROPERTY_DATA        = &H0009400C
%FSCTL_REQUEST_BATCH_OPLOCK      = &H00098000
%FSCTL_SET_OBJECT_ID             = &H00098002
%FSCTL_WRITE_PROPERTY_DATA       = &H0009800C
%FSCTL_OPLOCK_BREAK_ACKNOWLEDGE  = &H0009C000
%FSCTL_GET_OBJECT_ID             = &H0009C000
%FSCTL_FIND_FILES_BY_SID         = &H0009C00C
%FSCTL_MARK_VOLUME_DIRTY         = &H000B0000
%FSCTL_DELETE_OBJECT_ID          = &H000B0002
%FSCTL_ENUM_USN_DATA             = &H000B000D
%FSCTL_SET_REPARSE_POINT         = &H000B4002
%FSCTL_SECURITY_ID_CHECK         = &H000B400D
%FSCTL_IS_VOLUME_MOUNTED         = &H000B8000
%FSCTL_GET_REPARSE_POINT         = &H000B8000
%FSCTL_QUERY_RETRIEVAL_POINTERS  = &H000B800C
%FSCTL_READ_USN_JOURNAL          = &H000B800D
%FSCTL_IS_PATHNAME_VALID         = &H000BC000
%FSCTL_GET_COMPRESSION           = &H000BC000
%FSCTL_DELETE_REPARSE_POINT      = &H000BC002
%FSCTL_SET_OBJECT_ID_EXTENDED    = &H000BC002
%FSCTL_OPLOCK_BREAK_ACK_NO_2     = &H000D0000
%FSCTL_CREATE_OR_GET_OBJECT_ID   = &H000D0000
%FSCTL_ENABLE_UPGRADE            = &H000D0002
%FSCTL_SET_COMPRESSION           = &H000D0003
%FSCTL_INVALIDATE_VOLUMES        = &H000D4000
%FSCTL_SET_ENCRYPTION            = &H000D4000
%FSCTL_SET_SPARSE                = &H000D4002
%FSCTL_QUERY_FAT_BPB             = &H000D8000
%FSCTL_SET_ZERO_DATA             = &H000D8002
%FSCTL_ENCRYPTION_FSCTL_IO       = &H000D800C
%FSCTL_REQUEST_FILTER_OPLOCK     = &H000DC000
%FSCTL_MARK_AS_SYSTEM_HIVE       = &H000DC00C
%FSCTL_WRITE_RAW_ENCRYPTED       = &H000DC00C
%FSCTL_QUERY_ALLOCATED_RANGES    = &H000DC00D
%FSCTL_FILESYSTEM_GET_STATISTICS = &H000F0000
%FSCTL_EXTEND_VOLUME             = &H000F0000
%FSCTL_GET_RETRIEVAL_POINTERS    = &H000F000C
%FSCTL_READ_RAW_ENCRYPTED        = &H000F000C
%FSCTL_GET_NTFS_VOLUME_DATA      = &H000F4000
%FSCTL_MOVE_FILE                 = &H000F4000
%FSCTL_CREATE_USN_JOURNAL        = &H000F400D
%FSCTL_GET_NTFS_FILE_RECORD      = &H000F8000
%FSCTL_IS_VOLUME_DIRTY           = &H000F8000
%FSCTL_READ_FILE_USN_DATA        = &H000F800D
%FSCTL_GET_HFS_INFORMATION       = &H000FC000
%FSCTL_GET_VOLUME_BITMAP         = &H000FC00C
%FSCTL_WRITE_USN_CLOSE_RECORD    = &H000FC00D

%FILE_ANY_ACCESS   = 0%
%FILE_READ_ACCESS  = 1%
%FILE_WRITE_ACCESS = 2%

%PIPE_ACCESS_INBOUND  = &H1
%PIPE_ACCESS_OUTBOUND = &H2
%PIPE_ACCESS_DUPLEX   = &H3

%PIPE_CLIENT_END      = &H0
%PIPE_SERVER_END      = &H1

%PIPE_WAIT             = &H0
%PIPE_NOWAIT           = &H1
%PIPE_READMODE_BYTE    = &H0
%PIPE_READMODE_MESSAGE = &H2
%PIPE_TYPE_BYTE        = &H0
%PIPE_TYPE_MESSAGE     = &H4

%PIPE_UNLIMITED_INSTANCES = 255

%SECURITY_CONTEXT_TRACKING = &H40000
%SECURITY_EFFECTIVE_ONLY   = &H80000

%SECURITY_SQOS_PRESENT     = &H100000
%SECURITY_VALID_SQOS_FLAGS = &H1F0000

%SP_SERIALCOMM = &H1&

%PST_UNSPECIFIED    = &H0&
%PST_RS232          = &H1&
%PST_PARALLELPORT   = &H2&
%PST_RS422          = &H3&
%PST_RS423          = &H4&
%PST_RS449          = &H5&
%PST_FAX            = &H21&
%PST_SCANNER        = &H22&
%PST_NETWORK_BRIDGE = &H100&
%PST_LAT            = &H101&
%PST_TCPIP_TELNET   = &H102&
%PST_X25            = &H103&

%PCF_DTRDSR        = &H1&
%PCF_RTSCTS        = &H2&
%PCF_RLSD          = &H4&
%PCF_PARITY_CHECK  = &H8&
%PCF_XONXOFF       = &H10&
%PCF_SETXCHAR      = &H20&
%PCF_TOTALTIMEOUTS = &H40&
%PCF_INTTIMEOUTS   = &H80&
%PCF_SPECIALCHARS  = &H100&
%PCF_16BITMODE     = &H200&

%DLL_PROCESS_DETACH = 0
%DLL_PROCESS_ATTACH = 1
%DLL_THREAD_ATTACH  = 2
%DLL_THREAD_DETACH  = 3

%SP_PARITY       = &H1&
%SP_BAUD         = &H2&
%SP_DATABITS     = &H4&
%SP_STOPBITS     = &H8&
%SP_HANDSHAKING  = &H10&
%SP_PARITY_CHECK = &H20&
%SP_RLSD         = &H40&

%BAUD_075    = &H1&
%BAUD_110    = &H2&
%BAUD_134_5  = &H4&
%BAUD_150    = &H8&
%BAUD_300    = &H10&
%BAUD_600    = &H20&
%BAUD_1200   = &H40&
%BAUD_1800   = &H80&
%BAUD_2400   = &H100&
%BAUD_4800   = &H200&
%BAUD_7200   = &H400&
%BAUD_9600   = &H800&
%BAUD_14400  = &H1000&
%BAUD_19200  = &H2000&
%BAUD_38400  = &H4000&
%BAUD_56K    = &H8000&
%BAUD_128K   = &H10000
%BAUD_115200 = &H20000
%BAUD_57600  = &H40000
%BAUD_USER   = &H10000000

%DATABITS_5   = &H1&
%DATABITS_6   = &H2&
%DATABITS_7   = &H4&
%DATABITS_8   = &H8&
%DATABITS_16  = &H10&
%DATABITS_16X = &H20&

%STOPBITS_10  = &H1&
%STOPBITS_15  = &H2&
%STOPBITS_20  = &H4&
%PARITY_NONE  = &H100&
%PARITY_ODD   = &H200&
%PARITY_EVEN  = &H400&
%PARITY_MARK  = &H800&
%PARITY_SPACE = &H1000&

%DTR_CONTROL_DISABLE   = &H0
%DTR_CONTROL_ENABLE    = &H1
%DTR_CONTROL_HANDSHAKE = &H2

%RTS_CONTROL_DISABLE   = &H0
%RTS_CONTROL_ENABLE    = &H1
%RTS_CONTROL_HANDSHAKE = &H2
%RTS_CONTROL_TOGGLE    = &H3

' --- Values for SHFormatDrive, as semi-documented by Microsoft.
' --- See MSDN/Knowledgebase ID: Q173688
'
' Special value of fmtID which means "use the default format"
'
%SHFMT_ID_DEFAULT  = &HFFFF
'
' Option bits for options parameter
'
%SHFMT_OPT_FULL    = &H0001
%SHFMT_OPT_SYSONLY = &H0002
'
' Special return values. PLEASE NOTE that these are DWORD values.
'
%SHFMT_NOFORMAT = &HFFFFFFFD??? ' error on last format, disk may be formattable
%SHFMT_CANCEL   = &HFFFFFFFE??? ' last format was canceled
%SHFMT_ERROR    = &HFFFFFFFF??? ' drive is not formattable

%GMEM_FIXED          = &H0
%GMEM_MOVEABLE       = &H2
%GMEM_NOCOMPACT      = &H10
%GMEM_NODISCARD      = &H20
%GMEM_ZEROINIT       = &H40
%GMEM_MODIFY         = &H80
%GMEM_DISCARDABLE    = &H100
%GMEM_NOT_BANKED     = &H1000
%GMEM_SHARE          = &H2000
%GMEM_DDESHARE       = &H2000
%GMEM_NOTIFY         = &H4000
%GMEM_LOWER          = %GMEM_NOT_BANKED
%GMEM_VALID_FLAGS    = &H7F72
%GMEM_INVALID_HANDLE = &H8000

%MIIM_STATE      = &H00000001
%MIIM_ID         = &H00000002
%MIIM_SUBMENU    = &H00000004
%MIIM_CHECKMARKS = &H00000008
%MIIM_TYPE       = &H00000010
%MIIM_DATA       = &H00000020
%MIIM_STRING     = &H00000040
%MIIM_BITMAP     = &H00000080
%MIIM_FTYPE      = &H00000100

%GMEM_DISCARDED = &H4000
%GMEM_LOCKCOUNT = &HFF

%GHND = %GMEM_MOVEABLE OR %GMEM_ZEROINIT
%GPTR = %GMEM_FIXED OR %GMEM_ZEROINIT

%LMEM_FIXED          = &H0
%LMEM_MOVEABLE       = &H2
%LMEM_NOCOMPACT      = &H10
%LMEM_NODISCARD      = &H20
%LMEM_ZEROINIT       = &H40
%LMEM_MODIFY         = &H80
%LMEM_DISCARDABLE    = &HF00
%LMEM_VALID_FLAGS    = &HF72
%LMEM_INVALID_HANDLE = &H8000

%LHND = %LMEM_MOVEABLE + %LMEM_ZEROINIT
%LPTR = %LMEM_FIXED + %LMEM_ZEROINIT

%NONZEROLHND  = %LMEM_MOVEABLE
%NONZEROLPTR  = %LMEM_FIXED

%LMEM_DISCARDED      = &H4000
%LMEM_LOCKCOUNT      = &H00FF

%HEAP_NO_SERIALIZE        = 1
%HEAP_GROWABLE            = 2
%HEAP_GENERATE_EXCEPTIONS = 4
%HEAP_ZERO_MEMORY         = 8

%DEBUG_PROCESS           = 1
%DEBUG_ONLY_THIS_PROCESS = 2

%CREATE_SUSPENDED   = 4

%DETACHED_PROCESS   = 8

%CREATE_NEW_CONSOLE = &H10

%NORMAL_PRIORITY_CLASS   = &H0020
%IDLE_PRIORITY_CLASS     = &H0040
%HIGH_PRIORITY_CLASS     = &H0080
%REALTIME_PRIORITY_CLASS = &H0100

%CREATE_NEW_PROCESS_GROUP = &H0200

%CREATE_NO_WINDOW = &H08000000

%PROFILE_USER   = &H10000000
%PROFILE_KERNEL = &H20000000
%PROFILE_SERVER = &H40000000

%THREAD_BASE_PRIORITY_LOWRT = 15  ' value that gets a thread to LowRealtime-1
%THREAD_BASE_PRIORITY_MAX   = 2   ' maximum thread base priority boost
%THREAD_BASE_PRIORITY_MIN   = -2  ' minimum thread base priority boost
%THREAD_BASE_PRIORITY_IDLE  = -15 ' value that gets a thread to idle

%MAXLONG                      = &H7FFFFFFF&
%THREAD_PRIORITY_LOWEST       = %THREAD_BASE_PRIORITY_MIN
%THREAD_PRIORITY_BELOW_NORMAL = %THREAD_PRIORITY_LOWEST + 1
%THREAD_PRIORITY_NORMAL       = 0
%THREAD_PRIORITY_HIGHEST      = %THREAD_BASE_PRIORITY_MAX
%THREAD_PRIORITY_ABOVE_NORMAL = %THREAD_PRIORITY_HIGHEST - 1
%THREAD_PRIORITY_ERROR_RETURN = %MAXLONG

%THREAD_PRIORITY_TIME_CRITICAL= %THREAD_BASE_PRIORITY_LOWRT
%THREAD_PRIORITY_IDLE         = %THREAD_BASE_PRIORITY_IDLE

%ATTR_ARCHIVE  = %FILE_ATTRIBUTE_ARCHIVE
%ATTR_DIR      = %FILE_ATTRIBUTE_DIRECTORY
%ATTR_HIDDEN   = %FILE_ATTRIBUTE_HIDDEN
%ATTR_NORMAL   = %FILE_ATTRIBUTE_NORMAL
%ATTR_READONLY = %FILE_ATTRIBUTE_READONLY
%ATTR_SYSTEM   = %FILE_ATTRIBUTE_SYSTEM

%HELPINFO_WINDOW         = 1
%HELPINFO_MENUITEM       = 2

%REG_OPTION_RESERVED             = 0     ' Parameter is reserved
%REG_OPTION_NON_VOLATILE         = 0     ' Key is preserved when system is rebooted
%REG_OPTION_VOLATILE             = 1     ' Key is not preserved when system is rebooted
%REG_OPTION_CREATE_LINK          = 2     ' Created key is a symbolic link
%REG_OPTION_BACKUP_RESTORE       = 4     ' open for backup or restore
%REG_OPTION_OPEN_LINK            = 8     ' Open symbolic link

%REG_NONE                        = 0     ' No value type
%REG_SZ                          = 1     ' Unicode nul terminated string
%REG_EXPAND_SZ                   = 2     ' Unicode nul terminated string
%REG_BINARY                      = 3     ' Free form binary
%REG_DWORD                       = 4     ' 32-bit number
%REG_DWORD_LITTLE_ENDIAN         = 4     ' 32-bit number (same as %REG_DWORD)
%REG_DWORD_BIG_ENDIAN            = 5     ' 32-bit number
%REG_LINK                        = 6     ' Symbolic Link (unicode)
%REG_MULTI_SZ                    = 7     ' Multiple Unicode strings
%REG_RESOURCE_LIST               = 8     ' Resource list in the resource map
%REG_FULL_RESOURCE_DESCRIPTOR    = 9     ' Resource list in the hardware description
%REG_RESOURCE_REQUIREMENTS_LIST  = 10
%REG_QWORD                       = 11    ' 64-bit number
%REG_QWORD_LITTLE_ENDIAN         = 11    ' 64-bit number (same as %REG_QWORD)

%REG_CREATED_NEW_KEY             = 1     ' New Registry Key created
%REG_OPENED_EXISTING_KEY         = 2     ' Existing Key opened
%REG_WHOLE_HIVE_VOLATILE         = 1     ' Restore whole hive volatile
%REG_REFRESH_HIVE                = 2     ' Unwind changes to last flush
%REG_NO_LAZY_FLUSH               = 4     ' Never lazy flush this hive
%REG_FORCE_RESTORE               = 8     ' Force the restore process even when we have open handles on subkeys
%REG_NOTIFY_CHANGE_NAME          = 1     ' Create or delete (child)
%REG_NOTIFY_CHANGE_ATTRIBUTES    = 2
%REG_NOTIFY_CHANGE_LAST_SET      = 4     ' Time stamp
%REG_NOTIFY_CHANGE_SECURITY      = 8
%REG_LEGAL_CHANGE_FILTER         = %REG_NOTIFY_CHANGE_NAME OR %REG_NOTIFY_CHANGE_ATTRIBUTES OR %REG_NOTIFY_CHANGE_LAST_SET OR %REG_NOTIFY_CHANGE_SECURITY
%REG_LEGAL_OPTION                = %REG_OPTION_RESERVED OR %REG_OPTION_NON_VOLATILE OR %REG_OPTION_VOLATILE OR %REG_OPTION_CREATE_LINK OR %REG_OPTION_BACKUP_RESTORE OR %REG_OPTION_OPEN_LINK

%KEY_QUERY_VALUE        = &H1
%KEY_SET_VALUE          = &H2
%KEY_CREATE_SUB_KEY     = &H4
%KEY_ENUMERATE_SUB_KEYS = &H8
%KEY_NOTIFY             = &H10
%KEY_CREATE_LINK        = &H20
%KEY_READ               = %STANDARD_RIGHTS_READ OR %KEY_QUERY_VALUE OR %KEY_ENUMERATE_SUB_KEYS OR %KEY_NOTIFY AND (NOT %SYNCHRONIZE)
%KEY_WRITE              = %STANDARD_RIGHTS_WRITE OR %KEY_SET_VALUE OR %KEY_CREATE_SUB_KEY AND (NOT %SYNCHRONIZE)
%KEY_EXECUTE            = %KEY_READ
%KEY_ALL_ACCESS         = %STANDARD_RIGHTS_ALL OR %KEY_QUERY_VALUE OR %KEY_SET_VALUE OR %KEY_CREATE_SUB_KEY OR %KEY_ENUMERATE_SUB_KEYS OR %KEY_NOTIFY OR %KEY_CREATE_LINK AND (NOT %SYNCHRONIZE)

%EXCEPTION_DEBUG_EVENT      = 1
%CREATE_THREAD_DEBUG_EVENT  = 2
%CREATE_PROCESS_DEBUG_EVENT = 3
%EXIT_THREAD_DEBUG_EVENT    = 4
%EXIT_PROCESS_DEBUG_EVENT   = 5
%LOAD_DLL_DEBUG_EVENT       = 6
%UNLOAD_DLL_DEBUG_EVENT     = 7
%OUTPUT_DEBUG_STRING_EVENT  = 8
%RIP_EVENT                  = 9


%DRIVE_UNKNOWN     = 0
%DRIVE_NO_ROOT_DIR = 1
%DRIVE_REMOVABLE   = 2
%DRIVE_FIXED       = 3
%DRIVE_REMOTE      = 4
%DRIVE_CDROM       = 5
%DRIVE_RAMDISK     = 6

%FILE_TYPE_UNKNOWN = &H0
%FILE_TYPE_DISK    = &H1
%FILE_TYPE_CHAR    = &H2
%FILE_TYPE_PIPE    = &H3
%FILE_TYPE_REMOTE  = &H8000

%STD_INPUT_HANDLE  = -10&
%STD_OUTPUT_HANDLE = -11&
%STD_ERROR_HANDLE  = -12&

%NOPARITY    = 0
%ODDPARITY   = 1
%EVENPARITY  = 2
%MARKPARITY  = 3
%SPACEPARITY = 4

%ONESTOPBIT   = 0
%ONE5STOPBITS = 1
%TWOSTOPBITS  = 2

%IGNORE   = 0               '  Ignore signal
%INFINITE = &HFFFFFFFF???   '  Infinite timeout

' Comm Baud Rate indices
%CBR_110      = 110
%CBR_300      = 300
%CBR_600      = 600
%CBR_1200     = 1200
%CBR_2400     = 2400
%CBR_4800     = 4800
%CBR_9600     = 9600
%CBR_14400    = 14400
%CBR_19200    = 19200
%CBR_38400    = 38400
%CBR_56000    = 56000
%CBR_57600    = 57600
%CBR_115200   = 115200
%CBR_128000   = 128000
%CBR_256000   = 256000

' Error Flags
%CE_RXOVER   = &H1       '  Receive Queue overflow
%CE_OVERRUN  = &H2       '  Receive Overrun Error
%CE_RXPARITY = &H4       '  Receive Parity Error
%CE_FRAME    = &H8       '  Receive Framing error
%CE_BREAK    = &H10      '  Break Detected
%CE_TXFULL   = &H100     '  TX Queue is full
%CE_PTO      = &H200     '  LPTx Timeout
%CE_IOE      = &H400     '  LPTx I/O Error
%CE_DNS      = &H800     '  LPTx Device not selected
%CE_OOP      = &H1000    '  LPTx Out-Of-Paper
%CE_MODE     = &H8000    '  Requested mode unsupported

%IE_BADID    = -1        '  Invalid or unsupported id
%IE_OPEN     = -2        '  Device Already Open
%IE_NOPEN    = -3        '  Device Not Open
%IE_MEMORY   = -4        '  Unable to allocate queues
%IE_DEFAULT  = -5        '  Error in default parameters
%IE_HARDWARE = -10       '  Hardware Not Present
%IE_BYTESIZE = -11       '  Illegal Byte Size
%IE_BAUDRATE = -12       '  Unsupported BaudRate

' Events
%EV_RXCHAR   = &H1       '  Any Character received
%EV_RXFLAG   = &H2       '  Received certain character
%EV_TXEMPTY  = &H4       '  Transmitt Queue Empty
%EV_CTS      = &H8       '  CTS changed state
%EV_DSR      = &H10      '  DSR changed state
%EV_RLSD     = &H20      '  RLSD changed state
%EV_BREAK    = &H40      '  BREAK received
%EV_ERR      = &H80      '  Line status error occurred
%EV_RING     = &H100     '  Ring signal detected
%EV_PERR     = &H200     '  Printer error occured
%EV_RX80FULL = &H400     '  Receive buffer is 80 percent full
%EV_EVENT1   = &H800     '  Provider specific event 1
%EV_EVENT2   = &H1000    '  Provider specific event 2

%SETXOFF  = 1         '  Simulate XOFF received
%SETXON   = 2         '  Simulate XON received
%SETRTS   = 3         '  Set RTS high
%CLRRTS   = 4         '  Set RTS low
%SETDTR   = 5         '  Set DTR high
%CLRDTR   = 6         '  Set DTR low
%RESETDEV = 7         '  Reset device if possible
%SETBREAK = 8         '  Set the device break line
%CLRBREAK = 9         '  Clear the device break line

%PURGE_TXABORT = &H1       '  Kill the pending/current writes to the comm port.
%PURGE_RXABORT = &H2       '  Kill the pending/current reads to the comm port.
%PURGE_TXCLEAR = &H4       '  Kill the transmit queue if there.
%PURGE_RXCLEAR = &H8       '  Kill the typeahead buffer if there.

%LPTx = &H80      '  Set if ID is for LPT device

%MS_CTS_ON  = &H10&
%MS_DSR_ON  = &H20&
%MS_RING_ON = &H40&
%MS_RLSD_ON = &H80&

%S_QUEUEEMPTY   = 0
%S_THRESHOLD    = 1
%S_ALLTHRESHOLD = 2

%S_NORMAL       = 0
%S_LEGATO       = 1
%S_STACCATO     = 2

%S_PERIOD512    = 0   '  Freq = N/512 high pitch, less coarse hiss
%S_PERIOD1024   = 1   '  Freq = N/1024
%S_PERIOD2048   = 2   '  Freq = N/2048 low pitch, more coarse hiss
%S_PERIODVOICE  = 3   '  Source is frequency from voice channel (3)
%S_WHITE512     = 4   '  Freq = N/512 high pitch, less coarse hiss
%S_WHITE1024    = 5   '  Freq = N/1024
%S_WHITE2048    = 6   '  Freq = N/2048 low pitch, more coarse hiss
%S_WHITEVOICE   = 7   '  Source is frequency from voice channel (3)

%S_SERDVNA      = -1  '  Device not available
%S_SEROFM       = -2  '  Out of memory
%S_SERMACT      = -3  '  Music active
%S_SERQFUL      = -4  '  Queue full
%S_SERBDNT      = -5  '  Invalid note
%S_SERDLN       = -6  '  Invalid note length
%S_SERDCC       = -7  '  Invalid note count
%S_SERDTP       = -8  '  Invalid tempo
%S_SERDVL       = -9  '  Invalid volume
%S_SERDMD       = -10 '  Invalid mode
%S_SERDSH       = -11 '  Invalid shape
%S_SERDPT       = -12 '  Invalid pitch
%S_SERDFQ       = -13 '  Invalid frequency
%S_SERDDR       = -14 '  Invalid duration
%S_SERDSR       = -15 '  Invalid source
%S_SERDST       = -16 '  Invalid state

%NMPWAIT_WAIT_FOREVER      = &HFFFFFFFF
%NMPWAIT_NOWAIT            = &H00000001
%NMPWAIT_USE_DEFAULT_WAIT  = &H00000000

%FS_CASE_IS_PRESERVED      = %FILE_CASE_PRESERVED_NAMES
%FS_CASE_SENSITIVE         = %FILE_CASE_SENSITIVE_SEARCH
%FS_UNICODE_STORED_ON_DISK = %FILE_UNICODE_ON_DISK
%FS_PERSISTENT_ACLS        = %FILE_PERSISTENT_ACLS
%FS_VOL_IS_COMPRESSED      = %FILE_VOLUME_IS_COMPRESSED
%FS_FILE_COMPRESSION       = %FILE_FILE_COMPRESSION
%FS_FILE_ENCRYPTION        = %FILE_SUPPORTS_ENCRYPTION

%FILE_MAP_COPY       = %SECTION_QUERY
%FILE_MAP_WRITE      = %SECTION_MAP_WRITE
%FILE_MAP_READ       = %SECTION_MAP_READ
%FILE_MAP_ALL_ACCESS = %SECTION_ALL_ACCESS

' OpenFile() Flags
%OF_READ             = &H0
%OF_WRITE            = &H1
%OF_READWRITE        = &H2
%OF_SHARE_COMPAT     = &H0
%OF_SHARE_EXCLUSIVE  = &H10
%OF_SHARE_DENY_WRITE = &H20
%OF_SHARE_DENY_READ  = &H30
%OF_SHARE_DENY_NONE  = &H40
%OF_PARSE            = &H100
%OF_DELETE           = &H200
%OF_VERIFY           = &H400
%OF_CANCEL           = &H800
%OF_CREATE           = &H1000
%OF_PROMPT           = &H2000
%OF_EXIST            = &H4000
%OF_REOPEN           = &H8000

%OFS_MAXPATHNAME = 128

%DONT_RESOLVE_DLL_REFERENCES   = &H00000001
%LOAD_LIBRARY_AS_DATAFILE      = &H00000002
%LOAD_WITH_ALTERED_SEARCH_PATH = &H00000008

%TC_NORMAL  = 0
%TC_HARDERR = 1
%TC_GP_TRAP = 2
%TC_SIGNAL  = 3

%MAX_LEADBYTES = 12          '  5 ranges, 2 bytes ea., 0 term.

%WC_DEFAULTCHECK   = &H100       '  check for default char
%WC_COMPOSITECHECK = &H200       '  convert composite to precomposed
%WC_DISCARDNS      = &H10        '  discard non-spacing chars
%WC_SEPCHARS       = &H20        '  generate separate chars
%WC_DEFAULTCHAR    = &H40        '  replace w/ default char

%CT_CTYPE1 = &H1         '  ctype 1 information
%CT_CTYPE2 = &H2         '  ctype 2 information
%CT_CTYPE3 = &H4         '  ctype 3 information

%C1_UPPER  = &H1     '  upper case
%C1_LOWER  = &H2     '  lower case
%C1_DIGIT  = &H4     '  decimal digits
%C1_SPACE  = &H8     '  spacing characters
%C1_PUNCT  = &H10    '  punctuation characters
%C1_CNTRL  = &H20    '  control characters
%C1_BLANK  = &H40    '  blank characters
%C1_XDIGIT = &H80    '  other digits
%C1_ALPHA  = &H100   '  any letter

%C2_LEFTTORIGHT      = &H1     '  left to right
%C2_RIGHTTOLEFT      = &H2     '  right to left

%C2_EUROPENUMBER     = &H3     '  European number, digit
%C2_EUROPESEPARATOR  = &H4     '  European numeric separator
%C2_EUROPETERMINATOR = &H5     '  European numeric terminator
%C2_ARABICNUMBER     = &H6     '  Arabic number
%C2_COMMONSEPARATOR  = &H7     '  common numeric separator

%C2_BLOCKSEPARATOR   = &H8     '  block separator
%C2_SEGMENTSEPARATOR = &H9     '  segment separator
%C2_WHITESPACE       = &HA     '  white space
%C2_OTHERNEUTRAL     = &HB     '  other neutrals

%C2_NOTAPPLICABLE    = &H0     '  no implicit directionality

%C3_NONSPACING    = &H1     '  nonspacing character
%C3_DIACRITIC     = &H2     '  diacritic mark
%C3_VOWELMARK     = &H4     '  vowel mark
%C3_SYMBOL        = &H8     '  symbols

%C3_NOTAPPLICABLE = &H0     '  ctype 3 is not applicable

%NORM_IGNORECASE     = &H1  '  ignore case
%NORM_IGNORENONSPACE = &H2  '  ignore nonspacing chars
%NORM_IGNORESYMBOLS  = &H4  '  ignore symbols

%MAP_FOLDCZONE   = &H10     '  fold compatibility zone chars
%MAP_PRECOMPOSED = &H20     '  convert to precomposed chars
%MAP_COMPOSITE   = &H40     '  convert to composite chars
%MAP_FOLDDIGITS  = &H80     '  all digits to ASCII 0-9

%LCMAP_LOWERCASE = &H100    '  lower case letters
%LCMAP_UPPERCASE = &H200    '  upper case letters
%LCMAP_SORTKEY   = &H400    '  WC sort key (normalize)
%LCMAP_BYTEREV   = &H800    '  byte reversal

%SORT_STRINGSORT = &H1000   '  use string sort method

%CP_ACP   = 0  '  default to ANSI code page
%CP_OEMCP = 1  '  default to OEM  code page

%CTRY_DEFAULT        = 0

%CTRY_ALBANIA            = 355       ' Albania
%CTRY_ALGERIA            = 213       ' Algeria
%CTRY_ARGENTINA          = 54        ' Argentina
%CTRY_ARMENIA            = 374       ' Armenia
%CTRY_AUSTRALIA          = 61        ' Australia
%CTRY_AUSTRIA            = 43        ' Austria
%CTRY_AZERBAIJAN         = 994       ' Azerbaijan
%CTRY_BAHRAIN            = 973       ' Bahrain
%CTRY_BELARUS            = 375       ' Belarus
%CTRY_BELGIUM            = 32        ' Belgium
%CTRY_BELIZE             = 501       ' Belize
%CTRY_BOLIVIA            = 591       ' Bolivia
%CTRY_BRAZIL             = 55        ' Brazil
%CTRY_BRUNEI_DARUSSALAM  = 673       ' Brunei Darussalam
%CTRY_BULGARIA           = 359       ' Bulgaria
%CTRY_CANADA             = 2         ' Canada
%CTRY_CARIBBEAN          = 1         ' Caribbean
%CTRY_CHILE              = 56        ' Chile
%CTRY_COLOMBIA           = 57        ' Colombia
%CTRY_COSTA_RICA         = 506       ' Costa Rica
%CTRY_CROATIA            = 385       ' Croatia
%CTRY_CZECH              = 420       ' Czech Republic
%CTRY_DENMARK            = 45        ' Denmark
%CTRY_DOMINICAN_REPUBLIC = 1         ' Dominican Republic
%CTRY_ECUADOR            = 593       ' Ecuador
%CTRY_EGYPT              = 20        ' Egypt
%CTRY_EL_SALVADOR        = 503       ' El Salvador
%CTRY_ESTONIA            = 372       ' Estonia
%CTRY_FAEROE_ISLANDS     = 298       ' Faeroe Islands
%CTRY_FINLAND            = 358       ' Finland
%CTRY_FRANCE             = 33        ' France
%CTRY_GEORGIA            = 995       ' Georgia
%CTRY_GERMANY            = 49        ' Germany
%CTRY_GREECE             = 30        ' Greece
%CTRY_GUATEMALA          = 502       ' Guatemala
%CTRY_HONDURAS           = 504       ' Honduras
%CTRY_HONG_KONG          = 852       ' Hong Kong S.A.R., P.R.C.
%CTRY_HUNGARY            = 36        ' Hungary
%CTRY_ICELAND            = 354       ' Iceland
%CTRY_INDIA              = 91        ' India
%CTRY_INDONESIA          = 62        ' Indonesia
%CTRY_IRAN               = 981       ' Iran
%CTRY_IRAQ               = 964       ' Iraq
%CTRY_IRELAND            = 353       ' Ireland
%CTRY_ISRAEL             = 972       ' Israel
%CTRY_ITALY              = 39        ' Italy
%CTRY_JAMAICA            = 1         ' Jamaica
%CTRY_JAPAN              = 81        ' Japan
%CTRY_JORDAN             = 962       ' Jordan
%CTRY_KAZAKSTAN          = 7         ' Kazakstan
%CTRY_KENYA              = 254       ' Kenya
%CTRY_KUWAIT             = 965       ' Kuwait
%CTRY_LATVIA             = 371       ' Latvia
%CTRY_LEBANON            = 961       ' Lebanon
%CTRY_LIBYA              = 218       ' Libya
%CTRY_LIECHTENSTEIN      = 41        ' Liechtenstein
%CTRY_LITHUANIA          = 370       ' Lithuania
%CTRY_LUXEMBOURG         = 352       ' Luxembourg
%CTRY_MACAU              = 853       ' Macau
%CTRY_MACEDONIA          = 389       ' the Former Yugoslav Republic of Macedonia
%CTRY_MALAYSIA           = 60        ' Malaysia
%CTRY_MEXICO             = 52        ' Mexico
%CTRY_MONACO             = 33        ' Principality of Monaco
%CTRY_MOROCCO            = 212       ' Morocco
%CTRY_NETHERLANDS        = 31        ' Netherlands
%CTRY_NEW_ZEALAND        = 64        ' New Zealand
%CTRY_NICARAGUA          = 505       ' Nicaragua
%CTRY_NORWAY             = 47        ' Norway
%CTRY_OMAN               = 968       ' Oman
%CTRY_PAKISTAN           = 92        ' Islamic Republic of Pakistan
%CTRY_PANAMA             = 507       ' Panama
%CTRY_PARAGUAY           = 595       ' Paraguay
%CTRY_PERU               = 51        ' Peru
%CTRY_PHILIPPINES        = 63        ' Republic of the Philippines
%CTRY_POLAND             = 48        ' Poland
%CTRY_PORTUGAL           = 351       ' Portugal
%CTRY_PRCHINA            = 86        ' People's Republic of China
%CTRY_PUERTO_RICO        = 1         ' Puerto Rico
%CTRY_QATAR              = 974       ' Qatar
%CTRY_ROMANIA            = 40        ' Romania
%CTRY_RUSSIA             = 7         ' Russia
%CTRY_SAUDI_ARABIA       = 966       ' Saudi Arabia
%CTRY_SERBIA             = 381       ' Serbia
%CTRY_SINGAPORE          = 65        ' Singapore
%CTRY_SLOVAK             = 421       ' Slovak Republic
%CTRY_SLOVENIA           = 386       ' Slovenia
%CTRY_SOUTH_AFRICA       = 27        ' South Africa
%CTRY_SOUTH_KOREA        = 82        ' South Korea
%CTRY_SPAIN              = 34        ' Spain
%CTRY_SWEDEN             = 46        ' Sweden
%CTRY_SWITZERLAND        = 41        ' Switzerland
%CTRY_SYRIA              = 963       ' Syria
%CTRY_TAIWAN             = 886       ' Taiwan
%CTRY_TATARSTAN          = 7         ' Tatarstan
%CTRY_THAILAND           = 66        ' Thailand
%CTRY_TRINIDAD_Y_TOBAGO  = 1         ' Trinidad y Tobago
%CTRY_TUNISIA            = 216       ' Tunisia
%CTRY_TURKEY             = 90        ' Turkey
%CTRY_UAE                = 971       ' U.A.E.
%CTRY_UKRAINE            = 380       ' Ukraine
%CTRY_UNITED_KINGDOM     = 44        ' United Kingdom
%CTRY_UNITED_STATES      = 1         ' United States
%CTRY_URUGUAY            = 598       ' Uruguay
%CTRY_UZBEKISTAN         = 7         ' Uzbekistan
%CTRY_VENEZUELA          = 58        ' Venezuela
%CTRY_VIET_NAM           = 84        ' Viet Nam
%CTRY_YEMEN              = 967       ' Yemen
%CTRY_ZIMBABWE           = 263       ' Zimbabwe

%LOCALE_NOUSEROVERRIDE   = &H80000000??? ' do not use user overrides
%LOCALE_USE_CP_ACP       = &H40000000??? ' use the system ACP
%LOCALE_RETURN_NUMBER    = &H20000000??? ' return number instead of string

%LOCALE_USER_DEFAULT     = &H0000
%LOCALE_SYSTEM_DEFAULT   = &H0800&
%LOCALE_ILANGUAGE        = &H1       '  language id
%LOCALE_SLANGUAGE        = &H2       '  localized name of language
%LOCALE_SENGLANGUAGE     = &H1001    '  English name of language
%LOCALE_SABBREVLANGNAME  = &H3       '  abbreviated language name
%LOCALE_SNATIVELANGNAME  = &H4       '  native name of language
%LOCALE_ICOUNTRY         = &H5       '  country code
%LOCALE_SCOUNTRY         = &H6       '  localized name of country
%LOCALE_SENGCOUNTRY      = &H1002    '  English name of country
%LOCALE_SABBREVCTRYNAME  = &H7       '  abbreviated country name
%LOCALE_SNATIVECTRYNAME  = &H8       '  native name of country
%LOCALE_IDEFAULTLANGUAGE = &H9       '  default language id
%LOCALE_IDEFAULTCOUNTRY  = &HA       '  default country code
%LOCALE_IDEFAULTCODEPAGE = &HB       '  default code page

%LOCALE_SLIST            = &HC       '  list item separator
%LOCALE_IMEASURE         = &HD       '  0 = metric, 1 = US

%LOCALE_SDECIMAL         = &HE       '  decimal separator
%LOCALE_STHOUSAND        = &HF       '  thousand separator
%LOCALE_SGROUPING        = &H10      '  digit grouping
%LOCALE_IDIGITS          = &H11      '  number of fractional digits
%LOCALE_ILZERO           = &H12      '  leading zeros for decimal
%LOCALE_SNATIVEDIGITS    = &H13      '  native ascii 0-9

%LOCALE_SCURRENCY        = &H14      '  local monetary symbol
%LOCALE_SINTLSYMBOL      = &H15      '  intl monetary symbol
%LOCALE_SMONDECIMALSEP   = &H16      '  monetary decimal separator
%LOCALE_SMONTHOUSANDSEP  = &H17      '  monetary thousand separator
%LOCALE_SMONGROUPING     = &H18      '  monetary grouping
%LOCALE_ICURRDIGITS      = &H19      '  # local monetary digits
%LOCALE_IINTLCURRDIGITS  = &H1A      '  # intl monetary digits
%LOCALE_ICURRENCY        = &H1B      '  positive currency mode
%LOCALE_INEGCURR         = &H1C      '  negative currency mode

%LOCALE_SDATE            = &H1D      '  date separator
%LOCALE_STIME            = &H1E      '  time separator
%LOCALE_SSHORTDATE       = &H1F      '  short date format string
%LOCALE_SLONGDATE        = &H20      '  long date format string
%LOCALE_STIMEFORMAT      = &H1003    '  time format string
%LOCALE_IDATE            = &H21      '  short date format ordering
%LOCALE_ILDATE           = &H22      '  long date format ordering
%LOCALE_ITIME            = &H23      '  time format specifier
%LOCALE_ICENTURY         = &H24      '  century format specifier
%LOCALE_ITLZERO          = &H25      '  leading zeros in time field
%LOCALE_IDAYLZERO        = &H26      '  leading zeros in day field
%LOCALE_IMONLZERO        = &H27      '  leading zeros in month field
%LOCALE_S1159            = &H28      '  AM designator
%LOCALE_S2359            = &H29      '  PM designator

%LOCALE_SDAYNAME1          = &H2A    '  long name for Monday
%LOCALE_SDAYNAME2          = &H2B    '  long name for Tuesday
%LOCALE_SDAYNAME3          = &H2C    '  long name for Wednesday
%LOCALE_SDAYNAME4          = &H2D    '  long name for Thursday
%LOCALE_SDAYNAME5          = &H2E    '  long name for Friday
%LOCALE_SDAYNAME6          = &H2F    '  long name for Saturday
%LOCALE_SDAYNAME7          = &H30    '  long name for Sunday
%LOCALE_SABBREVDAYNAME1    = &H31    '  abbreviated name for Monday
%LOCALE_SABBREVDAYNAME2    = &H32    '  abbreviated name for Tuesday
%LOCALE_SABBREVDAYNAME3    = &H33    '  abbreviated name for Wednesday
%LOCALE_SABBREVDAYNAME4    = &H34    '  abbreviated name for Thursday
%LOCALE_SABBREVDAYNAME5    = &H35    '  abbreviated name for Friday
%LOCALE_SABBREVDAYNAME6    = &H36    '  abbreviated name for Saturday
%LOCALE_SABBREVDAYNAME7    = &H37    '  abbreviated name for Sunday
%LOCALE_SMONTHNAME1        = &H38    '  long name for January
%LOCALE_SMONTHNAME2        = &H39    '  long name for February
%LOCALE_SMONTHNAME3        = &H3A    '  long name for March
%LOCALE_SMONTHNAME4        = &H3B    '  long name for April
%LOCALE_SMONTHNAME5        = &H3C    '  long name for May
%LOCALE_SMONTHNAME6        = &H3D    '  long name for June
%LOCALE_SMONTHNAME7        = &H3E    '  long name for July
%LOCALE_SMONTHNAME8        = &H3F    '  long name for August
%LOCALE_SMONTHNAME9        = &H40    '  long name for September
%LOCALE_SMONTHNAME10       = &H41    '  long name for October
%LOCALE_SMONTHNAME11       = &H42    '  long name for November
%LOCALE_SMONTHNAME12       = &H43    '  long name for December
%LOCALE_SABBREVMONTHNAME1  = &H44    '  abbreviated name for January
%LOCALE_SABBREVMONTHNAME2  = &H45    '  abbreviated name for February
%LOCALE_SABBREVMONTHNAME3  = &H46    '  abbreviated name for March
%LOCALE_SABBREVMONTHNAME4  = &H47    '  abbreviated name for April
%LOCALE_SABBREVMONTHNAME5  = &H48    '  abbreviated name for May
%LOCALE_SABBREVMONTHNAME6  = &H49    '  abbreviated name for June
%LOCALE_SABBREVMONTHNAME7  = &H4A    '  abbreviated name for July
%LOCALE_SABBREVMONTHNAME8  = &H4B    '  abbreviated name for August
%LOCALE_SABBREVMONTHNAME9  = &H4C    '  abbreviated name for September
%LOCALE_SABBREVMONTHNAME10 = &H4D    '  abbreviated name for October
%LOCALE_SABBREVMONTHNAME11 = &H4E    '  abbreviated name for November
%LOCALE_SABBREVMONTHNAME12 = &H4F    '  abbreviated name for December
%LOCALE_SABBREVMONTHNAME13 = &H100F

%LOCALE_SPOSITIVESIGN   = &H50       '  positive sign
%LOCALE_SNEGATIVESIGN   = &H51       '  negative sign
%LOCALE_IPOSSIGNPOSN    = &H52       '  positive sign position
%LOCALE_INEGSIGNPOSN    = &H53       '  negative sign position
%LOCALE_IPOSSYMPRECEDES = &H54       '  mon sym precedes pos amt
%LOCALE_IPOSSEPBYSPACE  = &H55       '  mon sym sep by space from pos amt
%LOCALE_INEGSYMPRECEDES = &H56       '  mon sym precedes neg amt
%LOCALE_INEGSEPBYSPACE  = &H57       '  mon sym sep by space from neg amt

%TIME_NOMINUTESORSECONDS = &H1&      '  do not use minutes or seconds
%TIME_NOSECONDS          = &H2&      '  do not use seconds
%TIME_NOTIMEMARKER       = &H4&      '  do not use time marker
%TIME_FORCE24HOURFORMAT  = &H8&      '  always use 24 hour format

%TIME_ZONE_ID_INVALID  = &HFFFFFFFF???
%TIME_ZONE_ID_UNKNOWN  = 0
%TIME_ZONE_ID_STANDARD = 1
%TIME_ZONE_ID_DAYLIGHT = 2

%DATE_SHORTDATE = &H1         '  use short date picture
%DATE_LONGDATE  = &H2         '  use long date picture

%LR_DEFAULTCOLOR      = &H0000
%LR_MONOCHROME        = &H0001
%LR_COLOR             = &H0002
%LR_COPYRETURNORG     = &H0004
%LR_COPYDELETEORG     = &H0008
%LR_LOADFROMFILE      = &H0010
%LR_LOADTRANSPARENT   = &H0020
%LR_DEFAULTSIZE       = &H0040
%LR_LOADMAP3DCOLORS   = &H1000
%LR_CREATEDIBSECTION  = &H2000
%LR_COPYFROMRESOURCE  = &H4000
%LR_SHARED            = &H8000

%TF_FORCEDRIVE = &H80

%LOCKFILE_FAIL_IMMEDIATELY = &H1
%LOCKFILE_EXCLUSIVE_LOCK   = &H2

%LNOTIFY_OUTOFMEM = 0
%LNOTIFY_MOVE     = 1
%LNOTIFY_DISCARD  = 2

%SEM_FAILCRITICALERRORS = &H1
%SEM_NOGPFAULTERRORBOX  = &H2
%SEM_NOOPENFILEERRORBOX = &H8000

#IF NOT %DEF(%NORESOURCE) '---------------------------
%RT_CURSOR       = 1
%RT_BITMAP       = 2
%RT_ICON         = 3
%RT_MENU         = 4
%RT_DIALOG       = 5
%RT_STRING       = 6
%RT_FONTDIR      = 7
%RT_FONT         = 8
%RT_ACCELERATOR  = 9
%RT_RCDATA       = 10
%RT_MESSAGETABLE = 11
%RT_GROUP_CURSOR = 12
%RT_GROUP_ICON   = 14
%RT_VERSION      = 16
%RT_DLGINCLUDE   = 17
%RT_PLUGPLAY     = 19
%RT_VXD          = 20
%RT_ANICURSOR    = 21
%RT_ANIICON      = 22
%RT_HTML         = 23
#ENDIF ' #IF NOT %DEF(%NORESOURCE) -------------------

%DFC_CAPTION     = 1
%DFC_MENU        = 2
%DFC_SCROLL      = 3
%DFC_BUTTON      = 4

%DFCS_CAPTIONCLOSE   = &H0000
%DFCS_CAPTIONMIN     = &H0001
%DFCS_CAPTIONMAX     = &H0002
%DFCS_CAPTIONRESTORE = &H0003
%DFCS_CAPTIONHELP    = &H0004

%DFCS_MENUARROW      = &H0000
%DFCS_MENUCHECK      = &H0001
%DFCS_MENUBULLET     = &H0002
%DFCS_MENUARROWRIGHT = &H0004

%DFCS_SCROLLUP            = &H0000
%DFCS_SCROLLDOWN          = &H0001
%DFCS_SCROLLLEFT          = &H0002
%DFCS_SCROLLRIGHT         = &H0003
%DFCS_SCROLLCOMBOBOX      = &H0005
%DFCS_SCROLLSIZEGRIP      = &H0008
%DFCS_SCROLLSIZEGRIPRIGHT = &H0010

%DFCS_BUTTONCHECK      = &H0000
%DFCS_BUTTONRADIOIMAGE = &H0001
%DFCS_BUTTONRADIOMASK  = &H0002
%DFCS_BUTTONRADIO      = &H0004
%DFCS_BUTTON3STATE     = &H0008
%DFCS_BUTTONPUSH       = &H0010

%DFCS_INACTIVE   = &H0100
%DFCS_PUSHED     = &H0200
%DFCS_CHECKED    = &H0400
%DFCS_ADJUSTRECT = &H2000
%DFCS_FLAT       = &H4000
%DFCS_MONO       = &H8000

%DDD_RAW_TARGET_PATH       = &H1
%DDD_REMOVE_DEFINITION     = &H2
%DDD_EXACT_MATCH_ON_REMOVE = &H4

%MAX_PATH  = 260  ' max. length of full pathname
%MAX_DRIVE = 3    ' max. length of drive component
%MAX_DIR   = 256  ' max. length of path component
%MAX_FNAME = 256  ' max. length of file name component
%MAX_EXT   = 256  ' max. length of extension component

%MOVEFILE_REPLACE_EXISTING      = &H1
%MOVEFILE_COPY_ALLOWED          = &H2
%MOVEFILE_DELAY_UNTIL_REBOOT    = &H4
%MOVEFILE_WRITE_THROUGH         = &H8
%MOVEFILE_CREATE_HARDLINK       = &H10
%MOVEFILE_FAIL_IF_NOT_TRACKABLE = &H20

%GET_TAPE_MEDIA_INFORMATION = 0
%GET_TAPE_DRIVE_INFORMATION = 1

%SET_TAPE_MEDIA_INFORMATION = 0
%SET_TAPE_DRIVE_INFORMATION = 1

%FORMAT_MESSAGE_ALLOCATE_BUFFER = &H100
%FORMAT_MESSAGE_IGNORE_INSERTS  = &H200
%FORMAT_MESSAGE_FROM_STRING     = &H400
%FORMAT_MESSAGE_FROM_HMODULE    = &H800
%FORMAT_MESSAGE_FROM_SYSTEM     = &H1000
%FORMAT_MESSAGE_ARGUMENT_ARRAY  = &H2000
%FORMAT_MESSAGE_MAX_WIDTH_MASK  = &HFF

%TLS_OUT_OF_INDEXES = &HFFFF

%BACKUP_DATA           = &H1
%BACKUP_EA_DATA        = &H2
%BACKUP_SECURITY_DATA  = &H3
%BACKUP_ALTERNATE_DATA = &H4
%BACKUP_LINK           = &H5

'   Stream Attributes
%STREAM_MODIFIED_WHEN_READ = &H1
%STREAM_CONTAINS_SECURITY  = &H2

'  Dual Mode API below this line. Dual Mode Types also included.

%STARTF_USESHOWWINDOW    = &H00000001
%STARTF_USESIZE          = &H00000002
%STARTF_USEPOSITION      = &H00000004
%STARTF_USECOUNTCHARS    = &H00000008
%STARTF_USEFILLATTRIBUTE = &H00000010
%STARTF_RUNFULLSCREEN    = &H00000020     '  ignored for non-x86 platforms
%STARTF_FORCEONFEEDBACK  = &H00000040
%STARTF_FORCEOFFFEEDBACK = &H00000080
%STARTF_USESTDHANDLES    = &H00000100
%STARTF_USEHOTKEY        = &H00000200

%SHUTDOWN_NORETRY = &H1

%MAX_DEFAULTCHAR        = 2
%CAL_ICALINTVALUE       = &H1     '  calendar type
%CAL_SCALNAME           = &H2     '  native name of calendar
%CAL_IYEAROFFSETRANGE   = &H3     '  starting years of eras
%CAL_SERASTRING         = &H4     '  era name for IYearOffsetRanges
%CAL_SSHORTDATE         = &H5     '  Integer date format string
%CAL_SLONGDATE          = &H6     '  long date format string
%CAL_SDAYNAME1          = &H7     '  native name for Monday
%CAL_SDAYNAME2          = &H8     '  native name for Tuesday
%CAL_SDAYNAME3          = &H9     '  native name for Wednesday
%CAL_SDAYNAME4          = &HA     '  native name for Thursday
%CAL_SDAYNAME5          = &HB     '  native name for Friday
%CAL_SDAYNAME6          = &HC     '  native name for Saturday
%CAL_SDAYNAME7          = &HD     '  native name for Sunday
%CAL_SABBREVDAYNAME1    = &HE     '  abbreviated name for Monday
%CAL_SABBREVDAYNAME2    = &HF     '  abbreviated name for Tuesday
%CAL_SABBREVDAYNAME3    = &H10    '  abbreviated name for Wednesday
%CAL_SABBREVDAYNAME4    = &H11    '  abbreviated name for Thursday
%CAL_SABBREVDAYNAME5    = &H12    '  abbreviated name for Friday
%CAL_SABBREVDAYNAME6    = &H13    '  abbreviated name for Saturday
%CAL_SABBREVDAYNAME7    = &H14    '  abbreviated name for Sunday
%CAL_SMONTHNAME1        = &H15    '  native name for January
%CAL_SMONTHNAME2        = &H16    '  native name for February
%CAL_SMONTHNAME3        = &H17    '  native name for March
%CAL_SMONTHNAME4        = &H18    '  native name for April
%CAL_SMONTHNAME5        = &H19    '  native name for May
%CAL_SMONTHNAME6        = &H1A    '  native name for June
%CAL_SMONTHNAME7        = &H1B    '  native name for July
%CAL_SMONTHNAME8        = &H1C    '  native name for August
%CAL_SMONTHNAME9        = &H1D    '  native name for September
%CAL_SMONTHNAME10       = &H1E    '  native name for October
%CAL_SMONTHNAME11       = &H1F    '  native name for November
%CAL_SMONTHNAME12       = &H20    '  native name for December
%CAL_SMONTHNAME13       = &H21    '  native name for 13th month (if any)
%CAL_SABBREVMONTHNAME1  = &H22    '  abbreviated name for January
%CAL_SABBREVMONTHNAME2  = &H23    '  abbreviated name for February
%CAL_SABBREVMONTHNAME3  = &H24    '  abbreviated name for March
%CAL_SABBREVMONTHNAME4  = &H25    '  abbreviated name for April
%CAL_SABBREVMONTHNAME5  = &H26    '  abbreviated name for May
%CAL_SABBREVMONTHNAME6  = &H27    '  abbreviated name for June
%CAL_SABBREVMONTHNAME7  = &H28    '  abbreviated name for July
%CAL_SABBREVMONTHNAME8  = &H29    '  abbreviated name for August
%CAL_SABBREVMONTHNAME9  = &H2A    '  abbreviated name for September
%CAL_SABBREVMONTHNAME10 = &H2B    '  abbreviated name for October
%CAL_SABBREVMONTHNAME11 = &H2C    '  abbreviated name for November
%CAL_SABBREVMONTHNAME12 = &H2D    '  abbreviated name for December
%CAL_SABBREVMONTHNAME13 = &H2E    '  abbreviated name for 13th month (if any)

%ENUM_ALL_CALENDARS = &HFFFF  '  enumerate all calendars

%CAL_GREGORIAN    = 1       '  Gregorian (localized) calendar
%CAL_GREGORIAN_US = 2       '  Gregorian (U.S.) calendar
%CAL_JAPAN        = 3       '  Japanese Emperor Era calendar
%CAL_TAIWAN       = 4       '  Republic of China Era calendar
%CAL_KOREA        = 5       '  Korean Tangun Era calendar

%RIGHT_ALT_PRESSED  = &H1     '  the right alt key is pressed.
%LEFT_ALT_PRESSED   = &H2     '  the left alt key is pressed.
%RIGHT_CTRL_PRESSED = &H4     '  the right ctrl key is pressed.
%LEFT_CTRL_PRESSED  = &H8     '  the left ctrl key is pressed.
%SHIFT_PRESSED      = &H10    '  the shift key is pressed.
%NUMLOCK_ON         = &H20    '  the numlock light is on.
%SCROLLLOCK_ON      = &H40    '  the scrolllock light is on.
%CAPSLOCK_ON        = &H80    '  the capslock light is on.
%ENHANCED_KEY       = &H100   '  the key is enhanced.

%FROM_LEFT_1ST_BUTTON_PRESSED = &H1
%RIGHTMOST_BUTTON_PRESSED     = &H2
%FROM_LEFT_2ND_BUTTON_PRESSED = &H4
%FROM_LEFT_3RD_BUTTON_PRESSED = &H8
%FROM_LEFT_4TH_BUTTON_PRESSED = &H10

%MOUSE_MOVED  = &H1
%DOUBLE_CLICK = &H2

%KEY_EVENT                = &H1     '  Event contains key event record
%MOUSE_EVENT              = &H2     '  Event contains mouse event record
%WINDOW_BUFFER_SIZE_EVENT = &H4     '  Event contains window change event record
%MENU_EVENT               = &H8     '  Event contains menu event record
%FOCUS_EVENT              = &H10    '  event contains focus change

%FOREGROUND_BLUE      = &H1     '  text color contains blue.
%FOREGROUND_GREEN     = &H2     '  text color contains green.
%FOREGROUND_RED       = &H4     '  text color contains red.
%FOREGROUND_INTENSITY = &H8     '  text color is intensified.
%BACKGROUND_BLUE      = &H10    '  background color contains blue.
%BACKGROUND_GREEN     = &H20    '  background color contains green.
%BACKGROUND_RED       = &H40    '  background color contains red.
%BACKGROUND_INTENSITY = &H80    '  background color is intensified.

%CTRL_C_EVENT        = 0
%CTRL_BREAK_EVENT    = 1
%CTRL_CLOSE_EVENT    = 2
%CTRL_LOGOFF_EVENT   = 5
%CTRL_SHUTDOWN_EVENT = 6

%ENABLE_PROCESSED_INPUT = &H1
%ENABLE_LINE_INPUT      = &H2
%ENABLE_ECHO_INPUT      = &H4
%ENABLE_WINDOW_INPUT    = &H8
%ENABLE_MOUSE_INPUT     = &H10

%ENABLE_PROCESSED_OUTPUT   = &H1
%ENABLE_WRAP_AT_EOL_OUTPUT = &H2

%CONSOLE_TEXTMODE_BUFFER = 1



' Constants from mmreg.h ======================================================

%INC_MMREG = 146   ' _INC_MMREG in original; shows version 1, revision 46

#IF NOT %DEF(%NOMMIDS) '-------------------------------------------------------

#IF NOT %DEF(%MM_MICROSOFT)
%MM_MICROSOFT                  = 1     ' Microsoft Corporation
#ENDIF

%MM_CREATIVE                   = 2     ' Creative Labs, Inc
%MM_MEDIAVISION                = 3     ' Media Vision, Inc.
%MM_FUJITSU                    = 4     ' Fujitsu Corp.
%MM_ARTISOFT                   = 20    ' Artisoft, Inc.
%MM_TURTLE_BEACH               = 21    ' Turtle Beach, Inc.
%MM_IBM                        = 22    ' IBM Corporation
%MM_VOCALTEC                   = 23    ' Vocaltec LTD.
%MM_ROLAND                     = 24    ' Roland
%MM_DSP_SOLUTIONS              = 25    ' DSP Solutions, Inc.
%MM_NEC                        = 26    ' NEC
%MM_ATI                        = 27    ' ATI
%MM_WANGLABS                   = 28    ' Wang Laboratories, Inc
%MM_TANDY                      = 29    ' Tandy Corporation
%MM_VOYETRA                    = 30    ' Voyetra
%MM_ANTEX                      = 31    ' Antex Electronics Corporation
%MM_ICL_PS                     = 32    ' ICL Personal Systems
%MM_INTEL                      = 33    ' Intel Corporation
%MM_GRAVIS                     = 34    ' Advanced Gravis
%MM_VAL                        = 35    ' Video Associates Labs, Inc.
%MM_INTERACTIVE                = 36    ' InterActive Inc
%MM_YAMAHA                     = 37    ' Yamaha Corporation of America
%MM_EVEREX                     = 38    ' Everex Systems, Inc
%MM_ECHO                       = 39    ' Echo Speech Corporation
%MM_SIERRA                     = 40    ' Sierra Semiconductor Corp
%MM_CAT                        = 41    ' Computer Aided Technologies
%MM_APPS                       = 42    ' APPS Software International
%MM_DSP_GROUP                  = 43    ' DSP Group, Inc
%MM_MELABS                     = 44    ' microEngineering Labs
%MM_COMPUTER_FRIENDS           = 45    ' Computer Friends, Inc.
%MM_ESS                        = 46    ' ESS Technology
%MM_AUDIOFILE                  = 47    ' Audio, Inc.
%MM_MOTOROLA                   = 48    ' Motorola, Inc.
%MM_CANOPUS                    = 49    ' Canopus, co., Ltd.
%MM_EPSON                      = 50    ' Seiko Epson Corporation
%MM_TRUEVISION                 = 51    ' Truevision
%MM_AZTECH                     = 52    ' Aztech Labs, Inc.
%MM_VIDEOLOGIC                 = 53    ' Videologic
%MM_SCALACS                    = 54    ' SCALACS
%MM_KORG                       = 55    ' Korg Inc.
%MM_APT                        = 56    ' Audio Processing Technology
%MM_ICS                        = 57    ' Integrated Circuit Systems, Inc.
%MM_ITERATEDSYS                = 58    ' Iterated Systems, Inc.
%MM_METHEUS                    = 59    ' Metheus
%MM_LOGITECH                   = 60    ' Logitech, Inc.
%MM_WINNOV                     = 61    ' Winnov, Inc.
%MM_NCR                        = 62    ' NCR Corporation
%MM_EXAN                       = 63    ' EXAN
%MM_AST                        = 64    ' AST Research Inc.
%MM_WILLOWPOND                 = 65    ' Willow Pond Corporation
%MM_SONICFOUNDRY               = 66    ' Sonic Foundry
%MM_VITEC                      = 67    ' Vitec Multimedia
%MM_MOSCOM                     = 68    ' MOSCOM Corporation
%MM_SILICONSOFT                = 69    ' Silicon Soft, Inc.
%MM_SUPERMAC                   = 73    ' Supermac
%MM_AUDIOPT                    = 74    ' Audio Processing Technology
%MM_SPEECHCOMP                 = 76    ' Speech Compression
%MM_AHEAD                      = 77    ' Ahead, Inc.
%MM_DOLBY                      = 78    ' Dolby Laboratories
%MM_OKI                        = 79    ' OKI
%MM_AURAVISION                 = 80    ' AuraVision Corporation
%MM_OLIVETTI                   = 81    ' Ing C. Olivetti & C., S.p.A.
%MM_IOMAGIC                    = 82    ' I/O Magic Corporation
%MM_MATSUSHITA                 = 83    ' Matsushita Electric Industrial Co., LTD.
%MM_CONTROLRES                 = 84    ' Control Resources Limited
%MM_XEBEC                      = 85    ' Xebec Multimedia Solutions Limited
%MM_NEWMEDIA                   = 86    ' New Media Corporation
%MM_NMS                        = 87    ' Natural MicroSystems
%MM_LYRRUS                     = 88    ' Lyrrus Inc.
%MM_COMPUSIC                   = 89    ' Compusic
%MM_OPTI                       = 90    ' OPTi Computers Inc.
%MM_ADLACC                     = 91    ' Adlib Accessories Inc.
%MM_COMPAQ                     = 92    ' Compaq Computer Corp.
%MM_DIALOGIC                   = 93    ' Dialogic Corporation
%MM_INSOFT                     = 94    ' InSoft, Inc.
%MM_MPTUS                      = 95    ' M.P. Technologies, Inc.
%MM_WEITEK                     = 96    ' Weitek
%MM_LERNOUT_AND_HAUSPIE        = 97    ' Lernout & Hauspie
%MM_QCIAR                      = 98    ' Quanta Computer Inc.
%MM_APPLE                      = 99    ' Apple Computer, Inc.
%MM_DIGITAL                    = 100   ' Digital Equipment Corporation
%MM_MOTU                       = 101   ' Mark of the Unicorn
%MM_WORKBIT                    = 102   ' Workbit Corporation
%MM_OSITECH                    = 103   ' Ositech Communications Inc.
%MM_MIRO                       = 104   ' miro Computer Products AG
%MM_CIRRUSLOGIC                = 105   ' Cirrus Logic
%MM_ISOLUTION                  = 106   ' ISOLUTION  B.V.
%MM_HORIZONS                   = 107   ' Horizons Technology, Inc
%MM_CONCEPTS                   = 108   ' Computer Concepts Ltd
%MM_VTG                        = 109   ' Voice Technologies Group, Inc.
%MM_RADIUS                     = 110   ' Radius
%MM_ROCKWELL                   = 111   ' Rockwell International
%MM_XYz                        = 112   ' Co. XYZ for testing
%MM_OPCODE                     = 113   ' Opcode Systems
%MM_VOXWARE                    = 114   ' Voxware Inc
%MM_NORTHERN_TELECOM           = 115   ' Northern Telecom Limited
%MM_APICOM                     = 116   ' APICOM
%MM_GRANDE                     = 117   ' Grande Software
%MM_ADDX                       = 118   ' ADDX
%MM_WILDCAT                    = 119   ' Wildcat Canyon Software
%MM_RHETOREX                   = 120   ' Rhetorex Inc
%MM_BROOKTREE                  = 121   ' Brooktree Corporation
%MM_ENSONIQ                    = 125   ' ENSONIQ Corporation
%MM_FAST                       = 126   ' ///FAST Multimedia AG
%MM_NVIDIA                     = 127   ' NVidia Corporation
%MM_OKSORI                     = 128   ' OKSORI Co., Ltd.
%MM_DIACOUSTICS                = 129   ' DiAcoustics, Inc.
%MM_GULBRANSEN                 = 130   ' Gulbransen, Inc.
%MM_KAY_ELEMETRICS             = 131   ' Kay Elemetrics, Inc.
%MM_CRYSTAL                    = 132   ' Crystal Semiconductor Corporation
%MM_SPLASH_STUDIOS             = 133   ' Splash Studios
%MM_QUARTERDECK                = 134   ' Quarterdeck Corporation
%MM_TDK                        = 135   ' TDK Corporation
%MM_DIGITAL_AUDIO_LABS         = 136   ' Digital Audio Labs, Inc.
%MM_SEERSYS                    = 137   ' Seer Systems, Inc.
%MM_PICTURETEL                 = 138   ' PictureTel Corporation
%MM_ATT_MICROELECTRONICS       = 139   ' AT&T Microelectronics
%MM_OSPREY                     = 140   ' Osprey Technologies, Inc.
%MM_MEDIATRIX                  = 141   ' Mediatrix Peripherals
%MM_SOUNDESIGNS                = 142   ' SounDesignS M.C.S. Ltd.
%MM_ALDIGITAL                  = 143   ' A.L. Digital Ltd.
%MM_SPECTRUM_SIGNAL_PROCESSING = 144   ' Spectrum Signal Processing, Inc.
%MM_ECS                        = 145   ' Electronic Courseware Systems, Inc.
%MM_AMD                        = 146   ' AMD
%MM_COREDYNAMICS               = 147   ' Core Dynamics
%MM_CANAM                      = 148   ' CANAM Computers
%MM_SOFTSOUND                  = 149   ' Softsound, Ltd.
%MM_NORRIS                     = 150   ' Norris Communications, Inc.
%MM_DDD                        = 151   ' Danka Data Devices
%MM_EUPHONICS                  = 152   ' EuPhonics
%MM_PRECEPT                    = 153   ' Precept Software, Inc.
%MM_CRYSTAL_NET                = 154   ' Crystal Net Corporation
%MM_CHROMATIC                  = 155   ' Chromatic Research, Inc
%MM_VOICEINFO                  = 156   ' Voice Information Systems, Inc
%MM_VIENNASYS                  = 157   ' Vienna Systems
%MM_CONNECTIX                  = 158   ' Connectix Corporation
%MM_GADGETLABS                 = 159   ' Gadget Labs LLC
%MM_FRONTIER                   = 160   ' Frontier Design Group LLC
%MM_VIONA                      = 161   ' Viona Development GmbH
%MM_CASIO                      = 162   ' Casio Computer Co., LTD
%MM_DIAMONDMM                  = 163   ' Diamond Multimedia
%MM_S3                         = 164   ' S3
%MM_FRAUNHOFER_IIS             = 172   ' Fraunhofer

' MM_MICROSOFT product IDs

#IF NOT %DEF(%MM_MIDI_MAPPER) '-------------------------------------------

%MM_MIDI_MAPPER     = 1   '  MIDI Mapper
%MM_WAVE_MAPPER     = 2   '  Wave Mapper
%MM_SNDBLST_MIDIOUT = 3   '  Sound Blaster MIDI output port
%MM_SNDBLST_MIDIIN  = 4   '  Sound Blaster MIDI input port
%MM_SNDBLST_SYNTH   = 5   '  Sound Blaster internal synthesizer
%MM_SNDBLST_WAVEOUT = 6   '  Sound Blaster waveform output
%MM_SNDBLST_WAVEIN  = 7   '  Sound Blaster waveform input
%MM_ADLIB           = 9   '  Ad Lib-compatible synthesizer
%MM_MPU401_MIDIOUT  = 10  '  MPU401-compatible MIDI output port
%MM_MPU401_MIDIIN   = 11  '  MPU401-compatible MIDI input port
%MM_PC_JOYSTICK     = 12  '  Joystick adapter

#ENDIF ' #IF NOT %DEF(%MM_MIDI_MAPPER) -----------------------------------

%MM_PCSPEAKER_WAVEOUT           = 13  ' PC speaker waveform output
%MM_MSFT_WSS_WAVEIN             = 14  ' MS Audio Board waveform input
%MM_MSFT_WSS_WAVEOUT            = 15  ' MS Audio Board waveform output
%MM_MSFT_WSS_FMSYNTH_STEREO     = 16  ' MS Audio Board  Stereo FM synth
%MM_MSFT_WSS_MIXER              = 17  ' MS Audio Board Mixer Driver
%MM_MSFT_WSS_OEM_WAVEIN         = 18  ' MS OEM Audio Board waveform input
%MM_MSFT_WSS_OEM_WAVEOUT        = 19  ' MS OEM Audio Board waveform output
%MM_MSFT_WSS_OEM_FMSYNTH_STEREO = 20  ' MS OEM Audio Board Stereo FM Synth
%MM_MSFT_WSS_AUX                = 21  ' MS Audio Board Aux. Port
%MM_MSFT_WSS_OEM_AUX            = 22  ' MS OEM Audio Aux Port
%MM_MSFT_GENERIC_WAVEIN         = 23  ' MS Vanilla driver waveform input
%MM_MSFT_GENERIC_WAVEOUT        = 24  ' MS Vanilla driver wavefrom output
%MM_MSFT_GENERIC_MIDIIN         = 25  ' MS Vanilla driver MIDI in
%MM_MSFT_GENERIC_MIDIOUT        = 26  ' MS Vanilla driver MIDI  external out
%MM_MSFT_GENERIC_MIDISYNTH      = 27  ' MS Vanilla driver MIDI synthesizer
%MM_MSFT_GENERIC_AUX_LINE       = 28  ' MS Vanilla driver aux (line in)
%MM_MSFT_GENERIC_AUX_MIC        = 29  ' MS Vanilla driver aux (mic)
%MM_MSFT_GENERIC_AUX_CD         = 30  ' MS Vanilla driver aux (CD)
%MM_MSFT_WSS_OEM_MIXER          = 31  ' MS OEM Audio Board Mixer Driver
%MM_MSFT_MSACM                  = 32  ' MS Audio Compression Manager
%MM_MSFT_ACM_MSADPCM            = 33  ' MS ADPCM Codec
%MM_MSFT_ACM_IMAADPCM           = 34  ' IMA ADPCM Codec
%MM_MSFT_ACM_MSFILTER           = 35  ' MS Filter
%MM_MSFT_ACM_GSM610             = 36  ' GSM 610 codec
%MM_MSFT_ACM_G711               = 37  ' G.711 codec
%MM_MSFT_ACM_PCM                = 38  ' PCM converter

' Microsoft Windows Sound System drivers

%MM_WSS_SB16_WAVEIN            = 39   ' Sound Blaster 16 waveform input
%MM_WSS_SB16_WAVEOUT           = 40   ' Sound Blaster 16  waveform output
%MM_WSS_SB16_MIDIIN            = 41   ' Sound Blaster 16 midi-in
%MM_WSS_SB16_MIDIOUT           = 42   ' Sound Blaster 16 midi out
%MM_WSS_SB16_SYNTH             = 43   ' Sound Blaster 16 FM Synthesis
%MM_WSS_SB16_AUX_LINE          = 44   ' Sound Blaster 16 aux (line in)
%MM_WSS_SB16_AUX_CD            = 45   ' Sound Blaster 16 aux (CD)
%MM_WSS_SB16_MIXER             = 46   ' Sound Blaster 16 mixer device
%MM_WSS_SBPRO_WAVEIN           = 47   ' Sound Blaster Pro waveform input
%MM_WSS_SBPRO_WAVEOUT          = 48   ' Sound Blaster Pro waveform output
%MM_WSS_SBPRO_MIDIIN           = 49   ' Sound Blaster Pro midi in
%MM_WSS_SBPRO_MIDIOUT          = 50   ' Sound Blaster Pro midi out
%MM_WSS_SBPRO_SYNTH            = 51   ' Sound Blaster Pro FM synthesis
%MM_WSS_SBPRO_AUX_LINE         = 52   ' Sound Blaster Pro aux (line in )
%MM_WSS_SBPRO_AUX_CD           = 53   ' Sound Blaster Pro aux (CD)
%MM_WSS_SBPRO_MIXER            = 54   ' Sound Blaster Pro mixer

%MM_MSFT_WSS_NT_WAVEIN         = 55   ' WSS NT wave in
%MM_MSFT_WSS_NT_WAVEOUT        = 56   ' WSS NT wave out
%MM_MSFT_WSS_NT_FMSYNTH_STEREO = 57   ' WSS NT FM synth
%MM_MSFT_WSS_NT_MIXER          = 58   ' WSS NT mixer
%MM_MSFT_WSS_NT_AUX            = 59   ' WSS NT aux

%MM_MSFT_SB16_WAVEIN           = 60   ' Sound Blaster 16 waveform input
%MM_MSFT_SB16_WAVEOUT          = 61   ' Sound Blaster 16  waveform output
%MM_MSFT_SB16_MIDIIN           = 62   ' Sound Blaster 16 midi-in
%MM_MSFT_SB16_MIDIOUT          = 63   ' Sound Blaster 16 midi out
%MM_MSFT_SB16_SYNTH            = 64   ' Sound Blaster 16 FM Synthesis
%MM_MSFT_SB16_AUX_LINE         = 65   ' Sound Blaster 16 aux (line in)
%MM_MSFT_SB16_AUX_CD           = 66   ' Sound Blaster 16 aux (CD)
%MM_MSFT_SB16_MIXER            = 67   ' Sound Blaster 16 mixer device
%MM_MSFT_SBPRO_WAVEIN          = 68   ' Sound Blaster Pro waveform input
%MM_MSFT_SBPRO_WAVEOUT         = 69   ' Sound Blaster Pro waveform output
%MM_MSFT_SBPRO_MIDIIN          = 70   ' Sound Blaster Pro midi in
%MM_MSFT_SBPRO_MIDIOUT         = 71   ' Sound Blaster Pro midi out
%MM_MSFT_SBPRO_SYNTH           = 72   ' Sound Blaster Pro FM synthesis
%MM_MSFT_SBPRO_AUX_LINE        = 73   ' Sound Blaster Pro aux (line in )
%MM_MSFT_SBPRO_AUX_CD          = 74   ' Sound Blaster Pro aux (CD)
%MM_MSFT_SBPRO_MIXER           = 75   ' Sound Blaster Pro mixer

%MM_MSFT_MSOPL_SYNTH           = 76   ' Yamaha OPL2/OPL3 compatible FM synthesis

%MM_MSFT_VMDMS_LINE_WAVEIN     = 80   ' Voice Modem Serial Line Wave Input
%MM_MSFT_VMDMS_LINE_WAVEOUT    = 81   ' Voice Modem Serial Line Wave Output
%MM_MSFT_VMDMS_HANDSET_WAVEIN  = 82   ' Voice Modem Serial Handset Wave Input
%MM_MSFT_VMDMS_HANDSET_WAVEOUT = 83   ' Voice Modem Serial Handset Wave Output
%MM_MSFT_VMDMW_LINE_WAVEIN     = 84   ' Voice Modem Wrapper Line Wave Input
%MM_MSFT_VMDMW_LINE_WAVEOUT    = 85   ' Voice Modem Wrapper Line Wave Output
%MM_MSFT_VMDMW_HANDSET_WAVEIN  = 86   ' Voice Modem Wrapper Handset Wave Input
%MM_MSFT_VMDMW_HANDSET_WAVEOUT = 87   ' Voice Modem Wrapper Handset Wave Output
%MM_MSFT_VMDMW_MIXER           = 88   ' Voice Modem Wrapper Mixer
%MM_MSFT_VMDM_GAME_WAVEOUT     = 89   ' Voice Modem Game Compatible Wave Device
%MM_MSFT_VMDM_GAME_WAVEIN      = 90   ' Voice Modem Game Compatible Wave Device

%MM_MSFT_ACM_MSNAUDIO          = 91   '
%MM_MSFT_ACM_MSG723            = 92   '

%MM_MSFT_WDMAUDIO_WAVEOUT      = 100  ' Generic id for WDM Audio drivers
%MM_MSFT_WDMAUDIO_WAVEIN       = 101  ' Generic id for WDM Audio drivers
%MM_MSFT_WDMAUDIO_MIDIOUT      = 102  ' Generic id for WDM Audio drivers
%MM_MSFT_WDMAUDIO_MIDIIN       = 103  ' Generic id for WDM Audio drivers
%MM_MSFT_WDMAUDIO_MIXER        = 104  ' Generic id for WDM Audio drivers


' MM_CREATIVE product IDs
%MM_CREATIVE_SB15_WAVEIN       = 1    ' SB (r) 1.5 waveform input
%MM_CREATIVE_SB20_WAVEIN       = 2
%MM_CREATIVE_SBPRO_WAVEIN      = 3
%MM_CREATIVE_SBP16_WAVEIN      = 4
%MM_CREATIVE_PHNBLST_WAVEIN    = 5
%MM_CREATIVE_SB15_WAVEOUT      = 101
%MM_CREATIVE_SB20_WAVEOUT      = 102
%MM_CREATIVE_SBPRO_WAVEOUT     = 103
%MM_CREATIVE_SBP16_WAVEOUT     = 104
%MM_CREATIVE_PHNBLST_WAVEOUT   = 105
%MM_CREATIVE_MIDIOUT           = 201  ' SB (r)
%MM_CREATIVE_MIDIIN            = 202  ' SB (r)
%MM_CREATIVE_FMSYNTH_MONO      = 301  ' SB (r)
%MM_CREATIVE_FMSYNTH_STEREO    = 302  ' SB Pro (r) stereo synthesizer
%MM_CREATIVE_MIDI_AWE32        = 303
%MM_CREATIVE_AUX_CD            = 401  ' SB Pro (r) aux (CD)
%MM_CREATIVE_AUX_LINE          = 402  ' SB Pro (r) aux (Line in)
%MM_CREATIVE_AUX_MIC           = 403  ' SB Pro (r) aux (mic)
%MM_CREATIVE_AUX_MASTER        = 404
%MM_CREATIVE_AUX_PCSPK         = 405
%MM_CREATIVE_AUX_WAVE          = 406
%MM_CREATIVE_AUX_MIDI          = 407
%MM_CREATIVE_SBPRO_MIXER       = 408
%MM_CREATIVE_SB16_MIXER        = 409

' MM_MEDIAVISION product IDs

' Pro Audio Spectrum
%MM_MEDIAVISION_PROAUDIO      = &H10
%MM_PROAUD_MIDIOUT            = (%MM_MEDIAVISION_PROAUDIO+1)
%MM_PROAUD_MIDIIN             = (%MM_MEDIAVISION_PROAUDIO+2)
%MM_PROAUD_SYNTH              = (%MM_MEDIAVISION_PROAUDIO+3)
%MM_PROAUD_WAVEOUT            = (%MM_MEDIAVISION_PROAUDIO+4)
%MM_PROAUD_WAVEIN             = (%MM_MEDIAVISION_PROAUDIO+5)
%MM_PROAUD_MIXER              = (%MM_MEDIAVISION_PROAUDIO+6)
%MM_PROAUD_AUX                = (%MM_MEDIAVISION_PROAUDIO+7)

' Pro Audio Spectrum 16
%MM_MEDIAVISION_PROAUDIO_16   = &H60
%MM_PROAUD_16_MIDIOUT         = (%MM_MEDIAVISION_PROAUDIO_16+1)
%MM_PROAUD_16_MIDIIN          = (%MM_MEDIAVISION_PROAUDIO_16+2)
%MM_PROAUD_16_SYNTH           = (%MM_MEDIAVISION_PROAUDIO_16+3)
%MM_PROAUD_16_WAVEOUT         = (%MM_MEDIAVISION_PROAUDIO_16+4)
%MM_PROAUD_16_WAVEIN          = (%MM_MEDIAVISION_PROAUDIO_16+5)
%MM_PROAUD_16_MIXER           = (%MM_MEDIAVISION_PROAUDIO_16+6)
%MM_PROAUD_16_AUX             = (%MM_MEDIAVISION_PROAUDIO_16+7)

' Thunder Board
%MM_MEDIAVISION_THUNDER = &H20
%MM_THUNDER_SYNTH       = (%MM_MEDIAVISION_THUNDER+3)
%MM_THUNDER_WAVEOUT     = (%MM_MEDIAVISION_THUNDER+4)
%MM_THUNDER_WAVEIN      = (%MM_MEDIAVISION_THUNDER+5)
%MM_THUNDER_AUX         = (%MM_MEDIAVISION_THUNDER+7)

' Audio Port
%MM_MEDIAVISION_TPORT = &H40
%MM_TPORT_WAVEOUT     = (%MM_MEDIAVISION_TPORT+1)
%MM_TPORT_WAVEIN      = (%MM_MEDIAVISION_TPORT+2)
%MM_TPORT_SYNTH       = (%MM_MEDIAVISION_TPORT+3)

' Pro Audio Spectrum Plus
%MM_MEDIAVISION_PROAUDIO_PLUS = &H50
%MM_PROAUD_PLUS_MIDIOUT       = (%MM_MEDIAVISION_PROAUDIO_PLUS+1)
%MM_PROAUD_PLUS_MIDIIN        = (%MM_MEDIAVISION_PROAUDIO_PLUS+2)
%MM_PROAUD_PLUS_SYNTH         = (%MM_MEDIAVISION_PROAUDIO_PLUS+3)
%MM_PROAUD_PLUS_WAVEOUT       = (%MM_MEDIAVISION_PROAUDIO_PLUS+4)
%MM_PROAUD_PLUS_WAVEIN        = (%MM_MEDIAVISION_PROAUDIO_PLUS+5)
%MM_PROAUD_PLUS_MIXER         = (%MM_MEDIAVISION_PROAUDIO_PLUS+6)
%MM_PROAUD_PLUS_AUX           = (%MM_MEDIAVISION_PROAUDIO_PLUS+7)

' Pro Audio Studio 16
%MM_MEDIAVISION_PROSTUDIO_16 = &H60
%MM_STUDIO_16_MIDIOUT        = (%MM_MEDIAVISION_PROSTUDIO_16+1)
%MM_STUDIO_16_MIDIIN         = (%MM_MEDIAVISION_PROSTUDIO_16+2)
%MM_STUDIO_16_SYNTH          = (%MM_MEDIAVISION_PROSTUDIO_16+3)
%MM_STUDIO_16_WAVEOUT        = (%MM_MEDIAVISION_PROSTUDIO_16+4)
%MM_STUDIO_16_WAVEIN         = (%MM_MEDIAVISION_PROSTUDIO_16+5)
%MM_STUDIO_16_MIXER          = (%MM_MEDIAVISION_PROSTUDIO_16+6)
%MM_STUDIO_16_AUX            = (%MM_MEDIAVISION_PROSTUDIO_16+7)

' CDPC
%MM_MEDIAVISION_CDPC = &H70
%MM_CDPC_MIDIOUT     = (%MM_MEDIAVISION_CDPC+1)
%MM_CDPC_MIDIIN      = (%MM_MEDIAVISION_CDPC+2)
%MM_CDPC_SYNTH       = (%MM_MEDIAVISION_CDPC+3)
%MM_CDPC_WAVEOUT     = (%MM_MEDIAVISION_CDPC+4)
%MM_CDPC_WAVEIN      = (%MM_MEDIAVISION_CDPC+5)
%MM_CDPC_MIXER       = (%MM_MEDIAVISION_CDPC+6)
%MM_CDPC_AUX         = (%MM_MEDIAVISION_CDPC+7)

' Opus MV 1208 Chipsent
%MM_MEDIAVISION_OPUS1208 = &H80
%MM_OPUS401_MIDIOUT      = (%MM_MEDIAVISION_OPUS1208+1)
%MM_OPUS401_MIDIIN       = (%MM_MEDIAVISION_OPUS1208+2)
%MM_OPUS1208_SYNTH       = (%MM_MEDIAVISION_OPUS1208+3)
%MM_OPUS1208_WAVEOUT     = (%MM_MEDIAVISION_OPUS1208+4)
%MM_OPUS1208_WAVEIN      = (%MM_MEDIAVISION_OPUS1208+5)
%MM_OPUS1208_MIXER       = (%MM_MEDIAVISION_OPUS1208+6)
%MM_OPUS1208_AUX         = (%MM_MEDIAVISION_OPUS1208+7)

' Opus MV 1216 chipset
%MM_MEDIAVISION_OPUS1216 = &H90
%MM_OPUS1216_MIDIOUT     = (%MM_MEDIAVISION_OPUS1216+1)
%MM_OPUS1216_MIDIIN      = (%MM_MEDIAVISION_OPUS1216+2)
%MM_OPUS1216_SYNTH       = (%MM_MEDIAVISION_OPUS1216+3)
%MM_OPUS1216_WAVEOUT     = (%MM_MEDIAVISION_OPUS1216+4)
%MM_OPUS1216_WAVEIN      = (%MM_MEDIAVISION_OPUS1216+5)
%MM_OPUS1216_MIXER       = (%MM_MEDIAVISION_OPUS1216+6)
%MM_OPUS1216_AUX         = (%MM_MEDIAVISION_OPUS1216+7)

' MM_ARTISOFT product IDs
%MM_ARTISOFT_SBWAVEIN  = 1       '  Artisoft sounding Board waveform input
%MM_ARTISOFT_SBWAVEOUT = 2       '  Artisoft sounding Board waveform output

' MM_IBM product IDs
%MM_MMOTION_WAVEAUX    = 1       '  IBM M-Motion Auxiliary Device
%MM_MMOTION_WAVEOUT    = 2       '  IBM M-Motion Waveform output
%MM_MMOTION_WAVEIN     = 3       '  IBM M-Motion  Waveform Input
%MM_IBM_PCMCIA_WAVEIN  = 11      '  IBM waveform input
%MM_IBM_PCMCIA_WAVEOUT = 12      '  IBM Waveform output
%MM_IBM_PCMCIA_SYNTH   = 13      '  IBM Midi Synthesis
%MM_IBM_PCMCIA_MIDIIN  = 14      '  IBM external MIDI in
%MM_IBM_PCMCIA_MIDIOUT = 15      '  IBM external MIDI out
%MM_IBM_PCMCIA_AUX     = 16      '  IBM auxiliary control
%MM_IBM_THINKPAD200    = 17
%MM_IBM_MWAVE_WAVEIN   = 18
%MM_IBM_MWAVE_WAVEOUT  = 19
%MM_IBM_MWAVE_MIXER    = 20
%MM_IBM_MWAVE_MIDIIN   = 21
%MM_IBM_MWAVE_MIDIOUT  = 22
%MM_IBM_MWAVE_AUX      = 23
%MM_IBM_WC_MIDIOUT     = 30
%MM_IBM_WC_WAVEOUT     = 31
%MM_IBM_WC_MIXEROUT    = 33

' MM_VOCALTEC product IDs
%MM_VOCALTEC_WAVEOUT = 1
%MM_VOCALTEC_WAVEIN  = 2

' MM_ROLAND product IDs
%MM_ROLAND_RAP10_MIDIOUT  = 10      ' MM_ROLAND_RAP10
%MM_ROLAND_RAP10_MIDIIN   = 11      ' MM_ROLAND_RAP10
%MM_ROLAND_RAP10_SYNTH    = 12      ' MM_ROLAND_RAP10
%MM_ROLAND_RAP10_WAVEOUT  = 13      ' MM_ROLAND_RAP10
%MM_ROLAND_RAP10_WAVEIN   = 14      ' MM_ROLAND_RAP10
%MM_ROLAND_MPU401_MIDIOUT = 15
%MM_ROLAND_MPU401_MIDIIN  = 16
%MM_ROLAND_SMPU_MIDIOUTA  = 17
%MM_ROLAND_SMPU_MIDIOUTB  = 18
%MM_ROLAND_SMPU_MIDIINA   = 19
%MM_ROLAND_SMPU_MIDIINB   = 20
%MM_ROLAND_SC7_MIDIOUT    = 21
%MM_ROLAND_SC7_MIDIIN     = 22
%MM_ROLAND_SERIAL_MIDIOUT = 23
%MM_ROLAND_SERIAL_MIDIIN  = 24
%MM_ROLAND_SCP_MIDIOUT    = 38
%MM_ROLAND_SCP_MIDIIN     = 39
%MM_ROLAND_SCP_WAVEOUT    = 40
%MM_ROLAND_SCP_WAVEIN     = 41
%MM_ROLAND_SCP_MIXER      = 42
%MM_ROLAND_SCP_AUX        = 48

' MM_DSP_SOLUTIONS product IDs
%MM_DSP_SOLUTIONS_WAVEOUT = 1
%MM_DSP_SOLUTIONS_WAVEIN  = 2
%MM_DSP_SOLUTIONS_SYNTH   = 3
%MM_DSP_SOLUTIONS_AUX     = 4

' MM_WANGLABS product IDs
%MM_WANGLABS_WAVEIN1  = 1       '  Input audio wave on CPU board models: Exec 4010, 4030, 3450; PC 251/25c, pc 461/25s , pc 461/33c
%MM_WANGLABS_WAVEOUT1 = 2

' MM_TANDY product IDs
%MM_TANDY_VISWAVEIN       = 1
%MM_TANDY_VISWAVEOUT      = 2
%MM_TANDY_VISBIOSSYNTH    = 3
%MM_TANDY_SENS_MMAWAVEIN  = 4
%MM_TANDY_SENS_MMAWAVEOUT = 5
%MM_TANDY_SENS_MMAMIDIIN  = 6
%MM_TANDY_SENS_MMAMIDIOUT = 7
%MM_TANDY_SENS_VISWAVEOUT = 8
%MM_TANDY_PSSJWAVEIN      = 9
%MM_TANDY_PSSJWAVEOUT     = 10

' product IDs
%MM_INTELOPD_WAVEIN    = 1       '  HID2 WaveAudio Driver
%MM_INTELOPD_WAVEOUT   = 101     '  HID2
%MM_INTELOPD_AUX       = 401     '  HID2 for mixing
%MM_INTEL_NSPMODEMLINE = 501

' MM_INTERACTIVE product IDs
%MM_INTERACTIVE_WAVEIN  = &H45
%MM_INTERACTIVE_WAVEOUT = &H45

' MM_YAMAHA product IDs
%MM_YAMAHA_GSS_SYNTH       = &H01
%MM_YAMAHA_GSS_WAVEOUT     = &H02
%MM_YAMAHA_GSS_WAVEIN      = &H03
%MM_YAMAHA_GSS_MIDIOUT     = &H04
%MM_YAMAHA_GSS_MIDIIN      = &H05
%MM_YAMAHA_GSS_AUX         = &H06
%MM_YAMAHA_SERIAL_MIDIOUT  = &H07
%MM_YAMAHA_SERIAL_MIDIIN   = &H08
%MM_YAMAHA_OPL3SA_WAVEOUT  = &H10
%MM_YAMAHA_OPL3SA_WAVEIN   = &H11
%MM_YAMAHA_OPL3SA_FMSYNTH  = &H12
%MM_YAMAHA_OPL3SA_YSYNTH   = &H13
%MM_YAMAHA_OPL3SA_MIDIOUT  = &H14
%MM_YAMAHA_OPL3SA_MIDIIN   = &H15
%MM_YAMAHA_OPL3SA_MIXER    = &H17
%MM_YAMAHA_OPL3SA_JOYSTICK = &H18

' MM_EVEREX product IDs
%MM_EVEREX_CARRIER = &H01

' MM_ECHO product IDs
%MM_ECHO_SYNTH   = &H01
%MM_ECHO_WAVEOUT = &H02
%MM_ECHO_WAVEIN  = &H03
%MM_ECHO_MIDIOUT = &H04
%MM_ECHO_MIDIIN  = &H05
%MM_ECHO_AUX     = &H06

' MM_SIERRA product IDs
%MM_SIERRA_ARIA_MIDIOUT      = &H14
%MM_SIERRA_ARIA_MIDIIN       = &H15
%MM_SIERRA_ARIA_SYNTH        = &H16
%MM_SIERRA_ARIA_WAVEOUT      = &H17
%MM_SIERRA_ARIA_WAVEIN       = &H18
%MM_SIERRA_ARIA_AUX          = &H19
%MM_SIERRA_ARIA_AUX2         = &H20
%MM_SIERRA_QUARTET_WAVEIN    = &H50
%MM_SIERRA_QUARTET_WAVEOUT   = &H51
%MM_SIERRA_QUARTET_MIDIIN    = &H52
%MM_SIERRA_QUARTET_MIDIOUT   = &H53
%MM_SIERRA_QUARTET_SYNTH     = &H54
%MM_SIERRA_QUARTET_AUX_CD    = &H55
%MM_SIERRA_QUARTET_AUX_LINE  = &H56
%MM_SIERRA_QUARTET_AUX_MODEM = &H57
%MM_SIERRA_QUARTET_MIXER     = &H58

' MM_CAT product IDs
%MM_CAT_WAVEOUT = 1

' MM_DSP_GROUP product IDs
%MM_DSP_GROUP_TRUESPEECH = &H01

' MM_MELABS product IDs
%MM_MELABS_MIDI2GO = &H01

' MM_ESS product IDs
%MM_ESS_AMWAVEOUT       = &H01
%MM_ESS_AMWAVEIN        = &H02
%MM_ESS_AMAUX           = &H03
%MM_ESS_AMSYNTH         = &H04
%MM_ESS_AMMIDIOUT       = &H05
%MM_ESS_AMMIDIIN        = &H06
%MM_ESS_MIXER           = &H07
%MM_ESS_AUX_CD          = &H08
%MM_ESS_MPU401_MIDIOUT  = &H09
%MM_ESS_MPU401_MIDIIN   = &H0A
%MM_ESS_ES488_WAVEOUT   = &H10
%MM_ESS_ES488_WAVEIN    = &H11
%MM_ESS_ES488_MIXER     = &H12
%MM_ESS_ES688_WAVEOUT   = &H13
%MM_ESS_ES688_WAVEIN    = &H14
%MM_ESS_ES688_MIXER     = &H15
%MM_ESS_ES1488_WAVEOUT  = &H16
%MM_ESS_ES1488_WAVEIN   = &H17
%MM_ESS_ES1488_MIXER    = &H18
%MM_ESS_ES1688_WAVEOUT  = &H19
%MM_ESS_ES1688_WAVEIN   = &H1A
%MM_ESS_ES1688_MIXER    = &H1B
%MM_ESS_ES1788_WAVEOUT  = &H1C
%MM_ESS_ES1788_WAVEIN   = &H1D
%MM_ESS_ES1788_MIXER    = &H1E
%MM_ESS_ES1888_WAVEOUT  = &H1F
%MM_ESS_ES1888_WAVEIN   = &H20
%MM_ESS_ES1888_MIXER    = &H21
%MM_ESS_ES1868_WAVEOUT  = &H22
%MM_ESS_ES1868_WAVEIN   = &H23
%MM_ESS_ES1868_MIXER    = &H24
%MM_ESS_ES1878_WAVEOUT  = &H25
%MM_ESS_ES1878_WAVEIN   = &H26
%MM_ESS_ES1878_MIXER    = &H27

' product IDs
%MM_EPS_FMSND = 1

' MM_TRUEVISION product IDs
%MM_TRUEVISION_WAVEIN1  = 1
%MM_TRUEVISION_WAVEOUT1 = 2

' MM_AZTECH product IDs
%MM_AZTECH_MIDIOUT          = 3
%MM_AZTECH_MIDIIN           = 4
%MM_AZTECH_WAVEIN           = 17
%MM_AZTECH_WAVEOUT          = 18
%MM_AZTECH_FMSYNTH          = 20
%MM_AZTECH_MIXER            = 21
%MM_AZTECH_PRO16_WAVEIN     = 33
%MM_AZTECH_PRO16_WAVEOUT    = 34
%MM_AZTECH_PRO16_FMSYNTH    = 38
%MM_AZTECH_DSP16_WAVEIN     = 65
%MM_AZTECH_DSP16_WAVEOUT    = 66
%MM_AZTECH_DSP16_FMSYNTH    = 68
%MM_AZTECH_DSP16_WAVESYNTH  = 70
%MM_AZTECH_NOVA16_WAVEIN    = 71
%MM_AZTECH_NOVA16_WAVEOUT   = 72
%MM_AZTECH_NOVA16_MIXER     = 73
%MM_AZTECH_WASH16_WAVEIN    = 74
%MM_AZTECH_WASH16_WAVEOUT   = 75
%MM_AZTECH_WASH16_MIXER     = 76
%MM_AZTECH_AUX_CD           = 401
%MM_AZTECH_AUX_LINE         = 402
%MM_AZTECH_AUX_MIC          = 403
%MM_AZTECH_AUX              = 404

' MM_VIDEOLOGIC product IDs
%MM_VIDEOLOGIC_MSWAVEIN  = 1
%MM_VIDEOLOGIC_MSWAVEOUT = 2

' MM_KORG product IDs
%MM_KORG_PCIF_MIDIOUT = 1
%MM_KORG_PCIF_MIDIIN  = 2

' MM_APT product IDs
%MM_APT_ACE100CD = 1

' MM_ICS product IDs
%MM_ICS_WAVEDECK_WAVEOUT           = 1     '  MS WSS compatible card and driver
%MM_ICS_WAVEDECK_WAVEIN            = 2
%MM_ICS_WAVEDECK_MIXER             = 3
%MM_ICS_WAVEDECK_AUX               = 4
%MM_ICS_WAVEDECK_SYNTH             = 5
%MM_ICS_WAVEDEC_SB_WAVEOUT         = 6
%MM_ICS_WAVEDEC_SB_WAVEIN          = 7
%MM_ICS_WAVEDEC_SB_FM_MIDIOUT      = 8
%MM_ICS_WAVEDEC_SB_MPU401_MIDIOUT  = 9
%MM_ICS_WAVEDEC_SB_MPU401_MIDIIN   = 10
%MM_ICS_WAVEDEC_SB_MIXER           = 11
%MM_ICS_WAVEDEC_SB_AUX             = 12
%MM_ICS_2115_LITE_MIDIOUT          = 13
%MM_ICS_2120_LITE_MIDIOUT          = 14

' MM_ITERATEDSYS product IDs
%MM_ITERATEDSYS_FUFCODEC = 1

' MM_METHEUS product IDs
%MM_METHEUS_ZIPPER = 1

' MM_WINNOV product IDs
%MM_WINNOV_CAVIAR_WAVEIN    = 1
%MM_WINNOV_CAVIAR_WAVEOUT   = 2
%MM_WINNOV_CAVIAR_VIDC      = 3
%MM_WINNOV_CAVIAR_CHAMPAGNE = 4       '  Fourcc is CHAM
%MM_WINNOV_CAVIAR_YUV8      = 5       '  Fourcc is YUV8

' MM_NCR product IDs
%MM_NCR_BA_WAVEIN  = 1
%MM_NCR_BA_WAVEOUT = 2
%MM_NCR_BA_SYNTH   = 3
%MM_NCR_BA_AUX     = 4
%MM_NCR_BA_MIXER   = 5

' MM_VITEC product IDs
%MM_VITEC_VMAKER = 1
%MM_VITEC_VMPRO  = 2

' MM_MOSCOM product IDs
%MM_MOSCOM_VPC2400_IN  = 1   '  Four Port Voice Processing / Voice Recognition Board
%MM_MOSCOM_VPC2400_OUT = 2   '  VPC2400

' MM_SILICONSOFT product IDs
%MM_SILICONSOFT_SC1_WAVEIN         = 1   ' Waveform in , high sample rate
%MM_SILICONSOFT_SC1_WAVEOUT        = 2   ' Waveform out , high sample rate
%MM_SILICONSOFT_SC2_WAVEIN         = 3   ' Waveform in 2 channels, high sample rate
%MM_SILICONSOFT_SC2_WAVEOUT        = 4   ' Waveform out 2 channels, high sample rate
%MM_SILICONSOFT_SOUNDJR2_WAVEOUT   = 5   ' Waveform out, self powered, efficient
%MM_SILICONSOFT_SOUNDJR2PR_WAVEIN  = 6   ' Waveform in, self powered, efficient
%MM_SILICONSOFT_SOUNDJR2PR_WAVEOUT = 7   ' Waveform out 2 channels, self powered, efficient
%MM_SILICONSOFT_SOUNDJR3_WAVEOUT   = 8   ' Waveform in 2 channels, self powered, efficient

' MM_OLIVETTI product IDs
%MM_OLIVETTI_WAVEIN     = 1
%MM_OLIVETTI_WAVEOUT    = 2
%MM_OLIVETTI_MIXER      = 3
%MM_OLIVETTI_AUX        = 4
%MM_OLIVETTI_MIDIIN     = 5
%MM_OLIVETTI_MIDIOUT    = 6
%MM_OLIVETTI_SYNTH      = 7
%MM_OLIVETTI_JOYSTICK   = 8
%MM_OLIVETTI_ACM_GSM    = 9
%MM_OLIVETTI_ACM_ADPCM  = 10
%MM_OLIVETTI_ACM_CELP   = 11
%MM_OLIVETTI_ACM_SBC    = 12
%MM_OLIVETTI_ACM_OPR    = 13

' MM_IOMAGIC product IDs

'  The I/O Magic Tempo is a PCMCIA Type 2 audio card featuring wave audio
'   record and playback, FM synthesizer, and MIDI output.  The I/O Magic
'   Tempo WaveOut device supports mono and stereo PCM playback at rates
'   of 7350, 11025, 22050, and  44100 samples

%MM_IOMAGIC_TEMPO_WAVEOUT = 1
%MM_IOMAGIC_TEMPO_WAVEIN  = 2
%MM_IOMAGIC_TEMPO_SYNTH   = 3
%MM_IOMAGIC_TEMPO_MIDIOUT = 4
%MM_IOMAGIC_TEMPO_MXDOUT  = 5
%MM_IOMAGIC_TEMPO_AUXOUT  = 6

' MM_MATSUSHITA product IDs
%MM_MATSUSHITA_WAVEIN         = 1
%MM_MATSUSHITA_WAVEOUT        = 2
%MM_MATSUSHITA_FMSYNTH_STEREO = 3
%MM_MATSUSHITA_MIXER          = 4
%MM_MATSUSHITA_AUX            = 5

' MM_NEWMEDIA product IDs
%MM_NEWMEDIA_WAVJAMMER = 1       '  WSS Compatible sound card.

' MM_LYRRUS product IDs

'  Bridge is a MIDI driver that allows the the Lyrrus G-VOX hardware to
'   communicate with Windows base transcription and sequencer applications.
'   The driver also provides a mechanism for the user to configure the system
'   to their personal playing style.

%MM_LYRRUS_BRIDGE_GUITAR = 1

' MM_OPTI product IDs
%MM_OPTI_M16_FMSYNTH_STEREO = &H0001
%MM_OPTI_M16_MIDIIN         = &H0002
%MM_OPTI_M16_MIDIOUT        = &H0003
%MM_OPTI_M16_WAVEIN         = &H0004
%MM_OPTI_M16_WAVEOUT        = &H0005
%MM_OPTI_M16_MIXER          = &H0006
%MM_OPTI_M16_AUX            = &H0007
%MM_OPTI_P16_FMSYNTH_STEREO = &H0010
%MM_OPTI_P16_MIDIIN         = &H0011
%MM_OPTI_P16_MIDIOUT        = &H0012
%MM_OPTI_P16_WAVEIN         = &H0013
%MM_OPTI_P16_WAVEOUT        = &H0014
%MM_OPTI_P16_MIXER          = &H0015
%MM_OPTI_P16_AUX            = &H0016
%MM_OPTI_M32_WAVEIN         = &H0020
%MM_OPTI_M32_WAVEOUT        = &H0021
%MM_OPTI_M32_MIDIIN         = &H0022
%MM_OPTI_M32_MIDIOUT        = &H0023
%MM_OPTI_M32_SYNTH_STEREO   = &H0024
%MM_OPTI_M32_MIXER          = &H0025
%MM_OPTI_M32_AUX            = &H0026

'  Product IDs for     MM_ADDX    -  ADDX
%MM_ADDX_PCTV_DIGITALMIX = 1       ' MM_ADDX_PCTV_DIGITALMIX
%MM_ADDX_PCTV_WAVEIN     = 2       ' MM_ADDX_PCTV_WAVEIN
%MM_ADDX_PCTV_WAVEOUT    = 3       ' MM_ADDX_PCTV_WAVEOUT
%MM_ADDX_PCTV_MIXER      = 4       ' MM_ADDX_PCTV_MIXER
%MM_ADDX_PCTV_AUX_CD     = 5       ' MM_ADDX_PCTV_AUX_CD
%MM_ADDX_PCTV_AUX_LINE   = 6       ' MM_ADDX_PCTV_AUX_LINE

'  Product IDs for     MM_AHEAD    -  Ahead, Inc.
%MM_AHEAD_MULTISOUND   = 1
%MM_AHEAD_SOUNDBLASTER = 2
%MM_AHEAD_PROAUDIO     = 3
%MM_AHEAD_GENERIC      = 4

'  Product IDs for     MM_AMD    -  AMD
%MM_AMD_INTERWAVE_WAVEIN           = 1
%MM_AMD_INTERWAVE_WAVEOUT          = 2
%MM_AMD_INTERWAVE_SYNTH            = 3
%MM_AMD_INTERWAVE_MIXER1           = 4
%MM_AMD_INTERWAVE_MIXER2           = 5
%MM_AMD_INTERWAVE_JOYSTICK         = 6
%MM_AMD_INTERWAVE_EX_CD            = 7
%MM_AMD_INTERWAVE_MIDIIN           = 8
%MM_AMD_INTERWAVE_MIDIOUT          = 9
%MM_AMD_INTERWAVE_AUX1             = 10
%MM_AMD_INTERWAVE_AUX2             = 11
%MM_AMD_INTERWAVE_AUX_MIC          = 12
%MM_AMD_INTERWAVE_AUX_CD           = 13
%MM_AMD_INTERWAVE_MONO_IN          = 14
%MM_AMD_INTERWAVE_MONO_OUT         = 15
%MM_AMD_INTERWAVE_EX_TELEPHONY     = 16
%MM_AMD_INTERWAVE_WAVEOUT_BASE     = 17
%MM_AMD_INTERWAVE_WAVEOUT_TREBLE   = 18
%MM_AMD_INTERWAVE_STEREO_ENHANCED  = 19

'  Product IDs for     MM_AST    -  AST Research Inc.
%MM_AST_MODEMWAVE_WAVEIN  = 13
%MM_AST_MODEMWAVE_WAVEOUT = 14

'  Product IDs for     MM_BROOKTREE    -  Brooktree Corporation
%MM_BTV_WAVEIN          = 1       ' Brooktree PCM Wave Audio In
%MM_BTV_WAVEOUT         = 2       ' Brooktree PCM Wave Audio Out
%MM_BTV_MIDIIN          = 3       ' Brooktree MIDI In
%MM_BTV_MIDIOUT         = 4       ' Brooktree MIDI out
%MM_BTV_MIDISYNTH       = 5       ' Brooktree MIDI FM synth
%MM_BTV_AUX_LINE        = 6       ' Brooktree Line Input
%MM_BTV_AUX_MIC         = 7       ' Brooktree Microphone Input
%MM_BTV_AUX_CD          = 8       ' Brooktree CD Input
%MM_BTV_DIGITALIN       = 9       ' Brooktree PCM Wave in with subcode information
%MM_BTV_DIGITALOUT      = 10      ' Brooktree PCM Wave out with subcode information
%MM_BTV_MIDIWAVESTREAM  = 11      ' Brooktree WaveStream
%MM_BTV_MIXER           = 12      ' Brooktree WSS Mixer driver

'  Product IDs for     MM_CANAM    -  CANAM Computers
%MM_CANAM_CBXWAVEOUT = 1
%MM_CANAM_CBXWAVEIN  = 2

'  Product IDs for     MM_CASIO    -  Casio Computer Co., LTD
%MM_CASIO_WP150_MIDIOUT = 1       ' wp150
%MM_CASIO_WP150_MIDIIN  = 2

'  Product IDs for     MM_COMPAQ    -  Compaq Computer Corp.
%MM_COMPAQ_BB_WAVEIN  = 1
%MM_COMPAQ_BB_WAVEOUT = 2
%MM_COMPAQ_BB_WAVEAUX = 3

'  Product IDs for     MM_COREDYNAMICS    -  Core Dynamics
%MM_COREDYNAMICS_DYNAMIXHR           = 1       ' DynaMax Hi-Rez
%MM_COREDYNAMICS_DYNASONIX_SYNTH     = 2       ' DynaSonix
%MM_COREDYNAMICS_DYNASONIX_MIDI_IN   = 3
%MM_COREDYNAMICS_DYNASONIX_MIDI_OUT  = 4
%MM_COREDYNAMICS_DYNASONIX_WAVE_IN   = 5
%MM_COREDYNAMICS_DYNASONIX_WAVE_OUT  = 6
%MM_COREDYNAMICS_DYNASONIX_AUDIO_IN  = 7
%MM_COREDYNAMICS_DYNASONIX_AUDIO_OUT = 8
%MM_COREDYNAMICS_DYNAGRAFX_VGA       = 9       ' DynaGrfx
%MM_COREDYNAMICS_DYNAGRAFX_WAVE_IN   = 10
%MM_COREDYNAMICS_DYNAGRAFX_WAVE_OUT  = 11

'  Product IDs for     MM_CRYSTAL    -  Crystal Semiconductor Corporation
%MM_CRYSTAL_CS4232_WAVEIN         = 1
%MM_CRYSTAL_CS4232_WAVEOUT        = 2
%MM_CRYSTAL_CS4232_WAVEMIXER      = 3
%MM_CRYSTAL_CS4232_WAVEAUX_AUX1   = 4
%MM_CRYSTAL_CS4232_WAVEAUX_AUX2   = 5
%MM_CRYSTAL_CS4232_WAVEAUX_LINE   = 6
%MM_CRYSTAL_CS4232_WAVEAUX_MONO   = 7
%MM_CRYSTAL_CS4232_WAVEAUX_MASTER = 8
%MM_CRYSTAL_CS4232_MIDIIN         = 9
%MM_CRYSTAL_CS4232_MIDIOUT        = 10
%MM_CRYSTAL_CS4232_INPUTGAIN_AUX1 = 13
%MM_CRYSTAL_CS4232_INPUTGAIN_LOOP = 14

'  Product IDs for     MM_DDD    -  Danka Data Devices
%MM_DDD_MIDILINK_MIDIIN  = 1
%MM_DDD_MIDILINK_MIDIOUT = 2

'  Product IDs for     MM_DIACOUSTICS    -  DiAcoustics, Inc.
%MM_DIACOUSTICS_DRUM_ACTION = 1       ' Drum Action

'  Product IDs for     MM_DIAMONDMM    -  Diamond Multimedia
%MM_DIMD_PLATFORM = 0       ' Freedom Audio
%MM_DIMD_DIRSOUND = 1
%MM_DIMD_VIRTMPU  = 2
%MM_DIMD_VIRTSB   = 3
%MM_DIMD_VIRTJOY  = 4
%MM_DIMD_WAVEIN   = 5
%MM_DIMD_WAVEOUT  = 6
%MM_DIMD_MIDIIN   = 7
%MM_DIMD_MIDIOUT  = 8
%MM_DIMD_AUX_LINE = 9
%MM_DIMD_MIXER    = 10

'  Product IDs for     MM_DIGITAL_AUDIO_LABS    -  Digital Audio Labs, Inc.
%MM_DIGITAL_AUDIO_LABS_V8   = &H10
%MM_DIGITAL_AUDIO_LABS_CPRO = &H11

'  Product IDs for     MM_DIGITAL    -  Digital Equipment Corporation
%MM_DIGITAL_AV320_WAVEIN  = 1       ' Digital Audio Video Compression Board
%MM_DIGITAL_AV320_WAVEOUT = 2       ' Digital Audio Video Compression Board

'  Product IDs for     MM_ECS    -  Electronic Courseware Systems, Inc.
%MM_ECS_AADF_MIDI_IN      = 10
%MM_ECS_AADF_MIDI_OUT     = 11
%MM_ECS_AADF_WAVE2MIDI_IN = 12

'  Product IDs for     MM_ENSONIQ    -  ENSONIQ Corporation
%MM_ENSONIQ_SOUNDSCAPE     = &H10    ' ENSONIQ Soundscape
%MM_SOUNDSCAPE_WAVEOUT     = %MM_ENSONIQ_SOUNDSCAPE+1
%MM_SOUNDSCAPE_WAVEOUT_AUX = %MM_ENSONIQ_SOUNDSCAPE+2
%MM_SOUNDSCAPE_WAVEIN      = %MM_ENSONIQ_SOUNDSCAPE+3
%MM_SOUNDSCAPE_MIDIOUT     = %MM_ENSONIQ_SOUNDSCAPE+4
%MM_SOUNDSCAPE_MIDIIN      = %MM_ENSONIQ_SOUNDSCAPE+5
%MM_SOUNDSCAPE_SYNTH       = %MM_ENSONIQ_SOUNDSCAPE+6
%MM_SOUNDSCAPE_MIXER       = %MM_ENSONIQ_SOUNDSCAPE+7
%MM_SOUNDSCAPE_AUX         = %MM_ENSONIQ_SOUNDSCAPE+8

'  Product IDs for     MM_FRONTIER    -  Frontier Design Group LLC
%MM_FRONTIER_WAVECENTER_MIDIIN  = 1       ' WaveCenter
%MM_FRONTIER_WAVECENTER_MIDIOUT = 2
%MM_FRONTIER_WAVECENTER_WAVEIN  = 3
%MM_FRONTIER_WAVECENTER_WAVEOUT = 4

'  Product IDs for     MM_GADGETLABS    -  Gadget Labs LLC
%MM_GADGETLABS_WAVE44_WAVEIN  = 1
%MM_GADGETLABS_WAVE44_WAVEOUT = 2
%MM_GADGETLABS_WAVE42_WAVEIN  = 3
%MM_GADGETLABS_WAVE42_WAVEOUT = 4
%MM_GADGETLABS_WAVE4_MIDIIN   = 5
%MM_GADGETLABS_WAVE4_MIDIOUT  = 6

'  Product IDs for     MM_KAY_ELEMETRICS    -  Kay Elemetrics, Inc.
%MM_KAY_ELEMETRICS_CSL          = &H4300
%MM_KAY_ELEMETRICS_CSL_DAT      = &H4308
%MM_KAY_ELEMETRICS_CSL_4CHANNEL = &H4309

'  Product IDs for     MM_LERNOUT_AND_HAUSPIE    -  Lernout & Hauspie
%MM_LERNOUT_ANDHAUSPIE_LHCODECACM = 1

'  Product IDs for     MM_MPTUS    -  M.P. Technologies, Inc.
%MM_MPTUS_SPWAVEOUT = 1       ' Sound Pallette

'  Product IDs for     MM_MOTU    -  Mark of the Unicorn
%MM_MOTU_MTP_MIDIOUT_ALL        = 100
%MM_MOTU_MTP_MIDIIN_1           = 101
%MM_MOTU_MTP_MIDIOUT_1          = 101
%MM_MOTU_MTP_MIDIIN_2           = 102
%MM_MOTU_MTP_MIDIOUT_2          = 102
%MM_MOTU_MTP_MIDIIN_3           = 103
%MM_MOTU_MTP_MIDIOUT_3          = 103
%MM_MOTU_MTP_MIDIIN_4           = 104
%MM_MOTU_MTP_MIDIOUT_4          = 104
%MM_MOTU_MTP_MIDIIN_5           = 105
%MM_MOTU_MTP_MIDIOUT_5          = 105
%MM_MOTU_MTP_MIDIIN_6           = 106
%MM_MOTU_MTP_MIDIOUT_6          = 106
%MM_MOTU_MTP_MIDIIN_7           = 107
%MM_MOTU_MTP_MIDIOUT_7          = 107
%MM_MOTU_MTP_MIDIIN_8           = 108
%MM_MOTU_MTP_MIDIOUT_8          = 108

%MM_MOTU_MTPII_MIDIOUT_ALL      = 200
%MM_MOTU_MTPII_MIDIIN_SYNC      = 200
%MM_MOTU_MTPII_MIDIIN_1         = 201
%MM_MOTU_MTPII_MIDIOUT_1        = 201
%MM_MOTU_MTPII_MIDIIN_2         = 202
%MM_MOTU_MTPII_MIDIOUT_2        = 202
%MM_MOTU_MTPII_MIDIIN_3         = 203
%MM_MOTU_MTPII_MIDIOUT_3        = 203
%MM_MOTU_MTPII_MIDIIN_4         = 204
%MM_MOTU_MTPII_MIDIOUT_4        = 204
%MM_MOTU_MTPII_MIDIIN_5         = 205
%MM_MOTU_MTPII_MIDIOUT_5        = 205
%MM_MOTU_MTPII_MIDIIN_6         = 206
%MM_MOTU_MTPII_MIDIOUT_6        = 206
%MM_MOTU_MTPII_MIDIIN_7         = 207
%MM_MOTU_MTPII_MIDIOUT_7        = 207
%MM_MOTU_MTPII_MIDIIN_8         = 208
%MM_MOTU_MTPII_MIDIOUT_8        = 208
%MM_MOTU_MTPII_NET_MIDIIN_1     = 209
%MM_MOTU_MTPII_NET_MIDIOUT_1    = 209
%MM_MOTU_MTPII_NET_MIDIIN_2     = 210
%MM_MOTU_MTPII_NET_MIDIOUT_2    = 210
%MM_MOTU_MTPII_NET_MIDIIN_3     = 211
%MM_MOTU_MTPII_NET_MIDIOUT_3    = 211
%MM_MOTU_MTPII_NET_MIDIIN_4     = 212
%MM_MOTU_MTPII_NET_MIDIOUT_4    = 212
%MM_MOTU_MTPII_NET_MIDIIN_5     = 213
%MM_MOTU_MTPII_NET_MIDIOUT_5    = 213
%MM_MOTU_MTPII_NET_MIDIIN_6     = 214
%MM_MOTU_MTPII_NET_MIDIOUT_6    = 214
%MM_MOTU_MTPII_NET_MIDIIN_7     = 215
%MM_MOTU_MTPII_NET_MIDIOUT_7    = 215
%MM_MOTU_MTPII_NET_MIDIIN_8     = 216
%MM_MOTU_MTPII_NET_MIDIOUT_8    = 216

%MM_MOTU_MXP_MIDIIN_MIDIOUT_ALL = 300
%MM_MOTU_MXP_MIDIIN_SYNC        = 300
%MM_MOTU_MXP_MIDIIN_MIDIIN_1    = 301
%MM_MOTU_MXP_MIDIIN_MIDIOUT_1   = 301
%MM_MOTU_MXP_MIDIIN_MIDIIN_2    = 302
%MM_MOTU_MXP_MIDIIN_MIDIOUT_2   = 302
%MM_MOTU_MXP_MIDIIN_MIDIIN_3    = 303
%MM_MOTU_MXP_MIDIIN_MIDIOUT_3   = 303
%MM_MOTU_MXP_MIDIIN_MIDIIN_4    = 304
%MM_MOTU_MXP_MIDIIN_MIDIOUT_4   = 304
%MM_MOTU_MXP_MIDIIN_MIDIIN_5    = 305
%MM_MOTU_MXP_MIDIIN_MIDIOUT_5   = 305
%MM_MOTU_MXP_MIDIIN_MIDIIN_6    = 306
%MM_MOTU_MXP_MIDIIN_MIDIOUT_6   = 306

%MM_MOTU_MXPMPU_MIDIOUT_ALL     = 400
%MM_MOTU_MXPMPU_MIDIIN_SYNC     = 400
%MM_MOTU_MXPMPU_MIDIIN_1        = 401
%MM_MOTU_MXPMPU_MIDIOUT_1       = 401
%MM_MOTU_MXPMPU_MIDIIN_2        = 402
%MM_MOTU_MXPMPU_MIDIOUT_2       = 402
%MM_MOTU_MXPMPU_MIDIIN_3        = 403
%MM_MOTU_MXPMPU_MIDIOUT_3       = 403
%MM_MOTU_MXPMPU_MIDIIN_4        = 404
%MM_MOTU_MXPMPU_MIDIOUT_4       = 404
%MM_MOTU_MXPMPU_MIDIIN_5        = 405
%MM_MOTU_MXPMPU_MIDIOUT_5       = 405
%MM_MOTU_MXPMPU_MIDIIN_6        = 406
%MM_MOTU_MXPMPU_MIDIOUT_6       = 406

%MM_MOTU_MXN_MIDIOUT_ALL        = 500
%MM_MOTU_MXN_MIDIIN_SYNC        = 500
%MM_MOTU_MXN_MIDIIN_1           = 501
%MM_MOTU_MXN_MIDIOUT_1          = 501
%MM_MOTU_MXN_MIDIIN_2           = 502
%MM_MOTU_MXN_MIDIOUT_2          = 502
%MM_MOTU_MXN_MIDIIN_3           = 503
%MM_MOTU_MXN_MIDIOUT_3          = 503
%MM_MOTU_MXN_MIDIIN_4           = 504
%MM_MOTU_MXN_MIDIOUT_4          = 504

%MM_MOTU_FLYER_MIDI_IN_SYNC     = 600
%MM_MOTU_FLYER_MIDI_IN_A        = 601
%MM_MOTU_FLYER_MIDI_OUT_A       = 601
%MM_MOTU_FLYER_MIDI_IN_B        = 602
%MM_MOTU_FLYER_MIDI_OUT_B       = 602

%MM_MOTU_PKX_MIDI_IN_SYNC       = 700
%MM_MOTU_PKX_MIDI_IN_A          = 701
%MM_MOTU_PKX_MIDI_OUT_A         = 701
%MM_MOTU_PKX_MIDI_IN_B          = 702
%MM_MOTU_PKX_MIDI_OUT_B         = 702

%MM_MOTU_DTX_MIDI_IN_SYNC       = 800
%MM_MOTU_DTX_MIDI_IN_A          = 801
%MM_MOTU_DTX_MIDI_OUT_A         = 801
%MM_MOTU_DTX_MIDI_IN_B          = 802
%MM_MOTU_DTX_MIDI_OUT_B         = 802

%MM_MOTU_MTPAV_MIDIOUT_ALL      = 900
%MM_MOTU_MTPAV_MIDIIN_SYNC      = 900
%MM_MOTU_MTPAV_MIDIIN_1         = 901
%MM_MOTU_MTPAV_MIDIOUT_1        = 901
%MM_MOTU_MTPAV_MIDIIN_2         = 902
%MM_MOTU_MTPAV_MIDIOUT_2        = 902
%MM_MOTU_MTPAV_MIDIIN_3         = 903
%MM_MOTU_MTPAV_MIDIOUT_3        = 903
%MM_MOTU_MTPAV_MIDIIN_4         = 904
%MM_MOTU_MTPAV_MIDIOUT_4        = 904
%MM_MOTU_MTPAV_MIDIIN_5         = 905
%MM_MOTU_MTPAV_MIDIOUT_5        = 905
%MM_MOTU_MTPAV_MIDIIN_6         = 906
%MM_MOTU_MTPAV_MIDIOUT_6        = 906
%MM_MOTU_MTPAV_MIDIIN_7         = 907
%MM_MOTU_MTPAV_MIDIOUT_7        = 907
%MM_MOTU_MTPAV_MIDIIN_8         = 908
%MM_MOTU_MTPAV_MIDIOUT_8        = 908
%MM_MOTU_MTPAV_NET_MIDIIN_1     = 909
%MM_MOTU_MTPAV_NET_MIDIOUT_1    = 909
%MM_MOTU_MTPAV_NET_MIDIIN_2     = 910
%MM_MOTU_MTPAV_NET_MIDIOUT_2    = 910
%MM_MOTU_MTPAV_NET_MIDIIN_3     = 911
%MM_MOTU_MTPAV_NET_MIDIOUT_3    = 911
%MM_MOTU_MTPAV_NET_MIDIIN_4     = 912
%MM_MOTU_MTPAV_NET_MIDIOUT_4    = 912
%MM_MOTU_MTPAV_NET_MIDIIN_5     = 913
%MM_MOTU_MTPAV_NET_MIDIOUT_5    = 913
%MM_MOTU_MTPAV_NET_MIDIIN_6     = 914
%MM_MOTU_MTPAV_NET_MIDIOUT_6    = 914
%MM_MOTU_MTPAV_NET_MIDIIN_7     = 915
%MM_MOTU_MTPAV_NET_MIDIOUT_7    = 915
%MM_MOTU_MTPAV_NET_MIDIIN_8     = 916
%MM_MOTU_MTPAV_NET_MIDIOUT_8    = 916
%MM_MOTU_MTPAV_MIDIIN_ADAT      = 917
%MM_MOTU_MTPAV_MIDIOUT_ADAT     = 917


'  Product IDs for     MM_MIRO    -  miro Computer Products AG
%MM_MIRO_MOVIEPRO     = 1       ' miroMOVIE pro
%MM_MIRO_VIDEOD1      = 2       ' miroVIDEO D1
%MM_MIRO_VIDEODC1TV   = 3       ' miroVIDEO DC1 tv
%MM_MIRO_VIDEOTD      = 4       ' miroVIDEO 10/20 TD
%MM_MIRO_DC30_WAVEOUT = 5
%MM_MIRO_DC30_WAVEIN  = 6
%MM_MIRO_DC30_MIX     = 7

'  Product IDs for     MM_NEC    -  NEC
%MM_NEC_73_86_SYNTH    = 5
%MM_NEC_73_86_WAVEOUT  = 6
%MM_NEC_73_86_WAVEIN   = 7
%MM_NEC_26_SYNTH       = 9
%MM_NEC_MPU401_MIDIOUT = 10
%MM_NEC_MPU401_MIDIIN  = 11
%MM_NEC_JOYSTICK       = 12

'  Product IDs for     MM_NORRIS    -  Norris Communications, Inc.
%MM_NORRIS_VOICELINK = 1

'  Product IDs for     MM_NORTHERN_TELECOM    -  Northern Telecom Limited
%MM_NORTEL_MPXAC_WAVEIN  = 1       '  MPX Audio Card Wave Input Device
%MM_NORTEL_MPXAC_WAVEOUT = 2       ' MPX Audio Card Wave Output Device

'  Product IDs for     MM_NVIDIA    -  NVidia Corporation
%MM_NVIDIA_WAVEOUT  = 1
%MM_NVIDIA_WAVEIN   = 2
%MM_NVIDIA_MIDIOUT  = 3
%MM_NVIDIA_MIDIIN   = 4
%MM_NVIDIA_GAMEPORT = 5
%MM_NVIDIA_MIXER    = 6
%MM_NVIDIA_AUX      = 7

'  Product IDs for     MM_OKSORI    -  OKSORI Co., Ltd.
%MM_OKSORI_BASE           = 0                   ' Oksori Base
%MM_OKSORI_OSR8_WAVEOUT   = %MM_OKSORI_BASE+1   ' Oksori 8bit Wave out
%MM_OKSORI_OSR8_WAVEIN    = %MM_OKSORI_BASE+2   ' Oksori 8bit Wave in
%MM_OKSORI_OSR16_WAVEOUT  = %MM_OKSORI_BASE+3   ' Oksori 16 bit Wave out
%MM_OKSORI_OSR16_WAVEIN   = %MM_OKSORI_BASE+4   ' Oksori 16 bit Wave in
%MM_OKSORI_FM_OPL4        = %MM_OKSORI_BASE+5   ' Oksori FM Synth Yamaha OPL4
%MM_OKSORI_MIX_MASTER     = %MM_OKSORI_BASE+6   ' Oksori DSP Mixer - Master Volume
%MM_OKSORI_MIX_WAVE       = %MM_OKSORI_BASE+7   ' Oksori DSP Mixer - Wave Volume
%MM_OKSORI_MIX_FM         = %MM_OKSORI_BASE+8   ' Oksori DSP Mixer - FM Volume
%MM_OKSORI_MIX_LINE       = %MM_OKSORI_BASE+9   ' Oksori DSP Mixer - Line Volume
%MM_OKSORI_MIX_CD         = %MM_OKSORI_BASE+10  ' Oksori DSP Mixer - CD Volume
%MM_OKSORI_MIX_MIC        = %MM_OKSORI_BASE+11  ' Oksori DSP Mixer - MIC Volume
%MM_OKSORI_MIX_ECHO       = %MM_OKSORI_BASE+12  ' Oksori DSP Mixer - Echo Volume
%MM_OKSORI_MIX_AUX1       = %MM_OKSORI_BASE+13  ' Oksori AD1848 - AUX1 Volume
%MM_OKSORI_MIX_LINE1      = %MM_OKSORI_BASE+14  ' Oksori AD1848 - LINE1 Volume
%MM_OKSORI_EXT_MIC1       = %MM_OKSORI_BASE+15  ' Oksori External - One Mic Connect
%MM_OKSORI_EXT_MIC2       = %MM_OKSORI_BASE+16  ' Oksori External - Two Mic Connect
%MM_OKSORI_MIDIOUT        = %MM_OKSORI_BASE+17  ' Oksori MIDI Out Device
%MM_OKSORI_MIDIIN         = %MM_OKSORI_BASE+18  ' Oksori MIDI In Device
%MM_OKSORI_MPEG_CDVISION  = %MM_OKSORI_BASE+19  ' Oksori CD-Vision MPEG Decoder

'  Product IDs for     MM_OSITECH    -  Ositech Communications Inc.
%MM_OSITECH_TRUMPCARD = 1       ' Trumpcard

'  Product IDs for     MM_OSPREY    -  Osprey Technologies, Inc.
%MM_OSPREY_1000WAVEIN  = 1
%MM_OSPREY_1000WAVEOUT = 2

'  Product IDs for     MM_QUARTERDECK    -  Quarterdeck Corporation
%MM_QUARTERDECK_LHWAVEIN  = 0      ' Quarterdeck L&H Codec Wave In
%MM_QUARTERDECK_LHWAVEOUT = 1      ' Quarterdeck L&H Codec Wave Out

'  Product IDs for     MM_RHETOREX    -  Rhetorex Inc
%MM_RHETOREX_WAVEIN  = 1
%MM_RHETOREX_WAVEOUT = 2

'  Product IDs for     MM_ROCKWELL    -  Rockwell International
%MM_VOICEMIXER = 1
%ROCKWELL_WA1_WAVEIN     = 100
%ROCKWELL_WA1_WAVEOUT    = 101
%ROCKWELL_WA1_SYNTH      = 102
%ROCKWELL_WA1_MIXER      = 103
%ROCKWELL_WA1_MPU401_IN  = 104
%ROCKWELL_WA1_MPU401_OUT = 105
%ROCKWELL_WA2_WAVEIN     = 200
%ROCKWELL_WA2_WAVEOUT    = 201
%ROCKWELL_WA2_SYNTH      = 202
%ROCKWELL_WA2_MIXER      = 203
%ROCKWELL_WA2_MPU401_IN  = 204
%ROCKWELL_WA2_MPU401_OUT = 205

'  Product IDs for     MM_S3    -  S3
%MM_S3_WAVEOUT = &H1
%MM_S3_WAVEIN  = &H2
%MM_S3_MIDIOUT = &H3
%MM_S3_MIDIIN  = &H4
%MM_S3_FMSYNTH = &H5
%MM_S3_MIXER   = &H6
%MM_S3_AUX     = &H7

'  Product IDs for     MM_SEERSYS    -  Seer Systems, Inc.
%MM_SEERSYS_SEERSYNTH = 1
%MM_SEERSYS_SEERWAVE  = 2
%MM_SEERSYS_SEERMIX   = 3

'  Product IDs for     MM_SOFTSOUND    -  Softsound, Ltd.
%MM_SOFTSOUND_CODEC = 1

'  Product IDs for     MM_SOUNDESIGNS    -  SounDesignS M.C.S. Ltd.
%MM_SOUNDESIGNS_WAVEIN  = 1
%MM_SOUNDESIGNS_WAVEOUT = 2

'  Product IDs for     MM_SPECTRUM_SIGNAL_PROCESSING    -  Spectrum Signal Processing, Inc.
%MM_SSP_SNDFESWAVEIN   = 1   ' Sound Festa Wave In Device
%MM_SSP_SNDFESWAVEOUT  = 2   ' Sound Festa Wave Out Device
%MM_SSP_SNDFESMIDIIN   = 3   ' Sound Festa MIDI In Device
%MM_SSP_SNDFESMIDIOUT  = 4   ' Sound Festa MIDI Out Device
%MM_SSP_SNDFESSYNTH    = 5   ' Sound Festa MIDI Synth Device
%MM_SSP_SNDFESMIX      = 6   ' Sound Festa Mixer Device
%MM_SSP_SNDFESAUX      = 7   ' Sound Festa Auxilliary Device

'  Product IDs for     MM_TDK    -  TDK Corporation
%MM_TDK_MW_MIDI_SYNTH   = 1
%MM_TDK_MW_MIDI_IN      = 2
%MM_TDK_MW_MIDI_OUT     = 3
%MM_TDK_MW_WAVE_IN      = 4
%MM_TDK_MW_WAVE_OUT     = 5
%MM_TDK_MW_AUX          = 6
%MM_TDK_MW_MIXER        = 10
%MM_TDK_MW_AUX_MASTER   = 100
%MM_TDK_MW_AUX_BASS     = 101
%MM_TDK_MW_AUX_TREBLE   = 102
%MM_TDK_MW_AUX_MIDI_VOL = 103
%MM_TDK_MW_AUX_WAVE_VOL = 104
%MM_TDK_MW_AUX_WAVE_RVB = 105
%MM_TDK_MW_AUX_WAVE_CHR = 106
%MM_TDK_MW_AUX_VOL      = 107
%MM_TDK_MW_AUX_RVB      = 108
%MM_TDK_MW_AUX_CHR      = 109

'  Product IDs for     MM_TURTLE_BEACH    -  Turtle Beach, Inc.
%MM_TBS_TROPEZ_WAVEIN  = 37
%MM_TBS_TROPEZ_WAVEOUT = 38
%MM_TBS_TROPEZ_AUX1    = 39
%MM_TBS_TROPEZ_AUX2    = 40
%MM_TBS_TROPEZ_LINE    = 41

'  Product IDs for     MM_VIENNASYS    -  Vienna Systems
%MM_VIENNASYS_TSP_WAVE_DRIVER = 1

'  Product IDs for     MM_VIONA    -  Viona Development GmbH
%MM_VIONA_QVINPCI_MIXER    = 1       ' Q-Motion PCI II/Bravado 2000
%MM_VIONA_QVINPCI_WAVEIN   = 2
%MM_VIONAQVINPCI_WAVEOUT   = 3
%MM_VIONA_BUSTER_MIXER     = 4       ' Buster
%MM_VIONA_CINEMASTER_MIXER = 5       ' Cinemaster
%MM_VIONA_CONCERTO_MIXER   = 6       ' Concerto

'  Product IDs for     MM_WILDCAT    -  Wildcat Canyon Software
%MM_WILDCAT_AUTOSCOREMIDIIN = 1       ' Autoscore

'  Product IDs for     MM_WILLOWPOND    -  Willow Pond Corporation
%MM_WILLOWPOND_FMSYNTH_STEREO  = 20
%MM_WILLOWPOND_SNDPORT_WAVEIN  = 100
%MM_WILLOWPOND_SNDPORT_WAVEOUT = 101
%MM_WILLOWPOND_SNDPORT_MIXER   = 102
%MM_WILLOWPOND_SNDPORT_AUX     = 103
%MM_WILLOWPOND_PH_WAVEIN       = 104
%MM_WILLOWPOND_PH_WAVEOUT      = 105
%MM_WILLOWPOND_PH_MIXER        = 106
%MM_WILLOWPOND_PH_AUX          = 107

'  Product IDs for     MM_WORKBIT    -  Workbit Corporation
%MM_WORKBIT_MIXER    = 1      ' Harmony Mixer
%MM_WORKBIT_WAVEOUT  = 2      ' Harmony Mixer
%MM_WORKBIT_WAVEIN   = 3      ' Harmony Mixer
%MM_WORKBIT_MIDIIN   = 4      ' Harmony Mixer
%MM_WORKBIT_MIDIOUT  = 5      ' Harmony Mixer
%MM_WORKBIT_FMSYNTH  = 6      ' Harmony Mixer
%MM_WORKBIT_AUX      = 7      ' Harmony Mixer
%MM_WORKBIT_JOYSTICK = 8

'  Product IDs for     MM_FRAUNHOFER_IIS -  Fraunhofer
%MM_FHGIIS_MPEGLAYER3 = 10

#ENDIF ' #IF NOT %DEF(%NOMMIDS) -----------------------------------------------

' End of constants from mmreg.h ===============================================

' Constants from wingdi.h =====================================================

#IF NOT %DEF(%NOGDI) '---------------------------------------------------------

' Binary raster ops
%R2_BLACK       = 1  '   0
%R2_NOTMERGEPEN = 2  '  DPon
%R2_MASKNOTPEN  = 3  '  DPna
%R2_NOTCOPYPEN  = 4  '  PN
%R2_MASKPENNOT  = 5  '  PDna
%R2_NOT         = 6  '  Dn
%R2_XORPEN      = 7  '  DPx
%R2_NOTMASKPEN  = 8  '  DPan
%R2_MASKPEN     = 9  '  DPa
%R2_NOTXORPEN   = 10 '  DPxn
%R2_NOP         = 11 '  D
%R2_MERGENOTPEN = 12 '  DPno
%R2_COPYPEN     = 13 '  P
%R2_MERGEPENNOT = 14 '  PDno
%R2_MERGEPEN    = 15 '  DPo
%R2_WHITE       = 16 '   1
%R2_LAST        = 16

'  Ternary raster operations
%SRCCOPY     = &H00CC0020 ' (DWORD) dest = source
%SRCPAINT    = &H00EE0086 ' (DWORD) dest = source OR dest
%SRCAND      = &H008800C6 ' (DWORD) dest = source AND dest
%SRCINVERT   = &H00660046 ' (DWORD) dest = source XOR dest
%SRCERASE    = &H00440328 ' (DWORD) dest = source AND (NOT dest )
%NOTSRCCOPY  = &H00330008 ' (DWORD) dest = (NOT source)
%NOTSRCERASE = &H001100A6 ' (DWORD) dest = (NOT src) AND (NOT dest)
%MERGECOPY   = &H00C000CA ' (DWORD) dest = (source AND pattern)
%MERGEPAINT  = &H00BB0226 ' (DWORD) dest = (NOT source) OR dest
%PATCOPY     = &H00F00021 ' (DWORD) dest = pattern
%PATPAINT    = &H00FB0A09 ' (DWORD) dest = DPSnoo
%PATINVERT   = &H005A0049 ' (DWORD) dest = pattern XOR dest
%DSTINVERT   = &H00550009 ' (DWORD) dest = (NOT dest)
%BLACKNESS   = &H00000042 ' (DWORD) dest = BLACK
%WHITENESS   = &H00FF0062 ' (DWORD) dest = WHITE

%GDI_ERROR   = &HFFFFFFFF
%HGDI_ERROR  = &HFFFFFFFF???

' Region Flags
%ERRORAPI      = 0
%NULLREGION    = 1
%SIMPLEREGION  = 2
%COMPLEXREGION = 3

' CombineRgn() Styles
%RGN_AND  = 1
%RGN_OR   = 2
%RGN_XOR  = 3
%RGN_DIFF = 4
%RGN_COPY = 5
%RGN_MIN  = %RGN_AND
%RGN_MAX  = %RGN_COPY

' StretchBlt() Modes
%BLACKONWHITE      = 1
%WHITEONBLACK      = 2
%COLORONCOLOR      = 3
%HALFTONE          = 4
%MAXSTRETCHBLTMODE = 4

' New StretchBlt() Modes
%STRETCH_ANDSCANS    = %BLACKONWHITE
%STRETCH_ORSCANS     = %WHITEONBLACK
%STRETCH_DELETESCANS = %COLORONCOLOR
%STRETCH_HALFTONE    = %HALFTONE

' PolyFill() Modes
%ALTERNATE     = 1
%WINDING       = 2
%POLYFILL_LAST = 2

' Text Alignment Options
%TA_NOUPDATECP = 0
%TA_UPDATECP   = 1

%TA_LEFT       = 0
%TA_RIGHT      = 2
%TA_CENTER     = 6

%TA_TOP        = 0
%TA_BOTTOM     = 8
%TA_BASELINE   = 24
%TA_RTLREADING = 256
%TA_MASK       = %TA_BASELINE + %TA_CENTER + %TA_UPDATECP + %TA_RTLREADING

%VTA_BASELINE  = %TA_BASELINE
%VTA_LEFT      = %TA_BOTTOM
%VTA_RIGHT     = %TA_TOP
%VTA_CENTER    = %TA_CENTER
%VTA_BOTTOM    = %TA_RIGHT
%VTA_TOP       = %TA_LEFT

%ETO_GRAYED         = 1
%ETO_OPAQUE         = 2
%ETO_CLIPPED        = 4
%ETO_GLYPH_INDEX    = &H0010
%ETO_RTLREADING     = &H0080
%ETO_NUMERICSLOCAL  = &H0400
%ETO_NUMERICSLATIN  = &H0800
%ETO_IGNORELANGUAGE = &H1000
%ETO_PDY            = &H2000

%ASPECT_FILTERING = &H0001

' Bounds Accumulation APIs
'
%DCB_RESET      = &H0001
%DCB_ACCUMULATE = &H0002
%DCB_DIRTY      = %DCB_ACCUMULATE
%DCB_SET        = %DCB_RESET OR %DCB_ACCUMULATE
%DCB_ENABLE     = &H0004
%DCB_DISABLE    = &H0008

' Metafile Functions
%META_SETBKCOLOR            = &H201
%META_SETBKMODE             = &H102
%META_SETMAPMODE            = &H103
%META_SETROP2               = &H104
%META_SETRELABS             = &H105
%META_SETPOLYFILLMODE       = &H106
%META_SETSTRETCHBLTMODE     = &H107
%META_SETTEXTCHAREXTRA      = &H108
%META_SETTEXTCOLOR          = &H209
%META_SETTEXTJUSTIFICATION  = &H20A
%META_SETWINDOWORG          = &H20B
%META_SETWINDOWEXT          = &H20C
%META_SETVIEWPORTORG        = &H20D
%META_SETVIEWPORTEXT        = &H20E
%META_OFFSETWINDOWORG       = &H20F
%META_SCALEWINDOWEXT        = &H410
%META_OFFSETVIEWPORTORG     = &H211
%META_SCALEVIEWPORTEXT      = &H412
%META_LINETO                = &H213
%META_MOVETO                = &H214
%META_EXCLUDECLIPRECT       = &H415
%META_INTERSECTCLIPRECT     = &H416
%META_ARC                   = &H817
%META_ELLIPSE               = &H418
%META_FLOODFILL             = &H419
%META_PIE                   = &H81A
%META_RECTANGLE             = &H41B
%META_ROUNDRECT             = &H61C
%META_PATBLT                = &H61D
%META_SAVEDC                = &H01E
%META_SETPIXEL              = &H41F
%META_OFFSETCLIPRGN         = &H220
%META_TEXTOUT               = &H521
%META_BITBLT                = &H922
%META_STRETCHBLT            = &HB23
%META_POLYGON               = &H324
%META_POLYLINE              = &H325
%META_ESCAPE                = &H626
%META_RESTOREDC             = &H127
%META_FILLREGION            = &H228
%META_FRAMEREGION           = &H429
%META_INVERTREGION          = &H12A
%META_PAINTREGION           = &H12B
%META_SELECTCLIPREGION      = &H12C
%META_SELECTOBJECT          = &H12D
%META_SETTEXTALIGN          = &H12E
%META_CHORD                 = &H830
%META_SETMAPPERFLAGS        = &H231
%META_EXTTEXTOUT            = &HA32
%META_SETDIBTODEV           = &HD33
%META_SELECTPALETTE         = &H234
%META_REALIZEPALETTE        = &H035
%META_ANIMATEPALETTE        = &H436
%META_SETPALENTRIES         = &H037
%META_POLYPOLYGON           = &H538
%META_RESIZEPALETTE         = &H139
%META_DIBBITBLT             = &H940
%META_DIBSTRETCHBLT         = &HB41
%META_DIBCREATEPATTERNBRUSH = &H142
%META_STRETCHDIB            = &HF43
%META_EXTFLOODFILL          = &H548
%META_DELETEOBJECT          = &H1F0
%META_CREATEPALETTE         = &H0F7
%META_CREATEPATTERNBRUSH    = &H1F9
%META_CREATEPENINDIRECT     = &H2FA
%META_CREATEFONTINDIRECT    = &H2FB
%META_CREATEBRUSHINDIRECT   = &H2FC
%META_CREATEREGION          = &H6FF


' GDI Escapes
%NEWFRAME            = 1
%AbortDocC           = 2
%NEXTBAND            = 3
%SETCOLORTABLE       = 4
%GETCOLORTABLE       = 5
%FLUSHOUTPUT         = 6
%DRAFTMODE           = 7
%QUERYESCSUPPORT     = 8
%SETABORTPROC        = 9
%StartDocC           = 10
%EndDocC             = 11
%GETPHYSPAGESIZE     = 12
%GETPRINTINGOFFSET   = 13
%GETSCALINGFACTOR    = 14
%MFCOMMENT           = 15
%GETPENWIDTH         = 16
%SETCOPYCOUNT        = 17
%SELECTPAPERSOURCE   = 18
%DEVICEDATA          = 19
%PASSTHROUGH         = 19
%GETTECHNOLGY        = 20
%GETTECHNOLOGY       = 20
%SETLINECAP          = 21
%SETLINEJOIN         = 22
%SetMiterLimitC      = 23
%BANDINFO            = 24
%DRAWPATTERNRECT     = 25
%GETVECTORPENSIZE    = 26
%GETVECTORBRUSHSIZE  = 27
%ENABLEDUPLEX        = 28
%GETSETPAPERBINS     = 29
%GETSETPRINTORIENT   = 30
%ENUMPAPERBINS       = 31
%SETDIBSCALING       = 32
%EPSPRINTING         = 33
%ENUMPAPERMETRICS    = 34
%GETSETPAPERMETRICS  = 35
%POSTSCRIPT_DATA     = 37
%POSTSCRIPT_IGNORE   = 38
%MOUSETRAILS         = 39
%GETDEVICEUNITS      = 42

%GETEXTENDEDTEXTMETRICS = 256
%GETEXTENTTABLE         = 257
%GETPAIRKERNTABLE       = 258
%GETTRACKKERNTABLE      = 259
%ExtTextOutC            = 512
%GETFACENAME            = 513
%DOWNLOADFACE           = 514
%ENABLERELATIVEWIDTHS   = 768
%ENABLEPAIRKERNING      = 769
%SETKERNTRACK           = 770
%SETALLJUSTVALUES       = 771
%SETCHARSET             = 772

%STRETCHBLTC            = 2048  ' STRETCHBLT constant conflicted with STRETCHBLT function
%GETSETSCREENPARAMS     = 3072
%QUERYDIBSUPPORT        = 3073
%BEGIN_PATH             = 4096
%CLIP_TO_PATH           = 4097
%END_PATH               = 4098
%EXT_DEVICE_CAPS        = 4099
%RESTORE_CTM            = 4100
%SAVE_CTM               = 4101
%SET_ARC_DIRECTION      = 4102
%SET_BACKGROUND_COLOR   = 4103
%SET_POLY_MODE          = 4104
%SET_SCREEN_ANGLE       = 4105
%SET_SPREAD             = 4106
%TRANSFORM_CTM          = 4107
%SET_CLIP_BOX           = 4108
%SET_BOUNDS             = 4109
%SET_MIRROR_MODE        = 4110
%OPENCHANNEL            = 4110
%DOWNLOADHEADER         = 4111
%CLOSECHANNEL           = 4112
%POSTSCRIPT_PASSTHROUGH = 4115
%ENCAPSULATED_POSTSCRIPT= 4116

%POSTSCRIPT_IDENTIFY    = 4117   ' new escape for NT5 pscript driver
%POSTSCRIPT_INJECTION   = 4118   ' new escape for NT5 pscript driver

' Parameters for POSTSCRIPT_IDENTIFY escape
'
%PSIDENT_GDICENTRIC = 0
%PSIDENT_PSCENTRIC  = 1

' Constants for PSINJECTDATA.Flags field
'
%PSINJECT_APPEND  = 0
%PSINJECT_REPLACE = 1

'
' Constants for PSINJECTDATA.InjectionPoint field
'

'
' The data injected at these points coexist with the output emitted
' by the driver for the same points.
'
%PSINJECT_BEGINSTREAM     = 0
%PSINJECT_PSADOBE         = 1
%PSINJECT_COMMENTS        = 2
%PSINJECT_BEGINDEFAULTS   = 3
%PSINJECT_ENDDEFAULTS     = 4
%PSINJECT_BEGINPROLOG     = 5
%PSINJECT_ENDPROLOG       = 6
%PSINJECT_BEGINSETUP      = 7
%PSINJECT_ENDSETUP        = 8
%PSINJECT_ENDPAGECOMMENTS = 9
%PSINJECT_BEGINPAGESETUP  = 10
%PSINJECT_ENDPAGESETUP    = 11
%PSINJECT_SHOWPAGE        = 12
%PSINJECT_PAGETRAILER     = 13
%PSINJECT_TRAILER         = 14
%PSINJECT_EOF             = 15
%PSINJECT_ENDSTREAM       = 16
%PSINJECT_VMSAVE          = 17
%PSINJECT_VMRESTORE       = 18

' The data injected at these points are appended to the output
' emitted by the driver for the same points. It will go into
' the document trailer section. They must be in the form of:
'     %%+ resource-type resource-names

%PSINJECT_DOCNEEDEDRES   = 19
%PSINJECT_DOCSUPPLIEDRES = 20

' The data injected at these points replaces the output emitted
' by the driver for the same points.

%PSINJECT_PAGES       = 21
%PSINJECT_PAGEORDER   = 22
%PSINJECT_ORIENTATION = 23
%PSINJECT_BOUNDINGBOX = 24
%PSINJECT_PAGENUMBER  = 25
%PSINJECT_PAGEBBOX    = 26

%PSINJECT_MAX         = 27


' Flag returned from QUERYDIBSUPPORT
%QDI_SETDIBITS   = 1
%QDI_GETDIBITS   = 2
%QDI_DIBTOSCREEN = 4
%QDI_STRETCHDIB  = 8

' Spooler Error Codes
%SP_NOTREPORTED = &H4000
%SP_ERROR       = -1
%SP_APPABORT    = -2
%SP_USERABORT   = -3
%SP_OUTOFDISK   = -4
%SP_OUTOFMEMORY = -5

%PR_JOBSTATUS = &H0000

'  Object Definitions for EnumObjects()
%OBJ_PEN         = 1
%OBJ_BRUSH       = 2
%OBJ_DC          = 3
%OBJ_METADC      = 4
%OBJ_PAL         = 5
%OBJ_FONT        = 6
%OBJ_BITMAP      = 7
%OBJ_REGION      = 8
%OBJ_METAFILE    = 9
%OBJ_MEMDC       = 10
%OBJ_EXTPEN      = 11
%OBJ_ENHMETADC   = 12
%OBJ_ENHMETAFILE = 13

'  xform stuff
%MWT_IDENTITY      = 1
%MWT_LEFTMULTIPLY  = 2
%MWT_RIGHTMULTIPLY = 3

%MWT_MIN = %MWT_IDENTITY
%MWT_MAX = %MWT_RIGHTMULTIPLY

' Image Color Matching color definitions

%CS_ENABLE           = &H00000001&
%CS_DISABLE          = &H00000002&
%CS_DELETE_TRANSFORM = &H00000003&

' Logcolorspace signature

%LCS_SIGNATURE = &H50534f43     ' "PSOC"

' Logcolorspace lcsType values

%LCS_sRGB                = &H73524742  ' "sRGB"
%LCS_WINDOWS_COLOR_SPACE = &H57696e20  ' "Win "  ' Windows default color space

%LCS_CALIBRATED_RGB      = &H00000000&
%LCS_DEVICE_RGB          = &H00000001&
%LCS_DEVICE_CMYK         = &H00000002&

%LCS_GM_BUSINESS         = &H00000001&
%LCS_GM_GRAPHICS         = &H00000002&
%LCS_GM_IMAGES           = &H00000004&
%LCS_GM_ABS_COLORIMETRIC = &H00000008&

' ICM Defines for results from CheckColorInGamut()
%CM_OUT_OF_GAMUT = 255
%CM_IN_GAMUT     = 0

' UpdateICMRegKey Constants
%ICM_ADDPROFILE          = 1
%ICM_DELETEPROFILE       = 2
%ICM_QUERYPROFILE        = 3
%ICM_SETDEFAULTPROFILE   = 4
%ICM_REGISTERICMATCHER   = 5
%ICM_UNREGISTERICMATCHER = 6
%ICM_QUERYMATCH          = 7

' Values for bV5CSType
%PROFILE_LINKED   = &H4c494e4b  '  "LINK"
%PROFILE_EMBEDDED = &H4d424544  '  "MBED"

' constants for the biCompression field
%BI_RGB       = 0&
%BI_RLE8      = 1&
%BI_RLE4      = 2&
%BI_BITFIELDS = 3&

%TCI_SRCCHARSET  = 1
%TCI_SRCCODEPAGE = 2
%TCI_SRCFONTSIG  = 3

%TMPF_FIXED_PITCH = &H01
%TMPF_VECTOR      = &H02
%TMPF_DEVICE      = &H08
%TMPF_TRUETYPE    = &H04

' ntmFlags field flags
%NTM_REGULAR        = &H00000040&
%NTM_BOLD           = &H00000020&
%NTM_ITALIC         = &H00000001&

%NTM_NONNEGATIVE_AC = &H00010000
%NTM_OPENTYPE       = &H00020000
%NTM_MULTIPLEMASTER = &H00040000
%NTM_MM_INSTANCE    = &H00080000
%NTM_TYPE1          = &H00100000
%NTM_DSIG           = &H00200000

%LF_FACESIZE     = 32

%LF_FULLFACESIZE = 64

%OUT_DEFAULT_PRECIS        = 0
%OUT_STRING_PRECIS         = 1
%OUT_CHARACTER_PRECIS      = 2
%OUT_STROKE_PRECIS         = 3
%OUT_TT_PRECIS             = 4
%OUT_DEVICE_PRECIS         = 5
%OUT_RASTER_PRECIS         = 6
%OUT_TT_ONLY_PRECIS        = 7
%OUT_OUTLINE_PRECIS        = 8
%OUT_SCREEN_OUTLINE_PRECIS = 9

%CLIP_DEFAULT_PRECIS   = 0
%CLIP_CHARACTER_PRECIS = 1
%CLIP_STROKE_PRECIS    = 2
%CLIP_MASK             = &HF
%CLIP_LH_ANGLES        = 16
%CLIP_TT_ALWAYS        = 32
%CLIP_EMBEDDED         = 128

%DEFAULT_QUALITY        = 0
%DRAFT_QUALITY          = 1
%PROOF_QUALITY          = 2
%NONANTIALIASED_QUALITY = 3
%ANTIALIASED_QUALITY    = 4

%DEFAULT_PITCH   = 0
%FIXED_PITCH     = 1
%VARIABLE_PITCH  = 2
%MONO_FONT       = 8

%ANSI_CHARSET        = 0
%DEFAULT_CHARSET     = 1
%SYMBOL_CHARSET      = 2
%SHIFTJIS_CHARSET    = 128
%HANGEUL_CHARSET     = 129
%HANGUL_CHARSET      = 129
%CHINESEBIG5_CHARSET = 136
%OEM_CHARSET         = 255

%JOHAB_CHARSET       = 130
%HEBREW_CHARSET      = 177
%ARABIC_CHARSET      = 178
%GREEK_CHARSET       = 161
%TURKISH_CHARSET     = 162
%THAI_CHARSET        = 222
%EASTEUROPE_CHARSET  = 238
%RUSSIAN_CHARSET     = 204

%MAC_CHARSET         = 77
%BALTIC_CHARSET      = 186

%FS_LATIN1      = &H00000001&
%FS_LATIN2      = &H00000002&
%FS_CYRILLIC    = &H00000004&
%FS_GREEK       = &H00000008&
%FS_TURKISH     = &H00000010&
%FS_HEBREW      = &H00000020&
%FS_ARABIC      = &H00000040&
%FS_BALTIC      = &H00000080&
%FS_THAI        = &H00010000
%FS_JISJAPAN    = &H00020000
%FS_CHINESESIMP = &H00040000
%FS_WANSUNG     = &H00080000
%FS_CHINESETRAD = &H00100000
%FS_JOHAB       = &H00200000
%FS_SYMBOL      = &H80000000

' Font Families
'
%FF_DONTCARE = 0    '  Don't care or don't know.
%FF_ROMAN    = 16   '  Variable stroke width, serifed.

' Times Roman, Century Schoolbook, etc.
%FF_SWISS    = 32   '  Variable stroke width, sans-serifed.

' Helvetica, Swiss, etc.
%FF_MODERN   = 48   '  Constant stroke width, serifed or sans-serifed.

' Pica, Elite, Courier, etc.
%FF_SCRIPT     = 64 '  Cursive, etc.
%FF_DECORATIVE = 80 '  Old English, etc.

' Font Weights
%FW_DONTCARE   = 0
%FW_THIN       = 100
%FW_EXTRALIGHT = 200
%FW_LIGHT      = 300
%FW_NORMAL     = 400
%FW_MEDIUM     = 500
%FW_SEMIBOLD   = 600
%FW_BOLD       = 700
%FW_EXTRABOLD  = 800
%FW_HEAVY      = 900

%FW_ULTRALIGHT = %FW_EXTRALIGHT
%FW_REGULAR    = %FW_NORMAL
%FW_DEMIBOLD   = %FW_SEMIBOLD
%FW_ULTRABOLD  = %FW_EXTRABOLD
%FW_BLACK      = %FW_HEAVY

%PANOSE_COUNT               = 10
%PAN_FAMILYTYPE_INDEX       = 0
%PAN_SERIFSTYLE_INDEX       = 1
%PAN_WEIGHT_INDEX           = 2
%PAN_PROPORTION_INDEX       = 3
%PAN_CONTRAST_INDEX         = 4
%PAN_STROKEVARIATION_INDEX  = 5
%PAN_ARMSTYLE_INDEX         = 6
%PAN_LETTERFORM_INDEX       = 7
%PAN_MIDLINE_INDEX          = 8
%PAN_XHEIGHT_INDEX          = 9

%PAN_CULTURE_LATIN          = 0

%PAN_ANY                     = 0  '  Any
%PAN_NO_FIT                  = 1  '  No Fit

%PAN_FAMILY_TEXT_DISPLAY     = 2  '  Text and Display
%PAN_FAMILY_SCRIPT           = 3  '  Script
%PAN_FAMILY_DECORATIVE       = 4  '  Decorative
%PAN_FAMILY_PICTORIAL        = 5  '  Pictorial

%PAN_SERIF_COVE              = 2  '  Cove
%PAN_SERIF_OBTUSE_COVE       = 3  '  Obtuse Cove
%PAN_SERIF_SQUARE_COVE       = 4  '  Square Cove
%PAN_SERIF_OBTUSE_SQUARE_COVE= 5  '  Obtuse Square Cove
%PAN_SERIF_SQUARE            = 6  '  Square
%PAN_SERIF_THIN              = 7  '  Thin
%PAN_SERIF_BONE              = 8  '  Bone
%PAN_SERIF_EXAGGERATED       = 9  '  Exaggerated
%PAN_SERIF_TRIANGLE          = 10 '  Triangle
%PAN_SERIF_NORMAL_SANS       = 11 '  Normal Sans
%PAN_SERIF_OBTUSE_SANS       = 12 '  Obtuse Sans
%PAN_SERIF_PERP_SANS         = 13 '  Prep Sans
%PAN_SERIF_FLARED            = 14 '  Flared
%PAN_SERIF_ROUNDED           = 15 '  Rounded

%PAN_WEIGHT_VERY_LIGHT       = 2  '  Very Light
%PAN_WEIGHT_LIGHT            = 3  '  Light
%PAN_WEIGHT_THIN             = 4  '  Thin
%PAN_WEIGHT_BOOK             = 5  '  Book
%PAN_WEIGHT_MEDIUM           = 6  '  Medium
%PAN_WEIGHT_DEMI             = 7  '  Demi
%PAN_WEIGHT_BOLD             = 8  '  Bold
%PAN_WEIGHT_HEAVY            = 9  '  Heavy
%PAN_WEIGHT_BLACK            = 10 '  Black
%PAN_WEIGHT_NORD             = 11 '  Nord

%PAN_PROP_OLD_STYLE          = 2  '  Old Style
%PAN_PROP_MODERN             = 3  '  Modern
%PAN_PROP_EVEN_WIDTH         = 4  '  Even Width
%PAN_PROP_EXPANDED           = 5  '  Expanded
%PAN_PROP_CONDENSED          = 6  '  Condensed
%PAN_PROP_VERY_EXPANDED      = 7  '  Very Expanded
%PAN_PROP_VERY_CONDENSED     = 8  '  Very Condensed
%PAN_PROP_MONOSPACED         = 9  '  Monospaced

%PAN_CONTRAST_NONE           = 2  '  None
%PAN_CONTRAST_VERY_LOW       = 3  '  Very Low
%PAN_CONTRAST_LOW            = 4  '  Low
%PAN_CONTRAST_MEDIUM_LOW     = 5  '  Medium Low
%PAN_CONTRAST_MEDIUM         = 6  '  Medium
%PAN_CONTRAST_MEDIUM_HIGH    = 7  '  Mediim High
%PAN_CONTRAST_HIGH           = 8  '  High
%PAN_CONTRAST_VERY_HIGH      = 9  '  Very High

%PAN_STROKE_GRADUAL_DIAG     = 2  '  Gradual/Diagonal
%PAN_STROKE_GRADUAL_TRAN     = 3  '  Gradual/Transitional
%PAN_STROKE_GRADUAL_VERT     = 4  '  Gradual/Vertical
%PAN_STROKE_GRADUAL_HORZ     = 5  '  Gradual/Horizontal
%PAN_STROKE_RAPID_VERT       = 6  '  Rapid/Vertical
%PAN_STROKE_RAPID_HORZ       = 7  '  Rapid/Horizontal
%PAN_STROKE_INSTANT_VERT     = 8  '  Instant/Vertical

%PAN_STRAIGHT_ARMS_HORZ          = 2  '  Straight Arms/Horizontal
%PAN_STRAIGHT_ARMS_WEDGE         = 3  '  Straight Arms/Wedge
%PAN_STRAIGHT_ARMS_VERT          = 4  '  Straight Arms/Vertical
%PAN_STRAIGHT_ARMS_SINGLE_SERIF  = 5  '  Straight Arms/Single-Serif
%PAN_STRAIGHT_ARMS_DOUBLE_SERIF  = 6  '  Straight Arms/Double-Serif
%PAN_BENT_ARMS_HORZ              = 7  '  Non-Straight Arms/Horizontal
%PAN_BENT_ARMS_WEDGE             = 8  '  Non-Straight Arms/Wedge
%PAN_BENT_ARMS_VERT              = 9  '  Non-Straight Arms/Vertical
%PAN_BENT_ARMS_SINGLE_SERIF      = 10 '  Non-Straight Arms/Single-Serif
%PAN_BENT_ARMS_DOUBLE_SERIF      = 11 '  Non-Straight Arms/Double-Serif

%PAN_LETT_NORMAL_CONTACT     = 2  '  Normal/Contact
%PAN_LETT_NORMAL_WEIGHTED    = 3  '  Normal/Weighted
%PAN_LETT_NORMAL_BOXED       = 4  '  Normal/Boxed
%PAN_LETT_NORMAL_FLATTENED   = 5  '  Normal/Flattened
%PAN_LETT_NORMAL_ROUNDED     = 6  '  Normal/Rounded
%PAN_LETT_NORMAL_OFF_CENTER  = 7  '  Normal/Off Center
%PAN_LETT_NORMAL_SQUARE      = 8  '  Normal/Square
%PAN_LETT_OBLIQUE_CONTACT    = 9  '  Oblique/Contact
%PAN_LETT_OBLIQUE_WEIGHTED   = 10 '  Oblique/Weighted
%PAN_LETT_OBLIQUE_BOXED      = 11 '  Oblique/Boxed
%PAN_LETT_OBLIQUE_FLATTENED  = 12 '  Oblique/Flattened
%PAN_LETT_OBLIQUE_ROUNDED    = 13 '  Oblique/Rounded
%PAN_LETT_OBLIQUE_OFF_CENTER = 14 '  Oblique/Off Center
%PAN_LETT_OBLIQUE_SQUARE     = 15 '  Oblique/Square

%PAN_MIDLINE_STANDARD_TRIMMED = 2  '  Standard/Trimmed
%PAN_MIDLINE_STANDARD_POINTED = 3  '  Standard/Pointed
%PAN_MIDLINE_STANDARD_SERIFED = 4  '  Standard/Serifed
%PAN_MIDLINE_HIGH_TRIMMED     = 5  '  High/Trimmed
%PAN_MIDLINE_HIGH_POINTED     = 6  '  High/Pointed
%PAN_MIDLINE_HIGH_SERIFED     = 7  '  High/Serifed
%PAN_MIDLINE_CONSTANT_TRIMMED = 8  '  Constant/Trimmed
%PAN_MIDLINE_CONSTANT_POINTED = 9  '  Constant/Pointed
%PAN_MIDLINE_CONSTANT_SERIFED = 10 '  Constant/Serifed
%PAN_MIDLINE_LOW_TRIMMED      = 11 '  Low/Trimmed
%PAN_MIDLINE_LOW_POINTED      = 12 '  Low/Pointed
%PAN_MIDLINE_LOW_SERIFED      = 13 '  Low/Serifed

%PAN_XHEIGHT_CONSTANT_SMALL  = 2  '  Constant/Small
%PAN_XHEIGHT_CONSTANT_STD    = 3  '  Constant/Standard
%PAN_XHEIGHT_CONSTANT_LARGE  = 4  '  Constant/Large
%PAN_XHEIGHT_DUCKING_SMALL   = 5  '  Ducking/Small
%PAN_XHEIGHT_DUCKING_STD     = 6  '  Ducking/Standard
%PAN_XHEIGHT_DUCKING_LARGE   = 7  '  Ducking/Large

%ELF_VENDOR_SIZE   = 4

%ELF_VERSION       = 0
%ELF_CULTURE_LATIN = 0

'  EnumFonts Masks
%RASTER_FONTTYPE   = &H1
%DEVICE_FONTTYPE   = &H2
%TRUETYPE_FONTTYPE = &H4

' palette entry flags
%PC_RESERVED   = &H01  '  palette index used for animation
%PC_EXPLICIT   = &H02  '  palette index is explicit to device
%PC_NOCOLLAPSE = &H04  '  do not match color to system palette

' Background Modes
%TRANSPARENT = 1
%OPAQUE      = 2
%BKMODE_LAST = 2

'  Graphics Modes
%GM_COMPATIBLE = 1
%GM_ADVANCED   = 2
%GM_LAST       = 2

'  PolyDraw and GetPath point types
%PT_CLOSEFIGURE = &H01
%PT_LINETO      = &H02
%PT_BEZIERTO    = &H04
%PT_MOVETO      = &H06

'  Mapping Modes
%MM_TEXT         = 1
%MM_LOMETRIC     = 2
%MM_HIMETRIC     = 3
%MM_LOENGLISH    = 4
%MM_HIENGLISH    = 5
%MM_TWIPS        = 6
%MM_ISOTROPIC    = 7
%MM_ANISOTROPIC  = 8

'  Min and Max Mapping Mode values
%MM_MIN            = %MM_TEXT
%MM_MAX            = %MM_ANISOTROPIC
%MM_MAX_FIXEDSCALE = %MM_TWIPS

' Coordinate Modes
%ABSOLUTE = 1
%RELATIVE = 2

' Stock Logical Objects
%WHITE_BRUSH         = 0
%LTGRAY_BRUSH        = 1
%GRAY_BRUSH          = 2
%DKGRAY_BRUSH        = 3
%BLACK_BRUSH         = 4
%NULL_BRUSH          = 5
%HOLLOW_BRUSH        = %NULL_BRUSH
%WHITE_PEN           = 6
%BLACK_PEN           = 7
%NULL_PEN            = 8
%OEM_FIXED_FONT      = 10
%ANSI_FIXED_FONT     = 11
%ANSI_VAR_FONT       = 12
%SYSTEM_FONT         = 13
%DEVICE_DEFAULT_FONT = 14
%DEFAULT_PALETTE     = 15
%SYSTEM_FIXED_FONT   = 16

%DEFAULT_GUI_FONT    = 17

%DC_BRUSH            = 18
%DC_PEN              = 19

%STOCK_LAST          = 19  ' depending on Windows version, may be 16, 17 or 19

%CLR_INVALID         = &HFFFFFFFF???  ' some Microsoft docs claim this is &HFFFF, but it's not

' Brush Styles
%BS_SOLID            = 0
%BS_NULL             = 1
%BS_HOLLOW           = %BS_NULL
%BS_HATCHED          = 2
%BS_PATTERN          = 3
%BS_INDEXED          = 4
%BS_DIBPATTERN       = 5
%BS_DIBPATTERNPT     = 6
%BS_PATTERN8X8       = 7
%BS_DIBPATTERN8X8    = 8
%BS_MONOPATTERN      = 9

' Hatch Styles
%HS_HORIZONTAL       = 0     '  -----
%HS_VERTICAL         = 1     '  |||||
%HS_FDIAGONAL        = 2     '  \\\\\
%HS_BDIAGONAL        = 3     '  -----
%HS_CROSS            = 4     '  +++++
%HS_DIAGCROSS        = 5     '  xxxxx
%HS_FDIAGONAL1       = 6
%HS_BDIAGONAL1       = 7
%HS_SOLID            = 8
%HS_DENSE1           = 9
%HS_DENSE2           = 10
%HS_DENSE3           = 11
%HS_DENSE4           = 12
%HS_DENSE5           = 13
%HS_DENSE6           = 14
%HS_DENSE7           = 15
%HS_DENSE8           = 16
%HS_NOSHADE          = 17
%HS_HALFTONE         = 18
%HS_SOLIDCLR         = 19
%HS_DITHEREDCLR      = 20
%HS_SOLIDTEXTCLR     = 21
%HS_DITHEREDTEXTCLR  = 22
%HS_SOLIDBKCLR       = 23
%HS_DITHEREDBKCLR    = 24
%HS_API_MAX          = 25

' Pen Styles
%PS_SOLID            = 0
%PS_DASH             = 1     '  -------
%PS_DOT              = 2     '  .......
%PS_DASHDOT          = 3     '  _._._._
%PS_DASHDOTDOT       = 4     '  _.._.._
%PS_NULL             = 5
%PS_INSIDEFRAME      = 6
%PS_USERSTYLE        = 7
%PS_ALTERNATE        = 8
%PS_STYLE_MASK       = &H0000000F

%PS_ENDCAP_ROUND     = &H00000000
%PS_ENDCAP_SQUARE    = &H00000100
%PS_ENDCAP_FLAT      = &H00000200
%PS_ENDCAP_MASK      = &H00000F00

%PS_JOIN_ROUND       = &H00000000
%PS_JOIN_BEVEL       = &H00001000
%PS_JOIN_MITER       = &H00002000
%PS_JOIN_MASK        = &H0000F000

%PS_COSMETIC         = &H00000000
%PS_GEOMETRIC        = &H00010000
%PS_TYPE_MASK        = &H000F0000

%AD_COUNTERCLOCKWISE = 1
%AD_CLOCKWISE        = 2

' Device Parameters for GetDeviceCaps()
%DRIVERVERSION  = 0    ' Device driver version
%TECHNOLOGY     = 2    ' Device classification
%HORZSIZE       = 4    ' Horizontal size in millimeters
%VERTSIZE       = 6    ' Vertical size in millimeters
%HORZRES        = 8    ' Horizontal width in pixels
%VERTRES        = 10   ' Vertical width in pixels
%BITSPIXEL      = 12   ' Number of bits per pixel
%PLANES         = 14   ' Number of planes
%NUMBRUSHES     = 16   ' Number of brushes the device has
%NUMPENS        = 18   ' Number of pens the device has
%NUMMARKERS     = 20   ' Number of markers the device has
%NUMFONTS       = 22   ' Number of fonts the device has
%NUMCOLORS      = 24   ' Number of colors the device supports
%PDEVICESIZE    = 26   ' Size required for device descriptor
%CURVECAPS      = 28   ' Curve capabilities
%LINECAPS       = 30   ' Line capabilities
%POLYGONALCAPS  = 32   ' Polygonal capabilities
%TEXTCAPS       = 34   ' Text capabilities
%CLIPCAPS       = 36   ' Clipping capabilities
%RASTERCAPS     = 38   ' Bitblt capabilities
%ASPECTX        = 40   ' Length of the X leg
%ASPECTY        = 42   ' Length of the Y leg
%ASPECTXY       = 44   ' Length of the hypotenuse

%SHADEBLENDCAPS = 45   ' Shading and blending caps

%LOGPIXELSX     = 88   ' Logical pixels/inch in X
%LOGPIXELSY     = 90   ' Logical pixels/inch in Y

%SIZEPALETTE    = 104  ' Number of entries in physical palette
%NUMRESERVED    = 106  ' Number of reserved entries in palette
%COLORRES       = 108  ' Actual color resolution

'  Printing related DeviceCaps. These replace the appropriate Escapes
%PHYSICALWIDTH   = 110  ' Physical Width in device units
%PHYSICALHEIGHT  = 111  ' Physical Height in device units
%PHYSICALOFFSETX = 112  ' Physical Printable Area x margin
%PHYSICALOFFSETY = 113  ' Physical Printable Area y margin
%SCALINGFACTORX  = 114  ' Scaling factor x
%SCALINGFACTORY  = 115  ' Scaling factor y

' Display driver specific
%VREFRESH       = 116  ' Current vertical refresh rate of the
                       ' display device (for displays only) in Hz
%DESKTOPVERTRES = 117  ' Horizontal width of entire desktop in pixels
%DESKTOPHORZRES = 118  ' Vertical height of entire desktop in pixels
%BLTALIGNMENT   = 119  ' Preferred blt alignment

#IF NOT %DEF(%NOGDICAPMASKS) ' ------------------------------------------------

' Device Capability Masks:

' Device Technologies
%DT_PLOTTER    = 0     ' Vector plotter
%DT_RASDISPLAY = 1     ' Raster display
%DT_RASPRINTER = 2     ' Raster printer
%DT_RASCAMERA  = 3     ' Raster camera
%DT_CHARSTREAM = 4     ' Character-stream, PLP
%DT_METAFILE   = 5     ' Metafile, VDM
%DT_DISPFILE   = 6     ' Display-file

' Curve Capabilities
%CC_NONE       = 0     ' Curves not supported
%CC_CIRCLES    = 1     ' Can do circles
%CC_PIE        = 2     ' Can do pie wedges
%CC_CHORD      = 4     ' Can do chord arcs
%CC_ELLIPSES   = 8     ' Can do ellipese
%CC_WIDE       = 16    ' Can do wide lines
%CC_STYLED     = 32    ' Can do styled lines
%CC_WIDESTYLED = 64    ' Can do wide styled lines
%CC_INTERIORS  = 128   ' Can do interiors
%CC_ROUNDRECT  = 256   '

' Line Capabilities
%LC_NONE       = 0     ' Lines not supported
%LC_POLYLINE   = 2     ' Can do polylines
%LC_MARKER     = 4     ' Can do markers
%LC_POLYMARKER = 8     ' Can do polymarkers
%LC_WIDE       = 16    ' Can do wide lines
%LC_STYLED     = 32    ' Can do styled lines
%LC_WIDESTYLED = 64    ' Can do wide styled lines
%LC_INTERIORS  = 128   ' Can do interiors

' Polygonal Capabilities
%PC_NONE         = 0     ' Polygonals not supported
%PC_POLYGON      = 1     ' Can do polygons
%PC_RECTANGLE    = 2     ' Can do rectangles
%PC_WINDPOLYGON  = 4     ' Can do winding polygons
%PC_TRAPEZOID    = 4     ' Can do trapezoids
%PC_SCANLINE     = 8     ' Can do scanlines
%PC_WIDE         = 16    ' Can do wide borders
%PC_STYLED       = 32    ' Can do styled borders
%PC_WIDESTYLED   = 64    ' Can do wide styled borders
%PC_INTERIORS    = 128   ' Can do interiors
%PC_POLYPOLYGON  = 256   ' Can do polypolygons
%PC_PATHS        = 512   ' Can do paths

' Clipping Capabilities
%CP_NONE         = 0     ' No clipping of output
%CP_RECTANGLE    = 1     ' Output clipped to rects
%CP_REGION       = 2     ' obsolete

' Text Capabilities
%TC_OP_CHARACTER = &H00000001  ' Can do OutputPrecision   CHARACTER
%TC_OP_STROKE    = &H00000002  ' Can do OutputPrecision   STROKE
%TC_CP_STROKE    = &H00000004  ' Can do ClipPrecision     STROKE
%TC_CR_90        = &H00000008  ' Can do CharRotAbility    90
%TC_CR_ANY       = &H00000010  ' Can do CharRotAbility    ANY
%TC_SF_X_YINDEP  = &H00000020  ' Can do ScaleFreedom      X_YINDEPENDENT
%TC_SA_DOUBLE    = &H00000040  ' Can do ScaleAbility      DOUBLE
%TC_SA_INTEGER   = &H00000080  ' Can do ScaleAbility      INTEGER
%TC_SA_CONTIN    = &H00000100  ' Can do ScaleAbility      CONTINUOUS
%TC_EA_DOUBLE    = &H00000200  ' Can do EmboldenAbility   DOUBLE
%TC_IA_ABLE      = &H00000400  ' Can do ItalisizeAbility  ABLE
%TC_UA_ABLE      = &H00000800  ' Can do UnderlineAbility  ABLE
%TC_SO_ABLE      = &H00001000  ' Can do StrikeOutAbility  ABLE
%TC_RA_ABLE      = &H00002000  ' Can do RasterFontAble    ABLE
%TC_VA_ABLE      = &H00004000  ' Can do VectorFontAble    ABLE
%TC_RESERVED     = &H00008000
%TC_SCROLLBLT    = &H00010000  ' Don't do text scroll with blt

#ENDIF    ' #IF NOT %DEF(%NOGDICAPMASKS) --------------------------------------

' Raster Capabilities
%RC_NONE         = 0
%RC_BITBLT       = 1       '  Can do standard BLT.
%RC_BANDING      = 2       '  Device requires banding support
%RC_SCALING      = 4       '  Device requires scaling support
%RC_BITMAP64     = 8       '  Device can support >64K bitmap
%RC_GDI20_OUTPUT = &H0010  '  has 2.0 output calls
%RC_GDI20_STATE  = &H0020
%RC_SAVEBITMAP   = &H0040
%RC_DI_BITMAP    = &H0080  '  supports DIB to memory
%RC_PALETTE      = &H0100  '  supports a palette
%RC_DIBTODEV     = &H0200  '  supports DIBitsToDevice
%RC_BIGFONT      = &H0400  '  supports >64K fonts
%RC_STRETCHBLT   = &H0800  '  supports StretchBlt
%RC_FLOODFILL    = &H1000  '  supports FloodFill
%RC_STRETCHDIB   = &H2000  '  supports StretchDIBits
%RC_OP_DX_OUTPUT = &H4000
%RC_DEVBITS      = &H8000

' Shading and blending caps
%SB_NONE          = &H00000000
%SB_CONST_ALPHA   = &H00000001
%SB_PIXEL_ALPHA   = &H00000002
%SB_PREMULT_ALPHA = &H00000004

%SB_GRAD_RECT     = &H00000010
%SB_GRAD_TRI      = &H00000020

' DIB color table identifiers
%DIB_RGB_COLORS      = 0 ' color table in RGBs
%DIB_PAL_COLORS      = 1 ' color table in palette indices
%DIB_PAL_INDICES     = 2 ' No color table indices into surf palette
%DIB_PAL_PHYSINDICES = 2 ' No color table indices into surf palette
%DIB_PAL_LOGINDICES  = 4 ' No color table indices into DC palette

' constants for Get/SetSystemPaletteUse()
%SYSPAL_ERROR       = 0
%SYSPAL_STATIC      = 1
%SYSPAL_NOSTATIC    = 2
%SYSPAL_NOSTATIC256 = 3

' constants for CreateDIBitmap
%CBM_CREATEDIB      = 2     ' create DIB bitmap
%CBM_INIT           = 4     ' initialize bitmap

' ExtFloodFill style flags
%FLOODFILLBORDER    = 0
%FLOODFILLSURFACE   = 1

' size of a device name string
%CCHDEVICENAME = 32

' size of a form name string
%CCHFORMNAME = 32

' current version of specification
' depending on Windows version, may be &H0401, &H0400, or &H0320
%DM_SPECVERSION = &H0401

' field selection bits
%DM_ORIENTATION      = &H00000001&
%DM_PAPERSIZE        = &H00000002&
%DM_PAPERLENGTH      = &H00000004&
%DM_PAPERWIDTH       = &H00000008&
%DM_SCALE            = &H00000010&
%DM_POSITION         = &H00000020&
%DM_COPIES           = &H00000100&
%DM_DEFAULTSOURCE    = &H00000200&
%DM_PRINTQUALITY     = &H00000400&
%DM_COLOR            = &H00000800&
%DM_DUPLEX           = &H00001000&
%DM_YRESOLUTION      = &H00002000&
%DM_TTOPTION         = &H00004000&
%DM_COLLATE          = &H00008000&
%DM_FORMNAME         = &H00010000&
%DM_LOGPIXELS        = &H00020000&
%DM_BITSPERPEL       = &H00040000&
%DM_PELSWIDTH        = &H00080000&
%DM_PELSHEIGHT       = &H00100000&
%DM_DISPLAYFLAGS     = &H00200000&
%DM_DISPLAYFREQUENCY = &H00400000&
%DM_ICMMETHOD        = &H00800000&  ' *** MSDN claims a different value here!
%DM_ICMINTENT        = &H01000000&  ' *** MSDN claims a different value here!
%DM_MEDIATYPE        = &H02000000&  ' *** MSDN claims a different value here!
%DM_DITHERTYPE       = &H04000000&  ' *** MSDN claims a different value here!
%DM_PANNINGWIDTH     = &H08000000&
%DM_PANNINGHEIGHT    = &H10000000&

'  orientation selections
%DMORIENT_PORTRAIT  = 1
%DMORIENT_LANDSCAPE = 2

'  paper selections
%DMPAPER_LETTER              = 1
%DMPAPER_FIRST               = %DMPAPER_LETTER  '  Letter 8 1/2 x 11 in
%DMPAPER_LETTERSMALL         = 2    '  Letter Small 8 1/2 x 11 in
%DMPAPER_TABLOID             = 3    '  Tabloid 11 x 17 in
%DMPAPER_LEDGER              = 4    '  Ledger 17 x 11 in
%DMPAPER_LEGAL               = 5    '  Legal 8 1/2 x 14 in
%DMPAPER_STATEMENT           = 6    '  Statement 5 1/2 x 8 1/2 in
%DMPAPER_EXECUTIVE           = 7    '  Executive 7 1/4 x 10 1/2 in
%DMPAPER_A3                  = 8    '  A3 297 x 420 mm
%DMPAPER_A4                  = 9    '  A4 210 x 297 mm
%DMPAPER_A4SMALL             = 10   '  A4 Small 210 x 297 mm
%DMPAPER_A5                  = 11   '  A5 148 x 210 mm
%DMPAPER_B4                  = 12   '  B4 250 x 354
%DMPAPER_B5                  = 13   '  B5 182 x 257 mm
%DMPAPER_FOLIO               = 14   '  Folio 8 1/2 x 13 in
%DMPAPER_QUARTO              = 15   '  Quarto 215 x 275 mm
%DMPAPER_10X14               = 16   '  1&H14 in
%DMPAPER_11X17               = 17   '  11x17 in
%DMPAPER_NOTE                = 18   '  Note 8 1/2 x 11 in
%DMPAPER_ENV_9               = 19   '  Envelope #9 3 7/8 x 8 7/8
%DMPAPER_ENV_10              = 20   '  Envelope #10 4 1/8 x 9 1/2
%DMPAPER_ENV_11              = 21   '  Envelope #11 4 1/2 x 10 3/8
%DMPAPER_ENV_12              = 22   '  Envelope #12 4 \276 x 11
%DMPAPER_ENV_14              = 23   '  Envelope #14 5 x 11 1/2
%DMPAPER_CSHEET              = 24   '  C size sheet
%DMPAPER_DSHEET              = 25   '  D size sheet
%DMPAPER_ESHEET              = 26   '  E size sheet
%DMPAPER_ENV_DL              = 27   '  Envelope DL 110 x 220mm
%DMPAPER_ENV_C5              = 28   '  Envelope C5 162 x 229 mm
%DMPAPER_ENV_C3              = 29   '  Envelope C3  324 x 458 mm
%DMPAPER_ENV_C4              = 30   '  Envelope C4  229 x 324 mm
%DMPAPER_ENV_C6              = 31   '  Envelope C6  114 x 162 mm
%DMPAPER_ENV_C65             = 32   '  Envelope C65 114 x 229 mm
%DMPAPER_ENV_B4              = 33   '  Envelope B4  250 x 353 mm
%DMPAPER_ENV_B5              = 34   '  Envelope B5  176 x 250 mm
%DMPAPER_ENV_B6              = 35   '  Envelope B6  176 x 125 mm
%DMPAPER_ENV_ITALY           = 36   '  Envelope 110 x 230 mm
%DMPAPER_ENV_MONARCH         = 37   '  Envelope Monarch 3.875 x 7.5 in
%DMPAPER_ENV_PERSONAL        = 38   '  6 3/4 Envelope 3 5/8 x 6 1/2 in
%DMPAPER_FANFOLD_US          = 39   '  US Std Fanfold 14 7/8 x 11 in
%DMPAPER_FANFOLD_STD_GERMAN  = 40   '  German Std Fanfold 8 1/2 x 12 in
%DMPAPER_FANFOLD_LGL_GERMAN  = 41   '  German Legal Fanfold 8 1/2 x 13 in

%DMPAPER_ISO_B4              = 42   ' B4 (ISO) 250 x 353 mm
%DMPAPER_JAPANESE_POSTCARD   = 43   ' Japanese Postcard 100 x 148 mm
%DMPAPER_9X11                = 44   ' 9 x 11 in
%DMPAPER_10X11               = 45   ' 10 x 11 in
%DMPAPER_15X11               = 46   ' 15 x 11 in
%DMPAPER_ENV_INVITE          = 47   ' Envelope Invite 220 x 220 mm
%DMPAPER_RESERVED_48         = 48   ' RESERVED--DO NOT USE
%DMPAPER_RESERVED_49         = 49   ' RESERVED--DO NOT USE
%DMPAPER_LETTER_EXTRA        = 50   ' Letter Extra 9 \275 x 12 in
%DMPAPER_LEGAL_EXTRA         = 51   ' Legal Extra 9 \275 x 15 in
%DMPAPER_TABLOID_EXTRA       = 52   ' Tabloid Extra 11.69 x 18 in
%DMPAPER_A4_EXTRA            = 53   ' A4 Extra 9.27 x 12.69 in
%DMPAPER_LETTER_TRANSVERSE   = 54   ' Letter Transverse 8 \275 x 11 in
%DMPAPER_A4_TRANSVERSE       = 55   ' A4 Transverse 210 x 297 mm
%DMPAPER_LETTER_EXTRA_TRANSVERSE = 56 ' Letter Extra Transverse 9\275 x 12 in
%DMPAPER_A_PLUS              = 57   ' SuperA/SuperA/A4 227 x 356 mm
%DMPAPER_B_PLUS              = 58   ' SuperB/SuperB/A3 305 x 487 mm
%DMPAPER_LETTER_PLUS         = 59   ' Letter Plus 8.5 x 12.69 in
%DMPAPER_A4_PLUS             = 60   ' A4 Plus 210 x 330 mm
%DMPAPER_A5_TRANSVERSE       = 61   ' A5 Transverse 148 x 210 mm
%DMPAPER_B5_TRANSVERSE       = 62   ' B5 (JIS) Transverse 182 x 257 mm
%DMPAPER_A3_EXTRA            = 63   ' A3 Extra 322 x 445 mm
%DMPAPER_A5_EXTRA            = 64   ' A5 Extra 174 x 235 mm
%DMPAPER_B5_EXTRA            = 65   ' B5 (ISO) Extra 201 x 276 mm
%DMPAPER_A2                  = 66   ' A2 420 x 594 mm
%DMPAPER_A3_TRANSVERSE       = 67   ' A3 Transverse 297 x 420 mm
%DMPAPER_A3_EXTRA_TRANSVERSE = 68   ' A3 Extra Transverse 322 x 445 mm

%DMPAPER_DBL_JAPANESE_POSTCARD = 69 ' Japanese Double Postcard 200 x 148 mm
%DMPAPER_A6                  = 70  ' A6 105 x 148 mm
%DMPAPER_JENV_KAKU2          = 71  ' Japanese Envelope Kaku #2
%DMPAPER_JENV_KAKU3          = 72  ' Japanese Envelope Kaku #3
%DMPAPER_JENV_CHOU3          = 73  ' Japanese Envelope Chou #3
%DMPAPER_JENV_CHOU4          = 74  ' Japanese Envelope Chou #4
%DMPAPER_LETTER_ROTATED      = 75  ' Letter Rotated 11 x 8 1/2 11 in
%DMPAPER_A3_ROTATED          = 76  ' A3 Rotated 420 x 297 mm
%DMPAPER_A4_ROTATED          = 77  ' A4 Rotated 297 x 210 mm
%DMPAPER_A5_ROTATED          = 78  ' A5 Rotated 210 x 148 mm
%DMPAPER_B4_JIS_ROTATED      = 79  ' B4 (JIS) Rotated 364 x 257 mm
%DMPAPER_B5_JIS_ROTATED      = 80  ' B5 (JIS) Rotated 257 x 182 mm
%DMPAPER_JAPANESE_POSTCARD_ROTATED = 81 ' Japanese Postcard Rotated 148 x 100 mm
%DMPAPER_DBL_JAPANESE_POSTCARD_ROTATED = 82 ' Double Japanese Postcard Rotated 148 x 200 mm
%DMPAPER_A6_ROTATED          = 83  ' A6 Rotated 148 x 105 mm
%DMPAPER_JENV_KAKU2_ROTATED  = 84  ' Japanese Envelope Kaku #2 Rotated
%DMPAPER_JENV_KAKU3_ROTATED  = 85  ' Japanese Envelope Kaku #3 Rotated
%DMPAPER_JENV_CHOU3_ROTATED  = 86  ' Japanese Envelope Chou #3 Rotated
%DMPAPER_JENV_CHOU4_ROTATED  = 87  ' Japanese Envelope Chou #4 Rotated
%DMPAPER_B6_JIS              = 88  ' B6 (JIS) 128 x 182 mm
%DMPAPER_B6_JIS_ROTATED      = 89  ' B6 (JIS) Rotated 182 x 128 mm
%DMPAPER_12X11               = 90  ' 12 x 11 in
%DMPAPER_JENV_YOU4           = 91  ' Japanese Envelope You #4
%DMPAPER_JENV_YOU4_ROTATED   = 92  ' Japanese Envelope You #4 Rotated
%DMPAPER_P16K                = 93  ' PRC 16K 146 x 215 mm
%DMPAPER_P32K                = 94  ' PRC 32K 97 x 151 mm
%DMPAPER_P32KBIG             = 95  ' PRC 32K(Big) 97 x 151 mm
%DMPAPER_PENV_1              = 96  ' PRC Envelope #1 102 x 165 mm
%DMPAPER_PENV_2              = 97  ' PRC Envelope #2 102 x 176 mm
%DMPAPER_PENV_3              = 98  ' PRC Envelope #3 125 x 176 mm
%DMPAPER_PENV_4              = 99  ' PRC Envelope #4 110 x 208 mm
%DMPAPER_PENV_5              = 100 ' PRC Envelope #5 110 x 220 mm
%DMPAPER_PENV_6              = 101 ' PRC Envelope #6 120 x 230 mm
%DMPAPER_PENV_7              = 102 ' PRC Envelope #7 160 x 230 mm
%DMPAPER_PENV_8              = 103 ' PRC Envelope #8 120 x 309 mm
%DMPAPER_PENV_9              = 104 ' PRC Envelope #9 229 x 324 mm
%DMPAPER_PENV_10             = 105 ' PRC Envelope #10 324 x 458 mm
%DMPAPER_P16K_ROTATED        = 106 ' PRC 16K Rotated
%DMPAPER_P32K_ROTATED        = 107 ' PRC 32K Rotated
%DMPAPER_P32KBIG_ROTATED     = 108 ' PRC 32K(Big) Rotated
%DMPAPER_PENV_1_ROTATED      = 109 ' PRC Envelope #1 Rotated 165 x 102 mm
%DMPAPER_PENV_2_ROTATED      = 110 ' PRC Envelope #2 Rotated 176 x 102 mm
%DMPAPER_PENV_3_ROTATED      = 111 ' PRC Envelope #3 Rotated 176 x 125 mm
%DMPAPER_PENV_4_ROTATED      = 112 ' PRC Envelope #4 Rotated 208 x 110 mm
%DMPAPER_PENV_5_ROTATED      = 113 ' PRC Envelope #5 Rotated 220 x 110 mm
%DMPAPER_PENV_6_ROTATED      = 114 ' PRC Envelope #6 Rotated 230 x 120 mm
%DMPAPER_PENV_7_ROTATED      = 115 ' PRC Envelope #7 Rotated 230 x 160 mm
%DMPAPER_PENV_8_ROTATED      = 116 ' PRC Envelope #8 Rotated 309 x 120 mm
%DMPAPER_PENV_9_ROTATED      = 117 ' PRC Envelope #9 Rotated 324 x 229 mm
%DMPAPER_PENV_10_ROTATED     = 118 ' PRC Envelope #10 Rotated 458 x 324 mm

' Depending on the Windows version, %DMPAPER_LAST may be equal to any of
' %DMPAPER_FANFOLD_LGL_GERMAN, %DMPAPER_A3_EXTRA_TRANSVERSE, or
' %DMPAPER_PENV_10_ROTATED (so far)... we use the most recent, here.
'
%DMPAPER_LAST = %DMPAPER_PENV_10_ROTATED

%DMPAPER_USER                = 256

' bin selections
%DMBIN_UPPER         = 1
%DMBIN_FIRST         = %DMBIN_UPPER

%DMBIN_ONLYONE       = 1
%DMBIN_LOWER         = 2
%DMBIN_MIDDLE        = 3
%DMBIN_MANUAL        = 4
%DMBIN_ENVELOPE      = 5
%DMBIN_ENVMANUAL     = 6
%DMBIN_AUTO          = 7
%DMBIN_TRACTOR       = 8
%DMBIN_SMALLFMT      = 9
%DMBIN_LARGEFMT      = 10
%DMBIN_LARGECAPACITY = 11
%DMBIN_CASSETTE      = 14
%DMBIN_FORMSOURCE    = 15
%DMBIN_LAST          = %DMBIN_FORMSOURCE

%DMBIN_USER          = 256  '  device specific bins start here

' print qualities
%DMRES_DRAFT  = -1
%DMRES_LOW    = -2
%DMRES_MEDIUM = -3
%DMRES_HIGH   = -4

' color enable/disable for color printers
%DMCOLOR_MONOCHROME = 1
%DMCOLOR_COLOR      = 2

' duplex enable
%DMDUP_SIMPLEX    = 1
%DMDUP_VERTICAL   = 2
%DMDUP_HORIZONTAL = 3

' TrueType options
%DMTT_BITMAP           = 1  ' print TT fonts as graphics
%DMTT_DOWNLOAD         = 2  ' download TT fonts as soft fonts
%DMTT_SUBDEV           = 3  ' substitute device fonts for TT fonts
%DMTT_DOWNLOAD_OUTLINE = 4  ' download TT fonts as outline soft fonts

' Collation selections
%DMCOLLATE_FALSE = 0
%DMCOLLATE_TRUE  = 1

' DEVMODE dmDisplayFlags flags

%DM_GRAYSCALE            = 1
%DM_INTERLACED           = 2

%DMDISPLAYFLAGS_TEXTMODE = 4

' ICM methods
%DMICMMETHOD_NONE   = 1     ' ICM disabled
%DMICMMETHOD_SYSTEM = 2     ' ICM handled by system
%DMICMMETHOD_DRIVER = 3     ' ICM handled by driver
%DMICMMETHOD_DEVICE = 4     ' ICM handled by device
%DMICMMETHOD_USER   = 256   ' Device-specific methods start here

' ICM Intents
%DMICM_SATURATE         = 1   ' Maximize color saturation
%DMICM_CONTRAST         = 2   ' Maximize color contrast
%DMICM_COLORIMETRIC     = 3   ' Use specific color metric
%DMICM_ABS_COLORIMETRIC = 4   ' Use specific color metric
%DMICM_USER             = 256 ' Device-specific intents start here

' Media types
%DMMEDIA_STANDARD     = 1   ' Standard paper
%DMMEDIA_GLOSSY       = 2   ' Glossy paper
%DMMEDIA_TRANSPARENCY = 3   ' Transparency
%DMMEDIA_USER         = 256 ' Device-specific media start here

' Dither types
%DMDITHER_NONE           = 1   ' No dithering
%DMDITHER_COARSE         = 2   ' Dither with a coarse brush
%DMDITHER_FINE           = 3   ' Dither with a fine brush
%DMDITHER_LINEART        = 4   ' LineArt dithering
%DMDITHER_ERRORDIFFUSION = 5   ' LineArt dithering
%DMDITHER_RESERVED6      = 6   ' LineArt dithering
%DMDITHER_RESERVED7      = 7   ' LineArt dithering
%DMDITHER_RESERVED8      = 8   ' LineArt dithering
%DMDITHER_RESERVED9      = 9   ' LineArt dithering
%DMDITHER_GRAYSCALE      = 10  ' Device does grayscaling
%DMDITHER_USER           = 256 ' Device-specific dithers start here

%DISPLAY_DEVICE_ATTACHED_TO_DESKTOP = &H00000001
%DISPLAY_DEVICE_MULTI_DRIVER        = &H00000002
%DISPLAY_DEVICE_PRIMARY_DEVICE      = &H00000004
%DISPLAY_DEVICE_MIRRORING_DRIVER    = &H00000008
%DISPLAY_DEVICE_VGA_COMPATIBLE      = &H00000010

' GetRegionData/ExtCreateRegion

%RDH_RECTANGLES = 1

' GetGlyphOutline constants
%GGO_METRICS      = 0
%GGO_BITMAP       = 1
%GGO_NATIVE       = 2
%GGO_BEZIER       = 3
%GGO_GRAY2_BITMAP = 4
%GGO_GRAY4_BITMAP = 5
%GGO_GRAY8_BITMAP = 6
%GGO_GLYPH_INDEX  = &H0080

%TT_POLYGON_TYPE = 24

%TT_PRIM_LINE    = 1
%TT_PRIM_QSPLINE = 2
%TT_PRIM_CSPLINE = 3

%GCP_DBCS            = &H00000001
%GCP_REORDER         = &H00000002
%GCP_USEKERNING      = &H00000008
%GCP_GLYPHSHAPE      = &H00000010
%GCP_LIGATE          = &H00000020
%GCP_DIACRITIC       = &H00000100
%GCP_KASHIDA         = &H00000400
%GCP_ERROR           = &H00008000
%FLI_MASK            = &H0000103B

%GCP_JUSTIFY         = &H00010000
%GCP_NODIACRITICS    = &H00020000
%FLI_GLYPHS          = &H00040000
%GCP_CLASSIN         = &H00080000
%GCP_MAXEXTENT       = &H00100000
%GCP_JUSTIFYIN       = &H00200000
%GCP_DISPLAYZWG      = &H00400000
%GCP_SYMSWAPOFF      = &H00800000
%GCP_NUMERICOVERRIDE = &H01000000
%GCP_NEUTRALOVERRIDE = &H02000000
%GCP_NUMERICSLATIN   = &H04000000
%GCP_NUMERICSLOCAL   = &H08000000

%GCPCLASS_LATIN                  = 1
%GCPCLASS_HEBREW                 = 2
%GCPCLASS_ARABIC                 = 2
%GCPCLASS_NEUTRAL                = 3
%GCPCLASS_LOCALNUMBER            = 4
%GCPCLASS_LATINNUMBER            = 5
%GCPCLASS_LATINNUMERICTERMINATOR = 6
%GCPCLASS_LATINNUMERICSEPARATOR  = 7
%GCPCLASS_NUMERICSEPARATOR       = 8
%GCPCLASS_PREBOUNDRTL            = &H80
%GCPCLASS_PREBOUNDLTR            = &H40
%GCPCLASS_POSTBOUNDLTR           = &H20
%GCPCLASS_POSTBOUNDRTL           = &H10

%GCPGLYPH_LINKBEFORE = &H8000
%GCPGLYPH_LINKAFTER  = &H4000

' bits defined in wFlags of RASTERIZER_STATUS
%TT_AVAILABLE    = &H0001
%TT_ENABLED      = &H0002

' pixel types
%PFD_TYPE_RGBA       = 0
%PFD_TYPE_COLORINDEX = 1

' layer types
%PFD_MAIN_PLANE     = 0
%PFD_OVERLAY_PLANE  = 1
%PFD_UNDERLAY_PLANE = -1

' PIXELFORMATDESCRIPTOR flags
%PFD_DOUBLEBUFFER          = &H00000001
%PFD_STEREO                = &H00000002
%PFD_DRAW_TO_WINDOW        = &H00000004
%PFD_DRAW_TO_BITMAP        = &H00000008
%PFD_SUPPORT_GDI           = &H00000010
%PFD_SUPPORT_OPENGL        = &H00000020
%PFD_GENERIC_FORMAT        = &H00000040
%PFD_NEED_PALETTE          = &H00000080
%PFD_NEED_SYSTEM_PALETTE   = &H00000100
%PFD_SWAP_EXCHANGE         = &H00000200
%PFD_SWAP_COPY             = &H00000400
%PFD_SWAP_LAYER_BUFFERS    = &H00000800
%PFD_GENERIC_ACCELERATED   = &H00001000
%PFD_SUPPORT_DIRECTDRAW    = &H00002000

' PIXELFORMATDESCRIPTOR flags for use in ChoosePixelFormat only
%PFD_DEPTH_DONTCARE        = &H20000000
%PFD_DOUBLEBUFFER_DONTCARE = &H40000000
%PFD_STEREO_DONTCARE       = &H80000000

'  mode selections for the device mode function
%DM_UPDATE      = 1
%DM_COPY        = 2
%DM_PROMPT      = 4
%DM_MODIFY      = 8

%DM_IN_BUFFER   = %DM_MODIFY
%DM_IN_PROMPT   = %DM_PROMPT
%DM_OUT_BUFFER  = %DM_COPY
%DM_OUT_DEFAULT = %DM_UPDATE

'  device capabilities indices
%DC_FIELDS            = 1
%DC_PAPERS            = 2
%DC_PAPERSIZE         = 3
%DC_MINEXTENT         = 4
%DC_MAXEXTENT         = 5
%DC_BINS              = 6
%DC_DUPLEX            = 7
%DC_SIZE              = 8
%DC_EXTRA             = 9
%DC_VERSION           = 10
%DC_DRIVER            = 11
%DC_BINNAMES          = 12
%DC_ENUMRESOLUTIONS   = 13
%DC_FILEDEPENDENCIES  = 14
%DC_TRUETYPE          = 15
%DC_PAPERNAMES        = 16
%DC_ORIENTATION       = 17
%DC_COPIES            = 18
%DC_BINADJUST         = 19
%DC_EMF_COMPLIANT     = 20
%DC_DATATYPE_PRODUCED = 21
%DC_COLLATE           = 22
%DC_MANUFACTURER      = 23
%DC_MODEL             = 24

%DC_COLORDEVICE       = 23
%DC_NUP               = 24
%DC_PERSONALITY       = 25
%DC_PRINTRATE         = 26
%DC_PRINTRATEUNIT     = 27
%PRINTRATEUNIT_PPM  = 1
%PRINTRATEUNIT_CPS  = 2
%PRINTRATEUNIT_LPM  = 3
%PRINTRATEUNIT_IPM  = 4
%DC_PRINTERMEM        = 28
%DC_MEDIAREADY        = 29

' bit fields of the return value (DWORD) for DC_TRUETYPE
%DCTT_BITMAP           = &H00000001
%DCTT_DOWNLOAD         = &H00000002
%DCTT_SUBDEV           = &H00000004
%DCTT_DOWNLOAD_OUTLINE = &H00000008

' return values for DC_BINADJUST
%DCBA_FACEUPNONE     = &H0000
%DCBA_FACEUPCENTER   = &H0001
%DCBA_FACEUPLEFT     = &H0002
%DCBA_FACEUPRIGHT    = &H0003
%DCBA_FACEDOWNNONE   = &H0100
%DCBA_FACEDOWNCENTER = &H0101
%DCBA_FACEDOWNLEFT   = &H0102
%DCBA_FACEDOWNRIGHT  = &H0103

' flags for GetGlyphIndices
%GGI_MARK_NONEXISTING_GLYPHS = &H0001

%STAMP_DESIGNVECTOR = &H08007664   ' (0x8000000 + 'd' + ('v' << 8))
%STAMP_AXESLIST     = &H08006C61   ' (0x8000000 + 'a' + ('l' << 8))
%MM_MAX_NUMAXES     = 16

%FR_PRIVATE  = &H10
%FR_NOT_ENUM = &H20

' The actual size of the DESIGNVECTOR and ENUMLOGFONTEXDV structures
' is determined by dvNumAxes,
' MM_MAX_NUMAXES only detemines the maximal size allowed

%MM_MAX_AXES_NAMELEN = 16

' currently defined blend function

%AC_SRC_OVER             = &H00

' alpha format flags

%AC_SRC_NO_PREMULT_ALPHA = &H01
%AC_SRC_NO_ALPHA         = &H02
%AC_DST_NO_PREMULT_ALPHA = &H10
%AC_DST_NO_ALPHA         = &H20

' gradient drawing modes
'
%GRADIENT_FILL_RECT_H   = &H00000000
%GRADIENT_FILL_RECT_V   = &H00000001
%GRADIENT_FILL_TRIANGLE = &H00000002
%GRADIENT_FILL_OP_FLAG  = &H000000ff


' Flags value for COLORADJUSTMENT
%CA_NEGATIVE   = &H0001
%CA_LOG_FILTER = &H0002

' IlluminantIndex values
%ILLUMINANT_DEVICE_DEFAULT = 0
%ILLUMINANT_A              = 1
%ILLUMINANT_B              = 2
%ILLUMINANT_C              = 3
%ILLUMINANT_D50            = 4
%ILLUMINANT_D55            = 5
%ILLUMINANT_D65            = 6
%ILLUMINANT_D75            = 7
%ILLUMINANT_F2             = 8
%ILLUMINANT_MAX_INDEX      = %ILLUMINANT_F2

%ILLUMINANT_TUNGSTEN       = %ILLUMINANT_A
%ILLUMINANT_DAYLIGHT       = %ILLUMINANT_C
%ILLUMINANT_FLUORESCENT    = %ILLUMINANT_F2
%ILLUMINANT_NTSC           = %ILLUMINANT_C

' Min and max for RedGamma, GreenGamma, BlueGamma
%RGB_GAMMA_MIN = 2500??
%RGB_GAMMA_MAX = 65000??

' Min and max for ReferenceBlack and ReferenceWhite
%REFERENCE_WHITE_MIN = 6000??
%REFERENCE_WHITE_MAX = 10000??
%REFERENCE_BLACK_MIN = 0??
%REFERENCE_BLACK_MAX = 4000??

' Min and max for Contrast, Brightness, Colorfulness, RedGreenTint
%COLOR_ADJ_MIN = -100%
%COLOR_ADJ_MAX = 100%

%DI_APPBANDING            = &H00000001
%DI_ROPS_READ_DESTINATION = &H00000002

%FONTMAPPER_MAX = 10

%ICM_OFF            = 1
%ICM_ON             = 2
%ICM_QUERY          = 3
%ICM_DONE_OUTSIDEDC = 4

#IF NOT %DEF(%NOMETAFILE) '----------------------------------------------------

%ENHMETA_SIGNATURE = &H464D4520

' Stock object flag used in the object handle index in the enhanced
' metafile records.
' E.g. The object xHandle index (%META_STOCK_OBJECT OR %BLACK_BRUSH)
' represents the stock object %BLACK_BRUSH.

%ENHMETA_STOCK_OBJECT = &H80000000

' Enhanced metafile record types.

%EMR_HEADER                  = 1
%EMR_POLYBEZIER              = 2
%EMR_POLYGON                 = 3
%EMR_POLYLINE                = 4
%EMR_POLYBEZIERTO            = 5
%EMR_POLYLINETO              = 6
%EMR_POLYPOLYLINE            = 7
%EMR_POLYPOLYGON             = 8
%EMR_SETWINDOWEXTEX          = 9
%EMR_SETWINDOWORGEX          = 10
%EMR_SETVIEWPORTEXTEX        = 11
%EMR_SETVIEWPORTORGEX        = 12
%EMR_SETBRUSHORGEX           = 13
%EMR_EOF                     = 14
%EMR_SETPIXELV               = 15
%EMR_SETMAPPERFLAGS          = 16
%EMR_SETMAPMODE              = 17
%EMR_SETBKMODE               = 18
%EMR_SETPOLYFILLMODE         = 19
%EMR_SETROP2                 = 20
%EMR_SETSTRETCHBLTMODE       = 21
%EMR_SETTEXTALIGN            = 22
%EMR_SETCOLORADJUSTMENT      = 23
%EMR_SETTEXTCOLOR            = 24
%EMR_SETBKCOLOR              = 25
%EMR_OFFSETCLIPRGN           = 26
%EMR_MOVETOEX                = 27
%EMR_SETMETARGN              = 28
%EMR_EXCLUDECLIPRECT         = 29
%EMR_INTERSECTCLIPRECT       = 30
%EMR_SCALEVIEWPORTEXTEX      = 31
%EMR_SCALEWINDOWEXTEX        = 32
%EMR_SAVEDC                  = 33
%EMR_RESTOREDC               = 34
%EMR_SETWORLDTRANSFORM       = 35
%EMR_MODIFYWORLDTRANSFORM    = 36
%EMR_SELECTOBJECT            = 37
%EMR_CREATEPEN               = 38
%EMR_CREATEBRUSHINDIRECT     = 39
%EMR_DELETEOBJECT            = 40
%EMR_ANGLEARC                = 41
%EMR_ELLIPSE                 = 42
%EMR_RECTANGLE               = 43
%EMR_ROUNDRECT               = 44
%EMR_ARC                     = 45
%EMR_CHORD                   = 46
%EMR_PIE                     = 47
%EMR_SELECTPALETTE           = 48
%EMR_CREATEPALETTE           = 49
%EMR_SETPALETTEENTRIES       = 50
%EMR_RESIZEPALETTE           = 51
%EMR_REALIZEPALETTE          = 52
%EMR_EXTFLOODFILL            = 53
%EMR_LINETO                  = 54
%EMR_ARCTO                   = 55
%EMR_POLYDRAW                = 56
%EMR_SETARCDIRECTION         = 57
%EMR_SETMITERLIMIT           = 58
%EMR_BEGINPATH               = 59
%EMR_ENDPATH                 = 60
%EMR_CLOSEFIGURE             = 61
%EMR_FILLPATH                = 62
%EMR_STROKEANDFILLPATH       = 63
%EMR_STROKEPATH              = 64
%EMR_FLATTENPATH             = 65
%EMR_WIDENPATH               = 66
%EMR_SELECTCLIPPATH          = 67
%EMR_ABORTPATH               = 68

%EMR_GDICOMMENT              = 70
%EMR_FILLRGN                 = 71
%EMR_FRAMERGN                = 72
%EMR_INVERTRGN               = 73
%EMR_PAINTRGN                = 74
%EMR_EXTSELECTCLIPRGN        = 75
%EMR_BITBLT                  = 76
%EMR_STRETCHBLT              = 77
%EMR_MASKBLT                 = 78
%EMR_PLGBLT                  = 79
%EMR_SETDIBITSTODEVICE       = 80
%EMR_STRETCHDIBITS           = 81
%EMR_EXTCREATEFONTINDIRECTW  = 82
%EMR_EXTTEXTOUTA             = 83
%EMR_EXTTEXTOUTW             = 84
%EMR_POLYBEZIER16            = 85
%EMR_POLYGON16               = 86
%EMR_POLYLINE16              = 87
%EMR_POLYBEZIERTO16          = 88
%EMR_POLYLINETO16            = 89
%EMR_POLYPOLYLINE16          = 90
%EMR_POLYPOLYGON16           = 91
%EMR_POLYDRAW16              = 92
%EMR_CREATEMONOBRUSH         = 93
%EMR_CREATEDIBPATTERNBRUSHPT = 94
%EMR_EXTCREATEPEN            = 95
%EMR_POLYTEXTOUTA            = 96
%EMR_POLYTEXTOUTW            = 97

%EMR_SETICMMODE              = 98
%EMR_CREATECOLORSPACE        = 99
%EMR_SETCOLORSPACE           = 100
%EMR_DELETECOLORSPACE        = 101
%EMR_GLSRECORD               = 102
%EMR_GLSBOUNDEDRECORD        = 103
%EMR_PIXELFORMAT             = 104

%EMR_DRAWESCAPE              = 105
%EMR_EXTESCAPE               = 106
%EMR_STARTDOC                = 107
%EMR_SMALLTEXTOUT            = 108
%EMR_FORCEUFIMAPPING         = 109
%EMR_NAMEDESCAPE             = 110
%EMR_COLORCORRECTPALETTE     = 111
%EMR_SETICMPROFILEA          = 112
%EMR_SETICMPROFILEW          = 113
%EMR_ALPHABLEND              = 114
%EMR_ALPHADIBBLEND           = 115
%EMR_TRANSPARENTBLT          = 116
%EMR_TRANSPARENTDIB          = 117
%EMR_GRADIENTFILL            = 118
%EMR_SETLINKEDUFIS           = 119
%EMR_SETTEXTJUSTIFICATION    = 120

%EMR_MIN                     = 1
%EMR_MAX                     = 120 ' depending on Windows version, may be 97, 104, or 120 (so far)

%SETICMPROFILE_EMBEDED = &H00000001

%GDICOMMENT_IDENTIFIER       = &H43494447
%GDICOMMENT_WINDOWS_METAFILE = &H80000001
%GDICOMMENT_BEGINGROUP       = &H00000002
%GDICOMMENT_ENDGROUP         = &H00000003
%GDICOMMENT_MULTIFORMATS     = &H40000004
%EPS_SIGNATURE               = &H46535045

#ENDIF ' #IF NOT %DEF(%NOMETAFILE) --------------------------------------------

%WGL_FONT_LINES    = 0
%WGL_FONT_POLYGONS = 1

' LAYERPLANEDESCRIPTOR flags
%LPD_DOUBLEBUFFER   = &H00000001
%LPD_STEREO         = &H00000002
%LPD_SUPPORT_GDI    = &H00000010
%LPD_SUPPORT_OPENGL = &H00000020
%LPD_SHARE_DEPTH    = &H00000040
%LPD_SHARE_STENCIL  = &H00000080
%LPD_SHARE_ACCUM    = &H00000100
%LPD_SWAP_EXCHANGE  = &H00000200
%LPD_SWAP_COPY      = &H00000400
%LPD_TRANSPARENT    = &H00001000

%LPD_TYPE_RGBA       = 0
%LPD_TYPE_COLORINDEX = 1

' wglSwapLayerBuffers flags
%WGL_SWAP_MAIN_PLANE = &H00000001
%WGL_SWAP_OVERLAY1   = &H00000002
%WGL_SWAP_OVERLAY2   = &H00000004
%WGL_SWAP_OVERLAY3   = &H00000008
%WGL_SWAP_OVERLAY4   = &H00000010
%WGL_SWAP_OVERLAY5   = &H00000020
%WGL_SWAP_OVERLAY6   = &H00000040
%WGL_SWAP_OVERLAY7   = &H00000080
%WGL_SWAP_OVERLAY8   = &H00000100
%WGL_SWAP_OVERLAY9   = &H00000200
%WGL_SWAP_OVERLAY10  = &H00000400
%WGL_SWAP_OVERLAY11  = &H00000800
%WGL_SWAP_OVERLAY12  = &H00001000
%WGL_SWAP_OVERLAY13  = &H00002000
%WGL_SWAP_OVERLAY14  = &H00004000
%WGL_SWAP_OVERLAY15  = &H00008000
%WGL_SWAP_UNDERLAY1  = &H00010000
%WGL_SWAP_UNDERLAY2  = &H00020000
%WGL_SWAP_UNDERLAY3  = &H00040000
%WGL_SWAP_UNDERLAY4  = &H00080000
%WGL_SWAP_UNDERLAY5  = &H00100000
%WGL_SWAP_UNDERLAY6  = &H00200000
%WGL_SWAP_UNDERLAY7  = &H00400000
%WGL_SWAP_UNDERLAY8  = &H00800000
%WGL_SWAP_UNDERLAY9  = &H01000000
%WGL_SWAP_UNDERLAY10 = &H02000000
%WGL_SWAP_UNDERLAY11 = &H04000000
%WGL_SWAP_UNDERLAY12 = &H08000000
%WGL_SWAP_UNDERLAY13 = &H10000000
%WGL_SWAP_UNDERLAY14 = &H20000000
%WGL_SWAP_UNDERLAY15 = &H40000000

%WGL_SWAPMULTIPLE_MAX = 16

#ENDIF ' #IF NOT %DEF(%NOGDI) -------------------------------------------------

' End of constants from wingdi.h ==============================================

'* WM_PRINT flags
%PRF_CHECKVISIBLE    = &H00000001&
%PRF_NONCLIENT       = &H00000002&
%PRF_CLIENT          = &H00000004&
%PRF_ERASEBKGND      = &H00000008&
%PRF_CHILDREN        = &H00000010&
%PRF_OWNED           = &H00000020&

'* 3D border styles
%BDR_RAISEDOUTER     = &H0001
%BDR_SUNKENOUTER     = &H0002
%BDR_RAISEDINNER     = &H0004
%BDR_SUNKENINNER     = &H0008

%BDR_OUTER           = &H0003
%BDR_RAISED          = &H0005
%BDR_SUNKEN          = &H000A
%BDR_INNER           = &H000C

%EDGE_RAISED         = %BDR_RAISEDOUTER OR %BDR_RAISEDINNER
%EDGE_SUNKEN         = %BDR_SUNKENOUTER OR %BDR_SUNKENINNER
%EDGE_ETCHED         = %BDR_SUNKENOUTER OR %BDR_RAISEDINNER
%EDGE_BUMP           = %BDR_RAISEDOUTER OR %BDR_SUNKENINNER

'* Border flags
%BF_LEFT             = &H0001
%BF_TOP              = &H0002
%BF_RIGHT            = &H0004
%BF_BOTTOM           = &H0008

%BF_TOPLEFT          = %BF_TOP OR %BF_LEFT
%BF_TOPRIGHT         = %BF_TOP OR %BF_RIGHT
%BF_BOTTOMLEFT       = %BF_BOTTOM OR %BF_LEFT
%BF_BOTTOMRIGHT      = %BF_BOTTOM OR %BF_RIGHT
%BF_RECT             = %BF_LEFT OR %BF_TOP OR %BF_RIGHT OR %BF_BOTTOM

%BF_DIAGONAL         = &H0010

' For diagonal lines, the BF_RECT flags specify the end point of the
' vector bounded by the rectangle parameter.
%BF_DIAGONAL_ENDTOPRIGHT    = %BF_DIAGONAL OR %BF_TOP OR %BF_RIGHT
%BF_DIAGONAL_ENDTOPLEFT     = %BF_DIAGONAL OR %BF_TOP OR %BF_LEFT
%BF_DIAGONAL_ENDBOTTOMLEFT  = %BF_DIAGONAL OR %BF_BOTTOM OR %BF_LEFT
%BF_DIAGONAL_ENDBOTTOMRIGHT = %BF_DIAGONAL OR %BF_BOTTOM OR %BF_RIGHT

%BF_MIDDLE  = &H0800  '* Fill in the middle
%BF_SOFT    = &H1000  '* For softer buttons
%BF_ADJUST  = &H2000  '* Calculate the space left over
%BF_FLAT    = &H4000  '* For flat rather than 3D borders
%BF_MONO    = &H8000  '* For monochrome borders

' flags for HIGHCONTRAST dwFlags field
%HCF_HIGHCONTRASTON  = &H00000001
%HCF_AVAILABLE       = &H00000002
%HCF_HOTKEYACTIVE    = &H00000004
%HCF_CONFIRMHOTKEY   = &H00000008
%HCF_HOTKEYSOUND     = &H00000010
%HCF_INDICATOR       = &H00000020
%HCF_HOTKEYAVAILABLE = &H00000040

' flags for ChangeDisplaySettings
%CDS_UPDATEREGISTRY  = &H00000001
%CDS_TEST            = &H00000002
%CDS_FULLSCREEN      = &H00000004
%CDS_GLOBAL          = &H00000008
%CDS_SET_PRIMARY     = &H00000010
%CDS_VIDEOPARAMETERS = &H00000020
%CDS_RESET           = &H40000000
%CDS_NORESET         = &H10000000

#IF NOT %DEF(%TVOUT_INC) '----------------------------
%TVOUT_INC = 1

%VP_COMMAND_GET          = &H0001  ' size set, return caps.
                                   ' returned Flags = 0 if not supported.
%VP_COMMAND_SET          = &H0002  ' size and params set.

%VP_FLAGS_TV_MODE        = &H0001
%VP_FLAGS_TV_STANDARD    = &H0002
%VP_FLAGS_FLICKER        = &H0004
%VP_FLAGS_OVERSCAN       = &H0008
%VP_FLAGS_MAX_UNSCALED   = &H0010  ' do not use on SET
%VP_FLAGS_POSITION       = &H0020
%VP_FLAGS_BRIGHTNESS     = &H0040
%VP_FLAGS_CONTRAST       = &H0080
%VP_FLAGS_COPYPROTECT    = &H0100

%VP_MODE_WIN_GRAPHICS    = &H0001
%VP_MODE_TV_PLAYBACK     = &H0002  ' optimize for TV video playback

%VP_TV_STANDARD_NTSC_M   = &H0001  '        75 IRE Setup
%VP_TV_STANDARD_NTSC_M_J = &H0002  ' Japan,  0 IRE Setup
%VP_TV_STANDARD_PAL_B    = &H0004
%VP_TV_STANDARD_PAL_D    = &H0008
%VP_TV_STANDARD_PAL_H    = &H0010
%VP_TV_STANDARD_PAL_I    = &H0020
%VP_TV_STANDARD_PAL_M    = &H0040
%VP_TV_STANDARD_PAL_N    = &H0080
%VP_TV_STANDARD_SECAM_B  = &H0100
%VP_TV_STANDARD_SECAM_D  = &H0200
%VP_TV_STANDARD_SECAM_G  = &H0400
%VP_TV_STANDARD_SECAM_H  = &H0800
%VP_TV_STANDARD_SECAM_K  = &H1000
%VP_TV_STANDARD_SECAM_K1 = &H2000
%VP_TV_STANDARD_SECAM_L  = &H4000
%VP_TV_STANDARD_WIN_VGA  = &H8000
' and the rest
%VP_TV_STANDARD_NTSC_433 = &H00010000
%VP_TV_STANDARD_PAL_G    = &H00020000
%VP_TV_STANDARD_PAL_60   = &H00040000
%VP_TV_STANDARD_SECAM_L1 = &H00080000

%VP_CP_TYPE_APS_TRIGGER  = &H0001  ' DVD trigger bits only
%VP_CP_TYPE_MACROVISION  = &H0002  ' full macrovision data available

%VP_CP_CMD_ACTIVATE      = &H0001  ' CP command type
%VP_CP_CMD_DEACTIVATE    = &H0002
%VP_CP_CMD_CHANGE        = &H0004
#ENDIF ' #IF NOT %DEF(%TVOUT_INC) --------------------

' Return values for ChangeDisplaySettings
%DISP_CHANGE_SUCCESSFUL =  0
%DISP_CHANGE_RESTART    =  1
%DISP_CHANGE_FAILED     = -1
%DISP_CHANGE_BADMODE    = -2
%DISP_CHANGE_NOTUPDATED = -3
%DISP_CHANGE_BADFLAGS   = -4
%DISP_CHANGE_BADPARAM   = -5

%ENUM_CURRENT_SETTINGS  = &HFFFFFFFF???
%ENUM_REGISTRY_SETTINGS = &HFFFFFFFE???

' Flags for EnumDisplaySettingsEx
%EDS_RAWMODE = &H00000002

' Scroll Bar Constants
%SB_HORZ = 0
%SB_VERT = 1
%SB_CTL  = 2
%SB_BOTH = 3

' Scroll Bar Commands
%SB_LINEUP        = 0
%SB_LINELEFT      = 0
%SB_LINEDOWN      = 1
%SB_LINERIGHT     = 1
%SB_PAGEUP        = 2
%SB_PAGELEFT      = 2
%SB_PAGEDOWN      = 3
%SB_PAGERIGHT     = 3
%SB_THUMBPOSITION = 4
%SB_THUMBTRACK    = 5
%SB_TOP           = 6
%SB_LEFT          = 6
%SB_BOTTOM        = 7
%SB_RIGHT         = 7
%SB_ENDSCROLL     = 8

%SBM_SETSCROLLINFO = &H00E9
%SBM_GETSCROLLINFO = &H00EA

%SIF_RANGE           = &H0001
%SIF_PAGE            = &H0002
%SIF_POS             = &H0004
%SIF_DISABLENOSCROLL = &H0008
%SIF_TRACKPOS        = &H0010
%SIF_ALL             = %SIF_RANGE OR %SIF_PAGE OR %SIF_POS OR %SIF_TRACKPOS

' ShowWindow() Commands
%SW_HIDE            = 0
%SW_SHOWNORMAL      = 1
%SW_NORMAL          = 1
%SW_SHOWMINIMIZED   = 2
%SW_SHOWMAXIMIZED   = 3
%SW_MAXIMIZE        = 3
%SW_SHOWNOACTIVATE  = 4
%SW_SHOW            = 5
%SW_MINIMIZE        = 6
%SW_SHOWMINNOACTIVE = 7
%SW_SHOWNA          = 8
%SW_RESTORE         = 9
%SW_SHOWDEFAULT     = 10
%SW_MAX             = 10

' Old ShowWindow() Commands
%HIDE_WINDOW         = 0
%SHOW_OPENWINDOW     = 1
%SHOW_ICONWINDOW     = 2
%SHOW_FULLSCREEN     = 3
%SHOW_OPENNOACTIVATE = 4

' Identifiers for the WM_SHOWWINDOW message
%SW_PARENTCLOSING = 1
%SW_OTHERZOOM     = 2
%SW_PARENTOPENING = 3
%SW_OTHERUNZOOM   = 4

' AnimateWindow() Commands
%AW_HOR_POSITIVE = &H00000001
%AW_HOR_NEGATIVE = &H00000002
%AW_VER_POSITIVE = &H00000004
%AW_VER_NEGATIVE = &H00000008
%AW_CENTER       = &H00000010
%AW_HIDE         = &H00010000
%AW_ACTIVATE     = &H00020000
%AW_SLIDE        = &H00040000
%AW_BLEND        = &H00080000

' WM_KEYUP/DOWN/CHAR HIWORD(lParam) flags
%KF_EXTENDED = &H100
%KF_DLGMODE  = &H800
%KF_MENUMODE = &H1000
%KF_ALTDOWN  = &H2000
%KF_REPEAT   = &H4000
%KF_UP       = &H8000

' Virtual Keys, Standard Set
%VK_LBUTTON  = &H01
%VK_RBUTTON  = &H02
%VK_CANCEL   = &H03
%VK_MBUTTON  = &H04    ' NOT contiguous with L RBUTTON
%VK_XBUTTON1 = &H05    ' NOT contiguous with L & RBUTTON
%VK_XBUTTON2 = &H06    ' NOT contiguous with L & RBUTTON
%VK_BACK     = &H08
%VK_TAB      = &H09
%VK_LINEFEED = &H0A
%VK_CLEAR    = &H0C
%VK_RETURN   = &H0D
%VK_SHIFT    = &H10
%VK_CONTROL  = &H11
%VK_MENU     = &H12
%VK_PAUSE    = &H13
%VK_CAPITAL  = &H14
%VK_ESCAPE   = &H1B
%VK_SPACE    = &H20
%VK_PGUP     = &H21
%VK_PRIOR    = &H21
%VK_NEXT     = &H22
%VK_PGDN     = &H22
%VK_END      = &H23
%VK_HOME     = &H24
%VK_LEFT     = &H25
%VK_UP       = &H26
%VK_RIGHT    = &H27
%VK_DOWN     = &H28
%VK_SELECT   = &H29
%VK_PRINT    = &H2A
%VK_EXECUTE  = &H2B
%VK_SNAPSHOT = &H2C
%VK_INSERT   = &H2D
%VK_DELETE   = &H2E
%VK_HELP     = &H2F

' VK_A thru VK_Z are the same as their ASCII equivalents: 'A' thru 'Z'

%VK_A        = &H41
%VK_B        = &H42
%VK_C        = &H43
%VK_D        = &H44
%VK_E        = &H45
%VK_F        = &H46
%VK_G        = &H47
%VK_H        = &H48
%VK_I        = &H49
%VK_J        = &H4A
%VK_K        = &H4B
%VK_L        = &H4C
%VK_M        = &H4D
%VK_N        = &H4E
%VK_O        = &H4F
%VK_P        = &H50
%VK_Q        = &H51
%VK_R        = &H52
%VK_S        = &H53
%VK_T        = &H54
%VK_U        = &H55
%VK_V        = &H56
%VK_W        = &H57
%VK_X        = &H58
%VK_Y        = &H59
%VK_Z        = &H5A

' VK_0 thru VK_9 are the same as their ASCII equivalents: '0' thru '9'

%VK_0        = &H30
%VK_1        = &H31
%VK_2        = &H32
%VK_3        = &H33
%VK_4        = &H34
%VK_5        = &H35
%VK_6        = &H36
%VK_7        = &H37
%VK_8        = &H38
%VK_9        = &H39

%VK_NUMPAD0  = &H60
%VK_NUMPAD1  = &H61
%VK_NUMPAD2  = &H62
%VK_NUMPAD3  = &H63
%VK_NUMPAD4  = &H64
%VK_NUMPAD5  = &H65
%VK_NUMPAD6  = &H66
%VK_NUMPAD7  = &H67
%VK_NUMPAD8  = &H68
%VK_NUMPAD9  = &H69
%VK_MULTIPLY = &H6A
%VK_ADD      = &H6B
%VK_SEPARATOR= &H6C
%VK_SUBTRACT = &H6D
%VK_DECIMAL  = &H6E
%VK_DIVIDE   = &H6F
%VK_F1       = &H70
%VK_F2       = &H71
%VK_F3       = &H72
%VK_F4       = &H73
%VK_F5       = &H74
%VK_F6       = &H75
%VK_F7       = &H76
%VK_F8       = &H77
%VK_F9       = &H78
%VK_F10      = &H79
%VK_F11      = &H7A
%VK_F12      = &H7B
%VK_F13      = &H7C
%VK_F14      = &H7D
%VK_F15      = &H7E
%VK_F16      = &H7F
%VK_F17      = &H80
%VK_F18      = &H81
%VK_F19      = &H82
%VK_F20      = &H83
%VK_F21      = &H84
%VK_F22      = &H85
%VK_F23      = &H86
%VK_F24      = &H87
%VK_NUMLOCK  = &H90
%VK_SCROLL   = &H91

' VK_L VK_R - left and right Alt, Ctrl and Shift virtual keys.
' Used only as parameters to GetAsyncKeyState() and GetKeyState().
' No other API or message will distinguish left and right keys in this way.

%VK_LSHIFT   = &HA0
%VK_RSHIFT   = &HA1
%VK_LCONTROL = &HA2
%VK_RCONTROL = &HA3
%VK_LMENU    = &HA4
%VK_RMENU    = &HA5

%VK_BROWSER_BACK        = &HA6
%VK_BROWSER_FORWARD     = &HA7
%VK_BROWSER_REFRESH     = &HA8
%VK_BROWSER_STOP        = &HA9
%VK_BROWSER_SEARCH      = &HAA
%VK_BROWSER_FAVORITES   = &HAB
%VK_BROWSER_HOME        = &HAC

%VK_VOLUME_MUTE         = &HAD
%VK_VOLUME_DOWN         = &HAE
%VK_VOLUME_UP           = &HAF
%VK_MEDIA_NEXT_TRACK    = &HB0
%VK_MEDIA_PREV_TRACK    = &HB1
%VK_MEDIA_STOP          = &HB2
%VK_MEDIA_PLAY_PAUSE    = &HB3
%VK_LAUNCH_MAIL         = &HB4
%VK_LAUNCH_MEDIA_SELECT = &HB5
%VK_LAUNCH_APP1         = &HB6
%VK_LAUNCH_APP2         = &HB7

%VK_OEM_1        = &HBA   ' ";:" for US
%VK_OEM_PLUS     = &HBB   ' "+" any country
%VK_OEM_COMMA    = &HBC   ' "," any country
%VK_OEM_MINUS    = &HBD   ' "-" any country
%VK_OEM_PERIOD   = &HBE   ' "." any country
%VK_OEM_2        = &HBF   ' "/?" for US
%VK_OEM_3        = &HC0   ' "`~" for US

' 0xC1 - 0xD7 : reserved

' 0xD8 - 0xDA : unassigned

%VK_OEM_4        = &HDB  '  "[{" for US
%VK_OEM_5        = &HDC  '  "\|" for US
%VK_OEM_6        = &HDD  '  "]}" for US
%VK_OEM_7        = &HDE  '  """" for US
%VK_OEM_8        = &HDF

' 0xE0 : reserved

' Various extended or enhanced keyboards
%VK_OEM_AX       = &HE1  '  "AX" key on Japanese AX kbd
%VK_OEM_102      = &HE2  '  "<>" or "\|" on RT 102-key kbd.
%VK_ICO_HELP     = &HE3  '  Help key on ICO
%VK_ICO_00       = &HE4  '  00 key on ICO

%VK_PROCESSKEY   = &HE5

%VK_ICO_CLEAR    = &HE6


%VK_PACKET       = &HE7

' 0xE8 : unassigned

' Nokia/Ericsson definitions
%VK_OEM_RESET    = &HE9
%VK_OEM_JUMP     = &HEA
%VK_OEM_PA1      = &HEB
%VK_OEM_PA2      = &HEC
%VK_OEM_PA3      = &HED
%VK_OEM_WSCTRL   = &HEE
%VK_OEM_CUSEL    = &HEF
%VK_OEM_ATTN     = &HF0
%VK_OEM_FINISH   = &HF1
%VK_OEM_COPY     = &HF2
%VK_OEM_AUTO     = &HF3
%VK_OEM_ENLW     = &HF4
%VK_OEM_BACKTAB  = &HF5

%VK_ATTN     = &HF6
%VK_CRSEL    = &HF7
%VK_EXSEL    = &HF8
%VK_EREOF    = &HF9
%VK_PLAY     = &HFA
%VK_ZOOM     = &HFB
%VK_NONAME   = &HFC
%VK_PA1      = &HFD
%VK_OEM_CLEAR= &HFE

' 0xFF : reserved

' SetWindowsHook() codes
%WH_MIN             = -1
%WH_MSGFILTER       = -1
%WH_JOURNALRECORD   = 0
%WH_JOURNALPLAYBACK = 1
%WH_KEYBOARD        = 2
%WH_GETMESSAGE      = 3
%WH_CALLWNDPROC     = 4
%WH_CBT             = 5
%WH_SYSMSGFILTER    = 6
%WH_MOUSE           = 7
%WH_HARDWARE        = 8
%WH_DEBUG           = 9
%WH_SHELL           = 10
%WH_FOREGROUNDIDLE  = 11
%WH_CALLWNDPROCRET  = 12
%WH_KEYBOARD_LL     = 13
%WH_MOUSE_LL        = 14
%WH_MAX             = 14   ' depending on Windows version

' Hook Codes
%HC_ACTION      = 0
%HC_GETNEXT     = 1
%HC_SKIP        = 2
%HC_NOREMOVE    = 3
%HC_NOREM       = %HC_NOREMOVE
%HC_SYSMODALON  = 4
%HC_SYSMODALOFF = 5

' CBT Hook Codes
%HCBT_MOVESIZE     = 0
%HCBT_MINMAX       = 1
%HCBT_QS           = 2
%HCBT_CREATEWND    = 3
%HCBT_DESTROYWND   = 4
%HCBT_ACTIVATE     = 5
%HCBT_CLICKSKIPPED = 6
%HCBT_KEYSKIPPED   = 7
%HCBT_SYSCOMMAND   = 8
%HCBT_SETFOCUS     = 9

%HSHELL_WINDOWCREATED       = 1
%HSHELL_WINDOWDESTROYED     = 2
%HSHELL_ACTIVATESHELLWINDOW = 3
%HSHELL_WINDOWACTIVATED     = 4
%HSHELL_GETMINRECT          = 5
%HSHELL_REDRAW              = 6
%HSHELL_TASKMAN             = 7
%HSHELL_LANGUAGE            = 8
%HSHELL_ACCESSIBILITYSTATE  = 11
%HSHELL_APPCOMMAND          = 12

' wparam for HSHELL_ACCESSIBILITYSTATE
%ACCESS_STICKYKEYS = &H0001
%ACCESS_FILTERKEYS = &H0002
%ACCESS_MOUSEKEYS  = &H0003

' cmd for HSHELL_APPCOMMAND and WM_APPCOMMAND
%APPCOMMAND_BROWSER_BACKWARD     = 1
%APPCOMMAND_BROWSER_FORWARD      = 2
%APPCOMMAND_BROWSER_REFRESH      = 3
%APPCOMMAND_BROWSER_STOP         = 4
%APPCOMMAND_BROWSER_SEARCH       = 5
%APPCOMMAND_BROWSER_FAVORITES    = 6
%APPCOMMAND_BROWSER_HOME         = 7
%APPCOMMAND_VOLUME_MUTE          = 8
%APPCOMMAND_VOLUME_DOWN          = 9
%APPCOMMAND_VOLUME_UP            = 10
%APPCOMMAND_MEDIA_NEXTTRACK      = 11
%APPCOMMAND_MEDIA_PREVIOUSTRACK  = 12
%APPCOMMAND_MEDIA_STOP           = 13
%APPCOMMAND_MEDIA_PLAY_PAUSE     = 14
%APPCOMMAND_LAUNCH_MAIL          = 15
%APPCOMMAND_LAUNCH_MEDIA_SELECT  = 16
%APPCOMMAND_LAUNCH_APP1          = 17
%APPCOMMAND_LAUNCH_APP2          = 18
%APPCOMMAND_BASS_DOWN            = 19
%APPCOMMAND_BASS_BOOST           = 20
%APPCOMMAND_BASS_UP              = 21
%APPCOMMAND_TREBLE_DOWN          = 22
%APPCOMMAND_TREBLE_UP            = 23

%FAPPCOMMAND_MOUSE = &H08000
%FAPPCOMMAND_KEY   = 0
%FAPPCOMMAND_OEM   = &H01000
%FAPPCOMMAND_MASK  = &H0F000

' Keyboard Layout API
%HKL_PREV = 0
%HKL_NEXT = 1

%KLF_ACTIVATE       = &H1
%KLF_SUBSTITUTE_OK  = &H2
%KLF_UNLOADPREVIOUS = &H4
%KLF_REORDER        = &H8

' Bits in wParam of WM_INPUTLANGCHANGEREQUEST message
%INPUTLANGCHANGE_SYSCHARSET = &H0001
%INPUTLANGCHANGE_FORWARD    = &H0002
%INPUTLANGCHANGE_BACKWARD   = &H0004


' Size of KeyboardLayoutName (number of characters), including nul terminator
%KL_NAMELENGTH = 9

#IF NOT %DEF(%NODESKTOP) '----------------------------
' Desktop-specific access flags
%DESKTOP_READOBJECTS     = &H0001
%DESKTOP_CREATEWINDOW    = &H0002
%DESKTOP_CREATEMENU      = &H0004
%DESKTOP_HOOKCONTROL     = &H0008
%DESKTOP_JOURNALRECORD   = &H0010
%DESKTOP_JOURNALPLAYBACK = &H0020
%DESKTOP_ENUMERATE       = &H0040
%DESKTOP_WRITEOBJECTS    = &H0080
%DESKTOP_SWITCHDESKTOP   = &H0100
#ENDIF ' #IF NOT %DEF(%NODESKTOP) '-------------------

#IF NOT %DEF(%NOWINDOWSTATION) '----------------------
' Windowstation-specific access flags
%WINSTA_ENUMDESKTOPS      = &H0001
%WINSTA_READATTRIBUTES    = &H0002
%WINSTA_ACCESSCLIPBOARD   = &H0004
%WINSTA_CREATEDESKTOP     = &H0008
%WINSTA_WRITEATTRIBUTES   = &H0010
%WINSTA_ACCESSPUBLICATOMS = &H0020
%WINSTA_EXITWINDOWS       = &H0040
%WINSTA_ENUMERATE         = &H0100
%WINSTA_READSCREEN        = &H0200
#ENDIF ' #IF NOT %DEF(%NOWINDOWSTATION) '-------------

#IF NOT %DEF(%NOSECURITY) '---------------------------
%UOI_FLAGS    = 1
%UOI_NAME     = 2
%UOI_TYPE     = 3
%UOI_USER_SID = 4

TYPE USEROBJECTFLAGS
  fInherit AS LONG
  fReserved AS LONG
  dwFlags AS DWORD
END TYPE
#ENDIF ' #IF NOT %DEF(%NOSECURITY) '------------------

' Windowstation-specific attribute flags
%WSF_VISIBLE = 1

#IF NOT %DEF(%NOWINOFFSETS) '-------------------------
' Window field offsets for GetWindowLong() and GetWindowWord()
%GWL_WNDPROC    = -4
%GWL_HINSTANCE  = -6
%GWL_HWNDPARENT = -8
%GWL_STYLE      = -16
%GWL_EXSTYLE    = -20
%GWL_USERDATA   = -21
%GWL_ID         = -12

%GWLP_WNDPROC    = -4
%GWLP_HINSTANCE  = -6
%GWLP_HWNDPARENT = -8
%GWLP_USERDATA   = -21
%GWLP_ID         = -12

' Class field offsets for GetClassLong() and GetClassWord()
%GCL_MENUNAME      = -8
%GCL_HBRBACKGROUND = -10
%GCL_HCURSOR       = -12
%GCL_HICON         = -14
%GCL_HMODULE       = -16
%GCL_CBWNDEXTRA    = -18
%GCL_CBCLSEXTRA    = -20
%GCL_WNDPROC       = -24
%GCL_STYLE         = -26
%GCW_ATOM          = -32
%GCL_HICONSM       = -34

%GCLP_MENUNAME      = -8
%GCLP_HBRBACKGROUND = -10
%GCLP_HCURSOR       = -12
%GCLP_HICON         = -14
%GCLP_HMODULE       = -16
%GCLP_WNDPROC       = -24
%GCLP_HICONSM       = -34
#ENDIF ' #IF NOT %DEF(%NOWINOFFSETS) '----------------

' WH_MSGFILTER Filter Proc Codes
%MSGF_DIALOGBOX  = 0
%MSGF_MESSAGEBOX = 1
%MSGF_MENU       = 2
%MSGF_MOVE       = 3
%MSGF_SIZE       = 4
%MSGF_SCROLLBAR  = 5

' Private Window Messages Start Here:
%WM_USER = &H400

' NOTE: All Message Numbers below &H0400 are RESERVED.

' Window Messages
%WM_NULL    = &H0
%WM_CREATE  = &H1
%WM_DESTROY = &H2
%WM_MOVE    = &H3
%WM_SIZE    = &H5

%WM_ACTIVATE = &H6
'
'  WM_ACTIVATE state values

%WA_INACTIVE    = 0
%WA_ACTIVE      = 1
%WA_CLICKACTIVE = 2

%WM_SETFOCUS         = &H7
%WM_KILLFOCUS        = &H8
%WM_ENABLE           = &HA
%WM_SETREDRAW        = &HB
%WM_SETTEXT          = &HC
%WM_GETTEXT          = &HD
%WM_GETTEXTLENGTH    = &HE
%WM_PAINT            = &HF
%WM_CLOSE            = &H10
%WM_QUERYENDSESSION  = &H11
%WM_QUIT             = &H12
%WM_QUERYOPEN        = &H13
%WM_ERASEBKGND       = &H14
%WM_SYSCOLORCHANGE   = &H15
%WM_ENDSESSION       = &H16
%WM_SHOWWINDOW       = &H18
%WM_WININICHANGE     = &H1A
%WM_SETTINGCHANGE    = %WM_WININICHANGE
%WM_DEVMODECHANGE    = &H1B
%WM_ACTIVATEAPP      = &H1C
%WM_FONTCHANGE       = &H1D
%WM_TIMECHANGE       = &H1E
%WM_CANCELMODE       = &H1F
%WM_SETCURSOR        = &H20
%WM_MOUSEACTIVATE    = &H21
%WM_CHILDACTIVATE    = &H22
%WM_QUEUESYNC        = &H23
%WM_GETMINMAXINFO    = &H24
%WM_PAINTICON        = &H26
%WM_ICONERASEBKGND   = &H27
%WM_NEXTDLGCTL       = &H28
%WM_SPOOLERSTATUS    = &H2A
%WM_DRAWITEM         = &H2B
%WM_MEASUREITEM      = &H2C
%WM_DELETEITEM       = &H2D
%WM_VKEYTOITEM       = &H2E
%WM_CHARTOITEM       = &H2F
%WM_SETFONT          = &H30
%WM_GETFONT          = &H31
%WM_SETHOTKEY        = &H32
%WM_GETHOTKEY        = &H33
%WM_QUERYDRAGICON    = &H37
%WM_COMPAREITEM      = &H39
%WM_COMPACTING       = &H41
%WM_OTHERWINDOWCREATED   = &H42  '  no longer suported
%WM_OTHERWINDOWDESTROYED = &H43  '  no longer suported

%WM_COMMNOTIFY       = &H44  '  no longer suported

' notifications passed in low word of lParam on WM_COMMNOTIFY messages
%CN_RECEIVE  = &H1
%CN_TRANSMIT = &H2
%CN_EVENT    = &H4

%WM_WINDOWPOSCHANGING = &H46
%WM_WINDOWPOSCHANGED  = &H47

%WM_POWER             = &H48
'
'  wParam for WM_POWER window message and DRV_POWER driver notification
%PWR_OK             = 1
%PWR_FAIL           = -1
%PWR_SUSPENDREQUEST = 1
%PWR_SUSPENDRESUME  = 2
%PWR_CRITICALRESUME = 3

%WM_COPYDATA                   = &H4A
%WM_CANCELJOURNAL              = &H4B
%WM_NOTIFY                     = &H4E
%WM_INPUTLANGUAGECHANGEREQUEST = &H50
%WM_INPUTLANGUAGECHANGE        = &H51
%WM_TCARD                      = &H52
%WM_HELP                       = &H53
%WM_USERCHANGED                = &H54
%WM_NOTIFYFORMAT               = &H55

%WM_CONTEXTMENU   = &H7B
%WM_STYLECHANGING = &H7C
%WM_STYLECHANGED  = &H7D
%WM_DISPLAYCHANGE = &H7E

%WM_GETICON          = &H7F
%WM_SETICON          = &H80
%WM_NCCREATE         = &H81
%WM_NCDESTROY        = &H82
%WM_NCCALCSIZE       = &H83
%WM_NCHITTEST        = &H84
%WM_NCPAINT          = &H85
%WM_NCACTIVATE       = &H86
%WM_GETDLGCODE       = &H87
%WM_NCMOUSEMOVE      = &HA0
%WM_NCLBUTTONDOWN    = &HA1
%WM_NCLBUTTONUP      = &HA2
%WM_NCLBUTTONDBLCLK  = &HA3
%WM_NCRBUTTONDOWN    = &HA4
%WM_NCRBUTTONUP      = &HA5
%WM_NCRBUTTONDBLCLK  = &HA6
%WM_NCMBUTTONDOWN    = &HA7
%WM_NCMBUTTONUP      = &HA8
%WM_NCMBUTTONDBLCLK  = &HA9

%WM_KEYFIRST         = &H100
%WM_KEYDOWN          = &H100
%WM_KEYUP            = &H101
%WM_CHAR             = &H102
%WM_DEADCHAR         = &H103
%WM_SYSKEYDOWN       = &H104
%WM_SYSKEYUP         = &H105
%WM_SYSCHAR          = &H106
%WM_SYSDEADCHAR      = &H107
%WM_KEYLAST          = &H108
%WM_INITDIALOG       = &H110
%WM_COMMAND          = &H111
%WM_SYSCOMMAND       = &H112
%WM_TIMER            = &H113
%WM_HSCROLL          = &H114
%WM_VSCROLL          = &H115
%WM_INITMENU         = &H116
%WM_INITMENUPOPUP    = &H117
%WM_MENUSELECT       = &H11F
%WM_MENUCHAR         = &H120
%WM_ENTERIDLE        = &H121
%WM_CTLCOLORMSGBOX   = &H132
%WM_CTLCOLOREDIT     = &H133
%WM_CTLCOLORLISTBOX  = &H134
%WM_CTLCOLORBTN      = &H135
%WM_CTLCOLORDLG      = &H136
%WM_CTLCOLORSCROLLBAR= &H137
%WM_CTLCOLORSTATIC   = &H138
%WM_MOUSEFIRST       = &H200
%WM_MOUSEMOVE        = &H200
%WM_LBUTTONDOWN      = &H201
%WM_LBUTTONUP        = &H202
%WM_LBUTTONDBLCLK    = &H203
%WM_RBUTTONDOWN      = &H204
%WM_RBUTTONUP        = &H205
%WM_RBUTTONDBLCLK    = &H206
%WM_MBUTTONDOWN      = &H207
%WM_MBUTTONUP        = &H208
%WM_MBUTTONDBLCLK    = &H209
%WM_MOUSEWHEEL       = &H20A
%WM_MOUSELAST        = &H20A

%WM_PARENTNOTIFY     = &H210
%WM_ENTERMENULOOP    = &H211
%WM_EXITMENULOOP     = &H212

%WM_SIZING           = &H214
%WM_CAPTURECHANGED   = &H215
%WM_MOVING           = &H216

%WM_POWERBROADCAST   = &H218
%WM_DEVICECHANGE     = &H219
%WM_MDICREATE        = &H220
%WM_MDIDESTROY       = &H221
%WM_MDIACTIVATE      = &H222
%WM_MDIRESTORE       = &H223
%WM_MDINEXT          = &H224
%WM_MDIMAXIMIZE      = &H225
%WM_MDITILE          = &H226
%WM_MDICASCADE       = &H227
%WM_MDIICONARRANGE   = &H228
%WM_MDIGETACTIVE     = &H229
%WM_MDISETMENU       = &H230
%WM_ENTERSIZEMOVE    = &H231
%WM_EXITSIZEMOVE     = &H232
%WM_DROPFILES        = &H233
%WM_MDIREFRESHMENU   = &H234

%WM_MOUSEHOVER       = &H2A1
%WM_MOUSELEAVE       = &H2A3

%WM_CUT              = &H300
%WM_COPY             = &H301
%WM_PASTE            = &H302
%WM_CLEAR            = &H303
%WM_UNDO             = &H304
%WM_RENDERFORMAT     = &H305
%WM_RENDERALLFORMATS = &H306
%WM_DESTROYCLIPBOARD = &H307
%WM_DRAWCLIPBOARD    = &H308
%WM_PAINTCLIPBOARD   = &H309
%WM_VSCROLLCLIPBOARD = &H30A
%WM_SIZECLIPBOARD    = &H30B
%WM_ASKCBFORMATNAME  = &H30C
%WM_CHANGECBCHAIN    = &H30D
%WM_HSCROLLCLIPBOARD = &H30E
%WM_QUERYNEWPALETTE  = &H30F
%WM_PALETTEISCHANGING= &H310
%WM_PALETTECHANGED   = &H311
%WM_HOTKEY           = &H312
%WM_PRINTCLIENT      = &H318

%WM_PENWINFIRST      = &H380
%WM_PENWINLAST       = &H38F

%WMSZ_LEFT        = 1
%WMSZ_RIGHT       = 2
%WMSZ_TOP         = 3
%WMSZ_TOPLEFT     = 4
%WMSZ_TOPRIGHT    = 5
%WMSZ_BOTTOM      = 6
%WMSZ_BOTTOMLEFT  = 7
%WMSZ_BOTTOMRIGHT = 8

%PBT_APMQUERYSUSPEND         = &H0000
%PBT_APMQUERYSTANDBY         = &H0001
%PBT_APMQUERYSUSPENDFAILED   = &H0002
%PBT_APMQUERYSTANDBYFAILED   = &H0003
%PBT_APMSUSPEND              = &H0004
%PBT_APMSTANDBY              = &H0005
%PBT_APMRESUMECRITICAL       = &H0006
%PBT_APMRESUMESUSPEND        = &H0007
%PBT_APMRESUMESTANDBY        = &H0008
%PBTF_APMRESUMEFROMFAILURE   = &H00000001
%PBT_APMBATTERYLOW           = &H0009
%PBT_APMPOWERSTATUSCHANGE    = &H000A
%PBT_APMOEMEVENT             = &H000B
%PBT_APMRESUMEAUTOMATIC      = &H0012

' Broadcast Special Message Recipient list
%BSM_ALLCOMPONENTS       = &H00000000
%BSM_VXDS                = &H00000001
%BSM_NETDRIVER           = &H00000002
%BSM_INSTALLABLEDRIVERS  = &H00000004
%BSM_APPLICATIONS        = &H00000008
%BSM_ALLDESKTOPS         = &H00000010

' Broadcast Special Message Flags
%BSF_QUERY               = &H00000001
%BSF_IGNORECURRENTTASK   = &H00000002
%BSF_FLUSHDISK           = &H00000004
%BSF_NOHANG              = &H00000008
%BSF_POSTMESSAGE         = &H00000010
%BSF_FORCEIFHUNG         = &H00000020
%BSF_NOTIMEOUTIFNOTHUNG  = &H00000040
%BSF_ALLOWSFW            = &H00000080
%BSF_SENDNOTIFYMESSAGE   = &H00000100

%BROADCAST_QUERY_DENY    = &H424D5144  ' Return this value to deny a query.

%DEVICE_NOTIFY_WINDOW_HANDLE   = &H00000000
%DEVICE_NOTIFY_SERVICE_HANDLE  = &H00000001

%ICON_SMALL = 0
%ICON_BIG   = 1

' WM_SYNCTASK Commands
%ST_BEGINSWP = 0
%ST_ENDSWP   = 1

' WM_NCHITTEST and MOUSEHOOKSTRUCT Mouse Position Codes
%HTERROR       = -2
%HTTRANSPARENT = -1
%HTNOWHERE     = 0
%HTCLIENT      = 1
%HTCAPTION     = 2
%HTSYSMENU     = 3
%HTGROWBOX     = 4
%HTSIZE        = %HTGROWBOX
%HTMENU        = 5
%HTHSCROLL     = 6
%HTVSCROLL     = 7
%HTMINBUTTON   = 8
%HTMAXBUTTON   = 9
%HTLEFT        = 10
%HTRIGHT       = 11
%HTTOP         = 12
%HTTOPLEFT     = 13
%HTTOPRIGHT    = 14
%HTBOTTOM      = 15
%HTBOTTOMLEFT  = 16
%HTBOTTOMRIGHT = 17
%HTBORDER      = 18
%HTREDUCE      = %HTMINBUTTON
%HTZOOM        = %HTMAXBUTTON
%HTSIZEFIRST   = %HTLEFT
%HTSIZELAST    = %HTBOTTOMRIGHT
%HTOBJECT      = 19
%HTCLOSE       = 20
%HTHELP        = 21

'  SendMessageTimeout values
%SMTO_NORMAL      = &H0
%SMTO_BLOCK       = &H1
%SMTO_ABORTIFHUNG = &H2

' WM_MOUSEACTIVATE Return Codes
%MA_ACTIVATE         = 1
%MA_ACTIVATEANDEAT   = 2
%MA_NOACTIVATE       = 3
%MA_NOACTIVATEANDEAT = 4

' WM_SIZE message wParam values
%SIZE_RESTORED  = 0
%SIZE_MINIMIZED = 1
%SIZE_MAXIMIZED = 2
%SIZE_MAXSHOW   = 3
%SIZE_MAXHIDE   = 4

' Obsolete constant names
%SIZENORMAL     = %SIZE_RESTORED
%SIZEICONIC     = %SIZE_MINIMIZED
%SIZEFULLSCREEN = %SIZE_MAXIMIZED
%SIZEZOOMSHOW   = %SIZE_MAXSHOW
%SIZEZOOMHIDE   = %SIZE_MAXHIDE

' WM_NCCALCSIZE return flags
%WVR_ALIGNTOP    = &H10
%WVR_ALIGNLEFT   = &H20
%WVR_ALIGNBOTTOM = &H40
%WVR_ALIGNRIGHT  = &H80
%WVR_HREDRAW     = &H100
%WVR_VREDRAW     = &H200
%WVR_REDRAW      = %WVR_HREDRAW OR %WVR_VREDRAW
%WVR_VALIDRECTS  = &H400

' Key State Masks for Mouse Messages
%MK_LBUTTON = &H1
%MK_RBUTTON = &H2
%MK_SHIFT   = &H4
%MK_CONTROL = &H8
%MK_MBUTTON = &H10

' Window Styles
%WS_OVERLAPPED      = &H0&
%WS_POPUP           = &H80000000&
%WS_CHILD           = &H40000000&
%WS_MINIMIZE        = &H20000000&
%WS_VISIBLE         = &H10000000&
%WS_DISABLED        = &H8000000&
%WS_CLIPSIBLINGS    = &H4000000&
%WS_CLIPCHILDREN    = &H2000000&
%WS_MAXIMIZE        = &H1000000
%WS_CAPTION         = &HC00000&  '  WS_BORDER OR WS_DLGFRAME
%WS_BORDER          = &H800000&
%WS_DLGFRAME        = &H400000&
%WS_VSCROLL         = &H200000&
%WS_HSCROLL         = &H100000&
%WS_SYSMENU         = &H80000&
%WS_THICKFRAME      = &H40000&
%WS_GROUP           = &H20000&
%WS_TABSTOP         = &H10000&
%WS_MINIMIZEBOX     = &H20000&
%WS_MAXIMIZEBOX     = &H10000&
%WS_TILED           = %WS_OVERLAPPED
%WS_ICONIC          = %WS_MINIMIZE
%WS_SIZEBOX         = %WS_THICKFRAME
%WS_OVERLAPPEDWIN   = %WS_OVERLAPPED OR %WS_CAPTION OR %WS_SYSMENU OR %WS_THICKFRAME
%WS_OVERLAPPEDWINDOW= %WS_OVERLAPPED OR %WS_CAPTION OR %WS_SYSMENU OR %WS_THICKFRAME OR %WS_MINIMIZEBOX OR %WS_MAXIMIZEBOX
%WS_TILEDWINDOW     = %WS_OVERLAPPEDWINDOW
%WS_POPUPWINDOW     = %WS_POPUP OR %WS_BORDER OR %WS_SYSMENU
%WS_CHILDWINDOW     = %WS_CHILD

%WS_EX_DLGMODALFRAME   = &H00000001&
%WS_EX_NOPARENTNOTIFY  = &H00000004&
%WS_EX_TOPMOST         = &H00000008&
%WS_EX_ACCEPTFILES     = &H00000010&
%WS_EX_TRANSPARENT     = &H00000020&
%WS_EX_MDICHILD        = &H00000040&
%WS_EX_TOOLWINDOW      = &H00000080&
%WS_EX_SMCAPTION       = &H00000080&
%WS_EX_WINDOWEDGE      = &H00000100&
%WS_EX_CLIENTEDGE      = &H00000200&
%WS_EX_CONTEXTHELP     = &H00000400&
%WS_EX_RIGHT           = &H00001000&
%WS_EX_LEFT            = &H00000000&
%WS_EX_RTLREADING      = &H00002000&
%WS_EX_LTRREADING      = &H00000000&
%WS_EX_LEFTSCROLLBAR   = &H00004000&
%WS_EX_RIGHTSCROLLBAR  = &H00000000&
%WS_EX_CONTROLPARENT   = &H00010000&
%WS_EX_STATICEDGE      = &H00020000&
%WS_EX_APPWINDOW       = &H00040000&
%WS_EX_OVERLAPPEDWINDOW= %WS_EX_WINDOWEDGE OR %WS_EX_CLIENTEDGE
%WS_EX_PALETTEWINDOW   = %WS_EX_WINDOWEDGE OR %WS_EX_TOOLWINDOW OR %WS_EX_TOPMOST

%CS_VREDRAW         = &H1
%CS_HREDRAW         = &H2
%CS_KEYCVTWINDOW    = &H4
%CS_DBLCLKS         = &H8
%CS_OWNDC           = &H20
%CS_CLASSDC         = &H40
%CS_PARENTDC        = &H80
%CS_NOKEYCVT        = &H100
%CS_NOCLOSE         = &H200
%CS_SAVEBITS        = &H800
%CS_BYTEALIGNCLIENT = &H1000
%CS_BYTEALIGNWINDOW = &H2000
%CS_PUBLICCLASS     = &H4000
%CS_GLOBALCLASS     = %CS_PUBLICCLASS

%CS_DROPSHADOW = &H00020000

%CSIDL_DESKTOP                 = &H0000  ' <desktop>
%CSIDL_INTERNET                = &H0001  ' Internet Explorer (icon on desktop)
%CSIDL_PROGRAMS                = &H0002  ' Start Menu\Programs
%CSIDL_CONTROLS                = &H0003  ' My Computer\Control Panel
%CSIDL_PRINTERS                = &H0004  ' My Computer\Printers
%CSIDL_PERSONAL                = &H0005  ' My Documents
%CSIDL_FAVORITES               = &H0006  ' <user name>\Favorites
%CSIDL_STARTUP                 = &H0007  ' Start Menu\Programs\Startup
%CSIDL_RECENT                  = &H0008  ' <user name>\Recent
%CSIDL_SENDTO                  = &H0009  ' <user name>\SendTo
%CSIDL_BITBUCKET               = &H000a  ' <desktop>\Recycle Bin
%CSIDL_STARTMENU               = &H000b  ' <user name>\Start Menu
%CSIDL_DESKTOPDIRECTORY        = &H0010  ' <user name>\Desktop
%CSIDL_DRIVES                  = &H0011  ' My Computer
%CSIDL_NETWORK                 = &H0012  ' Network Neighborhood
%CSIDL_NETHOOD                 = &H0013  ' <user name>\nethood
%CSIDL_FONTS                   = &H0014  ' windows\fonts
%CSIDL_TEMPLATES               = &H0015
%CSIDL_COMMON_STARTMENU        = &H0016  ' All Users\Start Menu
%CSIDL_COMMON_PROGRAMS         = &H0017  ' All Users\Programs
%CSIDL_COMMON_STARTUP          = &H0018  ' All Users\Startup
%CSIDL_COMMON_DESKTOPDIRECTORY = &H0019  ' All Users\Desktop
%CSIDL_APPDATA                 = &H001a  ' <user name>\Application Data
%CSIDL_PRINTHOOD               = &H001b  ' <user name>\PrintHood
%CSIDL_LOCAL_APPDATA           = &H001c  ' <user name>\Local Settings\Application Data (non roaming)
%CSIDL_ALTSTARTUP              = &H001d  ' non localized startup
%CSIDL_COMMON_ALTSTARTUP       = &H001e  ' non localized common startup
%CSIDL_COMMON_FAVORITES        = &H001f
%CSIDL_INTERNET_CACHE          = &H0020
%CSIDL_COOKIES                 = &H0021
%CSIDL_HISTORY                 = &H0022
%CSIDL_COMMON_APPDATA          = &H0023  ' All Users\Application Data
%CSIDL_WINDOWS                 = &H0024  ' GetWindowsDirectory()
%CSIDL_SYSTEM                  = &H0025  ' GetSystemDirectory()
%CSIDL_PROGRAM_FILES           = &H0026  ' C:\Program Files
%CSIDL_MYPICTURES              = &H0027  ' C:\Program Files\My Pictures
%CSIDL_PROFILE                 = &H0028  ' USERPROFILE
%CSIDL_SYSTEMX86               = &H0029  ' x86 system directory on RISC
%CSIDL_PROGRAM_FILESX86        = &H002a  ' x86 C:\Program Files on RISC
%CSIDL_PROGRAM_FILES_COMMON    = &H002b  ' C:\Program Files\Common
%CSIDL_PROGRAM_FILES_COMMONX86 = &H002c  ' x86 Program Files\Common on RISC
%CSIDL_COMMON_TEMPLATES        = &H002d  ' All Users\Templates
%CSIDL_COMMON_DOCUMENTS        = &H002e  ' All Users\Documents
%CSIDL_COMMON_ADMINTOOLS       = &H002f  ' All Users\Start Menu\Programs\Administrative Tools
%CSIDL_ADMINTOOLS              = &H0030  ' <user name>\Start Menu\Programs\Administrative Tools
%CSIDL_CONNECTIONS             = &H0031  ' Network and Dial-up Connections

%CSIDL_FLAG_CREATE             = &H8000  ' combine with CSIDL_ value to force folder creation in SHGetFolderPath()
%CSIDL_FLAG_DONT_VERIFY        = &H4000  ' combine with CSIDL_ value to return an unverified folder path
%CSIDL_FLAG_MASK               = &HFF00  ' mask for all possible flag values
%CSIDL_FLAG_PFTI_TRACKTARGET   = %CSIDL_FLAG_DONT_VERIFY

#IF NOT %DEF(%CSIDL_PERSONAL)
%CSIDL_PERSONAL                = &H0005  ' My Documents
#ENDIF

#IF NOT %DEF(%CSIDL_APPDATA)
%CSIDL_APPDATA                 = &H001A  ' Application Data, new for NT4
#ENDIF

#IF NOT %DEF(%CSIDL_LOCAL_APPDATA)

%CSIDL_LOCAL_APPDATA           = &H001C  ' non roaming, user\Local Settings\Application Data
%CSIDL_INTERNET_CACHE          = &H0020
%CSIDL_COOKIES                 = &H0021
%CSIDL_HISTORY                 = &H0022
%CSIDL_COMMON_APPDATA          = &H0023  ' All Users\Application Data
%CSIDL_WINDOWS                 = &H0024  ' GetWindowsDirectory()
%CSIDL_SYSTEM                  = &H0025  ' GetSystemDirectory()
%CSIDL_PROGRAM_FILES           = &H0026  ' C:\Program Files
%CSIDL_MYPICTURES              = &H0027  ' My Pictures, new for Win2K
%CSIDL_PROGRAM_FILES_COMMON    = &H002b  ' C:\Program Files\Common
%CSIDL_COMMON_DOCUMENTS        = &H002e  ' All Users\Documents

%CSIDL_FLAG_CREATE             = &H8000  ' new for Win2K, or this in to force creation of folder

%CSIDL_COMMON_ADMINTOOLS       = &H002f  ' All Users\Start Menu\Programs\Administrative Tools
%CSIDL_ADMINTOOLS              = &H0030  ' <user name>\Start Menu\Programs\Administrative Tools

#ENDIF ' %CSIDL_LOCAL_APPDATA


%CF_TEXT            =  1
%CF_BITMAP          =  2
%CF_METAFILEPICT    =  3
%CF_SYLK            =  4
%CF_DIF             =  5
%CF_TIFF            =  6
%CF_OEMTEXT         =  7
%CF_DIB             =  8
%CF_PALETTE         =  9
%CF_PENDATA         = 10
%CF_RIFF            = 11
%CF_WAVE            = 12
%CF_UNICODETEXT     = 13
%CF_ENHMETAFILE     = 14
%CF_HDROP           = 15
%CF_LOCALE          = 16
%CF_DIBV5           = 17

%CF_OWNERDISPLAY    = &H0080
%CF_DSPTEXT         = &H0081
%CF_DSPBITMAP       = &H0082
%CF_DSPMETAFILEPICT = &H0083
%CF_DSPENHMETAFILE  = &H008E

%CF_PRIVATEFIRST    = &H0200
%CF_PRIVATELAST     = &H02FF

%CF_GDIOBJFIRST     = &H0300
%CF_GDIOBJLAST      = &H03FF

%FVIRTKEY   = &H1        '  Assumed to be == TRUE
%FNOINVERT  = &H2
%FSHIFT     = &H4
%FCONTROL   = &H8
%FALT       = &H10

%WPF_SETMINPOSITION     = &H1
%WPF_RESTORETOMAXIMIZED = &H2

' Owner draw control types
%ODT_MENU      = 1
%ODT_LISTBOX   = 2
%ODT_COMBOBOX  = 3
%ODT_BUTTON    = 4

' Owner draw actions
%ODA_DRAWENTIRE = &H1
%ODA_SELECT     = &H2
%ODA_FOCUS      = &H4

' Owner draw state
%ODS_SELECTED     = &H1
%ODS_GRAYED       = &H2
%ODS_DISABLED     = &H4
%ODS_CHECKED      = &H8
%ODS_FOCUS        = &H10
%ODS_DEFAULT      = &H0020
%ODS_COMBOBOXEDIT = &H1000
%ODS_HOTLIGHT     = &H0040
%ODS_INACTIVE     = &H0080
%ODS_NOACCEL      = &H0100
%ODS_NOFOCUSRECT  = &H0200

' PeekMessage() Options
%PM_NOREMOVE  = &H0
%PM_REMOVE    = &H1
%PM_NOYIELD   = &H2

%IDHOT_SNAPWINDOW  = -1    ' SHIFT-PRINTSCRN
%IDHOT_SNAPDESKTOP = -2    ' PRINTSCRN

%EWX_LOGOFF      = &H0000
%EWX_SHUTDOWN    = &H0001
%EWX_REBOOT      = &H0002
%EWX_FORCE       = &H0004
%EWX_POWEROFF    = &H0008
%EWX_FORCEIFHUNG = &H0010

%READAPI    = 0        '  Flags for _lopen
%WRITEAPI   = 1
%READ_WRITE = 2

' Special HWND value for use with PostMessage and SendMessage
%HWND_BROADCAST = &H0000FFFF

%CW_USEDEFAULT  = &H80000000???

%CWP_ALL             = &H0000
%CWP_SKIPINVISIBLE   = &H0001
%CWP_SKIPDISABLED    = &H0002
%CWP_SKIPTRANSPARENT = &H0004

' SetWindowPos Flags
%SWP_NOSIZE        = &H1
%SWP_NOMOVE        = &H2
%SWP_NOZORDER      = &H4
%SWP_NOREDRAW      = &H8
%SWP_NOACTIVATE    = &H10
%SWP_FRAMECHANGED  = &H20        '  The frame changed: send WM_NCCALCSIZE
%SWP_SHOWWINDOW    = &H40
%SWP_HIDEWINDOW    = &H80
%SWP_NOCOPYBITS    = &H100
%SWP_NOOWNERZORDER = &H200      '  Don't do owner Z ordering

%SWP_DRAWFRAME     = %SWP_FRAMECHANGED
%SWP_NOREPOSITION  = %SWP_NOOWNERZORDER

%HWND_DESKTOP   = 0

%HWND_TOP       = 0
%HWND_BOTTOM    = 1
%HWND_TOPMOST   = &HFFFFFFFF???
%HWND_NOTOPMOST = &HFFFFFFFE???

%HWND_MESSAGE   = &HFFFFFFFD???

%DLGWINDOWEXTRA = 30        '  Window extra bytes needed for private dialog classes

%KEYEVENTF_EXTENDEDKEY = &H1
%KEYEVENTF_KEYUP       = &H2

%MOUSEEVENTF_MOVE       = &H1 '  mouse move
%MOUSEEVENTF_LEFTDOWN   = &H2 '  left button down
%MOUSEEVENTF_LEFTUP     = &H4 '  left button up
%MOUSEEVENTF_RIGHTDOWN  = &H8 '  right button down
%MOUSEEVENTF_RIGHTUP    = &H10 '  right button up
%MOUSEEVENTF_MIDDLEDOWN = &H20 '  middle button down
%MOUSEEVENTF_MIDDLEUP   = &H40 '  middle button up
%MOUSEEVENTF_WHEEL      = &H0800 ' wheel button rolled
%MOUSEEVENTF_ABSOLUTE                        = &H8000 '  absolute move


' GetQueueStatus flags
%QS_KEY          = &H1
%QS_MOUSEMOVE    = &H2
%QS_MOUSEBUTTON  = &H4
%QS_POSTMESSAGE  = &H8
%QS_TIMER        = &H10
%QS_PAINT        = &H20
%QS_SENDMESSAGE  = &H40
%QS_HOTKEY       = &H80

%QS_MOUSE        = %QS_MOUSEMOVE OR %QS_MOUSEBUTTON

%QS_INPUT        = %QS_MOUSE OR %QS_KEY

%QS_ALLEVENTS    = %QS_INPUT OR %QS_POSTMESSAGE OR %QS_TIMER OR %QS_PAINT OR %QS_HOTKEY

%QS_ALLINPUT     = %QS_SENDMESSAGE OR %QS_PAINT OR %QS_TIMER OR %QS_POSTMESSAGE OR %QS_MOUSEBUTTON OR %QS_MOUSEMOVE OR %QS_HOTKEY OR %QS_KEY

' GetSystemMetrics() codes
%SM_CXSCREEN            = 0
%SM_CYSCREEN            = 1
%SM_CXVSCROLL           = 2
%SM_CYHSCROLL           = 3
%SM_CYCAPTION           = 4
%SM_CXBORDER            = 5
%SM_CYBORDER            = 6
%SM_CXDLGFRAME          = 7
%SM_CYDLGFRAME          = 8
%SM_CYVTHUMB            = 9
%SM_CXHTHUMB            = 10
%SM_CXICON              = 11
%SM_CYICON              = 12
%SM_CXCURSOR            = 13
%SM_CYCURSOR            = 14
%SM_CYMENU              = 15
%SM_CXFULLSCREEN        = 16
%SM_CYFULLSCREEN        = 17
%SM_CYKANJIWINDOW       = 18
%SM_MOUSEPRESENT        = 19
%SM_CYVSCROLL           = 20
%SM_CXHSCROLL           = 21
%SM_DEBUG               = 22
%SM_SWAPBUTTON          = 23
%SM_RESERVED1           = 24
%SM_RESERVED2           = 25
%SM_RESERVED3           = 26
%SM_RESERVED4           = 27
%SM_CXMIN               = 28
%SM_CYMIN               = 29
%SM_CXSIZE              = 30
%SM_CYSIZE              = 31
%SM_CXFRAME             = 32
%SM_CYFRAME             = 33
%SM_CXMINTRACK          = 34
%SM_CYMINTRACK          = 35
%SM_CXDOUBLECLK         = 36
%SM_CYDOUBLECLK         = 37
%SM_CXICONSPACING       = 38
%SM_CYICONSPACING       = 39
%SM_MENUDROPALIGNMENT   = 40
%SM_PENWINDOWS          = 41
%SM_DBCSENABLED         = 42
%SM_CMOUSEBUTTONS       = 43

%SM_CXFIXEDFRAME        = %SM_CXDLGFRAME  ' win40 name change
%SM_CYFIXEDFRAME        = %SM_CYDLGFRAME  ' win40 name change
%SM_CXSIZEFRAME         = %SM_CXFRAME     ' win40 name change
%SM_CYSIZEFRAME         = %SM_CYFRAME     ' win40 name change

%SM_SECURE              = 44
%SM_CXEDGE              = 45
%SM_CYEDGE              = 46
%SM_CXMINSPACING        = 47
%SM_CYMINSPACING        = 48
%SM_CXSMICON            = 49
%SM_CYSMICON            = 50
%SM_CYSMCAPTION         = 51
%SM_CXSMSIZE            = 52
%SM_CYSMSIZE            = 53
%SM_CXMENUSIZE          = 54
%SM_CYMENUSIZE          = 55
%SM_ARRANGE             = 56
%SM_CXMINIMIZED         = 57
%SM_CYMINIMIZED         = 58
%SM_CXMAXTRACK          = 59
%SM_CYMAXTRACK          = 60
%SM_CXMAXIMIZED         = 61
%SM_CYMAXIMIZED         = 62
%SM_NETWORK             = 63
%SM_CLEANBOOT           = 67
%SM_CXDRAG              = 68
%SM_CYDRAG              = 69
%SM_SHOWSOUNDS          = 70
%SM_CXMENUCHECK         = 71   ' Use instead of GetMenuCheckMarkDimensions()
%SM_CYMENUCHECK         = 72
%SM_SLOWMACHINE         = 73
%SM_MIDEASTENABLED      = 74
%SM_MOUSEWHEELPRESENT   = 75
%SM_XVIRTUALSCREEN      = 76
%SM_YVIRTUALSCREEN      = 77
%SM_CXVIRTUALSCREEN     = 78
%SM_CYVIRTUALSCREEN     = 79
%SM_CMONITORS           = 80
%SM_SAMEDISPLAYFORMAT   = 81
%SM_CMETRICS            = 83

' Flags for TrackPopupMenu
%TPM_LEFTBUTTON   = &H0&
%TPM_RIGHTBUTTON  = &H2&
%TPM_LEFTALIGN    = &H0&
%TPM_CENTERALIGN  = &H4&
%TPM_RIGHTALIGN   = &H8&

%TPM_TOPALIGN     = &H0&
%TPM_VCENTERALIGN = &H10&
%TPM_BOTTOMALIGN  = &H20&

%TPM_HORIZONTAL   = &H0&   ' Horz alignment matters more
%TPM_VERTICAL     = &H40&  ' Vert alignment matters more
%TPM_NONOTIFY     = &H80&  ' Don't send any notification msgs
%TPM_RETURNCMD    = &H100&

' DrawText() Format Flags
%DT_TOP                  = &H0
%DT_LEFT                 = &H0
%DT_CENTER               = &H1
%DT_RIGHT                = &H2
%DT_VCENTER              = &H4
%DT_BOTTOM               = &H8
%DT_WORDBREAK            = &H10
%DT_SINGLELINE           = &H20
%DT_EXPANDTABS           = &H40
%DT_TABSTOP              = &H80
%DT_NOCLIP               = &H100
%DT_EXTERNALLEADING      = &H200
%DT_CALCRECT             = &H400
%DT_NOPREFIX             = &H800
%DT_INTERNAL             = &H1000
%DT_EDITCONTROL          = &H00002000
%DT_PATH_ELLIPSIS        = &H00004000
%DT_END_ELLIPSIS         = &H00008000
%DT_MODIFYSTRING         = &H00010000
%DT_RTLREADING           = &H00020000
%DT_WORD_ELLIPSIS        = &H00040000
%DT_NOFULLWIDTHCHARBREAK = &H00080000
%DT_HIDEPREFIX           = &H00100000
%DT_PREFIXONLY           = &H00200000

' Monolithic state-drawing routine
' Image type
%DST_COMPLEX    = &H00000000???
%DST_TEXT       = &H00000001???
%DST_PREFIXTEXT = &H00000002???
%DST_ICON       = &H00000003???
%DST_BITMAP     = &H00000004???

' State type
%DSS_NORMAL     = &H00000000???
%DSS_UNION      = &H00000010???  ' Gray string appearance
%DSS_DISABLED   = &H00000020???
%DSS_MONO       = &H00000080???
%DSS_HIDEPREFIX = &H00000200???
%DSS_PREFIXONLY = &H00000400???
%DSS_RIGHT      = &H00008000???

%DCX_WINDOW          = &H1&
%DCX_CACHE           = &H2&
%DCX_NORESETATTRS    = &H4&
%DCX_CLIPCHILDREN    = &H8&
%DCX_CLIPSIBLINGS    = &H10&
%DCX_PARENTCLIP      = &H20&

%DCX_EXCLUDERGN      = &H40&
%DCX_INTERSECTRGN    = &H80&

%DCX_EXCLUDEUPDATE   = &H100&
%DCX_INTERSECTUPDATE = &H200&

%DCX_LOCKWINDOWUPDATE= &H400&

%DCX_NORECOMPUTE     = &H100000
%DCX_VALIDATE        = &H200000

%RDW_INVALIDATE      = &H1
%RDW_INTERNALPAINT   = &H2
%RDW_ERASE           = &H4

%RDW_VALIDATE        = &H8
%RDW_NOINTERNALPAINT = &H10
%RDW_NOERASE         = &H20

%RDW_NOCHILDREN      = &H40
%RDW_ALLCHILDREN     = &H80

%RDW_UPDATENOW       = &H100
%RDW_ERASENOW        = &H200

%RDW_FRAME           = &H400
%RDW_NOFRAME         = &H800

%SW_SCROLLCHILDREN = &H0001
%SW_INVALIDATE     = &H0002
%SW_ERASE          = &H0004
%SW_SMOOTHSCROLL   = &H0010

' EnableScrollBar() flags
%ESB_ENABLE_BOTH   = &H0
%ESB_DISABLE_BOTH  = &H3

%ESB_DISABLE_LEFT  = &H1
%ESB_DISABLE_RIGHT = &H2

%ESB_DISABLE_UP    = &H1
%ESB_DISABLE_DOWN  = &H2

%ESB_DISABLE_LTUP  = %ESB_DISABLE_LEFT
%ESB_DISABLE_RTDN  = %ESB_DISABLE_RIGHT

$IF NOT %DEF(%NOMB) '----------------------------------------------------------

' MessageBox() Flags
%MB_OK                        = &H00000000&
%MB_OKCANCEL                  = &H00000001&
%MB_ABORTRETRYIGNORE          = &H00000002&
%MB_YESNOCANCEL               = &H00000003&
%MB_YESNO                     = &H00000004&
%MB_RETRYCANCEL               = &H00000005&
%MB_CANCELTRYCONTINUE         = &H00000006&

%MB_ICONHAND                  = &H00000010&
%MB_ICONQUESTION              = &H00000020&
%MB_ICONEXCLAMATION           = &H00000030&
%MB_ICONASTERISK              = &H00000040&

%MB_USERICON                  = &H00000080&
%MB_ICONWARNING               = %MB_ICONEXCLAMATION
%MB_ICONERROR                 = %MB_ICONHAND

%MB_ICONINFORMATION           = %MB_ICONASTERISK
%MB_ICONSTOP                  = %MB_ICONHAND

%MB_DEFBUTTON1                = &H00000000&
%MB_DEFBUTTON2                = &H00000100&
%MB_DEFBUTTON3                = &H00000200&
%MB_DEFBUTTON4                = &H00000300&

%MB_APPLMODAL                 = &H00000000&
%MB_SYSTEMMODAL               = &H00001000&
%MB_TASKMODAL                 = &H00002000&
%MB_HELP                      = &H00004000&  ' Help Button

%MB_NOFOCUS                   = &H00008000&
%MB_SETFOREGROUND             = &H00010000&
%MB_DEFAULT_DESKTOP_ONLY      = &H00020000&

%MB_TOPMOST                   = &H00040000&
%MB_RIGHT                     = &H00080000&
%MB_RTLREADING                = &H00100000&

%MB_SERVICE_NOTIFICATION      = &H00200000&
%MB_SERVICE_NOTIFICATION_NT3X = &H00040000&

%MB_TYPEMASK                  = &H0000000F&
%MB_ICONMASK                  = &H000000F0&
%MB_DEFMASK                   = &H00000F00&
%MB_MODEMASK                  = &H00003000&
%MB_MISCMASK                  = &H0000C000&

$ENDIF ' $IF %DEF(%NOMB) ------------------------------------------------------

' MBCS and Unicode Translation Flags
%MB_PRECOMPOSED       = &H00000001  ' use precomposed chars
%MB_COMPOSITE         = &H00000002  ' use composite chars
%MB_USEGLYPHCHARS     = &H00000004  ' use glyph chars, not ctrl chars
%MB_ERR_INVALID_CHARS = &H00000008  ' error for invalid chars


' Color Types
%CTLCOLOR_MSGBOX    = 0
%CTLCOLOR_EDIT      = 1
%CTLCOLOR_LISTBOX   = 2
%CTLCOLOR_BTN       = 3
%CTLCOLOR_DLG       = 4
%CTLCOLOR_SCROLLBAR = 5
%CTLCOLOR_STATIC    = 6
%CTLCOLOR_MAX       = 8   '  three bits max

%COLOR_SCROLLBAR           = 0
%COLOR_BACKGROUND          = 1
%COLOR_ACTIVECAPTION       = 2
%COLOR_INACTIVECAPTION     = 3
%COLOR_MENU                = 4
%COLOR_MSGBOX              = 4
%COLOR_WINDOW              = 5
%COLOR_WINDOWFRAME         = 6
%COLOR_MENUTEXT            = 7
%COLOR_MSGBOXTEXT          = 7
%COLOR_WINDOWTEXT          = 8
%COLOR_CAPTIONTEXT         = 9
%COLOR_ACTIVEBORDER        = 10
%COLOR_INACTIVEBORDER      = 11
%COLOR_APPWORKSPACE        = 12
%COLOR_HIGHLIGHT           = 13
%COLOR_HIGHLIGHTTEXT       = 14
%COLOR_BTNFACE             = 15
%COLOR_BTNSHADOW           = 16
%COLOR_GRAYTEXT            = 17
%COLOR_BTNTEXT             = 18
%COLOR_INACTIVECAPTIONTEXT = 19
%COLOR_BTNHIGHLIGHT        = 20

%COLOR_3DDKSHADOW          = 21
%COLOR_3DLIGHT             = 22
%COLOR_INFOTEXT            = 23
%COLOR_INFOBK              = 24

%COLOR_DESKTOP             = %COLOR_BACKGROUND
%COLOR_3DFACE              = %COLOR_BTNFACE
%COLOR_3DSHADOW            = %COLOR_BTNSHADOW
%COLOR_3DHIGHLIGHT         = %COLOR_BTNHIGHLIGHT
%COLOR_3DHILIGHT           = %COLOR_BTNHIGHLIGHT
%COLOR_BTNHILIGHT          = %COLOR_BTNHIGHLIGHT


' GetWindow() Constants
%GW_HWNDFIRST = 0
%GW_HWNDLAST  = 1
%GW_HWNDNEXT  = 2
%GW_HWNDPREV  = 3
%GW_OWNER     = 4
%GW_CHILD     = 5
%GW_MAX       = 5

' Menu flags for Add/Check/EnableMenuItem()
%MF_INSERT          = &H0&
%MF_CHANGE          = &H80&
%MF_APPEND          = &H100&
%MF_DELETE          = &H200&
%MF_REMOVE          = &H1000&

%MF_BYCOMMAND       = &H0&
%MF_BYPOSITION      = &H400&

%MF_SEPARATOR       = &H800&

%MF_ENABLED         = &H0&
%MF_GRAYED          = &H1&
%MF_DISABLED        = &H2&

%MF_UNCHECKED       = &H0&
%MF_CHECKED         = &H8&
%MF_USECHECKBITMAPS = &H200&

%MF_STRING          = &H0&
%MF_BITMAP          = &H4&
%MF_OWNERDRAW       = &H100&

%MF_POPUP           = &H10&
%MF_MENUBARBREAK    = &H20&
%MF_MENUBREAK       = &H40&

%MF_UNHILITE        = &H0&
%MF_HILITE          = &H80&

%MF_DEFAULT         = &H00001000&
%MF_SYSMENU         = &H00002000&
%MF_HELP            = &H00004000&
%MF_RIGHTJUSTIFY    = &H00004000&
%MF_MOUSESELECT     = &H00008000&

%MF_END             = &H80&

%MFT_STRING         = %MF_STRING
%MFT_BITMAP         = %MF_BITMAP
%MFT_MENUBARBREAK   = %MF_MENUBARBREAK
%MFT_MENUBREAK      = %MF_MENUBREAK
%MFT_OWNERDRAW      = %MF_OWNERDRAW
%MFT_RADIOCHECK     = &H00000200&
%MFT_SEPARATOR      = %MF_SEPARATOR
%MFT_RIGHTORDER     = &H00002000&
%MFT_RIGHTJUSTIFY   = %MF_RIGHTJUSTIFY

' Menu flags for Add/Check/EnableMenuItem()
%MFS_GRAYED    = &H00000003&
%MFS_DISABLED  = %MFS_GRAYED
%MFS_CHECKED   = %MF_CHECKED
%MFS_HILITE    = %MF_HILITE
%MFS_ENABLED   = %MF_ENABLED
%MFS_UNCHECKED = %MF_UNCHECKED
%MFS_UNHILITE  = %MF_UNHILITE
%MFS_DEFAULT   = %MF_DEFAULT

' System Menu Command Values
%SC_SIZE         = &HF000&
%SC_MOVE         = &HF010&
%SC_MINIMIZE     = &HF020&
%SC_MAXIMIZE     = &HF030&
%SC_NEXTWINDOW   = &HF040&
%SC_PREVWINDOW   = &HF050&
%SC_CLOSE        = &HF060&
%SC_VSCROLL      = &HF070&
%SC_HSCROLL      = &HF080&
%SC_MOUSEMENU    = &HF090&
%SC_KEYMENU      = &HF100&
%SC_ARRANGE      = &HF110&
%SC_RESTORE      = &HF120&
%SC_TASKLIST     = &HF130&
%SC_SCREENSAVE   = &HF140&
%SC_HOTKEY       = &HF150&
%SC_DEFAULT      = &HF160&
%SC_MONITORPOWER = &HF170&
%SC_CONTEXTHELP  = &HF180&
%SC_SEPARATOR    = &HF00F&

' Obsolete names
%SC_ICON        = %SC_MINIMIZE
%SC_ZOOM        = %SC_MAXIMIZE

' Standard Cursor IDs
%IDC_ARROW        = 32512&
%IDC_IBEAM        = 32513&
%IDC_WAIT         = 32514&
%IDC_CROSS        = 32515&
%IDC_UPARROW      = 32516&
%IDC_SIZE         = 32640&
%IDC_ICON         = 32641&
%IDC_SIZENWSE     = 32642&
%IDC_SIZENESW     = 32643&
%IDC_SIZEWE       = 32644&
%IDC_SIZENS       = 32645&
%IDC_SIZEALL      = 32646&
%IDC_NO           = 32648&
%IDC_HAND         = 32649&
%IDC_APPSTARTING  = 32650&
%IDC_HELP         = 32651&

' OEM Resource Ordinal Numbers
%OBM_CLOSE        = 32754
%OBM_UPARROW      = 32753
%OBM_DNARROW      = 32752
%OBM_RGARROW      = 32751
%OBM_LFARROW      = 32750
%OBM_REDUCE       = 32749
%OBM_ZOOM         = 32748
%OBM_RESTORE      = 32747
%OBM_REDUCED      = 32746
%OBM_ZOOMD        = 32745
%OBM_RESTORED     = 32744
%OBM_UPARROWD     = 32743
%OBM_DNARROWD     = 32742
%OBM_RGARROWD     = 32741
%OBM_LFARROWD     = 32740
%OBM_MNARROW      = 32739
%OBM_COMBO        = 32738
%OBM_UPARROWI     = 32737
%OBM_DNARROWI     = 32736
%OBM_RGARROWI     = 32735
%OBM_LFARROWI     = 32734

%OBM_OLD_CLOSE    = 32767
%OBM_SIZE         = 32766
%OBM_OLD_UPARROW  = 32765
%OBM_OLD_DNARROW  = 32764
%OBM_OLD_RGARROW  = 32763
%OBM_OLD_LFARROW  = 32762
%OBM_BTSIZE       = 32761
%OBM_CHECK        = 32760
%OBM_CHECKBOXES   = 32759
%OBM_BTNCORNERS   = 32758
%OBM_OLD_REDUCE   = 32757
%OBM_OLD_ZOOM     = 32756
%OBM_OLD_RESTORE  = 32755

%OCR_NORMAL    = 32512
%OCR_IBEAM     = 32513
%OCR_WAIT      = 32514
%OCR_CROSS     = 32515
%OCR_UP        = 32516
%OCR_SIZE      = 32640
%OCR_ICON      = 32641
%OCR_SIZENWSE  = 32642
%OCR_SIZENESW  = 32643
%OCR_SIZEWE    = 32644
%OCR_SIZENS    = 32645
%OCR_SIZEALL   = 32646
%OCR_ICOCUR    = 32647
%OCR_NO        = 32648 ' not in win3.1

%OIC_SAMPLE = 32512
%OIC_HAND   = 32513
%OIC_QUES   = 32514
%OIC_BANG   = 32515
%OIC_NOTE   = 32516

%ORD_LANGDRIVER = 1 '  The ordinal number for the entry point of
'  language drivers.

' Standard Icon IDs
%IDI_APPLICATION = 32512&
%IDI_HAND        = 32513&
%IDI_ERROR       = 32513&
%IDI_QUESTION    = 32514&
%IDI_EXCLAMATION = 32515&
%IDI_WARNING     = 32515&
%IDI_ASTERISK    = 32516&
%IDI_INFORMATION = 32516&
%IDI_WINLOGO     = 32517&

' Dialog Box Command IDs
%IDOK       = 1
%IDCANCEL   = 2
%IDABORT    = 3
%IDRETRY    = 4
%IDIGNORE   = 5
%IDYES      = 6
%IDNO       = 7
%IDCLOSE    = 8
%IDHELP     = 9
%IDTRYAGAIN = 10
%IDCONTINUE = 11

' Control Manager Structures and Definitions

' Edit Control Styles
%ES_LEFT        = &H0&
%ES_CENTER      = &H1&
%ES_RIGHT       = &H2&
%ES_MULTILINE   = &H4&
%ES_UPPERCASE   = &H8&
%ES_LOWERCASE   = &H10&
%ES_PASSWORD    = &H20&
%ES_AUTOVSCROLL = &H40&
%ES_AUTOHSCROLL = &H80&
%ES_NOHIDESEL   = &H100&
%ES_OEMCONVERT  = &H400&
%ES_READONLY    = &H800&
%ES_WANTRETURN  = &H1000&
%ES_NUMBER      = &H2000&

' Edit Control Notification Codes
%EN_SETFOCUS  = &H100
%EN_KILLFOCUS = &H200
%EN_CHANGE    = &H300
%EN_UPDATE    = &H400
%EN_ERRSPACE  = &H500
%EN_MAXTEXT   = &H501
%EN_HSCROLL   = &H601
%EN_VSCROLL   = &H602

%EN_ALIGN_LTR_EC     = &H0700
%EN_ALIGN_RTL_EC     = &H0701

' Edit control EM_SETMARGIN parameters
%EC_LEFTMARGIN  = &H00000001
%EC_RIGHTMARGIN = &H00000002
%EC_USEFONTINFO = &H0000FFFF

' wParam of EM_GET/SETIMESTATUS
%EMSIS_COMPOSITIONSTRING        = &H0001

' lParam for EMSIS_COMPOSITIONSTRING
%EIMES_GETCOMPSTRATONCE         = &H0001
%EIMES_CANCELCOMPSTRINFOCUS     = &H0002
%EIMES_COMPLETECOMPSTRKILLFOCUS = &H0004

' Edit Control Messages
%EM_GETSEL              = &HB0
%EM_SETSEL              = &HB1
%EM_GETRECT             = &HB2
%EM_SETRECT             = &HB3
%EM_SETRECTNP           = &HB4
%EM_SCROLL              = &HB5
%EM_LINESCROLL          = &HB6
%EM_SCROLLCARET         = &HB7
%EM_GETMODIFY           = &HB8
%EM_SETMODIFY           = &HB9
%EM_GETLINECOUNT        = &HBA
%EM_LINEINDEX           = &HBB
%EM_SETHANDLE           = &HBC
%EM_GETHANDLE           = &HBD
%EM_GETTHUMB            = &HBE
%EM_LINELENGTH          = &HC1
%EM_REPLACESEL          = &HC2
%EM_GETLINE             = &HC4
%EM_LIMITTEXT           = &HC5
%EM_CANUNDO             = &HC6
%EM_UNDO                = &HC7
%EM_FMTLINES            = &HC8
%EM_LINEFROMCHAR        = &HC9
%EM_SETTABSTOPS         = &HCB
%EM_SETPASSWORDCHAR     = &HCC
%EM_EMPTYUNDOBUFFER     = &HCD
%EM_GETFIRSTVISIBLELINE = &HCE
%EM_SETREADONLY         = &HCF
%EM_SETWORDBREAKPROC    = &HD0
%EM_GETWORDBREAKPROC    = &HD1
%EM_GETPASSWORDCHAR     = &HD2
%EM_SETMARGINS          = &HD3
%EM_GETMARGINS          = &HD4
%EM_SETLIMITTEXT        = %EM_LIMITTEXT
%EM_GETLIMITTEXT        = &HD5
%EM_POSFROMCHAR         = &HD6
%EM_CHARFROMPOS         = &HD7

' EDITWORDBREAKPROC code values
%WB_LEFT        = 0
%WB_RIGHT       = 1
%WB_ISDELIMITER = 2

' Button Control Styles
%BS_TEXT            = &H0&
%BS_PUSHBUTTON      = &H0&
%BS_DEFPUSHBUTTON   = &H1&
%BS_DEFAULT         = %BS_DEFPUSHBUTTON
%BS_CHECKBOX        = &H2&
%BS_AUTOCHECKBOX    = &H3&
%BS_RADIOBUTTON     = &H4&
%BS_3STATE          = &H5&
%BS_AUTO3STATE      = &H6&
%BS_GROUPBOX        = &H7&
%BS_USERBUTTON      = &H8&
%BS_AUTORADIOBUTTON = &H9&
%BS_OWNERDRAW       = &HB&
%BS_LEFTTEXT        = &H20&
%BS_ICON            = &H40&
%BS_BITMAP          = &H80&
%BS_LEFT            = &H100&
%BS_RIGHT           = &H200&
%BS_CENTER          = &H300&
%BS_TOP             = &H400&
%BS_BOTTOM          = &H800&
%BS_VCENTER         = &HC00&
%BS_PUSHLIKE        = &H1000&
%BS_MULTILINE       = &H2000&
%BS_NOTIFY          = &H4000&
%BS_FLAT            = &H8000&
%BS_RIGHTBUTTON     = %BS_LEFTTEXT

' User Button Notification Codes
%BN_CLICKED        = 0
%BN_PAINT          = 1
%BN_HILITE         = 2
%BN_UNHILITE       = 3
%BN_DISABLE        = 4
%BN_DOUBLECLICKED  = 5
%BN_SETFOCUS       = 6
%BN_KILLFOCUS      = 7
%BN_DBLCLK         = %BN_DOUBLECLICKED

' Button Control Messages
%BST_UNCHECKED     = &H00
%BST_CHECKED       = &H01
%BST_INDETERMINATE = &H02
%BST_PUSHED        = &H04

%BM_GETCHECK = &HF0
%BM_SETCHECK = &HF1
%BM_GETSTATE = &HF2
%BM_SETSTATE = &HF3
%BM_SETSTYLE = &HF4
%BM_CLICK    = &HF5
%BM_GETIMAGE = &HF6
%BM_SETIMAGE = &HF7

' Static Control Constants
%SS_LEFT            = &H0000&
%SS_CENTER          = &H0001&
%SS_RIGHT           = &H0002&
%SS_ICON            = &H0003&
%SS_BLACKRECT       = &H0004&
%SS_GRAYRECT        = &H0005&
%SS_WHITERECT       = &H0006&
%SS_BLACKFRAME      = &H0007&
%SS_GRAYFRAME       = &H0008&
%SS_WHITEFRAME      = &H0009&
%SS_USERITEM        = &H000A&
%SS_SIMPLE          = &H000B&
%SS_LEFTNOWORDWRAP  = &H000C&
%SS_NOWORDWRAP      = %SS_LEFTNOWORDWRAP
%SS_OWNERDRAW       = &H000D&
%SS_BITMAP          = &H000E&
%SS_ENHMETAFILE     = &H000F&
%SS_ETCHEDHORZ      = &H0010&
%SS_ETCHEDVERT      = &H0011&
%SS_ETCHEDFRAME     = &H0012&
%SS_TYPEMASK        = &H001F&
%SS_NOPREFIX        = &H0080& '  Don't do "&" character translation
%SS_NOTIFY          = &H0100&
%SS_CENTERIMAGE     = &H0200&
%SS_RIGHTJUST       = &H0400&
%SS_REALSIZEIMAGE   = &H0800&
%SS_REALSIZE        = %SS_REALSIZEIMAGE
%SS_SUNKEN          = &H1000&
%SS_ENDELLIPSIS     = &H4000&
%SS_PATHELLIPSIS    = &H8000&
%SS_WORDELLIPSIS    = &HC000&
%SS_ELLIPSISMASK    = &HC000&

' Static Control Mesages
%STM_SETICON  = &H170
%STM_GETICON  = &H171
%STM_SETIMAGE = &H172
%STM_GETIMAGE = &H173
%STM_MSGMAX   = &H174

%STN_CLICKED  = 0
%STN_DBLCLK   = 1
%STN_ENABLE   = 2
%STN_DISABLE  = 3

%WC_DIALOG = 8002&

'  Get/SetWindowWord/Long offsets for use with WC_DIALOG windows
%DWL_MSGRESULT = 0
%DWL_DLGPROC   = 4
%DWL_USER      = 8

' DlgDirList, DlgDirListComboBox flags values
%DDL_READWRITE = &H0
%DDL_READONLY  = &H1
%DDL_HIDDEN    = &H2
%DDL_SYSTEM    = &H4
%DDL_DIRECTORY = &H10
%DDL_ARCHIVE   = &H20

%DDL_POSTMSGS  = &H2000
%DDL_DRIVES    = &H4000
%DDL_EXCLUSIVE = &H8000

' Dialog Styles
%DS_ABSALIGN      = &H0001&
%DS_SYSMODAL      = &H0002&
%DS_3DLOOK        = &H0004&
%DS_FIXEDSYS      = &H0008&
%DS_NOFAILCREATE  = &H0010&
%DS_LOCALEDIT     = &H0020& '  Edit items get Local storage.
%DS_SETFONT       = &H0040& '  User specified font for Dlg controls
%DS_MODALFRAME    = &H0080& '  Can be combined with WS_CAPTION
%DS_NOIDLEMSG     = &H0100& '  WM_ENTERIDLE message will not be sent
%DS_SETFOREGROUND = &H0200& '  not in win3.1
%DS_CONTROL       = &H0400&
%DS_CENTER        = &H0800&
%DS_CENTERMOUSE   = &H1000&
%DS_CONTEXTHELP   = &H2000&

%DS_DDT_DEFAULT   = %WS_POPUP AND %WS_CAPTION AND %DS_MODALFRAME

%DM_GETDEFID      = %WM_USER + 0
%DM_SETDEFID      = %WM_USER + 1
%DC_HASDEFID      = &H534      '&H534B

' Dialog Codes
%DLGC_WANTARROWS      = &H1    '  Control wants arrow keys
%DLGC_WANTTAB         = &H2    '  Control wants tab keys
%DLGC_WANTALLKEYS     = &H4    '  Control wants all keys
%DLGC_WANTMESSAGE     = &H4    '  Pass message to control
%DLGC_HASSETSEL       = &H8    '  Understands EM_SETSEL message
%DLGC_DEFPUSHBUTTON   = &H10   '  Default pushbutton
%DLGC_UNDEFPUSHBUTTON = &H20   '  Non-default pushbutton
%DLGC_RADIOBUTTON     = &H40   '  Radio button
%DLGC_WANTCHARS       = &H80   '  Want WM_CHAR messages
%DLGC_STATIC          = &H100  '  Static item: don't include
%DLGC_BUTTON          = &H2000 '  Button item: can be checked

%LB_CTLCODE  = 0&

' Listbox Return Values
%LB_OKAY     = 0
%LB_ERR      = -1
%LB_ERRSPACE = -2

' The idStaticPath parameter to DlgDirList can have the following values
' ORed if the list box should show other details of the files along with
' the name of the files;
' all other details also will be returned

' Listbox Notification Codes
%LBN_ERRSPACE  = -2
%LBN_SELCHANGE = 1
%LBN_DBLCLK    = 2
%LBN_SELCANCEL = 3
%LBN_SETFOCUS  = 4
%LBN_KILLFOCUS = 5

' Listbox messages
%LB_ADDSTRING          = &H180
%LB_INSERTSTRING       = &H181
%LB_DELETESTRING       = &H182
%LB_SELITEMRANGEEX     = &H183
%LB_RESETCONTENT       = &H184
%LB_SETSEL             = &H185
%LB_SETCURSEL          = &H186
%LB_GETSEL             = &H187
%LB_GETCURSEL          = &H188
%LB_GETTEXT            = &H189
%LB_GETTEXTLEN         = &H18A
%LB_GETCOUNT           = &H18B
%LB_SELECTSTRING       = &H18C
%LB_DIR                = &H18D
%LB_GETTOPINDEX        = &H18E
%LB_FINDSTRING         = &H18F
%LB_GETSELCOUNT        = &H190
%LB_GETSELITEMS        = &H191
%LB_SETTABSTOPS        = &H192
%LB_GETHORIZONTALEXTENT= &H193
%LB_SETHORIZONTALEXTENT= &H194
%LB_SETCOLUMNWIDTH     = &H195
%LB_ADDFILE            = &H196
%LB_SETTOPINDEX        = &H197
%LB_GETITEMRECT        = &H198
%LB_GETITEMDATA        = &H199
%LB_SETITEMDATA        = &H19A
%LB_SELITEMRANGE       = &H19B
%LB_SETANCHORINDEX     = &H19C
%LB_GETANCHORINDEX     = &H19D
%LB_SETCARETINDEX      = &H19E
%LB_GETCARETINDEX      = &H19F
%LB_SETITEMHEIGHT      = &H1A0
%LB_GETITEMHEIGHT      = &H1A1
%LB_FINDSTRINGEXACT    = &H1A2
%LB_SETLOCALE          = &H1A5
%LB_GETLOCALE          = &H1A6
%LB_SETCOUNT           = &H1A7
%LB_INITSTORAGE        = &H1A8
%LB_ITEMFROMPOINT      = &H1A9
%LB_MSGMAX             = &H1B0

' Listbox Styles
%LBS_NOTIFY            = &H1&
%LBS_SORT              = &H2&
%LBS_NOREDRAW          = &H4&
%LBS_MULTIPLESEL       = &H8&
%LBS_OWNERDRAWFIXED    = &H10&
%LBS_OWNERDRAWVARIABLE = &H20&
%LBS_HASSTRINGS        = &H40&
%LBS_USETABSTOPS       = &H80&
%LBS_NOINTEGRALHEIGHT  = &H100&
%LBS_MULTICOLUMN       = &H200&
%LBS_WANTKEYBOARDINPUT = &H400&
%LBS_EXTENDEDSEL       = &H800&
%LBS_DISABLENOSCROLL   = &H1000&
%LBS_NODATA            = &H2000&
%LBS_NOSEL             = &H4000&
%LBS_STANDARD          = %LBS_NOTIFY OR %LBS_SORT OR %WS_VSCROLL OR %WS_BORDER

' Combo Box return Values
%CB_OKAY     = 0
%CB_ERR      = -1
%CB_ERRSPACE = -2

' Combo Box Notification Codes
%CBN_ERRSPACE     = -1
%CBN_SELCHANGE    = 1
%CBN_DBLCLK       = 2
%CBN_SETFOCUS     = 3
%CBN_KILLFOCUS    = 4
%CBN_EDITCHANGE   = 5
%CBN_EDITUPDATE   = 6
%CBN_DROPDOWN     = 7
%CBN_CLOSEUP      = 8
%CBN_SELENDOK     = 9
%CBN_SELENDCANCEL = 10
%CBN_SELCANCEL    = %CBN_SELENDCANCEL

' Combo Box styles
%CBS_SIMPLE            = &H1&
%CBS_DROPDOWN          = &H2&
%CBS_DROPDOWNLIST      = &H3&
%CBS_OWNERDRAWFIXED    = &H10&
%CBS_OWNERDRAWVARIABLE = &H20&
%CBS_AUTOHSCROLL       = &H40&
%CBS_OEMCONVERT        = &H80&
%CBS_SORT              = &H100&
%CBS_HASSTRINGS        = &H200&
%CBS_NOINTEGRALHEIGHT  = &H400&
%CBS_DISABLENOSCROLL   = &H800&
%CBS_UPPERCASE         = &H2000&
%CBS_LOWERCASE         = &H4000&

' Combo Box messages
%CB_GETEDITSEL            = &H140
%CB_LIMITTEXT             = &H141
%CB_SETEDITSEL            = &H142
%CB_ADDSTRING             = &H143
%CB_DELETESTRING          = &H144
%CB_DIR                   = &H145
%CB_GETCOUNT              = &H146
%CB_GETCURSEL             = &H147
%CB_GETLBTEXT             = &H148
%CB_GETLBTEXTLEN          = &H149
%CB_INSERTSTRING          = &H14A
%CB_RESETCONTENT          = &H14B
%CB_FINDSTRING            = &H14C
%CB_SELECTSTRING          = &H14D
%CB_SETCURSEL             = &H14E
%CB_SHOWDROPDOWN          = &H14F
%CB_GETITEMDATA           = &H150
%CB_SETITEMDATA           = &H151
%CB_GETDROPPEDCONTROLRECT = &H152
%CB_SETITEMHEIGHT         = &H153
%CB_GETITEMHEIGHT         = &H154
%CB_SETEXTENDEDUI         = &H155
%CB_GETEXTENDEDUI         = &H156
%CB_GETDROPPEDSTATE       = &H157
%CB_FINDSTRINGEXACT       = &H158
%CB_SETLOCALE             = &H159
%CB_GETLOCALE             = &H15A
%CB_GETTOPINDEX           = &H15B
%CB_SETTOPINDEX           = &H15C
%CB_GETHORIZONTALEXTENT   = &H15D
%CB_SETHORIZONTALEXTENT   = &H15E
%CB_GETDROPPEDWIDTH       = &H15F
%CB_SETDROPPEDWIDTH       = &H160
%CB_INITSTORAGE           = &H161
%CB_MSGMAX                = &H162

' Scroll Bar Styles
%SBS_HORZ                    = &H0&
%SBS_VERT                    = &H1&
%SBS_TOPALIGN                = &H2&
%SBS_LEFTALIGN               = &H2&
%SBS_BOTTOMALIGN             = &H4&
%SBS_RIGHTALIGN              = &H4&
%SBS_SIZEBOXTOPLEFTALIGN     = &H2&
%SBS_SIZEBOXBOTTOMRIGHTALIGN = &H4&
%SBS_SIZEBOX                 = &H8&
%SBS_SIZEGRIP                = &H10&

'  Scroll bar messages
%SBM_SETPOS         = &HE0 ' not in win3.1
%SBM_GETPOS         = &HE1 ' not in win3.1
%SBM_SETRANGE       = &HE2 ' not in win3.1
%SBM_SETRANGEREDRAW = &HE6 ' not in win3.1
%SBM_GETRANGE       = &HE3 ' not in win3.1
%SBM_ENABLE_ARROWS  = &HE4 ' not in win3.1

%MDIS_ALLCHILDSTYLES = &H1

' wParam values for WM_MDITILE and WM_MDICASCADE messages.
%MDITILE_VERTICAL     = &H0
%MDITILE_HORIZONTAL   = &H1
%MDITILE_SKIPDISABLED = &H2

' Commands to pass WinHelp()
%HELP_CONTEXT      = &H1    '  Display topic in ulTopic
%HELP_QUIT         = &H2    '  Terminate help
%HELP_INDEX        = &H3    '  Display index
%HELP_CONTENTS     = &H3&
%HELP_HELPONHELP   = &H4    '  Display help on using help
%HELP_SETINDEX     = &H5    '  Set current Index for multi index help
%HELP_SETCONTENTS  = &H5&
%HELP_CONTEXTPOPUP = &H8&
%HELP_FORCEFILE    = &H9&
%HELP_KEY          = &H101  '  Display topic for keyword in offabData
%HELP_COMMAND      = &H102&
%HELP_PARTIALKEY   = &H105&
%HELP_MULTIKEY     = &H201&
%HELP_SETWINPOS    = &H203&
%HELP_CONTEXTMENU  = &H000A
%HELP_FINDER       = &H000B
%HELP_WM_HELP      = &H000C
%HELP_SETPOPUP_POS = &H000D

%HELP_TCARD              = &H8000
%HELP_TCARD_DATA         = &H0010
%HELP_TCARD_OTHER_CALLER = &H0011

' These are in winhelp.h in Win95.
%IDH_NO_HELP             = 28440
%IDH_MISSING_CONTEXT     = 28441 ' Control doesn't have matching help context
%IDH_GENERIC_HELP_BUTTON = 28442 ' Property sheet help button
%IDH_OK                  = 28443
%IDH_CANCEL              = 28444
%IDH_HELP                = 28445

' Parameter for SystemParametersInfo()
%SPI_GETBEEP               = 1
%SPI_SETBEEP               = 2
%SPI_GETMOUSE              = 3
%SPI_SETMOUSE              = 4
%SPI_GETBORDER             = 5
%SPI_SETBORDER             = 6
%SPI_GETKEYBOARDSPEED      = 10
%SPI_SETKEYBOARDSPEED      = 11
%SPI_LANGDRIVER            = 12
%SPI_ICONHORIZONTALSPACING = 13
%SPI_GETSCREENSAVETIMEOUT  = 14
%SPI_SETSCREENSAVETIMEOUT  = 15
%SPI_GETSCREENSAVEACTIVE   = 16
%SPI_SETSCREENSAVEACTIVE   = 17
%SPI_GETGRIDGRANULARITY    = 18
%SPI_SETGRIDGRANULARITY    = 19
%SPI_SETDESKWALLPAPER      = 20
%SPI_SETDESKPATTERN        = 21
%SPI_GETKEYBOARDDELAY      = 22
%SPI_SETKEYBOARDDELAY      = 23
%SPI_ICONVERTICALSPACING   = 24
%SPI_GETICONTITLEWRAP      = 25
%SPI_SETICONTITLEWRAP      = 26
%SPI_GETMENUDROPALIGNMENT  = 27
%SPI_SETMENUDROPALIGNMENT  = 28
%SPI_SETDOUBLECLKWIDTH     = 29
%SPI_SETDOUBLECLKHEIGHT    = 30
%SPI_GETICONTITLELOGFONT   = 31
%SPI_SETDOUBLECLICKTIME    = 32
%SPI_SETMOUSEBUTTONSWAP    = 33
%SPI_SETICONTITLELOGFONT   = 34
%SPI_GETFASTTASKSWITCH     = 35
%SPI_SETFASTTASKSWITCH     = 36
%SPI_SETDRAGFULLWINDOWS    = 37
%SPI_GETDRAGFULLWINDOWS    = 38
%SPI_GETNONCLIENTMETRICS   = 41
%SPI_SETNONCLIENTMETRICS   = 42
%SPI_GETMINIMIZEDMETRICS   = 43
%SPI_SETMINIMIZEDMETRICS   = 44
%SPI_GETICONMETRICS        = 45
%SPI_SETICONMETRICS        = 46
%SPI_SETWORKAREA           = 47
%SPI_GETWORKAREA           = 48
%SPI_SETPENWINDOWS         = 49
%SPI_GETFILTERKEYS         = 50
%SPI_SETFILTERKEYS         = 51
%SPI_GETTOGGLEKEYS         = 52
%SPI_SETTOGGLEKEYS         = 53
%SPI_GETMOUSEKEYS          = 54
%SPI_SETMOUSEKEYS          = 55
%SPI_GETSHOWSOUNDS         = 56
%SPI_SETSHOWSOUNDS         = 57
%SPI_GETSTICKYKEYS         = 58
%SPI_SETSTICKYKEYS         = 59
%SPI_GETACCESSTIMEOUT      = 60
%SPI_SETACCESSTIMEOUT      = 61
%SPI_GETSERIALKEYS         = 62
%SPI_SETSERIALKEYS         = 63
%SPI_GETSOUNDSENTRY        = 64
%SPI_SETSOUNDSENTRY        = 65
%SPI_GETHIGHCONTRAST       = 66
%SPI_SETHIGHCONTRAST       = 67
%SPI_GETKEYBOARDPREF       = 68
%SPI_SETKEYBOARDPREF       = 69
%SPI_GETSCREENREADER       = 70
%SPI_SETSCREENREADER       = 71
%SPI_GETANIMATION          = 72
%SPI_SETANIMATION          = 73
%SPI_GETFONTSMOOTHING      = 74
%SPI_SETFONTSMOOTHING      = 75
%SPI_SETDRAGWIDTH          = 76
%SPI_SETDRAGHEIGHT         = 77
%SPI_SETHANDHELD           = 78
%SPI_GETLOWPOWERTIMEOUT    = 79
%SPI_GETPOWEROFFTIMEOUT    = 80
%SPI_SETLOWPOWERTIMEOUT    = 81
%SPI_SETPOWEROFFTIMEOUT    = 82
%SPI_GETLOWPOWERACTIVE     = 83
%SPI_GETPOWEROFFACTIVE     = 84
%SPI_SETLOWPOWERACTIVE     = 85
%SPI_SETPOWEROFFACTIVE     = 86
%SPI_SETCURSORS            = 87
%SPI_SETICONS              = 88
%SPI_GETDEFAULTINPUTLANG   = 89
%SPI_SETDEFAULTINPUTLANG   = 90
%SPI_SETLANGTOGGLE         = 91
%SPI_GETWINDOWSEXTENSION   = 92
%SPI_SETMOUSETRAILS        = 93
%SPI_GETMOUSETRAILS        = 94
%SPI_SCREENSAVERRUNNING    = 97
%SPI_SETMOUSEHOVERWIDTH    = 99
%SPI_GETMOUSEHOVERHEIGHT   = 100
%SPI_SETMOUSEHOVERHEIGHT   = 101
%SPI_GETMOUSEHOVERTIME     = 102
%SPI_SETMOUSEHOVERTIME     = 103
%SPI_GETWHEELSCROLLLINES   = 104
%SPI_SETWHEELSCROLLLINES   = 105
%SPI_GETSHOWIMEUI          = 110
%SPI_SETSHOWIMEUI          = 111

%SPI_GETMOUSESPEED         = 112
%SPI_SETMOUSESPEED         = 113
%SPI_GETSCREENSAVERRUNNING = 114
%SPI_GETDESKWALLPAPER      = 115

%SPI_GETACTIVEWINDOWTRACKING      = &H1000
%SPI_SETACTIVEWINDOWTRACKING      = &H1001
%SPI_GETMENUANIMATION             = &H1002
%SPI_SETMENUANIMATION             = &H1003
%SPI_GETCOMBOBOXANIMATION         = &H1004
%SPI_SETCOMBOBOXANIMATION         = &H1005
%SPI_GETLISTBOXSMOOTHSCROLLING    = &H1006
%SPI_SETLISTBOXSMOOTHSCROLLING    = &H1007
%SPI_GETGRADIENTCAPTIONS          = &H1008
%SPI_SETGRADIENTCAPTIONS          = &H1009
%SPI_GETKEYBOARDCUES              = &H100A
%SPI_SETKEYBOARDCUES              = &H100B
%SPI_GETMENUUNDERLINES            = %SPI_GETKEYBOARDCUES
%SPI_SETMENUUNDERLINES            = %SPI_SETKEYBOARDCUES
%SPI_GETACTIVEWNDTRKZORDER        = &H100C
%SPI_SETACTIVEWNDTRKZORDER        = &H100D
%SPI_GETHOTTRACKING               = &H100E
%SPI_SETHOTTRACKING               = &H100F
%SPI_GETMENUFADE                  = &H1012
%SPI_SETMENUFADE                  = &H1013
%SPI_GETSELECTIONFADE             = &H1014
%SPI_SETSELECTIONFADE             = &H1015
%SPI_GETTOOLTIPANIMATION          = &H1016
%SPI_SETTOOLTIPANIMATION          = &H1017
%SPI_GETTOOLTIPFADE               = &H1018
%SPI_SETTOOLTIPFADE               = &H1019
%SPI_GETCURSORSHADOW              = &H101A
%SPI_SETCURSORSHADOW              = &H101B

%SPI_GETUIEFFECTS                 = &H103E
%SPI_SETUIEFFECTS                 = &H103F

%SPI_GETFOREGROUNDLOCKTIMEOUT     = &H2000
%SPI_SETFOREGROUNDLOCKTIMEOUT     = &H2001
%SPI_GETACTIVEWNDTRKTIMEOUT       = &H2002
%SPI_SETACTIVEWNDTRKTIMEOUT       = &H2003
%SPI_GETFOREGROUNDFLASHCOUNT      = &H2004
%SPI_SETFOREGROUNDFLASHCOUNT      = &H2005
%SPI_GETCARETWIDTH                = &H2006
%SPI_SETCARETWIDTH                = &H2007

%WHEEL_DELTA      = 120
%WHEEL_PAGESCROLL = &HFFFFFFFF

' SystemParametersInfo flags
%SPIF_UPDATEINIFILE    = &H1
%SPIF_SENDWININICHANGE = &H2
%SPIF_SENDCHANGE       = %SPIF_SENDWININICHANGE

%ARW_BOTTOMLEFT  = &H0000
%ARW_BOTTOMRIGHT = &H0001
%ARW_TOPLEFT     = &H0002
%ARW_TOPRIGHT    = &H0003
%ARW_STARTMASK   = &H0003
%ARW_STARTRIGHT  = &H0001
%ARW_STARTTOP    = &H0002

%ARW_LEFT        = &H0000
%ARW_RIGHT       = &H0000
%ARW_UP          = &H0004
%ARW_DOWN        = &H0004
%ARW_HIDE        = &H0008

' flags for SERIALKEYS dwFlags field
%SERKF_SERIALKEYSON = &H00000001
%SERKF_AVAILABLE    = &H00000002
%SERKF_INDICATOR    = &H00000004

' FILTERKEYS dwFlags field
%FKF_FILTERKEYSON    = &H00000001
%FKF_AVAILABLE       = &H00000002
%FKF_HOTKEYACTIVE    = &H00000004
%FKF_CONFIRMHOTKEY   = &H00000008
%FKF_HOTKEYSOUND     = &H00000010
%FKF_INDICATOR       = &H00000020
%FKF_CLICKON         = &H00000040

' STICKYKEYS dwFlags field
%SKF_STICKYKEYSON    = &H00000001???
%SKF_AVAILABLE       = &H00000002???
%SKF_HOTKEYACTIVE    = &H00000004???
%SKF_CONFIRMHOTKEY   = &H00000008???
%SKF_HOTKEYSOUND     = &H00000010???
%SKF_INDICATOR       = &H00000020???
%SKF_AUDIBLEFEEDBACK = &H00000040???
%SKF_TRISTATE        = &H00000080???
%SKF_TWOKEYSOFF      = &H00000100???
%SKF_LALTLATCHED     = &H10000000???
%SKF_LCTLLATCHED     = &H04000000???
%SKF_LSHIFTLATCHED   = &H01000000???
%SKF_RALTLATCHED     = &H20000000???
%SKF_RCTLLATCHED     = &H08000000???
%SKF_RSHIFTLATCHED   = &H02000000???
%SKF_LWINLATCHED     = &H40000000???
%SKF_RWINLATCHED     = &H80000000???
%SKF_LALTLOCKED      = &H00100000???
%SKF_LCTLLOCKED      = &H00040000???
%SKF_LSHIFTLOCKED    = &H00010000???
%SKF_RALTLOCKED      = &H00200000???
%SKF_RCTLLOCKED      = &H00080000???
%SKF_RSHIFTLOCKED    = &H00020000???
%SKF_LWINLOCKED      = &H00400000???
%SKF_RWINLOCKED      = &H00800000???

' MOUSEKEYS dwFlags field
%MKF_MOUSEKEYSON     = &H00000001???
%MKF_AVAILABLE       = &H00000002???
%MKF_HOTKEYACTIVE    = &H00000004???
%MKF_CONFIRMHOTKEY   = &H00000008???
%MKF_HOTKEYSOUND     = &H00000010???
%MKF_INDICATOR       = &H00000020???
%MKF_MODIFIERS       = &H00000040???
%MKF_REPLACENUMBERS  = &H00000080???
%MKF_LEFTBUTTONSEL   = &H10000000???
%MKF_RIGHTBUTTONSEL  = &H20000000???
%MKF_LEFTBUTTONDOWN  = &H01000000???
%MKF_RIGHTBUTTONDOWN = &H02000000???
%MKF_MOUSEMODE       = &H80000000???

' ACCESSTIMEOUT dwFlags field
%ATF_TIMEOUTON     = &H00000001
%ATF_ONOFFFEEDBACK = &H00000002

' values for SOUNDSENTRY iFSGrafEffect field
%SSGF_NONE    = 0
%SSGF_DISPLAY = 3

' values for SOUNDSENTRY iFSTextEffect field
%SSTF_NONE    = 0
%SSTF_CHARS   = 1
%SSTF_BORDER  = 2
%SSTF_DISPLAY = 3

' values for SOUNDSENTRY iWindowsEffect field
%SSWF_NONE    = 0
%SSWF_TITLE   = 1
%SSWF_WINDOW  = 2
%SSWF_DISPLAY = 3
%SSWF_CUSTOM  = 4

' SOUNDSENTRY dwFlags field
%SSF_SOUNDSENTRYON = &H00000001
%SSF_AVAILABLE     = &H00000002
%SSF_INDICATOR     = &H00000004

' TOGGLEKEYS dwFlags field
%TKF_TOGGLEKEYSON  = &H00000001
%TKF_AVAILABLE     = &H00000002
%TKF_HOTKEYACTIVE  = &H00000004
%TKF_CONFIRMHOTKEY = &H00000008
%TKF_HOTKEYSOUND   = &H00000010
%TKF_INDICATOR     = &H00000020

' SetLastErrorEx types.
%SLE_ERROR      = &H1
%SLE_MINORERROR = &H2
%SLE_WARNING    = &H3

' Multimonitor API.

%MONITOR_DEFAULTTONULL    = &H00000000
%MONITOR_DEFAULTTOPRIMARY = &H00000001
%MONITOR_DEFAULTTONEAREST = &H00000002

%MONITORINFOF_PRIMARY = &H00000001

' DDE window messages
%WM_DDE_FIRST     = &H3E0
%WM_DDE_INITIATE  = %WM_DDE_FIRST
%WM_DDE_TERMINATE = %WM_DDE_FIRST + 1
%WM_DDE_ADVISE    = %WM_DDE_FIRST + 2
%WM_DDE_UNADVISE  = %WM_DDE_FIRST + 3
%WM_DDE_ACK       = %WM_DDE_FIRST + 4
%WM_DDE_DATA      = %WM_DDE_FIRST + 5
%WM_DDE_REQUEST   = %WM_DDE_FIRST + 6
%WM_DDE_POKE      = %WM_DDE_FIRST + 7
%WM_DDE_EXECUTE   = %WM_DDE_FIRST + 8
%WM_DDE_LAST      = %WM_DDE_FIRST + 8

' conversation states (usState)
%XST_NULL           = 0  '  quiescent states
%XST_INCOMPLETE     = 1
%XST_CONNECTED      = 2
%XST_INIT1          = 3  '  mid-initiation states
%XST_INIT2          = 4
%XST_REQSENT        = 5  '  active conversation states
%XST_DATARCVD       = 6
%XST_POKESENT       = 7
%XST_POKEACKRCVD    = 8
%XST_EXECSENT       = 9
%XST_EXECACKRCVD    = 10
%XST_ADVSENT        = 11
%XST_UNADVSENT      = 12
%XST_ADVACKRCVD     = 13
%XST_UNADVACKRCVD   = 14
%XST_ADVDATASENT    = 15
%XST_ADVDATAACKRCVD = 16

' used in LOWORD(dwData1) of XTYP_ADVREQ callbacks...
%CADV_LATEACK = &HFFFF

' conversation status bits (fsStatus)
%ST_CONNECTED  = &H1
%ST_ADVISE     = &H2
%ST_ISLOCAL    = &H4
%ST_BLOCKED    = &H8
%ST_CLIENT     = &H10
%ST_TERMINATED = &H20
%ST_INLIST     = &H40
%ST_BLOCKNEXT  = &H80
%ST_ISSELF     = &H100

'  DDE constants for wStatus field
%DDE_FACK         = &H8000
%DDE_FBUSY        = &H4000
%DDE_FDEFERUPD    = &H4000
%DDE_FACKREQ      = &H8000
%DDE_FRELEASE     = &H2000
%DDE_FREQUESTED   = &H1000
%DDE_FAPPSTATUS   = &HFF
%DDE_FNOTPROCESSED= &H0

%DDE_FACKRESERVED = NOT (%DDE_FACK OR %DDE_FBUSY OR %DDE_FAPPSTATUS)
%DDE_FADVRESERVED = NOT (%DDE_FACKREQ OR %DDE_FDEFERUPD)
%DDE_FDATRESERVED = NOT (%DDE_FACKREQ OR %DDE_FRELEASE OR %DDE_FREQUESTED)
%DDE_FPOKRESERVED = NOT (%DDE_FRELEASE)

'  codepage constants
%CP_WINANSI    = 1004  '  default codepage for windows old DDE convs.
%CP_WINUNICODE = 1200

'  transaction types
%XTYPF_NOBLOCK = &H2     '  CBR_BLOCK will not work
%XTYPF_NODATA  = &H4     '  DDE_FDEFERUPD
%XTYPF_ACKREQ  = &H8     '  DDE_FACKREQ

%XCLASS_MASK         = &HFC00
%XCLASS_BOOL         = &H1000
%XCLASS_DATA         = &H2000
%XCLASS_FLAGS        = &H4000
%XCLASS_NOTIFICATION = &H8000

%XTYP_ERROR           = &H0 OR %XCLASS_NOTIFICATION OR %XTYPF_NOBLOCK
%XTYP_ADVDATA         = &H10 OR %XCLASS_FLAGS
%XTYP_ADVREQ          = &H20 OR %XCLASS_DATA OR %XTYPF_NOBLOCK
%XTYP_ADVSTART        = &H30 OR %XCLASS_BOOL
%XTYP_ADVSTOP         = &H40 OR %XCLASS_NOTIFICATION
%XTYP_EXECUTE         = &H50 OR %XCLASS_FLAGS
%XTYP_CONNECT         = &H60 OR %XCLASS_BOOL OR %XTYPF_NOBLOCK
%XTYP_CONNECT_CONFIRM = &H70 OR %XCLASS_NOTIFICATION OR %XTYPF_NOBLOCK
%XTYP_XACT_COMPLETE   = &H80 OR %XCLASS_NOTIFICATION
%XTYP_POKE            = &H90 OR %XCLASS_FLAGS
%XTYP_REGISTER        = &HA0 OR %XCLASS_NOTIFICATION OR %XTYPF_NOBLOCK
%XTYP_REQUEST         = &HB0 OR %XCLASS_DATA
%XTYP_DISCONNECT      = &HC0 OR %XCLASS_NOTIFICATION OR %XTYPF_NOBLOCK
%XTYP_UNREGISTER      = &HD0 OR %XCLASS_NOTIFICATION OR %XTYPF_NOBLOCK
%XTYP_WILDCONNECT     = &HE0 OR %XCLASS_DATA OR %XTYPF_NOBLOCK

%XTYP_MASK            = &HF0
%XTYP_SHIFT           = 4  '  shift to turn XTYP_ into an index

'  Timeout constants
%TIMEOUT_ASYNC = &HFFFF

'  Transaction ID constants
%QID_SYNC  = &HFFFF

%CBR_BLOCK = &HFFFF

' Callback filter flags for use with standard apps.
%CBF_FAIL_SELFCONNECTIONS   = &H1000
%CBF_FAIL_CONNECTIONS       = &H2000
%CBF_FAIL_ADVISES           = &H4000
%CBF_FAIL_EXECUTES          = &H8000
%CBF_FAIL_POKES             = &H10000
%CBF_FAIL_REQUESTS          = &H20000
%CBF_FAIL_ALLSVRXACTIONS    = &H3F000

%CBF_SKIP_CONNECT_CONFIRMS  = &H40000
%CBF_SKIP_REGISTRATIONS     = &H80000
%CBF_SKIP_UNREGISTRATIONS   = &H100000
%CBF_SKIP_DISCONNECTS       = &H200000
%CBF_SKIP_ALLNOTIFICATIONS  = &H3C0000

' Application command flags
%APPCMD_CLIENTONLY  = &H10&
%APPCMD_FILTERINITS = &H20&
%APPCMD_MASK        = &HFF0&

' Application classification flags
%APPCLASS_STANDARD  = &H0&
%APPCLASS_MASK      = &HF&

%EC_ENABLEALL    = 0
%EC_ENABLEONE    = %ST_BLOCKNEXT
%EC_DISABLE      = %ST_BLOCKED
%EC_QUERYWAITING = 2

%DNS_REGISTER   = &H1
%DNS_UNREGISTER = &H2
%DNS_FILTERON   = &H4
%DNS_FILTEROFF  = &H8

%HDATA_APPOWNED = &H1

%DMLERR_NO_ERROR            = 0      '  must be 0

%DMLERR_FIRST               = &H4000

%DMLERR_ADVACKTIMEOUT       = &H4000
%DMLERR_BUSY                = &H4001
%DMLERR_DATAACKTIMEOUT      = &H4002
%DMLERR_DLL_NOT_INITIALIZED = &H4003
%DMLERR_DLL_USAGE           = &H4004
%DMLERR_EXECACKTIMEOUT      = &H4005
%DMLERR_INVALIDPARAMETER    = &H4006
%DMLERR_LOW_MEMORY          = &H4007
%DMLERR_MEMORY_ERROR        = &H4008
%DMLERR_NOTPROCESSED        = &H4009
%DMLERR_NO_CONV_ESTABLISHED = &H400A
%DMLERR_POKEACKTIMEOUT      = &H400B
%DMLERR_POSTMSG_FAILED      = &H400C
%DMLERR_REENTRANCY          = &H400D
%DMLERR_SERVER_DIED         = &H400E
%DMLERR_SYS_ERROR           = &H400F
%DMLERR_UNADVACKTIMEOUT     = &H4010
%DMLERR_UNFOUND_QUEUE_ID    = &H4011

%DMLERR_LAST                = &H4011

%MH_CREATE  = 1
%MH_KEEP    = 2
%MH_DELETE  = 3
%MH_CLEANUP = 4

%MAX_MONITORS     = 4
%APPCLASS_MONITOR = &H1&
%XTYP_MONITOR     = &HF0 OR %XCLASS_NOTIFICATION OR %XTYPF_NOBLOCK

' Callback filter flags for use with MONITOR apps - 0 implies no monitor callbacks
%MF_HSZ_INFO  = &H1000000
%MF_SENDMSGS  = &H2000000
%MF_POSTMSGS  = &H4000000
%MF_CALLBACKS = &H8000000
%MF_ERRORS    = &H10000000
%MF_LINKS     = &H20000000
%MF_CONV      = &H40000000

%MF_MASK      = &HFF000000

' Browsing for directory.
%BIF_RETURNONLYFSDIRS   = &H0001  ' For finding a folder to start document searching
%BIF_DONTGOBELOWDOMAIN  = &H0002  ' For starting the Find Computer
%BIF_STATUSTEXT         = &H0004  ' Top of the dialog has 2 lines of text for BROWSEINFO.lpszTitle and one line if
                                  ' this flag is set.  Passing the message BFFM_SETSTATUSTEXTA to the hwnd can set the
                                  ' rest of the text.  This is not used with BIF_USENEWUI and BROWSEINFO.lpszTitle gets
                                  ' all three lines of text.
%BIF_RETURNFSANCESTORS  = &H0008
%BIF_EDITBOX            = &H0010   ' Add an editbox to the dialog
%BIF_VALIDATE           = &H0020   ' insist on valid result (or CANCEL)

%BIF_NEWDIALOGSTYLE     = &H0040   ' Use the new dialog layout with the ability to resize
                                        ' Caller needs to call OleInitialize() before using this API

%BIF_USENEWUI           = %BIF_NEWDIALOGSTYLE OR %BIF_EDITBOX

%BIF_BROWSEINCLUDEURLS  = &H0080   ' Allow URLs to be displayed or entered. (Requires BIF_USENEWUI)

%BIF_BROWSEFORCOMPUTER  = &H1000  ' Browsing for Computers.
%BIF_BROWSEFORPRINTER   = &H2000  ' Browsing for Printers
%BIF_BROWSEINCLUDEFILES = &H4000  ' Browsing for Everything
%BIF_SHAREABLE          = &H8000  ' sharable resources displayed (remote shares, requires BIF_USENEWUI)

' message from browser
%BFFM_INITIALIZED      = 1
%BFFM_SELCHANGED       = 2
%BFFM_VALIDATEFAILEDA  = 3   ' lParam:szPath ret:1(cont),0(EndDialog)
%BFFM_VALIDATEFAILEDW  = 4   ' lParam:wzPath ret:1(cont),0(EndDialog)

' messages to browser
%BFFM_SETSTATUSTEXTA   = %WM_USER + 100
%BFFM_ENABLEOK         = %WM_USER + 101
%BFFM_SETSELECTIONA    = %WM_USER + 102
%BFFM_SETSELECTIONW    = %WM_USER + 103
%BFFM_SETSTATUSTEXTW   = %WM_USER + 104

%BFFM_SETSTATUSTEXT  = %BFFM_SETSTATUSTEXTA
%BFFM_SETSELECTION   = %BFFM_SETSELECTIONA
%BFFM_VALIDATEFAILED = %BFFM_VALIDATEFAILEDA

' SHAddToRecentDocs
%SHARD_PIDL    = &H00000001
%SHARD_PATHA   = &H00000002
%SHARD_PATHW   = &H00000003

%SHARD_PATH  = %SHARD_PATHA



' -------------------------
'  MMSystem Section
' -------------------------

' This section defines all the support for Multimedia applications

'  general constants
%MAXPNAMELEN     = 32  '  max product name length (including NULL)
%MAXERRORLENGTH  = 128  '  max error text length (including final NULL)

'  values for wType field in MMTIME struct
%TIME_MS       = &H1     '  time in Milliseconds
%TIME_SAMPLES  = &H2     '  number of wave samples
%TIME_BYTES    = &H4     '  current byte offset
%TIME_SMPTE    = &H8     '  SMPTE time
%TIME_MIDI     = &H10    '  MIDI time

%MAX_JOYSTICKOEMVXDNAME  = 260

'  Multimedia Window Messages
%MM_JOY1MOVE       = &H3A0  '  joystick
%MM_JOY2MOVE       = &H3A1
%MM_JOY1ZMOVE      = &H3A2
%MM_JOY2ZMOVE      = &H3A3
%MM_JOY1BUTTONDOWN = &H3B5
%MM_JOY2BUTTONDOWN = &H3B6
%MM_JOY1BUTTONUP   = &H3B7
%MM_JOY2BUTTONUP   = &H3B8

%MM_MCINOTIFY        = &H3B9  '  MCI
%MM_MCISYSTEM_STRING = &H3CA

%MM_WOM_OPEN         = &H3BB  '  waveform output
%MM_WOM_CLOSE        = &H3BC
%MM_WOM_DONE         = &H3BD

%MM_WIM_OPEN         = &H3BE  '  waveform input
%MM_WIM_CLOSE        = &H3BF
%MM_WIM_DATA         = &H3C0

%MM_MIM_OPEN         = &H3C1  '  MIDI input
%MM_MIM_CLOSE        = &H3C2
%MM_MIM_DATA         = &H3C3
%MM_MIM_LONGDATA     = &H3C4
%MM_MIM_ERROR        = &H3C5
%MM_MIM_LONGERROR    = &H3C6

%MM_MOM_OPEN         = &H3C7  '  MIDI output
%MM_MOM_CLOSE        = &H3C8
%MM_MOM_DONE         = &H3C9

' String resource number bases (internal use)

%MMSYSERR_BASE = 0
%WAVERR_BASE   = 32
%MIDIERR_BASE  = 64
%TIMERR_BASE   = 96   '  was 128, changed to match Win 31 Sonic
%JOYERR_BASE   = 160
%MCIERR_BASE   = 256

%MCI_STRING_OFFSET  = 512  '  if this number is changed you MUST
                           '  alter the MCI_DEVTYPE_... list below
%MCI_VD_OFFSET      = 1024
%MCI_CD_OFFSET      = 1088
%MCI_WAVE_OFFSET    = 1152
%MCI_SEQ_OFFSET     = 1216

' General error return values
%MMSYSERR_NOERROR      = 0  '  no error
%MMSYSERR_ERROR        = %MMSYSERR_BASE + 1  '  unspecified error
%MMSYSERR_BADDEVICEID  = %MMSYSERR_BASE + 2  '  device ID out of range
%MMSYSERR_NOTENABLED   = %MMSYSERR_BASE + 3  '  driver failed enable
%MMSYSERR_ALLOCATED    = %MMSYSERR_BASE + 4  '  device already allocated
%MMSYSERR_INVALHANDLE  = %MMSYSERR_BASE + 5  '  device xHandle is invalid
%MMSYSERR_NODRIVER     = %MMSYSERR_BASE + 6  '  no device driver present
%MMSYSERR_NOMEM        = %MMSYSERR_BASE + 7  '  memory allocation error
%MMSYSERR_NOTSUPPORTED = %MMSYSERR_BASE + 8  '  function isn't supported
%MMSYSERR_BADERRNUM    = %MMSYSERR_BASE + 9  '  error value out of range
%MMSYSERR_INVALFLAG    = %MMSYSERR_BASE + 10 '  invalid flag passed
%MMSYSERR_INVALPARAM   = %MMSYSERR_BASE + 11 '  invalid parameter passed
%MMSYSERR_HANDLEBUSY   = %MMSYSERR_BASE + 12 '  xHandle being used
                                             '  simultaneously on another
                                             '  thread (eg callback)
%MMSYSERR_INVALIDALIAS = %MMSYSERR_BASE + 13 '  "Specified alias not found in WIN.INI
%MMSYSERR_LASTERROR    = %MMSYSERR_BASE + 13 '  last error in range
%MM_MOM_POSITIONCB = &H3CA     '  Callback for MEVT_POSITIONCB
%MM_MCISIGNAL      = &H3CB
%MM_MIM_MOREDATA   = &H3CC     '  MIM_DONE w/ pending events
%MIDICAPS_STREAM = &H8         '  driver supports midiStreamOut directly

%MEVT_F_SHORT    = &H0&
%MEVT_F_LONG     = &H80000000
%MEVT_F_CALLBACK = &H40000000
%MIDISTRM_ERROR  = -2

'
'  Structures and defines for midiStreamProperty
'
%MIDIPROP_SET = &H80000000
%MIDIPROP_GET = &H40000000

'  These are intentionally both non-zero so the app cannot accidentally
'  leave the operation off and happen to appear to work due to default
'  action.

%MIDIPROP_TIMEDIV = &H1&
%MIDIPROP_TEMPO   = &H2&

%MIXER_SHORT_NAME_CHARS = 16
%MIXER_LONG_NAME_CHARS  = 64

'
'   MMRESULT error return values specific to the mixer API
'
'
%MIXERR_BASE         = 1024
%MIXERR_INVALLINE    = %MIXERR_BASE + 0
%MIXERR_INVALCONTROL = %MIXERR_BASE + 1
%MIXERR_INVALVALUE   = %MIXERR_BASE + 2
%MIXERR_LASTERROR    = %MIXERR_BASE + 2


%MIXER_OBJECTF_HANDLE    = &H80000000
%MIXER_OBJECTF_MIXER     = &H0&
%MIXER_OBJECTF_HMIXER    = %MIXER_OBJECTF_HANDLE OR %MIXER_OBJECTF_MIXER
%MIXER_OBJECTF_WAVEOUT   = &H10000000
%MIXER_OBJECTF_HWAVEOUT  = %MIXER_OBJECTF_HANDLE OR %MIXER_OBJECTF_WAVEOUT
%MIXER_OBJECTF_WAVEIN    = &H20000000
%MIXER_OBJECTF_HWAVEIN   = %MIXER_OBJECTF_HANDLE OR %MIXER_OBJECTF_WAVEIN
%MIXER_OBJECTF_MIDIOUT   = &H30000000
%MIXER_OBJECTF_HMIDIOUT  = %MIXER_OBJECTF_HANDLE OR %MIXER_OBJECTF_MIDIOUT
%MIXER_OBJECTF_MIDIIN    = &H40000000
%MIXER_OBJECTF_HMIDIIN   = %MIXER_OBJECTF_HANDLE OR %MIXER_OBJECTF_MIDIIN
%MIXER_OBJECTF_AUX       = &H50000000

%MIXERLINE_LINEF_ACTIVE       = &H1&
%MIXERLINE_LINEF_DISCONNECTED = &H8000&
%MIXERLINE_LINEF_SOURCE       = &H80000000

'   MIXERLINE.dwComponentType

'   component types for destinations and sources

%MIXERLINE_COMPONENTTYPE_DST_FIRST     = &H0&
%MIXERLINE_COMPONENTTYPE_DST_UNDEFINED = %MIXERLINE_COMPONENTTYPE_DST_FIRST + 0
%MIXERLINE_COMPONENTTYPE_DST_DIGITAL   = %MIXERLINE_COMPONENTTYPE_DST_FIRST + 1
%MIXERLINE_COMPONENTTYPE_DST_LINE      = %MIXERLINE_COMPONENTTYPE_DST_FIRST + 2
%MIXERLINE_COMPONENTTYPE_DST_MONITOR   = %MIXERLINE_COMPONENTTYPE_DST_FIRST + 3
%MIXERLINE_COMPONENTTYPE_DST_SPEAKERS  = %MIXERLINE_COMPONENTTYPE_DST_FIRST + 4
%MIXERLINE_COMPONENTTYPE_DST_HEADPHONES= %MIXERLINE_COMPONENTTYPE_DST_FIRST + 5
%MIXERLINE_COMPONENTTYPE_DST_TELEPHONE = %MIXERLINE_COMPONENTTYPE_DST_FIRST + 6
%MIXERLINE_COMPONENTTYPE_DST_WAVEIN    = %MIXERLINE_COMPONENTTYPE_DST_FIRST + 7
%MIXERLINE_COMPONENTTYPE_DST_VOICEIN   = %MIXERLINE_COMPONENTTYPE_DST_FIRST + 8
%MIXERLINE_COMPONENTTYPE_DST_LAST      = %MIXERLINE_COMPONENTTYPE_DST_FIRST + 8

%MIXERLINE_COMPONENTTYPE_SRC_FIRST      = &H1000&
%MIXERLINE_COMPONENTTYPE_SRC_UNDEFINED  = %MIXERLINE_COMPONENTTYPE_SRC_FIRST + 0
%MIXERLINE_COMPONENTTYPE_SRC_DIGITAL    = %MIXERLINE_COMPONENTTYPE_SRC_FIRST + 1
%MIXERLINE_COMPONENTTYPE_SRC_LINE       = %MIXERLINE_COMPONENTTYPE_SRC_FIRST + 2
%MIXERLINE_COMPONENTTYPE_SRC_MICROPHONE = %MIXERLINE_COMPONENTTYPE_SRC_FIRST + 3
%MIXERLINE_COMPONENTTYPE_SRC_SYNTHESIZER= %MIXERLINE_COMPONENTTYPE_SRC_FIRST + 4
%MIXERLINE_COMPONENTTYPE_SRC_COMPACTDISC= %MIXERLINE_COMPONENTTYPE_SRC_FIRST + 5
%MIXERLINE_COMPONENTTYPE_SRC_TELEPHONE  = %MIXERLINE_COMPONENTTYPE_SRC_FIRST + 6
%MIXERLINE_COMPONENTTYPE_SRC_PCSPEAKER  = %MIXERLINE_COMPONENTTYPE_SRC_FIRST + 7
%MIXERLINE_COMPONENTTYPE_SRC_WAVEOUT    = %MIXERLINE_COMPONENTTYPE_SRC_FIRST + 8
%MIXERLINE_COMPONENTTYPE_SRC_AUXILIARY  = %MIXERLINE_COMPONENTTYPE_SRC_FIRST + 9
%MIXERLINE_COMPONENTTYPE_SRC_ANALOG     = %MIXERLINE_COMPONENTTYPE_SRC_FIRST + 10
%MIXERLINE_COMPONENTTYPE_SRC_LAST       = %MIXERLINE_COMPONENTTYPE_SRC_FIRST + 10


'
'   MIXERLINE.Target.dwType
'
'
%MIXERLINE_TARGETTYPE_UNDEFINED = 0
%MIXERLINE_TARGETTYPE_WAVEOUT   = 1
%MIXERLINE_TARGETTYPE_WAVEIN    = 2
%MIXERLINE_TARGETTYPE_MIDIOUT   = 3
%MIXERLINE_TARGETTYPE_MIDIIN    = 4
%MIXERLINE_TARGETTYPE_AUX       = 5

%MIXER_GETLINEINFOF_DESTINATION   = &H0&
%MIXER_GETLINEINFOF_SOURCE        = &H1&
%MIXER_GETLINEINFOF_LINEID        = &H2&
%MIXER_GETLINEINFOF_COMPONENTTYPE = &H3&
%MIXER_GETLINEINFOF_TARGETTYPE    = &H4&
%MIXER_GETLINEINFOF_QUERYMASK     = &HF&

%MIXERCONTROL_CONTROLF_UNIFORM  = &H1&
%MIXERCONTROL_CONTROLF_MULTIPLE = &H2&
%MIXERCONTROL_CONTROLF_DISABLED = &H80000000

'   MIXERCONTROL_CONTROLTYPE_xxx building block defines

%MIXERCONTROL_CT_CLASS_MASK        = &HF0000000
%MIXERCONTROL_CT_CLASS_CUSTOM      = &H0&
%MIXERCONTROL_CT_CLASS_METER       = &H10000000
%MIXERCONTROL_CT_CLASS_SWITCH      = &H20000000
%MIXERCONTROL_CT_CLASS_NUMBER      = &H30000000
%MIXERCONTROL_CT_CLASS_SLIDER      = &H40000000
%MIXERCONTROL_CT_CLASS_FADER       = &H50000000
%MIXERCONTROL_CT_CLASS_TIME        = &H60000000
%MIXERCONTROL_CT_CLASS_LIST        = &H70000000
%MIXERCONTROL_CT_SUBCLASS_MASK     = &HF000000
%MIXERCONTROL_CT_SC_SWITCH_BOOLEAN = &H0&
%MIXERCONTROL_CT_SC_SWITCH_BUTTON  = &H1000000
%MIXERCONTROL_CT_SC_METER_POLLED   = &H0&
%MIXERCONTROL_CT_SC_TIME_MICROSECS = &H0&
%MIXERCONTROL_CT_SC_TIME_MILLISECS = &H1000000
%MIXERCONTROL_CT_SC_LIST_SINGLE    = &H0&
%MIXERCONTROL_CT_SC_LIST_MULTIPLE  = &H1000000
%MIXERCONTROL_CT_UNITS_MASK        = &HFF0000
%MIXERCONTROL_CT_UNITS_CUSTOM      = &H0&
%MIXERCONTROL_CT_UNITS_BOOLEAN     = &H10000
%MIXERCONTROL_CT_UNITS_SIGNED      = &H20000
%MIXERCONTROL_CT_UNITS_UNSIGNED    = &H30000
%MIXERCONTROL_CT_UNITS_DECIBELS    = &H40000 '  in 10ths
%MIXERCONTROL_CT_UNITS_PERCENT     = &H50000 '  in 10ths
'
'   Commonly used control types for specifying MIXERCONTROL.dwControlType
'
%MIXERCONTROL_CONTROLTYPE_CUSTOM        = %MIXERCONTROL_CT_CLASS_CUSTOM OR %MIXERCONTROL_CT_UNITS_CUSTOM
%MIXERCONTROL_CONTROLTYPE_BOOLEANMETER  = %MIXERCONTROL_CT_CLASS_METER OR %MIXERCONTROL_CT_SC_METER_POLLED OR %MIXERCONTROL_CT_UNITS_BOOLEAN
%MIXERCONTROL_CONTROLTYPE_SIGNEDMETER   = %MIXERCONTROL_CT_CLASS_METER OR %MIXERCONTROL_CT_SC_METER_POLLED OR %MIXERCONTROL_CT_UNITS_SIGNED
%MIXERCONTROL_CONTROLTYPE_PEAKMETER     = %MIXERCONTROL_CONTROLTYPE_SIGNEDMETER + 1
%MIXERCONTROL_CONTROLTYPE_UNSIGNEDMETER = %MIXERCONTROL_CT_CLASS_METER OR %MIXERCONTROL_CT_SC_METER_POLLED OR %MIXERCONTROL_CT_UNITS_UNSIGNED
%MIXERCONTROL_CONTROLTYPE_BOOLEAN       = %MIXERCONTROL_CT_CLASS_SWITCH OR %MIXERCONTROL_CT_SC_SWITCH_BOOLEAN OR %MIXERCONTROL_CT_UNITS_BOOLEAN
%MIXERCONTROL_CONTROLTYPE_ONOFF         = %MIXERCONTROL_CONTROLTYPE_BOOLEAN + 1
%MIXERCONTROL_CONTROLTYPE_MUTE          = %MIXERCONTROL_CONTROLTYPE_BOOLEAN + 2
%MIXERCONTROL_CONTROLTYPE_MONO          = %MIXERCONTROL_CONTROLTYPE_BOOLEAN + 3
%MIXERCONTROL_CONTROLTYPE_LOUDNESS      = %MIXERCONTROL_CONTROLTYPE_BOOLEAN + 4
%MIXERCONTROL_CONTROLTYPE_STEREOENH     = %MIXERCONTROL_CONTROLTYPE_BOOLEAN + 5
%MIXERCONTROL_CONTROLTYPE_BUTTON        = %MIXERCONTROL_CT_CLASS_SWITCH OR %MIXERCONTROL_CT_SC_SWITCH_BUTTON OR %MIXERCONTROL_CT_UNITS_BOOLEAN
%MIXERCONTROL_CONTROLTYPE_DECIBELS      = %MIXERCONTROL_CT_CLASS_NUMBER OR %MIXERCONTROL_CT_UNITS_DECIBELS
%MIXERCONTROL_CONTROLTYPE_SIGNED        = %MIXERCONTROL_CT_CLASS_NUMBER OR %MIXERCONTROL_CT_UNITS_SIGNED
%MIXERCONTROL_CONTROLTYPE_UNSIGNED      = %MIXERCONTROL_CT_CLASS_NUMBER OR %MIXERCONTROL_CT_UNITS_UNSIGNED
%MIXERCONTROL_CONTROLTYPE_PERCENT       = %MIXERCONTROL_CT_CLASS_NUMBER OR %MIXERCONTROL_CT_UNITS_PERCENT
%MIXERCONTROL_CONTROLTYPE_SLIDER        = %MIXERCONTROL_CT_CLASS_SLIDER OR %MIXERCONTROL_CT_UNITS_SIGNED
%MIXERCONTROL_CONTROLTYPE_PAN           = %MIXERCONTROL_CONTROLTYPE_SLIDER + 1
%MIXERCONTROL_CONTROLTYPE_QSOUNDPAN     = %MIXERCONTROL_CONTROLTYPE_SLIDER + 2
%MIXERCONTROL_CONTROLTYPE_FADER         = %MIXERCONTROL_CT_CLASS_FADER OR %MIXERCONTROL_CT_UNITS_UNSIGNED
%MIXERCONTROL_CONTROLTYPE_VOLUME        = %MIXERCONTROL_CONTROLTYPE_FADER + 1
%MIXERCONTROL_CONTROLTYPE_BASS          = %MIXERCONTROL_CONTROLTYPE_FADER + 2
%MIXERCONTROL_CONTROLTYPE_TREBLE        = %MIXERCONTROL_CONTROLTYPE_FADER + 3
%MIXERCONTROL_CONTROLTYPE_EQUALIZER     = %MIXERCONTROL_CONTROLTYPE_FADER + 4
%MIXERCONTROL_CONTROLTYPE_SINGLESELECT  = %MIXERCONTROL_CT_CLASS_LIST OR %MIXERCONTROL_CT_SC_LIST_SINGLE OR %MIXERCONTROL_CT_UNITS_BOOLEAN
%MIXERCONTROL_CONTROLTYPE_MUX           = %MIXERCONTROL_CONTROLTYPE_SINGLESELECT + 1
%MIXERCONTROL_CONTROLTYPE_MULTIPLESELECT= %MIXERCONTROL_CT_CLASS_LIST OR %MIXERCONTROL_CT_SC_LIST_MULTIPLE OR %MIXERCONTROL_CT_UNITS_BOOLEAN
%MIXERCONTROL_CONTROLTYPE_MIXER         = %MIXERCONTROL_CONTROLTYPE_MULTIPLESELECT + 1
%MIXERCONTROL_CONTROLTYPE_MICROTIME     = %MIXERCONTROL_CT_CLASS_TIME OR %MIXERCONTROL_CT_SC_TIME_MICROSECS OR %MIXERCONTROL_CT_UNITS_UNSIGNED
%MIXERCONTROL_CONTROLTYPE_MILLITIME     = %MIXERCONTROL_CT_CLASS_TIME OR %MIXERCONTROL_CT_SC_TIME_MILLISECS OR %MIXERCONTROL_CT_UNITS_UNSIGNED
'
%MIXER_GETLINECONTROLSF_ALL       = &H0&
%MIXER_GETLINECONTROLSF_ONEBYID   = &H1&
%MIXER_GETLINECONTROLSF_ONEBYTYPE = &H2&
%MIXER_GETLINECONTROLSF_QUERYMASK = &HF&

%MIXER_GETCONTROLDETAILSF_VALUE     = &H0&
%MIXER_GETCONTROLDETAILSF_LISTTEXT  = &H1&
%MIXER_GETCONTROLDETAILSF_QUERYMASK = &HF&

%MIXER_SETCONTROLDETAILSF_VALUE     = &H0&
%MIXER_SETCONTROLDETAILSF_CUSTOM    = &H1&
%MIXER_SETCONTROLDETAILSF_QUERYMASK = &HF&

'  constants used with JOYINFOEX
%JOY_BUTTON5   = &H10&
%JOY_BUTTON6   = &H20&
%JOY_BUTTON7   = &H40&
%JOY_BUTTON8   = &H80&
%JOY_BUTTON9   = &H100&
%JOY_BUTTON10  = &H200&
%JOY_BUTTON11  = &H400&
%JOY_BUTTON12  = &H800&
%JOY_BUTTON13  = &H1000&
%JOY_BUTTON14  = &H2000&
%JOY_BUTTON15  = &H4000&
%JOY_BUTTON16  = &H8000&
%JOY_BUTTON17  = &H10000
%JOY_BUTTON18  = &H20000
%JOY_BUTTON19  = &H40000
%JOY_BUTTON20  = &H80000
%JOY_BUTTON21  = &H100000
%JOY_BUTTON22  = &H200000
%JOY_BUTTON23  = &H400000
%JOY_BUTTON24  = &H800000
%JOY_BUTTON25  = &H1000000
%JOY_BUTTON26  = &H2000000
%JOY_BUTTON27  = &H4000000
%JOY_BUTTON28  = &H8000000
%JOY_BUTTON29  = &H10000000
%JOY_BUTTON30  = &H20000000
%JOY_BUTTON31  = &H40000000
%JOY_BUTTON32  = &H80000000

'  constants used with JOYINFOEX structure
%JOY_POVCENTERED    = -1
%JOY_POVFORWARD     = 0
%JOY_POVRIGHT       = 9000
%JOY_POVBACKWARD    = 18000
%JOY_POVLEFT        = 27000
%JOY_RETURNX        = &H1&
%JOY_RETURNY        = &H2&
%JOY_RETURNZ        = &H4&
%JOY_RETURNR        = &H8&
%JOY_RETURNU        = &H10            '  axis 5
%JOY_RETURNV        = &H20            '  axis 6
%JOY_RETURNPOV      = &H40&
%JOY_RETURNBUTTONS  = &H80&
%JOY_RETURNRAWDATA  = &H100&
%JOY_RETURNPOVCTS   = &H200&
%JOY_RETURNCENTERED = &H400&
%JOY_USEDEADZONE    = &H800&
%JOY_RETURNALL      = %JOY_RETURNX OR %JOY_RETURNY OR %JOY_RETURNZ OR %JOY_RETURNR OR %JOY_RETURNU OR %JOY_RETURNV OR %JOY_RETURNPOV OR %JOY_RETURNBUTTONS
%JOY_CAL_READALWAYS = &H10000
%JOY_CAL_READXYONLY = &H20000
%JOY_CAL_READ3      = &H40000
%JOY_CAL_READ4      = &H80000
%JOY_CAL_READXONLY  = &H100000
%JOY_CAL_READYONLY  = &H200000
%JOY_CAL_READ5      = &H400000
%JOY_CAL_READ6      = &H800000
%JOY_CAL_READZONLY  = &H1000000
%JOY_CAL_READRONLY  = &H2000000
%JOY_CAL_READUONLY  = &H4000000
%JOY_CAL_READVONLY  = &H8000000

%WAVE_FORMAT_QUERY        = &H1
%SND_PURGE                = &H40  '  purge non-static events for task
%SND_APPLICATION          = &H80  '  look for application specific association
%WAVE_MAPPED              = &H4
%WAVE_FORMAT_DIRECT       = &H8
%WAVE_FORMAT_DIRECT_QUERY = %WAVE_FORMAT_QUERY OR %WAVE_FORMAT_DIRECT
%MIM_MOREDATA             = %MM_MIM_MOREDATA
%MOM_POSITIONCB           = %MM_MOM_POSITIONCB

'  flags for dwFlags parm of midiInOpen()
%MIDI_IO_STATUS = &H00000020

' Driver messages
%DRV_LOAD            = &H1
%DRV_ENABLE          = &H2
%DRV_OPEN            = &H3
%DRV_CLOSE           = &H4
%DRV_DISABLE         = &H5
%DRV_FREE            = &H6
%DRV_CONFIGURE       = &H7
%DRV_QUERYCONFIGURE  = &H8
%DRV_INSTALL         = &H9
%DRV_REMOVE          = &HA
%DRV_EXITSESSION     = &HB
%DRV_POWER           = &HF
%DRV_RESERVED        = &H800
%DRV_USER            = &H4000

' Supported return values for DRV_CONFIGURE message
%DRVCNF_CANCEL  = &H0
%DRVCNF_OK      = &H1
%DRVCNF_RESTART = &H2

'  return values from DriverProc() function
%DRV_CANCEL    = %DRVCNF_CANCEL
%DRV_OK        = %DRVCNF_OK
%DRV_RESTART   = %DRVCNF_RESTART

%DRV_MCI_FIRST = %DRV_RESERVED
%DRV_MCI_LAST  = %DRV_RESERVED + &HFFF

' Driver callback support

'  flags used with waveOutOpen(), waveInOpen(), midiInOpen(), and
'  midiOutOpen() to specify the type of the dwCallback parameter.
%CALLBACK_TYPEMASK = &H70000        ' callback type mask
%CALLBACK_NULL     = &H0            ' no callback
%CALLBACK_WINDOW   = &H10000        ' dwCallback is a HWND
%CALLBACK_TASK     = &H20000        ' dwCallback is a HTASK
%CALLBACK_FUNCTION = &H30000        ' dwCallback is a FARPROC
%CALLBACK_THREAD   = %CALLBACK_TASK ' thread ID replaces 16 bit task
%CALLBACK_EVENT    = &H00050000     ' dwCallback is an EVENT Handle

'  flag values for uFlags parameter
%SND_SYNC           = &H0         '  play synchronously (default)
%SND_ASYNC          = &H1         '  play asynchronously

%SND_NODEFAULT      = &H2         '  silence not default, if sound not found

%SND_MEMORY         = &H4         '  lpszSoundName points to a memory file
%SND_ALIAS          = &H10000     '  name is a WIN.INI [sounds] entry
%SND_FILENAME       = &H20000     '  name is a file name
%SND_RESOURCE       = &H40004     '  name is a resource name or atom
%SND_ALIAS_ID       = &H110000    '  name is a WIN.INI [sounds] entry identifier

%SND_ALIAS_START    = 0  '  must be > 4096 to keep strings in same section of resource file

%SND_LOOP           = &H8         '  loop the sound until next sndPlaySound
%SND_NOSTOP         = &H10        '  don't stop any currently playing sound
%SND_VALID          = &H1F        '  valid flags          / ;Internal /

%SND_NOWAIT         = &H2000      '  don't wait if the driver is busy

%SND_VALIDFLAGS     = &H17201F    '  Set of valid flag bits.  Anything outside
'  this range will raise an error
%SND_RESERVED       = &HFF000000  '  In particular these flags are reserved

%SND_TYPE_MASK      = &H170007

'  waveform audio error return values
%WAVERR_BADFORMAT    = %WAVERR_BASE + 0    '  unsupported wave format
%WAVERR_STILLPLAYING = %WAVERR_BASE + 1    '  still something playing
%WAVERR_UNPREPARED   = %WAVERR_BASE + 2    '  header not prepared
%WAVERR_SYNC         = %WAVERR_BASE + 3    '  device is synchronous
%WAVERR_LASTERROR    = %WAVERR_BASE + 3    '  last error in range

'  wave callback messages
%WOM_OPEN   = %MM_WOM_OPEN
%WOM_CLOSE  = %MM_WOM_CLOSE
%WOM_DONE   = %MM_WOM_DONE
%WIM_OPEN   = %MM_WIM_OPEN
%WIM_CLOSE  = %MM_WIM_CLOSE
%WIM_DATA   = %MM_WIM_DATA

'  device ID for wave device mapper
%WAVE_MAPPER = -1&

'  flags for dwFlags parameter in waveOutOpen() and waveInOpen()

%WAVE_ALLOWSYNC = &H00000002
%WAVE_VALID     = &H00000003    '  ;Internal

'  flags for dwFlags field of WAVEHDR
%WHDR_DONE      = &H00000001   '  done bit
%WHDR_PREPARED  = &H00000002   '  set if this header has been prepared
%WHDR_BEGINLOOP = &H00000004   '  loop start block
%WHDR_ENDLOOP   = &H00000008   '  loop end block
%WHDR_INQUEUE   = &H00000010   '  reserved for driver
%WHDR_VALID     = &H0000001F   '  valid flags      / ;Internal /

'  flags for dwSupport field of WAVEOUTCAPS
%WAVECAPS_PITCH        = &H00000001   '  supports pitch control
%WAVECAPS_PLAYBACKRATE = &H00000002   '  supports playback rate control
%WAVECAPS_VOLUME       = &H00000004   '  supports volume control
%WAVECAPS_LRVOLUME     = &H00000008   '  separate left-right volume control
%WAVECAPS_SYNC         = &H00000010   '

'  defines for dwFormat field of WAVEINCAPS and WAVEOUTCAPS
%WAVE_INVALIDFORMAT = &H00000000   '  invalid format
%WAVE_FORMAT_1M08   = &H00000001   '  11.025 kHz, Mono,   8-bit
%WAVE_FORMAT_1S08   = &H00000002   '  11.025 kHz, Stereo, 8-bit
%WAVE_FORMAT_1M16   = &H00000004   '  11.025 kHz, Mono,   16-bit
%WAVE_FORMAT_1S16   = &H00000008   '  11.025 kHz, Stereo, 16-bit
%WAVE_FORMAT_2M08   = &H00000010   '  22.05  kHz, Mono,   8-bit
%WAVE_FORMAT_2S08   = &H00000020   '  22.05  kHz, Stereo, 8-bit
%WAVE_FORMAT_2M16   = &H00000040   '  22.05  kHz, Mono,   16-bit
%WAVE_FORMAT_2S16   = &H00000080   '  22.05  kHz, Stereo, 16-bit
%WAVE_FORMAT_4M08   = &H00000100   '  44.1   kHz, Mono,   8-bit
%WAVE_FORMAT_4S08   = &H00000200   '  44.1   kHz, Stereo, 8-bit
%WAVE_FORMAT_4M16   = &H00000400   '  44.1   kHz, Mono,   16-bit
%WAVE_FORMAT_4S16   = &H00000800   '  44.1   kHz, Stereo, 16-bit

'  flags for wFormatTag field of WAVEFORMAT
%WAVE_FORMAT_PCM = 1  '  Needed in resource files so outside #ifndef RC_INVOKED

'  MIDI error return values
%MIDIERR_UNPREPARED   = %MIDIERR_BASE + 0   '  header not prepared
%MIDIERR_STILLPLAYING = %MIDIERR_BASE + 1   '  still something playing
%MIDIERR_NOMAP        = %MIDIERR_BASE + 2   '  no current map
%MIDIERR_NOTREADY     = %MIDIERR_BASE + 3   '  hardware is still busy
%MIDIERR_NODEVICE     = %MIDIERR_BASE + 4   '  port no longer connected
%MIDIERR_INVALIDSETUP = %MIDIERR_BASE + 5   '  invalid setup
%MIDIERR_LASTERROR    = %MIDIERR_BASE + 5   '  last error in range

'  MIDI callback messages
%MIM_OPEN      = %MM_MIM_OPEN
%MIM_CLOSE     = %MM_MIM_CLOSE
%MIM_DATA      = %MM_MIM_DATA
%MIM_LONGDATA  = %MM_MIM_LONGDATA
%MIM_ERROR     = %MM_MIM_ERROR
%MIM_LONGERROR = %MM_MIM_LONGERROR
%MOM_OPEN      = %MM_MOM_OPEN
%MOM_CLOSE     = %MM_MOM_CLOSE
%MOM_DONE      = %MM_MOM_DONE

'  device ID for MIDI mapper
%MIDIMAPPER  = -1  '  Cannot be cast to DWORD as RC complains
%MIDI_MAPPER = -1&

'  flags for wFlags parm of midiOutCachePatches(), midiOutCacheDrumPatches()
%MIDI_CACHE_ALL     = 1
%MIDI_CACHE_BESTFIT = 2
%MIDI_CACHE_QUERY   = 3
%MIDI_UNCACHE       = 4
%MIDI_CACHE_VALID   = %MIDI_CACHE_ALL OR %MIDI_CACHE_BESTFIT OR %MIDI_CACHE_QUERY OR %MIDI_UNCACHE  '  ;Internal

'  flags for wTechnology field of MIDIOUTCAPS structure
%MOD_MIDIPORT = 1  '  output port
%MOD_SYNTH    = 2  '  generic internal synth
%MOD_SQSYNTH  = 3  '  square wave internal synth
%MOD_FMSYNTH  = 4  '  FM internal synth
%MOD_MAPPER   = 5  '  MIDI mapper

'  flags for dwSupport field of MIDIOUTCAPS
%MIDICAPS_VOLUME   = &H1         '  supports volume control
%MIDICAPS_LRVOLUME = &H2         '  separate left-right volume control
%MIDICAPS_CACHE    = &H4

'  flags for dwFlags field of MIDIHDR structure
%MHDR_DONE     = &H00000001   '  done bit
%MHDR_PREPARED = &H00000002   '  set if header prepared
%MHDR_INQUEUE  = &H00000004   '  reserved for driver
%MHDR_VALID    = &H00000007   '  valid flags / ;Internal /

'  device ID for aux device mapper
%AUX_MAPPER = -1&

'  flags for wTechnology field in AUXCAPS structure
%AUXCAPS_CDAUDIO = 1  '  audio from internal CD-ROM drive
%AUXCAPS_AUXIN   = 2  '  audio from auxiliary input jacks

'  flags for dwSupport field in AUXCAPS structure
%AUXCAPS_VOLUME   = &H1         '  supports volume control
%AUXCAPS_LRVOLUME = &H2         '  separate left-right volume control

'  timer error return values
%TIMERR_NOERROR = 0  '  no error
%TIMERR_NOCANDO = %TIMERR_BASE + 1 '  request not completed
%TIMERR_STRUCT  = %TIMERR_BASE + 33 '  time struct size

'  flags for wFlags parameter of timeSetEvent() function
%TIME_ONESHOT  = 0  '  program timer for single event
%TIME_PERIODIC = 1  '  program for continuous periodic event

'  joystick error return values
%JOYERR_NOERROR   = 0  '  no error
%JOYERR_PARMS     = %JOYERR_BASE + 5 '  bad parameters
%JOYERR_NOCANDO   = %JOYERR_BASE + 6 '  request not completed
%JOYERR_UNPLUGGED = %JOYERR_BASE + 7 '  joystick is unplugged

'  constants used with JOYINFO structure and MM_JOY messages
%JOY_BUTTON1    = &H1
%JOY_BUTTON2    = &H2
%JOY_BUTTON3    = &H4
%JOY_BUTTON4    = &H8
%JOY_BUTTON1CHG = &H100
%JOY_BUTTON2CHG = &H200
%JOY_BUTTON3CHG = &H400
%JOY_BUTTON4CHG = &H800

'  joystick ID constants
%JOYSTICKID1 = 0
%JOYSTICKID2 = 1

'  MMIO error return values
%MMIOERR_BASE          = 256
%MMIOERR_FILENOTFOUND  = %MMIOERR_BASE + 1  '  file not found
%MMIOERR_OUTOFMEMORY   = %MMIOERR_BASE + 2  '  out of memory
%MMIOERR_CANNOTOPEN    = %MMIOERR_BASE + 3  '  cannot open
%MMIOERR_CANNOTCLOSE   = %MMIOERR_BASE + 4  '  cannot close
%MMIOERR_CANNOTREAD    = %MMIOERR_BASE + 5  '  cannot read
%MMIOERR_CANNOTWRITE   = %MMIOERR_BASE + 6  '  cannot write
%MMIOERR_CANNOTSEEK    = %MMIOERR_BASE + 7  '  cannot seek
%MMIOERR_CANNOTEXPAND  = %MMIOERR_BASE + 8  '  cannot expand file
%MMIOERR_CHUNKNOTFOUND = %MMIOERR_BASE + 9  '  chunk not found
%MMIOERR_UNBUFFERED    = %MMIOERR_BASE + 10 '  file is unbuffered

%MMIO_RWMODE           = &H3         '  mask to get bits used for opening
'  file for reading/writing/both
%MMIO_SHAREMODE        = &H70        '  file sharing mode number

'  constants for dwFlags field of MMIOINFO
%MMIO_CREATE           = &H00001000  '  create new file (or truncate file)
%MMIO_PARSE            = &H00000100  '  parse new file returning path
%MMIO_DELETE           = &H00000200  '  create new file (or truncate file)
%MMIO_EXIST            = &H00004000  '  checks for existence of file
%MMIO_ALLOCBUF         = &H00010000  '  mmioOpen() should allocate a buffer
%MMIO_GETTEMP          = &H00020000  '  mmioOpen() should retrieve temp name

%MMIO_DIRTY            = &H10000000  '  I/O buffer is dirty
'  MMIO_DIRTY is also used in the <dwFlags> field of MMCKINFO structure

%MMIO_OPEN_VALID       = &H3FFFF     '  valid flags for mmioOpen / ;Internal /

'  read/write mode numbers (bit field MMIO_RWMODE)
%MMIO_READ             = &H0         '  open file for reading only
%MMIO_WRITE            = &H1         '  open file for writing only
%MMIO_READWRITE        = &H2         '  open file for reading and writing

'  share mode numbers (bit field MMIO_SHAREMODE)
%MMIO_COMPAT           = &H0         '  compatibility mode
%MMIO_EXCLUSIVE        = &H10        '  exclusive-access mode
%MMIO_DENYWRITE        = &H20        '  deny writing to other processes
%MMIO_DENYREAD         = &H30        '  deny reading to other processes
%MMIO_DENYNONE         = &H40        '  deny nothing to other processes

'  flags for other functions
%MMIO_FHOPEN           = &H10    '  mmioClose(): keep file xHandle open
%MMIO_EMPTYBUF         = &H10    '  mmioFlush(): empty the I/O buffer
%MMIO_TOUPPER          = &H10    '  mmioStringToFOURCC(): cvt. to u-case
%MMIO_INSTALLPROC      = &H10000     '  mmioInstallIOProc(): install MMIOProc
%MMIO_PUBLICPROC       = &H10000000  '  mmioInstallIOProc: install Globally
%MMIO_UNICODEPROC      = &H1000000   '  mmioInstallIOProc(): Unicode MMIOProc
%MMIO_REMOVEPROC       = &H20000     '  mmioInstallIOProc(): remove MMIOProc
%MMIO_FINDPROC         = &H40000     '  mmioInstallIOProc(): find an MMIOProc
%MMIO_FINDCHUNK        = &H10    '  mmioDescend(): find a chunk by ID
%MMIO_FINDRIFF         = &H20    '  mmioDescend(): find a LIST chunk
%MMIO_FINDLIST         = &H40    '  mmioDescend(): find a RIFF chunk
%MMIO_CREATERIFF       = &H20    '  mmioCreateChunk(): make a LIST chunk
%MMIO_CREATELIST       = &H40    '  mmioCreateChunk(): make a RIFF chunk

%MMIO_VALIDPROC        = &H11070000  '  valid for mmioInstallIOProc / ;Internal /

'  message numbers for MMIOPROC I/O procedure functions
%MMIOM_READ        = %MMIO_READ  '  read (must equal MMIO_READ!)
%MMIOM_WRITE       = %MMIO_WRITE  '  write (must equal MMIO_WRITE!)
%MMIOM_SEEK        = 2  '  seek to a new position in file
%MMIOM_OPEN        = 3  '  open file
%MMIOM_CLOSE       = 4  '  close file
%MMIOM_WRITEFLUSH  = 5  '  write and flush
%MMIOM_RENAME      = 6  '  rename specified file
%MMIOM_USER        = &H8000  '  beginning of user-defined messages

'  flags for mmioSeek()
%SEEK_SET = 0  '  seek to an absolute position
%SEEK_CUR = 1  '  seek relative to current position
%SEEK_END = 2  '  seek relative to end of file

'  other constants
%MMIO_DEFAULTBUFFER = 8192  '  default buffer size

'   MCI error return values
%MCIERR_INVALID_DEVICE_ID       = %MCIERR_BASE + 1
%MCIERR_UNRECOGNIZED_KEYWORD    = %MCIERR_BASE + 3
%MCIERR_UNRECOGNIZED_COMMAND    = %MCIERR_BASE + 5
%MCIERR_HARDWARE                = %MCIERR_BASE + 6
%MCIERR_INVALID_DEVICE_NAME     = %MCIERR_BASE + 7
%MCIERR_OUT_OF_MEMORY           = %MCIERR_BASE + 8
%MCIERR_DEVICE_OPEN             = %MCIERR_BASE + 9
%MCIERR_CANNOT_LOAD_DRIVER      = %MCIERR_BASE + 10
%MCIERR_MISSING_COMMAND_STRING  = %MCIERR_BASE + 11
%MCIERR_PARAM_OVERFLOW          = %MCIERR_BASE + 12
%MCIERR_MISSING_STRING_ARGUMENT = %MCIERR_BASE + 13
%MCIERR_BAD_INTEGER             = %MCIERR_BASE + 14
%MCIERR_PARSER_INTERNAL         = %MCIERR_BASE + 15
%MCIERR_DRIVER_INTERNAL         = %MCIERR_BASE + 16
%MCIERR_MISSING_PARAMETER       = %MCIERR_BASE + 17
%MCIERR_UNSUPPORTED_FUNCTION    = %MCIERR_BASE + 18
%MCIERR_FILE_NOT_FOUND          = %MCIERR_BASE + 19
%MCIERR_DEVICE_NOT_READY        = %MCIERR_BASE + 20
%MCIERR_INTERNAL                = %MCIERR_BASE + 21
%MCIERR_DRIVER                  = %MCIERR_BASE + 22
%MCIERR_CANNOT_USE_ALL          = %MCIERR_BASE + 23
%MCIERR_MULTIPLE                = %MCIERR_BASE + 24
%MCIERR_EXTENSION_NOT_FOUND     = %MCIERR_BASE + 25
%MCIERR_OUTOFRANGE              = %MCIERR_BASE + 26
%MCIERR_FLAGS_NOT_COMPATIBLE    = %MCIERR_BASE + 28
%MCIERR_FILE_NOT_SAVED          = %MCIERR_BASE + 30
%MCIERR_DEVICE_TYPE_REQUIRED    = %MCIERR_BASE + 31
%MCIERR_DEVICE_LOCKED           = %MCIERR_BASE + 32
%MCIERR_DUPLICATE_ALIAS         = %MCIERR_BASE + 33
%MCIERR_BAD_CONSTANT            = %MCIERR_BASE + 34
%MCIERR_MUST_USE_SHAREABLE      = %MCIERR_BASE + 35
%MCIERR_MISSING_DEVICE_NAME     = %MCIERR_BASE + 36
%MCIERR_BAD_TIME_FORMAT         = %MCIERR_BASE + 37
%MCIERR_NO_CLOSING_QUOTE        = %MCIERR_BASE + 38
%MCIERR_DUPLICATE_FLAGS         = %MCIERR_BASE + 39
%MCIERR_INVALID_FILE            = %MCIERR_BASE + 40
%MCIERR_NULL_PARAMETER_BLOCK    = %MCIERR_BASE + 41
%MCIERR_UNNAMED_RESOURCE        = %MCIERR_BASE + 42
%MCIERR_NEW_REQUIRES_ALIAS      = %MCIERR_BASE + 43
%MCIERR_NOTIFY_ON_AUTO_OPEN     = %MCIERR_BASE + 44
%MCIERR_NO_ELEMENT_ALLOWED      = %MCIERR_BASE + 45
%MCIERR_NONAPPLICABLE_FUNCTION  = %MCIERR_BASE + 46
%MCIERR_ILLEGAL_FOR_AUTO_OPEN   = %MCIERR_BASE + 47
%MCIERR_FILENAME_REQUIRED       = %MCIERR_BASE + 48
%MCIERR_EXTRA_CHARACTERS        = %MCIERR_BASE + 49
%MCIERR_DEVICE_NOT_INSTALLED    = %MCIERR_BASE + 50
%MCIERR_GET_CD                  = %MCIERR_BASE + 51
%MCIERR_SET_CD                  = %MCIERR_BASE + 52
%MCIERR_SET_DRIVE               = %MCIERR_BASE + 53
%MCIERR_DEVICE_LENGTH           = %MCIERR_BASE + 54
%MCIERR_DEVICE_ORD_LENGTH       = %MCIERR_BASE + 55
%MCIERR_NO_INTEGER              = %MCIERR_BASE + 56

%MCIERR_WAVE_OUTPUTSINUSE        = %MCIERR_BASE + 64
%MCIERR_WAVE_SETOUTPUTINUSE      = %MCIERR_BASE + 65
%MCIERR_WAVE_INPUTSINUSE         = %MCIERR_BASE + 66
%MCIERR_WAVE_SETINPUTINUSE       = %MCIERR_BASE + 67
%MCIERR_WAVE_OUTPUTUNSPECIFIED   = %MCIERR_BASE + 68
%MCIERR_WAVE_INPUTUNSPECIFIED    = %MCIERR_BASE + 69
%MCIERR_WAVE_OUTPUTSUNSUITABLE   = %MCIERR_BASE + 70
%MCIERR_WAVE_SETOUTPUTUNSUITABLE = %MCIERR_BASE + 71
%MCIERR_WAVE_INPUTSUNSUITABLE    = %MCIERR_BASE + 72
%MCIERR_WAVE_SETINPUTUNSUITABLE  = %MCIERR_BASE + 73

%MCIERR_SEQ_DIV_INCOMPATIBLE    = %MCIERR_BASE + 80
%MCIERR_SEQ_PORT_INUSE          = %MCIERR_BASE + 81
%MCIERR_SEQ_PORT_NONEXISTENT    = %MCIERR_BASE + 82
%MCIERR_SEQ_PORT_MAPNODEVICE    = %MCIERR_BASE + 83
%MCIERR_SEQ_PORT_MISCERROR      = %MCIERR_BASE + 84
%MCIERR_SEQ_TIMER               = %MCIERR_BASE + 85
%MCIERR_SEQ_PORTUNSPECIFIED     = %MCIERR_BASE + 86
%MCIERR_SEQ_NOMIDIPRESENT       = %MCIERR_BASE + 87

%MCIERR_NO_WINDOW               = %MCIERR_BASE + 90
%MCIERR_CREATEWINDOW            = %MCIERR_BASE + 91
%MCIERR_FILE_READ               = %MCIERR_BASE + 92
%MCIERR_FILE_WRITE                           = %MCIERR_BASE + 93

'  All custom device driver errors must be >= this value
%MCIERR_CUSTOM_DRIVER_BASE = %MCIERR_BASE + 256

'  Message numbers must be in the range between MCI_FIRST and MCI_LAST

%MCI_FIRST       = &H800
'  Messages &H801 and &H802 are reserved
%MCI_OPEN        = &H803
%MCI_CLOSE       = &H804
%MCI_ESCAPE      = &H805
%MCI_PLAY        = &H806
%MCI_SEEK        = &H807
%MCI_STOP        = &H808
%MCI_PAUSE       = &H809
%MCI_INFO        = &H80A
%MCI_GETDEVCAPS  = &H80B
%MCI_SPIN        = &H80C
%MCI_SET         = &H80D
%MCI_STEP        = &H80E
%MCI_RECORD      = &H80F
%MCI_SYSINFO     = &H810
%MCI_BREAK       = &H811
%MCI_SOUND       = &H812
%MCI_SAVE        = &H813
%MCI_STATUS      = &H814

%MCI_CUE         = &H830

%MCI_REALIZE     = &H840
%MCI_WINDOW      = &H841
%MCI_PUT         = &H842
%MCI_WHERE       = &H843
%MCI_FREEZE      = &H844
%MCI_UNFREEZE    = &H845

%MCI_LOAD        = &H850
%MCI_CUT         = &H851
%MCI_COPY        = &H852
%MCI_PASTE       = &H853
%MCI_UPDATE      = &H854
%MCI_RESUME      = &H855
%MCI_DELETE      = &H856

%MCI_LAST        = &HFFF

'  the next &H400 message ID's are reserved for custom drivers
'  all custom MCI command messages must be >= than this value
%MCI_USER_MESSAGES  = &H400 + %MCI_FIRST
%MCI_ALL_DEVICE_ID  = -1 '  Matches all MCI devices

'  constants for predefined MCI device types
%MCI_DEVTYPE_VCR            = 513
%MCI_DEVTYPE_VIDEODISC      = 514
%MCI_DEVTYPE_OVERLAY        = 515
%MCI_DEVTYPE_CD_AUDIO       = 516
%MCI_DEVTYPE_DAT            = 517
%MCI_DEVTYPE_SCANNER        = 518
%MCI_DEVTYPE_ANIMATION      = 519
%MCI_DEVTYPE_DIGITAL_VIDEO  = 520
%MCI_DEVTYPE_OTHER          = 521
%MCI_DEVTYPE_WAVEFORM_AUDIO = 522
%MCI_DEVTYPE_SEQUENCER      = 523

%MCI_DEVTYPE_FIRST          = %MCI_DEVTYPE_VCR
%MCI_DEVTYPE_LAST           = %MCI_DEVTYPE_SEQUENCER

%MCI_DEVTYPE_FIRST_USER     = &H1000

'  return values for 'status mode' command
%MCI_MODE_NOT_READY = %MCI_STRING_OFFSET + 12
%MCI_MODE_STOP      = %MCI_STRING_OFFSET + 13
%MCI_MODE_PLAY      = %MCI_STRING_OFFSET + 14
%MCI_MODE_RECORD    = %MCI_STRING_OFFSET + 15
%MCI_MODE_SEEK      = %MCI_STRING_OFFSET + 16
%MCI_MODE_PAUSE     = %MCI_STRING_OFFSET + 17
%MCI_MODE_OPEN      = %MCI_STRING_OFFSET + 18

'  constants used in 'set time format' and 'status time format' commands
%MCI_FORMAT_MILLISECONDS  = 0
%MCI_FORMAT_HMS           = 1
%MCI_FORMAT_MSF           = 2
%MCI_FORMAT_FRAMES        = 3
%MCI_FORMAT_SMPTE_24      = 4
%MCI_FORMAT_SMPTE_25      = 5
%MCI_FORMAT_SMPTE_30      = 6
%MCI_FORMAT_SMPTE_30DROP  = 7
%MCI_FORMAT_BYTES         = 8
%MCI_FORMAT_SAMPLES       = 9
%MCI_FORMAT_TMSF          = 10

'  Flags for wParam of the MM_MCINOTIFY message
%MCI_NOTIFY_SUCCESSFUL = &H1
%MCI_NOTIFY_SUPERSEDED = &H2
%MCI_NOTIFY_ABORTED    = &H4
%MCI_NOTIFY_FAILURE    = &H8

'  common flags for dwFlags parameter of MCI command messages
%MCI_NOTIFY = &H00000001
%MCI_WAIT   = &H00000002
%MCI_FROM   = &H00000004
%MCI_TO     = &H00000008
%MCI_TRACK  = &H00000010

'  flags for dwFlags parameter of MCI_OPEN command message
%MCI_OPEN_SHAREABLE  = &H00000100
%MCI_OPEN_ELEMENT    = &H00000200
%MCI_OPEN_ALIAS      = &H00000400
%MCI_OPEN_ELEMENT_ID = &H00000800
%MCI_OPEN_TYPE_ID    = &H00001000
%MCI_OPEN_TYPE       = &H00002000

'  flags for dwFlags parameter of MCI_SEEK command message
%MCI_SEEK_TO_START = &H00000100
%MCI_SEEK_TO_END   = &H00000200

'  flags for dwFlags parameter of MCI_STATUS command message
%MCI_STATUS_ITEM   = &H00000100
%MCI_STATUS_START  = &H00000200

'  flags for dwItem field of the MCI_STATUS_PARMS parameter block
%MCI_STATUS_LENGTH           = &H00000001
%MCI_STATUS_POSITION         = &H00000002
%MCI_STATUS_NUMBER_OF_TRACKS = &H00000003
%MCI_STATUS_MODE             = &H00000004
%MCI_STATUS_MEDIA_PRESENT    = &H00000005
%MCI_STATUS_TIME_FORMAT      = &H00000006
%MCI_STATUS_READY            = &H00000007
%MCI_STATUS_CURRENT_TRACK    = &H00000008

'  flags for dwFlags parameter of MCI_INFO command message
%MCI_INFO_PRODUCT  = &H00000100
%MCI_INFO_FILE     = &H00000200

'  flags for dwFlags parameter of MCI_GETDEVCAPS command message
%MCI_GETDEVCAPS_ITEM = &H00000100???

'  flags for dwItem field of the MCI_GETDEVCAPS_PARMS parameter block
%MCI_GETDEVCAPS_CAN_RECORD      = 1
%MCI_GETDEVCAPS_HAS_AUDIO       = 2
%MCI_GETDEVCAPS_HAS_VIDEO       = 3
%MCI_GETDEVCAPS_DEVICE_TYPE     = 4
%MCI_GETDEVCAPS_USES_FILES      = 5
%MCI_GETDEVCAPS_COMPOUND_DEVICE = 6
%MCI_GETDEVCAPS_CAN_EJECT       = 7
%MCI_GETDEVCAPS_CAN_PLAY        = 8
%MCI_GETDEVCAPS_CAN_SAVE        = 9

'  flags for dwFlags parameter of MCI_SYSINFO command message
%MCI_SYSINFO_QUANTITY    = &H00000100
%MCI_SYSINFO_OPEN        = &H00000200
%MCI_SYSINFO_NAME        = &H00000400
%MCI_SYSINFO_INSTALLNAME = &H00000800

'  flags for dwFlags parameter of MCI_SET command message
%MCI_SET_DOOR_OPEN   = &H00000100
%MCI_SET_DOOR_CLOSED = &H00000200
%MCI_SET_TIME_FORMAT = &H00000400
%MCI_SET_AUDIO       = &H00000800
%MCI_SET_VIDEO       = &H00001000
%MCI_SET_ON          = &H00002000
%MCI_SET_OFF         = &H00004000

'  flags for dwAudio field of MCI_SET_PARMS or MCI_SEQ_SET_PARMS
%MCI_SET_AUDIO_ALL   = &H00004001
%MCI_SET_AUDIO_LEFT  = &H00004002
%MCI_SET_AUDIO_RIGHT = &H00004003

'  flags for dwFlags parameter of MCI_BREAK command message
%MCI_BREAK_KEY  = &H00000100
%MCI_BREAK_HWND = &H00000200
%MCI_BREAK_OFF  = &H00000400

'  flags for dwFlags parameter of MCI_RECORD command message
%MCI_RECORD_INSERT    = &H00000100
%MCI_RECORD_OVERWRITE = &H00000200

'  flags for dwFlags parameter of MCI_SOUND command message
%MCI_SOUND_NAME = &H00000100

'  flags for dwFlags parameter of MCI_SAVE command message
%MCI_SAVE_FILE  = &H00000100

'  flags for dwFlags parameter of MCI_LOAD command message
%MCI_LOAD_FILE  = &H00000100

%MCI_VD_MODE_PARK = %MCI_VD_OFFSET + 1

'  return ID's for videodisc MCI_GETDEVCAPS command

'  flag for dwReturn field of MCI_STATUS_PARMS
'  MCI_STATUS command, (dwItem == MCI_VD_STATUS_MEDIA_TYPE)
%MCI_VD_MEDIA_CLV   = %MCI_VD_OFFSET + 2
%MCI_VD_MEDIA_CAV   = %MCI_VD_OFFSET + 3
%MCI_VD_MEDIA_OTHER = %MCI_VD_OFFSET + 4

%MCI_VD_FORMAT_TRACK = &H00004001

'  flags for dwFlags parameter of MCI_PLAY command message
%MCI_VD_PLAY_REVERSE = &H00010000
%MCI_VD_PLAY_FAST    = &H00020000
%MCI_VD_PLAY_SPEED   = &H00040000
%MCI_VD_PLAY_SCAN    = &H00080000
%MCI_VD_PLAY_SLOW    = &H00100000

'  flag for dwFlags parameter of MCI_SEEK command message
%MCI_VD_SEEK_REVERSE = &H00010000

'  flags for dwItem field of MCI_STATUS_PARMS parameter block
%MCI_VD_STATUS_SPEED      = &H00004002
%MCI_VD_STATUS_FORWARD    = &H00004003
%MCI_VD_STATUS_MEDIA_TYPE = &H00004004
%MCI_VD_STATUS_SIDE       = &H00004005
%MCI_VD_STATUS_DISC_SIZE  = &H00004006

'  flags for dwFlags parameter of MCI_GETDEVCAPS command message
%MCI_VD_GETDEVCAPS_CLV = &H00010000
%MCI_VD_GETDEVCAPS_CAV = &H00020000

%MCI_VD_SPIN_UP   = &H00010000
%MCI_VD_SPIN_DOWN = &H00020000

'  flags for dwItem field of MCI_GETDEVCAPS_PARMS parameter block
%MCI_VD_GETDEVCAPS_CAN_REVERSE = &H00004002
%MCI_VD_GETDEVCAPS_FAST_RATE   = &H00004003
%MCI_VD_GETDEVCAPS_SLOW_RATE   = &H00004004
%MCI_VD_GETDEVCAPS_NORMAL_RATE = &H00004005

'  flags for the dwFlags parameter of MCI_STEP command message
%MCI_VD_STEP_FRAMES  = &H00010000
%MCI_VD_STEP_REVERSE = &H00020000

'  flag for the MCI_ESCAPE command message
%MCI_VD_ESCAPE_STRING = &H100&

%MCI_WAVE_PCM    = %MCI_WAVE_OFFSET + 0
%MCI_WAVE_MAPPER = %MCI_WAVE_OFFSET + 1

'  flags for the dwFlags parameter of MCI_OPEN command message
%MCI_WAVE_OPEN_BUFFER = &H00010000

'  flags for the dwFlags parameter of MCI_SET command message
%MCI_WAVE_SET_FORMATTAG      = &H00010000
%MCI_WAVE_SET_CHANNELS       = &H00020000
%MCI_WAVE_SET_SAMPLESPERSEC  = &H00040000
%MCI_WAVE_SET_AVGBYTESPERSEC = &H00080000
%MCI_WAVE_SET_BLOCKALIGN     = &H00100000
%MCI_WAVE_SET_BITSPERSAMPLE  = &H00200000

'  flags for the dwFlags parameter of MCI_STATUS, MCI_SET command messages
%MCI_WAVE_INPUT  = &H00400000
%MCI_WAVE_OUTPUT = &H00800000

'  flags for the dwItem field of MCI_STATUS_PARMS parameter block
%MCI_WAVE_STATUS_FORMATTAG      = &H00004001
%MCI_WAVE_STATUS_CHANNELS       = &H00004002
%MCI_WAVE_STATUS_SAMPLESPERSEC  = &H00004003
%MCI_WAVE_STATUS_AVGBYTESPERSEC = &H00004004
%MCI_WAVE_STATUS_BLOCKALIGN     = &H00004005
%MCI_WAVE_STATUS_BITSPERSAMPLE  = &H00004006
%MCI_WAVE_STATUS_LEVEL          = &H00004007

'  flags for the dwFlags parameter of MCI_SET command message
%MCI_WAVE_SET_ANYINPUT   = &H04000000
%MCI_WAVE_SET_ANYOUTPUT  = &H08000000

'  flags for the dwFlags parameter of MCI_GETDEVCAPS command message
%MCI_WAVE_GETDEVCAPS_INPUTS  = &H00004001
%MCI_WAVE_GETDEVCAPS_OUTPUTS = &H00004002

'  flags for the dwReturn field of MCI_STATUS_PARMS parameter block
'  MCI_STATUS command, (dwItem == MCI_SEQ_STATUS_DIVTYPE)
%MCI_SEQ_DIV_PPQN         = %MCI_SEQ_OFFSET
%MCI_SEQ_DIV_SMPTE_24     = %MCI_SEQ_OFFSET + 1
%MCI_SEQ_DIV_SMPTE_25     = %MCI_SEQ_OFFSET + 2
%MCI_SEQ_DIV_SMPTE_30DROP = %MCI_SEQ_OFFSET + 3
%MCI_SEQ_DIV_SMPTE_30     = %MCI_SEQ_OFFSET + 4

'  flags for the dwMaster field of MCI_SEQ_SET_PARMS parameter block
'  MCI_SET command, (dwFlags == %MCI_SEQ_SET_MASTER)
%MCI_SEQ_FORMAT_SONGPTR = &H00004001
%MCI_SEQ_FILE           = &H00004002
%MCI_SEQ_MIDI           = &H00004003
%MCI_SEQ_SMPTE          = &H00004004
%MCI_SEQ_NONE           = 65533

%MCI_SEQ_MAPPER         = 65535

'  flags for the dwItem field of MCI_STATUS_PARMS parameter block
%MCI_SEQ_STATUS_TEMPO   = &H00004002
%MCI_SEQ_STATUS_PORT    = &H00004003
%MCI_SEQ_STATUS_SLAVE   = &H00004007
%MCI_SEQ_STATUS_MASTER  = &H00004008
%MCI_SEQ_STATUS_OFFSET  = &H00004009
%MCI_SEQ_STATUS_DIVTYPE = &H0000400A

'  flags for the dwFlags parameter of MCI_SET command message
%MCI_SEQ_SET_TEMPO      = &H00010000
%MCI_SEQ_SET_PORT       = &H00020000
%MCI_SEQ_SET_SLAVE      = &H00040000
%MCI_SEQ_SET_MASTER     = &H00080000
%MCI_SEQ_SET_OFFSET     = &H01000000

'  flags for dwFlags parameter of MCI_OPEN command message
%MCI_ANIM_OPEN_WS       = &H00010000
%MCI_ANIM_OPEN_PARENT   = &H00020000
%MCI_ANIM_OPEN_NOSTATIC = &H00040000

'  flags for dwFlags parameter of MCI_PLAY command message
%MCI_ANIM_PLAY_SPEED    = &H00010000
%MCI_ANIM_PLAY_REVERSE  = &H00020000
%MCI_ANIM_PLAY_FAST     = &H00040000
%MCI_ANIM_PLAY_SLOW     = &H00080000
%MCI_ANIM_PLAY_SCAN     = &H00100000

'  flags for dwFlags parameter of MCI_STEP command message
%MCI_ANIM_STEP_REVERSE  = &H00010000
%MCI_ANIM_STEP_FRAMES   = &H00020000

'  flags for dwItem field of MCI_STATUS_PARMS parameter block
%MCI_ANIM_STATUS_SPEED    = &H00004001
%MCI_ANIM_STATUS_FORWARD  = &H00004002
%MCI_ANIM_STATUS_HWND     = &H00004003
%MCI_ANIM_STATUS_HPAL     = &H00004004
%MCI_ANIM_STATUS_STRETCH  = &H00004005

'  flags for the dwFlags parameter of MCI_INFO command message
%MCI_ANIM_INFO_TEXT       = &H00010000

'  flags for dwItem field of MCI_GETDEVCAPS_PARMS parameter block
%MCI_ANIM_GETDEVCAPS_CAN_REVERSE  = &H00004001
%MCI_ANIM_GETDEVCAPS_FAST_RATE    = &H00004002
%MCI_ANIM_GETDEVCAPS_SLOW_RATE    = &H00004003
%MCI_ANIM_GETDEVCAPS_NORMAL_RATE  = &H00004004
%MCI_ANIM_GETDEVCAPS_PALETTES     = &H00004006
%MCI_ANIM_GETDEVCAPS_CAN_STRETCH  = &H00004007
%MCI_ANIM_GETDEVCAPS_MAX_WINDOWS  = &H00004008

'  flags for the MCI_REALIZE command message
%MCI_ANIM_REALIZE_NORM = &H00010000
%MCI_ANIM_REALIZE_BKGD = &H00020000

'  flags for dwFlags parameter of MCI_WINDOW command message
%MCI_ANIM_WINDOW_HWND            = &H00010000
%MCI_ANIM_WINDOW_STATE           = &H00040000
%MCI_ANIM_WINDOW_TEXT            = &H00080000
%MCI_ANIM_WINDOW_ENABLE_STRETCH  = &H00100000
%MCI_ANIM_WINDOW_DISABLE_STRETCH = &H00200000

'  flags for hWnd field of MCI_ANIM_WINDOW_PARMS parameter block
'  MCI_WINDOW command message, (dwFlags == MCI_ANIM_WINDOW_HWND)
%MCI_ANIM_WINDOW_DEFAULT = 0

'  flags for dwFlags parameter of MCI_PUT command message
%MCI_ANIM_RECT            = &H00010000
%MCI_ANIM_PUT_SOURCE      = &H00020000
%MCI_ANIM_PUT_DESTINATION = &H00040000

'  flags for dwFlags parameter of MCI_WHERE command message
%MCI_ANIM_WHERE_SOURCE      = &H00020000
%MCI_ANIM_WHERE_DESTINATION = &H00040000

'  flags for dwFlags parameter of MCI_UPDATE command message
%MCI_ANIM_UPDATE_HDC        = &H00020000

'  flags for dwFlags parameter of MCI_OPEN command message
%MCI_OVLY_OPEN_WS           = &H00010000
%MCI_OVLY_OPEN_PARENT       = &H00020000

'  flags for dwFlags parameter of MCI_STATUS command message
%MCI_OVLY_STATUS_HWND       = &H00004001
%MCI_OVLY_STATUS_STRETCH    = &H00004002

'  flags for dwFlags parameter of MCI_INFO command message
%MCI_OVLY_INFO_TEXT         = &H00010000

'  flags for dwItem field of MCI_GETDEVCAPS_PARMS parameter block
%MCI_OVLY_GETDEVCAPS_CAN_STRETCH  = &H00004001
%MCI_OVLY_GETDEVCAPS_CAN_FREEZE   = &H00004002
%MCI_OVLY_GETDEVCAPS_MAX_WINDOWS  = &H00004003

'  flags for dwFlags parameter of MCI_WINDOW command message
%MCI_OVLY_WINDOW_HWND             = &H00010000
%MCI_OVLY_WINDOW_STATE            = &H00040000
%MCI_OVLY_WINDOW_TEXT             = &H00080000
%MCI_OVLY_WINDOW_ENABLE_STRETCH   = &H00100000
%MCI_OVLY_WINDOW_DISABLE_STRETCH  = &H00200000

'  flags for hWnd parameter of MCI_OVLY_WINDOW_PARMS parameter block
%MCI_OVLY_WINDOW_DEFAULT    = 0

'  flags for dwFlags parameter of MCI_PUT command message
%MCI_OVLY_RECT              = &H00010000
%MCI_OVLY_PUT_SOURCE        = &H00020000
%MCI_OVLY_PUT_DESTINATION   = &H00040000
%MCI_OVLY_PUT_FRAME         = &H00080000
%MCI_OVLY_PUT_VIDEO         = &H00100000

'  flags for dwFlags parameter of MCI_WHERE command message
%MCI_OVLY_WHERE_SOURCE      = &H00020000
%MCI_OVLY_WHERE_DESTINATION = &H00040000
%MCI_OVLY_WHERE_FRAME       = &H00080000
%MCI_OVLY_WHERE_VIDEO       = &H00100000

%CAPS1          = 94              '  other caps
%C1_TRANSPARENT = &H1     '  new raster cap
%NEWTRANSPARENT = 3  '  use with SetBkMode()

%QUERYROPSUPPORT = 40  '  use to determine ROP support

%SELECTDIB = 41  '  DIB.DRV select dib escape

' ----------------
' shell association database management functions
' -----------------

%PRINTER_CONTROL_PAUSE   = 1
%PRINTER_CONTROL_RESUME  = 2
%PRINTER_CONTROL_PURGE   = 3

%PRINTER_STATUS_PAUSED            = &H1
%PRINTER_STATUS_ERROR             = &H2
%PRINTER_STATUS_PENDING_DELETION  = &H4
%PRINTER_STATUS_PAPER_JAM         = &H8
%PRINTER_STATUS_PAPER_OUT         = &H10
%PRINTER_STATUS_MANUAL_FEED       = &H20
%PRINTER_STATUS_PAPER_PROBLEM     = &H40
%PRINTER_STATUS_OFFLINE           = &H80
%PRINTER_STATUS_IO_ACTIVE         = &H100
%PRINTER_STATUS_BUSY              = &H200
%PRINTER_STATUS_PRINTING          = &H400
%PRINTER_STATUS_OUTPUT_BIN_FULL   = &H800
%PRINTER_STATUS_NOT_AVAILABLE     = &H1000
%PRINTER_STATUS_WAITING           = &H2000
%PRINTER_STATUS_PROCESSING        = &H4000
%PRINTER_STATUS_INITIALIZING      = &H8000
%PRINTER_STATUS_WARMING_UP        = &H10000
%PRINTER_STATUS_TONER_LOW         = &H20000
%PRINTER_STATUS_NO_TONER          = &H40000
%PRINTER_STATUS_PAGE_PUNT         = &H80000
%PRINTER_STATUS_USER_INTERVENTION = &H100000
%PRINTER_STATUS_OUT_OF_MEMORY     = &H200000
%PRINTER_STATUS_DOOR_OPEN         = &H400000

%PRINTER_ATTRIBUTE_QUEUED  = &H1
%PRINTER_ATTRIBUTE_DIRECT  = &H2
%PRINTER_ATTRIBUTE_DEFAULT = &H4
%PRINTER_ATTRIBUTE_SHARED  = &H8
%PRINTER_ATTRIBUTE_NETWORK = &H10
%PRINTER_ATTRIBUTE_HIDDEN  = &H20
%PRINTER_ATTRIBUTE_LOCAL   = &H40

%NO_PRIORITY  = 0
%MAX_PRIORITY = 99
%MIN_PRIORITY = 1
%DEF_PRIORITY = 1

%JOB_CONTROL_PAUSE   = 1
%JOB_CONTROL_RESUME  = 2
%JOB_CONTROL_CANCEL  = 3
%JOB_CONTROL_RESTART = 4

%JOB_STATUS_PAUSED   = &H1
%JOB_STATUS_ERROR    = &H2
%JOB_STATUS_DELETING = &H4
%JOB_STATUS_SPOOLING = &H8
%JOB_STATUS_PRINTING = &H10
%JOB_STATUS_OFFLINE  = &H20
%JOB_STATUS_PAPEROUT = &H40
%JOB_STATUS_PRINTED  = &H80

%JOB_POSITION_UNSPECIFIED = 0

%FORM_BUILTIN = &H1

%PRINTER_CONTROL_SET_STATUS     = 4
%PRINTER_ATTRIBUTE_WORK_OFFLINE = &H400
%PRINTER_ATTRIBUTE_ENABLE_BIDI  = &H800
%JOB_CONTROL_DELETE             = 5
%JOB_STATUS_USER_INTERVENTION   = &H10000

%DI_CHANNEL        = 1                  '  start direct read/write channel,
%DI_READ_SPOOL_JOB = 3

%DI_MASK           = &H0001
%DI_IMAGE          = &H0002
%DI_NORMAL         = &H0003
%DI_COMPAT         = &H0004
%DI_DEFAULTSIZE    = &H0008

%PORT_TYPE_WRITE        = &H1
%PORT_TYPE_READ         = &H2
%PORT_TYPE_REDIRECTED   = &H4
%PORT_TYPE_NET_ATTACHED = &H8

%PRINTER_ENUM_DEFAULT     = &H1
%PRINTER_ENUM_LOCAL       = &H2
%PRINTER_ENUM_CONNECTIONS = &H4
%PRINTER_ENUM_FAVORITE    = &H4
%PRINTER_ENUM_NAME        = &H8
%PRINTER_ENUM_REMOTE      = &H10
%PRINTER_ENUM_SHARED      = &H20
%PRINTER_ENUM_NETWORK     = &H40

%PRINTER_ENUM_EXPAND      = &H4000
%PRINTER_ENUM_CONTAINER   = &H8000

%PRINTER_ENUM_ICONMASK    = &HFF0000
%PRINTER_ENUM_ICON1       = &H10000
%PRINTER_ENUM_ICON2       = &H20000
%PRINTER_ENUM_ICON3       = &H40000
%PRINTER_ENUM_ICON4       = &H80000
%PRINTER_ENUM_ICON5       = &H100000
%PRINTER_ENUM_ICON6       = &H200000
%PRINTER_ENUM_ICON7       = &H400000
%PRINTER_ENUM_ICON8       = &H800000

%PRINTER_CHANGE_ADD_PRINTER             = &H1
%PRINTER_CHANGE_SET_PRINTER             = &H2
%PRINTER_CHANGE_DELETE_PRINTER          = &H4
%PRINTER_CHANGE_PRINTER                 = &HFF
%PRINTER_CHANGE_ADD_JOB                 = &H100
%PRINTER_CHANGE_SET_JOB                 = &H200
%PRINTER_CHANGE_DELETE_JOB              = &H400
%PRINTER_CHANGE_WRITE_JOB               = &H800
%PRINTER_CHANGE_JOB                     = &HFF00
%PRINTER_CHANGE_ADD_FORM                = &H10000
%PRINTER_CHANGE_SET_FORM                = &H20000
%PRINTER_CHANGE_DELETE_FORM             = &H40000
%PRINTER_CHANGE_FORM                    = &H70000
%PRINTER_CHANGE_ADD_PORT                = &H100000
%PRINTER_CHANGE_CONFIGURE_PORT          = &H200000
%PRINTER_CHANGE_DELETE_PORT             = &H400000
%PRINTER_CHANGE_PORT                    = &H700000
%PRINTER_CHANGE_ADD_PRINT_PROCESSOR     = &H1000000
%PRINTER_CHANGE_DELETE_PRINT_PROCESSOR  = &H4000000
%PRINTER_CHANGE_PRINT_PROCESSOR         = &H7000000
%PRINTER_CHANGE_ADD_PRINTER_DRIVER      = &H10000000
%PRINTER_CHANGE_DELETE_PRINTER_DRIVER   = &H40000000
%PRINTER_CHANGE_PRINTER_DRIVER          = &H70000000
%PRINTER_CHANGE_TIMEOUT                 = &H80000000
%PRINTER_CHANGE_ALL                     = &H7777FFFF

%PRINTER_ERROR_INFORMATION = &H80000000
%PRINTER_ERROR_WARNING     = &H40000000
%PRINTER_ERROR_SEVERE      = &H20000000

%PRINTER_ERROR_OUTOFPAPER  = &H1
%PRINTER_ERROR_JAM         = &H2
%PRINTER_ERROR_OUTOFTONER  = &H4

%SERVER_ACCESS_ADMINISTER  = &H1
%SERVER_ACCESS_ENUMERATE   = &H2

%PRINTER_ACCESS_ADMINISTER = &H4
%PRINTER_ACCESS_USE        = &H8

%JOB_ACCESS_ADMINISTER = &H10

' Access rights for print servers

%SERVER_ALL_ACCESS = %STANDARD_RIGHTS_REQUIRED OR %SERVER_ACCESS_ADMINISTER OR %SERVER_ACCESS_ENUMERATE
%SERVER_READ       = %STANDARD_RIGHTS_READ OR %SERVER_ACCESS_ENUMERATE
%SERVER_WRITE      = %STANDARD_RIGHTS_WRITE OR %SERVER_ACCESS_ADMINISTER OR %SERVER_ACCESS_ENUMERATE
%SERVER_EXECUTE    = %STANDARD_RIGHTS_EXECUTE OR %SERVER_ACCESS_ENUMERATE

' Access rights for printers
%PRINTER_ALL_ACCESS = %STANDARD_RIGHTS_REQUIRED OR %PRINTER_ACCESS_ADMINISTER OR %PRINTER_ACCESS_USE
%PRINTER_READ       = %STANDARD_RIGHTS_READ OR %PRINTER_ACCESS_USE
%PRINTER_WRITE      = %STANDARD_RIGHTS_WRITE OR %PRINTER_ACCESS_USE
%PRINTER_EXECUTE    = %STANDARD_RIGHTS_EXECUTE OR %PRINTER_ACCESS_USE

' Access rights for jobs
%JOB_ALL_ACCESS = %STANDARD_RIGHTS_REQUIRED OR %JOB_ACCESS_ADMINISTER
%JOB_READ       = %STANDARD_RIGHTS_READ OR %JOB_ACCESS_ADMINISTER
%JOB_WRITE      = %STANDARD_RIGHTS_WRITE OR %JOB_ACCESS_ADMINISTER
%JOB_EXECUTE    = %STANDARD_RIGHTS_EXECUTE OR %JOB_ACCESS_ADMINISTER

' Windows Network support (constants from winnetwk.h) =========================

' Network types
'
%WNNC_NET_MSNET      = &H00010000
%WNNC_NET_LANMAN     = &H00020000
%WNNC_NET_NETWARE    = &H00030000
%WNNC_NET_VINES      = &H00040000
%WNNC_NET_10NET      = &H00050000
%WNNC_NET_LOCUS      = &H00060000
%WNNC_NET_SUN_PC_NFS = &H00070000
%WNNC_NET_LANSTEP    = &H00080000
%WNNC_NET_9TILES     = &H00090000
%WNNC_NET_LANTASTIC  = &H000A0000
%WNNC_NET_AS400      = &H000B0000
%WNNC_NET_FTP_NFS    = &H000C0000
%WNNC_NET_PATHWORKS  = &H000D0000
%WNNC_NET_LIFENET    = &H000E0000
%WNNC_NET_POWERLAN   = &H000F0000
%WNNC_NET_BWNFS      = &H00100000
%WNNC_NET_COGENT     = &H00110000
%WNNC_NET_FARALLON   = &H00120000
%WNNC_NET_APPLETALK  = &H00130000
%WNNC_NET_INTERGRAPH = &H00140000
%WNNC_NET_SYMFONET   = &H00150000
%WNNC_NET_CLEARCASE  = &H00160000
%WNNC_NET_FRONTIER   = &H00170000
%WNNC_NET_BMC        = &H00180000
%WNNC_NET_DCE        = &H00190000
%WNNC_NET_DECORB     = &H00200000
%WNNC_NET_PROTSTOR   = &H00210000
%WNNC_NET_FJ_REDIR   = &H00220000
%WNNC_NET_DISTINCT   = &H00230000
%WNNC_NET_TWINS      = &H00240000
%WNNC_NET_RDR2SAMPLE = &H00250000

' Network Resources.
'
%RESOURCE_CONNECTED    = &H00000001
%RESOURCE_PUBLICNET    = &H00000002
%RESOURCE_GLOBALNET    = &H00000002
%RESOURCE_REMEMBERED   = &H00000003
%RESOURCE_RECENT       = &H00000004
%RESOURCE_CONTEXT      = &H00000005

%RESOURCETYPE_ANY      = &H00000000
%RESOURCETYPE_DISK     = &H00000001
%RESOURCETYPE_PRINT    = &H00000002
%RESOURCETYPE_RESERVED = &H00000008
%RESOURCETYPE_UNKNOWN  = &HFFFFFFFF???

%RESOURCEUSAGE_CONNECTABLE   = &H00000001
%RESOURCEUSAGE_CONTAINER     = &H00000002
%RESOURCEUSAGE_NOLOCALDEVICE = &H00000004
%RESOURCEUSAGE_SIBLING       = &H00000008
%RESOURCEUSAGE_ATTACHED      = &H00000010
%RESOURCEUSAGE_ALL           = %RESOURCEUSAGE_CONNECTABLE OR %RESOURCEUSAGE_CONTAINER OR %RESOURCEUSAGE_ATTACHED
%RESOURCEUSAGE_RESERVED      = &H80000000

%RESOURCEDISPLAYTYPE_GENERIC      = &H00000000
%RESOURCEDISPLAYTYPE_DOMAIN       = &H00000001
%RESOURCEDISPLAYTYPE_SERVER       = &H00000002
%RESOURCEDISPLAYTYPE_SHARE        = &H00000003
%RESOURCEDISPLAYTYPE_FILE         = &H00000004
%RESOURCEDISPLAYTYPE_GROUP        = &H00000005
%RESOURCEDISPLAYTYPE_NETWORK      = &H00000006
%RESOURCEDISPLAYTYPE_ROOT         = &H00000007
%RESOURCEDISPLAYTYPE_SHAREADMIN   = &H00000008
%RESOURCEDISPLAYTYPE_DIRECTORY    = &H00000009
%RESOURCEDISPLAYTYPE_TREE         = &H0000000A
%RESOURCEDISPLAYTYPE_NDSCONTAINER = &H0000000B

' Network Connections.
'
%NETPROPERTY_PERSISTENT = 1

%CONNECT_UPDATE_PROFILE = &H00000001
%CONNECT_UPDATE_RECENT  = &H00000002
%CONNECT_TEMPORARY      = &H00000004
%CONNECT_INTERACTIVE    = &H00000008
%CONNECT_PROMPT         = &H00000010
%CONNECT_NEED_DRIVE     = &H00000020
%CONNECT_REFCOUNT       = &H00000040
%CONNECT_REDIRECT       = &H00000080
%CONNECT_LOCALDRIVE     = &H00000100
%CONNECT_CURRENT_MEDIA  = &H00000200
%CONNECT_DEFERRED       = &H00000400
%CONNECT_RESERVED       = &HFF000000

%CONNDLG_RO_PATH        = &H00000001   ' Resource path should be read-only
%CONNDLG_CONN_POINT     = &H00000002   ' Netware-style movable connection point
%CONNDLG_USE_MRU        = &H00000004   ' Use MRU combobox
%CONNDLG_HIDE_BOX       = &H00000008   ' Hide persistent connect checkbox

' NOTE: Set at most ONE of the below CONNDLG_ flags. If neither flag is set,
'       the persistence is set to whatever the user chose during a previous
'       connection.
'
%CONNDLG_PERSIST        = &H00000010   ' Force persistent connection
%CONNDLG_NOT_PERSIST    = &H00000020   ' Force connection NOT persistent

%DISC_UPDATE_PROFILE = &H00000001
%DISC_NO_FORCE       = &H00000040

' Universal Naming.
'
%UNIVERSAL_NAME_INFO_LEVEL = &H00000001
%REMOTE_NAME_INFO_LEVEL    = &H00000002

' Other.
'
%WNFMT_MULTILINE    = &H01
%WNFMT_ABBREVIATED  = &H02
%WNFMT_INENUM       = &H10
%WNFMT_CONNECTION   = &H20

%NETINFO_DLL16      = &H00000001  ' Provider running as 16 bit Winnet Driver
%NETINFO_DISKRED    = &H00000004  ' Provider requires disk redirections to connect
%NETINFO_PRINTERRED = &H00000008  ' Provider requires printer redirections to connect

%RP_LOGON   = &H01   ' if set, do for logon, else for logoff
%RP_INIFILE = &H02   ' if set, reconcile .INI file, else reg. hive

%PP_DISPLAYERRORS = &H01  ' if set, display error messages, else fail silently if error

'
' STATUS CODES
'
'
' General
'
%WN_SUCCESS          = %NO_ERROR
%WN_NO_ERROR         = %NO_ERROR
%WN_NOT_SUPPORTED    = %ERROR_NOT_SUPPORTED
%WN_CANCEL           = %ERROR_CANCELLED
%WN_RETRY            = %ERROR_RETRY
%WN_NET_ERROR        = %ERROR_UNEXP_NET_ERR
%WN_MORE_DATA        = %ERROR_MORE_DATA
%WN_BAD_POINTER      = %ERROR_INVALID_ADDRESS
%WN_BAD_VALUE        = %ERROR_INVALID_PARAMETER
%WN_BAD_USER         = %ERROR_BAD_USERNAME
%WN_BAD_PASSWORD     = %ERROR_INVALID_PASSWORD
%WN_ACCESS_DENIED    = %ERROR_ACCESS_DENIED
%WN_FUNCTION_BUSY    = %ERROR_BUSY
%WN_WINDOWS_ERROR    = %ERROR_UNEXP_NET_ERR
%WN_OUT_OF_MEMORY    = %ERROR_NOT_ENOUGH_MEMORY
%WN_NO_NETWORK       = %ERROR_NO_NETWORK
%WN_EXTENDED_ERROR   = %ERROR_EXTENDED_ERROR
%WN_BAD_LEVEL        = %ERROR_INVALID_LEVEL
%WN_BAD_HANDLE       = %ERROR_INVALID_HANDLE
%WN_NOT_INITIALIZING = %ERROR_ALREADY_INITIALIZED
%WN_NO_MORE_DEVICES  = %ERROR_NO_MORE_DEVICES

' Connection
'
%WN_NOT_CONNECTED        = %ERROR_NOT_CONNECTED
%WN_OPEN_FILES           = %ERROR_OPEN_FILES
%WN_DEVICE_IN_USE        = %ERROR_DEVICE_IN_USE
%WN_BAD_NETNAME          = %ERROR_BAD_NET_NAME
%WN_BAD_LOCALNAME        = %ERROR_BAD_DEVICE
%WN_ALREADY_CONNECTED    = %ERROR_ALREADY_ASSIGNED
%WN_DEVICE_ERROR         = %ERROR_GEN_FAILURE
%WN_CONNECTION_CLOSED    = %ERROR_CONNECTION_UNAVAIL
%WN_NO_NET_OR_BAD_PATH   = %ERROR_NO_NET_OR_BAD_PATH
%WN_BAD_PROVIDER         = %ERROR_BAD_PROVIDER
%WN_CANNOT_OPEN_PROFILE  = %ERROR_CANNOT_OPEN_PROFILE
%WN_BAD_PROFILE          = %ERROR_BAD_PROFILE
%WN_BAD_DEV_TYPE         = %ERROR_BAD_DEV_TYPE
%WN_DEVICE_ALREADY_REMEMBERED = %ERROR_DEVICE_ALREADY_REMEMBERED
%WN_CONNECTED_OTHER_PASSWORD  = %ERROR_CONNECTED_OTHER_PASSWORD

' Enumeration
'
%WN_NO_MORE_ENTRIES     = %ERROR_NO_MORE_ITEMS
%WN_NOT_CONTAINER       = %ERROR_NOT_CONTAINER

' Authentication
'
%WN_NOT_AUTHENTICATED   = %ERROR_NOT_AUTHENTICATED
%WN_NOT_LOGGED_ON       = %ERROR_NOT_LOGGED_ON
%WN_NOT_VALIDATED       = %ERROR_NO_LOGON_SERVERS

' for Shell
'
%WNCON_FORNETCARD = &H00000001
%WNCON_NOTROUTED  = &H00000002
%WNCON_SLOWLINK   = &H00000004
%WNCON_DYNAMIC    = &H00000008


' End of constants from winnetwk.h ============================================

' This section contains the definitions
' for portable NetBIOS 3.0 support.

%NCBNAMSZ         = 16  '  absolute length of a net name
%MAX_LANA         = 254  '  lana's in range 0 to MAX_LANA

' Constants from nb30.h =======================================================

%NAME_FLAGS_MASK  = &H87
%GROUP_NAME       = &H80
%UNIQUE_NAME      = &H00
%REGISTERING      = &H00
%REGISTERED       = &H04
%DEREGISTERED     = &H05
%DUPLICATE        = &H06
%DUPLICATE_DEREG  = &H07

' Values for state
'
%LISTEN_OUTSTANDING   = &H01
%CALL_PENDING         = &H02
%SESSION_ESTABLISHED  = &H03
%HANGUP_PENDING       = &H04
%HANGUP_COMPLETE      = &H05
%SESSION_ABORTED      = &H06

' Values for transport_id
'
#IF 1  ' Assume PB/CC 2.0 and PB/DLL 6.0

  $ALL_TRANSPORTS = "M\0\0\0"
  $MS_NBF         = "MNBF"

#ENDIF

' NCB Command codes
'
%NCBCALL          = &H10  ' NCB CALL
%NCBLISTEN        = &H11  ' NCB LISTEN
%NCBHANGUP        = &H12  ' NCB HANG UP
%NCBSEND          = &H14  ' NCB SEND
%NCBRECV          = &H15  ' NCB RECEIVE
%NCBRECVANY       = &H16  ' NCB RECEIVE ANY
%NCBCHAINSEND     = &H17  ' NCB CHAIN SEND
%NCBDGSEND        = &H20  ' NCB SEND DATAGRAM
%NCBDGRECV        = &H21  ' NCB RECEIVE DATAGRAM
%NCBDGSENDBC      = &H22  ' NCB SEND BROADCAST DATAGRAM
%NCBDGRECVBC      = &H23  ' NCB RECEIVE BROADCAST DATAGRAM
%NCBADDNAME       = &H30  ' NCB ADD NAME
%NCBDELNAME       = &H31  ' NCB DELETE NAME
%NCBRESET         = &H32  ' NCB RESET
%NCBASTAT         = &H33  ' NCB ADAPTER STATUS
%NCBSSTAT         = &H34  ' NCB SESSION STATUS
%NCBCANCEL        = &H35  ' NCB CANCEL
%NCBADDGRNAME     = &H36  ' NCB ADD GROUP NAME
%NCBENUM          = &H37  ' NCB ENUMERATE LANA NUMBERS
%NCBUNLINK        = &H70  ' NCB UNLINK
%NCBSENDNA        = &H71  ' NCB SEND NO ACK
%NCBCHAINSENDNA   = &H72  ' NCB CHAIN SEND NO ACK
%NCBLANSTALERT    = &H73  ' NCB LAN STATUS ALERT
%NCBACTION        = &H77  ' NCB ACTION
%NCBFINDNAME      = &H78  ' NCB FIND NAME
%NCBTRACE         = &H79  ' NCB TRACE

%ASYNCH           = &H80  ' high bit set == asynchronous

' NCB Return codes
'
%NRC_GOODRET      = &H00  ' good return
                          ' also returned when ASYNCH request accepted
%NRC_BUFLEN       = &H01  ' illegal buffer length
%NRC_ILLCMD       = &H03  ' illegal command
%NRC_CMDTMO       = &H05  ' command timed out
%NRC_INCOMP       = &H06  ' message incomplete, issue another command
%NRC_BADDR        = &H07  ' illegal buffer address
%NRC_SNUMOUT      = &H08  ' session number out of range
%NRC_NORES        = &H09  ' no resource available
%NRC_SCLOSED      = &H0A  ' session closed
%NRC_CMDCAN       = &H0B  ' command cancelled
%NRC_DUPNAME      = &H0D  ' duplicate name
%NRC_NAMTFUL      = &H0E  ' name table full
%NRC_ACTSES       = &H0F  ' no deletions, name has active sessions
%NRC_LOCTFUL      = &H11  ' local session table full
%NRC_REMTFUL      = &H12  ' remote session table full
%NRC_ILLNN        = &H13  ' illegal name number
%NRC_NOCALL       = &H14  ' no callname
%NRC_NOWILD       = &H15  ' cannot put  in NCB_NAME
%NRC_INUSE        = &H16  ' name in use on remote adapter
%NRC_NAMERR       = &H17  ' name deleted
%NRC_SABORT       = &H18  ' session ended abnormally
%NRC_NAMCONF      = &H19  ' name conflict detected
%NRC_IFBUSY       = &H21  ' interface busy, IRET before retrying
%NRC_TOOMANY      = &H22  ' too many commands outstanding, retry later
%NRC_BRIDGE       = &H23  ' ncb_lana_num field invalid
%NRC_CANOCCR      = &H24  ' command completed while cancel occurring
%NRC_CANCEL       = &H26  ' command not valid to cancel
%NRC_DUPENV       = &H30  ' name defined by anther local process
%NRC_ENVNOTDEF    = &H34  ' environment undefined. RESET required
%NRC_OSRESNOTAV   = &H35  ' required OS resources exhausted
%NRC_MAXAPPS      = &H36  ' max number of applications exceeded
%NRC_NOSAPS       = &H37  ' no saps available for netbios
%NRC_NORESOURCES  = &H38  ' requested resources are not available
%NRC_INVADDRESS   = &H39  ' invalid ncb address or length > segment
%NRC_INVDDID      = &H3B  ' invalid NCB DDID
%NRC_LOCKFAIL     = &H3C  ' lock of user area failed
%NRC_OPENERR      = &H3F  ' NETBIOS not loaded
%NRC_SYSTEM       = &H40  ' system error

%NRC_PENDING      = &HFF  ' asynchronous command is not yet finished

' End of constants from nb30.h ================================================

' Legal values for expression in except().
%EXCEPTION_EXECUTE_HANDLER    = 1
%EXCEPTION_CONTINUE_SEARCH    = 0
%EXCEPTION_CONTINUE_EXECUTION = -1

' UI dialog constants and types

' ----Constants--------------------------------------------------------------
%ctlFirst = &H400
%ctlLast  = &H4FF
'  Push buttons
%psh1     = &H400
%psh2     = &H401
%psh3     = &H402
%psh4     = &H403
%psh5     = &H404
%psh6     = &H405
%psh7     = &H406
%psh8     = &H407
%psh9     = &H408
%psh10    = &H409
%psh11    = &H40A
%psh12    = &H40B
%psh13    = &H40C
%psh14    = &H40D
%psh15    = &H40E
%pshHelp  = %psh15
%psh16    = &H40F
'  Checkboxes
%chx1     = &H410
%chx2     = &H411
%chx3     = &H412
%chx4     = &H413
%chx5     = &H414
%chx6     = &H415
%chx7     = &H416
%chx8     = &H417
%chx9     = &H418
%chx10    = &H419
%chx11    = &H41A
%chx12    = &H41B
%chx13    = &H41C
%chx14    = &H41D
%chx15    = &H41E
%chx16    = &H41D
'  Radio buttons
%rad1     = &H420
%rad2     = &H421
%rad3     = &H422
%rad4     = &H423
%rad5     = &H424
%rad6     = &H425
%rad7     = &H426
%rad8     = &H427
%rad9     = &H428
%rad10    = &H429
%rad11    = &H42A
%rad12    = &H42B
%rad13    = &H42C
%rad14    = &H42D
%rad15    = &H42E
%rad16    = &H42F
'  Groups, frames, rectangles, and icons
%grp1     = &H430
%grp2     = &H431
%grp3     = &H432
%grp4     = &H433
%frm1     = &H434
%frm2     = &H435
%frm3     = &H436
%frm4     = &H437
%rct1     = &H438
%rct2     = &H439
%rct3     = &H43A
%rct4     = &H43B
%ico1     = &H43C
%ico2     = &H43D
%ico3     = &H43E
%ico4     = &H43F
'  Static text
%stc1     = &H440
%stc2     = &H441
%stc3     = &H442
%stc4     = &H443
%stc5     = &H444
%stc6     = &H445
%stc7     = &H446
%stc8     = &H447
%stc9     = &H448
%stc10    = &H449
%stc11    = &H44A
%stc12    = &H44B
%stc13    = &H44C
%stc14    = &H44D
%stc15    = &H44E
%stc16    = &H44F
%stc17    = &H450
%stc18    = &H451
%stc19    = &H452
%stc20    = &H453
%stc21    = &H454
%stc22    = &H455
%stc23    = &H456
%stc24    = &H457
%stc25    = &H458
%stc26    = &H459
%stc27    = &H45A
%stc28    = &H45B
%stc29    = &H45C
%stc30    = &H45D
%stc31    = &H45E
%stc32    = &H45F
'  Listboxes
%lst1     = &H460
%lst2     = &H461
%lst3     = &H462
%lst4     = &H463
%lst5     = &H464
%lst6     = &H465
%lst7     = &H466
%lst8     = &H467
%lst9     = &H468
%lst10    = &H469
%lst11    = &H46A
%lst12    = &H46B
%lst13    = &H46C
%lst14    = &H46D
%lst15    = &H46E
%lst16    = &H46F
'  Combo boxes
%cmb1     = &H470
%cmb2     = &H471
%cmb3     = &H472
%cmb4     = &H473
%cmb5     = &H474
%cmb6     = &H475
%cmb7     = &H476
%cmb8     = &H477
%cmb9     = &H478
%cmb10    = &H479
%cmb11    = &H47A
%cmb12    = &H47B
%cmb13    = &H47C
%cmb14    = &H47D
%cmb15    = &H47E
%cmb16    = &H47F
'  Edit controls
%edt1     = &H480
%edt2     = &H481
%edt3     = &H482
%edt4     = &H483
%edt5     = &H484
%edt6     = &H485
%edt7     = &H486
%edt8     = &H487
%edt9     = &H488
%edt10    = &H489
%edt11    = &H48A
%edt12    = &H48B
%edt13    = &H48C
%edt14    = &H48D
%edt15    = &H48E
%edt16    = &H48F
'  Scroll bars
%scr1     = &H490
%scr2     = &H491
%scr3     = &H492
%scr4     = &H493
%scr5     = &H494
%scr6     = &H495
%scr7     = &H496
%scr8     = &H497

%FILEOPENORD        = 1536
%MULTIFILEOPENORD   = 1537
%PRINTDLGORD        = 1538
%PRNSETUPDLGORD     = 1539
%FINDDLGORD         = 1540
%REPLACEDLGORD      = 1541
%FONTDLGORD         = 1542
%FORMATDLGORD31     = 1543
%FORMATDLGORD30     = 1544

%HKEY_CLASSES_ROOT     = &H80000000
%HKEY_CURRENT_USER     = &H80000001
%HKEY_LOCAL_MACHINE    = &H80000002
%HKEY_USERS            = &H80000003
%HKEY_PERFORMANCE_DATA = &H80000004
%HKEY_CURRENT_CONFIG   = &H80000005
%HKEY_DYN_DATA         = &H80000006
%HKEY_DYNAMIC_DATA     = %HKEY_DYN_DATA

%HKCR = %HKEY_CLASSES_ROOT
%HKCU = %HKEY_CURRENT_USER
%HKLM = %HKEY_LOCAL_MACHINE
%HKU  = %HKEY_USERS
%HKPD = %HKEY_PERFORMANCE_DATA
%HKCC = %HKEY_CURRENT_CONFIG
%HKDD = %HKEY_DYN_DATA

' Value to indicate no change to an optional parameter
%SERVICE_NO_CHANGE = &HFFFF

' Service State -- for Enum Requests (Bit Mask)
%SERVICE_ACTIVE    = &H1
%SERVICE_INACTIVE  = &H2
%SERVICE_STATE_ALL = %SERVICE_ACTIVE OR %SERVICE_INACTIVE

' Controls
%SERVICE_CONTROL_STOP        = &H1
%SERVICE_CONTROL_PAUSE       = &H2
%SERVICE_CONTROL_CONTINUE    = &H3
%SERVICE_CONTROL_INTERROGATE = &H4
%SERVICE_CONTROL_SHUTDOWN    = &H5

' Service State -- for CurrentState
%SERVICE_STOPPED          = &H1
%SERVICE_START_PENDING    = &H2
%SERVICE_STOP_PENDING     = &H3
%SERVICE_RUNNING          = &H4
%SERVICE_CONTINUE_PENDING = &H5
%SERVICE_PAUSE_PENDING    = &H6
%SERVICE_PAUSED           = &H7

' Controls Accepted  (Bit Mask)
%SERVICE_ACCEPT_STOP           = &H1
%SERVICE_ACCEPT_PAUSE_CONTINUE = &H2
%SERVICE_ACCEPT_SHUTDOWN       = &H4

' Service Control Manager object specific access types
%SC_MANAGER_CONNECT            = &H1
%SC_MANAGER_CREATE_SERVICE     = &H2
%SC_MANAGER_ENUMERATE_SERVICE  = &H4
%SC_MANAGER_LOCK               = &H8
%SC_MANAGER_QUERY_LOCK_STATUS  = &H10
%SC_MANAGER_MODIFY_BOOT_CONFIG = &H20

%SC_MANAGER_ALL_ACCESS         = %STANDARD_RIGHTS_REQUIRED OR %SC_MANAGER_CONNECT OR %SC_MANAGER_CREATE_SERVICE OR %SC_MANAGER_ENUMERATE_SERVICE OR %SC_MANAGER_LOCK _
                                 OR %SC_MANAGER_QUERY_LOCK_STATUS OR %SC_MANAGER_MODIFY_BOOT_CONFIG

' Service object specific access type
%SERVICE_QUERY_CONFIG          = &H1
%SERVICE_CHANGE_CONFIG         = &H2
%SERVICE_QUERY_STATUS          = &H4
%SERVICE_ENUMERATE_DEPENDENTS  = &H8
%SERVICE_START                 = &H10
%SERVICE_STOP                  = &H20
%SERVICE_PAUSE_CONTINUE        = &H40
%SERVICE_INTERROGATE           = &H80
%SERVICE_USER_DEFINED_CONTROL  = &H100

%SERVICE_ALL_ACCESS            = %STANDARD_RIGHTS_REQUIRED OR %SERVICE_QUERY_CONFIG OR %SERVICE_CHANGE_CONFIG OR %SERVICE_QUERY_STATUS _
                                 OR %SERVICE_ENUMERATE_DEPENDENTS OR %SERVICE_START OR %SERVICE_STOP OR %SERVICE_PAUSE_CONTINUE OR %SERVICE_INTERROGATE OR %SERVICE_USER_DEFINED_CONTROL


%PERF_DATA_VERSION             = 1
%PERF_DATA_REVISION            = 1

%PERF_NO_INSTANCES             = -1  '  no instances

' The counter type is the "or" of the following values as described below
'
' select one of the following to indicate the counter's data size
%PERF_SIZE_DWORD               = &H0
%PERF_SIZE_LARGE               = &H100
%PERF_SIZE_ZERO                = &H200    '  for Zero Length fields
%PERF_SIZE_VARIABLE_LEN        = &H300    '  length is in CounterLength field of Counter Definition struct

' select one of the following values to indicate the counter field usage
%PERF_TYPE_NUMBER              = &H0      '  a number (not a counter)
%PERF_TYPE_COUNTER             = &H400    '  an increasing numeric value
%PERF_TYPE_TEXT                = &H800    '  a text field
%PERF_TYPE_ZERO                = &HC00    '  displays a zero

' If the PERF_TYPE_NUMBER field was selected, then select one of the
' following to describe the Number
%PERF_NUMBER_HEX               = &H0      '  display as HEX value
%PERF_NUMBER_DECIMAL           = &H10000  '  display as a decimal integer
%PERF_NUMBER_DEC_1000          = &H20000  '  display as a decimal/1000
'
' If the PERF_TYPE_COUNTER value was selected then select one of the
' following to indicate the type of counter
%PERF_COUNTER_VALUE            = &H0      '  display counter value
%PERF_COUNTER_RATE             = &H10000  '  divide ctr / delta time
%PERF_COUNTER_FRACTION         = &H20000  '  divide ctr / base
%PERF_COUNTER_BASE             = &H30000  '  base value used in fractions
%PERF_COUNTER_ELAPSED          = &H40000  '  subtract counter from current time
%PERF_COUNTER_QUEUELEN         = &H50000  '  Use Queuelen processing func.
%PERF_COUNTER_HISTOGRAM        = &H60000  '  Counter begins or ends a histogram

' If the PERF_TYPE_TEXT value was selected, then select one of the
' following to indicate the type of TEXT data.
%PERF_TEXT_UNICODE             = &H0      '  type of text in text field
%PERF_TEXT_ASCII               = &H10000  '  ASCII using the CodePage field

' Timer SubTypes
%PERF_TIMER_TICK               = &H0         '  use system perf. freq for base
%PERF_TIMER_100NS              = &H100000    '  use 100 NS timer time base units
%PERF_OBJECT_TIMER             = &H200000    '  use the object timer freq

' Any types that have calculations performed can use one or more of
' the following calculation modification flags listed here
%PERF_DELTA_COUNTER            = &H400000    '  compute difference first
%PERF_DELTA_BASE               = &H800000    '  compute base diff as well
%PERF_INVERSE_COUNTER          = &H1000000   '  show as 1.00-value (assumes:
%PERF_MULTI_COUNTER            = &H2000000   '  sum of multiple instances

' Select one of the following values to indicate the display suffix (if any)
%PERF_DISPLAY_NO_SUFFIX        = &H0         '  no suffix
%PERF_DISPLAY_PER_SEC          = &H10000000  '  "/sec"
%PERF_DISPLAY_PERCENT          = &H20000000  '  "%"
%PERF_DISPLAY_SECONDS          = &H30000000  '  "secs"
%PERF_DISPLAY_NOSHOW           = &H40000000  '  value is not displayed

' Predefined counter types

' 32-bit Counter.  Divide delta by delta time.  Display suffix: "/sec"
%PERF_COUNTER_COUNTER          = %PERF_SIZE_DWORD OR %PERF_TYPE_COUNTER OR %PERF_COUNTER_RATE OR %PERF_TIMER_TICK OR %PERF_DELTA_COUNTER OR %PERF_DISPLAY_PER_SEC

' 64-bit Timer.  Divide delta by delta time.  Display suffix: "%"
%PERF_COUNTER_TIMER            = %PERF_SIZE_LARGE OR %PERF_TYPE_COUNTER OR %PERF_COUNTER_RATE OR %PERF_TIMER_TICK OR %PERF_DELTA_COUNTER OR %PERF_DISPLAY_PERCENT

' Queue Length Space-Time Product. Divide delta by delta time. No Display Suffix.
%PERF_COUNTER_QUEUELEN_TYPE    = %PERF_SIZE_DWORD OR %PERF_TYPE_COUNTER OR %PERF_COUNTER_QUEUELEN OR %PERF_TIMER_TICK OR %PERF_DELTA_COUNTER OR %PERF_DISPLAY_NO_SUFFIX

' 64-bit Counter.  Divide delta by delta time. Display Suffix: "/sec"
%PERF_COUNTER_BULK_COUNT       = %PERF_SIZE_LARGE OR %PERF_TYPE_COUNTER OR %PERF_COUNTER_RATE OR %PERF_TIMER_TICK OR %PERF_DELTA_COUNTER OR %PERF_DISPLAY_PER_SEC

' Indicates the counter is not a  counter but rather Unicode text Display as text.
%PERF_COUNTER_TEXT             = %PERF_SIZE_VARIABLE_LEN OR %PERF_TYPE_TEXT OR %PERF_TEXT_UNICODE OR %PERF_DISPLAY_NO_SUFFIX

' Indicates the data is a counter  which should not be
' time averaged on display (such as an error counter on a serial line)
' Display as is.  No Display Suffix.
%PERF_COUNTER_RAWCOUNT         = %PERF_SIZE_DWORD OR %PERF_TYPE_NUMBER OR %PERF_NUMBER_DECIMAL OR %PERF_DISPLAY_NO_SUFFIX

' A count which is either 1 or 0 on each sampling interrupt (% busy)
' Divide delta by delta base. Display Suffix: "%"
%PERF_SAMPLE_FRACTION          = %PERF_SIZE_DWORD OR %PERF_TYPE_COUNTER OR %PERF_COUNTER_FRACTION OR %PERF_DELTA_COUNTER OR %PERF_DELTA_BASE OR %PERF_DISPLAY_PERCENT

' A count which is sampled on each sampling interrupt (queue length)
' Divide delta by delta time. No Display Suffix.
%PERF_SAMPLE_COUNTER           = %PERF_SIZE_DWORD OR %PERF_TYPE_COUNTER OR %PERF_COUNTER_RATE OR %PERF_TIMER_TICK OR %PERF_DELTA_COUNTER OR %PERF_DISPLAY_NO_SUFFIX

' A label: no data is associated with this counter (it has 0 length)
' Do not display.
%PERF_COUNTER_NODATA           = %PERF_SIZE_ZERO OR %PERF_DISPLAY_NOSHOW

' 64-bit Timer inverse (e.g., idle is measured, but display busy as Integer)
' Display 100 - delta divided by delta time.  Display suffix: "%"
%PERF_COUNTER_TIMER_INV        = %PERF_SIZE_LARGE OR %PERF_TYPE_COUNTER OR %PERF_COUNTER_RATE OR %PERF_TIMER_TICK OR %PERF_DELTA_COUNTER OR %PERF_INVERSE_COUNTER OR %PERF_DISPLAY_PERCENT

' The divisor for a sample, used with the previous counter to form a
' sampled %.  You must check for >0 before dividing by this!  This
' counter will directly follow the  numerator counter.  It should not
' be displayed to the user.
%PERF_SAMPLE_BASE              = %PERF_SIZE_DWORD OR %PERF_TYPE_COUNTER OR %PERF_COUNTER_BASE OR %PERF_DISPLAY_NOSHOW OR &H1         '  for compatibility with pre-beta versions

' A timer which, when divided by an average base, produces a time
' in seconds which is the average time of some operation.  This
' timer times total operations, and  the base is the number of opera-
' tions.  Display Suffix: "sec"
%PERF_AVERAGE_TIMER            = %PERF_SIZE_DWORD OR %PERF_TYPE_COUNTER OR %PERF_COUNTER_FRACTION OR %PERF_DISPLAY_SECONDS

' Used as the denominator in the computation of time or count
' averages.  Must directly follow the numerator counter.  Not dis-
' played to the user.
%PERF_AVERAGE_BASE             = %PERF_SIZE_DWORD OR %PERF_TYPE_COUNTER OR %PERF_COUNTER_BASE OR %PERF_DISPLAY_NOSHOW OR &H2         '  for compatibility with pre-beta versions

' A bulk count which, when divided (typically) by the number of
' operations, gives (typically) the number of bytes per operation.
' No Display Suffix.
%PERF_AVERAGE_BULK             = %PERF_SIZE_LARGE OR %PERF_TYPE_COUNTER OR %PERF_COUNTER_FRACTION OR %PERF_DISPLAY_NOSHOW

' 64-bit Timer in 100 nsec units. Display delta divided by
' delta time.  Display suffix: "%"
%PERF_100NSEC_TIMER            = %PERF_SIZE_LARGE OR %PERF_TYPE_COUNTER OR %PERF_COUNTER_RATE OR %PERF_TIMER_100NS OR %PERF_DELTA_COUNTER OR %PERF_DISPLAY_PERCENT

' 64-bit Timer inverse (e.g., idle is measured, but display busy  AS Integer)
' Display 100 - delta divided by delta time.  Display suffix: "%"
%PERF_100NSEC_TIMER_INV        = %PERF_SIZE_LARGE OR %PERF_TYPE_COUNTER OR %PERF_COUNTER_RATE OR %PERF_TIMER_100NS OR %PERF_DELTA_COUNTER OR %PERF_INVERSE_COUNTER OR %PERF_DISPLAY_PERCENT

' 64-bit Timer.  Divide delta by delta time.  Display suffix: "%"
' Timer for multiple instances, so result can exceed 100%.
%PERF_COUNTER_MULTI_TIMER      = %PERF_SIZE_LARGE OR %PERF_TYPE_COUNTER OR %PERF_COUNTER_RATE OR %PERF_DELTA_COUNTER OR %PERF_TIMER_TICK OR %PERF_MULTI_COUNTER OR %PERF_DISPLAY_PERCENT

' 64-bit Timer inverse (e.g., idle is measured, but display busy  AS Integer)
' Display 100  _MULTI_BASE - delta divided by delta time.
' Display suffix: "%" Timer for multiple instances, so result
' can exceed 100%.  Followed by a counter of type _MULTI_BASE.
%PERF_COUNTER_MULTI_TIMER_INV  = %PERF_SIZE_LARGE OR %PERF_TYPE_COUNTER OR %PERF_COUNTER_RATE OR %PERF_DELTA_COUNTER OR %PERF_MULTI_COUNTER OR %PERF_TIMER_TICK OR %PERF_INVERSE_COUNTER OR %PERF_DISPLAY_PERCENT

' Number of instances to which the preceding _MULTI_..._INV counter
' applies.  Used as a factor to get the percentage.
%PERF_COUNTER_MULTI_BASE       = %PERF_SIZE_LARGE OR %PERF_TYPE_COUNTER OR %PERF_COUNTER_BASE OR %PERF_MULTI_COUNTER OR %PERF_DISPLAY_NOSHOW

' 64-bit Timer in 100 nsec units. Display delta divided by delta time.
' Display suffix: "%" Timer for multiple instances, so result can exceed 100%.
%PERF_100NSEC_MULTI_TIMER      = %PERF_SIZE_LARGE OR %PERF_TYPE_COUNTER OR %PERF_DELTA_COUNTER OR %PERF_COUNTER_RATE OR %PERF_TIMER_100NS OR %PERF_MULTI_COUNTER OR %PERF_DISPLAY_PERCENT

' 64-bit Timer inverse (e.g., idle is measured, but display busy  AS Integer)
' Display 100  _MULTI_BASE - delta divided by delta time.
' Display suffix: "%" Timer for multiple instances, so result
' can exceed 100%.  Followed by a counter of type _MULTI_BASE.
%PERF_100NSEC_MULTI_TIMER_INV  = %PERF_SIZE_LARGE OR %PERF_TYPE_COUNTER OR %PERF_DELTA_COUNTER OR %PERF_COUNTER_RATE OR %PERF_TIMER_100NS OR %PERF_MULTI_COUNTER OR %PERF_INVERSE_COUNTER OR %PERF_DISPLAY_PERCENT

' Indicates the data is a fraction of the following counter  which
' should not be time averaged on display (such as free space over
' total space.) Display as is.  Display the quotient as "%".
%PERF_RAW_FRACTION             = %PERF_SIZE_DWORD OR %PERF_TYPE_COUNTER OR %PERF_COUNTER_FRACTION OR %PERF_DISPLAY_PERCENT

' Indicates the data is a base for the preceding counter which should
' not be time averaged on display (such as free space over total space.)
%PERF_RAW_BASE                 = %PERF_SIZE_DWORD OR %PERF_TYPE_COUNTER OR %PERF_COUNTER_BASE OR %PERF_DISPLAY_NOSHOW OR &H3         '  for compatibility with pre-beta versions

' The data collected in this counter is actually the start time of the
' item being measured. For display, this data is subtracted from the
' sample time to yield the elapsed time as the difference between the two.
' In the definition below, the PerfTime field of the Object contains
' the sample time as indicated by the PERF_OBJECT_TIMER bit and the
' difference is scaled by the PerfFreq of the Object to convert the time
' units into seconds.
%PERF_ELAPSED_TIME             = %PERF_SIZE_LARGE OR %PERF_TYPE_COUNTER OR %PERF_COUNTER_ELAPSED OR %PERF_OBJECT_TIMER OR %PERF_DISPLAY_SECONDS

' The following counter type can be used with the preceding types to
' define a range of values to be displayed in a histogram.
%PERF_COUNTER_HISTOGRAM_TYPE   = &H80000000  ' Counter begins or ends a histogram

' The following are used to determine the level of detail associated
' with the counter.  The user will be setting the level of detail
' that should be displayed at any given time.
%PERF_DETAIL_NOVICE     = 100 '  The uninformed can understand it
%PERF_DETAIL_ADVANCED   = 200 '  For the advanced user
%PERF_DETAIL_EXPERT     = 300 '  For the expert user
%PERF_DETAIL_WIZARD     = 400 '  For the system designer

%PERF_NO_UNIQUE_ID      = -1

'  LZEXPAND error return codes
%LZERROR_BADINHANDLE    = -1  '  invalid input handle
%LZERROR_BADOUTHANDLE   = -2  '  invalid output handle
%LZERROR_READ           = -3  '  corrupt compressed file format
%LZERROR_WRITE          = -4  '  out of space for output file
%LZERROR_GLOBALLOC      = -5  '  insufficient memory for LZFile struct
%LZERROR_PUBLICLOC      = -5  ' insufficient memory for LZFile struct
%LZERROR_GLOBLOCK       = -6  '  bad Global handle
%LZERROR_BADVALUE       = -7  '  input parameter out of range
%LZERROR_UNKNOWNALG     = -8  '  compression algorithm not recognized

%VK_PROCESSKEY          = &HE5

' Constants from imm.h ========================================================

%STYLE_DESCRIPTION_SIZE = 32

%IMEMENUITEM_STRING_SIZE = 80

' wParam for WM_IME_CONTROL
%IMC_GETCANDIDATEPOS      = &H0007
%IMC_SETCANDIDATEPOS      = &H0008
%IMC_GETCOMPOSITIONFONT   = &H0009
%IMC_SETCOMPOSITIONFONT   = &H000A
%IMC_GETCOMPOSITIONWINDOW = &H000B
%IMC_SETCOMPOSITIONWINDOW = &H000C
%IMC_GETSTATUSWINDOWPOS   = &H000F
%IMC_SETSTATUSWINDOWPOS   = &H0010
%IMC_CLOSESTATUSWINDOW    = &H0021
%IMC_OPENSTATUSWINDOW     = &H0022

' dwAction for ImmNotifyIME
%NI_OPENCANDIDATE            = &H0010
%NI_CLOSECANDIDATE           = &H0011
%NI_SELECTCANDIDATESTR       = &H0012
%NI_CHANGECANDIDATELIST      = &H0013
%NI_FINALIZECONVERSIONRESULT = &H0014
%NI_COMPOSITIONSTR           = &H0015
%NI_SETCANDIDATE_PAGESTART   = &H0016
%NI_SETCANDIDATE_PAGESIZE    = &H0017
%NI_IMEMENUSELECTED          = &H0018

' lParam for WM_IME_SETCONTEXT
%ISC_SHOWUICANDIDATEWINDOW    = &H00000001
%ISC_SHOWUICOMPOSITIONWINDOW  = &H80000000
%ISC_SHOWUIGUIDELINE          = &H40000000
%ISC_SHOWUIALLCANDIDATEWINDOW = &H0000000F
%ISC_SHOWUIALL                = &HC000000F

' dwIndex for ImmNotifyIME/NI_COMPOSITIONSTR
%CPS_COMPLETE  = &H0001
%CPS_CONVERT   = &H0002
%CPS_REVERT    = &H0003
%CPS_CANCEL    = &H0004

' the modifiers of hot key
%MOD_ALT                 = &H0001
%MOD_CONTROL             = &H0002
%MOD_SHIFT               = &H0004

%MOD_LEFT                = &H8000
%MOD_RIGHT               = &H4000

%MOD_ON_KEYUP            = &H0800
%MOD_IGNORE_ALL_MODIFIER = &H0400

' Windows for Simplified Chinese Edition hot key ID from &H10 - &H2F
%IME_CHOTKEY_IME_NONIME_TOGGLE = &H10
%IME_CHOTKEY_SHAPE_TOGGLE      = &H11
%IME_CHOTKEY_SYMBOL_TOGGLE     = &H12

' Windows for Japanese Edition hot key ID from &H30 - &H4F
%IME_JHOTKEY_CLOSE_OPEN        = &H30

' Windows for Korean Edition hot key ID from &H50 - &H6F
%IME_KHOTKEY_SHAPE_TOGGLE      = &H50
%IME_KHOTKEY_HANJACONVERT      = &H51
%IME_KHOTKEY_ENGLISH           = &H52

' Windows for Traditional Chinese Edition hot key ID from &H70 - &H8F
%IME_THOTKEY_IME_NONIME_TOGGLE = &H70
%IME_THOTKEY_SHAPE_TOGGLE      = &H71
%IME_THOTKEY_SYMBOL_TOGGLE     = &H72

' direct switch hot key ID from &H100 - &H11F
%IME_HOTKEY_DSWITCH_FIRST      = &H100
%IME_HOTKEY_DSWITCH_LAST       = &H11F

' IME private hot key from &H200 - &H21F
%IME_ITHOTKEY_RESEND_RESULTSTR     = &H200
%IME_ITHOTKEY_PREVIOUS_COMPOSITION = &H201
%IME_ITHOTKEY_UISTYLE_TOGGLE       = &H202
%IME_ITHOTKEY_RECONVERTSTRING      = &H203
%IME_HOTKEY_PRIVATE_LAST           = &H21F

' dwSystemInfoFlag bits

' parameter of ImmGetCompositionString
%GCS_COMPREADSTR      = &H0001
%GCS_COMPREADATTR     = &H0002
%GCS_COMPREADCLAUSE   = &H0004
%GCS_COMPSTR          = &H0008
%GCS_COMPATTR         = &H0010
%GCS_COMPCLAUSE       = &H0020
%GCS_CURSORPOS        = &H0080
%GCS_DELTASTART       = &H0100
%GCS_RESULTREADSTR    = &H0200
%GCS_RESULTREADCLAUSE = &H0400
%GCS_RESULTSTR        = &H0800
%GCS_RESULTCLAUSE     = &H1000

' style bit flags for WM_IME_COMPOSITION
%CS_INSERTCHAR        = &H2000
%CS_NOMOVECARET       = &H4000

' bits of fdwInit of INPUTCONTEXT
' IME version constants
%IMEVER_0310            = &H0003000A
%IMEVER_0400            = &H00040000

' IME property bits
%IME_PROP_AT_CARET              = &H00010000
%IME_PROP_SPECIAL_UI            = &H00020000
%IME_PROP_CANDLIST_START_FROM_1 = &H00040000
%IME_PROP_UNICODE               = &H00080000
%IME_PROP_COMPLETE_ON_UNSELECT  = &H00100000

' IME UICapability bits
%UI_CAP_2700   = &H00000001
%UI_CAP_ROT90  = &H00000002
%UI_CAP_ROTANY = &H00000004

' ImmSetCompositionString Capability bits
%SCS_CAP_COMPSTR            = &H00000001
%SCS_CAP_MAKEREAD           = &H00000002
%SCS_CAP_SETRECONVERTSTRING = &H00000004

' IME WM_IME_SELECT inheritance Capability bits
%SELECT_CAP_CONVERSION = &H00000001
%SELECT_CAP_SENTENCE   = &H00000002

' ID for deIndex of ImmGetGuideLine
%GGL_LEVEL   = &H00000001
%GGL_INDEX   = &H00000002
%GGL_STRING  = &H00000003
%GGL_PRIVATE = &H00000004

' ID for dwLevel of GUIDELINE Structure
%GL_LEVEL_NOGUIDELINE = &H00000000
%GL_LEVEL_FATAL       = &H00000001
%GL_LEVEL_ERROR       = &H00000002
%GL_LEVEL_WARNING     = &H00000003
%GL_LEVEL_INFORMATION = &H00000004

' ID for dwIndex of GUIDELINE Structure
%GL_ID_UNKNOWN           = &H00000000
%GL_ID_NOMODULE          = &H00000001
%GL_ID_NODICTIONARY      = &H00000010
%GL_ID_CANNOTSAVE        = &H00000011
%GL_ID_NOCONVERT         = &H00000020
%GL_ID_TYPINGERROR       = &H00000021
%GL_ID_TOOMANYSTROKE     = &H00000022
%GL_ID_READINGCONFLICT   = &H00000023
%GL_ID_INPUTREADING      = &H00000024
%GL_ID_INPUTRADICAL      = &H00000025
%GL_ID_INPUTCODE         = &H00000026
%GL_ID_INPUTSYMBOL       = &H00000027
%GL_ID_CHOOSECANDIDATE   = &H00000028
%GL_ID_REVERSECONVERSION = &H00000029
%GL_ID_PRIVATE_FIRST     = &H00008000
%GL_ID_PRIVATE_LAST      = &H0000FFFF

' ID for dwIndex of ImmGetProperty
%IGP_GETIMEVERSION = &HFFFFFFFC???
%IGP_PROPERTY      = &H00000004
%IGP_CONVERSION    = &H00000008
%IGP_SENTENCE      = &H0000000C
%IGP_UI            = &H00000010
%IGP_SETCOMPSTR    = &H00000014
%IGP_SELECT        = &H00000018

' dwIndex for ImmSetCompositionString API
%SCS_SETSTR               = %GCS_COMPREADSTR OR %GCS_COMPSTR
%SCS_CHANGEATTR           = %GCS_COMPREADATTR OR %GCS_COMPATTR
%SCS_CHANGECLAUSE         = %GCS_COMPREADCLAUSE OR %GCS_COMPCLAUSE
%SCS_SETRECONVERTSTRING   = &H00010000
%SCS_QUERYRECONVERTSTRING = &H00020000

' attribute for COMPOSITIONSTRING Structure
%ATTR_INPUT               = &H00
%ATTR_TARGET_CONVERTED    = &H01
%ATTR_CONVERTED           = &H02
%ATTR_TARGET_NOTCONVERTED = &H03
%ATTR_INPUT_ERROR         = &H04
%ATTR_FIXEDCONVERTED      = &H05

' bit field for IMC_SETCOMPOSITIONWINDOW, IMC_SETCANDIDATEWINDOW
%CFS_DEFAULT        = &H0000
%CFS_RECT           = &H0001
%CFS_POINT          = &H0002
%CFS_SCREEN         = &H0004
%CFS_FORCE_POSITION = &H0020
%CFS_CANDIDATEPOS   = &H0040
%CFS_EXCLUDE        = &H0080

' conversion direction for ImmGetConversionList
%GCL_CONVERSION        = &H0001
%GCL_REVERSECONVERSION = &H0002
%GCL_REVERSE_LENGTH    = &H0003

'  bit field for conversion mode
%IME_CMODE_ALPHANUMERIC = &H0000
%IME_CMODE_NATIVE       = &H0001
%IME_CMODE_CHINESE      = %IME_CMODE_NATIVE
%IME_CMODE_HANGEUL      = %IME_CMODE_NATIVE ' old name of IME_CMODE_HANGUL
%IME_CMODE_JAPANESE     = %IME_CMODE_NATIVE
%IME_CMODE_KATAKANA     = &H0002       '  only effect under IME_CMODE_NATIVE
%IME_CMODE_LANGUAGE     = &H0003
%IME_CMODE_FULLSHAPE    = &H0008
%IME_CMODE_ROMAN        = &H0010
%IME_CMODE_CHARCODE     = &H0020
%IME_CMODE_HANJACONVERT = &H0040
%IME_CMODE_SOFTKBD      = &H0080
%IME_CMODE_NOCONVERSION = &H0100
%IME_CMODE_EUDC         = &H0200
%IME_CMODE_SYMBOL       = &H0400
%IME_CMODE_FIXED        = &H0800

%IME_SMODE_NONE          = &H0000
%IME_SMODE_PLAURALCLAUSE = &H0001
%IME_SMODE_SINGLECONVERT = &H0002
%IME_SMODE_AUTOMATIC     = &H0004
%IME_SMODE_PHRASEPREDICT = &H0008
%IME_SMODE_CONVERSATION  = &H0010

' style of candidate
%IME_CAND_UNKNOWN        = &H0000
%IME_CAND_READ           = &H0001
%IME_CAND_CODE           = &H0002
%IME_CAND_MEANING        = &H0003
%IME_CAND_RADICAL        = &H0004
%IME_CAND_STROKE         = &H0005

' wParam of report message WM_IME_NOTIFY
%IMN_CLOSESTATUSWINDOW    = &H0001
%IMN_OPENSTATUSWINDOW     = &H0002
%IMN_CHANGECANDIDATE      = &H0003
%IMN_CLOSECANDIDATE       = &H0004
%IMN_OPENCANDIDATE        = &H0005
%IMN_SETCONVERSIONMODE    = &H0006
%IMN_SETSENTENCEMODE      = &H0007
%IMN_SETOPENSTATUS        = &H0008
%IMN_SETCANDIDATEPOS      = &H0009
%IMN_SETCOMPOSITIONFONT   = &H000A
%IMN_SETCOMPOSITIONWINDOW = &H000B
%IMN_SETSTATUSWINDOWPOS   = &H000C
%IMN_GUIDELINE            = &H000D
%IMN_PRIVATE              = &H000E

' wParam of report message WM_IME_REQUEST
%IMR_COMPOSITIONWINDOW      = &H0001
%IMR_CANDIDATEWINDOW        = &H0002
%IMR_COMPOSITIONFONT        = &H0003
%IMR_RECONVERTSTRING        = &H0004
%IMR_CONFIRMRECONVERTSTRING = &H0005

' error code of ImmGetCompositionString
%IMM_ERROR_NODATA  = -1
%IMM_ERROR_GENERAL = -2

' dialog mode of ImmConfigureIME
%IME_CONFIG_GENERAL          = 1
%IME_CONFIG_REGISTERWORD     = 2
%IME_CONFIG_SELECTDICTIONARY = 3

' dialog mode of ImmEscape
%IME_ESC_QUERY_SUPPORT        = &H0003
%IME_ESC_RESERVED_FIRST       = &H0004
%IME_ESC_RESERVED_LAST        = &H07FF
%IME_ESC_PRIVATE_FIRST        = &H0800
%IME_ESC_PRIVATE_LAST         = &H0FFF
%IME_ESC_SEQUENCE_TO_INTERNAL = &H1001
%IME_ESC_GET_EUDC_DICTIONARY  = &H1003
%IME_ESC_SET_EUDC_DICTIONARY  = &H1004
%IME_ESC_MAX_KEY              = &H1005
%IME_ESC_IME_NAME             = &H1006
%IME_ESC_SYNC_HOTKEY          = &H1007
%IME_ESC_HANJA_MODE           = &H1008
%IME_ESC_PRIVATE_HOTKEY       = &H100A
%IME_ESC_GETHELPFILENAME      = &H100B

'  style of word registration
%IME_REGWORD_STYLE_EUDC       = &H1
%IME_REGWORD_STYLE_USER_FIRST = &H80000000
%IME_REGWORD_STYLE_USER_LAST  = &HFFFF

' dwFlags for ImmAssociateContextEx
%IACE_CHILDREN        = &H0001
%IACE_DEFAULT         = &H0010
%IACE_IGNORENOCONTEXT = &H0020

' dwFlags for ImmGetImeMenuItems
%IGIMIF_RIGHTMENU = &H0001

' dwType for ImmGetImeMenuItems
%IGIMII_CMODE      = &H0001
%IGIMII_SMODE      = &H0002
%IGIMII_CONFIGURE  = &H0004
%IGIMII_TOOLS      = &H0008
%IGIMII_HELP       = &H0010
%IGIMII_OTHER      = &H0020
%IGIMII_INPUTTOOLS = &H0040

' fType of IMEMENUITEMINFO structure
%IMFT_RADIOCHECK = &H00001
%IMFT_SEPARATOR  = &H00002
%IMFT_SUBMENU    = &H00004

' fState of IMEMENUITEMINFO structure
%IMFS_GRAYED    = %MFS_GRAYED
%IMFS_DISABLED  = %MFS_DISABLED
%IMFS_CHECKED   = %MFS_CHECKED
%IMFS_HILITE    = %MFS_HILITE
%IMFS_ENABLED   = %MFS_ENABLED
%IMFS_UNCHECKED = %MFS_UNCHECKED
%IMFS_UNHILITE  = %MFS_UNHILITE
%IMFS_DEFAULT   = %MFS_DEFAULT

' type of soft keyboard
' for Windows Traditional Chinese Edition
%SOFTKEYBOARD_TYPE_T1 = &H0001
' for Windows Simplified Chinese Edition
%SOFTKEYBOARD_TYPE_C1 = &H0002

' End of constants from imm.h =================================================

' Constants from ime.h ========================================================

%IME_MAXPROCESS = 32

%CP_HWND   = 0
%CP_OPEN   = 1
%CP_DIRECT = 2
%CP_LEVEL  = 3

' Virtual Keys
'
%VK_DBE_ALPHANUMERIC           = &H0F0
%VK_DBE_KATAKANA               = &H0F1
%VK_DBE_HIRAGANA               = &H0F2
%VK_DBE_SBCSCHAR               = &H0F3
%VK_DBE_DBCSCHAR               = &H0F4
%VK_DBE_ROMAN                  = &H0F5
%VK_DBE_NOROMAN                = &H0F6
%VK_DBE_ENTERWORDREGISTERMODE  = &H0F7
%VK_DBE_ENTERIMECONFIGMODE     = &H0F8
%VK_DBE_FLUSHSTRING            = &H0F9
%VK_DBE_CODEINPUT              = &H0FA
%VK_DBE_NOCODEINPUT            = &H0FB
%VK_DBE_DETERMINESTRING        = &H0FC
%VK_DBE_ENTERDLGCONVERSIONMODE = &H0FD

' switch for wParam of IME_SETCONVERSIONWINDOW
'
%MCW_DEFAULT  = &H00
%MCW_RECT     = &H01
%MCW_WINDOW   = &H02
%MCW_SCREEN   = &H04
%MCW_VERTICAL = &H08
%MCW_HIDDEN   = &H10

' switch for wParam of IME_SETCONVERSIONMODE and IME_GETCONVERSIONMODE
'
%IME_MODE_ALPHANUMERIC   = &H0001

#IF %DEF(%KOREA)
%IME_MODE_SBCSCHAR       = &H0002
#ELSE
%IME_MODE_SBCSCHAR       = &H0008
#ENDIF

%IME_MODE_KATAKANA       = &H0002
%IME_MODE_HIRAGANA       = &H0004
%IME_MODE_HANJACONVERT   = &H0004
%IME_MODE_DBCSCHAR       = &H0010
%IME_MODE_ROMAN          = &H0020
%IME_MODE_NOROMAN        = &H0040
%IME_MODE_CODEINPUT      = &H0080
%IME_MODE_NOCODEINPUT    = &H0100

'     IME APIs
'
%IME_GETIMECAPS            = &H03
%IME_SETOPEN               = &H04
%IME_GETOPEN               = &H05
%IME_GETVERSION            = &H07
%IME_SETCONVERSIONWINDOW   = &H08
%IME_MOVEIMEWINDOW         = %IME_SETCONVERSIONWINDOW  ' KOREA only
%IME_SETCONVERSIONMODE     = &H10

%IME_GETCONVERSIONMODE     = &H11
%IME_SET_MODE              = &H12    ' KOREA only
%IME_SENDVKEY              = &H13
%IME_ENTERWORDREGISTERMODE = &H18
%IME_SETCONVERSIONFONTEX   = &H19

'
' IME_CODECONVERT subfunctions
'
%IME_BANJAtoJUNJA = &H13    ' KOREA only
%IME_JUNJAtoBANJA = &H14    ' KOREA only
%IME_JOHABtoKS    = &H15    ' KOREA only
%IME_KStoJOHAB    = &H16    ' KOREA only

'
' IME_AUTOMATA subfunctions
'
%IMEA_INIT = &H01    ' KOREA only
%IMEA_NEXT = &H02    ' KOREA only
%IMEA_PREV = &H03    ' KOREA only

'
' IME_HANJAMODE subfunctions
'
%IME_REQUEST_CONVERT = &H01    ' KOREA only
%IME_ENABLE_CONVERT  = &H02    ' KOREA only

'
' IME_MOVEIMEWINDOW subfunctions
'
%INTERIM_WINDOW = &H00    ' KOREA only
%MODE_WINDOW    = &H01    ' KOREA only
%HANJA_WINDOW   = &H02    ' KOREA only

'
'    error code
'
%IME_RS_ERROR       = &H01    ' genetal error
%IME_RS_NOIME       = &H02    ' IME is not installed
%IME_RS_TOOLONG     = &H05    ' given string is too long
%IME_RS_ILLEGAL     = &H06    ' illegal charactor(s) is string
%IME_RS_NOTFOUND    = &H07    ' no (more) candidate
%IME_RS_NOROOM      = &H0A    ' no disk/memory space
%IME_RS_DISKERROR   = &H0E    ' disk I/O error
%IME_RS_INVALID     = &H11    ' Win3.1/NT
%IME_RS_NEST        = &H12    ' called nested
%IME_RS_SYSTEMMODAL = &H13    ' called when system mode

'
'   report messge from IME to WinApps
'
%WM_IME_REPORT = &H0280

'
'   report message parameter for WM_IME_REPORT
'
%IR_STRINGSTART   = &H100
%IR_STRINGEND     = &H101
%IR_OPENCONVERT   = &H120
%IR_CHANGECONVERT = &H121
%IR_CLOSECONVERT  = &H122
%IR_FULLCONVERT   = &H123
%IR_IMESELECT     = &H130
%IR_STRING        = &H140
%IR_DBCSCHAR      = &H160
%IR_UNDETERMINE   = &H170
%IR_STRINGEX      = &H180   ' New for 3.1
%IR_MODEINFO      = &H190

%WM_WNT_CONVERTREQUESTEX = &H0109  ' WM_CONVERTREQUESTEX: 109 for NT, 108 for OT
%WM_CONVERTREQUEST       = &H010A
%WM_CONVERTRESULT        = &H010B
%WM_INTERIM              = &H010C

%WM_IMEKEYDOWN           = &H290
%WM_IMEKEYUP             = &H291

' End of constants from ime.h =================================================

%WM_IME_STARTCOMPOSITION = &H010D
%WM_IME_ENDCOMPOSITION   = &H010E
%WM_IME_COMPOSITION      = &H010F
%WM_IME_KEYLAST          = &H010F

%WM_IME_SETCONTEXT       = &H0281
%WM_IME_NOTIFY           = &H0282
%WM_IME_CONTROL          = &H0283
%WM_IME_COMPOSITIONFULL  = &H0284
%WM_IME_SELECT           = &H0285
%WM_IME_CHAR             = &H0286
%WM_IME_REQUEST          = &H0288
%WM_IME_KEYDOWN          = &H290
%WM_IME_KEYUP            = &H291

'  Dial Options
%DIALOPTION_BILLING  = &H40     '  Supports wait for bong "$"
%DIALOPTION_QUIET    = &H80     '  Supports wait for quiet "@"
%DIALOPTION_DIALTONE = &H100    '  Supports wait for dial tone "W"

'  SpeakerVolume for MODEMDEVCAPS
%MDMVOLFLAG_LOW    = &H1
%MDMVOLFLAG_MEDIUM = &H2
%MDMVOLFLAG_HIGH   = &H4

'  SpeakerVolume for MODEMSETTINGS
%MDMVOL_LOW        = &H0
%MDMVOL_MEDIUM     = &H1
%MDMVOL_HIGH       = &H2

'  SpeakerMode for MODEMDEVCAPS
%MDMSPKRFLAG_OFF       = &H1
%MDMSPKRFLAG_DIAL      = &H2
%MDMSPKRFLAG_ON        = &H4
%MDMSPKRFLAG_CALLSETUP = &H8

'  SpeakerMode for MODEMSETTINGS
%MDMSPKR_OFF       = &H0
%MDMSPKR_DIAL      = &H1
%MDMSPKR_ON        = &H2
%MDMSPKR_CALLSETUP = &H3

'  Modem Options
%MDM_COMPRESSION      = &H1
%MDM_ERROR_CONTROL    = &H2
%MDM_FORCED_EC        = &H4
%MDM_CELLULAR         = &H8
%MDM_FLOWCONTROL_HARD = &H10
%MDM_FLOWCONTROL_SOFT = &H20
%MDM_CCITT_OVERRIDE   = &H40
%MDM_SPEED_ADJUST     = &H80
%MDM_TONE_DIAL        = &H100
%MDM_BLIND_DIAL       = &H200
%MDM_V23_OVERRIDE     = &H400

' AppBar stuff
%ABM_NEW              = &H00000000
%ABM_REMOVE           = &H00000001
%ABM_QUERYPOS         = &H00000002
%ABM_SETPOS           = &H00000003
%ABM_GETSTATE         = &H00000004
%ABM_GETTASKBARPOS    = &H00000005
%ABM_ACTIVATE         = &H00000006    '  lParam == TRUE/FALSE means activate/deactivate
%ABM_GETAUTOHIDEBAR   = &H00000007
%ABM_SETAUTOHIDEBAR   = &H00000008    '  this can fail at any time.  MUST check the result
                                      '  lParam = TRUE/FALSE  Set/Unset
                                      '  uEdge = what edge
%ABM_WINDOWPOSCHANGED = &H00000009


'  these are put in the wparam of callback messages
%ABN_STATECHANGE   = 0
%ABN_POSCHANGED    = 1
%ABN_FULLSCREENAPP = 2
%ABN_WINDOWARRANGE = 3 '  lParam == TRUE means hide

' flags for get state

%ABS_AUTOHIDE    = 1
%ABS_ALWAYSONTOP = 2

%ABE_LEFT   = 0
%ABE_TOP    = 1
%ABE_RIGHT  = 2
%ABE_BOTTOM = 3

%EIRESID   = -1

' Shell File Operations

%FO_MOVE   = &H1
%FO_COPY   = &H2
%FO_DELETE = &H3
%FO_RENAME = &H4

%FOF_MULTIDESTFILES        = &H0001
%FOF_CONFIRMMOUSE          = &H0002
%FOF_SILENT                = &H0004  ' don't create progress/report
%FOF_RENAMEONCOLLISION     = &H0008
%FOF_NOCONFIRMATION        = &H0010  ' Don't prompt the user.
%FOF_WANTMAPPINGHANDLE     = &H0020  ' Fill in SHFILEOPSTRUCT.hNameMappings
                                     ' Must be freed using SHFreeNameMappings
%FOF_ALLOWUNDO             = &H0040
%FOF_FILESONLY             = &H0080  ' on *.*, do only files
%FOF_SIMPLEPROGRESS        = &H0100  ' means don't show names of files
%FOF_NOCONFIRMMKDIR        = &H0200  ' don't confirm making any needed dirs
%FOF_NOERRORUI             = &H0400  ' don't put up error UI
%FOF_NOCOPYSECURITYATTRIBS = &H0800  ' don't copy NT file Security Attributes

%PO_DELETE     = &H0013   ' printer is being deleted
%PO_RENAME     = &H0014   ' printer is being renamed
%PO_PORTCHANGE = &H0020   ' port this printer connected to is being changed
                          ' if this id is set, the strings received by
                          ' the copyhook are a doubly-null terminated
                          ' list of strings.  The first is the printer
                          ' name and the second is the printer port.
%PO_REN_PORT   = &H0034   ' PO_RENAME and PO_PORTCHANGE at same time.

'  no POF_ flags currently defined

'  regular WinExec() codes
%SE_ERR_FNF          = 2      ' file not found
%SE_ERR_PNF          = 3      ' path not found
%SE_ERR_ACCESSDENIED = 5      ' access denied
%SE_ERR_OOM          = 8      ' out of memory
%SE_ERR_DLLNOTFOUND  = 32

%SE_ERR_SHARE            = 26
%SE_ERR_ASSOCINCOMPLETE  = 27
%SE_ERR_DDETIMEOUT       = 28
%SE_ERR_DDEFAIL          = 29
%SE_ERR_DDEBUSY          = 30
%SE_ERR_NOASSOC          = 31


'  Note CLASSKEY overrides CLASSNAME
%SEE_MASK_CLASSNAME      = &H00000001
%SEE_MASK_CLASSKEY       = &H00000003

'  Note INVOKEIDLIST overrides IDLIST
%SEE_MASK_IDLIST         = &H00000004
%SEE_MASK_INVOKEIDLIST   = &H0000000C
%SEE_MASK_ICON           = &H00000010
%SEE_MASK_HOTKEY         = &H00000020
%SEE_MASK_NOCLOSEPROCESS = &H00000040
%SEE_MASK_CONNECTNETDRV  = &H00000080
%SEE_MASK_FLAG_DDEWAIT   = &H00000100
%SEE_MASK_DOENVSUBST     = &H00000200
%SEE_MASK_FLAG_NO_UI     = &H00000400
%SEE_MASK_UNICODE        = &H00004000
%SEE_MASK_NO_CONSOLE     = &H00008000
%SEE_MASK_ASYNCOK        = &H00100000
%SEE_MASK_HMONITOR       = &H00200000

' flags for SHEmptyRecycleBin
'
%SHERB_NOCONFIRMATION    = &H00000001
%SHERB_NOPROGRESSUI      = &H00000002
%SHERB_NOSOUND           = &H00000004


%NIM_ADD     = &H00000000
%NIM_MODIFY  = &H00000001
%NIM_DELETE  = &H00000002

%NIF_MESSAGE = &H00000001
%NIF_ICON    = &H00000002
%NIF_TIP     = &H00000004

%SHGFI_ICON              = &H00000100  ' get icon
%SHGFI_DISPLAYNAME       = &H00000200  ' get display name
%SHGFI_TYPENAME          = &H00000400  ' get type name
%SHGFI_ATTRIBUTES        = &H00000800  ' get attributes
%SHGFI_ICONLOCATION      = &H00001000  ' get icon location
%SHGFI_EXETYPE           = &H00002000  ' return exe type
%SHGFI_SYSICONINDEX      = &H00004000  ' get system icon index
%SHGFI_LINKOVERLAY       = &H00008000  ' put a link overlay on icon
%SHGFI_SELECTED          = &H00010000  ' show icon in selected state
%SHGFI_ATTR_SPECIFIED    = &H00020000  ' get only specified attributes

%SHGFI_LARGEICON         = &H00000000  ' get large icon
%SHGFI_SMALLICON         = &H00000001  ' get small icon
%SHGFI_OPENICON          = &H00000002  ' get open icon
%SHGFI_SHELLICONSIZE     = &H00000004  ' get shell size icon
%SHGFI_PIDL              = &H00000008  ' pszPath is a pidl
%SHGFI_USEFILEATTRIBUTES = &H00000010  ' use passed dwFileAttribute

%SHGFI_ADDOVERLAYS       = &H00000020  ' apply the appropriate overlays
%SHGFI_OVERLAYINDEX      = &H00000040  ' Get the index of the overlay
                                       ' in the upper 8 bits of the iIcon

%SHGNLI_PIDL             = &H00000001  ' pszLinkTo is a pidl
%SHGNLI_PREFIXNAME       = &H00000002  ' Make name "Shortcut to xxx"
%SHGNLI_NOUNIQUE         = &H00000004  ' don't do the unique name generation

'  File System Notification flags

%SHCNE_RENAMEITEM       = &H00000001&
%SHCNE_CREATE           = &H00000002&
%SHCNE_DELETE           = &H00000004&
%SHCNE_MKDIR            = &H00000008&
%SHCNE_RMDIR            = &H00000010&
%SHCNE_MEDIAINSERTED    = &H00000020&
%SHCNE_MEDIAREMOVED     = &H00000040&
%SHCNE_DRIVEREMOVED     = &H00000080&
%SHCNE_DRIVEADD         = &H00000100&
%SHCNE_NETSHARE         = &H00000200&
%SHCNE_NETUNSHARE       = &H00000400&
%SHCNE_ATTRIBUTES       = &H00000800&
%SHCNE_UPDATEDIR        = &H00001000&
%SHCNE_UPDATEITEM       = &H00002000&
%SHCNE_SERVERDISCONNECT = &H00004000&
%SHCNE_UPDATEIMAGE      = &H00008000&
%SHCNE_DRIVEADDGUI      = &H00010000&
%SHCNE_RENAMEFOLDER     = &H00020000&
%SHCNE_FREESPACE        = &H00040000&

' SHCNE_EXTENDED_EVENT: the extended event is identified in dwItem1,
' packed in LPITEMIDLIST format (same as SHCNF_DWORD packing).
' Additional information can be passed in the dwItem2 parameter
' of SHChangeNotify (called "pidl2" below), which if present, must also
' be in LPITEMIDLIST format.
'
' Unlike the standard events, the extended events are ORDINALs, so we
' don't run out of bits.  Extended events follow the SHCNEE_* naming
' convention.
'
' The dwItem2 parameter varies according to the extended event.

%SHCNE_EXTENDED_EVENT   = &H04000000&

%SHCNE_ASSOCCHANGED     = &H08000000&

%SHCNE_DISKEVENTS       = &H0002381F&
%SHCNE_GLOBALEVENTS     = &H0C0581E0& ' Events that dont match pidls first
%SHCNE_ALLEVENTS        = &H7FFFFFFF&
%SHCNE_INTERRUPT        = &H80000000&  ' The presence of this flag indicates
                                       ' that the event was generated by an
                                       ' interrupt.  It is stripped out before
                                       ' the clients of SHCNNotify_ see it.

' SHCNE_EXTENDED_EVENT extended events.  These events are ordinals.
' This is not a bitfield.

%SHCNEE_ORDERCHANGED  = 2 ' pidl2 is the changed folder
%SHCNEE_MSI_CHANGE    = 4 ' pidl2 is a SHChangeProductKeyAsIDList
%SHCNEE_MSI_UNINSTALL = 5 ' pidl2 is a SHChangeProductKeyAsIDList


' Flags
' uFlags & SHCNF_TYPE is an ID which indicates what dwItem1 and dwItem2 mean
%SHCNF_IDLIST      = &H0000     ' LPITEMIDLIST
%SHCNF_PATHA       = &H0001     ' path name
%SHCNF_PRINTERA    = &H0002     ' printer friendly name
%SHCNF_DWORD       = &H0003     ' DWORD
%SHCNF_PATHW       = &H0005     ' path name
%SHCNF_PRINTERW    = &H0006     ' printer friendly name
%SHCNF_TYPE        = &H00FF
%SHCNF_FLUSH       = &H1000
%SHCNF_FLUSHNOWAIT = &H2000


' Printer stuff
'
%PRINTACTION_OPEN             = 0
%PRINTACTION_PROPERTIES       = 1
%PRINTACTION_NETINSTALL       = 2
%PRINTACTION_NETINSTALLLINK   = 3
%PRINTACTION_TESTPAGE         = 4
%PRINTACTION_OPENNETPRN       = 5
%PRINTACTION_DOCUMENTDEFAULTS = 6
%PRINTACTION_SERVERPROPERTIES = 7



'  ----- Symbols -----
%VS_VERSION_INFO = 1
%VS_USER_DEFINED = 100

'  ----- VS_VERSION.dwFileFlags -----
%VS_FFI_SIGNATURE     = &HFEEF04BD
%VS_FFI_STRUCVERSION  = &H10000
%VS_FFI_FILEFLAGSMASK = &H3F&

'  ----- VS_VERSION.dwFileFlags -----
%VS_FF_DEBUG        = &H1&
%VS_FF_PRERELEASE   = &H2&
%VS_FF_PATCHED      = &H4&
%VS_FF_PRIVATEBUILD = &H8&
%VS_FF_INFOINFERRED = &H10&
%VS_FF_SPECIALBUILD = &H20&

'  ----- VS_VERSION.dwFileOS -----
%VOS_UNKNOWN       = &H0&
%VOS_DOS           = &H10000
%VOS_OS216         = &H20000
%VOS_OS232         = &H30000
%VOS_NT            = &H40000

%VOS__BASE         = &H0&
%VOS__WINDOWS16    = &H1&
%VOS__PM16         = &H2&
%VOS__PM32         = &H3&
%VOS__WINDOWS32    = &H4&

%VOS_DOS_WINDOWS16 = &H10001
%VOS_DOS_WINDOWS32 = &H10004
%VOS_OS216_PM16    = &H20002
%VOS_OS232_PM32    = &H30003
%VOS_NT_WINDOWS32  = &H40004

'  ----- VS_VERSION.dwFileType -----
%VFT_UNKNOWN    = &H0&
%VFT_APP        = &H1&
%VFT_DLL        = &H2&
%VFT_DRV        = &H3&
%VFT_FONT       = &H4&
%VFT_VXD        = &H5&
%VFT_STATIC_LIB = &H7&

'  ----- VS_VERSION.dwFileSubtype for VFT_WINDOWS_DRV -----
%VFT2_UNKNOWN         = &H0&
%VFT2_DRV_PRINTER     = &H1&
%VFT2_DRV_KEYBOARD    = &H2&
%VFT2_DRV_LANGUAGE    = &H3&
%VFT2_DRV_DISPLAY     = &H4&
%VFT2_DRV_MOUSE       = &H5&
%VFT2_DRV_NETWORK     = &H6&
%VFT2_DRV_SYSTEM      = &H7&
%VFT2_DRV_INSTALLABLE = &H8&
%VFT2_DRV_SOUND       = &H9&
%VFT2_DRV_COMM        = &HA&
%VFT2_DRV_INPUTMETHOD = &HB&

'  ----- VS_VERSION.dwFileSubtype for VFT_WINDOWS_FONT -----
%VFT2_FONT_RASTER     = &H1&
%VFT2_FONT_VECTOR     = &H2&
%VFT2_FONT_TRUETYPE   = &H3&

'  ----- VerFindFile() flags -----
%VFFF_ISSHAREDFILE = &H1

%VFF_CURNEDEST    = &H1
%VFF_FILEINUSE    = &H2
%VFF_BUFFTOOSMALL = &H4

'  ----- VerInstallFile() flags -----
%VIFF_FORCEINSTALL  = &H1
%VIFF_DONTDELETEOLD = &H2

%VIF_TEMPFILE         = &H1&
%VIF_MISMATCH         = &H2&
%VIF_SRCOLD           = &H4&

%VIF_DIFFLANG         = &H8&
%VIF_DIFFCODEPG       = &H10&
%VIF_DIFFTYPE         = &H20&

%VIF_WRITEPROT        = &H40&
%VIF_FILEINUSE        = &H80&
%VIF_OUTOFSPACE       = &H100&
%VIF_ACCESSVIOLATION  = &H200&
%VIF_SHARINGVIOLATION = &H400&
%VIF_CANNOTCREATE     = &H800&
%VIF_CANNOTDELETE     = &H1000&
%VIF_CANNOTRENAME     = &H2000&
%VIF_CANNOTDELETECUR  = &H4000&
%VIF_OUTOFMEMORY      = &H8000&

%VIF_CANNOTREADSRC    = &H10000
%VIF_CANNOTREADDST    = &H20000
%VIF_BUFFTOOSMALL     = &H40000

%PROCESS_HEAP_REGION            = &H1
%PROCESS_HEAP_UNCOMMITTED_RANGE = &H2
%PROCESS_HEAP_ENTRY_BUSY        = &H4
%PROCESS_HEAP_ENTRY_MOVEABLE    = &H10
%PROCESS_HEAP_ENTRY_DDESHARE    = &H20

%NORMAL_PRIORITY_CLASS      = &H00000020
%IDLE_PRIORITY_CLASS        = &H00000040
%HIGH_PRIORITY_CLASS        = &H00000080
%REALTIME_PRIORITY_CLASS    = &H00000100
%CREATE_NEW_PROCESS_GROUP   = &H00000200
%CREATE_UNICODE_ENVIRONMENT = &H00000400
%CREATE_SEPARATE_WOW_VDM    = &H00000800
%CREATE_SHARED_WOW_VDM      = &H00001000
%CREATE_DEFAULT_ERROR_MODE  = &H04000000

'  GetBinaryType return values.

%SCS_32BIT_BINARY = 0
%SCS_DOS_BINARY   = 1
%SCS_WOW_BINARY   = 2
%SCS_PIF_BINARY   = 3
%SCS_POSIX_BINARY = 4
%SCS_OS216_BINARY = 5

'  Logon Support APIs

%LOGON32_LOGON_INTERACTIVE = 2
%LOGON32_LOGON_BATCH       = 4
%LOGON32_LOGON_SERVICE     = 5

%LOGON32_PROVIDER_DEFAULT  = 0
%LOGON32_PROVIDER_WINNT35  = 1
%LOGON32_PROVIDER_WINNT40  = 2
%LOGON32_PROVIDER_WINNT50  = 3

' Microsoft docs and structures identify these as WORD values, although
' they obviously aren't defined that way...!
'
%VER_SERVER_NT                      = &H80000000
%VER_WORKSTATION_NT                 = &H40000000
%VER_SUITE_SMALLBUSINESS            = &H00000001
%VER_SUITE_ENTERPRISE               = &H00000002
%VER_SUITE_BACKOFFICE               = &H00000004
%VER_SUITE_COMMUNICATIONS           = &H00000008
%VER_SUITE_TERMINAL                 = &H00000010
%VER_SUITE_SMALLBUSINESS_RESTRICTED = &H00000020
%VER_SUITE_EMBEDDEDNT               = &H00000040
%VER_SUITE_DATACENTER               = &H00000080
%VER_SUITE_SINGLEUSERTS             = &H00000100

' RtlVerifyVersionInfo() conditions

%VER_EQUAL         = 1
%VER_GREATER       = 2
%VER_GREATER_EQUAL = 3
%VER_LESS          = 4
%VER_LESS_EQUAL    = 5
%VER_AND           = 6
%VER_OR            = 7

%VER_CONDITION_MASK              = 7
%VER_NUM_BITS_PER_CONDITION_MASK = 3

' RtlVerifyVersionInfo() type mask bits

%VER_MINORVERSION     = &H0000001
%VER_MAJORVERSION     = &H0000002
%VER_BUILDNUMBER      = &H0000004
%VER_PLATFORMID       = &H0000008
%VER_SERVICEPACKMINOR = &H0000010
%VER_SERVICEPACKMAJOR = &H0000020
%VER_SUITENAME        = &H0000040
%VER_PRODUCT_TYPE     = &H0000080

' RtlVerifyVersionInfo() os product type values

%VER_NT_WORKSTATION       = &H0000001
%VER_NT_DOMAIN_CONTROLLER = &H0000002
%VER_NT_SERVER            = &H0000003

' dwPlatformId defines:

%VER_PLATFORM_WIN32s        = 0
%VER_PLATFORM_WIN32_WINDOWS = 1
%VER_PLATFORM_WIN32_NT      = 2

' Power Management APIs

%AC_LINE_OFFLINE      = &H0
%AC_LINE_ONLINE       = &H1
%AC_LINE_BACKUP_POWER = &H2
%AC_LINE_UNKNOWN      = &HFF

%BATTERY_FLAG_HIGH       = &H1
%BATTERY_FLAG_LOW        = &H2
%BATTERY_FLAG_CRITICAL   = &H4
%BATTERY_FLAG_CHARGING   = &H8
%BATTERY_FLAG_NO_BATTERY = &H80
%BATTERY_FLAG_UNKNOWN    = &HFF

%BATTERY_PERCENTAGE_UNKNOWN = &HFF

%BATTERY_LIFE_UNKNOWN    = &HFFFFFFFF???

%CDM_FIRST           = %WM_USER + 100
%CDM_LAST            = %WM_USER + 200
%CDM_GETSPEC         = %CDM_FIRST + &H0
%CDM_GETFILEPATH     = %CDM_FIRST + &H1
%CDM_GETFOLDERPATH   = %CDM_FIRST + &H2
%CDM_GETFOLDERIDLIST = %CDM_FIRST + &H3
%CDM_SETCONTROLTEXT  = %CDM_FIRST + &H4
%CDM_HIDECONTROL     = %CDM_FIRST + &H5
%CDM_SETDEFEXT       = %CDM_FIRST + &H6

%SIMULATED_FONTTYPE = &H8000
%PRINTER_FONTTYPE   = &H4000
%SCREEN_FONTTYPE    = &H2000
%BOLD_FONTTYPE      = &H100
%ITALIC_FONTTYPE    = &H200
%REGULAR_FONTTYPE   = &H400

%WM_PSD_PAGESETUPDLG   = %WM_USER
%WM_PSD_FULLPAGERECT   = %WM_USER + 1
%WM_PSD_MINMARGINRECT  = %WM_USER + 2
%WM_PSD_MARGINRECT     = %WM_USER + 3
%WM_PSD_GREEKTEXTRECT  = %WM_USER + 4
%WM_PSD_ENVSTAMPRECT   = %WM_USER + 5
%WM_PSD_YAFULLPAGERECT = %WM_USER + 6

$CFSEPCHAR                  = "+"  '  compound file name separator char.
$COLOROKSTRING              = "commdlg_ColorOK"
$FILEOKSTRING               = "commdlg_FileNameOK"
$FINDMSGSTRING              = "commdlg_FindReplace"
$HELPMSGSTRING              = "commdlg_help"
$LBSELCHSTRING              = "commdlg_LBSelChangedNotify"
$SC_GROUP_IDENTIFIER        = "+"
$SERVICES_ACTIVE_DATABASE   = "ServicesActive"
$SERVICES_FAILED_DATABASE   = "ServicesFailed"
$SETRGBSTRING               = "commdlg_SetRGBColor"
$SHAREVISTRING              = "commdlg_ShareViolation"
$SZDDESYS_ITEM_FORMATS      = "Formats"
$SZDDESYS_ITEM_HELP         = "Help"
$SZDDESYS_ITEM_RTNMSG       = "ReturnMessage"
$SZDDESYS_ITEM_STATUS       = "Status"
$SZDDESYS_ITEM_SYSITEMS     = "SysItems"
$SZDDESYS_ITEM_TOPICS       = "Topics"
$SZDDESYS_TOPIC             = "System"
$SZDDE_ITEM_ITEMLIST        = "TopicItemList"

'====== WM_NOTIFY codes (NMHDR.code values) =[ or not: see winbase.h ]========

%NM_FIRST = 0            ' generic to all controls
%NM_LAST  = -99&

%DBG_CONTINUE              = &H00010002&
%DBG_TERMINATE_THREAD      = &H40010003&
%DBG_TERMINATE_PROCESS     = &H40010004&
%DBG_CONTROL_C             = &H40010005&
%DBG_CONTROL_BREAK         = &H40010008&
%DBG_EXCEPTION_NOT_HANDLED = &H80010001&

%WAIT_FAILED      = &HFFFFFFFF???
%WAIT_OBJECT_0    = %STATUS_WAIT_0
%WAIT_ABANDONED   = %STATUS_ABANDONED_WAIT_0
%WAIT_ABANDONED_0 = %STATUS_ABANDONED_WAIT_0

%WAIT_IO_COMPLETION              = %STATUS_USER_APC

%EXCEPTION_CONTINUABLE           = 0      ' Continuable exception

%EXCEPTION_ACCESS_VIOLATION      = %STATUS_ACCESS_VIOLATION
%EXCEPTION_DATATYPE_MISALIGNMENT = %STATUS_DATATYPE_MISALIGNMENT
%EXCEPTION_BREAKPOINT            = %STATUS_BREAKPOINT
%EXCEPTION_SINGLE_STEP           = %STATUS_SINGLE_STEP
%EXCEPTION_ARRAY_BOUNDS_EXCEEDED = %STATUS_ARRAY_BOUNDS_EXCEEDED
%EXCEPTION_FLT_DENORMAL_OPERAND  = %STATUS_FLOAT_DENORMAL_OPERAND
%EXCEPTION_FLT_DIVIDE_BY_ZERO    = %STATUS_FLOAT_DIVIDE_BY_ZERO
%EXCEPTION_FLT_INEXACT_RESULT    = %STATUS_FLOAT_INEXACT_RESULT
%EXCEPTION_FLT_INVALID_OPERATION = %STATUS_FLOAT_INVALID_OPERATION
%EXCEPTION_FLT_OVERFLOW          = %STATUS_FLOAT_OVERFLOW
%EXCEPTION_FLT_STACK_CHECK       = %STATUS_FLOAT_STACK_CHECK
%EXCEPTION_FLT_UNDERFLOW         = %STATUS_FLOAT_UNDERFLOW
%EXCEPTION_INT_DIVIDE_BY_ZERO    = %STATUS_INTEGER_DIVIDE_BY_ZERO
%EXCEPTION_INT_OVERFLOW          = %STATUS_INTEGER_OVERFLOW
%EXCEPTION_PRIV_INSTRUCTION      = %STATUS_PRIVILEGED_INSTRUCTION
%EXCEPTION_IN_PAGE_ERROR         = %STATUS_IN_PAGE_ERROR

' Directory Entries

%IMAGE_DIRECTORY_ENTRY_EXPORT       =  0   ' Export Directory
%IMAGE_DIRECTORY_ENTRY_IMPORT       =  1   ' Import Directory
%IMAGE_DIRECTORY_ENTRY_RESOURCE     =  2   ' Resource Directory
%IMAGE_DIRECTORY_ENTRY_EXCEPTION    =  3   ' Exception Directory
%IMAGE_DIRECTORY_ENTRY_SECURITY     =  4   ' Security Directory
%IMAGE_DIRECTORY_ENTRY_BASERELOC    =  5   ' Base Relocation Table
%IMAGE_DIRECTORY_ENTRY_DEBUG        =  6   ' Debug Directory
%IMAGE_DIRECTORY_ENTRY_COPYRIGHT    =  7   ' Description String
%IMAGE_DIRECTORY_ENTRY_GLOBALPTR    =  8   ' Machine Value (MIPS GP)
%IMAGE_DIRECTORY_ENTRY_TLS          =  9   ' TLS Directory
%IMAGE_DIRECTORY_ENTRY_LOAD_CONFIG  = 10   ' Load Configuration Directory
%IMAGE_DIRECTORY_ENTRY_BOUND_IMPORT = 11   ' Bound Import Directory in headers
%IMAGE_DIRECTORY_ENTRY_IAT          = 12   ' Import Address Table
%IMAGE_DIRECTORY_ENTRY_DELAY_IMPORT   = 13   ' Delay Load Import Descriptors
%IMAGE_DIRECTORY_ENTRY_COM_DESCRIPTOR = 14   ' COM Runtime descriptor
%IMAGE_NUMBEROF_DIRECTORY_ENTRIES   = 16

%IMAGE_BITMAP                       = 0
%IMAGE_ICON                         = 1
%IMAGE_CURSOR                       = 2
%IMAGE_ENHMETAFILE                  = 3

%VT_EMPTY           = 0
%VT_NULL            = 1
%VT_I2              = 2
%VT_I4              = 3
%VT_R4              = 4
%VT_R8              = 5
%VT_CY              = 6
%VT_DATE            = 7
%VT_BSTR            = 8
%VT_DISPATCH        = 9
%VT_ERROR           = 10
%VT_BOOL            = 11
%VT_VARIANT         = 12
%VT_UNKNOWN         = 13
%VT_I1              = 16
%VT_UI1             = 17
%VT_UI2             = 18
%VT_UI4             = 19
%VT_I8              = 20
%VT_UI8             = 21
%VT_INT             = 22
%VT_UINT            = 23
%VT_VOID            = 24
%VT_HRESULT         = 25
%VT_PTR             = 26
%VT_SAFEARRAY       = 27
%VT_CARRAY          = 28
%VT_USERDEFINED     = 29
%VT_LPSTR           = 30
%VT_LPWSTR          = 31
%VT_FILETIME        = 64
%VT_BLOB            = 65
%VT_STREAM          = 66
%VT_STORAGE         = 67
%VT_STREAMED_OBJECT = 68
%VT_STORED_OBJECT   = 69
%VT_BLOB_OBJECT     = 70
%VT_CF              = 71
%VT_CLSID           = 72

%VT_VECTOR          = &H1000
%VT_ARRAY           = &H2000
%VT_BYREF           = &H4000
%VT_RESERVED        = &H8000

' Plug-and-Play API's

%HW_PROFILE_GUIDLEN = 39    ' 36-characters plus NULL terminator
%MAX_PROFILE_LEN    = 80

%DOCKINFO_UNDOCKED      = &H1
%DOCKINFO_DOCKED        = &H2
%DOCKINFO_USER_SUPPLIED = &H4
%DOCKINFO_USER_UNDOCKED = %DOCKINFO_USER_SUPPLIED OR %DOCKINFO_UNDOCKED
%DOCKINFO_USER_DOCKED   = %DOCKINFO_USER_SUPPLIED OR %DOCKINFO_DOCKED

%MAX_COMPUTERNAME_LENGTH = 15

%GA_PARENT    = 1
%GA_ROOT      = 2
%GA_ROOTOWNER = 3

TYPE RECT
  nLeft AS LONG
  nTop AS LONG
  nRight AS LONG
  nBottom AS LONG
END TYPE

TYPE RECTL
  nLeft AS LONG
  nTop AS LONG
  nRight AS LONG
  nBottom AS LONG
END TYPE

UNION VARIANTDATA
  bVal AS BYTE            ' VT_UI1
  iVal AS INTEGER         ' VT_I2
  lVal AS LONG            ' VT_I4
  fltVal AS SINGLE        ' VT_R4
  dblVal AS DOUBLE        ' VT_R8
  boolVal AS INTEGER      ' VT_BOOL
  scode AS LONG           ' VT_ERROR
  cyVal AS LONG           ' VT_CY
  date AS DOUBLE          ' VT_DATE
  bstrVal AS LONG         ' VT_BSTR
  punkVal AS DWORD        ' VT_UNKNOWN
  pdispVal AS DWORD       ' VT_DISPATCH
  parray AS DWORD         ' VT_ARRAY|*
  pbVal AS BYTE PTR       ' VT_BYREF|VT_UI1
  piVal AS INTEGER PTR    ' VT_BYREF|VT_I2
  plVal AS LONG PTR       ' VT_BYREF|VT_I4
  pfltVal AS SINGLE PTR   ' VT_BYREF|VT_R4
  pdblVal AS DOUBLE PTR   ' VT_BYREF|VT_R8
  pboolVal AS INTEGER PTR ' VT_BYREF|VT_BOOL
  pscode AS LONG PTR      ' VT_BYREF|VT_ERROR
  pcyVal AS LONG PTR      ' VT_BYREF|VT_CY
  pdate AS DOUBLE PTR     ' VT_BYREF|VT_DATE
  pbstrVal AS LONG PTR    ' VT_BYREF|VT_BSTR
  ppunkVal AS DWORD PTR   ' VT_BYREF|VT_UNKNOWN
  ppdispVal AS DWORD PTR  ' VT_BYREF|VT_DISPATCH
  psArray AS DWORD PTR    ' VT_ARRAY|*
  pVariant AS DWORD PTR   ' VT_BYREF|VT_VARIANT
  pByRef AS DWORD         ' Generic ByRef
END UNION

TYPE VARIANTAPI
  vt         AS WORD  'VARTYPE
  wReserved1 AS WORD
  wReserved2 AS WORD
  wReserved3 AS WORD
  vd         AS VARIANTDATA
END TYPE

TYPE HIGHCONTRAST
  cbSize AS DWORD
  dwFlags AS DWORD
  lpszDefaultScheme AS ASCIIZ PTR
END TYPE

' Accessibility support

TYPE FILTERKEYS
  cbSize AS DWORD
  dwFlags AS DWORD
  iWaitMSec AS DWORD    ' Acceptance Delay
  iDelayMSec AS DWORD   ' Delay Until Repeat
  iRepeatMSec AS DWORD  ' Repeat Rate
  iBounceMSec AS DWORD  ' Debounce Time
END TYPE

TYPE STICKYKEYS
  cbSize AS DWORD
  dwFlags AS DWORD
END TYPE

TYPE MOUSEKEYS
  cbSize AS DWORD
  dwFlags AS DWORD
  iMaxSpeed AS DWORD
  iTimeToMaxSpeed AS DWORD
  iCtrlSpeed AS DWORD
  dwReserved1 AS DWORD
  dwReserved2 AS DWORD
END TYPE

TYPE ACCESSTIMEOUT
  cbSize AS DWORD
  dwFlags AS DWORD
  iTimeOutMSec AS DWORD
END TYPE

TYPE SOUNDSENTRY
  cbSize AS DWORD
  dwFlags AS DWORD
  iFSTextEffect AS DWORD
  iFSTextEffectMSec AS DWORD
  iFSTextEffectColorBits AS DWORD
  iFSGrafEffect AS DWORD
  iFSGrafEffectMSec AS DWORD
  iFSGrafEffectColor AS DWORD
  iWindowsEffect AS DWORD
  iWindowsEffectMSec AS DWORD
  lpszWindowsEffectDLL AS ASCIIZ PTR
  iWindowsEffectOrdinal AS DWORD
END TYPE

TYPE TOGGLEKEYS
  cbSize AS DWORD
  dwFlags AS DWORD
END TYPE

TYPE MONITORINFO
  cbSize AS DWORD
  rcMonitor AS RECT
  rcWork AS RECT
  dwFlags AS DWORD
END TYPE

#IF NOT %DEF(%NOGDI)
TYPE MONITORINFOEX
  cbSize AS DWORD
  rcMonitor AS RECT
  rcWork AS RECT
  dwFlags AS DWORD
  szDevice AS ASCIIZ * %CCHDEVICENAME
END TYPE
#ENDIF

TYPE POINTAPI
  x AS LONG
  y AS LONG
END TYPE

TYPE POINTL
  x AS LONG
  y AS LONG
END TYPE

TYPE apiSIZE
  cx AS LONG
  cy AS LONG
END TYPE

TYPE SIZEL
  cx AS LONG
  cy AS LONG
END TYPE

TYPE POINTS
  x AS INTEGER
  y AS INTEGER
END TYPE

TYPE tagMSG
  hwnd AS DWORD
  message AS DWORD
  wParam AS DWORD
  lParam AS DWORD
  time AS DWORD
  pt AS POINTAPI
END TYPE

' Structure that defines the header of the Eventlog record. This is the
' fixed-sized portion before all the variable-length strings, binary
' data and pad bytes.
'
' TimeGenerated is the time it was generated at the client.
' TimeWritten is the time it was put into the log at the server end.

TYPE EVENTLOGRECORD
  Length AS DWORD              ' Length of full record
  Reserved AS DWORD            ' Used by the service
  RecordNumber AS DWORD        ' Absolute record number
  TimeGenerated AS DWORD       ' Seconds since 1-1-1970
  TimeWritten AS DWORD         ' Seconds since 1-1-1970
  EventID AS DWORD
  EventType AS WORD
  NumStrings AS WORD
  EventCategory AS WORD
  ReservedFlags AS WORD        ' For use with paired events (auditing)
  ClosingRecordNumber AS DWORD ' For use with paired events (auditing)
  StringOffset AS DWORD        ' Offset from beginning of record
  UserSidLength AS DWORD
  UserSidOffset AS DWORD
  DataLength AS DWORD
  DataOffset AS DWORD          ' Offset from beginning of record
  '
  ' Then follow:
  '
  ' WCHAR SourceName[]
  ' WCHAR Computername[]
  ' SID   UserSid
  ' WCHAR Strings[]
  ' BYTE  Data[]
  ' CHAR  Pad[]
  ' DWORD Length;
END TYPE

TYPE OVERLAPPED
  Internal AS DWORD
  InternalHigh AS DWORD
  offset AS DWORD
  OffsetHigh AS DWORD
  hEvent AS DWORD
END TYPE

TYPE SECURITY_ATTRIBUTES
  nLength AS DWORD
  lpSecurityDescriptor AS LONG
  bInheritHandle AS LONG
END TYPE

TYPE PROCESS_INFORMATION
  hProcess AS DWORD
  hThread AS DWORD
  dwProcessId AS DWORD
  dwThreadId AS DWORD
END TYPE

TYPE FILETIME
  dwLowDateTime AS DWORD
  dwHighDateTime AS DWORD
END TYPE

TYPE SYSTEMTIME
  wYear AS WORD
  wMonth AS WORD
  wDayOfWeek AS WORD
  wDay AS WORD
  wHour AS WORD
  wMinute AS WORD
  wSecond AS WORD
  wMilliseconds AS WORD
END TYPE

TYPE COMMPROP
  wPacketLength AS WORD
  wPacketVersion AS WORD
  dwServiceMask AS DWORD
  dwReserved1 AS DWORD
  dwMaxTxQueue AS DWORD
  dwMaxRxQueue AS DWORD
  dwMaxBaud AS DWORD
  dwProvSubType AS DWORD
  dwProvCapabilities AS DWORD
  dwSettableParams AS DWORD
  dwSettableBaud AS DWORD
  wSettableData AS WORD
  wSettableStopParity AS WORD
  dwCurrentTxQueue AS DWORD
  dwCurrentRxQueue AS DWORD
  dwProvSpec1 AS DWORD
  dwProvSpec2 AS DWORD
  wcProvChar(0 TO 0) AS WORD   ' array size may vary
END TYPE

TYPE COMSTAT
  fbits AS DWORD       'fCtsHold
                       'fDsrHold
                       'fRlsdHold
                       'fXoffHold
                       'fXoffSent
                       'fEof
                       'fTxim
  cbInQue AS DWORD
  cbOutQue AS DWORD
END TYPE

TYPE DCB
  DCBlength AS DWORD
  BaudRate AS DWORD
  fBits AS DWORD       ' fBinary
                       ' fParity
                       ' fOutxDtsFlow
                       ' fOutxDsrFlow
                       ' fDtrControl
                       ' fDsrSensitivity
                       ' fTXContinueOnXoff
                       ' fOutX
                       ' fInX
                       ' fErrorChar
                       ' fNull
                       ' fRtsControl
                       ' fAbortOnError
                       ' fDummy2
  wReserved AS WORD
  XonLim AS WORD
  XoffLim AS WORD
  ByteSize AS BYTE
  PARITY AS BYTE
  StopBits AS BYTE
  XonChar AS BYTE
  XoffChar AS BYTE
  ErrorChar AS BYTE
  EofChar AS BYTE
  EvtChar AS BYTE
  wReserved2 AS INTEGER
END TYPE

TYPE COMMTIMEOUTS
  ReadIntervalTimeout AS DWORD
  ReadTotalTimeoutMultiplier AS DWORD
  ReadTotalTimeoutConstant AS DWORD
  WriteTotalTimeoutMultiplier AS DWORD
  WriteTotalTimeoutConstant AS DWORD
END TYPE

TYPE SYSTEM_INFO
  dwOemID AS DWORD
  dwPageSize AS DWORD
  lpMinimumApplicationAddress AS DWORD
  lpMaximumApplicationAddress AS DWORD
  dwActiveProcessorMask AS DWORD
  dwNumberOfProcessors AS DWORD
  dwProcessorType AS DWORD
  dwAllocationGranularity AS DWORD
  wProcessorLevel AS WORD
  wProcessorRevision AS WORD
END TYPE

TYPE MEMORYSTATUS
  dwLength AS DWORD
  dwMemoryLoad AS DWORD
  dwTotalPhys AS DWORD
  dwAvailPhys AS DWORD
  dwTotalPageFile AS DWORD
  dwAvailPageFile AS DWORD
  dwTotalVirtual AS DWORD
  dwAvailVirtual AS DWORD
END TYPE

TYPE MEMORYSTATUSEX
  dwLength AS DWORD
  dwMemoryLoad AS DWORD
  ullTotalPhys AS QUAD
  ullAvailPhys AS QUAD
  ullTotalPageFile AS QUAD
  ullAvailPageFile AS QUAD
  ullTotalVirtual AS QUAD
  ullAvailVirtual AS QUAD
  ullAvailExtendedVirtual AS QUAD
END TYPE

TYPE TPMPARAMS
  cbSize AS DWORD
  rcExclude AS RECT
END TYPE

TYPE LOAD_DLL_DEBUG_INFO
  hFile AS DWORD
  lpBaseOfDll AS LONG
  dwDebugInfoFileOffset AS DWORD
  nDebugInfoSize AS DWORD
  lpImageName AS ASCIIZ PTR
  fUnicode AS WORD
END TYPE

TYPE UNLOAD_DLL_DEBUG_INFO
  lpBaseOfDll AS LONG
END TYPE

' OpenFile structure
TYPE OFSTRUCT
  cBytes AS BYTE
  fFixedDisk AS BYTE
  nErrCode AS WORD
  Reserved1 AS WORD
  Reserved2 AS WORD
  szPathName AS ASCIIZ * %OFS_MAXPATHNAME
END TYPE

TYPE WNDCLASSEX
  cbSize AS DWORD
  style AS DWORD
  lpfnWndProc AS LONG
  cbClsExtra AS LONG
  cbWndExtra AS LONG
  hInstance AS DWORD
  hIcon AS DWORD
  hCursor AS DWORD
  hbrBackground AS LONG
  lpszMenuName AS ASCIIZ PTR
  lpszClassName AS ASCIIZ PTR
  hIconSm AS LONG
END TYPE

TYPE WNDCLASS
  style AS DWORD
  lpfnwndproc AS LONG
  cbClsextra AS LONG
  cbWndExtra AS LONG
  hInstance AS DWORD
  hIcon AS DWORD
  hCursor AS DWORD
  hbrBackground AS LONG
  lpszMenuName AS ASCIIZ PTR
  lpszClassName AS ASCIIZ PTR
END TYPE

' The CRITICAL_SECTION value is incorrectly defined, in many of the
' Microsoft include files, as a UINT (for C) or LONG (for VB).
' In fact, it needs to be 24 bytes long, not 4 bytes.
' See Microsoft Knowledgebase article Q197569 for details.
'
TYPE CRITICAL_SECTION
  dummy AS STRING * 24
END TYPE

TYPE BY_HANDLE_FILE_INFORMATION
  dwFileAttributes AS DWORD
  ftCreationTime AS FILETIME
  ftLastAccessTime AS FILETIME
  ftLastWriteTime AS FILETIME
  dwVolumeSerialNumber AS DWORD
  nFileSizeHigh AS DWORD
  nFileSizeLow AS DWORD
  nNumberOfLinks AS DWORD
  nFileIndexHigh AS DWORD
  nFileIndexLow AS DWORD
END TYPE

TYPE WIN32_FILE_ATTRIBUTE_DATA
  dwFileAttributes AS DWORD
  ftCreationTime AS FILETIME
  ftLastAccessTime AS FILETIME
  ftLastWriteTime AS FILETIME
  dwVolumeSerialNumber AS DWORD
  nFileSizeHigh AS DWORD
  nFileSizeLow AS DWORD
END TYPE

TYPE DIOC_REGISTERS
  regEBX AS DWORD
  regEDX AS DWORD
  regECX AS DWORD
  regEAX AS DWORD
  regEDI AS DWORD
  regESI AS DWORD
  regFlags AS DWORD
END TYPE

TYPE TIME_ZONE_INFORMATION
  Bias AS LONG
  StandardName AS STRING * 64
  StandardDate AS SYSTEMTIME
  StandardBias AS LONG
  DaylightName AS STRING * 64
  DaylightDate AS SYSTEMTIME
  DaylightBias AS LONG
END TYPE

' Stream ID type
TYPE WIN32_STREAM_ID
  dwStreamID AS DWORD
  dwStreamAttributes AS DWORD
  qsize AS QUAD
  dwStreamNameSize AS DWORD
  cStreamName AS BYTE
END TYPE

TYPE STARTUPINFO
  cb AS DWORD
  lpReserved AS ASCIIZ PTR
  lpDesktop AS ASCIIZ PTR
  lpTitle AS ASCIIZ PTR
  dwX AS DWORD
  dwY AS DWORD
  dwXSize AS DWORD
  dwYSize AS DWORD
  dwXCountChars AS DWORD
  dwYCountChars AS DWORD
  dwFillAttribute AS DWORD
  dwFlags AS DWORD
  wShowWindow AS WORD
  cbReserved2 AS WORD
  lpReserved2 AS BYTE PTR
  hStdInput AS LONG
  hStdOutput AS LONG
  hStdError AS LONG
END TYPE

TYPE WIN32_FIND_DATA
  dwFileAttributes AS DWORD
  ftCreationTime AS FILETIME
  ftLastAccessTime AS FILETIME
  ftLastWriteTime AS FILETIME
  nFileSizeHigh AS DWORD
  nFileSizeLow AS DWORD
  dwReserved0 AS DWORD
  dwReserved1 AS DWORD
  cFileName AS ASCIIZ * %MAX_PATH
  cAlternateFileName AS ASCIIZ * 14
END TYPE

TYPE CPINFO
  MaxCharSize AS DWORD                           'max length (bytes) of a char
  DefaultChar(0 TO %MAX_DEFAULTCHAR - 1) AS BYTE 'default character
  LeadByte(0 TO %MAX_LEADBYTES - 1) AS BYTE      'lead byte ranges
END TYPE

TYPE NUMBERFMT
  NumDigits AS DWORD                    'number of decimal digits
  LeadingZero AS DWORD                  'if leading zero in decimal fields
  Grouping AS DWORD                     'group size left of decimal
  lpDecimalSep AS ASCIIZ PTR            'ptr to decimal separator string
  lpThousandSep AS ASCIIZ PTR           'ptr to thousand separator string
  NegativeOrder AS DWORD                'negative number ordering
END TYPE

TYPE CURRENCYFMT
  NumDigits AS DWORD                    'number of decimal digits
  LeadingZero AS DWORD                  'if leading zero in decimal fields
  Grouping AS DWORD                     'group size left of decimal
  lpDecimalSep AS ASCIIZ PTR            'ptr to decimal separator string
  lpThousandSep AS ASCIIZ PTR           'ptr to thousand separator string
  NegativeOrder AS DWORD                'negative currency ordering
  PositiveOrder AS DWORD                'positive currency ordering
  lpCurrencySymbol AS ASCIIZ PTR        'ptr to currency symbol string
END TYPE

' The following section contains the public data structures, data types,
' and procedures exported by the NT console subsystem.

TYPE COORD
  x AS INTEGER
  y AS INTEGER
END TYPE

TYPE SMALL_RECT
  xLeft AS INTEGER
  xTop AS INTEGER
  xRight AS INTEGER
  xBottom AS INTEGER
END TYPE

TYPE KEY_EVENT_RECORD
  bKeyDown AS LONG
  wRepeatCount AS WORD
  wVirtualKeyCode AS WORD
  wVirtualScanCode AS WORD
  uChar AS INTEGER
  dwControlKeyState AS DWORD
END TYPE

TYPE MOUSE_EVENT_RECORD
  dwMousePosition AS COORD
  dwButtonState AS DWORD
  dwControlKeyState AS DWORD
  dwEventFlags AS DWORD
END TYPE

TYPE WINDOW_BUFFER_SIZE_RECORD
  dwSize AS COORD
END TYPE

TYPE MENU_EVENT_RECORD
  dwCommandId AS DWORD
END TYPE

TYPE FOCUS_EVENT_RECORD
  bSetFocus AS LONG
END TYPE

UNION EventStruc
  KeyEvent AS KEY_EVENT_RECORD
  MouseEvent AS MOUSE_EVENT_RECORD
  WindowBufferSizeEvent AS WINDOW_BUFFER_SIZE_RECORD
  MenuEvent AS MENU_EVENT_RECORD
  FocusEvent AS FOCUS_EVENT_RECORD
END UNION

TYPE INPUT_RECORD DWORD
  EventType AS WORD
  Event AS EventStruc
END TYPE

TYPE CHAR_INFO
  Ch AS INTEGER
  Attributes AS WORD
END TYPE

TYPE CONSOLE_SCREEN_BUFFER_INFO
  dwSize AS COORD
  dwCursorPosition AS COORD
  wAttributes AS WORD
  srWindow AS SMALL_RECT
  dwMaximumWindowSize AS COORD
END TYPE

TYPE CONSOLE_CURSOR_INFO
  dwSize AS DWORD
  bVisible AS LONG
END TYPE



' Types from winnt.h ==========================================================

TYPE FLOAT128
  LowPart AS QUAD
  HighPart AS QUAD
END TYPE

'
' Locally Unique Identifier
'

TYPE LUID
  LowPart AS DWORD
  HighPart AS LONG
END TYPE

'
' Base data structures for OLE support
'
#IF NOT %DEF(%GUID_DEFINED) '--------------------------------------------------
TYPE GUIDAPI
  Data1 AS DWORD
  Data2 AS WORD
  Data3 AS WORD
  Data4 AS STRING * 8
END TYPE
%GUID_DEFINED = 1
#ENDIF ' #IF NOT %DEF(%GUID_DEFINED) ------------------------------------------

#IF NOT %DEF(%OBJECTID_DEFINED) '----------------------------------------------
TYPE OBJECTID
  Lineage AS GUIDAPI
  Uniquifier AS DWORD
END TYPE
%OBJECTID_DEFINED = 1
#ENDIF ' #IF NOT %DEF(%OBJECTID_DEFINED) --------------------------------------

TYPE VIDEOPARAMETERS
    xGuid AS GUIDAPI                   ' GUID for this structure
    dwOffset AS DWORD                  ' leave it 0 for now.
    dwCommand AS DWORD                 ' VP_COMMAND_*            SET or GET
    dwFlags AS DWORD                   ' bitfield, defined below SET or GET
    dwMode AS DWORD                    ' bitfield, defined below SET or GET
    dwTVStandard AS DWORD              ' bitfield, defined below SET or GET
    dwAvailableModes AS DWORD          ' bitfield, defined below GET
    dwAvailableTVStandard AS DWORD     ' bitfield, defined below GET
    dwFlickerFilter AS DWORD           ' value                   SET or GET
    dwOverScanX AS DWORD               ' value                   SET or GET
    dwOverScanY AS DWORD               '                         SET or GET
    dwMaxUnscaledX AS DWORD            ' value                   SET or GET
    dwMaxUnscaledY AS DWORD            '                         SET or GET
    dwPositionX AS DWORD               ' value                   SET or GET
    dwPositionY AS DWORD               '                         SET or GET
    dwBrightness AS DWORD              ' value                   SET or GET
    dwContrast AS DWORD                ' value                   SET or GET
    dwCPType AS DWORD                  ' copy protection type    SET or GET
    dwCPCommand AS DWORD               ' VP_CP_CMD_
    dwCPStandard AS DWORD              ' what TV standards CP is available on. GET
    dwCPKey AS DWORD
    bCP_APSTriggerBits AS DWORD        ' (a dword for alignment) SET(bits 0 and 1 valid).
    bOEMCopyProtection AS STRING * 256 ' oem specific copy protection data SET or GET
END TYPE

TYPE FLOATING_SAVE_AREA
  ControlWord AS DWORD
  StatusWord AS DWORD
  TagWord AS DWORD
  ErrorOffset AS DWORD
  ErrorSelector AS DWORD
  DataOffset AS DWORD
  DataSelector AS DWORD
  RegisterArea(0 TO %SIZE_OF_80387_REGISTERS - 1) AS BYTE
  Cr0NpxState AS DWORD
END TYPE

'
' Context Frame
'
'  This frame has a several purposes: 1) it is used as an argument to
'  NtContinue, 2) is is used to constuct a call frame for APC delivery,
'  and 3) it is used in the user level thread creation routines.
'
'  The layout of the record conforms to a standard call frame.
'
TYPE CONTEXT
  '
  ' The flags values within this flag control the contents of
  ' a CONTEXT record.
  '
  ' If the context record is used as an input parameter, then
  ' for each portion of the context record controlled by a flag
  ' whose value is set, it is assumed that that portion of the
  ' context record contains valid context. If the context record
  ' is being used to modify a threads context, then only that
  ' portion of the threads context will be modified.
  '
  ' If the context record is used as an IN OUT parameter to capture
  ' the context of a thread, then only those portions of the thread's
  ' context corresponding to set flags will be returned.
  '
  ' The context record is never used as an OUT only parameter.
  '
  ContextFlags AS DWORD

  ' This section is specified/returned if CONTEXT_DEBUG_REGISTERS is
  ' set in ContextFlags.  Note that CONTEXT_DEBUG_REGISTERS is NOT
  ' included in CONTEXT_FULL.
  Dr0 AS DWORD
  Dr1 AS DWORD
  Dr2 AS DWORD
  Dr3 AS DWORD
  Dr6 AS DWORD
  Dr7 AS DWORD

  ' This section is specified/returned if the
  ' ContextFlags word contians the flag CONTEXT_FLOATING_POINT.
  FloatSave AS FLOATING_SAVE_AREA

  ' This section is specified/returned if the
  ' ContextFlags word contians the flag CONTEXT_SEGMENTS.
  regGs AS DWORD
  regFs AS DWORD
  regEs AS DWORD
  regDs AS DWORD

  ' This section is specified/returned if the
  ' ContextFlags word contians the flag CONTEXT_INTEGER.
  regEdi AS DWORD
  regEsi AS DWORD
  regEbx AS DWORD
  regEdx AS DWORD
  regEcx AS DWORD
  regEax AS DWORD

  ' This section is specified/returned if the
  ' ContextFlags word contians the flag CONTEXT_CONTROL.
  regEbp AS DWORD
  regEip AS DWORD
  regCs AS DWORD      ' MUST BE SANITIZED
  regFlag AS DWORD    ' MUST BE SANITIZED
  regEsp AS DWORD
  regSs AS DWORD
END TYPE

#IF NOT %DEF(%LDT_ENTRY_DEFINED) '---------------------------------------------
TYPE LDT_BYTES
  BaseMid AS BYTE
  Flags1 AS BYTE
  Flags2 AS BYTE
  BaseHi AS BYTE
END TYPE

UNION LDT_UNION
  HighWord AS DWORD
  LDTB AS LDT_BYTES
END UNION

TYPE LDT_ENTRY
  LimitLow AS INTEGER
  BaseLow AS INTEGER
  HL AS LDT_UNION
END TYPE
#ENDIF ' #IF NOT %DEF(%LDT_ENTRY_DEFINED) -------------------------------------

'
' Exception record definition.
'

TYPE EXCEPTION_RECORD
  ExceptionCode AS DWORD
  ExceptionFlags AS DWORD
  pExceptionRecord AS EXCEPTION_RECORD PTR
  ExceptionAddress AS DWORD
  NumberParameters AS DWORD
  ExceptionInformation(0 TO %EXCEPTION_MAXIMUM_PARAMETERS - 1) AS DWORD
END TYPE

TYPE EXCEPTION_POINTERS
  pExceptionRecord AS EXCEPTION_RECORD PTR
  ContextRecord AS CONTEXT PTR
END TYPE

' Define the generic mapping array.  This is used to denote the
' mapping of each generic access right to a specific access mask.

TYPE GENERIC_MAPPING
  GenericRead AS DWORD
  GenericWrite AS DWORD
  GenericExecute AS DWORD
  GenericAll AS DWORD
END TYPE

TYPE LUID_AND_ATTRIBUTES
  pLuid AS LUID
  Attributes AS DWORD
END TYPE

#IF NOT %DEF(%SID_IDENTIFIER_AUTHORITY_DEFINED)
%SID_IDENTIFIER_AUTHORITY_DEFINED = 1
TYPE SID_IDENTIFIER_AUTHORITY
  Value(0 TO 5) AS BYTE
END TYPE
#ENDIF

#IF NOT %DEF(%SID_DEFINED)
%SID_DEFINED = 1
TYPE SID
  Revision AS BYTE
  SubAuthorityCount AS BYTE
  IdentifierAuthority AS SID_IDENTIFIER_AUTHORITY
  SubAuthority(0 TO 0) AS DWORD   ' array size may vary
END TYPE
#ENDIF

TYPE SID_AND_ATTRIBUTES
  pSid AS DWORD
  Attributes AS DWORD
END TYPE

TYPE ACL
  AclRevision AS BYTE
  Sbz1 AS BYTE
  AclSize AS WORD
  AceCount AS WORD
  Sbz2 AS WORD
END TYPE

TYPE ACE_HEADER
  AceType AS BYTE
  AceFlags AS BYTE
  AceSize AS WORD
END TYPE

' The following are the four predefined ACE types.
'
' Examine the AceType field in the Header to determine
' which structure is appropriate to use for casting.

TYPE ACCESS_ALLOWED_ACE
  Header AS ACE_HEADER
  Mask AS DWORD
  SidStart AS DWORD
END TYPE

TYPE ACCESS_DENIED_ACE
  Header AS ACE_HEADER
  Mask AS DWORD
  SidStart AS DWORD
END TYPE

TYPE SYSTEM_AUDIT_ACE
  Header AS ACE_HEADER
  Mask AS DWORD
  SidStart AS DWORD
END TYPE

TYPE SYSTEM_ALARM_ACE
  Header AS ACE_HEADER
  Mask AS DWORD
  SidStart AS DWORD
END TYPE

TYPE ACCESS_ALLOWED_OBJECT_ACE
  Header AS ACE_HEADER
  Mask AS DWORD
  Flags AS DWORD
  ObjectType AS GUIDAPI
  InheritedObjectType AS GUIDAPI
  SidStart AS DWORD
END TYPE

TYPE ACCESS_DENIED_OBJECT_ACE
  Header AS ACE_HEADER
  Mask AS DWORD
  Flags AS DWORD
  ObjectType AS GUIDAPI
  InheritedObjectType AS GUIDAPI
  SidStart AS DWORD
END TYPE

TYPE SYSTEM_AUDIT_OBJECT_ACE
  Header AS ACE_HEADER
  Mask AS DWORD
  Flags AS DWORD
  ObjectType AS GUIDAPI
  InheritedObjectType AS GUIDAPI
  SidStart AS DWORD
END TYPE

TYPE SYSTEM_ALARM_OBJECT_ACE
  Header AS ACE_HEADER
  Mask AS DWORD
  Flags AS DWORD
  ObjectType AS GUIDAPI
  InheritedObjectType AS GUIDAPI
  SidStart AS DWORD
END TYPE

' This record is returned/sent if the user is requesting/setting the
' AclRevisionInformation
'
TYPE ACL_REVISION_INFORMATION
  AclRevision AS DWORD
END TYPE

' This record is returned if the user is requesting AclSizeInformation
'
TYPE ACL_SIZE_INFORMATION
  AceCount AS DWORD
  AclBytesInUse AS DWORD
  AclBytesFree AS DWORD
END TYPE

TYPE SECURITY_DESCRIPTOR_RELATIVE
  Revision AS BYTE
  Sbz1 AS BYTE
  nControl AS WORD
  Owner AS DWORD
  Group AS DWORD
  Sacl AS DWORD
  Dacl AS DWORD
END TYPE

TYPE SECURITY_DESCRIPTOR
  Revision AS BYTE
  Sbz1 AS BYTE
  nControl AS WORD
  Owner AS DWORD
  Group AS DWORD
  Sacl AS ACL PTR
  Dacl AS ACL PTR
END TYPE

' Object Type list for AccessCheckByType

TYPE OBJECT_TYPE_LIST
  Level AS WORD
  Sbz AS WORD
  ObjectType AS GUIDAPI PTR
END TYPE

' Privilege Set - This is defined for a privilege set of one.
'                 If more than one privilege is needed, then this structure
'                 will need to be allocated with more space.
'
' Note: don't change this structure without fixing the INITIAL_PRIVILEGE_SET
' structure (defined in se.h)
'
' [PowerBASIC note: The above note is Microsoft's. Be advised that there is
'  no se.h in the Windows SDK, nor is INITIAL_PRIVILEGE_SET ever defined.]
'
TYPE PRIVILEGE_SET
  PrivilegeCount AS DWORD
  nControl AS DWORD
'  Privilege(0 TO 0) AS LUID_AND_ATTRIBUTES  ' array size may vary
END TYPE

'
' Token information class structures
'

TYPE TOKEN_USER
    User AS SID_AND_ATTRIBUTES
END TYPE

TYPE TOKEN_GROUPS
    GroupCount AS DWORD
    Groups(0 TO 0) AS SID_AND_ATTRIBUTES   ' array size may vary
END TYPE

TYPE TOKEN_PRIVILEGES
    PrivilegeCount AS DWORD
    Privileges(0 TO 0) AS LUID_AND_ATTRIBUTES  ' array size may vary
END TYPE

TYPE TOKEN_OWNER
    Owner AS DWORD
END TYPE

TYPE TOKEN_PRIMARY_GROUP
    PrimaryGroup AS DWORD
END TYPE

TYPE TOKEN_DEFAULT_DACL
    DefaultDacl AS ACL PTR
END TYPE

TYPE TOKEN_SOURCE
    SourceName AS ASCIIZ * %TOKEN_SOURCE_LENGTH
    SourceIdentifier AS LUID
END TYPE

TYPE TOKEN_STATISTICS
    TokenId AS LUID
    AuthenticationId AS LUID
    ExpirationTime AS QUAD
    TokenType AS LONG
    ImpersonationLevel AS LONG
    DynamicCharged AS DWORD
    DynamicAvailable AS DWORD
    GroupCount AS DWORD
    PrivilegeCount AS DWORD
    ModifiedId AS LUID
END TYPE

TYPE TOKEN_CONTROL
    TokenId AS LUID
    AuthenticationId AS LUID
    ModifiedId AS LUID
    TokenSource AS TOKEN_SOURCE
END TYPE

'
' Quality of Service
'

TYPE SECURITY_QUALITY_OF_SERVICE
  Length AS DWORD
  Impersonationlevel AS LONG
  ContextTrackingMode AS BYTE
  EffectiveOnly AS BYTE
END TYPE

'
' Used to represent information related to a thread impersonation
'

TYPE SE_IMPERSONATION_LEVEL
  Token AS DWORD        ' pointer
  CopyOnOpen AS BYTE
  EffectiveOnly AS BYTE
  Level AS DWORD
END TYPE

TYPE QUOTA_LIMITS
  PagedPoolLimit AS DWORD
  NonPagedPoolLimit AS DWORD
  MinimumWorkingSetSize AS DWORD
  MaximumWorkingSetSize AS DWORD
  PagefileLimit AS DWORD
  TimeLimit AS QUAD
END TYPE

TYPE IO_COUNTERS
  ReadOperationCount AS QUAD
  WriteOperationCount AS QUAD
  OtherOperationCount AS QUAD
  ReadTransferCount AS QUAD
  WriteTransferCount AS QUAD
  OtherTransferCount AS QUAD
END TYPE

TYPE JOBOBJECT_BASIC_ACCOUNTING_INFORMATION
  TotalUserTime AS QUAD
  TotalKernelTime AS QUAD
  ThisPeriodTotalUserTime AS QUAD
  ThisPeriodTotalKernelTime AS QUAD
  TotalPageFaultCount AS DWORD
  TotalProcesses AS DWORD
  ActiveProcesses AS DWORD
  TotalTerminatedProcesses AS DWORD
END TYPE

TYPE JOBOBJECT_BASIC_LIMIT_INFORMATION
  PerProcessUserTimeLimit AS QUAD
  PerJobUserTimeLimit AS QUAD
  LimitFlags AS DWORD
  MinimumWorkingSetSize AS DWORD
  MaximumWorkingSetSize AS DWORD
  ActiveProcessLimit AS DWORD
  Affinity AS QUAD PTR
  PriorityClass AS DWORD
  SchedulingClass AS DWORD
END TYPE

TYPE JOBOBJECT_EXTENDED_LIMIT_INFORMATION
  BasicLimitInformation AS JOBOBJECT_BASIC_LIMIT_INFORMATION
  IoInfo AS IO_COUNTERS
  ProcessMemoryLimit AS DWORD
  JobMemoryLimit AS DWORD
  PeakProcessMemoryUsed AS DWORD
  PeakJobMemoryUsed AS DWORD
END TYPE

TYPE JOBOBJECT_BASIC_PROCESS_ID_LIST
  NumberOfAssignedProcesses AS DWORD
  NumberOfProcessIdsInList AS DWORD
  ProcessIdList(0 TO 0) AS QUAD PTR
END TYPE

TYPE JOBOBJECT_BASIC_UI_RESTRICTIONS
  UIRestrictionsClass AS DWORD
END TYPE

TYPE JOBOBJECT_SECURITY_LIMIT_INFORMATION
  SecurityLimitFlags AS DWORD
  JobToken AS DWORD
  SidsToDisable AS DWORD
  PrivilegesToDelete AS TOKEN_PRIVILEGES PTR
  RestrictedSids AS DWORD
END TYPE

TYPE JOBOBJECT_END_OF_JOB_TIME_INFORMATION
  EndOfJobTimeAction AS DWORD
END TYPE

TYPE JOBOBJECT_ASSOCIATE_COMPLETION_PORT
  CompletionKey AS DWORD
  CompletionPort AS DWORD
END TYPE

TYPE JOBOBJECT_BASIC_AND_IO_ACCOUNTING_INFORMATION
  BasicInfo AS JOBOBJECT_BASIC_ACCOUNTING_INFORMATION
  IoInfo AS IO_COUNTERS
END TYPE

TYPE MEMORY_BASIC_INFORMATION
  BaseAddress AS DWORD
  AllocationBase AS DWORD
  AllocationProtect AS DWORD
  RegionSize AS LONG
  State AS DWORD
  Protect AS DWORD
  dType AS DWORD
END TYPE

TYPE MEMORY_BASIC_INFORMATION_VLM
  BaseAddress AS QUAD
  AllocationBase AS QUAD
  RegionSize AS QUAD
  AllocationProtect AS DWORD
  State AS DWORD
  Protect AS DWORD
  dType AS DWORD
END TYPE

'
' Define the file notification information structure
'

TYPE FILE_NOTIFY_INFORMATION
  NextEntryOffset AS DWORD
  Action AS DWORD
  FileNameLength AS DWORD
  FileName(0 TO 0) AS DWORD
END TYPE


'
' Define segment buffer structure for scatter/gather read/write.
'

UNION FILE_SEGMENT_ELEMENT
  Buffer AS QUAD
  Alignment AS QUAD
END UNION

'
' The reparse GUIDAPI structure is used by all 3rd party layered drivers to
' store data in a reparse point. For non-Microsoft tags, The GUIDAPI field
' cannot be GUID_NULL.
' The constraints on reparse tags are defined below.
' Microsoft tags can also be used with this format of the reparse point buffer.
'

TYPE REPARSE_GUID_DATA_BUFFER
  ReparseTag AS DWORD
  ReparseDataLength AS WORD
  Reserved AS WORD
  ReparseGuid AS GUIDAPI
  DataBuffer(0 TO 0) AS BYTE
END TYPE

TYPE IMAGE_DOS_HEADER
  e_magic AS WORD              ' Magic number
  e_cblp AS WORD               ' Bytes on last page of file
  e_cp AS WORD                 ' Pages in file
  e_crlc AS WORD               ' Relocations
  e_cparhdr AS WORD            ' Size of header in paragraphs
  e_minalloc AS WORD           ' Minimum extra paragraphs needed
  e_maxalloc AS WORD           ' Maximum extra paragraphs needed
  e_ss AS WORD                 ' Initial (relative) SS value
  e_sp AS WORD                 ' Initial SP value
  e_csum AS WORD               ' Checksum
  e_ip AS WORD                 ' Initial IP value
  e_cs AS WORD                 ' Initial (relative) CS value
  e_lfarlc AS WORD             ' File address of relocation table
  e_ovno AS WORD               ' Overlay number
  e_res(0 TO 3) AS WORD        ' Reserved words
  e_oemid AS WORD              ' OEM identifier (for e_oeminfo)
  e_oeminfo AS WORD            ' OEM information; e_oemid specific
  e_res2(0 TO 9) AS WORD       ' Reserved words
  e_lfanew AS LONG             ' File address of new exe header
END TYPE

TYPE IMAGE_OS2_HEADER WORD     ' OS/2 .EXE header
  ne_magic AS WORD           ' Magic number
  ne_ver AS BYTE             ' Version number
  ne_rev AS BYTE             ' Revision number
  ne_enttab AS WORD          ' Offset of Entry Table
  ne_cbenttab AS WORD        ' Number of bytes in Entry Table
  ne_crc AS LONG             ' Checksum of whole file
  ne_flags AS WORD           ' Flag word
  ne_autodata AS WORD        ' Automatic data segment number
  ne_heap AS WORD            ' Initial heap allocation
  ne_stack AS WORD           ' Initial stack allocation
  ne_csip AS LONG            ' Initial CS:IP setting
  ne_sssp AS LONG            ' Initial SS:SP setting
  ne_cseg AS WORD            ' Count of file segments
  ne_cmod AS WORD            ' Entries in Module Reference Table
  ne_cbnrestab AS WORD       ' Size of non-resident name table
  ne_segtab AS WORD          ' Offset of Segment Table
  ne_rsrctab AS WORD         ' Offset of Resource Table
  ne_restab AS WORD          ' Offset of resident name table
  ne_modtab AS WORD          ' Offset of Module Reference Table
  ne_imptab AS WORD          ' Offset of Imported Names Table
  ne_nrestab AS LONG         ' Offset of Non-resident Names Table
  ne_cmovent AS WORD         ' Count of movable entries
  ne_align AS WORD           ' Segment alignment shift count
  ne_cres AS WORD            ' Count of resource segments
  ne_exetyp AS BYTE          ' Target Operating system
  ne_flagsothers AS BYTE     ' Other .EXE flags
  ne_pretthunks AS WORD      ' offset to return thunks
  ne_psegrefbytes AS WORD    ' offset to segment ref. bytes
  ne_swaparea AS WORD        ' Minimum code swap area size
  ne_expver AS WORD          ' Expected Windows version number
END TYPE

TYPE IMAGE_VXD_HEADER WORD     ' Windows VXD header
  e32_magic AS WORD          ' Magic number
  e32_border AS BYTE         ' The byte ordering for the VXD
  e32_worder AS BYTE         ' The word ordering for the VXD
  e32_level AS DWORD         ' The EXE format level for now = 0
  e32_cpu AS WORD            ' The CPU type
  e32_os AS WORD             ' The OS type
  e32_ver AS DWORD           ' Module version
  e32_mflags AS DWORD        ' Module flags
  e32_mpages AS DWORD        ' Module # pages
  e32_startobj AS DWORD      ' Object # for instruction pointer
  e32_eip AS DWORD           ' Extended instruction pointer
  e32_stackobj AS DWORD      ' Object # for stack pointer
  e32_esp AS DWORD           ' Extended stack pointer
  e32_pagesize AS DWORD      ' VXD page size
  e32_lastpagesize AS DWORD  ' Last page size in VXD
  e32_fixupsize AS DWORD     ' Fixup section size
  e32_fixupsum AS DWORD      ' Fixup section checksum
  e32_ldrsize AS DWORD       ' Loader section size
  e32_ldrsum AS DWORD        ' Loader section checksum
  e32_objtab AS DWORD        ' Object table offset
  e32_objcnt AS DWORD        ' Number of objects in module
  e32_objmap AS DWORD        ' Object page map offset
  e32_itermap AS DWORD       ' Object iterated data map offset
  e32_rsrctab AS DWORD       ' Offset of Resource Table
  e32_rsrccnt AS DWORD       ' Number of resource entries
  e32_restab AS DWORD        ' Offset of resident name table
  e32_enttab AS DWORD        ' Offset of Entry Table
  e32_dirtab AS DWORD        ' Offset of Module Directive Table
  e32_dircnt AS DWORD        ' Number of module directives
  e32_fpagetab AS DWORD      ' Offset of Fixup Page Table
  e32_frectab AS DWORD       ' Offset of Fixup Record Table
  e32_impmod AS DWORD        ' Offset of Import Module Name Table
  e32_impmodcnt AS DWORD     ' Number of entries in Import Module Name Table
  e32_impproc AS DWORD       ' Offset of Import Procedure Name Table
  e32_pagesum AS DWORD       ' Offset of Per-Page Checksum Table
  e32_datapage AS DWORD      ' Offset of Enumerated Data Pages
  e32_preload AS DWORD       ' Number of preload pages
  e32_nrestab AS DWORD       ' Offset of Non-resident Names Table
  e32_cbnrestab AS DWORD     ' Size of Non-resident Name Table
  e32_nressum AS DWORD       ' Non-resident Name Table Checksum
  e32_autodata AS DWORD      ' Object # for automatic data object
  e32_debuginfo AS DWORD     ' Offset of the debugging information
  e32_debuglen AS DWORD      ' The length of the debugging info. in bytes
  e32_instpreload AS DWORD   ' Number of instance pages in preload section of VXD file
  e32_instdemand AS DWORD    ' Number of instance pages in demand load section of VXD file
  e32_heapsize AS DWORD      ' Size of heap - for 16-bit apps
  e32_res3 AS STRING * 12    ' Reserved words
  e32_winresoff AS DWORD
  e32_winreslen AS DWORD
  e32_devid AS WORD          ' Device ID for VxD
  e32_ddkver AS WORD         ' DDK version for VxD
END TYPE

' File header format.

TYPE IMAGE_FILE_HEADER DWORD
  Machine AS WORD
  NumberOfSections AS WORD
  TimeDateStamp AS DWORD
  PointerToSymbolTable AS DWORD
  NumberOfSymbols AS DWORD
  SizeOfOptionalHeader AS WORD
  Characteristics AS WORD
END TYPE

' Directory format.

TYPE IMAGE_DATA_DIRECTORY DWORD
  VirtualAddress AS DWORD
  nSize AS DWORD
END TYPE

' Optional header format.

TYPE IMAGE_OPTIONAL_HEADER DWORD
  ' Standard fields.
  Magic AS WORD
  MajorLinkerVersion AS BYTE
  MinorLinkerVersion AS BYTE
  SizeOfCode AS DWORD
  SizeOfInitializedData AS DWORD
  SizeOfUninitializedData AS DWORD
  AddressOfEntryPoint AS DWORD
  BaseOfCode AS DWORD
  BaseOfData AS DWORD
  ' NT additional fields.
  ImageBase AS DWORD
  SectionAlignment AS DWORD
  FileAlignment AS DWORD
  MajorOperatingSystemVersion AS WORD
  MinorOperatingSystemVersion AS WORD
  MajorImageVersion AS WORD
  MinorImageVersion AS WORD
  MajorSubsystemVersion AS WORD
  MinorSubsystemVersion AS WORD
  Win32VersionValue AS DWORD
  SizeOfImage AS DWORD
  SizeOfHeaders AS DWORD
  CheckSum AS DWORD
  Subsystem AS WORD
  DllCharacteristics AS WORD
  SizeOfStackReserve AS DWORD
  SizeOfStackCommit AS DWORD
  SizeOfHeapReserve AS DWORD
  SizeOfHeapCommit AS DWORD
  LoaderFlags AS DWORD
  NumberOfRvaAndSizes AS DWORD
  DataDirectory(0 TO %IMAGE_NUMBEROF_DIRECTORY_ENTRIES - 1) AS IMAGE_DATA_DIRECTORY
END TYPE

TYPE IMAGE_ROM_OPTIONAL_HEADER DWORD
  Magic AS WORD
  MajorLinkerVersion AS BYTE
  MinorLinkerVersion AS BYTE
  SizeOfCode AS DWORD
  SizeOfInitializedData AS DWORD
  SizeOfUninitializedData AS DWORD
  AddressOfEntryPoint AS DWORD
  BaseOfCode AS DWORD
  BaseOfData AS DWORD
  BaseOfBss AS DWORD
  GprMask AS DWORD
  CprMask(0 TO 3) AS DWORD
  GpValue AS DWORD
END TYPE

TYPE IMAGE_OPTIONAL_HEADER64
  Magic AS WORD
  MajorLinkerVersion AS BYTE
  MinorLinkerVersion AS BYTE
  SizeOfCode AS DWORD
  SizeOfInitializedData AS DWORD
  SizeOfUninitializedData AS DWORD
  AddressOfEntryPoint AS DWORD
  BaseOfCode AS DWORD
  ImageBase AS QUAD
  SectionAlignment AS DWORD
  FileAlignment AS DWORD
  MajorOperatingSystemVersion AS WORD
  MinorOperatingSystemVersion AS WORD
  MajorImageVersion AS WORD
  MinorImageVersion AS WORD
  MajorSubsystemVersion AS WORD
  MinorSubsystemVersion AS WORD
  Win32VersionValue AS DWORD
  SizeOfImage AS DWORD
  SizeOfHeaders AS DWORD
  CheckSum AS DWORD
  Subsystem AS WORD
  DllCharacteristics AS WORD
  SizeOfStackReserve AS QUAD
  SizeOfStackCommit AS QUAD
  SizeOfHeapReserve AS QUAD
  SizeOfHeapCommit AS QUAD
  LoaderFlags AS DWORD
  NumberOfRvaAndSizes AS DWORD
  DataDirectory(0 TO %IMAGE_NUMBEROF_DIRECTORY_ENTRIES - 1) AS IMAGE_DATA_DIRECTORY
END TYPE

TYPE IMAGE_NT_HEADERS64 DWORD
  Signature AS DWORD
  FileHeader AS IMAGE_FILE_HEADER
  OptionalHeader AS IMAGE_OPTIONAL_HEADER64
END TYPE

TYPE IMAGE_NT_HEADERS DWORD
  Signature AS DWORD
  FileHeader AS IMAGE_FILE_HEADER
  OptionalHeader AS IMAGE_OPTIONAL_HEADER
END TYPE

TYPE IMAGE_ROM_HEADER DWORD
  FileHeader AS IMAGE_FILE_HEADER
  OptionalHeader AS IMAGE_ROM_OPTIONAL_HEADER
END TYPE

TYPE ANON_OBJECT_HEADER DWORD
  Sig1 AS WORD           ' Must be %IMAGE_FILE_MACHINE_UNKNOWN
  Sig2 AS WORD           ' Must be &HFFFF??
  Version AS WORD        ' >= 1 (implies the ClassID field is present)
  Machine AS WORD
  TimeDateStamp AS DWORD
  ClassID AS GUIDAPI     ' Used to invoke CoCreateInstance
  SizeOfData AS DWORD    ' Size of data that follows the header
END TYPE

' Section header format.

UNION MiscUnionISH
  PhysicalAddress AS DWORD
  VirtualSize AS DWORD
END UNION

TYPE IMAGE_SECTION_HEADER DWORD
  xName AS STRING * %IMAGE_SIZEOF_SHORT_NAME
  Misc AS MiscUnionISH
  VirtualAddress AS DWORD
  SizeOfRawData AS DWORD
  PointerToRawData AS DWORD
  PointerToRelocations AS DWORD
  PointerToLinenumbers AS DWORD
  NumberOfRelocations AS WORD
  NumberOfLinenumbers AS WORD
  Characteristics AS DWORD
END TYPE

UNION NameUnion
  dShort AS DWORD    ' if 0, use LongName
  dLong AS DWORD     ' offset into string table
END UNION

UNION Nunion
  ShortName AS STRING * 8
  xName AS NameUnion
  LongName(0 TO 1) AS DWORD
END UNION

TYPE IMAGE_SYMBOL WORD
  N AS Nunion
  Value AS DWORD
  SectionNumber AS INTEGER
  wType AS WORD
  StorageClass AS BYTE
  NumberOfAuxSymbols AS BYTE
END TYPE

' Auxiliary entry format.

TYPE LnSzType DWORD
  Linenumber AS WORD   ' declaration line number
  Size AS WORD         ' size of struct, union, or enum
END TYPE

UNION MiscUnionST
  LnSz AS LnSzType
  TotalSize AS DWORD
END UNION

TYPE FunctionType DWORD
  PointerToLinenumber AS DWORD
  PointerToNextFunction AS DWORD
END TYPE

TYPE ArrayType DWORD
  Dimension(0 TO 3) AS WORD
END TYPE

UNION FcnAryUnion
  xFunction AS FunctionType  ' if ISFCN, tag, or .bb
  xArray AS ArrayType        ' if ISARY, up to 4 dimen.
END UNION

TYPE SymType DWORD
  TagIndex AS DWORD      ' struct, union, or enum tag index
  Misc AS MiscUnionST
  FcnAry AS FcnAryUnion
  TvIndex AS WORD        ' tv index
END TYPE

TYPE FileType DWORD
  xName AS STRING * %IMAGE_SIZEOF_SYMBOL
END TYPE

TYPE SectionType DWORD
  Length AS DWORD               ' section length
  NumberOfRelocations AS WORD   ' number of relocation entries
  NumberOfLinenumbers AS WORD   ' number of line numbers
  CheckSum AS DWORD             ' checksum for communal
  Number AS INTEGER             ' section number to associate with
  Selection AS BYTE             ' communal selection type
END TYPE

UNION IMAGE_AUX_SYMBOL
  Sym AS SymType
  File AS FileType
  Section AS SectionType
END UNION

' Relocation format.

UNION IMAGE_RELOC_union
  VirtualAddress AS DWORD
  RelocCount AS DWORD  ' Set to the real count when IMAGE_SCN_LNK_NRELOC_OVFL is set
END UNION

TYPE IMAGE_RELOCATION DWORD
  IRU AS IMAGE_RELOC_union
  SymbolTableIndex AS DWORD
  wType AS WORD
END TYPE

TYPE USER_INFO_3
   ' Level 0 starts here
  uName AS LONG                ' pointer to Unicode string
   ' Level 1 starts here
  Password AS LONG             ' pointer to Unicode string
  PasswordAge AS DWORD         '
  Privilege AS DWORD           '
  HomeDir AS LONG              ' pointer to Unicode string
  Comment AS LONG              ' pointer to Unicode string
  Flags AS DWORD               '
  ScriptPath AS LONG           ' pointer to Unicode string
   ' Level 2 starts here
  AuthFlags AS DWORD           '
  FullName AS LONG             ' pointer to Unicode string
  UserComment AS LONG          ' pointer to Unicode string
  Parms AS LONG                ' pointer to Unicode string
  Workstations AS LONG         ' pointer to Unicode string
  LastLogon AS DWORD           '
  LastLogoff AS DWORD          '
  AcctExpires AS DWORD         '
  MaxStorage AS DWORD          '
  UnitsPerWeek AS DWORD        '
  LogonHours AS BYTE PTR       ' pointer to 21 byte bitmap
  BadPwCount AS DWORD          '
  NumLogons AS DWORD           '
  LogonServer AS LONG          ' pointer to Unicode string
  CountryCode AS DWORD         '
  CodePage AS DWORD            '
   ' Level 3 starts here
  UserID AS DWORD              '
  PrimaryGroupID AS DWORD      '
  pProfile AS LONG              ' pointer to Unicode string
  HomeDirDrive AS LONG         ' pointer to Unicode string
  PasswordExpired AS DWORD     ' boolean
END TYPE

TYPE WKSTA_USER_INFO_1
  wkui_username     AS LONG    ' pointer to Unicode string
  wkui_logon_domain AS LONG    ' pointer to Unicode string
  wkui_oth_domains  AS LONG    ' pointer to Unicode string
  wkui_logon_server AS LONG    ' pointer to Unicode string
END TYPE

TYPE GROUP_INFO_2
  grpi2_name AS LONG           ' pointer to Unicode string
  grpi2_comment AS LONG        ' pointer to Unicode string
  grpi2_group_id AS DWORD      '
  grpi2_attributes AS DWORD    '
END TYPE

TYPE SERVER_INFO_100
  sv100_platform_id AS DWORD   '
  sv100_name AS LONG           ' pointer to Unicode string
END TYPE

TYPE SERVER_INFO_101
  sv101_platform_id AS DWORD   '
  sv101_name AS LONG           ' pointer to Unicode string
  sv101_version_major AS DWORD '
  sv101_version_minor AS DWORD '
  sv101_type AS DWORD          '
  sv101_comment AS LONG        ' pointer to Unicode string
END TYPE

TYPE SERVER_INFO_102           '
  sv102_platform_id AS DWORD   '
  sv102_name AS LONG           ' pointer to Unicode string
  sv102_version_major AS DWORD '
  sv102_version_minor AS DWORD '
  sv102_type AS DWORD          '
  sv102_comment AS LONG        ' pointer to Unicode string
  sv102_users AS DWORD         '
  sv102_disc AS DWORD          '
  sv102_hidden AS LONG         '
  sv102_announce AS DWORD      '
  sv102_anndelta AS DWORD      '
  sv102_licenses AS DWORD      '
  sv102_userpath AS LONG       ' pointer to Unicode string
END TYPE

TYPE SERVER_INFO_402
  sv402_ulist_mtime AS DWORD   '
  sv402_glist_mtime AS DWORD   '
  sv402_alist_mtime AS DWORD   '
  sv402_alerts AS LONG         ' pointer to Unicode string
  sv402_security AS DWORD      '
  sv402_numadmin AS DWORD      '
  sv402_lanmask AS DWORD       '
  sv402_guestacct AS LONG      ' pointer to Unicode string
  sv402_chdevs AS DWORD        '
  sv402_chdevq AS DWORD        '
  sv402_chdevjobs AS DWORD     '
  sv402_connections AS DWORD   '
  sv402_shares AS DWORD        '
  sv402_openfiles AS DWORD     '
  sv402_sessopens AS DWORD     '
  sv402_sessvcs AS DWORD       '
  sv402_sessreqs AS DWORD      '
  sv402_opensearch AS DWORD    '
  sv402_activelocks AS DWORD   '
  sv402_numreqbuf AS DWORD     '
  sv402_sizreqbuf AS DWORD     '
  sv402_numbigbuf AS DWORD     '
  sv402_numfiletasks AS DWORD  '
  sv402_alertsched AS DWORD    '
  sv402_erroralert AS DWORD    '
  sv402_logonalert AS DWORD    '
  sv402_accessalert AS DWORD   '
  sv402_diskalert AS DWORD     '
  sv402_netioalert AS DWORD    '
  sv402_maxauditsz AS DWORD    '
  sv402_srvheuristics AS LONG  ' pointer to Unicode string
END TYPE

TYPE SERVER_INFO_403
  sv403_ulist_mtime AS DWORD   '
  sv403_glist_mtime AS DWORD   '
  sv403_alist_mtime AS DWORD   '
  sv403_alerts AS LONG         ' pointer to Unicode string
  sv403_security AS DWORD      '
  sv403_numadmin AS DWORD      '
  sv403_lanmask AS DWORD       '
  sv403_guestacct AS LONG      ' pointer to Unicode string
  sv403_chdevs AS DWORD        '
  sv403_chdevq AS DWORD        '
  sv403_chdevjobs AS DWORD     '
  sv403_connections AS DWORD   '
  sv403_shares AS DWORD        '
  sv403_openfiles AS DWORD     '
  sv403_sessopens AS DWORD     '
  sv403_sessvcs AS DWORD       '
  sv403_sessreqs AS DWORD      '
  sv403_opensearch AS DWORD    '
  sv403_activelocks AS DWORD   '
  sv403_numreqbuf AS DWORD     '
  sv403_sizreqbuf AS DWORD     '
  sv403_numbigbuf AS DWORD     '
  sv403_numfiletasks AS DWORD  '
  sv403_alertsched AS DWORD    '
  sv403_erroralert AS DWORD    '
  sv403_logonalert AS DWORD    '
  sv403_accessalert AS DWORD   '
  sv403_diskalert AS DWORD     '
  sv403_netioalert AS DWORD    '
  sv403_maxauditsz AS DWORD    '
  sv403_srvheuristics AS LONG  ' pointer to Unicode string
  sv403_auditedevents AS DWORD '
  sv403_autoprofile AS DWORD   '
  sv403_autopath AS LONG       ' pointer to Unicode string
END TYPE

TYPE SERVER_INFO_502
  sv502_sessopens AS DWORD
  sv502_sessvcs AS DWORD
  sv502_opensearch AS DWORD
  sv502_sizreqbuf AS DWORD
  sv502_initworkitems AS DWORD
  sv502_maxworkitems AS DWORD
  sv502_rawworkitems AS DWORD
  sv502_irpstacksize AS DWORD
  sv502_maxrawbuflen AS DWORD
  sv502_sessusers AS DWORD
  sv502_sessconns AS DWORD
  sv502_maxpagedmemoryusage AS DWORD
  sv502_maxnonpagedmemoryusage AS DWORD
  sv502_enablesoftcompat AS LONG
  sv502_enableforcedlogoff AS LONG
  sv502_timesource AS LONG
  sv502_acceptdownlevelapis AS LONG
  sv502_lmannounce AS LONG
END TYPE

TYPE SERVER_INFO_503
  sv503_sessopens AS DWORD
  sv503_sessvcs AS DWORD
  sv503_opensearch AS DWORD
  sv503_sizreqbuf AS DWORD
  sv503_initworkitems AS DWORD
  sv503_maxworkitems AS DWORD
  sv503_rawworkitems AS DWORD
  sv503_irpstacksize AS DWORD
  sv503_maxrawbuflen AS DWORD
  sv503_sessusers AS DWORD
  sv503_sessconns AS DWORD
  sv503_maxpagedmemoryusage AS DWORD
  sv503_maxnonpagedmemoryusage AS DWORD
  sv503_enablesoftcompat AS LONG
  sv503_enableforcedlogoff AS LONG
  sv503_timesource AS LONG
  sv503_acceptdownlevelapis AS LONG
  sv503_lmannounce AS LONG
  sv503_domain AS LONG                 ' pointer to Unicode string
  sv503_maxcopyreadlen AS DWORD
  sv503_maxcopywritelen AS DWORD
  sv503_minkeepsearch AS DWORD
  sv503_maxkeepsearch AS DWORD
  sv503_minkeepcomplsearch AS DWORD
  sv503_maxkeepcomplsearch AS DWORD
  sv503_threadcountadd AS DWORD
  sv503_numblockthreads AS DWORD
  sv503_scavtimeout AS DWORD
  sv503_minrcvqueue AS DWORD
  sv503_minfreeworkitems AS DWORD
  sv503_xactmemsize AS DWORD
  sv503_threadpriority AS DWORD
  sv503_maxmpxct AS DWORD
  sv503_oplockbreakwait AS DWORD
  sv503_oplockbreakresponsewait AS DWORD
  sv503_enableoplocks AS LONG
  sv503_enableoplockforceclose AS LONG
  sv503_enablefcbopens AS LONG
  sv503_enableraw AS LONG
  sv503_enablesharednetdrives AS LONG
  sv503_minfreeconnections AS DWORD
  sv503_maxfreeconnections AS DWORD
END TYPE

TYPE SERVER_INFO_599
  sv599_sessopens AS DWORD
  sv599_sessvcs AS DWORD
  sv599_opensearch AS DWORD
  sv599_sizreqbuf AS DWORD
  sv599_initworkitems AS DWORD
  sv599_maxworkitems AS DWORD
  sv599_rawworkitems AS DWORD
  sv599_irpstacksize AS DWORD
  sv599_maxrawbuflen AS DWORD
  sv599_sessusers AS DWORD
  sv599_sessconns AS DWORD
  sv599_maxpagedmemoryusage AS DWORD
  sv599_maxnonpagedmemoryusage AS DWORD
  sv599_enablesoftcompat AS LONG
  sv599_enableforcedlogoff AS LONG
  sv599_timesource AS LONG
  sv599_acceptdownlevelapis AS LONG
  sv599_lmannounce AS LONG
  sv599_domain AS LONG                    ' pointer to Unicode string
  sv599_maxcopyreadlen AS DWORD
  sv599_maxcopywritelen AS DWORD
  sv599_minkeepsearch AS DWORD
  sv599_maxkeepsearch AS DWORD
  sv599_minkeepcomplsearch AS DWORD
  sv599_maxkeepcomplsearch AS DWORD
  sv599_threadcountadd AS DWORD
  sv599_numblockthreads AS DWORD
  sv599_scavtimeout AS DWORD
  sv599_minrcvqueue AS DWORD
  sv599_minfreeworkitems AS DWORD
  sv599_xactmemsize AS DWORD
  sv599_threadpriority AS DWORD
  sv599_maxmpxct AS DWORD
  sv599_oplockbreakwait AS DWORD
  sv599_oplockbreakresponsewait AS DWORD
  sv599_enableoplocks AS LONG
  sv599_enableoplockforceclose AS LONG
  sv599_enablefcbopens AS LONG
  sv599_enableraw AS LONG
  sv599_enablesharednetdrives AS LONG
  sv599_minfreeconnections AS DWORD
  sv599_maxfreeconnections AS DWORD
  sv599_initsesstable AS DWORD
  sv599_initconntable AS DWORD
  sv599_initfiletable AS DWORD
  sv599_initsearchtable AS DWORD
  sv599_alertschedule AS DWORD
  sv599_errorthreshold AS DWORD
  sv599_networkerrorthreshold AS DWORD
  sv599_diskspacethreshold AS DWORD
  sv599_reserved AS DWORD
  sv599_maxlinkdelay AS DWORD
  sv599_minlinkthroughput AS DWORD
  sv599_linkinfovalidtime AS DWORD
  sv599_scavqosinfoupdatetime AS DWORD
  sv599_maxworkitemidletime AS DWORD
END TYPE

TYPE SERVER_INFO_598
  sv598_maxrawworkitems AS DWORD
  sv598_maxthreadsperqueue AS DWORD
  sv598_producttype AS DWORD
  sv598_serversize AS DWORD
  sv598_connectionlessautodisc AS DWORD
  sv598_sharingviolationretries AS DWORD
  sv598_sharingviolationdelay AS DWORD
  sv598_maxglobalopensearch AS DWORD
  sv598_removeduplicatesearches AS DWORD
  sv598_lockviolationoffset AS DWORD
  sv598_lockviolationdelay AS DWORD
  sv598_mdlreadswitchover AS DWORD
  sv598_cachedopenlimit AS DWORD
  sv598_otherqueueaffinity AS DWORD
  sv598_restrictnullsessaccess AS LONG
  sv598_enablewfw311directipx AS LONG
  sv598_queuesamplesecs AS DWORD
  sv598_balancecount AS DWORD
  sv598_preferredaffinity AS DWORD
  sv598_maxfreerfcbs AS DWORD
  sv598_maxfreemfcbs AS DWORD
  sv598_maxfreelfcbs AS DWORD
  sv598_maxfreepagedpoolchunks AS DWORD
  sv598_minpagedpoolchunksize AS DWORD
  sv598_maxpagedpoolchunksize AS DWORD
  sv598_sendsfrompreferredprocessor AS LONG
  sv598_cacheddirectorylimit AS DWORD
  sv598_maxcopylength AS DWORD
  sv598_enablebulktransfer AS LONG
  sv598_enablecompression AS LONG
  sv598_autosharewks AS LONG
  sv598_autoshareserver AS LONG
  sv598_enablesecuritysignature AS LONG
  sv598_requiresecuritysignature AS LONG
  sv598_minclientbuffersize AS DWORD
  sv598_serverguid AS LONG  'GUID
  sv598_ConnectionNoSessionsTimeout AS DWORD
END TYPE

TYPE SERVER_INFO_1005
  sv1005_comment AS LONG       ' pointer to Unicode string
END TYPE

TYPE SERVER_INFO_1107
  sv1107_users AS DWORD
END TYPE

TYPE SERVER_INFO_1010
  sv1010_disc AS LONG
END TYPE

TYPE SERVER_INFO_1016
  sv1016_hidden AS LONG
END TYPE

TYPE SERVER_INFO_1017
  sv1017_announce AS DWORD
END TYPE

TYPE SERVER_INFO_1018
  sv1018_anndelta AS DWORD
END TYPE

TYPE SERVER_INFO_1501
  sv1501_sessopens AS DWORD
END TYPE

TYPE SERVER_INFO_1502
  sv1502_sessvcs AS DWORD
END TYPE

TYPE SERVER_INFO_1503
  sv1503_opensearch AS DWORD
END TYPE

TYPE SERVER_INFO_1506
  sv1506_maxworkitems AS DWORD
END TYPE

TYPE SERVER_INFO_1509
  sv1509_maxrawbuflen AS DWORD
END TYPE

TYPE SERVER_INFO_1510
  sv1510_sessusers AS DWORD
END TYPE

TYPE SERVER_INFO_1511
  sv1511_sessconns AS DWORD
END TYPE

TYPE SERVER_INFO_1512
  sv1512_maxnonpagedmemoryusage AS DWORD
END TYPE

TYPE SERVER_INFO_1513
  sv1513_maxpagedmemoryusage AS DWORD
END TYPE

TYPE SERVER_INFO_1514
  sv1514_enablesoftcompat AS LONG
END TYPE

TYPE SERVER_INFO_1515
  sv1515_enableforcedlogoff AS LONG
END TYPE

TYPE SERVER_INFO_1516
  sv1516_timesource AS LONG
END TYPE

TYPE SERVER_INFO_1518
  sv1518_lmannounce AS LONG
END TYPE

TYPE SERVER_INFO_1520
  sv1520_maxcopyreadlen AS DWORD
END TYPE

TYPE SERVER_INFO_1521
  sv1521_maxcopywritelen AS DWORD
END TYPE

TYPE SERVER_INFO_1522
  sv1522_minkeepsearch AS DWORD
END TYPE

TYPE SERVER_INFO_1523
  sv1523_maxkeepsearch AS DWORD
END TYPE

TYPE SERVER_INFO_1524
  sv1524_minkeepcomplsearch AS DWORD
END TYPE

TYPE SERVER_INFO_1525
  sv1525_maxkeepcomplsearch AS DWORD
END TYPE

TYPE SERVER_INFO_1528
  sv1528_scavtimeout AS DWORD
END TYPE

TYPE SERVER_INFO_1529
  sv1529_minrcvqueue AS DWORD
END TYPE

TYPE SERVER_INFO_1530
  sv1530_minfreeworkitems AS DWORD
END TYPE

TYPE SERVER_INFO_1533
  sv1533_maxmpxct AS DWORD
END TYPE

TYPE SERVER_INFO_1534
  sv1534_oplockbreakwait AS DWORD
END TYPE

TYPE SERVER_INFO_1535
  sv1535_oplockbreakresponsewait AS DWORD
END TYPE

TYPE SERVER_INFO_1536
  sv1536_enableoplocks AS LONG
END TYPE

TYPE SERVER_INFO_1537
  sv1537_enableoplockforceclose AS LONG
END TYPE

TYPE SERVER_INFO_1538
  sv1538_enablefcbopens AS LONG
END TYPE

TYPE SERVER_INFO_1539
  sv1539_enableraw AS LONG
END TYPE

TYPE SERVER_INFO_1540
  sv1540_enablesharednetdrives AS LONG
END TYPE

TYPE SERVER_INFO_1541
  sv1541_minfreeconnections AS LONG
END TYPE

TYPE SERVER_INFO_1542
  sv1542_maxfreeconnections AS LONG
END TYPE

TYPE SERVER_INFO_1543
  sv1543_initsesstable AS DWORD
END TYPE

TYPE SERVER_INFO_1544
  sv1544_initconntable AS DWORD
END TYPE

TYPE SERVER_INFO_1545
  sv1545_initfiletable AS DWORD
END TYPE

TYPE SERVER_INFO_1546
  sv1546_initsearchtable AS DWORD
END TYPE

TYPE SERVER_INFO_1547
  sv1547_alertschedule AS DWORD
END TYPE

TYPE SERVER_INFO_1548
  sv1548_errorthreshold AS DWORD
END TYPE

TYPE SERVER_INFO_1549
  sv1549_networkerrorthreshold AS DWORD
END TYPE

TYPE SERVER_INFO_1550
  sv1550_diskspacethreshold AS DWORD
END TYPE

TYPE SERVER_INFO_1552
  sv1552_maxlinkdelay AS DWORD
END TYPE

TYPE SERVER_INFO_1553
  sv1553_minlinkthroughput AS DWORD
END TYPE

TYPE SERVER_INFO_1554
  sv1554_linkinfovalidtime AS DWORD
END TYPE

TYPE SERVER_INFO_1555
  sv1555_scavqosinfoupdatetime AS DWORD
END TYPE

TYPE SERVER_INFO_1556
  sv1556_maxworkitemidletime AS DWORD
END TYPE

TYPE SERVER_INFO_1557
  sv1557_maxrawworkitems AS DWORD
END TYPE

TYPE SERVER_INFO_1560
  sv1560_producttype AS DWORD
END TYPE

TYPE SERVER_INFO_1561
  sv1561_serversize AS DWORD
END TYPE

TYPE SERVER_INFO_1562
  sv1562_connectionlessautodisc AS DWORD
END TYPE

TYPE SERVER_INFO_1563
  sv1563_sharingviolationretries AS DWORD
END TYPE

TYPE SERVER_INFO_1564
  sv1564_sharingviolationdelay AS DWORD
END TYPE

TYPE SERVER_INFO_1565
  sv1565_maxglobalopensearch AS DWORD
END TYPE

TYPE SERVER_INFO_1566
  sv1566_removeduplicatesearches AS LONG
END TYPE

TYPE SERVER_INFO_1567
  sv1567_lockviolationretries AS DWORD
END TYPE

TYPE SERVER_INFO_1568
  sv1568_lockviolationoffset AS DWORD
END TYPE

TYPE SERVER_INFO_1569
  sv1569_lockviolationdelay AS DWORD
END TYPE

TYPE SERVER_INFO_1570
  sv1570_mdlreadswitchover AS DWORD
END TYPE

TYPE SERVER_INFO_1571
  sv1571_cachedopenlimit AS DWORD
END TYPE

TYPE SERVER_INFO_1572
  sv1572_criticalthreads AS DWORD
END TYPE

TYPE SERVER_INFO_1573
  sv1573_restrictnullsessaccess AS DWORD
END TYPE

TYPE SERVER_INFO_1574
  sv1574_enablewfw311directipx AS DWORD
END TYPE

TYPE SERVER_INFO_1575
  sv1575_otherqueueaffinity AS DWORD
END TYPE

TYPE SERVER_INFO_1576
  sv1576_queuesamplesecs AS DWORD
END TYPE

TYPE SERVER_INFO_1577
  sv1577_balancecount AS DWORD
END TYPE

TYPE SERVER_INFO_1578
  sv1578_preferredaffinity AS DWORD
END TYPE

TYPE SERVER_INFO_1579
  sv1579_maxfreerfcbs AS DWORD
END TYPE

TYPE SERVER_INFO_1580
  sv1580_maxfreemfcbs AS DWORD
END TYPE

TYPE SERVER_INFO_1581
  sv1581_maxfreemlcbs AS DWORD
END TYPE

TYPE SERVER_INFO_1582
  sv1582_maxfreepagedpoolchunks AS DWORD
END TYPE

TYPE SERVER_INFO_1583
  sv1583_minpagedpoolchunksize AS DWORD
END TYPE

TYPE SERVER_INFO_1584
  sv1584_maxpagedpoolchunksize AS DWORD
END TYPE

TYPE SERVER_INFO_1585
  sv1585_sendsfrompreferredprocessor AS LONG
END TYPE

TYPE SERVER_INFO_1586
  sv1586_maxthreadsperqueue AS DWORD
END TYPE

TYPE SERVER_INFO_1587
  sv1587_cacheddirectorylimit AS DWORD
END TYPE

TYPE SERVER_INFO_1588
  sv1588_maxcopylength AS DWORD
END TYPE

TYPE SERVER_INFO_1589
  sv1589_enablebulktransfer AS DWORD
END TYPE

TYPE SERVER_INFO_1590
  sv1590_enablecompression AS DWORD
END TYPE

TYPE SERVER_INFO_1591
  sv1591_autosharewks AS DWORD
END TYPE

TYPE SERVER_INFO_1592
  sv1592_autosharewks AS DWORD
END TYPE

TYPE SERVER_INFO_1593
  sv1593_enablesecuritysignature AS DWORD
END TYPE

TYPE SERVER_INFO_1594
  sv1594_requiresecuritysignature AS DWORD
END TYPE

TYPE SERVER_INFO_1595
  sv1595_minclientbuffersize AS DWORD
END TYPE

TYPE SERVER_INFO_1596
  sv1596_ConnectionNoSessionsTimeout AS DWORD
END TYPE

' End of types from winnt.h ===================================================

' Types from sensapi.h ========================================================

TYPE QOCINFO
    dwSize     AS DWORD
    dwFlags    AS DWORD
    dwInSpeed  AS DWORD
    dwOutSpeed AS DWORD
END TYPE

' End of types from sensapi.h =================================================



' Types from wingdi.h =========================================================

#IF NOT %DEF(%NOGDI) '---------------------------------------------------------

#IF NOT %DEF(%NOMETAFILE) '----------------------------------------------------

TYPE DRAWPATRECT
  ptPosition AS POINTAPI
  ptSize AS POINTAPI
  wStyle AS WORD
  wPattern AS WORD
END TYPE

#ENDIF ' #IF NOT %DEF(%NOMETAFILE) --------------------------------------------

TYPE PSINJECTDATA
  DataBytes AS DWORD        ' number of raw data bytes
  InjectionPoint AS DWORD   ' injection point
  Flags AS DWORD            ' flags
  Reserved AS DWORD         ' reserved field - must be 0
END TYPE

TYPE XFORM
  eM11 AS DOUBLE
  eM12 AS DOUBLE
  eM21 AS DOUBLE
  eM22 AS DOUBLE
  eDx AS DOUBLE
  eDy AS DOUBLE
END TYPE

' Bitmap Header Definition
TYPE BITMAP
  bmType AS LONG
  bmWidth AS LONG
  bmHeight AS LONG
  bmWidthBytes AS LONG
  bmPlanes AS WORD
  bmBitsPixel AS WORD
  bmBits AS BYTE PTR
END TYPE

TYPE RGBTRIPLE BYTE
  rgbtBlue AS BYTE
  rgbtGreen AS BYTE
  rgbtRed AS BYTE
END TYPE

TYPE RGBQUAD
  rgbBlue AS BYTE
  rgbGreen AS BYTE
  rgbRed AS BYTE
  rgbReserved AS BYTE
END TYPE

TYPE CIEXYZ
  ciexyzX AS LONG
  ciexyzY AS LONG
  ciexyzZ AS LONG
END TYPE

TYPE CIEXYZTRIPLE
  ciexyzRed AS CIEXYZ
  ciexyzGreen AS CIEXYZ
  ciexyBlue AS CIEXYZ
END TYPE

TYPE LOGCOLORSPACE
  lcsSignature AS DWORD
  lcsVersion AS DWORD
  lcsSize AS DWORD
  lcsCSType AS LONG
  lcsIntent AS LONG
  lcsEndPoints AS CIEXYZTRIPLE
  lcsGammaRed AS DWORD
  lcsGammaGreen AS DWORD
  lcsGammaBlue AS DWORD
  lcsFileName AS ASCIIZ * %MAX_PATH
END TYPE

' structures for defining DIBs

TYPE BITMAPCOREHEADER
  bcSize AS DWORD
  bcWidth AS WORD
  bcHeight AS WORD
  bcPlanes AS WORD
  bcBitCount AS WORD
END TYPE

TYPE BITMAPINFOHEADER
  biSize AS DWORD
  biWidth AS LONG
  biHeight AS LONG
  biPlanes AS WORD
  biBitCount AS WORD
  biCompression AS DWORD
  biSizeImage AS DWORD
  biXPelsPerMeter AS LONG
  biYPelsPerMeter AS LONG
  biClrUsed AS DWORD
  biClrImportant AS DWORD
END TYPE

TYPE BITMAPV4HEADER
  bV4Size AS DWORD
  bV4Width AS LONG
  bV4Height AS LONG
  bV4Planes AS WORD
  bV4BitCount AS WORD
  bV4Compression AS DWORD
  bV4SizeImage AS DWORD
  bV4XPelsPerMeter AS LONG
  bV4YPelsPerMeter AS LONG
  bV4ClrUsed AS DWORD
  bV4ClrImportant AS DWORD
  bV4RedMask AS DWORD
  bV4GreenMask AS DWORD
  bV4BlueMask AS DWORD
  bV4AlphaMask AS DWORD
  bV4CSType AS DWORD
  bV4Endpoints AS CIEXYZTRIPLE
  bV4GammaRed AS DWORD
  bV4GammaGreen AS DWORD
  bV4GammaBlue AS DWORD
END TYPE

TYPE BITMAPV5HEADER
  bV5Size AS DWORD
  bV5Width AS LONG
  bV5Height AS LONG
  bV5Planes AS WORD
  bV5BitCount AS WORD
  bV5Compression AS DWORD
  bV5SizeImage AS DWORD
  bV5XPelsPerMeter AS LONG
  bV5YPelsPerMeter AS LONG
  bV5ClrUsed AS DWORD
  bV5ClrImportant AS DWORD
  bV5RedMask AS DWORD
  bV5GreenMask AS DWORD
  bV5BlueMask AS DWORD
  bV5AlphaMask AS DWORD
  bV5CSType AS DWORD
  bV5Endpoints AS CIEXYZTRIPLE
  bV5GammaRed AS DWORD
  bV5GammaGreen AS DWORD
  bV5GammaBlue AS DWORD
  bV5Intent AS DWORD
  bV5ProfileData AS DWORD
  bV5ProfileSize AS DWORD
  bV5Reserved AS DWORD
END TYPE

TYPE BITMAPINFO
  bmiHeader AS BITMAPINFOHEADER
  bmiColors AS LONG
END TYPE

TYPE BITMAPCOREINFO
  bmciHeader AS BITMAPCOREHEADER
  bmciColors AS LONG
END TYPE

TYPE BITMAPFILEHEADER WORD
  bfType AS WORD
  bfSize AS DWORD
  bfReserved1 AS WORD
  bfReserved2 AS WORD
  bfOffBits AS DWORD
END TYPE

TYPE FONTSIGNATURE
  fsUsb(0 TO 3) AS DWORD
  fsCsb(0 TO 1) AS DWORD
END TYPE

TYPE CHARSETINFO
  ciCharset AS DWORD
  ciACP AS DWORD
  fs AS FONTSIGNATURE
END TYPE

TYPE LOCALESIGNATURE
  lsUsb(0 TO 3) AS DWORD
  lsCsbDefault(0 TO 1) AS DWORD
  lsCsbSupported(0 TO 1) AS DWORD
END TYPE

#IF NOT %DEF(%NOMETAFILE) '----------------------------------------------------

' Clipboard Metafile Picture Structure
TYPE HANDLETABLE
  objectHandle(0 TO 0) AS LONG   ' variable-size array
END TYPE

TYPE METARECORD
  rdSize AS DWORD
  rdFunction AS WORD
  rdParm(0 TO 0) AS WORD   ' variable-size array
END TYPE

TYPE METAFILEPICT
  mm AS LONG
  xExt AS LONG
  yExt AS LONG
  hMF AS DWORD
END TYPE

TYPE METAHEADER WORD
  mtType AS WORD
  mtHeaderSize AS WORD
  mtVersion AS WORD
  mtSize AS DWORD
  mtNoObjects AS WORD
  mtMaxRecord AS DWORD
  mtNoParameters AS WORD
END TYPE

TYPE ENHMETARECORD
  iType AS DWORD           ' Record type EMR_XXX
  nSize AS DWORD           ' Record size in bytes
  dParm(0 TO 0) AS DWORD   ' Parameters (variable-size array)
END TYPE

TYPE ENHMETAHEADER
  iType AS DWORD           ' Record type EMR_HEADER
  nSize AS DWORD           ' Record size in bytes. This may be greater
                           ' than the sizeof(ENHMETAHEADER).
  rclBounds AS RECTL       ' Inclusive-inclusive bounds in device units
  rclFrame AS RECTL        ' Inclusive-inclusive Picture Frame of metafile in .01 mm units
  dSignature AS DWORD      ' Signature. Must be ENHMETA_SIGNATURE.
  nVersion AS DWORD        ' Version number
  nBytes AS DWORD          ' Size of the metafile in bytes
  nRecords AS DWORD        ' Number of records in the metafile
  nHandles AS WORD         ' Number of handles in the handle table
                           ' Handle index zero is reserved.
  sReserved AS WORD        ' Reserved. Must be zero.
  nDescription AS DWORD    ' Number of chars in the unicode description string
                           ' This is 0 if there is no description string
  offDescription AS DWORD  ' Offset to the metafile description record.
                           ' This is 0 if there is no description string
  nPalEntries AS DWORD     ' Number of entries in the metafile palette.
  szlDevice AS SIZEL       ' Size of the reference device in pels
  szlMillimeters AS SIZEL  ' Size of the reference device in millimeters
  cbPixelFormat AS DWORD   ' Size of PIXELFORMATDESCRIPTOR information
                           ' This is 0 if no pixel format is set
  offPixelFormat AS DWORD  ' Offset to PIXELFORMATDESCRIPTOR
                           ' This is 0 if no pixel format is set
  bOpenGL AS DWORD         ' TRUE if OpenGL commands are present in
                           ' the metafile, otherwise FALSE
  szlMicrometers AS SIZEL  ' Size of the reference device in micrometers
END TYPE

#ENDIF ' #IF NOT %DEF(%NOMETAFILE) --------------------------------------------

#IF NOT %DEF(%NOTEXTMETRIC) '--------------------------------------------------

TYPE TEXTMETRIC
  tmHeight AS LONG
  tmAscent AS LONG
  tmDescent AS LONG
  tmInternalLeading AS LONG
  tmExternalLeading AS LONG
  tmAveCharWidth AS LONG
  tmMaxCharWidth AS LONG
  tmWeight AS LONG
  tmOverhang AS LONG
  tmDigitizedAspectX AS LONG
  tmDigitizedAspectY AS LONG
  tmFirstChar AS BYTE
  tmLastChar AS BYTE
  tmDefaultChar AS BYTE
  tmBreakChar AS BYTE
  tmItalic AS BYTE
  tmUnderlined AS BYTE
  tmStruckOut AS BYTE
  tmPitchAndFamily AS BYTE
  tmCharSet AS BYTE
END TYPE

TYPE NEWTEXTMETRIC
  tmHeight AS LONG
  tmAscent AS LONG
  tmDescent AS LONG
  tmInternalLeading AS LONG
  tmExternalLeading AS LONG
  tmAveCharWidth AS LONG
  tmMaxCharWidth AS LONG
  tmWeight AS LONG
  tmOverhang AS LONG
  tmDigitizedAspectX AS LONG
  tmDigitizedAspectY AS LONG
  tmFirstChar AS BYTE
  tmLastChar AS BYTE
  tmDefaultChar AS BYTE
  tmBreakChar AS BYTE
  tmItalic AS BYTE
  tmUnderlined AS BYTE
  tmStruckOut AS BYTE
  tmPitchAndFamily AS BYTE
  tmCharSet AS BYTE
  ntmFlags AS DWORD
  ntmSizeEM AS DWORD
  ntmCellHeight AS DWORD
  ntmAveWidth AS DWORD
END TYPE

TYPE NEWTEXTMETRICEX
  ntmTm AS NEWTEXTMETRIC
  ntmFontSig AS FONTSIGNATURE
END TYPE

#ENDIF ' #IF NOT %DEF(%NOTEXTMETRIC) ------------------------------------------

' GDI Logical Objects:

' Pel Array
TYPE PELARRAY
  paXCount AS LONG
  paYCount AS LONG
  paXExt AS LONG
  paYExt AS LONG
  paRGBs AS BYTE
END TYPE

' Logical Brush (or Pattern)
TYPE LOGBRUSH
  lbStyle AS DWORD
  lbColor AS DWORD
  lbHatch AS LONG
END TYPE

' Logical Pen
TYPE LOGPEN
  lopnStyle AS DWORD
  lopnWidth AS POINTAPI
  lopnColor AS DWORD
END TYPE

TYPE EXTLOGPEN
  elpPenStyle AS DWORD
  elpWidth AS DWORD
  elpBrushStyle AS DWORD
  elpColor AS DWORD
  elpHatch AS LONG
  elpNumEntries AS DWORD
  elpStyleEntry(0 TO 0) AS DWORD   ' variable-length array
END TYPE

TYPE PALETTEENTRY
  peRed AS BYTE
  peGreen AS BYTE
  peBlue AS BYTE
  peFlags AS BYTE
END TYPE

' Logical Palette
TYPE LOGPALETTE
  palVersion AS WORD
  palNumEntries AS WORD
  palPalEntry(0 TO 0) AS PALETTEENTRY
END TYPE

TYPE LOGFONT
  lfHeight AS LONG
  lfWidth AS LONG
  lfEscapement AS LONG
  lfOrientation AS LONG
  lfWeight AS LONG
  lfItalic AS BYTE
  lfUnderline AS BYTE
  lfStrikeOut AS BYTE
  lfCharSet AS BYTE
  lfOutPrecision AS BYTE
  lfClipPrecision AS BYTE
  lfQuality AS BYTE
  lfPitchAndFamily AS BYTE
  lfFaceName AS ASCIIZ * %LF_FACESIZE
END TYPE

' Structure passed to FONTENUMPROC
TYPE ENUMLOGFONT
  elfLogFont AS LOGFONT
  elfFullName AS ASCIIZ * %LF_FULLFACESIZE
  elfStyle AS ASCIIZ * %LF_FACESIZE
END TYPE

TYPE ENUMLOGFONTEX
  elfLogFont AS LOGFONT
  elfFullName AS ASCIIZ * %LF_FULLFACESIZE
  elfStyle AS ASCIIZ * %LF_FACESIZE
  elfScript AS ASCIIZ * %LF_FACESIZE
END TYPE

TYPE PANOSE
  ulculture AS LONG
  bFamilyType AS BYTE
  bSerifStyle AS BYTE
  bWeight AS BYTE
  bProportion AS BYTE
  bContrast AS BYTE
  bStrokeVariation AS BYTE
  bArmStyle AS BYTE
  bLetterform AS BYTE
  bMidline AS BYTE
  bXHeight AS BYTE
END TYPE

TYPE EXTLOGFONT
  elfLogFont AS LOGFONT
  elfFullName AS ASCIIZ * %LF_FULLFACESIZE
  elfStyle AS ASCIIZ * %LF_FACESIZE
  elfVersion AS DWORD
  elfStyleSize AS DWORD
  elfMatch AS DWORD
  elfReserved AS DWORD
  elfVendorId AS ASCIIZ * %ELF_VENDOR_SIZE
  elfCulture AS DWORD
  elfPanose AS PANOSE
END TYPE

TYPE DEVMODE
  dmDeviceName AS ASCIIZ * %CCHDEVICENAME
  dmSpecVersion AS WORD
  dmDriverVersion AS WORD
  dmSize AS WORD
  dmDriverExtra AS WORD
  dmFields AS DWORD
  dmOrientation AS INTEGER
  dmPaperSize AS INTEGER
  dmPaperLength AS INTEGER
  dmPaperWidth AS INTEGER
  dmScale AS INTEGER
  dmCopies AS INTEGER
  dmDefaultSource AS INTEGER
  dmPrintQuality AS INTEGER
  dmColor AS INTEGER
  dmDuplex AS INTEGER
  dmYResolution AS INTEGER
  dmTTOption AS INTEGER
  dmCollate AS INTEGER
  dmFormName AS ASCIIZ * %CCHFORMNAME
  dmLogPixels AS WORD
  dmBitsPerPel AS DWORD
  dmPelsWidth AS DWORD
  dmPelsHeight AS DWORD
  dmDisplayFlags AS DWORD
  dmDisplayFrequency AS DWORD
  dmICMMethod AS DWORD
  dmICMIntent AS DWORD
  dmMediaType AS DWORD
  dmDitherType AS DWORD
  dmICCManufacturer AS DWORD
  dmICCModel AS DWORD
  dmPanningWidth AS DWORD
  dmPanningHeight AS DWORD
END TYPE

TYPE RGNDATAHEADER
  dwSize AS DWORD
  iType AS DWORD
  nCount AS DWORD
  nRgnSize AS DWORD
  rcBound AS RECT
END TYPE

TYPE RGNDATA
  rdh AS RGNDATAHEADER
  Buffer AS STRING * 1    ' arbitrary-length buffer : size as needed
END TYPE

TYPE ABC
  abcA AS LONG
  abcB AS DWORD
  abcC AS LONG
END TYPE

TYPE ABCFLOAT
  abcfA AS DOUBLE
  abcfB AS DOUBLE
  abcfC AS DOUBLE
END TYPE

#IF NOT %DEF(%NOTEXTMETRIC) '--------------------------------------------------

TYPE OUTLINETEXTMETRIC
  otmSize AS DWORD
  otmTextMetrics AS TEXTMETRIC
  otmFiller AS BYTE
  otmPanoseNumber AS PANOSE
  otmfsSelection AS DWORD
  otmfsType AS DWORD
  otmsCharSlopeRise AS LONG
  otmsCharSlopeRun AS LONG
  otmItalicAngle AS LONG
  otmEMSquare AS DWORD
  otmAscent AS LONG
  otmDescent AS LONG
  otmLineGap AS DWORD
  otmsCapEmHeight AS DWORD
  otmsXHeight AS DWORD
  otmrcFontBox AS RECT
  otmMacAscent AS LONG
  otmMacDescent AS LONG
  otmMacLineGap AS DWORD
  otmusMinimumPPEM AS DWORD
  otmptSubscriptSize AS POINTAPI
  otmptSubscriptOffset AS POINTAPI
  otmptSuperscriptSize AS POINTAPI
  otmptSuperscriptOffset AS POINTAPI
  otmsStrikeoutSize AS DWORD
  otmsStrikeoutPosition AS LONG
  otmsUnderscorePosition AS LONG
  otmsUnderscoreSize AS LONG
  otmpFamilyName AS ASCIIZ PTR
  otmpFaceName AS ASCIIZ PTR
  otmpStyleName AS ASCIIZ PTR
  otmpFullName AS ASCIIZ PTR
END TYPE

#ENDIF ' #IF NOT %DEF(%NOTEXTMETRIC) ------------------------------------------

TYPE POLYTEXT
  x AS LONG
  y AS LONG
  n AS DWORD
  lpStr AS ASCIIZ PTR
  uiFlags AS DWORD
  rcl AS RECT
  pdx AS LONG PTR
END TYPE

TYPE FIXED
  fract AS WORD
  value AS INTEGER
END TYPE

TYPE MAT2
  eM11 AS FIXED
  eM12 AS FIXED
  eM21 AS FIXED
  eM22 AS FIXED
END TYPE

TYPE GLYPHMETRICS
  gmBlackBoxX AS DWORD
  gmBlackBoxY AS DWORD
  gmptGlyphOrigin AS POINTAPI
  gmCellIncX AS INTEGER
  gmCellIncY AS INTEGER
END TYPE

TYPE POINTFX
  x AS FIXED
  y AS FIXED
END TYPE

TYPE TTPOLYCURVE
  wType AS WORD
  cpfx AS WORD
  apfx(0 TO 0) AS POINTFX   ' variable-length array
END TYPE

TYPE TTPOLYGONHEADER
  cb AS DWORD
  dwType AS DWORD
  pfxStart AS POINTFX
END TYPE

TYPE GCP_RESULTS
  lStructSize AS DWORD
  lpOutString AS ASCIIZ PTR
  lpOrder AS DWORD PTR
  lpDx AS LONG PTR
  lpCaretPos AS LONG PTR
  lpClass AS ASCIIZ PTR
  lpGlyphs AS DWORD PTR
  nGlyphs AS DWORD
  nMaxFit AS LONG
END TYPE

TYPE RASTERIZER_STATUS
  nSize AS INTEGER
  wFlags AS INTEGER        ' yes, this is supposed to be a signed integer
  nLanguageID AS INTEGER
END TYPE

TYPE PIXELFORMATDESCRIPTOR
  nSize AS WORD
  nVersion AS WORD
  dwFlags AS DWORD
  iPixelType AS BYTE
  cColorBits AS BYTE
  cRedBits AS BYTE
  cRedShift AS BYTE
  cGreenBits AS BYTE
  cGreenShift AS BYTE
  cBlueBits AS BYTE
  cBlueShift AS BYTE
  cAlphaBits AS BYTE
  cAlphaShift AS BYTE
  cAccumBits AS BYTE
  cAccumRedBits AS BYTE
  cAccumGreenBits AS BYTE
  cAccumBlueBits AS BYTE
  cAccumAlphaBits AS BYTE
  cDepthBits AS BYTE
  cStencilBits AS BYTE
  cAuxBuffers AS BYTE
  iLayerType AS BYTE
  bReserved AS BYTE
  dwLayerMask AS DWORD
  dwVisibleMask AS DWORD
  dwDamageMask AS DWORD
END TYPE

TYPE DESIGNVECTOR
  dvReserved AS DWORD
  dvNumAxes AS DWORD
  dvValues(0 TO %MM_MAX_NUMAXES - 1) AS LONG
END TYPE

TYPE AXISINFO
  axMinValue AS LONG
  axMaxValue AS LONG
  axAxisName AS ASCIIZ * %MM_MAX_AXES_NAMELEN - 1
END TYPE

TYPE AXESLIST
  axlReserved AS DWORD
  axlNumAxes AS DWORD
  axlAxisInfo(0 TO %MM_MAX_NUMAXES - 1) AS AXISINFO
END TYPE

' The actual size of the AXESLIST and ENUMTEXTMETRIC structure is
' determined by axlNumAxes,
' MM_MAX_NUMAXES only detemines the maximal size allowed

TYPE ENUMLOGFONTEXDV
  elfEnumLogfontEx AS ENUMLOGFONTEX
  elfDesignVector AS DESIGNVECTOR
END TYPE

#IF NOT %DEF(%NOTEXTMETRIC) '--------------------------------------------------

TYPE ENUMTEXTMETRIC
  etmNewTextMetricEx AS NEWTEXTMETRICEX
  etmAxesList AS AXESLIST
END TYPE

#ENDIF  ' #IF NOT %DEF(%NOTEXTMETRIC) -----------------------------------------

TYPE TRIVERTEX
  x AS LONG
  y AS LONG
  Red AS WORD
  Green AS WORD
  Blue AS WORD
  Alpha AS WORD
END TYPE

TYPE GRADIENT_TRIANGLE
  Vertex1 AS DWORD
  Vertex2 AS DWORD
  Vertex3 AS DWORD
END TYPE

TYPE GRADIENT_RECT
  UpperLeft AS DWORD
  LowerRight AS DWORD
END TYPE

TYPE BLENDFUNCTION
  BlendOp AS BYTE
  BlendFlags AS BYTE
  SourceConstantAlpha AS BYTE
  AlphaFormat AS BYTE
END TYPE

' new GDI

TYPE DIBSECTION
  dsBm AS BITMAP
  dsBmih AS BITMAPINFOHEADER
  dsBitfields(0 TO 2) AS DWORD
  dshSection AS DWORD
  dsOffset AS DWORD
END TYPE

TYPE COLORADJUSTMENT
  caSize AS WORD
  caFlags AS WORD
  caIlluminantIndex AS WORD
  caRedGamma AS WORD
  caGreenGamma AS WORD
  caBlueGamma AS WORD
  caReferenceBlack AS WORD
  caReferenceWhite AS WORD
  caContrast AS INTEGER
  caBrightness AS INTEGER
  caColorfulness AS INTEGER
  caRedGreenTint AS INTEGER
END TYPE

TYPE DOCINFO
  cbSize AS LONG
  lpszDocName AS ASCIIZ PTR
  lpszOutput AS ASCIIZ PTR
  lpszpDataType AS ASCIIZ PTR
  fwType AS DWORD
END TYPE

TYPE KERNINGPAIR
  wFirst AS WORD
  wSecond AS WORD
  iKernAmount AS LONG
END TYPE

#IF NOT %DEF(%NOMETAFILE) '----------------------------------------------------

' Base record type for the enhanced metafile.

TYPE EMR
  iType AS DWORD  ' Enhanced metafile record type
  nSize AS DWORD  ' Length of the record in bytes. Must be a multiple of 4.
END TYPE

TYPE EMRTEXT
  ptlReference AS POINTL
  nChars AS DWORD
  offString AS DWORD
  fOptions AS DWORD
  rcl AS RECTL
  offDx AS DWORD
END TYPE

TYPE EMRABORTPATH
  pEmr AS EMR
END TYPE

TYPE EMRBEGINPATH
  pEmr AS EMR
END TYPE

TYPE EMRENDPATH
  pEmr AS EMR
END TYPE

TYPE EMRCLOSEFIGURE
  pEmr AS EMR
END TYPE

TYPE EMRFLATTENPATH
  pEmr AS EMR
END TYPE

TYPE EMRWIDENPATH
  pEmr AS EMR
END TYPE

TYPE EMRSETMETARGN
  pEmr AS EMR
END TYPE

TYPE EMREMRSAVEDC
  pEmr AS EMR
END TYPE

TYPE EMRREALIZEPALETTE
  pEmr AS EMR
END TYPE

TYPE EMRSELECTCLIPPATH
  pEmr AS EMR
  iMode AS DWORD
END TYPE

TYPE EMRSETBKMODE
  pEmr AS EMR
  iMode AS DWORD
END TYPE

TYPE EMRSETMAPMODE
  pEmr AS EMR
  iMode AS DWORD
END TYPE

TYPE EMRSETPOLYFILLMODE
  pEmr AS EMR
  iMode AS DWORD
END TYPE

TYPE EMRSETROP2
  pEmr AS EMR
  iMode AS DWORD
END TYPE

TYPE EMRSETSTRETCHBLTMODE
  pEmr AS EMR
  iMode AS DWORD
END TYPE

TYPE EMRSETTEXTALIGN
  pEmr AS EMR
  iMode AS DWORD
END TYPE

TYPE EMRSETMITERLIMIT
  pEmr AS EMR
  eMiterLimit AS DOUBLE
END TYPE

TYPE EMRRESTOREDC
  pEmr AS EMR
  iRelative AS LONG   ' Specifies a relative instance
END TYPE

TYPE EMRSETARCDIRECTION
  pEmr AS EMR
  iArcDirection AS DWORD   ' Specifies the arc direction in the advanced graphics mode
END TYPE

TYPE EMRSETMAPPERFLAGS
  pEmr AS EMR
  dwFlags AS DWORD
END TYPE

TYPE EMRSETTEXTCOLOR
  pEmr AS EMR
  crColor AS DWORD
END TYPE

TYPE EMRSETBKCOLOR
  pEmr AS EMR
  crColor AS DWORD
END TYPE

TYPE EMRSELECTOBJECT
  pEmr AS EMR
  ihObject AS DWORD    ' Object handle index
END TYPE

TYPE EMRDELETEOBJECT
  pEmr AS EMR
  ihObject AS DWORD    ' Object handle index
END TYPE

TYPE EMRSELECTCOLORSPACE
  pEmr AS EMR
  ihCS AS DWORD    'ColorSpace handle index
END TYPE

TYPE EMRDELETECOLORSPACE
  pEmr AS EMR
  ihCS AS DWORD    'ColorSpace handle index
END TYPE

TYPE EMRSELECTPALETTE
  pEmr AS EMR
  ihPal AS DWORD    ' Palette handle index, background mode only
END TYPE

TYPE EMRRESIZEPALETTE
  pEmr AS EMR
  ihPal AS DWORD    ' Palette handle index
  cEntries AS DWORD
END TYPE

TYPE EMRSETPALETTEENTRIES
  pEmr AS EMR
  ihPal AS DWORD    ' Palette handle index
  iStart AS DWORD
  cEntries AS DWORD
  aPalEntries(0 TO 0) AS PALETTEENTRY  ' The peFlags fields do not contain any flags
                                       ' array size may vary
END TYPE

TYPE EMRSETCOLORADJUSTMENT
  pEmr AS EMR
  ColorAdjustment AS ColorAdjustment
END TYPE

TYPE EMRGDICOMMENT
  pEmr AS EMR
  cbData AS DWORD          ' Size of data in bytes
  xData(0 TO 0) AS BYTE    ' array size may vary
END TYPE

TYPE EMREOF
  pEmr AS EMR
  nPalEntries AS DWORD      ' Number of palette entries
  offPalEntries AS DWORD    ' Offset to the palette entries
  nSizeLast AS DWORD        ' Same as nSize and must be the last DWORD
                            ' of the record. The palette entries, if they
                            ' exist, precede this field.
END TYPE

TYPE EMRLINETO
  pEmr AS EMR
  ptl AS POINTL
END TYPE

TYPE EMRMOVETOEX
  pEmr AS EMR
  ptl AS POINTL
END TYPE

TYPE EMROFFSETCLIPRGN
  pEmr AS EMR
  ptlOffset AS POINTL
END TYPE

TYPE EMRFILLPATH
  pEmr AS EMR
  rclBounds AS RECTL    ' inclusive-inclusive bounds in device units
END TYPE

TYPE EMRSTROKEANDFILLPATH
  pEmr AS EMR
  rclBounds AS RECTL    ' inclusive-inclusive bounds in device units
END TYPE

TYPE EMRSTROKEPATH
  pEmr AS EMR
  rclBounds AS RECTL    ' inclusive-inclusive bounds in device units
END TYPE

TYPE EMREXCLUDECLIPRECT
  pEmr AS EMR
  rclClip AS RECTL
END TYPE

TYPE EMRINTERSECTCLIPRECT
  pEmr AS EMR
  rclClip AS RECTL
END TYPE

TYPE EMRSETVIEWPORTORGEX
  pEmr AS EMR
  ptlOrigin AS POINTL
END TYPE

TYPE EMRSETWINDOWORGEX
  pEmr AS EMR
  ptlOrigin AS POINTL
END TYPE

TYPE EMRSETBRUSHORGEX
  pEmr AS EMR
  ptlOrigin AS POINTL
END TYPE

TYPE EMRSETVIEWPORTEXTEX
  pEmr AS EMR
  szlExtent AS SIZEL
END TYPE

TYPE EMRSETWINDOWEXTEX
  pEmr AS EMR
  szlExtent AS SIZEL
END TYPE

TYPE EMRSCALEVIEWPORTEXTEX
  pEmr AS EMR
  xNum AS LONG
  xDenom AS LONG
  yNum AS LONG
  yDemon AS LONG
END TYPE

TYPE EMRSCALEWINDOWEXTEX
  pEmr AS EMR
  xNum AS LONG
  xDenom AS LONG
  yNum AS LONG
  yDemon AS LONG
END TYPE

TYPE EMRSETWORLDTRANSFORM
  pEmr AS EMR
  xform AS XFORM
END TYPE

TYPE EMRMODIFYWORLDTRANSFORM
  pEmr AS EMR
  xform AS XFORM
  iMode AS DWORD
END TYPE

TYPE EMRSETPIXELV
  pEmr AS EMR
  ptlPixel AS POINTL
  crColor AS DWORD
END TYPE

TYPE EMREXTFLOODFILL
  pEmr AS EMR
  ptlStart AS POINTL
  crColor AS DWORD
  iMode AS DWORD
END TYPE

TYPE EMRELLIPSE
  pEmr AS EMR
  rclBox AS RECTL    ' Inclusive-inclusive bounding rectangle
END TYPE

TYPE EMRRECTANGLE
  pEmr AS EMR
  rclBox AS RECTL    ' Inclusive-inclusive bounding rectangle
END TYPE

TYPE EMRROUNDRECT
  pEmr AS EMR
  rclBox AS RECTL    ' Inclusive-inclusive bounding rectangle
  szlCorner AS SIZEL
END TYPE

TYPE EMRARC
  pEmr AS EMR
  rclBox AS RECTL    ' Inclusive-inclusive bounding rectangle
  ptlStart AS POINTL
  ptlEnd AS POINTL
END TYPE

TYPE EMRARCTO
  pEmr AS EMR
  rclBox AS RECTL    ' Inclusive-inclusive bounding rectangle
  ptlStart AS POINTL
  ptlEnd AS POINTL
END TYPE

TYPE EMRCHORD
  pEmr AS EMR
  rclBox AS RECTL    ' Inclusive-inclusive bounding rectangle
  ptlStart AS POINTL
  ptlEnd AS POINTL
END TYPE

TYPE EMRPIE
  pEmr AS EMR
  rclBox AS RECTL    ' Inclusive-inclusive bounding rectangle
  ptlStart AS POINTL
  ptlEnd AS POINTL
END TYPE

TYPE EMRANGLEARC
  pEmr AS EMR
  ptlCenter AS POINTL
  nRadius AS LONG
  eStartAngle AS DOUBLE
  eSweepAngle AS DOUBLE
END TYPE

TYPE EMRPOLYLINE
  pEmr AS EMR
  rclBounds AS RECTL        ' Inclusive-inclusive bounds in device units
  cptl AS DWORD
  aptl(0 TO 0) AS POINTL    ' array size may vary
END TYPE

TYPE EMRPOLYBEZIER
  pEmr AS EMR
  rclBounds AS RECTL        ' Inclusive-inclusive bounds in device units
  cptl AS DWORD
  aptl(0 TO 0) AS POINTL    ' array size may vary
END TYPE

TYPE EMRPOLYGON
  pEmr AS EMR
  rclBounds AS RECTL        ' Inclusive-inclusive bounds in device units
  cptl AS DWORD
  aptl(0 TO 0) AS POINTL    ' array size may vary
END TYPE

TYPE EMRPOLYBEZIERTO
  pEmr AS EMR
  rclBounds AS RECTL        ' Inclusive-inclusive bounds in device units
  cptl AS DWORD
  aptl(0 TO 0) AS POINTL    ' array size may vary
END TYPE

TYPE EMRPOLYLINETO
  pEmr AS EMR
  rclBounds AS RECTL        ' Inclusive-inclusive bounds in device units
  cptl AS DWORD
  aptl(0 TO 0) AS POINTL    ' array size may vary
END TYPE

TYPE EMRPOLYLINE16
  pEmr AS emr
  rclBounds AS RECTL        ' Inclusive-inclusive bounds in device units
  cpts AS DWORD
  aptl(0 TO 0) AS POINTL    ' array size may vary
END TYPE

TYPE EMRPOLYBEZIER16
  pEmr AS emr
  rclBounds AS RECTL        ' Inclusive-inclusive bounds in device units
  cpts AS DWORD
  aptl(0 TO 0) AS POINTL    ' array size may vary
END TYPE

TYPE EMRPOLYGON16
  pEmr AS emr
  rclBounds AS RECTL        ' Inclusive-inclusive bounds in device units
  cpts AS DWORD
  aptl(0 TO 0) AS POINTL    ' array size may vary
END TYPE

TYPE EMRPOLYBEZIERTO16
  pEmr AS emr
  rclBounds AS RECTL        ' Inclusive-inclusive bounds in device units
  cpts AS DWORD
  aptl(0 TO 0) AS POINTL    ' array size may vary
END TYPE

TYPE EMRPOLYLINETO16
  pEmr AS emr
  rclBounds AS RECTL        ' Inclusive-inclusive bounds in device units
  cpts AS DWORD
  aptl(0 TO 0) AS POINTL    ' array size may vary
END TYPE

TYPE EMRPOLYDRAW
  pEmr AS EMR
  rclBounds AS RECTL         ' Inclusive-inclusive bounds in device units
  cptl AS DWORD              ' Number of points
  aptl(0 TO 0) AS POINTL     ' Array of points - array size may vary
  abTypes(0 TO 0) AS BYTE    ' Array of point types - array size may vary
END TYPE

TYPE EMRPOLYDRAW16
  pEmr AS EMR
  rclBounds AS RECTL         ' Inclusive-inclusive bounds in device units
  cpts AS DWORD              ' Number of points
  apts(0 TO 0) AS POINTS     ' Array of points - array size may vary
  abTypes(0 TO 0) AS BYTE    ' Array of point types - array size may vary
END TYPE

TYPE EMRPOLYPOLYLINE
  pEmr AS EMR
  rclBounds AS RECTL             ' Inclusive-inclusive bounds in device units
  nPolys AS DWORD                ' Number of polys
  cptl AS DWORD                  ' Total number of points in all polys
  aPolyCounts(0 TO 0) AS DWORD   ' Array of point counts for each poly - array size may vary
  aptl(0 TO 0) AS POINTL         ' Array of points - array size may vary
END TYPE

TYPE EMRPOLYPOLYLINE16
  pEmr AS EMR
  rclBounds AS RECTL             ' Inclusive-inclusive bounds in device units
  nPolys AS DWORD                ' Number of polys
  cpts AS DWORD                  ' Total number of points in all polys
  aPolyCounts(0 TO 0) AS DWORD   ' Array of point counts for each poly - array size may vary
  apts(0 TO 0) AS POINTS         ' Array of points - array size may vary
END TYPE

TYPE EMRINVERTRGN
  pEmr AS EMR
  rclBounds AS RECTL         ' Inclusive-inclusive bounds in device units
  cbRgnData AS DWORD         ' Size of region data in bytes
  RgnData(0 TO 0) AS BYTE    ' array size may vary
END TYPE

TYPE EMRFILLRGN
  pEmr AS EMR
  rclBounds AS RECTL         ' Inclusive-inclusive bounds in device units
  cbRgnData AS DWORD         ' Size of region data in bytes
  ihBrush AS DWORD           ' Brush handle index
  RgnData(0 TO 0) AS BYTE    ' array size may vary
END TYPE

TYPE EMRFRAMERGN
  pEmr AS EMR
  rclBounds AS RECTL         ' Inclusive-inclusive bounds in device units
  cbRgnData AS DWORD         ' Size of region data in bytes
  ihBrush AS DWORD           ' Brush handle index
  szlStroke AS SIZEL
  RgnData(0 TO 0) AS BYTE    ' array size may vary
END TYPE

TYPE EMRGRADIENTFILL
  pEmr AS EMR
  rclBounds AS RECTL         ' Inclusive-inclusive bounds in device units
  nVer AS DWORD
  nTri AS DWORD
  ulMode AS DWORD
  Ver(0 TO 0) AS TRIVERTEX   ' array size may vary
END TYPE

TYPE EMREXTSELECTCLIPRGN
  pEmr AS EMR
  cbRgnData AS DWORD         ' Size of region data in bytes
  iMode AS DWORD
  RgnData(0 TO 0) AS BYTE    ' array size may vary
END TYPE

TYPE EMREXTTEXTOUT
  pEmr AS EMR
  rclBounds AS RECTL         ' Inclusive-inclusive bounds in device units
  iGraphicsMode AS DWORD     ' Current graphics mode
  exScale AS DOUBLE          ' X and Y scales from Page units to .01mm units
  eyScale AS DOUBLE          '   if graphics mode is %GM_COMPATIBLE.
  pemrtext AS EMRTEXT        ' This is followed by the string and spacing array
END TYPE

TYPE EMRPOLYTEXTOUT
  pEmr AS EMR
  rclBounds AS RECTL          ' Inclusive-inclusive bounds in device units
  iGraphicsMode AS DWORD      ' Current graphics mode
  exScale AS DOUBLE           ' X and Y scales from Page units to .01mm units
  eyScale AS DOUBLE           '   if graphics mode is %GM_COMPATIBLE.
  cStrings AS LONG            '
  aemrtext(0 TO 0) AS EMRTEXT ' Array of EMRTEXT structures. This is followed
                              ' by the strings and spacing arrays.
END TYPE

TYPE EMRBITBLT
  pEmr AS EMR
  rclBounds AS RECTL      ' Inclusive-inclusive bounds in device units
  xDest AS LONG
  yDest AS LONG
  cxDest AS LONG
  cyDest AS LONG
  dwRop AS DWORD
  xSrc AS LONG
  ySrc AS LONG
  xformSrc AS XFORM       ' Source DC transform
  crBkColorSrc AS DWORD   ' Source DC BkColor in RGB
  iUsageSrc AS DWORD      ' Source bitmap info color table usage (%DIB_RGB_COLORS)
  offBmiSrc AS DWORD      ' Offset to the source BITMAPINFO structure
  cbBmiSrc AS DWORD       ' Size of the source BITMAPINFO structure
  offBitsSrc AS DWORD     ' Offset to the source bitmap bits
  cbBitsSrc AS DWORD      ' Size of the source bitmap bits
END TYPE

TYPE EMRSTRETCHBLT
  pEmr AS EMR
  rclBounds AS RECTL     ' Inclusive-inclusive bounds in device units
  xDest AS LONG
  yDest AS LONG
  cxDest AS LONG
  cyDest AS LONG
  dwRop AS DWORD
  xSrc AS LONG
  ySrc AS LONG
  xformSrc AS XFORM      ' Source DC transform
  crBkColorSrc AS DWORD  ' Source DC BkColor in RGB
  iUsageSrc AS DWORD     ' Source bitmap info color table usage (%DIB_RGB_COLORS)
  offBmiSrc AS DWORD     ' Offset to the source BITMAPINFO structure
  cbBmiSrc AS DWORD      ' Size of the source BITMAPINFO structure
  offBitsSrc AS DWORD    ' Offset to the source bitmap bits
  cbBitsSrc AS DWORD     ' Size of the source bitmap bits
  cxSrc AS LONG
  cySrc AS LONG
END TYPE

TYPE EMRMASKBLT
  pEmr AS EMR
  rclBounds AS RECTL     ' Inclusive-inclusive bounds in device units
  xDest AS LONG
  yDest AS LONG
  cxDest AS LONG
  cyDest AS LONG
  dwRop AS DWORD
  xSrc2 AS LONG
  cyDest2 AS LONG
  dwRop2 AS LONG
  xSrc AS LONG
  ySrc AS LONG
  xformSrc AS XFORM      ' Source DC transform
  crBkColorSrc AS DWORD  ' Source DC BkColor in RGB
  iUsageSrc AS DWORD     ' Source bitmap info color table usage (%DIB_RGB_COLORS)
  offBmiSrc AS DWORD     ' Offset to the source BITMAPINFO structure
  cbBmiSrc AS DWORD      ' Size of the source BITMAPINFO structure
  offBitsSrc AS DWORD    ' Offset to the source bitmap bits
  cbBitsSrc AS DWORD     ' Size of the source bitmap bits
  xMask AS LONG
  yMask AS LONG
  iUsageMask AS DWORD    ' Mask bitmap info color table usage
  offBmiMask AS DWORD    ' Offset to the mask BITMAPINFO structure if any
  cbBmiMask AS DWORD     ' Size of the mask BITMAPINFO structure if any
  offBitsMask AS DWORD   ' Offset to the mask bitmap bits if any
  cbBitsMask AS DWORD    ' Size of the mask bitmap bits if any
END TYPE

TYPE EMRPLGBLT
  pEmr AS EMR
  rclBounds AS RECTL          ' Inclusive-inclusive bounds in device units
  aptlDest(0 TO 2) AS POINTL
  xSrc AS LONG
  ySrc AS LONG
  cxSrc AS LONG
  cySrc AS LONG
  xformSrc AS XFORM           ' Source DC transform
  crBkColorSrc AS DWORD       ' Source DC BkColor in RGB
  iUsageSrc AS DWORD          ' Source bitmap info color table usage (%DIB_RGB_COLORS)
  offBmiSrc AS DWORD          ' Offset to the source BITMAPINFO structure
  cbBmiSrc AS DWORD           ' Size of the source BITMAPINFO structure
  offBitsSrc AS DWORD         ' Offset to the source bitmap bits
  cbBitsSrc AS DWORD          ' Size of the source bitmap bits
  xMask AS LONG
  yMask AS LONG
  iUsageMask AS DWORD         ' Mask bitmap info color table usage
  offBmiMask AS DWORD         ' Offset to the mask BITMAPINFO structure if any
  cbBmiMask AS DWORD          ' Size of the mask BITMAPINFO structure if any
  offBitsMask AS DWORD        ' Offset to the mask bitmap bits if any
  cbBitsMask AS DWORD         ' Size of the mask bitmap bits if any
END TYPE

TYPE EMRSETDIBITSTODEVICE
  pEmr AS EMR
  rclBounds AS RECTL    ' Inclusive-inclusive bounds in device units
  xDest AS LONG
  yDest AS LONG
  xSrc AS LONG
  ySrc AS LONG
  cxSrc AS LONG
  cySrc AS LONG
  offBmiSrc AS DWORD    ' Offset to the source BITMAPINFO structure
  cbBmiSrc AS DWORD     ' Size of the source BITMAPINFO structure
  offBitsSrc AS DWORD   ' Offset to the source bitmap bits
  cbBitsSrc AS DWORD    ' Size of the source bitmap bits
  iUsageSrc AS DWORD    ' Source bitmap info color table usage
  iStartScan AS DWORD
  cScans AS DWORD
END TYPE

TYPE EMRSTRETCHDIBITS
  pEmr AS EMR
  rclBounds AS RECTL    ' Inclusive-inclusive bounds in device units
  xDest AS LONG
  yDest AS LONG
  xSrc AS LONG
  ySrc AS LONG
  cxSrc AS LONG
  cySrc AS LONG
  offBmiSrc AS DWORD    ' Offset to the source BITMAPINFO structure
  cbBmiSrc AS DWORD     ' Size of the source BITMAPINFO structure
  offBitsSrc AS DWORD   ' Offset to the source bitmap bits
  cbBitsSrc AS DWORD    ' Size of the source bitmap bits
  iUsageSrc AS DWORD    ' Source bitmap info color table usage
  dwRop AS DWORD
  cxDest AS LONG
  cyDest AS LONG
END TYPE

TYPE EMREXTCREATEFONTINDIRECT
  pEmr AS emr
  ihFont AS DWORD
  elfw AS EXTLOGFONT
END TYPE

TYPE EMRALPHABLEND
  pEmr AS EMR
  rclBounds AS RECTL    ' Inclusive-inclusive bounds in device units
  xDest AS LONG
  yDest AS LONG
  cxDest AS LONG
  cyDest AS LONG
  dwRop AS DWORD
  xSrc AS LONG
  ySrc AS LONG
  xformSrc AS XFORM     ' Source DC transform
  crBkColorSrc AS DWORD ' Source DC BkColor in RGB
  iUsageSrc AS DWORD    ' Source bitmap info color table usage (%DIB_RGB_COLORS)
  offBmiSrc AS DWORD    ' Offset to the source BITMAPINFO structure
  cbBmiSrc AS DWORD     ' Size of the source BITMAPINFO structure
  offBitsSrc AS DWORD   ' Offset to the source bitmap bits
  cbBitsSrc AS DWORD    ' Size of the source bitmap bits
  cxSrc AS LONG
  cySrc AS LONG
END TYPE

TYPE EMRTRANSPARENTBLT
  pEmr AS EMR
  rclBounds AS RECTL    ' Inclusive-inclusive bounds in device units
  xDest AS LONG
  yDest AS LONG
  cxDest AS LONG
  cyDest AS LONG
  dwRop AS DWORD
  xSrc AS LONG
  ySrc AS LONG
  xformSrc AS XFORM     ' Source DC transform
  crBkColorSrc AS DWORD ' Source DC BkColor in RGB
  iUsageSrc AS DWORD    ' Source bitmap info color table usage (%DIB_RGB_COLORS)
  offBmiSrc AS DWORD    ' Offset to the source BITMAPINFO structure
  cbBmiSrc AS DWORD     ' Size of the source BITMAPINFO structure
  offBitsSrc AS DWORD   ' Offset to the source bitmap bits
  cbBitsSrc AS DWORD    ' Size of the source bitmap bits
  cxSrc AS LONG
  cySrc AS LONG
END TYPE

TYPE EMRCREATEPALETTE
  pEmr AS EMR
  ihPal AS DWORD       ' Palette handle index
  lgpl AS LOGPALETTE   ' The peFlags fields in the palette entries
                       ' do not contain any flags
END TYPE

TYPE EMRCREATECOLORSPACE
  pEmr AS EMR
  ihCS AS DWORD           ' ColorSpace handle index
  lcs AS LOGCOLORSPACE
END TYPE

TYPE EMRCREATEPEN
  pEmr AS EMR
  ihPen AS DWORD    ' Pen handle index
  lopn AS LOGPEN
END TYPE

TYPE EMREXTCREATEPEN
  pEmr AS EMR
  ihPen AS DWORD    ' Pen handle index
  offBmi AS DWORD   ' Offset to the BITMAPINFO structure if any
  cbBmi AS DWORD    ' Size of the BITMAPINFO structure if any
                    ' The bitmap info is followed by the bitmap bits
                    ' to form a packed DIB.
  offBits AS DWORD  ' Offset to the brush bitmap bits if any
  cbBits AS DWORD   ' Size of the brush bitmap bits if any
  elp AS EXTLOGPEN  ' The extended pen with the style array
END TYPE

TYPE EMRCREATEBRUSHINDIRECT
  pEmr AS EMR
  ihBrush AS DWORD   ' Brush handle index
  lb AS LOGBRUSH     ' The style must be %BS_SOLID, %BS_HOLLOW, %BS_NULL or
                     ' %BS_HATCHED.
END TYPE

TYPE EMRCREATEMONOBRUSH
  pEmr AS EMR
  ihBrush AS DWORD   ' Brush handle index
  iUsage AS DWORD    ' Bitmap info color table usage
  offBmi AS DWORD    ' Offset to the BITMAPINFO structure
  cbBmi AS DWORD     ' Size of the BITMAPINFO structure
  offBits AS DWORD   ' Offset to the bitmap bits
  cbBits AS DWORD    ' Size of the bitmap bits
END TYPE

TYPE EMRCREATEDIBPATTERNBRUSHPT
  pEmr AS EMR
  ihBursh AS DWORD   ' Brush handle index
  iUsage AS DWORD    ' Bitmap info color table usage
  offBmi AS DWORD    ' Offset to the BITMAPINFO structure
  cbBmi AS DWORD     ' Size of the BITMAPINFO structure
                     ' The bitmap info is followed by the bitmap bits
                     ' to form a packed DIB.
  offBits AS DWORD   ' Offset to the bitmap bits
  cbBits AS DWORD    ' Size of the bitmap bits
END TYPE

TYPE EMRFORMAT
  dSignature AS DWORD   ' Format signature, e.g. %ENHMETA_SIGNATURE.
  nVersion AS DWORD     ' Format version number.
  cbData AS DWORD       ' Size of data in bytes.
  offData AS DWORD      ' Offset to data from %GDICOMMENT_IDENTIFIER.
                        ' It must begin at a DWORD offset.
END TYPE

TYPE EMRGLSRECORD
  pEmr AS EMR
  cbData AS DWORD         ' Size of data in bytes
  bData(0 TO 0) AS BYTE   ' size of array may vary
END TYPE

TYPE EMRGLSBOUNDEDRECORD
  pEmr AS EMR
  rclBounds AS RECTL      ' Bounds in recording coordinates
  cbData AS DWORD         ' Size of data in bytes
  bData(0 TO 0) AS BYTE   ' size of array may vary
END TYPE

TYPE EMRPIXELFORMAT
  pEmr AS EMR
  pfd AS PIXELFORMATDESCRIPTOR
END TYPE

TYPE EMRSETICMPROFILE
  pEmr AS EMR
  dwFlags AS DWORD       ' flags
  cbName AS DWORD        ' Size of desired profile name
  cbData AS DWORD        ' Size of raw profile data if attached
  bData(0 TO 0) AS BYTE  ' Array size is cbName and cbData - array size may vary
END TYPE

#ENDIF ' #IF NOT %DEF(%NOMETAFILE) '-------------------------------------------

TYPE POINTFLOAT
  x AS DOUBLE
  y AS DOUBLE
END TYPE

TYPE GLYPHMETRICSFLOAT
  gmfBlackBoxX AS DOUBLE
  gmfBlackBoxY AS DOUBLE
  gmfptGlyphOrigin AS POINTFLOAT
  gmfCellIncX AS DOUBLE
  gmfCellIncY AS DOUBLE
END TYPE

' Layer plane descriptor
TYPE LAYERPLANEDESCRIPTOR
  nSize AS WORD
  nVersion AS WORD
  dwFlags AS DWORD
  iPixelType AS BYTE
  cColorBits AS BYTE
  cRedBits AS BYTE
  cRedShift AS BYTE
  cGreenBits AS BYTE
  cGreenShift AS BYTE
  cBlueBits AS BYTE
  cBlueShift AS BYTE
  cAlphaBits AS BYTE
  cAlphaShift AS BYTE
  cAccumBits AS BYTE
  cAccumRedBits AS BYTE
  cAccumGreenBits AS BYTE
  cAccumBlueBits AS BYTE
  cAccumAlphaBits AS BYTE
  cDepthBits AS BYTE
  cStencilBits AS BYTE
  cAuxBuffers AS BYTE
  iLayerPlane AS BYTE
  bReserved AS BYTE
  crTransparent AS DWORD
END TYPE

TYPE WGLSWAP
  hdc AS DWORD
  uiFlags AS DWORD
END TYPE

#ENDIF ' #IF NOT %DEF(%NOGDI) -------------------------------------------------

' End of types from wingdi.h ==================================================

TYPE DISPLAY_DEVICE
  cb AS DWORD
  DeviceName AS ASCIIZ * 32
  DeviceString AS ASCIIZ * 128
  StateFlags AS DWORD
END TYPE

#IF NOT %DEF(%NOGDI) '---------------------------------------------------------

TYPE NONCLIENTMETRICS
  cbSize AS DWORD
  iBorderWidth AS LONG
  iScrollWidth AS LONG
  iScrollHeight AS LONG
  iCaptionWidth AS LONG
  iCaptionHeight AS LONG
   lfCaptionFont AS LOGFONT
  iSMCaptionWidth AS LONG
  iSMCaptionHeight AS LONG
  lfSMCaptionFont AS LOGFONT
  iMenuWidth AS LONG
  iMenuHeight AS LONG
  lfMenuFont AS LOGFONT
  lfStatusFont AS LOGFONT
  lfMessageFont AS LOGFONT
END TYPE

TYPE EMRPOLYPOLYGON
  pEmr AS emr
  rclBounds AS RECTL
  nPolys AS DWORD
  cptl AS DWORD
  aPolyCounts(0 TO 0) AS DWORD         ' array size may vary
  aptl(0 TO 0) AS POINTL               ' array size may vary
END TYPE

TYPE EMRPOLYPOLYGON16
  pEmr AS emr
  rclBounds AS RECTL
  nPolys AS DWORD
  cpts AS DWORD
  aPolyCounts(0 TO 0) AS DWORD         ' array size may vary
  apts(0 TO 0) AS POINTS               ' array size may vary
END TYPE

TYPE EMRPAINTRGN
  pEmr AS emr
  rclBounds AS RECTL
  cbRgnData AS DWORD
  RgnData(0 TO 0) AS BYTE              ' array size may vary
END TYPE

#ENDIF ' #IF NOT %DEF(%NOGDI) -------------------------------------------------

' HCBT_ACTIVATE structure pointed to by lParam
TYPE CBTACTIVATESTRUCT
  fMouse AS LONG
  hWndActive AS LONG
END TYPE

' Message Structure used in Journaling
TYPE EVENTMSG
  message AS DWORD
  paramL AS DWORD
  paramH AS DWORD
  time AS DWORD
  hWnd AS DWORD
END TYPE

TYPE CWPSTRUCT
  lParam AS LONG
  wParam AS DWORD
  message AS DWORD
  hWnd AS DWORD
END TYPE

TYPE DEBUGHOOKINFO
  hModuleHook AS DWORD
  Reserved AS DWORD
  lParam AS LONG
  wParam AS DWORD
  code AS LONG
END TYPE


TYPE MOUSEHOOKSTRUCT
  pt AS POINTAPI
  hWnd AS DWORD
  wHitTestCode AS DWORD
  dwExtraInfo AS DWORD
END TYPE

' Message structure

TYPE MINMAXINFO
  ptReserved AS POINTAPI
  ptMaxSize AS POINTAPI
  ptMaxPosition AS POINTAPI
  ptMinTrackSize AS POINTAPI
  ptMaxTrackSize AS POINTAPI
END TYPE

TYPE COPYDATASTRUCT
  dwData AS DWORD
  cbData AS DWORD
  lpData AS LONG
END TYPE

' WM_WINDOWPOSCHANGING/CHANGED struct pointed to by lParam
TYPE WINDOWPOS
  hWnd AS DWORD
  hWndInsertAfter AS DWORD
  x AS LONG
  y AS LONG
  cx AS LONG
  cy AS LONG
  flags AS DWORD
END TYPE

TYPE NCCALCSIZE_PARAMS
    rgrc(0 TO 2) AS RECT
    lppos AS WINDOWPOS PTR
END TYPE

TYPE ACCELAPI WORD
  fVirt AS BYTE
  key AS WORD
  cmd AS WORD
END TYPE

TYPE PAINTSTRUCT
  hDC AS DWORD
  fErase AS LONG
  rcPaint AS RECT
  fRestore AS LONG
  fIncUpdate AS LONG
  rgbReserved(0 TO 31) AS BYTE
END TYPE

TYPE CREATESTRUCT
  lpCreateParams AS LONG
  hInstance AS DWORD
  hMenu AS DWORD
  hwndParent AS DWORD
  cy AS LONG
  cx AS LONG
  y AS LONG
  x AS LONG
  style AS LONG
  lpszName AS ASCIIZ PTR
  lpszClass AS ASCIIZ PTR
  dwExStyle AS DWORD
END TYPE

' HCBT_CREATEWND parameters pointed to by lParam
TYPE CBT_CREATEWND
  lpcs AS CREATESTRUCT
  hWndInsertAfter AS DWORD
END TYPE

TYPE WINDOWPLACEMENT
  Length AS DWORD
  flags AS DWORD
  showCmd AS DWORD
  ptMinPosition AS POINTAPI
  ptMaxPosition AS POINTAPI
  rcNormalPosition AS RECT
END TYPE

' MEASUREITEMSTRUCT for ownerdraw
TYPE MEASUREITEMSTRUCT
  CtlType AS DWORD
  CtlID AS DWORD
  itemID AS DWORD
  itemWidth AS DWORD
  itemHeight AS DWORD
  itemData AS DWORD
END TYPE

' DRAWITEMSTRUCT for ownerdraw
TYPE DRAWITEMSTRUCT
  CtlType AS DWORD
  CtlID AS DWORD
  itemID AS DWORD
  itemAction AS DWORD
  itemState AS DWORD
  hwndItem AS LONG
  hDC AS DWORD
  rcItem AS RECT
  itemData AS DWORD
END TYPE

' DELETEITEMSTRUCT for ownerdraw
TYPE DELETEITEMSTRUCT
  CtlType AS DWORD
  CtlID AS DWORD
  itemID AS DWORD
  hwndItem AS LONG
  itemData AS DWORD
END TYPE

' COMPAREITEMSTRUCT for ownerdraw sorting
TYPE COMPAREITEMSTRUCT
  CtlType AS DWORD
  CtlID AS DWORD
  hwndItem AS LONG
  itemID1 AS DWORD
  itemData1 AS DWORD
  itemID2 AS DWORD
  itemData2 AS DWORD
END TYPE

TYPE DLGTEMPLATE
  style           AS DWORD
  dwExtendedStyle AS DWORD
  cdit            AS INTEGER
  x               AS INTEGER
  y               AS INTEGER
  cx              AS INTEGER
  cy              AS INTEGER
END TYPE

TYPE DLGITEMTEMPLATE
  Style         AS DWORD
  ExtendedStyle AS DWORD
  x             AS INTEGER
  y             AS INTEGER
  cx            AS INTEGER
  cy            AS INTEGER
  ID            AS WORD
END TYPE

' Menu item resource format
TYPE MENUITEMTEMPLATEHEADER
  versionNumber AS WORD
  offset AS WORD
END TYPE

TYPE MENUITEMTEMPLATE
  mtOption AS WORD
  mtID AS WORD
  mtString AS WORD    ' one or more, repeated
END TYPE

TYPE ICONINFO
  fIcon AS LONG
  xHotspot AS DWORD
  yHotspot AS DWORD
  hbmMask AS LONG
  hbmColor AS LONG
END TYPE

TYPE MDICREATESTRUCT
  szClass AS ASCIIZ PTR
  szTitle AS ASCIIZ PTR
  hOwner AS DWORD
  x AS LONG
  y AS LONG
  cx AS LONG
  cy AS LONG
  style AS DWORD
  lParam AS LONG
END TYPE

TYPE CLIENTCREATESTRUCT
  hWindowMenu AS LONG
  idFirstChild AS DWORD
END TYPE

'  Help engine section.

TYPE MULTIKEYHELP
  mkSize AS DWORD
  mkKeylist AS STRING * 1
  szKeyphrase AS ASCIIZ * 253   ' arbitrary string length: change as needed
END TYPE

TYPE HELPWININFO
  wStructSize AS LONG
  x AS LONG
  y AS LONG
  dx AS LONG
  dy AS LONG
  wMax AS LONG
  rgchMember AS ASCIIZ * 2
END TYPE

' ----------------------------------------------------------------------------

TYPE DDEACK
  bAppReturnCode AS BYTE
  bFlags AS BYTE         ' bit flags
END TYPE

TYPE DDEADVISE
  wFlags AS WORD         ' bit flags
  cfFormat AS INTEGER
END TYPE

TYPE DDEDATA
  wFlags AS WORD         ' bit flags
  cfFormat AS INTEGER
  bValue(0 TO 0) AS BYTE ' array length may vary
END TYPE

TYPE DDEPOKE
  wFlags AS WORD         ' bit flags
  cfFormat AS INTEGER
  bValue(0 TO 0) AS BYTE ' array length may vary
END TYPE

TYPE DDELN
  wFlags AS WORD         ' bit flags
  cfFormat AS INTEGER
END TYPE

TYPE DDEUP
  wFlags AS WORD         ' bit flags
  cfFormat AS INTEGER
  xRGB(0 TO 0) AS BYTE   ' array length may vary
END TYPE

TYPE HSZPAIR
  hszSvc AS LONG
  hszTopic AS DWORD
END TYPE

TYPE CONVCONTEXT
  cb AS DWORD
  wFlags AS DWORD      ' yes, this is supposed to be a DWORD
  wCountryID AS DWORD  ' yes, this is supposed to be a DWORD
  iCodePage AS LONG
  dwLangID AS DWORD
  dwSecurity AS DWORD
  qos AS SECURITY_QUALITY_OF_SERVICE
END TYPE

TYPE CONVINFO
  cb AS DWORD
  hUser AS DWORD
  hConvPartner AS LONG
  hszSvcPartner AS LONG
  hszServiceReq AS LONG
  hszTopic AS DWORD
  hszItem AS DWORD
  wFmt AS DWORD
  wType AS DWORD
  wStatus AS DWORD
  wConvst AS DWORD
  wLastError AS DWORD
  hConvList AS DWORD
  ConvCtxt AS CONVCONTEXT
  hWnd AS DWORD
  hwndPartner AS LONG
END TYPE

TYPE DDEML_MSG_HOOK_DATA
  uiLo AS DWORD              'unpacked lo and hi parts of lParam
  uiHi AS DWORD
  cbData AS DWORD            'bytes of data in message. May be > than 32 bytes.
  xData(0 TO 7) AS DWORD     'data peeking by DDESPY is limited to 32 bytes.
END TYPE

TYPE MONMSGSTRUCT
  cb AS DWORD
  hWndTo AS DWORD
  dwTime AS DWORD
  htask AS LONG
  wMsg AS DWORD
  wParam AS DWORD
  lParam AS LONG
  dmhd AS DDEML_MSG_HOOK_DATA
END TYPE

TYPE MONCBSTRUCT
  cb AS DWORD
  dwTime AS DWORD
  htask AS LONG
  dwRet AS DWORD
  wType AS DWORD
  wFmt AS DWORD
  hConv AS DWORD
  hsz1 AS DWORD
  hsz2 AS DWORD
  hData AS DWORD
  dwData1 AS DWORD
  dwData2 AS DWORD
  cc AS CONVCONTEXT
  cbData AS DWORD
  xData(0 TO 7) AS DWORD
END TYPE

TYPE MONHSZSTRUCT
  cb AS DWORD
  fsAction AS LONG          'MH_ value
  dwTime AS DWORD
  hsz AS DWORD
  htask AS LONG
  str AS STRING * 1
END TYPE

TYPE MONERRSTRUCT
  cb AS DWORD
  wLastError AS DWORD
  dwTime AS DWORD
  htask AS LONG
END TYPE

TYPE MONLINKSTRUCT
  cb AS DWORD
  dwTime AS DWORD
  htask AS LONG
  fEstablished AS LONG
  fNoData AS LONG
  hszSvc AS LONG
  hszTopic AS DWORD
  hszItem AS DWORD
  wFmt AS DWORD
  fServer AS LONG
  hConvServer AS LONG
  hConvClient AS LONG
END TYPE

TYPE MONCONVSTRUCT
  cb AS DWORD
  fConnect AS LONG
  dwTime AS DWORD
  htask AS LONG
  hszSvc AS LONG
  hszTopic AS DWORD
  hConvClient AS LONG       'Globally unique value != apps local hConv
  hConvServer AS LONG       'Globally unique value != apps local hConv
END TYPE

TYPE smpte
  hour AS BYTE
  minute AS BYTE
  sec AS BYTE
  FRAME AS BYTE
  fps AS BYTE
  dummy AS BYTE
  pad(0 TO 1) AS BYTE
END TYPE

TYPE midi
  songptrpos AS DWORD
END TYPE

UNION pbMMTIMEunion
  ms AS DWORD
  sample AS DWORD
  cb AS DWORD
  ticks AS DWORD
  pbsmpte AS smpte
  pbsongptrpos AS midi
END UNION

TYPE MMTIME
  wType AS DWORD
  pbMMTIME AS pbMMTIMEunion
END TYPE

TYPE MIDIEVENT
  dwDeltaTime AS DWORD       'Ticks since last event
  dwStreamID AS DWORD        'Reserved; must be zero
  dwEvent AS DWORD           'Event type and parameters
  dwParms(0 TO 0) AS DWORD   'Parameters, if long event (array size may vary)
END TYPE

TYPE MIDISTRMBUFFVER
  dwVersion AS LONG          'Stream buffer format version
  dwMid AS LONG              'Manufacturer ID as defined in MMREG.H
  dwOEMVersion AS LONG       'Manufacturer version for custom ext
END TYPE

'  Type codes which go in the high byte of the event DWORD of a stream buffer

'  Type codes 00-7F contain parameters within the low 24 bits
'  Type codes 80-FF contain a length of their parameter in the low 24
'  bits, followed by their parameter data in the buffer. The event
'  DWORD contains the exact byte length; the parm data itself must be
'  padded to be an even multiple of 4 Byte long.

TYPE MIDIPROPTIMEDIV
  cbStruct AS DWORD
  dwTimeDiv AS DWORD
END TYPE

TYPE MIDIPROPTEMPO
  cbStruct AS DWORD
  dwTempo AS DWORD
END TYPE

TYPE MIXERCAPS
  wMid AS WORD                          'manufacturer id
  wPid AS WORD                          'product id
  vDriverVersion AS DWORD               'version of the driver
  szPname AS ASCIIZ * %MAXPNAMELEN      'product name
  fdwSupport AS DWORD                   'misc. support bits
  cDestinations AS DWORD                'count of destinations
END TYPE

TYPE Target           'for use in MIXERLINE and others (embedded structure)
  dwType AS DWORD            'MIXERLINE_TARGETTYPE_xxxx
  dwDeviceID AS DWORD        'target device ID of device type
  wMid AS WORD               'of target device
  wPid AS WORD               '"
  vDriverVersion AS DWORD    '"
  szPname AS ASCIIZ * %MAXPNAMELEN
END TYPE

TYPE MIXERLINE
  cbStruct AS DWORD          'size of MIXERLINE structure
  dwDestination AS DWORD     'zero based destination index
  dwSource AS DWORD          'zero based source index (if source)
  dwLineID AS DWORD          'unique line id for mixer device
  fdwLine AS DWORD           'state/information about line
  dwUser AS DWORD            'driver specific information
  dwComponentType AS DWORD   'component type line connects to
  cChannels AS DWORD         'number of channels line supports
  cConnections AS DWORD      'number of connections (possible)
  cControls AS DWORD         'number of controls at this line
  szShortName AS ASCIIZ * %MIXER_SHORT_NAME_CHARS
  szName AS ASCIIZ * %MIXER_LONG_NAME_CHARS
  lpTarget AS Target
END TYPE

'   MIXERCONTROL

TYPE pblMIXERCONTROL
  lMinimum AS LONG
  lMaximum AS LONG
END TYPE

TYPE pbdwMIXERCONTROL
  lMinimum AS DWORD
  lMaximum AS DWORD
END TYPE

UNION pbBounds
  lMinMax AS pblMIXERCONTROL
  dwMinMax AS pbdwMIXERCONTROL
  dwReserved(0 TO 5) AS DWORD
END UNION

UNION pbMetrics
  cSteps AS DWORD
  cbCustomData AS DWORD
  dwReserved(0 TO 5) AS DWORD
END UNION

TYPE MIXERCONTROL
  cbStruct AS DWORD            'size in Byte of MIXERCONTROL
  dwControlID AS DWORD         'unique control id for mixer device
  dwControlType AS DWORD       'MIXERCONTROL_CONTROLTYPE_xxx
  fdwControl AS DWORD          'MIXERCONTROL_CONTROLF_xxx
  cMultipleItems AS DWORD      'if MIXERCONTROL_CONTROLF_MULTIPLE set
  szShortName AS ASCIIZ * %MIXER_SHORT_NAME_CHARS
  szName AS ASCIIZ * %MIXER_LONG_NAME_CHARS
  Bounds AS pbBounds
  Metrics AS pbMetrics
END TYPE
'
'   MIXERCONTROL.fdwControl

'   MIXERLINECONTROLS
'
TYPE MIXERLINECONTROLS
  cbStruct AS DWORD              'size in Byte of MIXERLINECONTROLS
  dwLineID AS DWORD              'line id (from MIXERLINE.dwLineID)
  item AS DWORD                  'dwControlID or dwControlType
  cControls AS DWORD             'count of controls pmxctrl points to
  cbmxctrl AS DWORD              'size in Byte of _one_ MIXERCONTROL
  pamxctrl AS MIXERCONTROL PTR   'pointer to first MIXERCONTROL array
END TYPE

TYPE MIXERCONTROLDETAILS
  cbStruct AS DWORD              'size in Byte of MIXERCONTROLDETAILS
  dwControlID AS DWORD           'control id to get/set details on
  cChannels AS DWORD             'number of channels in paDetails array
  item AS DWORD                  'hwndOwner or cMultipleItems
  cbDetails AS DWORD             'size of _one_ details_XX struct
  paDetails AS LONG              'pointer to array of details_XX structs
END TYPE

'   MIXER_GETCONTROLDETAILSF_LISTTEXT

TYPE MIXERCONTROLDETAILS_LISTTEXT
  dwParam1 AS DWORD
  dwParam2 AS DWORD
  szName AS ASCIIZ * %MIXER_LONG_NAME_CHARS
END TYPE

'   MIXER_GETCONTROLDETAILSF_VALUE

TYPE MIXERCONTROLDETAILS_BOOLEAN
  fValue AS LONG
END TYPE

TYPE MIXERCONTROLDETAILS_SIGNED
  lValue AS LONG
END TYPE

TYPE MIXERCONTROLDETAILS_UNSIGNED
  dwValue AS DWORD
END TYPE

TYPE JOYINFOEX
  dwSize AS DWORD           'size of structure
  dwFlags AS DWORD          'flags to indicate what to return
  dwXpos AS DWORD           'x position
  dwYpos AS DWORD           'y position
  dwZpos AS DWORD           'z position
  dwRpos AS DWORD           'rudder/4th axis position
  dwUpos AS DWORD           '5th axis position
  dwVpos AS DWORD           '6th axis position
  dwButtons AS DWORD        'button states
  dwButtonNumber AS DWORD   'current button number pressed
  dwPOV AS DWORD            'point of view state
  dwReserved1 AS DWORD      'reserved for communication between winmm driver
  dwReserved2 AS DWORD      'reserved for future expansion
END TYPE

TYPE DRVCONFIGINFO
  dwDCISize AS DWORD
  lpszDCISectionName AS ASCIIZ PTR
  lpszDCIAliasName AS ASCIIZ PTR
END TYPE

TYPE WAVEHDR
  lpData AS ASCIIZ PTR
  dwBufferLength AS DWORD
  dwBytesRecorded AS DWORD
  dwUser AS DWORD
  dwFlags AS DWORD
  dwLoops AS DWORD
  lpNext AS LONG
  Reserved AS DWORD
END TYPE

TYPE WAVEOUTCAPS
  wMid AS WORD
  wPid AS WORD
  vDriverVersion AS DWORD
  szPname AS ASCIIZ * %MAXPNAMELEN
  dwFormats AS DWORD
  wChannels AS WORD
  wReserved1 AS WORD
  dwSupport AS DWORD
END TYPE

TYPE WAVEINCAPS
  wMid AS WORD
  wPid AS WORD
  vDriverVersion AS DWORD
  szPname AS ASCIIZ * %MAXPNAMELEN
  dwFormats AS DWORD
  wChannels AS WORD
  wReserved1 AS WORD
END TYPE

TYPE WAVEFORMAT
  wFormatTag AS WORD
  nChannels AS WORD
  nSamplesPerSec AS DWORD
  nAvgBytesPerSec AS DWORD
  nBlockAlign AS WORD
END TYPE

TYPE WAVEFORMATEX
  wFormatTag AS WORD
  nChannels AS WORD
  nSamplesPerSec AS DWORD
  nAvgBytesPerSec AS DWORD
  nBlockAlign AS WORD
  wBitsPerSample AS WORD
  cbSize AS WORD
END TYPE

TYPE PCMWAVEFORMAT
  wf AS WAVEFORMAT
  wBitsPerSample AS WORD
END TYPE

TYPE MIDIOUTCAPS
  wMid AS WORD
  wPid AS WORD
  vDriverVersion AS DWORD
  szPname AS ASCIIZ * %MAXPNAMELEN
  wTechnology AS WORD
  wVoices AS WORD
  wNotes AS WORD
  wChannelMask AS WORD
  dwSupport AS DWORD
END TYPE

TYPE MIDIINCAPS
  wMid AS WORD
  wPid AS WORD
  vDriverVersion AS DWORD
  szPname AS ASCIIZ * %MAXPNAMELEN
  dwSupport AS DWORD
END TYPE

TYPE MIDIHDR
  lpData AS ASCIIZ PTR
  dwBufferLength AS DWORD
  dwBytesRecorded AS DWORD
  dwUser AS DWORD
  dwFlags AS DWORD
  lpNext AS LONG
  Reserved AS DWORD
  dwOffset AS DWORD
  dwReserved(0 TO 7) AS DWORD
END TYPE

TYPE AUXCAPS
  wMid AS WORD
  wPid AS WORD
  vDriverVersion AS DWORD
  szPname AS ASCIIZ * %MAXPNAMELEN
  wTechnology AS WORD
  dwSupport AS DWORD
END TYPE

TYPE TIMECAPS
  wPeriodMin AS DWORD
  wPeriodMax AS DWORD
END TYPE

TYPE JOYCAPS
  wMid AS WORD
  wPid AS WORD
  szPname AS ASCIIZ * %MAXPNAMELEN
  wXmin AS DWORD
  wXmax AS DWORD
  wYmin AS DWORD
  wYmax AS DWORD
  wZmin AS DWORD
  wZmax AS DWORD
  wNumButtons AS DWORD
  wPeriodMin AS DWORD
  wPeriodMax AS DWORD
  wRmin AS DWORD
  wRmax AS DWORD
  wUmin AS DWORD
  wUmax AS DWORD
  wVmin AS DWORD
  wVmax AS DWORD
  wCaps AS DWORD
  wMaxAxes AS DWORD
  wNumAxes AS DWORD
  wMaxButtons AS DWORD
  szRegKey AS ASCIIZ * %MAXPNAMELEN
  szOEMVxD AS ASCIIZ * %MAX_JOYSTICKOEMVXDNAME
END TYPE

TYPE JOYINFO
  wXpos AS DWORD
  wYpos AS DWORD
  wZpos AS DWORD
  wButtons AS DWORD
END TYPE

TYPE MMIOINFO
  dwFlags AS DWORD
  fccIOProc AS LONG
  pIOProc AS LONG
  wErrorRet AS DWORD
  htask AS LONG
  cchBuffer AS LONG
  pchBuffer AS ASCIIZ PTR
  pchNext AS ASCIIZ PTR
  pchEndRead AS ASCIIZ PTR
  pchEndWrite AS ASCIIZ PTR
  lBufOffset AS LONG
  lDiskOffset AS LONG
  adwInfo(0 TO 3) AS DWORD
  dwReserved1 AS DWORD
  dwReserved2 AS DWORD
  hmmio AS DWORD
END TYPE

TYPE MMCKINFO
  ckid AS LONG
  ckSize AS DWORD
  fccType AS LONG
  dwDataOffset AS DWORD
  dwFlags AS DWORD
END TYPE

TYPE MCI_GENERIC_PARMS
  dwCallback AS DWORD
END TYPE

TYPE MCI_OPEN_PARMS
  dwCallback AS DWORD
  wDeviceId AS DWORD
  lpstrDeviceType AS ASCIIZ PTR
  lpstrElementName AS ASCIIZ PTR
  lpstrAlias AS ASCIIZ PTR
END TYPE

TYPE MCI_PLAY_PARMS
  dwCallback AS DWORD
  dwFrom AS DWORD
  dwTo AS DWORD
END TYPE

TYPE MCI_SEEK_PARMS
  dwCallback AS DWORD
  dwTo AS DWORD
END TYPE

TYPE MCI_STATUS_PARMS
  dwCallback AS DWORD
  dwReturn AS DWORD
  dwItem AS DWORD
  dwTrack AS DWORD
END TYPE

TYPE MCI_INFO_PARMS
  dwCallback AS DWORD
  lpstrReturn AS ASCIIZ PTR
  dwRetSize AS DWORD
END TYPE

TYPE MCI_GETDEVCAPS_PARMS
  dwCallback AS DWORD
  dwReturn AS DWORD
  dwIten AS DWORD
END TYPE

TYPE MCI_SYSINFO_PARMS
  dwCallback AS DWORD
  lpstrReturn AS ASCIIZ PTR
  dwRetSize AS DWORD
  dwNumber AS DWORD
  wDeviceType AS DWORD
END TYPE

TYPE MCI_SET_PARMS
  dwCallback AS DWORD
  dwTimeFormat AS DWORD
  dwAudio AS DWORD
END TYPE

TYPE MCI_BREAK_PARMS
  dwCallback AS DWORD
  nVirtKey AS LONG
  hwndBreak AS LONG
END TYPE

TYPE MCI_SAVE_PARMS
  dwCallback AS DWORD
  lpFileName AS ASCIIZ PTR
END TYPE

TYPE MCI_LOAD_PARMS
  dwCallback AS DWORD
  lpFileName AS ASCIIZ PTR
END TYPE

TYPE MCI_RECORD_PARMS
  dwCallback AS DWORD
  dwFrom AS DWORD
  dwTo AS DWORD
END TYPE

TYPE MCI_VD_PLAY_PARMS
  dwCallback AS DWORD
  dwFrom AS DWORD
  dwTo AS DWORD
  dwSpeed AS DWORD
END TYPE

TYPE MCI_VD_STEP_PARMS
  dwCallback AS DWORD
  dwFrames AS DWORD
END TYPE

TYPE MCI_VD_ESCAPE_PARMS
  dwCallback AS DWORD
  lpstrCommand AS ASCIIZ PTR
END TYPE

TYPE MCI_WAVE_OPEN_PARMS
  dwCallback AS DWORD
  wDeviceID AS DWORD
  lpstrDeviceType AS ASCIIZ PTR
  lpstrElementName AS ASCIIZ PTR
  lpstrAlias AS ASCIIZ PTR
  dwBufferSeconds AS DWORD
END TYPE

TYPE MCI_WAVE_DELETE_PARMS
  dwCallback AS DWORD
  dwFrom AS DWORD
  dwTo AS DWORD
END TYPE

TYPE MCI_WAVE_SET_PARMS
  dwCallback AS DWORD
  dwTimeFormat AS DWORD
  dwAudio AS DWORD
  wInput AS DWORD
  wOutput AS DWORD
  wFormatTag AS WORD
  wReserved2 AS WORD
  nChannels AS WORD
  wReserved3 AS WORD
  nSamplesPerSec AS DWORD
  nAvgBytesPerSec AS DWORD
  nBlockAlign AS WORD
  wReserved4 AS WORD
  wBitsPerSample AS WORD
  wReserved5 AS WORD
END TYPE

TYPE MCI_SEQ_SET_PARMS
  dwCallback AS DWORD
  dwTimeFormat AS DWORD
  dwAudio AS DWORD
  dwTempo AS DWORD
  dwPort AS DWORD
  dwSlave AS DWORD
  dwMaster AS DWORD
  dwOffset AS DWORD
END TYPE

TYPE MCI_ANIM_OPEN_PARMS
  dwCallback AS DWORD
  wDeviceID AS DWORD
  lpstrDeviceType AS ASCIIZ PTR
  lpstrElementName AS ASCIIZ PTR
  lpstrAlias AS ASCIIZ PTR
  dwStyle AS DWORD
  hwndParent AS DWORD
END TYPE

TYPE MCI_ANIM_PLAY_PARMS
  dwCallback AS DWORD
  dwFrom AS DWORD
  dwTo AS DWORD
  dwSpeed AS DWORD
END TYPE

TYPE MCI_ANIM_STEP_PARMS
  dwCallback AS DWORD
  dwFrames AS DWORD
END TYPE

TYPE MCI_ANIM_WINDOW_PARMS
  dwCallback AS DWORD
  hWnd AS DWORD
  nCmdShow AS DWORD
  lpstrText AS ASCIIZ PTR
END TYPE

TYPE MCI_ANIM_RECT_PARMS
  dwCallback AS DWORD
  rc AS RECT
END TYPE

TYPE MCI_ANIM_UPDATE_PARMS
  dwCallback AS DWORD
  rc AS RECT
  hDC AS DWORD
END TYPE

TYPE MCI_OVLY_OPEN_PARMS
  dwCallback AS DWORD
  wDeviceId AS DWORD
  lpstrDeviceType AS ASCIIZ PTR
  lpstrElementName AS ASCIIZ PTR
  lpstrAlias AS ASCIIZ PTR
  dwStyle AS DWORD
  hwndParent AS DWORD
END TYPE

TYPE MCI_OVLY_WINDOW_PARMS
  dwCallback AS DWORD
  hWnd AS DWORD
  nCmdShow AS DWORD
  lpstrText AS ASCIIZ PTR
END TYPE

TYPE MCI_OVLY_RECT_PARMS
  dwCallback AS DWORD
  rc AS RECT
END TYPE

TYPE MCI_OVLY_SAVE_PARMS
  dwCallback AS DWORD
  lpFileName AS ASCIIZ PTR
  rc AS RECT
END TYPE

TYPE MCI_OVLY_LOAD_PARMS
  dwCallback AS DWORD
  lpFileName AS ASCIIZ PTR
  rc AS RECT
END TYPE

' -------------
' Print APIs
' -------------

TYPE PRINTER_INFO_1
  flags AS DWORD
  pDescription AS ASCIIZ PTR
  pName AS ASCIIZ PTR
  pComment AS ASCIIZ PTR
END TYPE

#IF NOT %DEF(%NOGDI) '---------------------------------------------------------

TYPE PRINTER_INFO_2
  pServerName AS ASCIIZ PTR
  pPrinterName AS ASCIIZ PTR
  pShareName AS ASCIIZ PTR
  pPortName AS ASCIIZ PTR
  pDriverName AS ASCIIZ PTR
  pComment AS ASCIIZ PTR
  pLocation AS ASCIIZ PTR
  pDevMode AS DEVMODE PTR
  pSepFile AS ASCIIZ PTR
  pPrintProcessor AS ASCIIZ PTR
  pDatatype AS ASCIIZ PTR
  pParameters AS ASCIIZ PTR
  pSecurityDescriptor AS SECURITY_DESCRIPTOR PTR
  Attributes AS DWORD
  Priority AS DWORD
  DefaultPriority AS DWORD
  StartTime AS DWORD
  UntilTime AS DWORD
  STATUS AS DWORD
  cJobs AS DWORD
  AveragePPM AS DWORD
END TYPE

#ENDIF ' #IF NOT %DEF(%NOGDI) -------------------------------------------------

TYPE PRINTER_INFO_3
  pSecurityDescriptor AS SECURITY_DESCRIPTOR PTR
END TYPE

TYPE PRINTER_INFO_4
  pPrinterName AS ASCIIZ PTR
  pServerName AS ASCIIZ PTR
  Attributes AS DWORD
END TYPE

TYPE PRINTER_INFO_5
  pPrinterName AS ASCIIZ PTR
  pPortName AS ASCIIZ PTR
  Attributes AS DWORD
  DeviceNotSelected AS DWORD
  TransmissionRetryTimeout AS DWORD
END TYPE

TYPE PRINTER_INFO_6
  dwStatus AS DWORD
END TYPE

TYPE JOB_INFO_1
  JobId AS DWORD
  pPrinterName AS ASCIIZ PTR
  pMachineName AS ASCIIZ PTR
  pUserName AS ASCIIZ PTR
  pDocument AS ASCIIZ PTR
  pDatatype AS ASCIIZ PTR
  pStatus AS ASCIIZ PTR
  STATUS AS DWORD
  Priority AS DWORD
  Position AS DWORD
  TotalPages AS DWORD
  PagesPrinted AS DWORD
  Submitted AS SYSTEMTIME
END TYPE

#IF NOT %DEF(%NOGDI) '---------------------------------------------------------

TYPE JOB_INFO_2
  JobId AS DWORD
  pPrinterName AS ASCIIZ PTR
  pMachineName AS ASCIIZ PTR
  pUserName AS ASCIIZ PTR
  pDocument AS ASCIIZ PTR
  pNotifyName AS ASCIIZ PTR
  pDatatype AS ASCIIZ PTR
  pPrintProcessor AS ASCIIZ PTR
  pParameters AS ASCIIZ PTR
  pDriverName AS ASCIIZ PTR
  pDevMode AS DEVMODE PTR
  pStatus AS ASCIIZ PTR
  pSecurityDescriptor AS SECURITY_DESCRIPTOR PTR
  STATUS AS DWORD
  Priority AS DWORD
  Position AS DWORD
  StartTime AS DWORD
  UntilTime AS DWORD
  TotalPages AS DWORD
  nSize AS DWORD
  Submitted AS SYSTEMTIME
  time AS DWORD
  PagesPrinted AS DWORD
END TYPE

#ENDIF ' #IF NOT %DEF(%NOGDI) -------------------------------------------------

TYPE JOB_INFO_3
  JobId AS DWORD
  NextJobId AS DWORD
  Reserved AS DWORD
END TYPE

TYPE ADDJOB_INFO_1
  Path AS ASCIIZ PTR
  JobId AS DWORD
END TYPE

TYPE DRIVER_INFO_1
  pName AS ASCIIZ PTR
END TYPE

TYPE DRIVER_INFO_2
  cVersion AS DWORD
  pName AS ASCIIZ PTR
  pEnvironment AS ASCIIZ PTR
  pDriverPath AS ASCIIZ PTR
  pDataFile AS ASCIIZ PTR
  pConfigFile AS ASCIIZ PTR
END TYPE

TYPE DRIVER_INFO_3
  cVersion AS DWORD
  pName AS ASCIIZ PTR
  pEnvironment AS ASCIIZ PTR
  pDriverPath AS ASCIIZ PTR
  pDataFile AS ASCIIZ PTR
  pConfigFile AS ASCIIZ PTR
  pHelpFile AS ASCIIZ PTR
  pDependentFiles AS ASCIIZ PTR
  pMonitorName AS ASCIIZ PTR
  pDefaultDataType AS ASCIIZ PTR
END TYPE

TYPE DOC_INFO_1
  pDocName AS ASCIIZ PTR
  pOutputFile AS ASCIIZ PTR
  pDatatype AS ASCIIZ PTR
END TYPE

TYPE DOC_INFO_2
  pDocName AS ASCIIZ PTR
  pOutputFile AS ASCIIZ PTR
  pDatatype AS ASCIIZ PTR
  dwMode AS DWORD
  JobId AS DWORD
END TYPE

TYPE FORM_INFO_1
  Flags AS DWORD
  pName AS ASCIIZ PTR
  nSize AS SIZEL
  ImageableArea AS RECTL
END TYPE

TYPE PRINTPROCESSOR_INFO_1
  pName AS ASCIIZ PTR
END TYPE

TYPE PORT_INFO_1
  pName AS ASCIIZ PTR
END TYPE

TYPE PORT_INFO_2
  pPortName AS ASCIIZ PTR
  pMonitorName AS ASCIIZ PTR
  pDescription AS ASCIIZ PTR
  fPortType AS DWORD
  Reserved AS DWORD
END TYPE

TYPE PORT_INFO_3
  dwStatus AS DWORD
  pszStatus AS ASCIIZ PTR
  dwSeverity AS DWORD
END TYPE

TYPE MONITOR_INFO_1
  pName AS ASCIIZ PTR
END TYPE

TYPE MONITOR_INFO_2
  pName AS ASCIIZ PTR
  pEnvironment AS ASCIIZ PTR
  pDLLName AS ASCIIZ PTR
END TYPE

TYPE DATATYPES_INFO_1
  pName AS ASCIIZ PTR
END TYPE

#IF NOT %DEF(%NOGDI) '---------------------------------------------------------

TYPE PRINTER_DEFAULTS
  pDatatype AS ASCIIZ PTR
  pDevMode AS DEVMODE PTR
  DesiredAccess AS DWORD
END TYPE

#ENDIF ' #IF NOT %DEF(%NOGDI) -------------------------------------------------

TYPE PROVIDOR_INFO_1
  pName AS ASCIIZ PTR
  pEnvironment AS ASCIIZ PTR
  pDLLName AS ASCIIZ PTR
END TYPE

' Types from winnetwk.h =======================================================

TYPE NETRESOURCE
  dwScope AS DWORD
  dwType AS DWORD
  dwDisplayType AS DWORD
  dwUsage AS DWORD
  lpLocalName AS ASCIIZ PTR
  lpRemoteName AS ASCIIZ PTR
  lpComment AS ASCIIZ PTR
  lpProvider AS ASCIIZ PTR
END TYPE

TYPE CONNECTDLGSTRUCT
  cbStructure AS DWORD          ' size of this structure in bytes
  hwndOwner AS DWORD            ' owner window for the dialog (HWND)
  lpConnRes AS NETRESOURCE PTR  ' requested resource info
  dwFlags AS DWORD              ' flags
  dwDevNum AS DWORD             ' number of devices connected to
END TYPE

TYPE DISCDLGSTRUCT
  cbStructure AS DWORD          ' size of this structure in bytes
  hwndOwner AS DWORD            ' owner window for the dialog (HWND)
  lpLocalName AS ASCIIZ PTR     ' local device name
  lpRemoteName AS ASCIIZ PTR    ' network resource name
  dwFlags AS DWORD              ' flags
END TYPE

TYPE UNIVERSAL_NAME_INFO
  lpUniversalName AS ASCIIZ PTR
END TYPE

TYPE REMOTE_NAME_INFO
  lpUniversalName AS ASCIIZ PTR
  lpConnectionName AS ASCIIZ PTR
  lpRemainingPath AS ASCIIZ PTR
END TYPE

TYPE NETINFOSTRUCT
  cbStructure AS DWORD
  dwProviderVersion AS DWORD
  dwStatus AS DWORD
  dwCharacteristics AS DWORD
  dwHandle AS DWORD
  wNetType AS WORD
  dwPrinters AS DWORD
  dwDrives AS DWORD
END TYPE

TYPE NETCONNECTINFOSTRUCT
  cbStructure AS DWORD
  dwFlags AS DWORD
  dwSpeed AS DWORD
  dwDelay AS DWORD
  dwOptDataSize AS DWORD
END TYPE

' End of types from winnetwk.h ================================================

' Types from nb30.h ===========================================================

TYPE NCB
  ncb_command AS BYTE                   ' command code
  ncb_retcode AS BYTE                   ' return code
  ncb_lsn AS BYTE                       ' local session number
  ncb_num AS BYTE                       ' number of our network name
  ncb_buffer AS ASCIIZ PTR              ' address of message buffer
  ncb_length AS WORD                    ' size of message buffer
  ncb_callname AS STRING * %NCBNAMSZ    ' blank-padded name of remote
  ncb_name AS STRING * %NCBNAMSZ        ' our blank-padded netname
  ncb_rto AS BYTE                       ' rcv timeout/retry count
  ncb_sto AS BYTE                       ' send timeout/sys timeout
  ncb_post AS DWORD                     ' POST routine address (callback)
  ncb_lana_num AS BYTE                  ' lana (adapter) number
  ncb_cmd_cplt AS BYTE                  ' &HFF => command pending
  ncb_reserve(0 TO 9) AS BYTE           ' reserved, used by BIOS
  ncb_event AS DWORD                    ' HANDLE to Win32 event which will
                                        ' be set to the signalled state
                                        ' when an ASYNCH command completes
END TYPE

TYPE ADAPTER_STATUS
  adapter_address(0 TO 5) AS BYTE
  rev_major AS BYTE
  reserved0 AS BYTE
  adapter_type AS BYTE
  rev_minor AS BYTE
  duration AS WORD
  frmr_recv AS WORD
  frmr_xmit AS WORD
  iframe_recv_err AS WORD
  xmit_aborts AS WORD
  xmit_success AS DWORD
  recv_success AS DWORD
  iframe_xmit_err AS WORD
  recv_buff_unavail AS WORD
  t1_timeouts AS WORD
  ti_timeouts AS WORD
  reserved1 AS DWORD
  free_ncbs AS WORD
  max_cfg_ncbs AS WORD
  max_ncbs AS WORD
  xmit_buf_unavail AS WORD
  max_dgram_size AS WORD
  pending_sess AS WORD
  max_cfg_sess AS WORD
  max_sess AS WORD
  max_sess_pkt_size AS WORD
  name_count AS WORD
END TYPE

TYPE NAME_BUFFER
  xname AS STRING * %NCBNAMSZ
  name_num AS BYTE
  name_flags AS BYTE
END TYPE

TYPE SESSION_HEADER
  sess_name AS BYTE
  num_sess AS BYTE
  rcv_dg_outstanding AS BYTE
  rcv_any_outstanding AS BYTE
END TYPE

TYPE SESSION_BUFFER
  lsn AS BYTE
  STATE AS BYTE
  local_name AS STRING * %NCBNAMSZ
  remote_name AS STRING * %NCBNAMSZ
  rcvs_outstanding AS BYTE
  sends_outstanding AS BYTE
END TYPE

TYPE LANA_ENUM
  length AS BYTE
  lana(0 TO %MAX_LANA) AS BYTE  ' yes, this is of size (%MAX_LANA + 1)
END TYPE

TYPE FIND_NAME_HEADER
  node_count AS WORD
  reserved AS BYTE
  unique_group AS BYTE
END TYPE

TYPE FIND_NAME_BUFFER
  length AS BYTE
  access_control AS BYTE
  frame_control AS BYTE
  destination_addr(0 TO 5) AS BYTE
  source_addr(0 TO 5) AS BYTE
  routing_info(0 TO 17) AS BYTE
END TYPE

TYPE ACTION_HEADER
  transport_id AS DWORD
  action_code AS WORD
  reserved AS WORD
END TYPE

' End of types from nb30.h ====================================================

TYPE CRGB
  bRed AS BYTE
  bGreen AS BYTE
  bBlue AS BYTE
  bExtra AS BYTE
END TYPE

TYPE SERVICE_STATUS
  dwServiceType AS DWORD
  dwCurrentState AS DWORD
  dwControlsAccepted AS DWORD
  dwWin32ExitCode AS DWORD
  dwServiceSpecificExitCode AS DWORD
  dwCheckPoint AS DWORD
  dwWaitHint AS DWORD
END TYPE

TYPE ENUM_SERVICE_STATUS
  lpServiceName AS ASCIIZ PTR
  lpDisplayName AS ASCIIZ PTR
  ServiceStatus AS SERVICE_STATUS
END TYPE

TYPE QUERY_SERVICE_LOCK_STATUS
  fIsLocked AS DWORD
  lpLockOwner AS ASCIIZ PTR
  dwLockDuration AS DWORD
END TYPE

TYPE QUERY_SERVICE_CONFIG
  dwServiceType AS DWORD
  dwStartType AS DWORD
  dwErrorControl AS DWORD
  lpBinaryPathName AS ASCIIZ PTR
  lpLoadOrderGroup AS ASCIIZ PTR
  dwTagId AS DWORD
  lpDependencies AS ASCIIZ PTR
  lpServiceStartName AS ASCIIZ PTR
  lpDisplayName AS ASCIIZ PTR
END TYPE

TYPE SERVICE_TABLE_ENTRY
  lpServiceName AS ASCIIZ PTR
  lpServiceProc AS LONG
END TYPE

TYPE PERF_DATA_BLOCK
  Signature AS ASCIIZ * 4
  LittleEndian AS DWORD
  Version AS DWORD
  Revision AS DWORD
  TotalByteLength AS DWORD
  HeaderLength AS DWORD
  NumObjectTypes AS DWORD
  DefaultObject AS LONG
  SystemTime AS SYSTEMTIME
  PerfTime AS QUAD
  PerfFreq AS QUAD
  PerTime100nSec AS QUAD
  SystemNameLength AS DWORD
  SystemNameOffset AS DWORD
END TYPE

TYPE PERF_OBJECT_TYPE
  TotalByteLength AS DWORD
  DefinitionLength AS DWORD
  HeaderLength AS DWORD
  ObjectNameTitleIndex AS DWORD
  ObjectNameTitle AS LONG              ' pointer to Unicode string
  ObjectHelpTitleIndex AS DWORD
  ObjectHelpTitle AS LONG              ' pointer to Unicode string
  DetailLevel AS DWORD
  NumCounters AS DWORD
  DefaultCounter AS LONG
  NumInstances AS LONG
  CodePage AS DWORD
  PerfTime AS QUAD
  PerfFreq AS QUAD
END TYPE

TYPE PERF_COUNTER_DEFINITION
  ByteLength AS DWORD
  CounterNameTitleIndex AS DWORD
  CounterNameTitle AS LONG             ' pointer to Unicode string
  CounterHelpTitleIndex AS DWORD
  CounterHelpTitle AS LONG             ' pointer to Unicode string
  DefaultScale AS LONG
  DetailLevel AS DWORD
  CounterType AS DWORD
  CounterSize AS DWORD
  CounterOffset AS DWORD
END TYPE

TYPE PERF_INSTANCE_DEFINITION
  ByteLength AS DWORD
  ParentObjectTitleIndex AS DWORD
  ParentObjectInstance AS DWORD
  UniqueID AS LONG
  NameOffset AS DWORD
  NameLength AS LONG
END TYPE

TYPE PERF_COUNTER_BLOCK
  ByteLength AS DWORD
END TYPE

' Types from imm.h ============================================================

TYPE COMPOSITIONFORM
  dwStyle AS DWORD
  ptCurrentPos AS POINTAPI
  rcArea AS RECT
END TYPE

TYPE CANDIDATEFORM
  dwIndex AS DWORD
  dwStyle AS DWORD
  ptCurrentPos AS POINTAPI
  rcArea AS RECT
END TYPE

TYPE CANDIDATELIST
  dwSize AS DWORD
  dwStyle AS DWORD
  dwCount AS DWORD
  dwSelection AS DWORD
  dwPageStart AS DWORD
  dwPageSize AS DWORD
  dwOffset(0 TO 0) AS DWORD            ' array size may vary
END TYPE

TYPE REGISTERWORD
  lpReading AS ASCIIZ PTR
  lpWord AS ASCIIZ PTR
END TYPE

TYPE RECONVERTSTRING
  dwSize AS DWORD
  dwVersion AS DWORD
  dwStrLen AS DWORD
  dwStrOffset AS DWORD
  dwCompStrLen AS DWORD
  dwCompStrOffset AS DWORD
  dwTargetStrLen AS DWORD
  dwTargetStrOffset AS DWORD
END TYPE

TYPE STYLEBUF
  dwStyle AS DWORD
  szDescription AS ASCIIZ * %STYLE_DESCRIPTION_SIZE
END TYPE

TYPE IMEMENUITEMINFO
  cbSize AS DWORD
  fType AS DWORD
  fState AS DWORD
  wID AS DWORD
  hbmpChecked AS DWORD
  hbmpUnchecked AS DWORD
  dwItemData AS DWORD
  szString AS ASCIIZ * %IMEMENUITEM_STRING_SIZE
  hbmpItem AS DWORD
END TYPE

' End of types from imm.h =====================================================

' Types from ime.h ============================================================

TYPE IMESTRUCT
  fnc AS DWORD         ' function code
  wParam AS DWORD      ' "word" parameter
  wCount AS DWORD      ' "word" counter
  dchSource AS DWORD   ' offset to Source from top of memory object
  dchDest AS DWORD     ' offset to Destination from top of memory object
  lParam1 AS LONG
  lParam2 AS LONG
  lParam3 AS LONG
END TYPE

' UNDETERMINESTRING structure for IR_UNDETERMINE
'
TYPE UNDETERMINESTRUCT
    dwSize AS DWORD
    uDefIMESize AS DWORD
    uDefIMEPos AS DWORD
    uUndetTextLen AS DWORD
    uUndetTextPos AS DWORD
    uUndetAttrPos AS DWORD
    uCursorPos AS DWORD
    uDeltaStart AS DWORD
    uDetermineTextLen AS DWORD
    uDetermineTextPos AS DWORD
    uDetermineDelimPos AS DWORD
    uYomiTextLen AS DWORD
    uYomiTextPos AS DWORD
    uYomiDelimPos AS DWORD
END TYPE

TYPE STRINGEXSTRUCT
    dwSize AS DWORD
    uDeterminePos AS DWORD
    uDetermineDelimPos AS DWORD
    uYomiPos AS DWORD
    uYomiDelimPos AS DWORD
END TYPE

' End of types from ime.h =====================================================

TYPE MODEMDEVCAPS
  dwActualSize AS DWORD
  dwRequiredSize AS DWORD
  dwDevSpecificOffset AS DWORD
  dwDevSpecificSize AS DWORD

  ' product and version identification
  dwModemProviderVersion AS DWORD
  dwModemManufacturerOffset AS DWORD
  dwModemManufacturerSize AS DWORD
  dwModemModelOffset AS DWORD
  dwModemModelSize AS DWORD
  dwModemVersionOffset AS DWORD
  dwModemVersionSize AS DWORD

  ' local option capabilities
  dwDialOptions AS LONG                 'bitmap of supported values
  dwCallSetupFailTimer AS LONG          'maximum in seconds
  dwInactivityTimeout AS LONG           'maximum in seconds
  dwSpeakerVolume AS LONG               'bitmap of supported values
  dwSpeakerMode AS LONG                 'bitmap of supported values
  dwModemOptions AS LONG                'bitmap of supported values
  dwMaxDTERate AS LONG                  'maximum value in bit/s
  dwMaxDCERate AS LONG                  'maximum value in bit/s

  ' Variable portion for proprietary expansion
  abVariablePortion(0 TO 0) AS BYTE     ' array size may vary
END TYPE

TYPE MODEMSETTINGS
  dwActualSize AS DWORD
  dwRequiredSize AS DWORD
  dwDevSpecificOffset AS DWORD
  dwDevSpecificSize AS DWORD

  ' static local options (read/write)
  dwCallSetupFailTimer AS DWORD         'seconds
  dwInactivityTimeout AS DWORD          'seconds
  dwSpeakerVolume AS DWORD              'level
  dwSpeakerMode AS DWORD                'mode
  dwPreferredModemOptions AS DWORD      'bitmap

  ' negotiated options (read only) for current or last call
  dwNegotiatedModemOptions AS DWORD     'bitmap
  dwNegotiatedDCERate AS DWORD          'bit/s

  ' Variable portion for proprietary expansion
  abVariablePortion(0 TO 0) AS BYTE     ' array size may vary
END TYPE

TYPE DRAGINFO
  uSize AS DWORD              'init with sizeof(DRAGINFO)
  pt AS POINTAPI
  fNC AS LONG
  lpFileList AS ASCIIZ PTR
  grfKeyState AS DWORD
END TYPE

' AppBar stuff

TYPE APPBARDATA
  cbSize AS DWORD
  hwnd AS DWORD
  uCallbackMessage AS DWORD
  uEdge AS DWORD
  rc AS RECT
  lParam AS LONG              'message specific
END TYPE

TYPE SHFILEOPSTRUCT
  hwnd AS DWORD
  wFunc AS DWORD
  pFrom AS ASCIIZ PTR
  pTo AS ASCIIZ PTR
  fFlags AS WORD
  fAnyOperationsAborted AS LONG
  hNameMappings AS DWORD
  lpszProgressTitle AS ASCIIZ PTR       'only used if FOF_SIMPLEPROGRESS
END TYPE

TYPE SHNAMEMAPPING
  pszOldPath AS ASCIIZ PTR
  pszNewPath AS ASCIIZ PTR
  cchOldPath AS LONG
  cchNewPath AS LONG
END TYPE

TYPE SHELLEXECUTEINFO
  cbSize AS DWORD
  fMask AS DWORD
  hwnd AS DWORD
  lpVerb AS ASCIIZ PTR
  lpFile AS ASCIIZ PTR
  lpParameters AS ASCIIZ PTR
  lpDirectory AS ASCIIZ PTR
  nShow AS LONG
  hInstApp AS DWORD
  ' Optional fields
  lpIDList AS DWORD
  lpClass AS ASCIIZ PTR
  hkeyClass AS DWORD
  dwHotKey AS DWORD
  item AS DWORD           ' hIcon or hMonitor value
  hProcess AS DWORD
END TYPE

TYPE SHQUERYRBINFO
  cbSize AS DWORD
  i64Size AS QUAD
  i64NumItems AS QUAD
END TYPE

TYPE NOTIFYICONDATA
  cbSize AS DWORD
  hwnd AS DWORD
  uID AS DWORD
  uFlags AS DWORD
  uCallbackMessage AS DWORD
  hIcon AS DWORD
  szTip AS ASCIIZ * 64
END TYPE

TYPE SHFILEINFO
  hIcon AS DWORD                        'out: icon
  iIcon AS LONG                         'out: icon index
  dwAttributes AS DWORD                 'out: SFGAO_ flags
  szDisplayName AS ASCIIZ * %MAX_PATH   'out: display name (or path)
  szTypeName AS ASCIIZ * 80             'out: type name
END TYPE

TYPE VS_FIXEDFILEINFO
  dwSignature AS DWORD
  dwStrucVersion AS DWORD              ' e.g. &H00000042 = "0.42"
  dwFileVersionMS AS DWORD             ' e.g. &H00030075 = "3.75"
  dwFileVersionLS AS DWORD             ' e.g. &H00000031 = "0.31"
  dwProductVersionMS AS DWORD          ' e.g. &H00030010 = "3.10"
  dwProductVersionLS AS DWORD          ' e.g. &H00000031 = "0.31"
  dwFileFlagsMask AS DWORD             ' = &H3F for version "0.42"
  dwFileFlags AS DWORD                 ' e.g. VFF_DEBUG OR %VFF_PRERELEASE
  dwFileOS AS DWORD                    ' e.g. VOS_DOS_WINDOWS16
  dwFileType AS DWORD                  ' e.g. VFT_DRIVER
  dwFileSubtype AS DWORD               ' e.g. VFT2_DRV_KEYBOARD
  dwFileDateMS AS DWORD                ' e.g. 0
  dwFileDateLS AS DWORD                ' e.g. 0
END TYPE

#IF NOT %DEF(%NOGDI)
TYPE ICONMETRICS
  cbSize AS DWORD
  iHorzSpacing AS LONG
  iVertSpacing AS LONG
  iTitleWrap AS LONG
  lfFont AS LOGFONT
END TYPE
#ENDIF

TYPE HELPINFO
  cbSize AS DWORD
  iContextType AS LONG
  iCtrlId AS LONG
  hItemHandle AS LONG
  dwContextId AS DWORD
  MousePos AS POINTAPI
END TYPE

TYPE ANIMATIONINFO
  cbSize AS DWORD
  iMinAnimate AS LONG
END TYPE

TYPE SERIALKEYS
  cbSize AS DWORD
  dwFlags AS DWORD
  lpszActivePort AS ASCIIZ PTR
  lpszPort AS ASCIIZ PTR
  iBaudRate AS DWORD
  iPortState AS DWORD
  iActive AS DWORD
END TYPE

TYPE MINIMIZEDMETRICS
  cbSize AS DWORD
  iWidth AS LONG
  iHorzGap AS LONG
  iVertGap AS LONG
  iArrange AS LONG
END TYPE

TYPE OSVERSIONINFO
  dwOSVersionInfoSize AS DWORD
  dwMajorVersion AS DWORD
  dwMinorVersion AS DWORD
  dwBuildNumber AS DWORD
  dwPlatformId AS DWORD
  szCSDVersion AS ASCIIZ * 128          'Maintenance string for PSS usage
END TYPE

TYPE OSVERSIONINFOEX
  dwOSVersionInfoSize AS DWORD
  dwMajorVersion AS DWORD
  dwMinorVersion AS DWORD
  dwBuildNumber AS DWORD
  dwPlatformId AS DWORD
  szCSDVersion AS ASCIIZ * 128          'Maintenance string for PSS usage
  wServicePackMajor AS WORD
  wServicePackMinor AS WORD
  wSuiteMask AS WORD
  wProductType AS BYTE
  wReserved AS BYTE
END TYPE

TYPE SYSTEM_POWER_STATUS
  ACLineStatus AS BYTE
  BatteryFlag AS BYTE
  BatteryLifePercent AS BYTE
  Reserved1 AS BYTE
  BatteryLifeTime AS DWORD
  BatteryFullLifeTime AS DWORD
END TYPE

TYPE NMHDR
  hwndFrom AS DWORD
  idfrom AS DWORD
  code AS LONG    ' used for messages, so needs to be LONG, not DWORD...
END TYPE

TYPE STYLESTRUCT
  styleOld AS DWORD
  styleNew AS DWORD
END TYPE

TYPE DEVNAMES
  wDriverOffset AS WORD
  wDeviceOffset AS WORD
  wOutputOffset AS WORD
  wDefault AS WORD
END TYPE

TYPE COMMCONFIG
  dwSize AS DWORD
  wVersion AS WORD
  wReserved AS WORD
  dcbx AS DCB
  dwProviderSubType AS DWORD
  dwProviderOffset AS DWORD
  dwProviderSize AS DWORD
END TYPE

TYPE DRAWTEXTPARAMS
  cbSize AS DWORD
  iTabLength AS LONG
  iLeftMargin AS LONG
  iRightMargin AS LONG
  uiLengthDrawn AS DWORD
END TYPE

TYPE MENUITEMINFO
  cbSize AS DWORD
  fMask AS DWORD
  fType AS DWORD
  fState AS DWORD
  wID AS DWORD
  hSubMenu AS LONG
  hbmpChecked AS LONG
  hbmpUnchecked AS LONG
  dwItemData AS DWORD
  dwTypeData AS ASCIIZ PTR
  cch AS DWORD
END TYPE

TYPE SCROLLINFO
  cbSize AS DWORD
  fMask AS DWORD
  nMin AS LONG
  nMax AS LONG
  nPage AS DWORD
  nPos AS LONG
  nTrackPos AS LONG
END TYPE

TYPE MSGBOXPARAMS
  cbSize AS DWORD
  hWndOwner AS DWORD
  hInstance AS DWORD
  lpszText AS ASCIIZ PTR
  lpszCaption AS ASCIIZ PTR
  dwStyle AS DWORD
  lpszIcon AS ASCIIZ PTR
  dwContextHelpId AS DWORD
  lpfnMsgBoxCallback AS LONG
  dwLanguageId AS DWORD
END TYPE

TYPE EXCEPTION_DEBUG_INFO
  ExceptionRecord AS EXCEPTION_RECORD
  dwFirstChange AS DWORD
END TYPE

TYPE CREATE_THREAD_DEBUG_INFO
  hThread AS DWORD
  lpThreadLocalBase AS DWORD
  lpStartAddress AS DWORD
END TYPE

TYPE CREATE_PROCESS_DEBUG_INFO
  hFile AS DWORD
  hProcess AS DWORD
  hThread AS DWORD
  lpBaseOfImage AS DWORD
  dwDebugInfoFileOffset AS DWORD
  nDebugInfoSize AS DWORD
  lpThreadLocalBase AS DWORD
  lpStartAddress AS DWORD
  lpImageName AS DWORD PTR
  fUnicode AS WORD
END TYPE

TYPE EXIT_THREAD_DEBUG_INFO
  dwExitCode AS DWORD
END TYPE

TYPE EXIT_PROCESS_DEBUG_INFO
  dwExitCode AS DWORD
END TYPE

TYPE OUTPUT_DEBUG_STRING_INFO
  lpDebugStringData AS ASCIIZ PTR
  fUnicode AS WORD
  nDebugStringLength AS WORD
END TYPE

TYPE RIP_INFO
  dwError AS DWORD
  dwType AS DWORD
END TYPE

UNION DEBUGEVENTUNION
  deuException AS EXCEPTION_DEBUG_INFO
  deuCreateThread AS CREATE_THREAD_DEBUG_INFO
  deuCreateProcessInfo AS CREATE_PROCESS_DEBUG_INFO
  deuExitThread AS EXIT_THREAD_DEBUG_INFO
  deuExitProcess AS EXIT_PROCESS_DEBUG_INFO
  deuLoadDll AS LOAD_DLL_DEBUG_INFO
  deuUnloadDll AS UNLOAD_DLL_DEBUG_INFO
  deuDebugString AS OUTPUT_DEBUG_STRING_INFO
  deuRipInfo AS RIP_INFO
END UNION

TYPE DEBUG_EVENT
  dwDebugEventCode AS DWORD
  dwProcessId AS DWORD
  dwThreadId AS DWORD
  u AS DebugEventUnion
END TYPE

TYPE TBBUTTON
  iBitmap AS LONG
  idCommand AS LONG
  fsState AS BYTE
  fsStyle AS BYTE
  bReserved(0 TO 1) AS BYTE
  dwData AS DWORD
  iString AS LONG
END TYPE

TYPE COLORMAP
  cmFrom AS DWORD
  cmTo AS DWORD
END TYPE

TYPE TBNOTIFY
  hdr AS NMHDR
  iItem AS LONG
  BUTTON AS TBBUTTON
  cchText AS LONG
  pszText AS ASCIIZ PTR
END TYPE

TYPE TBREPLACEBITMAP
  hInstOld AS DWORD
  nIDOld AS DWORD
  hInstNew AS DWORD
  nIDNew AS DWORD
  nButtons AS LONG
END TYPE

TYPE TBSAVEPARAMSA
  hkr AS LONG
  pszSubKey AS ASCIIZ PTR
  pszValueName AS ASCIIZ PTR
END TYPE

TYPE TBADDBITMAP
  hInst AS DWORD
  nID AS DWORD
END TYPE

TYPE TOOLINFO
  cbSize AS DWORD
  uFlags AS DWORD
  hwnd AS DWORD
  uId AS DWORD
  rec AS RECT
  hinst AS DWORD
  lpszText AS ASCIIZ PTR
  lParam AS LONG
END TYPE

TYPE TOOLTIPTEXT
  hdr AS NMHDR
  lpszText AS ASCIIZ PTR
  szText AS ASCIIZ * 80
  hinst AS DWORD
  uFlags AS DWORD
  lParam AS DWORD
END TYPE

TYPE HDHITTESTINFO
  pt AS POINTAPI
  flags AS DWORD
  iItem AS LONG
END TYPE

TYPE IMAGE_EXPORT_DIRECTORY
  Characteristics AS DWORD
  TimeDateStamp AS DWORD
  MajorVersion AS WORD
  MinorVersion AS WORD
  nName AS DWORD
  nBase AS DWORD
  NumberOfFunctions AS DWORD
  NumberOfNames AS DWORD
  AddressOfFunctions AS DWORD PTR
  AddressOfNames AS DWORD PTR
  AddressOfNameOrdinals AS WORD PTR
END TYPE

TYPE ShortItemId
  cb   AS LONG
  abID AS BYTE
END TYPE

TYPE ITEMIDLIST
  mkid AS ShortItemId
END TYPE

TYPE BROWSEINFO
  hWndOwner      AS DWORD
  pIDLRoot       AS DWORD
  pszDisplayName AS ASCIIZ PTR
  lpszTitle      AS ASCIIZ PTR
  ulFlags        AS DWORD
  lpfnCallback   AS DWORD
  lParam         AS LONG
  iImage         AS LONG
END TYPE

TYPE HW_PROFILE_INFO
  dwDockInfo      AS DWORD
  szHwProfileGuid AS ASCIIZ * %HW_PROFILE_GUIDLEN
  szHwProfileName AS ASCIIZ * %MAX_PROFILE_LEN
END TYPE

' Functions from wingdi.h =====================================================

#IF NOT %DEF(%NOGDI) '---------------------------------------------------------
#IF %DEF(%CCWIN) '--------------------------------------------------------

  FUNCTION MAKEROP4 (BYVAL dFore AS DWORD, BYVAL dBack AS DWORD) AS DWORD
    SHIFT LEFT dBack, 8
    dBack = (dBack AND &HFF000000???)
    FUNCTION = (dBack OR dFore)
  END FUNCTION

  FUNCTION GetKValue (BYVAL dwCMYK AS DWORD) AS BYTE
    FUNCTION = (dwCMYK AND &HFF???)
  END FUNCTION

  FUNCTION GetYValue (BYVAL dwCMYK AS DWORD) AS BYTE
    SHIFT RIGHT dwCMYK, 8
    FUNCTION = (dwCMYK AND &HFF???)
  END FUNCTION

  FUNCTION GetMValue (BYVAL dwCMYK AS DWORD) AS BYTE
    SHIFT RIGHT dwCMYK, 16
    FUNCTION = (dwCMYK AND &HFF???)
  END FUNCTION

  FUNCTION GetCValue (BYVAL dwCMYK AS DWORD) AS BYTE
    SHIFT RIGHT dwCMYK, 24
    FUNCTION = (dwCMYK AND &HFF???)
  END FUNCTION

  FUNCTION CMYK (BYVAL c AS BYTE, BYVAL m AS BYTE, BYVAL y AS BYTE, BYVAL k AS BYTE) AS DWORD
    LOCAL dwCMYKtmp AS DWORD
    LOCAL dwCMYKacc AS DWORD
    dwCMYKacc = c
    SHIFT LEFT dwCMYKacc, 24
    dwCMYKtmp = m
    SHIFT LEFT dwCMYKtmp, 16
    dwCMYKacc = (dwCMYKacc OR dwCMYKtmp)
    dwCMYKtmp = y
    SHIFT LEFT dwCMYKtmp, 8
    FUNCTION= (dwCMYKacc OR dwCMYKtmp OR k)
  END FUNCTION

  FUNCTION PALETTERGB (BYVAL r AS BYTE, BYVAL g AS BYTE, BYVAL b AS BYTE) AS DWORD
    FUNCTION = (&H02000000??? OR RGB(r,g,b))
  END FUNCTION

  FUNCTION PALETTEINDEX (BYVAL i AS WORD) AS DWORD
    FUNCTION = (&H01000000??? OR CDWD(i))
  END FUNCTION

  FUNCTION GetRValue (BYVAL drgb AS DWORD) AS BYTE
    FUNCTION = (drgb AND &H000000FF???)
  END FUNCTION

  FUNCTION GetGValue (BYVAL drgb AS DWORD) AS BYTE
    SHIFT RIGHT drgb, 8
    FUNCTION = (drgb AND &H000000FF???)
  END FUNCTION

  FUNCTION GetBValue (BYVAL drgb AS DWORD) AS BYTE
    SHIFT RIGHT drgb, 16
    FUNCTION = (drgb AND &H000000FF???)
  END FUNCTION

#ENDIF ' #IF %DEF(%CCWIN) ------------------------------------------------
#ENDIF ' #IF NOT %DEF(%NOGDI) -------------------------------------------------

' End of functions from wingdi.h ==============================================

'
'  KERNEL32.DLL Declares [winbase.h]
'
DECLARE FUNCTION AddAtom LIB "KERNEL32.DLL" ALIAS "AddAtomA" (lpString AS ASCIIZ) AS LONG
DECLARE FUNCTION AllocConsole LIB "KERNEL32.DLL" ALIAS "AllocConsole" () AS LONG
DECLARE FUNCTION BackupRead LIB "KERNEL32.DLL" ALIAS "BackupRead" (BYVAL hFile AS DWORD, lpBuffer AS BYTE, BYVAL nNumberOfBytesToRead AS LONG, lpNumberOfBytesRead AS LONG, BYVAL bAbort AS LONG, _
                 BYVAL bProcessSecurity AS LONG, lpContext AS ANY) AS LONG
DECLARE FUNCTION BackupSeek LIB "KERNEL32.DLL" ALIAS "BackupSeek" (BYVAL hFile AS DWORD, BYVAL dwLowBytesToSeek AS DWORD, BYVAL dwHighBytesToSeek AS DWORD, lpdwLowByteSeeked AS DWORD, _
                 lpdwHighByteSeeked AS LONG, lpContext AS LONG) AS LONG
DECLARE FUNCTION BackupWrite LIB "KERNEL32.DLL" ALIAS "BackupWrite" (BYVAL hFile AS DWORD, lpBuffer AS BYTE, BYVAL nNumberOfBytesToWrite AS LONG, lpNumberOfBytesWritten AS LONG, _
                 BYVAL bAbort AS LONG, BYVAL bProcessSecurity AS LONG, lpContext AS LONG) AS LONG
DECLARE FUNCTION WinBeep LIB "KERNEL32.DLL" ALIAS "Beep" (BYVAL dwFreq AS DWORD, BYVAL dwDuration AS DWORD) AS LONG
DECLARE FUNCTION BeginUpdateResource LIB "KERNEL32.DLL" ALIAS "BeginUpdateResourceA" (pFileName AS ASCIIZ, BYVAL bDeleteExistingResources AS LONG) AS LONG
DECLARE FUNCTION BuildCommDCB LIB "KERNEL32.DLL" ALIAS "BuildCommDCBA" (lpDef AS ASCIIZ, lpDCB AS DCB) AS LONG
DECLARE FUNCTION BuildCommDCBAndTimeouts LIB "KERNEL32.DLL" ALIAS "BuildCommDCBAndTimeoutsA" (lpDef AS ASCIIZ, lpDCB AS DCB, lpCommTimeouts AS COMMTIMEOUTS) AS LONG
DECLARE FUNCTION CallNamedPipe LIB "KERNEL32.DLL" ALIAS "CallNamedPipeA" (lpNamedPipeName AS ASCIIZ, lpInBuffer AS ANY, BYVAL nInBufferSize AS LONG, lpOutBuffer AS ANY, BYVAL nOutBufferSize AS LONG, lpBytesRead AS LONG, _
                 BYVAL nTimeOut AS LONG) AS LONG
DECLARE FUNCTION CancelWaitableTimer LIB "KERNEL32.DLL" ALIAS "CancelWaitableTimer" (BYVAL hTimer AS DWORD) AS LONG
DECLARE FUNCTION ClearCommBreak LIB "KERNEL32.DLL" ALIAS "ClearCommBreak" (BYVAL nCid AS LONG) AS LONG
DECLARE FUNCTION ClearCommError LIB "KERNEL32.DLL" ALIAS "ClearCommError" (BYVAL hFile AS DWORD, lpErrors AS LONG, lpStat AS COMSTAT) AS LONG
DECLARE FUNCTION CloseHandle LIB "KERNEL32.DLL" ALIAS "CloseHandle" (BYVAL hObject AS DWORD) AS LONG
DECLARE FUNCTION CommConfigDialog LIB "KERNEL32.DLL" ALIAS "CommConfigDialogA" (lpszName AS ASCIIZ, BYVAL hWnd AS DWORD, lpCC AS COMMCONFIG) AS LONG
DECLARE FUNCTION CompareFileTime LIB "KERNEL32.DLL" ALIAS "CompareFileTime" (lpFileTime1 AS FILETIME, lpFileTime2 AS FILETIME) AS LONG
DECLARE FUNCTION CompareString LIB "KERNEL32.DLL" ALIAS "CompareStringA" (BYVAL Locale AS LONG, BYVAL dwCmpFlags AS DWORD, lpString1 AS ASCIIZ, BYVAL cchCount1 AS LONG, lpString2 AS ASCIIZ, BYVAL cchCount2 AS LONG) AS LONG
DECLARE FUNCTION ConnectNamedPipe LIB "KERNEL32.DLL" ALIAS "ConnectNamedPipe" (BYVAL hNamedPipe AS DWORD, lpOverlapped AS OVERLAPPED) AS LONG
DECLARE FUNCTION ContinueDebugEvent LIB "KERNEL32.DLL" ALIAS "ContinueDebugEvent" (BYVAL dwProcessId AS DWORD, BYVAL dwThreadId AS DWORD, BYVAL dwContinueStatus AS DWORD) AS LONG
DECLARE FUNCTION ConvertDefaultLocale LIB "KERNEL32.DLL" ALIAS "ConvertDefaultLocale" (BYVAL Locale AS LONG) AS LONG
DECLARE FUNCTION ConvertThreadToFiber LIB "KERNEL32.DLL" ALIAS "ConvertThreadToFiber" (BYVAL lpParameter AS DWORD) AS DWORD
DECLARE FUNCTION CopyFile LIB "KERNEL32.DLL" ALIAS "CopyFileA" (lpExistingFileName AS ASCIIZ, lpNewFileName AS ASCIIZ, BYVAL bFailIfExists AS LONG) AS LONG
DECLARE FUNCTION CopyFileEx LIB "KERNEL32.DLL" ALIAS "CopyFileExA" (lpExistingFileName AS ASCIIZ, lpNewFileName AS ASCIIZ, BYVAL lpProgressRoutine AS DWORD, BYVAL lpData AS DWORD, pbCancel AS LONG, BYVAL dwCopyFlags AS DWORD) AS LONG
DECLARE FUNCTION CreateConsoleScreenBuffer LIB "KERNEL32.DLL" ALIAS "CreateConsoleScreenBuffer" (BYVAL dwDesiredAccess AS DWORD, BYVAL dwShareMode AS DWORD, lpSecurityAttributes AS SECURITY_ATTRIBUTES, BYVAL dwFlags AS DWORD, _
                 BYVAL lpScreenBufferData AS LONG) AS LONG
DECLARE FUNCTION CreateDirectory LIB "KERNEL32.DLL" ALIAS "CreateDirectoryA" (lpPathName AS ASCIIZ, lpSecurityAttributes AS SECURITY_ATTRIBUTES) AS LONG
DECLARE FUNCTION CreateDirectoryEx LIB "KERNEL32.DLL" ALIAS "CreateDirectoryExA" (lpTemplateDirectory AS ASCIIZ, lpNewDirectory AS ASCIIZ, lpSecurityAttributes AS SECURITY_ATTRIBUTES) AS LONG
DECLARE FUNCTION CreateEvent LIB "KERNEL32.DLL" ALIAS "CreateEventA" (lpEventAttributes AS SECURITY_ATTRIBUTES, BYVAL bManualReset AS LONG, BYVAL bInitialState AS LONG, lpName AS ASCIIZ) AS LONG
DECLARE FUNCTION CreateFiber LIB "KERNEL32.DLL" ALIAS "CreateFiber" (BYVAL dwStackSize AS DWORD, BYVAL lpStartAddress AS DWORD, BYVAL lpParameter AS DWORD) AS DWORD
DECLARE FUNCTION CreateFile LIB "KERNEL32.DLL" ALIAS "CreateFileA" (lpFileName AS ASCIIZ, BYVAL dwDesiredAccess AS DWORD, BYVAL dwShareMode AS DWORD, lpSecurityAttributes AS SECURITY_ATTRIBUTES, BYVAL dwCreationDisposition AS DWORD, _
                 BYVAL dwFlagsAndAttributes AS DWORD, BYVAL hTemplateFile AS DWORD) AS DWORD
DECLARE FUNCTION CreateFileMapping LIB "KERNEL32.DLL" ALIAS "CreateFileMappingA" (BYVAL hFile AS DWORD, lpFileMappigAttributes AS SECURITY_ATTRIBUTES, BYVAL flProtect AS LONG, BYVAL dwMaximumSizeHigh AS DWORD, BYVAL dwMaximumSizeLow AS DWORD, _
                 lpName AS ASCIIZ) AS LONG
DECLARE FUNCTION CreateHardLink LIB "KERNEL32.DLL" ALIAS "CreateHardLinkA" (lpFileName AS ASCIIZ, lpExistingFileName AS ASCIIZ, lpSecurity_Attributes AS SECURITY_ATTRIBUTES) AS LONG
DECLARE FUNCTION CreateIoCompletionPort LIB "KERNEL32.DLL" ALIAS "CreateIoCompletionPort" (BYVAL FileHandle AS DWORD, BYVAL ExistingCompletionPort AS DWORD, BYVAL CompletionKey AS DWORD, BYVAL NumberOfConcurrentThreads AS DWORD) AS DWORD
DECLARE FUNCTION CreateMailslot LIB "KERNEL32.DLL" ALIAS "CreateMailslotA" (lpName AS ASCIIZ, BYVAL nMaxMessageSize AS LONG, BYVAL lReadTimeout AS LONG, lpSecurityAttributes AS SECURITY_ATTRIBUTES) AS LONG
DECLARE FUNCTION CreateMutex LIB "KERNEL32.DLL" ALIAS "CreateMutexA" (lpMutexAttributes AS SECURITY_ATTRIBUTES, BYVAL bInitialOwner AS LONG, lpName AS ASCIIZ) AS LONG
DECLARE FUNCTION CreateNamedPipe LIB "KERNEL32.DLL" ALIAS "CreateNamedPipeA" (lpName AS ASCIIZ, BYVAL dwOpenMode AS DWORD, BYVAL dwPipeMode AS DWORD, BYVAL nMaxInstances AS DWORD, BYVAL nOutBufferSize AS DWORD, BYVAL nInBufferSize AS DWORD, _
                 BYVAL nDefaultTimeOut AS DWORD, lpSecurityAttributes AS SECURITY_ATTRIBUTES) AS DWORD
DECLARE FUNCTION CreatePipe LIB "KERNEL32.DLL" ALIAS "CreatePipe" (phReadPipe AS DWORD, phWritePipe AS DWORD, lpPipeAttributes AS SECURITY_ATTRIBUTES, BYVAL nSize AS DWORD) AS LONG
DECLARE FUNCTION CreateProcess LIB "KERNEL32.DLL" ALIAS "CreateProcessA" (lpApplicationName AS ASCIIZ, lpCommandLine AS ASCIIZ, lpProcessAttributes AS SECURITY_ATTRIBUTES, lpThreadAttributes AS SECURITY_ATTRIBUTES, _
                 BYVAL bInheritHandles AS LONG, BYVAL dwCreationFlags AS DWORD, lpEnvironment AS ANY, lpCurrentDirectory AS ASCIIZ, lpStartupInfo AS STARTUPINFO, lpProcessInformation AS PROCESS_INFORMATION) AS LONG
DECLARE FUNCTION CreateProcessAsUser LIB "KERNEL32.DLL" ALIAS "CreateProcessAsUserA" (BYVAL hToken AS DWORD, lpApplicationName AS ASCIIZ, lpCommandLine AS ASCIIZ, lpProcessAttributes AS SECURITY_ATTRIBUTES, _
                 lpThreadAttributes AS SECURITY_ATTRIBUTES, BYVAL bInheritHandles AS LONG, BYVAL dwCreationFlags AS DWORD, lpEnvironment AS ASCIIZ, lpCurrentDirectory AS ASCIIZ, lpStartupInfo AS STARTUPINFO, _
                 lpProcessInformation AS PROCESS_INFORMATION) AS LONG
DECLARE FUNCTION CreateRemoteThread LIB "KERNEL32.DLL" ALIAS "CreateRemoteThread" (BYVAL hProcess AS DWORD, lpThreadAttributes AS SECURITY_ATTRIBUTES, BYVAL dwStackSize AS DWORD, BYVAL lpStartAddress AS LONG, lpParameter AS ANY, _
                 BYVAL dwCreationFlags AS DWORD, lpThreadId AS LONG) AS LONG
DECLARE FUNCTION CreateSemaphore LIB "KERNEL32.DLL" ALIAS "CreateSemaphoreA" (lpSemaphoreAttributes AS SECURITY_ATTRIBUTES, BYVAL lInitialCount AS LONG, BYVAL lMaximumCount AS LONG, lpName AS ASCIIZ) AS LONG
DECLARE FUNCTION CreateTapePartition LIB "KERNEL32.DLL" ALIAS "CreateTapePartition" (BYVAL hDevice AS DWORD, BYVAL dwPartitionMethod AS DWORD, BYVAL dwCount AS DWORD, BYVAL dwSize AS DWORD) AS LONG
DECLARE FUNCTION CreateThread LIB "KERNEL32.DLL" ALIAS "CreateThread" (lpThreadAttributes AS SECURITY_ATTRIBUTES, BYVAL dwStackSize AS DWORD, BYVAL StartAddress AS LONG, BYVAL lpParameter AS LONG, BYVAL dwCreationFlags AS DWORD, _
                 lpThreadId AS LONG) AS LONG
DECLARE FUNCTION CreateWaitableTimer LIB "KERNEL32.DLL" ALIAS "CreateWaitableTimerA" (lpTimerAttributes AS SECURITY_ATTRIBUTES, BYVAL bManualReset AS LONG, lpTimerName AS ASCIIZ) AS DWORD
DECLARE FUNCTION DebugActiveProcess LIB "KERNEL32.DLL" ALIAS "DebugActiveProcess" (BYVAL dwProcessId AS DWORD) AS LONG
DECLARE SUB      DebugBreak LIB "KERNEL32.DLL" ALIAS "DebugBreak" ()
DECLARE FUNCTION DefineDosDevice LIB "KERNEL32.DLL" ALIAS "DefineDosDeviceA" (BYVAL dwFlags AS DWORD, lpDeviceName AS ASCIIZ, lpTargetPath AS ASCIIZ) AS LONG
DECLARE FUNCTION DeleteAtom LIB "KERNEL32.DLL" ALIAS "DeleteAtom" (BYVAL nAtom AS LONG) AS LONG
DECLARE SUB      DeleteCriticalSection LIB "KERNEL32.DLL" ALIAS "DeleteCriticalSection" (lpCriticalSection AS CRITICAL_SECTION)
DECLARE SUB      DeleteFiber LIB "KERNEL32.DLL" ALIAS "DeleteFiber" (BYVAL lpFiber AS DWORD)
DECLARE FUNCTION DeleteFile LIB "KERNEL32.DLL" ALIAS "DeleteFileA" (lpFileName AS ASCIIZ) AS LONG
DECLARE FUNCTION DeviceIoControl LIB "KERNEL32.DLL" ALIAS "DeviceIoControl" (BYVAL hDevice AS DWORD, BYVAL dwIoControlCode AS DWORD, lpInBuffer AS ANY, BYVAL nInBufferSize AS LONG, lpOutBuffer AS ANY, BYVAL nOutBufferSize AS LONG, _
                 lpBytesReturned AS LONG, lpOverlapped AS OVERLAPPED) AS LONG
DECLARE FUNCTION DisableThreadLibraryCalls LIB "KERNEL32.DLL" ALIAS "DisableThreadLibraryCalls" (BYVAL hLibModule AS DWORD) AS LONG
DECLARE FUNCTION DisconnectNamedPipe LIB "KERNEL32.DLL" ALIAS "DisconnectNamedPipe" (BYVAL hNamedPipe AS DWORD) AS LONG
DECLARE FUNCTION DosDateTimeToFileTime LIB "KERNEL32.DLL" ALIAS "DosDateTimeToFileTime" (BYVAL wFatDate AS WORD, BYVAL wFatTime AS WORD, lpFileTime AS FILETIME) AS LONG
DECLARE FUNCTION DuplicateHandle LIB "KERNEL32.DLL" ALIAS "DuplicateHandle" (BYVAL hSourceProcessHandle AS DWORD, BYVAL hSourceHandle AS DWORD, BYVAL hTargetProcessHandle AS DWORD, lpTargetHandle AS DWORD, BYVAL dwDesiredAccess AS DWORD, _
                 BYVAL bInheritHandle AS LONG, BYVAL dwOptions AS DWORD) AS LONG
DECLARE FUNCTION EndUpdateResource LIB "KERNEL32.DLL" ALIAS "EndUpdateResourceA" (BYVAL hUpdate AS DWORD, BYVAL fDiscard AS LONG) AS LONG
DECLARE SUB      EnterCriticalSection LIB "KERNEL32.DLL" ALIAS "EnterCriticalSection" (lpCriticalSection AS CRITICAL_SECTION)
DECLARE FUNCTION EnumCalendarInfo LIB "KERNEL32.DLL" ALIAS "EnumCalendarInfoA" (BYVAL lpCalInfoEnumProc AS LONG, BYVAL Locale AS LONG, BYVAL Calendar AS LONG, BYVAL CalType AS LONG) AS LONG
DECLARE FUNCTION EnumDateFormats LIB "KERNEL32.DLL" ALIAS "EnumDateFormats" (BYVAL lpDateFmtEnumProc AS LONG, BYVAL Locale AS LONG, BYVAL dwFlags AS DWORD) AS LONG
DECLARE FUNCTION EnumResourceLanguages LIB "KERNEL32.DLL" ALIAS "EnumResourceLanguagesA" (BYVAL hModule AS DWORD, lpType AS ASCIIZ, lpName AS ASCIIZ, BYVAL lpEnumFunc AS LONG, BYVAL lParam AS LONG) AS LONG
DECLARE FUNCTION EnumResourceNames LIB "KERNEL32.DLL" ALIAS "EnumResourceNamesA" (BYVAL hModule AS DWORD, lpType AS ASCIIZ, BYVAL lpEnumFunc AS LONG, BYVAL lParam AS LONG) AS LONG
DECLARE FUNCTION EnumResourceTypes LIB "KERNEL32.DLL" ALIAS "EnumResourceTypesA" (BYVAL hModule AS DWORD, BYVAL lpEnumFunc AS LONG, BYVAL lParam AS LONG) AS LONG
DECLARE FUNCTION EnumSystemCodePages LIB "KERNEL32.DLL" ALIAS "EnumSystemCodePages" (BYVAL lpCodePageEnumProc AS LONG, BYVAL dwFlags AS DWORD) AS LONG
DECLARE FUNCTION EnumSystemLocales LIB "KERNEL32.DLL" ALIAS "EnumSystemLocalesA" (BYVAL lpLocaleEnumProc AS LONG, BYVAL dwFlags AS DWORD) AS LONG
DECLARE FUNCTION EnumTimeFormats LIB "KERNEL32.DLL" ALIAS "EnumTimeFormats" (BYVAL lpTimeFmtEnumProc AS LONG, BYVAL Locale AS LONG, BYVAL dwFlags AS DWORD) AS LONG
DECLARE FUNCTION EraseTape LIB "KERNEL32.DLL" ALIAS "EraseTape" (BYVAL hDevice AS DWORD, BYVAL dwEraseType AS DWORD, BYVAL bimmediate AS LONG) AS LONG
DECLARE FUNCTION EscapeCommFunction LIB "KERNEL32.DLL" ALIAS "EscapeCommFunction" (BYVAL nCid AS LONG, BYVAL nFunc AS LONG) AS LONG
DECLARE SUB      ExitProcess LIB "KERNEL32.DLL" ALIAS "ExitProcess" (BYVAL uExitCode AS DWORD)
DECLARE SUB      ExitThread LIB "KERNEL32.DLL" ALIAS "ExitThread" (BYVAL dwExitCode AS DWORD)
DECLARE FUNCTION ExpandEnvironmentStrings LIB "KERNEL32.DLL" ALIAS "ExpandEnvironmentStringsA" (lpSrc AS ASCIIZ, lpDst AS ASCIIZ, BYVAL nSize AS DWORD) AS DWORD
DECLARE SUB      FatalAppExit LIB "KERNEL32.DLL" ALIAS "FatalAppExitA" (BYVAL uAction AS DWORD, lpMessageText AS ASCIIZ)
DECLARE SUB      FatalExit LIB "KERNEL32.DLL" ALIAS "FatalExit" (BYVAL code AS LONG)
DECLARE FUNCTION FileTimeToDosDateTime LIB "KERNEL32.DLL" ALIAS "FileTimeToDosDateTime" (lpFileTime AS FILETIME, lpFatDate AS WORD, lpFatTime AS WORD) AS LONG
DECLARE FUNCTION FileTimeToLocalFileTime LIB "KERNEL32.DLL" ALIAS "FileTimeToLocalFileTime" (lpFileTime AS FILETIME, lpLocalFileTime AS FILETIME) AS LONG
DECLARE FUNCTION FileTimeToSystemTime LIB "KERNEL32.DLL" ALIAS "FileTimeToSystemTime" (lpFileTime AS FILETIME, lpSystemTime AS SYSTEMTIME) AS LONG
DECLARE FUNCTION FillConsoleOutputAttribute LIB "KERNEL32.DLL" ALIAS "FillConsoleOutputAttribute" (BYVAL hConsoleOutput AS DWORD, BYVAL dwAttribute AS DWORD, BYVAL nLength AS LONG, BYVAL dwWriteCoord AS DWORD, lpNumberOfAttrsWritten AS LONG) AS LONG
DECLARE FUNCTION FillConsoleOutputCharacter LIB "KERNEL32.DLL" ALIAS "FillConsoleOutputCharacterA" (BYVAL hConsoleOutput AS DWORD, szCharacter AS ASCIIZ, BYVAL nLength AS LONG, BYVAL dwWriteCoord AS DWORD, lpNumberOfCharsWritten AS LONG) AS LONG
DECLARE FUNCTION FindAtom LIB "KERNEL32.DLL" ALIAS "FindAtomA" (lpString AS ASCIIZ) AS LONG
DECLARE FUNCTION FindClose LIB "KERNEL32.DLL" ALIAS "FindClose" (BYVAL hFindFile AS DWORD) AS LONG
DECLARE FUNCTION FindCloseChangeNotification LIB "KERNEL32.DLL" ALIAS "FindCloseChangeNotification" (BYVAL hChangeHandle AS DWORD) AS LONG
DECLARE FUNCTION FindFirstChangeNotification LIB "KERNEL32.DLL" ALIAS "FindFirstChangeNotificationA" (lpPathName AS ASCIIZ, BYVAL bWatchSubtree AS LONG, BYVAL dwNotifyFilter AS DWORD) AS DWORD
DECLARE FUNCTION FindFirstFile LIB "KERNEL32.DLL" ALIAS "FindFirstFileA" (lpFileName AS ASCIIZ, lpFindFileData AS WIN32_FIND_DATA) AS DWORD
DECLARE FUNCTION FindFirstFileEx LIB "KERNEL32.DLL" ALIAS "FindFirstFileExA" (lpFileName AS ASCIIZ, BYVAL fInfoLevelId AS LONG, BYVAL lpFindFileData AS DWORD, BYVAL fSearchOp AS LONG, BYVAL lpSearchFilter AS DWORD, _
                 BYVAL dwAdditionalFlags AS DWORD) AS DWORD
DECLARE FUNCTION FindNextChangeNotification LIB "KERNEL32.DLL" ALIAS "FindNextChangeNotification" (BYVAL hChangeHandle AS DWORD) AS LONG
DECLARE FUNCTION FindNextFile LIB "KERNEL32.DLL" ALIAS "FindNextFileA" (BYVAL hFindFile AS DWORD, lpFindFileData AS WIN32_FIND_DATA) AS LONG
DECLARE FUNCTION FindResource LIB "KERNEL32.DLL" ALIAS "FindResourceA" (BYVAL hInstance AS DWORD, lpName AS ASCIIZ, lpType AS ASCIIZ) AS LONG
DECLARE FUNCTION FindResourceEx LIB "KERNEL32.DLL" ALIAS "FindResourceExA" (BYVAL hModule AS DWORD, lpType AS ASCIIZ, lpName AS ASCIIZ, BYVAL wLanguage AS WORD) AS DWORD
DECLARE FUNCTION FlushConsoleInputBuffer LIB "KERNEL32.DLL" ALIAS "FlushConsoleInputBuffer" (BYVAL hConsoleInput AS DWORD) AS LONG
DECLARE FUNCTION FlushFileBuffers LIB "KERNEL32.DLL" ALIAS "FlushFileBuffers" (BYVAL hFile AS DWORD) AS LONG
DECLARE FUNCTION FlushInstructionCache LIB "KERNEL32.DLL" ALIAS "FlushInstructionCache" (BYVAL hProcess AS DWORD, lpBaseAddress AS ANY, BYVAL dwSize AS DWORD) AS LONG
DECLARE FUNCTION FlushViewOfFile LIB "KERNEL32.DLL" ALIAS "FlushViewOfFile" (lpBaseAddress AS ANY, BYVAL dwNumberOfBytesToFlush AS DWORD) AS LONG
DECLARE FUNCTION FoldString LIB "KERNEL32.DLL" ALIAS "FoldStringA" (BYVAL dwMapFlags AS DWORD, lpSrcStr AS ASCIIZ, BYVAL cchSrc AS LONG, lpDestStr AS ASCIIZ, BYVAL cchDest AS LONG) AS LONG
DECLARE FUNCTION FormatMessage LIB "KERNEL32.DLL" ALIAS "FormatMessageA" (BYVAL dwFlags AS DWORD, lpSource AS ANY, BYVAL dwMessageId AS DWORD, BYVAL dwLanguageId AS DWORD, lpBuffer AS ASCIIZ, BYVAL nSize AS DWORD, Arguments AS ANY) AS DWORD
DECLARE FUNCTION FreeConsole LIB "KERNEL32.DLL" ALIAS "FreeConsole" () AS LONG
DECLARE FUNCTION FreeEnvironmentStrings LIB "KERNEL32.DLL" ALIAS "FreeEnvironmentStringsA" (lpsz AS ASCIIZ) AS LONG
DECLARE FUNCTION FreeLibrary LIB "KERNEL32.DLL" ALIAS "FreeLibrary" (BYVAL hLibModule AS DWORD) AS LONG
DECLARE SUB      FreeLibraryAndExitThread LIB "KERNEL32.DLL" ALIAS "FreeLibraryAndExitThread" (BYVAL hLibModule AS DWORD, BYVAL dwExitCode AS DWORD)
DECLARE FUNCTION FreeResource LIB "KERNEL32.DLL" ALIAS "FreeResource" (BYVAL hResData AS DWORD) AS LONG
DECLARE FUNCTION GenerateConsoleCtrlEvent LIB "KERNEL32.DLL" ALIAS "GenerateConsoleCtrlEvent" (BYVAL dwCtrlEvent AS DWORD, BYVAL dwProcessGroupId AS DWORD) AS LONG
DECLARE FUNCTION GetACP LIB "KERNEL32.DLL" ALIAS "GetACP" () AS LONG
DECLARE FUNCTION GetAtomName LIB "KERNEL32.DLL" ALIAS "GetAtomNameA" (BYVAL nAtom AS LONG, lpBuffer AS ASCIIZ, BYVAL nSize AS DWORD) AS DWORD
DECLARE FUNCTION GetBinaryType LIB "KERNEL32.DLL" ALIAS "GetBinaryTypeA" (lpApplicationName AS ASCIIZ, lpBinaryType AS LONG) AS LONG
DECLARE FUNCTION GetCPInfo LIB "KERNEL32.DLL" ALIAS "GetCPInfo" (BYVAL CodePage AS LONG, lpCPInfo AS CPINFO) AS LONG
DECLARE FUNCTION GetCommConfig LIB "KERNEL32.DLL" ALIAS "GetCommConfig" (BYVAL hCommDev AS DWORD, lpCC AS COMMCONFIG, lpdwSize AS DWORD) AS LONG
DECLARE FUNCTION GetCommMask LIB "KERNEL32.DLL" ALIAS "GetCommMask" (BYVAL hFile AS DWORD, lpEvtMask AS LONG) AS LONG
DECLARE FUNCTION GetCommModemStatus LIB "KERNEL32.DLL" ALIAS "GetCommModemStatus" (BYVAL hFile AS DWORD, lpModemStat AS LONG) AS LONG
DECLARE FUNCTION GetCommProperties LIB "KERNEL32.DLL" ALIAS "GetCommProperties" (BYVAL hFile AS DWORD, lpCommProp AS ANY) AS LONG
DECLARE FUNCTION GetCommState LIB "KERNEL32.DLL" ALIAS "GetCommState" (BYVAL nCid AS LONG, lpDCB AS DCB) AS LONG
DECLARE FUNCTION GetCommTimeouts LIB "KERNEL32.DLL" ALIAS "GetCommTimeouts" (BYVAL hFile AS DWORD, lpCommTimeouts AS COMMTIMEOUTS) AS LONG
DECLARE FUNCTION GetCommandLine LIB "KERNEL32.DLL" ALIAS "GetCommandLineA" () AS DWORD
DECLARE FUNCTION GetCompressedFileSize LIB "KERNEL32.DLL" ALIAS "GetCompressedFileSizeA" (lpFileName AS ASCIIZ, lpFileSizeHigh AS LONG) AS LONG
DECLARE FUNCTION GetComputerName LIB "KERNEL32.DLL" ALIAS "GetComputerNameA" (lpBuffer AS ASCIIZ, nSize AS DWORD) AS LONG
DECLARE FUNCTION GetConsoleCP LIB "KERNEL32.DLL" ALIAS "GetConsoleCP" () AS LONG
DECLARE FUNCTION GetConsoleCursorInfo LIB "KERNEL32.DLL" ALIAS "GetConsoleCursorInfo" (BYVAL hConsoleOutput AS DWORD, lpConsoleCursorInfo AS CONSOLE_CURSOR_INFO) AS LONG
DECLARE FUNCTION GetConsoleMode LIB "KERNEL32.DLL" ALIAS "GetConsoleMode" (BYVAL hConsoleHandle AS DWORD, lpMode AS DWORD) AS LONG
DECLARE FUNCTION GetConsoleOutputCP LIB "KERNEL32.DLL" ALIAS "GetConsoleOutputCP" () AS LONG
DECLARE FUNCTION GetConsoleScreenBufferInfo LIB "KERNEL32.DLL" ALIAS "GetConsoleScreenBufferInfo" (BYVAL hConsoleOutput AS DWORD, lpConsoleScreenBufferInfo AS CONSOLE_SCREEN_BUFFER_INFO) AS LONG
DECLARE FUNCTION GetConsoleTitle LIB "KERNEL32.DLL" ALIAS "GetConsoleTitleA" (lpConsoleTitle AS ASCIIZ, BYVAL nSize AS DWORD) AS DWORD
DECLARE FUNCTION GetCurrencyFormat LIB "KERNEL32.DLL" ALIAS "GetCurrencyFormatA" (BYVAL Locale AS LONG, BYVAL dwFlags AS DWORD, lpValue AS ASCIIZ, lpFormat AS CURRENCYFMT, lpCurrencyStr AS ASCIIZ, BYVAL cchCurrency AS LONG) AS LONG
DECLARE FUNCTION GetCurrentDirectory LIB "KERNEL32.DLL" ALIAS "GetCurrentDirectoryA" (BYVAL nBufferLength AS LONG, lpBuffer AS ASCIIZ) AS LONG
DECLARE FUNCTION GetCurrentProcess LIB "KERNEL32.DLL" ALIAS "GetCurrentProcess" () AS LONG
DECLARE FUNCTION GetCurrentProcessId LIB "KERNEL32.DLL" ALIAS "GetCurrentProcessId" () AS LONG
DECLARE FUNCTION GetCurrentThread LIB "KERNEL32.DLL" ALIAS "GetCurrentThread" () AS LONG
DECLARE FUNCTION GetCurrentThreadId LIB "KERNEL32.DLL" ALIAS "GetCurrentThreadId" () AS LONG
DECLARE FUNCTION GetDateFormat LIB "KERNEL32.DLL" ALIAS "GetDateFormatA" (BYVAL Locale AS LONG, BYVAL dwFlags AS DWORD, lpDate AS SYSTEMTIME, lpFormat AS ASCIIZ, lpDateStr AS ASCIIZ, BYVAL cchDate AS LONG) AS LONG
DECLARE FUNCTION GetDefaultCommConfig LIB "KERNEL32.DLL" ALIAS "GetDefaultCommConfigA" (lpszName AS ASCIIZ, lpCC AS COMMCONFIG, lpdwSize AS DWORD) AS LONG
DECLARE FUNCTION GetDiskFreeSpace LIB "KERNEL32.DLL" ALIAS "GetDiskFreeSpaceA" (lpRootPathName AS ASCIIZ, lpSectorsPerCluster AS DWORD, lpBytesPerSector AS DWORD, lpNumberOfFreeClusters AS DWORD, lpTotalNumberOfClusters AS DWORD) AS LONG
DECLARE FUNCTION GetDiskFreeSpaceEx LIB "KERNEL32.DLL" ALIAS "GetDiskFreeSpaceExA" (lpPathName AS ASCIIZ, lpFreeBytesAvailableToCaller AS QUAD, lpTotalNumberOfBytes AS QUAD, lpTotalNumberOfFreeBytes AS QUAD) AS LONG
DECLARE FUNCTION GetDriveType LIB "KERNEL32.DLL" ALIAS "GetDriveTypeA" (nDrive AS ASCIIZ) AS LONG
DECLARE FUNCTION GetEnvironmentStrings LIB "KERNEL32.DLL" ALIAS "GetEnvironmentStringsA" () AS DWORD
DECLARE FUNCTION GetEnvironmentVariable LIB "KERNEL32.DLL" ALIAS "GetEnvironmentVariableA" (lpName AS ASCIIZ, lpBuffer AS ASCIIZ, BYVAL nSize AS DWORD) AS DWORD
DECLARE FUNCTION GetExitCodeProcess LIB "KERNEL32.DLL" ALIAS "GetExitCodeProcess" (BYVAL hProcess AS DWORD, lpExitCode AS LONG) AS LONG
DECLARE FUNCTION GetExitCodeThread LIB "KERNEL32.DLL" ALIAS "GetExitCodeThread" (BYVAL hThread AS DWORD, lpExitCode AS LONG) AS LONG
DECLARE FUNCTION GetFileAttributes LIB "KERNEL32.DLL" ALIAS "GetFileAttributesA" (lpFileName AS ASCIIZ) AS LONG
DECLARE FUNCTION GetFileAttributesEx LIB "KERNEL32.DLL" ALIAS "GetFileAttributesExA" (lpFileName AS ASCIIZ, BYVAL fInfoLevelId AS LONG, lpFileInformation AS ANY) AS LONG
DECLARE FUNCTION GetFileInformationByHandle LIB "KERNEL32.DLL" ALIAS "GetFileInformationByHandle" (BYVAL hFile AS DWORD, lpFileInformation AS BY_HANDLE_FILE_INFORMATION) AS LONG
DECLARE FUNCTION GetFileSize LIB "KERNEL32.DLL" ALIAS "GetFileSize" (BYVAL hFile AS DWORD, lpFileSizeHigh AS LONG) AS LONG
DECLARE FUNCTION GetFileTime LIB "KERNEL32.DLL" ALIAS "GetFileTime" (BYVAL hFile AS DWORD, lpCreationTime AS FILETIME, lpLastAccessTime AS FILETIME, lpLastWriteTime AS FILETIME) AS LONG
DECLARE FUNCTION GetFileType LIB "KERNEL32.DLL" ALIAS "GetFileType" (BYVAL hFile AS DWORD) AS LONG
DECLARE FUNCTION GetFullPathName LIB "KERNEL32.DLL" ALIAS "GetFullPathNameA" (lpFileName AS ASCIIZ, BYVAL nBufferLength AS LONG, lpBuffer AS ASCIIZ, BYVAL lpFilePart AS LONG) AS LONG
DECLARE FUNCTION GetHandleInformation LIB "KERNEL32.DLL" ALIAS "GetHandleInformation" (BYVAL hObject AS DWORD, lpdwFlags AS DWORD) AS LONG
DECLARE FUNCTION GetLargestConsoleWindowSize LIB "KERNEL32.DLL" ALIAS "GetLargestConsoleWindowSize" (BYVAL hConsoleOutput AS DWORD) AS DWORD
DECLARE FUNCTION GetLastError LIB "KERNEL32.DLL" ALIAS "GetLastError" () AS LONG
DECLARE FUNCTION GetLocaleInfo LIB "KERNEL32.DLL" ALIAS "GetLocaleInfoA" (BYVAL Locale AS LONG, BYVAL LCType AS LONG, lpLCData AS ASCIIZ, BYVAL cchData AS LONG) AS LONG
DECLARE SUB      GetLocalTime LIB "KERNEL32.DLL" ALIAS "GetLocalTime" (lpSystemTime AS SYSTEMTIME)
DECLARE FUNCTION GetLogicalDriveStrings LIB "KERNEL32.DLL" ALIAS "GetLogicalDriveStringsA" (BYVAL nBufferLength AS DWORD, lpBuffer AS ANY) AS DWORD
DECLARE FUNCTION GetLogicalDrives LIB "KERNEL32.DLL" ALIAS "GetLogicalDrives" () AS LONG
DECLARE FUNCTION GetMailslotInfo LIB "KERNEL32.DLL" ALIAS "GetMailslotInfo" (BYVAL hMailSlot AS DWORD, lpMaxMessageSize AS LONG, lpNextSize AS LONG, lpMessageCount AS LONG, lpReadTimeout AS LONG) AS LONG
DECLARE FUNCTION GetModuleFileName LIB "KERNEL32.DLL" ALIAS "GetModuleFileNameA" (BYVAL hModule AS DWORD, lpFileName AS ASCIIZ, BYVAL nSize AS DWORD) AS DWORD
DECLARE FUNCTION GetModuleHandle LIB "KERNEL32.DLL" ALIAS "GetModuleHandleA" (lpModuleName AS ASCIIZ) AS DWORD

#IF %DEF(%CCWIN)
  FUNCTION GethInst () AS DWORD
    FUNCTION = GetModuleHandle(BYVAL %NULL)
  END FUNCTION
#ENDIF

DECLARE FUNCTION GetNamedPipeHandleState LIB "KERNEL32.DLL" ALIAS "GetNamedPipeHandleStateA" (BYVAL hNamedPipe AS DWORD, lpState AS DWORD, lpCurInstances AS DWORD, lpMaxCollectionCount AS DWORD, lpCollectDataTimeout AS DWORD, _
                 lpUserName AS ASCIIZ, BYVAL nMaxUserNameSize AS DWORD) AS LONG
DECLARE FUNCTION GetNamedPipeInfo LIB "KERNEL32.DLL" ALIAS "GetNamedPipeInfo" (BYVAL hNamedPipe AS DWORD, lpFlags AS LONG, lpOutBufferSize AS LONG, lpInBufferSize AS LONG, lpMaxInstances AS LONG) AS LONG
DECLARE FUNCTION GetNumberFormat LIB "KERNEL32.DLL" ALIAS "GetNumberFormatA" (BYVAL Locale AS LONG, BYVAL dwFlags AS DWORD, lpValue AS ASCIIZ, lpFormat AS NUMBERFMT, lpNumberStr AS ASCIIZ, BYVAL cchNumber AS LONG) AS LONG
DECLARE FUNCTION GetNumberOfConsoleInputEvents LIB "KERNEL32.DLL" ALIAS "GetNumberOfConsoleInputEvents" (BYVAL hConsoleInput AS DWORD, lpNumberOfEvents AS LONG) AS LONG
DECLARE FUNCTION GetNumberOfConsoleMouseButtons LIB "KERNEL32.DLL" ALIAS "GetNumberOfConsoleMouseButtons" (lpNumberOfMouseButtons AS LONG) AS LONG
DECLARE FUNCTION GetOEMCP LIB "KERNEL32.DLL" ALIAS "GetOEMCP" () AS LONG
DECLARE FUNCTION GetOverlappedResult LIB "KERNEL32.DLL" ALIAS "GetOverlappedResult" (BYVAL hFile AS DWORD, lpOverlapped AS OVERLAPPED, lpNumberOfBytesTransferred AS LONG, BYVAL bWait AS LONG) AS LONG
DECLARE FUNCTION GetPriorityClass LIB "KERNEL32.DLL" ALIAS "GetPriorityClass" (BYVAL hProcess AS DWORD) AS LONG
DECLARE FUNCTION GetPrivateProfileInt LIB "KERNEL32.DLL" ALIAS "GetPrivateProfileIntA" (lpApplicationName AS ASCIIZ, lpKeyName AS ASCIIZ, BYVAL nDefault AS LONG, lpFileName AS ASCIIZ) AS DWORD
DECLARE FUNCTION GetPrivateProfileSection LIB "KERNEL32.DLL" ALIAS "GetPrivateProfileSectionA" (lpAppName AS ASCIIZ, lpReturnedString AS ASCIIZ, BYVAL nSize AS DWORD, lpFileName AS ASCIIZ) AS DWORD
DECLARE FUNCTION GetPrivateProfileSectionNames LIB "KERNEL32.DLL" ALIAS "GetPrivateProfileSectionNamesA" (lpszReturnBuffer AS ASCIIZ, BYVAL nSize AS DWORD, lpFileName AS ASCIIZ) AS DWORD
DECLARE FUNCTION GetPrivateProfileString LIB "KERNEL32.DLL" ALIAS "GetPrivateProfileStringA" (lpApplicationName AS ASCIIZ, lpKeyName AS ASCIIZ, lpDefault AS ASCIIZ, lpReturnedString AS ASCIIZ, BYVAL nSize AS DWORD, lpFileName AS ASCIIZ) AS DWORD
DECLARE FUNCTION GetProcAddress LIB "KERNEL32.DLL" ALIAS "GetProcAddress" (BYVAL hModule AS DWORD, lpProcName AS ASCIIZ) AS LONG
DECLARE FUNCTION GetProcessAffinityMask LIB "KERNEL32.DLL" ALIAS "GetProcessAffinityMask" (BYVAL hProcess AS DWORD, lpProcessAffinityMask AS LONG, SystemAffinityMask AS LONG) AS LONG
DECLARE FUNCTION GetProcessHeap LIB "KERNEL32.DLL" ALIAS "GetProcessHeap" () AS LONG
DECLARE FUNCTION GetProcessHeaps LIB "KERNEL32.DLL" ALIAS "GetProcessHeaps" (BYVAL NumberOfHeaps AS LONG, ProcessHeaps AS LONG) AS LONG
DECLARE FUNCTION GetProcessPriorityBoost LIB "KERNEL32.DLL" ALIAS "GetProcessPriorityBoost" (BYVAL hProcess AS DWORD, pDisablePriorityBoost AS LONG) AS LONG
DECLARE FUNCTION GetProcessShutdownParameters LIB "KERNEL32.DLL" ALIAS "GetProcessShutdownParameters" (lpdwLevel AS DWORD, lpdwFlags AS DWORD) AS LONG
DECLARE FUNCTION GetProcessTimes LIB "KERNEL32.DLL" ALIAS "GetProcessTimes" (BYVAL hProcess AS DWORD, lpCreationTime AS FILETIME, lpExitTime AS FILETIME, lpKernelTime AS FILETIME, lpUserTime AS FILETIME) AS LONG
DECLARE FUNCTION GetProcessVersion LIB "KERNEL32.DLL" ALIAS "GetProcessVersion" (BYVAL hProcess AS DWORD) AS DWORD
DECLARE FUNCTION GetProcessWorkingSetSize LIB "KERNEL32.DLL" ALIAS "GetProcessWorkingSetSize" (BYVAL hProcess AS DWORD, lpMinimumWorkingSetSize AS LONG, lpMaximumWorkingSetSize AS LONG) AS LONG
DECLARE FUNCTION GetProfileInt LIB "KERNEL32.DLL" ALIAS "GetProfileIntA" (lpAppName AS ASCIIZ, lpKeyName AS ASCIIZ, BYVAL nDefault AS LONG) AS LONG
DECLARE FUNCTION GetProfileSection LIB "KERNEL32.DLL" ALIAS "GetProfileSectionA" (lpAppName AS ASCIIZ, lpReturnedString AS ASCIIZ, BYVAL nSize AS DWORD) AS DWORD
DECLARE FUNCTION GetProfileString LIB "KERNEL32.DLL" ALIAS "GetProfileStringA" (lpAppName AS ASCIIZ, lpKeyName AS ASCIIZ, lpDefault AS ASCIIZ, lpReturnedString AS ASCIIZ, BYVAL nSize AS DWORD) AS DWORD
DECLARE FUNCTION GetQueuedCompletionStatus LIB "KERNEL32.DLL" ALIAS "GetQueuedCompletionStatus" (BYVAL CompletionPort AS LONG, lpNumberOfBytesTransferred AS LONG, lpCompletionKey AS LONG, lpOverlapped AS LONG, BYVAL dwMilliseconds AS DWORD) AS LONG
DECLARE FUNCTION GetShortPathName LIB "KERNEL32.DLL" ALIAS "GetShortPathNameA" (lpszLongPath AS ASCIIZ, lpszShortPath AS ASCIIZ, BYVAL cchBuffer AS LONG) AS LONG
DECLARE SUB      GetStartupInfo LIB "KERNEL32.DLL" ALIAS "GetStartupInfoA" (lpStartupInfo AS STARTUPINFO)
DECLARE FUNCTION GetStdHandle LIB "KERNEL32.DLL" ALIAS "GetStdHandle" (BYVAL nStdHandle AS DWORD) AS DWORD
DECLARE FUNCTION GetStringTypeA LIB "KERNEL32.DLL" ALIAS "GetStringTypeA" (BYVAL lcid AS DWORD, BYVAL dwInfoType AS DWORD, lpSrcStr AS ASCIIZ, BYVAL cchSrc AS LONG, lpCharType AS LONG) AS LONG
DECLARE FUNCTION GetStringTypeEx LIB "KERNEL32.DLL" ALIAS "GetStringTypeExA" (BYVAL Locale AS LONG, BYVAL dwInfoType AS DWORD, lpSrcStr AS ASCIIZ, BYVAL cchSrc AS LONG, lpCharType AS LONG) AS LONG
DECLARE FUNCTION GetStringTypeW LIB "KERNEL32.DLL" ALIAS "GetStringTypeW" (BYVAL dwInfoType AS DWORD, lpSrcStr AS ASCIIZ, BYVAL cchSrc AS LONG, lpCharType AS LONG) AS LONG
DECLARE FUNCTION GetSystemDefaultLCID LIB "KERNEL32.DLL" ALIAS "GetSystemDefaultLCID" () AS LONG
DECLARE FUNCTION GetSystemDefaultLangID LIB "KERNEL32.DLL" ALIAS "GetSystemDefaultLangID" () AS LONG
DECLARE FUNCTION GetSystemDirectory LIB "KERNEL32.DLL" ALIAS "GetSystemDirectoryA" (lpBuffer AS ASCIIZ, BYVAL nSize AS DWORD) AS DWORD
DECLARE SUB      GetSystemInfo LIB "KERNEL32.DLL" ALIAS "GetSystemInfo" (lpSystemInfo AS SYSTEM_INFO)
DECLARE FUNCTION GetSystemPowerStatus LIB "KERNEL32.DLL" ALIAS "GetSystemPowerStatus" (lpSystemPowerStatus AS SYSTEM_POWER_STATUS) AS LONG
DECLARE SUB      GetSystemTime LIB "KERNEL32.DLL" ALIAS "GetSystemTime" (lpSystemTime AS SYSTEMTIME)
DECLARE FUNCTION GetSystemTimeAdjustment LIB "KERNEL32.DLL" ALIAS "GetSystemTimeAdjustment" (lpTimeAdjustment AS LONG, lpTimeIncrement AS LONG, lpTimeAdjustmentDisabled AS LONG) AS LONG
DECLARE SUB      GetSystemTimeAsFileTime LIB "KERNEL32.DLL" ALIAS "GetSystemTimeAsFileTime" (lpFileTime AS FILETIME)
DECLARE FUNCTION GetTapeParameters LIB "KERNEL32.DLL" ALIAS "GetTapeParameters" (BYVAL hDevice AS DWORD, BYVAL dwOperation AS DWORD, lpdwSize AS DWORD, lpTapeInformation AS ANY) AS LONG
DECLARE FUNCTION GetTapePosition LIB "KERNEL32.DLL" ALIAS "GetTapePosition" (BYVAL hDevice AS DWORD, BYVAL dwPositionType AS DWORD, lpdwPartition AS DWORD, lpdwOffsetLow AS DWORD, lpdwOffsetHigh AS DWORD) AS LONG
DECLARE FUNCTION GetTapeStatus LIB "KERNEL32.DLL" ALIAS "GetTapeStatus" (BYVAL hDevice AS DWORD) AS LONG
DECLARE FUNCTION GetTempFileName LIB "KERNEL32.DLL" ALIAS "GetTempFileNameA" (lpszPath AS ASCIIZ, lpPrefixString AS ASCIIZ, BYVAL dwUnique AS DWORD, lpTempFileName AS ASCIIZ) AS DWORD
DECLARE FUNCTION GetTempPath LIB "KERNEL32.DLL" ALIAS "GetTempPathA" (BYVAL nBufferLength AS LONG, lpBuffer AS ASCIIZ) AS LONG
DECLARE FUNCTION GetThreadContext LIB "KERNEL32.DLL" ALIAS "GetThreadContext" (BYVAL hThread AS DWORD, lpContext AS CONTEXT) AS LONG
DECLARE FUNCTION GetThreadLocale LIB "KERNEL32.DLL" ALIAS "GetThreadLocale" () AS LONG
DECLARE FUNCTION GetThreadPriority LIB "KERNEL32.DLL" ALIAS "GetThreadPriority" (BYVAL hThread AS DWORD) AS LONG
DECLARE FUNCTION GetThreadPriorityBoost LIB "KERNEL32.DLL" ALIAS "GetThreadPriorityBoost" (BYVAL hThread AS DWORD, pDisablePriorityBoost AS LONG) AS LONG
DECLARE FUNCTION GetThreadSelectorEntry LIB "KERNEL32.DLL" ALIAS "GetThreadSelectorEntry" (BYVAL hThread AS DWORD, BYVAL dwSelector AS DWORD, lpSelectorEntry AS LDT_ENTRY) AS LONG
DECLARE FUNCTION GetThreadTimes LIB "KERNEL32.DLL" ALIAS "GetThreadTimes" (BYVAL hThread AS DWORD, lpCreationTime AS FILETIME, lpExitTime AS FILETIME, lpKernelTime AS FILETIME, lpUserTime AS FILETIME) AS LONG
DECLARE FUNCTION GetTickCount LIB "KERNEL32.DLL" ALIAS "GetTickCount" () AS DWORD
DECLARE FUNCTION GetTimeFormat LIB "KERNEL32.DLL" ALIAS "GetTimeFormatA" (BYVAL Locale AS LONG, BYVAL dwFlags AS DWORD, lpTime AS SYSTEMTIME, lpFormat AS ASCIIZ, lpTimeStr AS ASCIIZ, BYVAL cchTime AS LONG) AS LONG
DECLARE FUNCTION GetTimeZoneInformation LIB "KERNEL32.DLL" ALIAS "GetTimeZoneInformation" (lpTimeZoneInformation AS TIME_ZONE_INFORMATION) AS DWORD
DECLARE FUNCTION GetUserDefaultLCID LIB "KERNEL32.DLL" ALIAS "GetUserDefaultLCID" () AS LONG
DECLARE FUNCTION GetUserDefaultLangID LIB "KERNEL32.DLL" ALIAS "GetUserDefaultLangID" () AS LONG
DECLARE FUNCTION GetVersion LIB "KERNEL32.DLL" ALIAS "GetVersion" () AS LONG
DECLARE FUNCTION GetVersionEx LIB "KERNEL32.DLL" ALIAS "GetVersionExA" (lpVersionInformation AS OSVERSIONINFO) AS LONG
DECLARE FUNCTION GetVolumeInformation LIB "KERNEL32.DLL" ALIAS "GetVolumeInformationA" (lpRootPathName AS ASCIIZ, lpVolumeNameBuffer AS ASCIIZ, BYVAL nVolumeNameSize AS DWORD, lpVolumeSerialNumber AS DWORD, lpMaximumComponentLength AS DWORD, _
  lpFileSystemFlags AS DWORD, lpFileSystemNameBuffer AS ASCIIZ, BYVAL nFileSystemNameSize AS DWORD) AS LONG
DECLARE FUNCTION GetWindowsDirectory LIB "KERNEL32.DLL" ALIAS "GetWindowsDirectoryA" (lpBuffer AS ASCIIZ, BYVAL nSize AS DWORD) AS DWORD
DECLARE FUNCTION GlobalAddAtom LIB "KERNEL32.DLL" ALIAS "GlobalAddAtomA" (lpString AS ASCIIZ) AS LONG
DECLARE FUNCTION GlobalAlloc LIB "KERNEL32.DLL" ALIAS "GlobalAlloc" (BYVAL wFlags AS DWORD, BYVAL dwBytes AS DWORD) AS LONG
DECLARE FUNCTION GlobalCompact LIB "KERNEL32.DLL" ALIAS "GlobalCompact" (BYVAL dwMinFree AS DWORD) AS LONG
DECLARE FUNCTION GlobalDeleteAtom LIB "KERNEL32.DLL" ALIAS "GlobalDeleteAtom" (BYVAL nAtom AS LONG) AS LONG
DECLARE FUNCTION GlobalFindAtom LIB "KERNEL32.DLL" ALIAS "GlobalFindAtomA" (lpString AS ASCIIZ) AS LONG
DECLARE SUB      GlobalFix LIB "KERNEL32.DLL" ALIAS "GlobalFix" (BYVAL hMem AS DWORD)
DECLARE FUNCTION GlobalFlags LIB "KERNEL32.DLL" ALIAS "GlobalFlags" (BYVAL hMem AS DWORD) AS LONG
DECLARE FUNCTION GlobalFree LIB "KERNEL32.DLL" ALIAS "GlobalFree" (BYVAL hMem AS DWORD) AS LONG
DECLARE FUNCTION GlobalGetAtomName LIB "KERNEL32.DLL" ALIAS "GlobalGetAtomNameA" (BYVAL nAtom AS LONG, lpBuffer AS ASCIIZ, BYVAL nSize AS DWORD) AS DWORD
DECLARE FUNCTION GlobalHandle LIB "KERNEL32.DLL" ALIAS "GlobalHandle" (pMem AS ANY) AS DWORD
DECLARE FUNCTION GlobalLock LIB "KERNEL32.DLL" ALIAS "GlobalLock" (BYVAL hMem AS DWORD) AS DWORD
DECLARE SUB      GlobalMemoryStatus LIB "KERNEL32.DLL" ALIAS "GlobalMemoryStatus" (lpBuffer AS MEMORYSTATUS)
DECLARE FUNCTION GlobalReAlloc LIB "KERNEL32.DLL" ALIAS "GlobalReAlloc" (BYVAL hMem AS DWORD, BYVAL dwBytes AS DWORD, BYVAL uFlags AS DWORD) AS DWORD
DECLARE FUNCTION GlobalMemoryStatusEx LIB "KERNEL32.DLL" ALIAS "GlobalMemoryStatusEx" (lpBuffer AS MEMORYSTATUSEX) AS LONG
DECLARE FUNCTION GlobalSize LIB "KERNEL32.DLL" ALIAS "GlobalSize" (BYVAL hMem AS DWORD) AS DWORD
DECLARE SUB      GlobalUnfix LIB "KERNEL32.DLL" ALIAS "GlobalUnfix" (BYVAL hMem AS DWORD)
DECLARE FUNCTION GlobalUnlock LIB "KERNEL32.DLL" ALIAS "GlobalUnlock" (BYVAL hMem AS DWORD) AS LONG
DECLARE FUNCTION GlobalUnWire LIB "KERNEL32.DLL" ALIAS "GlobalUnWire" (BYVAL hMem AS DWORD) AS LONG
DECLARE FUNCTION GlobalWire LIB "KERNEL32.DLL" ALIAS "GlobalWire" (BYVAL hMem AS DWORD) AS LONG
DECLARE FUNCTION HeapAlloc LIB "KERNEL32.DLL" ALIAS "HeapAlloc" (BYVAL hHeap AS DWORD, BYVAL dwFlags AS DWORD, BYVAL dwBytes AS DWORD) AS DWORD
DECLARE FUNCTION HeapCompact LIB "KERNEL32.DLL" ALIAS "HeapCompact" (BYVAL hHeap AS DWORD, BYVAL dwFlags AS DWORD) AS DWORD
DECLARE FUNCTION HeapCreate LIB "KERNEL32.DLL" ALIAS "HeapCreate" (BYVAL flOptions AS DWORD, BYVAL dwInitialSize AS DWORD, BYVAL dwMaximumSize AS DWORD) AS DWORD
DECLARE FUNCTION HeapDestroy LIB "KERNEL32.DLL" ALIAS "HeapDestroy" (BYVAL hHeap AS DWORD) AS LONG
DECLARE FUNCTION HeapFree LIB "KERNEL32.DLL" ALIAS "HeapFree" (BYVAL hHeap AS DWORD, BYVAL dwFlags AS DWORD, BYVAL lpMem AS DWORD) AS LONG
DECLARE FUNCTION HeapLock LIB "KERNEL32.DLL" ALIAS "HeapLock" (BYVAL hHeap AS DWORD) AS LONG
DECLARE FUNCTION HeapReAlloc LIB "KERNEL32.DLL" ALIAS "HeapReAlloc" (BYVAL hHeap AS DWORD, BYVAL dwFlags AS DWORD, BYVAL lpMem AS DWORD, BYVAL dwBytes AS DWORD) AS DWORD
DECLARE FUNCTION HeapSize LIB "KERNEL32.DLL" ALIAS "HeapSize" (BYVAL hHeap AS DWORD, BYVAL dwFlags AS DWORD, BYVAL lpMem AS DWORD) AS DWORD
DECLARE FUNCTION HeapUnlock LIB "KERNEL32.DLL" ALIAS "HeapUnlock" (BYVAL hHeap AS DWORD) AS LONG
DECLARE FUNCTION HeapValidate LIB "KERNEL32.DLL" ALIAS "HeapValidate" (BYVAL hHeap AS DWORD, BYVAL dwFlags AS DWORD, BYVAL lpMem AS DWORD) AS LONG
DECLARE FUNCTION ImpersonateLoggedOnUser LIB "KERNEL32.DLL" ALIAS "ImpersonateLoggedOnUser" (BYVAL hToken AS DWORD) AS LONG
DECLARE FUNCTION InitAtomTable LIB "KERNEL32.DLL" ALIAS "InitAtomTable" (BYVAL nSize AS DWORD) AS LONG
DECLARE SUB      InitializeCriticalSection LIB "KERNEL32.DLL" ALIAS "InitializeCriticalSection" (lpCriticalSection AS CRITICAL_SECTION)
DECLARE FUNCTION InitializeCriticalSectionAndSpinCount LIB "KERNEL32.DLL" ALIAS "InitializeCriticalSectionAndSpinCount" (lpCriticalSection AS CRITICAL_SECTION, BYVAL dwSpinCount AS DWORD) AS LONG
DECLARE FUNCTION InterlockedDecrement LIB "KERNEL32.DLL" ALIAS "InterlockedDecrement" (lpAddend AS LONG) AS LONG
DECLARE FUNCTION InterlockedExchange LIB "KERNEL32.DLL" ALIAS "InterlockedExchange" (xTarget AS LONG, BYVAL xValue AS LONG) AS LONG
DECLARE FUNCTION InterlockedIncrement LIB "KERNEL32.DLL" ALIAS "InterlockedIncrement" (lpAddend AS LONG) AS LONG
DECLARE FUNCTION IsBadCodePtr LIB "KERNEL32.DLL" ALIAS "IsBadCodePtr" (BYVAL lpfn AS DWORD) AS LONG
DECLARE FUNCTION IsBadHugeReadPtr LIB "KERNEL32.DLL" ALIAS "IsBadHugeReadPtr" (BYVAL lp AS DWORD, BYVAL ucb AS DWORD) AS LONG
DECLARE FUNCTION IsBadHugeWritePtr LIB "KERNEL32.DLL" ALIAS "IsBadHugeWritePtr" (BYVAL lp AS DWORD, BYVAL ucb AS DWORD) AS LONG
DECLARE FUNCTION IsBadReadPtr LIB "KERNEL32.DLL" ALIAS "IsBadReadPtr" (BYVAL lp AS DWORD, BYVAL ucb AS DWORD) AS LONG
DECLARE FUNCTION IsBadStringPtr LIB "KERNEL32.DLL" ALIAS "IsBadStringPtrA" (lpsz AS ASCIIZ, BYVAL ucchMax AS DWORD) AS LONG
DECLARE FUNCTION IsBadWritePtr LIB "KERNEL32.DLL" ALIAS "IsBadWritePtr" (BYVAL lp AS DWORD, BYVAL ucb AS DWORD) AS LONG
DECLARE FUNCTION IsDBCSLeadByte LIB "KERNEL32.DLL" ALIAS "IsDBCSLeadByte" (BYVAL bTestChar AS BYTE) AS LONG
DECLARE FUNCTION IsDebuggerPresent LIB "KERNEL32.DLL" ALIAS "IsDebuggerPresent" () AS LONG
DECLARE FUNCTION IsValidCodePage LIB "KERNEL32.DLL" ALIAS "IsValidCodePage" (BYVAL CodePage AS LONG) AS LONG
DECLARE FUNCTION IsValidLocale LIB "KERNEL32.DLL" ALIAS "IsValidLocale" (BYVAL Locale AS LONG, BYVAL dwFlags AS DWORD) AS LONG
DECLARE FUNCTION LCMapString LIB "KERNEL32.DLL" ALIAS "LCMapStringA" (BYVAL Locale AS LONG, BYVAL dwMapFlags AS DWORD, lpSrcStr AS ASCIIZ, BYVAL cchSrc AS LONG, lpDestStr AS ASCIIZ, BYVAL cchDest AS LONG) AS LONG
DECLARE SUB      LeaveCriticalSection LIB "KERNEL32.DLL" ALIAS "LeaveCriticalSection" (lpCriticalSection AS CRITICAL_SECTION)
DECLARE FUNCTION LoadLibrary LIB "KERNEL32.DLL" ALIAS "LoadLibraryA" (lpLibFileName AS ASCIIZ) AS LONG
DECLARE FUNCTION LoadLibraryEx LIB "KERNEL32.DLL" ALIAS "LoadLibraryExA" (lpLibFileName AS ASCIIZ, BYVAL hFile AS DWORD, BYVAL dwFlags AS DWORD) AS LONG
DECLARE FUNCTION LoadModule LIB "KERNEL32.DLL" ALIAS "LoadModule" (lpModuleName AS ASCIIZ, lpParameterBlock AS ANY) AS LONG
DECLARE FUNCTION LoadResource LIB "KERNEL32.DLL" ALIAS "LoadResource" (BYVAL hInstance AS DWORD, BYVAL hResInfo AS DWORD) AS LONG
DECLARE FUNCTION LocalAlloc LIB "KERNEL32.DLL" ALIAS "LocalAlloc" (BYVAL uFlags AS DWORD, BYVAL lBytes AS LONG) AS DWORD
DECLARE FUNCTION LocalCompact LIB "KERNEL32.DLL" ALIAS "LocalCompact" (BYVAL uMinFree AS DWORD) AS LONG
DECLARE FUNCTION LocalFileTimeToFileTime LIB "KERNEL32.DLL" ALIAS "LocalFileTimeToFileTime" (lpLocalFileTime AS FILETIME, lpFileTime AS FILETIME) AS LONG
DECLARE FUNCTION LocalFlags LIB "KERNEL32.DLL" ALIAS "LocalFlags" (BYVAL hMem AS DWORD) AS DWORD
DECLARE FUNCTION LocalFree LIB "KERNEL32.DLL" ALIAS "LocalFree" (BYVAL hMem AS DWORD) AS LONG
DECLARE FUNCTION LocalHandle LIB "KERNEL32.DLL" ALIAS "LocalHandle" (BYVAL pMem AS DWORD) AS DWORD
DECLARE FUNCTION LocalLock LIB "KERNEL32.DLL" ALIAS "LocalLock" (BYVAL hMem AS DWORD) AS DWORD
DECLARE FUNCTION LocalReAlloc LIB "KERNEL32.DLL" ALIAS "LocalReAlloc" (BYVAL hMem AS DWORD, BYVAL lBytes AS LONG, BYVAL uFlags AS DWORD) AS DWORD
DECLARE FUNCTION LocalShrink LIB "KERNEL32.DLL" ALIAS "LocalShrink" (BYVAL hMem AS DWORD, BYVAL cbNewSize AS LONG) AS LONG
DECLARE FUNCTION LocalSize LIB "KERNEL32.DLL" ALIAS "LocalSize" (BYVAL hMem AS DWORD) AS DWORD
DECLARE FUNCTION LocalUnlock LIB "KERNEL32.DLL" ALIAS "LocalUnlock" (BYVAL hMem AS DWORD) AS LONG
DECLARE FUNCTION LockFile LIB "KERNEL32.DLL" ALIAS "LockFile" (BYVAL hFile AS DWORD, BYVAL dwFileOffsetLow AS DWORD, BYVAL dwFileOffsetHigh AS DWORD, BYVAL nNumberOfBytesToLockLow AS LONG, BYVAL nNumberOfBytesToLockHigh AS LONG) AS LONG
DECLARE FUNCTION LockFileEx LIB "KERNEL32.DLL" ALIAS "LockFileEx" (BYVAL hFile AS DWORD, BYVAL dwFlags AS DWORD, BYVAL dwReserved AS DWORD, BYVAL nNumberOfBytesToLockLow AS LONG, BYVAL nNumberOfBytesToLockHigh AS LONG, _
                 lpOverlapped AS OVERLAPPED) AS LONG
DECLARE FUNCTION LockResource LIB "KERNEL32.DLL" ALIAS "LockResource" (BYVAL hResData AS DWORD) AS DWORD
DECLARE FUNCTION LogonUser LIB "KERNEL32.DLL" ALIAS "LogonUserA" (lpszUsername AS ASCIIZ, lpszDomain AS ASCIIZ, lpszPassword AS ASCIIZ, BYVAL dwLogonType AS DWORD, BYVAL dwLogonProvider AS DWORD, phToken AS DWORD) AS LONG
DECLARE FUNCTION MapViewOfFile LIB "KERNEL32.DLL" ALIAS "MapViewOfFile" (BYVAL hFileMappingObject AS DWORD, BYVAL dwDesiredAccess AS DWORD, BYVAL dwFileOffsetHigh AS DWORD, BYVAL dwFileOffsetLow AS DWORD, BYVAL dwNumberOfBytesToMap AS DWORD) AS DWORD
DECLARE FUNCTION MapViewOfFileEx LIB "KERNEL32.DLL" ALIAS "MapViewOfFileEx" (BYVAL hFileMappingObject AS DWORD, BYVAL dwDesiredAccess AS DWORD, BYVAL dwFileOffsetHigh AS DWORD, BYVAL dwFileOffsetLow AS DWORD, BYVAL dwNumberOfBytesToMap AS DWORD, _
                 lpBaseAddress AS DWORD) AS DWORD
DECLARE FUNCTION MoveFile LIB "KERNEL32.DLL" ALIAS "MoveFileA" (lpExistingFileName AS ASCIIZ, lpNewFileName AS ASCIIZ) AS LONG
DECLARE FUNCTION MoveFileEx LIB "KERNEL32.DLL" ALIAS "MoveFileExA" (lpExistingFileName AS ASCIIZ, lpNewFileName AS ASCIIZ, BYVAL dwFlags AS DWORD) AS LONG
DECLARE FUNCTION MoveFileWithProgress LIB "KERNEL32.DLL" ALIAS "MoveFileWithProgressA" (lpExistingFileName AS ASCIIZ, lpNewFileName AS ASCIIZ, BYVAL lpProgressRoutine AS DWORD, BYVAL lpData AS BYTE PTR, BYVAL dwFlags AS DWORD) AS LONG
DECLARE FUNCTION MulDiv LIB "KERNEL32.DLL" ALIAS "MulDiv" (BYVAL nNumber AS LONG, BYVAL nNumerator AS LONG, BYVAL nDenominator AS LONG) AS LONG
DECLARE FUNCTION MultiByteToWideChar LIB "KERNEL32.DLL" ALIAS "MultiByteToWideChar" (BYVAL CodePage AS LONG, BYVAL dwFlags AS DWORD, lpMultiByteStr AS ASCIIZ, BYVAL cchMultiByte AS LONG, lpWideCharStr AS ASCIIZ, BYVAL cchWideChar AS LONG) AS LONG
DECLARE FUNCTION ObjectOpenAuditAlarm LIB "KERNEL32.DLL" ALIAS "ObjectOpenAuditAlarmA" (SubsystemName AS ASCIIZ, HandleId AS ANY, ObjectTypeName AS ASCIIZ, ObjectName AS ASCIIZ, pSecurityDescriptor AS SECURITY_DESCRIPTOR, _
                 BYVAL ClientToken AS LONG, BYVAL DesiredAccess AS LONG, BYVAL GrantedAccess AS LONG, Privileges AS ANY, BYVAL ObjectCreation AS LONG, BYVAL AccessGranted AS LONG, BYVAL GenerateOnClose AS LONG) AS LONG
DECLARE FUNCTION OpenEvent LIB "KERNEL32.DLL" ALIAS "OpenEventA" (BYVAL dwDesiredAccess AS DWORD, BYVAL bInheritHandle AS LONG, lpName AS ASCIIZ) AS LONG
DECLARE FUNCTION OpenFile LIB "KERNEL32.DLL" ALIAS "OpenFile" (lpFileName AS ASCIIZ, lpReOpenBuff AS OFSTRUCT, BYVAL uStyle AS DWORD) AS DWORD
DECLARE FUNCTION OpenFileMapping LIB "KERNEL32.DLL" ALIAS "OpenFileMappingA" (BYVAL dwDesiredAccess AS DWORD, BYVAL bInheritHandle AS LONG, lpName AS ASCIIZ) AS DWORD
DECLARE FUNCTION OpenMutex LIB "KERNEL32.DLL" ALIAS "OpenMutexA" (BYVAL dwDesiredAccess AS DWORD, BYVAL bInheritHandle AS LONG, lpName AS ASCIIZ) AS DWORD
DECLARE FUNCTION OpenProcess LIB "KERNEL32.DLL" ALIAS "OpenProcess" (BYVAL dwDesiredAccess AS DWORD, BYVAL bInheritHandle AS LONG, BYVAL dwProcessId AS DWORD) AS DWORD
DECLARE FUNCTION OpenSemaphore LIB "KERNEL32.DLL" ALIAS "OpenSemaphoreA" (BYVAL dwDesiredAccess AS DWORD, BYVAL bInheritHandle AS LONG, lpName AS ASCIIZ) AS DWORD
DECLARE FUNCTION OpenWaitableTimer LIB "KERNEL32.DLL" ALIAS "OpenWaitableTimerA" (BYVAL dwDesiredAccess AS DWORD, BYVAL bInheritHandle AS LONG, lpTimerName AS ASCIIZ) AS DWORD
DECLARE SUB      OutputDebugString LIB "KERNEL32.DLL" ALIAS "OutputDebugStringA" (lpOutputString AS ASCIIZ)
DECLARE FUNCTION PeekConsoleInput LIB "KERNEL32.DLL" ALIAS "PeekConsoleInputA" (BYVAL hConsoleInput AS DWORD, lpBuffer AS INPUT_RECORD, BYVAL nLength AS DWORD, lpNumberOfEventsWritten AS DWORD) AS LONG
DECLARE FUNCTION PeekNamedPipe LIB "KERNEL32.DLL" ALIAS "PeekNamedPipe" (BYVAL hNamedPipe AS DWORD, lpBuffer AS ANY, BYVAL nBufferSize AS LONG, lpBytesRead AS LONG, lpTotalBytesAvail AS LONG, lpBytesLeftThisMessage AS LONG) AS LONG
DECLARE FUNCTION PrepareTape LIB "KERNEL32.DLL" ALIAS "PrepareTape" (BYVAL hDevice AS DWORD, BYVAL dwOperation AS DWORD, BYVAL bimmediate AS LONG) AS LONG
DECLARE FUNCTION PulseEvent LIB "KERNEL32.DLL" ALIAS "PulseEvent" (BYVAL hEvent AS DWORD) AS LONG
DECLARE FUNCTION PurgeComm LIB "KERNEL32.DLL" ALIAS "PurgeComm" (BYVAL hFile AS DWORD, BYVAL dwFlags AS DWORD) AS LONG
DECLARE FUNCTION QueueUserAPC LIB "KERNEL32.DLL" ALIAS "QueueUserAPC" (BYVAL pfnAPC AS DWORD, BYVAL hThread AS DWORD, BYVAL dwData AS DWORD) AS DWORD
DECLARE FUNCTION QueryDosDevice LIB "KERNEL32.DLL" ALIAS "QueryDosDeviceA" (lpDeviceName AS ASCIIZ, lpTargetPath AS ASCIIZ, BYVAL ucchMax AS DWORD) AS LONG
DECLARE FUNCTION QueryPerformanceCounter LIB "KERNEL32.DLL" ALIAS "QueryPerformanceCounter" (lpPerformanceCount AS QUAD) AS LONG
DECLARE FUNCTION QueryPerformanceFrequency LIB "KERNEL32.DLL" ALIAS "QueryPerformanceFrequency" (lpFrequency AS QUAD) AS LONG
DECLARE SUB      RaiseException LIB "KERNEL32.DLL" ALIAS "RaiseException" (BYVAL dwExceptionCode AS DWORD, BYVAL dwExceptionFlags AS DWORD, BYVAL nNumberOfArguments AS LONG, lpArguments AS LONG)
DECLARE FUNCTION ReadConsole LIB "KERNEL32.DLL" ALIAS "ReadConsoleA" (BYVAL hConsoleInput AS DWORD, lpBuffer AS ANY, BYVAL nNumberOfCharsToRead AS LONG, lpNumberOfCharsRead AS LONG, lpReserved AS ANY) AS LONG
DECLARE FUNCTION ReadConsoleInput LIB "KERNEL32.DLL" ALIAS "ReadConsoleInputA" (BYVAL hConsoleInput AS DWORD, lpBuffer AS ANY, BYVAL nNumberOfCharsToRead AS LONG, lpNumberOfCharsRead AS LONG) AS LONG
DECLARE FUNCTION ReadConsoleOutput LIB "KERNEL32.DLL" ALIAS "ReadConsoleOutputA" (BYVAL hConsoleOutput AS DWORD, BYVAL lpBuffer AS DWORD, BYVAL dwBufferSize AS DWORD, BYVAL dwBufferCoord AS DWORD, lpReadRegion AS SMALL_RECT) AS LONG
DECLARE FUNCTION ReadConsoleOutputAttribute LIB "KERNEL32.DLL" ALIAS "ReadConsoleOutputAttribute" (BYVAL hConsoleOutput AS DWORD, lpdwAttribute AS DWORD, BYVAL nLength AS LONG, BYVAL dwReadCoord AS DWORD, lpNumberOfAttrsRead AS LONG) AS LONG
DECLARE FUNCTION ReadConsoleOutputCharacter LIB "KERNEL32.DLL" ALIAS "ReadConsoleOutputCharacterA" (BYVAL hConsoleOutput AS DWORD, szCharacter AS ASCIIZ, BYVAL nLength AS LONG, BYVAL dwReadCoord AS DWORD, lpNumberOfCharsRead AS LONG) AS LONG
DECLARE FUNCTION ReadFile LIB "KERNEL32.DLL" ALIAS "ReadFile" (BYVAL hFile AS DWORD, lpBuffer AS ANY, BYVAL nNumberOfBytesToRead AS LONG, lpNumberOfBytesRead AS LONG, lpOverlapped AS OVERLAPPED) AS LONG
DECLARE FUNCTION ReadFileEx LIB "KERNEL32.DLL" ALIAS "ReadFileEx" (BYVAL hFile AS DWORD, lpBuffer AS ANY, BYVAL nNumberOfBytesToRead AS LONG, lpOverlapped AS OVERLAPPED, BYVAL lpCompletionRoutine AS LONG) AS LONG
DECLARE FUNCTION ReadProcessMemory LIB "KERNEL32.DLL" ALIAS "ReadProcessMemory" (BYVAL hProcess AS DWORD, BYVAL lpBaseAddress AS LONG, lpBuffer AS ANY, BYVAL nSize AS DWORD, lpNumberOfBytesWritten AS LONG) AS LONG
DECLARE FUNCTION ReleaseMutex LIB "KERNEL32.DLL" ALIAS "ReleaseMutex" (BYVAL hMutex AS DWORD) AS LONG
DECLARE FUNCTION ReleaseSemaphore LIB "KERNEL32.DLL" ALIAS "ReleaseSemaphore" (BYVAL hSemaphore AS DWORD, BYVAL lReleaseCount AS LONG, lpPreviousCount AS LONG) AS LONG
DECLARE FUNCTION RemoveDirectory LIB "KERNEL32.DLL" ALIAS "RemoveDirectoryA" (lpPathName AS ASCIIZ) AS LONG
DECLARE FUNCTION RequestWakeupLatency LIB "KERNEL32.DLL" ALIAS "RequestWakeupLatency" (BYVAL latency AS LONG) AS LONG
DECLARE FUNCTION ResetEvent LIB "KERNEL32.DLL" ALIAS "ResetEvent" (BYVAL hEvent AS DWORD) AS LONG
DECLARE FUNCTION ResumeThread LIB "KERNEL32.DLL" ALIAS "ResumeThread" (BYVAL hThread AS DWORD) AS LONG
DECLARE FUNCTION ScrollConsoleScreenBuffer LIB "KERNEL32.DLL" ALIAS "ScrollConsoleScreenBufferA" (BYVAL hConsoleOutput AS DWORD, lpScrollRectangle AS SMALL_RECT, lpClipRectangle AS SMALL_RECT, BYVAL dwDestinationOrigin AS DWORD, _
                 lpFill AS CHAR_INFO) AS LONG
DECLARE FUNCTION SearchPath LIB "KERNEL32.DLL" ALIAS "SearchPathA" (lpPath AS ASCIIZ, lpFileName AS ASCIIZ, lpExtension AS ASCIIZ, BYVAL nBufferLength AS LONG, lpBuffer AS ASCIIZ, lpFilePart AS ASCIIZ) AS LONG
DECLARE FUNCTION SetCommBreak LIB "KERNEL32.DLL" ALIAS "SetCommBreak" (BYVAL nCid AS LONG) AS LONG
DECLARE FUNCTION SetCommConfig LIB "KERNEL32.DLL" ALIAS "SetCommConfig" (BYVAL hCommDev AS DWORD, lpCC AS COMMCONFIG, BYVAL dwSize AS DWORD) AS LONG
DECLARE FUNCTION SetCommMask LIB "KERNEL32.DLL" ALIAS "SetCommMask" (BYVAL hFile AS DWORD, BYVAL dwEventMask AS DWORD) AS LONG
DECLARE FUNCTION SetCommState LIB "KERNEL32.DLL" ALIAS "SetCommState" (BYVAL hCommDev AS DWORD, lpDCB AS DCB) AS LONG
DECLARE FUNCTION SetCommTimeouts LIB "KERNEL32.DLL" ALIAS "SetCommTimeouts" (BYVAL hFile AS DWORD, lpCommTimeouts AS COMMTIMEOUTS) AS LONG
DECLARE FUNCTION SetComputerName LIB "KERNEL32.DLL" ALIAS "SetComputerNameA" (lpComputerName AS ASCIIZ) AS LONG
DECLARE FUNCTION SetConsoleActiveScreenBuffer LIB "KERNEL32.DLL" ALIAS "SetConsoleActiveScreenBuffer" (BYVAL hConsoleOutput AS DWORD) AS LONG
DECLARE FUNCTION SetConsoleCP LIB "KERNEL32.DLL" ALIAS "SetConsoleCP" (BYVAL dwCodePageID AS DWORD) AS LONG
DECLARE FUNCTION SetConsoleCtrlHandler LIB "KERNEL32.DLL" ALIAS "SetConsoleCtrlHandler" (BYVAL HandlerRoutine AS DWORD, BYVAL nAdd AS LONG) AS LONG
DECLARE FUNCTION SetConsoleCursorInfo LIB "KERNEL32.DLL" ALIAS "SetConsoleCursorInfo" (BYVAL hConsoleOutput AS DWORD, lpConsoleCursorInfo AS CONSOLE_CURSOR_INFO) AS LONG
DECLARE FUNCTION SetConsoleCursorPosition LIB "KERNEL32.DLL" ALIAS "SetConsoleCursorPosition" (BYVAL hConsoleOutput AS DWORD, BYVAL dwCursorPosition AS DWORD) AS LONG
DECLARE FUNCTION SetConsoleMode LIB "KERNEL32.DLL" ALIAS "SetConsoleMode" (BYVAL hConsoleHandle AS DWORD, BYVAL dwMode AS DWORD) AS LONG
DECLARE FUNCTION SetConsoleOutputCP LIB "KERNEL32.DLL" ALIAS "SetConsoleOutputCP" (BYVAL dwCodePageID AS DWORD) AS LONG
DECLARE FUNCTION SetConsoleScreenBufferSize LIB "KERNEL32.DLL" ALIAS "SetConsoleScreenBufferSize" (BYVAL hConsoleOutput AS DWORD, BYVAL dwSize AS DWORD) AS LONG
DECLARE FUNCTION SetConsoleTextAttribute LIB "KERNEL32.DLL" ALIAS "SetConsoleTextAttribute" (BYVAL hConsoleOutput AS DWORD, BYVAL dwAttributes AS DWORD) AS LONG
DECLARE FUNCTION SetConsoleTitle LIB "KERNEL32.DLL" ALIAS "SetConsoleTitleA" (lpConsoleTitle AS ASCIIZ) AS LONG
DECLARE FUNCTION SetConsoleWindowInfo LIB "KERNEL32.DLL" ALIAS "SetConsoleWindowInfo" (BYVAL hConsoleOutput AS DWORD, BYVAL bAbsolute AS LONG, lpConsoleWindow AS SMALL_RECT) AS LONG
DECLARE FUNCTION SetCriticalSectionSpinCount LIB "KERNEL32.DLL" ALIAS "SetCriticalSectionSpinCount" (lpCriticalSection AS CRITICAL_SECTION, BYVAL dwSpinCount AS DWORD) AS DWORD
DECLARE FUNCTION SetCurrentDirectory LIB "KERNEL32.DLL" ALIAS "SetCurrentDirectoryA" (lpPathName AS ASCIIZ) AS LONG
DECLARE FUNCTION SetDefaultCommConfig LIB "KERNEL32.DLL" ALIAS "SetDefaultCommConfigA" (lpszName AS ASCIIZ, lpCC AS COMMCONFIG, BYVAL dwSize AS DWORD) AS LONG
DECLARE FUNCTION SetEndOfFile LIB "KERNEL32.DLL" ALIAS "SetEndOfFile" (BYVAL hFile AS DWORD) AS LONG
DECLARE FUNCTION SetEnvironmentVariable LIB "KERNEL32.DLL" ALIAS "SetEnvironmentVariableA" (lpName AS ASCIIZ, lpValue AS ASCIIZ) AS LONG
DECLARE FUNCTION SetErrorMode LIB "KERNEL32.DLL" ALIAS "SetErrorMode" (BYVAL uMode AS DWORD) AS DWORD
DECLARE FUNCTION SetEvent LIB "KERNEL32.DLL" ALIAS "SetEvent" (BYVAL hEvent AS DWORD) AS LONG
DECLARE SUB      SetFileApisToANSI LIB "KERNEL32.DLL" ALIAS "SetFileApisToANSI" ()
DECLARE SUB      SetFileApisToOEM LIB "KERNEL32.DLL" ALIAS "SetFileApisToOEM" ()
DECLARE FUNCTION SetFileAttributes LIB "KERNEL32.DLL" ALIAS "SetFileAttributesA" (lpFileName AS ASCIIZ, BYVAL dwFileAttributes AS DWORD) AS LONG
DECLARE FUNCTION SetFilePointer LIB "KERNEL32.DLL" ALIAS "SetFilePointer" (BYVAL hFile AS DWORD, BYVAL lDistanceToMove AS LONG, lpDistanceToMoveHigh AS LONG, BYVAL dwMoveMethod AS DWORD) AS LONG
DECLARE FUNCTION SetFileTime LIB "KERNEL32.DLL" ALIAS "SetFileTime" (BYVAL hFile AS DWORD, lpCreationTime AS FILETIME, lpLastAccessTime AS FILETIME, lpLastWriteTime AS FILETIME) AS LONG
DECLARE FUNCTION SetHandleCount LIB "KERNEL32.DLL" ALIAS "SetHandleCount" (BYVAL uNumber AS DWORD) AS DWORD
DECLARE FUNCTION SetHandleInformation LIB "KERNEL32.DLL" ALIAS "SetHandleInformation" (BYVAL hObject AS DWORD, BYVAL dwMask AS DWORD, BYVAL dwFlags AS DWORD) AS LONG
DECLARE SUB      SetLastError LIB "KERNEL32.DLL" ALIAS "SetLastError" (BYVAL dwErrCode AS DWORD)
DECLARE FUNCTION SetLocalTime LIB "KERNEL32.DLL" ALIAS "SetLocalTime" (lpSystemTime AS SYSTEMTIME) AS LONG
DECLARE FUNCTION SetLocaleInfo LIB "KERNEL32.DLL" ALIAS "SetLocaleInfoA" (BYVAL Locale AS LONG, BYVAL LCType AS LONG, lpLCData AS ASCIIZ) AS LONG
DECLARE FUNCTION SetMailslotInfo LIB "KERNEL32.DLL" ALIAS "SetMailslotInfo" (BYVAL hMailslot AS DWORD, BYVAL lReadTimeout AS LONG) AS LONG
DECLARE FUNCTION SetNamedPipeHandleState LIB "KERNEL32.DLL" ALIAS "SetNamedPipeHandleState" (BYVAL hNamedPipe AS DWORD, lpMode AS DWORD, lpMaxCollectionCount AS DWORD, lpCollectDataTimeout AS DWORD) AS LONG
DECLARE FUNCTION SetPriorityClass LIB "KERNEL32.DLL" ALIAS "SetPriorityClass" (BYVAL hProcess AS DWORD, BYVAL dwPriorityClass AS DWORD) AS LONG
DECLARE FUNCTION SetProcessPriorityBoost LIB "KERNEL32.DLL" ALIAS "SetProcessPriorityBoost" (BYVAL hProcess AS DWORD, BYVAL bDisablePriorityBoost AS LONG) AS LONG
DECLARE FUNCTION SetProcessShutdownParameters LIB "KERNEL32.DLL" ALIAS "SetProcessShutdownParameters" (BYVAL dwLevel AS DWORD, BYVAL dwFlags AS DWORD) AS LONG
DECLARE FUNCTION SetProcessWorkingSetSize LIB "KERNEL32.DLL" ALIAS "SetProcessWorkingSetSize" (BYVAL hProcess AS DWORD, BYVAL dwMinimumWorkingSetSize AS DWORD, BYVAL dwMaximumWorkingSetSize AS DWORD) AS LONG
DECLARE FUNCTION SetStdHandle LIB "KERNEL32.DLL" ALIAS "SetStdHandle" (BYVAL nStdHandle AS DWORD, BYVAL nHandle AS DWORD) AS LONG
DECLARE FUNCTION SetSystemPowerState LIB "KERNEL32.DLL" ALIAS "SetSystemPowerState" (BYVAL fSuspend AS LONG, BYVAL fForce AS LONG) AS LONG
DECLARE FUNCTION SetSystemTime LIB "KERNEL32.DLL" ALIAS "SetSystemTime" (lpSystemTime AS SYSTEMTIME) AS LONG
DECLARE FUNCTION SetSystemTimeAdjustment LIB "KERNEL32.DLL" ALIAS "SetSystemTimeAdjustment" (BYVAL dwTimeAdjustment AS DWORD, BYVAL bTimeAdjustmentDisabled AS LONG) AS LONG
DECLARE FUNCTION SetTapeParameters LIB "KERNEL32.DLL" ALIAS "SetTapeParameters" (BYVAL hDevice AS DWORD, BYVAL dwOperation AS DWORD, lpTapeInformation AS ANY) AS LONG
DECLARE FUNCTION SetTapePosition LIB "KERNEL32.DLL" ALIAS "SetTapePosition" (BYVAL hDevice AS DWORD, BYVAL dwPositionMethod AS DWORD, BYVAL dwPartition AS DWORD, BYVAL dwOffsetLow AS DWORD, BYVAL dwOffsetHigh AS DWORD, _
                 BYVAL bimmediate AS LONG) AS LONG
DECLARE FUNCTION SetThreadAffinityMask LIB "KERNEL32.DLL" ALIAS "SetThreadAffinityMask" (BYVAL hThread AS DWORD, BYVAL dwThreadAffinityMask AS DWORD) AS LONG
DECLARE FUNCTION SetThreadContext LIB "KERNEL32.DLL" ALIAS "SetThreadContext" (BYVAL hThread AS DWORD, lpContext AS CONTEXT) AS LONG
DECLARE FUNCTION SetThreadExecutionState LIB "KERNEL32.DLL" ALIAS "SetThreadExecutionState" (BYVAL esFlags AS DWORD) AS DWORD
DECLARE FUNCTION SetThreadIdealProcessor LIB "KERNEL32.DLL" ALIAS "SetThreadIdealProcessor" (BYVAL hThread AS DWORD, BYVAL dwIdealProcessor AS DWORD) AS DWORD
DECLARE FUNCTION SetThreadLocale LIB "KERNEL32.DLL" ALIAS "SetThreadLocale" (BYVAL Locale AS LONG) AS LONG
DECLARE FUNCTION SetThreadPriority LIB "KERNEL32.DLL" ALIAS "SetThreadPriority" (BYVAL hThread AS DWORD, BYVAL nPriority AS LONG) AS LONG
DECLARE FUNCTION SetThreadPriorityBoost LIB "KERNEL32.DLL" ALIAS "SetThreadPriorityBoost" (BYVAL hThread AS DWORD, BYVAL bDisablePriorityBoost AS LONG) AS LONG
DECLARE FUNCTION SetTimeZoneInformation LIB "KERNEL32.DLL" ALIAS "SetTimeZoneInformation" (lpTimeZoneInformation AS TIME_ZONE_INFORMATION) AS LONG
DECLARE FUNCTION SetUnhandledExceptionFilter LIB "KERNEL32.DLL" ALIAS "SetUnhandledExceptionFilter" (BYVAL lpTopLevelExceptionFilter AS DWORD) AS DWORD
DECLARE FUNCTION SetVolumeLabel LIB "KERNEL32.DLL" ALIAS "SetVolumeLabelA" (lpRootPathName AS ASCIIZ, lpVolumeName AS ASCIIZ) AS LONG
DECLARE FUNCTION SetWaitableTimer LIB "KERNEL32.DLL" ALIAS "SetWaitableTimer" (BYVAL hTimer AS DWORD, lpDueTime AS QUAD, BYVAL lPeriod AS LONG, BYVAL pfnCompletionRoutine AS DWORD, BYVAL lpArgToCompletionRoutine AS DWORD, _
                 BYVAL fResume AS LONG) AS LONG
DECLARE FUNCTION SetupComm LIB "KERNEL32.DLL" ALIAS "SetupComm" (BYVAL hFile AS DWORD, BYVAL dwInQueue AS DWORD, BYVAL dwOutQueue AS DWORD) AS LONG
DECLARE FUNCTION SignalObjectAndWait LIB "KERNEL32.DLL" ALIAS "SignalObjectAndWait" (BYVAL hObjectToSignal AS DWORD, BYVAL hObjectToWaitOn AS DWORD, BYVAL dwMilliseconds AS DWORD, BYVAL bAlertable AS LONG) AS DWORD
DECLARE FUNCTION SizeofResource LIB "KERNEL32.DLL" ALIAS "SizeofResource" (BYVAL hInstance AS DWORD, BYVAL hResInfo AS DWORD) AS LONG
DECLARE SUB      apiSleep LIB "KERNEL32.DLL" ALIAS "Sleep" (BYVAL dwMilliseconds AS DWORD)
DECLARE FUNCTION SleepEx LIB "KERNEL32.DLL" ALIAS "SleepEx" (BYVAL dwMilliseconds AS DWORD, BYVAL bAlertable AS LONG) AS LONG
DECLARE FUNCTION SuspendThread LIB "KERNEL32.DLL" ALIAS "SuspendThread" (BYVAL hThread AS DWORD) AS LONG
DECLARE SUB      SwitchToFiber LIB "KERNEL32.DLL" ALIAS "SwitchToFiber" (BYVAL lpFiber AS DWORD)
DECLARE FUNCTION SwitchToThread LIB "KERNEL32.DLL" ALIAS "SwitchToThread" () AS LONG
DECLARE FUNCTION SystemTimeToFileTime LIB "KERNEL32.DLL" ALIAS "SystemTimeToFileTime" (lpSystemTime AS SYSTEMTIME, lpFileTime AS FILETIME) AS LONG
DECLARE FUNCTION SystemTimeToTzSpecificLocalTime LIB "KERNEL32.DLL" ALIAS "SystemTimeToTzSpecificLocalTime" (lpTimeZoneInformation AS TIME_ZONE_INFORMATION, lpUniversalTime AS SYSTEMTIME, lpLocalTime AS SYSTEMTIME) AS LONG
DECLARE FUNCTION TerminateProcess LIB "KERNEL32.DLL" ALIAS "TerminateProcess" (BYVAL hProcess AS DWORD, BYVAL uExitCode AS DWORD) AS LONG
DECLARE FUNCTION TerminateThread LIB "KERNEL32.DLL" ALIAS "TerminateThread" (BYVAL hThread AS DWORD, BYVAL dwExitCode AS DWORD) AS LONG
DECLARE FUNCTION TlsAlloc LIB "KERNEL32.DLL" ALIAS "TlsAlloc" () AS LONG
DECLARE FUNCTION TlsFree LIB "KERNEL32.DLL" ALIAS "TlsFree" (BYVAL dwTlsIndex AS DWORD) AS LONG
DECLARE FUNCTION TlsGetValue LIB "KERNEL32.DLL" ALIAS "TlsGetValue" (BYVAL dwTlsIndex AS DWORD) AS LONG
DECLARE FUNCTION TlsSetValue LIB "KERNEL32.DLL" ALIAS "TlsSetValue" (BYVAL dwTlsIndex AS DWORD, lpTlsValue AS ANY) AS LONG
DECLARE FUNCTION TransactNamedPipe LIB "KERNEL32.DLL" ALIAS "TransactNamedPipe" (BYVAL hNamedPipe AS DWORD, lpInBuffer AS ANY, BYVAL nInBufferSize AS LONG, lpOutBuffer AS ANY, BYVAL nOutBufferSize AS LONG, lpBytesRead AS LONG, _
                 lpOverlapped AS OVERLAPPED) AS LONG
DECLARE FUNCTION TransmitCommChar LIB "KERNEL32.DLL" ALIAS "TransmitCommChar" (BYVAL nCid AS LONG, BYVAL cChar AS BYTE) AS LONG
DECLARE FUNCTION TryEnterCriticalSection LIB "KERNEL32.DLL" ALIAS "TryEnterCriticalSection" (lpCriticalSection AS CRITICAL_SECTION) AS LONG
DECLARE FUNCTION UnhandledExceptionFilter LIB "KERNEL32.DLL" ALIAS "UnhandledExceptionFilter" (ExceptionInfo AS EXCEPTION_POINTERS) AS LONG
DECLARE FUNCTION UnlockFile LIB "KERNEL32.DLL" ALIAS "UnlockFile" (BYVAL hFile AS DWORD, BYVAL dwFileOffsetLow AS DWORD, BYVAL dwFileOffsetHigh AS DWORD, BYVAL nNumberOfBytesToUnlockLow AS LONG, BYVAL nNumberOfBytesToUnlockHigh AS LONG) AS LONG
DECLARE FUNCTION UnlockFileEx LIB "KERNEL32.DLL" ALIAS "UnlockFileEx" (BYVAL hFile AS DWORD, BYVAL dwReserved AS DWORD, BYVAL nNumberOfBytesToUnlockLow AS LONG, BYVAL nNumberOfBytesToUnlockHigh AS LONG, lpOverlapped AS OVERLAPPED) AS LONG
DECLARE FUNCTION UnmapViewOfFile LIB "KERNEL32.DLL" ALIAS "UnmapViewOfFile" (lpBaseAddress AS ANY) AS LONG
DECLARE FUNCTION UpdateResource LIB "KERNEL32.DLL" ALIAS "UpdateResourceA" (BYVAL hUpdate AS DWORD, lpType AS ASCIIZ, lpName AS ASCIIZ, BYVAL wLanguage AS WORD, lpData AS ANY, BYVAL cbData AS DWORD) AS LONG
DECLARE FUNCTION VerLanguageName LIB "KERNEL32.DLL" ALIAS "VerLanguageNameA" (BYVAL dwLang AS DWORD, szLang AS ASCIIZ, BYVAL nSize AS DWORD) AS DWORD
DECLARE FUNCTION VirtualAlloc LIB "KERNEL32.DLL" ALIAS "VirtualAlloc" (lpAddress AS ANY, BYVAL dwSize AS DWORD, BYVAL flAllocationType AS LONG, BYVAL flProtect AS LONG) AS LONG
DECLARE FUNCTION VirtualAllocEx LIB "KERNEL32.DLL" ALIAS "VirtualAllocEx" (BYVAL hProcess AS DWORD, lpAddress AS ANY, BYVAL dwSize AS DWORD, BYVAL flAllocationType AS DWORD, BYVAL flProtect AS DWORD) AS DWORD
DECLARE FUNCTION VirtualFree LIB "KERNEL32.DLL" ALIAS "VirtualFree" (lpAddress AS ANY, BYVAL dwSize AS DWORD, BYVAL dwFreeType AS DWORD) AS LONG
DECLARE FUNCTION VirtualFreeEx LIB "KERNEL32.DLL" ALIAS "VirtualFreeEx" (BYVAL hProcess AS DWORD, lpAddress AS ANY, BYVAL dwSize AS DWORD, BYVAL dwFreeType AS DWORD) AS LONG
DECLARE FUNCTION VirtualLock LIB "KERNEL32.DLL" ALIAS "VirtualLock" (lpAddress AS ANY, BYVAL dwSize AS DWORD) AS LONG
DECLARE FUNCTION VirtualProtect LIB "KERNEL32.DLL" ALIAS "VirtualProtect" (lpAddress AS ANY, BYVAL dwSize AS DWORD, BYVAL flNewProtect AS LONG, lpflOldProtect AS LONG) AS LONG
DECLARE FUNCTION VirtualProtectEx LIB "KERNEL32.DLL" ALIAS "VirtualProtectEx" (BYVAL hProcess AS DWORD, lpAddress AS ANY, BYVAL dwSize AS DWORD, BYVAL flNewProtect AS LONG, lpflOldProtect AS LONG) AS LONG
DECLARE FUNCTION VirtualQuery LIB "KERNEL32.DLL" ALIAS "VirtualQuery" (lpAddress AS ANY, lpBuffer AS MEMORY_BASIC_INFORMATION, BYVAL dwLength AS DWORD) AS LONG
DECLARE FUNCTION VirtualQueryEx LIB "KERNEL32.DLL" ALIAS "VirtualQueryEx" (BYVAL hProcess AS DWORD, lpAddress AS ANY, lpBuffer AS MEMORY_BASIC_INFORMATION, BYVAL dwLength AS DWORD) AS LONG
DECLARE FUNCTION VirtualUnlock LIB "KERNEL32.DLL" ALIAS "VirtualUnlock" (lpAddress AS ANY, BYVAL dwSize AS DWORD) AS LONG
DECLARE FUNCTION WaitCommEvent LIB "KERNEL32.DLL" ALIAS "WaitCommEvent" (BYVAL hFile AS DWORD, lpEvtMask AS LONG, lpOverlapped AS OVERLAPPED) AS LONG
DECLARE FUNCTION WaitForDebugEvent LIB "KERNEL32.DLL" ALIAS "WaitForDebugEvent" (lpde AS DEBUG_EVENT, BYVAL dwTimeout AS DWORD) AS LONG
DECLARE FUNCTION WaitForMultipleObjects LIB "KERNEL32.DLL" ALIAS "WaitForMultipleObjects" (BYVAL nCount AS DWORD, lpHandles AS DWORD, BYVAL bWaitAll AS LONG, BYVAL dwMilliseconds AS DWORD) AS DWORD
DECLARE FUNCTION WaitForMultipleObjectsEx LIB "KERNEL32.DLL" ALIAS "WaitForMultipleObjectsEx" (BYVAL nCount AS DWORD, lpHandles AS DWORD, BYVAL bWaitAll AS LONG, BYVAL dwMilliseconds AS DWORD, BYVAL bAlertable AS LONG) AS DWORD
DECLARE FUNCTION WaitForSingleObject LIB "KERNEL32.DLL" ALIAS "WaitForSingleObject" (BYVAL hHandle AS DWORD, BYVAL dwMilliseconds AS DWORD) AS DWORD
DECLARE FUNCTION WaitForSingleObjectEx LIB "KERNEL32.DLL" ALIAS "WaitForSingleObjectEx" (BYVAL hHandle AS DWORD, BYVAL dwMilliseconds AS DWORD, BYVAL bAlertable AS LONG) AS DWORD
DECLARE FUNCTION WaitNamedPipe LIB "KERNEL32.DLL" ALIAS "WaitNamedPipeA" (lpNamedPipeName AS ASCIIZ, BYVAL nTimeOut AS DWORD) AS LONG
DECLARE FUNCTION WideCharToMultiByte LIB "KERNEL32.DLL" ALIAS "WideCharToMultiByte" (BYVAL CodePage AS LONG, BYVAL dwFlags AS DWORD, lpWideCharStr AS ASCIIZ, BYVAL cchWideChar AS LONG, lpMultiByteStr AS ASCIIZ, BYVAL cchMultiByte AS LONG, _
                 lpDefaultChar AS ASCIIZ, BYVAL lpUsedDefaultChar AS LONG) AS LONG
DECLARE FUNCTION WinExec LIB "KERNEL32.DLL" ALIAS "WinExec" (lpCmdLine AS ASCIIZ, BYVAL nCmdShow AS LONG) AS LONG
DECLARE FUNCTION WriteConsole LIB "KERNEL32.DLL" ALIAS "WriteConsoleA" (BYVAL hConsoleOutput AS DWORD, lpBuffer AS ASCIIZ, BYVAL nNumberOfCharsToWrite AS LONG, lpNumberOfCharsWritten AS LONG, BYVAL lpReserved AS LONG) AS LONG
DECLARE FUNCTION WriteConsoleInput LIB "KERNEL32.DLL" ALIAS "WriteConsoleInputA" (BYVAL hConsoleInput AS DWORD, lpBuffer AS INPUT_RECORD, BYVAL nLength AS DWORD, lpNumberOfEventsWritten AS LONG) AS LONG
DECLARE FUNCTION WriteConsoleOutput LIB "KERNEL32.DLL" ALIAS "WriteConsoleOutputA" (BYVAL hConsoleOutput AS DWORD, BYVAL lpBuffer AS DWORD, BYVAL dwBufferSize AS DWORD, BYVAL dwBufferCoord AS DWORD, lpWriteRegion AS SMALL_RECT) AS LONG
DECLARE FUNCTION WriteConsoleOutputAttribute LIB "KERNEL32.DLL" ALIAS "WriteConsoleOutputAttribute" (BYVAL hConsoleOutput AS DWORD, lpdwAttribute AS DWORD, BYVAL nLength AS LONG, BYVAL dwWriteCoord AS DWORD, lpNumberOfAttrsWritten AS LONG) AS LONG
DECLARE FUNCTION WriteConsoleOutputCharacter LIB "KERNEL32.DLL" ALIAS "WriteConsoleOutputCharacterA" (BYVAL hConsoleOutput AS DWORD, szCharacter AS ASCIIZ, BYVAL nLength AS LONG, BYVAL dwWriteCoord AS DWORD, lpNumberOfCharsWritten AS LONG) AS LONG
DECLARE FUNCTION WriteFile LIB "KERNEL32.DLL" ALIAS "WriteFile" (BYVAL hFile AS DWORD, lpBuffer AS ANY, BYVAL nNumberOfBytesToWrite AS LONG, lpNumberOfBytesWritten AS LONG, lpOverlapped AS OVERLAPPED) AS LONG
DECLARE FUNCTION WriteFileEx LIB "KERNEL32.DLL" ALIAS "WriteFileEx" (BYVAL hFile AS DWORD, lpBuffer AS ANY, BYVAL nNumberOfBytesToWrite AS LONG, lpOverlapped AS OVERLAPPED, BYVAL lpCompletionRoutine AS LONG) AS LONG
DECLARE FUNCTION WritePrivateProfileSection LIB "KERNEL32.DLL" ALIAS "WritePrivateProfileSectionA" (lpAppName AS ASCIIZ, lpString AS ASCIIZ, lpFileName AS ASCIIZ) AS LONG
DECLARE FUNCTION WritePrivateProfileString LIB "KERNEL32.DLL" ALIAS "WritePrivateProfileStringA" (lpApplicationName AS ASCIIZ, lpKeyName AS ASCIIZ, lpString AS ASCIIZ, lpFileName AS ASCIIZ) AS LONG
DECLARE FUNCTION WriteProcessMemory LIB "KERNEL32.DLL" ALIAS "WriteProcessMemory" (BYVAL hProcess AS DWORD, lpBaseAddress AS ANY, lpBuffer AS ANY, BYVAL nSize AS DWORD, lpNumberOfBytesWritten AS LONG) AS LONG
DECLARE FUNCTION WriteProfileSection LIB "KERNEL32.DLL" ALIAS "WriteProfileSectionA" (lpAppName AS ASCIIZ, lpString AS ASCIIZ) AS LONG
DECLARE FUNCTION WriteProfileString LIB "KERNEL32.DLL" ALIAS "WriteProfileStringA" (lpszSection AS ASCIIZ, lpszKeyName AS ASCIIZ, lpszString AS ASCIIZ) AS LONG
DECLARE FUNCTION WriteTapemark LIB "KERNEL32.DLL" ALIAS "WriteTapemark" (BYVAL hDevice AS DWORD, BYVAL dwTapeMarkType AS DWORD, BYVAL dwTapeMarkCount AS DWORD, BYVAL bimmediate AS LONG) AS LONG
DECLARE FUNCTION hread LIB "KERNEL32.DLL" ALIAS "_hread" (BYVAL hFile AS DWORD, lpBuffer AS ANY, BYVAL lBytes AS LONG) AS LONG
DECLARE FUNCTION hwrite LIB "KERNEL32.DLL" ALIAS "_hwrite" (BYVAL hFile AS DWORD, lpBuffer AS ASCIIZ, BYVAL lBytes AS LONG) AS LONG
DECLARE FUNCTION lclose LIB "KERNEL32.DLL" ALIAS "_lclose" (BYVAL hFile AS DWORD) AS LONG
DECLARE FUNCTION lcreat LIB "KERNEL32.DLL" ALIAS "_lcreat" (lpPathName AS ASCIIZ, BYVAL iAttribute AS LONG) AS LONG
DECLARE FUNCTION llseek LIB "KERNEL32.DLL" ALIAS "_llseek" (BYVAL hFile AS DWORD, BYVAL lOffset AS LONG, BYVAL iOrigin AS LONG) AS LONG
DECLARE FUNCTION lopen LIB "KERNEL32.DLL" ALIAS "_lopen" (lpPathName AS ASCIIZ, BYVAL iReadWrite AS LONG) AS DWORD
DECLARE FUNCTION lread LIB "KERNEL32.DLL" ALIAS "_lread" (BYVAL hFile AS DWORD, lpBuffer AS ANY, BYVAL uBytes AS DWORD) AS DWORD
DECLARE FUNCTION lstrcat LIB "KERNEL32.DLL" ALIAS "lstrcatA" (lpString1 AS ASCIIZ, lpString2 AS ASCIIZ) AS LONG
DECLARE FUNCTION lstrcmp LIB "KERNEL32.DLL" ALIAS "lstrcmpA" (lpString1 AS ASCIIZ, lpString2 AS ASCIIZ) AS LONG
DECLARE FUNCTION lstrcmpi LIB "KERNEL32.DLL" ALIAS "lstrcmpiA" (lpString1 AS ASCIIZ, lpString2 AS ASCIIZ) AS LONG
DECLARE FUNCTION lstrcpy LIB "KERNEL32.DLL" ALIAS "lstrcpyA" (lpString1 AS ASCIIZ, lpString2 AS ASCIIZ) AS LONG
DECLARE FUNCTION lstrcpyn LIB "KERNEL32.DLL" ALIAS "lstrcpynA" (lpString1 AS ASCIIZ, lpString2 AS ASCIIZ, BYVAL iMaxLength AS LONG) AS LONG
DECLARE FUNCTION lstrlen LIB "KERNEL32.DLL" ALIAS "lstrlenA" (lpString AS ASCIIZ) AS LONG
DECLARE FUNCTION lstrlenw LIB "KERNEL32.DLL" ALIAS "lstrlenW" (lpString AS ANY) AS LONG
DECLARE FUNCTION lwrite LIB "KERNEL32.DLL" ALIAS "_lwrite" (BYVAL hFile AS DWORD, lpBuffer AS ASCIIZ, BYVAL uBytes AS DWORD) AS DWORD

'
'  ADVAPI32.DLL
'
DECLARE FUNCTION AbortSystemShutdown LIB "ADVAPI32.DLL" ALIAS "AbortSystemShutdownA" (lpMachineName AS ASCIIZ) AS LONG
DECLARE FUNCTION AccessCheck LIB "ADVAPI32.DLL" ALIAS "AccessCheck" (pSecurityDescriptor AS SECURITY_DESCRIPTOR, BYVAL ClientToken AS LONG, BYVAL DesiredAccess AS LONG, GenericMapping AS GENERIC_MAPPING, PrivilegeSet AS ANY, _
                 PrivilegeSetLength AS LONG, GrantedAccess AS LONG, BYVAL STATUS AS LONG) AS LONG
DECLARE FUNCTION AccessCheckAndAuditAlarm LIB "ADVAPI32.DLL" ALIAS "AccessCheckAndAuditAlarmA" (SubsystemName AS ASCIIZ, HandleId AS ANY, ObjectTypeName AS ASCIIZ, ObjectName AS ASCIIZ, SecurityDescriptor AS SECURITY_DESCRIPTOR, _
                 BYVAL DesiredAccess AS LONG, GenericMapping AS GENERIC_MAPPING, BYVAL ObjectCreation AS LONG, GrantedAccess AS LONG, BYVAL AccessStatus AS LONG, BYVAL pfGenerateOnClose AS LONG) AS LONG
#IF %DEF(%NOBYVALPTR)
    DECLARE FUNCTION AccessCheckByType LIB "ADVAPI32.DLL" ALIAS "AccessCheckByType" (pSecurityDescriptor AS SECURITY_DESCRIPTOR, PrincipalSelfSid AS ANY, BYVAL ClientToken AS DWORD, BYVAL DesiredAccess AS DWORD, _
                 ObjectTypeList AS OBJECT_TYPE_LIST PTR, BYVAL ObjectTypeListLength AS DWORD, GenericMapping AS GENERIC_MAPPING, PrivilegeSet AS ANY, PrivilegeSetLength AS DWORD, GrantedAccess AS DWORD, _
                 AccessStatus AS LONG) AS LONG
#ELSE
    DECLARE FUNCTION AccessCheckByType LIB "ADVAPI32.DLL" ALIAS "AccessCheckByType" (pSecurityDescriptor AS SECURITY_DESCRIPTOR, PrincipalSelfSid AS ANY, BYVAL ClientToken AS DWORD, BYVAL DesiredAccess AS DWORD, _
                 BYVAL ObjectTypeList AS OBJECT_TYPE_LIST PTR, BYVAL ObjectTypeListLength AS DWORD, GenericMapping AS GENERIC_MAPPING, PrivilegeSet AS ANY, PrivilegeSetLength AS DWORD, GrantedAccess AS DWORD, _
                 AccessStatus AS LONG) AS LONG
#ENDIF
DECLARE FUNCTION AccessCheckByTypeAndAuditAlarm LIB "ADVAPI32.DLL" ALIAS "AccessCheckByTypeAndAuditAlarmA" (SubsystemName AS ASCIIZ, HandleId AS DWORD, ObjectTypeName AS ASCIIZ, ObjectName AS ASCIIZ, _
                 SecurityDescriptor AS SECURITY_DESCRIPTOR, PrincipalSelfSid AS ANY, BYVAL DesiredAccess AS DWORD, BYVAL AuditType AS LONG, BYVAL Flags AS DWORD, ObjectTypeList AS OBJECT_TYPE_LIST, _
                 BYVAL ObjectTypeListLength AS DWORD, GenericMapping AS GENERIC_MAPPING, BYVAL ObjectCreation AS LONG, GrantedAccess AS DWORD, AccessStatus AS LONG, pfGenerateOnClose AS LONG) AS LONG
#IF %DEF(%NOBYVALPTR)
    DECLARE FUNCTION AccessCheckByTypeResultList LIB "ADVAPI32.DLL" ALIAS "AccessCheckByTypeResultList" (pSecurityDescriptor AS SECURITY_DESCRIPTOR, PrincipalSelfSid AS ANY, BYVAL ClientToken AS DWORD, BYVAL DesiredAccess AS DWORD, _
                 ObjectTypeList AS OBJECT_TYPE_LIST PTR, BYVAL ObjectTypeListLength AS DWORD, GenericMapping AS GENERIC_MAPPING, PrivilegeSet AS ANY, PrivilegeSetLength AS DWORD, GrantedAccess AS DWORD, _
                 AccessStatusList AS DWORD) AS LONG
#ELSE
    DECLARE FUNCTION AccessCheckByTypeResultList LIB "ADVAPI32.DLL" ALIAS "AccessCheckByTypeResultList" (pSecurityDescriptor AS SECURITY_DESCRIPTOR, PrincipalSelfSid AS ANY, BYVAL ClientToken AS DWORD, BYVAL DesiredAccess AS DWORD, _
                 BYVAL ObjectTypeList AS OBJECT_TYPE_LIST PTR, BYVAL ObjectTypeListLength AS DWORD, GenericMapping AS GENERIC_MAPPING, PrivilegeSet AS ANY, PrivilegeSetLength AS DWORD, GrantedAccess AS DWORD, _
                 AccessStatusList AS DWORD) AS LONG
#ENDIF
DECLARE FUNCTION AccessCheckByTypeResultListAndAuditAlarm LIB "ADVAPI32.DLL" ALIAS "AccessCheckByTypeResultListAndAuditAlarmA" (SubsystemName AS ASCIIZ, HandleId AS DWORD, ObjectTypeName AS ASCIIZ, ObjectName AS ASCIIZ, _
                 SecurityDescriptor AS SECURITY_DESCRIPTOR, PrincipalSelfSid AS ANY, BYVAL DesiredAccess AS DWORD, BYVAL AuditType AS LONG, BYVAL Flags AS DWORD, ObjectTypeList AS OBJECT_TYPE_LIST, GenericMapping AS GENERIC_MAPPING, _
                 BYVAL ObjectCreation AS LONG, GrantedAccess AS DWORD, AccessStatusList AS DWORD, pfGenerateOnClose AS LONG) AS LONG
DECLARE FUNCTION AddAccessAllowedAce LIB "ADVAPI32.DLL" ALIAS "AddAccessAllowedAce" (pAcl AS ACL, BYVAL dwAceRevision AS DWORD, BYVAL AccessMask AS LONG, dwFlags AS DWORD) AS LONG
DECLARE FUNCTION AddAccessAllowedAceEx LIB "ADVAPI32.DLL" ALIAS "AddAccessAllowedAceEx" (pAcl AS ACL, BYVAL dwAceRevision AS DWORD, BYVAL AceFlags AS DWORD, BYVAL AccessMask AS DWORD, pSid AS ANY) AS LONG
DECLARE FUNCTION AddAccessDeniedAce LIB "ADVAPI32.DLL" ALIAS "AddAccessDeniedAce" (pAcl AS ACL, BYVAL dwAceRevision AS DWORD, BYVAL AccessMask AS LONG, dwFlags AS DWORD) AS LONG
DECLARE FUNCTION AccessDeniedAceEx LIB "ADVAPI32.DLL" ALIAS "AccessDeniedAceEx" (pAcl AS ACL, BYVAL dwAceRevision AS DWORD, BYVAL AceFlags AS DWORD, BYVAL AccessMask AS DWORD, pSid AS ANY) AS LONG
DECLARE FUNCTION AddAce LIB "ADVAPI32.DLL" ALIAS "AddAce" (pAcl AS ACL, BYVAL dwAceRevision AS DWORD, BYVAL dwStartingAceIndex AS DWORD, pAceList AS ANY, BYVAL nAceListLength AS LONG) AS LONG
DECLARE FUNCTION AddAuditAccessAce LIB "ADVAPI32.DLL" ALIAS "AddAuditAccessAce" (pAcl AS ACL, BYVAL dwAceRevision AS DWORD, BYVAL dwAccessMask AS DWORD, pSid AS ANY, BYVAL bAuditSuccess AS LONG, BYVAL bAuditFailure AS LONG) AS LONG
DECLARE FUNCTION AddAuditAccessAceEx LIB "ADVAPI32.DLL" ALIAS "AddAuditAccessAceEx" (pAcl AS ACL, BYVAL dwAceRevision AS DWORD, BYVAL AceFlags AS DWORD, BYVAL dwAccessMask AS DWORD, pSid AS ANY, BYVAL bAuditSuccess AS LONG, _
                 BYVAL bAuditFailure AS LONG) AS LONG
DECLARE FUNCTION AdjustTokenGroups LIB "ADVAPI32.DLL" ALIAS "AdjustTokenGroups" (BYVAL TokenHandle AS DWORD, BYVAL ResetToDefault AS LONG, NewState AS ANY, BYVAL BufferLength AS DWORD, PreviousState AS ANY, _
                 ReturnLength AS DWORD) AS LONG
DECLARE FUNCTION AdjustTokenPrivileges LIB "ADVAPI32.DLL" ALIAS "AdjustTokenPrivileges" (BYVAL TokenHandle AS DWORD, BYVAL DisableAllPrivileges AS LONG, NewState AS ANY, BYVAL BufferLength AS DWORD, PreviousState AS ANY, _
                 ReturnLength AS DWORD) AS LONG
DECLARE FUNCTION AllocateAndInitializeSid LIB "ADVAPI32.DLL" ALIAS "AllocateAndInitializeSid" (pIdentifierAuthority AS SID_IDENTIFIER_AUTHORITY, BYVAL nSubAuthorityCount AS BYTE, BYVAL nSubAuthority0 AS LONG, BYVAL nSubAuthority1 AS LONG, _
                 BYVAL nSubAuthority2 AS LONG, BYVAL nSubAuthority3 AS LONG, BYVAL nSubAuthority4 AS LONG, BYVAL nSubAuthority5 AS LONG, BYVAL nSubAuthority6 AS LONG, BYVAL nSubAuthority7 AS LONG, lpPSid AS LONG) AS LONG
DECLARE FUNCTION AllocateLocallyUniqueId LIB "ADVAPI32.DLL" ALIAS "AllocateLocallyUniqueId" (xLuid AS LUID) AS LONG
DECLARE FUNCTION AreAllAccessesGranted LIB "ADVAPI32.DLL" ALIAS "AreAllAccessesGranted" (BYVAL GrantedAccess AS LONG, BYVAL DesiredAccess AS LONG) AS LONG
DECLARE FUNCTION AreAnyAccessesGranted LIB "ADVAPI32.DLL" ALIAS "AreAnyAccessesGranted" (BYVAL GrantedAccess AS LONG, BYVAL DesiredAccess AS LONG) AS LONG
DECLARE FUNCTION BackupEventLog LIB "ADVAPI32.DLL" ALIAS "BackupEventLogA" (BYVAL hEventLog AS DWORD, lpBackupFileName AS ASCIIZ) AS LONG
DECLARE FUNCTION ChangeServiceConfig LIB "ADVAPI32.DLL" ALIAS "ChangeServiceConfigA" (BYVAL hService AS DWORD, BYVAL dwServiceType AS DWORD, BYVAL dwStartType AS DWORD, BYVAL dwErrorControl AS DWORD, lpBinaryPathName AS ASCIIZ, _
                 lpLoadOrderGroup AS ASCIIZ, lpdwTagId AS DWORD, lpDependencies AS ASCIIZ, lpServiceStartName AS ASCIIZ, lpPassword AS ASCIIZ, lpDisplayName AS ASCIIZ) AS LONG
DECLARE FUNCTION ClearEventLog LIB "ADVAPI32.DLL" ALIAS "ClearEventLogA" (BYVAL hEventLog AS DWORD, lpBackupFileName AS ASCIIZ) AS LONG
DECLARE FUNCTION CloseEventLog LIB "ADVAPI32.DLL" ALIAS "CloseEventLog" (BYVAL hEventLog AS DWORD) AS LONG
DECLARE FUNCTION CloseServiceHandle LIB "ADVAPI32.DLL" ALIAS "CloseServiceHandle" (BYVAL hSCObject AS DWORD) AS LONG
DECLARE FUNCTION ControlService LIB "ADVAPI32.DLL" ALIAS "ControlService" (BYVAL hService AS DWORD, BYVAL dwControl AS DWORD, lpServiceStatus AS SERVICE_STATUS) AS LONG
DECLARE FUNCTION CopySid LIB "ADVAPI32.DLL" ALIAS "CopySid" (BYVAL nDestinationSidLength AS LONG, pDestinationSid AS ANY, pSourceSid AS ANY) AS LONG
DECLARE FUNCTION CreatePrivateObjectSecurity LIB "ADVAPI32.DLL" ALIAS "CreatePrivateObjectSecurity" (ParentDescriptor AS SECURITY_DESCRIPTOR, CreatorDescriptor AS SECURITY_DESCRIPTOR, NewDescriptor AS SECURITY_DESCRIPTOR, _
                 BYVAL IsDirectoryObject AS LONG, BYVAL Token AS LONG, GenericMapping AS GENERIC_MAPPING) AS LONG
DECLARE FUNCTION CreateService LIB "ADVAPI32.DLL" ALIAS "CreateServiceA" (BYVAL hSCManager AS DWORD, lpServiceName AS ASCIIZ, lpDisplayName AS ASCIIZ, BYVAL dwDesiredAccess AS DWORD, BYVAL dwServiceType AS DWORD, _
                 BYVAL dwStartType AS DWORD, BYVAL dwErrorControl AS DWORD, lpBinaryPathName AS ASCIIZ, lpLoadOrderGroup AS ASCIIZ, lpdwTagId AS DWORD, lpDependencies AS ASCIIZ, lp AS ASCIIZ, lpPassword AS ASCIIZ) AS LONG
DECLARE FUNCTION DeleteAce LIB "ADVAPI32.DLL" ALIAS "DeleteAce" (pAcl AS ACL, BYVAL dwAceIndex AS DWORD) AS LONG
DECLARE FUNCTION DeleteService LIB "ADVAPI32.DLL" ALIAS "DeleteService" (BYVAL hService AS DWORD) AS LONG
DECLARE FUNCTION DeregisterEventSource LIB "ADVAPI32.DLL" ALIAS "DeregisterEventSource" (BYVAL hEventLog AS DWORD) AS LONG
DECLARE FUNCTION DestroyPrivateObjectSecurity LIB "ADVAPI32.DLL" ALIAS "DestroyPrivateObjectSecurity" (ObjectDescriptor AS SECURITY_DESCRIPTOR) AS LONG
DECLARE FUNCTION DuplicateToken LIB "ADVAPI32.DLL" ALIAS "DuplicateToken" (BYVAL ExistingTokenHandle AS DWORD, ImpersonationLevel AS LONG, DuplicateTokenHandle AS DWORD) AS LONG
DECLARE FUNCTION EnumDependentServices LIB "ADVAPI32.DLL" ALIAS "EnumDependentServicesA" (BYVAL hService AS DWORD, BYVAL dwServiceState AS DWORD, lpServices AS ENUM_SERVICE_STATUS, BYVAL cbBufSize AS DWORD, pcbBytesNeeded AS DWORD, _
                 lpServicesReturned AS DWORD) AS LONG
DECLARE FUNCTION EnumServicesStatus LIB "ADVAPI32.DLL" ALIAS "EnumServicesStatusA" (BYVAL hSCManager AS DWORD, BYVAL dwServiceType AS DWORD, BYVAL dwServiceState AS DWORD, lpServices AS ENUM_SERVICE_STATUS, BYVAL cbBufSize AS DWORD, _
                 pcbBytesNeeded AS DWORD, lpServicesReturned AS DWORD, lpResumeHandle AS DWORD) AS LONG
DECLARE FUNCTION EqualPrefixSid LIB "ADVAPI32.DLL" ALIAS "EqualPrefixSid" (pSid1 AS ANY, pSid2 AS ANY) AS LONG
DECLARE FUNCTION EqualSid LIB "ADVAPI32.DLL" ALIAS "EqualSid" (pSid1 AS ANY, pSid2 AS ANY) AS LONG
DECLARE FUNCTION FindFirstFreeAce LIB "ADVAPI32.DLL" ALIAS "FindFirstFreeAce" (pAcl AS ACL, pAce AS LONG) AS LONG
DECLARE FUNCTION GetAce LIB "ADVAPI32.DLL" ALIAS "GetAce" (pAcl AS ACL, BYVAL dwAceIndex AS DWORD, pAce AS ANY) AS LONG
DECLARE FUNCTION GetAclInformation LIB "ADVAPI32.DLL" ALIAS "GetAclInformation" (pAcl AS ACL, pAclInformation AS ANY, BYVAL nAclInformationLength AS LONG, BYVAL dwAclInformationClass AS DWORD) AS LONG
DECLARE FUNCTION GetCurrentHwProfile LIB "ADVAPI32.DLL" ALIAS "GetCurrentHwProfileA" (lpHwProfileInfo AS HW_PROFILE_INFO) AS LONG
DECLARE FUNCTION GetFileSecurity LIB "ADVAPI32.DLL" ALIAS "GetFileSecurityA" (lpFileName AS ASCIIZ, BYVAL RequestedInformation AS LONG, pSecurityDescriptor AS SECURITY_DESCRIPTOR, BYVAL nLength AS LONG, lpnLengthNeeded AS LONG) AS LONG
DECLARE FUNCTION GetKernelObjectSecurity LIB "ADVAPI32.DLL" ALIAS "GetKernelObjectSecurity" (BYVAL xHandle AS DWORD, BYVAL RequestedInformation AS DWORD, pSecurityDescriptor AS SECURITY_DESCRIPTOR, BYVAL nLength AS DWORD, _
                 lpnLengthNeeded AS DWORD) AS LONG
DECLARE FUNCTION GetLengthSid LIB "ADVAPI32.DLL" ALIAS "GetLengthSid" (dwFlags AS DWORD) AS LONG
DECLARE FUNCTION GetNumberOfEventLogRecords LIB "ADVAPI32.DLL" ALIAS "GetNumberOfEventLogRecords" (BYVAL hEventLog AS DWORD, NumberOfRecords AS LONG) AS LONG
DECLARE FUNCTION GetOldestEventLogRecord LIB "ADVAPI32.DLL" ALIAS "GetOldestEventLogRecord" (BYVAL hEventLog AS DWORD, OldestRecord AS LONG) AS LONG
DECLARE FUNCTION GetPrivateObjectSecurity LIB "ADVAPI32.DLL" ALIAS "GetPrivateObjectSecurity" (ObjectDescriptor AS SECURITY_DESCRIPTOR, BYVAL SecurityInformation AS LONG, ResultantDescriptor AS SECURITY_DESCRIPTOR, BYVAL DescriptorLength AS LONG, _
                 ReturnLength AS LONG) AS LONG
DECLARE FUNCTION GetSecurityDescriptorControl LIB "ADVAPI32.DLL" ALIAS "GetSecurityDescriptorControl" (pSecurityDescriptor AS SECURITY_DESCRIPTOR, pControl AS LONG, lpdwRevision AS DWORD) AS LONG
DECLARE FUNCTION GetSecurityDescriptorDacl LIB "ADVAPI32.DLL" ALIAS "GetSecurityDescriptorDacl" (pSecurityDescriptor AS SECURITY_DESCRIPTOR, lpbDaclPresent AS LONG, pDacl AS ACL, lpbDaclDefaulted AS LONG) AS LONG
DECLARE FUNCTION GetSecurityDescriptorGroup LIB "ADVAPI32.DLL" ALIAS "GetSecurityDescriptorGroup" (pSecurityDescriptor AS SECURITY_DESCRIPTOR, pGroup AS ANY, BYVAL lpbGroupDefaulted AS LONG) AS LONG
DECLARE FUNCTION GetSecurityDescriptorLength LIB "ADVAPI32.DLL" ALIAS "GetSecurityDescriptorLength" (pSecurityDescriptor AS SECURITY_DESCRIPTOR) AS LONG
DECLARE FUNCTION GetSecurityDescriptorOwner LIB "ADVAPI32.DLL" ALIAS "GetSecurityDescriptorOwner" (pSecurityDescriptor AS SECURITY_DESCRIPTOR, pOwner AS ANY, BYVAL lpbOwnerDefaulted AS LONG) AS LONG
DECLARE FUNCTION GetSecurityDescriptorSacl LIB "ADVAPI32.DLL" ALIAS "GetSecurityDescriptorSacl" (pSecurityDescriptor AS SECURITY_DESCRIPTOR, BYVAL lpbSaclPresent AS LONG, pSacl AS ACL, BYVAL lpbSaclDefaulted AS LONG) AS LONG
DECLARE FUNCTION GetSecurityInfo LIB "ADVAPI32.DLL" ALIAS "GetSecurityInfo" (BYVAL hHandle AS DWORD, BYVAL ObjectType AS DWORD, BYVAL SecurityInformation AS DWORD, pSidOwner AS ANY, _
                 pSidGroup AS ANY, pDacl AS DWORD, pSacl AS DWORD, pSecurityDescriptor AS SECURITY_DESCRIPTOR) AS DWORD
DECLARE FUNCTION GetServiceDisplayName LIB "ADVAPI32.DLL" ALIAS "GetServiceDisplayNameA" (BYVAL hSCManager AS DWORD, lpServiceName AS ASCIIZ, lpDisplayName AS ASCIIZ, lpcchBuffer AS LONG) AS LONG
DECLARE FUNCTION GetServiceKeyName LIB "ADVAPI32.DLL" ALIAS "GetServiceKeyNameA" (BYVAL hSCManager AS DWORD, lpDisplayName AS ASCIIZ, lpServiceName AS ASCIIZ, lpcchBuffer AS LONG) AS LONG
DECLARE FUNCTION GetSidIdentifierAuthority LIB "ADVAPI32.DLL" ALIAS "GetSidIdentifierAuthority" (dwFlags AS DWORD) AS DWORD
DECLARE FUNCTION GetSidLengthRequired LIB "ADVAPI32.DLL" ALIAS "GetSidLengthRequired" (BYVAL nSubAuthorityCount AS BYTE) AS LONG
DECLARE FUNCTION GetSidSubAuthority LIB "ADVAPI32.DLL" ALIAS "GetSidSubAuthority" (dwFlags AS DWORD, BYVAL nSubAuthority AS LONG) AS LONG
DECLARE FUNCTION GetSidSubAuthorityCount LIB "ADVAPI32.DLL" ALIAS "GetSidSubAuthorityCount" (dwFlags AS DWORD) AS BYTE
DECLARE FUNCTION GetTokenInformation LIB "ADVAPI32.DLL" ALIAS "GetTokenInformation" (BYVAL TokenHandle AS DWORD, BYVAL TokenInformationClass AS LONG, TokenInformation AS ANY, BYVAL TokenInformationLength AS DWORD, ReturnLength AS DWORD) AS LONG
DECLARE FUNCTION GetUserName LIB "ADVAPI32.DLL" ALIAS "GetUserNameA" (lpBuffer AS ASCIIZ, nSize AS DWORD) AS LONG
DECLARE FUNCTION ImpersonateNamedPipeClient LIB "ADVAPI32.DLL" ALIAS "ImpersonateNamedPipeClient" (BYVAL hNamedPipe AS DWORD) AS LONG
DECLARE FUNCTION ImpersonateSelf LIB "ADVAPI32.DLL" ALIAS "ImpersonateSelf" (ImpersonationLevel AS LONG) AS LONG
DECLARE FUNCTION InitializeAcl LIB "ADVAPI32.DLL" ALIAS "InitializeAcl" (pAcl AS ACL, BYVAL nAclLength AS DWORD, BYVAL dwAclRevision AS DWORD) AS LONG
DECLARE FUNCTION InitializeSecurityDescriptor LIB "ADVAPI32.DLL" ALIAS "InitializeSecurityDescriptor" (pSecurityDescriptor AS SECURITY_DESCRIPTOR, BYVAL dwRevision AS DWORD) AS LONG
DECLARE FUNCTION InitializeSid LIB "ADVAPI32.DLL" ALIAS "InitializeSid" (pSid AS ANY, pIdentifierAuthority AS SID_IDENTIFIER_AUTHORITY, BYVAL nSubAuthorityCount AS BYTE) AS LONG
DECLARE FUNCTION InitiateSystemShutdown LIB "ADVAPI32.DLL" ALIAS "InitiateSystemShutdownA" (lpMachineName AS ASCIIZ, lpMessage AS ASCIIZ, BYVAL dwTimeout AS DWORD, BYVAL bForceAppsClosed AS LONG, BYVAL bRebootAfterShutdown AS LONG) AS LONG
DECLARE FUNCTION IsTextUnicode LIB "ADVAPI32.DLL" ALIAS "IsTextUnicode" (lpBuffer AS ANY, BYVAL cb AS LONG, lpi AS LONG) AS LONG
DECLARE FUNCTION IsValidAcl LIB "ADVAPI32.DLL" ALIAS "IsValidAcl" (pAcl AS ACL) AS LONG
DECLARE FUNCTION IsValidSecurityDescriptor LIB "ADVAPI32.DLL" ALIAS "IsValidSecurityDescriptor" (pSecurityDescriptor AS SECURITY_DESCRIPTOR) AS LONG
DECLARE FUNCTION IsValidSid LIB "ADVAPI32.DLL" ALIAS "IsValidSid" (dwFlags AS DWORD) AS LONG
DECLARE FUNCTION LockServiceDatabase LIB "ADVAPI32.DLL" ALIAS "LockServiceDatabase" (BYVAL hSCManager AS DWORD) AS LONG
DECLARE FUNCTION LookupAccountName LIB "ADVAPI32.DLL" ALIAS "LookupAccountNameA" (lpSystemName AS ASCIIZ, lpAccountName AS ASCIIZ, pSid AS ANY, cbSid AS LONG, ReferencedDomainName AS ASCIIZ, cbReferencedDomainName AS LONG, peUse AS LONG) AS LONG
DECLARE FUNCTION LookupAccountSid LIB "ADVAPI32.DLL" ALIAS "LookupAccountSidA" (lpSystemName AS ASCIIZ, pSid AS ANY, xName AS ASCIIZ, cbName AS LONG, ReferencedDomainName AS ASCIIZ, cbReferencedDomainName AS LONG, peUse AS LONG) AS LONG
DECLARE FUNCTION LookupPrivilegeDisplayName LIB "ADVAPI32.DLL" ALIAS "LookupPrivilegeDisplayNameA" (lpSystemName AS ASCIIZ, lpName AS ASCIIZ, lpDisplayName AS ASCIIZ, cbDisplayName AS LONG, lpLanguageID AS LONG) AS LONG
DECLARE FUNCTION LookupPrivilegeName LIB "ADVAPI32.DLL" ALIAS "LookupPrivilegeNameA" (lpSystemName AS ASCIIZ, lpLuid AS LUID, lpName AS ASCIIZ, cbName AS LONG) AS LONG
DECLARE FUNCTION LookupPrivilegeValue LIB "ADVAPI32.DLL" ALIAS "LookupPrivilegeValueA" (lpSystemName AS ASCIIZ, lpName AS ASCIIZ, lpLuid AS LUID) AS LONG
DECLARE FUNCTION MakeAbsoluteSD LIB "ADVAPI32.DLL" ALIAS "MakeAbsoluteSD" (pSelfRelativeSecurityDescriptor AS SECURITY_DESCRIPTOR, pAbsoluteSecurityDescriptor AS SECURITY_DESCRIPTOR, lpdwAbsoluteSecurityDescriptorSize AS DWORD, pDacl AS ACL, _
                 lpdwDaclSize AS DWORD, pSacl AS ACL, lpdwSaclSize AS DWORD, pOwner AS ANY, lpdwOwnerSize AS DWORD, pPrimaryGroup AS ANY, lpdwPrimaryGroupSize AS DWORD) AS LONG
DECLARE FUNCTION MakeSelfRelativeSD LIB "ADVAPI32.DLL" ALIAS "MakeSelfRelativeSD" (pAbsoluteSecurityDescriptor AS SECURITY_DESCRIPTOR, pSelfRelativeSecurityDescriptor AS SECURITY_DESCRIPTOR, lpdwBufferLength AS DWORD) AS LONG
DECLARE FUNCTION NotifyBootConfigStatus LIB "ADVAPI32.DLL" ALIAS "NotifyBootConfigStatus" (BYVAL BootAcceptable AS LONG) AS LONG
DECLARE FUNCTION NotifyChangeEventLog LIB "ADVAPI32.DLL" ALIAS "NotifyChangeEventLog" (BYVAL hEventLog AS DWORD, BYVAL hEvent AS DWORD) AS LONG
DECLARE FUNCTION ObjectCloseAuditAlarm LIB "ADVAPI32.DLL" ALIAS "ObjectCloseAuditAlarmA" (SubsystemName AS ASCIIZ, HandleId AS ANY, BYVAL GenerateOnClose AS LONG) AS LONG
DECLARE FUNCTION ObjectPrivilegeAuditAlarm LIB "ADVAPI32.DLL" ALIAS "ObjectPrivilegeAuditAlarmA" (SubsystemName AS ASCIIZ, HandleId AS ANY, BYVAL ClientToken AS LONG, BYVAL DesiredAccess AS LONG, Privileges AS ANY, _
                 BYVAL AccessGranted AS LONG) AS LONG
DECLARE FUNCTION OpenBackupEventLog LIB "ADVAPI32.DLL" ALIAS "OpenBackupEventLogA" (lpUNCServerName AS ASCIIZ, lpFileName AS ASCIIZ) AS LONG
DECLARE FUNCTION OpenEventLog LIB "ADVAPI32.DLL" ALIAS "OpenEventLogA" (lpUNCServerName AS ASCIIZ, lpSourceName AS ASCIIZ) AS LONG
DECLARE FUNCTION OpenProcessToken LIB "ADVAPI32.DLL" ALIAS "OpenProcessToken" (BYVAL ProcessHandle AS DWORD, BYVAL DesiredAccess AS DWORD, TokenHandle AS DWORD) AS LONG
DECLARE FUNCTION OpenSCManager LIB "ADVAPI32.DLL" ALIAS "OpenSCManagerA" (lpMachineName AS ASCIIZ, lpDatabaseName AS ASCIIZ, BYVAL dwDesiredAccess AS DWORD) AS LONG
DECLARE FUNCTION OpenService LIB "ADVAPI32.DLL" ALIAS "OpenServiceA" (BYVAL hSCManager AS DWORD, lpServiceName AS ASCIIZ, BYVAL dwDesiredAccess AS DWORD) AS LONG
DECLARE FUNCTION OpenThreadToken LIB "ADVAPI32.DLL" ALIAS "OpenThreadToken" (BYVAL ThreadHandle AS DWORD, BYVAL DesiredAccess AS DWORD, BYVAL OpenAsSelf AS LONG, TokenHandle AS DWORD) AS LONG
DECLARE FUNCTION PrivilegeCheck LIB "ADVAPI32.DLL" ALIAS "PrivilegeCheck" (BYVAL ClientToken AS LONG, RequiredPrivileges AS ANY, BYVAL pfResult AS LONG) AS LONG
DECLARE FUNCTION PrivilegedServiceAuditAlarm LIB "ADVAPI32.DLL" ALIAS "PrivilegedServiceAuditAlarmA" (SubsystemName AS ASCIIZ, ServiceName AS ASCIIZ, BYVAL ClientToken AS DWORD, Privileges AS ANY, BYVAL AccessGranted AS LONG) AS LONG
DECLARE FUNCTION QueryServiceConfig LIB "ADVAPI32.DLL" ALIAS "QueryServiceConfigA" (BYVAL hService AS DWORD, lpServiceConfig AS QUERY_SERVICE_CONFIG, BYVAL cbBufSize AS DWORD, pcbBytesNeeded AS DWORD) AS LONG
DECLARE FUNCTION QueryServiceLockStatus LIB "ADVAPI32.DLL" ALIAS "QueryServiceLockStatusA" (BYVAL hSCManager AS DWORD, lpLockStatus AS QUERY_SERVICE_LOCK_STATUS, BYVAL cbBufSize AS DWORD, pcbBytesNeeded AS DWORD) AS LONG
DECLARE FUNCTION QueryServiceObjectSecurity LIB "ADVAPI32.DLL" ALIAS "QueryServiceObjectSecurity" (BYVAL hService AS DWORD, BYVAL dwSecurityInformation AS DWORD, lpSecurityDescriptor AS SECURITY_DESCRIPTOR, BYVAL cbBufSize AS DWORD, _
                 pcbBytesNeeded AS DWORD) AS LONG
DECLARE FUNCTION QueryServiceStatus LIB "ADVAPI32.DLL" ALIAS "QueryServiceStatus" (BYVAL hService AS DWORD, lpServiceStatus AS SERVICE_STATUS) AS LONG
DECLARE FUNCTION ReadEventLog LIB "ADVAPI32.DLL" ALIAS "ReadEventLogA" (BYVAL hEventLog AS DWORD, BYVAL dwReadFlags AS DWORD, BYVAL dwRecordOffset AS DWORD, lpBuffer AS EVENTLOGRECORD, BYVAL nNumberOfBytesToRead AS LONG, pnBytesRead AS LONG, _
                 pnMinNumberOfBytesNeeded AS LONG) AS LONG
DECLARE FUNCTION RegCloseKey LIB "ADVAPI32.DLL" ALIAS "RegCloseKey" (BYVAL hKey AS DWORD) AS LONG
DECLARE FUNCTION RegConnectRegistry LIB "ADVAPI32.DLL" ALIAS "RegConnectRegistryA" (lpMachineName AS ASCIIZ, BYVAL hKey AS DWORD, phkResult AS DWORD) AS LONG
DECLARE FUNCTION RegCreateKey LIB "ADVAPI32.DLL" ALIAS "RegCreateKeyA" (BYVAL hKey AS DWORD, lpSubKey AS ASCIIZ, phkResult AS DWORD) AS LONG
DECLARE FUNCTION RegCreateKeyEx LIB "ADVAPI32.DLL" ALIAS "RegCreateKeyExA" (BYVAL hKey AS DWORD, lpSubKey AS ASCIIZ, BYVAL Reserved AS LONG, lpClass AS ASCIIZ, BYVAL dwOptions AS DWORD, BYVAL samDesired AS LONG, _
                 lpSecurityAttributes AS SECURITY_ATTRIBUTES, phkResult AS DWORD, lpdwDisposition AS DWORD) AS LONG
DECLARE FUNCTION RegDeleteKey LIB "ADVAPI32.DLL" ALIAS "RegDeleteKeyA" (BYVAL hKey AS DWORD, lpSubKey AS ASCIIZ) AS LONG
DECLARE FUNCTION RegDeleteValue LIB "ADVAPI32.DLL" ALIAS "RegDeleteValueA" (BYVAL hKey AS DWORD, lpValueName AS ASCIIZ) AS LONG
DECLARE FUNCTION RegEnumKey LIB "ADVAPI32.DLL" ALIAS "RegEnumKeyA" (BYVAL hKey AS DWORD, BYVAL dwIndex AS DWORD, lpName AS ASCIIZ, BYVAL cbName AS DWORD) AS LONG
DECLARE FUNCTION RegEnumKeyEx LIB "ADVAPI32.DLL" ALIAS "RegEnumKeyExA" (BYVAL hKey AS DWORD, BYVAL dwIndex AS DWORD, lpName AS ASCIIZ, lpcbName AS LONG, BYVAL lpReserved AS LONG, lpClass AS ASCIIZ, lpcbClass AS LONG, _
                 lpftLastWriteTime AS FILETIME) AS LONG
DECLARE FUNCTION RegEnumValue LIB "ADVAPI32.DLL" ALIAS "RegEnumValueA" (BYVAL hKey AS DWORD, BYVAL dwIndex AS DWORD, lpValueName AS ASCIIZ, lpcbValueName AS DWORD, lpReserved AS DWORD, lpType AS DWORD, lpData AS ANY, lpcbData AS DWORD) AS LONG
DECLARE FUNCTION RegFlushKey LIB "ADVAPI32.DLL" ALIAS "RegFlushKey" (BYVAL hKey AS DWORD) AS LONG
DECLARE FUNCTION RegGetKeySecurity LIB "ADVAPI32.DLL" ALIAS "RegGetKeySecurity" (BYVAL hKey AS DWORD, BYVAL SecurityInformation AS LONG, pSecurityDescriptor AS SECURITY_DESCRIPTOR, lpcbSecurityDescriptor AS LONG) AS LONG
DECLARE FUNCTION RegLoadKey LIB "ADVAPI32.DLL" ALIAS "RegLoadKeyA" (BYVAL hKey AS DWORD, lpSubKey AS ASCIIZ, lpFile AS ASCIIZ) AS LONG
DECLARE FUNCTION RegNotifyChangeKeyValue LIB "ADVAPI32.DLL" ALIAS "RegNotifyChangeKeyValue" (BYVAL hKey AS DWORD, BYVAL bWatchSubtree AS LONG, BYVAL dwNotifyFilter AS DWORD, BYVAL hEvent AS DWORD, BYVAL fAsynchronus AS LONG) AS LONG
DECLARE FUNCTION RegOpenKey LIB "ADVAPI32.DLL" ALIAS "RegOpenKeyA" (BYVAL hKey AS DWORD, lpSubKey AS ASCIIZ, phkResult AS DWORD) AS LONG
DECLARE FUNCTION RegOpenKeyEx LIB "ADVAPI32.DLL" ALIAS "RegOpenKeyExA" (BYVAL hKey AS DWORD, lpSubKey AS ASCIIZ, BYVAL ulOptions AS DWORD, BYVAL samDesired AS LONG, phkResult AS DWORD) AS LONG
DECLARE FUNCTION RegQueryInfoKey LIB "ADVAPI32.DLL" ALIAS "RegQueryInfoKeyA" (BYVAL hKey AS DWORD, lpClass AS ASCIIZ, lpcbClass AS LONG, lpReserved AS LONG, lpcSubKeys AS LONG, lpcbMaxSubKeyLen AS LONG, lpcbMaxClassLen AS LONG, lpcValues AS LONG, _
                 lpcbMaxValueNameLen AS LONG, lpcbMaxValueLen AS LONG, lpcbSecurityDescriptor AS LONG, lpftLastWriteTime AS FILETIME) AS LONG
DECLARE FUNCTION RegQueryValue LIB "ADVAPI32.DLL" ALIAS "RegQueryValueA" (BYVAL hKey AS DWORD, lpSubKey AS ASCIIZ, lpValue AS ASCIIZ, lpcbValue AS LONG) AS LONG
DECLARE FUNCTION RegQueryValueEx LIB "ADVAPI32.DLL" ALIAS "RegQueryValueExA" (BYVAL hKey AS DWORD, lpValueName AS ASCIIZ, BYVAL lpReserved AS LONG, lpType AS LONG, lpData AS ANY, lpcbData AS LONG) AS LONG
DECLARE FUNCTION RegReplaceKey LIB "ADVAPI32.DLL" ALIAS "RegReplaceKeyA" (BYVAL hKey AS DWORD, lpSubKey AS ASCIIZ, lpNewFile AS ASCIIZ, lpOldFile AS ASCIIZ) AS LONG
DECLARE FUNCTION RegRestoreKey LIB "ADVAPI32.DLL" ALIAS "RegRestoreKeyA" (BYVAL hKey AS DWORD, lpFile AS ASCIIZ, BYVAL dwFlags AS DWORD) AS LONG
DECLARE FUNCTION RegSaveKey LIB "ADVAPI32.DLL" ALIAS "RegSaveKeyA" (BYVAL hKey AS DWORD, lpFile AS ASCIIZ, lpSecurityAttributes AS SECURITY_ATTRIBUTES) AS LONG
DECLARE FUNCTION RegSetKeySecurity LIB "ADVAPI32.DLL" ALIAS "RegSetKeySecurity" (BYVAL hKey AS DWORD, BYVAL SecurityInformation AS LONG, pSecurityDescriptor AS SECURITY_DESCRIPTOR) AS LONG
DECLARE FUNCTION RegSetValue LIB "ADVAPI32.DLL" ALIAS "RegSetValueA" (BYVAL hKey AS DWORD, lpSubKey AS ASCIIZ, BYVAL dwType AS DWORD, lpData AS ASCIIZ, BYVAL cbData AS DWORD) AS LONG
DECLARE FUNCTION RegSetValueEx LIB "ADVAPI32.DLL" ALIAS "RegSetValueExA" (BYVAL hKey AS DWORD, lpValueName AS ASCIIZ, BYVAL dwReserved AS DWORD, BYVAL dwType AS DWORD, lpData AS ANY, BYVAL cbData AS DWORD) AS LONG
DECLARE FUNCTION RegUnLoadKey LIB "ADVAPI32.DLL" ALIAS "RegUnLoadKeyA" (BYVAL hKey AS DWORD, lpSubKey AS ASCIIZ) AS LONG
DECLARE FUNCTION RegisterEventSource LIB "ADVAPI32.DLL" ALIAS "RegisterEventSourceA" (lpUNCServerName AS ASCIIZ, lpSourceName AS ASCIIZ) AS LONG
DECLARE FUNCTION RegisterServiceCtrlHandler LIB "ADVAPI32.DLL" ALIAS "RegisterServiceCtrlHandlerA" (lpServiceName AS ASCIIZ, BYVAL lpHandlerProc AS DWORD) AS DWORD
DECLARE FUNCTION RegisterServiceCtrlHandlerEx LIB "ADVAPI32.DLL" ALIAS "RegisterServiceCtrlHandlerExA" (lpServiceName AS ASCIIZ, BYVAL lpHandlerProc AS DWORD, lpContext AS ANY) AS DWORD
DECLARE FUNCTION ReportEvent LIB "ADVAPI32.DLL" ALIAS "ReportEventA" (BYVAL hEventLog AS DWORD, BYVAL wType AS WORD, BYVAL wCategory AS WORD, BYVAL dwEventId AS DWORD, lpUserSid AS ANY, BYVAL wNumStrings AS WORD, BYVAL dwDataSize AS DWORD, _
                 lpStrings AS ANY, lpRawData AS ANY) AS LONG
DECLARE FUNCTION RevertToSelf LIB "ADVAPI32.DLL" ALIAS "RevertToSelf" () AS LONG
DECLARE FUNCTION SetAclInformation LIB "ADVAPI32.DLL" ALIAS "SetAclInformation" (pAcl AS ACL, pAclInformation AS ANY, BYVAL nAclInformationLength AS LONG, BYVAL dwAclInformationClass AS DWORD) AS LONG
DECLARE FUNCTION SetFileSecurity LIB "ADVAPI32.DLL" ALIAS "SetFileSecurityA" (lpFileName AS ASCIIZ, BYVAL SecurityInformation AS LONG, pSecurityDescriptor AS SECURITY_DESCRIPTOR) AS LONG
DECLARE FUNCTION SetKernelObjectSecurity LIB "ADVAPI32.DLL" ALIAS "SetKernelObjectSecurity" (BYVAL xHandle AS DWORD, BYVAL SecurityInformation AS DWORD, SecurityDescriptor AS SECURITY_DESCRIPTOR) AS LONG
DECLARE FUNCTION SetPrivateObjectSecurity LIB "ADVAPI32.DLL" ALIAS "SetPrivateObjectSecurity" (BYVAL SecurityInformation AS LONG, ModificationDescriptor AS SECURITY_DESCRIPTOR, ObjectsSecurityDescriptor AS SECURITY_DESCRIPTOR, _
                 GenericMapping AS GENERIC_MAPPING, BYVAL Token AS LONG) AS LONG
DECLARE FUNCTION SetSecurityDescriptorDacl LIB "ADVAPI32.DLL" ALIAS "SetSecurityDescriptorDacl" (pSecurityDescriptor AS SECURITY_DESCRIPTOR, BYVAL bDaclPresent AS LONG, pDacl AS ACL, BYVAL bDaclDefaulted AS LONG) AS LONG
DECLARE FUNCTION SetSecurityDescriptorGroup LIB "ADVAPI32.DLL" ALIAS "SetSecurityDescriptorGroup" (pSecurityDescriptor AS SECURITY_DESCRIPTOR, pGroup AS ANY, BYVAL bGroupDefaulted AS LONG) AS LONG
DECLARE FUNCTION SetSecurityDescriptorOwner LIB "ADVAPI32.DLL" ALIAS "SetSecurityDescriptorOwner" (pSecurityDescriptor AS SECURITY_DESCRIPTOR, pOwner AS ANY, BYVAL bOwnerDefaulted AS LONG) AS LONG
DECLARE FUNCTION SetSecurityDescriptorSacl LIB "ADVAPI32.DLL" ALIAS "SetSecurityDescriptorSacl" (pSecurityDescriptor AS SECURITY_DESCRIPTOR, BYVAL bSaclPresent AS LONG, pSacl AS ACL, BYVAL bSaclDefaulted AS LONG) AS LONG
DECLARE FUNCTION SetServiceBits LIB "ADVAPI32.DLL" ALIAS "SetServiceBits" (BYVAL hServiceStatus AS DWORD, BYVAL dwServiceBits AS DWORD, BYVAL bSetBitsOn AS LONG, BYVAL bUpdateImmediately AS LONG) AS LONG
DECLARE FUNCTION SetServiceObjectSecurity LIB "ADVAPI32.DLL" ALIAS "SetServiceObjectSecurity" (BYVAL hService AS DWORD, BYVAL dwSecurityInformation AS DWORD, lpSecurityDescriptor AS ANY) AS LONG
DECLARE FUNCTION SetServiceStatus LIB "ADVAPI32.DLL" ALIAS "SetServiceStatus" (BYVAL hServiceStatus AS DWORD, lpServiceStatus AS SERVICE_STATUS) AS LONG
DECLARE FUNCTION SetThreadToken LIB "ADVAPI32.DLL" ALIAS "SetThreadToken" (hThread AS DWORD, BYVAL Token AS LONG) AS LONG
DECLARE FUNCTION SetTokenInformation LIB "ADVAPI32.DLL" ALIAS "SetTokenInformation" (BYVAL TokenHandle AS DWORD, TokenInformationClass AS LONG, TokenInformation AS ANY, BYVAL TokenInformationLength AS DWORD) AS LONG
DECLARE FUNCTION StartService LIB "ADVAPI32.DLL" ALIAS "StartServiceA" (BYVAL hService AS DWORD, BYVAL dwNumServiceArgs AS DWORD, BYVAL lpServiceArgVectors AS LONG) AS LONG
DECLARE FUNCTION StartServiceCtrlDispatcher LIB "ADVAPI32.DLL" ALIAS "StartServiceCtrlDispatcherA" (lpServiceStartTable AS SERVICE_TABLE_ENTRY) AS LONG
DECLARE FUNCTION UnlockServiceDatabase LIB "ADVAPI32.DLL" ALIAS "UnlockServiceDatabase" (ScLock AS ANY) AS LONG
DECLARE SUB FreeSid LIB "ADVAPI32.DLL" ALIAS "FreeSid" (dwFlags AS DWORD)
DECLARE SUB MapGenericMask LIB "ADVAPI32.DLL" ALIAS "MapGenericMask" (AccessMask AS LONG, GenericMapping AS GENERIC_MAPPING)

'
' Declares from wingdi.h ======================================================
'

#IF NOT %DEF(%NOGDI) '---------------------------------------------------------

DECLARE FUNCTION AddFontResource LIB "GDI32.DLL" ALIAS "AddFontResourceA" (lpFileName AS ASCIIZ) AS LONG
DECLARE FUNCTION AnimatePalette LIB "GDI32.DLL" ALIAS "AnimatePalette" (BYVAL hPalette AS DWORD, BYVAL wStartIndex AS DWORD, BYVAL wNumEntries AS DWORD, lpPaletteColors AS PALETTEENTRY) AS LONG
DECLARE FUNCTION Arc LIB "GDI32.DLL" ALIAS "Arc" (BYVAL hdc AS DWORD, BYVAL X1 AS LONG, BYVAL Y1 AS LONG, BYVAL X2 AS LONG, BYVAL Y2 AS LONG, BYVAL X3 AS LONG, BYVAL Y3 AS LONG, BYVAL X4 AS LONG, BYVAL Y4 AS LONG) AS LONG
DECLARE FUNCTION BitBlt LIB "GDI32.DLL" ALIAS "BitBlt" (BYVAL hDestDC AS DWORD, BYVAL x AS LONG, BYVAL y AS LONG, BYVAL nWidth AS LONG, BYVAL nHeight AS LONG, BYVAL hSrcDC AS DWORD, BYVAL xSrc AS LONG, BYVAL ySrc AS LONG, _
                 BYVAL dwRop AS DWORD) AS LONG
DECLARE FUNCTION CancelDC LIB "GDI32.DLL" ALIAS "CancelDC" (BYVAL hdc AS DWORD) AS LONG
DECLARE FUNCTION Chord LIB "GDI32.DLL" ALIAS "Chord" (BYVAL hdc AS DWORD, BYVAL X1 AS LONG, BYVAL Y1 AS LONG, BYVAL X2 AS LONG, BYVAL Y2 AS LONG, BYVAL X3 AS LONG, BYVAL Y3 AS LONG, BYVAL X4 AS LONG, BYVAL Y4 AS LONG) AS LONG
DECLARE FUNCTION ChoosePixelFormat LIB "GDI32.DLL" ALIAS "ChoosePixelFormat" (BYVAL hDC AS DWORD, pPixelFormatDescriptor AS PIXELFORMATDESCRIPTOR) AS LONG
DECLARE FUNCTION CloseMetaFile LIB "GDI32.DLL" ALIAS "CloseMetaFile" (BYVAL hMF AS DWORD) AS DWORD
DECLARE FUNCTION CombineRgn LIB "GDI32.DLL" ALIAS "CombineRgn" (BYVAL hDestRgn AS DWORD, BYVAL hSrcRgn1 AS DWORD, BYVAL hSrcRgn2 AS DWORD, BYVAL nCombineMode AS LONG) AS LONG
DECLARE FUNCTION CopyMetaFile LIB "GDI32.DLL" ALIAS "CopyMetaFileA" (BYVAL hMF AS DWORD, lpFileName AS ASCIIZ) AS DWORD
DECLARE FUNCTION CreateBitmap LIB "GDI32.DLL" ALIAS "CreateBitmap" (BYVAL nWidth AS LONG, BYVAL nHeight AS LONG, BYVAL nPlanes AS DWORD, BYVAL nBitCount AS DWORD, lpBits AS ANY) AS DWORD
DECLARE FUNCTION CreateBitmapIndirect LIB "GDI32.DLL" ALIAS "CreateBitmapIndirect" (lpBitmap AS BITMAP) AS DWORD
DECLARE FUNCTION CreateBrushIndirect LIB "GDI32.DLL" ALIAS "CreateBrushIndirect" (lpLogBrush AS LOGBRUSH) AS DWORD
DECLARE FUNCTION CreateCompatibleBitmap LIB "GDI32.DLL" ALIAS "CreateCompatibleBitmap" (BYVAL hdc AS DWORD, BYVAL nWidth AS LONG, BYVAL nHeight AS LONG) AS DWORD
DECLARE FUNCTION CreateDiscardableBitmap LIB "GDI32.DLL" ALIAS "CreateDiscardableBitmap" (BYVAL hdc AS DWORD, BYVAL nWidth AS LONG, BYVAL nHeight AS LONG) AS DWORD
DECLARE FUNCTION CreateCompatibleDC LIB "GDI32.DLL" ALIAS "CreateCompatibleDC" (BYVAL hdc AS DWORD) AS DWORD
DECLARE FUNCTION CreateDC LIB "GDI32.DLL" ALIAS "CreateDCA" (lpDriverName AS ASCIIZ, lpDeviceName AS ASCIIZ, lpOutput AS ASCIIZ, lpInitData AS DEVMODE) AS DWORD
DECLARE FUNCTION CreateDIBitmap LIB "GDI32.DLL" ALIAS "CreateDIBitmap" (BYVAL hdc AS DWORD, lpInfoHeader AS BITMAPINFOHEADER, BYVAL dwUsage AS DWORD, lpInitBits AS ANY, lpInitInfo AS BITMAPINFO, BYVAL wUsage AS DWORD) AS DWORD
DECLARE FUNCTION CreateDIBPatternBrush LIB "GDI32.DLL" ALIAS "CreateDIBPatternBrush" (BYVAL hPackedDIB AS DWORD, BYVAL wUsage AS DWORD) AS DWORD
DECLARE FUNCTION CreateDIBPatternBrushPt LIB "GDI32.DLL" ALIAS "CreateDIBPatternBrushPt" (lpPackedDIB AS ANY, BYVAL iUsage AS DWORD) AS DWORD
DECLARE FUNCTION CreateEllipticRgn LIB "GDI32.DLL" ALIAS "CreateEllipticRgn" (BYVAL X1 AS LONG, BYVAL Y1 AS LONG, BYVAL X2 AS LONG, BYVAL Y2 AS LONG) AS DWORD
DECLARE FUNCTION CreateEllipticRgnIndirect LIB "GDI32.DLL" ALIAS "CreateEllipticRgnIndirect" (lpRect AS RECT) AS DWORD
DECLARE FUNCTION CreateFontIndirect LIB "GDI32.DLL" ALIAS "CreateFontIndirectA" (lpLogFont AS LOGFONT) AS DWORD
DECLARE FUNCTION CreateFont LIB "GDI32.DLL" ALIAS "CreateFontA" (BYVAL nHeight AS LONG, BYVAL nWidth AS LONG, BYVAL nEscapement AS LONG, BYVAL nOrientation AS LONG, BYVAL fnWeight AS LONG, BYVAL fdwItalic AS DWORD, _
        BYVAL fdwUnderline AS DWORD, BYVAL fdwStrikeOut AS DWORD, BYVAL fdwCharSet AS DWORD, BYVAL fdwOutputPrecision AS DWORD, BYVAL fdwClipPrecision AS DWORD, BYVAL fdwQuality AS DWORD, _
        BYVAL fdwPitchAndFamily AS DWORD, lpszFace AS ASCIIZ) AS DWORD
DECLARE FUNCTION CreateHatchBrush LIB "GDI32.DLL" ALIAS "CreateHatchBrush" (BYVAL nIndex AS LONG, BYVAL crColor AS DWORD) AS DWORD
DECLARE FUNCTION CreateIC LIB "GDI32.DLL" ALIAS "CreateICA" (lpDriverName AS ASCIIZ, lpDeviceName AS ASCIIZ, lpOutput AS ASCIIZ, lpInitData AS DEVMODE) AS DWORD
DECLARE FUNCTION CreateMetaFile LIB "GDI32.DLL" ALIAS "CreateMetaFileA" (lpString AS ASCIIZ) AS DWORD
DECLARE FUNCTION CreatePalette LIB "GDI32.DLL" ALIAS "CreatePalette" (lpLogPalette AS LOGPALETTE) AS DWORD
DECLARE FUNCTION CreatePen LIB "GDI32.DLL" ALIAS "CreatePen" (BYVAL nPenStyle AS LONG, BYVAL nWidth AS LONG, BYVAL crColor AS DWORD) AS DWORD
DECLARE FUNCTION CreatePenIndirect LIB "GDI32.DLL" ALIAS "CreatePenIndirect" (lpLogPen AS LOGPEN) AS DWORD
DECLARE FUNCTION CreatePolyPolygonRgn LIB "GDI32.DLL" ALIAS "CreatePolyPolygonRgn" (lpPoint AS POINTAPI, lpPolyCounts AS LONG, BYVAL nCount AS LONG, BYVAL nPolyFillMode AS LONG) AS DWORD
DECLARE FUNCTION CreatePatternBrush LIB "GDI32.DLL" ALIAS "CreatePatternBrush" (BYVAL hBitmap AS DWORD) AS DWORD
DECLARE FUNCTION CreateRectRgn LIB "GDI32.DLL" ALIAS "CreateRectRgn" (BYVAL X1 AS LONG, BYVAL Y1 AS LONG, BYVAL X2 AS LONG, BYVAL Y2 AS LONG) AS DWORD
DECLARE FUNCTION CreateRectRgnIndirect LIB "GDI32.DLL" ALIAS "CreateRectRgnIndirect" (lpRect AS RECT) AS DWORD
DECLARE FUNCTION CreateRoundRectRgn LIB "GDI32.DLL" ALIAS "CreateRoundRectRgn" (BYVAL X1 AS LONG, BYVAL Y1 AS LONG, BYVAL X2 AS LONG, BYVAL Y2 AS LONG, BYVAL X3 AS LONG, BYVAL Y3 AS LONG) AS DWORD
DECLARE FUNCTION CreateScalableFontResource LIB "GDI32.DLL" ALIAS "CreateScalableFontResourceA" (BYVAL fHidden AS DWORD, lpszResourceFile AS ASCIIZ, lpszFontFile AS ASCIIZ, lpszCurrentPath AS ASCIIZ) AS LONG
DECLARE FUNCTION CreateSolidBrush LIB "GDI32.DLL" ALIAS "CreateSolidBrush" (BYVAL crColor AS DWORD) AS DWORD
DECLARE FUNCTION DeleteDC LIB "GDI32.DLL" ALIAS "DeleteDC" (BYVAL hdc AS DWORD) AS LONG
DECLARE FUNCTION DeleteMetaFile LIB "GDI32.DLL" ALIAS "DeleteMetaFile" (BYVAL hMF AS DWORD) AS LONG
DECLARE FUNCTION DeleteObject LIB "GDI32.DLL" ALIAS "DeleteObject" (BYVAL hObject AS DWORD) AS LONG
DECLARE FUNCTION DescribePixelFormat LIB "GDI32.DLL" ALIAS "DescribePixelFormat" (BYVAL hDC AS DWORD, BYVAL iPixelFormat AS LONG, BYVAL nBytes AS DWORD, ppfd AS PIXELFORMATDESCRIPTOR) AS LONG
DECLARE FUNCTION DeviceCapabilities LIB "WINSPOOL.DRV" ALIAS "DeviceCapabilitiesA" (lpDeviceName AS ASCIIZ, lpPort AS ASCIIZ, BYVAL iIndex AS WORD, lpOutput AS ASCIIZ, lpDevMode AS DEVMODE) AS LONG
DECLARE FUNCTION DrawEscape LIB "GDI32.DLL" ALIAS "DrawEscape" (BYVAL hdc AS DWORD, BYVAL nEscape AS LONG, BYVAL cbInput AS LONG, lpszInData AS ASCIIZ) AS LONG
DECLARE FUNCTION Ellipse LIB "GDI32.DLL" ALIAS "Ellipse" (BYVAL hdc AS DWORD, BYVAL X1 AS LONG, BYVAL Y1 AS LONG, BYVAL X2 AS LONG, BYVAL Y2 AS LONG) AS LONG
DECLARE FUNCTION EnumFontFamiliesEx LIB "GDI32.DLL" ALIAS "EnumFontFamiliesExA" (BYVAL hdc AS DWORD, lpLogFont AS LOGFONT, BYVAL lpEnumFontProc AS DWORD, BYVAL lParam AS LONG, BYVAL dw AS DWORD) AS LONG
DECLARE FUNCTION EnumFontFamilies LIB "GDI32.DLL" ALIAS "EnumFontFamiliesA" (BYVAL hdc AS DWORD, lpszFamily AS ASCIIZ, BYVAL lpEnumFontFamProc AS DWORD, BYVAL lParam AS LONG) AS LONG
DECLARE FUNCTION EnumFonts LIB "GDI32.DLL" ALIAS "EnumFontsA" (BYVAL hDC AS DWORD, lpsz AS ASCIIZ, BYVAL lpFontEnumProc AS DWORD, BYVAL lParam AS LONG) AS LONG
DECLARE FUNCTION EnumObjects LIB "GDI32.DLL" ALIAS "EnumObjects" (BYVAL hDC AS DWORD, BYVAL n AS LONG, BYVAL lpGOBJEnumProc AS DWORD, lpVoid AS ANY) AS LONG
DECLARE FUNCTION EqualRgn LIB "GDI32.DLL" ALIAS "EqualRgn" (BYVAL hSrcRgn1 AS DWORD, BYVAL hSrcRgn2 AS DWORD) AS LONG
DECLARE FUNCTION Escape LIB "GDI32.DLL" ALIAS "Escape" (BYVAL hdc AS DWORD, BYVAL nEscape AS LONG, BYVAL nCount AS LONG, lpInData AS ASCIIZ, lpOutData AS ANY) AS LONG
DECLARE FUNCTION ExtEscape LIB "GDI32.DLL" ALIAS "ExtEscape" (BYVAL hdc AS DWORD, BYVAL nEscape AS LONG, BYVAL cbInput AS LONG, lpszInData AS ASCIIZ, BYVAL cbOutput AS LONG, lpszOutData AS ASCIIZ) AS LONG
DECLARE FUNCTION ExcludeClipRect LIB "GDI32.DLL" ALIAS "ExcludeClipRect" (BYVAL hdc AS DWORD, BYVAL X1 AS LONG, BYVAL Y1 AS LONG, BYVAL X2 AS LONG, BYVAL Y2 AS LONG) AS LONG
DECLARE FUNCTION ExtCreateRegion LIB "GDI32.DLL" ALIAS "ExtCreateRegion" (lpXform AS xform, BYVAL nCount AS DWORD, lpRgnData AS ANY) AS DWORD
DECLARE FUNCTION ExtFloodFill LIB "GDI32.DLL" ALIAS "ExtFloodFill" (BYVAL hdc AS DWORD, BYVAL x AS LONG, BYVAL y AS LONG, BYVAL crColor AS DWORD, BYVAL wFillType AS DWORD) AS LONG
DECLARE FUNCTION FillRgn LIB "GDI32.DLL" ALIAS "FillRgn" (BYVAL hdc AS DWORD, BYVAL hRgn AS DWORD, BYVAL hBrush AS DWORD) AS LONG
DECLARE FUNCTION FloodFill LIB "GDI32.DLL" ALIAS "FloodFill" (BYVAL hdc AS DWORD, BYVAL x AS LONG, BYVAL y AS LONG, BYVAL crColor AS DWORD) AS LONG
DECLARE FUNCTION FrameRgn LIB "GDI32.DLL" ALIAS "FrameRgn" (BYVAL hdc AS DWORD, BYVAL hRgn AS DWORD, BYVAL hBrush AS DWORD, BYVAL nWidth AS LONG, BYVAL nHeight AS LONG) AS LONG
DECLARE FUNCTION GetROP2 LIB "GDI32.DLL" ALIAS "GetROP2" (BYVAL hdc AS DWORD) AS LONG
DECLARE FUNCTION GetAspectRatioFilterEx LIB "GDI32.DLL" ALIAS "GetAspectRatioFilterEx" (BYVAL hdc AS DWORD, lpAspectRatio AS SIZEL) AS LONG
DECLARE FUNCTION GetBkColor LIB "GDI32.DLL" ALIAS "GetBkColor" (BYVAL hdc AS DWORD) AS DWORD
DECLARE FUNCTION GetDCBrushColor LIB "GDI32.DLL" ALIAS "GetDCBrushColor" (BYVAL hdc AS DWORD) AS DWORD
DECLARE FUNCTION GetDCPenColor LIB "GDI32.DLL" ALIAS "GetDCPenColor" (BYVAL hdc AS DWORD) AS DWORD
DECLARE FUNCTION GetBkMode LIB "GDI32.DLL" ALIAS "GetBkMode" (BYVAL hdc AS DWORD) AS LONG
DECLARE FUNCTION GetBitmapBits LIB "GDI32.DLL" ALIAS "GetBitmapBits" (BYVAL hBitmap AS DWORD, BYVAL cbBuffer AS LONG, lpBits AS ANY) AS LONG
DECLARE FUNCTION GetBitmapDimensionEx LIB "GDI32.DLL" ALIAS "GetBitmapDimensionEx" (BYVAL hBitmap AS DWORD, lpDimension AS SIZEL) AS LONG
DECLARE FUNCTION GetBoundsRect LIB "GDI32.DLL" ALIAS "GetBoundsRect" (BYVAL hdc AS DWORD, lprcBounds AS RECT, BYVAL flags AS DWORD) AS DWORD
DECLARE FUNCTION GetBrushOrgEx LIB "GDI32.DLL" ALIAS "GetBrushOrgEx" (BYVAL hDC AS DWORD, lpPoint AS POINTAPI) AS LONG
DECLARE FUNCTION GetCharWidth LIB "GDI32.DLL" ALIAS "GetCharWidthA" (BYVAL hdc AS DWORD, BYVAL dFirstChar AS DWORD, BYVAL dLastChar AS DWORD, lpBuffer AS LONG) AS LONG
DECLARE FUNCTION GetCharWidth32 LIB "GDI32.DLL" ALIAS "GetCharWidth32A" (BYVAL hdc AS DWORD, BYVAL dFirstChar AS DWORD, BYVAL dLastChar AS DWORD, lpBuffer AS LONG) AS LONG
DECLARE FUNCTION GetCharWidthFloat LIB "GDI32.DLL" ALIAS "GetCharWidthFloatA" (BYVAL hdc AS DWORD, BYVAL dFirstChar AS DWORD, BYVAL dLastChar AS DWORD, pxBuffer AS DOUBLE) AS LONG
DECLARE FUNCTION GetCharABCWidths LIB "GDI32.DLL" ALIAS "GetCharABCWidthsA" (BYVAL hdc AS DWORD, BYVAL dFirstChar AS DWORD, BYVAL dLastChar AS DWORD, lpabc AS ABC) AS LONG
DECLARE FUNCTION GetCharABCWidthsFloat LIB "GDI32.DLL" ALIAS "GetCharABCWidthsFloatA" (BYVAL hdc AS DWORD, BYVAL dFirstChar AS DWORD, BYVAL dLastChar AS DWORD, lpABCF AS ABCFLOAT) AS LONG
DECLARE FUNCTION GetClipBox LIB "GDI32.DLL" ALIAS "GetClipBox" (BYVAL hdc AS DWORD, lpRect AS RECT) AS LONG
DECLARE FUNCTION GetClipRgn LIB "GDI32.DLL" ALIAS "GetClipRgn" (BYVAL hdc AS DWORD, BYVAL hRgn AS DWORD) AS LONG
DECLARE FUNCTION GetMetaRgn LIB "GDI32.DLL" ALIAS "GetMetaRgn" (BYVAL hdc AS DWORD, BYVAL hRgn AS DWORD) AS LONG
DECLARE FUNCTION GetCurrentObject LIB "GDI32.DLL" ALIAS "GetCurrentObject" (BYVAL hdc AS DWORD, BYVAL uObjectType AS DWORD) AS DWORD
DECLARE FUNCTION GetCurrentPositionEx LIB "GDI32.DLL" ALIAS "GetCurrentPositionEx" (BYVAL hdc AS DWORD, lpPoint AS POINTAPI) AS LONG
DECLARE FUNCTION GetDeviceCaps LIB "GDI32.DLL" ALIAS "GetDeviceCaps" (BYVAL hdc AS DWORD, BYVAL nIndex AS LONG) AS LONG
DECLARE FUNCTION GetDIBits LIB "GDI32.DLL" ALIAS "GetDIBits" (BYVAL hdc AS DWORD, BYVAL hBitmap AS DWORD, BYVAL nStartScan AS DWORD, BYVAL nNumScans AS DWORD, lpBits AS ANY, lpBI AS BITMAPINFO, BYVAL wUsage AS DWORD) AS LONG
DECLARE FUNCTION GetFontData LIB "GDI32.DLL" ALIAS "GetFontData" (BYVAL hdc AS DWORD, BYVAL dwTable AS DWORD, BYVAL dwOffset AS DWORD, lpvBuffer AS ANY, BYVAL cbData AS DWORD) AS DWORD
DECLARE FUNCTION GetGlyphOutline LIB "GDI32.DLL" ALIAS "GetGlyphOutlineA" (BYVAL hdc AS DWORD, BYVAL uChar AS DWORD, BYVAL ufFormat AS DWORD, lpgm AS GLYPHMETRICS, BYVAL cbBuffer AS DWORD, lpBuffer AS ANY, lpmat2 AS MAT2) AS DWORD
DECLARE FUNCTION GetGraphicsMode LIB "GDI32.DLL" ALIAS "GetGraphicsMode" (BYVAL hdc AS DWORD) AS LONG
DECLARE FUNCTION GetMapMode LIB "GDI32.DLL" ALIAS "GetMapMode" (BYVAL hdc AS DWORD) AS LONG
DECLARE FUNCTION GetMetaFileBitsEx LIB "GDI32.DLL" ALIAS "GetMetaFileBitsEx" (BYVAL hMF AS DWORD, BYVAL nSize AS DWORD, lpvData AS ANY) AS DWORD
DECLARE FUNCTION GetMetaFile LIB "GDI32.DLL" ALIAS "GetMetaFileA" (lpFileName AS ASCIIZ) AS DWORD
DECLARE FUNCTION GetNearestColor LIB "GDI32.DLL" ALIAS "GetNearestColor" (BYVAL hdc AS DWORD, BYVAL crColor AS DWORD) AS DWORD
DECLARE FUNCTION GetNearestPaletteIndex LIB "GDI32.DLL" ALIAS "GetNearestPaletteIndex" (BYVAL hPalette AS DWORD, BYVAL crColor AS DWORD) AS DWORD
DECLARE FUNCTION GetObjectType LIB "GDI32.DLL" ALIAS "GetObjectType" (BYVAL hgdiobj AS DWORD) AS DWORD
#IF NOT %DEF(%NOTEXTMETRIC) '--------------------------------------------------
DECLARE FUNCTION GetOutlineTextMetrics LIB "GDI32.DLL" ALIAS "GetOutlineTextMetricsA" (BYVAL hdc AS DWORD, BYVAL cbData AS DWORD, lpotm AS OUTLINETEXTMETRIC) AS DWORD
#ENDIF ' #IF NOT %DEF(%NOTEXTMETRIC) '-----------------------------------------
DECLARE FUNCTION GetPaletteEntries LIB "GDI32.DLL" ALIAS "GetPaletteEntries" (BYVAL hPalette AS DWORD, BYVAL wStartIndex AS DWORD, BYVAL wNumEntries AS DWORD, lpPaletteEntries AS PALETTEENTRY) AS DWORD
DECLARE FUNCTION GetPixel LIB "GDI32.DLL" ALIAS "GetPixel" (BYVAL hdc AS DWORD, BYVAL x AS LONG, BYVAL y AS LONG) AS DWORD
DECLARE FUNCTION GetPixelFormat LIB "GDI32.DLL" ALIAS "GetPixelFormat" (BYVAL hDC AS DWORD) AS LONG
DECLARE FUNCTION GetPolyFillMode LIB "GDI32.DLL" ALIAS "GetPolyFillMode" (BYVAL hdc AS DWORD) AS LONG
DECLARE FUNCTION GetRasterizerCaps LIB "GDI32.DLL" ALIAS "GetRasterizerCaps" (lpraststat AS RASTERIZER_STATUS, BYVAL cb AS DWORD) AS LONG
DECLARE FUNCTION GetRegionData LIB "GDI32.DLL" ALIAS "GetRegionData" (BYVAL hRgn AS DWORD, BYVAL dwCount AS DWORD, lpRgnData AS RgnData) AS DWORD
DECLARE FUNCTION GetRgnBox LIB "GDI32.DLL" ALIAS "GetRgnBox" (BYVAL hRgn AS DWORD, lpRect AS RECT) AS LONG
DECLARE FUNCTION GetStockObject LIB "GDI32.DLL" ALIAS "GetStockObject" (BYVAL nIndex AS LONG) AS DWORD
DECLARE FUNCTION GetStretchBltMode LIB "GDI32.DLL" ALIAS "GetStretchBltMode" (BYVAL hdc AS DWORD) AS LONG
DECLARE FUNCTION GetSystemPaletteEntries LIB "GDI32.DLL" ALIAS "GetSystemPaletteEntries" (BYVAL hdc AS DWORD, BYVAL wStartIndex AS DWORD, BYVAL wNumEntries AS DWORD, lpPaletteEntries AS PALETTEENTRY) AS DWORD
DECLARE FUNCTION GetSystemPaletteUse LIB "GDI32.DLL" ALIAS "GetSystemPaletteUse" (BYVAL hdc AS DWORD) AS DWORD
DECLARE FUNCTION GetTextCharacterExtra LIB "GDI32.DLL" ALIAS "GetTextCharacterExtra" (BYVAL hdc AS DWORD) AS LONG
DECLARE FUNCTION GetTextAlign LIB "GDI32.DLL" ALIAS "GetTextAlign" (BYVAL hdc AS DWORD) AS DWORD
DECLARE FUNCTION GetTextColor LIB "GDI32.DLL" ALIAS "GetTextColor" (BYVAL hdc AS DWORD) AS DWORD
DECLARE FUNCTION GetTextExtentPoint LIB "GDI32.DLL" ALIAS "GetTextExtentPointA" (BYVAL hdc AS DWORD, lpszString AS ASCIIZ, BYVAL cbString AS LONG, lpSize AS SIZEL) AS LONG
DECLARE FUNCTION GetTextExtentPoint32 LIB "GDI32.DLL" ALIAS "GetTextExtentPoint32A" (BYVAL hdc AS DWORD, lpsz AS ASCIIZ, BYVAL cbString AS LONG, lpSize AS SIZEL) AS LONG
DECLARE FUNCTION GetTextExtentExPoint LIB "GDI32.DLL" ALIAS "GetTextExtentExPointA" (BYVAL hdc AS DWORD, lpszStr AS ASCIIZ, BYVAL cchString AS LONG, BYVAL nMaxExtent AS LONG, lpnFit AS LONG, alpDx AS LONG, lpSize AS SIZEL) AS LONG
DECLARE FUNCTION GetTextCharset LIB "GDI32.DLL" ALIAS "GetTextCharset" (BYVAL hdc AS DWORD) AS LONG
DECLARE FUNCTION GetTextCharsetInfo LIB "GDI32.DLL" ALIAS "GetTextCharsetInfo" (BYVAL hdc AS DWORD, lpSig AS FONTSIGNATURE, BYVAL dwFlags AS DWORD) AS LONG
DECLARE FUNCTION TranslateCharsetInfo LIB "GDI32.DLL" ALIAS "TranslateCharsetInfo" (lpSrc AS DWORD, lpcs AS CHARSETINFO, BYVAL dwFlags AS DWORD) AS LONG
DECLARE FUNCTION GetFontLanguageInfo LIB "GDI32.DLL" ALIAS "GetFontLanguageInfo" (BYVAL hdc AS DWORD) AS DWORD
DECLARE FUNCTION GetCharacterPlacement LIB "GDI32.DLL" ALIAS "GetCharacterPlacementA" (BYVAL hdc AS DWORD, lpsz AS ASCIIZ, BYVAL n1 AS LONG, BYVAL n2 AS LONG, lpGcpResults AS GCP_RESULTS, BYVAL dw AS DWORD) AS DWORD
DECLARE FUNCTION GetGlyphIndices LIB "GDI32.DLL" ALIAS "GetGlyphIndicesA" (BYVAL hdc AS DWORD, lpstr AS ASCIIZ, BYVAL c AS LONG, pgi AS WORD, BYVAL fl AS DWORD) AS DWORD
DECLARE FUNCTION GetTextExtentPointI LIB "GDI32.DLL" ALIAS "GetTextExtentPointI" (BYVAL hdc AS DWORD, pgiIn AS WORD, BYVAL cgi AS LONG, lpSize AS SIZEL) AS LONG
DECLARE FUNCTION GetTextExtentExPointI LIB "GDI32.DLL" ALIAS "GetTextExtentExPointI" (BYVAL hdc AS DWORD, pgiIn AS WORD, BYVAL cgi AS LONG, BYVAL nMaxExtent AS LONG, lpnFit AS LONG, alpDx AS LONG, lpSize AS SIZEL) AS LONG
DECLARE FUNCTION GetCharWidthI LIB "GDI32.DLL" ALIAS "GetCharWidthI" (BYVAL hdc AS DWORD, BYVAL giFirst AS DWORD, BYVAL cgi AS DWORD, pgi AS ANY, lpBuffer AS ANY) AS LONG
DECLARE FUNCTION GetCharABCWidthsI LIB "GDI32.DLL" ALIAS "GetCharABCWidthsI" (BYVAL hdc AS DWORD, BYVAL giFirst AS DWORD, BYVAL cgi AS DWORD, pgi AS ANY, lpabc AS ANY) AS LONG
DECLARE FUNCTION AddFontResourceEx LIB "GDI32.DLL" ALIAS "AddFontResourceExA" (lpszFileName AS ASCIIZ, BYVAL fl AS DWORD, BYVAL pdv AS DWORD) AS LONG
DECLARE FUNCTION RemoveFontResourceEx LIB "GDI32.DLL" ALIAS "RemoveFontResourceExA" (lpFileName AS ASCIIZ, BYVAL fl AS DWORD, BYVAL pdv AS DWORD) AS LONG
DECLARE FUNCTION AddFontMemResourceEx LIB "GDI32.DLL" ALIAS "AddFontMemResourceEx" (BYVAL pbFont AS DWORD, BYVAL cbFont AS DWORD, BYVAL pdv AS DWORD, pcFonts AS DWORD) AS DWORD
DECLARE FUNCTION RemoveFontMemResourceEx LIB "GDI32.DLL" ALIAS "RemoveFontMemResourceEx" (BYVAL fh AS DWORD) AS LONG
DECLARE FUNCTION CreateFontIndirectEx LIB "GDI32.DLL" ALIAS "CreateFontIndirectExA" (penumlfex AS ENUMLOGFONTEXDV) AS DWORD
DECLARE FUNCTION GetViewportExtEx LIB "GDI32.DLL" ALIAS "GetViewportExtEx" (BYVAL hdc AS DWORD, lpSize AS SIZEL) AS LONG
DECLARE FUNCTION GetViewportOrgEx LIB "GDI32.DLL" ALIAS "GetViewportOrgEx" (BYVAL hdc AS DWORD, lpPoint AS POINTAPI) AS LONG
DECLARE FUNCTION GetWindowExtEx LIB "GDI32.DLL" ALIAS "GetWindowExtEx" (BYVAL hdc AS DWORD, lpSize AS SIZEL) AS LONG
DECLARE FUNCTION GetWindowOrgEx LIB "GDI32.DLL" ALIAS "GetWindowOrgEx" (BYVAL hdc AS DWORD, lpPoint AS POINTAPI) AS LONG
DECLARE FUNCTION IntersectClipRect LIB "GDI32.DLL" ALIAS "IntersectClipRect" (BYVAL hdc AS DWORD, BYVAL X1 AS LONG, BYVAL Y1 AS LONG, BYVAL X2 AS LONG, BYVAL Y2 AS LONG) AS LONG
DECLARE FUNCTION InvertRgn LIB "GDI32.DLL" ALIAS "InvertRgn" (BYVAL hdc AS DWORD, BYVAL hRgn AS DWORD) AS LONG
DECLARE FUNCTION LineDDA LIB "GDI32.DLL" ALIAS "LineDDA" (BYVAL n1 AS LONG, BYVAL n2 AS LONG, BYVAL n3 AS LONG, BYVAL n4 AS LONG, BYVAL lpLineDDAProc AS DWORD, BYVAL lParam AS LONG) AS LONG
DECLARE FUNCTION LineTo LIB "GDI32.DLL" ALIAS "LineTo" (BYVAL hdc AS DWORD, BYVAL x AS LONG, BYVAL y AS LONG) AS LONG
DECLARE FUNCTION MaskBlt LIB "GDI32.DLL" ALIAS "MaskBlt" (BYVAL hdcDest AS DWORD, BYVAL nXDest AS LONG, BYVAL nYDest AS LONG, BYVAL nWidth AS LONG, BYVAL nHeight AS LONG, BYVAL hdcSrc AS DWORD, BYVAL nXSrc AS LONG, BYVAL nYSrc AS LONG, _
                 BYVAL hbmMask AS DWORD, BYVAL xMask AS LONG, BYVAL yMask AS LONG, BYVAL dwRop AS DWORD) AS LONG
DECLARE FUNCTION PlgBlt LIB "GDI32.DLL" ALIAS "PlgBlt" (BYVAL hdcDest AS DWORD, lpPoint AS POINTAPI, BYVAL hdcSrc AS DWORD, BYVAL nXSrc AS LONG, BYVAL nYSrc AS LONG, BYVAL nWidth AS LONG, BYVAL nHeight AS LONG, BYVAL hbmMask AS DWORD, _
                 BYVAL xMask AS LONG, BYVAL yMask AS LONG) AS LONG
DECLARE FUNCTION OffsetClipRgn LIB "GDI32.DLL" ALIAS "OffsetClipRgn" (BYVAL hdc AS DWORD, BYVAL x AS LONG, BYVAL y AS LONG) AS LONG
DECLARE FUNCTION OffsetRgn LIB "GDI32.DLL" ALIAS "OffsetRgn" (BYVAL hRgn AS DWORD, BYVAL x AS LONG, BYVAL y AS LONG) AS LONG
DECLARE FUNCTION PatBlt LIB "GDI32.DLL" ALIAS "PatBlt" (BYVAL hdc AS DWORD, BYVAL x AS LONG, BYVAL y AS LONG, BYVAL nWidth AS LONG, BYVAL nHeight AS LONG, BYVAL dwRop AS DWORD) AS LONG
DECLARE FUNCTION Pie LIB "GDI32.DLL" ALIAS "Pie" (BYVAL hdc AS DWORD, BYVAL X1 AS LONG, BYVAL Y1 AS LONG, BYVAL X2 AS LONG, BYVAL Y2 AS LONG, BYVAL X3 AS LONG, BYVAL Y3 AS LONG, BYVAL X4 AS LONG, BYVAL Y4 AS LONG) AS LONG
DECLARE FUNCTION PlayMetaFile LIB "GDI32.DLL" ALIAS "PlayMetaFile" (BYVAL hdc AS DWORD, BYVAL hMF AS DWORD) AS LONG
DECLARE FUNCTION PaintRgn LIB "GDI32.DLL" ALIAS "PaintRgn" (BYVAL hdc AS DWORD, BYVAL hRgn AS DWORD) AS LONG
DECLARE FUNCTION PolyPolygon LIB "GDI32.DLL" ALIAS "PolyPolygon" (BYVAL hdc AS DWORD, lpPoint AS POINTAPI, lpPolyCounts AS LONG, BYVAL nCount AS LONG) AS LONG
DECLARE FUNCTION PtInRegion LIB "GDI32.DLL" ALIAS "PtInRegion" (BYVAL hRgn AS DWORD, BYVAL x AS LONG, BYVAL y AS LONG) AS LONG
DECLARE FUNCTION PtVisible LIB "GDI32.DLL" ALIAS "PtVisible" (BYVAL hdc AS DWORD, BYVAL x AS LONG, BYVAL y AS LONG) AS LONG
DECLARE FUNCTION RectInRegion LIB "GDI32.DLL" ALIAS "RectInRegion" (BYVAL hRgn AS DWORD, lpRect AS RECT) AS LONG
DECLARE FUNCTION RectVisible LIB "GDI32.DLL" ALIAS "RectVisible" (BYVAL hdc AS DWORD, lpRect AS RECT) AS LONG
DECLARE FUNCTION Rectangle LIB "GDI32.DLL" ALIAS "Rectangle" (BYVAL hdc AS DWORD, BYVAL X1 AS LONG, BYVAL Y1 AS LONG, BYVAL X2 AS LONG, BYVAL Y2 AS LONG) AS LONG
DECLARE FUNCTION RestoreDC LIB "GDI32.DLL" ALIAS "RestoreDC" (BYVAL hdc AS DWORD, BYVAL nSavedDC AS LONG) AS LONG
DECLARE FUNCTION ResetDC LIB "GDI32.DLL" ALIAS "ResetDCA" (BYVAL hdc AS DWORD, lpInitData AS DEVMODE) AS DWORD
DECLARE FUNCTION RealizePalette LIB "GDI32.DLL" ALIAS "RealizePalette" (BYVAL hdc AS DWORD) AS DWORD
DECLARE FUNCTION RemoveFontResource LIB "GDI32.DLL" ALIAS "RemoveFontResourceA" (lpFileName AS ASCIIZ) AS LONG
DECLARE FUNCTION RoundRect LIB "GDI32.DLL" ALIAS "RoundRect" (BYVAL hdc AS DWORD, BYVAL X1 AS LONG, BYVAL Y1 AS LONG, BYVAL X2 AS LONG, BYVAL Y2 AS LONG, BYVAL X3 AS LONG, BYVAL Y3 AS LONG) AS LONG
DECLARE FUNCTION ResizePalette LIB "GDI32.DLL" ALIAS "ResizePalette" (BYVAL hPalette AS DWORD, BYVAL nNumEntries AS DWORD) AS LONG
DECLARE FUNCTION SaveDC LIB "GDI32.DLL" ALIAS "SaveDC" (BYVAL hdc AS DWORD) AS LONG
DECLARE FUNCTION SelectClipRgn LIB "GDI32.DLL" ALIAS "SelectClipRgn" (BYVAL hdc AS DWORD, BYVAL hRgn AS DWORD) AS LONG
DECLARE FUNCTION ExtSelectClipRgn LIB "GDI32.DLL" ALIAS "ExtSelectClipRgn" (BYVAL hdc AS DWORD, BYVAL hRgn AS DWORD, BYVAL fnMode AS LONG) AS LONG
DECLARE FUNCTION SetMetaRgn LIB "GDI32.DLL" ALIAS "SetMetaRgn" (BYVAL hdc AS DWORD) AS LONG
DECLARE FUNCTION SelectObject LIB "GDI32.DLL" ALIAS "SelectObject" (BYVAL hdc AS DWORD, BYVAL hObject AS DWORD) AS DWORD
DECLARE FUNCTION SelectPalette LIB "GDI32.DLL" ALIAS "SelectPalette" (BYVAL hdc AS DWORD, BYVAL hPalette AS DWORD, BYVAL bForceBackground AS LONG) AS DWORD
DECLARE FUNCTION SetBkColor LIB "GDI32.DLL" ALIAS "SetBkColor" (BYVAL hdc AS DWORD, BYVAL crColor AS DWORD) AS DWORD
DECLARE FUNCTION SetDCBrushColor LIB "GDI32.DLL" ALIAS "SetDCBrushColor" (BYVAL hdc AS DWORD, BYVAL crColor AS DWORD) AS DWORD
DECLARE FUNCTION SetDCPenColor LIB "GDI32.DLL" ALIAS "SetDCPenColor" (BYVAL hdc AS DWORD, BYVAL crColor AS DWORD) AS DWORD
DECLARE FUNCTION SetBkMode LIB "GDI32.DLL" ALIAS "SetBkMode" (BYVAL hdc AS DWORD, BYVAL nBkMode AS LONG) AS LONG
DECLARE FUNCTION SetBitmapBits LIB "GDI32.DLL" ALIAS "SetBitmapBits" (BYVAL hBitmap AS DWORD, BYVAL dwCount AS DWORD, lpBits AS ANY) AS LONG
DECLARE FUNCTION SetBoundsRect LIB "GDI32.DLL" ALIAS "SetBoundsRect" (BYVAL hdc AS DWORD, lprcBounds AS RECT, BYVAL flags AS DWORD) AS DWORD
DECLARE FUNCTION SetDIBits LIB "GDI32.DLL" ALIAS "SetDIBits" (BYVAL hdc AS DWORD, BYVAL hBitmap AS DWORD, BYVAL nStartScan AS DWORD, BYVAL nNumScans AS DWORD, lpBits AS ANY, lpBI AS BITMAPINFO, BYVAL wUsage AS DWORD) AS LONG
DECLARE FUNCTION SetDIBitsToDevice LIB "GDI32.DLL" ALIAS "SetDIBitsToDevice" (BYVAL hdc AS DWORD, BYVAL x AS LONG, BYVAL y AS LONG, BYVAL dx AS DWORD, BYVAL dy AS DWORD, BYVAL SrcX AS LONG, BYVAL SrcY AS LONG, BYVAL xScan AS DWORD, _
                 BYVAL NumScans AS DWORD, xBits AS ANY, BitsInfo AS BITMAPINFO, BYVAL wUsage AS DWORD) AS LONG
DECLARE FUNCTION SetMapperFlags LIB "GDI32.DLL" ALIAS "SetMapperFlags" (BYVAL hdc AS DWORD, BYVAL dwFlag AS DWORD) AS DWORD
DECLARE FUNCTION SetGraphicsMode LIB "GDI32.DLL" ALIAS "SetGraphicsMode" (BYVAL hdc AS DWORD, BYVAL iMode AS LONG) AS LONG
DECLARE FUNCTION SetMapMode LIB "GDI32.DLL" ALIAS "SetMapMode" (BYVAL hdc AS DWORD, BYVAL nMapMode AS LONG) AS LONG
DECLARE FUNCTION SetMetaFileBitsEx LIB "GDI32.DLL" ALIAS "SetMetaFileBitsEx" (BYVAL nSize AS DWORD, lpData AS BYTE) AS DWORD
DECLARE FUNCTION SetPaletteEntries LIB "GDI32.DLL" ALIAS "SetPaletteEntries" (BYVAL hPalette AS DWORD, BYVAL wStartIndex AS DWORD, BYVAL wNumEntries AS DWORD, lpPaletteEntries AS PALETTEENTRY) AS DWORD
DECLARE FUNCTION SetPixel LIB "GDI32.DLL" ALIAS "SetPixel" (BYVAL hdc AS DWORD, BYVAL x AS LONG, BYVAL y AS LONG, BYVAL crColor AS DWORD) AS DWORD
DECLARE FUNCTION SetPixelV LIB "GDI32.DLL" ALIAS "SetPixelV" (BYVAL hdc AS DWORD, BYVAL x AS LONG, BYVAL y AS LONG, BYVAL crColor AS DWORD) AS LONG
DECLARE FUNCTION SetPixelFormat LIB "GDI32.DLL" ALIAS "SetPixelFormat" (BYVAL hDC AS DWORD, BYVAL n AS LONG, pcPixelFormatDescriptor AS PIXELFORMATDESCRIPTOR) AS LONG
DECLARE FUNCTION SetPolyFillMode LIB "GDI32.DLL" ALIAS "SetPolyFillMode" (BYVAL hdc AS DWORD, BYVAL nPolyFillMode AS LONG) AS LONG
DECLARE FUNCTION StretchBlt LIB "GDI32.DLL" ALIAS "StretchBlt" (BYVAL hdc AS DWORD, BYVAL x AS LONG, BYVAL y AS LONG, BYVAL nWidth AS LONG, BYVAL nHeight AS LONG, BYVAL hSrcDC AS DWORD, BYVAL xSrc AS LONG, BYVAL ySrc AS LONG, _
                 BYVAL nSrcWidth AS LONG, BYVAL nSrcHeight AS LONG, BYVAL dwRop AS DWORD) AS LONG
DECLARE FUNCTION SetRectRgn LIB "GDI32.DLL" ALIAS "SetRectRgn" (BYVAL hRgn AS DWORD, BYVAL X1 AS LONG, BYVAL Y1 AS LONG, BYVAL X2 AS LONG, BYVAL Y2 AS LONG) AS LONG
DECLARE FUNCTION StretchDIBits LIB "GDI32.DLL" ALIAS "StretchDIBits" (BYVAL hdc AS DWORD, BYVAL x AS LONG, BYVAL y AS LONG, BYVAL dx AS LONG, BYVAL dy AS LONG, BYVAL SrcX AS LONG, BYVAL SrcY AS LONG, BYVAL nSrcWidth AS LONG, _
                 BYVAL nSrcHeight AS LONG, lpBits AS ANY, lpBitsInfo AS BITMAPINFO, BYVAL uUsage AS DWORD, BYVAL dwRop AS DWORD) AS LONG
DECLARE FUNCTION SetROP2 LIB "GDI32.DLL" ALIAS "SetROP2" (BYVAL hdc AS DWORD, BYVAL nDrawMode AS LONG) AS LONG
DECLARE FUNCTION SetStretchBltMode LIB "GDI32.DLL" ALIAS "SetStretchBltMode" (BYVAL hdc AS DWORD, BYVAL nStretchMode AS LONG) AS LONG
DECLARE FUNCTION SetSystemPaletteUse LIB "GDI32.DLL" ALIAS "SetSystemPaletteUse" (BYVAL hdc AS DWORD, BYVAL uUsage AS DWORD) AS DWORD
DECLARE FUNCTION SetTextCharacterExtra LIB "GDI32.DLL" ALIAS "SetTextCharacterExtra" (BYVAL hdc AS DWORD, BYVAL nCharExtra AS LONG) AS LONG
DECLARE FUNCTION SetTextColor LIB "GDI32.DLL" ALIAS "SetTextColor" (BYVAL hdc AS DWORD, BYVAL crColor AS DWORD) AS DWORD
DECLARE FUNCTION SetTextAlign LIB "GDI32.DLL" ALIAS "SetTextAlign" (BYVAL hdc AS DWORD, BYVAL dwFlags AS DWORD) AS DWORD
DECLARE FUNCTION SetTextJustification LIB "GDI32.DLL" ALIAS "SetTextJustification" (BYVAL hdc AS DWORD, BYVAL nBreakExtra AS LONG, BYVAL nBreakCount AS LONG) AS LONG
DECLARE FUNCTION UpdateColors LIB "GDI32.DLL" ALIAS "UpdateColors" (BYVAL hdc AS DWORD) AS LONG
DECLARE FUNCTION AlphaBlend LIB "MSIMG32.DLL" ALIAS "AlphaBlend" (BYVAL hdcDest AS DWORD, BYVAL nXOriginDest AS LONG, BYVAL nYOriginDest AS LONG, BYVAL nWidthDest AS LONG, BYVAL nHeightDest AS LONG, _
                 BYVAL hdcSrc AS DWORD, BYVAL nXOriginSrc AS LONG, BYVAL nYOriginSrc AS LONG, BYVAL nWidthSrc AS LONG, BYVAL nHeightSrc AS LONG) AS LONG
' wingdi.h declares AlphaDIBBlend at this point, but this function is
' not documented by Microsoft and does not appear to be exported at this time.
DECLARE FUNCTION TransparentBlt LIB "MSIMG32.DLL" ALIAS "TransparentBlt" (BYVAL hdcDest AS DWORD, BYVAL nXOriginDest AS LONG, BYVAL nYOriginDest AS LONG, BYVAL nWidthDest AS LONG, BYVAL hHeightDest AS DWORD, _
                 BYVAL hdcSrc AS DWORD, BYVAL nXOriginSrc AS LONG, BYVAL nYOriginSrc AS LONG, BYVAL nWidthSrc AS LONG, BYVAL nHeightSrc AS LONG, BYVAL crTransparent AS DWORD) AS LONG
' wingdi.h declares TransparentDIBits at this point, but this function is
' not documented by Microsoft and does not appear to be exported at this time.
DECLARE FUNCTION GradientFill LIB "MSIMG32.DLL" ALIAS "GradientFill" (BYVAL hdc AS DWORD, pVertex AS TRIVERTEX, BYVAL dwNumVertex AS DWORD, pMesh AS ANY, BYVAL dwNumMesh AS DWORD, BYVAL dwMode AS DWORD) AS LONG
#IF NOT %DEF(%NOMETAFILE) '----------------------------------------------------
DECLARE FUNCTION PlayMetaFileRecord LIB "GDI32.DLL" ALIAS "PlayMetaFileRecord" (BYVAL hdc AS DWORD, lpHandletable AS HANDLETABLE, lpMetaRecord AS METARECORD, BYVAL nHandles AS DWORD) AS LONG
DECLARE FUNCTION EnumMetaFile LIB "GDI32.DLL" ALIAS "EnumMetaFile" (BYVAL hDC AS DWORD, BYVAL hMetafile AS DWORD, BYVAL lpMFEnumProc AS DWORD, BYVAL lParam AS LONG) AS LONG
DECLARE FUNCTION CloseEnhMetaFile LIB "GDI32.DLL" ALIAS "CloseEnhMetaFile" (BYVAL hdc AS DWORD) AS DWORD
DECLARE FUNCTION CopyEnhMetaFile LIB "GDI32.DLL" ALIAS "CopyEnhMetaFileA" (BYVAL hemfSrc AS DWORD, lpszFile AS ASCIIZ) AS DWORD
DECLARE FUNCTION CreateEnhMetaFile LIB "GDI32.DLL" ALIAS "CreateEnhMetaFileA" (BYVAL hdcRef AS DWORD, lpFileName AS ASCIIZ, lpRect AS RECT, lpDescription AS ASCIIZ) AS DWORD
DECLARE FUNCTION DeleteEnhMetaFile LIB "GDI32.DLL" ALIAS "DeleteEnhMetaFile" (BYVAL hemf AS DWORD) AS LONG
DECLARE FUNCTION EnumEnhMetaFile LIB "GDI32.DLL" ALIAS "EnumEnhMetaFile" (BYVAL hdc AS DWORD, BYVAL hemf AS DWORD, BYVAL lpEnhMetaFunc AS DWORD, lpData AS ANY, lpRect AS RECT) AS LONG
DECLARE FUNCTION GetEnhMetaFile LIB "GDI32.DLL" ALIAS "GetEnhMetaFileA" (lpszMetaFile AS ASCIIZ) AS DWORD
DECLARE FUNCTION GetEnhMetaFileBits LIB "GDI32.DLL" ALIAS "GetEnhMetaFileBits" (BYVAL hemf AS DWORD, BYVAL cbBuffer AS DWORD, lpbBuffer AS BYTE) AS DWORD
DECLARE FUNCTION GetEnhMetaFileDescription LIB "GDI32.DLL" ALIAS "GetEnhMetaFileDescriptionA" (BYVAL hemf AS DWORD, BYVAL cchBuffer AS DWORD, lpszDescription AS ASCIIZ) AS DWORD
DECLARE FUNCTION GetEnhMetaFileHeader LIB "GDI32.DLL" ALIAS "GetEnhMetaFileHeader" (BYVAL hemf AS DWORD, BYVAL cbBuffer AS DWORD, lpemh AS ENHMETAHEADER) AS DWORD
DECLARE FUNCTION GetEnhMetaFilePaletteEntries LIB "GDI32.DLL" ALIAS "GetEnhMetaFilePaletteEntries" (BYVAL hemf AS DWORD, BYVAL cEntries AS DWORD, lppe AS PALETTEENTRY) AS DWORD
DECLARE FUNCTION GetEnhMetaFilePixelFormat LIB "GDI32.DLL" ALIAS "GetEnhMetaFilePixelFormat" (BYVAL hemf AS DWORD, BYVAL cbBuffer AS DWORD, ppfd AS PIXELFORMATDESCRIPTOR) AS DWORD
DECLARE FUNCTION GetWinMetaFileBits LIB "GDI32.DLL" ALIAS "GetWinMetaFileBits" (BYVAL hemf AS DWORD, BYVAL cbBuffer AS DWORD, lpbBuffer AS BYTE, BYVAL fnMapMode AS LONG, BYVAL hdcRef AS DWORD) AS DWORD
DECLARE FUNCTION PlayEnhMetaFile LIB "GDI32.DLL" ALIAS "PlayEnhMetaFile" (BYVAL hdc AS DWORD, BYVAL hemf AS DWORD, lpRect AS RECT) AS LONG
DECLARE FUNCTION PlayEnhMetaFileRecord LIB "GDI32.DLL" ALIAS "PlayEnhMetaFileRecord" (BYVAL hdc AS DWORD, lpHandletable AS HANDLETABLE, lpEnhMetaRecord AS ENHMETARECORD, BYVAL nHandles AS DWORD) AS LONG
DECLARE FUNCTION SetEnhMetaFileBits LIB "GDI32.DLL" ALIAS "SetEnhMetaFileBits" (BYVAL cbBuffer AS DWORD, lpData AS BYTE) AS DWORD
DECLARE FUNCTION SetWinMetaFileBits LIB "GDI32.DLL" ALIAS "SetWinMetaFileBits" (BYVAL cbBuffer AS DWORD, lpbBuffer AS BYTE, BYVAL hdcRef AS DWORD, lpmfp AS METAFILEPICT) AS DWORD
DECLARE FUNCTION GdiComment LIB "GDI32.DLL" ALIAS "GdiComment" (BYVAL hdc AS DWORD, BYVAL cbSize AS DWORD, lpData AS BYTE) AS LONG
#ENDIF ' #IF NOT %DEF(%NOMETAFILE) --------------------------------------------
#IF NOT %DEF(%NOTEXTMETRIC) '--------------------------------------------------
DECLARE FUNCTION GetTextMetrics LIB "GDI32.DLL" ALIAS "GetTextMetricsA" (BYVAL hdc AS DWORD, lpMetrics AS TEXTMETRIC) AS LONG
#ENDIF ' IF NOT %DEF(%NOTEXTMETRIC) -------------------------------------------
DECLARE FUNCTION AngleArc LIB "GDI32.DLL" ALIAS "AngleArc" (BYVAL hdc AS DWORD, BYVAL x AS LONG, BYVAL y AS LONG, BYVAL dwRadius AS DWORD, BYVAL eStartAngle AS DOUBLE, BYVAL eSweepAngle AS DOUBLE) AS LONG
DECLARE FUNCTION PolyPolyline LIB "GDI32.DLL" ALIAS "PolyPolyline" (BYVAL hdc AS DWORD, lppt AS POINTAPI, lpdwPolyPoints AS DWORD, BYVAL cCount AS DWORD) AS LONG
DECLARE FUNCTION GetWorldTransform LIB "GDI32.DLL" ALIAS "GetWorldTransform" (BYVAL hdc AS DWORD, lpXform AS XFORM) AS LONG
DECLARE FUNCTION SetWorldTransform LIB "GDI32.DLL" ALIAS "SetWorldTransform" (BYVAL hdc AS DWORD, lpXform AS XFORM) AS LONG
DECLARE FUNCTION ModifyWorldTransform LIB "GDI32.DLL" ALIAS "ModifyWorldTransform" (BYVAL hdc AS DWORD, lpXform AS xform, BYVAL dwMode AS DWORD) AS LONG
DECLARE FUNCTION CombineTransform LIB "GDI32.DLL" ALIAS "CombineTransform" (lpXFORMResult AS XFORM, lpXFORM1 AS XFORM, lpXFORM2 AS XFORM) AS LONG
DECLARE FUNCTION CreateDIBSection LIB "GDI32.DLL" ALIAS "CreateDIBSection" (BYVAL hdc AS DWORD, pbmi AS BITMAPINFO, BYVAL dwUsage AS DWORD, BYVAL ppvBits AS DWORD, BYVAL hSection AS DWORD, BYVAL dwOffset AS DWORD) AS DWORD
DECLARE FUNCTION GetDIBColorTable LIB "GDI32.DLL" ALIAS "GetDIBColorTable" (BYVAL hDC AS DWORD, BYVAL uStartIndex AS DWORD, BYVAL cEntries AS DWORD, pRGBQuad AS RGBQUAD) AS DWORD
DECLARE FUNCTION SetDIBColorTable LIB "GDI32.DLL" ALIAS "SetDIBColorTable" (BYVAL hDC AS DWORD, BYVAL uStartIndex AS DWORD, BYVAL cEntries AS DWORD, pcRGBQuad AS RGBQUAD) AS DWORD
DECLARE FUNCTION SetColorAdjustment LIB "GDI32.DLL" ALIAS "SetColorAdjustment" (BYVAL hdc AS DWORD, lpca AS COLORADJUSTMENT) AS LONG
DECLARE FUNCTION GetColorAdjustment LIB "GDI32.DLL" ALIAS "GetColorAdjustment" (BYVAL hdc AS DWORD, lpca AS COLORADJUSTMENT) AS LONG
DECLARE FUNCTION CreateHalftonePalette LIB "GDI32.DLL" ALIAS "CreateHalftonePalette" (BYVAL hdc AS DWORD) AS DWORD
DECLARE FUNCTION StartDoc LIB "GDI32.DLL" ALIAS "StartDocA" (BYVAL hdc AS DWORD, lpdi AS DOCINFO) AS LONG
DECLARE FUNCTION EndDoc LIB "GDI32.DLL" ALIAS "EndDoc" (BYVAL hdc AS DWORD) AS LONG
DECLARE FUNCTION StartPage LIB "GDI32.DLL" ALIAS "StartPage" (BYVAL hdc AS DWORD) AS LONG
DECLARE FUNCTION EndPage LIB "GDI32.DLL" ALIAS "EndPage" (BYVAL hdc AS DWORD) AS LONG
DECLARE FUNCTION AbortDoc LIB "GDI32.DLL" ALIAS "AbortDoc" (BYVAL hdc AS DWORD) AS LONG
DECLARE FUNCTION SetAbortProc LIB "GDI32.DLL" ALIAS "SetAbortProc" (BYVAL hDC AS DWORD, BYVAL lpAbortProc AS DWORD) AS LONG
DECLARE FUNCTION AbortPath LIB "GDI32.DLL" ALIAS "AbortPath" (BYVAL hdc AS DWORD) AS LONG
DECLARE FUNCTION ArcTo LIB "GDI32.DLL" ALIAS "ArcTo" (BYVAL hdc AS DWORD, BYVAL X1 AS LONG, BYVAL Y1 AS LONG, BYVAL X2 AS LONG, BYVAL Y2 AS LONG, BYVAL X3 AS LONG, BYVAL Y3 AS LONG, BYVAL X4 AS LONG, BYVAL Y4 AS LONG) AS LONG
DECLARE FUNCTION BeginPath LIB "GDI32.DLL" ALIAS "BeginPath" (BYVAL hdc AS DWORD) AS LONG
DECLARE FUNCTION CloseFigure LIB "GDI32.DLL" ALIAS "CloseFigure" (BYVAL hdc AS DWORD) AS LONG
DECLARE FUNCTION EndPath LIB "GDI32.DLL" ALIAS "EndPath" (BYVAL hdc AS DWORD) AS LONG
DECLARE FUNCTION FillPath LIB "GDI32.DLL" ALIAS "FillPath" (BYVAL hdc AS DWORD) AS LONG
DECLARE FUNCTION FlattenPath LIB "GDI32.DLL" ALIAS "FlattenPath" (BYVAL hdc AS DWORD) AS LONG
DECLARE FUNCTION GetPath LIB "GDI32.DLL" ALIAS "GetPath" (BYVAL hdc AS DWORD, lpPoint AS POINTAPI, lpTypes AS BYTE, BYVAL nSize AS DWORD) AS LONG
DECLARE FUNCTION PathToRegion LIB "GDI32.DLL" ALIAS "PathToRegion" (BYVAL hdc AS DWORD) AS DWORD
DECLARE FUNCTION PolyDraw LIB "GDI32.DLL" ALIAS "PolyDraw" (BYVAL hdc AS DWORD, lppt AS POINTAPI, lpbTypes AS BYTE, BYVAL cCount AS LONG) AS LONG
DECLARE FUNCTION SelectClipPath LIB "GDI32.DLL" ALIAS "SelectClipPath" (BYVAL hdc AS DWORD, BYVAL iMode AS LONG) AS LONG
DECLARE FUNCTION SetArcDirection LIB "GDI32.DLL" ALIAS "SetArcDirection" (BYVAL hdc AS DWORD, BYVAL ArcDirection AS LONG) AS LONG
DECLARE FUNCTION SetMiterLimit LIB "GDI32.DLL" ALIAS "SetMiterLimit" (BYVAL hdc AS DWORD, BYVAL eNewLimit AS DOUBLE, peOldLimit AS DOUBLE) AS LONG
DECLARE FUNCTION StrokeAndFillPath LIB "GDI32.DLL" ALIAS "StrokeAndFillPath" (BYVAL hdc AS DWORD) AS LONG
DECLARE FUNCTION StrokePath LIB "GDI32.DLL" ALIAS "StrokePath" (BYVAL hdc AS DWORD) AS LONG
DECLARE FUNCTION WidenPath LIB "GDI32.DLL" ALIAS "WidenPath" (BYVAL hdc AS DWORD) AS LONG
DECLARE FUNCTION ExtCreatePen LIB "GDI32.DLL" ALIAS "ExtCreatePen" (BYVAL dwPenStyle AS DWORD, BYVAL dwWidth AS DWORD, lplb AS LOGBRUSH, BYVAL dwStyleCount AS DWORD, lpStyle AS DWORD) AS DWORD
DECLARE FUNCTION GetMiterLimit LIB "GDI32.DLL" ALIAS "GetMiterLimit" (BYVAL hdc AS DWORD, peLimit AS DOUBLE) AS LONG
DECLARE FUNCTION GetArcDirection LIB "GDI32.DLL" ALIAS "GetArcDirection" (BYVAL hdc AS DWORD) AS LONG
DECLARE FUNCTION GetObject LIB "GDI32.DLL" ALIAS "GetObjectA" (BYVAL hObject AS DWORD, BYVAL nCount AS LONG, lpObject AS ANY) AS LONG
DECLARE FUNCTION MoveToEx LIB "GDI32.DLL" ALIAS "MoveToEx" (BYVAL hdc AS DWORD, BYVAL x AS LONG, BYVAL y AS LONG, lpPoint AS POINTAPI) AS LONG

FUNCTION MoveTo (BYVAL hDC AS DWORD, BYVAL x AS LONG, BYVAL y AS LONG) AS LONG
    FUNCTION = MoveToEx(hDC, x, y, BYVAL %NULL)
END FUNCTION

DECLARE FUNCTION TextOut LIB "GDI32.DLL" ALIAS "TextOutA" (BYVAL hdc AS DWORD, BYVAL x AS LONG, BYVAL y AS LONG, lpString AS ASCIIZ, BYVAL nCount AS LONG) AS LONG
DECLARE FUNCTION ExtTextOut LIB "GDI32.DLL" ALIAS "ExtTextOutA" (BYVAL hdc AS DWORD, BYVAL x AS LONG, BYVAL y AS LONG, BYVAL dwOptions AS DWORD, lpRect AS RECT, lpString AS ASCIIZ, BYVAL nCount AS DWORD, lpDx AS LONG) AS LONG
DECLARE FUNCTION PolyTextOut LIB "GDI32.DLL" ALIAS "PolyTextOutA" (BYVAL hdc AS DWORD, pptxt AS POLYTEXT, cStrings AS LONG) AS LONG
DECLARE FUNCTION CreatePolygonRgn LIB "GDI32.DLL" ALIAS "CreatePolygonRgn" (lpPoint AS POINTAPI, BYVAL nCount AS LONG, BYVAL nPolyFillMode AS LONG) AS DWORD
DECLARE FUNCTION DPtoLP LIB "GDI32.DLL" ALIAS "DPtoLP" (BYVAL hdc AS DWORD, lpPoint AS POINTAPI, BYVAL nCount AS LONG) AS LONG
DECLARE FUNCTION LPtoDP LIB "GDI32.DLL" ALIAS "LPtoDP" (BYVAL hdc AS DWORD, lpPoint AS POINTAPI, BYVAL nCount AS LONG) AS LONG
DECLARE FUNCTION Polygon LIB "GDI32.DLL" ALIAS "Polygon" (BYVAL hdc AS DWORD, lpPoint AS POINTAPI, BYVAL nCount AS LONG) AS LONG
DECLARE FUNCTION Polyline LIB "GDI32.DLL" ALIAS "Polyline" (BYVAL hdc AS DWORD, lpPoint AS POINTAPI, BYVAL nCount AS LONG) AS LONG
DECLARE FUNCTION PolyBezier LIB "GDI32.DLL" ALIAS "PolyBezier" (BYVAL hdc AS DWORD, lppt AS POINTAPI, BYVAL cPoints AS DWORD) AS LONG
DECLARE FUNCTION PolyBezierTo LIB "GDI32.DLL" ALIAS "PolyBezierTo" (BYVAL hdc AS DWORD, lppt AS POINTAPI, BYVAL cCount AS DWORD) AS LONG
DECLARE FUNCTION PolylineTo LIB "GDI32.DLL" ALIAS "PolylineTo" (BYVAL hdc AS DWORD, lppt AS POINTAPI, BYVAL cCount AS DWORD) AS LONG
DECLARE FUNCTION SetViewportExtEx LIB "GDI32.DLL" ALIAS "SetViewportExtEx" (BYVAL hdc AS DWORD, BYVAL nX AS LONG, BYVAL nY AS LONG, lpSize AS SIZEL) AS LONG
DECLARE FUNCTION SetViewportOrgEx LIB "GDI32.DLL" ALIAS "SetViewportOrgEx" (BYVAL hdc AS DWORD, BYVAL nX AS LONG, BYVAL nY AS LONG, lpPoint AS POINTAPI) AS LONG
DECLARE FUNCTION SetWindowExtEx LIB "GDI32.DLL" ALIAS "SetWindowExtEx" (BYVAL hdc AS DWORD, BYVAL nX AS LONG, BYVAL nY AS LONG, lpSize AS SIZEL) AS LONG
DECLARE FUNCTION SetWindowOrgEx LIB "GDI32.DLL" ALIAS "SetWindowOrgEx" (BYVAL hdc AS DWORD, BYVAL nX AS LONG, BYVAL nY AS LONG, lpPoint AS POINTAPI) AS LONG
DECLARE FUNCTION OffsetViewportOrgEx LIB "GDI32.DLL" ALIAS "OffsetViewportOrgEx" (BYVAL hdc AS DWORD, BYVAL nX AS LONG, BYVAL nY AS LONG, lpPoint AS POINTAPI) AS LONG
DECLARE FUNCTION OffsetWindowOrgEx LIB "GDI32.DLL" ALIAS "OffsetWindowOrgEx" (BYVAL hdc AS DWORD, BYVAL nX AS LONG, BYVAL nY AS LONG, lpPoint AS POINTAPI) AS LONG
DECLARE FUNCTION ScaleViewportExtEx LIB "GDI32.DLL" ALIAS "ScaleViewportExtEx" (BYVAL hdc AS DWORD, BYVAL nXnum AS LONG, BYVAL nXdenom AS LONG, BYVAL nYnum AS LONG, BYVAL nYdenom AS LONG, lpSize AS SIZEL) AS LONG
DECLARE FUNCTION ScaleWindowExtEx LIB "GDI32.DLL" ALIAS "ScaleWindowExtEx" (BYVAL hdc AS DWORD, BYVAL nXnum AS LONG, BYVAL nXdenom AS LONG, BYVAL nYnum AS LONG, BYVAL nYdenom AS LONG, lpSize AS SIZEL) AS LONG
DECLARE FUNCTION SetBitmapDimensionEx LIB "GDI32.DLL" ALIAS "SetBitmapDimensionEx" (BYVAL hbm AS DWORD, BYVAL nX AS LONG, BYVAL nY AS LONG, lpSize AS SIZEL) AS LONG
DECLARE FUNCTION SetBrushOrgEx LIB "GDI32.DLL" ALIAS "SetBrushOrgEx" (BYVAL hdc AS DWORD, BYVAL nXOrg AS LONG, BYVAL nYOrg AS LONG, lppt AS POINTAPI) AS LONG
DECLARE FUNCTION GetTextFace LIB "GDI32.DLL" ALIAS "GetTextFaceA" (BYVAL hdc AS DWORD, BYVAL nCount AS LONG, lpFacename AS ASCIIZ) AS LONG
DECLARE FUNCTION GetKerningPairs LIB "GDI32.DLL" ALIAS "GetKerningPairsA" (BYVAL hdc AS DWORD, BYVAL cPairs AS DWORD, lpkrnpair AS KERNINGPAIR) AS DWORD
DECLARE FUNCTION GetDCOrgEx LIB "GDI32.DLL" ALIAS "GetDCOrgEx" (BYVAL hdc AS DWORD, lpPoint AS POINTAPI) AS LONG
DECLARE FUNCTION FixBrushOrgEx LIB "GDI32.DLL" ALIAS "FixBrushOrgEx" (BYVAL hDC AS DWORD, BYVAL n1 AS LONG, BYVAL n2 AS LONG, lpPoint AS POINTAPI) AS LONG
DECLARE FUNCTION UnrealizeObject LIB "GDI32.DLL" ALIAS "UnrealizeObject" (BYVAL hObject AS DWORD) AS LONG
DECLARE FUNCTION GdiFlush LIB "GDI32.DLL" ALIAS "GdiFlush" () AS LONG
DECLARE FUNCTION GdiSetBatchLimit LIB "GDI32.DLL" ALIAS "GdiSetBatchLimit" (BYVAL dwLimit AS DWORD) AS DWORD
DECLARE FUNCTION GdiGetBatchLimit LIB "GDI32.DLL" ALIAS "GdiGetBatchLimit" () AS DWORD
DECLARE FUNCTION SetICMMode LIB "GDI32.DLL" ALIAS "SetICMMode" (BYVAL hdc AS DWORD, BYVAL n AS LONG) AS LONG
DECLARE FUNCTION CheckColorsInGamut LIB "GDI32.DLL" ALIAS "CheckColorsInGamut" (BYVAL hDC AS DWORD, lpRGBTriples AS ANY, lpBuffer AS ANY, BYVAL nCount AS DWORD) AS LONG
DECLARE FUNCTION GetColorSpace LIB "GDI32.DLL" ALIAS "GetColorSpace" (BYVAL hdc AS DWORD) AS DWORD
DECLARE FUNCTION GetLogColorSpace LIB "GDI32.DLL" ALIAS "GetLogColorSpaceA" (BYVAL hColorSpace AS DWORD, lpBuffer AS LOGCOLORSPACE, BYVAL nSize AS DWORD) AS LONG
DECLARE FUNCTION CreateColorSpace LIB "GDI32.DLL" ALIAS "CreateColorSpaceA" (lpLogColorSpace AS LOGCOLORSPACE) AS DWORD
DECLARE FUNCTION SetColorSpace LIB "GDI32.DLL" ALIAS "SetColorSpace" (BYVAL hdc AS DWORD, BYVAL hColorSpace AS DWORD) AS DWORD
DECLARE FUNCTION DeleteColorSpace LIB "GDI32.DLL" ALIAS "DeleteColorSpace" (BYVAL hColorSpace AS DWORD) AS LONG
DECLARE FUNCTION GetICMProfile LIB "GDI32.DLL" ALIAS "GetICMProfileA" (BYVAL hDC AS DWORD, BYVAL lpcbName AS DWORD, lpszFilename AS ASCIIZ) AS LONG
DECLARE FUNCTION SetICMProfile LIB "GDI32.DLL" ALIAS "SetICMProfileA" (BYVAL hDC AS DWORD, lpFileName AS ASCIIZ) AS LONG
DECLARE FUNCTION GetDeviceGammaRamp LIB "GDI32.DLL" ALIAS "GetDeviceGammaRamp" (BYVAL hDC AS DWORD, lpRamp AS ANY) AS LONG
DECLARE FUNCTION SetDeviceGammaRamp LIB "GDI32.DLL" ALIAS "SetDeviceGammaRamp" (BYVAL hDC AS DWORD, lpRamp AS ANY) AS LONG
DECLARE FUNCTION ColorMatchToTarget LIB "GDI32.DLL" ALIAS "ColorMatchToTarget" (BYVAL hDC AS DWORD, BYVAL hdcTarget AS DWORD, BYVAL uiAction AS DWORD) AS LONG
DECLARE FUNCTION EnumICMProfiles LIB "GDI32.DLL" ALIAS "EnumICMProfilesA" (BYVAL hdc AS DWORD, BYVAL icmEnumProc AS DWORD, BYVAL lParam AS LONG) AS LONG
DECLARE FUNCTION UpdateICMRegKey LIB "GDI32.DLL" ALIAS "UpdateICMRegKey" (BYVAL dwReserved AS DWORD, lpszCMID AS ASCIIZ, lpszFileName AS ASCIIZ, BYVAL nCommand AS DWORD) AS LONG
DECLARE FUNCTION ColorCorrectPalette LIB "GDI32.DLL" ALIAS "ColorCorrectPalette" (BYVAL hDC AS DWORD, BYVAL hPalette AS DWORD, BYVAL dwFirstEntry AS DWORD, BYVAL dwNumOfEntries AS DWORD) AS LONG

' OpenGL wgl declarations

DECLARE FUNCTION wglCopyContext LIB "OPENGL32.DLL" ALIAS "wglCopyContext" (BYVAL hglrcSrc AS DWORD, BYVAL hlglrcDst AS DWORD, BYVAL dMask AS DWORD) AS LONG
DECLARE FUNCTION wglCreateContext LIB "OPENGL32.DLL" ALIAS "wglCreateContext" (BYVAL hdc AS DWORD) AS DWORD
DECLARE FUNCTION wglCreateLayerContext LIB "OPENGL32.DLL" ALIAS "wglCreateLayerContext" (BYVAL hdc AS DWORD, BYVAL iLayerPlane AS LONG) AS DWORD
DECLARE FUNCTION wglDeleteContext LIB "OPENGL32.DLL" ALIAS "wglDeleteContext" (BYVAL hglrc AS DWORD) AS LONG
DECLARE FUNCTION wglGetCurrentContext LIB "OPENGL32.DLL" ALIAS "wglGetCurrentContext" () AS DWORD
DECLARE FUNCTION wglGetCurrentDC LIB "OPENGL32.DLL" ALIAS "wglGetCurrentDC" () AS DWORD
DECLARE FUNCTION wglGetProcAddress LIB "OPENGL32.DLL" ALIAS "wglGetProcAddress" (lpszProc AS ASCIIZ) AS DWORD
DECLARE FUNCTION wglMakeCurrent LIB "OPENGL32.DLL" ALIAS "wglMakeCurrent" (BYVAL hdc AS DWORD, BYVAL hglrc AS DWORD) AS LONG
DECLARE FUNCTION wglShareLists LIB "OPENGL32.DLL" ALIAS "wglShareLists" (BYVAL hglrc1 AS DWORD, BYVAL hglrc2 AS DWORD) AS LONG
DECLARE FUNCTION wglUseFontBitmaps LIB "OPENGL32.DLL" ALIAS "wglUseFontBitmapsA" (BYVAL hdc AS DWORD, BYVAL dFirst AS DWORD, BYVAL dCount AS DWORD, BYVAL dListBase AS DWORD) AS LONG
DECLARE FUNCTION SwapBuffers LIB "OPENGL32.DLL" ALIAS "SwapBuffers" (BYVAL hDC AS DWORD) AS LONG
DECLARE FUNCTION wglUseFontOutlines LIB "OPENGL32.DLL" ALIAS "wglUseFontOutlinesA" (BYVAL hdc AS DWORD, BYVAL dFirst AS DWORD, BYVAL dCount AS DWORD, BYVAL dListBase AS DWORD, BYVAL deviation AS DOUBLE, BYVAL extrusion AS DOUBLE, _
                 BYVAL iFormat AS LONG, BYVAL lpgmf AS DWORD) AS LONG
DECLARE FUNCTION wglDescribeLayerPlane LIB "OPENGL32.DLL" ALIAS "wglDescribeLayerPlane" (BYVAL hdc AS DWORD, BYVAL iPixelFormat AS LONG, BYVAL iLayerPlane AS LONG, BYVAL nBytes AS DWORD, plpd AS LAYERPLANEDESCRIPTOR) AS LONG
DECLARE FUNCTION wglSetLayerPaletteEntries LIB "OPENGL32.DLL" ALIAS "wglSetLayerPaletteEntries" (BYVAL hdc AS DWORD, BYVAL iLayerPlane AS LONG, BYVAL iStart AS LONG, BYVAL cEntries AS LONG, pcr AS DWORD) AS LONG
DECLARE FUNCTION wglGetLayerPaletteEntries LIB "OPENGL32.DLL" ALIAS "wglGetLayerPaletteEntries" (BYVAL hdc AS DWORD, BYVAL iLayerPlane AS LONG, BYVAL iStart AS LONG, BYVAL cEntries AS LONG, pcr AS DWORD) AS LONG
DECLARE FUNCTION wglRealizeLayerPalette LIB "OPENGL32.DLL" ALIAS "wglRealizeLayerPalette" (BYVAL hdc AS DWORD, BYVAL iLayerPlane AS LONG, BYVAL fRealize AS LONG) AS LONG
DECLARE FUNCTION wglSwapLayerBuffers LIB "OPENGL32.DLL" ALIAS "wglSwapLayerBuffers" (BYVAL hdc AS DWORD, BYVAL dfPlanes AS DWORD) AS LONG

#ENDIF ' #IF NOT %DEF(%NOGDI) -------------------------------------------------

' End of declares from wingdi.h ===============================================



' Declares from sensapi.h =====================================================

DECLARE FUNCTION IsDestinationReachable LIB "sensapi.dll" ALIAS "IsDestinationReachableA" (lpszDestination AS ASCIIZ, lpQOCInfo AS QOCINFO) AS LONG
DECLARE FUNCTION IsNetworkAlive LIB "sensapi.dll" ALIAS "IsNetworkAlive" (lpdwFlags AS DWORD) AS LONG

' End of declares from sensapi.h ==============================================



'
'  USER32.DLL Declares
'
DECLARE FUNCTION ActivateKeyboardLayout LIB "USER32.DLL" ALIAS "ActivateKeyboardLayout" (BYVAL HKL AS DWORD, BYVAL flags AS LONG) AS LONG
DECLARE FUNCTION AdjustWindowRect LIB "USER32.DLL" ALIAS "AdjustWindowRect" (lpRect AS RECT, BYVAL dwStyle AS DWORD, BYVAL bMenu AS LONG) AS LONG
DECLARE FUNCTION AdjustWindowRectEx LIB "USER32.DLL" ALIAS "AdjustWindowRectEx" (lpRect AS RECT, BYVAL dsStyle AS LONG, BYVAL bMenu AS LONG, BYVAL dwEsStyle AS DWORD) AS LONG
DECLARE FUNCTION AnyPopup LIB "USER32.DLL" ALIAS "AnyPopup" () AS LONG
DECLARE FUNCTION AppendMenu LIB "USER32.DLL" ALIAS "AppendMenuA" (BYVAL hMenu AS DWORD, BYVAL uFlags AS DWORD, BYVAL uIDNewItem AS DWORD, lpNewItem AS ASCIIZ) AS LONG
DECLARE FUNCTION ArrangeIconicWindows LIB "USER32.DLL" ALIAS "ArrangeIconicWindows" (BYVAL hWnd AS DWORD) AS LONG
DECLARE FUNCTION AttachThreadInput LIB "USER32.DLL" ALIAS "AttachThreadInput" (BYVAL idAttach AS LONG, BYVAL idAttachTo AS LONG, BYVAL fAttach AS LONG) AS LONG
DECLARE FUNCTION BeginDeferWindowPos LIB "USER32.DLL" ALIAS "BeginDeferWindowPos" (BYVAL nNumWindows AS LONG) AS LONG
DECLARE FUNCTION BeginPaint LIB "USER32.DLL" ALIAS "BeginPaint" (BYVAL hWnd AS DWORD, lpPaint AS PAINTSTRUCT) AS LONG
DECLARE FUNCTION BringWindowToTop LIB "USER32.DLL" ALIAS "BringWindowToTop" (BYVAL hWnd AS DWORD) AS LONG
DECLARE FUNCTION BroadcastSystemMessage LIB "USER32.DLL" ALIAS "BroadcastSystemMessage" (BYVAL dwFlags AS DWORD, pdwRecipients AS DWORD, BYVAL uiMessage AS DWORD, BYVAL wParam AS DWORD, BYVAL lParam AS LONG) AS LONG
DECLARE FUNCTION BroadcastSystemMessageA LIB "USER32.DLL" ALIAS "BroadcastSystemMessageA" (BYVAL dwFlags AS DWORD, pdwRecipients AS DWORD, BYVAL uiMessage AS DWORD, BYVAL wParam AS DWORD, BYVAL lParam AS LONG) AS LONG
DECLARE FUNCTION CallMsgFilter LIB "USER32.DLL" ALIAS "CallMsgFilterA" (lpMsg AS tagMSG, BYVAL ncode AS LONG) AS LONG
DECLARE FUNCTION CallNextHookEx LIB "USER32.DLL" ALIAS "CallNextHookEx" (BYVAL hHook AS DWORD, BYVAL ncode AS LONG, BYVAL wParam AS DWORD, lParam AS ANY) AS LONG
DECLARE FUNCTION CallWindowProc LIB "USER32.DLL" ALIAS "CallWindowProcA" (BYVAL lpPrevWndFunc AS DWORD, BYVAL hWnd AS DWORD, BYVAL uMsg AS DWORD, BYVAL wParam AS DWORD, BYVAL lParam AS LONG) AS LONG
DECLARE FUNCTION CascadeWindows LIB "USER32.DLL" ALIAS "CascadeWindows" (BYVAL hwndParent AS DWORD, BYVAL uHow AS DWORD, lpRect AS RECT, BYVAL cKids AS DWORD, lpkids AS DWORD) AS WORD
DECLARE FUNCTION ChangeClipboardChain LIB "USER32.DLL" ALIAS "ChangeClipboardChain" (BYVAL hWnd AS DWORD, BYVAL hWndNext AS DWORD) AS LONG

#IF NOT %DEF(%NOGDI)
  DECLARE FUNCTION ChangeDisplaySettings LIB "USER32.DLL" ALIAS "ChangeDisplaySettingsA" (lpDevMode AS DEVMODE, BYVAL dwFlags AS DWORD) AS LONG
  DECLARE FUNCTION ChangeDisplaySettingsEx LIB "USER32.DLL" ALIAS "ChangeDisplaySettingsExA" (lpszDeviceName AS ASCIIZ, lpDevMode AS DEVMODE, BYVAL hwnd AS DWORD, BYVAL dwFlags AS DWORD, lParam AS VIDEOPARAMETERS) AS LONG
#ENDIF

DECLARE FUNCTION ChangeMenu LIB "USER32.DLL" ALIAS "ChangeMenuA" (BYVAL hMenu AS DWORD, BYVAL cmd AS LONG, lpszNewItem AS ASCIIZ, BYVAL cmdInsert AS LONG, BYVAL flags AS LONG) AS LONG
DECLARE FUNCTION CharLower LIB "USER32.DLL" ALIAS "CharLowerA" (lpsz AS ASCIIZ) AS DWORD
DECLARE FUNCTION CharLowerBuff LIB "USER32.DLL" ALIAS "CharLowerBuffA" (lpsz AS ASCIIZ, BYVAL cchLength AS LONG) AS LONG
DECLARE FUNCTION CharNext LIB "USER32.DLL" ALIAS "CharNextA" (lpsz AS ASCIIZ) AS DWORD
DECLARE FUNCTION CharPrev LIB "USER32.DLL" ALIAS "CharPrevA" (lpszStart AS ASCIIZ, lpszCurrent AS ASCIIZ) AS DWORD
DECLARE FUNCTION CharToOem LIB "USER32.DLL" ALIAS "CharToOemA" (lpszSrc AS ASCIIZ, lpszDst AS ASCIIZ) AS LONG
DECLARE FUNCTION CharToOemBuff LIB "USER32.DLL" ALIAS "CharToOemBuffA" (lpszSrc AS ASCIIZ, lpszDst AS ASCIIZ, BYVAL cchDstLength AS LONG) AS LONG
DECLARE FUNCTION CharUpper LIB "USER32.DLL" ALIAS "CharUpperA" (lpsz AS ASCIIZ) AS DWORD
DECLARE FUNCTION CharUpperBuff LIB "USER32.DLL" ALIAS "CharUpperBuffA" (lpsz AS ASCIIZ, BYVAL cchLength AS LONG) AS LONG
DECLARE FUNCTION CheckDlgButton LIB "USER32.DLL" ALIAS "CheckDlgButton" (BYVAL hDlg AS DWORD, BYVAL nIDButton AS LONG, BYVAL uCheck AS DWORD) AS LONG
DECLARE FUNCTION CheckMenuItem LIB "USER32.DLL" ALIAS "CheckMenuItem" (BYVAL hMenu AS DWORD, BYVAL uIDCheckItem AS DWORD, BYVAL uCheck AS DWORD) AS DWORD
DECLARE FUNCTION CheckMenuRadioItem LIB "USER32.DLL" ALIAS "CheckMenuRadioItem" (BYVAL hMenu AS DWORD, BYVAL idFirst AS DWORD, BYVAL idLast AS DWORD, BYVAL idCheck AS DWORD, BYVAL uFlags AS DWORD) AS LONG
DECLARE FUNCTION CheckRadioButton LIB "USER32.DLL" ALIAS "CheckRadioButton" (BYVAL hDlg AS DWORD, BYVAL nIDFirstButton AS LONG, BYVAL nIDLastButton AS LONG, BYVAL nIDCheckButton AS LONG) AS LONG
DECLARE FUNCTION ChildWindowFromPoint LIB "USER32.DLL" ALIAS "ChildWindowFromPoint" (BYVAL hwndParent AS DWORD, BYVAL x AS LONG, BYVAL y AS LONG) AS DWORD
DECLARE FUNCTION ChildWindowFromPointEx LIB "USER32.DLL" ALIAS "ChildWindowFromPointEx" (BYVAL hWnd AS DWORD, BYVAL x AS LONG, BYVAL y AS LONG, BYVAL uFlags AS DWORD) AS DWORD
DECLARE FUNCTION ClientToScreen LIB "USER32.DLL" ALIAS "ClientToScreen" (BYVAL hWnd AS DWORD, lpPoint AS POINTAPI) AS LONG
DECLARE FUNCTION ClipCursor LIB "USER32.DLL" ALIAS "ClipCursor" (lpRect AS ANY) AS LONG
DECLARE FUNCTION CloseClipboard LIB "USER32.DLL" ALIAS "CloseClipboard" () AS LONG
DECLARE FUNCTION CloseDesktop LIB "USER32.DLL" ALIAS "CloseDesktop" (BYVAL hDesktop AS DWORD) AS LONG
DECLARE FUNCTION CloseWindow LIB "USER32.DLL" ALIAS "CloseWindow" (BYVAL hWnd AS DWORD) AS LONG
DECLARE FUNCTION CloseWindowStation LIB "USER32.DLL" ALIAS "CloseWindowStation" (BYVAL hWinSta AS DWORD) AS LONG
DECLARE FUNCTION CopyAcceleratorTable LIB "USER32.DLL" ALIAS "CopyAcceleratorTableA" (BYVAL hAccelSrc AS DWORD, lpAccelDst AS ACCELAPI, BYVAL cAccelEntries AS LONG) AS LONG
DECLARE FUNCTION CopyCursor LIB "USER32.DLL" ALIAS "CopyCursor" (BYVAL hcur AS DWORD) AS DWORD
DECLARE FUNCTION CopyIcon LIB "USER32.DLL" ALIAS "CopyIcon" (BYVAL hIcon AS DWORD) AS DWORD
DECLARE FUNCTION CopyImage LIB "USER32.DLL" ALIAS "CopyImage" (BYVAL hImage AS DWORD, BYVAL uType AS DWORD, BYVAL cxDesired AS LONG, BYVAL cyDesired AS LONG, BYVAL fuFlags AS DWORD) AS DWORD
DECLARE FUNCTION CopyRect LIB "USER32.DLL" ALIAS "CopyRect" (lpDestRect AS RECT, lpSourceRect AS RECT) AS LONG
DECLARE FUNCTION CountClipboardFormats LIB "USER32.DLL" ALIAS "CountClipboardFormats" () AS LONG
DECLARE FUNCTION CreateAcceleratorTable LIB "USER32.DLL" ALIAS "CreateAcceleratorTableA" (lpaccl AS ACCELAPI, BYVAL cEntries AS LONG) AS LONG
DECLARE FUNCTION CreateCaret LIB "USER32.DLL" ALIAS "CreateCaret" (BYVAL hWnd AS DWORD, BYVAL hBitmap AS DWORD, BYVAL nWidth AS LONG, BYVAL nHeight AS LONG) AS LONG
DECLARE FUNCTION CreateCursor LIB "USER32.DLL" ALIAS "CreateCursor" (BYVAL hInstance AS DWORD, BYVAL nXhotspot AS LONG, BYVAL nYhotspot AS LONG, BYVAL nWidth AS LONG, BYVAL nHeight AS LONG, lpANDbitPlane AS ANY, lpXORbitPlane AS ANY) AS LONG

#IF NOT %DEF(%NOGDI)
  DECLARE FUNCTION CreateDesktop LIB "USER32.DLL" ALIAS "CreateDesktopA" (lpszDesktop AS ASCIIZ, lpszDevice AS ASCIIZ, pDevmode AS DEVMODE, BYVAL dwFlags AS DWORD, BYVAL dwDesiredAccess AS DWORD, lpsa AS SECURITY_ATTRIBUTES) AS LONG
#ENDIF

DECLARE FUNCTION CreateDialogIndirectParam LIB "USER32.DLL" ALIAS "CreateDialogIndirectParamA" (BYVAL hInstance AS DWORD, lpTemplate AS DLGTEMPLATE, BYVAL hWndParent AS DWORD, BYVAL lpDialogFunc AS LONG, BYVAL dwInitParam AS DWORD) AS DWORD

#IF %DEF(%CCWIN)
  FUNCTION CreateDialogIndirect (BYVAL hInstance AS DWORD, lpTemplate AS DLGTEMPLATE, BYVAL hWndParent AS DWORD, BYVAL lpDialogFunc AS LONG) AS LONG
    FUNCTION = CreateDialogIndirectParam(hInstance, lpTemplate, hWndParent, lpDialogFunc, %NULL)
  END FUNCTION
#ENDIF

DECLARE FUNCTION CreateDialogParam LIB "USER32.DLL" ALIAS "CreateDialogParamA" (BYVAL hInstance AS DWORD, lpName AS ASCIIZ, BYVAL hwndParent AS DWORD, BYVAL lpDialogFunc AS LONG, BYVAL lParamInit AS LONG) AS LONG

#IF %DEF(%CCWIN)
  FUNCTION CreateDialog (BYVAL hInstance AS DWORD, lpName AS ASCIIZ, BYVAL hwndParent AS DWORD, BYVAL lpDialogFunc AS LONG) AS LONG
    FUNCTION = CreateDialogParam(hInstance, lpName, hWndParent, lpDialogFunc, %NULL)
  END FUNCTION
#ENDIF

DECLARE FUNCTION CreateIcon LIB "USER32.DLL" ALIAS "CreateIcon" (BYVAL hInstance AS DWORD, BYVAL nWidth AS LONG, BYVAL nHeight AS LONG, BYVAL nPlanes AS BYTE, BYVAL nBitsPixel AS BYTE, lpANDbits AS BYTE, lpXORbits AS BYTE) AS LONG
DECLARE FUNCTION CreateIconFromResource LIB "USER32.DLL" ALIAS "CreateIconFromResource" (presbits AS BYTE, BYVAL dwResSize AS DWORD, BYVAL fIcon AS LONG, BYVAL dwVer AS DWORD) AS LONG
DECLARE FUNCTION CreateIconIndirect LIB "USER32.DLL" ALIAS "CreateIconIndirect" (piconinfo AS ICONINFO) AS LONG
DECLARE FUNCTION CreateMDIWindow LIB "USER32.DLL" ALIAS "CreateMDIWindowA" (lpClassName AS ASCIIZ, lpWindowName AS ASCIIZ, BYVAL dwStyle AS DWORD, BYVAL x AS LONG, BYVAL y AS LONG, BYVAL nWidth AS LONG, BYVAL nHeight AS LONG, _
                 BYVAL hwndParent AS DWORD, BYVAL hInstance AS DWORD, BYVAL lParam AS LONG) AS LONG
DECLARE FUNCTION CreateMenu LIB "USER32.DLL" ALIAS "CreateMenu" () AS LONG
DECLARE FUNCTION CreatePopupMenu LIB "USER32.DLL" ALIAS "CreatePopupMenu" () AS LONG
DECLARE FUNCTION CreateWindowStation LIB "USER32.DLL" ALIAS "CreateWindowStationA" (lpszwinsta AS ASCIIZ, BYVAL dwReserved AS DWORD, BYVAL dwDesiredAccess AS DWORD, lpsa AS SECURITY_ATTRIBUTES) AS DWORD
DECLARE FUNCTION CreateWindowEx LIB "USER32.DLL" ALIAS "CreateWindowExA" (BYVAL dwExStyle AS DWORD, lpClassName AS ASCIIZ, lpWindowName AS ASCIIZ, BYVAL dwStyle AS DWORD, BYVAL x AS LONG, BYVAL y AS LONG, _
    BYVAL nWidth AS LONG, BYVAL nHeight AS LONG, BYVAL hWndParent AS DWORD, BYVAL hMenu AS DWORD, BYVAL hInstance AS DWORD, lpParam AS ANY) AS DWORD

#IF %DEF(%CCWIN)
  FUNCTION CreateWindow (lpClassName AS ASCIIZ, lpWindowName AS ASCIIZ, BYVAL dwStyle AS DWORD, BYVAL xx AS LONG, BYVAL yy AS LONG, BYVAL nWidth AS LONG, _
                         BYVAL nHeight AS LONG, BYVAL hwndParent AS DWORD, BYVAL hMenu AS DWORD, BYVAL hInstance AS DWORD, BYVAL lpParam AS DWORD) AS LONG
    FUNCTION = CreateWindowEx(0, lpClassName, lpWindowName, dwStyle, xx, yy, nWidth, nHeight, hWndParent, hMenu, hInstance, BYVAL lpParam)
  END FUNCTION
#ENDIF

DECLARE FUNCTION DdeAbandonTransaction LIB "USER32.DLL" ALIAS "DdeAbandonTransaction" (BYVAL idInst AS DWORD, BYVAL hConv AS DWORD, BYVAL idTransaction AS DWORD) AS LONG
DECLARE FUNCTION DdeAccessData LIB "USER32.DLL" ALIAS "DdeAccessData" (BYVAL hData AS DWORD, pcbDataSize AS DWORD) AS DWORD
DECLARE FUNCTION DdeAddData LIB "USER32.DLL" ALIAS "DdeAddData" (BYVAL hData AS DWORD, pSrc AS ANY, BYVAL cb AS DWORD, BYVAL cbOff AS DWORD) AS DWORD
DECLARE FUNCTION DdeClientTransaction LIB "USER32.DLL" ALIAS "DdeClientTransaction" (pData AS ANY, BYVAL cbData AS DWORD, BYVAL hConv AS DWORD, BYVAL hszItem AS DWORD, BYVAL uFmt AS DWORD, BYVAL uType AS DWORD, BYVAL dwTimeout AS DWORD, _
                 pdwResult AS DWORD) AS DWORD
DECLARE FUNCTION DdeCmpStringHandles LIB "USER32.DLL" ALIAS "DdeCmpStringHandles" (BYVAL hsz1 AS DWORD, BYVAL hsz2 AS DWORD) AS LONG
DECLARE FUNCTION DdeConnect LIB "USER32.DLL" ALIAS "DdeConnect" (BYVAL idInst AS DWORD, BYVAL hszService AS DWORD, BYVAL hszTopic AS DWORD, pCC AS CONVCONTEXT) AS LONG
DECLARE FUNCTION DdeConnectList LIB "USER32.DLL" ALIAS "DdeConnectList" (BYVAL idInst AS DWORD, BYVAL hszService AS DWORD, BYVAL hszTopic AS DWORD, BYVAL hConvList AS DWORD, pCC AS CONVCONTEXT) AS LONG
DECLARE FUNCTION DdeCreateDataHandle LIB "USER32.DLL" ALIAS "DdeCreateDataHandle" (BYVAL idInst AS DWORD, pSrc AS ANY, BYVAL cb AS DWORD, BYVAL cbOff AS DWORD, BYVAL hszItem AS DWORD, BYVAL wFmt AS DWORD, BYVAL afCmd AS DWORD) AS DWORD
DECLARE FUNCTION DdeCreateStringHandle LIB "USER32.DLL" ALIAS "DdeCreateStringHandleA" (BYVAL idInst AS DWORD, psz AS ASCIIZ, BYVAL iCodePage AS LONG) AS DWORD
DECLARE FUNCTION DdeDisconnect LIB "USER32.DLL" ALIAS "DdeDisconnect" (BYVAL hConv AS DWORD) AS LONG
DECLARE FUNCTION DdeDisconnectList LIB "USER32.DLL" ALIAS "DdeDisconnectList" (BYVAL hConvList AS DWORD) AS LONG
DECLARE FUNCTION DdeEnableCallback LIB "USER32.DLL" ALIAS "DdeEnableCallback" (BYVAL idInst AS DWORD, BYVAL hConv AS DWORD, BYVAL wCmd AS DWORD) AS LONG
DECLARE FUNCTION DdeFreeDataHandle LIB "USER32.DLL" ALIAS "DdeFreeDataHandle" (BYVAL hData AS DWORD) AS LONG
DECLARE FUNCTION DdeFreeStringHandle LIB "USER32.DLL" ALIAS "DdeFreeStringHandle" (BYVAL idInst AS DWORD, BYVAL hsz AS DWORD) AS LONG
DECLARE FUNCTION DdeGetData LIB "USER32.DLL" ALIAS "DdeGetData" (BYVAL hData AS DWORD, pDst AS ANY, BYVAL cbMax AS DWORD, BYVAL cbOff AS DWORD) AS DWORD
DECLARE FUNCTION DdeGetLastError LIB "USER32.DLL" ALIAS "DdeGetLastError" (BYVAL idInst AS DWORD) AS LONG
DECLARE FUNCTION DdeImpersonateClient LIB "USER32.DLL" ALIAS "DdeImpersonateClient" (BYVAL hConv AS DWORD) AS LONG
DECLARE FUNCTION DdeInitialize LIB "USER32.DLL" ALIAS "DdeInitializeA" (pidInst AS DWORD, BYVAL pfnCallback AS DWORD, BYVAL afCmd AS DWORD, BYVAL ulRes AS DWORD) AS DWORD
DECLARE FUNCTION DdeKeepStringHandle LIB "USER32.DLL" ALIAS "DdeKeepStringHandle" (BYVAL idInst AS DWORD, BYVAL hsz AS DWORD) AS LONG
DECLARE FUNCTION DdeNameService LIB "USER32.DLL" ALIAS "DdeNameService" (BYVAL idInst AS DWORD, BYVAL hsz1 AS DWORD, BYVAL hsz2 AS DWORD, BYVAL afCmd AS LONG) AS LONG
DECLARE FUNCTION DdePostAdvise LIB "USER32.DLL" ALIAS "DdePostAdvise" (BYVAL idInst AS DWORD, BYVAL hszTopic AS DWORD, BYVAL hszItem AS DWORD) AS LONG
DECLARE FUNCTION DdeQueryConvInfo LIB "USER32.DLL" ALIAS "DdeQueryConvInfo" (BYVAL hConv AS DWORD, BYVAL idTransaction AS DWORD, pConvInfo AS CONVINFO) AS LONG
DECLARE FUNCTION DdeQueryNextServer LIB "USER32.DLL" ALIAS "DdeQueryNextServer" (BYVAL hConvList AS DWORD, BYVAL hConvPrev AS DWORD) AS LONG
DECLARE FUNCTION DdeQueryString LIB "USER32.DLL" ALIAS "DdeQueryStringA" (BYVAL idInst AS DWORD, BYVAL hsz AS DWORD, psz AS ASCIIZ, BYVAL cchMax AS LONG, BYVAL iCodePage AS LONG) AS LONG
DECLARE FUNCTION DdeReconnect LIB "USER32.DLL" ALIAS "DdeReconnect" (BYVAL hConv AS DWORD) AS LONG
DECLARE FUNCTION DdeSetQualityOfService LIB "USER32.DLL" ALIAS "DdeSetQualityOfService" (BYVAL hWndClient AS DWORD, pqosNew AS SECURITY_QUALITY_OF_SERVICE, pqosPrev AS SECURITY_QUALITY_OF_SERVICE) AS LONG
DECLARE FUNCTION DdeSetUserHandle LIB "USER32.DLL" ALIAS "DdeSetUserHandle" (BYVAL hConv AS DWORD, BYVAL id AS DWORD, BYVAL hUser AS DWORD) AS LONG
DECLARE FUNCTION DdeUnaccessData LIB "USER32.DLL" ALIAS "DdeUnaccessData" (BYVAL hData AS DWORD) AS LONG
DECLARE FUNCTION DdeUninitialize LIB "USER32.DLL" ALIAS "DdeUninitialize" (BYVAL idInst AS DWORD) AS LONG
DECLARE FUNCTION DefDlgProc LIB "USER32.DLL" ALIAS "DefDlgProcA" (BYVAL hDlg AS DWORD, BYVAL uMsg AS DWORD, BYVAL wParam AS DWORD, BYVAL lParam AS LONG) AS LONG
DECLARE FUNCTION DefFrameProc LIB "USER32.DLL" ALIAS "DefFrameProcA" (BYVAL hWnd AS DWORD, BYVAL hWndMDIClient AS DWORD, BYVAL uMsg AS DWORD, BYVAL wParam AS DWORD, BYVAL lParam AS LONG) AS LONG
DECLARE FUNCTION DefMDIChildProc LIB "USER32.DLL" ALIAS "DefMDIChildProcA" (BYVAL hWnd AS DWORD, BYVAL uMsg AS DWORD, BYVAL wParam AS DWORD, BYVAL lParam AS LONG) AS LONG
DECLARE FUNCTION DefWindowProc LIB "USER32.DLL" ALIAS "DefWindowProcA" (BYVAL hWnd AS DWORD, BYVAL uMsg AS DWORD, BYVAL wParam AS DWORD, BYVAL lParam AS LONG) AS LONG
DECLARE FUNCTION DeferWindowPos LIB "USER32.DLL" ALIAS "DeferWindowPos" (BYVAL hWinPosInfo AS DWORD, BYVAL hWnd AS DWORD, BYVAL hWndInsertAfter AS DWORD, BYVAL x AS LONG, BYVAL y AS LONG, BYVAL cx AS LONG, BYVAL cy AS LONG, _
                 BYVAL wFlags AS DWORD) AS LONG
DECLARE FUNCTION DeleteMenu LIB "USER32.DLL" ALIAS "DeleteMenu" (BYVAL hMenu AS DWORD, BYVAL nPosition AS LONG, BYVAL wFlags AS DWORD) AS LONG
DECLARE FUNCTION DestroyAcceleratorTable LIB "USER32.DLL" ALIAS "DestroyAcceleratorTable" (BYVAL hAccel AS DWORD) AS LONG
DECLARE FUNCTION DestroyCaret LIB "USER32.DLL" ALIAS "DestroyCaret" () AS LONG
DECLARE FUNCTION DestroyCursor LIB "USER32.DLL" ALIAS "DestroyCursor" (BYVAL hCursor AS DWORD) AS LONG
DECLARE FUNCTION DestroyIcon LIB "USER32.DLL" ALIAS "DestroyIcon" (BYVAL hIcon AS DWORD) AS LONG
DECLARE FUNCTION DestroyMenu LIB "USER32.DLL" ALIAS "DestroyMenu" (BYVAL hMenu AS DWORD) AS LONG
DECLARE FUNCTION DestroyWindow LIB "USER32.DLL" ALIAS "DestroyWindow" (BYVAL hWnd AS DWORD) AS LONG
DECLARE FUNCTION DialogBoxParam LIB "USER32.DLL" ALIAS "DialogBoxParamA" (BYVAL hInstance AS DWORD, lpTemplateName AS ASCIIZ, BYVAL hwndParent AS DWORD, BYVAL lpDialogFunc AS LONG, BYVAL dwInitParam AS DWORD) AS LONG

#IF %DEF(%CCWIN)
  FUNCTION DialogBox (BYVAL hInstance AS DWORD, lpTemplateName AS ASCIIZ, BYVAL hwndParent AS DWORD, BYVAL lpDialogFunc AS LONG) AS LONG
    FUNCTION = DialogBoxParam(hInstance, lpTemplateName, hWndParent, lpDialogFunc, 0)
  END FUNCTION
#ENDIF

DECLARE FUNCTION DialogBoxIndirectParam LIB "USER32.DLL" ALIAS "DialogBoxIndirectParamA" (BYVAL hInstance AS DWORD, hDialogTemplate AS DLGTEMPLATE, BYVAL hwndParent AS DWORD, BYVAL lpDialogFunc AS LONG, BYVAL dwInitParam AS DWORD) AS LONG

#IF %DEF(%CCWIN)
  FUNCTION DialogBoxIndirect (BYVAL hInstance AS DWORD, hDialogTemplate AS DLGTEMPLATE, BYVAL hWndParent AS DWORD, BYVAL lpDialogFunc AS LONG) AS LONG
    FUNCTION = DialogBoxIndirectParam(hInstance, hDialogTemplate, hWndParent, lpDialogFunc, 0)
  END FUNCTION
#ENDIF

DECLARE FUNCTION DispatchMessage LIB "USER32.DLL" ALIAS "DispatchMessageA" (lpMsg AS tagMSG) AS LONG
DECLARE FUNCTION DlgDirList LIB "USER32.DLL" ALIAS "DlgDirListA" (BYVAL hDlg AS DWORD, lpPathSpec AS ASCIIZ, BYVAL nIDListBox AS LONG, BYVAL nIDStaticPath AS LONG, BYVAL uFileType AS DWORD) AS LONG
DECLARE FUNCTION DlgDirListComboBox LIB "USER32.DLL" ALIAS "DlgDirListComboBoxA" (BYVAL hDlg AS DWORD, lpPathSpec AS ASCIIZ, BYVAL nIDComboBox AS LONG, BYVAL nIDStaticPath AS LONG, BYVAL uFileType AS DWORD) AS LONG
DECLARE FUNCTION DlgDirSelectComboBoxEx LIB "USER32.DLL" ALIAS "DlgDirSelectComboBoxExA" (BYVAL hWndDlg AS DWORD, lpszPath AS ASCIIZ, BYVAL cbPath AS LONG, BYVAL idComboBox AS LONG) AS LONG
DECLARE FUNCTION DlgDirSelectEx LIB "USER32.DLL" ALIAS "DlgDirSelectExA" (BYVAL hWndDlg AS DWORD, lpszPath AS ASCIIZ, BYVAL cbPath AS LONG, BYVAL idListBox AS LONG) AS LONG
DECLARE FUNCTION DragDetect LIB "USER32.DLL" ALIAS "DragDetect" (BYVAL hWnd AS DWORD, pt AS POINTAPI) AS LONG
DECLARE FUNCTION DrawAnimatedRects LIB "USER32.DLL" ALIAS "DrawAnimatedRects" (BYVAL hWnd AS DWORD, BYVAL idAni AS LONG, lprcFrom AS RECT, lprcTo AS RECT) AS LONG
DECLARE FUNCTION DrawCaption LIB "USER32.DLL" ALIAS "DrawCaption" (BYVAL hWnd AS DWORD, BYVAL hDC AS DWORD, pcRect AS RECT, BYVAL uFlags AS DWORD) AS LONG
DECLARE FUNCTION DrawEdge LIB "USER32.DLL" ALIAS "DrawEdge" (BYVAL hDC AS DWORD, qrc AS RECT, BYVAL edge AS LONG, BYVAL grfFlags AS LONG) AS LONG
DECLARE FUNCTION DrawFocusRect LIB "USER32.DLL" ALIAS "DrawFocusRect" (BYVAL hDC AS DWORD, lpRect AS RECT) AS LONG
DECLARE FUNCTION DrawFrameControl LIB "USER32.DLL" ALIAS "DrawFrameControl" (BYVAL hDC AS DWORD, lpRect AS RECT, BYVAL un1 AS LONG, BYVAL un2 AS LONG) AS LONG
DECLARE FUNCTION DrawIcon LIB "USER32.DLL" ALIAS "DrawIcon" (BYVAL hDC AS DWORD, BYVAL x AS LONG, BYVAL y AS LONG, BYVAL hIcon AS DWORD) AS LONG
DECLARE FUNCTION DrawIconEx LIB "USER32.DLL" ALIAS "DrawIconEx" (BYVAL hDC AS DWORD, BYVAL xLeft AS LONG, BYVAL yTop AS LONG, BYVAL hIcon AS DWORD, BYVAL cxWidth AS LONG, BYVAL cyWidth AS LONG, BYVAL istepIfAniCur AS LONG, _
                 BYVAL hbrFlickerFreeDraw AS DWORD, BYVAL diFlags AS LONG) AS LONG
DECLARE FUNCTION DrawMenuBar LIB "USER32.DLL" ALIAS "DrawMenuBar" (BYVAL hWnd AS DWORD) AS LONG
DECLARE FUNCTION DrawState LIB "USER32.DLL" ALIAS "DrawStateA" (BYVAL hDC AS DWORD, BYVAL hBrush AS DWORD, BYVAL lpDrawStateProc AS DWORD, BYVAL lParam AS LONG, BYVAL wParam AS DWORD, BYVAL x AS LONG, BYVAL y AS LONG, BYVAL cx AS LONG, _
                 BYVAL cy AS LONG, BYVAL fuFlags AS DWORD) AS LONG
DECLARE FUNCTION DrawText LIB "USER32.DLL" ALIAS "DrawTextA" (BYVAL hDC AS DWORD, lpStr AS ASCIIZ, BYVAL nCount AS LONG, lpRect AS RECT, BYVAL uFormat AS DWORD) AS LONG
DECLARE FUNCTION DrawTextEx LIB "USER32.DLL" ALIAS "DrawTextExA" (BYVAL hDC AS DWORD, lpsz AS ASCIIZ, BYVAL n AS LONG, lpRect AS RECT, BYVAL dwDTFormat AS DWORD, lpDrawTextParams AS DRAWTEXTPARAMS) AS LONG
DECLARE FUNCTION EmptyClipboard LIB "USER32.DLL" ALIAS "EmptyClipboard" () AS LONG
DECLARE FUNCTION EnableMenuItem LIB "USER32.DLL" ALIAS "EnableMenuItem" (BYVAL hMenu AS DWORD, BYVAL uIDEnableItem AS DWORD, BYVAL uEnable AS DWORD) AS LONG
DECLARE FUNCTION EnableScrollBar LIB "USER32.DLL" ALIAS "EnableScrollBar" (BYVAL hWnd AS DWORD, BYVAL uSBflags AS DWORD, BYVAL uArrows AS DWORD) AS LONG
DECLARE FUNCTION EnableWindow LIB "USER32.DLL" ALIAS "EnableWindow" (BYVAL hWnd AS DWORD, BYVAL fEnable AS LONG) AS LONG
DECLARE FUNCTION EndDeferWindowPos LIB "USER32.DLL" ALIAS "EndDeferWindowPos" (BYVAL hWinPosInfo AS DWORD) AS LONG
DECLARE FUNCTION EndDialog LIB "USER32.DLL" ALIAS "EndDialog" (BYVAL hDlg AS DWORD, BYVAL nResult AS LONG) AS LONG
DECLARE FUNCTION EndPaint LIB "USER32.DLL" ALIAS "EndPaint" (BYVAL hWnd AS DWORD, lpPaint AS PAINTSTRUCT) AS LONG
DECLARE FUNCTION EnumChildWindows LIB "USER32.DLL" ALIAS "EnumChildWindows" (BYVAL hwndParent AS DWORD, BYVAL lpEnumFunc AS LONG, BYVAL lParam AS LONG) AS LONG
DECLARE FUNCTION EnumClipboardFormats LIB "USER32.DLL" ALIAS "EnumClipboardFormats" (BYVAL uFormat AS DWORD) AS DWORD
DECLARE FUNCTION EnumDesktopWindows LIB "USER32.DLL" ALIAS "EnumDesktopWindows" (BYVAL hDesktop AS DWORD, BYVAL lpfn AS LONG, BYVAL lParam AS LONG) AS LONG
DECLARE FUNCTION EnumDesktops LIB "USER32.DLL" ALIAS "EnumDesktopsA" (BYVAL hWinSta AS DWORD, BYVAL lpEnumFunc AS LONG, BYVAL lParam AS LONG) AS LONG
DECLARE FUNCTION EnumDisplayDevices LIB "USER32.DLL" ALIAS "EnumDisplayDevicesA" (lpszDevice AS ASCIIZ, BYVAL iDevNum AS DWORD, lpDisplayDevice AS DISPLAY_DEVICE, BYVAL dwFlags AS DWORD) AS LONG
DECLARE FUNCTION EnumDisplayMonitors LIB "USER32.DLL" ALIAS "EnumDisplayMonitors" (BYVAL hdc AS DWORD, lprcClip AS RECT, lpfnEnum AS DWORD, BYVAL dwData AS LONG) AS LONG

#IF NOT %DEF(%NOGDI)
  DECLARE FUNCTION EnumDisplaySettings LIB "USER32.DLL" ALIAS "EnumDisplaySettingsA" (lpszDeviceName AS ASCIIZ, BYVAL iModeNum AS DWORD, lpDevMode AS DEVMODE) AS LONG
  DECLARE FUNCTION EnumDisplaySettingsEx LIB "USER32.DLL" ALIAS "EnumDisplaySettingsExA" (lpszDeviceName AS ASCIIZ, BYVAL iModeNum AS DWORD, lpDevMode AS DEVMODE, BYVAL dwFlags AS DWORD) AS LONG
#ENDIF

DECLARE FUNCTION EnumProps LIB "USER32.DLL" ALIAS "EnumPropsA" (BYVAL hWnd AS DWORD, BYVAL lpEnumFunc AS LONG) AS LONG
DECLARE FUNCTION EnumPropsEx LIB "USER32.DLL" ALIAS "EnumPropsExA" (BYVAL hWnd AS DWORD, BYVAL lpEnumFunc AS LONG, BYVAL lParam AS LONG) AS LONG
DECLARE FUNCTION EnumThreadWindows LIB "USER32.DLL" ALIAS "EnumThreadWindows" (BYVAL dwThreadId AS DWORD, BYVAL lpfn AS LONG, BYVAL lParam AS LONG) AS LONG
DECLARE FUNCTION EnumWindows LIB "USER32.DLL" ALIAS "EnumWindows" (BYVAL lpEnumFunc AS LONG, BYVAL lParam AS LONG) AS LONG
DECLARE FUNCTION EnumWindowStations LIB "USER32.DLL" ALIAS "EnumWindowStationsA" (BYVAL lpEnumFunc AS LONG, BYVAL lParam AS LONG) AS LONG
DECLARE FUNCTION EqualRect LIB "USER32.DLL" ALIAS "EqualRect" (lpRect1 AS RECT, lpRect2 AS RECT) AS LONG
DECLARE FUNCTION ExcludeUpdateRgn LIB "USER32.DLL" ALIAS "ExcludeUpdateRgn" (BYVAL hDC AS DWORD, BYVAL hWnd AS DWORD) AS LONG
DECLARE FUNCTION ExitWindows LIB "USER32.DLL" ALIAS "ExitWindows" (BYVAL dwReserved AS DWORD, BYVAL uReturnCode AS DWORD) AS LONG
DECLARE FUNCTION ExitWindowsEx LIB "USER32.DLL" ALIAS "ExitWindowsEx" (BYVAL uFlags AS DWORD, BYVAL dwReserved AS DWORD) AS LONG
DECLARE FUNCTION FillRect LIB "USER32.DLL" ALIAS "FillRect" (BYVAL hDC AS DWORD, lpRect AS RECT, BYVAL hBrush AS DWORD) AS LONG
DECLARE FUNCTION FindWindow LIB "USER32.DLL" ALIAS "FindWindowA" (lpClassName AS ASCIIZ, lpWindowName AS ASCIIZ) AS LONG
DECLARE FUNCTION FindWindowEx LIB "USER32.DLL" ALIAS "FindWindowExA" (BYVAL hWnd1 AS LONG, BYVAL hWnd2 AS LONG, lpsz1 AS ASCIIZ, lpsz2 AS ASCIIZ) AS LONG
DECLARE FUNCTION FlashWindow LIB "USER32.DLL" ALIAS "FlashWindow" (BYVAL hWnd AS DWORD, BYVAL bInvert AS LONG) AS LONG
DECLARE FUNCTION FrameRect LIB "USER32.DLL" ALIAS "FrameRect" (BYVAL hDC AS DWORD, lpRect AS RECT, BYVAL hBrush AS DWORD) AS LONG
DECLARE FUNCTION FreeDDElParam LIB "USER32.DLL" ALIAS "FreeDDElParam" (BYVAL msg AS LONG, BYVAL lParam AS LONG) AS LONG
DECLARE FUNCTION GetActiveWindow LIB "USER32.DLL" ALIAS "GetActiveWindow" () AS LONG
DECLARE FUNCTION GetAncestor LIB "USER32.DLL" ALIAS "GetAncestor" (BYVAL hwnd AS DWORD, BYVAL gaFlags AS DWORD) AS DWORD
DECLARE FUNCTION GetAsyncKeyState LIB "USER32.DLL" ALIAS "GetAsyncKeyState" (BYVAL vKey AS LONG) AS INTEGER
DECLARE FUNCTION GetCapture LIB "USER32.DLL" ALIAS "GetCapture" () AS LONG
DECLARE FUNCTION GetCaretBlinkTime LIB "USER32.DLL" ALIAS "GetCaretBlinkTime" () AS LONG
DECLARE FUNCTION GetCaretPos LIB "USER32.DLL" ALIAS "GetCaretPos" (lpPoint AS POINTAPI) AS LONG
DECLARE FUNCTION GetClassInfo LIB "USER32.DLL" ALIAS "GetClassInfoA" (BYVAL hInstance AS DWORD, lpClassName AS ASCIIZ, lpWndClass AS WNDCLASS) AS LONG
DECLARE FUNCTION GetClassInfoEx LIB "USER32.DLL" ALIAS "GetClassInfoExA" (BYVAL hInst AS DWORD, lpszClass AS ASCIIZ, lpWndClass AS WNDCLASSEX) AS LONG
DECLARE FUNCTION GetClassLong LIB "USER32.DLL" ALIAS "GetClassLongA" (BYVAL hwnd AS DWORD, BYVAL nIndex AS LONG) AS LONG
DECLARE FUNCTION GetClassName LIB "USER32.DLL" ALIAS "GetClassNameA" (BYVAL hwnd AS DWORD, lpClassName AS ASCIIZ, BYVAL nMaxCount AS LONG) AS LONG
DECLARE FUNCTION GetClassWord LIB "USER32.DLL" ALIAS "GetClassWord" (BYVAL hwnd AS DWORD, BYVAL nIndex AS LONG) AS LONG
DECLARE FUNCTION GetClientRect LIB "USER32.DLL" ALIAS "GetClientRect" (BYVAL hwnd AS DWORD, lpRect AS RECT) AS LONG
DECLARE FUNCTION GetClipCursor LIB "USER32.DLL" ALIAS "GetClipCursor" (lprc AS RECT) AS LONG
DECLARE FUNCTION GetClipboardData LIB "USER32.DLL" ALIAS "GetClipboardData" (BYVAL uFormat AS DWORD) AS DWORD
DECLARE FUNCTION GetClipboardFormatName LIB "USER32.DLL" ALIAS "GetClipboardFormatNameA" (BYVAL uFormat AS DWORD, lpString AS ASCIIZ, BYVAL nMaxCount AS LONG) AS LONG
DECLARE FUNCTION GetClipboardOwner LIB "USER32.DLL" ALIAS "GetClipboardOwner" () AS LONG
DECLARE FUNCTION GetClipboardViewer LIB "USER32.DLL" ALIAS "GetClipboardViewer" () AS LONG
DECLARE FUNCTION GetCursor LIB "USER32.DLL" ALIAS "GetCursor" () AS LONG
DECLARE FUNCTION GetCursorPos LIB "USER32.DLL" ALIAS "GetCursorPos" (lpPoint AS POINTAPI) AS LONG
DECLARE FUNCTION GetDC LIB "USER32.DLL" ALIAS "GetDC" (BYVAL hWnd AS DWORD) AS LONG
DECLARE FUNCTION GetDCEx LIB "USER32.DLL" ALIAS "GetDCEx" (BYVAL hWnd AS DWORD, BYVAL hRgnClip AS DWORD, BYVAL fdwOptions AS DWORD) AS LONG
DECLARE FUNCTION GetDesktopWindow LIB "USER32.DLL" ALIAS "GetDesktopWindow" () AS LONG
DECLARE FUNCTION GetDialogBaseUnits LIB "USER32.DLL" ALIAS "GetDialogBaseUnits" () AS LONG
DECLARE FUNCTION GetDlgCtrlID LIB "USER32.DLL" ALIAS "GetDlgCtrlID" (BYVAL hWnd AS DWORD) AS LONG
DECLARE FUNCTION GetDlgItem LIB "USER32.DLL" ALIAS "GetDlgItem" (BYVAL hDlg AS DWORD, BYVAL nIDDlgItem AS LONG) AS LONG
DECLARE FUNCTION GetDlgItemInt LIB "USER32.DLL" ALIAS "GetDlgItemInt" (BYVAL hDlg AS DWORD, BYVAL nIDDlgItem AS LONG, BYVAL lpTranslated AS LONG, BYVAL bSigned AS LONG) AS LONG
DECLARE FUNCTION GetDlgItemText LIB "USER32.DLL" ALIAS "GetDlgItemTextA" (BYVAL hDlg AS DWORD, BYVAL nIDDlgItem AS LONG, lpString AS ASCIIZ, BYVAL nMaxCount AS LONG) AS LONG
DECLARE FUNCTION GetDoubleClickTime LIB "USER32.DLL" ALIAS "GetDoubleClickTime" () AS DWORD
DECLARE FUNCTION GetFocus LIB "USER32.DLL" ALIAS "GetFocus" () AS DWORD
DECLARE FUNCTION GetForegroundWindow LIB "USER32.DLL" ALIAS "GetForegroundWindow" () AS DWORD
DECLARE FUNCTION GetIconInfo LIB "USER32.DLL" ALIAS "GetIconInfo" (BYVAL hIcon AS DWORD, piconinfo AS ICONINFO) AS LONG
DECLARE FUNCTION GetInputState LIB "USER32.DLL" ALIAS "GetInputState" () AS LONG
DECLARE FUNCTION GetKBCodePage LIB "USER32.DLL" ALIAS "GetKBCodePage" () AS LONG
DECLARE FUNCTION GetKeyNameText LIB "USER32.DLL" ALIAS "GetKeyNameTextA" (BYVAL lParam AS LONG, lpBuffer AS ASCIIZ, BYVAL nSize AS DWORD) AS LONG
DECLARE FUNCTION GetKeyState LIB "USER32.DLL" ALIAS "GetKeyState" (BYVAL nVirtKey AS LONG) AS INTEGER
DECLARE FUNCTION GetKeyboardLayout LIB "USER32.DLL" ALIAS "GetKeyboardLayout" (BYVAL dwLayout AS DWORD) AS LONG
DECLARE FUNCTION GetKeyboardLayoutList LIB "USER32.DLL" ALIAS "GetKeyboardLayoutList" (BYVAL nBuff AS LONG, lpList AS LONG) AS LONG
DECLARE FUNCTION GetKeyboardLayoutName LIB "USER32.DLL" ALIAS "GetKeyboardLayoutNameA" (pwszKLID AS ASCIIZ) AS LONG
DECLARE FUNCTION GetKeyboardState LIB "USER32.DLL" ALIAS "GetKeyboardState" (pbKeyState AS BYTE) AS LONG
DECLARE FUNCTION GetKeyboardType LIB "USER32.DLL" ALIAS "GetKeyboardType" (BYVAL nTypeFlag AS LONG) AS LONG
DECLARE FUNCTION GetLastActivePopup LIB "USER32.DLL" ALIAS "GetLastActivePopup" (BYVAL hWndOwner AS DWORD) AS LONG
DECLARE FUNCTION GetMenu LIB "USER32.DLL" ALIAS "GetMenu" (BYVAL hWnd AS DWORD) AS LONG
DECLARE FUNCTION GetMenuCheckMarkDimensions LIB "USER32.DLL" ALIAS "GetMenuCheckMarkDimensions" () AS LONG
DECLARE FUNCTION GetMenuContextHelpId LIB "USER32.DLL" ALIAS "GetMenuContextHelpId" (BYVAL hMenu AS DWORD) AS LONG
DECLARE FUNCTION GetMenuDefaultItem LIB "USER32.DLL" ALIAS "GetMenuDefaultItem" (BYVAL hMenu AS DWORD, BYVAL fByPos AS LONG, BYVAL gmdiFlags AS LONG) AS LONG
DECLARE FUNCTION GetMenuItemCount LIB "USER32.DLL" ALIAS "GetMenuItemCount" (BYVAL hMenu AS DWORD) AS LONG
DECLARE FUNCTION GetMenuItemID LIB "USER32.DLL" ALIAS "GetMenuItemID" (BYVAL hMenu AS DWORD, BYVAL nPos AS LONG) AS LONG
DECLARE FUNCTION GetMenuItemInfo LIB "USER32.DLL" ALIAS "GetMenuItemInfoA" (BYVAL hMenu AS DWORD, BYVAL uItem AS DWORD, BYVAL fByPosition AS LONG, lpMenuItemInfo AS MENUITEMINFO) AS LONG
DECLARE FUNCTION GetMenuItemRect LIB "USER32.DLL" ALIAS "GetMenuItemRect" (BYVAL hWnd AS DWORD, BYVAL hMenu AS DWORD, BYVAL uItem AS DWORD, lprcItem AS RECT) AS LONG
DECLARE FUNCTION GetMenuState LIB "USER32.DLL" ALIAS "GetMenuState" (BYVAL hMenu AS DWORD, BYVAL dwID AS DWORD, BYVAL dwFlags AS DWORD) AS DWORD
DECLARE FUNCTION GetMenuString LIB "USER32.DLL" ALIAS "GetMenuStringA" (BYVAL hMenu AS DWORD, BYVAL uIDItem AS DWORD, lpString AS ASCIIZ, BYVAL nMaxCount AS LONG, BYVAL uFlag AS DWORD) AS LONG
DECLARE FUNCTION GetMessage LIB "USER32.DLL" ALIAS "GetMessageA" (lpMsg AS tagMSG, BYVAL hWnd AS DWORD, BYVAL uMsgFilterMin AS DWORD, BYVAL uMsgFilterMax AS DWORD) AS LONG
DECLARE FUNCTION GetMessageExtraInfo LIB "USER32.DLL" ALIAS "GetMessageExtraInfo" () AS LONG
DECLARE FUNCTION GetMessagePos LIB "USER32.DLL" ALIAS "GetMessagePos" () AS LONG
DECLARE FUNCTION GetMessageTime LIB "USER32.DLL" ALIAS "GetMessageTime" () AS LONG
DECLARE FUNCTION GetMonitorInfo LIB "USER32.DLL" ALIAS "GetMonitorInfoA" (BYVAL hMonitor AS DWORD, lpmi AS MONITORINFO) AS LONG
DECLARE FUNCTION GetNextDlgGroupItem LIB "USER32.DLL" ALIAS "GetNextDlgGroupItem" (BYVAL hDlg AS DWORD, BYVAL hCtl AS DWORD, BYVAL bPrevious AS LONG) AS LONG
DECLARE FUNCTION GetNextDlgTabItem LIB "USER32.DLL" ALIAS "GetNextDlgTabItem" (BYVAL hDlg AS DWORD, BYVAL hCtl AS DWORD, BYVAL bPrevious AS LONG) AS LONG
DECLARE FUNCTION GetOpenClipboardWindow LIB "USER32.DLL" ALIAS "GetOpenClipboardWindow" () AS LONG
DECLARE FUNCTION GetParent LIB "USER32.DLL" ALIAS "GetParent" (BYVAL hWnd AS DWORD) AS LONG
DECLARE FUNCTION GetPriorityClipboardFormat LIB "USER32.DLL" ALIAS "GetPriorityClipboardFormat" (lpPriorityList AS LONG, BYVAL nCount AS LONG) AS LONG
DECLARE FUNCTION GetProcessWindowStation LIB "USER32.DLL" ALIAS "GetProcessWindowStation" () AS LONG
DECLARE FUNCTION GetProp LIB "USER32.DLL" ALIAS "GetPropA" (BYVAL hWnd AS DWORD, lpString AS ASCIIZ) AS LONG
DECLARE FUNCTION GetQueueStatus LIB "USER32.DLL" ALIAS "GetQueueStatus" (BYVAL fuFlags AS LONG) AS LONG
DECLARE FUNCTION GetScrollInfo LIB "USER32.DLL" ALIAS "GetScrollInfo" (BYVAL hWnd AS DWORD, BYVAL n AS LONG, lpScrollInfo AS SCROLLINFO) AS LONG
DECLARE FUNCTION GetScrollPos LIB "USER32.DLL" ALIAS "GetScrollPos" (BYVAL hWnd AS DWORD, BYVAL nBar AS LONG) AS LONG
DECLARE FUNCTION GetScrollRange LIB "USER32.DLL" ALIAS "GetScrollRange" (BYVAL hWnd AS DWORD, BYVAL nBar AS LONG, lpMinPos AS LONG, lpMaxPos AS LONG) AS LONG
DECLARE FUNCTION GetSubMenu LIB "USER32.DLL" ALIAS "GetSubMenu" (BYVAL hMenu AS DWORD, BYVAL nPos AS LONG) AS LONG
DECLARE FUNCTION GetSysColor LIB "USER32.DLL" ALIAS "GetSysColor" (BYVAL nIndex AS LONG) AS LONG
DECLARE FUNCTION GetSysColorBrush LIB "USER32.DLL" ALIAS "GetSysColorBrush" (BYVAL nIndex AS LONG) AS LONG
DECLARE FUNCTION GetSystemMenu LIB "USER32.DLL" ALIAS "GetSystemMenu" (BYVAL hWnd AS DWORD, BYVAL bRevert AS LONG) AS LONG
DECLARE FUNCTION GetSystemMetrics LIB "USER32.DLL" ALIAS "GetSystemMetrics" (BYVAL nIndex AS LONG) AS LONG
DECLARE FUNCTION GetTabbedTextExtent LIB "USER32.DLL" ALIAS "GetTabbedTextExtentA" (BYVAL hDC AS DWORD, lpString AS ASCIIZ, BYVAL nCount AS LONG, BYVAL nTabPositions AS LONG, lpnTabStopPositions AS LONG) AS LONG
DECLARE FUNCTION GetThreadDesktop LIB "USER32.DLL" ALIAS "GetThreadDesktop" (BYVAL dwThread AS DWORD) AS LONG
DECLARE FUNCTION GetTopWindow LIB "USER32.DLL" ALIAS "GetTopWindow" (BYVAL hWnd AS DWORD) AS LONG
DECLARE FUNCTION GetUpdateRect LIB "USER32.DLL" ALIAS "GetUpdateRect" (BYVAL hWnd AS DWORD, lpRect AS RECT, BYVAL bErase AS LONG) AS LONG
DECLARE FUNCTION GetUpdateRgn LIB "USER32.DLL" ALIAS "GetUpdateRgn" (BYVAL hWnd AS DWORD, BYVAL hRgn AS DWORD, BYVAL fErase AS LONG) AS LONG
DECLARE FUNCTION GetUserObjectInformation LIB "USER32.DLL" ALIAS "GetUserObjectInformationA" (BYVAL hObj AS DWORD, BYVAL nIndex AS LONG, pvInfo AS ANY, BYVAL nLength AS LONG, lpnLengthNeeded AS LONG) AS LONG
DECLARE FUNCTION GetUserObjectSecurity LIB "USER32.DLL" ALIAS "GetUserObjectSecurity" (BYVAL hObj AS DWORD, pSIRequested AS LONG, pSd AS SECURITY_DESCRIPTOR, BYVAL nLength AS LONG, lpnLengthNeeded AS LONG) AS LONG
DECLARE FUNCTION GetWindow LIB "USER32.DLL" ALIAS "GetWindow" (BYVAL hWnd AS DWORD, BYVAL wCmd AS DWORD) AS LONG

#IF %DEF(%CCWIN)
  FUNCTION GetNextWindow (BYVAL hWnd AS DWORD, BYVAL uCmd AS DWORD) AS DWORD
    FUNCTION = GetWindow(hWnd, uCmd)
  END FUNCTION
#ENDIF

DECLARE FUNCTION GetWindowContextHelpId LIB "USER32.DLL" ALIAS "GetWindowContextHelpId" (BYVAL hWnd AS DWORD) AS LONG
DECLARE FUNCTION GetWindowDC LIB "USER32.DLL" ALIAS "GetWindowDC" (BYVAL hWnd AS DWORD) AS LONG
DECLARE FUNCTION GetWindowLong LIB "USER32.DLL" ALIAS "GetWindowLongA" (BYVAL hWnd AS DWORD, BYVAL nIndex AS LONG) AS LONG
DECLARE FUNCTION GetWindowPlacement LIB "USER32.DLL" ALIAS "GetWindowPlacement" (BYVAL hWnd AS DWORD, lpwndpl AS WINDOWPLACEMENT) AS LONG
DECLARE FUNCTION GetWindowRect LIB "USER32.DLL" ALIAS "GetWindowRect" (BYVAL hWnd AS DWORD, lpRect AS RECT) AS LONG
DECLARE FUNCTION GetWindowRgn LIB "USER32.DLL" ALIAS "GetWindowRgn" (BYVAL hWnd AS DWORD, BYVAL hRgn AS DWORD) AS LONG
DECLARE FUNCTION GetWindowText LIB "USER32.DLL" ALIAS "GetWindowTextA" (BYVAL hWnd AS DWORD, lpString AS ASCIIZ, BYVAL cch AS LONG) AS LONG
DECLARE FUNCTION GetWindowTextLength LIB "USER32.DLL" ALIAS "GetWindowTextLengthA" (BYVAL hWnd AS DWORD) AS LONG
DECLARE FUNCTION GetWindowThreadProcessId LIB "USER32.DLL" ALIAS "GetWindowThreadProcessId" (BYVAL hWnd AS DWORD, lpdwProcessId AS DWORD) AS LONG
DECLARE FUNCTION GetWindowWord LIB "USER32.DLL" ALIAS "GetWindowWord" (BYVAL hWnd AS DWORD, BYVAL nIndex AS LONG) AS LONG
DECLARE FUNCTION GrayString LIB "USER32.DLL" ALIAS "GrayStringA" (BYVAL hDC AS DWORD, BYVAL hBrush AS DWORD, BYVAL lpOutputFunc AS LONG, BYVAL lpData AS LONG, BYVAL nCount AS LONG, BYVAL X AS LONG, BYVAL Y AS LONG, BYVAL nWidth AS LONG, _
                 BYVAL nHeight AS LONG) AS LONG
DECLARE FUNCTION HideCaret LIB "USER32.DLL" ALIAS "HideCaret" (BYVAL hWnd AS DWORD) AS LONG
DECLARE FUNCTION HiliteMenuItem LIB "USER32.DLL" ALIAS "HiliteMenuItem" (BYVAL hWnd AS DWORD, BYVAL hMenu AS DWORD, BYVAL dwIDHiliteItem AS DWORD, BYVAL dwHilite AS DWORD) AS LONG
DECLARE FUNCTION ImpersonateDdeClientWindow LIB "USER32.DLL" ALIAS "ImpersonateDdeClientWindow" (BYVAL hWndClient AS DWORD, BYVAL hWndServer AS DWORD) AS LONG
DECLARE FUNCTION InSendMessage LIB "USER32.DLL" ALIAS "InSendMessage" () AS LONG
DECLARE FUNCTION InflateRect LIB "USER32.DLL" ALIAS "InflateRect" (lpRect AS RECT, BYVAL x AS LONG, BYVAL y AS LONG) AS LONG
DECLARE FUNCTION InsertMenu LIB "USER32.DLL" ALIAS "InsertMenuA" (BYVAL hMenu AS DWORD, BYVAL dwPosition AS DWORD, BYVAL dwFlags AS DWORD, BYVAL dwIDNewItem AS DWORD, lpNewItem AS ASCIIZ) AS LONG
DECLARE FUNCTION InsertMenuItem LIB "USER32.DLL" ALIAS "InsertMenuItemA" (BYVAL hMenu AS DWORD, BYVAL uItem AS DWORD, BYVAL fByPosition AS LONG, lpcMenuItemInfo AS MENUITEMINFO) AS LONG
DECLARE FUNCTION IntersectRect LIB "USER32.DLL" ALIAS "IntersectRect" (lpDestRect AS RECT, lpSrc1Rect AS RECT, lpSrc2Rect AS RECT) AS LONG
DECLARE FUNCTION InvalidateRect LIB "USER32.DLL" ALIAS "InvalidateRect" (BYVAL hWnd AS DWORD, lpRect AS RECT, BYVAL bErase AS LONG) AS LONG
DECLARE FUNCTION InvalidateRgn LIB "USER32.DLL" ALIAS "InvalidateRgn" (BYVAL hWnd AS DWORD, BYVAL hRgn AS DWORD, BYVAL bErase AS LONG) AS LONG
DECLARE FUNCTION InvertRect LIB "USER32.DLL" ALIAS "InvertRect" (BYVAL hDC AS DWORD, lpRect AS RECT) AS LONG
DECLARE FUNCTION IsCharAlpha LIB "USER32.DLL" ALIAS "IsCharAlphaA" (BYVAL cChar AS BYTE) AS LONG
DECLARE FUNCTION IsCharAlphaNumeric LIB "USER32.DLL" ALIAS "IsCharAlphaNumericA" (BYVAL cChar AS BYTE) AS LONG
DECLARE FUNCTION IsCharLower LIB "USER32.DLL" ALIAS "IsCharLowerA" (BYVAL cChar AS BYTE) AS LONG
DECLARE FUNCTION IsCharUpper LIB "USER32.DLL" ALIAS "IsCharUpperA" (BYVAL cChar AS BYTE) AS LONG
DECLARE FUNCTION IsChild LIB "USER32.DLL" ALIAS "IsChild" (BYVAL hwndParent AS DWORD, BYVAL hWnd AS DWORD) AS LONG
DECLARE FUNCTION IsClipboardFormatAvailable LIB "USER32.DLL" ALIAS "IsClipboardFormatAvailable" (BYVAL dwFormat AS DWORD) AS LONG
DECLARE FUNCTION IsDialogMessage LIB "USER32.DLL" ALIAS "IsDialogMessageA" (BYVAL hDlg AS DWORD, lpMsg AS tagMSG) AS LONG
DECLARE FUNCTION IsDlgButtonChecked LIB "USER32.DLL" ALIAS "IsDlgButtonChecked" (BYVAL hDlg AS DWORD, BYVAL nIDButton AS LONG) AS LONG
DECLARE FUNCTION IsIconic LIB "USER32.DLL" ALIAS "IsIconic" (BYVAL hWnd AS DWORD) AS LONG
DECLARE FUNCTION IsMenu LIB "USER32.DLL" ALIAS "IsMenu" (BYVAL hMenu AS DWORD) AS LONG
DECLARE FUNCTION IsRectEmpty LIB "USER32.DLL" ALIAS "IsRectEmpty" (lpRect AS RECT) AS LONG
DECLARE FUNCTION IsWindow LIB "USER32.DLL" ALIAS "IsWindow" (BYVAL hWnd AS DWORD) AS LONG
DECLARE FUNCTION IsWindowEnabled LIB "USER32.DLL" ALIAS "IsWindowEnabled" (BYVAL hWnd AS DWORD) AS LONG
DECLARE FUNCTION IsWindowUnicode LIB "USER32.DLL" ALIAS "IsWindowUnicode" (BYVAL hWnd AS DWORD) AS LONG
DECLARE FUNCTION IsWindowVisible LIB "USER32.DLL" ALIAS "IsWindowVisible" (BYVAL hWnd AS DWORD) AS LONG
DECLARE FUNCTION IsZoomed LIB "USER32.DLL" ALIAS "IsZoomed" (BYVAL hWnd AS DWORD) AS LONG
DECLARE FUNCTION KillTimer LIB "USER32.DLL" ALIAS "KillTimer" (BYVAL hWnd AS DWORD, BYVAL nIDEvent AS LONG) AS LONG
DECLARE FUNCTION LoadAccelerators LIB "USER32.DLL" ALIAS "LoadAcceleratorsA" (BYVAL hInstance AS DWORD, lpTableName AS ASCIIZ) AS DWORD
DECLARE FUNCTION LoadBitmap LIB "USER32.DLL" ALIAS "LoadBitmapA" (BYVAL hInstance AS DWORD, lpBitmapName AS ASCIIZ) AS DWORD
DECLARE FUNCTION LoadCursor LIB "USER32.DLL" ALIAS "LoadCursorA" (BYVAL hInstance AS DWORD, lpCursorName AS ASCIIZ) AS DWORD
DECLARE FUNCTION LoadCursorFromFile LIB "USER32.DLL" ALIAS "LoadCursorFromFileA" (lpFileName AS ASCIIZ) AS DWORD
DECLARE FUNCTION LoadIcon LIB "USER32.DLL" ALIAS "LoadIconA" (BYVAL hInstance AS DWORD, lpIconName AS ASCIIZ) AS DWORD
DECLARE FUNCTION LoadImage LIB "USER32.DLL" ALIAS "LoadImageA" (BYVAL hInst AS DWORD, lpsz AS ASCIIZ, BYVAL uType AS DWORD, BYVAL cxDesired AS LONG, BYVAL cyDesired AS LONG, BYVAL fuLoad AS DWORD) AS DWORD
DECLARE FUNCTION LoadKeyboardLayout LIB "USER32.DLL" ALIAS "LoadKeyboardLayoutA" (pwszKLID AS ASCIIZ, BYVAL flags AS LONG) AS DWORD
DECLARE FUNCTION LoadMenu LIB "USER32.DLL" ALIAS "LoadMenuA" (BYVAL hInstance AS DWORD, lpString AS ASCIIZ) AS DWORD
DECLARE FUNCTION LoadMenuIndirect LIB "USER32.DLL" ALIAS "LoadMenuIndirectA" (BYVAL lpMenuTemplate AS LONG) AS DWORD
DECLARE FUNCTION LoadString LIB "USER32.DLL" ALIAS "LoadStringA" (BYVAL hInstance AS DWORD, BYVAL uID AS DWORD, lpBuffer AS ASCIIZ, BYVAL nBufferMax AS LONG) AS DWORD
DECLARE FUNCTION LockWindowUpdate LIB "USER32.DLL" ALIAS "LockWindowUpdate" (BYVAL hWndLock AS DWORD) AS LONG
DECLARE FUNCTION LockWorkStation LIB "USER32.DLL" ALIAS "LockWorkStation" () AS LONG
DECLARE FUNCTION LookupIconIdFromDirectory LIB "USER32.DLL" ALIAS "LookupIconIdFromDirectory" (presbits AS BYTE, BYVAL fIcon AS LONG) AS LONG
DECLARE FUNCTION LookupIconIdFromDirectoryEx LIB "USER32.DLL" ALIAS "LookupIconIdFromDirectoryEx" (presbits AS BYTE, BYVAL fIcon AS LONG, BYVAL cxDesired AS LONG, BYVAL cyDesired AS LONG, BYVAL Flags AS LONG) AS LONG
DECLARE FUNCTION MapDialogRect LIB "USER32.DLL" ALIAS "MapDialogRect" (BYVAL hDlg AS DWORD, lpRect AS RECT) AS LONG
DECLARE FUNCTION MapVirtualKey LIB "USER32.DLL" ALIAS "MapVirtualKeyA" (BYVAL dwCode AS DWORD, BYVAL dwMapType AS DWORD) AS DWORD
DECLARE FUNCTION MapVirtualKeyEx LIB "USER32.DLL" ALIAS "MapVirtualKeyExA" (BYVAL uCode AS DWORD, BYVAL uMapType AS DWORD, BYVAL dwHKL AS DWORD) AS DWORD
DECLARE FUNCTION MapWindowPoints LIB "USER32.DLL" ALIAS "MapWindowPoints" (BYVAL hWndFrom AS DWORD, BYVAL hWndTo AS DWORD, lppt AS ANY, BYVAL cPoints AS LONG) AS LONG
DECLARE FUNCTION MenuItemFromPoint LIB "USER32.DLL" ALIAS "MenuItemFromPoint" (BYVAL hWnd AS DWORD, BYVAL hMenu AS DWORD, BYVAL x AS LONG, BYVAL y AS LONG) AS LONG
DECLARE FUNCTION MessageBeep LIB "USER32.DLL" ALIAS "MessageBeep" (BYVAL dwType AS DWORD) AS LONG
DECLARE FUNCTION MessageBox LIB "USER32.DLL" ALIAS "MessageBoxA" (BYVAL hWnd AS DWORD, lpText AS ASCIIZ, lpCaption AS ASCIIZ, BYVAL dwType AS DWORD) AS LONG
DECLARE FUNCTION MessageBoxEx LIB "USER32.DLL" ALIAS "MessageBoxExA" (BYVAL hWnd AS DWORD, lpText AS ASCIIZ, lpCaption AS ASCIIZ, BYVAL uType AS DWORD, BYVAL wLanguageId AS DWORD) AS LONG
DECLARE FUNCTION MessageBoxIndirect LIB "USER32.DLL" ALIAS "MessageBoxIndirectA" (lpMsgBoxParams AS MSGBOXPARAMS) AS LONG
DECLARE FUNCTION ModifyMenu LIB "USER32.DLL" ALIAS "ModifyMenuA" (BYVAL hMenu AS DWORD, BYVAL dwPosition AS DWORD, BYVAL dwFlags AS DWORD, BYVAL dwIDNewItem AS DWORD, lpString AS ASCIIZ) AS LONG
DECLARE FUNCTION MonitorFromPoint LIB "USER32.DLL" ALIAS "MonitorFromPoint" (BYVAL x AS LONG, BYVAL y AS LONG, BYVAL dwFlags AS DWORD) AS DWORD
DECLARE FUNCTION MonitorFromRect LIB "USER32.DLL" ALIAS "MonitorFromRect" (lprc AS RECT, BYVAL dwFlags AS DWORD) AS DWORD
DECLARE FUNCTION MonitorFromWindow LIB "USER32.DLL" ALIAS "MonitorFromWindow" (BYVAL hwnd AS DWORD, BYVAL dwFlags AS DWORD) AS DWORD
DECLARE FUNCTION MoveWindow LIB "USER32.DLL" ALIAS "MoveWindow" (BYVAL hWnd AS DWORD, BYVAL x AS LONG, BYVAL y AS LONG, BYVAL nWidth AS LONG, BYVAL nHeight AS LONG, BYVAL bRepaint AS LONG) AS LONG
DECLARE FUNCTION MsgWaitForMultipleObjects LIB "USER32.DLL" ALIAS "MsgWaitForMultipleObjects" (BYVAL nCount AS DWORD, pHandles AS DWORD, BYVAL fWaitAll AS LONG, BYVAL dwMilliseconds AS DWORD, BYVAL dwWakeMask AS DWORD) AS DWORD
DECLARE FUNCTION OemKeyScan LIB "USER32.DLL" ALIAS "OemKeyScan" (BYVAL wOemChar AS WORD) AS DWORD
DECLARE FUNCTION OemToChar LIB "USER32.DLL" ALIAS "OemToCharA" (lpszSrc AS ASCIIZ, lpszDst AS ASCIIZ) AS LONG
DECLARE FUNCTION OemToCharBuff LIB "USER32.DLL" ALIAS "OemToCharBuffA" (lpszSrc AS ASCIIZ, lpszDst AS ASCIIZ, BYVAL cchDstLength AS LONG) AS LONG
DECLARE FUNCTION OffsetRect LIB "USER32.DLL" ALIAS "OffsetRect" (lpRect AS RECT, BYVAL x AS LONG, BYVAL y AS LONG) AS LONG
DECLARE FUNCTION OpenClipboard LIB "USER32.DLL" ALIAS "OpenClipboard" (BYVAL hWnd AS DWORD) AS LONG
DECLARE FUNCTION OpenDesktop LIB "USER32.DLL" ALIAS "OpenDesktopA" (lpszDesktop AS ASCIIZ, BYVAL dwFlags AS DWORD, BYVAL fInherit AS LONG, BYVAL dwDesiredAccess AS DWORD) AS LONG
DECLARE FUNCTION OpenIcon LIB "USER32.DLL" ALIAS "OpenIcon" (BYVAL hWnd AS DWORD) AS LONG
DECLARE FUNCTION OpenInputDesktop LIB "USER32.DLL" ALIAS "OpenInputDesktop" (BYVAL dwFlags AS DWORD, BYVAL fInherit AS LONG, BYVAL dwDesiredAccess AS DWORD) AS LONG
DECLARE FUNCTION OpenWindowStation LIB "USER32.DLL" ALIAS "OpenWindowStationA" (lpszWinSta AS ASCIIZ, BYVAL fInherit AS LONG, BYVAL dwDesiredAccess AS DWORD) AS LONG
DECLARE FUNCTION PackDDElParam LIB "USER32.DLL" ALIAS "PackDDElParam" (BYVAL msg AS LONG, BYVAL uiLo AS DWORD, BYVAL uiHi AS DWORD) AS LONG
DECLARE FUNCTION PaintDesktop LIB "USER32.DLL" ALIAS "PaintDesktop" (BYVAL hDC AS DWORD) AS LONG
DECLARE FUNCTION PeekMessage LIB "USER32.DLL" ALIAS "PeekMessageA" (lpMsg AS tagMSG, BYVAL hWnd AS DWORD, BYVAL dwMsgFilterMin AS DWORD, BYVAL dwMsgFilterMax AS DWORD, BYVAL dwRemoveMsg AS DWORD) AS LONG
DECLARE FUNCTION PostMessage LIB "USER32.DLL" ALIAS "PostMessageA" (BYVAL hWnd AS DWORD, BYVAL dwMsg AS DWORD, BYVAL wParam AS DWORD, BYVAL lParam AS LONG) AS LONG
DECLARE FUNCTION PostThreadMessage LIB "USER32.DLL" ALIAS "PostThreadMessageA" (BYVAL idThread AS DWORD, BYVAL uMsg AS DWORD, BYVAL wParam AS DWORD, BYVAL lParam AS LONG) AS LONG
DECLARE FUNCTION PtInRect LIB "USER32.DLL" ALIAS "PtInRect" (lpRect AS RECT, BYVAL ptx AS LONG, BYVAL pty AS LONG) AS LONG
DECLARE FUNCTION RedrawWindow LIB "USER32.DLL" ALIAS "RedrawWindow" (BYVAL hWnd AS DWORD, lprcUpdate AS RECT, BYVAL hRgnUpdate AS DWORD, BYVAL fuRedraw AS LONG) AS LONG
DECLARE FUNCTION RegisterClass LIB "USER32.DLL" ALIAS "RegisterClassA" (pcWndClass AS WNDCLASS) AS LONG
DECLARE FUNCTION RegisterClassEx LIB "USER32.DLL" ALIAS "RegisterClassExA" (pcWndClassEx AS WNDCLASSEX) AS LONG
DECLARE FUNCTION RegisterClipboardFormat LIB "USER32.DLL" ALIAS "RegisterClipboardFormatA" (lpString AS ASCIIZ) AS LONG
DECLARE FUNCTION RegisterHotKey LIB "USER32.DLL" ALIAS "RegisterHotKey" (BYVAL hWnd AS DWORD, BYVAL id AS LONG, BYVAL fsModifiers AS LONG, BYVAL vk AS LONG) AS LONG
DECLARE FUNCTION RegisterWindowMessage LIB "USER32.DLL" ALIAS "RegisterWindowMessageA" (lpString AS ASCIIZ) AS LONG
DECLARE FUNCTION ReleaseCapture LIB "USER32.DLL" ALIAS "ReleaseCapture" () AS LONG
DECLARE FUNCTION ReleaseDC LIB "USER32.DLL" ALIAS "ReleaseDC" (BYVAL hWnd AS DWORD, BYVAL hDC AS DWORD) AS LONG
DECLARE FUNCTION RemoveMenu LIB "USER32.DLL" ALIAS "RemoveMenu" (BYVAL hMenu AS DWORD, BYVAL nPosition AS LONG, BYVAL wFlags AS DWORD) AS LONG
DECLARE FUNCTION RemoveProp LIB "USER32.DLL" ALIAS "RemovePropA" (BYVAL hWnd AS DWORD, lpString AS ASCIIZ) AS LONG
DECLARE FUNCTION ReplyMessage LIB "USER32.DLL" ALIAS "ReplyMessage" (BYVAL lReply AS LONG) AS LONG
DECLARE FUNCTION ReuseDDElParam LIB "USER32.DLL" ALIAS "ReuseDDElParam" (BYVAL lParam AS LONG, BYVAL msgIn AS LONG, BYVAL msgOut AS LONG, BYVAL uiLo AS DWORD, BYVAL uiHi AS DWORD) AS LONG
DECLARE FUNCTION ScreenToClient LIB "USER32.DLL" ALIAS "ScreenToClient" (BYVAL hWnd AS DWORD, lpPoint AS POINTAPI) AS LONG
DECLARE FUNCTION ScrollDC LIB "USER32.DLL" ALIAS "ScrollDC" (BYVAL hDC AS DWORD, BYVAL dx AS LONG, BYVAL dy AS LONG, lprcScroll AS RECT, lprcClip AS RECT, BYVAL hRgnUpdate AS DWORD, lprcUpdate AS RECT) AS LONG
DECLARE FUNCTION ScrollWindow LIB "USER32.DLL" ALIAS "ScrollWindow" (BYVAL hWnd AS DWORD, BYVAL XAmount AS LONG, BYVAL YAmount AS LONG, lpRect AS RECT, lpClipRect AS RECT) AS LONG
DECLARE FUNCTION ScrollWindowEx LIB "USER32.DLL" ALIAS "ScrollWindowEx" (BYVAL hWnd AS DWORD, BYVAL dx AS LONG, BYVAL dy AS LONG, lprcScroll AS RECT, lprcClip AS RECT, BYVAL hRgnUpdate AS DWORD, lprcUpdate AS RECT, BYVAL fuScroll AS LONG) AS LONG
DECLARE FUNCTION SendDlgItemMessage LIB "USER32.DLL" ALIAS "SendDlgItemMessageA" (BYVAL hDlg AS DWORD, BYVAL nIDDlgItem AS LONG, BYVAL wMsg AS DWORD, BYVAL wParam AS DWORD, BYVAL lParam AS LONG) AS LONG
DECLARE FUNCTION SendMessage LIB "USER32.DLL" ALIAS "SendMessageA" (BYVAL hWnd AS DWORD, BYVAL dwMsg AS DWORD, BYVAL wParam AS DWORD, BYVAL lParam AS LONG) AS LONG
DECLARE FUNCTION SendMessageCallback LIB "USER32.DLL" ALIAS "SendMessageCallbackA" (BYVAL hWnd AS DWORD, BYVAL dwMsg AS DWORD, BYVAL wParam AS DWORD, BYVAL lParam AS LONG, BYVAL lpResultCallBack AS LONG, BYVAL dwData AS DWORD) AS LONG
DECLARE FUNCTION SendMessageTimeout LIB "USER32.DLL" ALIAS "SendMessageTimeoutA" (BYVAL hWnd AS DWORD, BYVAL dwMsg AS DWORD, BYVAL wParam AS DWORD, BYVAL lParam AS LONG, BYVAL fuFlags AS LONG, BYVAL uTimeout AS DWORD, lpdwResult AS DWORD) AS LONG
DECLARE FUNCTION SendNotifyMessage LIB "USER32.DLL" ALIAS "SendNotifyMessageA" (BYVAL hWnd AS DWORD, BYVAL dwMsg AS DWORD, BYVAL wParam AS DWORD, BYVAL lParam AS LONG) AS LONG
DECLARE FUNCTION SetActiveWindow LIB "USER32.DLL" ALIAS "SetActiveWindow" (BYVAL hWnd AS DWORD) AS LONG
DECLARE FUNCTION SetCapture LIB "USER32.DLL" ALIAS "SetCapture" (BYVAL hWnd AS DWORD) AS LONG
DECLARE FUNCTION SetCaretBlinkTime LIB "USER32.DLL" ALIAS "SetCaretBlinkTime" (BYVAL dwMillieconds AS DWORD) AS LONG
DECLARE FUNCTION SetCaretPos LIB "USER32.DLL" ALIAS "SetCaretPos" (BYVAL x AS LONG, BYVAL y AS LONG) AS LONG
DECLARE FUNCTION SetClassLong LIB "USER32.DLL" ALIAS "SetClassLongA" (BYVAL hWnd AS DWORD, BYVAL nIndex AS LONG, BYVAL dwNewLong AS DWORD) AS LONG
DECLARE FUNCTION SetClassWord LIB "USER32.DLL" ALIAS "SetClassWord" (BYVAL hWnd AS DWORD, BYVAL nIndex AS LONG, BYVAL wNewWord AS WORD) AS WORD
DECLARE FUNCTION SetClipboardData LIB "USER32.DLL" ALIAS "SetClipboardData" (BYVAL dwFormat AS DWORD, BYVAL hMem AS DWORD) AS DWORD
DECLARE FUNCTION SetClipboardViewer LIB "USER32.DLL" ALIAS "SetClipboardViewer" (BYVAL hWnd AS DWORD) AS DWORD
DECLARE FUNCTION SetCursor LIB "USER32.DLL" ALIAS "SetCursor" (BYVAL hCursor AS DWORD) AS DWORD
DECLARE FUNCTION SetCursorPos LIB "USER32.DLL" ALIAS "SetCursorPos" (BYVAL x AS LONG, BYVAL y AS LONG) AS LONG
DECLARE FUNCTION SetDlgItemInt LIB "USER32.DLL" ALIAS "SetDlgItemInt" (BYVAL hDlg AS DWORD, BYVAL nIDDlgItem AS LONG, BYVAL dwValue AS DWORD, BYVAL bSigned AS LONG) AS LONG
DECLARE FUNCTION SetDlgItemText LIB "USER32.DLL" ALIAS "SetDlgItemTextA" (BYVAL hDlg AS DWORD, BYVAL nIDDlgItem AS LONG, lpString AS ASCIIZ) AS LONG
DECLARE FUNCTION SetDoubleClickTime LIB "USER32.DLL" ALIAS "SetDoubleClickTime" (BYVAL uInterval AS DWORD) AS LONG
DECLARE FUNCTION SetFocus LIB "USER32.DLL" ALIAS "SetFocus" (BYVAL hWnd AS DWORD) AS LONG
DECLARE FUNCTION SetForegroundWindow LIB "USER32.DLL" ALIAS "SetForegroundWindow" (BYVAL hWnd AS DWORD) AS LONG
DECLARE FUNCTION SetKeyboardState LIB "USER32.DLL" ALIAS "SetKeyboardState" (lppbKeyState AS BYTE) AS LONG
DECLARE FUNCTION SetMenu LIB "USER32.DLL" ALIAS "SetMenu" (BYVAL hWnd AS DWORD, BYVAL hMenu AS DWORD) AS LONG
DECLARE FUNCTION SetMenuContextHelpId LIB "USER32.DLL" ALIAS "SetMenuContextHelpId" (BYVAL hMenu AS DWORD, BYVAL dw AS DWORD) AS LONG
DECLARE FUNCTION SetMenuDefaultItem LIB "USER32.DLL" ALIAS "SetMenuDefaultItem" (BYVAL hMenu AS DWORD, BYVAL uItem AS DWORD, BYVAL fByPos AS LONG) AS LONG
DECLARE FUNCTION SetMenuItemBitmaps LIB "USER32.DLL" ALIAS "SetMenuItemBitmaps" (BYVAL hMenu AS DWORD, BYVAL nPosition AS LONG, BYVAL wFlags AS DWORD, BYVAL hBitmapUnchecked AS DWORD, BYVAL hBitmapChecked AS DWORD) AS LONG
DECLARE FUNCTION SetMenuItemInfo LIB "USER32.DLL" ALIAS "SetMenuItemInfoA" (BYVAL hMenu AS DWORD, BYVAL uItem AS DWORD, BYVAL fByPosition AS LONG, lpcMenuItemInfo AS MENUITEMINFO) AS LONG
DECLARE FUNCTION SetMessageExtraInfo LIB "USER32.DLL" ALIAS "SetMessageExtraInfo" (BYVAL lParam AS LONG) AS LONG
DECLARE FUNCTION SetMessageQueue LIB "USER32.DLL" ALIAS "SetMessageQueue" (BYVAL cMessagesMax AS LONG) AS LONG
DECLARE FUNCTION SetParent LIB "USER32.DLL" ALIAS "SetParent" (BYVAL hWndChild AS DWORD, BYVAL hWndNewParent AS DWORD) AS LONG
DECLARE FUNCTION SetProcessWindowStation LIB "USER32.DLL" ALIAS "SetProcessWindowStation" (BYVAL hWinSta AS DWORD) AS LONG
DECLARE FUNCTION SetProp LIB "USER32.DLL" ALIAS "SetPropA" (BYVAL hWnd AS DWORD, lpString AS ASCIIZ, BYVAL hData AS DWORD) AS LONG
DECLARE FUNCTION SetRect LIB "USER32.DLL" ALIAS "SetRect" (lpRect AS RECT, BYVAL X1 AS LONG, BYVAL Y1 AS LONG, BYVAL X2 AS LONG, BYVAL Y2 AS LONG) AS LONG
DECLARE FUNCTION SetRectEmpty LIB "USER32.DLL" ALIAS "SetRectEmpty" (lpRect AS RECT) AS LONG
DECLARE FUNCTION SetScrollInfo LIB "USER32.DLL" ALIAS "SetScrollInfo" (BYVAL hWnd AS DWORD, BYVAL fnBar AS LONG, lpcScrollInfo AS SCROLLINFO, BYVAL fRedraw AS LONG) AS LONG
DECLARE FUNCTION SetScrollPos LIB "USER32.DLL" ALIAS "SetScrollPos" (BYVAL hWnd AS DWORD, BYVAL nBar AS LONG, BYVAL nPos AS LONG, BYVAL bRedraw AS LONG) AS LONG
DECLARE FUNCTION SetScrollRange LIB "USER32.DLL" ALIAS "SetScrollRange" (BYVAL hWnd AS DWORD, BYVAL nBar AS LONG, BYVAL nMinPos AS LONG, BYVAL nMaxPos AS LONG, BYVAL bRedraw AS LONG) AS LONG
DECLARE FUNCTION SetSysColors LIB "USER32.DLL" ALIAS "SetSysColors" (BYVAL nChanges AS LONG, lpSysColor AS LONG, lpColorValues AS LONG) AS LONG
DECLARE FUNCTION SetSystemCursor LIB "USER32.DLL" ALIAS "SetSystemCursor" (BYVAL hCur AS DWORD, BYVAL id AS LONG) AS LONG
DECLARE FUNCTION SetThreadDesktop LIB "USER32.DLL" ALIAS "SetThreadDesktop" (BYVAL hDesktop AS DWORD) AS LONG
DECLARE FUNCTION SetTimer LIB "USER32.DLL" ALIAS "SetTimer" (BYVAL hWnd AS DWORD, BYVAL nIDEvent AS LONG, BYVAL uElapse AS DWORD, BYVAL lpTimerFunc AS LONG) AS LONG
DECLARE FUNCTION SetUserObjectInformation LIB "USER32.DLL" ALIAS "SetUserObjectInformationA" (BYVAL hObj AS DWORD, BYVAL nIndex AS LONG, pvInfo AS ANY, BYVAL nLength AS LONG) AS LONG
DECLARE FUNCTION SetUserObjectSecurity LIB "USER32.DLL" ALIAS "SetUserObjectSecurity" (BYVAL hObj AS DWORD, pSIRequested AS LONG, pSd AS SECURITY_DESCRIPTOR) AS LONG
DECLARE FUNCTION SetWindowContextHelpId LIB "USER32.DLL" ALIAS "SetWindowContextHelpId" (BYVAL hWnd AS DWORD, BYVAL dwContextHelpId AS DWORD) AS LONG
DECLARE FUNCTION SetWindowLong LIB "USER32.DLL" ALIAS "SetWindowLongA" (BYVAL hWnd AS DWORD, BYVAL nIndex AS LONG, BYVAL lNewLong AS LONG) AS LONG
DECLARE FUNCTION SetWindowPlacement LIB "USER32.DLL" ALIAS "SetWindowPlacement" (BYVAL hWnd AS DWORD, lpwndpl AS WINDOWPLACEMENT) AS LONG
DECLARE FUNCTION SetWindowPos LIB "USER32.DLL" ALIAS "SetWindowPos" (BYVAL hWnd AS DWORD, BYVAL hWndInsertAfter AS DWORD, BYVAL x AS LONG, BYVAL y AS LONG, BYVAL cx AS LONG, BYVAL cy AS LONG, BYVAL wFlags AS DWORD) AS LONG
DECLARE FUNCTION SetWindowRgn LIB "USER32.DLL" ALIAS "SetWindowRgn" (BYVAL hWnd AS DWORD, BYVAL hRgn AS DWORD, BYVAL bRedraw AS LONG) AS LONG
DECLARE FUNCTION SetWindowText LIB "USER32.DLL" ALIAS "SetWindowTextA" (BYVAL hWnd AS DWORD, lpString AS ASCIIZ) AS LONG
DECLARE FUNCTION SetWindowWord LIB "USER32.DLL" ALIAS "SetWindowWord" (BYVAL hWnd AS DWORD, BYVAL nIndex AS LONG, BYVAL wNewWord AS WORD) AS WORD
DECLARE FUNCTION SetWindowsHook LIB "USER32.DLL" ALIAS "SetWindowsHookA" (BYVAL nFilterType AS LONG, BYVAL pfnFilterProc AS DWORD) AS LONG
DECLARE FUNCTION SetWindowsHookEx LIB "USER32.DLL" ALIAS "SetWindowsHookExA" (BYVAL idHook AS LONG, BYVAL lpfn AS DWORD, BYVAL hMod AS DWORD, BYVAL dwThreadId AS DWORD) AS LONG
DECLARE FUNCTION ShowCaret LIB "USER32.DLL" ALIAS "ShowCaret" (BYVAL hWnd AS DWORD) AS LONG
DECLARE FUNCTION ShowCursor LIB "USER32.DLL" ALIAS "ShowCursor" (BYVAL bShow AS LONG) AS LONG
DECLARE FUNCTION ShowOwnedPopups LIB "USER32.DLL" ALIAS "ShowOwnedPopups" (BYVAL hWnd AS DWORD, BYVAL fShow AS LONG) AS LONG
DECLARE FUNCTION ShowScrollBar LIB "USER32.DLL" ALIAS "ShowScrollBar" (BYVAL hWnd AS DWORD, BYVAL iBar AS LONG, BYVAL bShow AS LONG) AS LONG
DECLARE FUNCTION ShowWindow LIB "USER32.DLL" ALIAS "ShowWindow" (BYVAL hWnd AS DWORD, BYVAL nCmdShow AS LONG) AS LONG
DECLARE FUNCTION ShowWindowAsync LIB "USER32.DLL" ALIAS "ShowWindowAsync" (BYVAL hWnd AS DWORD, BYVAL nCmdShow AS LONG) AS LONG
DECLARE FUNCTION SubtractRect LIB "USER32.DLL" ALIAS "SubtractRect" (lprcDst AS RECT, lprcSrc1 AS RECT, lprcSrc2 AS RECT) AS LONG
DECLARE FUNCTION SwapMouseButton LIB "USER32.DLL" ALIAS "SwapMouseButton" (BYVAL bSwap AS LONG) AS LONG
DECLARE FUNCTION SwitchDesktop LIB "USER32.DLL" ALIAS "SwitchDesktop" (BYVAL hDesktop AS DWORD) AS LONG
DECLARE FUNCTION SystemParametersInfo LIB "USER32.DLL" ALIAS "SystemParametersInfoA" (BYVAL uAction AS DWORD, BYVAL uParam AS DWORD, lpvParam AS ANY, BYVAL fuWinIni AS DWORD) AS LONG
DECLARE FUNCTION TabbedTextOut LIB "USER32.DLL" ALIAS "TabbedTextOutA" (BYVAL hDC AS DWORD, BYVAL x AS LONG, BYVAL y AS LONG, lpString AS ASCIIZ, BYVAL nCount AS LONG, BYVAL nTabPositions AS LONG, lpnTabStopPositions AS LONG, _
                 BYVAL nTabOrigin AS LONG) AS LONG
DECLARE FUNCTION TileWindows LIB "USER32.DLL" ALIAS "TileWindows" (BYVAL hwndParent AS DWORD, BYVAL dwHow AS DWORD, lpRect AS RECT, BYVAL cKids AS DWORD, lpKids AS DWORD) AS WORD
DECLARE FUNCTION ToAscii LIB "USER32.DLL" ALIAS "ToAscii" (BYVAL uVirtKey AS DWORD, BYVAL uScanCode AS DWORD, lpbKeyState AS BYTE, lpwTransKey AS LONG, BYVAL fuState AS DWORD) AS LONG
DECLARE FUNCTION ToAsciiEx LIB "USER32.DLL" ALIAS "ToAsciiEx" (BYVAL uVirtKey AS DWORD, BYVAL uScanCode AS DWORD, lpKeyState AS ANY, lpChar AS LONG, BYVAL uFlags AS DWORD, BYVAL dwHKL AS DWORD) AS LONG
DECLARE FUNCTION ToUnicode LIB "USER32.DLL" ALIAS "ToUnicode" (BYVAL uVirtKey AS DWORD, BYVAL uScanCode AS DWORD, lpKeyState AS ANY, pwszBuff AS ANY, BYVAL cchBuff AS LONG, BYVAL uFlags AS DWORD) AS LONG
DECLARE FUNCTION TrackPopupMenu LIB "USER32.DLL" ALIAS "TrackPopupMenu" (BYVAL hMenu AS DWORD, BYVAL uFlags AS DWORD, BYVAL x AS LONG, BYVAL y AS LONG, BYVAL nReserved AS LONG, BYVAL hWnd AS DWORD, lprc AS RECT) AS LONG
DECLARE FUNCTION TrackPopupMenuEx LIB "USER32.DLL" ALIAS "TrackPopupMenuEx" (BYVAL hMenu AS DWORD, BYVAL uFlags AS DWORD, BYVAL x AS LONG, BYVAL y AS LONG, BYVAL hWnd AS DWORD, lpTPMParams AS TPMPARAMS) AS LONG
DECLARE FUNCTION TranslateAccelerator LIB "USER32.DLL" ALIAS "TranslateAcceleratorA" (BYVAL hWnd AS DWORD, BYVAL hAccTable AS DWORD, lpMsg AS tagMSG) AS LONG
DECLARE FUNCTION TranslateMDISysAccel LIB "USER32.DLL" ALIAS "TranslateMDISysAccel" (BYVAL hWndClient AS DWORD, lpMsg AS tagMSG) AS LONG
DECLARE FUNCTION TranslateMessage LIB "USER32.DLL" ALIAS "TranslateMessage" (lpMsg AS tagMSG) AS LONG
DECLARE FUNCTION UnhookWindowsHook LIB "USER32.DLL" ALIAS "UnhookWindowsHook" (BYVAL nCode AS LONG, BYVAL pfnFilterProc AS DWORD) AS LONG
DECLARE FUNCTION UnhookWindowsHookEx LIB "USER32.DLL" ALIAS "UnhookWindowsHookEx" (BYVAL hHook AS DWORD) AS LONG
DECLARE FUNCTION UnionRect LIB "USER32.DLL" ALIAS "UnionRect" (lpDestRect AS RECT, lpSrc1Rect AS RECT, lpSrc2Rect AS RECT) AS LONG
DECLARE FUNCTION UnloadKeyboardLayout LIB "USER32.DLL" ALIAS "UnloadKeyboardLayout" (BYVAL HKL AS DWORD) AS LONG
DECLARE FUNCTION UnpackDDElParam LIB "USER32.DLL" ALIAS "UnpackDDElParam" (BYVAL msg AS LONG, BYVAL lParam AS LONG, puiLo AS DWORD, puiHi AS DWORD) AS LONG
DECLARE FUNCTION UnregisterClass LIB "USER32.DLL" ALIAS "UnregisterClassA" (lpClassName AS ASCIIZ, BYVAL hInstance AS DWORD) AS LONG
DECLARE FUNCTION UnregisterHotKey LIB "USER32.DLL" ALIAS "UnregisterHotKey" (BYVAL hWnd AS DWORD, BYVAL id AS LONG) AS LONG
DECLARE FUNCTION UpdateWindow LIB "USER32.DLL" ALIAS "UpdateWindow" (BYVAL hWnd AS DWORD) AS LONG
DECLARE FUNCTION ValidateRect LIB "USER32.DLL" ALIAS "ValidateRect" (BYVAL hWnd AS DWORD, lpRect AS RECT) AS LONG
DECLARE FUNCTION ValidateRgn LIB "USER32.DLL" ALIAS "ValidateRgn" (BYVAL hWnd AS DWORD, BYVAL hRgn AS DWORD) AS LONG
DECLARE FUNCTION VkKeyScan LIB "USER32.DLL" ALIAS "VkKeyScanA" (BYVAL cChar AS BYTE) AS INTEGER
DECLARE FUNCTION VkKeyScanEx LIB "USER32.DLL" ALIAS "VkKeyScanExA" (BYVAL ch AS BYTE, BYVAL dwHKL AS DWORD) AS INTEGER
DECLARE FUNCTION WaitForInputIdle LIB "USER32.DLL" ALIAS "WaitForInputIdle" (BYVAL hProcess AS DWORD, BYVAL dwMilliseconds AS DWORD) AS LONG
DECLARE FUNCTION WaitMessage LIB "USER32.DLL" ALIAS "WaitMessage" () AS LONG
DECLARE FUNCTION WinHelp LIB "USER32.DLL" ALIAS "WinHelpA" (BYVAL hWnd AS DWORD, lpHelpFile AS ASCIIZ, BYVAL uCommand AS DWORD, BYVAL dwData AS DWORD) AS LONG
DECLARE FUNCTION WindowFromDC LIB "USER32.DLL" ALIAS "WindowFromDC" (BYVAL hDC AS DWORD) AS LONG
DECLARE FUNCTION WindowFromPoint LIB "USER32.DLL" ALIAS "WindowFromPoint" (BYVAL xPoint AS LONG, BYVAL yPoint AS LONG) AS LONG
DECLARE SUB PostQuitMessage LIB "USER32.DLL" ALIAS "PostQuitMessage" (BYVAL nExitCode AS LONG)
DECLARE SUB keybd_event LIB "USER32.DLL" ALIAS "keybd_event" (BYVAL bVk AS BYTE, BYVAL bScan AS BYTE, BYVAL dwFlags AS DWORD, BYVAL dwExtraInfo AS DWORD)
DECLARE SUB mouse_event LIB "USER32.DLL" ALIAS "mouse_event" (BYVAL dwFlags AS DWORD, BYVAL dx AS DWORD, BYVAL dy AS DWORD, BYVAL cButtons AS DWORD, BYVAL dwExtraInfo AS DWORD)
DECLARE SUB SetDebugErrorLevel LIB "USER32.DLL" ALIAS "SetDebugErrorLevel" (BYVAL dwLevel AS DWORD)
DECLARE SUB SetLastErrorEx LIB "USER32.DLL" ALIAS "SetLastErrorEx" (BYVAL dwErrCode AS DWORD, BYVAL dwType AS DWORD)

#IF %DEF(%NOBYVALPTR)
    DECLARE FUNCTION wsprintf CDECL LIB "USER32.DLL" ALIAS "wsprintfA" (lpOutput AS ASCIIZ, lpFormat AS ASCIIZ, x AS ANY[, x1 AS ANY, x2 AS ANY, x3 AS ANY, x4 AS ANY, x5 AS ANY, x6 AS ANY, x7 AS ANY, x8 AS ANY, x9 AS ANY, _
        x10 AS ANY, x11 AS ANY, x12 AS ANY]) AS LONG
#ELSE
    DECLARE FUNCTION wsprintf CDECL LIB "USER32.DLL" ALIAS "wsprintfA" (lpOutput AS ASCIIZ, lpFormat AS ASCIIZ, x AS ANY, OPTIONAL x1 AS ANY, OPTIONAL x2 AS ANY, OPTIONAL x3 AS ANY, OPTIONAL x4 AS ANY, OPTIONAL x5 AS ANY, _
        OPTIONAL x6 AS ANY, OPTIONAL x7 AS ANY, OPTIONAL x8 AS ANY, OPTIONAL x9 AS ANY, OPTIONAL x10 AS ANY, OPTIONAL x11 AS ANY, OPTIONAL x12 AS ANY) AS LONG
#ENDIF

' Multimedia declares from mmsystem.h =========================================

DECLARE FUNCTION CloseDriver LIB "WINMM.DLL" ALIAS "CloseDriver" (BYVAL hDriver AS DWORD, BYVAL lParam1 AS LONG, BYVAL lParam2 AS LONG) AS LONG
DECLARE FUNCTION DefDriverProc LIB "WINMM.DLL" ALIAS "DefDriverProc" (BYVAL dwDriverIdentifier AS DWORD, BYVAL hDriver AS DWORD, BYVAL uMsg AS DWORD, BYVAL lParam1 AS LONG, BYVAL lParam2 AS LONG) AS LONG
DECLARE FUNCTION DrvGetModuleHandle LIB "WINMM.DLL" ALIAS "DrvGetModuleHandle" (BYVAL hDriver AS DWORD) AS LONG
DECLARE FUNCTION GetDriverModuleHandle LIB "WINMM.DLL" ALIAS "GetDriverModuleHandle" (BYVAL hDriver AS DWORD) AS LONG
DECLARE FUNCTION OpenDriver LIB "WINMM.DLL" ALIAS "OpenDriver" (szDriverName AS ASCIIZ, szSectionName AS ASCIIZ, BYVAL lParam2 AS LONG) AS LONG
DECLARE FUNCTION PlaySound LIB "WINMM.DLL" ALIAS "PlaySoundA" (lpszName AS ASCIIZ, BYVAL hModule AS DWORD, BYVAL dwFlags AS DWORD) AS LONG
DECLARE FUNCTION SendDriverMessage LIB "WINMM.DLL" ALIAS "SendDriverMessage" (BYVAL hDriver AS DWORD, BYVAL message AS LONG, BYVAL lParam1 AS LONG, BYVAL lParam2 AS LONG) AS LONG

DECLARE FUNCTION auxGetDevCaps LIB "WINMM.DLL" ALIAS "auxGetDevCapsA" (BYVAL uDeviceID AS DWORD, lpCaps AS AUXCAPS, BYVAL uSize AS DWORD) AS DWORD
DECLARE FUNCTION auxGetNumDevs LIB "WINMM.DLL" ALIAS "auxGetNumDevs" () AS LONG
DECLARE FUNCTION auxGetVolume LIB "WINMM.DLL" ALIAS "auxGetVolume" (BYVAL uDeviceID AS DWORD, lpdwVolume AS DWORD) AS LONG
DECLARE FUNCTION auxOutMessage LIB "WINMM.DLL" ALIAS "auxOutMessage" (BYVAL uDeviceID AS DWORD, BYVAL uMsg AS DWORD, BYVAL dwParam1 AS DWORD, BYVAL dwParam2 AS DWORD) AS LONG
DECLARE FUNCTION auxSetVolume LIB "WINMM.DLL" ALIAS "auxSetVolume" (BYVAL uDeviceID AS DWORD, BYVAL dwVolume AS DWORD) AS LONG
DECLARE FUNCTION joyGetDevCaps LIB "WINMM.DLL" ALIAS "joyGetDevCapsA" (BYVAL id AS LONG, lpCaps AS JOYCAPS, BYVAL uSize AS DWORD) AS LONG
DECLARE FUNCTION joyGetNumDevs LIB "WINMM.DLL" ALIAS "joyGetNumDevs" () AS LONG
DECLARE FUNCTION joyGetPos LIB "WINMM.DLL" ALIAS "joyGetPos" (BYVAL uJoyId AS DWORD, pji AS JOYINFO) AS LONG
DECLARE FUNCTION joyGetPosEx LIB "WINMM.DLL" ALIAS "joyGetPosEx" (BYVAL uJoyId AS DWORD, pji AS JOYINFOEX) AS LONG
DECLARE FUNCTION joyGetThreshold LIB "WINMM.DLL" ALIAS "joyGetThreshold" (BYVAL id AS LONG, lpuThreshold AS DWORD) AS LONG
DECLARE FUNCTION joyReleaseCapture LIB "WINMM.DLL" ALIAS "joyReleaseCapture" (BYVAL id AS LONG) AS LONG
DECLARE FUNCTION joySetCapture LIB "WINMM.DLL" ALIAS "joySetCapture" (BYVAL hWnd AS DWORD, BYVAL uId AS DWORD, BYVAL uPeriod AS DWORD, BYVAL bChanged AS LONG) AS LONG
DECLARE FUNCTION joySetThreshold LIB "WINMM.DLL" ALIAS "joySetThreshold" (BYVAL id AS LONG, BYVAL uThreshold AS DWORD) AS LONG
DECLARE FUNCTION mciExecute LIB "WINMM.DLL" ALIAS "mciExecute" (lpstrCommand AS ASCIIZ) AS LONG
DECLARE FUNCTION mciGetCreatorTask LIB "WINMM.DLL" ALIAS "mciGetCreatorTask" (BYVAL wDeviceId AS DWORD) AS LONG
DECLARE FUNCTION mciGetDeviceID LIB "WINMM.DLL" ALIAS "mciGetDeviceIDA" (lpstrName AS ASCIIZ) AS LONG
DECLARE FUNCTION mciGetDeviceIDFromElementID LIB "WINMM.DLL" ALIAS "mciGetDeviceIDFromElementIDA" (BYVAL dwElementId AS DWORD, lpstrType AS ASCIIZ) AS LONG
DECLARE FUNCTION mciGetErrorString LIB "WINMM.DLL" ALIAS "mciGetErrorStringA" (BYVAL dwError AS DWORD, lpstrBuffer AS ASCIIZ, BYVAL uLength AS DWORD) AS LONG
DECLARE FUNCTION mciGetYieldProc LIB "WINMM.DLL" ALIAS "mciGetYieldProc" (BYVAL mciId AS LONG, pdwYieldData AS DWORD) AS LONG
DECLARE FUNCTION mciSendCommand LIB "WINMM.DLL" ALIAS "mciSendCommandA" (BYVAL wDeviceId AS DWORD, BYVAL uMessage AS DWORD, BYVAL dwParam1 AS DWORD, BYVAL dwParam2 AS DWORD) AS LONG
DECLARE FUNCTION mciSendString LIB "WINMM.DLL" ALIAS "mciSendStringA" (lpstrCommand AS ASCIIZ, lpstrReturnString AS ASCIIZ, BYVAL uReturnLength AS DWORD, BYVAL hwndCallback AS DWORD) AS LONG
DECLARE FUNCTION mciSetYieldProc LIB "WINMM.DLL" ALIAS "mciSetYieldProc" (BYVAL mciId AS LONG, BYVAL fpYieldProc AS LONG, BYVAL dwYieldData AS DWORD) AS LONG
DECLARE FUNCTION midiConnect LIB "WINMM.DLL" ALIAS "midiConnect" (BYVAL hmi AS DWORD, BYVAL hmo AS DWORD, pReserved AS ANY) AS LONG
DECLARE FUNCTION midiDisconnect LIB "WINMM.DLL" ALIAS "midiDisconnect" (BYVAL hmi AS DWORD, BYVAL hmo AS DWORD, pReserved AS ANY) AS LONG
DECLARE FUNCTION midiInAddBuffer LIB "WINMM.DLL" ALIAS "midiInAddBuffer" (BYVAL hMidiIn AS DWORD, lpMidiInHdr AS MIDIHDR, BYVAL uSize AS DWORD) AS LONG
DECLARE FUNCTION midiInClose LIB "WINMM.DLL" ALIAS "midiInClose" (BYVAL hMidiIn AS DWORD) AS LONG
DECLARE FUNCTION midiInGetDevCaps LIB "WINMM.DLL" ALIAS "midiInGetDevCapsA" (BYVAL uDeviceID AS DWORD, lpCaps AS MIDIINCAPS, BYVAL uSize AS DWORD) AS LONG
DECLARE FUNCTION midiInGetErrorText LIB "WINMM.DLL" ALIAS "midiInGetErrorTextA" (BYVAL xerr AS LONG, lpText AS ASCIIZ, BYVAL uSize AS DWORD) AS LONG
DECLARE FUNCTION midiInGetID LIB "WINMM.DLL" ALIAS "midiInGetID" (BYVAL hMidiIn AS DWORD, lpuDeviceId AS DWORD) AS LONG
DECLARE FUNCTION midiInGetNumDevs LIB "WINMM.DLL" ALIAS "midiInGetNumDevs" () AS LONG
DECLARE FUNCTION midiInMessage LIB "WINMM.DLL" ALIAS "midiInMessage" (BYVAL hMidiIn AS DWORD, BYVAL msg AS LONG, BYVAL dw1 AS DWORD, BYVAL dw2 AS DWORD) AS LONG
DECLARE FUNCTION midiInOpen LIB "WINMM.DLL" ALIAS "midiInOpen" (lphMidiIn AS DWORD, BYVAL uDeviceID AS DWORD, BYVAL dwCallback AS DWORD, BYVAL dwInstance AS DWORD, BYVAL dwFlags AS DWORD) AS LONG
DECLARE FUNCTION midiInPrepareHeader LIB "WINMM.DLL" ALIAS "midiInPrepareHeader" (BYVAL hMidiIn AS DWORD, lpMidiInHdr AS MIDIHDR, BYVAL uSize AS DWORD) AS LONG
DECLARE FUNCTION midiInReset LIB "WINMM.DLL" ALIAS "midiInReset" (BYVAL hMidiIn AS DWORD) AS LONG
DECLARE FUNCTION midiInStart LIB "WINMM.DLL" ALIAS "midiInStart" (BYVAL hMidiIn AS DWORD) AS LONG
DECLARE FUNCTION midiInStop LIB "WINMM.DLL" ALIAS "midiInStop" (BYVAL hMidiIn AS DWORD) AS LONG
DECLARE FUNCTION midiInUnprepareHeader LIB "WINMM.DLL" ALIAS "midiInUnprepareHeader" (BYVAL hMidiIn AS DWORD, lpMidiInHdr AS MIDIHDR, BYVAL uSize AS DWORD) AS LONG
DECLARE FUNCTION midiOutCacheDrumPatches LIB "WINMM.DLL" ALIAS "midiOutCacheDrumPatches" (BYVAL hMidiOut AS DWORD, BYVAL uPatch AS DWORD, lpKeyArray AS LONG, BYVAL uFlags AS DWORD) AS LONG
DECLARE FUNCTION midiOutCachePatches LIB "WINMM.DLL" ALIAS "midiOutCachePatches" (BYVAL hMidiOut AS DWORD, BYVAL uBank AS DWORD, lpPatchArray AS LONG, BYVAL uFlags AS DWORD) AS LONG
DECLARE FUNCTION midiOutClose LIB "WINMM.DLL" ALIAS "midiOutClose" (BYVAL hMidiOut AS DWORD) AS LONG
DECLARE FUNCTION midiOutGetDevCaps LIB "WINMM.DLL" ALIAS "midiOutGetDevCapsA" (BYVAL uDeviceID AS DWORD, lpCaps AS MIDIOUTCAPS, BYVAL uSize AS DWORD) AS LONG
DECLARE FUNCTION midiOutGetErrorText LIB "WINMM.DLL" ALIAS "midiOutGetErrorTextA" (BYVAL xerr AS LONG, lpText AS ASCIIZ, BYVAL uSize AS DWORD) AS LONG
DECLARE FUNCTION midiOutGetID LIB "WINMM.DLL" ALIAS "midiOutGetID" (BYVAL hMidiOut AS DWORD, lpuDeviceId AS DWORD) AS LONG
DECLARE FUNCTION midiOutGetNumDevs LIB "WINMM.DLL" ALIAS "midiOutGetNumDevs" () AS LONG
DECLARE FUNCTION midiOutGetVolume LIB "WINMM.DLL" ALIAS "midiOutGetVolume" (BYVAL uDeviceID AS DWORD, lpdwVolume AS DWORD) AS LONG
DECLARE FUNCTION midiOutLongMsg LIB "WINMM.DLL" ALIAS "midiOutLongMsg" (BYVAL hMidiOut AS DWORD, lpMidiOutHdr AS MIDIHDR, BYVAL uSize AS DWORD) AS LONG
DECLARE FUNCTION midiOutMessage LIB "WINMM.DLL" ALIAS "midiOutMessage" (BYVAL hMidiOut AS DWORD, BYVAL msg AS LONG, BYVAL dw1 AS DWORD, BYVAL dw2 AS DWORD) AS LONG
DECLARE FUNCTION midiOutOpen LIB "WINMM.DLL" ALIAS "midiOutOpen" (lphMidiOut AS DWORD, BYVAL uDeviceID AS DWORD, BYVAL dwCallback AS DWORD, BYVAL dwInstance AS DWORD, BYVAL dwFlags AS DWORD) AS LONG
DECLARE FUNCTION midiOutPrepareHeader LIB "WINMM.DLL" ALIAS "midiOutPrepareHeader" (BYVAL hMidiOut AS DWORD, lpMidiOutHdr AS MIDIHDR, BYVAL uSize AS DWORD) AS LONG
DECLARE FUNCTION midiOutReset LIB "WINMM.DLL" ALIAS "midiOutReset" (BYVAL hMidiOut AS DWORD) AS LONG
DECLARE FUNCTION midiOutSetVolume LIB "WINMM.DLL" ALIAS "midiOutSetVolume" (BYVAL uDeviceID AS DWORD, BYVAL dwVolume AS DWORD) AS LONG
DECLARE FUNCTION midiOutShortMsg LIB "WINMM.DLL" ALIAS "midiOutShortMsg" (BYVAL hMidiOut AS DWORD, BYVAL dwMsg AS DWORD) AS LONG
DECLARE FUNCTION midiOutUnprepareHeader LIB "WINMM.DLL" ALIAS "midiOutUnprepareHeader" (BYVAL hMidiOut AS DWORD, lpMidiOutHdr AS MIDIHDR, BYVAL uSize AS DWORD) AS LONG
DECLARE FUNCTION midiStreamClose LIB "WINMM.DLL" ALIAS "midiStreamClose" (BYVAL hms AS DWORD) AS LONG
DECLARE FUNCTION midiStreamOpen LIB "WINMM.DLL" ALIAS "midiStreamOpen" (phms AS LONG, puDeviceId AS DWORD, BYVAL cMidi AS LONG, BYVAL dwCallback AS DWORD, BYVAL dwInstance AS DWORD, BYVAL fdwOpen AS DWORD) AS LONG
DECLARE FUNCTION midiStreamOut LIB "WINMM.DLL" ALIAS "midiStreamOut" (BYVAL hms AS DWORD, pmh AS MIDIHDR, BYVAL cbMidiHdr AS DWORD) AS LONG
DECLARE FUNCTION midiStreamPause LIB "WINMM.DLL" ALIAS "midiStreamPause" (BYVAL hms AS DWORD) AS LONG
DECLARE FUNCTION midiStreamPosition LIB "WINMM.DLL" ALIAS "midiStreamPosition" (BYVAL hms AS DWORD, lpmmt AS MMTIME, BYVAL cbmmt AS DWORD) AS LONG
DECLARE FUNCTION midiStreamProperty LIB "WINMM.DLL" ALIAS "midiStreamProperty" (BYVAL hms AS DWORD, lppropdata AS BYTE, BYVAL dwProperty AS DWORD) AS LONG
DECLARE FUNCTION midiStreamRestart LIB "WINMM.DLL" ALIAS "midiStreamRestart" (BYVAL hms AS DWORD) AS LONG
DECLARE FUNCTION midiStreamStop LIB "WINMM.DLL" ALIAS "midiStreamStop" (BYVAL hms AS DWORD) AS LONG
DECLARE FUNCTION mixerClose LIB "WINMM.DLL" ALIAS "mixerClose" (BYVAL hmx AS DWORD) AS LONG
DECLARE FUNCTION mixerGetControlDetails LIB "WINMM.DLL" ALIAS "mixerGetControlDetailsA" (BYVAL hmxobj AS DWORD, pmxcd AS MIXERCONTROLDETAILS, BYVAL fdwDetails AS DWORD) AS LONG
DECLARE FUNCTION mixerGetDevCaps LIB "WINMM.DLL" ALIAS "mixerGetDevCapsA" (BYVAL uMxId AS DWORD, pmxcaps AS MIXERCAPS, BYVAL cbmxcaps AS DWORD) AS LONG
DECLARE FUNCTION mixerGetID LIB "WINMM.DLL" ALIAS "mixerGetID" (BYVAL hmxobj AS DWORD, pumxId AS DWORD, BYVAL fdwId AS DWORD) AS LONG
DECLARE FUNCTION mixerGetLineControls LIB "WINMM.DLL" ALIAS "mixerGetLineControlsA" (BYVAL hmxobj AS DWORD, pmxlc AS MIXERLINECONTROLS, BYVAL fdwControls AS DWORD) AS LONG
DECLARE FUNCTION mixerGetLineInfo LIB "WINMM.DLL" ALIAS "mixerGetLineInfoA" (BYVAL hmxobj AS DWORD, pmxl AS MIXERLINE, BYVAL fdwInfo AS DWORD) AS LONG
DECLARE FUNCTION mixerGetNumDevs LIB "WINMM.DLL" ALIAS "mixerGetNumDevs" () AS LONG
DECLARE FUNCTION mixerMessage LIB "WINMM.DLL" ALIAS "mixerMessage" (BYVAL hmx AS DWORD, BYVAL uMsg AS DWORD, BYVAL dwParam1 AS DWORD, BYVAL dwParam2 AS DWORD) AS LONG
DECLARE FUNCTION mixerOpen LIB "WINMM.DLL" ALIAS "mixerOpen" (phmx AS DWORD, BYVAL uMxId AS DWORD, BYVAL dwCallback AS DWORD, BYVAL dwInstance AS DWORD, BYVAL fdwOpen AS DWORD) AS LONG
DECLARE FUNCTION mixerSetControlDetails LIB "WINMM.DLL" ALIAS "mixerSetControlDetails" (BYVAL hmxobj AS DWORD, pmxcd AS MIXERCONTROLDETAILS, BYVAL fdwDetails AS DWORD) AS LONG
DECLARE FUNCTION mmioAdvance LIB "WINMM.DLL" ALIAS "mmioAdvance" (BYVAL hmmio AS DWORD, lpmmioinfo AS MMIOINFO, BYVAL uFlags AS DWORD) AS LONG
DECLARE FUNCTION mmioAscend LIB "WINMM.DLL" ALIAS "mmioAscend" (BYVAL hmmio AS DWORD, lpck AS MMCKINFO, BYVAL uFlags AS DWORD) AS LONG
DECLARE FUNCTION mmioClose LIB "WINMM.DLL" ALIAS "mmioClose" (BYVAL hmmio AS DWORD, BYVAL uFlags AS DWORD) AS LONG
DECLARE FUNCTION mmioCreateChunk LIB "WINMM.DLL" ALIAS "mmioCreateChunk" (BYVAL hmmio AS DWORD, lpck AS MMCKINFO, BYVAL uFlags AS DWORD) AS LONG
DECLARE FUNCTION mmioDescend LIB "WINMM.DLL" ALIAS "mmioDescend" (BYVAL hmmio AS DWORD, lpck AS MMCKINFO, lpckParent AS MMCKINFO, BYVAL uFlags AS DWORD) AS LONG
DECLARE FUNCTION mmioFlush LIB "WINMM.DLL" ALIAS "mmioFlush" (BYVAL hmmio AS DWORD, BYVAL uFlags AS DWORD) AS LONG
DECLARE FUNCTION mmioGetInfo LIB "WINMM.DLL" ALIAS "mmioGetInfo" (BYVAL hmmio AS DWORD, lpmmioinfo AS MMIOINFO, BYVAL uFlags AS DWORD) AS LONG
DECLARE FUNCTION mmioInstallIOProcA LIB "WINMM.DLL" ALIAS "mmioInstallIOProcA" (fccIOProc AS ASCIIZ * 4, BYVAL pIOProc AS LONG, BYVAL dwFlags AS DWORD) AS LONG
DECLARE FUNCTION mmioOpen LIB "WINMM.DLL" ALIAS "mmioOpenA" (szFileName AS ASCIIZ, lpmmioinfo AS MMIOINFO, BYVAL dwOpenFlags AS DWORD) AS LONG
DECLARE FUNCTION mmioRead LIB "WINMM.DLL" ALIAS "mmioRead" (BYVAL hmmio AS DWORD, pch AS ASCIIZ, BYVAL cch AS LONG) AS LONG
DECLARE FUNCTION mmioRename LIB "WINMM.DLL" ALIAS "mmioRenameA" (szFileName AS ASCIIZ, SzNewFileName AS ASCIIZ, lpmmioinfo AS MMIOINFO, BYVAL dwRenameFlags AS DWORD) AS LONG
DECLARE FUNCTION mmioSeek LIB "WINMM.DLL" ALIAS "mmioSeek" (BYVAL hmmio AS DWORD, BYVAL lOffset AS LONG, BYVAL iOrigin AS LONG) AS LONG
DECLARE FUNCTION mmioSendMessage LIB "WINMM.DLL" ALIAS "mmioSendMessage" (BYVAL hmmio AS DWORD, BYVAL uMsg AS DWORD, BYVAL lParam1 AS LONG, BYVAL lParam2 AS LONG) AS LONG
DECLARE FUNCTION mmioSetBuffer LIB "WINMM.DLL" ALIAS "mmioSetBuffer" (BYVAL hmmio AS DWORD, pchBuffer AS ASCIIZ, BYVAL cchBuffer AS LONG, BYVAL uFlags AS DWORD) AS LONG
DECLARE FUNCTION mmioSetInfo LIB "WINMM.DLL" ALIAS "mmioSetInfo" (BYVAL hmmio AS DWORD, lpmmioinfo AS MMIOINFO, BYVAL uFlags AS DWORD) AS LONG
DECLARE FUNCTION mmioStringToFOURCC LIB "WINMM.DLL" ALIAS "mmioStringToFOURCCA" (sz AS ASCIIZ, BYVAL uFlags AS DWORD) AS LONG
DECLARE FUNCTION mmioWrite LIB "WINMM.DLL" ALIAS "mmioWrite" (BYVAL hmmio AS DWORD, pch AS ASCIIZ, BYVAL cch AS LONG) AS LONG
DECLARE FUNCTION mmsystemGetVersion LIB "WINMM.DLL" ALIAS "mmsystemGetVersion" () AS LONG
DECLARE FUNCTION sndPlaySound LIB "WINMM.DLL" ALIAS "sndPlaySoundA" (lpszSoundName AS ASCIIZ, BYVAL uFlags AS DWORD) AS LONG
DECLARE FUNCTION timeBeginPeriod LIB "WINMM.DLL" ALIAS "timeBeginPeriod" (BYVAL uPeriod AS DWORD) AS DWORD
DECLARE FUNCTION timeEndPeriod LIB "WINMM.DLL" ALIAS "timeEndPeriod" (BYVAL uPeriod AS DWORD) AS DWORD
DECLARE FUNCTION timeGetDevCaps LIB "WINMM.DLL" ALIAS "timeGetDevCaps" (lpTimeCaps AS TIMECAPS, BYVAL uSize AS DWORD) AS DWORD
DECLARE FUNCTION timeGetSystemTime LIB "WINMM.DLL" ALIAS "timeGetSystemTime" (lpTime AS MMTIME, BYVAL uSize AS DWORD) AS DWORD
DECLARE FUNCTION timeGetTime LIB "WINMM.DLL" ALIAS "timeGetTime" () AS DWORD
DECLARE FUNCTION timeKillEvent LIB "WINMM.DLL" ALIAS "timeKillEvent" (BYVAL uId AS DWORD) AS DWORD
DECLARE FUNCTION timeSetEvent LIB "WINMM.DLL" ALIAS "timeSetEvent" (BYVAL uDelay AS DWORD, BYVAL uResolution AS DWORD, BYVAL lpFunction AS DWORD, BYVAL dwUser AS DWORD, BYVAL uFlags AS DWORD) AS DWORD
DECLARE FUNCTION waveInAddBuffer LIB "WINMM.DLL" ALIAS "waveInAddBuffer" (BYVAL hWaveIn AS DWORD, lpWaveInHdr AS WAVEHDR, BYVAL uSize AS DWORD) AS LONG
DECLARE FUNCTION waveInClose LIB "WINMM.DLL" ALIAS "waveInClose" (BYVAL hWaveIn AS DWORD) AS LONG
DECLARE FUNCTION waveInGetDevCaps LIB "WINMM.DLL" ALIAS "waveInGetDevCapsA" (BYVAL uDeviceID AS DWORD, lpCaps AS WAVEINCAPS, BYVAL uSize AS DWORD) AS LONG
DECLARE FUNCTION waveInGetErrorText LIB "WINMM.DLL" ALIAS "waveInGetErrorTextA" (BYVAL xerr AS LONG, lpText AS ASCIIZ, BYVAL uSize AS DWORD) AS LONG
DECLARE FUNCTION waveInGetID LIB "WINMM.DLL" ALIAS "waveInGetID" (BYVAL hWaveIn AS DWORD, lpuDeviceId AS DWORD) AS LONG
DECLARE FUNCTION waveInGetNumDevs LIB "WINMM.DLL" ALIAS "waveInGetNumDevs" () AS LONG
DECLARE FUNCTION waveInGetPosition LIB "WINMM.DLL" ALIAS "waveInGetPosition" (BYVAL hWaveIn AS DWORD, lpInfo AS MMTIME, BYVAL uSize AS DWORD) AS LONG
DECLARE FUNCTION waveInMessage LIB "WINMM.DLL" ALIAS "waveInMessage" (BYVAL hWaveIn AS DWORD, BYVAL uMsg AS LONG, BYVAL dwParam1 AS DWORD, BYVAL dwParam2 AS DWORD) AS LONG
DECLARE FUNCTION waveInOpen LIB "WINMM.DLL" ALIAS "waveInOpen" (lphWaveIn AS DWORD, BYVAL uDeviceID AS DWORD, lpFormat AS WAVEFORMATEX, BYVAL dwCallback AS DWORD, BYVAL dwInstance AS DWORD, BYVAL dwFlags AS DWORD) AS LONG
DECLARE FUNCTION waveInPrepareHeader LIB "WINMM.DLL" ALIAS "waveInPrepareHeader" (BYVAL hWaveIn AS DWORD, lpWaveInHdr AS WAVEHDR, BYVAL uSize AS DWORD) AS LONG
DECLARE FUNCTION waveInReset LIB "WINMM.DLL" ALIAS "waveInReset" (BYVAL hWaveIn AS DWORD) AS LONG
DECLARE FUNCTION waveInStart LIB "WINMM.DLL" ALIAS "waveInStart" (BYVAL hWaveIn AS DWORD) AS LONG
DECLARE FUNCTION waveInStop LIB "WINMM.DLL" ALIAS "waveInStop" (BYVAL hWaveIn AS DWORD) AS LONG
DECLARE FUNCTION waveInUnprepareHeader LIB "WINMM.DLL" ALIAS "waveInUnprepareHeader" (BYVAL hWaveIn AS DWORD, lpWaveInHdr AS WAVEHDR, BYVAL uSize AS DWORD) AS LONG
DECLARE FUNCTION waveOutBreakLoop LIB "WINMM.DLL" ALIAS "waveOutBreakLoop" (BYVAL hWaveOut AS DWORD) AS LONG
DECLARE FUNCTION waveOutClose LIB "WINMM.DLL" ALIAS "waveOutClose" (BYVAL hWaveOut AS DWORD) AS LONG
DECLARE FUNCTION waveOutGetDevCaps LIB "WINMM.DLL" ALIAS "waveOutGetDevCapsA" (BYVAL uDeviceID AS DWORD, lpCaps AS WAVEOUTCAPS, BYVAL uSize AS DWORD) AS LONG
DECLARE FUNCTION waveOutGetErrorText LIB "WINMM.DLL" ALIAS "waveOutGetErrorTextA" (BYVAL xerr AS LONG, lpText AS ASCIIZ, BYVAL uSize AS DWORD) AS LONG
DECLARE FUNCTION waveOutGetID LIB "WINMM.DLL" ALIAS "waveOutGetID" (BYVAL hWaveOut AS DWORD, lpuDeviceID AS DWORD) AS LONG
DECLARE FUNCTION waveOutGetNumDevs LIB "WINMM.DLL" ALIAS "waveOutGetNumDevs" () AS LONG
DECLARE FUNCTION waveOutGetPitch LIB "WINMM.DLL" ALIAS "waveOutGetPitch" (BYVAL hWaveOut AS DWORD, lpdwPitch AS DWORD) AS LONG
DECLARE FUNCTION waveOutGetPlaybackRate LIB "WINMM.DLL" ALIAS "waveOutGetPlaybackRate" (BYVAL hWaveOut AS DWORD, lpdwRate AS DWORD) AS LONG
DECLARE FUNCTION waveOutGetPosition LIB "WINMM.DLL" ALIAS "waveOutGetPosition" (BYVAL hWaveOut AS DWORD, lpInfo AS MMTIME, BYVAL uSize AS DWORD) AS LONG
DECLARE FUNCTION waveOutGetVolume LIB "WINMM.DLL" ALIAS "waveOutGetVolume" (BYVAL uDeviceID AS DWORD, lpdwVolume AS DWORD) AS LONG
DECLARE FUNCTION waveOutMessage LIB "WINMM.DLL" ALIAS "waveOutMessage" (BYVAL hWaveOut AS DWORD, BYVAL uMsg AS DWORD, BYVAL dwParam1 AS DWORD, BYVAL dwParam2 AS DWORD) AS DWORD
DECLARE FUNCTION waveOutOpen LIB "WINMM.DLL" ALIAS "waveOutOpen" (lphWaveOut AS DWORD, BYVAL uDeviceID AS DWORD, lpFormat AS WAVEFORMATEX, BYVAL dwCallback AS DWORD, BYVAL dwInstance AS DWORD, BYVAL dwFlags AS DWORD) AS LONG
DECLARE FUNCTION waveOutPause LIB "WINMM.DLL" ALIAS "waveOutPause" (BYVAL hWaveOut AS DWORD) AS LONG
DECLARE FUNCTION waveOutPrepareHeader LIB "WINMM.DLL" ALIAS "waveOutPrepareHeader" (BYVAL hWaveOut AS DWORD, lpWaveOutHdr AS WAVEHDR, BYVAL uSize AS DWORD) AS LONG
DECLARE FUNCTION waveOutReset LIB "WINMM.DLL" ALIAS "waveOutReset" (BYVAL hWaveOut AS DWORD) AS LONG
DECLARE FUNCTION waveOutRestart LIB "WINMM.DLL" ALIAS "waveOutRestart" (BYVAL hWaveOut AS DWORD) AS LONG
DECLARE FUNCTION waveOutSetPitch LIB "WINMM.DLL" ALIAS "waveOutSetPitch" (BYVAL hWaveOut AS DWORD, BYVAL dwPitch AS DWORD) AS LONG
DECLARE FUNCTION waveOutSetPlaybackRate LIB "WINMM.DLL" ALIAS "waveOutSetPlaybackRate" (BYVAL hWaveOut AS DWORD, BYVAL dwRate AS DWORD) AS LONG
DECLARE FUNCTION waveOutSetVolume LIB "WINMM.DLL" ALIAS "waveOutSetVolume" (BYVAL uDeviceID AS DWORD, BYVAL dwVolume AS DWORD) AS LONG
DECLARE FUNCTION waveOutUnprepareHeader LIB "WINMM.DLL" ALIAS "waveOutUnprepareHeader" (BYVAL hWaveOut AS DWORD, lpWaveOutHdr AS WAVEHDR, BYVAL uSize AS DWORD) AS LONG
DECLARE FUNCTION waveOutWrite LIB "WINMM.DLL" ALIAS "waveOutWrite" (BYVAL hWaveOut AS DWORD, lpWaveOutHdr AS WAVEHDR, BYVAL uSize AS DWORD) AS LONG
DECLARE SUB OutputDebugStr LIB "WINMM.DLL" ALIAS "OutputDebugStr" (lpszOutputString AS ASCIIZ)

' End of declares from mmsystem.h =============================================

'  WINSPOOL.DRV Declares (Printer Support)

DECLARE FUNCTION AbortPrinter LIB "WINSPOOL.DRV" ALIAS "AbortPrinter" (BYVAL hPrinter AS DWORD) AS LONG
DECLARE FUNCTION AddForm LIB "WINSPOOL.DRV" ALIAS "AddFormA" (BYVAL hPrinter AS DWORD, BYVAL Level AS DWORD, pForm AS BYTE) AS LONG
DECLARE FUNCTION AddJob LIB "WINSPOOL.DRV" ALIAS "AddJobA" (BYVAL hPrinter AS DWORD, BYVAL Level AS DWORD, pData AS ANY, BYVAL cbBuf AS DWORD, pcbNeeded AS DWORD) AS LONG
DECLARE FUNCTION AddMonitor LIB "WINSPOOL.DRV" ALIAS "AddMonitorA" (pName AS ASCIIZ, BYVAL Level AS DWORD, pMonitors AS BYTE) AS LONG
DECLARE FUNCTION AddPort LIB "WINSPOOL.DRV" ALIAS "AddPortA" (pName AS ASCIIZ, BYVAL hWnd AS DWORD, pMonitorName AS ASCIIZ) AS LONG
DECLARE FUNCTION AddPrintProcessor LIB "WINSPOOL.DRV" ALIAS "AddPrintProcessorA" (pName AS ASCIIZ, pEnvironment AS ASCIIZ, pPathName AS ASCIIZ, pPrintProcessorName AS ASCIIZ) AS LONG
DECLARE FUNCTION AddPrintProvidor LIB "WINSPOOL.DRV" ALIAS "AddPrintProvidorA" (pName AS ASCIIZ, BYVAL Level AS DWORD, pProvidorInfo AS BYTE) AS LONG
DECLARE FUNCTION AddPrinter LIB "WINSPOOL.DRV" ALIAS "AddPrinterA" (pName AS ASCIIZ, BYVAL Level AS DWORD, pPrinter AS ANY) AS DWORD
DECLARE FUNCTION AddPrinterConnection LIB "WINSPOOL.DRV" ALIAS "AddPrinterConnectionA" (pName AS ASCIIZ) AS LONG
DECLARE FUNCTION AddPrinterDriver LIB "WINSPOOL.DRV" ALIAS "AddPrinterDriverA" (pName AS ASCIIZ, BYVAL Level AS DWORD, pDriverInfor AS ANY) AS LONG

#IF NOT %DEF(%NOGDI)
  DECLARE FUNCTION AdvancedDocumentProperties LIB "WINSPOOL.DRV" ALIAS "AdvancedDocumentPropertiesA" (BYVAL hWnd AS DWORD, BYVAL hPrinter AS DWORD, pDeviceName AS ASCIIZ, pDevModeOutput AS DEVMODE, pDevModeInput AS DEVMODE) AS LONG
#ENDIF

DECLARE FUNCTION ClosePrinter LIB "WINSPOOL.DRV" ALIAS "ClosePrinter" (BYVAL hPrinter AS DWORD) AS LONG
DECLARE FUNCTION ConfigurePort LIB "WINSPOOL.DRV" ALIAS "ConfigurePortA" (pName AS ASCIIZ, BYVAL hWnd AS DWORD, pPortName AS ASCIIZ) AS LONG
DECLARE FUNCTION ConnectToPrinterDlg LIB "WINSPOOL.DRV" ALIAS "ConnectToPrinterDlg" (BYVAL hWnd AS DWORD, BYVAL flags AS LONG) AS LONG
DECLARE FUNCTION DeleteForm LIB "WINSPOOL.DRV" ALIAS "DeleteFormA" (BYVAL hPrinter AS DWORD, pFormName AS ASCIIZ) AS LONG
DECLARE FUNCTION DeleteMonitor LIB "WINSPOOL.DRV" ALIAS "DeleteMonitorA" (pName AS ASCIIZ, pEnvironment AS ASCIIZ, pMonitorName AS ASCIIZ) AS LONG
DECLARE FUNCTION DeletePort LIB "WINSPOOL.DRV" ALIAS "DeletePortA" (pName AS ASCIIZ, BYVAL hWnd AS DWORD, pPortName AS ASCIIZ) AS LONG
DECLARE FUNCTION DeletePrintProcessor LIB "WINSPOOL.DRV" ALIAS "DeletePrintProcessorA" (pName AS ASCIIZ, pEnvironment AS ASCIIZ, pPrintProcessorName AS ASCIIZ) AS LONG
DECLARE FUNCTION DeletePrintProvidor LIB "WINSPOOL.DRV" ALIAS "DeletePrintProvidorA" (pName AS ASCIIZ, pEnvironment AS ASCIIZ, pPrintProvidorName AS ASCIIZ) AS LONG
DECLARE FUNCTION DeletePrinter LIB "WINSPOOL.DRV" ALIAS "DeletePrinter" (BYVAL hPrinter AS DWORD) AS LONG
DECLARE FUNCTION DeletePrinterConnection LIB "WINSPOOL.DRV" ALIAS "DeletePrinterConnectionA" (pName AS ASCIIZ) AS LONG
DECLARE FUNCTION DeletePrinterDriver LIB "WINSPOOL.DRV" ALIAS "DeletePrinterDriverA" (pName AS ASCIIZ, pEnvironment AS ASCIIZ, pDriverName AS ASCIIZ) AS LONG

#IF NOT %DEF(%NOGDI)
  DECLARE FUNCTION DocumentProperties LIB "WINSPOOL.DRV" ALIAS "DocumentPropertiesA" (BYVAL hWnd AS DWORD, BYVAL hPrinter AS DWORD, pDeviceName AS ASCIIZ, pDevModeOutput AS DEVMODE, pDevModeInput AS DEVMODE, BYVAL fMode AS LONG) AS LONG
#ENDIF

DECLARE FUNCTION EndDocPrinter LIB "WINSPOOL.DRV" ALIAS "EndDocPrinter" (BYVAL hPrinter AS DWORD) AS LONG
DECLARE FUNCTION EndPagePrinter LIB "WINSPOOL.DRV" ALIAS "EndPagePrinter" (BYVAL hPrinter AS DWORD) AS LONG
DECLARE FUNCTION EnumForms LIB "WINSPOOL.DRV" ALIAS "EnumFormsA" (BYVAL hPrinter AS DWORD, BYVAL Level AS DWORD, pForm AS ANY, BYVAL cbBuf AS DWORD, pcbNeeded AS DWORD, pcReturned AS DWORD) AS LONG
DECLARE FUNCTION EnumJobs LIB "WINSPOOL.DRV" ALIAS "EnumJobsA" (BYVAL hPrinter AS DWORD, BYVAL FirstJob AS LONG, BYVAL NoJobs AS LONG, BYVAL Level AS DWORD, pJob AS BYTE, BYVAL cbBuf AS DWORD, pcbNeeded AS DWORD, pcReturned AS DWORD) AS LONG
DECLARE FUNCTION EnumMonitors LIB "WINSPOOL.DRV" ALIAS "EnumMonitorsA" (pName AS ASCIIZ, BYVAL Level AS DWORD, pMonitors AS BYTE, BYVAL cbBuf AS DWORD, pcbNeeded AS DWORD, pcReturned AS DWORD) AS LONG
DECLARE FUNCTION EnumPorts LIB "WINSPOOL.DRV" ALIAS "EnumPortsA" (pName AS ASCIIZ, BYVAL Level AS DWORD, BYVAL lpbPorts AS LONG, BYVAL cbBuf AS DWORD, pcbNeeded AS DWORD, pcReturned AS DWORD) AS LONG
DECLARE FUNCTION EnumPrintProcessorDatatypes LIB "WINSPOOL.DRV" ALIAS "EnumPrintProcessorDatatypesA" (pName AS ASCIIZ, pPrintProcessorName AS ASCIIZ, BYVAL Level AS DWORD, pDatatypes AS BYTE, BYVAL cbBuf AS DWORD, pcbNeeded AS DWORD, _
                 pcReturned AS DWORD) AS LONG
DECLARE FUNCTION EnumPrintProcessors LIB "WINSPOOL.DRV" ALIAS "EnumPrintProcessorsA" (pName AS ASCIIZ, pEnvironment AS ASCIIZ, BYVAL Level AS DWORD, pPrintProcessorInfo AS ANY, BYVAL cbBuf AS DWORD, pcbNeeded AS DWORD, pcReturned AS DWORD) AS LONG
DECLARE FUNCTION EnumPrinterDrivers LIB "WINSPOOL.DRV" ALIAS "EnumPrinterDriversA" (pName AS ASCIIZ, pEnvironment AS ASCIIZ, BYVAL Level AS DWORD, pDriverInfo AS ANY, BYVAL cbBuf AS DWORD, pcbNeeded AS DWORD, pcReturned AS DWORD) AS LONG
DECLARE FUNCTION EnumPrinterPropertySheets LIB "WINSPOOL.DRV" ALIAS "EnumPrinterPropertySheets" (hPrinter AS DWORD, hWnd AS DWORD, lpfnAdd AS DWORD, BYVAL lParam AS LONG) AS LONG
DECLARE FUNCTION EnumPrinters LIB "WINSPOOL.DRV" ALIAS "EnumPrintersA" (BYVAL dwFlags AS DWORD, xname AS ASCIIZ, BYVAL Level AS DWORD, pPrinterEnum AS BYTE, BYVAL cbBuf AS DWORD, pcbNeeded AS DWORD, pcReturned AS DWORD) AS LONG
DECLARE FUNCTION FindClosePrinterChangeNotification LIB "WINSPOOL.DRV" ALIAS "FindClosePrinterChangeNotification" (BYVAL hChange AS DWORD) AS LONG
DECLARE FUNCTION FindFirstPrinterChangeNotification LIB "WINSPOOL.DRV" ALIAS "FindFirstPrinterChangeNotification" (BYVAL hPrinter AS DWORD, BYVAL fdwFlags AS DWORD, BYVAL fdwOptions AS DWORD, pPrinterNotifyOptions AS ANY) AS DWORD
DECLARE FUNCTION FindNextPrinterChangeNotification LIB "WINSPOOL.DRV" ALIAS "FindNextPrinterChangeNotification" (BYVAL hChange AS DWORD, pdwChange AS DWORD, pvReserved AS ASCIIZ, BYVAL ppPrinterNotifyInfo AS DWORD) AS LONG
DECLARE FUNCTION GetForm LIB "WINSPOOL.DRV" ALIAS "GetFormA" (BYVAL hPrinter AS DWORD, pFormName AS ASCIIZ, BYVAL Level AS DWORD, pForm AS ANY, BYVAL cbBuf AS DWORD, pcbNeeded AS DWORD) AS LONG
DECLARE FUNCTION GetJob LIB "WINSPOOL.DRV" ALIAS "GetJobA" (BYVAL hPrinter AS DWORD, BYVAL JobId AS LONG, BYVAL Level AS DWORD, pJob AS ANY, BYVAL cbBuf AS DWORD, pcbNeeded AS DWORD) AS LONG
DECLARE FUNCTION GetPrintProcessorDirectory LIB "WINSPOOL.DRV" ALIAS "GetPrintProcessorDirectoryA" (pName AS ASCIIZ, pEnvironment AS ASCIIZ, BYVAL Level AS DWORD, pPrintProcessorInfo AS ASCIIZ, BYVAL cbBuf AS DWORD, pcbNeeded AS DWORD) AS LONG
DECLARE FUNCTION GetPrinter LIB "WINSPOOL.DRV" ALIAS "GetPrinterA" (BYVAL hPrinter AS DWORD, BYVAL Level AS DWORD, pPrinter AS ANY, BYVAL cbBuf AS DWORD, pcbNeeded AS DWORD) AS LONG
DECLARE FUNCTION GetPrinterData LIB "WINSPOOL.DRV" ALIAS "GetPrinterDataA" (BYVAL hPrinter AS DWORD, pValueName AS ASCIIZ, pType AS DWORD, pData AS ANY, BYVAL nSize AS DWORD, pcbNeeded AS DWORD) AS DWORD
DECLARE FUNCTION GetPrinterDriver LIB "WINSPOOL.DRV" ALIAS "GetPrinterDriverA" (BYVAL hPrinter AS DWORD, pEnvironment AS ASCIIZ, BYVAL Level AS DWORD, pDriverInfo AS ANY, BYVAL cbBuf AS DWORD, pcbNeeded AS DWORD) AS LONG
DECLARE FUNCTION GetPrinterDriverDirectory LIB "WINSPOOL.DRV" ALIAS "GetPrinterDriverDirectoryA" (pName AS ASCIIZ, pEnvironment AS ASCIIZ, BYVAL Level AS DWORD, pDriverDirectory AS BYTE, BYVAL cbBuf AS DWORD, pcbNeeded AS DWORD) AS LONG

#IF NOT %DEF(%NOGDI)
  DECLARE FUNCTION OpenPrinter LIB "WINSPOOL.DRV" ALIAS "OpenPrinterA" (pPrinterName AS ASCIIZ, phPrinter AS DWORD, pDefault AS PRINTER_DEFAULTS) AS LONG
#ENDIF

DECLARE FUNCTION PrinterMessageBox LIB "WINSPOOL.DRV" ALIAS "PrinterMessageBoxA" (BYVAL hPrinter AS DWORD, BYVAL xerror AS LONG, BYVAL hWnd AS DWORD, pText AS ASCIIZ, pCaption AS ASCIIZ, BYVAL dwType AS DWORD) AS LONG
DECLARE FUNCTION PrinterProperties LIB "WINSPOOL.DRV" ALIAS "PrinterProperties" (BYVAL hWnd AS DWORD, BYVAL hPrinter AS DWORD) AS LONG
DECLARE FUNCTION ReadPrinter LIB "WINSPOOL.DRV" ALIAS "ReadPrinter" (BYVAL hPrinter AS DWORD, pBuf AS ANY, BYVAL cbBuf AS DWORD, pNoBytesRead AS LONG) AS LONG

#IF NOT %DEF(%NOGDI)
  DECLARE FUNCTION ResetPrinter LIB "WINSPOOL.DRV" ALIAS "ResetPrinterA" (BYVAL hPrinter AS DWORD, pDefault AS PRINTER_DEFAULTS) AS LONG
#ENDIF

DECLARE FUNCTION ScheduleJob LIB "WINSPOOL.DRV" ALIAS "ScheduleJob" (BYVAL hPrinter AS DWORD, BYVAL JobId AS LONG) AS LONG
DECLARE FUNCTION SetForm LIB "WINSPOOL.DRV" ALIAS "SetFormA" (BYVAL hPrinter AS DWORD, pFormName AS ASCIIZ, BYVAL Level AS DWORD, pForm AS BYTE) AS LONG
DECLARE FUNCTION SetJob LIB "WINSPOOL.DRV" ALIAS "SetJobA" (BYVAL hPrinter AS DWORD, BYVAL JobId AS LONG, BYVAL Level AS DWORD, pJob AS ANY, BYVAL Command AS LONG) AS LONG
DECLARE FUNCTION SetPrinter LIB "WINSPOOL.DRV" ALIAS "SetPrinterA" (BYVAL hPrinter AS DWORD, BYVAL Level AS DWORD, pPrinter AS BYTE, BYVAL Command AS LONG) AS LONG
DECLARE FUNCTION SetPrinterData LIB "WINSPOOL.DRV" ALIAS "SetPrinterDataA" (BYVAL hPrinter AS DWORD, pValueName AS ASCIIZ, BYVAL dwType AS DWORD, pData AS BYTE, BYVAL cbData AS LONG) AS LONG
DECLARE FUNCTION StartDocPrinter LIB "WINSPOOL.DRV" ALIAS "StartDocPrinterA" (BYVAL hPrinter AS DWORD, BYVAL Level AS DWORD, pDocInfo AS ANY) AS LONG
DECLARE FUNCTION StartPagePrinter LIB "WINSPOOL.DRV" ALIAS "StartPagePrinter" (BYVAL hPrinter AS DWORD) AS LONG
DECLARE FUNCTION WaitForPrinterChange LIB "WINSPOOL.DRV" ALIAS "WaitForPrinterChange" (BYVAL hPrinter AS DWORD, BYVAL flags AS LONG) AS LONG
DECLARE FUNCTION WritePrinter LIB "WINSPOOL.DRV" ALIAS "WritePrinter" (BYVAL hPrinter AS DWORD, pBuf AS ANY, BYVAL cbBuf AS DWORD, pcWritten AS LONG) AS LONG


' Network support declares from winnetwk.h ====================================

DECLARE FUNCTION WNetAddConnection LIB "MPR.DLL" ALIAS "WNetAddConnectionA" (lpszRemoteName AS ASCIIZ, lpszPassword AS ASCIIZ, lpszLocalName AS ASCIIZ) AS DWORD
DECLARE FUNCTION WNetAddConnection2 LIB "MPR.DLL" ALIAS "WNetAddConnection2A" (lpszNetResource AS NETRESOURCE, lpszPassword AS ASCIIZ, lpszUserName AS ASCIIZ, BYVAL dwFlags AS DWORD) AS DWORD
DECLARE FUNCTION WNetAddConnection3 LIB "MPR.DLL" ALIAS "WNetAddConnection3A" (BYVAL hwndOwner AS DWORD, lpszNetResource AS NETRESOURCE, lpszPassword AS ASCIIZ, lpszUserName AS ASCIIZ, BYVAL dwFlags AS DWORD) AS DWORD
DECLARE FUNCTION WNetCancelConnection LIB "MPR.DLL" ALIAS "WNetCancelConnectionA" (lpszName AS ASCIIZ, BYVAL fForce AS LONG) AS DWORD
DECLARE FUNCTION WNetCancelConnection2 LIB "MPR.DLL" ALIAS "WNetCancelConnection2A" (lpName AS ASCIIZ, BYVAL dwFlags AS DWORD, BYVAL fForce AS LONG) AS DWORD
DECLARE FUNCTION WNetGetConnection LIB "MPR.DLL" ALIAS "WNetGetConnectionA" (lpszLocalName AS ASCIIZ, lpszRemoteName AS ASCIIZ, lpnLength AS DWORD) AS DWORD
DECLARE FUNCTION WNetUseConnection LIB "MPR.DLL" ALIAS "WNetUseConnectionA" (BYVAL hwndOwner AS DWORD, lpNetResource AS NETRESOURCE, lpszUserID AS ASCIIZ, lpszPassword AS ASCIIZ, BYVAL dwFlags AS DWORD, lpszAccessName AS ASCIIZ, _
  lpBufferSize AS DWORD, lpResult AS DWORD) AS DWORD
DECLARE FUNCTION WNetConnectionDialog LIB "MPR.DLL" ALIAS "WNetConnectionDialog" (BYVAL hwnd AS DWORD, BYVAL dwType AS DWORD) AS DWORD
DECLARE FUNCTION WNetDisconnectDialog LIB "MPR.DLL" ALIAS "WNetDisconnectDialog" (BYVAL hwnd AS DWORD, BYVAL dwType AS DWORD) AS DWORD
DECLARE FUNCTION WNetConnectionDialog1 LIB "MPR.DLL" ALIAS "WNetConnectionDialog1" (lpConnDlgStruct AS CONNECTDLGSTRUCT) AS DWORD
DECLARE FUNCTION WNetDisconnectDialog1 LIB "MPR.DLL" ALIAS "WNetDisconnectDialog1A" (lpConnDlgStruct AS DISCDLGSTRUCT) AS DWORD
DECLARE FUNCTION WNetOpenEnum LIB "MPR.DLL" ALIAS "WNetOpenEnumA" (BYVAL dwScope AS DWORD, BYVAL dwType AS DWORD, BYVAL dwUsage AS DWORD, lpNetResource AS NETRESOURCE, lphEnum AS DWORD) AS DWORD
DECLARE FUNCTION WNetEnumResource LIB "MPR.DLL" ALIAS "WNetEnumResourceA" (BYVAL hEnum AS DWORD, lpcCount AS DWORD, lpBuffer AS ANY, lpBufferSize AS DWORD) AS DWORD
DECLARE FUNCTION WNetCloseEnum LIB "MPR.DLL" ALIAS "WNetCloseEnum" (BYVAL hEnum AS DWORD) AS DWORD
DECLARE FUNCTION WNetGetUniversalName LIB "MPR.DLL" ALIAS "WNetGetUniversalNameA" (lpLocalPath AS ASCIIZ, BYVAL dwInfoLevel AS DWORD, lpBuffer AS ANY, lpBufferSize AS DWORD) AS DWORD
DECLARE FUNCTION WNetGetUser LIB "MPR.DLL" ALIAS "WNetGetUserA" (lpName AS ASCIIZ, lpUserName AS ASCIIZ, lpnLength AS DWORD) AS DWORD
DECLARE FUNCTION WNetGetProviderName LIB "MPR.DLL" ALIAS "WNetGetProviderNameA" (BYVAL dwNetType AS DWORD, lpProviderName AS ASCIIZ, lpBufferSize AS DWORD) AS DWORD
DECLARE FUNCTION WNetGetNetworkInformation LIB "MPR.DLL" ALIAS "WNetGetNetworkInformationA" (lpszProvider AS ASCIIZ, lpNetInfoStruct AS NETINFOSTRUCT) AS DWORD
DECLARE FUNCTION WNetGetLastError LIB "MPR.DLL" ALIAS "WNetGetLastErrorA" (lpError AS DWORD, lpErrorBuf AS ASCIIZ, BYVAL nErrorBufSize AS DWORD, lpNameBuf AS ASCIIZ, BYVAL nNameBufSize AS DWORD) AS DWORD
DECLARE FUNCTION MultinetGetConnectionPerformance LIB "MPR.DLL" ALIAS "MultinetGetConnectionPerformanceA" (lpNetResource AS NETRESOURCE, lpNetConnectInfoStruct AS NETCONNECTINFOSTRUCT) AS DWORD

' End of declares from winnetwk.h =============================================


' Network support declares from lmaccess.h ====================================
'
DECLARE FUNCTION Netbios LIB "NETAPI32.DLL" ALIAS "Netbios" (pncb AS NCB) AS BYTE
DECLARE FUNCTION NetUserGetInfo LIB "NETAPI32.DLL" ALIAS "NetUserGetInfo" (lpServer AS ANY, UserName AS ANY, BYVAL Level AS DWORD, BYVAL lpBuffer AS DWORD) AS DWORD
DECLARE FUNCTION NetGetAnyDCName LIB "NETAPI32.DLL" ALIAS "NetGetAnyDCName" (uServer AS ANY, uDomain AS ANY, BYVAL buffer AS DWORD) AS DWORD
DECLARE FUNCTION NetGetDCName LIB "NETAPI32.DLL" ALIAS "NetGetDCName" (uServer AS ANY, uDomain AS ANY, BYVAL buffer AS DWORD) AS DWORD
DECLARE FUNCTION NetUserChangePassword LIB "NETAPI32.DLL" ALIAS "NetUserChangePassword" (Domain AS ANY, User AS ANY, OldPass AS ANY, NewPass AS ANY) AS DWORD
DECLARE FUNCTION NetUserGetGroups LIB "NETAPI32.DLL" ALIAS "NetUserGetGroups" (lpServer AS ANY, UserName AS ANY, BYVAL Level AS DWORD, BYVAL lpBuffer AS DWORD, BYVAL PrefMaxLen AS DWORD, lpEntriesRead AS DWORD, lpTotalEntries AS DWORD) AS DWORD
DECLARE FUNCTION NetUserGetLocalGroups LIB "NETAPI32.DLL" ALIAS "NetUserGetLocalGroups" (lpServer AS ANY, UserName AS ANY, BYVAL Level AS DWORD, BYVAL Flags AS DWORD, BYVAL lpBuffer AS DWORD, BYVAL MaxLen AS DWORD, lpEntriesRead AS DWORD, _
                 lpTotalEntries AS DWORD) AS DWORD
DECLARE FUNCTION NetRemoteTOD LIB "NETAPI32.DLL" ALIAS "NetRemoteTOD" (yServer AS ANY, BYVAL pBuffer AS DWORD) AS DWORD
DECLARE FUNCTION NetWkstaGetInfo LIB "NETAPI32.DLL" ALIAS "NetWkstaGetInfo" (uServer AS ANY, BYVAL level AS DWORD, BYVAL lpBuffer AS DWORD) AS DWORD
DECLARE FUNCTION NetWkstaUserGetInfo LIB "NETAPI32.DLL" ALIAS "NetWkstaUserGetInfo" (uServer AS ANY, BYVAL level AS DWORD, BYVAL lpBuffer AS DWORD) AS DWORD


' End of declares from lmaccess.h =============================================


' Network support declares from lmapibuf.h ====================================
'
DECLARE FUNCTION NetApiBufferAllocate LIB "NETAPI32.DLL" ALIAS "NetApiBufferAllocate" (BYVAL ByteCount AS DWORD, pBuffer AS ANY) AS DWORD
DECLARE FUNCTION NetApiBufferFree LIB "NETAPI32.DLL" ALIAS "NetApiBufferFree" (BYVAL pBuffer AS DWORD) AS DWORD
DECLARE FUNCTION NetApiBufferReallocate LIB "NETAPI32.DLL" ALIAS "NetApiBufferReallocate" (BYVAL pOldBuffer AS DWORD, BYVAL NewByteCount AS DWORD, pNewBuffer AS ANY) AS DWORD
DECLARE FUNCTION NetApiBufferSize LIB "NETAPI32.DLL" ALIAS "NetApiBufferSize" (BYVAL pBuffer AS DWORD, ByteCount AS DWORD) AS DWORD

' End of declares from lmapibuf.h =============================================


'
' Compression function declares from lzexpand.h ===============================
'
DECLARE FUNCTION LZStart LIB "LZ32.DLL" ALIAS "LZStart" () AS LONG
DECLARE SUB LZDone LIB "LZ32.DLL" ALIAS "LZDone" ()
DECLARE FUNCTION CopyLZFile LIB "LZ32.DLL" ALIAS "CopyLZFile" (BYVAL n1 AS LONG, BYVAL n2 AS LONG) AS LONG
DECLARE FUNCTION LZCopy LIB "LZ32.DLL" ALIAS "LZCopy" (BYVAL hfSource AS DWORD, BYVAL hfDest AS DWORD) AS LONG
DECLARE FUNCTION LZInit LIB "LZ32.DLL" ALIAS "LZInit" (BYVAL hfSrc AS DWORD) AS LONG
DECLARE FUNCTION GetExpandedName LIB "LZ32.DLL" ALIAS "GetExpandedNameA" (lpszSource AS ASCIIZ, lpszBuffer AS ASCIIZ) AS LONG
DECLARE FUNCTION LZOpenFile LIB "LZ32.DLL" ALIAS "LZOpenFileA" (lpszFile AS ASCIIZ, lpOf AS OFSTRUCT, BYVAL style AS WORD) AS LONG
DECLARE FUNCTION LZSeek LIB "LZ32.DLL" ALIAS "LZSeek" (BYVAL hfFile AS DWORD, BYVAL lOffset AS LONG, BYVAL nOrigin AS LONG) AS LONG
DECLARE FUNCTION LZRead LIB "LZ32.DLL" ALIAS "LZRead" (BYVAL hfFile AS DWORD, lpvBuf AS ASCIIZ, BYVAL cbread AS LONG) AS LONG
DECLARE SUB LZClose LIB "LZ32.DLL" ALIAS "LZClose" (BYVAL hfFile AS DWORD)

' End of declares from lzexpand.h =============================================


'
' IMM32.DLL Declares from imm.h ===============================================
'
DECLARE FUNCTION ImmInstallIME LIB "IMM32.DLL" ALIAS "ImmInstallIMEA" (lpszIMEFileName AS ASCIIZ, lpszLayoutText AS ASCIIZ) AS DWORD
DECLARE FUNCTION ImmGetDefaultIMEWnd LIB "IMM32.DLL" ALIAS "ImmGetDefaultIMEWnd" (BYVAL hwnd AS DWORD) AS DWORD
DECLARE FUNCTION ImmGetDescription LIB "IMM32.DLL" ALIAS "ImmGetDescriptionA" (BYVAL hkl AS DWORD, lpsz AS ASCIIZ, BYVAL uBufLen AS DWORD) AS DWORD
DECLARE FUNCTION ImmGetIMEFileName LIB "IMM32.DLL" ALIAS "ImmGetIMEFileNameA" (BYVAL hkl AS DWORD, lpStr AS ASCIIZ, BYVAL uBufLen AS DWORD) AS DWORD
DECLARE FUNCTION ImmGetProperty LIB "IMM32.DLL" ALIAS "ImmGetProperty" (BYVAL hkl AS DWORD, BYVAL dw AS DWORD) AS DWORD
DECLARE FUNCTION ImmIsIME LIB "IMM32.DLL" ALIAS "ImmIsIME" (BYVAL hkl AS DWORD) AS LONG
DECLARE FUNCTION ImmSimulateHotKey LIB "IMM32.DLL" ALIAS "ImmSimulateHotKey" (BYVAL hwnd AS DWORD, BYVAL dwHotKeyID AS DWORD) AS LONG
DECLARE FUNCTION ImmCreateContext LIB "IMM32.DLL" ALIAS "ImmCreateContext" () AS DWORD
DECLARE FUNCTION ImmDestroyContext LIB "IMM32.DLL" ALIAS "ImmDestroyContext" (BYVAL himc AS DWORD) AS LONG
DECLARE FUNCTION ImmGetContext LIB "IMM32.DLL" ALIAS "ImmGetContext" (BYVAL hwnd AS DWORD) AS DWORD
DECLARE FUNCTION ImmReleaseContext LIB "IMM32.DLL" ALIAS "ImmReleaseContext" (BYVAL hwnd AS DWORD, BYVAL himc AS DWORD) AS LONG
DECLARE FUNCTION ImmAssociateContext LIB "IMM32.DLL" ALIAS "ImmAssociateContext" (BYVAL hwnd AS DWORD, BYVAL himc AS DWORD) AS DWORD
DECLARE FUNCTION ImmAssociateContextEx LIB "IMM32.DLL" ALIAS "ImmAssociateContextEx" (BYVAL hwnd AS DWORD, BYVAL himc AS DWORD, BYVAL dwFlags AS DWORD) AS LONG
DECLARE FUNCTION ImmGetCompositionString LIB "IMM32.DLL" ALIAS "ImmGetCompositionStringA" (BYVAL himc AS DWORD, BYVAL dwIndex AS DWORD, lpv AS ANY, BYVAL dwBufLen AS DWORD) AS LONG
DECLARE FUNCTION ImmSetCompositionString LIB "IMM32.DLL" ALIAS "ImmSetCompositionStringA" (BYVAL himc AS DWORD, BYVAL dwIndex AS DWORD, lpComp AS ANY, BYVAL dwCompLen AS DWORD, lpRead AS ANY, BYVAL dwReadLen AS DWORD) AS LONG
DECLARE FUNCTION ImmGetCandidateListCount LIB "IMM32.DLL" ALIAS "ImmGetCandidateListCountA" (BYVAL himc AS DWORD, lpdwListCount AS DWORD) AS DWORD
DECLARE FUNCTION ImmGetCandidateList LIB "IMM32.DLL" ALIAS "ImmGetCandidateListA" (BYVAL himc AS DWORD, BYVAL deIndex AS DWORD, lpCandidateList AS CANDIDATELIST, BYVAL dwBufLen AS DWORD) AS DWORD
DECLARE FUNCTION ImmGetGuideLine LIB "IMM32.DLL" ALIAS "ImmGetGuideLineA" (BYVAL himc AS DWORD, BYVAL dwIndex AS DWORD, lpStr AS ASCIIZ, BYVAL dwBufLen AS DWORD) AS DWORD
DECLARE FUNCTION ImmGetConversionStatus LIB "IMM32.DLL" ALIAS "ImmGetConversionStatus" (BYVAL himc AS DWORD, lpdwConversion AS DWORD, lpdwfSentence AS DWORD) AS LONG
DECLARE FUNCTION ImmSetConversionStatus LIB "IMM32.DLL" ALIAS "ImmSetConversionStatus" (BYVAL himc AS DWORD, BYVAL dwfConversion AS DWORD, BYVAL dwfSentence AS DWORD) AS LONG
DECLARE FUNCTION ImmGetOpenStatus LIB "IMM32.DLL" ALIAS "ImmGetOpenStatus" (BYVAL himc AS DWORD) AS LONG
DECLARE FUNCTION ImmSetOpenStatus LIB "IMM32.DLL" ALIAS "ImmSetOpenStatus" (BYVAL himc AS DWORD, BYVAL fOpen AS LONG) AS LONG
#IF NOT %DEF(%NOGDI)
DECLARE FUNCTION ImmGetCompositionFont LIB "IMM32.DLL" ALIAS "ImmGetCompositionFontA" (BYVAL himc AS DWORD, lpLogFont AS LOGFONT) AS LONG
DECLARE FUNCTION ImmSetCompositionFont LIB "IMM32.DLL" ALIAS "ImmSetCompositionFontA" (BYVAL himc AS DWORD, lpLogFont AS LOGFONT) AS LONG
#ENDIF
DECLARE FUNCTION ImmConfigureIME LIB "IMM32.DLL" ALIAS "ImmConfigureIME" (BYVAL hkl AS DWORD, BYVAL hwnd AS DWORD, BYVAL dwMode AS DWORD, lpData AS ANY) AS LONG
DECLARE FUNCTION ImmEscape LIB "IMM32.DLL" ALIAS "ImmEscapeA" (BYVAL hkl AS DWORD, BYVAL himc AS DWORD, BYVAL uEscape AS DWORD, lpData AS ANY) AS LONG
DECLARE FUNCTION ImmGetConversionList LIB "IMM32.DLL" ALIAS "ImmGetConversionListA" (BYVAL hkl AS DWORD, BYVAL himc AS DWORD, lpSrc AS ASCIIZ, lpCandidateList AS CANDIDATELIST, BYVAL dwBufLen AS DWORD, BYVAL uFlag AS DWORD) AS DWORD
DECLARE FUNCTION ImmNotifyIME LIB "IMM32.DLL" ALIAS "ImmNotifyIME" (BYVAL himc AS DWORD, BYVAL dwAction AS DWORD, BYVAL dwIndex AS DWORD, BYVAL dwValue AS DWORD) AS LONG
DECLARE FUNCTION ImmGetStatusWindowPos LIB "IMM32.DLL" ALIAS "ImmGetStatusWindowPos" (BYVAL himc AS DWORD, lpPoint AS POINTAPI) AS LONG
DECLARE FUNCTION ImmSetStatusWindowPos LIB "IMM32.DLL" ALIAS "ImmSetStatusWindowPos" (BYVAL himc AS DWORD, lpPoint AS POINTAPI) AS LONG
DECLARE FUNCTION ImmGetCompositionWindow LIB "IMM32.DLL" ALIAS "ImmGetCompositionWindow" (BYVAL himc AS DWORD, lpCompositionForm AS COMPOSITIONFORM) AS LONG
DECLARE FUNCTION ImmSetCompositionWindow LIB "IMM32.DLL" ALIAS "ImmSetCompositionWindow" (BYVAL himc AS DWORD, lpCompositionForm AS COMPOSITIONFORM) AS LONG
DECLARE FUNCTION ImmGetCandidateWindow LIB "IMM32.DLL" ALIAS "ImmGetCandidateWindow" (BYVAL himc AS DWORD, BYVAL dwIndex AS DWORD, lpCandidateForm AS CANDIDATEFORM) AS LONG
DECLARE FUNCTION ImmSetCandidateWindow LIB "IMM32.DLL" ALIAS "ImmSetCandidateWindow" (BYVAL himc AS DWORD, lpCandidateForm AS CANDIDATEFORM) AS LONG
DECLARE FUNCTION ImmIsUIMessage LIB "IMM32.DLL" ALIAS "ImmIsUIMessageA" (BYVAL hwnd AS DWORD, BYVAL uMsg AS DWORD, BYVAL wParam AS DWORD, BYVAL lParam AS LONG) AS LONG
DECLARE FUNCTION ImmGetVirtualKey LIB "IMM32.DLL" ALIAS "ImmGetVirtualKey" (BYVAL hwnd AS DWORD) AS DWORD
DECLARE FUNCTION ImmRegisterWord LIB "IMM32.DLL" ALIAS "ImmRegisterWordA" (BYVAL hkl AS DWORD, lpszReading AS ASCIIZ, BYVAL dwStyle AS DWORD, lpszRegister AS ASCIIZ) AS DWORD
DECLARE FUNCTION ImmUnregisterWord LIB "IMM32.DLL" ALIAS "ImmUnregisterWordA" (BYVAL hkl AS DWORD, lpszReading AS ASCIIZ, BYVAL dwStyle AS DWORD, lpszUnregister AS ASCIIZ) AS LONG
DECLARE FUNCTION ImmGetRegisterWordStyle LIB "IMM32.DLL" ALIAS "ImmGetRegisterWordStyleA" (BYVAL hkl AS DWORD, BYVAL nItem AS DWORD, lpStyleBuf AS STYLEBUF) AS DWORD
DECLARE FUNCTION ImmEnumRegisterWord LIB "IMM32.DLL" ALIAS "ImmEnumRegisterWordA" (BYVAL hkl AS DWORD, BYVAL RegisterWordEnumProc AS DWORD, lpszReading AS ASCIIZ, BYVAL dwStyle AS DWORD, lpszRegister AS ASCIIZ, lpData AS ANY) AS DWORD
DECLARE FUNCTION ImmDisableIME LIB "IMM32.DLL" ALIAS "ImmDisableIME" (BYVAL idThread AS DWORD) AS LONG
DECLARE FUNCTION ImmGetImeMenuItems LIB "IMM32.DLL" ALIAS "ImmGetImeMenuItemsA" (BYVAL hIMC AS DWORD, BYVAL dwFlags AS DWORD, BYVAL dwType AS DWORD, lpImeParentMenu AS IMEMENUITEMINFO, lpImeMenu AS IMEMENUITEMINFO, BYVAL dwSize AS DWORD) AS DWORD

' End of declares from imm.h ==================================================

'
' Declares from ime.h =========================================================
'
DECLARE FUNCTION SendIMEMessageEx LIB "IMM32.DLL" ALIAS "SendIMEMessageExA" (BYVAL hWnd AS DWORD, BYVAL lParam AS LONG) AS LONG

' End of declares from ime.h ==================================================


'
' Declares from shellapi.h ====================================================
'
DECLARE FUNCTION DragQueryFile LIB "SHELL32.DLL" ALIAS "DragQueryFileA" (BYVAL hDrop AS DWORD, BYVAL uiFile AS DWORD, lpStr AS ASCIIZ, BYVAL cch AS DWORD) AS DWORD
DECLARE FUNCTION DragQueryPoint LIB "SHELL32.DLL" ALIAS "DragQueryPoint" (BYVAL hDrop AS DWORD, lpPoint AS POINTAPI) AS LONG
DECLARE SUB DragFinish LIB "SHELL32.DLL" ALIAS "DragFinish" (BYVAL hDrop AS DWORD)
DECLARE SUB DragAcceptFiles LIB "SHELL32.DLL" ALIAS "DragAcceptFiles" (BYVAL hwnd AS DWORD, BYVAL fAccept AS LONG)
DECLARE FUNCTION ShellExecute LIB "SHELL32.DLL" ALIAS "ShellExecuteA" (BYVAL hwnd AS DWORD, lpOperation AS ASCIIZ, lpFile AS ASCIIZ, lpParameters AS ASCIIZ, lpDirectory AS ASCIIZ, BYVAL nShowCmd AS LONG) AS DWORD
DECLARE FUNCTION FindExecutable LIB "SHELL32.DLL" ALIAS "FindExecutableA" (lpFile AS ASCIIZ, lpDirectory AS ASCIIZ, lpResult AS ASCIIZ) AS DWORD
DECLARE FUNCTION ShellAbout LIB "SHELL32.DLL" ALIAS "ShellAboutA" (BYVAL hWnd AS DWORD, szApp AS ASCIIZ, szOtherStuff AS ASCIIZ, BYVAL hIcon AS DWORD) AS LONG
DECLARE FUNCTION DuplicateIcon LIB "SHELL32.DLL" ALIAS "DuplicateIcon" (BYVAL hInst AS DWORD, BYVAL hIcon AS DWORD) AS DWORD
DECLARE FUNCTION ExtractAssociatedIcon LIB "SHELL32.DLL" ALIAS "ExtractAssociatedIconA" (BYVAL hInst AS DWORD, lpIconPath AS ASCIIZ, lpwIcon AS WORD) AS DWORD
DECLARE FUNCTION ExtractIcon LIB "SHELL32.DLL" ALIAS "ExtractIconA" (BYVAL hInst AS DWORD, lpszExeFileName AS ASCIIZ, BYVAL nIconIndex AS DWORD) AS DWORD
DECLARE FUNCTION SHAppBarMessage LIB "SHELL32.DLL" ALIAS "SHAppBarMessage" (BYVAL dwMessage AS DWORD, pData AS APPBARDATA) AS DWORD
DECLARE FUNCTION DoEnvironmentSubst LIB "SHELL32.DLL" ALIAS "DoEnvironmentSubstA" (szString AS ASCIIZ, BYVAL cbString AS DWORD) AS DWORD
' Microsoft documents the FindEnvironmentString function, but it doesn't actually exist.
'DECLARE FUNCTION FindEnvironmentString LIB "SHELL32.DLL" ALIAS "FindEnvironmentStringA" (szEnvVar AS ASCIIZ) AS STRING
DECLARE FUNCTION ExtractIconEx LIB "SHELL32.DLL" ALIAS "ExtractIconExA" (lpszFile AS ASCIIZ, BYVAL nIconIndex AS LONG, phiconLarge AS DWORD, phiconSmall AS DWORD, BYVAL nIcons AS DWORD) AS DWORD
DECLARE FUNCTION SHFileOperation LIB "SHELL32.DLL" ALIAS "SHFileOperationA" (lpFileOp AS SHFILEOPSTRUCT) AS LONG
DECLARE SUB SHFreeNameMappings LIB "SHELL32.DLL" ALIAS "SHFreeNameMappings" (BYVAL hNameMappings AS DWORD)
DECLARE FUNCTION ShellExecuteEx LIB "SHELL32.DLL" ALIAS "ShellExecuteExA" (lpShellInfo AS SHELLEXECUTEINFO) AS LONG
DECLARE SUB WinExecError LIB "SHELL32.DLL" ALIAS "WinExecErrorA" (BYVAL hwnd AS DWORD, BYVAL xerror AS LONG, lpstrFileName AS ASCIIZ, lpstrTitle AS ASCIIZ)
DECLARE FUNCTION SHQueryRecycleBin LIB "SHELL32.DLL" ALIAS "SHQueryRecycleBinA" (pszRootPath AS ASCIIZ, pSHQueryRBInfo AS SHQUERYRBINFO) AS DWORD
DECLARE FUNCTION SHEmptyRecycleBin LIB "SHELL32.DLL" ALIAS "SHEmptyRecycleBinA" (BYVAL hwnd AS DWORD, pszRootPath AS ASCIIZ, BYVAL dwFlags AS DWORD) AS DWORD
DECLARE FUNCTION Shell_NotifyIcon LIB "SHELL32.DLL" ALIAS "Shell_NotifyIconA" (BYVAL dwMessage AS DWORD, lpData AS NOTIFYICONDATA) AS LONG
DECLARE FUNCTION SHGetFileInfo LIB "SHELL32.DLL" ALIAS "SHGetFileInfoA" (pszPath AS ASCIIZ, BYVAL dwFileAttributes AS DWORD, psfi AS SHFILEINFO, BYVAL cbFileInfo AS DWORD, BYVAL uFlags AS DWORD) AS DWORD
DECLARE FUNCTION SHGetDiskFreeSpace LIB "SHELL32.DLL" ALIAS "SHGetDiskFreeSpaceA" (pszVolume AS ASCIIZ, pqwFreeCaller AS QUAD, pqwTot AS QUAD, pqwFree AS QUAD) AS LONG
DECLARE FUNCTION SHGetNewLinkInfo LIB "SHELL32.DLL" ALIAS "SHGetNewLinkInfoA" (pszLinkto AS ASCIIZ, pszDir AS ASCIIZ, pszName AS ASCIIZ, pfMustCopy AS LONG, BYVAL uFlags AS DWORD) AS LONG
DECLARE FUNCTION SHInvokePrinterCommand LIB "SHELL32.DLL" ALIAS "SHInvokePrinterCommandA" (BYVAL hwnd AS DWORD, BYVAL uAction AS DWORD, lpBuf1 AS ASCIIZ, lpBuf2 AS ASCIZ, BYVAL fModal AS LONG) AS LONG

' End of declares from shellapi.h =============================================

'
' Declares from shlobj.h ======================================================
'
DECLARE SUB      SHAddToRecentDocs LIB "SHELL32.DLL" ALIAS "SHAddToRecentDocs" (BYVAL uFlags AS DWORD, pv AS ANY)
DECLARE FUNCTION SHBrowseForFolder LIB "SHELL32.DLL" ALIAS "SHBrowseForFolderA" (lpbi AS BROWSEINFO) AS DWORD
DECLARE SUB      SHChangeNotify LIB "SHELL32.DLL" ALIAS "SHChangeNotify" (BYVAL nEventId AS LONG, BYVAL uFlags AS DWORD, dwItem1 AS ANY, dwItem2 AS ANY)
DECLARE FUNCTION SHGetPathFromIDList LIB "SHELL32.DLL" ALIAS "SHGetPathFromIDListA" (pidList AS ITEMIDLIST, lpBuffer AS ASCIIZ) AS LONG
DECLARE FUNCTION SHGetSpecialFolderLocation LIB "shell32.dll" ALIAS "SHGetSpecialFolderLocation" (BYVAL hwndOwner AS DWORD, BYVAL nFolder AS LONG, pidl AS ITEMIDLIST) AS DWORD

' End of declares from shlobj.h ===============================================

'
' Declare from MSDN ID: Q173688 ===============================================
'
DECLARE FUNCTION SHFormatDrive LIB "SHELL32.DLL" ALIAS "SHFormatDrive" (BYVAL hWnd AS DWORD, BYVAL drive AS DWORD, BYVAL fmtID AS DWORD, BYVAL options AS DWORD) AS DWORD

' End of declare from MSDN ID: Q173688 ========================================


'
' Declares from oleauto.h =====================================================
'
DECLARE FUNCTION SysAllocString LIB "OLEAUT32.DLL" ALIAS "SysAllocString" (sz AS ANY) AS DWORD
DECLARE FUNCTION SysReAllocString LIB "OLEAUT32.DLL" ALIAS "SysReAllocString" (pbstr AS ANY, psz AS ANY) AS LONG
DECLARE FUNCTION SysAllocStringLen LIB "OLEAUT32.DLL" ALIAS "SysAllocStringLen" (pch AS ANY, BYVAL cch AS DWORD) AS DWORD
DECLARE FUNCTION SysReAllocStringLen LIB "OLEAUT32.DLL" ALIAS "SysReAllocStringLen" (pbstr AS ANY, psz AS ANY, BYVAL cch AS DWORD) AS LONG
DECLARE SUB      SysFreeString LIB "OLEAUT32.DLL" ALIAS "SysFreeString" (bstr AS ANY)
DECLARE FUNCTION SysStringLen LIB "OLEAUT32.DLL" ALIAS "SysStringLen" (bstr AS ANY) AS DWORD

DECLARE FUNCTION SysStringByteLen LIB "OLEAUT32.DLL" ALIAS "SysStringByteLen" (bstr AS ANY) AS DWORD
DECLARE FUNCTION SysAllocStringByteLen LIB "OLEAUT32.DLL" ALIAS "SysAllocStringByteLen" (psz AS ASCIIZ, BYVAL ulen AS DWORD) AS DWORD

DECLARE FUNCTION DosDateTimeToVariantTime LIB "OLEAUT32.DLL" ALIAS "DosDateTimeToVariantTime" (BYVAL wDosDate AS WORD, BYVAL wDosTime AS WORD, vbTime AS DOUBLE) AS LONG
DECLARE FUNCTION VarDateFromStr LIB "OLEAUT32.DLL" ALIAS "VarDateFromStr" (BYVAL OleString AS DWORD, BYVAL lcid AS DWORD, BYVAL dwFlags AS DWORD, pDate AS DOUBLE) AS LONG
DECLARE FUNCTION VariantTimeToDosDateTime LIB "OLEAUT32.DLL" ALIAS "VariantTimeToDosDateTime" (BYVAL vbTime AS DOUBLE, pwDosDate AS WORD, pwDosTime AS WORD) AS LONG
DECLARE FUNCTION VariantTimeToSystemTime LIB "OLEAUT32.DLL" ALIAS "VariantTimeToSystemTime" (BYVAL vbtime AS DOUBLE, lpSystemTime AS SYSTEMTIME) AS LONG
DECLARE FUNCTION SystemTimeToVariantTime LIB "OLEAUT32.DLL" ALIAS "SystemTimeToVariantTime" (lpSystemTime AS SYSTEMTIME, vbtime AS DOUBLE) AS LONG

' End of declares from oleauto.h ==============================================

'
' Declares from winver.h ======================================================
'
DECLARE FUNCTION VerFindFile LIB "VERSION.DLL" ALIAS "VerFindFileA" (BYVAL uFlags AS DWORD, szFileName AS ASCIIZ, szWinDir AS ASCIIZ, szAppDir AS ASCIIZ, szCurDir AS ASCIIZ, lpuCurDirLen AS DWORD, szDestDir AS ASCIIZ, lpuDestDirLen AS DWORD) AS LONG
DECLARE FUNCTION VerInstallFile LIB "VERSION.DLL" ALIAS "VerInstallFileA" (BYVAL uFlags AS DWORD, szSrcFileName AS ASCIIZ, szDestFileName AS ASCIIZ, szSrcDir AS ASCIIZ, szDestDir AS ASCIIZ, szCurDir AS ASCIIZ, szTmpFile AS ASCIIZ, _
                 lpuTmpFileLen AS DWORD) AS LONG
DECLARE FUNCTION GetFileVersionInfoSize LIB "VERSION.DLL" ALIAS "GetFileVersionInfoSizeA" (lptstrFilename AS ASCIIZ, lpdwHandle AS DWORD) AS DWORD
DECLARE FUNCTION GetFileVersionInfo LIB "VERSION.DLL"  ALIAS "GetFileVersionInfoA" (lptstrFilename AS ASCIIZ, BYVAL dwHandle AS DWORD, BYVAL dwLen AS DWORD, lpData AS ANY) AS LONG
DECLARE FUNCTION VerQueryValue LIB "VERSION.DLL" ALIAS "VerQueryValueA" (BYVAL pBlock AS DWORD, lpSubBlock AS ASCIIZ, lplpBuffer AS DWORD, puLen AS DWORD) AS LONG

' End of declares from winver.h ===============================================

'
' Declares from winnt.h =======================================================
'
DECLARE SUB MoveMemory LIB "KERNEL32.DLL" ALIAS "RtlMoveMemory" (pDestination AS ANY, pSource AS ANY, BYVAL cbLength AS LONG)

SUB CopyMemory (BYVAL pDestination AS DWORD, BYVAL pSource AS DWORD, BYVAL cbLength AS LONG)
    MoveMemory BYVAL pDestination, BYVAL pSource, cbLength
END SUB

SUB FillMemory (BYVAL pDestination AS DWORD, BYVAL cbLength AS LONG, BYVAL bFill AS BYTE)
    LOCAL ix AS LONG
    LOCAL pDest AS BYTE PTR
    pDest = pDestination
    FOR ix = 1 TO cbLength
        @pDest = bFill
        INCR pDest
    NEXT
END SUB

SUB ZeroMemory (BYVAL pDestination AS DWORD, BYVAL cbLength AS LONG)
    FillMemory pDestination, cbLength, 0
END SUB

FUNCTION MAKELANGID (BYVAL p AS WORD, BYVAL s AS WORD) AS DWORD
    LOCAL dResult AS DWORD
    dResult = s
    SHIFT LEFT dResult, 10
    dResult = dResult OR p
    FUNCTION = dResult
END FUNCTION

' End of declares from winnt.h ================================================

'
' Declares from objbase.h =====================================================
'
DECLARE FUNCTION CoCreateGuid LIB "ole32.dll" ALIAS "CoCreateGuid" (pGuid AS GUIDAPI) AS LONG
DECLARE FUNCTION CoTaskMemAlloc LIB "ole32.dll" ALIAS "CoTaskMemAlloc" (BYVAL cbSize AS DWORD) AS DWORD
DECLARE SUB      CoTaskMemFree LIB "ole32.dll" ALIAS "CoTaskMemFree" (BYVAL pMem AS DWORD)
DECLARE FUNCTION CoTaskMemRealloc LIB "ole32.dll" ALIAS "CoTaskMemRealloc" (BYVAL pMem AS DWORD, BYVAL cbSize AS DWORD) AS DWORD

' End of declares from objbase.h ==============================================

#ENDIF   ' %WINAPI
