'------------------------------------------------------------------------------
'
'    WSOCK32.INC -- Windows Sockets 1.1 API Declarations for PowerBASIC
'
'                 Copyright (C) 1997-2001 PowerBASIC, Inc.
'          Portions Copyright (C) 1993-1999 Microsoft Corporation
'
'  Last Update: June 25, 2001
'
'  This file contains the constants, TYPE, and DECLARE statements for the
'  32-bit Windows Sockets 1.1 API.
'
'  This file is not compatible with Visual Basic.  It uses the correct
'  data type as defined in the Microsoft SDK for Windows for all API calls.
'  This includes data types which are not natively supported in Visual Basic
'  such as unsigned integers and ASCIIZ strings.
'
'  You have a royalty-free right to use, modify, reproduce and distribute
'  this file (and/or any modified version) in any way you find useful,
'  provided that you agree that PowerBASIC has no warranty, obligation or
'  liability for its contents.  Refer to the Microsoft Windows Programmer's
'  Reference for further information.
'
'------------------------------------------------------------------------------

#IF NOT %DEF(%WSOCK32_INC)

%WSOCK32_INC = 1

%WSADESCRIPTION_LEN = 256
%WSASYS_STATUS_LEN  = 128

%IPPROTO_IP =             0                ' dummy for IP
%IPPROTO_ICMP =           1                ' control message protocol
%IPPROTO_GGP =            2                ' gateway^2 (deprecated)
%IPPROTO_TCP =            6                ' tcp
%IPPROTO_PUP =            12               ' pup
%IPPROTO_UDP =            17               ' user datagram protocol
%IPPROTO_IDP =            22               ' xns idp
%IPPROTO_ND =             77               ' UNOFFICIAL net disk proto

%IPPROTO_RAW =            255              ' raw IP packet
%IPPROTO_MAX =            256

%IOCPARM_MASK  = &H7F                  ' parameters must be < 128 bytes */
%IOC_VOID      = &H20000000            ' no parameters */
%IOC_OUT       = &H40000000            ' copy out parameters */
%IOC_IN        = &H80000000            ' copy in parameters */
%IOC_INOUT     = (%IOC_IN OR %IOC_OUT) ' 20000000 distinguishes new & old ioctl's

%FIONBIO       = &H8004667E
%FIONSYNC      = &H8004667D
%FIONREAD      = &H4004667F

'
' Port/socket numbers: network standard functions
'

%IPPORT_ECHO =            7
%IPPORT_DISCARD =         9
%IPPORT_SYSTAT =          11
%IPPORT_DAYTIME =         13
%IPPORT_NETSTAT =         15
%IPPORT_FTP =             21
%IPPORT_TELNET =          23
%IPPORT_SMTP =            25
%IPPORT_TIMESERVER =      37
%IPPORT_NAMESERVER =      42
%IPPORT_WHOIS =           43
%IPPORT_MTP =             57

' * Port/socket numbers: host specific functions

%IPPORT_TFTP =            69
%IPPORT_RJE =             77
%IPPORT_FINGER =          79
%IPPORT_TTYLINK =         87
%IPPORT_SUPDUP =          95

' * UNIX TCP sockets

%IPPORT_EXECSERVER =      512
%IPPORT_LOGINSERVER =     513
%IPPORT_CMDSERVER =       514
%IPPORT_EFSSERVER =       520

' * UNIX UDP sockets

%IPPORT_BIFFUDP =         512
%IPPORT_WHOSERVER =       513
%IPPORT_ROUTESERVER =     520
 ' 520+1 also used

' * Ports < IPPORT_RESERVED are reserved for
' * privileged processes (e.g. root).

%IPPORT_RESERVED =        1024

' * Link numbers

%IMPLINK_IP =             155
%IMPLINK_LOWEXPER =       156
%IMPLINK_HIGHEXPER =      158

'%IN_CLASSA(i) =           (((long)(i) & 0x80000000) == 0)
%IN_CLASSA_NET =          &H0FF000000
%IN_CLASSA_NSHIFT =       24
%IN_CLASSA_HOST =         &H000FFFFFF
%IN_CLASSA_MAX =          128

'%IN_CLASSB(i) =           (((long)(i) & 0xc0000000) == 0x80000000)
%IN_CLASSB_NET =          &H0FFFF0000
%IN_CLASSB_NSHIFT =       16
%IN_CLASSB_HOST =         &H00000FFFF
%IN_CLASSB_MAX =          65536

FUNCTION IN_CLASSC(BYVAL i AS LONG) AS LONG
  FUNCTION = (i AND &He0000000) = &Hc0000000
END FUNCTION

%IN_CLASSC_NET =          &H0FFFFFF00
%IN_CLASSC_NSHIFT =       8
%IN_CLASSC_HOST =         &H0000000FF

%INADDR_ANY =             &H000000000
%INADDR_LOOPBACK =        &H07F000001
%INADDR_BROADCAST =       &H0FFFFFFFF
%INADDR_NONE =            &H0FFFFFFFF

' Options for use with [gs]etsockopt at the IP level.

%IP_OPTIONS         = 1           ' set/get IP per-packet options
%IP_MULTICAST_IF    = 2           ' set/get IP multicast interface
%IP_MULTICAST_TTL   = 3           ' set/get IP multicast timetolive
%IP_MULTICAST_LOOP  = 4           ' set/get IP multicast loopback
%IP_ADD_MEMBERSHIP  = 5           ' add  an IP group membership
%IP_DROP_MEMBERSHIP = 6           ' drop an IP group membership
%IP_TTL             = 7           ' set/get IP Time To Live
%IP_TOS             = 8           ' set/get IP Type Of Service
%IP_DONTFRAGMENT    = 9           ' set/get IP Don't Fragment flag


%IP_DEFAULT_MULTICAST_TTL  = 1    ' normally limit m'casts to 1 hop
%IP_DEFAULT_MULTICAST_LOOP = 1    ' normally hear sends if a member
%IP_MAX_MEMBERSHIPS        = 20   ' per socket; must fit in one mbuf

%SOCK_STREAM =    1                ' stream socket
%SOCK_DGRAM =     2                ' datagram socket
%SOCK_RAW =       3                ' raw-protocol interface
%SOCK_RDM =       4                ' reliably-delivered message
%SOCK_SEQPACKET = 5                ' sequenced packet stream

' * Option flags per-socket.

%SO_DEBUG =       &H00001           ' turn on debugging info recording
%SO_ACCEPTCONN =  &H00002           ' socket has had listen()
%SO_REUSEADDR =   &H00004           ' allow local address reuse
%SO_KEEPALIVE =   &H00008           ' keep connections alive
%SO_DONTROUTE =   &H00010           ' just use interface addresses
%SO_BROADCAST =   &H00020           ' permit sending of broadcast msgs
%SO_USELOOPBACK = &H00040           ' bypass hardware when possible
%SO_LINGER =      &H00080           ' linger on close if data present
%SO_OOBINLINE =   &H00100           ' leave received OOB data in line
%SOL_SOCKET   =   &H0FFFF           'options for socket level

%SO_DONTLINGER =  NOT %SO_LINGER

' * Additional options.

%SO_SNDBUF =      &H01001           ' send buffer size
%SO_RCVBUF =      &H01002           ' receive buffer size
%SO_SNDLOWAT =    &H01003           ' send low-water mark
%SO_RCVLOWAT =    &H01004           ' receive low-water mark
%SO_SNDTIMEO =    &H01005           ' send timeout
%SO_RCVTIMEO =    &H01006           ' receive timeout
%SO_ERROR =       &H01007           ' get error status and clear
%SO_TYPE =        &H01008           ' get socket type

' * TCP options.

%TCP_NODELAY =    &H00001

' * Address families.

%AF_UNSPEC =      0                ' unspecified
%AF_UNIX =        1                ' local to host (pipes, portals)
%AF_INET =        2                ' internetwork: UDP, TCP, etc.
%AF_IMPLINK =     3                ' arpanet imp addresses
%AF_PUP =         4                ' pup protocols: e.g. BSP
%AF_CHAOS =       5                ' mit CHAOS protocols
%AF_NS =          6                ' XEROX NS protocols
%AF_IPX =         6                ' IPX and SPX
%AF_ISO =         7                ' ISO protocols
%AF_OSI =         %AF_ISO           ' OSI is ISO
%AF_ECMA =        8                ' european computer manufacturers
%AF_DATAKIT =     9                ' datakit protocols
%AF_CCITT =       10               ' CCITT protocols, X.25 etc
%AF_SNA =         11               ' IBM SNA
%AF_DECnet =      12               ' DECnet
%AF_DLI =         13               ' Direct data link interface
%AF_LAT =         14               ' LAT
%AF_HYLINK =      15               ' NSC Hyperchannel
%AF_APPLETALK =   16               ' AppleTalk
%AF_NETBIOS =     17               ' NetBios-style addresses

%AF_MAX =         18

' * Protocol families, same as address families for now.

%PF_UNSPEC =      %AF_UNSPEC
%PF_UNIX =        %AF_UNIX
%PF_INET =        %AF_INET
%PF_IMPLINK =     %AF_IMPLINK
%PF_PUP =         %AF_PUP
%PF_CHAOS =       %AF_CHAOS
%PF_NS =          %AF_NS
%PF_IPX =         %AF_IPX
%PF_ISO =         %AF_ISO
%PF_OSI =         %AF_OSI
%PF_ECMA =        %AF_ECMA
%PF_DATAKIT =     %AF_DATAKIT
%PF_CCITT =       %AF_CCITT
%PF_SNA =         %AF_SNA
%PF_DECnet =      %AF_DECnet
%PF_DLI =         %AF_DLI
%PF_LAT =         %AF_LAT
%PF_HYLINK =      %AF_HYLINK
%PF_APPLETALK =   %AF_APPLETALK

%PF_MAX =         %AF_MAX

%SOMAXCONN =      5

%MSG_OOB =        &H01              ' process out-of-band data
%MSG_PEEK =   &H02                  ' peek at incoming message
%MSG_DONTROUTE =  &H04              ' send without using routing tables

%MSG_MAXIOVLEN =  16

' * Define constant based on rfc883, used by gethostbyxxxx() calls.

%MAXGETHOSTSTRUCT =       1024

' * Define flags to be used with the WSAAsyncSelect() call.

%FD_READ =        &H001
%FD_WRITE =       &H002
%FD_OOB =         &H004
%FD_ACCEPT =      &H008
%FD_CONNECT =     &H010
%FD_CLOSE =       &H020

' * All Windows Sockets error constants are biased by WSABASEERR from
' * the "normal"

%WSABASEERR =     10000

' * Windows Sockets definitions of regular Microsoft C error constants

%WSAEINTR =               %WSABASEERR+4
%WSAEBADF =               %WSABASEERR+9
%WSAEACCES =              %WSABASEERR+13
%WSAEFAULT =              %WSABASEERR+14
%WSAEINVAL =              %WSABASEERR+22
%WSAEMFILE =              %WSABASEERR+24

' * Windows Sockets definitions of regular Berkeley error constants

%WSAEWOULDBLOCK =         %WSABASEERR + 35
%WSAEINPROGRESS =         %WSABASEERR + 36
%WSAEALREADY =            %WSABASEERR + 37
%WSAENOTSOCK =            %WSABASEERR + 38
%WSAEDESTADDRREQ =        %WSABASEERR + 39
%WSAEMSGSIZE =            %WSABASEERR + 40
%WSAEPROTOTYPE =          %WSABASEERR + 41
%WSAENOPROTOOPT =         %WSABASEERR + 42
%WSAEPROTONOSUPPORT =     %WSABASEERR + 43
%WSAESOCKTNOSUPPORT =     %WSABASEERR + 44
%WSAEOPNOTSUPP =          %WSABASEERR + 45
%WSAEPFNOSUPPORT =        %WSABASEERR + 46
%WSAEAFNOSUPPORT =        %WSABASEERR + 47
%WSAEADDRINUSE =          %WSABASEERR + 48
%WSAEADDRNOTAVAIL =       %WSABASEERR + 49
%WSAENETDOWN =            %WSABASEERR + 50
%WSAENETUNREACH =         %WSABASEERR + 51
%WSAENETRESET =           %WSABASEERR + 52
%WSAECONNABORTED =        %WSABASEERR + 53
%WSAECONNRESET =          %WSABASEERR + 54
%WSAENOBUFS =             %WSABASEERR + 55
%WSAEISCONN =             %WSABASEERR + 56
%WSAENOTCONN =            %WSABASEERR + 57
%WSAESHUTDOWN =           %WSABASEERR + 58
%WSAETOOMANYREFS =        %WSABASEERR + 59
%WSAETIMEDOUT =           %WSABASEERR + 60
%WSAECONNREFUSED =        %WSABASEERR + 61
%WSAELOOP =               %WSABASEERR + 62
%WSAENAMETOOLONG =        %WSABASEERR + 63
%WSAEHOSTDOWN =           %WSABASEERR + 64
%WSAEHOSTUNREACH =        %WSABASEERR + 65
%WSAENOTEMPTY =           %WSABASEERR + 66
%WSAEPROCLIM =            %WSABASEERR + 67
%WSAEUSERS =              %WSABASEERR + 68
%WSAEDQUOT =              %WSABASEERR + 69
%WSAESTALE =              %WSABASEERR + 70
%WSAEREMOTE =             %WSABASEERR + 71

' * Extended Windows Sockets error constant definitions

%WSASYSNOTREADY =         %WSABASEERR+91
%WSAVERNOTSUPPORTED =     %WSABASEERR+92
%WSANOTINITIALISED =      %WSABASEERR+93

' * Error return codes from gethostbyname() and gethostbyaddr()
' * (when using the resolver). Note that these errors are
' * retrieved via WSAGetLastError() and must therefore follow
' * the rules for avoiding clashes with error numbers from
' * specific implementations or language run-time systems.
' * For this reason the codes are based at WSABASEERR+1001.
' * Note also that [WSA]NO_ADDRESS is defined only for
' * compatibility purposes.

'%h_errno =        WSAGetLastError()

 ' Authoritative Answer: Host not found
%WSAHOST_NOT_FOUND =      %WSABASEERR + 1001
%HOST_NOT_FOUND =         %WSAHOST_NOT_FOUND

 ' Non-Authoritative: Host not found, or SERVERFAIL
%WSATRY_AGAIN =           %WSABASEERR + 1002
%TRY_AGAIN =              %WSATRY_AGAIN

 ' Non recoverable errors, FORMERR, REFUSED, NOTIMP
%WSANO_RECOVERY =         %WSABASEERR + 1003
%NO_RECOVERY =            %WSANO_RECOVERY

 ' Valid name, no data record of requested type
%WSANO_DATA =             %WSABASEERR + 1004
%NO_DATA =                %WSANO_DATA

 ' no address, look for MX record
%WSANO_ADDRESS =          %WSANO_DATA
%NO_ADDRESS =             %WSANO_ADDRESS

' * Windows Sockets errors redefined as regular Berkeley error constants

%EWOULDBLOCK =            %WSAEWOULDBLOCK
%EINPROGRESS =            %WSAEINPROGRESS
%EALREADY =               %WSAEALREADY
%ENOTSOCK =               %WSAENOTSOCK
%EDESTADDRREQ =           %WSAEDESTADDRREQ
%EMSGSIZE =               %WSAEMSGSIZE
%EPROTOTYPE =             %WSAEPROTOTYPE
%ENOPROTOOPT =            %WSAENOPROTOOPT
%EPROTONOSUPPORT =        %WSAEPROTONOSUPPORT
%ESOCKTNOSUPPORT =        %WSAESOCKTNOSUPPORT
%EOPNOTSUPP =             %WSAEOPNOTSUPP
%EPFNOSUPPORT =           %WSAEPFNOSUPPORT
%EAFNOSUPPORT =           %WSAEAFNOSUPPORT
%EADDRINUSE =             %WSAEADDRINUSE
%EADDRNOTAVAIL =          %WSAEADDRNOTAVAIL
%ENETDOWN =               %WSAENETDOWN
%ENETUNREACH =            %WSAENETUNREACH
%ENETRESET =              %WSAENETRESET
%ECONNABORTED =           %WSAECONNABORTED
%ECONNRESET =             %WSAECONNRESET
%ENOBUFS =                %WSAENOBUFS
%EISCONN =                %WSAEISCONN
%ENOTCONN =               %WSAENOTCONN
%ESHUTDOWN =              %WSAESHUTDOWN
%ETOOMANYREFS =           %WSAETOOMANYREFS
%ETIMEDOUT =              %WSAETIMEDOUT
%ECONNREFUSED =           %WSAECONNREFUSED
%ELOOP =                  %WSAELOOP
%ENAMETOOLONG =           %WSAENAMETOOLONG
%EHOSTDOWN =              %WSAEHOSTDOWN
%EHOSTUNREACH =           %WSAEHOSTUNREACH
%ENOTEMPTY =              %WSAENOTEMPTY
%EPROCLIM =               %WSAEPROCLIM
%EUSERS =                 %WSAEUSERS
%EDQUOT =                 %WSAEDQUOT
%ESTALE =                 %WSAESTALE
%EREMOTE =                %WSAEREMOTE

%FD_SETSIZE         = 64

%INVALID_SOCKET     = NOT 0
%SOCKET_ERROR       = -1
%SOCKET_BUFFER_SIZE = 512

%ICMP_ECHOREPLY =   0 'echo reply
%ICMP_ECHOREQ   =   8 'echo request

TYPE fd_setstruc
  fd_count AS LONG
  fd_array (0 TO %FD_SETSIZE - 1) AS LONG
END TYPE

TYPE timeval
  tv_sec AS LONG
  tv_usec AS LONG
END TYPE

UNION in_addr
  s_addr AS LONG
  s AS STRING * 4
END UNION

TYPE sockaddr_in
  sin_family AS WORD
  sin_port AS WORD
  sin_addr AS in_addr
  sin_zero AS STRING * 8
END TYPE

TYPE sockaddr
  sa_family AS INTEGER
  sa_data(0 TO 13) AS BYTE
END TYPE

TYPE WSAdata
  wVersion AS INTEGER
  wHighVersion AS INTEGER
  szDescription AS ASCIIZ * %WSADESCRIPTION_LEN + 1
  xFiller1 AS STRING * 3
  szSystemStatus AS ASCIIZ * %WSASYS_STATUS_LEN + 1
  xFiller2 AS STRING * 3
  iMaxSockets AS WORD
  iMaxUdpDg AS WORD
  lpVendorInfo AS ASCIIZ PTR
END TYPE

TYPE sockproto
  sp_family AS INTEGER
  sp_protocol AS INTEGER
END TYPE

TYPE linger
  l_onoff AS INTEGER
  l_linger AS INTEGER
END TYPE

TYPE hostentStru
  h_name     AS ASCIIZ PTR
  h_alias    AS ASCIIZ PTR
  h_addr     AS INTEGER
  h_len      AS INTEGER
  h_list     AS LONG PTR
END TYPE

TYPE netent DWORD
  n_name     AS ASCIIZ PTR
  n_aliases  AS ASCIIZ PTR
  n_addrtype AS INTEGER
  n_net      AS LONG
END TYPE

TYPE servent DWORD
  s_name    AS ASCIIZ PTR
  s_aliases AS ASCIIZ PTR
  s_port    AS INTEGER
  s_proto   AS ASCIIZ PTR
END TYPE

TYPE icmp_hdr
  icmp_type  AS BYTE
  icmp_code  AS BYTE
  icmp_cksum AS INTEGER
  icmp_id    AS INTEGER
  icmp_seq   AS INTEGER
  icmp_data  AS STRING * 1
END TYPE

TYPE ip_hdr
  ip_hlv   AS BYTE        ' header length+ version (4 bits each)
  ip_tos   AS BYTE        'type of service
  ip_len   AS WORD        'total len
  ip_id    AS WORD        'id
  ip_off   AS WORD        'fragment offset
  ip_ttl   AS BYTE        'time to live
  ip_p     AS BYTE        'protocol
  ip_cksum AS WORD
  ip_src   AS in_addr     'source address
  ip_dest  AS in_addr     'dest address
END TYPE

TYPE ICMP_OPTIONS
  Ttl             AS BYTE
  Tos             AS BYTE
  Flags           AS BYTE
  OptionsSize     AS BYTE
  OptionsData     AS LONG
END TYPE

TYPE ICMP_ECHO_REPLY
  Address         AS LONG
  Status          AS LONG
  RoundTripTime   AS LONG
  DataSize        AS INTEGER
  Reserved        AS INTEGER
  DataPointer     AS LONG
  Options         AS ICMP_OPTIONS
  zData           AS ASCIIZ * 250
END TYPE

DECLARE FUNCTION IcmpCreateFile LIB "icmp.dll" ALIAS "IcmpCreateFile" () AS LONG
DECLARE FUNCTION IcmpCloseHandle LIB "icmp.dll" ALIAS "IcmpCloseHandle" (BYVAL IcmpHandle AS LONG) AS LONG
DECLARE FUNCTION IcmpSendEcho LIB "icmp.dll" ALIAS "IcmpSendEcho" (BYVAL IcmpHandle AS LONG, BYVAL DestinationAddress AS LONG, RequestData AS ASCIIZ, BYVAL RequestSize AS INTEGER, BYVAL RequestOptions AS LONG, _
                 ReplyBuffer AS ICMP_ECHO_REPLY, BYVAL ReplySize AS LONG, BYVAL Tymeout AS LONG) AS LONG

DECLARE FUNCTION shutdown LIB "wsock32.dll" ALIAS "shutdown" (BYVAL s AS LONG, BYVAL how AS LONG) AS LONG
DECLARE FUNCTION aaccept LIB "wsock32.dll" ALIAS "accept" (BYVAL s AS LONG, address AS sockaddr_in, addrlen AS LONG) AS LONG
DECLARE FUNCTION bind LIB "wsock32.dll" ALIAS "bind" (BYVAL s AS LONG, address AS sockaddr_in, BYVAL namelen AS LONG) AS LONG
DECLARE FUNCTION closesocket LIB "wsock32.dll" ALIAS "closesocket" (BYVAL s AS LONG) AS LONG
DECLARE FUNCTION cconnect LIB "wsock32.dll" ALIAS "connect" (BYVAL s AS LONG, address AS sockaddr_in, BYVAL namelen AS LONG) AS LONG
DECLARE FUNCTION getpeername LIB "wsock32.dll" ALIAS "getpeername" (BYVAL s AS LONG, sname AS sockaddr_in, namelen AS LONG) AS LONG
DECLARE FUNCTION getsockname LIB "wsock32.dll" ALIAS "getsockname" (BYVAL s AS LONG, sname AS sockaddr_in, namelen AS LONG) AS LONG
DECLARE FUNCTION getsockopt LIB "wsock32.dll" ALIAS "getsockopt" (BYVAL s AS LONG, BYVAL level AS LONG, BYVAL optname AS LONG, optval AS ANY, optlen AS LONG) AS LONG
DECLARE FUNCTION htonl LIB "wsock32.dll" ALIAS "htonl" (BYVAL hostlong AS LONG) AS LONG
DECLARE FUNCTION htons LIB "wsock32.dll" ALIAS "htons" (BYVAL hostshort AS LONG) AS Integer
DECLARE FUNCTION inet_addr LIB "wsock32.dll" ALIAS "inet_addr" (cp AS ASCIIZ) AS LONG
DECLARE FUNCTION inet_ntoa LIB "wsock32.dll" ALIAS "inet_ntoa" (byval inn AS LONG) AS LONG
DECLARE FUNCTION ioctlsocket LIB "wsock32.dll" ALIAS "ioctlsocket" (BYVAL s AS LONG, BYVAL cmd AS LONG, argp AS LONG) AS LONG
DECLARE FUNCTION listen LIB "wsock32.dll" ALIAS "listen" (BYVAL s AS LONG, BYVAL backlog AS LONG) AS LONG
DECLARE FUNCTION ntohl LIB "wsock32.dll" ALIAS "ntohl" (BYVAL netlong AS LONG) AS LONG
DECLARE FUNCTION ntohs LIB "wsock32.dll" ALIAS "ntohs" (BYVAL netshort AS LONG) AS Integer
DECLARE FUNCTION rrecv LIB "wsock32.dll" ALIAS "recv" (BYVAL s AS LONG, buf AS Any, BYVAL buflen AS LONG, BYVAL flags AS LONG) AS LONG
DECLARE FUNCTION recvfrom LIB "wsock32.dll" ALIAS "recvfrom" (BYVAL s AS LONG, buf AS ANY, BYVAL buflen AS LONG, BYVAL flags AS LONG, Sockstruct AS sockaddr_in, strulen AS LONG) AS LONG
DECLARE FUNCTION ssend LIB "wsock32.dll" ALIAS "send" (BYVAL s AS LONG, buf AS Any, BYVAL buflen AS LONG, BYVAL flags AS LONG) AS LONG
DECLARE FUNCTION sendto LIB "wsock32.dll" ALIAS "sendto" (BYVAL s AS LONG, buf AS ANY, BYVAL buflen AS LONG, BYVAL flags AS LONG, to_addr AS sockaddr_in, BYVAL tolen AS LONG) AS LONG
DECLARE FUNCTION setsockopt LIB "wsock32.dll" ALIAS "setsockopt" (BYVAL s AS LONG, BYVAL level AS LONG, BYVAL optname AS LONG, optval AS Any, BYVAL optlen AS LONG) AS LONG
DECLARE FUNCTION socket LIB "wsock32.dll" ALIAS "socket" (BYVAL af AS LONG, BYVAL s_type AS LONG, BYVAL protocol AS LONG) AS LONG
DECLARE FUNCTION sselect LIB "wsock32.dll" ALIAS "select" (BYVAL nfds AS LONG, readfds AS fd_setstruc, writefds AS fd_setstruc, exceptfds AS fd_setstruc, tymeout AS timeval) AS LONG

'DATABASE FUNCTIONS
DECLARE FUNCTION gethostbyaddr LIB "wsock32.dll"  ALIAS "gethostbyaddr" (address AS LONG, BYVAL addr_len AS LONG, BYVAL addr_type AS LONG) AS LONG
DECLARE FUNCTION gethostbyname LIB "wsock32.dll" ALIAS "gethostbyname" (ost_name AS ASCIIZ) AS LONG
DECLARE FUNCTION gethostname LIB "wsock32.dll" ALIAS "gethostname" (host_name AS ASCIIZ, BYVAL namelen AS LONG) AS LONG
DECLARE FUNCTION getprotobyname LIB "wsock32.dll" ALIAS "getprotobyname" (proto_name AS ASCIIZ) AS LONG
DECLARE FUNCTION getprotobynumber LIB "wsock32.dll" ALIAS "getprotobynumber" (BYVAL proto AS LONG) AS LONG
DECLARE FUNCTION getservbyname LIB "wsock32.dll" ALIAS "getservbyname" (serv_name AS ASCIIZ, proto AS ASCIIZ) AS LONG
DECLARE FUNCTION getservbyport LIB "wsock32.dll" ALIAS "getservbyport" (BYVAL lPort AS LONG, proto AS ASCIIZ) AS LONG

'WINDOWS EXTENSIONS
DECLARE FUNCTION WSAAsyncSelect LIB "wsock32.dll" ALIAS "WSAAsyncSelect" (BYVAL s AS LONG, BYVAL hWnd AS LONG, BYVAL wMsg AS LONG, BYVAL lEvent AS LONG) AS LONG
DECLARE FUNCTION WSACancelBlockingCall LIB "wsock32.dll" ALIAS "WSACancelBlockingCall" () AS LONG
DECLARE FUNCTION WSACleanup LIB "wsock32.dll" ALIAS "WSACleanup" () AS LONG
DECLARE FUNCTION WSAGetLastError LIB "wsock32.dll" ALIAS "WSAGetLastError" () AS LONG
DECLARE FUNCTION WSAIsBlocking LIB "wsock32.dll" ALIAS "WSAIsBlocking" () AS LONG
DECLARE FUNCTION WSARecvEx LIB "wsock32.dll" ALIAS "WSARecvEx" (BYVAL s AS LONG, buf AS Any, BYVAL buflen AS LONG, BYVAL flags AS LONG) AS LONG
DECLARE FUNCTION WSASetBlockingHook LIB "wsock32.dll" ALIAS "WSASetBlockingHook" (BYVAL lpBlockFunc AS LONG) AS LONG
DECLARE FUNCTION WSAStartup LIB "wsock32.dll" ALIAS "WSAStartup" (BYVAL wVR AS LONG, lpWSAD AS WSAData) AS LONG
DECLARE FUNCTION WSAUnhookBlockingHook LIB "wsock32.dll" ALIAS "WSAUnhookBlockingHook" () AS LONG
DECLARE SUB WSASetLastError LIB "wsock32.dll" ALIAS "WSASetLastError" (BYVAL iError AS LONG)

'WSAASYNCGETXBYY FUNCTIONS DON'T WORK RELIABLY UNDER 32BIT WINDOWS
DECLARE FUNCTION WSAAsyncGetServByName LIB "wsock32.dll" ALIAS "WSAAsyncGetServByName" (BYVAL hWnd AS LONG, BYVAL wMsg AS LONG, serv_name AS ASCIIZ, proto AS ASCIIZ, buf AS ASCIIZ, BYVAL buflen AS LONG) AS LONG
DECLARE FUNCTION WSAAsyncGetServByPort LIB "wsock32.dll" ALIAS "WSAAsyncGetServByPort" (BYVAL hWnd AS LONG, BYVAL wMsg AS LONG, BYVAL lPort AS LONG, proto AS ASCIIZ, buf AS ASCIIZ, BYVAL buflen AS LONG) AS LONG
DECLARE FUNCTION WSAAsyncGetProtoByName LIB "wsock32.dll" ALIAS "WSAAsyncGetProtoByName" (BYVAL hWnd AS LONG, BYVAL wMsg AS LONG, proto_name AS ASCIIZ, buf AS ASCIIZ, BYVAL buflen AS LONG) AS LONG
DECLARE FUNCTION WSAAsyncGetProtoByNumber LIB "wsock32.dll" ALIAS "WSAAsyncGetProtoByNumber" (BYVAL hWnd AS LONG, BYVAL wMsg AS LONG, BYVAL number AS LONG, buf AS ASCIIZ, BYVAL buflen AS LONG) AS LONG
DECLARE FUNCTION WSAAsyncGetHostByName LIB "wsock32.dll" ALIAS "WSAAsyncGetHostByName" (BYVAL hWnd AS LONG, BYVAL wMsg AS LONG, host_name AS ASCIIZ, buf AS ASCIIZ, BYVAL buflen AS LONG) AS LONG
DECLARE FUNCTION WSAAsyncGetHostByAddr LIB "wsock32.dll" ALIAS "WSAAsyncGetHostByAddr" (BYVAL hWnd AS LONG, BYVAL wMsg AS LONG, address AS ASCIIZ, BYVAL addr_len AS LONG, BYVAL addr_type AS LONG, buf AS ASCIIZ, BYVAL buflen AS LONG) AS LONG
DECLARE FUNCTION WSACancelAsyncRequest LIB "wsock32.dll" ALIAS "WSACancelAsyncRequest" (BYVAL hAsyncTaskHandle AS LONG) AS LONG

' Return a pointer to all of the host IP addresses
FUNCTION GetHostAddr () AS LONG

  DIM hostent AS hostentStru PTR
  DIM hostname AS ASCIIZ * 32
  DIM result AS LONG

  result = GetHostName(hostname, SIZEOF(hostname))

  IF result THEN
    IF LEN(hostname) THEN
      hostent = GetHostByName(hostname)
      IF hostent THEN
        FUNCTION = @hostent.h_list
      END IF
    END IF
  END IF

END FUNCTION

SUB FD_ZERO (fd AS fd_setstruc)

  fd.fd_count = 0

END SUB

SUB FD_SET (BYVAL s AS LONG, fds AS fd_setstruc)
  DO
    IF fds.fd_count < %FD_SETSIZE THEN
      fds.fd_array(fds.fd_count) = s
      INCR fds.fd_count
    ELSE
      EXIT DO
    END IF
  LOOP
END SUB

#ENDIF
