'------------------------------------------------------------------------------
'
'       WS2_32.INC -- Windows Sockets 2 API Declarations for PowerBASIC
'
'                  Copyright (C) 1997-2001 PowerBASIC, Inc.
'           Portions Copyright (C) 1993-1999 Microsoft Corporation
'
' Last Update: July 16, 2001
'
' This file contains the constants and TYPE and DECLARE statements for the
' 32-bit Windows Sockets 2 API. It is based on the Windows SDK header file
' winsock2.h.
'
' This file is not compatible with Visual Basic. It uses the correct data type
' as defined in the Microsoft SDK for Windows for all API calls. This includes
' data types which are not natively supported in Visual Basic such as unsigned
' integers and ASCIIZ strings.
'
' You have a royalty-free right to use, modify, reproduce and distribute this
' file (and/or any modified version) in any way you find useful, provided that
' you agree that PowerBASIC has no warranty, obligation or liability for its
' contents. Refer to the Microsoft Windows Programmer's Reference for further
' information.
'
'------------------------------------------------------------------------------



#IF NOT %DEF(%WS2_32_INC) '----------------------------------------------------

%WS2_32_INC = 1

'
' Default: include function prototypes, don't include function typedefs.
'

#IF NOT %DEF(%INCL_WINSOCK_API_PROTOTYPES)
  %INCL_WINSOCK_API_PROTOTYPES = 1
#ENDIF

#IF NOT %DEF(%INCL_WINSOCK_API_TYPEDEFS)
  %INCL_WINSOCK_API_TYPEDEFS = 0
#ENDIF

'
' Pull in Windows includes if necessary
'
#IF NOT %DEF(%WINAPI)
    #INCLUDE "win32api.inc"
#ENDIF

' Define the current Winsock version. To build an earlier Winsock version
' application redefine this value prior to including WSOCK32.INC.

#IF NOT %DEF(%WINSOCK_VERSION)
%WINSOCK_VERSION = &H0202??
#ENDIF

' Select uses arrays of SOCKETs.  These macros manipulate such
' arrays.  FD_SETSIZE may be defined by the user before including
' this file, but the default here should be >= 64.

%FD_SETSIZE = 64

TYPE FD_SETstruc DWORD
  fd_count AS LONG
  fd_array(0 TO %FD_SETSIZE - 1) AS DWORD PTR
END TYPE

TYPE timeval DWORD
  tv_sec AS LONG     ' seconds
  tv_usec AS LONG    ' microseconds
END TYPE

%IOCPARM_MASK = &H7F                 ' parameters must be < 128 bytes
%IOC_VOID     = &H20000000           ' no parameters
%IOC_OUT      = &H40000000           ' copy out parameters
%IOC_IN       = &H80000000           ' copy in parameters
%IOC_INOUT    = %IOC_IN OR %IOC_OUT  ' 20000000 distinguishes new & old ioctl's

%FIONREAD     = &H4004667F
%FIONBIO      = &H8004667E
%FIOASYNC     = &H8004667D

' Socket I/O Controls
%SIOCSHIWAT   = &H80047300    ' set high watermark
%SIOCGHIWAT   = &H40047301    ' get high watermark
%SIOCSLOWAT   = &H80047302    ' set low watermark
%SIOCGLOWAT   = &H40047303    ' get low watermark
%SIOCATMARK   = &H40047307    ' at oob mark?

TYPE hostentStru
  h_name AS ASCIIZ PTR       ' official name of host
  h_aliases AS ASCIIZ PTR    ' alias list
  h_addrtype AS INTEGER      ' host address type
  h_length AS INTEGER        ' length of address
  h_addr_list AS DWORD PTR   ' list of addresses
END TYPE

' It is assumed here that a network number fits in 32 bits.

TYPE netent DWORD
  n_name AS ASCIIZ PTR       ' official name of net
  n_aliases AS DWORD PTR     ' alias list
  n_addrtype AS INTEGER      ' net address type
  n_net AS DWORD             ' network #
END TYPE

TYPE servent DWORD
  s_name AS ASCIIZ PTR     ' official service name
  s_aliases AS DWORD PTR   ' alias list
  s_port AS INTEGER        ' port #
  s_proto AS ASCIIZ PTR    ' protocol to use
END TYPE

TYPE protoent DWORD
  p_name AS ASCIIZ PTR     ' official protocol name
  p_aliases AS DWORD PTR   ' alias list
  p_proto AS INTEGER       ' protocol #
END TYPE

' Constants and structures defined by the internet system,
' Per RFC 790, September 1981.

' Protocols

%IPPROTO_IP   = 0    ' dummy for IP
%IPPROTO_ICMP = 1    ' control message protocol
%IPPROTO_IGMP = 2    ' internet group management protocol
%IPPROTO_GGP  = 3    ' gateway^2 (deprecated)
%IPPROTO_TCP  = 6    ' tcp
%IPPROTO_PUP  = 12   ' pup
%IPPROTO_UDP  = 17   ' user datagram protocol
%IPPROTO_IDP  = 22   ' xns idp
%IPPROTO_ND   = 77   ' UNOFFICIAL net disk proto

%IPPROTO_RAW  = 255  ' raw IP packet
%IPPROTO_MAX  = 256


' Port/socket numbers: network standard functions

%IPPORT_ECHO       = 7
%IPPORT_DISCARD    = 9
%IPPORT_SYSTAT     = 11
%IPPORT_DAYTIME    = 13
%IPPORT_NETSTAT    = 15
%IPPORT_FTP        = 21
%IPPORT_TELNET     = 23
%IPPORT_SMTP       = 25
%IPPORT_TIMESERVER = 37
%IPPORT_NAMESERVER = 42
%IPPORT_WHOIS      = 43
%IPPORT_MTP        = 57

' Port/socket numbers: host specific functions

%IPPORT_TFTP    = 69
%IPPORT_RJE     = 77
%IPPORT_FINGER  = 79
%IPPORT_TTYLINK = 87
%IPPORT_SUPDUP  = 95

' UNIX TCP sockets

%IPPORT_EXECSERVER  = 512
%IPPORT_LOGINSERVER = 513
%IPPORT_CMDSERVER   = 514
%IPPORT_EFSSERVER   = 520

' UNIX UDP sockets

%IPPORT_BIFFUDP     = 512
%IPPORT_WHOSERVER   = 513
%IPPORT_ROUTESERVER = 520
                    ' 520+1 also used

' Ports < IPPORT_RESERVED are reserved for privileged processes (e.g. root).

%IPPORT_RESERVED    = 1024

' Link numbers

%IMPLINK_IP        = 155
%IMPLINK_LOWEXPER  = 156
%IMPLINK_HIGHEXPER = 158

TYPE S_un_b
  s_b1 AS BYTE
  s_b2 AS BYTE
  s_b3 AS BYTE
  s_b4 AS BYTE
END TYPE

TYPE S_un_w
  s_w1 AS WORD
  s_w2 AS WORD
END TYPE

UNION S_un
  sunb AS S_un_b
  sunw AS S_un_w
END UNION

' Definitions of bits in internet address integers.
' On subnets, the decomposition of addresses to host and net parts
' is done according to subnet mask, not the masks here.

FUNCTION IN_CLASSA (BYVAL i AS DWORD) AS LONG
  FUNCTION = -((i AND &H80000000???) = 0???)
END FUNCTION

%IN_CLASSA_NET    = &HFF000000???
%IN_CLASSA_NSHIFT = 24
%IN_CLASSA_HOST   = &H00FFFFFF???
%IN_CLASSA_MAX    = 128

FUNCTION IN_CLASSB (BYVAL i AS DWORD) AS LONG
  FUNCTION = -((i AND &HC0000000???) = &H80000000???)
END FUNCTION

%IN_CLASSB_NET    = &HFFFF0000???
%IN_CLASSB_NSHIFT = 16
%IN_CLASSB_HOST   = &H0000FFFF???
%IN_CLASSB_MAX    = 65536

FUNCTION IN_CLASSC (BYVAL i AS DWORD) AS LONG
  FUNCTION = -((i AND &HE0000000???) = &HC0000000???)
END FUNCTION

%IN_CLASSC_NET    = &HFFFFFF00???
%IN_CLASSC_NSHIFT = 8
%IN_CLASSC_HOST   = &H000000FF???

FUNCTION IN_CLASSD (BYVAL i AS DWORD) AS LONG
  FUNCTION = -((i AND &HF0000000???) = &HE0000000???)
END FUNCTION

%IN_CLASSD_NET    = &HF0000000???   ' These ones aren't really
%IN_CLASSD_NSHIFT = 28              ' net and host fields, but
%IN_CLASSD_HOST   = &H0FFFFFFF???   ' routing needn't know.

FUNCTION IN_MULTICAST (BYVAL i AS DWORD) AS LONG
  FUNCTION = IN_CLASSD(i)
END FUNCTION

%INADDR_ANY       = &H00000000???
%INADDR_LOOPBACK  = &H7F000001???
%INADDR_BROADCAST = &HFFFFFFFF???
%INADDR_NONE      = &HFFFFFFFF???

%ADDR_ANY         = %INADDR_ANY

TYPE SOCKADDR_IN
  sin_family AS INTEGER
  sin_port AS WORD
  sin_addr AS S_un
  sin_zero AS STRING * 8
END TYPE

%WSADESCRIPTION_LEN = 256
%WSASYS_STATUS_LEN  = 128

TYPE WSADATA
  wVersion AS WORD
  wHighVersion AS WORD
  szDescription AS ASCIIZ * %WSADESCRIPTION_LEN + 1
  xFiller1 AS STRING * 3
  szSystemStatus AS ASCIIZ * %WSASYS_STATUS_LEN + 1
  xFiller2 AS STRING * 3
  iMaxSockets AS WORD
  iMaxUdpDg AS WORD
  lpVendorInfo AS ASCIIZ PTR
END TYPE

' Definitions related to sockets: types, address families, options.

%INVALID_SOCKET = &HFFFFFFFF???
%SOCKET_ERROR   = -1

' The following may be used in place of the address family, socket type, or
' protocol in a call to WSASocket to indicate that the corresponding value
' should be taken from the supplied WSAPROTOCOL_INFO structure instead of the
' parameter itself.

%FROM_PROTOCOL_INFO = -1

' Types
'
%SOCK_STREAM    = 1    ' stream socket
%SOCK_DGRAM     = 2    ' datagram socket
%SOCK_RAW       = 3    ' raw-protocol interface
%SOCK_RDM       = 4    ' reliably-delivered message
%SOCK_SEQPACKET = 5    ' sequenced packet stream

' Option flags per-socket.

%SO_DEBUG       = &H0001    ' turn on debugging info recording
%SO_ACCEPTCONN  = &H0002    ' socket has had listen()
%SO_REUSEADDR   = &H0004    ' allow local address reuse
%SO_KEEPALIVE   = &H0008    ' keep connections alive
%SO_DONTROUTE   = &H0010    ' just use interface addresses
%SO_BROADCAST   = &H0020    ' permit sending of broadcast msgs
%SO_USELOOPBACK = &H0040    ' bypass hardware when possible
%SO_LINGER      = &H0080    ' linger on close if data present
%SO_OOBINLINE   = &H0100    ' leave received OOB data in line

%SO_DONTLINGER       = &HFFFFFF7F   ' CLNG(NOT SO_LINGER)
%SO_EXCLUSIVEADDRUSE = &HFFFFFFFB   ' CLNG(NOT S0_REUSEADDR) disallow local address reuse

' Additional options.

%SO_SNDBUF      = &H1001    ' send buffer size
%SO_RCVBUF      = &H1002    ' receive buffer size
%SO_SNDLOWAT    = &H1003    ' send low-water mark
%SO_RCVLOWAT    = &H1004    ' receive low-water mark
%SO_SNDTIMEO    = &H1005    ' send timeout
%SO_RCVTIMEO    = &H1006    ' receive timeout
%SO_ERROR       = &H1007    ' get error status and clear
%SO_TYPE        = &H1008    ' get socket type

'
' WinSock 2 extension -- new options
'
%SO_GROUP_ID       = &H2001     ' ID of a socket group
%SO_GROUP_PRIORITY = &H2002     ' the relative priority within a group
%SO_MAX_MSG_SIZE   = &H2003     ' maximum message size
%SO_PROTOCOL_INFO  = &H2004     ' WSAPROTOCOL_INFO structure
%PVD_CONFIG        = &H3001     ' configuration info for service provider
%SO_CONDITIONAL_ACCEPT = &H3002 ' enable true conditional accept:
                                '  connection is not ack-ed to the
                                '  other side until conditional
                                '  function returns %CF_ACCEPT
' TCP options.

%TCP_NODELAY = &H0001

' Address families.

%AF_UNSPEC    = 0         ' unspecified
'
' Although AF_UNSPEC is defined for backwards compatibility, using
' AF_UNSPEC for the "af" parameter when creating a socket is STRONGLY
' DISCOURAGED. The interpretation of the "protocol" parameter
' depends on the actual address family chosen. As environments grow
' to include more and more address families that use overlapping
' protocol values there is more and more chance of choosing an
' undesired address family when AF_UNSPEC is used.
'
%AF_UNIX      = 1         ' local to host (pipes, portals)
%AF_INET      = 2         ' internetwork: UDP, TCP, etc.
%AF_IMPLINK   = 3         ' arpanet imp addresses
%AF_PUP       = 4         ' pup protocols: e.g. BSP
%AF_CHAOS     = 5         ' mit CHAOS protocols
%AF_NS        = 6         ' XEROX NS protocols
%AF_IPX       = 6         ' IPX and SPX
%AF_ISO       = 7         ' ISO protocols
%AF_OSI       = %AF_ISO   ' OSI is ISO
%AF_ECMA      = 8         ' european computer manufacturers
%AF_DATAKIT   = 9         ' datakit protocols
%AF_CCITT     = 10        ' CCITT protocols, X.25 etc
%AF_SNA       = 11        ' IBM SNA
%AF_DECnet    = 12        ' DECnet
%AF_DLI       = 13        ' Direct data link interface
%AF_LAT       = 14        ' LAT
%AF_HYLINK    = 15        ' NSC Hyperchannel
%AF_APPLETALK = 16        ' AppleTalk
%AF_NETBIOS   = 17        ' NetBios-style addresses
%AF_VOICEVIEW = 18        ' VoiceView
%AF_FIREFOX   = 19        ' Protocols from Firefox
%AF_UNKNOWN1  = 20        ' Somebody is using this!
%AF_BAN       = 21        ' Banyan
%AF_ATM       = 22        ' Native ATM Services
%AF_INET6     = 23        ' Internetwork Version 6
%AF_CLUSTER   = 24        ' Microsoft Wolfpack
%AF_12844     = 25        ' IEEE 1284.4 WG AF
%AF_IRDA      = 26        ' IrDA
%AF_NETDES    = 28        ' Network Designers OSI & gateway enabled protocols

%AF_MAX       = 29

' Structure used by kernel to store most addresses.
'
TYPE sockaddr DWORD
  sa_family AS WORD       ' address family
  sa_data AS STRING * 14  ' up to 14 bytes of direct address
END TYPE

' Structure used by kernel to pass protocol information in raw sockets.
'
TYPE sockproto DWORD
  sp_family AS WORD       ' address family
  sp_protocol AS WORD     ' protocol
END TYPE

' Protocol families, same as address families for now.

%PF_UNSPEC    = %AF_UNSPEC
%PF_UNIX      = %AF_UNIX
%PF_INET      = %AF_INET
%PF_IMPLINK   = %AF_IMPLINK
%PF_PUP       = %AF_PUP
%PF_CHAOS     = %AF_CHAOS
%PF_NS        = %AF_NS
%PF_IPX       = %AF_IPX
%PF_ISO       = %AF_ISO
%PF_OSI       = %AF_OSI
%PF_ECMA      = %AF_ECMA
%PF_DATAKIT   = %AF_DATAKIT
%PF_CCITT     = %AF_CCITT
%PF_SNA       = %AF_SNA
%PF_DECnet    = %AF_DECnet
%PF_DLI       = %AF_DLI
%PF_LAT       = %AF_LAT
%PF_HYLINK    = %AF_HYLINK
%PF_APPLETALK = %AF_APPLETALK
%PF_VOICEVIEW = %AF_VOICEVIEW
%PF_FIREFOX   = %AF_FIREFOX
%PF_UNKNOWN1  = %AF_UNKNOWN1
%PF_BAN       = %AF_BAN
%PF_ATM       = %AF_ATM
%PF_INET6     = %AF_INET6

%PF_MAX       = %AF_MAX

' Structure used for manipulating linger option.
'
TYPE linger DWORD
  l_onoff AS WORD    ' option on/off
  l_linger AS WORD   ' linger time
END TYPE

' Level number for (get/set)sockopt() to apply to socket itself.
'
%SOL_SOCKET = &HFFFF   ' options for socket level

' Maximum queue length specifiable by listen.
'
%SOMAXCONN = &H7FFFFFFF

%MSG_OOB       = &H1      ' process out-of-band data
%MSG_PEEK      = &H2      ' peek at incoming message
%MSG_DONTROUTE = &H4      ' send without using routing tables

%MSG_PARTIAL   = &H8000   ' partial send or recv for message xport

'
' WinSock 2 extension -- new flags for WSASend(), WSASendTo(), WSARecv() and
'                          WSARecvFrom()
'
%MSG_INTERRUPT = &H10   ' send/recv in the interrupt context

%MSG_MAXIOVLEN = 16

' Define constant based on rfc883, used by gethostbyxxxx() calls.

%MAXGETHOSTSTRUCT = 1024

' WinSock 2 extension -- bit values and indices for FD_XXX network events

%FD_READ_BIT    = 0
%FD_READ        = 1

%FD_WRITE_BIT   = 1
%FD_WRITE       = 2

%FD_OOB_BIT     = 2
%FD_OOB         = 4

%FD_ACCEPT_BIT  = 3
%FD_ACCEPT      = 8

%FD_CONNECT_BIT = 4
%FD_CONNECT     = 16

%FD_CLOSE_BIT   = 5
%FD_CLOSE       = 32

%FD_QOS_BIT     = 6
%FD_QOS         = 64

%FD_GROUP_QOS_BIT = 7
%FD_GROUP_QOS   = 128

%FD_ROUTING_INTERFACE_CHANGE_BIT = 8
%FD_ROUTING_INTERFACE_CHANGE = 256

%FD_ADDRESS_LIST_CHANGE_BIT = 9
%FD_ADDRESS_LIST_CHANGE = 512

%FD_MAX_EVENTS = 10
%FD_ALL_EVENTS = 1024 - 1

'
' WinSock error codes are also defined in winerror.h
' Hence the #IF %DEF
'

#IF NOT %DEF(%WSABASEERR) '----------------------------------------------------

' All Windows Sockets error constants are biased by WSABASEERR from
' the "normal"

%WSABASEERR             = 10000

' Windows Sockets definitions of regular Microsoft C error constants

%WSAEINTR               = %WSABASEERR+4
%WSAEBADF               = %WSABASEERR+9
%WSAEACCES              = %WSABASEERR+13
%WSAEFAULT              = %WSABASEERR+14
%WSAEINVAL              = %WSABASEERR+22
%WSAEMFILE              = %WSABASEERR+24

' Windows Sockets definitions of regular Berkeley error constants

%WSAEWOULDBLOCK         = %WSABASEERR+35
%WSAEINPROGRESS         = %WSABASEERR+36
%WSAEALREADY            = %WSABASEERR+37
%WSAENOTSOCK            = %WSABASEERR+38
%WSAEDESTADDRREQ        = %WSABASEERR+39
%WSAEMSGSIZE            = %WSABASEERR+40
%WSAEPROTOTYPE          = %WSABASEERR+41
%WSAENOPROTOOPT         = %WSABASEERR+42
%WSAEPROTONOSUPPORT     = %WSABASEERR+43
%WSAESOCKTNOSUPPORT     = %WSABASEERR+44
%WSAEOPNOTSUPP          = %WSABASEERR+45
%WSAEPFNOSUPPORT        = %WSABASEERR+46
%WSAEAFNOSUPPORT        = %WSABASEERR+47
%WSAEADDRINUSE          = %WSABASEERR+48
%WSAEADDRNOTAVAIL       = %WSABASEERR+49
%WSAENETDOWN            = %WSABASEERR+50
%WSAENETUNREACH         = %WSABASEERR+51
%WSAENETRESET           = %WSABASEERR+52
%WSAECONNABORTED        = %WSABASEERR+53
%WSAECONNRESET          = %WSABASEERR+54
%WSAENOBUFS             = %WSABASEERR+55
%WSAEISCONN             = %WSABASEERR+56
%WSAENOTCONN            = %WSABASEERR+57
%WSAESHUTDOWN           = %WSABASEERR+58
%WSAETOOMANYREFS        = %WSABASEERR+59
%WSAETIMEDOUT           = %WSABASEERR+60
%WSAECONNREFUSED        = %WSABASEERR+61
%WSAELOOP               = %WSABASEERR+62
%WSAENAMETOOLONG        = %WSABASEERR+63
%WSAEHOSTDOWN           = %WSABASEERR+64
%WSAEHOSTUNREACH        = %WSABASEERR+65
%WSAENOTEMPTY           = %WSABASEERR+66
%WSAEPROCLIM            = %WSABASEERR+67
%WSAEUSERS              = %WSABASEERR+68
%WSAEDQUOT              = %WSABASEERR+69
%WSAESTALE              = %WSABASEERR+70
%WSAEREMOTE             = %WSABASEERR+71

' Extended Windows Sockets error constant definitions

%WSASYSNOTREADY         = %WSABASEERR+91
%WSAVERNOTSUPPORTED     = %WSABASEERR+92
%WSANOTINITIALISED      = %WSABASEERR+93
%WSAEDISCON             = %WSABASEERR+101
%WSAENOMORE             = %WSABASEERR+102
%WSAECANCELLED          = %WSABASEERR+103
%WSAEINVALIDPROCTABLE   = %WSABASEERR+104
%WSAEINVALIDPROVIDER    = %WSABASEERR+105
%WSAEPROVIDERFAILEDINIT = %WSABASEERR+106
%WSASYSCALLFAILURE      = %WSABASEERR+107
%WSASERVICE_NOT_FOUND   = %WSABASEERR+108
%WSATYPE_NOT_FOUND      = %WSABASEERR+109
%WSA_E_NO_MORE          = %WSABASEERR+110
%WSA_E_CANCELLED        = %WSABASEERR+111
%WSAEREFUSED            = %WSABASEERR+112

' Error return codes from gethostbyname() and gethostbyaddr()
' (when using the resolver). Note that these errors are
' retrieved via WSAGetLastError() and must therefore follow
' the rules for avoiding clashes with error numbers from
' specific implementations or language run-time systems.
' For this reason the codes are based at %WSABASEERR+1001.
' Note also that %[WSA]NO_ADDRESS is defined only for
' compatibility purposes.

' Authoritative Answer: Host not found
%WSAHOST_NOT_FOUND      = %WSABASEERR+1001

' Non-Authoritative: Host not found, or SERVERFAIL
%WSATRY_AGAIN           = %WSABASEERR+1002

' Non-recoverable errors, FORMERR, REFUSED, NOTIMP
%WSANO_RECOVERY         = %WSABASEERR+1003

' Valid name, no data record of requested type
%WSANO_DATA             = %WSABASEERR+1004

'
' Define QOS related error return codes
'

' at least one Reserve has arrived
%WSA_QOS_RECEIVERS               = %WSABASEERR + 1005
' at least one Path has arrived
%WSA_QOS_SENDERS                 = %WSABASEERR + 1006
' there are no senders
%WSA_QOS_NO_SENDERS              = %WSABASEERR + 1007
' there are no receivers
%WSA_QOS_NO_RECEIVERS            = %WSABASEERR + 1008
' Reserve has been confirmed
%WSA_QOS_REQUEST_CONFIRMED       = %WSABASEERR + 1009
' error due to lack of resources
%WSA_QOS_ADMISSION_FAILURE       = %WSABASEERR + 1010
' rejected for administrative reasons - bad credentials
%WSA_QOS_POLICY_FAILURE          = %WSABASEERR + 1011
' unknown or conflicting style
%WSA_QOS_BAD_STYLE               = %WSABASEERR + 1012
' problem with some part of the filterspec or providerspecific
' buffer in general
%WSA_QOS_BAD_OBJECT              = %WSABASEERR + 1013
' problem with some part of the flowspec
%WSA_QOS_TRAFFIC_CTRL_ERROR      = %WSABASEERR + 1014
' general error
%WSA_QOS_GENERIC_ERROR           = %WSABASEERR + 1015
' invalid service type in flowspec
%WSA_QOS_ESERVICETYPE            = %WSABASEERR + 1016
' invalid flowspec
%WSA_QOS_EFLOWSPEC               = %WSABASEERR + 1017
' invalid provider specific buffer
%WSA_QOS_EPROVSPECBUF            = %WSABASEERR + 1018
' invalid filter style
%WSA_QOS_EFILTERSTYLE            = %WSABASEERR + 1019
' invalid filter type
%WSA_QOS_EFILTERTYPE             = %WSABASEERR + 1020
' incorrect number of filters
%WSA_QOS_EFILTERCOUNT            = %WSABASEERR + 1021
' invalid object length
%WSA_QOS_EOBJLENGTH              = %WSABASEERR + 1022
' incorrect number of flows
%WSA_QOS_EFLOWCOUNT              = %WSABASEERR + 1023
' unknown object in provider specific buffer
%WSA_QOS_EUNKOWNPSOBJ            = %WSABASEERR + 1024
' invalid policy object in provider specific buffer
%WSA_QOS_EPOLICYOBJ              = %WSABASEERR + 1025
' invalid flow descriptor in the list
%WSA_QOS_EFLOWDESC               = %WSABASEERR + 1026
' inconsistent flow spec in provider specific buffer
%WSA_QOS_EPSFLOWSPEC             = %WSABASEERR + 1027
' invalid filter spec in provider specific buffer
%WSA_QOS_EPSFILTERSPEC           = %WSABASEERR + 1028
' invalid shape discard mode object in provider specific buffer
%WSA_QOS_ESDMODEOBJ              = %WSABASEERR + 1029
' invalid shaping rate object in provider specific buffer
%WSA_QOS_ESHAPERATEOBJ           = %WSABASEERR + 1030
' reserved policy element in provider specific buffer
%WSA_QOS_RESERVED_PETYPE         = %WSABASEERR + 1031

#ENDIF ' #IF NOT %DEF(%WSABASEERR) --------------------------------------------

' Compatibility macros.

%HOST_NOT_FOUND = %WSAHOST_NOT_FOUND
%TRY_AGAIN      = %WSATRY_AGAIN
%NO_RECOVERY    = %WSANO_RECOVERY
%NO_DATA        = %WSANO_DATA
' no address, look for MX record
%WSANO_ADDRESS  = %WSANO_DATA
%NO_ADDRESS     = %WSANO_ADDRESS


'
' Windows Sockets errors redefined as regular Berkeley error constants.
'
%EWOULDBLOCK     = %WSAEWOULDBLOCK
%EINPROGRESS     = %WSAEINPROGRESS
%EALREADY        = %WSAEALREADY
%ENOTSOCK        = %WSAENOTSOCK
%EDESTADDRREQ    = %WSAEDESTADDRREQ
%EMSGSIZE        = %WSAEMSGSIZE
%EPROTOTYPE      = %WSAEPROTOTYPE
%ENOPROTOOPT     = %WSAENOPROTOOPT
%EPROTONOSUPPORT = %WSAEPROTONOSUPPORT
%ESOCKTNOSUPPORT = %WSAESOCKTNOSUPPORT
%EOPNOTSUPP      = %WSAEOPNOTSUPP
%EPFNOSUPPORT    = %WSAEPFNOSUPPORT
%EAFNOSUPPORT    = %WSAEAFNOSUPPORT
%EADDRINUSE      = %WSAEADDRINUSE
%EADDRNOTAVAIL   = %WSAEADDRNOTAVAIL
%ENETDOWN        = %WSAENETDOWN
%ENETUNREACH     = %WSAENETUNREACH
%ENETRESET       = %WSAENETRESET
%ECONNABORTED    = %WSAECONNABORTED
%ECONNRESET      = %WSAECONNRESET
%ENOBUFS         = %WSAENOBUFS
%EISCONN         = %WSAEISCONN
%ENOTCONN        = %WSAENOTCONN
%ESHUTDOWN       = %WSAESHUTDOWN
%ETOOMANYREFS    = %WSAETOOMANYREFS
%ETIMEDOUT       = %WSAETIMEDOUT
%ECONNREFUSED    = %WSAECONNREFUSED
%ELOOP           = %WSAELOOP
%ENAMETOOLONG    = %WSAENAMETOOLONG
%EHOSTDOWN       = %WSAEHOSTDOWN
%EHOSTUNREACH    = %WSAEHOSTUNREACH
%ENOTEMPTY       = %WSAENOTEMPTY
%EPROCLIM        = %WSAEPROCLIM
%EUSERS          = %WSAEUSERS
%EDQUOT          = %WSAEDQUOT
%ESTALE          = %WSAESTALE
%EREMOTE         = %WSAEREMOTE

%WSA_IO_PENDING         = %ERROR_IO_PENDING
%WSA_IO_INCOMPLETE      = %ERROR_IO_INCOMPLETE
%WSA_INVALID_HANDLE     = %ERROR_INVALID_HANDLE
%WSA_INVALID_PARAMETER  = %ERROR_INVALID_PARAMETER
%WSA_NOT_ENOUGH_MEMORY  = %ERROR_NOT_ENOUGH_MEMORY
%WSA_OPERATION_ABORTED  = %ERROR_OPERATION_ABORTED

%WSA_INVALID_EVENT      = 0???
%WSA_MAXIMUM_WAIT_EVENTS= %MAXIMUM_WAIT_OBJECTS
%WSA_WAIT_FAILED        = %WAIT_FAILED
%WSA_WAIT_EVENT_0       = %WAIT_OBJECT_0
%WSA_WAIT_IO_COMPLETION = %WAIT_IO_COMPLETION
%WSA_WAIT_TIMEOUT       = %WAIT_TIMEOUT
%WSA_INFINITE           = %INFINITE

' WinSock 2 extension -- WSABUF and QOS struct, include qos.h
' to pull in FLOWSPEC and related definitions

TYPE WSABUF
  dLen AS DWORD       ' the length of the buffer
  buf AS ASCIIZ PTR   ' the pointer to the buffer
END TYPE

' This section defines the Quality of Service structures and types used
' by Winsock applications.

#IF NOT %DEF(%QOS_INC) '-------------------------------------------------------

%QOS_INC = 1

' Definitions for valued-based Service Type for each direction of data flow.

%SERVICETYPE_NOTRAFFIC           = &H00000000  ' No data in this direction
%SERVICETYPE_BESTEFFORT          = &H00000001  ' Best Effort
%SERVICETYPE_CONTROLLEDLOAD      = &H00000002  ' Controlled Load
%SERVICETYPE_GUARANTEED          = &H00000003  ' Guaranteed
%SERVICETYPE_NETWORK_UNAVAILABLE = &H00000004  ' Used to notify change to user
%SERVICETYPE_GENERAL_INFORMATION = &H00000005  ' corresponds to "General Parameters" defined by IntServ
%SERVICETYPE_NOCHANGE            = &H00000006  ' used to indicate that the flow spec contains no change from any previous one
%SERVICETYPE_NONCONFORMING       = &H00000009  ' Non-Conforming Traffic
%SERVICETYPE_NETWORK_CONTROL     = &H0000000A  ' Network Control traffic
%SERVICETYPE_QUALITATIVE         = &H0000000D  ' Qualitative applications

' Definitions for bitmap-based Service Type for each direction of data flow.

%SERVICE_BESTEFFORT              = &H80010000
%SERVICE_CONTROLLEDLOAD          = &H80020000
%SERVICE_GUARANTEED              = &H80040000
%SERVICE_QUALITATIVE             = &H80200000


' Flags to control the usage of RSVP on this flow.

' to turn off traffic control, 'OR' this flag with the
' ServiceType field in the FLOWSPEC

%SERVICE_NO_TRAFFIC_CONTROL = &H81000000


' this flag can be used to prevent any rsvp signaling messages from being
' sent. Local traffic control will be invoked, but no RSVP Path messages
' will be sent.This flag can also be used in conjunction with a receiving
' flowspec to suppress the automatic generation of a Reserve message.
' The application would receive notification that a Path  message had arrived
' and would then need to alter the QOS by issuing WSAIoctl(%SIO_SET_QOS),
' to unset this flag and thereby causing Reserve messages to go out.

%SERVICE_NO_QOS_SIGNALING   = &H40000000

' Flow Specifications for each direction of data flow.

TYPE FLOWSPEC DWORD
  TokenRate AS DWORD            ' In Bytes/sec
  TokenBucketSize AS DWORD      ' In Bytes
  PeakBandwidth AS DWORD        ' In Bytes/sec
  Latency AS DWORD              ' In microseconds
  DelayVariation AS DWORD       ' In microseconds
  ServiceType AS DWORD
  MaxSduSize AS DWORD           ' In Bytes
  MinimumPolicedSize AS DWORD   ' In Bytes
END TYPE


' this value can be used in the FLOWSPEC structure to instruct the Rsvp Service
' provider to derive the appropriate default value for the parameter.  Note
' that not all values in the FLOWSPEC structure can be defaults. In the
' ReceivingFlowspec, all parameters can be defaulted except the ServiceType.
' In the SendingFlowspec, the MaxSduSize and MinimumPolicedSize can be
' defaulted. Other defaults may be possible. Refer to the appropriate
' documentation.

%QOS_NOT_SPECIFIED = &HFFFFFFFF


' define a value that can be used for the PeakBandwidth, which will map into
' positive infinity when the FLOWSPEC is converted into IntServ floating point
' format.  We can't use (-1) because that value was previously defined to mean
' "select the default".

%POSITIVE_INFINITY_RATE = &HFFFFFFFE


' the provider specific structure can have a number of objects in it.
' Each next structure in the
' ProviderSpecific will be the QOS_OBJECT_HDR struct that prefaces the actual
' data with a type and length for that object.  This QOS_OBJECT struct can
' repeat several times if there are several objects.  This list of objects
' terminates either when the buffer length has been reached ( WSABUF ) or
' an object of type QOS_END_OF_LIST is encountered.

TYPE QOS_OBJECT_HDR DWORD
  ObjectType AS DWORD
  ObjectLength AS DWORD   ' the length of object buffer INCLUDING this header
END TYPE


' general QOS objects start at this offset from the base and have a range
' of 1000

%QOS_GENERAL_ID_BASE = 2000

%QOS_OBJECT_END_OF_LIST = &H00000001 + %QOS_GENERAL_ID_BASE
          ' QOS_End_of_list structure passed
%QOS_OBJECT_SD_MODE = &H00000002 + %QOS_GENERAL_ID_BASE
          ' QOS_ShapeDiscard structure passed
%QOS_OBJECT_SHAPING_RATE = &H00000003 + %QOS_GENERAL_ID_BASE
          ' QOS_ShapingRate structure
%QOS_OBJECT_DESTADDR = &H00000004 + %QOS_GENERAL_ID_BASE
          ' QOS_DestAddr structure (defined in qossp.h)


' This structure is used to define the behaviour that the traffic
' control packet shaper will apply to the flow.
'
' %TC_NONCONF_BORROW - the flow will receive resources remaining
'  after all higher priority flows have been serviced. If a
'  TokenRate is specified, packets may be non-conforming and
'  will be demoted to less than best-effort priority.
'
' %TC_NONCONF_SHAPE - TokenRate must be specified. Non-conforming
'  packets will be retianed in the packet shaper until they become
'  conforming.
'
' %TC_NONCONF_DISCARD - TokenRate must be specified. Non-conforming
'  packets will be discarded.

TYPE QOS_SD_MODE DWORD
  ObjectHdr AS QOS_OBJECT_HDR
  ShapeDiscardMode AS DWORD
END TYPE

%TC_NONCONF_BORROW      = 0
%TC_NONCONF_SHAPE       = 1
%TC_NONCONF_DISCARD     = 2
%TC_NONCONF_BORROW_PLUS = 3

' This structure allows an app to specify a prorated "average token rate" using
' by the traffic shaper under SHAPE modehaper queue. It is expressed in bytes
' per sec.
'
' ShapingRate (bytes per sec.)

TYPE QOS_SHAPING_RATE DWORD
  ObjectHdr AS QOS_OBJECT_HDR
  ShapingRate AS DWORD
END TYPE

#ENDIF ' #IF NOT %DEF(%QOS_INC) -----------------------------------------------

TYPE QOS
  SendingFlowspec AS FLOWSPEC      ' the flow spec for data sending
  ReceivingFlowspec AS FLOWSPEC    ' the flow spec for data receiving
  ProviderSpecific AS WSABUF       ' additional provider-specific stuff
END TYPE

' WinSock 2 extension -- manifest constants for return values of the condition function

%CF_ACCEPT = &H0000
%CF_REJECT = &H0001
%CF_DEFER  = &H0002

' WinSock 2 extension -- manifest constants for shutdown()

%SD_RECEIVE = &H00
%SD_SEND    = &H01
%SD_BOTH    = &H02

' WinSock 2 extension -- data type and manifest constants for socket groups

%SG_UNCONSTRAINED_GROUP = &H01
%SG_CONSTRAINED_GROUP   = &H02

' WinSock 2 extension -- data type for WSAEnumNetworkEvents()

TYPE WSANETWORKEVENTS
  lNetworkEvents AS LONG
  iErrorCode(0 TO %FD_MAX_EVENTS - 1) AS LONG
END TYPE

' WinSock 2 extension -- WSAPROTOCOL_INFO structure and associated
' manifest constants

#IF NOT %DEF(%GUID_DEFINED)
  TYPE GUIDAPI
    Data1 AS DWORD
    Data2 AS WORD
    Data3 AS WORD
    Data4 AS STRING * 8
  END TYPE
  %GUID_DEFINED = 1
#ENDIF

%MAX_PROTOCOL_CHAIN = 7
%BASE_PROTOCOL      = 1
%LAYERED_PROTOCOL   = 0

TYPE WSAPROTOCOLCHAIN
  ChainLen AS LONG    ' the length of the chain (=0, layered protocol; =1, base protocol; >1, protocol chain)
  ChainEntries(0 TO %MAX_PROTOCOL_CHAIN - 1) AS DWORD   ' a list of dwCatalogEntryIds
END TYPE

%WSAPROTOCOL_LEN = 255

TYPE WSAPROTOCOL_INFO
  dwServiceFlags1 AS DWORD
  dwServiceFlags2 AS DWORD
  dwServiceFlags3 AS DWORD
  dwServiceFlags4 AS DWORD
  dwProviderFlags AS DWORD
  ProviderId AS GUIDAPI
  dwCatalogEntryId AS DWORD
  ProtocolChain AS WSAPROTOCOLCHAIN
  iVersion AS LONG
  iAddressFamily AS LONG
  iMaxSockAddr AS LONG
  iMinSockAddr AS LONG
  iSocketType AS LONG
  iProtocol AS LONG
  iProtocolMaxOffset AS LONG
  iNetworkByteOrder AS LONG
  iSecurityScheme AS LONG
  dwMessageSize AS DWORD
  dwProviderReserved AS DWORD
  szProtocol AS ASCIIZ * (%WSAPROTOCOL_LEN + 1)
END TYPE

' Flag bit definitions for dwProviderFlags
%PFL_MULTIPLE_PROTO_ENTRIES  = &H00000001
%PFL_RECOMMENDED_PROTO_ENTRY = &H00000002
%PFL_HIDDEN                  = &H00000004
%PFL_MATCHES_PROTOCOL_ZERO   = &H00000008

' Flag bit definitions for dwServiceFlags1
%XP1_CONNECTIONLESS           = &H00000001
%XP1_GUARANTEED_DELIVERY      = &H00000002
%XP1_GUARANTEED_ORDER         = &H00000004
%XP1_MESSAGE_ORIENTED         = &H00000008
%XP1_PSEUDO_STREAM            = &H00000010
%XP1_GRACEFUL_CLOSE           = &H00000020
%XP1_EXPEDITED_DATA           = &H00000040
%XP1_CONNECT_DATA             = &H00000080
%XP1_DISCONNECT_DATA          = &H00000100
%XP1_SUPPORT_BROADCAST        = &H00000200
%XP1_SUPPORT_MULTIPOINT       = &H00000400
%XP1_MULTIPOINT_CONTROL_PLANE = &H00000800
%XP1_MULTIPOINT_DATA_PLANE    = &H00001000
%XP1_QOS_SUPPORTED            = &H00002000
%XP1_INTERRUPT                = &H00004000
%XP1_UNI_SEND                 = &H00008000
%XP1_UNI_RECV                 = &H00010000
%XP1_IFS_HANDLES              = &H00020000
%XP1_PARTIAL_MESSAGE          = &H00040000

%BIGENDIAN    = &H0000
%LITTLEENDIAN = &H0001

%SECURITY_PROTOCOL_NONE = &H0000

' WinSock 2 extension -- manifest constants for WSAJoinLeaf()

%JL_SENDER_ONLY   = &H01
%JL_RECEIVER_ONLY = &H02
%JL_BOTH          = &H04

' WinSock 2 extension -- manifest constants for WSASocket()

%WSA_FLAG_OVERLAPPED        = &H01
%WSA_FLAG_MULTIPOINT_C_ROOT = &H02
%WSA_FLAG_MULTIPOINT_C_LEAF = &H04
%WSA_FLAG_MULTIPOINT_D_ROOT = &H08
%WSA_FLAG_MULTIPOINT_D_LEAF = &H10

' WinSock 2 extension -- manifest constants for WSAIoctl()

%IOC_UNIX     = &H00000000
%IOC_WS2      = &H08000000
%IOC_PROTOCOL = &H10000000
%IOC_VENDOR   = &H18000000

%SIOCSHIWAT                         = &H80047300
%SIO_ASSOCIATE_HANDLE               = &H88000001
%SIO_ENABLE_CIRCULAR_QUEUEING       = &H28000002
%SIO_FIND_ROUTE                     = &H48000003
%SIO_FLUSH                          = &H28000004
%SIO_GET_BROADCAST_ADDRESS          = &H48000005
%SIO_GET_EXTENSION_FUNCTION_POINTER = &HC8000006
%SIO_GET_QOS                        = &HC8000007
%SIO_GET_GROUP_QOS                  = &HC8000008
%SIO_MULTIPOINT_LOOPBACK            = &H88000009
%SIO_MULTICAST_SCOPE                = &H8800000A
%SIO_SET_QOS                        = &H8800000B
%SIO_SET_GROUP_QOS                  = &H8800000C
%SIO_TRANSLATE_HANDLE               = &HC800000D
%SIO_ROUTING_INTERFACE_QUERY        = &HC8000014
%SIO_ROUTING_INTERFACE_CHANGE       = &H88000015
%SIO_ADDRESS_LIST_QUERY             = &H48000016
%SIO_ADDRESS_LIST_CHANGE            = &H28000017
%SIO_QUERY_TARGET_PNP_HANDLE        = &H48000018

' WinSock 2 extension -- manifest constants for SIO_TRANSLATE_HANDLE ioctl

%TH_NETDEV = &H00000001
%TH_TAPI   = &H00000002

' Manifest constants and type definitions related to name resolution and
' registration (RNR) API

#IF NOT %DEF(%BLOB_DEFINED)
  %BLOB_DEFINED = 1
  TYPE BLOB
    cbSize AS DWORD
    pBlobData AS BYTE PTR
  END TYPE
#ENDIF

' Service Install Flags

%SERVICE_MULTIPLE       = &H00000001

' & Name Spaces

%NS_ALL         = 0

%NS_SAP         = 1
%NS_NDS         = 2
%NS_PEER_BROWSE = 3
%NS_SLP         = 5
%NS_DHCP        = 6

%NS_TCPIP_LOCAL = 10
%NS_TCPIP_HOSTS = 11
%NS_DNS         = 12
%NS_NETBT       = 13
%NS_WINS        = 14

%NS_NBP         = 20

%NS_MS          = 30
%NS_STDA        = 31
%NS_NTDS        = 32

%NS_X500        = 40
%NS_NIS         = 41
%NS_NISPLUS     = 42

%NS_WRQ         = 50

%NS_NETDES      = 60    ' Network Designers Limited


' Resolution flags for WSAGetAddressByName().
' Note these are also used by the 1.1 API GetAddressByName, so
' leave them around.

%RES_UNUSED_1    = &H00000001
%RES_FLUSH_CACHE = &H00000002
#IF NOT %DEF(%RES_SERVICE)
%RES_SERVICE     = &H00000004
#ENDIF

' Well known value names for Service Types

$SERVICE_TYPE_VALUE_IPXPORT  = "IpxSocket"
$SERVICE_TYPE_VALUE_SAPID    = "SapId"
$SERVICE_TYPE_VALUE_TCPPORT  = "TcpPort"
$SERVICE_TYPE_VALUE_UDPPORT  = "UdpPort"
$SERVICE_TYPE_VALUE_OBJECTID = "ObjectId"

#IF NOT %DEF(%CSADDR_DEFINED) '------------------------------------------------

' SockAddr Information

TYPE SOCKET_ADDRESS
  lpSocaddr AS SOCKADDR PTR
  iSockaddrLength AS LONG
END TYPE

' CSAddr Information

TYPE CSADDR_INFO
  LocalAddr AS SOCKET_ADDRESS
  RemoteAddr AS SOCKET_ADDRESS
  iSocketType AS LONG
  iProtocol AS LONG
END TYPE

#ENDIF ' #IF NOT %DEF(%CSADDR_DEFINED) ----------------------------------------

' Address list returned via SIO_ADDRESS_LIST_QUERY

TYPE SOCKET_ADDRESS_LIST
  iAddressCount AS LONG
  Address(0 TO 0) AS SOCKET_ADDRESS
END TYPE

' Address Family/Protocol Tuples

TYPE AFPROTOCOLS
  iAddressFamily AS LONG
  iProtocol AS LONG
END TYPE

' Client Query API Typedefs

' The comparators

%COMP_EQUAL   = 0
%COMP_NOTLESS = 1

TYPE WSAVersion
  dwVersion AS DWORD
  ecHow AS LONG
END TYPE

TYPE WSAQUERYSET
  dwSize AS DWORD
  lpszServiceInstanceName AS ASCIIZ PTR
  lpServiceClassId AS GUIDAPI PTR
  lpVersion AS WSAVERSION PTR
  lpszComment AS ASCIIZ PTR
  dwNameSpace AS DWORD
  lpNSProviderId AS GUIDAPI PTR
  lpszContext AS ASCIIZ PTR
  dwNumberOfProtocols AS DWORD
  lpafpProtocols AS AFPROTOCOLS PTR
  lpszQueryString AS ASCIIZ PTR
  dwNumberOfCsAddrs AS DWORD
  lpcsaBuffer AS CSADDR_INFO PTR
  dwOutputFlags AS DWORD
  lpBlob AS BLOB PTR
END TYPE

%LUP_DEEP                = &H0001
%LUP_CONTAINERS          = &H0002
%LUP_NOCONTAINERS        = &H0004
%LUP_NEAREST             = &H0008
%LUP_RETURN_NAME         = &H0010
%LUP_RETURN_TYPE         = &H0020
%LUP_RETURN_VERSION      = &H0040
%LUP_RETURN_COMMENT      = &H0080
%LUP_RETURN_ADDR         = &H0100
%LUP_RETURN_BLOB         = &H0200
%LUP_RETURN_ALIASES      = &H0400
%LUP_RETURN_QUERY_STRING = &H0800
%LUP_RETURN_ALL          = &H0FF0
%LUP_RES_SERVICE         = &H8000

%LUP_FLUSHCACHE          = &H1000
%LUP_FLUSHPREVIOUS       = &H2000

' Return flags

%RESULT_IS_ALIAS      = &H0001

' Service Address Registration and Deregistration Data Types.

%RNRSERVICE_REGISTER = 0
%RNRSERVICE_DEREGISTER = 1
%RNRSERVICE_DELETE = 2

' Service Installation/Removal Data Types.

TYPE WSANSCLASSINFO
  lpszName AS ASCIIZ PTR
  dwNameSpace AS DWORD
  dwValueType AS DWORD
  dwValueSize AS DWORD
  lpValue AS BYTE PTR
END TYPE

TYPE WSASERVICECLASSINFO
  lpServiceClassId AS GUIDAPI PTR
  lpszServiceClassName AS ASCIIZ PTR
  dwCount AS DWORD
  lpClassInfos AS WSANSCLASSINFO PTR
END TYPE

TYPE WSANAMESPACE_INFO
  NSProviderId AS GUIDAPI
  dwNameSpace AS DWORD
  fActive AS LONG
  dwVersion AS DWORD
  lpszIdentifier AS ASCIIZ PTR
END TYPE

#IF (%INCL_WINSOCK_API_PROTOTYPES) '-------------------------------------------

DECLARE FUNCTION aaccept LIB "ws2_32.dll" ALIAS "accept" (s AS DWORD, saAddr AS SOCKADDR, addrlen AS LONG) AS DWORD
DECLARE FUNCTION bind LIB "ws2_32.dll" ALIAS "bind" (s AS DWORD, sname AS SOCKADDR, BYVAL namelen AS LONG) AS LONG
DECLARE FUNCTION closesocket LIB "ws2_32.dll" ALIAS "closesocket" (s AS DWORD) AS LONG
DECLARE FUNCTION cconnect LIB "ws2_32.dll" ALIAS "connect" (s AS DWORD, sname AS SOCKADDR, BYVAL namelen AS LONG) AS LONG
DECLARE FUNCTION ioctlsocket LIB "ws2_32.dll" ALIAS "ioctlsocket" (s AS DWORD, BYVAL cmd AS LONG, argp AS DWORD) AS LONG
DECLARE FUNCTION getpeername LIB "ws2_32.dll" ALIAS "getpeername" (s AS DWORD, sname AS SOCKADDR, namelen AS LONG) AS LONG
DECLARE FUNCTION getsockname LIB "ws2_32.dll" ALIAS "getsockname" (s AS DWORD, sname AS SOCKADDR, namelen AS LONG) AS LONG
DECLARE FUNCTION getsockopt LIB "ws2_32.dll" ALIAS "getsockport" (s AS DWORD, BYVAL level AS LONG, BYVAL optname AS LONG, optval AS ASCIIZ, optlen AS LONG) AS LONG
DECLARE FUNCTION htonl LIB "ws2_32.dll" ALIAS "htonl" (BYVAL hostlong AS DWORD) AS DWORD
DECLARE FUNCTION htons LIB "ws2_32.dll" ALIAS "htons" (BYVAL hostshort AS WORD) AS WORD
DECLARE FUNCTION inet_addr LIB "ws2_32.dll" ALIAS "inet_addr" (cp AS ASCIIZ) AS DWORD
DECLARE FUNCTION inet_ntoa LIB "ws2_32.dll" ALIAS "inet_ntoa" (inn AS S_un) AS STRING
DECLARE FUNCTION listen LIB "ws2_32.dll" ALIAS "listen" (s AS DWORD, BYVAL backlog AS LONG) AS LONG
DECLARE FUNCTION ntohl LIB "ws2_32.dll" ALIAS "ntohl" (BYVAL netlong AS DWORD) AS DWORD
DECLARE FUNCTION ntohs LIB "ws2_32.dll" ALIAS "ntohs" (BYVAL netshort AS WORD) AS WORD
DECLARE FUNCTION rrecv LIB "ws2_32.dll" ALIAS "recv" (s AS DWORD, buf AS ANY, BYVAL buflen AS LONG, BYVAL flags AS LONG) AS LONG
DECLARE FUNCTION recvfrom LIB "ws2_32.dll" ALIAS "recvfrom" (s AS DWORD, buf AS ANY, BYVAL buflen AS LONG, BYVAL flags AS LONG, saFrom AS SOCKADDR, fromlen AS LONG) AS LONG
DECLARE FUNCTION sselect LIB "ws2_32.dll" ALIAS "select" (BYVAL nfds AS LONG, readfds AS fd_setstruc, writefds AS fd_setstruc, exceptfds AS FD_SETstruc, tymeout AS timeval) AS LONG
DECLARE FUNCTION ssend LIB "ws2_32.dll" ALIAS "send" (s AS DWORD, buf AS ANY, BYVAL buflen AS LONG, BYVAL flags AS LONG) AS LONG
DECLARE FUNCTION sendto LIB "ws2_32.dll" ALIAS "sendto" (s AS DWORD, buf AS ANY, BYVAL buflen AS LONG, BYVAL flags AS LONG, to_addr AS SOCKADDR, BYVAL tolen AS LONG) AS LONG
DECLARE FUNCTION setsockopt LIB "ws2_32.dll" ALIAS "setsockopt" (s AS DWORD, BYVAL level AS LONG, BYVAL optname AS LONG, optval AS ANY, BYVAL optlen AS LONG) AS LONG
DECLARE FUNCTION shutdown LIB "ws2_32.dll" ALIAS "shutdown" (s AS DWORD, BYVAL how AS LONG) AS LONG
DECLARE FUNCTION socket LIB "ws2_32.dll" ALIAS "socket" (BYVAL af AS LONG, BYVAL s_type AS LONG, BYVAL protocol AS LONG) AS DWORD

' Database function prototypes
DECLARE FUNCTION gethostbyaddr LIB "ws2_32.dll"  ALIAS "gethostbyaddr" (saAddr AS ANY, BYVAL addr_len AS LONG, BYVAL addr_type AS LONG) AS DWORD
DECLARE FUNCTION gethostbyname LIB "ws2_32.dll" ALIAS "gethostbyname" (hname AS ASCIIZ) AS DWORD
DECLARE FUNCTION gethostname LIB "ws2_32.dll" ALIAS "gethostname" (host_name AS ASCIIZ, BYVAL namelen AS LONG) AS LONG
DECLARE FUNCTION getservbyport LIB "ws2_32.dll" ALIAS "getservbyport" (BYVAL lPort AS LONG, proto AS ASCIIZ) AS DWORD
DECLARE FUNCTION getservbyname LIB "ws2_32.dll" ALIAS "getservbyname" (serv_name AS ASCIIZ, proto AS ASCIIZ) AS DWORD
DECLARE FUNCTION getprotobynumber LIB "ws2_32.dll" ALIAS "getprotobynumber" (BYVAL proto AS LONG) AS DWORD
DECLARE FUNCTION getprotobyname LIB "ws2_32.dll" ALIAS "getprotobyname" (proto_name AS ASCIIZ) AS DWORD

' Microsoft Windows Extension function prototypes

DECLARE FUNCTION WSAStartup LIB "ws2_32.dll" ALIAS "WSAStartup" (BYVAL wVR AS WORD, lpWSAD AS WSADATA) AS LONG
DECLARE FUNCTION WSACleanup LIB "ws2_32.dll" ALIAS "WSACleanup" () AS LONG
DECLARE SUB WSASetLastError LIB "ws2_32.dll" ALIAS "WSASetLastError" (BYVAL iError AS LONG)
DECLARE FUNCTION WSAGetLastError LIB "ws2_32.dll" ALIAS "WSAGetLastError" () AS LONG
DECLARE FUNCTION WSAIsBlocking LIB "ws2_32.dll" ALIAS "WSAIsBlocking" () AS LONG
DECLARE FUNCTION WSAUnhookBlockingHook LIB "ws2_32.dll" ALIAS "WSAUnhookBlockingHook" () AS LONG
DECLARE FUNCTION WSASetBlockingHook LIB "ws2_32.dll" ALIAS "WSASetBlockingHook" (BYVAL lpBlockFunc AS DWORD) AS DWORD
DECLARE FUNCTION WSACancelBlockingCall LIB "ws2_32.dll" ALIAS "WSACancelBlockingCall" () AS LONG
DECLARE FUNCTION WSAAsyncGetServByName LIB "ws2_32.dll" ALIAS "WSAAsyncGetServByName" (BYVAL hWnd AS DWORD, BYVAL wMsg AS DWORD, serv_name AS ASCIIZ, proto AS ASCIIZ, buf AS ASCIIZ, BYVAL buflen AS LONG) AS DWORD
DECLARE FUNCTION WSAAsyncGetServByPort LIB "ws2_32.dll" ALIAS "WSAAsyncGetServByPort" (BYVAL hWnd AS DWORD, BYVAL wMsg AS DWORD, BYVAL lPort AS LONG, proto AS ASCIIZ, buf AS ASCIIZ, BYVAL buflen AS LONG) AS DWORD
DECLARE FUNCTION WSAAsyncGetProtoByName LIB "ws2_32.dll" ALIAS "WSAAsyncGetProtoByName" (BYVAL hWnd AS DWORD, BYVAL wMsg AS DWORD, proto_name AS ASCIIZ, buf AS ASCIIZ, BYVAL buflen AS LONG) AS DWORD
DECLARE FUNCTION WSAAsyncGetProtoByNumber LIB "ws2_32.dll" ALIAS "WSAAsyncGetProtoByNumber" (BYVAL hWnd AS DWORD, BYVAL wMsg AS DWORD, BYVAL number AS LONG, buf AS ASCIIZ, BYVAL buflen AS LONG) AS DWORD
DECLARE FUNCTION WSAAsyncGetHostByName LIB "ws2_32.dll" ALIAS "WSAAsyncGetHostByName" (BYVAL hWnd AS DWORD, BYVAL wMsg AS DWORD, host_name AS ASCIIZ, buf AS ASCIIZ, BYVAL buflen AS LONG) AS DWORD
DECLARE FUNCTION WSAAsyncGetHostByAddr LIB "ws2_32.dll" ALIAS "WSAAsyncGetHostByAddr" (BYVAL hWnd AS DWORD, BYVAL wMsg AS DWORD, address AS ASCIIZ, BYVAL addr_len AS LONG, BYVAL addr_type AS LONG, buf AS ASCIIZ, BYVAL buflen AS LONG) AS DWORD
DECLARE FUNCTION WSACancelAsyncRequest LIB "ws2_32.dll" ALIAS "WSACancelAsyncRequest" (BYVAL hAsyncTaskHandle AS DWORD) AS LONG
DECLARE FUNCTION WSAAsyncSelect LIB "ws2_32.dll" ALIAS "WSAAsyncSelect" (s AS DWORD, BYVAL hWnd AS DWORD, BYVAL wMsg AS DWORD, BYVAL lEvent AS LONG) AS LONG

' WinSock 2 API new function prototypes

DECLARE FUNCTION WSAAccept LIB "ws2_32.dll" ALIAS "WSAAccept" (s AS DWORD, saAddr AS SOCKADDR, addrlen AS LONG, lpfnCondition AS DWORD, dwCallbackData AS DWORD) AS DWORD
DECLARE FUNCTION WSACloseEvent LIB "ws2_32.dll" ALIAS "WSACloseEvent" (BYVAL h AS DWORD) AS LONG
DECLARE FUNCTION WSAConnect LIB "ws2_32.dll" ALIAS "WSAConnect" (s AS DWORD, sname AS SOCKADDR, BYVAL namelen AS LONG, lpCallerData AS WSABUF, lpCalleeData AS WSABUF, lpSQOS AS QOS, lpGQOS AS QOS) AS LONG
DECLARE FUNCTION WSACreateEvent LIB "ws2_32.dll" ALIAS "WSACreateEvent" () AS DWORD
DECLARE FUNCTION WSADuplicateSocket LIB "ws2_32.dll" ALIAS "WSADuplicateSocketA" (s AS DWORD, BYVAL dwProcessId AS DWORD, lpProtocolInfo AS WSAPROTOCOL_INFO) AS LONG
DECLARE FUNCTION WSAEnumNetworkEvents LIB "ws2_32.dll" ALIAS "WSAEnumNetworkEvents" (s AS DWORD, BYVAL hEventObject AS DWORD, lpNetworkEvents AS WSANETWORKEVENTS) AS LONG
DECLARE FUNCTION WSAEnumProtocols LIB "ws2_32.dll" ALIAS "WSAEnumProtocolsA" (lpiProtocols AS LONG, lpProtocolBuffer AS WSAPROTOCOL_INFO, lpdwBufferLength AS DWORD) AS LONG
DECLARE FUNCTION WSAEventSelect LIB "ws2_32.dll" ALIAS "WSAEventSelect" (s AS DWORD, BYVAL hEventObject AS DWORD, BYVAL lNetworkEvents AS LONG) AS LONG
DECLARE FUNCTION WSAGetOverlappedResult LIB "ws2_32.dll" ALIAS "WSAGetOverlappedResult" (s AS DWORD, lpOverlapped AS OVERLAPPED, lpcbTransfer AS DWORD, BYVAL fWait AS LONG, lpdwFlags AS DWORD) AS LONG
DECLARE FUNCTION WSAGetQOSByName LIB "ws2_32.dll" ALIAS "WSAGetQOSByName" (s AS DWORD, lpQOSName AS WSABUF, lpQOS AS QOS) AS LONG
DECLARE FUNCTION WSAHtonl LIB "ws2_32.dll" ALIAS "WSAHtonl" (s AS DWORD, BYVAL hostlong AS DWORD, lpnetlong AS DWORD) AS LONG
DECLARE FUNCTION WSAHtons LIB "ws2_32.dll" ALIAS "WSAHtons" (s AS DWORD, BYVAL hostshort AS WORD, lpnetshort AS WORD) AS LONG
DECLARE FUNCTION WSAIoctl LIB "ws2_32.dll" ALIAS "WSAIoctl" (s AS DWORD, BYVAL dwIoControlCode AS DWORD, BYVAL lpvInBuffer AS DWORD, BYVAL cbInBuffer AS DWORD, BYVAL lpvOutBuffer AS DWORD, BYVAL cbOutBuffer AS DWORD, _
    lpcbBytesReturned AS DWORD, lpOverlapped AS OVERLAPPED, BYVAL lpCompletionRoutine AS DWORD) AS LONG
DECLARE FUNCTION WSAJoinLeaf LIB "ws2_32.dll" ALIAS "WSAJoinLeaf" (s AS DWORD, sname AS SOCKADDR, BYVAL namelen AS LONG, lpCallerData AS WSABUF, lpCalleeData AS WSABUF, lpSQOS AS QOS, lpGQOS AS QOS, BYVAL dwFlags AS DWORD) AS DWORD
DECLARE FUNCTION WSANtohl LIB "ws2_32.dll" ALIAS "WSANtohl" (s AS DWORD, BYVAL netlong AS DWORD, lphostlong AS DWORD) AS LONG
DECLARE FUNCTION WSANtohs LIB "ws2_32.dll" ALIAS "WSANtohs" (s AS DWORD, BYVAL netshort AS WORD, lphostshort AS WORD) AS LONG
DECLARE FUNCTION WSARecv LIB "ws2_32.dll" ALIAS "WSARecv" (s AS DWORD, lpBuffers AS WSABUF, BYVAL dwBufferCount AS DWORD, lpNumberOfBytesRecvd AS DWORD, lpFlags AS DWORD, lpOverlapped AS OVERLAPPED, _
    BYVAL lpCompletionRoutine AS DWORD) AS LONG
DECLARE FUNCTION WSARecvDisconnect LIB "ws2_32.dll" ALIAS "WSARecvDisconnect" (s AS DWORD, lpInboundDisconnectData AS WSABUF) AS LONG
DECLARE FUNCTION WSARecvFrom LIB "ws2_32.dll" ALIAS "WSARecvFrom" (s AS DWORD, lpBuffers AS WSABUF, BYVAL dwBufferCount AS DWORD, lpNumberOfBytesRecvd AS DWORD, lpFlags AS DWORD, lpFrom AS SOCKADDR, _
    lpFromlen AS LONG, lpOverlapped AS OVERLAPPED, BYVAL lpCompletionRoutine AS DWORD) AS LONG
DECLARE FUNCTION WSAResetEvent LIB "ws2_32.dll" ALIAS "WSAResetEvent" (BYVAL hEvent AS DWORD) AS LONG
DECLARE FUNCTION WSASend LIB "ws2_32.dll" ALIAS "WSASend" (s AS DWORD, lpBuffers AS WSABUF, BYVAL dwBufferCount AS DWORD, lpNumberOfBytesSent AS DWORD, BYVAL dwFlags AS DWORD, lpOverlapped AS OVERLAPPED, _
    BYVAL lpCompletionRoutine AS DWORD) AS LONG
DECLARE FUNCTION WSASendDisconnect LIB "ws2_32.dll" ALIAS "WSASendDisconnect" (s AS DWORD, lpOutboundDisconnectData AS WSABUF) AS LONG
DECLARE FUNCTION WSASendTo LIB "ws2_32.dll" ALIAS "WSASendTo" (s AS DWORD, lpBuffers AS WSABUF, BYVAL dwBufferCount AS DWORD, lpNumberOfBytesSent AS DWORD, BYVAL dwFlags AS DWORD, lpTo AS SOCKADDR, BYVAL iTolen AS LONG, _
    lpOverlapped AS OVERLAPPED, BYVAL lpCompletionRoutine AS DWORD) AS LONG
DECLARE FUNCTION WSASetEvent LIB "ws2_32.dll" ALIAS "WSASetEvent" (BYVAL hEvent AS DWORD) AS LONG
DECLARE FUNCTION WSASocket LIB "ws2_32.dll" ALIAS "WSASocketA" (BYVAL af AS LONG, BYVAL ltype AS LONG, BYVAL protocol AS LONG, lpProtocolInfo AS WSAPROTOCOL_INFO, BYVAL g AS DWORD, BYVAL dwFlags AS DWORD) AS DWORD
DECLARE FUNCTION WSAWaitForMultipleEvents LIB "ws2_32.dll" ALIAS "WSAWaitForMultipleEvents" (BYVAL cEvents AS DWORD, BYVAL lphEvents AS DWORD PTR, BYVAL fWaitAll AS LONG, BYVAL dwTimeout AS DWORD, BYVAL fAlertable AS LONG) AS DWORD
DECLARE FUNCTION WSAAddressToString LIB "ws2_32.dll" ALIAS "WSAAddressToStringA" (lpsaAddress AS SOCKADDR, BYVAL dwAddressLength AS DWORD, lpProtocolInfo AS WSAPROTOCOL_INFO, lpszAddressString AS ASCIIZ, _
    lpdwAddressStringLength AS DWORD) AS LONG
DECLARE FUNCTION WSAStringToAddress LIB "ws2_32.dll" ALIAS "WSAStringToAddressA" (AddressString AS ASCIIZ, BYVAL AddressFamily AS LONG, lpProtocolInfo AS WSAPROTOCOL_INFO, lpAddress AS SOCKADDR, lpAddressLength AS LONG) AS LONG

' Registration and Name Resolution API functions

DECLARE FUNCTION WSALookupServiceBegin LIB "ws2_32.dll" ALIAS "WSALookupServiceBeginA" (lpqsRestrictions AS WSAQUERYSET, BYVAL dwControlFlags AS DWORD, lphLookup AS DWORD) AS LONG
DECLARE FUNCTION WSALookupServiceNext LIB "ws2_32.dll" ALIAS "WSALookupServiceNextA" (BYVAL hLookup AS DWORD, BYVAL dwControlFlags AS DWORD, lpdwBufferLength AS DWORD, lpsqResults AS WSAQUERYSET) AS LONG
DECLARE FUNCTION WSALookupServiceEnd LIB "ws2_32.dll" ALIAS "WSALookupServiceEnd" (BYVAL hLookup AS DWORD) AS LONG
DECLARE FUNCTION WSAInstallServiceClass LIB "ws2_32.dll" ALIAS "WSAInstallServiceClassA" (lpServiceClassInfo AS WSASERVICECLASSINFO) AS LONG
DECLARE FUNCTION WSARemoveServiceClass LIB "ws2_32.dll" ALIAS "WSARemoveServiceClass" (lpServiceClassId AS GUIDAPI) AS LONG
DECLARE FUNCTION WSAGetServiceClassInfo LIB "ws2_32.dll" ALIAS "WSAGetServiceClassInfoA" (lpProviderId AS GUIDAPI, lpServiceClassId AS GUIDAPI, lpdwBufSize AS DWORD, lpServiceClassInfo AS WSASERVICECLASSINFO) AS LONG
DECLARE FUNCTION WSAEnumNameSpaceProviders LIB "ws2_32.dll" ALIAS "WSAEnumNameSpaceProvidersA" (lpdwBufferLength AS DWORD, lpnspBuffer AS WSANAMESPACE_INFO) AS LONG
DECLARE FUNCTION WSAGetServiceClassNameByClassId LIB "ws2_32.dll" ALIAS "WSAGetServiceClassNameByClassIdA" (lpServiceClassId AS GUIDAPI, lpszServiceClassName AS ASCIIZ, lpdwBufferLength AS DWORD) AS LONG
DECLARE FUNCTION WSASetService LIB "ws2_32.dll" ALIAS "WSASetServiceA" (lpqsRegInfo AS WSAQUERYSET, BYVAL essoperation AS LONG, BYVAL dwControlFlags AS DWORD) AS LONG
DECLARE FUNCTION WSAProviderConfigChange LIB "ws2_32.dll" ALIAS "WSAProviderConfigChange" (lpNotificationHandle AS DWORD, lpOverlapped AS OVERLAPPED, BYVAL lpCompletionRoutine AS DWORD) AS LONG

#ENDIF ' #IF (%INCL_WINSOCK_API_PROTOTYPES) -----------------------------------


FUNCTION h_errno () AS LONG
  FUNCTION = WSAGetLastError
END FUNCTION

' Windows message parameter composition and decomposition
' macros.

' WSAMAKEASYNCREPLY is intended for use by the Windows Sockets implementation
' when constructing the response to a WSAAsyncGetXByY() routine.

FUNCTION WSAMAKEASYNCREPLY (BYVAL wbuflen AS WORD, BYVAL werror AS WORD) AS LONG
  FUNCTION = MAKLNG(wbuflen,werror)
END FUNCTION

' WSAMAKESELECTREPLY is intended for use by the Windows Sockets implementation
' when constructing the response to WSAAsyncSelect().

FUNCTION WSAMAKESELECTREPLY (BYVAL wevent AS WORD, BYVAL werror AS WORD) AS LONG
  FUNCTION = MAKLNG(wevent,werror)
END FUNCTION

' WSAGETASYNCBUFLEN is intended for use by the Windows Sockets application
' to extract the buffer length from the lParam in the response
' to a WSAAsyncGetXByY().

FUNCTION WSAGETASYNCBUFLEN (BYVAL lParam AS LONG) AS WORD
  FUNCTION = LOWRD(lParam)
END FUNCTION

' WSAGETASYNCERROR is intended for use by the Windows Sockets application
' to extract the error code from the lParam in the response
' to a WSAGetXByY().

FUNCTION WSAGETASYNCERROR (BYVAL lParam AS LONG) AS WORD
  FUNCTION = HIWRD(lParam)
END FUNCTION

' WSAGETSELECTEVENT is intended for use by the Windows Sockets application
' to extract the event code from the lParam in the response
' to a WSAAsyncSelect().

FUNCTION WSAGETSELECTEVENT (BYVAL lParam AS LONG) AS WORD
  FUNCTION = LOWRD(lParam)
END FUNCTION

' WSAGETSELECTERROR is intended for use by the Windows Sockets application
' to extract the error code from the lParam in the response
' to a WSAAsyncSelect().

FUNCTION WSAGETSELECTERROR (BYVAL lParam AS LONG) AS WORD
  FUNCTION = HIWRD(lParam)
END FUNCTION

' Return a pointer to all of the host IP addresses

FUNCTION GetHostAddr() AS DWORD

  DIM hostent AS hostentStru PTR
  DIM hostname AS ASCIIZ * 32
  DIM result AS LONG

  result = GetHostName(hostname, SIZEOF(hostname))

  IF result THEN
    IF LEN(hostname) THEN
      hostent = GetHostByName(hostname)
      IF hostent THEN
        FUNCTION = @hostent.h_addr_list
      END IF
    END IF
  END IF

END FUNCTION

#ENDIF ' #IF NOT %DEF(%WS2_32_INC) --------------------------------------------
