'==============================================================================
'
'  RAS Functions
'
'  Partial translation of the C header files for the RAS connection
'
'  by Don Dickinson
'  Hereby Public Domain
'  Use or Misuse of this code implies that you hold the author (Don Dickinson)
'  harmless for any effects or side-effects generated by this code.
'
'  Depends upon your copy of win32api.inc that came with PB/DLL
'
'  * Updated 5/31/2000 by Dave Navarro, Jr.
'  * Updated 6/1/2000 by Dave Navarro, Jr.
'
'==============================================================================

#IF NOT %DEF(%WINAPI)
  #INCLUDE "WIN32API.INC"
#ENDIF

%RASBASE                             = 600
%SUCCESS                             = 0

%PENDING                             = %RASBASE + 0
'
' An operation is pending.
'
%ERROR_INVALID_PORT_HANDLE           = %RASBASE + 1
'
' The port handle is invalid.
'
%ERROR_PORT_ALREADY_OPEN             = %RASBASE + 2
'
' The port is already open.
'
%ERROR_BUFFER_TOO_SMALL              = %RASBASE + 3
'
' Caller's buffer is too small.
'
%ERROR_WRONG_INFO_SPECIFIED          = %RASBASE + 4
'
' Wrong information specified.
'
%ERROR_CANNOT_SET_PORT_INFO          = %RASBASE + 5
'
' Cannot set port information.
'
%ERROR_PORT_NOT_CONNECTED            = %RASBASE + 6
'
' The port is not connected.
'
%ERROR_EVENT_INVALID                 = %RASBASE + 7
'
' The event is invalid.
'
%ERROR_DEVICE_DOES_NOT_EXIST         = %RASBASE + 8
'
' The device does not exist.
'
%ERROR_DEVICETYPE_DOES_NOT_EXIST     = %RASBASE + 9
'
' The device type does not exist.
'
%ERROR_BUFFER_INVALID                = %RASBASE + 10
'
' The buffer is invalid.
'
%ERROR_ROUTE_NOT_AVAILABLE           = %RASBASE + 11
'
' The route is not available.
'
%ERROR_ROUTE_NOT_ALLOCATED           = %RASBASE + 12
'
' The route is not allocated.
'
%ERROR_INVALID_COMPRESSION_SPECIFIED = %RASBASE + 13
'
' Invalid compression specified.
'
%ERROR_OUT_OF_BUFFERS                = %RASBASE + 14
'
' Out of buffers.
'
%ERROR_PORT_NOT_FOUND                = %RASBASE + 15
'
' The port was not found.
'
%ERROR_ASYNC_REQUEST_PENDING         = %RASBASE + 16
'
' An asynchronous request is pending.
'
%ERROR_ALREADY_DISCONNECTING         = %RASBASE + 17
'
' The port or device is already disconnecting.
'
%ERROR_PORT_NOT_OPEN                 = %RASBASE + 18
'
' The port is not open.
'
%ERROR_PORT_DISCONNECTED             = %RASBASE + 19
'
' The port is disconnected.
'
%ERROR_NO_ENDPOINTS                  = %RASBASE + 20
'
' There are no endpoints.
'
%ERROR_CANNOT_OPEN_PHONEBOOK         = %RASBASE + 21
'
' Cannot open the phone book file.
'
%ERROR_CANNOT_LOAD_PHONEBOOK         = %RASBASE + 22
'
' Cannot load the phone book file.
'
%ERROR_CANNOT_FIND_PHONEBOOK_ENTRY   = %RASBASE + 23
'
' Cannot find the phone book entry.
'
%ERROR_CANNOT_WRITE_PHONEBOOK        = %RASBASE + 24
'
' Cannot write the phone book file.
'
%ERROR_CORRUPT_PHONEBOOK             = %RASBASE + 25
'
' Invalid information found in the phone book file.
'
%ERROR_CANNOT_LOAD_STRING            = %RASBASE + 26
'
' Cannot load a string.
'
%ERROR_KEY_NOT_FOUND                 = %RASBASE + 27
'
' Cannot find key.
'
%ERROR_DISCONNECTION                 = %RASBASE + 28
'
' The port was disconnected.
'
%ERROR_REMOTE_DISCONNECTION          = %RASBASE + 29
'
' The data link was terminated by the remote machine.
'
%ERROR_HARDWARE_FAILURE              = %RASBASE + 30
'
' The port was disconnected due to hardware failure.
'
%ERROR_USER_DISCONNECTION            = %RASBASE + 31
'
' The port was disconnected by the user.
'
%ERROR_INVALID_SIZE                  = %RASBASE + 32
'
' The structure size is incorrect.
'
%ERROR_PORT_NOT_AVAILABLE            = %RASBASE + 33
'
' The port is already in use or is not configured for Remote Access dial out.
'
%ERROR_CANNOT_PROJECT_CLIENT         = %RASBASE + 34
'
' Cannot register your computer on on the remote network.
'
%ERROR_UNKNOWN                       = %RASBASE + 35
'
' Unknown error.
'
%ERROR_WRONG_DEVICE_ATTACHED         = %RASBASE + 36
'
' The wrong device is attached to the port.
'
%ERROR_BAD_STRING                    = %RASBASE + 37
'
' The string could not be converted.
'
%ERROR_REQUEST_TIMEOUT               = %RASBASE + 38
'
' The request has timed out.
'
%ERROR_CANNOT_GET_LANA               = %RASBASE + 39
'
' No asynchronous net available.
'
%ERROR_NETBIOS_ERROR                 = %RASBASE + 40
'
' A NetBIOS error has occurred.
'
%ERROR_SERVER_OUT_OF_RESOURCES       = %RASBASE + 41
'
' The server cannot allocate NetBIOS resources needed to support the client.
'
%ERROR_NAME_EXISTS_ON_NET            = %RASBASE + 42
'
' One of your NetBIOS names is already registered on the remote network.
'
%ERROR_SERVER_GENERAL_NET_FAILURE    = %RASBASE + 43
'
' A network adapter at the server failed.
'
%WARNING_MSG_ALIAS_NOT_ADDED         = %RASBASE + 44
'
' You will not receive network message popups.
'
%ERROR_AUTH_INTERNAL                 = %RASBASE + 45
'
' Internal authentication error.
'
%ERROR_RESTRICTED_LOGON_HOURS        = %RASBASE + 46
'
' The account is not permitted to logon at this time of day.
'
%ERROR_ACCT_DISABLED                 = %RASBASE + 47
'
' The account is disabled.
'
%ERROR_PASSWD_EXPIRED                = %RASBASE + 48
'
' The password has expired.
'
%ERROR_NO_DIALIN_PERMISSION          = %RASBASE + 49
'
' The account does not have Remote Access permission.
'
%ERROR_SERVER_NOT_RESPONDING         = %RASBASE + 50
'
' The Remote Access server is not responding.
'
%ERROR_FROM_DEVICE                   = %RASBASE + 51
'
' Your modem or other connecting device has reported an error.
'
%ERROR_UNRECOGNIZED_RESPONSE         = %RASBASE + 52
'
' Unrecognized response from the device.
'
%ERROR_MACRO_NOT_FOUND               = %RASBASE + 53
'
' A macro required by the device was not found in the device .INF file section.
'
%ERROR_MACRO_NOT_DEFINED             = %RASBASE + 54
'
' A command or response in the device .INF file section refers to an undefined macro.
'
%ERROR_MESSAGE_MACRO_NOT_FOUND       = %RASBASE + 55
'
' The <message> macro was not found in the device .INF file secion.
'
%ERROR_DEFAULTOFF_MACRO_NOT_FOUND    = %RASBASE + 56
'
' The <defaultoff> macro in the device .INF file section contains an undefined macro.
'
%ERROR_FILE_COULD_NOT_BE_OPENED      = %RASBASE + 57
'
' The device .INF file could not be opened.
'
%ERROR_DEVICENAME_TOO_LONG           = %RASBASE + 58
'
' The device name in the device .INF or media .INI file is too long.
'
%ERROR_DEVICENAME_NOT_FOUND          = %RASBASE + 59
'
' The media .INI file refers to an unknown device name.
'
%ERROR_NO_RESPONSES                  = %RASBASE + 60
'
' The device .INF file contains no responses for the command.
'
%ERROR_NO_COMMAND_FOUND              = %RASBASE + 61
'
' The device .INF file is missing a command.
'
%ERROR_WRONG_KEY_SPECIFIED           = %RASBASE + 62
'
' Attempted to set a macro not listed in device .INF file section.
'
%ERROR_UNKNOWN_DEVICE_TYPE           = %RASBASE + 63
'
' The media .INI file refers to an unknown device type.
'
%ERROR_ALLOCATING_MEMORY             = %RASBASE + 64
'
' Cannot allocate memory.
'
%ERROR_PORT_NOT_CONFIGURED           = %RASBASE + 65
'
' The port is not configured for Remote Access.
'
%ERROR_DEVICE_NOT_READY              = %RASBASE + 66
'
' Your modem or other connecting device is not functioning.
'
%ERROR_READING_INI_FILE              = %RASBASE + 67
'
' Cannot read the media .INI file.
'
%ERROR_NO_CONNECTION                 = %RASBASE + 68
'
' The connection dropped.
'
%ERROR_BAD_USAGE_IN_INI_FILE         = %RASBASE + 69
'
' The usage parameter in the media .INI file is invalid.
'
%ERROR_READING_SECTIONNAME           = %RASBASE + 70
'
' Cannot read the section name from the media .INI file.
'
%ERROR_READING_DEVICETYPE            = %RASBASE + 71
'
' Cannot read the device type from the media .INI file.
'
%ERROR_READING_DEVICENAME            = %RASBASE + 72
'
' Cannot read the device name from the media .INI file.
'
%ERROR_READING_USAGE                 = %RASBASE + 73
'
' Cannot read the usage from the media .INI file.
'
%ERROR_READING_MAXCONNECTBPS         = %RASBASE + 74
'
' Cannot read the maximum connection BPS rate from the media .INI file.
'
%ERROR_READING_MAXCARRIERBPS         = %RASBASE + 75
'
' Cannot read the maximum carrier BPS rate from the media .INI file.
'
%ERROR_LINE_BUSY                     = %RASBASE + 76
'
' The line is busy.
'
%ERROR_VOICE_ANSWER                  = %RASBASE + 77
'
' A person answered instead of a modem.
'
%ERROR_NO_ANSWER                     = %RASBASE + 78
'
' There is no answer.
'
%ERROR_NO_CARRIER                    = %RASBASE + 79
'
' Cannot detect carrier.
'
%ERROR_NO_DIALTONE                   = %RASBASE + 80
'
' There is no dial tone.
'
%ERROR_IN_COMMAND                    = %RASBASE + 81
'
' General error reported by device.
'
%ERROR_WRITING_SECTIONNAME           = %RASBASE + 82
'
' ERROR_WRITING_SECTIONNAME
'
%ERROR_WRITING_DEVICETYPE            = %RASBASE + 83
'
' ERROR_WRITING_DEVICETYPE
'
%ERROR_WRITING_DEVICENAME            = %RASBASE + 84
'
' ERROR_WRITING_DEVICENAME
'
%ERROR_WRITING_MAXCONNECTBPS         = %RASBASE + 85
'
' ERROR_WRITING_MAXCONNECTBPS
'
%ERROR_WRITING_MAXCARRIERBPS         = %RASBASE + 86
'
' ERROR_WRITING_MAXCARRIERBPS
'
%ERROR_WRITING_USAGE                 = %RASBASE + 87
'
' ERROR_WRITING_USAGE
'
%ERROR_WRITING_DEFAULTOFF            = %RASBASE + 88
'
' ERROR_WRITING_DEFAULTOFF
'
%ERROR_READING_DEFAULTOFF            = %RASBASE + 89
'
' ERROR_READING_DEFAULTOFF
'
%ERROR_EMPTY_INI_FILE                = %RASBASE + 90
'
' ERROR_EMPTY_INI_FILE
'
%ERROR_AUTHENTICATION_FAILURE        = %RASBASE + 91
'
' Access denied because username and/or password is invalid on the domain.
'
%ERROR_PORT_OR_DEVICE                = %RASBASE + 92
'
' Hardware failure in port or attached device.
'
%ERROR_NOT_BINARY_MACRO              = %RASBASE + 93
'
' ERROR_NOT_BINARY_MACRO
'
%ERROR_DCB_NOT_FOUND                 = %RASBASE + 94
'
' ERROR_DCB_NOT_FOUND
'
%ERROR_STATE_MACHINES_NOT_STARTED    = %RASBASE + 95
'
' ERROR_STATE_MACHINES_NOT_STARTED
'
%ERROR_STATE_MACHINES_ALREADY_STARTED= %RASBASE + 96
'
' ERROR_STATE_MACHINES_ALREADY_STARTED
'
%ERROR_PARTIAL_RESPONSE_LOOPING      = %RASBASE + 97
'
' ERROR_PARTIAL_RESPONSE_LOOPING
'
%ERROR_UNKNOWN_RESPONSE_KEY          = %RASBASE + 98
'
' A response keyname in the device .INF file is not in the expected format.
'
%ERROR_RECV_BUF_FULL                 = %RASBASE + 99
'
' The device response caused buffer overflow.
'
%ERROR_CMD_TOO_LONG                  = %RASBASE + 100
'
' The expanded command in the device .INF file is too long.
'
%ERROR_UNSUPPORTED_BPS               = %RASBASE + 101
'
' The device moved to a BPS rate not supported by the COM driver.
'
%ERROR_UNEXPECTED_RESPONSE           = %RASBASE + 102
'
' Device response received when none expected.
'
%ERROR_INTERACTIVE_MODE              = %RASBASE + 103
'
' The Application does not allow user interaction. The connection requires interaction with the user to complete successfully.
'
%ERROR_BAD_CALLBACK_NUMBER           = %RASBASE + 104
'
' ERROR_BAD_CALLBACK_NUMBER
'
%ERROR_INVALID_AUTH_STATE            = %RASBASE + 105
'
' ERROR_INVALID_AUTH_STATE
'
%ERROR_WRITING_INITBPS               = %RASBASE + 106
'
' ERROR_WRITING_INITBPS
'
%ERROR_X25_DIAGNOSTIC                = %RASBASE + 107
'
' X.25 diagnostic indication.
'
%ERROR_ACCT_EXPIRED                  = %RASBASE + 108
'
' The account has expired.
'
%ERROR_CHANGING_PASSWORD             = %RASBASE + 109
'
' Error changing password on domain.  The password may be too short or may match a previously used password.
'
%ERROR_OVERRUN                       = %RASBASE + 110
'
' Serial overrun errors were detected while communicating with your modem.
'
%ERROR_RASMAN_CANNOT_INITIALIZE         = %RASBASE + 111
'
' RasMan initialization failure.  Check the event log.
'
%ERROR_BIPLEX_PORT_NOT_AVAILABLE     = %RASBASE + 112
'
' Biplex port initializing.  Wait a few seconds and redial.
'
%ERROR_NO_ACTIVE_ISDN_LINES          = %RASBASE + 113
'
' No active ISDN lines are available.
'
%ERROR_NO_ISDN_CHANNELS_AVAILABLE    = %RASBASE + 114
'
' No ISDN channels are available to make the call.
'
%ERROR_TOO_MANY_LINE_ERRORS          = %RASBASE + 115
'
' Too many errors occurred because of poor phone line quality.
'
%ERROR_IP_CONFIGURATION              = %RASBASE + 116
'
' The Remote Access IP configuration is unusable.
'
%ERROR_NO_IP_ADDRESSES               = %RASBASE + 117
'
' No IP addresses are available in the static pool of Remote Access IP addresses.
'
%ERROR_PPP_TIMEOUT                   = %RASBASE + 118
'
' Timed out waiting for a valid response from the remote PPP peer.
'
%ERROR_PPP_REMOTE_TERMINATED         = %RASBASE + 119
'
' PPP terminated by remote machine.
'
%ERROR_PPP_NO_PROTOCOLS_CONFIGURED   = %RASBASE + 120
'
' No PPP control protocols configured.
'
%ERROR_PPP_NO_RESPONSE               = %RASBASE + 121
'
' Remote PPP peer is not responding.
'
%ERROR_PPP_INVALID_PACKET            = %RASBASE + 122
'
' The PPP packet is invalid.
'
%ERROR_PHONE_NUMBER_TOO_LONG         = %RASBASE + 123
'
' The phone number including prefix and suffix is too long.
'
%ERROR_IPXCP_NO_DIALOUT_CONFIGURED   = %RASBASE + 124
'
' The IPX protocol cannot dial-out on the port because the machine is an IPX router.
'
%ERROR_IPXCP_NO_DIALIN_CONFIGURED    = %RASBASE + 125
'
' The IPX protocol cannot dial-in on the port because the IPX router is not installed.
'
%ERROR_IPXCP_DIALOUT_ALREADY_ACTIVE  = %RASBASE + 126
'
' The IPX protocol cannot be used for dial-out on more than one port at a time.
'
%ERROR_ACCESSING_TCPCFGDLL           = %RASBASE + 127
'
' Cannot access TCPCFG.DLL.
'
%ERROR_NO_IP_RAS_ADAPTER             = %RASBASE + 128
'
' Cannot find an IP adapter bound to Remote Access.
'
%ERROR_SLIP_REQUIRES_IP              = %RASBASE + 129
'
' SLIP cannot be used unless the IP protocol is installed.
'
%ERROR_PROJECTION_NOT_COMPLETE       = %RASBASE + 130
'
' Computer registration is not complete.
'
%ERROR_PROTOCOL_NOT_CONFIGURED       = %RASBASE + 131
'
' The protocol is not configured.
'
%ERROR_PPP_NOT_CONVERGING            = %RASBASE + 132
'
' The PPP negotiation is not converging.
'
%ERROR_PPP_CP_REJECTED               = %RASBASE + 133
'
' The PPP control protocol for this network protocol is not available on the server.
'
%ERROR_PPP_LCP_TERMINATED            = %RASBASE + 134
'
' The PPP link control protocol terminated.
'
%ERROR_PPP_REQUIRED_ADDRESS_REJECTED = %RASBASE + 135
'
' The requested address was rejected by the server.
'
%ERROR_PPP_NCP_TERMINATED            = %RASBASE + 136
'
' The remote computer terminated the control protocol.
'
%ERROR_PPP_LOOPBACK_DETECTED         = %RASBASE + 137
'
' Loopback detected.
'
%ERROR_PPP_NO_ADDRESS_ASSIGNED       = %RASBASE + 138
'
' The server did not assign an address.
'
%ERROR_CANNOT_USE_LOGON_CREDENTIALS  = %RASBASE + 139
'
' The authentication protocol required by the remote server cannot use the Windows NT encrypted password.  Redial, entering the password explicitly.
'
%ERROR_TAPI_CONFIGURATION            = %RASBASE + 140
'
' Invalid TAPI configuration.
'
%ERROR_NO_LOCAL_ENCRYPTION           = %RASBASE + 141
'
' The local computer does not support the required encryption type.
'
%ERROR_NO_REMOTE_ENCRYPTION          = %RASBASE + 142
'
' The remote computer does not support the required encryption type.
'
%ERROR_REMOTE_REQUIRES_ENCRYPTION    = %RASBASE + 143
'
' The remote computer requires encryption.
'
%ERROR_IPXCP_NET_NUMBER_CONFLICT     = %RASBASE + 144
'
' Cannot use the IPX network number assigned by remote server.  Check the event log.
'
%ERROR_INVALID_SMM                   = %RASBASE + 145
'
' ERROR_INVALID_SMM
'
%ERROR_SMM_UNINITIALIZED             = %RASBASE + 146
'
' ERROR_SMM_UNINITIALIZED
'
%ERROR_NO_MAC_FOR_PORT               = %RASBASE + 147
'
' ERROR_NO_MAC_FOR_PORT
'
%ERROR_SMM_TIMEOUT                   = %RASBASE + 148
'
' ERROR_SMM_TIMEOUT
'
%ERROR_BAD_PHONE_NUMBER              = %RASBASE + 149
'
' ERROR_BAD_PHONE_NUMBER
'
%ERROR_WRONG_MODULE                  = %RASBASE + 150
'
' ERROR_WRONG_MODULE
'
%ERROR_INVALID_CALLBACK_NUMBER       = %RASBASE + 151
'
' Invalid callback number.  Only the characters 0 to 9, T, P, W, , , -, @, and space are allowed in the number.
'
%ERROR_SCRIPT_SYNTAX                 = %RASBASE + 152
'
' A syntax error was encountered while processing a script.
'
%ERROR_HANGUP_FAILED                 = %RASBASE + 153
'
' The connection could not be disconnected because it was created by the Multi-Protocol Router.
'
%RASBASEEND                          = %RASBASE + 153

%RAS_MAXENTRYNAMEBUFFER              = 257
%RAS_MAXDEVICETYPE                   = 16
%RAS_MAXENTRYNAME                    = 256
%RAS_MAXDEVICENAME                   = 128
%RAS_MAXPHONENUMBER                  = 128
%RAS_MAXCALLBACKNUMBER               = %RAS_MAXPHONENUMBER

%RAS_MAXAREACODE                     = 10
%RAS_MAXPADTYPE                      = 32
%RAS_MAXX25ADDRESS                   = 200
%RAS_MAXFACILITIES                   = 200
%RAS_MAXUSERDATA                     = 200

%ULEN                                = 256
%PWLEN                               = 256
%DNLEN                               = 15

'- Connection Status Constants
%RASCS_PAUSED                        = &H1000
%RASCS_DONE                          = &H2000
%RASCS_CONNECTED                     = %RASCS_DONE

'- The members are not dword aligned, but the whole
'  structure has to fit into a 4-byte bounded memory space,
'  thus the extra 3-byte buffer at the end of the structure.
'  So far, all of the ras structures I've found work this
'  way. NOTE: This is not the same as using the Dword specifier
'  in the type declaration (that would dword align each
'  member of the structure).

TYPE RASENTRYNAME
   dwSize AS DWORD
   szEntryName AS ASCIIZ * %RAS_MAXENTRYNAMEBUFFER
   buffer AS ASCIIZ * 3
END TYPE

TYPE RASIPADDR
  a AS BYTE
  b AS BYTE
  c AS BYTE
  d AS BYTE
END TYPE

TYPE RASENTRY
  dwSize AS DWORD
  dwfOptions AS DWORD
  dwCountryID AS DWORD
  dwCountryCode AS DWORD
  szAreaCode AS ASCIIZ * %RAS_MAXAREACODE + 1
  szLocalPhoneNumber AS ASCIIZ * %RAS_MAXPHONENUMBER + 1
  dwAlternatesOffset AS DWORD
  ipaddr AS RASIPADDR
  ipaddrDns AS RASIPADDR
  ipaddrDnsAlt AS RASIPADDR
  ipaddrWins AS RASIPADDR
  ipaddrWinsAlt AS RASIPADDR
  dwFrameSize AS DWORD
  dwfNetProtocols AS DWORD
  dwFramingProtocol AS DWORD
  szScript AS ASCIIZ * %MAX_PATH
  szAutoDialDll AS ASCIIZ * %MAX_PATH
  szAutoDialFunc AS ASCIIZ * %MAX_PATH
  szDeviceType AS ASCIIZ * %RAS_MAXDEVICETYPE + 1
  szDeviceName AS ASCIIZ * %RAS_MAXDEVICENAME + 1
  szX25PadType AS ASCIIZ * %RAS_MAXPADTYPE + 1
  szX25Address AS ASCIIZ * %RAS_MAXX25ADDRESS + 1
  szX25Facilities AS ASCIIZ * %RAS_MAXFACILITIES + 1
  szX25UserData AS ASCIIZ * %RAS_MAXUSERDATA + 1
  dwChannels AS DWORD
  dwReserved1 AS DWORD
  dwReserved2 AS DWORD
END TYPE

TYPE RASDIALPARAMS
  dwSize AS DWORD                                             '4
  szEntryName AS ASCIIZ * %RAS_MAXENTRYNAME + 1               '257
  szPhoneNumber AS ASCIIZ * %RAS_MAXPHONENUMBER + 1           '129
  szCallBackNumber AS ASCIIZ * %RAS_MAXCALLBACKNUMBER + 1     '129
  szUserName AS ASCIIZ * %ULEN + 1                            '257
  szPassword AS ASCIIZ * %PWLEN + 1                           '257
  szDomain AS ASCIIZ * %DNLEN + 1                             '16
  buffer AS STRING * 3                                        '3
END TYPE

TYPE RASDIALEXTENSIONS
  dwSize AS DWORD
  dwfOptions AS DWORD
  hwndParent AS LONG
  reserved AS LONG
END TYPE

TYPE RASCONN
  dwSize AS DWORD                                       '4
  hRasConn AS LONG                                      '4          8
  szEntryName AS ASCIIZ * %RAS_MAXENTRYNAME + 1         '257        265
  szDeviceTYPE AS ASCIIZ * %RAS_MAXDEVICETYPE + 1       '17         282
  szDeviceName AS ASCIIZ * %RAS_MAXDEVICENAME + 1       '129        411
  buffer AS STRING * 1                                  '1          412
END TYPE

TYPE RASCONNSTATUS
  dwSize AS DWORD                                      '4
  rasconnstate AS LONG                                 '4    8
  dwError AS DWORD                                     '4    12
  szDeviceTYPE AS ASCIIZ * %RAS_MAXDEVICETYPE + 1      '17   29
  szDeviceName AS ASCIIZ * %RAS_MAXDEVICENAME + 1      '129  158
  buffer AS STRING * 2                                 '1    160
END TYPE

DECLARE FUNCTION RasGetConnectStatus LIB "rasapi32.dll" ALIAS "RasGetConnectStatusA" _
      ( BYVAL hRasConn AS LONG, lpRasConnStatus AS RASCONNSTATUS ) AS LONG

DECLARE FUNCTION RasEnumEntries LIB "rasapi32.dll" ALIAS "RasEnumEntriesA" _
      ( zReserved AS ASCIIZ, zPhoneBook AS ASCIIZ, lpRasEntry AS RASENTRYNAME, _
        lpCb AS LONG, lpcEntries AS LONG ) AS LONG

DECLARE FUNCTION RasGetEntryDialParams LIB "rasapi32.dll" ALIAS "RasGetEntryDialParamsA" _
      ( zPhoneBook AS ASCIIZ, rDialParams AS RASDIALPARAMS, iPassword AS LONG ) AS LONG

DECLARE FUNCTION RasDial LIB "rasapi32.dll" ALIAS "RasDialA" _
      ( lpRasDialExtensions AS RASDIALEXTENSIONS, lpszPhoneBook AS ASCIIZ, _
        lpRasDialParams AS RASDIALPARAMS, BYVAL dwNotiferTYPE AS DWORD, _
        BYVAL lpvNotifier AS LONG, lphRasConn AS LONG ) AS DWORD

DECLARE FUNCTION RasHangUp LIB "rasapi32.dll" ALIAS "RasHangUpA" _
      ( BYVAL hRasConn AS LONG ) AS LONG

DECLARE FUNCTION RasEnumConnections LIB "rasapi32.dll" ALIAS "RasEnumConnectionsA" _
      ( lpRasConn AS RASCONN, lpcb AS LONG, lpcConnections AS LONG ) AS DWORD

DECLARE FUNCTION RasValidateEntryName LIB "rasapi32.dll" ALIAS "RasValidateEntryNameA" _
      ( lpszPhoneBook AS ASCIIZ, lpszName AS ASCIIZ ) AS LONG

DECLARE FUNCTION RasGetEntryProperties LIB "rasapi32.dll" ALIAS "RasGetEntryPropertiesA" _
      ( lpszPhoneBook AS ASCIIZ, szEntry AS ASCIIZ, lpbEntry AS RASENTRY, lpdwEntrySize AS LONG, _
        lpBuffer AS ANY, lpdwSize AS LONG) AS LONG

DECLARE FUNCTION RasSetEntryProperties LIB "rasapi32.dll" ALIAS "RasSetEntryPropertiesA" _
      ( lpszPhoneBook AS ASCIIZ, szEntry AS ASCIIZ, lpbEntry AS RASENTRY, dwEntrySize AS LONG, _
        lpBuffer AS ANY, dwSize AS LONG) AS LONG
