'------------------------------------------------------------------------------
'
'  IPHLPAPI.INC -- "Internet Protocol Helper" Win32 SDK header for PowerBASIC
'  Copyright (c) 2001 PowerBASIC, Inc.
'  Some portions copyright (c) 1990-1999 Microsoft Corporation
'
'  Last Update: July 11, 2001
'
'  You have a royalty-free right to use, modify, reproduce and distribute
'  this file (and/or any modified version) in any way you find useful,
'  provided that you agree that both PowerBASIC and Microsoft have no
'  warranty, obligation or liability for its contents.  Refer to the
'  PowerBASIC Compiler Reference Guide for further information.
'
'  NOTE: Some of the SDK files this is based on appear to have been only partly
'  completed by Microsoft, casting some doubt on the status of these routines.
'
'------------------------------------------------------------------------------



#IF NOT %DEF(%IPHLPAPI_INC)

%IPHLPAPI_INC = 1


#IF NOT %DEF(%WINAPI)
#INCLUDE "win32api.inc"
#ENDIF


#IF NOT %DEF(%MAX_INTERFACE_NAME_LEN)
%MAX_INTERFACE_NAME_LEN = 256
#ENDIF



'''''''''''''''''''''''''''''''''''''''
'
' Media types
'
'''''''''''''''''''''''''''''''''''''''

%MIN_IF_TYPE                     = 1

%IF_TYPE_OTHER                   = 1   ' None of the below
%IF_TYPE_REGULAR_1822            = 2
%IF_TYPE_HDH_1822                = 3
%IF_TYPE_DDN_X25                 = 4
%IF_TYPE_RFC877_X25              = 5
%IF_TYPE_ETHERNET_CSMACD         = 6
%IF_TYPE_IS088023_CSMACD         = 7
%IF_TYPE_ISO88024_TOKENBUS       = 8
%IF_TYPE_ISO88025_TOKENRING      = 9
%IF_TYPE_ISO88026_MAN            = 10
%IF_TYPE_STARLAN                 = 11
%IF_TYPE_PROTEON_10MBIT          = 12
%IF_TYPE_PROTEON_80MBIT          = 13
%IF_TYPE_HYPERCHANNEL            = 14
%IF_TYPE_FDDI                    = 15
%IF_TYPE_LAP_B                   = 16
%IF_TYPE_SDLC                    = 17
%IF_TYPE_DS1                     = 18  ' DS1-MIB
%IF_TYPE_E1                      = 19  ' Obsolete; see DS1-MIB
%IF_TYPE_BASIC_ISDN              = 20
%IF_TYPE_PRIMARY_ISDN            = 21
%IF_TYPE_PROP_POINT2POINT_SERIAL = 22  ' proprietary serial
%IF_TYPE_PPP                     = 23
%IF_TYPE_SOFTWARE_LOOPBACK       = 24
%IF_TYPE_EON                     = 25  ' CLNP over IP
%IF_TYPE_ETHERNET_3MBIT          = 26
%IF_TYPE_NSIP                    = 27  ' XNS over IP
%IF_TYPE_SLIP                    = 28  ' Generic Slip
%IF_TYPE_ULTRA                   = 29  ' ULTRA Technologies
%IF_TYPE_DS3                     = 30  ' DS3-MIB
%IF_TYPE_SIP                     = 31  ' SMDS, coffee
%IF_TYPE_FRAMERELAY              = 32  ' DTE only
%IF_TYPE_RS232                   = 33
%IF_TYPE_PARA                    = 34  ' Parallel port
%IF_TYPE_ARCNET                  = 35
%IF_TYPE_ARCNET_PLUS             = 36
%IF_TYPE_ATM                     = 37  ' ATM cells
%IF_TYPE_MIO_X25                 = 38
%IF_TYPE_SONET                   = 39  ' SONET or SDH
%IF_TYPE_X25_PLE                 = 40
%IF_TYPE_ISO88022_LLC            = 41
%IF_TYPE_LOCALTALK               = 42
%IF_TYPE_SMDS_DXI                = 43
%IF_TYPE_FRAMERELAY_SERVICE      = 44  ' FRNETSERV-MIB
%IF_TYPE_V35                     = 45
%IF_TYPE_HSSI                    = 46
%IF_TYPE_HIPPI                   = 47
%IF_TYPE_MODEM                   = 48  ' Generic Modem
%IF_TYPE_AAL5                    = 49  ' AAL5 over ATM
%IF_TYPE_SONET_PATH              = 50
%IF_TYPE_SONET_VT                = 51
%IF_TYPE_SMDS_ICIP               = 52  ' SMDS InterCarrier Interface
%IF_TYPE_PROP_VIRTUAL            = 53  ' Proprietary virtual/internal
%IF_TYPE_PROP_MULTIPLEXOR        = 54  ' Proprietary multiplexing
%IF_TYPE_IEEE80212               = 55  ' 100BaseVG
%IF_TYPE_FIBRECHANNEL            = 56
%IF_TYPE_HIPPIINTERFACE          = 57
%IF_TYPE_FRAMERELAY_INTERCONNECT = 58  ' Obsolete, use 32 or 44
%IF_TYPE_AFLANE_8023             = 59  ' ATM Emulated LAN for 802.3
%IF_TYPE_AFLANE_8025             = 60  ' ATM Emulated LAN for 802.5
%IF_TYPE_CCTEMUL                 = 61  ' ATM Emulated circuit
%IF_TYPE_FASTETHER               = 62  ' Fast Ethernet (100BaseT)
%IF_TYPE_ISDN                    = 63  ' ISDN and X.25
%IF_TYPE_V11                     = 64  ' CCITT V.11/X.21
%IF_TYPE_V36                     = 65  ' CCITT V.36
%IF_TYPE_G703_64K                = 66  ' CCITT G703 at 64Kbps
%IF_TYPE_G703_2MB                = 67  ' Obsolete; see DS1-MIB
%IF_TYPE_QLLC                    = 68  ' SNA QLLC
%IF_TYPE_FASTETHER_FX            = 69  ' Fast Ethernet (100BaseFX)
%IF_TYPE_CHANNEL                 = 70
%IF_TYPE_IEEE80211               = 71  ' Radio spread spectrum
%IF_TYPE_IBM370PARCHAN           = 72  ' IBM System 360/370 OEMI Channel
%IF_TYPE_ESCON                   = 73  ' IBM Enterprise Systems Connection
%IF_TYPE_DLSW                    = 74  ' Data Link Switching
%IF_TYPE_ISDN_S                  = 75  ' ISDN S/T interface
%IF_TYPE_ISDN_U                  = 76  ' ISDN U interface
%IF_TYPE_LAP_D                   = 77  ' Link Access Protocol D
%IF_TYPE_IPSWITCH                = 78  ' IP Switching Objects
%IF_TYPE_RSRB                    = 79  ' Remote Source Route Bridging
%IF_TYPE_ATM_LOGICAL             = 80  ' ATM Logical Port
%IF_TYPE_DS0                     = 81  ' Digital Signal Level 0
%IF_TYPE_DS0_BUNDLE              = 82  ' Group of ds0s on the same ds1
%IF_TYPE_BSC                     = 83  ' Bisynchronous Protocol
%IF_TYPE_ASYNC                   = 84  ' Asynchronous Protocol
%IF_TYPE_CNR                     = 85  ' Combat Net Radio
%IF_TYPE_ISO88025R_DTR           = 86  ' ISO 802.5r DTR
%IF_TYPE_EPLRS                   = 87  ' Ext Pos Loc Report Sys
%IF_TYPE_ARAP                    = 88  ' Appletalk Remote Access Protocol
%IF_TYPE_PROP_CNLS               = 89  ' Proprietary Connectionless Proto
%IF_TYPE_HOSTPAD                 = 90  ' CCITT-ITU X.29 PAD Protocol
%IF_TYPE_TERMPAD                 = 91  ' CCITT-ITU X.3 PAD Facility
%IF_TYPE_FRAMERELAY_MPI          = 92  ' Multiproto Interconnect over FR
%IF_TYPE_X213                    = 93  ' CCITT-ITU X213
%IF_TYPE_ADSL                    = 94  ' Asymmetric Digital Subscrbr Loop
%IF_TYPE_RADSL                   = 95  ' Rate-Adapt Digital Subscrbr Loop
%IF_TYPE_SDSL                    = 96  ' Symmetric Digital Subscriber Loop
%IF_TYPE_VDSL                    = 97  ' Very H-Speed Digital Subscrb Loop
%IF_TYPE_ISO88025_CRFPRINT       = 98  ' ISO 802.5 CRFP
%IF_TYPE_MYRINET                 = 99  ' Myricom Myrinet
%IF_TYPE_VOICE_EM                = 100 ' Voice recEive and transMit
%IF_TYPE_VOICE_FXO               = 101 ' Voice Foreign Exchange Office
%IF_TYPE_VOICE_FXS               = 102 ' Voice Foreign Exchange Station
%IF_TYPE_VOICE_ENCAP             = 103 ' Voice encapsulation
%IF_TYPE_VOICE_OVERIP            = 104 ' Voice over IP encapsulation
%IF_TYPE_ATM_DXI                 = 105 ' ATM DXI
%IF_TYPE_ATM_FUNI                = 106 ' ATM FUNI
%IF_TYPE_ATM_IMA                 = 107 ' ATM IMA
%IF_TYPE_PPPMULTILINKBUNDLE      = 108 ' PPP Multilink Bundle
%IF_TYPE_IPOVER_CDLC             = 109 ' IBM ipOverCdlc
%IF_TYPE_IPOVER_CLAW             = 110 ' IBM Common Link Access to Workstn
%IF_TYPE_STACKTOSTACK            = 111 ' IBM stackToStack
%IF_TYPE_VIRTUALIPADDRESS        = 112 ' IBM VIPA
%IF_TYPE_MPC                     = 113 ' IBM multi-proto channel support
%IF_TYPE_IPOVER_ATM              = 114 ' IBM ipOverAtm
%IF_TYPE_ISO88025_FIBER          = 115 ' ISO 802.5j Fiber Token Ring
%IF_TYPE_TDLC                    = 116 ' IBM twinaxial data link control
%IF_TYPE_GIGABITETHERNET         = 117
%IF_TYPE_HDLC                    = 118
%IF_TYPE_LAP_F                   = 119
%IF_TYPE_V37                     = 120
%IF_TYPE_X25_MLP                 = 121 ' Multi-Link Protocol
%IF_TYPE_X25_HUNTGROUP           = 122 ' X.25 Hunt Group
%IF_TYPE_TRANSPHDLC              = 123
%IF_TYPE_INTERLEAVE              = 124 ' Interleave channel
%IF_TYPE_FAST                    = 125 ' Fast channel
%IF_TYPE_IP                      = 126 ' IP (for APPN HPR in IP networks)
%IF_TYPE_DOCSCABLE_MACLAYER      = 127 ' CATV Mac Layer
%IF_TYPE_DOCSCABLE_DOWNSTREAM    = 128 ' CATV Downstream interface
%IF_TYPE_DOCSCABLE_UPSTREAM      = 129 ' CATV Upstream interface
%IF_TYPE_A12MPPSWITCH            = 130 ' Avalon Parallel Processor
%IF_TYPE_TUNNEL                  = 131 ' Encapsulation interface
%IF_TYPE_COFFEE                  = 132 ' Coffee pot
%IF_TYPE_CES                     = 133 ' Circuit Emulation Service
%IF_TYPE_ATM_SUBINTERFACE        = 134 ' ATM Sub Interface
%IF_TYPE_L2_VLAN                 = 135 ' Layer 2 Virtual LAN using 802.1Q
%IF_TYPE_L3_IPVLAN               = 136 ' Layer 3 Virtual LAN using IP
%IF_TYPE_L3_IPXVLAN              = 137 ' Layer 3 Virtual LAN using IPX
%IF_TYPE_DIGITALPOWERLINE        = 138 ' IP over Power Lines
%IF_TYPE_MEDIAMAILOVERIP         = 139 ' Multimedia Mail over IP
%IF_TYPE_DTM                     = 140 ' Dynamic syncronous Transfer Mode
%IF_TYPE_DCN                     = 141 ' Data Communications Network
%IF_TYPE_IPFORWARD               = 142 ' IP Forwarding Interface
%IF_TYPE_MSDSL                   = 143 ' Multi-rate Symmetric DSL
%IF_TYPE_IEEE1394                = 144 ' IEEE1394 High Perf Serial Bus

%MAX_IF_TYPE                     = 144

'''''''''''''''''''''''''''''''''''''''
'
' Access types
'
'''''''''''''''''''''''''''''''''''''''

%IF_ACCESS_LOOPBACK          = 1
%IF_ACCESS_BROADCAST         = 2
%IF_ACCESS_POINTTOPOINT      = 3
%IF_ACCESS_POINTTOMULTIPOINT = 4

'''''''''''''''''''''''''''''''''''''''
'
' Connection Types
'
'''''''''''''''''''''''''''''''''''''''

%IF_CONNECTION_DEDICATED     = 1
%IF_CONNECTION_PASSIVE       = 2
%IF_CONNECTION_DEMAND        = 3


%IF_ADMIN_STATUS_UP          = 1
%IF_ADMIN_STATUS_DOWN        = 2
%IF_ADMIN_STATUS_TESTING     = 3

'''''''''''''''''''''''''''''''''''''''
'
' The following are the the operational states for WAN and LAN interfaces.
' The order of the states seems weird, but is done for a purpose. All
' states >= CONNECTED can transmit data right away. States >= DISCONNECTED
' can tx data but some set up might be needed. States < DISCONNECTED can
' not transmit data.
' A card is marked UNREACHABLE if DIM calls InterfaceUnreachable for
' reasons other than failure to connect.
'
' NON_OPERATIONAL -- Valid for LAN Interfaces. Means the card is not
'                      working or not plugged in or has no address.
' UNREACHABLE     -- Valid for WAN Interfaces. Means the remote site is
'                      not reachable at this time.
' DISCONNECTED    -- Valid for WAN Interfaces. Means the remote site is
'                      not connected at this time.
' CONNECTING      -- Valid for WAN Interfaces. Means a connection attempt
'                      has been initiated to the remote site.
' CONNECTED       -- Valid for WAN Interfaces. Means the remote site is
'                      connected.
' OPERATIONAL     -- Valid for LAN Interfaces. Means the card is plugged
'                      in and working.
'
' It is the users duty to convert these values to MIB-II values if they
' are to be used by a subagent
'
'''''''''''''''''''''''''''''''''''''''

%IF_OPER_STATUS_NON_OPERATIONAL = 0
%IF_OPER_STATUS_UNREACHABLE     = 1
%IF_OPER_STATUS_DISCONNECTED    = 2
%IF_OPER_STATUS_CONNECTING      = 3
%IF_OPER_STATUS_CONNECTED       = 4
%IF_OPER_STATUS_OPERATIONAL     = 5

%MIB_IF_TYPE_OTHER              = 1
%MIB_IF_TYPE_ETHERNET           = 6
%MIB_IF_TYPE_TOKENRING          = 9
%MIB_IF_TYPE_FDDI               = 15
%MIB_IF_TYPE_PPP                = 23
%MIB_IF_TYPE_LOOPBACK           = 24
%MIB_IF_TYPE_SLIP               = 28

%MIB_IF_ADMIN_STATUS_UP         = 1
%MIB_IF_ADMIN_STATUS_DOWN       = 2
%MIB_IF_ADMIN_STATUS_TESTING    = 3

%MIB_IF_OPER_STATUS_NON_OPERATIONAL = 0
%MIB_IF_OPER_STATUS_UNREACHABLE     = 1
%MIB_IF_OPER_STATUS_DISCONNECTED    = 2
%MIB_IF_OPER_STATUS_CONNECTING      = 3
%MIB_IF_OPER_STATUS_CONNECTED       = 4
%MIB_IF_OPER_STATUS_OPERATIONAL     = 5




'''''''''''''''''''''''''''''''''''''''
'
' This is the Id for IP Router Manager.  The Router Manager handles
' MIB-II, Forwarding MIB and some enterprise specific information.
' Calls made with any other ID are passed on to the corresponding protocol
' For example, an MprAdminMIBXXX call with a protocol ID of PID_IP and
' a routing Id of 0xD will be sent to the IP Router Manager and then
' forwarded to OSPF
' This lives in the same number space as the protocol Ids of RIP, OSPF
' etc, so any change made to it should be done keeping this in mind
'
'''''''''''''''''''''''''''''''''''''''


%IPRTRMGR_PID = 10000

#IF NOT %DEF(%ANY_SIZE)

%ANY_SIZE = 1

#ENDIF

'''''''''''''''''''''''''''''''''''''''
'
' The following equates are the Ids of the MIB variables made accessible
' to the user via MprAdminMIBXXX Apis.  It will be noticed that these are
' not the same as RFC 1213, since the MprAdminMIBXXX APIs work on rows and
' groups instead of scalar variables
'
'''''''''''''''''''''''''''''''''''''''


%IF_NUMBER        = 0
%IF_TABLE         = %IF_NUMBER          + 1
%IF_ROW           = %IF_TABLE           + 1
%IP_STATS         = %IF_ROW             + 1
%IP_ADDRTABLE     = %IP_STATS           + 1
%IP_ADDRROW       = %IP_ADDRTABLE       + 1
%IP_FORWARDNUMBER = %IP_ADDRROW         + 1
%IP_FORWARDTABLE  = %IP_FORWARDNUMBER   + 1
%IP_FORWARDROW    = %IP_FORWARDTABLE    + 1
%IP_NETTABLE      = %IP_FORWARDROW      + 1
%IP_NETROW        = %IP_NETTABLE        + 1
%ICMP_STATS       = %IP_NETROW          + 1
%TCP_STATS        = %ICMP_STATS         + 1
%TCP_TABLE        = %TCP_STATS          + 1
%TCP_ROW          = %TCP_TABLE          + 1
%UDP_STATS        = %TCP_ROW            + 1
%UDP_TABLE        = %UDP_STATS          + 1
%UDP_ROW          = %UDP_TABLE          + 1
%MCAST_MFE        = %UDP_ROW            + 1
%MCAST_MFE_STATS  = %MCAST_MFE          + 1
%BEST_IF          = %MCAST_MFE_STATS    + 1
%BEST_ROUTE       = %BEST_IF            + 1
%PROXY_ARP        = %BEST_ROUTE         + 1
%MCAST_IF_ENTRY   = %PROXY_ARP          + 1
%MCAST_GLOBAL     = %MCAST_IF_ENTRY     + 1
%IF_STATUS        = %MCAST_GLOBAL       + 1
%MCAST_BOUNDARY   = %IF_STATUS          + 1
%MCAST_SCOPE      = %MCAST_BOUNDARY     + 1
%DEST_MATCHING    = %MCAST_SCOPE        + 1
%DEST_LONGER      = %DEST_MATCHING      + 1
%DEST_SHORTER     = %DEST_LONGER        + 1
%ROUTE_MATCHING   = %DEST_SHORTER       + 1
%ROUTE_LONGER     = %ROUTE_MATCHING     + 1
%ROUTE_SHORTER    = %ROUTE_LONGER       + 1
%ROUTE_STATE      = %ROUTE_SHORTER      + 1

%NUMBER_OF_EXPORTED_VARIABLES = %ROUTE_STATE + 1


'''''''''''''''''''''''''''''''''''''''
'
' MIB_OPAQUE_QUERY is the structure filled in by the user to identify a
' MIB variable
'
'  dwVarId     ID of MIB Variable (One of the Ids #defined above)
'  dwVarIndex  Variable sized array containing the indices needed to
'              identify a variable. NOTE: Unlike SNMP we don't require that
'              a scalar variable be indexed by 0
'
'''''''''''''''''''''''''''''''''''''''

TYPE MIB_OPAQUE_QUERY
    dwVarId AS DWORD
    rgdwVarIndex(0 TO 0) AS DWORD    ' ANY_SIZE ... another Microsoft fake type
END TYPE

'''''''''''''''''''''''''''''''''''''''
'
' The following are the structures which are filled in and returned to the
' user when a query is made, OR  are filled in BY THE USER when a set is
' done
'
'''''''''''''''''''''''''''''''''''''''

TYPE MIB_IFNUMBER
    dwValue AS DWORD
END TYPE


%MAXLEN_IFDESCR  = 256
%MAXLEN_PHYSADDR = 8

TYPE MIB_IFROW
    wszName AS STRING * (%MAX_INTERFACE_NAME_LEN * 2)   ' UNICODE string
    dwIndex           AS DWORD
    dwType            AS DWORD
    dwMtu             AS DWORD
    dwSpeed           AS DWORD
    dwPhysAddrLen     AS DWORD
    bPhysAddr(0 TO %MAXLEN_PHYSADDR - 1) AS BYTE
    dwAdminStatus     AS DWORD
    dwOperStatus      AS DWORD
    dwLastChange      AS DWORD
    dwInOctets        AS DWORD
    dwInUcastPkts     AS DWORD
    dwInNUcastPkts    AS DWORD
    dwInDiscards      AS DWORD
    dwInErrors        AS DWORD
    dwInUnknownProtos AS DWORD
    dwOutOctets       AS DWORD
    dwOutUcastPkts    AS DWORD
    dwOutNUcastPkts   AS DWORD
    dwOutDiscards     AS DWORD
    dwOutErrors       AS DWORD
    dwOutQLen         AS DWORD
    dwDescrLen        AS DWORD
    bDescr(0 TO %MAXLEN_IFDESCR - 1) AS BYTE
END TYPE

TYPE MIB_IFTABLE
    dwNumEntries  AS DWORD
    table(0 TO 0) AS MIB_IFROW    ' ANY_SIZE : fake type
END TYPE


TYPE MIBICMPSTATS
    dwMsgs          AS DWORD
    dwErrors        AS DWORD
    dwDestUnreachs  AS DWORD
    dwTimeExcds     AS DWORD
    dwParmProbs     AS DWORD
    dwSrcQuenchs    AS DWORD
    dwRedirects     AS DWORD
    dwEchos         AS DWORD
    dwEchoReps      AS DWORD
    dwTimestamps    AS DWORD
    dwTimestampReps AS DWORD
    dwAddrMasks     AS DWORD
    dwAddrMaskReps  AS DWORD
END TYPE

TYPE MIBICMPINFO
    icmpInStats  AS MIBICMPSTATS
    icmpOutStats AS MIBICMPSTATS
END TYPE

TYPE MIB_ICMP
    stats AS MIBICMPINFO
END TYPE

TYPE MIB_UDPSTATS
    dwInDatagrams  AS DWORD
    dwNoPorts      AS DWORD
    dwInErrors     AS DWORD
    dwOutDatagrams AS DWORD
    dwNumAddrs     AS DWORD
END TYPE

TYPE MIB_UDPROW
    dwLocalAddr AS DWORD
    dwLocalPort AS DWORD
END TYPE

TYPE MIB_UDPTABLE
    dwNumEntries  AS DWORD
    table(0 TO 0) AS MIB_UDPROW   ' ANY_SIZE : fake type
END TYPE


TYPE MIB_TCPSTATS
    dwRtoAlgorithm AS DWORD
    dwRtoMin       AS DWORD
    dwRtoMax       AS DWORD
    dwMaxConn      AS DWORD
    dwActiveOpens  AS DWORD
    dwPassiveOpens AS DWORD
    dwAttemptFails AS DWORD
    dwEstabResets  AS DWORD
    dwCurrEstab    AS DWORD
    dwInSegs       AS DWORD
    dwOutSegs      AS DWORD
    dwRetransSegs  AS DWORD
    dwInErrs       AS DWORD
    dwOutRsts      AS DWORD
    dwNumConns     AS DWORD
END TYPE

%MIB_TCP_RTO_OTHER    = 1
%MIB_TCP_RTO_CONSTANT = 2
%MIB_TCP_RTO_RSRE     = 3
%MIB_TCP_RTO_VANJ     = 4

%MIB_TCP_MAXCONN_DYNAMIC = &HFFFFFFFF???

TYPE MIB_TCPROW
    dwState      AS DWORD
    dwLocalAddr  AS DWORD
    dwLocalPort  AS DWORD
    dwRemoteAddr AS DWORD
    dwRemotePort AS DWORD
END TYPE

%MIB_TCP_STATE_CLOSED     =  1
%MIB_TCP_STATE_LISTEN     =  2
%MIB_TCP_STATE_SYN_SENT   =  3
%MIB_TCP_STATE_SYN_RCVD   =  4
%MIB_TCP_STATE_ESTAB      =  5
%MIB_TCP_STATE_FIN_WAIT1  =  6
%MIB_TCP_STATE_FIN_WAIT2  =  7
%MIB_TCP_STATE_CLOSE_WAIT =  8
%MIB_TCP_STATE_CLOSING    =  9
%MIB_TCP_STATE_LAST_ACK   = 10
%MIB_TCP_STATE_TIME_WAIT  = 11
%MIB_TCP_STATE_DELETE_TCB = 12

TYPE MIB_TCPTABLE
    dwNumEntries  AS DWORD
    table(0 TO 0) AS MIB_TCPROW   ' ANY_SIZE : fake type
END TYPE


%MIB_USE_CURRENT_TTL        = &HFFFFFFFF???
%MIB_USE_CURRENT_FORWARDING = &HFFFFFFFF???

TYPE MIB_IPSTATS
    dwForwarding      AS DWORD
    dwDefaultTTL      AS DWORD
    dwInReceives      AS DWORD
    dwInHdrErrors     AS DWORD
    dwInAddrErrors    AS DWORD
    dwForwDatagrams   AS DWORD
    dwInUnknownProtos AS DWORD
    dwInDiscards      AS DWORD
    dwInDelivers      AS DWORD
    dwOutRequests     AS DWORD
    dwRoutingDiscards AS DWORD
    dwOutDiscards     AS DWORD
    dwOutNoRoutes     AS DWORD
    dwReasmTimeout    AS DWORD
    dwReasmReqds      AS DWORD
    dwReasmOks        AS DWORD
    dwReasmFails      AS DWORD
    dwFragOks         AS DWORD
    dwFragFails       AS DWORD
    dwFragCreates     AS DWORD
    dwNumIf           AS DWORD
    dwNumAddr         AS DWORD
    dwNumRoutes       AS DWORD
END TYPE

%MIB_IP_FORWARDING     = 1
%MIB_IP_NOT_FORWARDING = 2


TYPE MIB_IPADDRROW
    dwAddr      AS DWORD
    dwIndex     AS DWORD
    dwMask      AS DWORD
    dwBCastAddr AS DWORD
    dwReasmSize AS DWORD
    unused1     AS WORD
    unused2     AS WORD
END TYPE

TYPE MIB_IPADDRTABLE
    dwNumEntries  AS DWORD
    table(0 TO 0) AS MIB_IPADDRROW   ' ANY_SIZE : fake type
END TYPE


TYPE MIB_IPFORWARDNUMBER
    dwValue AS DWORD
END TYPE

TYPE MIB_IPFORWARDROW
    dwForwardDest      AS DWORD
    dwForwardMask      AS DWORD
    dwForwardPolicy    AS DWORD
    dwForwardNextHop   AS DWORD
    dwForwardIfIndex   AS DWORD
    dwForwardType      AS DWORD
    dwForwardProto     AS DWORD
    dwForwardAge       AS DWORD
    dwForwardNextHopAS AS DWORD
    dwForwardMetric1   AS DWORD
    dwForwardMetric2   AS DWORD
    dwForwardMetric3   AS DWORD
    dwForwardMetric4   AS DWORD
    dwForwardMetric5   AS DWORD
END TYPE

%MIB_IPROUTE_TYPE_OTHER    = 1
%MIB_IPROUTE_TYPE_INVALID  = 2
%MIB_IPROUTE_TYPE_DIRECT   = 3
%MIB_IPROUTE_TYPE_INDIRECT = 4

%MIB_IPROUTE_METRIC_UNUSED = &HFFFFFFFF???

%MIB_IPPROTO_OTHER             = 1
%MIB_IPPROTO_LOCAL             = 2
%MIB_IPPROTO_NETMGMT           = 3
%MIB_IPPROTO_ICMP              = 4
%MIB_IPPROTO_EGP               = 5
%MIB_IPPROTO_GGP               = 6
%MIB_IPPROTO_HELLO             = 7
%MIB_IPPROTO_RIP               = 8
%MIB_IPPROTO_IS_IS             = 9
%MIB_IPPROTO_ES_IS             = 10
%MIB_IPPROTO_CISCO             = 11
%MIB_IPPROTO_BBN               = 12
%MIB_IPPROTO_OSPF              = 13
%MIB_IPPROTO_BGP               = 14

%MIB_IPPROTO_NT_AUTOSTATIC     = 10002
%MIB_IPPROTO_NT_STATIC         = 10006
%MIB_IPPROTO_NT_STATIC_NON_DOD = 10007

TYPE MIB_IPFORWARDTABLE
    dwNumEntries  AS DWORD
    table(0 TO 0) AS MIB_IPFORWARDROW   ' ANY_SIZE : fake type
END TYPE


TYPE MIB_IPNETROW
    dwIndex       AS DWORD
    dwPhysAddrLen AS DWORD
    bPhysAddr(0 TO %MAXLEN_PHYSADDR - 1) AS BYTE
    dwAddr        AS DWORD
    dwType        AS DWORD
END TYPE

%MIB_IPNET_TYPE_OTHER   = 1
%MIB_IPNET_TYPE_INVALID = 2
%MIB_IPNET_TYPE_DYNAMIC = 3
%MIB_IPNET_TYPE_STATIC  = 4

TYPE MIB_IPNETTABLE
    dwNumEntries   AS DWORD
    table(0 TO 0)  AS MIB_IPNETROW   ' ANY_SIZE : fake type
END TYPE


TYPE MIB_IPMCAST_OIF
    dwOutIfIndex  AS DWORD
    dwNextHopAddr AS DWORD
    pvReserved    AS BYTE PTR
    dwReserved    AS DWORD
END TYPE

TYPE MIB_IPMCAST_MFE
    dwGroup         AS DWORD
    dwSource        AS DWORD
    dwSrcMask       AS DWORD
    dwUpStrmNgbr    AS DWORD
    dwInIfIndex     AS DWORD
    dwInIfProtocol  AS DWORD
    dwRouteProtocol AS DWORD
    dwRouteNetwork  AS DWORD
    dwRouteMask     AS DWORD
    ulUpTime        AS DWORD
    ulExpiryTime    AS DWORD
    ulTimeOut       AS DWORD
    ulNumOutIf      AS DWORD
    fFlags          AS DWORD
    dwReserved      AS DWORD
    rgmioOutInfo(0 TO 0) AS MIB_IPMCAST_OIF  ' ANY_SIZE : fake type
END TYPE

TYPE MIB_MFE_TABLE
    dwNumEntries  AS DWORD
    table(0 TO 0) AS MIB_IPMCAST_MFE  ' ANY_SIZE : fake type
END TYPE


TYPE MIB_IPMCAST_OIF_STATS
    dwOutIfIndex  AS DWORD
    dwNextHopAddr AS DWORD
    pvDialContext AS BYTE PTR
    ulTtlTooLow   AS DWORD
    ulFragNeeded  AS DWORD
    ulOutPackets  AS DWORD
    ulOutDiscards AS DWORD
END TYPE

TYPE MIB_IPMCAST_MFE_STATS
    dwGroup           AS DWORD
    dwSource          AS DWORD
    dwSrcMask         AS DWORD
    dwUpStrmNgbr      AS DWORD
    dwInIfIndex       AS DWORD
    dwInIfProtocol    AS DWORD
    dwRouteProtocol   AS DWORD
    dwRouteNetwork    AS DWORD
    dwRouteMask       AS DWORD
    ulUpTime          AS DWORD
    ulExpiryTime      AS DWORD
    ulNumOutIf        AS DWORD
    ulInPkts          AS DWORD
    ulInOctets        AS DWORD
    ulPktsDifferentIf AS DWORD
    ulQueueOverflow   AS DWORD
    rgmiosOutStats(0 TO 0) AS MIB_IPMCAST_OIF_STATS  ' ANY_SIZE : fake type
END TYPE

TYPE MIB_MFE_STATS_TABLE
    dwNumEntries  AS DWORD
    table(0 TO 0) AS MIB_IPMCAST_MFE_STATS  ' ANY_SIZE : fake type
END TYPE

TYPE MIB_IPMCAST_GLOBAL
    dwEnable AS DWORD
END TYPE

TYPE MIB_IPMCAST_IF_ENTRY
    dwIfIndex        AS DWORD
    dwTtl            AS DWORD
    dwProtocol       AS DWORD
    dwRateLimit      AS DWORD
    ulInMcastOctets  AS DWORD
    ulOutMcastOctets AS DWORD
END TYPE

TYPE MIB_IPMCAST_IF_TABLE
    dwNumEntries  AS DWORD
    table(0 TO 0) AS MIB_IPMCAST_IF_ENTRY  ' ANY_SIZE : fake type
END TYPE

TYPE MIB_IPMCAST_BOUNDARY
    dwIfIndex      AS DWORD
    dwGroupAddress AS DWORD
    dwGroupMask    AS DWORD
    dwStatus       AS DWORD
END TYPE

TYPE MIB_IPMCAST_BOUNDARY_TABLE
    dwNumEntries  AS DWORD
    table(0 TO 0) AS MIB_IPMCAST_BOUNDARY  ' ANY_SIZE : fake type
END TYPE


TYPE MIB_BOUNDARYROW
    dwGroupAddress AS DWORD
    dwGroupMask    AS DWORD
END TYPE

' Structure matching what goes in the registry in a block of type
' IP_MCAST_LIMIT_INFO.  This contains the fields of
' MIB_IPMCAST_IF_ENTRY which are configurable.

TYPE MIB_MCAST_LIMIT_ROW
    dwTtl       AS DWORD
    dwRateLimit AS DWORD
END TYPE

%MAX_SCOPE_NAME_LEN = 255

'
' Scope names are unicode.  SNMP and MZAP use UTF-8 encoding.
'

%SN_UNICODE = 1


TYPE MIB_IPMCAST_SCOPE
    dwGroupAddress AS DWORD
    dwGroupMask    AS DWORD
    snNameBuffer   AS STRING * ((%MAX_SCOPE_NAME_LEN + 1) * 2)   ' Unicode
    dwStatus       AS DWORD
END TYPE

TYPE MIB_IPDESTROW
    ForwardRow          AS MIB_IPFORWARDROW
    dwForwardPreference AS DWORD
    dwForwardViewSet    AS DWORD
END TYPE

TYPE MIB_IPDESTTABLE
    dwNumEntries  AS DWORD
    table(0 TO 0) AS MIB_IPDESTROW  ' ANY_SIZE : fake type
END TYPE

TYPE MIB_BEST_IF
    dwDestAddr AS DWORD
    dwIfIndex  AS DWORD
END TYPE

TYPE MIB_PROXYARP
    dwAddress AS DWORD
    dwMask    AS DWORD
    dwIfIndex AS DWORD
END TYPE

TYPE MIB_IFSTATUS
    dwIfIndex           AS DWORD
    dwAdminStatus       AS DWORD
    dwOperationalStatus AS DWORD
    bMHbeatActive       AS LONG
    bMHbeatAlive        AS LONG
END TYPE

TYPE MIB_ROUTESTATE
    bRoutesSetToStack AS LONG
END TYPE

UNION MIB_OPAQUE_UNION
    ullAlign AS QUAD
    rgbyData(0 TO 0) AS BYTE
END UNION

TYPE MIB_OPAQUE_INFO
    dwId AS DWORD
    mou  AS MIB_OPAQUE_UNION
END TYPE

%MAX_MIB_OFFSET = 8


' The ip_option_information structure describes the options to be
' included in the header of an IP packet. The TTL, TOS, and Flags
' values are carried in specific fields in the header. The OptionsData
' bytes are carried in the options area following the standard IP header.
' With the exception of source route options, this data must be in the
' format to be transmitted on the wire as specified in RFC 791. A source
' route option should contain the full route - first hop thru final
' destination - in the route data. The first hop will be pulled out of the
' data and the option will be reformatted accordingly. Otherwise, the route
' option should be formatted as specified in RFC 791.
'
TYPE IP_OPTION_INFORMATION
    Ttl         AS BYTE      ' Time To Live
    Tos         AS BYTE      ' Type Of Service
    Flags       AS BYTE      ' IP header flags
    OptionsSize AS BYTE      ' Size in bytes of options data
    OptionsData AS BYTE PTR  ' Pointer to options data
END TYPE

'
' The icmp_echo_reply structure describes the data returned in response
' to an echo request.
'
TYPE ICMP_ECHO_REPLY
    Address           AS DWORD        ' Replying address
    STATUS            AS DWORD        ' Reply IP_STATUS
    RoundTripTime     AS DWORD        ' RTT in milliseconds
    DataSize          AS WORD         ' Reply data size in bytes
    Reserved          AS WORD         ' Reserved for system use
    pData             AS BYTE PTR     ' Pointer to the reply data
    Options AS IP_OPTION_INFORMATION  ' Reply options
END TYPE



TYPE ARP_SEND_REPLY
   DestAddress AS DWORD
   SrcAddress AS DWORD
END TYPE

TYPE TCP_RESERVE_PORT_RANGE
   UpperRange AS WORD
   LowerRange AS WORD
END TYPE

%MAX_ADAPTER_NAME = 128

TYPE IP_ADAPTER_INDEX_MAP
   Index AS DWORD
   wName AS STRING * (%MAX_ADAPTER_NAME * 2)    ' Unicode!
END TYPE

TYPE IP_INTERFACE_INFO
   NumAdapters AS LONG
   Adapter(0 TO 0) AS IP_ADAPTER_INDEX_MAP
END TYPE

TYPE IP_UNIDIRECTIONAL_ADAPTER_ADDRESS
   NumAdapters AS DWORD
   Address(0 TO 0) AS DWORD
END TYPE

TYPE IP_ADAPTER_ORDER_MAP
    NumAdapters AS DWORD
    AdapterOrder(0 TO 0) AS DWORD
END TYPE

'
' IP_STATUS codes returned from IP APIs
'

%IP_STATUS_BASE            = 11000

%IP_SUCCESS                = 0
%IP_BUF_TOO_SMALL          = %IP_STATUS_BASE + 1
%IP_DEST_NET_UNREACHABLE   = %IP_STATUS_BASE + 2
%IP_DEST_HOST_UNREACHABLE  = %IP_STATUS_BASE + 3
%IP_DEST_PROT_UNREACHABLE  = %IP_STATUS_BASE + 4
%IP_DEST_PORT_UNREACHABLE  = %IP_STATUS_BASE + 5
%IP_NO_RESOURCES           = %IP_STATUS_BASE + 6
%IP_BAD_OPTION             = %IP_STATUS_BASE + 7
%IP_HW_ERROR               = %IP_STATUS_BASE + 8
%IP_PACKET_TOO_BIG         = %IP_STATUS_BASE + 9
%IP_REQ_TIMED_OUT          = %IP_STATUS_BASE + 10
%IP_BAD_REQ                = %IP_STATUS_BASE + 11
%IP_BAD_ROUTE              = %IP_STATUS_BASE + 12
%IP_TTL_EXPIRED_TRANSIT    = %IP_STATUS_BASE + 13
%IP_TTL_EXPIRED_REASSEM    = %IP_STATUS_BASE + 14
%IP_PARAM_PROBLEM          = %IP_STATUS_BASE + 15
%IP_SOURCE_QUENCH          = %IP_STATUS_BASE + 16
%IP_OPTION_TOO_BIG         = %IP_STATUS_BASE + 17
%IP_BAD_DESTINATION        = %IP_STATUS_BASE + 18


'
' The next group are status codes passed up on status indications to
' transport layer protocols.
'
%IP_ADDR_DELETED             = %IP_STATUS_BASE + 19
%IP_SPEC_MTU_CHANGE          = %IP_STATUS_BASE + 20
%IP_MTU_CHANGE               = %IP_STATUS_BASE + 21
%IP_UNLOAD                   = %IP_STATUS_BASE + 22
%IP_ADDR_ADDED               = %IP_STATUS_BASE + 23
%IP_MEDIA_CONNECT            = %IP_STATUS_BASE + 24
%IP_MEDIA_DISCONNECT         = %IP_STATUS_BASE + 25
%IP_BIND_ADAPTER             = %IP_STATUS_BASE + 26
%IP_UNBIND_ADAPTER           = %IP_STATUS_BASE + 27
%IP_DEVICE_DOES_NOT_EXIST    = %IP_STATUS_BASE + 28
%IP_DUPLICATE_ADDRESS        = %IP_STATUS_BASE + 29
%IP_INTERFACE_METRIC_CHANGE  = %IP_STATUS_BASE + 30
%IP_RECONFIG_SECFLTR         = %IP_STATUS_BASE + 31
%IP_NEGOTIATING_IPSEC        = %IP_STATUS_BASE + 32
%IP_INTERFACE_WOL_CAPABILITY_CHANGE  = %IP_STATUS_BASE + 33
%IP_DUPLICATE_IPADD          = %IP_STATUS_BASE + 34

%IP_GENERAL_FAILURE          = %IP_STATUS_BASE + 50
%MAX_IP_STATUS               = %IP_GENERAL_FAILURE
%IP_PENDING                  = %IP_STATUS_BASE + 255


'
' Values used in the IP header Flags field.
'
%IP_FLAG_DF      = 2         ' Don't fragment this packet.

'
' Supported IP Option Types.
'
' These types define the options which may be used in the OptionsData field
' of the ip_option_information structure.  See RFC 791 for a complete
' description of each.
'
%IP_OPT_EOL          = 0     ' End of list option
%IP_OPT_NOP          = 1     ' No operation
%IP_OPT_SECURITY     = &H82  ' Security option
%IP_OPT_LSRR         = &H83  ' Loose source route
%IP_OPT_SSRR         = &H89  ' Strict source route
%IP_OPT_RR           = &H7   ' Record route
%IP_OPT_TS           = &H44  ' Timestamp
%IP_OPT_SID          = &H88  ' Stream ID (obsolete)
%IP_OPT_ROUTER_ALERT = &H94  ' Router Alert Option

%MAX_OPT_SIZE  = 40         ' Maximum length of IP options in bytes

#IF NOT %DEF(%IOCTL_IP_RTCHANGE_NOTIFY_REQUEST)

' Ioctls code exposed by Memphis tcpip stack.
' For NT these ioctls are define in ntddip.h  (private\inc)

%IOCTL_IP_RTCHANGE_NOTIFY_REQUEST        = 101
%IOCTL_IP_ADDCHANGE_NOTIFY_REQUEST       = 102
%IOCTL_ARP_SEND_REQUEST                  = 103
%IOCTL_IP_INTERFACE_INFO                 = 104
%IOCTL_IP_GET_BEST_INTERFACE             = 105
%IOCTL_IP_UNIDIRECTIONAL_ADAPTER_ADDRESS = 106

#ENDIF





' Definitions and structures used by getnetworkparams and getadaptersinfo apis

%MAX_ADAPTER_DESCRIPTION_LENGTH = 128 ' arb.
%MAX_ADAPTER_NAME_LENGTH        = 256 ' arb.
%MAX_ADAPTER_ADDRESS_LENGTH     = 8   ' arb.
%DEFAULT_MINIMUM_ENTITIES       = 32  ' arb.
%MAX_HOSTNAME_LEN               = 128 ' arb.
%MAX_DOMAIN_NAME_LEN            = 128 ' arb.
%MAX_SCOPE_ID_LEN               = 256 ' arb.

'
' types
'

' Node Type

%BROADCAST_NODETYPE    = 1
%PEER_TO_PEER_NODETYPE = 2
%MIXED_NODETYPE        = 4
%HYBRID_NODETYPE       = 8

' Adapter Type

%IF_OTHER_ADAPTERTYPE      = 0
%IF_ETHERNET_ADAPTERTYPE   = 1
%IF_TOKEN_RING_ADAPTERTYPE = 2
%IF_FDDI_ADAPTERTYPE       = 3
%IF_PPP_ADAPTERTYPE        = 4
%IF_LOOPBACK_ADAPTERTYPE   = 5
%IF_SLIP_ADAPTERTYPE       = 6

'
' IP_ADDRESS_STRING - store an IP address as a dotted decimal string
'

TYPE IP_ADDRESS_STRING
    sString AS STRING * 16
END TYPE

TYPE IP_MASK_STRING
    sString AS STRING * 16
END TYPE

'
' IP_ADDR_STRING - store an IP address with its corresponding subnet mask,
' both as dotted decimal strings
'

TYPE IP_ADDR_STRING
    pNext     AS IP_ADDR_STRING PTR
    IpAddress AS IP_ADDRESS_STRING
    IpMask    AS IP_MASK_STRING
    Context   AS DWORD
END TYPE

'
' ADAPTER_INFO - per-adapter information. All IP addresses are stored as
' strings
'

TYPE IP_ADAPTER_INFO
    pNext AS IP_ADAPTER_INFO PTR
    ComboIndex AS DWORD
    AdapterName AS STRING * (%MAX_ADAPTER_NAME_LENGTH + 4)
    Description AS STRING * (%MAX_ADAPTER_DESCRIPTION_LENGTH + 4)
    AddressLength AS DWORD
    Address(0 TO %MAX_ADAPTER_ADDRESS_LENGTH - 1) AS BYTE
    Index AS DWORD
    uType AS DWORD
    DhcpEnabled AS DWORD
    CurrentIpAddress AS IP_ADDR_STRING PTR
    IpAddressList AS IP_ADDR_STRING
    GatewayList AS IP_ADDR_STRING
    DhcpServer AS IP_ADDR_STRING
    HaveWins AS LONG
    PrimaryWinsServer AS IP_ADDR_STRING
    SecondaryWinsServer AS IP_ADDR_STRING
    LeaseObtained AS LONG
    LeaseExpires AS LONG
END TYPE

'
' IP_PER_ADAPTER_INFO - per-adapter IP information such as DNS server list.
'

TYPE IP_PER_ADAPTER_INFO
    AutoconfigEnabled AS DWORD
    AutoconfigActive AS DWORD
    CurrentDnsServer AS IP_ADDR_STRING PTR
    DnsServerList AS IP_ADDR_STRING
END TYPE

'
' FIXED_INFO - the set of IP-related information which does not depend on DHCP
'

TYPE FIXED_INFO
    HostName AS STRING * (%MAX_HOSTNAME_LEN + 4)
    DomainName AS STRING * (%MAX_DOMAIN_NAME_LEN + 4)
    CurrentDnsServer AS IP_ADDR_STRING PTR
    DnsServerList AS IP_ADDR_STRING
    NodeType AS DWORD
    ScopeId AS STRING * (%MAX_SCOPE_ID_LEN + 4)
    EnableRouting AS DWORD
    EnableProxy AS DWORD
    EnableDns AS DWORD
END TYPE



'''''''''''''''''''''''''''''''''''''''
'
' The GetXXXTable APIs take a buffer and a size of buffer.  If the buffer
' is not large enough, the APIs return %ERROR_INSUFFICIENT_BUFFER  and
' pdwSize is the required buffer size.
' The bOrder is a BOOLEAN, which if TRUE sorts the table according to
' MIB-II (RFC XXXX)
'
'''''''''''''''''''''''''''''''''''''''


'''''''''''''''''''''''''''''''''''''''
'
' Retrieves the number of interfaces in the system. These include LAN and
' WAN interfaces
'
'''''''''''''''''''''''''''''''''''''''

DECLARE FUNCTION GetNumberOfInterfaces LIB "iphlpapi.dll" _
        ALIAS "GetNumberOfInterfaces" (pdwNumIf AS DWORD) AS DWORD

'''''''''''''''''''''''''''''''''''''''
'
' Gets the MIB-II ifEntry
' The dwIndex field of the MIB_IFROW should be set to the index of the
' interface being queried
'
'''''''''''''''''''''''''''''''''''''''

DECLARE FUNCTION GetIfEntry LIB "iphlpapi.dll" ALIAS "GetIfEntry" _
        (pIfRow AS MIB_IFROW) AS DWORD

'''''''''''''''''''''''''''''''''''''''
'
' Gets the MIB-II IfTable
'
'''''''''''''''''''''''''''''''''''''''

DECLARE FUNCTION GetIfTable LIB "iphlpapi.dll" ALIAS "GetIfTable" _
        (pIfTable AS MIB_IFTABLE, pdwSize AS DWORD, BYVAL bOrder AS LONG) _
        AS DWORD

'''''''''''''''''''''''''''''''''''''''
'
' Gets the Interface to IP Address mapping
'
'''''''''''''''''''''''''''''''''''''''

DECLARE FUNCTION GetIpAddrTable LIB "iphlpapi.dll" ALIAS "GetIpAddrTable" _
        (pIpAddrTable AS MIB_IPADDRTABLE, pdwSize AS DWORD, _
        BYVAL bOrder AS LONG) AS DWORD

'''''''''''''''''''''''''''''''''''''''
'
' Gets the current IP Address to Physical Address (ARP) mapping
'
'''''''''''''''''''''''''''''''''''''''

DECLARE FUNCTION GetIpNetTable LIB "iphlpapi.dll" ALIAS "GetIpNetTable" _
        (pIpNetTable AS MIB_IPNETTABLE, pdwSize AS DWORD, _
        BYVAL bOrder AS LONG) AS DWORD

'''''''''''''''''''''''''''''''''''''''
'
' Gets the IP Routing Table  (RFX XXXX)
'
'''''''''''''''''''''''''''''''''''''''

DECLARE FUNCTION GetIpForwardTable LIB "iphlpapi.dll" _
        ALIAS "GetIpForwardTable" (pIpForwardTable AS MIB_IPFORWARDTABLE, _
        pdwSize AS DWORD, BYVAL bOrder AS LONG) AS DWORD

'''''''''''''''''''''''''''''''''''''''
'
' Gets TCP Connection/UDP Listener Table
'
'''''''''''''''''''''''''''''''''''''''

DECLARE FUNCTION GetTcpTable LIB "iphlpapi.dll" ALIAS "GetTcpTable" _
        (pTcpTable AS MIB_TCPTABLE, pdwSize AS DWORD, BYVAL bOrder AS LONG) _
        AS DWORD

DECLARE FUNCTION GetUdpTable LIB "iphlpapi.dll" ALIAS "GetUdpTable" _
        (pUdpTable AS MIB_UDPTABLE, pdwSize AS DWORD, BYVAL bOrder AS LONG) _
        AS DWORD

'''''''''''''''''''''''''''''''''''''''
'
' Gets IP/ICMP/TCP/UDP Statistics
'
'''''''''''''''''''''''''''''''''''''''

DECLARE FUNCTION GetIpStatistics LIB "iphlpapi.dll" ALIAS "GetIpStatistics" _
        (pStats AS MIB_IPSTATS) AS DWORD

DECLARE FUNCTION GetIcmpStatistics LIB "iphlpapi.dll" _
        ALIAS "GetIcmpStatistics" (pStats AS MIB_ICMP) AS DWORD

DECLARE FUNCTION GetTcpStatistics LIB "iphlpapi.dll" ALIAS "GetTcpStatistics" _
        (pStats AS MIB_TCPSTATS) AS DWORD

DECLARE FUNCTION GetUdpStatistics LIB "iphlpapi.dll" ALIAS "GetUdpStatistics" _
        (pStats AS MIB_UDPSTATS) AS DWORD

'''''''''''''''''''''''''''''''''''''''
'
' Used to set the ifAdminStatus on an interface.  The only fields of the
' MIB_IFROW that are relevant are the dwIndex (index of the interface
' whose status needs to be set) and the dwAdminStatus which can be either
' MIB_IF_ADMIN_STATUS_UP or MIB_IF_ADMIN_STATUS_DOWN
'
'''''''''''''''''''''''''''''''''''''''

DECLARE FUNCTION SetIfEntry LIB "iphlpapi.dll" ALIAS "SetIfEntry" _
        (pIfRow AS MIB_IFROW) AS DWORD

'''''''''''''''''''''''''''''''''''''''
'
' Used to create, modify or delete a route.  In all cases the
' dwForwardIfIndex, dwForwardDest, dwForwardMask, dwForwardNextHop and
' dwForwardPolicy MUST BE SPECIFIED. Currently dwForwardPolicy is unused
' and MUST BE 0.
' For a set, the complete MIB_IPFORWARDROW structure must be specified
'
'''''''''''''''''''''''''''''''''''''''

DECLARE FUNCTION CreateIpForwardEntry LIB "iphlpapi.dll" _
        ALIAS "CreateIpForwardEntry" (pRoute AS MIB_IPFORWARDROW) AS DWORD

DECLARE FUNCTION SetIpForwardEntry LIB "iphlpapi.dll" _
        ALIAS "SetIpForwardEntry" (pRoute AS MIB_IPFORWARDROW) AS DWORD

DECLARE FUNCTION DeleteIpForwardEntry LIB "iphlpapi.dll" _
        ALIAS "DeleteIpForwardEntry" (pRoute AS MIB_IPFORWARDROW) AS DWORD

'''''''''''''''''''''''''''''''''''''''
'
' Used to set the ipForwarding to ON or OFF (currently only ON->OFF is
' allowed) and to set the defaultTTL.  If only one of the fields needs to
' be modified and the other needs to be the same as before the other field
' needs to be set to MIB_USE_CURRENT_TTL or MIB_USE_CURRENT_FORWARDING as
' the case may be
'
'''''''''''''''''''''''''''''''''''''''

DECLARE FUNCTION SetIpStatistics LIB "iphlpapi.dll" ALIAS "SetIpStatistics" _
        (pIpStats AS MIB_IPSTATS) AS DWORD

'''''''''''''''''''''''''''''''''''''''
'
' Used to set the defaultTTL.
'
'''''''''''''''''''''''''''''''''''''''

DECLARE FUNCTION SetIpTTL LIB "iphlpapi.dll" ALIAS "SetIpTTL" _
        (BYVAL nTTL AS DWORD) AS DWORD

'''''''''''''''''''''''''''''''''''''''
'
' Used to create, modify or delete an ARP entry.  In all cases the dwIndex
' dwAddr field MUST BE SPECIFIED.
' For a set, the complete MIB_IPNETROW structure must be specified
'
'''''''''''''''''''''''''''''''''''''''

DECLARE FUNCTION CreateIpNetEntry LIB "iphlpapi.dll" ALIAS "CreateIpNetEntry" _
        (pArpEntry AS MIB_IPNETROW) AS DWORD

DECLARE FUNCTION SetIpNetEntry LIB "iphlpapi.dll" ALIAS "SetIpNetEntry" _
        (pArpEntry AS MIB_IPNETROW) AS DWORD

DECLARE FUNCTION DeleteIpNetEntry LIB "iphlpapi.dll" ALIAS "DeleteIpNetEntry" _
        (pArpEntry AS MIB_IPNETROW) AS DWORD

DECLARE FUNCTION FlushIpNetTable LIB "iphlpapi.dll" ALIAS "FlushIpNetTable" _
        (BYVAL dwIfIndex AS DWORD) AS DWORD


'''''''''''''''''''''''''''''''''''''''
'
' Used to create or delete a Proxy ARP entry. The dwIndex is the index of
' the interface on which to PARP for the dwAddress.  If the interface is
' of a type that doesnt support ARP, e.g. PPP, then the call will fail
'
'''''''''''''''''''''''''''''''''''''''

DECLARE FUNCTION CreateProxyArpEntry LIB "iphlpapi.dll" _
        ALIAS "CreateProxyArpEntry" (BYVAL dwAddress AS DWORD, _
        BYVAL dwMask AS DWORD, BYVAL dwIfIndex AS DWORD) AS DWORD

DECLARE FUNCTION DeleteProxyArpEntry LIB "iphlpapi.dll" _
        ALIAS "DeleteProxyArpEntry" (BYVAL dwAddress AS DWORD, _
        BYVAL dwMask AS DWORD, BYVAL dwIfIndex AS DWORD) AS DWORD

'''''''''''''''''''''''''''''''''''''''
'
' Used to set the state of a TCP Connection. The only state that it can be
' set to is MIB_TCP_STATE_DELETE_TCB.  The complete MIB_TCPROW structure
' MUST BE SPECIFIED
'
'''''''''''''''''''''''''''''''''''''''

DECLARE FUNCTION SetTcpEntry LIB "iphlpapi.dll" ALIAS "SetTcpEntry" _
        (pTcpRow AS MIB_TCPROW) AS DWORD

DECLARE FUNCTION GetInterfaceInfo LIB "iphlpapi.dll" ALIAS "GetInterfaceInfo" _
        (pIfTable AS IP_INTERFACE_INFO, dwOutBufLen AS DWORD) AS DWORD

DECLARE FUNCTION GetUniDirectionalAdapterInfo LIB "iphlpapi.dll" _
        ALIAS "GetUniDirectionalAdapterInfo" _
        (pIPIfInfo AS IP_UNIDIRECTIONAL_ADAPTER_ADDRESS, _
        dwOutBufLen AS DWORD) AS DWORD

'''''''''''''''''''''''''''''''''''''''
'
' Gets the "best" outgoing interface for the specified destination address
'
'''''''''''''''''''''''''''''''''''''''

DECLARE FUNCTION GetBestInterface LIB "iphlpapi.dll" ALIAS "GetBestInterface" _
        (BYVAL dwDestAddr AS DWORD, pdwBestIfIndex AS DWORD) AS DWORD

'''''''''''''''''''''''''''''''''''''''
'
' Gets the best (longest matching prefix) route for the given destination
' If the source address is also specified (i.e. is not 0x00000000), and
' there are multiple "best" routes to the given destination, the returned
' route will be one that goes out over the interface which has an address
' that matches the source address
'
'''''''''''''''''''''''''''''''''''''''

DECLARE FUNCTION GetBestRoute LIB "iphlpapi.dll" ALIAS "GetBestRoute" _
        (BYVAL dwDestAddr AS DWORD, BYVAL dwSourceAddr AS DWORD, _
        pBestRoute AS MIB_IPFORWARDROW) AS DWORD

DECLARE FUNCTION NotifyAddrChange LIB "iphlpapi.dll" ALIAS "NotifyAddrChange" _
        (pHandle AS DWORD, pOverlapped AS OVERLAPPED) AS DWORD

DECLARE FUNCTION NotifyRouteChange LIB "iphlpapi.dll" _
        ALIAS "NotifyRouteChange" (pHandle AS DWORD, _
        pOverlapped AS OVERLAPPED) AS DWORD

' NOTE: AdapterName is a UNICODE string...
DECLARE FUNCTION GetAdapterIndex LIB "iphlpapi.dll" ALIAS "GetAdapterIndex" _
        (AdapterName AS ANY, IfIndex AS DWORD) AS DWORD

DECLARE FUNCTION AddIPAddress LIB "iphlpapi.dll" ALIAS "AddIPAddress" _
        (BYVAL Address AS DWORD, BYVAL IpMask AS DWORD, _
        BYVAL IfIndex AS DWORD, NTEContext AS DWORD, NTEInstance AS DWORD) _
        AS DWORD

DECLARE FUNCTION DeleteIPAddress LIB "iphlpapi.dll" ALIAS "DeleteIPAddress" _
        (BYVAL NTEContext AS DWORD) AS DWORD

DECLARE FUNCTION GetNetworkParams LIB "iphlpapi.dll" ALIAS "GetNetworkParams" _
        (pFixedInfo AS FIXED_INFO, pOutBufLen AS DWORD) AS DWORD

DECLARE FUNCTION GetAdaptersInfo LIB "iphlpapi.dll" ALIAS "GetAdaptersInfo" _
        (pAdapterInfo AS IP_ADAPTER_INFO, pOutBufLen AS DWORD) AS DWORD

DECLARE FUNCTION GetPerAdapterInfo LIB "iphlpapi.dll" _
        ALIAS "GetPerAdapterInfo" (BYVAL IfIndex AS DWORD, _
        pPerAdapterInfo AS IP_PER_ADAPTER_INFO, pOutBufLen AS DWORD) AS DWORD

DECLARE FUNCTION IpReleaseAddress LIB "iphlpapi.dll" ALIAS "IpReleaseAddress" _
        (AdapterInfo AS IP_ADAPTER_INDEX_MAP) AS DWORD

DECLARE FUNCTION IpRenewAddress LIB "iphlpapi.dll" ALIAS "IpRenewAddress" _
        (AdapterInfo AS IP_ADAPTER_INDEX_MAP) AS DWORD

DECLARE FUNCTION SendARP LIB "iphlpapi.dll" ALIAS "SendARP" _
        (BYVAL DestIP AS DWORD, BYVAL SrcIP AS DWORD, pMacAddr AS DWORD, _
        PhyAddrLen AS DWORD) AS DWORD

DECLARE FUNCTION GetRTTAndHopCount LIB "iphlpapi.dll" _
        ALIAS "GetRTTAndHopCount" (BYVAL DestIpAddress AS DWORD, _
        HopCount AS DWORD, BYVAL MaxHops AS DWORD, RTT AS DWORD) AS LONG

DECLARE FUNCTION GetFriendlyIfIndex LIB "iphlpapi.dll" _
        ALIAS "GetFriendlyIfIndex" (BYVAL IfIndex AS DWORD) AS DWORD

DECLARE FUNCTION EnableRouter LIB "iphlpapi.dll" ALIAS "EnableRouter" _
        (pHandle AS DWORD, pOverlapped AS OVERLAPPED) AS DWORD

DECLARE FUNCTION UnenableRouter LIB "iphlpapi.dll" ALIAS "UnenableRouter" _
        (pOverlapped AS OVERLAPPED, lpdwEnableCount AS DWORD) AS DWORD



#ENDIF ' #IF NOT %DEF(%IPHLPAPI_INC)
