'------------------------------------------------------------------------------
'
'  COMMCTRL.INC -- 32-bit Windows API Declarations for PowerBASIC
'
'  Copyright (c) 1997-2001 PowerBASIC, Inc.
'  Portions Copyright (c) 1991-1999 Microsoft Corporation
'
'  Last Update: December 3, 2001
'
'
'  This file contains the constants, TYPE, and DECLARE statements for certain
'  32-bit Windows APIs (for Windows 95, 98, Me, NT, 2000, and XP).
'
'  This file is not compatible with Visual Basic.  It uses the correct
'  data type as defined in the Microsoft SDK for Windows for all API calls.
'  This includes data types which are not natively supported in Visual Basic
'  such as unsigned integers and ASCIIZ strings.
'
'  You have a royalty-free right to use, modify, reproduce and distribute
'  this file (and/or any modified version) in any way you find useful,
'  provided that you agree that PowerBASIC has no warranty, obligation or
'  liability for its contents.  Refer to the Microsoft Windows Programmer's
'  Reference for further information.
'
'  IMPORTANT:  This file is not compatible with PB/DLL 5.0 or PB/CC 1.0
'              as-is. It uses string equates, which are only available in
'              PB/CC 2.0 or later and PB/DLL 6.0 or later.  You will need
'              to comment out the string equates to use this file with
'              earlier compilers.
'
'------------------------------------------------------------------------------

'------------------------------------------------------------------------------
'
'  You can disable support (and code) for the various common controls by
'  defining the following constants in your code *before* the #INCLUDE
'  statement.
'
'    %NOANIMATE         = 1  ' Animate control
'    %NOBUTTON          = 1  ' Button
'    %NOCOMBO           = 1  ' Combo box
'    %NOCOMBOEX         = 1  ' ComboBoxEx
'    %NODATETIMEPICK    = 1  ' Date/time picker
'    %NODRAGLIST        = 1  ' Drag list control
'    %NOEDIT            = 1  ' Edit control
'    %NOFLATSBAPIS      = 1  ' Flat scroll bar
'    %NOHEADER          = 1  ' Header control
'    %NOHOTKEY          = 1  ' HotKey control
'    %NOIMAGELIST       = 1  ' Image APIs
'    %NOIPADDRESS       = 1  ' IP Address edit control
'    %NOLIST            = 1  ' List box control
'    %NOLISTVIEW        = 1  ' ListView control
'    %NOMENUHELP        = 1  ' Menu help
'    %NOMONTHCAL        = 1  ' MonthCal
'    %NOMUI             = 1  ' MUI
'    %NONATIVEFONTCTL   = 1  ' Native Font control
'    %NOPAGESCROLLER    = 1  ' Pager
'    %NOPROGRESS        = 1  ' Progress control
'    %NOREBAR           = 1  ' Rebar control
'    %NOSTATUSBAR       = 1  ' Status bar
'    %NOTABCONTROL      = 1  ' Tab control
'    %NOTOOLBAR         = 1  ' Tool bar
'    %NOTOOLTIPS        = 1  ' Tool tips
'    %NOTRACKBAR        = 1  ' Track bar
'    %NOTRACKMOUSEEVENT = 1  ' Track Mouse Event
'    %NOTREEVIEW        = 1  ' TreeView
'    %NOUPDOWN          = 1  ' Up Down arrow control
'
'------------------------------------------------------------------------------

#IF NOT %DEF(%COMMCTRL_INC)

%COMMCTRL_INC = 1

#IF NOT %DEF(%WINAPI)
    #INCLUDE "WIN32API.INC"
#ENDIF

DECLARE SUB InitCommonControls LIB "COMCTL32.DLL" ALIAS "InitCommonControls" ()

TYPE INIT_COMMON_CONTROLSEX
    dwSize AS DWORD   ' size of this structure
    dwICC  AS DWORD   ' flags indicating which classes to be initialized
END TYPE

%ICC_LISTVIEW_CLASSES    = &H00000001 ' listview, header
%ICC_TREEVIEW_CLASSES    = &H00000002 ' treeview, tooltips
%ICC_BAR_CLASSES         = &H00000004 ' toolbar, statusbar, trackbar, tooltips
%ICC_TAB_CLASSES         = &H00000008 ' tab, tooltips
%ICC_UPDOWN_CLASS        = &H00000010 ' updown
%ICC_PROGRESS_CLASS      = &H00000020 ' progress
%ICC_HOTKEY_CLASS        = &H00000040 ' hotkey
%ICC_ANIMATE_CLASS       = &H00000080 ' animate
%ICC_WIN95_CLASSES       = &H000000FF
%ICC_DATE_CLASSES        = &H00000100 ' month picker, date picker, time picker, updown
%ICC_USEREX_CLASSES      = &H00000200 ' comboex
%ICC_COOL_CLASSES        = &H00000400 ' rebar (coolbar) control
%ICC_INTERNET_CLASSES    = &H00000800
%ICC_PAGESCROLLER_CLASS  = &H00001000 ' page scroller
%ICC_NATIVEFNTCTL_CLASS  = &H00002000 ' native font control

DECLARE FUNCTION InitCommonControlsEx LIB "COMCTL32.DLL" ALIAS "InitCommonControlsEx" (icc AS INIT_COMMON_CONTROLSEX) AS LONG

%ODT_HEADER              = 100
%ODT_TAB                 = 101
%ODT_LISTVIEW            = 102

' Ranges for control message IDs

%LVM_FIRST               = &H1000      ' ListView messages
%TV_FIRST                = &H1100      ' TreeView messages
%HDM_FIRST               = &H1200      ' Header messages
%TCM_FIRST               = &H1300      ' Tab control messages
%PGM_FIRST               = &H1400      ' Pager control messages
%CCM_FIRST               = &H2000      ' Common control shared messages

%CCM_SETBKCOLOR          = %CCM_FIRST + 1 ' lParam is bkColor
%CCM_SETCOLORSCHEME      = %CCM_FIRST + 2 ' lParam is color scheme
%CCM_GETCOLORSCHEME      = %CCM_FIRST + 3 ' fills in COLORSCHEME pointed to by lParam
%CCM_GETDROPTARGET       = %CCM_FIRST + 4
%CCM_SETUNICODEFORMAT    = %CCM_FIRST + 5
%CCM_GETUNICODEFORMAT    = %CCM_FIRST + 6
%COMCTL32_VERSION = 5
%CCM_SETVERSION          = %CCM_FIRST + 7
%CCM_GETVERSION          = %CCM_FIRST + 8
%CCM_SETNOTIFYWINDOW     = %CCM_FIRST + 9 ' wParam = hwndParent.

TYPE COLORSCHEME
    dwSize          AS DWORD
    clrBtnHighlight AS DWORD  ' highlight color
    clrBtnShadow    AS DWORD  ' shadow color
END TYPE

' for tooltips
%INFOTIPSIZE = 1024

' Generic WM_NOTIFY notification codes

%NM_OUTOFMEMORY     = %NM_FIRST - 1
%NM_CLICK           = %NM_FIRST - 2  ' uses NMCLICK type
%NM_DBLCLK          = %NM_FIRST - 3
%NM_RETURN          = %NM_FIRST - 4
%NM_RCLICK          = %NM_FIRST - 5  ' uses NMCLICK type
%NM_RDBLCLK         = %NM_FIRST - 6
%NM_SETFOCUS        = %NM_FIRST - 7
%NM_KILLFOCUS       = %NM_FIRST - 8
%NM_CUSTOMDRAW      = %NM_FIRST - 12
%NM_HOVER           = %NM_FIRST - 13
%NM_NCHITTEST       = %NM_FIRST - 14 ' uses NMMOUSE type
%NM_KEYDOWN         = %NM_FIRST - 15 ' uses NMKEY type
%NM_RELEASEDCAPTURE = %NM_FIRST - 16
%NM_SETCURSOR       = %NM_FIRST - 17 ' uses NMMOUSE type
%NM_CHAR            = %NM_FIRST - 18 ' uses NMCHAR type
%NM_TOOLTIPSCREATED = %NM_FIRST - 19 ' notify of when the tooltips window is create
%NM_LDOWN           = %NM_FIRST - 20
%NM_RDOWN           = %NM_FIRST - 21

TYPE NMTOOLTIPSCREATED
    hdr          AS NMHDR
    hwndToolTips AS DWORD
END TYPE

TYPE NMMOUSE
    hdr        AS NMHDR
    dwItemSpec AS DWORD
    dwItemData AS DWORD
    pt         AS POINTAPI
    dwHitInfo  AS DWORD ' any specifics about where on the item or control the mouse is
END TYPE

TYPE NMCLICK
    hdr        AS NMHDR
    dwItemSpec AS DWORD
    dwItemData AS DWORD
    pt         AS POINTAPI
    dwHitInfo  AS DWORD ' any specifics about where on the item or control the mouse is
END TYPE

' Generic structure to request an object of a specific type.

TYPE NMOBJECTNOTIFY
    hdr     AS NMHDR
    iItem   AS LONG
    piid    AS BYTE PTR
    pObject AS BYTE PTR
    hResult AS LONG
    dwFlags AS DWORD
END TYPE

' Generic structure for a key

TYPE NMKEY
    hdr    AS NMHDR
    nVKey  AS DWORD
    uFlags AS DWORD
END TYPE

' Generic structure for a character

TYPE NMCHAR
    hdr        AS NMHDR
    ch         AS DWORD
    dwItemPrev AS DWORD  ' item previously selected
    dwItemNext AS DWORD  ' item to be selected
END TYPE



' WM_NOTIFY codes (NMHDR.code values)

' %NM_FIRST and %NM_LAST definitions are in WIN32API.INC (always included)

%LVN_FIRST               = 0-100       ' listview
%LVN_LAST                = 0-199

%HDN_FIRST               = 0-300       ' header
%HDN_LAST                = 0-399

%TVN_FIRST               = 0-400       ' treeview
%TVN_LAST                = 0-499

%TTN_FIRST               = 0-520       ' tooltips
%TTN_LAST                = 0-549

%TCN_FIRST               = 0-550       ' tab control
%TCN_LAST                = 0-580

' Shell reserved               0U-580U -  0U-589U

%CDN_FIRST               = 0-601       ' common dialog new
%CDN_LAST                = 0-699

%TBN_FIRST               = 0-700      ' toolbar
%TBN_LAST                = 0-720

%UDN_FIRST               = 0-721       ' updown
%UDN_LAST                = 0-740

%MCN_FIRST               = 0-750       ' monthcal
%MCN_LAST                = 0-759

%DTN_FIRST               = 0-760       ' datetimepick
%DTN_LAST                = 0-799

%CBEN_FIRST              = 0-800       ' combo box ex
%CBEN_LAST               = 0-830

%RBN_FIRST               = 0-831       ' rebar
%RBN_LAST                = 0-859

%IPN_FIRST               = 0-860       ' internet address
%IPN_LAST                = 0-879       ' internet address

%SBN_FIRST               = 0-880       ' status bar
%SBN_LAST                = 0-899

%PGN_FIRST               = 0-900       ' Pager Control
%PGN_LAST                = 0-950

#IF NOT %DEF(%WMN_FIRST)
%WMN_FIRST               = 0-1000
%WMN_LAST                = 0-1200
#ENDIF

%MSGF_COMMCTRL_BEGINDRAG   = &H4200
%MSGF_COMMCTRL_SIZEHEADER  = &H4201
%MSGF_COMMCTRL_DRAGSELECT  = &H4202
%MSGF_COMMCTRL_TOOLBARCUST = &H4203



'==============================================================================
' CUSTOM DRAW APIS

' custom draw return flags
' values under &H00010000 are reserved for global custom draw values.
' above that are for specific controls
%CDRF_DODEFAULT          = &H00000000
%CDRF_NEWFONT            = &H00000002
%CDRF_SKIPDEFAULT        = &H00000004


%CDRF_NOTIFYPOSTPAINT    = &H00000010
%CDRF_NOTIFYITEMDRAW     = &H00000020
%CDRF_NOTIFYSUBITEMDRAW  = &H00000020  ' flags are the same, we can distinguish by context
%CDRF_NOTIFYPOSTERASE    = &H00000040

' drawstage flags
' values under &H00010000 are reserved for global custom draw values.
' above that are for specific controls
%CDDS_PREPAINT           = &H00000001
%CDDS_POSTPAINT          = &H00000002
%CDDS_PREERASE           = &H00000003
%CDDS_POSTERASE          = &H00000004
' the &H000010000 bit means it's individual item specific
%CDDS_ITEM               = &H00010000
%CDDS_ITEMPREPAINT       = (%CDDS_ITEM OR %CDDS_PREPAINT)
%CDDS_ITEMPOSTPAINT      = (%CDDS_ITEM OR %CDDS_POSTPAINT)
%CDDS_ITEMPREERASE       = (%CDDS_ITEM OR %CDDS_PREERASE)
%CDDS_ITEMPOSTERASE      = (%CDDS_ITEM OR %CDDS_POSTERASE)
%CDDS_SUBITEM            = &H00020000

' itemState flags
%CDIS_SELECTED       = &H0001
%CDIS_GRAYED         = &H0002
%CDIS_DISABLED       = &H0004
%CDIS_CHECKED        = &H0008
%CDIS_FOCUS          = &H0010
%CDIS_DEFAULT        = &H0020
%CDIS_HOT            = &H0040
%CDIS_MARKED         = &H0080
%CDIS_INDETERMINATE  = &H0100

TYPE NMCUSTOMDRAW
    hdr         AS NMHDR
    dwDrawStage AS DWORD
    hdc         AS DWORD
    rc          AS RECT
    dwItemSpec  AS DWORD  ' this is control specific, but it's how to specify an item. valid only with CDDS_ITEM bit set
    uItemState  AS DWORD
    lItemlParam AS LONG
END TYPE

TYPE NMTTCUSTOMDRAW
    nmcd       AS NMCUSTOMDRAW
    uDrawFlags AS DWORD
END TYPE



'==============================================================================
' IMAGE APIS

#IF NOT %DEF(%NOIMAGELIST)

%CLR_NONE                = &HFFFFFFFF&
%CLR_DEFAULT             = &HFF000000&

TYPE IMAGELISTDRAWPARAMS
    cbSize  AS DWORD
    himl    AS DWORD
    i       AS LONG
    hdcDst  AS DWORD
    x       AS LONG
    y       AS LONG
    cx      AS LONG
    cy      AS LONG
    xBitmap AS LONG    ' x offest from the upperleft of bitmap
    yBitmap AS LONG    ' y offest from the upperleft of bitmap
    rgbBk   AS DWORD
    rgbFg   AS DWORD
    fStyle  AS DWORD
    dwRop   AS DWORD
END TYPE

%ILC_MASK       = &H0001
%ILC_COLOR      = &H0000
%ILC_COLORDDB   = &H00FE
%ILC_COLOR4     = &H0004
%ILC_COLOR8     = &H0008
%ILC_COLOR16    = &H0010
%ILC_COLOR24    = &H0018
%ILC_COLOR32    = &H0020
%ILC_PALETTE    = &H0800     ' (not implemented)

DECLARE FUNCTION ImageList_Create LIB "COMCTL32.DLL" ALIAS "ImageList_Create" _
    (BYVAL cx AS LONG, BYVAL cy AS LONG, BYVAL flags AS DWORD, _
    BYVAL cInitial AS LONG, BYVAL cGrow AS LONG) AS DWORD

DECLARE FUNCTION ImageList_Destroy LIB "COMCTL32.DLL" _
    ALIAS "ImageList_Destroy" (BYVAL himl AS DWORD) AS LONG

DECLARE FUNCTION ImageList_GetImageCount LIB "COMCTL32.DLL" _
    ALIAS "ImageList_GetImageCount" (BYVAL himl AS DWORD) AS LONG

DECLARE FUNCTION ImageList_SetImageCount LIB "COMCTL32.DLL" _
    ALIAS "ImageList_SetImageCount" (BYVAL himl AS DWORD, _
    BYVAL uNewCount AS DWORD) AS LONG

DECLARE FUNCTION ImageList_Add LIB "COMCTL32.DLL" ALIAS "ImageList_Add" _
    (BYVAL himl AS DWORD, BYVAL hbmImage AS DWORD, BYVAL hbmMask AS DWORD) _
    AS LONG

DECLARE FUNCTION ImageList_ReplaceIcon LIB "COMCTL32.DLL" _
    ALIAS "ImageList_ReplaceIcon" (BYVAL himl AS DWORD, BYVAL i AS LONG, _
    BYVAL hIcon AS DWORD) AS LONG

DECLARE FUNCTION ImageList_SetBkColor LIB "COMCTL32.DLL" _
    ALIAS "ImageList_SetBkColor" (BYVAL himl AS DWORD, BYVAL clrBk AS DWORD) _
    AS DWORD

DECLARE FUNCTION ImageList_GetBkColor LIB "COMCTL32.DLL" _
    ALIAS "ImageList_GetBkColor" (BYVAL himl AS DWORD) AS DWORD

DECLARE FUNCTION ImageList_SetOverlayImage LIB "COMCTL32.DLL" _
    ALIAS "ImageList_SetOverlayImage" (BYVAL himl AS DWORD, _
    BYVAL iImage AS LONG, BYVAL iOverlay AS LONG) AS LONG

FUNCTION ImageList_AddIcon (BYVAL hIml AS DWORD, hIcon AS DWORD) AS LONG
    FUNCTION = ImageList_ReplaceIcon(hIml, -1, hIcon)
END FUNCTION

%ILD_NORMAL      = &H0000
%ILD_TRANSPARENT = &H0001
%ILD_MASK        = &H0010
%ILD_IMAGE       = &H0020
%ILD_ROP         = &H0040
%ILD_BLEND25     = &H0002
%ILD_BLEND50     = &H0004
%ILD_OVERLAYMASK = &H0F00

FUNCTION IndexToOverlayMask (BYVAL i AS LONG) AS LONG
    SHIFT LEFT i, 8
    FUNCTION = i
END FUNCTION

%ILD_SELECTED = %ILD_BLEND50
%ILD_FOCUS    = %ILD_BLEND25
%ILD_BLEND    = %ILD_BLEND50
%CLR_HILIGHT  = %CLR_DEFAULT

DECLARE FUNCTION ImageList_Draw LIB "COMCTL32.DLL" ALIAS "ImageList_Draw" _
    (BYVAL himl AS DWORD, BYVAL i AS LONG, BYVAL hdcDst AS DWORD, _
    BYVAL x AS LONG, BYVAL y AS LONG, BYVAL fStyle AS DWORD) AS LONG

DECLARE FUNCTION ImageList_Replace LIB "COMCTL32.DLL" _
    ALIAS "ImageList_Replace" (BYVAL himl AS DWORD, BYVAL i AS LONG, _
    BYVAL hbmImage AS DWORD, BYVAL hbmMask AS DWORD) AS LONG

DECLARE FUNCTION ImageList_AddMasked LIB "COMCTL32.DLL" _
    ALIAS "ImageList_AddMasked" (BYVAL himl AS DWORD, _
    BYVAL hbmImage AS DWORD, BYVAL crMask AS DWORD) AS LONG

DECLARE FUNCTION ImageList_DrawEx LIB "COMCTL32.DLL" ALIAS "ImageList_DrawEx" _
    (BYVAL himl AS DWORD, BYVAL i AS LONG, BYVAL hdcDst AS DWORD, _
    BYVAL x AS LONG, BYVAL y AS LONG, BYVAL dx AS LONG, BYVAL dy AS LONG, _
    BYVAL rgbBk AS DWORD, BYVAL rgbFg AS DWORD, BYVAL fStyle AS DWORD) AS LONG

DECLARE FUNCTION ImageList_DrawIndirect LIB "COMCTL32.DLL" _
    ALIAS "ImageList_DrawIndirect" (pimldp AS IMAGELISTDRAWPARAMS) AS LONG

DECLARE FUNCTION ImageList_Remove LIB "COMCTL32.DLL" ALIAS "ImageList_Remove" _
    (BYVAL himl AS DWORD, BYVAL i AS LONG) AS LONG

DECLARE FUNCTION ImageList_GetIcon LIB "COMCTL32.DLL" _
    ALIAS "ImageList_GetIcon" (BYVAL himl AS DWORD, BYVAL i AS LONG, _
    BYVAL flags AS DWORD) AS DWORD

DECLARE FUNCTION ImageList_LoadImage LIB "COMCTL32.DLL" _
    ALIAS "ImageList_LoadImageA" (BYVAL hi AS DWORD, lpBmp AS ASCIIZ, _
    BYVAL cx AS LONG, BYVAL cGrow AS LONG, BYVAL crMask AS DWORD, _
    BYVAL uTypw AS DWORD, BYVAL uFlags AS DWORD) AS DWORD

%ILCF_MOVE = &H00000000
%ILCF_SWAP = &H00000001

DECLARE FUNCTION ImageList_Copy (BYVAL himlDst AS DWORD, BYVAL iDst AS LONG, _
    BYVAL himlSrc AS DWORD, BYVAL iSrc AS LONG, BYVAL uFlags AS DWORD) AS LONG

DECLARE FUNCTION ImageList_BeginDrag LIB "COMCTL32.DLL" _
    ALIAS "ImageList_BeginDrag" (BYVAL himlTrack AS DWORD, _
    BYVAL iTrack AS LONG, BYVAL dxHotSpot AS LONG, BYVAL dyHotSpot AS LONG) _
    AS LONG

DECLARE SUB ImageList_EndDrag LIB "COMCTL32.DLL" ALIAS "ImageList_EndDrag" ()

DECLARE FUNCTION ImageList_DragEnter LIB "COMCTL32.DLL" _
    ALIAS "ImageList_DragEnter" (BYVAL hWndLock AS DWORD, BYVAL x AS LONG, _
    BYVAL y AS LONG) AS LONG

DECLARE FUNCTION ImageList_DragLeave LIB "COMCTL32.DLL" _
    ALIAS "ImageList_DragLeave" (BYVAL hWndLock AS DWORD) AS LONG

DECLARE FUNCTION ImageList_DragMove LIB "COMCTL32.DLL" _
    ALIAS "ImageList_DragMove" (BYVAL x AS LONG, BYVAL y AS LONG) AS LONG

DECLARE FUNCTION ImageList_SetDragCursorImage LIB "COMCTL32.DLL" _
    ALIAS "ImageList_SetDragCursorImage" (BYVAL himlDrag AS DWORD, _
    BYVAL iDrag AS LONG, BYVAL dxHotSpot AS LONG, BYVAL dyHotSpot AS LONG) _
    AS LONG

DECLARE FUNCTION ImageList_DragShowNolock LIB "COMCTL32.DLL" _
    ALIAS "ImageList_DragShowNolock" (BYVAL fShow AS LONG) AS LONG

DECLARE FUNCTION ImageList_GetDragImage LIB "COMCTL32.DLL" _
    ALIAS "ImageList_GetDragImage" (ppt AS POINTAPI, pptHotSpot AS POINTAPI) _
    AS DWORD

FUNCTION ImageList_RemoveAll (BYVAL hIml AS DWORD) AS LONG
    FUNCTION = ImageList_Remove(hIml, -1)
END FUNCTION

FUNCTION ImageList_ExtractIcon (BYVAL hI AS DWORD, BYVAL hIml AS DWORD, _
                                BYVAL i AS LONG) AS LONG
    FUNCTION = ImageList_GetIcon(hIml, i, 0)
END FUNCTION

FUNCTION ImageList_LoadBitmap (BYVAL hI AS DWORD, lpBmp AS ASCIIZ, _
                               BYVAL cx AS LONG, BYVAL cGrow AS LONG, _
                               crMask AS LONG) AS LONG
    FUNCTION = ImageList_LoadImage(hi, lpBmp, cx, cGrow, crMask, _
                                   %IMAGE_BITMAP, 0)
END FUNCTION

TYPE IMAGEINFO
    hbmImage AS DWORD
    hbmMask  AS DWORD
    Unused1  AS LONG
    Unused2  AS LONG
    rcImage  AS RECT
END TYPE

DECLARE FUNCTION ImageList_GetIconSize LIB "COMCTL32.DLL" _
    ALIAS "ImageList_GetIconSize" (BYVAL himl AS DWORD, cx AS LONG, _
    cy AS LONG) AS LONG

DECLARE FUNCTION ImageList_SetIconSize LIB "COMCTL32.DLL" _
    ALIAS "ImageList_SetIconSize" (BYVAL himl AS DWORD, BYVAL cx AS LONG, _
    BYVAL cy AS LONG) AS LONG

DECLARE FUNCTION ImageList_GetImageInfo LIB "COMCTL32.DLL" _
    ALIAS "ImageList_GetImageInfo" (BYVAL himl AS DWORD, BYVAL i AS LONG, _
    pImageInfo AS IMAGEINFO) AS LONG

DECLARE FUNCTION ImageList_Merge LIB "COMCTL32.DLL" ALIAS "ImageList_Merge" _
    (BYVAL himl1 AS DWORD, BYVAL i1 AS LONG, BYVAL himl2 AS DWORD, _
    BYVAL i2 AS LONG, BYVAL dx AS LONG, BYVAL dy AS LONG) AS DWORD

DECLARE FUNCTION ImageList_Duplicate LIB "COMCTL32.DLL" _
    ALIAS "ImageList_Duplicate" (BYVAL himl AS DWORD) AS DWORD

#ENDIF



'==============================================================================
' HEADER CONTROL

#IF NOT %DEF(%NOHEADER)

$WC_HEADER       = "SysHeader32"

' begin_r_commctrl

%HDS_HORZ        = &H0000
%HDS_BUTTONS     = &H0002
%HDS_HOTTRACK    = &H0004
%HDS_HIDDEN      = &H0008
%HDS_DRAGDROP    = &H0040
%HDS_FULLDRAG    = &H0080
%HDS_FILTERBAR   = &H0100

' end_r_commctrl

%HDFT_ISSTRING   = &H0000  ' HD_ITEM.pvFilter points to a HD_TEXTFILTER
%HDFT_ISNUMBER   = &H0001  ' HD_ITEM.pvFilter points to a INT
%HDFT_HASNOVALUE = &H8000  ' clear the filter, by setting this bit

TYPE HD_TEXTFILTER
    pszText    AS ASCIIZ PTR  ' [in] pointer to the buffer containing the filter (ANSI)
    cchTextMax AS LONG        ' [in] max size of buffer/edit control buffer
END TYPE

TYPE HD_ITEM
    Mask       AS DWORD
    cxy        AS LONG
    pszText    AS ASCIIZ PTR
    hbm        AS DWORD
    cchTextMax AS LONG
    fmt        AS LONG
    lParam     AS LONG
    iImage     AS LONG    ' index of bitmap in ImageList
    iOrder     AS LONG    ' where to draw this item
    dType      AS DWORD   ' [in] filter type (defined what pvFilter is a pointer to)
    pvFilter   AS DWORD   ' [in] filter data see above
END TYPE

%HDI_WIDTH            = &H0001
%HDI_HEIGHT           = %HDI_WIDTH
%HDI_TEXT             = &H0002
%HDI_FORMAT           = &H0004
%HDI_LPARAM           = &H0008
%HDI_BITMAP           = &H0010
%HDI_IMAGE            = &H0020
%HDI_DI_SETITEM       = &H0040
%HDI_ORDER            = &H0080
%HDI_FILTER           = &H0100

%HDF_LEFT             = 0
%HDF_RIGHT            = 1
%HDF_CENTER           = 2
%HDF_JUSTIFYMASK      = &H0003
%HDF_RTLREADING       = 4

%HDF_OWNERDRAW        = &H8000
%HDF_STRING           = &H4000
%HDF_BITMAP           = &H2000
%HDF_BITMAP_ON_RIGHT  = &H1000
%HDF_IMAGE            = &H0800

%HDM_GETITEMCOUNT        = (%HDM_FIRST + 0)

FUNCTION Header_GetItemCount (BYVAL hWndHD AS DWORD) AS LONG
    FUNCTION = SendMessage(hWndHD, %HDM_GETITEMCOUNT, 0, 0)
END FUNCTION

%HDM_INSERTITEM          =  (%HDM_FIRST + 1)
%HDM_INSERTITEMW         =  (%HDM_FIRST + 10)

FUNCTION Header_InsertItem (BYVAL hWndHD AS DWORD, BYVAL i AS DWORD, _
                            BYVAL phdi AS DWORD) AS LONG
    FUNCTION = SendMessage(hWndHD, %HDM_INSERTITEM, i, phdi)
END FUNCTION

%HDM_DELETEITEM         =  (%HDM_FIRST + 2)

FUNCTION Header_DeleteItem (BYVAL hWndHD AS DWORD, BYVAL i AS DWORD) AS LONG
    FUNCTION = SendMessage(hWndHD, %HDM_DELETEITEM, i, 0)
END FUNCTION

%HDM_GETITEM             =  (%HDM_FIRST + 3)
%HDM_GETITEMW            =  (%HDM_FIRST + 11)

FUNCTION Header_GetItem (BYVAL hWndHD AS DWORD, BYVAL i AS DWORD, _
                         phdi AS HD_ITEM) AS LONG
    FUNCTION = SendMessage(hWndHD, %HDM_GETITEM, i, VARPTR(phdi))
END FUNCTION

%HDM_SETITEM             = (%HDM_FIRST + 4)
%HDM_SETITEMW            = (%HDM_FIRST + 12)

FUNCTION Header_SetItem (BYVAL hWndHD AS DWORD, BYVAL i AS DWORD, _
                         phdi AS HD_ITEM) AS LONG
    FUNCTION = SendMessage(hWndHD, %HDM_SETITEM, i, VARPTR(phdi))
END FUNCTION

TYPE HD_LAYOUT
    prc   AS RECT PTR
    pwpos AS WINDOWPOS PTR
END TYPE

TYPE HDLAYOUT
    prc   AS RECT PTR
    pwpos AS WINDOWPOS PTR
END TYPE

%HDM_LAYOUT              = (%HDM_FIRST + 5)

FUNCTION Header_Layout (BYVAL hWndHD AS DWORD, playout AS HD_LAYOUT) AS LONG
    FUNCTION = SendMessage(hWndHD, %HDM_LAYOUT, 0, VARPTR(playout))
END FUNCTION

%HHT_NOWHERE             = &H0001
%HHT_ONHEADER            = &H0002
%HHT_ONDIVIDER           = &H0004
%HHT_ONDIVOPEN           = &H0008
%HHT_ABOVE               = &H0100
%HHT_BELOW               = &H0200
%HHT_TORIGHT             = &H0400
%HHT_TOLEFT              = &H0800

TYPE HD_HITTESTINFO
    pt     AS POINTAPI
    flags  AS DWORD
    iItem  AS LONG
END TYPE

%HDM_HITTEST             = (%HDM_FIRST + 6)

%HDM_GETITEMRECT         = (%HDM_FIRST + 7)

FUNCTION Header_GetItemRect (BYVAL hwnd AS DWORD, BYVAL iItem AS LONG, _
   BYVAL lprc AS DWORD) AS DWORD
    FUNCTION = SendMessage(hwnd, %HDM_GETITEMRECT, iItem, lprc)
END FUNCTION

%HDM_SETIMAGELIST        = (%HDM_FIRST + 8)

FUNCTION Header_SetImageList (BYVAL hwnd AS DWORD) AS DWORD
    FUNCTION = SendMessage(hwnd, %HDM_SETIMAGELIST, 0, hwnd)
END FUNCTION

%HDM_GETIMAGELIST        = (%HDM_FIRST + 9)

FUNCTION Header_GetImageList (BYVAL hwnd AS DWORD) AS DWORD
    FUNCTION = SendMessage(hwnd, %HDM_GETIMAGELIST, 0, 0)
END FUNCTION

%HDM_ORDERTOINDEX        = (%HDM_FIRST + 15)

FUNCTION Header_OrderToIndex (BYVAL hwnd AS DWORD, BYVAL i AS LONG) AS DWORD
    FUNCTION = SendMessage(hwnd, %HDM_ORDERTOINDEX, i, 0)
END FUNCTION

%HDM_CREATEDRAGIMAGE     = (%HDM_FIRST + 16)  ' wparam = which item (by index)

FUNCTION Header_CreateDragImage (BYVAL hwnd AS DWORD, BYVAL i AS DWORD) _
   AS DWORD
    FUNCTION = SendMessage(hwnd, %HDM_CREATEDRAGIMAGE, i, 0)
END FUNCTION

%HDM_GETORDERARRAY       = (%HDM_FIRST + 17)

FUNCTION Header_GetOrderArray (BYVAL hwnd AS DWORD, BYVAL iCount AS DWORD, _
   BYVAL lpi AS LONG) AS LONG
    FUNCTION = SendMessage(hwnd, %HDM_GETORDERARRAY, iCount, lpi)
END FUNCTION

%HDM_SETORDERARRAY       = (%HDM_FIRST + 18)

FUNCTION Header_SetOrderArray (BYVAL hwnd AS DWORD, BYVAL iCount AS DWORD, _
   BYVAL lpi AS LONG) AS LONG
    FUNCTION = SendMessage(hwnd, %HDM_SETORDERARRAY, iCount, lpi)
END FUNCTION
' lparam = int array of size %HDM_GETITEMCOUNT
' the array specifies the order that all items should be displayed.
' e.g.  { 2, 0, 1}
' says the index 2 item should be shown in the 0ths position
'      index 0 should be shown in the 1st position
'      index 1 should be shown in the 2nd position

%HDM_SETHOTDIVIDER       = (%HDM_FIRST + 19)

FUNCTION Header_SetHotDivider (BYVAL hwnd AS DWORD, BYVAL fPos AS DWORD, _
   BYVAL dw AS LONG) AS LONG
    FUNCTION = SendMessage(hwnd, %HDM_SETHOTDIVIDER, fPos, dw)
END FUNCTION
' convenience message for external dragdrop
' wParam = BOOL  specifying whether the lParam is a dwPos of the cursor
'              position or the index of which divider to hotlight
' lParam = depends on wParam  (-1 and wParm = %FALSE turns off hotlight)

%HDM_SETBITMAPMARGIN     = (%HDM_FIRST + 20)

FUNCTION Header_SetBitmapMargin (BYVAL hwnd AS DWORD, BYVAL iWidth AS DWORD) _
   AS LONG
    FUNCTION = SendMessage(hwnd, %HDM_SETBITMAPMARGIN, iWidth, 0)
END FUNCTION

%HDM_GETBITMAPMARGIN     = (%HDM_FIRST + 21)

FUNCTION Header_GetBitmapMargin (BYVAL hwnd AS DWORD) AS LONG
    FUNCTION = SendMessage(hwnd, %HDM_GETBITMAPMARGIN, 0, 0)
END FUNCTION

%HDM_SETUNICODEFORMAT    = %CCM_SETUNICODEFORMAT

FUNCTION Header_SetUnicodeFormat (BYVAL hwnd AS DWORD, _
   BYVAL fUnicode AS DWORD) AS LONG
    FUNCTION = SendMessage(hwnd, %HDM_SETUNICODEFORMAT, fUnicode, 0)
END FUNCTION

%HDM_GETUNICODEFORMAT    = %CCM_GETUNICODEFORMAT

FUNCTION Header_GetUnicodeFormat (BYVAL hwnd AS DWORD) AS LONG
    FUNCTION = SendMessage(hwnd, %HDM_GETUNICODEFORMAT, 0, 0)
END FUNCTION

%HDM_SETFILTERCHANGETIMEOUT = (%HDM_FIRST + 22)

FUNCTION Header_SetFilterChangeTimeout (BYVAL hwnd AS DWORD, BYVAL i AS LONG) _
   AS LONG
    FUNCTION = SendMessage(hwnd, %HDM_SETFILTERCHANGETIMEOUT, 0, i)
END FUNCTION

%HDM_EDITFILTER             = (%HDM_FIRST + 23)

FUNCTION Header_EditFilter (BYVAL hwnd AS DWORD, BYVAL i AS DWORD, _
   BYVAL fDiscardChanges AS INTEGER) AS LONG
    FUNCTION = SendMessage(hwnd, %HDM_EDITFILTER, i, MAKLNG(fDiscardChanges, 0))
END FUNCTION

' Clear filter takes -1 as a column value to indicate that all
' the filter should be cleared.  When this happens you will
' only receive a single filter changed notification.

%HDM_CLEARFILTER            = (%HDM_FIRST + 24)

FUNCTION Header_ClearFilter (BYVAL hwnd AS DWORD, BYVAL i AS DWORD) AS LONG
    FUNCTION = SendMessage(hwnd, %HDM_CLEARFILTER, i, 0)
END FUNCTION

FUNCTION Header_ClearAllFilters (BYVAL hwnd AS DWORD) AS LONG
    FUNCTION = SendMessage(hwnd, %HDM_CLEARFILTER, -1, 0)
END FUNCTION

%HDN_ITEMCHANGING        = (%HDN_FIRST - 0)
%HDN_ITEMCHANGINGW       = (%HDN_FIRST - 20)
%HDN_ITEMCHANGED         = (%HDN_FIRST - 1)
%HDN_ITEMCHANGEDW        = (%HDN_FIRST - 21)
%HDN_ITEMCLICK           = (%HDN_FIRST - 2)
%HDN_ITEMCLICKW          = (%HDN_FIRST - 22)
%HDN_ITEMDBLCLICK        = (%HDN_FIRST - 3)
%HDN_ITEMDBLCLICKW       = (%HDN_FIRST - 23)
%HDN_DIVIDERDBLCLICK     = (%HDN_FIRST - 5)
%HDN_DIVIDERDBLCLICKW    = (%HDN_FIRST - 25)
%HDN_BEGINTRACK          = (%HDN_FIRST - 6)
%HDN_BEGINTRACKW         = (%HDN_FIRST - 26)
%HDN_ENDTRACK            = (%HDN_FIRST - 7)
%HDN_ENDTRACKW           = (%HDN_FIRST - 27)
%HDN_TRACK               = (%HDN_FIRST - 8)
%HDN_TRACKW              = (%HDN_FIRST - 28)
%HDN_GETDISPINFO         = (%HDN_FIRST - 9)
%HDN_GETDISPINFOW        = (%HDN_FIRST - 29)
%HDN_BEGINDRAG           = (%HDN_FIRST - 10)
%HDN_ENDDRAG             = (%HDN_FIRST - 11)
%HDN_FILTERCHANGE        = (%HDN_FIRST - 12)
%HDN_FILTERBTNCLICK      = (%HDN_FIRST - 13)

TYPE HD_NOTIFY
    hdr     AS NMHDR
    iItem   AS LONG
    iButton AS LONG
    pitem   AS HD_ITEM PTR
END TYPE

TYPE NMHEADER
    hdr     AS NMHDR
    iItem   AS LONG
    iButton AS LONG
    pitem   AS HD_ITEM PTR
END TYPE

TYPE NMHDDISPINFO
    hdr        AS NMHDR
    iItem      AS LONG
    mask       AS DWORD
    pszText    AS ASCIIZ PTR
    cchTextMax AS LONG
    iImage     AS LONG
    lParam     AS LONG
END TYPE

TYPE NMHDFILTERBTNCLICK
    hdr   AS NMHDR
    iItem AS LONG
    rc    AS RECT
END TYPE

#ENDIF



'==============================================================================
' TOOLBAR CONTROL

#IF NOT %DEF(%NOTOOLBAR)

$TOOLBARCLASSNAME      = "ToolbarWindow32"

DECLARE FUNCTION CreateToolbarEx LIB "COMCTL32.DLL" ALIAS "CreateToolbarEx" _
    (BYVAL hWnd AS LONG, BYVAL ws AS DWORD, BYVAL wID AS WORD, _
    BYVAL nBitmaps AS LONG, BYVAL hBMInst AS DWORD, BYVAL wBMID AS DWORD, _
    lpButtons AS TBBUTTON, BYVAL iNumButtons AS LONG, BYVAL dxButton AS LONG, _
    BYVAL dyButton AS LONG, BYVAL dxBitmap AS LONG, BYVAL dyBitmap AS LONG, _
    BYVAL uStructSize AS DWORD) AS DWORD

DECLARE FUNCTION CreateMappedBitmap LIB "COMCTL32.DLL" _
    ALIAS "CreateMappedBitmap" (BYVAL hInstance AS DWORD, _
    BYVAL idBitmap AS LONG, BYVAL wFlags AS DWORD, lpColorMap AS COLORMAP, _
    BYVAL iNumMaps AS LONG) AS DWORD

%CMB_MASKED             = &H02

%TBSTATE_CHECKED        = &H01
%TBSTATE_PRESSED        = &H02
%TBSTATE_ENABLED        = &H04
%TBSTATE_HIDDEN         = &H08
%TBSTATE_INDETERMINATE  = &H10
%TBSTATE_WRAP           = &H20
%TBSTATE_ELLIPSES       = &H40
%TBSTATE_MARKED         = &H80

%TBSTYLE_BUTTON         = &H0000
%TBSTYLE_SEP            = &H0001
%TBSTYLE_CHECK          = &H0002
%TBSTYLE_GROUP          = &H0004
%TBSTYLE_CHECKGROUP     = %TBSTYLE_GROUP OR %TBSTYLE_CHECK
%TBSTYLE_DROPDOWN       = &H0008
%TBSTYLE_AUTOSIZE       = &H0010 ' automatically calculate the cx of the button
%TBSTYLE_NOPREFIX       = &H0020 ' if this button should not have accel prefix

%TBSTYLE_TOOLTIPS        = &H0100
%TBSTYLE_WRAPABLE        = &H0200
%TBSTYLE_ALTDRAG         = &H0400
%TBSTYLE_FLAT            = &H0800
%TBSTYLE_LIST            = &H1000
%TBSTYLE_CUSTOMERASE     = &H2000
%TBSTYLE_REGISTERDROP    = &H4000
%TBSTYLE_TRANSPARENT     = &H8000
%TBSTYLE_EX_DRAWDDARROWS = &H00000001

%BTNS_BUTTON     = %TBSTYLE_BUTTON      ' &H0000
%BTNS_SEP        = %TBSTYLE_SEP         ' &H0001
%BTNS_CHECK      = %TBSTYLE_CHECK       ' &H0002
%BTNS_GROUP      = %TBSTYLE_GROUP       ' &H0004
%BTNS_CHECKGROUP = %TBSTYLE_CHECKGROUP  ' (%TBSTYLE_GROUP OR %TBSTYLE_CHECK)
%BTNS_DROPDOWN   = %TBSTYLE_DROPDOWN    ' &H0008
%BTNS_AUTOSIZE   = %TBSTYLE_AUTOSIZE    ' &H0010; automatically calculate the cx of the button
%BTNS_NOPREFIX   = %TBSTYLE_NOPREFIX    ' &H0020; this button should not have accel prefix
%BTNS_SHOWTEXT   = &H0040              ' ignored unless %TBSTYLE_EX_MIXEDBUTTONS is set
%BTNS_WHOLEDROPDOWN  = &H0080          ' draw drop-down arrow, but without split arrow section

%TBSTYLE_EX_MIXEDBUTTONS        = &H00000008
%TBSTYLE_EX_HIDECLIPPEDBUTTONS  = &H00000010  ' don't show partially obscured buttons

TYPE NMTBCUSTOMDRAW
    nmcd                 AS NMCUSTOMDRAW
    hbrMonoDither        AS DWORD
    hbrLines             AS DWORD  ' For drawing lines on buttons
    hpenLines            AS DWORD  ' For drawing lines on buttons
    clrText              AS DWORD  ' Color of text
    clrMark              AS DWORD  ' Color of text bk when marked (only if TBSTATE_MARKED)
    clrTextHighlight     AS DWORD  ' Color of text when highlighted
    clrBtnFace           AS DWORD  ' Background of the button
    clrBtnHighlight      AS DWORD  ' 3D highlight
    clrHighlightHotTrack AS DWORD  ' In conjunction with fHighlightHotTrack,
    rcText               AS RECT   ' will cause button to highlight like a menu
    nStringBkMode        AS LONG   ' Rect for text
    nHLStringBkMode      AS LONG
END TYPE

' Toolbar custom draw return flags
%TBCDRF_NOEDGES        = &H00010000 ' Don't draw button edges
%TBCDRF_HILITEHOTTRACK = &H00020000 ' Use color of the button bk when hottracked
%TBCDRF_NOOFFSET       = &H00040000 ' Don't offset button if pressed
%TBCDRF_NOMARK         = &H00080000 ' Don't draw default highlight of image/text for TBSTATE_MARKED
%TBCDRF_NOETCHEDEFFECT = &H00100000 ' Don't draw etched effect for disabled items
%TBCDRF_BLENDICON      = &H00200000 ' Use ILD_BLEND50 on the icon image

%TB_ENABLEBUTTON             = %WM_USER + 1
%TB_CHECKBUTTON              = %WM_USER + 2
%TB_PRESSBUTTON              = %WM_USER + 3
%TB_HIDEBUTTON               = %WM_USER + 4
%TB_INDETERMINATE            = %WM_USER + 5
%TB_MARKBUTTON               = %WM_USER + 6
%TB_ISBUTTONENABLED          = %WM_USER + 9
%TB_ISBUTTONCHECKED          = %WM_USER + 10
%TB_ISBUTTONPRESSED          = %WM_USER + 11
%TB_ISBUTTONHIDDEN           = %WM_USER + 12
%TB_ISBUTTONINDETERMINATE    = %WM_USER + 13
%TB_ISBUTTONHIGHLIGHTED      = %WM_USER + 14
%TB_SETSTATE                 = %WM_USER + 17
%TB_GETSTATE                 = %WM_USER + 18
%TB_ADDBITMAP                = %WM_USER + 19

%HINST_COMMCTRL          = &HFFFFFFFF??? ' -1
%IDB_STD_SMALL_COLOR     = 0
%IDB_STD_LARGE_COLOR     = 1
%IDB_VIEW_SMALL_COLOR    = 4
%IDB_VIEW_LARGE_COLOR    = 5
%IDB_HIST_SMALL_COLOR    = 8
%IDB_HIST_LARGE_COLOR    = 9

' icon indexes for standard bitmap

%STD_CUT         = 0
%STD_COPY        = 1
%STD_PASTE       = 2
%STD_UNDO        = 3
%STD_REDOW       = 4
%STD_DELETE      = 5
%STD_FILENEW     = 6
%STD_FILEOPEN    = 7
%STD_FILESAVE    = 8
%STD_PRINTPRE    = 9
%STD_PROPERTIES  = 10
%STD_HELP        = 11
%STD_FIND        = 12
%STD_REPLACE     = 13
%STD_PRINT       = 14

' icon indexes for standard view bitmap

%VIEW_LARGEICONS     = 0
%VIEW_SMALLICONS     = 1
%VIEW_LIST           = 2
%VIEW_DETAILS        = 3
%VIEW_SORTNAME       = 4
%VIEW_SORTSIZE       = 5
%VIEW_SORTDATE       = 6
%VIEW_SORTTYPE       = 7
%VIEW_PARENTFOLDER   = 8
%VIEW_NETCONNECT     = 9
%VIEW_NETDISCONNECT  = 10
%VIEW_NEWFOLDER      = 11
%VIEW_VIEWMENU       = 12

%HIST_BACK           = 0
%HIST_FORWARD        = 1
%HIST_FAVORITES      = 2
%HIST_ADDTOFAVORITES = 3
%HIST_VIEWTREE       = 4

%TB_ADDBUTTONS       = %WM_USER + 20
%TB_INSERTBUTTON     = %WM_USER + 21
%TB_DELETEBUTTON     = %WM_USER + 22
%TB_GETBUTTON        = %WM_USER + 23
%TB_BUTTONCOUNT      = %WM_USER + 24
%TB_COMMANDTOINDEX   = %WM_USER + 25

TYPE TBSAVEPARAMS
  hkr AS DWORD
  pszSubKey AS ASCIIZ PTR
  pszValueName AS ASCIIZ PTR
END TYPE

%TB_SAVERESTORE           = %WM_USER + 26
%TB_SAVERESTOREW          = %WM_USER + 76
%TB_CUSTOMIZE             = %WM_USER + 27
%TB_ADDSTRING             = %WM_USER + 28
%TB_ADDSTRINGW            = %WM_USER + 77
%TB_GETITEMRECT           = %WM_USER + 29
%TB_BUTTONSTRUCTSIZE      = %WM_USER + 30
%TB_SETBUTTONSIZE         = %WM_USER + 31
%TB_SETBITMAPSIZE         = %WM_USER + 32
%TB_AUTOSIZE              = %WM_USER + 33
%TB_GETTOOLTIPS           = %WM_USER + 35
%TB_SETTOOLTIPS           = %WM_USER + 36
%TB_SETPARENT             = %WM_USER + 37
%TB_SETROWS               = %WM_USER + 39
%TB_GETROWS               = %WM_USER + 40
%TB_SETCMDID              = %WM_USER + 42
%TB_CHANGEBITMAP          = %WM_USER + 43
%TB_GETBITMAP             = %WM_USER + 44
%TB_GETBUTTONTEXT         = %WM_USER + 45
%TB_GETBUTTONTEXTW        = %WM_USER + 75
%TB_REPLACEBITMAP         = %WM_USER + 46
%TB_SETINDENT             = %WM_USER + 47
%TB_SETIMAGELIST          = %WM_USER + 48
%TB_GETIMAGELIST          = %WM_USER + 49
%TB_LOADIMAGES            = %WM_USER + 50
%TB_GETRECT               = %WM_USER + 51  ' wParam is the Cmd instead of index
%TB_SETHOTIMAGELIST       = %WM_USER + 52
%TB_GETHOTIMAGELIST       = %WM_USER + 53
%TB_SETDISABLEDIMAGELIST  = %WM_USER + 54
%TB_GETDISABLEDIMAGELIST  = %WM_USER + 55
%TB_SETSTYLE              = %WM_USER + 56
%TB_GETSTYLE              = %WM_USER + 57
%TB_GETBUTTONSIZE         = %WM_USER + 58
%TB_SETBUTTONWIDTH        = %WM_USER + 59
%TB_SETMAXTEXTROWS        = %WM_USER + 60
%TB_GETTEXTROWS           = %WM_USER + 61

%TB_GETOBJECT             = %WM_USER + 62  ' wParam == IID, lParam void **ppv
%TB_GETHOTITEM            = %WM_USER + 71
%TB_SETHOTITEM            = %WM_USER + 72  ' wParam == iHotItem
%TB_SETANCHORHIGHLIGHT    = %WM_USER + 73  ' wParam == TRUE/FALSE
%TB_GETANCHORHIGHLIGHT    = %WM_USER + 74
%TB_MAPACCELERATOR        = %WM_USER + 78  ' wParam == ch, lParam int * pidBtn

TYPE TBINSERTMARK
    iButton AS LONG
    dwFlags AS DWORD
END TYPE

%TBIMHT_AFTER      = &H00000001 ' TRUE = insert After iButton, otherwise before
%TBIMHT_BACKGROUND = &H00000002 ' TRUE iff missed buttons completely

%TB_GETINSERTMARK        = %WM_USER + 79  ' lParam == LPTBINSERTMARK
%TB_SETINSERTMARK        = %WM_USER + 80  ' lParam == LPTBINSERTMARK
%TB_INSERTMARKHITTEST    = %WM_USER + 81  ' wParam == LPPOINT lParam == LPTBINSERTMARK
%TB_MOVEBUTTON           = %WM_USER + 82
%TB_GETMAXSIZE           = %WM_USER + 83  ' lParam == LPSIZE
%TB_SETEXTENDEDSTYLE     = %WM_USER + 84  ' For TBSTYLE_EX_*
%TB_GETEXTENDEDSTYLE     = %WM_USER + 85  ' For TBSTYLE_EX_*
%TB_GETPADDING           = %WM_USER + 86
%TB_SETPADDING           = %WM_USER + 87
%TB_SETINSERTMARKCOLOR   = %WM_USER + 88
%TB_GETINSERTMARKCOLOR   = %WM_USER + 89

%TB_SETCOLORSCHEME       = %CCM_SETCOLORSCHEME  ' lParam is color scheme
%TB_GETCOLORSCHEME       = %CCM_GETCOLORSCHEME  ' fills in COLORSCHEME pointed to by lParam

%TB_SETUNICODEFORMAT     = %CCM_SETUNICODEFORMAT
%TB_GETUNICODEFORMAT     = %CCM_GETUNICODEFORMAT

%TB_MAPACCELERATORW      = %WM_USER + 90  ' wParam == ch, lParam int * pidBtn

%TBBF_LARGE              = &H0001

%TB_GETBITMAPFLAGS       = (%WM_USER + 41)

%TBIF_IMAGE              = &H00000001
%TBIF_TEXT               = &H00000002
%TBIF_STATE              = &H00000004
%TBIF_STYLE              = &H00000008
%TBIF_LPARAM             = &H00000010
%TBIF_COMMAND            = &H00000020
%TBIF_SIZE               = &H00000040
%TBIF_BYINDEX            = &H80000000 ' this specifies that the wparam in Get/SetButtonInfo is an index, not id

TYPE TBBUTTONINFO
    cbSize AS DWORD
    dwMask AS DWORD
    idCommand AS LONG
    iImage AS LONG
    fsState AS BYTE
    fsStyle AS BYTE
    cx AS WORD
    lParam AS DWORD
    pszText AS ASCIIZ PTR
    cchText AS LONG
END TYPE

' BUTTONINFO APIs do NOT support the string pool.
%TB_GETBUTTONINFOW        = %WM_USER + 63
%TB_SETBUTTONINFOW        = %WM_USER + 64
%TB_GETBUTTONINFO         = %WM_USER + 65
%TB_SETBUTTONINFO         = %WM_USER + 66

' New post Win95/NT4 for InsertButton and AddButton.  if iString member
' is a pointer to a string, it will be handled as a string like listview
' (although LPSTR_TEXTCALLBACK is not supported).

%TB_INSERTBUTTONW        = %WM_USER + 67
%TB_ADDBUTTONSW          = %WM_USER + 68

%TB_HITTEST              = %WM_USER + 69

%TB_SETDRAWTEXTFLAGS     = %WM_USER + 70  ' wParam == mask lParam == bit values

%TB_GETSTRINGW           = %WM_USER + 91
%TB_GETSTRING            = %WM_USER + 92

%TBN_GETBUTTONINFO       = %TBN_FIRST - 0
%TBN_GETBUTTONINFOW      = %TBN_FIRST - 20
%TBN_BEGINDRAG           = %TBN_FIRST - 1
%TBN_ENDDRAG             = %TBN_FIRST - 2
%TBN_BEGINADJUST         = %TBN_FIRST - 3
%TBN_ENDADJUST           = %TBN_FIRST - 4
%TBN_RESET               = %TBN_FIRST - 5
%TBN_QUERYINSERT         = %TBN_FIRST - 6
%TBN_QUERYDELETE         = %TBN_FIRST - 7
%TBN_TOOLBARCHANGE       = %TBN_FIRST - 8
%TBN_CUSTHELP            = %TBN_FIRST - 9
%TBN_DROPDOWN            = %TBN_FIRST - 10
%TBN_GETOBJECT           = %TBN_FIRST - 12

' Structure for %TBN_HOTITEMCHANGE notification
'
TYPE NMTBHOTITEM
    hdr AS NMHDR
    idOld AS LONG
    idNew AS LONG
    dwFlags AS DWORD    ' %HICF_*
END TYPE

' Hot item change flags
%HICF_OTHER          = &H00000000
%HICF_MOUSE          = &H00000001    ' Triggered by mouse
%HICF_ARROWKEYS      = &H00000002    ' Triggered by arrow keys
%HICF_ACCELERATOR    = &H00000004    ' Triggered by accelerator
%HICF_DUPACCEL       = &H00000008    ' This accelerator is not unique
%HICF_ENTERING       = &H00000010    ' idOld is invalid
%HICF_LEAVING        = &H00000020    ' idNew is invalid
%HICF_RESELECT       = &H00000040    ' hot item reselected

%TBN_HOTITEMCHANGE   = %TBN_FIRST - 13
%TBN_DRAGOUT         = %TBN_FIRST - 14 ' this is sent when the user clicks down on a button then drags off the button
%TBN_DELETINGBUTTON  = %TBN_FIRST - 15 ' uses %TBNOTIFY
%TBN_GETDISPINFO     = %TBN_FIRST - 16 ' This is sent when the toolbar needs some display information
%TBN_GETDISPINFOW    = %TBN_FIRST - 17 ' This is sent when the toolbar needs some display information
%TBN_GETINFOTIP      = %TBN_FIRST - 18
%TBN_GETINFOTIPW     = %TBN_FIRST - 19
%TBN_RESTORE         = %TBN_FIRST - 21
%TBN_SAVE            = %TBN_FIRST - 22
%TBN_INITCUSTOMIZE   = %TBN_FIRST - 23

%TBNRF_HIDEHELP      = &H00000001
%TBNRF_ENDCUSTOMIZE  = &H00000002

TYPE NMTBSAVE
    hdr        AS NMHDR
    pData      AS DWORD PTR
    pCurrent   AS DWORD PTR
    cbData     AS DWORD
    iItem      AS LONG
    cButtons   AS LONG
    tButton    AS TBBUTTON
END TYPE

TYPE NMTBRESTORE
    hdr              AS NMHDR
    pData            AS DWORD PTR
    pCurrent         AS DWORD PTR
    cbData           AS DWORD
    iItem            AS LONG
    cButtons         AS LONG
    cbBytesPerRecord AS LONG
    tButton          AS TBBUTTON
END TYPE

TYPE NMTBGETINFOTIP
    hdr        AS NMHDR
    pszText    AS ASCIIZ PTR
    cchTextMax AS LONG
    iItem      AS LONG
    lParam     AS LONG
END TYPE

%TBNF_IMAGE       = &H00000001
%TBNF_TEXT        = &H00000002
%TBNF_DI_SETITEM  = &H10000000

TYPE NMTBDISPINFO
    hdr       AS NMHDR
    dwMask    AS DWORD      ' [in] Specifies the values requested .[out] Client ask the data to be set for future use
    idCommand AS LONG       ' [in] id of button we're requesting info for
    lParam    AS DWORD      ' [in] lParam of button
    iImage    AS LONG       ' [out] image index
    pszText   AS ASCIIZ PTR ' [out] new text for item
    cchText   AS LONG       ' [in] size of buffer pointed to by pszText
END TYPE

' Return codes for TBN_DROPDOWN
%TBDDRET_DEFAULT      = 0
%TBDDRET_NODEFAULT    = 1
%TBDDRET_TREATPRESSED = 2       ' Treat as a standard press button

TYPE NMTOOLBAR
    hdr       AS NMHDR
    iItem     AS LONG
    tbButton  AS TBBUTTON
    cchText   AS LONG
    pszText   AS ASCIIZ PTR
    rcButton  AS RECT
END TYPE

#ENDIF



'====== REBAR CONTROL ========================================================

#IF NOT %DEF(%NOREBAR)

$REBARCLASSNAME  = "ReBarWindow32"

%RBIM_IMAGELIST  = &H00000001

%RBS_TOOLTIPS        = &H0100
%RBS_VARHEIGHT       = &H0200
%RBS_BANDBORDERS     = &H0400
%RBS_FIXEDORDER      = &H0800
%RBS_REGISTERDROP    = &H1000
%RBS_AUTOSIZE        = &H2000
%RBS_VERTICALGRIPPER = &H4000  ' this always has the vertical gripper (default for horizontal mode)
%RBS_DBLCLKTOGGLE    = &H8000

TYPE REBARINFO
    cbSize AS DWORD
    fMask  AS DWORD
    himl   AS DWORD
END TYPE

%RBBS_BREAK          = &H00000001  ' break to new line
%RBBS_FIXEDSIZE      = &H00000002  ' band can't be sized
%RBBS_CHILDEDGE      = &H00000004  ' edge around top & bottom of child window
%RBBS_HIDDEN         = &H00000008  ' don't show
%RBBS_NOVERT         = &H00000010  ' don't show when vertical
%RBBS_FIXEDBMP       = &H00000020  ' bitmap doesn't move during band resize
%RBBS_VARIABLEHEIGHT = &H00000040  ' allow autosizing of this child vertically
%RBBS_GRIPPERALWAYS  = &H00000080  ' always show the gripper
%RBBS_NOGRIPPER      = &H00000100  ' never show the gripper
%RBBS_USECHEVRON     = &H00000200  ' display drop-down button for this band if it's sized smaller than ideal width
%RBBS_HIDETITLE      = &H00000400  ' keep band title hidden

%RBBIM_STYLE         = &H00000001
%RBBIM_COLORS        = &H00000002
%RBBIM_TEXT          = &H00000004
%RBBIM_IMAGE         = &H00000008
%RBBIM_CHILD         = &H00000010
%RBBIM_CHILDSIZE     = &H00000020
%RBBIM_SIZE          = &H00000040
%RBBIM_BACKGROUND    = &H00000080
%RBBIM_ID            = &H00000100
%RBBIM_IDEALSIZE     = &H00000200
%RBBIM_LPARAM        = &H00000400
%RBBIM_HEADERSIZE    = &H00000800  ' control the size of the header

TYPE REBARBANDINFO
    cbSize     AS DWORD
    fMask      AS DWORD
    fStyle     AS DWORD
    clrFore    AS DWORD
    clrBack    AS DWORD
    lpText     AS ASCIIZ PTR
    cch        AS DWORD
    iImage     AS LONG
    hwndChild  AS DWORD
    cxMinChild AS DWORD
    cyMinChild AS DWORD
    cx         AS DWORD
    hbmBack    AS DWORD
    wID        AS DWORD
    cyChild    AS DWORD
    cyMaxChild AS DWORD
    cyIntegral AS DWORD
    cxIdeal    AS DWORD
    lParam     AS LONG
    cxHeader   AS DWORD
END TYPE

%RB_INSERTBAND   = (%WM_USER + 1)
%RB_DELETEBAND   = (%WM_USER + 2)
%RB_GETBARINFO   = (%WM_USER + 3)
%RB_SETBARINFO   = (%WM_USER + 4)
'%RB_GETBANDINFO  = (%WM_USER + 5)    ' for _WIN32_IE < 0x0400
%RB_SETBANDINFO  = (%WM_USER + 6)
%RB_SETPARENT    = (%WM_USER + 7)
%RB_HITTEST      = (%WM_USER + 8)
%RB_GETRECT      = (%WM_USER + 9)
%RB_INSERTBANDW  = (%WM_USER + 10)
%RB_SETBANDINFOW = (%WM_USER + 11)
%RB_GETBANDCOUNT = (%WM_USER + 12)
%RB_GETROWCOUNT  = (%WM_USER + 13)
%RB_GETROWHEIGHT = (%WM_USER + 14)
%RB_IDTOINDEX    = (%WM_USER + 16) ' wParam == id
%RB_GETTOOLTIPS  = (%WM_USER + 17)
%RB_SETTOOLTIPS  = (%WM_USER + 18)
%RB_SETBKCOLOR   = (%WM_USER + 19) ' sets the default BK color
%RB_GETBKCOLOR   = (%WM_USER + 20) ' defaults to CLR_NONE
%RB_SETTEXTCOLOR = (%WM_USER + 21)
%RB_GETTEXTCOLOR = (%WM_USER + 22) ' defaults to &H00000000
%RB_SIZETORECT   = (%WM_USER + 23) ' resize the rebar/break bands and such to this rect (lparam)

%RB_SETCOLORSCHEME  = %CCM_SETCOLORSCHEME  ' lParam is color scheme
%RB_GETCOLORSCHEME  = %CCM_GETCOLORSCHEME  ' fills in COLORSCHEME pointed to by lParam

' for manual drag control
' lparam == cursor pos
        ' -1 means do it yourself.
        ' -2 means use what you had saved before
%RB_BEGINDRAG    = (%WM_USER + 24)
%RB_ENDDRAG      = (%WM_USER + 25)
%RB_DRAGMOVE     = (%WM_USER + 26)
%RB_GETBARHEIGHT = (%WM_USER + 27)
%RB_GETBANDINFOW = (%WM_USER + 28)
%RB_GETBANDINFO  = (%WM_USER + 29)

%RB_MINIMIZEBAND = (%WM_USER + 30)
%RB_MAXIMIZEBAND = (%WM_USER + 31)

%RB_GETDROPTARGET = (%CCM_GETDROPTARGET)

%RB_GETBANDBORDERS = (%WM_USER + 34)  ' returns in lparam = lprc the amount of edges added to band wparam

%RB_SHOWBAND     = (%WM_USER + 35)      ' show/hide band
%RB_SETPALETTE   = (%WM_USER + 37)
%RB_GETPALETTE   = (%WM_USER + 38)
%RB_MOVEBAND     = (%WM_USER + 39)

%RB_SETUNICODEFORMAT = %CCM_SETUNICODEFORMAT
%RB_GETUNICODEFORMAT = %CCM_GETUNICODEFORMAT

%RB_PUSHCHEVRON  = (%WM_USER + 43)

%RBN_HEIGHTCHANGE    = (%RBN_FIRST - 0)

%RBN_GETOBJECT       = (%RBN_FIRST - 1)
%RBN_LAYOUTCHANGED   = (%RBN_FIRST - 2)
%RBN_AUTOSIZE        = (%RBN_FIRST - 3)
%RBN_BEGINDRAG       = (%RBN_FIRST - 4)
%RBN_ENDDRAG         = (%RBN_FIRST - 5)
%RBN_DELETINGBAND    = (%RBN_FIRST - 6)     ' Uses NMREBAR
%RBN_DELETEDBAND     = (%RBN_FIRST - 7)     ' Uses NMREBAR
%RBN_CHILDSIZE       = (%RBN_FIRST - 8)
%RBN_CHEVRONPUSHED   = (%RBN_FIRST - 10)
%RBN_MINMAX          = (%RBN_FIRST - 21)

TYPE NMREBARCHILDSIZE
    hdr     AS NMHDR
    uBand   AS DWORD
    wID     AS DWORD
    rcChild AS RECT
    rcBand  AS RECT
END TYPE

TYPE NMREBAR
    hdr    AS NMHDR
    dwMask AS DWORD    ' RBNM_*
    uBand  AS DWORD
    fStyle AS DWORD
    wID    AS DWORD
    lParam AS LONG
END TYPE

' Mask flags for NMREBAR
%RBNM_ID         = &H00000001
%RBNM_STYLE      = &H00000002
%RBNM_LPARAM     = &H00000004

TYPE NMRBAUTOSIZE
    hdr      AS NMHDR
    fChanged AS LONG
    rcTarget AS RECT
    rcActual AS RECT
END TYPE

%RBHT_NOWHERE = &H0001
%RBHT_CAPTION = &H0002
%RBHT_CLIENT  = &H0003
%RBHT_GRABBER = &H0004
%RBHT_CHEVRON = &H0008

TYPE RBHITTESTINFO
    pt    AS POINTAPI
    flags AS DWORD
    iBand AS LONG
END TYPE

#ENDIF



'==============================================================================
' TOOLTIPS CONTROL

#IF NOT %DEF(%NOTOOLTIPS)

$TOOLTIPS_CLASS         = "tooltips_class32"

' begin_r_commctrl

%TTS_ALWAYSTIP  = &H01
%TTS_NOPREFIX   = &H02
%TTS_NOANIMATE  = &H10
%TTS_NOFADE     = &H20
%TTS_BALLOON    = &H40

' end_r_commctrl

%TTF_IDISHWND      = &H0001

' Use this to center around trackpoint in trackmode
' -OR- to center around tool in normal mode.
' Use TTF_ABSOLUTE to place the tip exactly at the track coords when
' in tracking mode. TTF_ABSOLUTE can be used in conjunction with TTF_CENTERTIP
' to center the tip absolutely about the track point.

%TTF_CENTERTIP     = &H0002
%TTF_RTLREADING    = &H0004
%TTF_SUBCLASS      = &H0010
%TTF_TRACK         = &H0020
%TTF_ABSOLUTE      = &H0080
%TTF_TRANSPARENT   = &H0100
%TTF_DI_SETITEM    = &H8000  ' valid only on the TTN_NEEDTEXT callback

%TTDT_AUTOMATIC    = 0
%TTDT_RESHOW       = 1
%TTDT_AUTOPOP      = 2
%TTDT_INITIAL      = 3

' ToolTip Icons (Set with TTM_SETTITLE)
%TTI_NONE          = 0
%TTI_INFO          = 1
%TTI_WARNING       = 2
%TTI_ERROR         = 3

' Tool Tip Messages
%TTM_ACTIVATE      = %WM_USER +  1
%TTM_SETDELAYTIME  = %WM_USER +  3
%TTM_ADDTOOL       = %WM_USER +  4
%TTM_ADDTOOLW      = %WM_USER + 50
%TTM_DELTOOL       = %WM_USER +  5
%TTM_DELTOOLW      = %WM_USER + 51
%TTM_NEWTOOLRECT   = %WM_USER +  6
%TTM_NEWTOOLRECTW  = %WM_USER + 52
%TTM_RELAYEVENT    = %WM_USER +  7

%TTM_GETTOOLINFO   = %WM_USER +  8
%TTM_GETTOOLINFOW  = %WM_USER + 53

%TTM_SETTOOLINFO   = %WM_USER +  9
%TTM_SETTOOLINFOW  = %WM_USER + 54

%TTM_HITTEST         = %WM_USER + 10
%TTM_HITTESTW        = %WM_USER + 55
%TTM_GETTEXT         = %WM_USER + 11
%TTM_GETTEXTW        = %WM_USER + 56
%TTM_UPDATETIPTEXT   = %WM_USER + 12
%TTM_UPDATETIPTEXTW  = %WM_USER + 57
%TTM_GETTOOLCOUNT    = %WM_USER + 13
%TTM_ENUMTOOLS       = %WM_USER + 14
%TTM_ENUMTOOLSW      = %WM_USER + 58
%TTM_GETCURRENTTOOL  = %WM_USER + 15
%TTM_GETCURRENTTOOLW = %WM_USER + 59
%TTM_WINDOWFROMPOINT = %WM_USER + 16
%TTM_TRACKACTIVATE   = %WM_USER + 17
%TTM_TRACKPOSITION   = %WM_USER + 18
%TTM_SETTIPBKCOLOR   = %WM_USER + 19
%TTM_SETTIPTEXTCOLOR = %WM_USER + 20
%TTM_GETDELAYTIME    = %WM_USER + 21
%TTM_GETTIPBKCOLOR   = %WM_USER + 22
%TTM_GETTIPTEXTCOLOR = %WM_USER + 23
%TTM_SETMAXTIPWIDTH  = %WM_USER + 24
%TTM_GETMAXTIPWIDTH  = %WM_USER + 25
%TTM_SETMARGIN       = %WM_USER + 26
%TTM_GETMARGIN       = %WM_USER + 27
%TTM_POP             = %WM_USER + 28
%TTM_UPDATE          = %WM_USER + 29
%TTM_GETBUBBLESIZE   = %WM_USER + 30
%TTM_ADJUSTRECT      = %WM_USER + 31
%TTM_SETTITLE        = %WM_USER + 32  ' wParam = TTI_*, lParam = char* szTitle
%TTM_SETTITLEW       = %WM_USER + 33  ' wParam = TTI_*, lParam = wchar* szTitle

TYPE TT_HITTESTINFO
    hWnd  AS DWORD
    pt    AS POINTAPI
    ti    AS TOOLINFO
END TYPE

%TTN_GETDISPINFO     = (%TTN_FIRST - 0)
%TTN_GETDISPINFOW    = (%TTN_FIRST - 10)
%TTN_SHOW            = (%TTN_FIRST - 1)
%TTN_POP             = (%TTN_FIRST - 2)

%TTN_NEEDTEXT        = %TTN_GETDISPINFO
%TTN_NEEDTEXTW       = %TTN_GETDISPINFOW

TYPE NMTTDISPINFO
    hdr       AS NMHDR
    lpszText  AS ASCIIZ PTR
    szText    AS ASCIIZ * 80
    hInst     AS DWORD
    uFlags    AS DWORD
    lParam    AS DWORD
END TYPE

#ENDIF



'==============================================================================
' STATUS BAR CONTROL

#IF NOT %DEF(%NOSTATUSBAR)

' begin_r_commctrl

%SBARS_SIZEGRIP = &H0100
%SBARS_TOOLTIPS = &H0800

' end_r_commctrl

DECLARE SUB DrawStatusText LIB "COMCTL32.DLL" ALIAS "DrawStatusTextA" _
    (BYVAL hDc AS DWORD, lprec AS RECT, sztext AS ASCIIZ, _
    BYVAL uFlags AS DWORD)

DECLARE FUNCTION CreateStatusWindow LIB "COMCTL32.DLL" _
    ALIAS "CreateStatusWindowA" (BYVAL Style AS LONG, lpszText AS ASCIIZ, _
    BYVAL hWndParent AS DWORD, BYVAL wId AS DWORD) AS DWORD

$STATUSCLASSNAME = "msctls_statusbar32"

%SB_SETTEXT           = %WM_USER + 1
%SB_SETTEXTW          = %WM_USER + 11
%SB_GETTEXT           = %WM_USER + 2
%SB_GETTEXTW          = %WM_USER + 13
%SB_GETTEXTLENGTH     = %WM_USER + 3
%SB_GETTEXTLENGTHW    = %WM_USER + 12

%SB_SETPARTS          = %WM_USER + 4
%SB_GETPARTS          = %WM_USER + 6
%SB_GETBORDERS        = %WM_USER + 7
%SB_SETMINHEIGHT      = %WM_USER + 8
%SB_SIMPLE            = %WM_USER + 9
%SB_GETRECT           = %WM_USER + 10

%SB_ISSIMPLE          = %WM_USER + 14
%SB_SETICON           = %WM_USER + 15
%SB_SETTIPTEXT        = %WM_USER + 16
%SB_SETTIPTEXTW       = %WM_USER + 17
%SB_GETTIPTEXT        = %WM_USER + 18
%SB_GETTIPTEXTW       = %WM_USER + 19
%SB_GETICON           = %WM_USER + 20
%SB_SETUNICODEFORMAT  = %CCM_SETUNICODEFORMAT
%SB_GETUNICODEFORMAT  = %CCM_GETUNICODEFORMAT

%SBT_OWNERDRAW        = &H1000
%SBT_NOBORDERS        = &H0100
%SBT_POPOUT           = &H0200
%SBT_RTLREADING       = &H0400
%SBT_TOOLTIPS         = &H0800
%SBT_NOTABPARSING     = &H0800

%SB_SETBKCOLOR        = %CCM_SETBKCOLOR  ' lParam = bkColor

%SBN_SIMPLEMODECHANGE = %SBN_FIRST

' refers to the data saved for simple mode
%SB_SIMPLEID = &H00FF

#ENDIF



'==============================================================================
' MENU HELP

#IF NOT %DEF(%NOMENUHELP)

DECLARE SUB MenuHelp LIB "COMCTL32.DLL" ALIAS "MenuHelp" _
    (BYVAL uMsg AS DWORD, BYVAL wParam AS DWORD, BYVAL lParam AS LONG, _
    BYVAL hMainMenu AS DWORD, BYVAL hInst AS DWORD, _
    BYVAL hWndStatus AS DWORD, lpwIds AS DWORD)

DECLARE FUNCTION ShowHideMenuCtl LIB "COMCTL32.DLL" ALIAS "ShowHideMenuCtl" _
    (BYVAL hWnd AS DWORD, BYVAL uFlags AS DWORD, lpInfo AS LONG) AS LONG

DECLARE SUB GetEffectiveClientRect LIB "COMCTL32.DLL" _
    ALIAS "GetEffectiveClientRect" (BYVAL hWnd AS DWORD, lprc AS RECT, _
    lpInfo AS LONG)

%MINSYSCOMMAND  = %SC_SIZE

#ENDIF



'==============================================================================
' TRACKBAR CONTROL

#IF NOT %DEF(%NOTRACKBAR)

$TRACKBAR_CLASS         = "msctls_trackbar32"

' begin_r_commctrl

%TBS_AUTOTICKS          = &H0001
%TBS_VERT               = &H0002
%TBS_HORZ               = &H0000
%TBS_TOP                = &H0004
%TBS_BOTTOM             = &H0000
%TBS_LEFT               = &H0004
%TBS_RIGHT              = &H0000
%TBS_BOTH               = &H0008
%TBS_NOTICKS            = &H0010
%TBS_ENABLESELRANGE     = &H0020
%TBS_FIXEDLENGTH        = &H0040
%TBS_NOTHUMB            = &H0080
%TBS_TOOLTIPS           = &H0100
%TBS_REVERSED           = &H0200  ' Accessibility hint: the smaller number (usually the min value) means "high" and the larger number (usually the max value) means "low"

' end_r_commctrl

%TBM_GETPOS             = %WM_USER
%TBM_GETRANGEMIN        = %WM_USER + 1
%TBM_GETRANGEMAX        = %WM_USER + 2
%TBM_GETTIC             = %WM_USER + 3
%TBM_SETTIC             = %WM_USER + 4
%TBM_SETPOS             = %WM_USER + 5
%TBM_SETRANGE           = %WM_USER + 6
%TBM_SETRANGEMIN        = %WM_USER + 7
%TBM_SETRANGEMAX        = %WM_USER + 8
%TBM_CLEARTICS          = %WM_USER + 9
%TBM_SETSEL             = %WM_USER + 10
%TBM_SETSELSTART        = %WM_USER + 11
%TBM_SETSELEND          = %WM_USER + 12
%TBM_GETPTICS           = %WM_USER + 14
%TBM_GETTICPOS          = %WM_USER + 15
%TBM_GETNUMTICS         = %WM_USER + 16
%TBM_GETSELSTART        = %WM_USER + 17
%TBM_GETSELEND          = %WM_USER + 18
%TBM_CLEARSEL           = %WM_USER + 19
%TBM_SETTICFREQ         = %WM_USER + 20
%TBM_SETPAGESIZE        = %WM_USER + 21
%TBM_GETPAGESIZE        = %WM_USER + 22
%TBM_SETLINESIZE        = %WM_USER + 23
%TBM_GETLINESIZE        = %WM_USER + 24
%TBM_GETTHUMBRECT       = %WM_USER + 25
%TBM_GETCHANNELRECT     = %WM_USER + 26
%TBM_SETTHUMBLENGTH     = %WM_USER + 27
%TBM_GETTHUMBLENGTH     = %WM_USER + 28
%TBM_SETTOOLTIPS        = %WM_USER + 29
%TBM_GETTOOLTIPS        = %WM_USER + 30
%TBM_SETTIPSIDE         = %WM_USER + 31

' TrackBar Tip Side flags
%TBTS_TOP               = 0
%TBTS_LEFT              = 1
%TBTS_BOTTOM            = 2
%TBTS_RIGHT             = 3

%TBM_SETBUDDY           = %WM_USER + 32 ' wparam = BOOL fLeft; (or right)
%TBM_GETBUDDY           = %WM_USER + 33 ' wparam = BOOL fLeft; (or right)

%TBM_SETUNICODEFORMAT   = %CCM_SETUNICODEFORMAT
%TBM_GETUNICODEFORMAT   = %CCM_GETUNICODEFORMAT

%TB_LINEUP              = 0
%TB_LINEDOWN            = 1
%TB_PAGEUP              = 2
%TB_PAGEDOWN            = 3
%TB_THUMBPOSITION       = 4
%TB_THUMBTRACK          = 5
%TB_TOP                 = 6
%TB_BOTTOM              = 7
%TB_ENDTRACK            = 8

' custom draw item specs
%TBCD_TICS    = &H0001
%TBCD_THUMB   = &H0002
%TBCD_CHANNEL = &H0003

#ENDIF



'==============================================================================
' DRAG LIST CONTROL

#IF NOT %DEF(%NODRAGLIST)

TYPE DRAGLISTINFO
    uNotification AS DWORD
    hWnd          AS DWORD
    ptCursor      AS POINTAPI
END TYPE

%DL_BEGINDRAG  = %WM_USER + 133
%DL_DRAGGING   = %WM_USER + 134
%DL_DROPPED    = %WM_USER + 135
%DL_CANCELDRAG = %WM_USER + 136

%DL_CURSORSET  = 0
%DL_STOPCURSOR = 1
%DL_COPYCURSOR = 2
%DL_MOVECURSOR = 3

$DRAGLISTMSGSTRING = "commctrl_DragListMsg"

DECLARE FUNCTION MakeDragList LIB "COMCTL32.DLL" ALIAS "MakeDragList" _
    (BYVAL hLB AS DWORD) AS LONG

DECLARE SUB DrawInsert LIB "COMCTL32.DLL" ALIAS "DrawInsert" _
    (BYVAL handParent AS DWORD, BYVAL hLB AS DWORD, BYVAL nItem AS LONG)

DECLARE FUNCTION LBItemFromPt LIB "COMCTL32.DLL" ALIAS "LBItemFromPt" _
    (BYVAL hLB AS DWORD, pt AS POINTAPI, BYVAL bAutoScroll AS LONG) AS LONG

#ENDIF



'==============================================================================
' UPDOWN CONTROL

#IF NOT %DEF(%NOUPDOWN)

$UPDOWN_CLASS = "msctls_updown32"

TYPE UDACCEL
    nSec AS DWORD
    nInc AS DWORD
END TYPE

%UD_MAXVAL            = &H7FFF
%UD_MINVAL            = - %UD_MAXVAL

%UDS_WRAP             = &H0001
%UDS_SETBUDDYINT      = &H0002
%UDS_ALIGNRIGHT       = &H0004
%UDS_ALIGNLEFT        = &H0008
%UDS_AUTOBUDDY        = &H0010
%UDS_ARROWKEYS        = &H0020
%UDS_HORZ             = &H0040
%UDS_NOTHOUSANDS      = &H0080
%UDS_HOTTRACK         = &H0100

%UDM_SETRANGE         = %WM_USER + 101
%UDM_GETRANGE         = %WM_USER + 102
%UDM_SETPOS           = %WM_USER + 103
%UDM_GETPOS           = %WM_USER + 104
%UDM_SETBUDDY         = %WM_USER + 105
%UDM_GETBUDDY         = %WM_USER + 106
%UDM_SETACCEL         = %WM_USER + 107
%UDM_GETACCEL         = %WM_USER + 108
%UDM_SETBASE          = %WM_USER + 109
%UDM_GETBASE          = %WM_USER + 110
%UDM_SETRANGE32       = %WM_USER + 111
%UDM_GETRANGE32       = %WM_USER + 112 ' wParam & lParam are LPINT
%UDM_SETUNICODEFORMAT = %CCM_SETUNICODEFORMAT
%UDM_GETUNICODEFORMAT = %CCM_GETUNICODEFORMAT
%UDM_SETPOS32         = %WM_USER + 113
%UDM_GETPOS32         = %WM_USER + 114

DECLARE FUNCTION CreateUpDownControl LIB "COMCTL32.DLL" _
    ALIAS "CreateUpDownControl" (BYVAL dwStyle AS DWORD, BYVAL x AS LONG, _
    BYVAL y AS LONG, BYVAL cx AS LONG, BYVAL cy AS LONG, _
    BYVAL hParent AS DWORD, BYVAL nID AS LONG, BYVAL hInst AS DWORD, _
    BYVAL hBuddy AS DWORD, BYVAL nUpper AS LONG, BYVAL nLower AS LONG, _
    BYVAL nPos AS LONG) AS DWORD

TYPE NM_UPDOWN
    hdr    AS NMHDR
    iPos   AS LONG
    iDelta AS LONG
END TYPE

TYPE NMUPDOWN
    hdr    AS NMHDR
    iPos   AS LONG
    iDelta AS LONG
END TYPE

%UDN_DELTAPOS = %UDN_FIRST - 1

#ENDIF



'==============================================================================
' PROGRESS CONTROL

#IF NOT %DEF(%NOPROGRESS)

$PROGRESS_CLASS = "msctls_progress32"

' begin_r_commctrl

%PBS_SMOOTH     = &H01
%PBS_VERTICAL   = &H04

' end_r_commctrl

%PBM_SETRANGE    = %WM_USER + 1
%PBM_SETPOS      = %WM_USER + 2
%PBM_DELTAPOS    = %WM_USER + 3
%PBM_SETSTEP     = %WM_USER + 4
%PBM_STEPIT      = %WM_USER + 5
%PBM_SETRANGE32  = %WM_USER + 6  ' lParam = high, wParam = low

TYPE PBRANGE
    iLow AS LONG
    iHigh AS LONG
END TYPE

%PBM_GETRANGE    = %WM_USER + 7     ' wParam = return (TRUE ? low : high). lParam = PPBRANGE or NULL
%PBM_SETBKCOLOR  = %CCM_SETBKCOLOR  ' lParam = bkColor
%PBM_SETBARCOLOR = %WM_USER + 9     ' lParam = bar color

#ENDIF



'==============================================================================
' HOTKEY CONTROL

#IF NOT %DEF(%NOHOTKEY)

%HOTKEYF_SHIFT   = &H01
%HOTKEYF_CONTROL = &H02
%HOTKEYF_ALT     = &H04
%HOTKEYF_EXT     = &H08

%HKCOMB_NONE     = &H0001
%HKCOMB_S        = &H0002
%HKCOMB_C        = &H0004
%HKCOMB_A        = &H0008
%HKCOMB_SC       = &H0010
%HKCOMB_SA       = &H0020
%HKCOMB_CA       = &H0040
%HKCOMB_SCA      = &H0080

%HKM_SETHOTKEY   = %WM_USER + 1
%HKM_GETHOTKEY   = %WM_USER + 2
%HKM_SETRULES    = %WM_USER + 3

$HOTKEY_CLASS    = "msctls_hotkey32"

#ENDIF



'==============================================================================
' COMMON CONTROL STYLES

' begin_r_commctrl

%CCS_TOP           = &H00000001&
%CCS_NOMOVEY       = &H00000002&
%CCS_BOTTOM        = &H00000003&
%CCS_NORESIZE      = &H00000004&
%CCS_NOPARENTALIGN = &H00000008&
%CCS_ADJUSTABLE    = &H00000020&
%CCS_NODIVIDER     = &H00000040&
%CCS_VERT          = &H00000080&
%CCS_LEFT          = %CCS_VERT OR %CCS_TOP
%CCS_RIGHT         = %CCS_VERT OR %CCS_BOTTOM
%CCS_NOMOVEX       = %CCS_VERT OR %CCS_NOMOVEY

' end_r_commctrl



'==============================================================================
' LISTVIEW CONTROL

#IF NOT %DEF(%NOLISTVIEW)

$WC_LISTVIEW = "SysListView32"

' begin_r_commctrl

%LVS_ICON            = &H00000000
%LVS_REPORT          = &H00000001
%LVS_SMALLICON       = &H00000002
%LVS_LIST            = &H00000003
%LVS_TYPEMASK        = &H00000003
%LVS_SINGLESEL       = &H00000004
%LVS_SHOWSELALWAYS   = &H00000008
%LVS_SORTASCENDING   = &H00000010
%LVS_SORTDESCENDING  = &H00000020
%LVS_SHAREIMAGELISTS = &H00000040
%LVS_NOLABELWRAP     = &H00000080
%LVS_AUTOARRANGE     = &H00000100
%LVS_EDITLABELS      = &H00000200
%LVS_OWNERDATA       = &H00001000
%LVS_NOSCROLL        = &H00002000

%LVS_TYPESTYLEMASK   = &H0000FC00

%LVS_ALIGNTOP        = &H00000000
%LVS_ALIGNLEFT       = &H00000800
%LVS_ALIGNMASK       = &H00000C00

%LVS_OWNERDRAWFIXED  = &H00000400
%LVS_NOCOLUMNHEADER  = &H00004000
%LVS_NOSORTHEADER    = &H00008000

' end_r_commctrl

%LVM_SETUNICODEFORMAT   = %CCM_SETUNICODEFORMAT

FUNCTION ListView_SetUnicodeFormat (BYVAL hwnd AS DWORD, _
   BYVAL fUnicode AS LONG) AS LONG
    FUNCTION = SendMessage(hwnd, %LVM_SETUNICODEFORMAT, fUnicode, 0)
END FUNCTION

%LVM_GETUNICODEFORMAT   = %CCM_GETUNICODEFORMAT

FUNCTION ListView_GetUnicodeFormat (BYVAL hwnd AS DWORD) AS LONG
    FUNCTION = SendMessage(hwnd, %LVM_GETUNICODEFORMAT, 0, 0)
END FUNCTION

%LVM_GETBKCOLOR         = %LVM_FIRST + 0

FUNCTION ListView_GetBkColor (BYVAL hWnd AS DWORD) AS DWORD
    FUNCTION = SendMessage(hWnd, %LVM_GETBKCOLOR, 0, 0)
END FUNCTION

%LVM_SETBKCOLOR         = %LVM_FIRST + 1

FUNCTION ListView_SetBkColor (BYVAL hWnd AS DWORD, clrBk AS DWORD) AS LONG
    FUNCTION = SendMessage(hWnd, %LVM_SETBKCOLOR, 0, VARPTR(clrBk))
END FUNCTION

%LVM_GETIMAGELIST       = %LVM_FIRST + 2

FUNCTION ListView_GetImageList (BYVAL hWnd AS DWORD, _
   BYVAL iImageList AS LONG) AS DWORD
    FUNCTION = SendMessage(hWnd, %LVM_GETIMAGELIST, iImageList, 0)
END FUNCTION

%LVSIL_NORMAL           = 0
%LVSIL_SMALL            = 1
%LVSIL_STATE            = 2

%LVM_SETIMAGELIST       = %LVM_FIRST + 3

FUNCTION ListView_SetImageList (BYVAL hWnd AS DWORD, BYVAL himl AS DWORD, _
   BYVAL iImageList AS LONG) AS DWORD
    FUNCTION = SendMessage(hWnd, %LVM_SETIMAGELIST, iImageList, himl)
END FUNCTION

%LVM_GETITEMCOUNT       = %LVM_FIRST + 4

FUNCTION ListView_GetItemCount (BYVAL hWnd AS DWORD) AS LONG
    FUNCTION = SendMessage(hWnd, %LVM_GETITEMCOUNT, 0, 0)
END FUNCTION

%LVIF_TEXT              = &H0001
%LVIF_IMAGE             = &H0002
%LVIF_PARAM             = &H0004
%LVIF_STATE             = &H0008
%LVIF_INDENT            = &H0010
%LVIF_NORECOMPUTE       = &H0800

%LVIS_FOCUSED           = &H0001
%LVIS_SELECTED          = &H0002
%LVIS_CUT               = &H0004
%LVIS_DROPHILITED       = &H0008
%LVIS_ACTIVATING        = &H0020

%LVIS_OVERLAYMASK       = &H0F00
%LVIS_STATEIMAGEMASK    = &HF000

#IF NOT %DEF(%ITSIM)
    %ITSIM = 1
    FUNCTION IndexToStateImageMask (BYVAL i AS LONG) AS LONG
        SHIFT LEFT i, 12
        FUNCTION = i
    END FUNCTION
#ENDIF

TYPE LV_ITEM
    mask       AS DWORD
    iItem      AS LONG
    iSubItem   AS LONG
    STATE      AS DWORD
    stateMask  AS DWORD
    pszText    AS ASCIIZ PTR
    cchTextMax AS LONG
    iImage     AS LONG
    lParam     AS LONG
    iIndent    AS LONG
END TYPE

TYPE LVITEM
    mask       AS DWORD
    iItem      AS LONG
    iSubItem   AS LONG
    STATE      AS DWORD
    stateMask  AS DWORD
    pszText    AS ASCIIZ PTR
    cchTextMax AS LONG
    iImage     AS LONG
    lParam     AS LONG
    iIndent    AS LONG
END TYPE

%LPSTR_TEXTCALLBACKW    = -1&
%LPSTR_TEXTCALLBACK     = -1&

%I_IMAGECALLBACK        = -1
%I_IMAGENONE            = -2

%LVM_GETITEM            = %LVM_FIRST + 5
%LVM_GETITEMW           = %LVM_FIRST + 75

FUNCTION ListView_GetItem (BYVAL hWnd AS DWORD, pitem AS LV_ITEM) AS LONG
    FUNCTION = SendMessage(hWnd, %LVM_GETITEM, 0, VARPTR(pitem))
END FUNCTION

%LVM_SETITEM            = %LVM_FIRST + 6
%LVM_SETITEMW           = %LVM_FIRST + 76

FUNCTION ListView_SetItem (BYVAL hWnd AS DWORD, pitem AS LV_ITEM) AS LONG
    FUNCTION = SendMessage(hWnd, %LVM_SETITEM, 0, VARPTR(pitem))
END FUNCTION

%LVM_INSERTITEM         = %LVM_FIRST + 7
%LVM_INSERTITEMW        = %LVM_FIRST + 77

FUNCTION ListView_InsertItem (BYVAL hWnd AS LONG, pitem AS LV_ITEM) AS LONG
    FUNCTION = SendMessage(hWnd, %LVM_INSERTITEM, 0, VARPTR(pitem))
END FUNCTION

%LVM_DELETEITEM         = %LVM_FIRST + 8

FUNCTION ListView_DeleteItem (BYVAL hWnd AS DWORD, BYVAL i AS LONG) AS LONG
    FUNCTION = SendMessage(hWnd, %LVM_DELETEITEM, i, 0)
END FUNCTION

%LVM_DELETEALLITEMS     = %LVM_FIRST + 9

FUNCTION ListView_DeleteAllItems (BYVAL hWnd AS DWORD) AS LONG
    FUNCTION = SendMessage(hWnd, %LVM_DELETEALLITEMS, 0, 0)
END FUNCTION

%LVM_GETCALLBACKMASK    = %LVM_FIRST + 10

FUNCTION ListView_GetCallbackMask (BYVAL hWnd AS DWORD) AS LONG
    FUNCTION = SendMessage(hWnd, %LVM_GETCALLBACKMASK, 0, 0)
END FUNCTION

%LVM_SETCALLBACKMASK    = %LVM_FIRST + 11

FUNCTION ListView_SetCallbackMask (BYVAL hWnd AS DWORD, BYVAL mask AS DWORD) _
   AS LONG
    FUNCTION = SendMessage(hWnd, %LVM_SETCALLBACKMASK, mask, 0)
END FUNCTION

%LVNI_ALL               = &H0000
%LVNI_FOCUSED           = &H0001
%LVNI_SELECTED          = &H0002
%LVNI_CUT               = &H0004
%LVNI_DROPHILITED       = &H0008

%LVNI_ABOVE             = &H0100
%LVNI_BELOW             = &H0200
%LVNI_TOLEFT            = &H0400
%LVNI_TORIGHT           = &H0800

%LVM_GETNEXTITEM        = %LVM_FIRST + 12

FUNCTION ListView_GetNextItem (BYVAL hWnd AS LONG, BYVAL i AS LONG, _
   BYVAL flags AS LONG) AS LONG
    FUNCTION = SendMessage(hWnd, %LVM_GETNEXTITEM, i, MAKLNG(flags, 0))
END FUNCTION

%LVFI_PARAM             = &H0001
%LVFI_STRING            = &H0002
%LVFI_PARTIAL           = &H0008
%LVFI_WRAP              = &H0020
%LVFI_NEARESTXY         = &H0040

TYPE LV_FINDINFO
    flags AS DWORD
    psz AS ASCIIZ PTR
    lParam AS LONG
    pt AS POINTAPI
    vkDirection AS DWORD
END TYPE

TYPE LVFINDINFO
    flags AS DWORD
    psz AS ASCIIZ PTR
    lParam AS LONG
    pt AS POINTAPI
    vkDirection AS DWORD
END TYPE

%LVM_FINDITEM           = %LVM_FIRST + 13
%LVM_FINDITEMW          = %LVM_FIRST + 83

FUNCTION ListView_FindItem (BYVAL hWnd AS DWORD, BYVAL iStart AS LONG, _
   plvfi AS LV_FINDINFO) AS LONG
    FUNCTION = SendMessage(hWnd, %LVM_FINDITEM, iStart, VARPTR(plvfi))
END FUNCTION

%LVIR_BOUNDS            = 0
%LVIR_ICON              = 1
%LVIR_LABEL             = 2
%LVIR_SELECTBOUNDS      = 3

%LVM_GETITEMRECT        = %LVM_FIRST + 14

FUNCTION ListView_GetItemRect (BYVAL hWnd AS DWORD, BYVAL i AS LONG, _
   prc AS RECT, BYVAL code AS LONG) AS LONG
    IF prc.nLeft = code THEN
        FUNCTION = SendMessage(hWnd, %LVM_GETITEMRECT, i, VARPTR(prc))
    ELSE
        FUNCTION = SendMessage(hWnd, %LVM_GETITEMRECT, i, %NULL)
    END IF
END FUNCTION

%LVM_SETITEMPOSITION    = %LVM_FIRST + 15

FUNCTION ListView_SetItemPosition (BYVAL hWndLV AS DWORD, BYVAL i AS LONG, _
   BYVAL x AS INTEGER, BYVAL y AS INTEGER) AS LONG
    FUNCTION = SendMessage(hWndLV, %LVM_SETITEMPOSITION, i, MAKLNG(x, y))
END FUNCTION

%LVM_GETITEMPOSITION    = %LVM_FIRST + 16

FUNCTION ListView_GetItemPosition (BYVAL hWndLV AS DWORD, BYVAL i AS LONG, _
   pt AS POINTAPI) AS LONG
    FUNCTION = SendMessage(hWndLV, %LVM_GETITEMPOSITION, i, VARPTR(pt))
END FUNCTION

%LVM_GETSTRINGWIDTH     = %LVM_FIRST + 17
%LVM_GETSTRINGWIDTHW    = %LVM_FIRST + 87

FUNCTION ListView_GetStringWidth (BYVAL hWndLV AS DWORD, psz AS ASCIIZ) AS LONG
    FUNCTION = SendMessage(hWndLV, %LVM_GETSTRINGWIDTH, 0, VARPTR(psz))
END FUNCTION

%LVHT_NOWHERE           = &H0001
%LVHT_ONITEMICON        = &H0002
%LVHT_ONITEMLABEL       = &H0004
%LVHT_ONITEMSTATEICON   = &H0008
%LVHT_ONITEM            = (%LVHT_ONITEMICON OR %LVHT_ONITEMLABEL OR %LVHT_ONITEMSTATEICON)

%LVHT_ABOVE             = &H0008
%LVHT_BELOW             = &H0010
%LVHT_TORIGHT           = &H0020
%LVHT_TOLEFT            = &H0040

TYPE LV_HITTESTINFO
    pt AS POINTAPI
    flags AS DWORD
    iItem AS LONG
END TYPE

TYPE LVHITTESTINFO
    pt AS POINTAPI
    flags AS DWORD
    iItem AS LONG
    iSubItem AS LONG
END TYPE

%LVM_HITTEST            = %LVM_FIRST + 18

FUNCTION ListView_HitTest (BYVAL hWndLV AS DWORD, pinfo AS LV_HITTESTINFO) _
   AS LONG
    FUNCTION = SendMessage(hWndLV, %LVM_HITTEST, 0, VARPTR(pinfo))
END FUNCTION

%LVM_ENSUREVISIBLE      = %LVM_FIRST + 19

FUNCTION ListView_EnsureVisible (BYVAL hWndLV AS DWORD, BYVAL i AS LONG, _
   BYVAL fPartialOK AS INTEGER) AS LONG
    FUNCTION = SendMessage(hWndLV, %LVM_ENSUREVISIBLE, i, MAKLNG(fPartialOK, 0))
END FUNCTION

%LVM_SCROLL             = %LVM_FIRST + 20

FUNCTION ListView_Scroll (BYVAL hWndLV AS DWORD, dx AS LONG, _
   BYVAL dy AS LONG) AS LONG
    FUNCTION = SendMessage(hWndLV, %LVM_SCROLL, dx, dy)
END FUNCTION

%LVM_REDRAWITEMS        = %LVM_FIRST + 21

FUNCTION ListView_RedrawItems (BYVAL hWndLV AS DWORD, BYVAL iFirst AS LONG, _
   BYVAL iLast AS LONG) AS LONG
    FUNCTION = SendMessage(hWndLV, %LVM_REDRAWITEMS, iFirst, iLast)
END FUNCTION

%LVA_DEFAULT            = &H0000
%LVA_ALIGNLEFT          = &H0001
%LVA_ALIGNTOP           = &H0002
%LVA_SNAPTOGRID         = &H0005

%LVM_ARRANGE            = %LVM_FIRST + 22

FUNCTION ListView_Arrange (BYVAL hWndLV AS DWORD, BYVAL code AS LONG) AS LONG
    FUNCTION = SendMessage(hWndLV, %LVM_ARRANGE, code, 0)
END FUNCTION

%LVM_EDITLABEL          = %LVM_FIRST + 23
%LVM_EDITLABELW         = %LVM_FIRST + 118

FUNCTION ListView_EditLabel (BYVAL hWndLV AS DWORD, BYVAL i AS LONG) AS DWORD
    FUNCTION = SendMessage(hWndLV, %LVM_EDITLABEL, i, 0)
END FUNCTION

%LVM_GETEDITCONTROL     = %LVM_FIRST + 24

FUNCTION ListView_GetEditControl (BYVAL hWndLV AS DWORD) AS DWORD
    FUNCTION = SendMessage(hWndLV, %LVM_GETEDITCONTROL, 0, 0)
END FUNCTION

TYPE LV_COLUMN
    mask AS DWORD
    fmt AS LONG
    cx AS LONG
    pszText AS ASCIIZ PTR
    cchTextMax AS LONG
    iSubItem AS LONG
    iImage AS LONG
    iOrder AS LONG
END TYPE

TYPE LVCOLUMN
    mask AS DWORD
    fmt AS LONG
    cx AS LONG
    pszText AS ASCIIZ PTR
    cchTextMax AS LONG
    iSubItem AS LONG
    iImage AS LONG
    iOrder AS LONG
END TYPE

%LVCF_FMT               = &H0001
%LVCF_WIDTH             = &H0002
%LVCF_TEXT              = &H0004
%LVCF_SUBITEM           = &H0008
%LVCF_IMAGE             = &H0010
%LVCF_ORDER             = &H0020

%LVCFMT_LEFT            = &H0000
%LVCFMT_RIGHT           = &H0001
%LVCFMT_CENTER          = &H0002
%LVCFMT_JUSTIFYMASK     = &H0003
%LVCFMT_IMAGE           = &H0800
%LVCFMT_BITMAP_ON_RIGHT = &H1000
%LVCFMT_COL_HAS_IMAGES  = &H8000

%LVM_GETCOLUMN          = %LVM_FIRST + 25
%LVM_GETCOLUMNW         = %LVM_FIRST + 95

FUNCTION ListView_GetColumn (BYVAL hWnd AS DWORD, BYVAL iCol AS LONG, _
   pcol AS LV_COLUMN) AS LONG
    FUNCTION = SendMessage(hWnd, %LVM_GETCOLUMN, iCol, VARPTR(pcol))
END FUNCTION

%LVM_SETCOLUMN          = %LVM_FIRST + 26
%LVM_SETCOLUMNW         = %LVM_FIRST + 96

FUNCTION ListView_SetColumn (BYVAL hWnd AS DWORD, BYVAL iCol AS LONG, _
   pcol AS LV_COLUMN) AS LONG
    FUNCTION = SendMessage(hWnd, %LVM_SETCOLUMN, iCol, VARPTR(pcol))
END FUNCTION

%LVM_INSERTCOLUMN       = %LVM_FIRST + 27
%LVM_INSERTCOLUMNW      = %LVM_FIRST + 97

FUNCTION ListView_InsertColumn (BYVAL hWnd AS DWORD, BYVAL iCol AS LONG, _
   pcol AS LV_COLUMN) AS LONG
    FUNCTION = SendMessage(hWnd, %LVM_INSERTCOLUMN, iCol, VARPTR(pcol))
END FUNCTION

%LVM_DELETECOLUMN       = %LVM_FIRST + 28

FUNCTION ListView_DeleteColumn (BYVAL hWnd AS DWORD, BYVAL iCol AS LONG) AS LONG
    FUNCTION = SendMessage(hWnd, %LVM_DELETECOLUMN, iCol, 0)
END FUNCTION

%LVM_GETCOLUMNWIDTH     = %LVM_FIRST + 29

FUNCTION ListView_GetColumnWidth (BYVAL hWnd AS DWORD, iCol AS LONG) AS LONG
    FUNCTION = SendMessage(hWnd, %LVM_GETCOLUMNWIDTH, iCol, 0)
END FUNCTION

%LVSCW_AUTOSIZE             = -1
%LVSCW_AUTOSIZE_USEHEADER   = -2
%LVM_SETCOLUMNWIDTH         = %LVM_FIRST + 30

FUNCTION ListView_SetColumnWidth (BYVAL hWnd AS DWORD, BYVAL iCol AS LONG, _
   BYVAL cx AS INTEGER) AS LONG
    FUNCTION = SendMessage(hWnd, %LVM_SETCOLUMNWIDTH, iCol, MAKLNG(cx, 0))
END FUNCTION

%LVM_GETHEADER          = %LVM_FIRST + 31

FUNCTION ListView_GetHeader (BYVAL hwnd AS DWORD) AS DWORD
    FUNCTION = SendMessage(hwnd, %LVM_GETHEADER, 0, 0)
END FUNCTION

%LVM_CREATEDRAGIMAGE    = %LVM_FIRST + 33

FUNCTION ListView_CreateDragImage (BYVAL hWnd AS DWORD, BYVAL i AS LONG, _
   lpptUpLeft AS POINTAPI) AS LONG
     FUNCTION = SendMessage(hWnd, %LVM_CREATEDRAGIMAGE, i, VARPTR(lpptUpLeft))
END FUNCTION

%LVM_GETVIEWRECT        = %LVM_FIRST + 34

FUNCTION ListView_GetViewRect (BYVAL hWnd AS DWORD, prc AS RECT) AS LONG
  FUNCTION = SendMessage(hWnd, %LVM_GETVIEWRECT, 0, VARPTR(prc))
END FUNCTION

%LVM_GETTEXTCOLOR       = %LVM_FIRST + 35

FUNCTION ListView_GetTextColor (BYVAL hWnd AS DWORD) AS DWORD
    FUNCTION = SendMessage(hWnd, %LVM_GETTEXTCOLOR, 0, 0)
END FUNCTION

%LVM_SETTEXTCOLOR       = (%LVM_FIRST + 36)

FUNCTION ListView_SetTextColor (BYVAL hWnd AS DWORD, BYVAL clrText AS LONG) _
   AS LONG
    FUNCTION = SendMessage(hWnd, %LVM_SETTEXTCOLOR, 0, clrText)
END FUNCTION

%LVM_GETTEXTBKCOLOR     = %LVM_FIRST + 37

FUNCTION ListView_GetTextBkColor (BYVAL hWnd AS DWORD) AS DWORD
    FUNCTION = SendMessage(hWnd, %LVM_GETTEXTBKCOLOR, 0, 0)
END FUNCTION

%LVM_SETTEXTBKCOLOR     = %LVM_FIRST + 38

FUNCTION ListView_SetTextBkColor (BYVAL hWnd AS DWORD, _
   BYVAL clrTextBk AS LONG) AS LONG
    FUNCTION = SendMessage(hWnd, %LVM_SETTEXTBKCOLOR, 0, clrTextBk)
END FUNCTION

%LVM_GETTOPINDEX        = %LVM_FIRST + 39

FUNCTION ListView_GetTopIndex (BYVAL hWndLV AS DWORD) AS LONG
    FUNCTION = SendMessage(hWndLV, %LVM_GETTOPINDEX, 0, 0)
END FUNCTION

%LVM_GETCOUNTPERPAGE    = %LVM_FIRST + 40

FUNCTION ListView_GetCountPerPage (BYVAL hWndLV AS DWORD) AS LONG
    FUNCTION = SendMessage(hWndLV, %LVM_GETCOUNTPERPAGE, 0, 0)
END FUNCTION

%LVM_GETORIGIN          = %LVM_FIRST + 41

FUNCTION ListView_GetOrigin (BYVAL hWndLV AS DWORD, pt AS POINTAPI) AS LONG
    FUNCTION = SendMessage(hWndLV, %LVM_GETORIGIN, 0, VARPTR(pt))
END FUNCTION

%LVM_UPDATE             = %LVM_FIRST + 42

FUNCTION ListView_Update (BYVAL hWndLV AS DWORD, BYVAL i AS LONG) AS LONG
  FUNCTION = SendMessage(hWndLV, %LVM_UPDATE, i, 0)
END FUNCTION

%LVM_SETITEMSTATE       = %LVM_FIRST + 43

SUB ListView_SetItemState (BYVAL hWndLV AS DWORD, BYVAL i AS LONG, _
   BYVAL nData AS DWORD, BYVAL mask AS DWORD)
    LOCAL ms_lvi AS LV_ITEM
    ms_lvi.stateMask = mask
    ms_lvi.state = nData
    SendMessage hWndLV, %LVM_SETITEMSTATE, i, VARPTR(ms_lvi)
END SUB

SUB ListView_SetCheckState (BYVAL hWndLV AS DWORD, BYVAL i AS LONG, _
   BYVAL fCheck AS LONG)
    ListView_SetItemState hWndLV, i, _
        INDEXTOSTATEIMAGEMASK(1 - (ISTRUE fCheck)), %LVIS_STATEIMAGEMASK
END SUB

%LVM_GETITEMSTATE       = %LVM_FIRST + 44

FUNCTION ListView_GetItemState (BYVAL hWndLV AS DWORD, BYVAL i AS LONG, _
   BYVAL mask AS LONG) AS DWORD
    FUNCTION = SendMessage(hWndLV, %LVM_GETITEMSTATE, i, mask)
END FUNCTION

FUNCTION ListView_GetCheckState (BYVAL hwndLV AS DWORD, BYVAL i AS LONG) _
   AS DWORD
    LOCAL nCheck AS LONG
    nCheck = SendMessage(hwndLV, %LVM_GETITEMSTATE, i, %LVIS_STATEIMAGEMASK)
    FUNCTION = BIT(nCheck, 12) - 1
END FUNCTION

%LVM_GETITEMTEXT        = (%LVM_FIRST + 45)
%LVM_GETITEMTEXTW       = (%LVM_FIRST + 115)

SUB ListView_GetItemText (BYVAL hWndLV AS DWORD, BYVAL i AS LONG, _
   BYVAL iSubItem AS LONG, pszText AS ASCIIZ, BYVAL cchTextMax AS LONG)
    LOCAL ms_lvi AS LV_ITEM
    ms_lvi.iSubItem = iSubItem
    ms_lvi.cchTextMax = cchTextMax
    ms_lvi.pszText = VARPTR(pszText)
    SendMessage hWndLV, %LVM_GETITEMTEXT, i, VARPTR(ms_lvi)
END SUB

%LVM_SETITEMTEXT        = %LVM_FIRST + 46
%LVM_SETITEMTEXTW       = %LVM_FIRST + 116

SUB ListView_SetItemText (BYVAL hWndLV AS DWORD, BYVAL i AS LONG, _
   BYVAL iSubItem AS LONG, pszText AS ASCIIZ)
    LOCAL ms_lvi AS LV_ITEM
    ms_lvi.iSubItem = iSubItem
    ms_lvi.pszText = VARPTR(pszText)
    SendMessage hWndLV, %LVM_SETITEMTEXT, i, VARPTR(ms_lvi)
END SUB

' these flags only apply to LVS_OWNERDATA listviews in report or list mode
%LVSICF_NOINVALIDATEALL  = &H00000001
%LVSICF_NOSCROLL         = &H00000002

%LVM_SETITEMCOUNT       = %LVM_FIRST + 47

SUB ListView_SetItemCount (BYVAL hwndLV AS DWORD, BYVAL cItems AS DWORD)
    SendMessage hwndLV, %LVM_SETITEMCOUNT, cItems, 0
END SUB

%LVM_SORTITEMS          = %LVM_FIRST + 48

SUB ListView_SetItemCountEx (BYVAL hwndLV AS DWORD, BYVAL cItems AS DWORD, _
   BYVAL dwFlags AS LONG)
    SendMessage hwndLV, %LVM_SETITEMCOUNT, cItems, dwFlags
END SUB

FUNCTION ListView_SortItems (BYVAL hWndLV AS DWORD, _
   BYVAL pfnCompare AS DWORD, BYVAL lPrm AS LONG) AS LONG
    FUNCTION = SendMessage(hWndLV, %LVM_SORTITEMS, lPrm, pfnCompare)
END FUNCTION

%LVM_SETITEMPOSITION32  = %LVM_FIRST + 49

SUB ListView_SetItemPosition32 (BYVAL hWndLV AS DWORD, BYVAL i AS LONG, _
   BYVAL x AS LONG, BYVAL y AS LONG)
    LOCAL ptNewPos AS POINTAPI
    ptNewPos.x = x
    ptNewPos.y = y
    SendMessage  hWndLV, %LVM_SETITEMPOSITION32, i, VARPTR(ptNewPos)
END SUB

%LVM_GETSELECTEDCOUNT   = %LVM_FIRST + 50

FUNCTION ListView_GetSelectedCount (BYVAL hWndLV AS DWORD) AS DWORD
    FUNCTION = SendMessage(hWndLV, %LVM_GETSELECTEDCOUNT, 0, 0)
END FUNCTION

%LVM_GETITEMSPACING     = %LVM_FIRST + 51

FUNCTION ListView_GetItemSpacing (BYVAL hWndLV AS DWORD, _
   BYVAL fSmall AS LONG) AS DWORD
    FUNCTION = SendMessage(hWndLV, %LVM_GETITEMSPACING, fSmall, 0)
END FUNCTION

%LVM_GETISEARCHSTRING   = %LVM_FIRST + 52
%LVM_GETISEARCHSTRINGW  = %LVM_FIRST + 117

FUNCTION ListView_GetISearchString (BYVAL hWndLV AS DWORD, lpsz AS ASCIIZ) _
   AS LONG
    FUNCTION = SendMessage(hWndLV, %LVM_GETISEARCHSTRING, 0, VARPTR(lpsz))
END FUNCTION

%LVM_SETICONSPACING     = %LVM_FIRST + 53

' -1 for cx and cy means we'll use the default (system settings)
' 0 for cx or cy means use the current setting (allows you to change just one param)

FUNCTION ListView_SetIconSpacing (BYVAL hwndLV AS DWORD, BYVAL cx AS INTEGER, _
   BYVAL cy AS INTEGER) AS DWORD
    FUNCTION = SendMessage(hwndLV, %LVM_SETICONSPACING, 0, MAKLNG(cx, cy))
END FUNCTION

%LVM_SETEXTENDEDLISTVIEWSTYLE = %LVM_FIRST + 54  ' optional wParam == mask

FUNCTION ListView_SetExtendedListViewStyle (BYVAL hwndLV AS DWORD, _
   BYVAL dw AS DWORD) AS DWORD
    FUNCTION = SendMessage(hwndLV, %LVM_SETEXTENDEDLISTVIEWSTYLE, 0, dw)
END FUNCTION

FUNCTION ListView_SetExtendedListViewStyleEx (BYVAL hwndLV AS DWORD, _
   BYVAL dwMask AS DWORD, BYVAL dw AS DWORD) AS DWORD
    FUNCTION = SendMessage(hwndLV, %LVM_SETEXTENDEDLISTVIEWSTYLE, dwMask, dw)
END FUNCTION

%LVM_GETEXTENDEDLISTVIEWSTYLE = %LVM_FIRST + 55

FUNCTION ListView_GetExtendedListViewStyle (BYVAL hwndLV AS DWORD) AS DWORD
    FUNCTION = SendMessage(hwndLV, %LVM_GETEXTENDEDLISTVIEWSTYLE, 0, 0)
END FUNCTION

%LVS_EX_GRIDLINES        = &H00000001
%LVS_EX_SUBITEMIMAGES    = &H00000002
%LVS_EX_CHECKBOXES       = &H00000004
%LVS_EX_TRACKSELECT      = &H00000008
%LVS_EX_HEADERDRAGDROP   = &H00000010
%LVS_EX_FULLROWSELECT    = &H00000020 ' applies to report mode only
%LVS_EX_ONECLICKACTIVATE = &H00000040
%LVS_EX_TWOCLICKACTIVATE = &H00000080
%LVS_EX_FLATSB           = &H00000100
%LVS_EX_REGIONAL         = &H00000200
%LVS_EX_INFOTIP          = &H00000400 ' listview does InfoTips for you
%LVS_EX_UNDERLINEHOT     = &H00000800
%LVS_EX_UNDERLINECOLD    = &H00001000
%LVS_EX_MULTIWORKAREAS   = &H00002000
%LVS_EX_LABELTIP         = &H00004000 ' listview unfolds partly hidden labels if it does not have infotip text

%LVM_GETSUBITEMRECT      = %LVM_FIRST + 56

FUNCTION ListView_GetSubItemRect (BYVAL hwnd AS DWORD, BYVAL iItem AS LONG, _
   BYVAL iSubItem AS LONG, BYVAL code AS LONG, prc AS RECT PTR) AS LONG
    IF prc THEN
        @prc.nTop = iSubItem
        @prc.nLeft = code
        FUNCTION = SendMessage(hwnd, %LVM_GETSUBITEMRECT, iItem, prc)
    ELSE
        FUNCTION = SendMessage(hwnd, %LVM_GETSUBITEMRECT, iItem, %NULL)
    END IF
END FUNCTION

%LVM_SUBITEMHITTEST      = %LVM_FIRST + 57

FUNCTION ListView_SubItemHitTest (BYVAL hwnd AS DWORD, plvhti AS LVHITTESTINFO) AS LONG
    FUNCTION = SendMessage(hwnd, %LVM_SUBITEMHITTEST, 0, VARPTR(plvhti))
END FUNCTION

%LVM_SETCOLUMNORDERARRAY = %LVM_FIRST + 58

FUNCTION ListView_SetColumnOrderArray (BYVAL hwnd AS DWORD, _
   BYVAL iCount AS LONG, pi AS LONG) AS LONG
    FUNCTION = SendMessage(hwnd, %LVM_SETCOLUMNORDERARRAY, iCount, VARPTR(pi))
END FUNCTION

%LVM_GETCOLUMNORDERARRAY = %LVM_FIRST + 59

FUNCTION ListView_GetColumnOrderArray (BYVAL hwnd AS DWORD, _
   BYVAL iCount AS LONG, pi AS LONG) AS LONG
    FUNCTION = SendMessage(hwnd, %LVM_GETCOLUMNORDERARRAY, iCount, VARPTR(pi))
END FUNCTION

%LVM_SETHOTITEM  = %LVM_FIRST + 60

FUNCTION ListView_SetHotItem (BYVAL hwnd AS DWORD, i AS DWORD) AS LONG
    FUNCTION = SendMessage(hwnd, %LVM_SETHOTITEM, i, 0)
END FUNCTION

%LVM_GETHOTITEM  = %LVM_FIRST + 61

FUNCTION ListView_GetHotItem (BYVAL hwnd AS DWORD) AS LONG
    FUNCTION = SendMessage(hwnd, %LVM_GETHOTITEM, 0, 0)
END FUNCTION

%LVM_SETHOTCURSOR  = %LVM_FIRST + 62

FUNCTION ListView_SetHotCursor (BYVAL hwnd AS DWORD, BYVAL hcur AS DWORD) _
   AS DWORD
    FUNCTION = SendMessage(hwnd, %LVM_SETHOTCURSOR, 0, hcur)
END FUNCTION

%LVM_GETHOTCURSOR  = %LVM_FIRST + 63

FUNCTION ListView_GetHotCursot (BYVAL hwnd AS DWORD) AS DWORD
    FUNCTION = SendMessage(hwnd, %LVM_GETHOTCURSOR, 0, 0)
END FUNCTION

%LVM_APPROXIMATEVIEWRECT = %LVM_FIRST + 64

FUNCTION ListView_ApproximateViewRect (BYVAL hwnd AS DWORD, _
   BYVAL iWidth AS INTEGER, BYVAL iHeight AS INTEGER, BYVAL iCount AS LONG) _
   AS LONG
    FUNCTION = SendMessage(hwnd, %LVM_APPROXIMATEVIEWRECT, iCount, _
       MAKLNG(iWidth, iHeight))
END FUNCTION

%LV_MAX_WORKAREAS         = 16
%LVM_SETWORKAREAS         = %LVM_FIRST + 65

FUNCTION ListView_SetWorkAreas (BYVAL hwnd AS DWORD, _
   BYVAL nWorkAreas AS LONG, prc AS RECT) AS LONG
    FUNCTION = SendMessage(hwnd, %LVM_SETWORKAREAS, nWorkAreas, VARPTR(prc))
END FUNCTION

%LVM_GETWORKAREAS        = %LVM_FIRST + 70

FUNCTION ListView_GetWorkAreas (BYVAL hwnd AS DWORD, _
   BYVAL nWorkAreas AS LONG, prc AS RECT) AS LONG
    FUNCTION = SendMessage(hwnd, %LVM_GETWORKAREAS, nWorkAreas, VARPTR(prc))
END FUNCTION

%LVM_GETNUMBEROFWORKAREAS  = %LVM_FIRST + 73

FUNCTION ListView_GetNumberOfWorkAreas (BYVAL hwnd AS DWORD, _
   pnWorkAreas AS DWORD) AS LONG
    FUNCTION = SendMessage(hwnd, %LVM_GETNUMBEROFWORKAREAS, 0, _
       VARPTR(pnWorkAreas))
END FUNCTION

%LVM_GETSELECTIONMARK    = %LVM_FIRST + 66

FUNCTION ListView_GetSelectionMark (BYVAL hwnd AS DWORD) AS LONG
    FUNCTION = SendMessage(hwnd, %LVM_GETSELECTIONMARK, 0, 0)
END FUNCTION

%LVM_SETSELECTIONMARK    = %LVM_FIRST + 67

FUNCTION ListView_SetSelectionMark (BYVAL hwnd AS DWORD, i AS LONG) AS LONG
    FUNCTION = SendMessage(hwnd, %LVM_SETSELECTIONMARK, 0, i)
END FUNCTION

%LVM_SETHOVERTIME        = %LVM_FIRST + 71

FUNCTION ListView_SetHoverTime (BYVAL hwndLV AS DWORD, _
   BYVAL dwHoverTimeMs AS DWORD) AS DWORD
    FUNCTION = SendMessage(hwndLV, %LVM_SETHOVERTIME, 0, dwHoverTimeMs)
END FUNCTION

%LVM_GETHOVERTIME        = %LVM_FIRST + 72

FUNCTION ListView_GetHoverTime (BYVAL hwndLV AS DWORD) AS DWORD
    FUNCTION = SendMessage(hwndLV, %LVM_GETHOVERTIME, 0, 0)
END FUNCTION

%LVM_SETTOOLTIPS       = %LVM_FIRST + 74

FUNCTION ListView_SetToolTips (BYVAL hwndLV AS DWORD, _
   BYVAL hwndNewHwnd AS DWORD) AS DWORD
    FUNCTION = SendMessage(hwndLV, %LVM_SETTOOLTIPS, hwndNewHwnd, 0)
END FUNCTION

%LVM_GETTOOLTIPS       = %LVM_FIRST + 78

FUNCTION ListView_GetToolTips (BYVAL hwndLV AS DWORD) AS DWORD
    FUNCTION = SendMessage(hwndLV, %LVM_GETTOOLTIPS, 0, 0)
END FUNCTION

TYPE LVBKIMAGE
    ulFlags        AS DWORD    ' LVBKIF_*
    hbm            AS DWORD
    pszImage       AS ASCIIZ PTR
    cchImageMax    AS DWORD
    xOffsetPercent AS LONG
    yOffsetPercent AS LONG
END TYPE

%LVBKIF_SOURCE_NONE      = &H00000000
%LVBKIF_SOURCE_HBITMAP   = &H00000001
%LVBKIF_SOURCE_URL       = &H00000002
%LVBKIF_SOURCE_MASK      = &H00000003
%LVBKIF_STYLE_NORMAL     = &H00000000
%LVBKIF_STYLE_TILE       = &H00000010
%LVBKIF_STYLE_MASK       = &H00000010

%LVM_SETBKIMAGE          = %LVM_FIRST + 68
%LVM_SETBKIMAGEW         = %LVM_FIRST + 138
%LVM_GETBKIMAGE          = %LVM_FIRST + 69
%LVM_GETBKIMAGEW         = %LVM_FIRST + 139

FUNCTION ListView_SetBkImage (BYVAL hwnd AS DWORD, BYVAL plvbki AS DWORD) _
   AS LONG
    FUNCTION = SendMessage(hwnd, %LVM_SETBKIMAGE, 0, plvbki)
END FUNCTION

FUNCTION ListView_GetBkImage (BYVAL hwnd AS DWORD, BYVAL plvbki AS DWORD) _
   AS LONG
    FUNCTION = SendMessage(hwnd, %LVM_GETBKIMAGE, 0, plvbki)
END FUNCTION

TYPE NM_LISTVIEW
    hdr       AS NMHDR
    iItem     AS LONG
    iSubItem  AS LONG
    uNewState AS DWORD
    uOldState AS DWORD
    uChanged  AS DWORD
    ptAction  AS POINTAPI
    lParam    AS LONG
END TYPE

TYPE NMLISTVIEW
  hdr AS NMHDR
  iItem AS LONG
  iSubItem AS LONG
  uNewState AS DWORD
  uOldState AS DWORD
  uChanged AS DWORD
  ptAction AS POINTAPI
  lParam AS LONG
END TYPE

' NMITEMACTIVATE is used instead of NMLISTVIEW in IE >= 0x400
' therefore all the fields are the same except for extra uKeyFlags
' they are used to store key flags at the time of the single click with
' delayed activation - because by the time the timer goes off a user may
' not hold the keys (shift, ctrl) any more

TYPE NMITEMACTIVATE
    hdr AS NMHDR
    iItem AS LONG
    iSubItem AS LONG
    uNewState AS DWORD
    uOldState AS DWORD
    uChanged AS DWORD
    ptAction AS POINTAPI
    lParam AS LONG
    uKeyFlags AS DWORD
END TYPE

' key flags stored in uKeyFlags
%LVKF_ALT       = &H0001
%LVKF_CONTROL   = &H0002
%LVKF_SHIFT     = &H0004

TYPE NMLVCUSTOMDRAW
    nmcd AS NMCUSTOMDRAW
    clrText AS DWORD
    clrTextBk AS DWORD
    iSubItem AS LONG
END TYPE

TYPE NMLVCACHEHINT
    hdr AS NMHDR
    iFrom AS LONG
    iTo AS LONG
END TYPE

TYPE NM_CACHEHINT
    hdr AS NMHDR
    iFrom AS LONG
    iTo AS LONG
END TYPE

TYPE NMLVFINDITEM
    hdr AS NMHDR
    iStart AS LONG
    lvfi AS LVFINDINFO
END TYPE

TYPE NM_FINDITEM
    hdr AS NMHDR
    iStart AS LONG
    lvfi AS LVFINDINFO
END TYPE

TYPE NMLVODSTATECHANGE
    hdr AS NMHDR
    iFrom AS LONG
    iTo AS LONG
    uNewState AS DWORD
    uOldState AS DWORD
END TYPE

TYPE NM_ODSTATECHANGE
    hdr AS NMHDR
    iFrom AS LONG
    iTo AS LONG
    uNewState AS DWORD
    uOldState AS DWORD
END TYPE

%LVN_ITEMCHANGING       = %LVN_FIRST - 0
%LVN_ITEMCHANGED        = %LVN_FIRST - 1
%LVN_INSERTITEM         = %LVN_FIRST - 2
%LVN_DELETEITEM         = %LVN_FIRST - 3
%LVN_DELETEALLITEMS     = %LVN_FIRST - 4
%LVN_BEGINLABELEDIT     = %LVN_FIRST - 5
%LVN_BEGINLABELEDITW    = %LVN_FIRST - 75
%LVN_ENDLABELEDIT       = %LVN_FIRST - 6
%LVN_ENDLABELEDITW      = %LVN_FIRST - 76
%LVN_COLUMNCLICK        = %LVN_FIRST - 8
%LVN_BEGINDRAG          = %LVN_FIRST - 9
%LVN_BEGINRDRAG         = %LVN_FIRST - 11

%LVN_ODCACHEHINT        = %LVN_FIRST - 13
%LVN_ODFINDITEM         = %LVN_FIRST - 52
%LVN_ODFINDITEMW        = %LVN_FIRST - 79

%LVN_ITEMACTIVATE       = %LVN_FIRST - 14
%LVN_ODSTATECHANGED     = %LVN_FIRST - 15

%LVN_HOTTRACK           = %LVN_FIRST - 21

%LVN_GETDISPINFO        = %LVN_FIRST - 50
%LVN_GETDISPINFOW       = %LVN_FIRST - 77
%LVN_SETDISPINFO        = %LVN_FIRST - 51
%LVN_SETDISPINFOW       = %LVN_FIRST - 78

%LVIF_DI_SETITEM        = &H1000

TYPE LV_DISPINFO
    hdr AS NMHDR
    item AS LV_ITEM
END TYPE

%LVN_KEYDOWN            = %LVN_FIRST - 55

TYPE LV_KEYDOWN BYTE
    hdr   AS NMHDR
    wVKey AS WORD
    flags AS DWORD
END TYPE

TYPE NMLVKEYDOWN BYTE
    hdr   AS NMHDR
    wVKey AS WORD
    flags AS DWORD
END TYPE

%LVN_MARQUEEBEGIN       = %LVN_FIRST - 56

TYPE NMLVGETINFOTIP
    hdr        AS NMHDR
    dwFlags    AS DWORD
    pszText    AS ASCIIZ PTR
    cchTextMax AS LONG
    iItem      AS LONG
    iSubItem   AS LONG
    lParam     AS LONG
END TYPE

' NMLVGETINFOTIPA.dwFlag values

%LVGIT_UNFOLDED  = &H0001

%LVN_GETINFOTIP          = %LVN_FIRST - 57
%LVN_GETINFOTIPW         = %LVN_FIRST - 58

#ENDIF



'==============================================================================
' TREEVIEW CONTROL

#IF NOT %DEF(%NOTREEVIEW)

$WC_TREEVIEW            = "SysTreeView32"

' begin_r_commctrl

%TVS_HASBUTTONS         = &H0001
%TVS_HASLINES           = &H0002
%TVS_LINESATROOT        = &H0004
%TVS_EDITLABELS         = &H0008
%TVS_DISABLEDRAGDROP    = &H0010
%TVS_SHOWSELALWAYS      = &H0020
%TVS_RTLREADING         = &H0040
%TVS_NOTOOLTIPS         = &H0080
%TVS_CHECKBOXES         = &H0100
%TVS_TRACKSELECT        = &H0200
%TVS_SINGLEEXPAND       = &H0400
%TVS_INFOTIP            = &H0800
%TVS_FULLROWSELECT      = &H1000
%TVS_NOSCROLL           = &H2000
%TVS_NONEVENHEIGHT      = &H4000
%TVS_NOHSCROLL          = &H8000  ' TVS_NOSCROLL overrides this

' end_r_commctrl

%TVIF_TEXT              = &H0001
%TVIF_IMAGE             = &H0002
%TVIF_PARAM             = &H0004
%TVIF_STATE             = &H0008
%TVIF_HANDLE            = &H0010
%TVIF_SELECTEDIMAGE     = &H0020
%TVIF_CHILDREN          = &H0040
%TVIF_INTEGRAL          = &H0080

%TVIS_SELECTED          = &H0002
%TVIS_CUT               = &H0004
%TVIS_DROPHILITED       = &H0008
%TVIS_BOLD              = &H0010
%TVIS_EXPANDED          = &H0020
%TVIS_EXPANDEDONCE      = &H0040
%TVIS_EXPANDPARTIAL     = &H0080

%TVIS_OVERLAYMASK       = &H0F00
%TVIS_STATEIMAGEMASK    = &HF000
%TVIS_USERMASK          = &HF000

%I_CHILDRENCALLBACK     = -1

TYPE TV_ITEM
    mask           AS DWORD
    hItem          AS DWORD
    STATE          AS DWORD
    stateMask      AS DWORD
    pszText        AS ASCIIZ PTR
    cchTextMax     AS LONG
    iImage         AS LONG
    iSelectedImage AS LONG
    cChildren      AS LONG
    lParam         AS LONG
END TYPE

TYPE TVITEM
    mask           AS DWORD
    hItem          AS DWORD
    STATE          AS DWORD
    stateMask      AS DWORD
    pszText        AS ASCIIZ PTR
    cchTextMax     AS LONG
    iImage         AS LONG
    iSelectedImage AS LONG
    cChildren      AS LONG
    lParam         AS LONG
END TYPE

' only used for Get and Set messages.  no notifies

TYPE TVITEMEX
    mask           AS DWORD
    hItem          AS DWORD
    STATE          AS DWORD
    stateMask      AS DWORD
    pszText        AS ASCIIZ PTR
    cchTextMax     AS LONG
    iImage         AS LONG
    iSelectedImage AS LONG
    cChildren      AS LONG
    lParam         AS LONG
    iIntegral      AS LONG
END TYPE

%TVI_ROOT               = &HFFFF0000???
%TVI_FIRST              = &HFFFF0001???
%TVI_LAST               = &HFFFF0002???
%TVI_SORT               = &HFFFF0003???

UNION TV_ITEM_UNION
    itemex AS TVITEMEX
    item   AS TV_ITEM
END UNION

TYPE TV_INSERTSTRUCT
    hParent      AS DWORD
    hInsertAfter AS DWORD
    item         AS TV_ITEM_UNION
END TYPE

%TVM_INSERTITEM         = %TV_FIRST + 0
%TVM_INSERTITEMW        = %TV_FIRST + 50

FUNCTION TreeView_InsertItem (BYVAL hWnd AS LONG, lpis AS TV_INSERTSTRUCT) _
   AS DWORD
    FUNCTION = SendMessage(hWnd, %TVM_INSERTITEM, 0, VARPTR(lpis))
END FUNCTION

%TVM_DELETEITEM         = %TV_FIRST + 1

FUNCTION TreeView_DeleteItem (BYVAL hWnd AS DWORD, BYVAL hitem AS DWORD) _
   AS LONG
    FUNCTION = SendMessage(hWnd, %TVM_DELETEITEM, 0, hitem)
END FUNCTION

FUNCTION TreeView_DeleteAllItems (BYVAL hWnd AS DWORD) AS LONG
    FUNCTION = SendMessage(hWnd, %TVM_DELETEITEM, 0, %TVI_ROOT)
END FUNCTION

%TVM_EXPAND             = %TV_FIRST + 2

FUNCTION TreeView_Expand (BYVAL hWnd AS DWORD, BYVAL hitem AS LONG, _
   BYVAL code AS DWORD) AS LONG
    FUNCTION = SendMessage(hWnd, %TVM_EXPAND, code, hitem)
END FUNCTION

%TVE_COLLAPSE           = &H0001
%TVE_EXPAND             = &H0002
%TVE_TOGGLE             = &H0003
%TVE_EXPANDPARTIAL      = &H4000
%TVE_COLLAPSERESET      = &H8000

%TVM_GETITEMRECT        = %TV_FIRST + 4

FUNCTION TreeView_GetItemRect (BYVAL hWnd AS DWORD, BYVAL hItem AS DWORD, _
   prc AS RECT, BYVAL code AS LONG) AS LONG
    prc.nLeft = hItem
    FUNCTION = SendMessage(hWnd, %TVM_GETITEMRECT, code, VARPTR(prc))
END FUNCTION

%TVM_GETCOUNT           = %TV_FIRST + 5

FUNCTION TreeView_GetCount (BYVAL hWnd AS DWORD) AS DWORD
    FUNCTION = SendMessage(hWnd, %TVM_GETCOUNT, 0, 0)
END FUNCTION

%TVM_GETINDENT          = %TV_FIRST + 6

FUNCTION TreeView_GetIndent (BYVAL hWnd AS DWORD) AS DWORD
    FUNCTION = SendMessage(hWnd, %TVM_GETINDENT, 0, 0)
END FUNCTION

%TVM_SETINDENT          = %TV_FIRST + 7

FUNCTION TreeView_SetIndent (BYVAL hWnd AS DWORD, BYVAL indent AS DWORD) _
   AS LONG
    FUNCTION = SendMessage(hWnd, %TVM_SETINDENT, indent, 0)
END FUNCTION

%TVM_GETIMAGELIST       = %TV_FIRST + 8

FUNCTION TreeView_GetImageList (BYVAL hWnd AS DWORD, BYVAL iImage AS LONG) _
   AS DWORD
    FUNCTION = SendMessage(hWnd, %TVM_GETIMAGELIST, iImage, 0)
END FUNCTION

%TVSIL_NORMAL           = 0
%TVSIL_STATE            = 2

%TVM_SETIMAGELIST       = %TV_FIRST + 9

FUNCTION TreeView_SetImageList (BYVAL hWnd AS DWORD, BYVAL himl AS DWORD, _
   BYVAL iImage AS LONG) AS DWORD
    FUNCTION = SendMessage(hWnd, %TVM_SETIMAGELIST, iImage, himl)
END FUNCTION

%TVM_GETNEXTITEM        = %TV_FIRST + 10

FUNCTION TreeView_GetNextItem (BYVAL hWnd AS DWORD, BYVAL hitem AS DWORD, _
   BYVAL code AS DWORD) AS DWORD
    FUNCTION = SendMessage(hWnd, %TVM_GETNEXTITEM, code, hitem)
END FUNCTION

%TVGN_ROOT              = &H0000
%TVGN_NEXT              = &H0001
%TVGN_PREVIOUS          = &H0002
%TVGN_PARENT            = &H0003
%TVGN_CHILD             = &H0004
%TVGN_FIRSTVISIBLE      = &H0005
%TVGN_NEXTVISIBLE       = &H0006
%TVGN_PREVIOUSVISIBLE   = &H0007
%TVGN_DROPHILITE        = &H0008
%TVGN_CARET             = &H0009
%TVGN_LASTVISIBLE       = &H000A

FUNCTION TreeView_GetChild (BYVAL hwnd AS DWORD, BYVAL hitem AS DWORD) AS DWORD
    FUNCTION = TreeView_GetNextItem(hwnd, hitem, %TVGN_CHILD)
END FUNCTION

FUNCTION TreeView_GetNextSibling (BYVAL hwnd AS DWORD, BYVAL hitem AS DWORD) _
   AS DWORD
    FUNCTION = TreeView_GetNextItem(hwnd, hitem, %TVGN_NEXT)
END FUNCTION

FUNCTION TreeView_GetPrevSibling (BYVAL hwnd AS DWORD, BYVAL hitem AS DWORD) _
   AS DWORD
    FUNCTION = TreeView_GetNextItem(hwnd, hitem, %TVGN_PREVIOUS)
END FUNCTION

FUNCTION TreeView_GetParent (BYVAL hwnd AS DWORD, BYVAL hitem AS DWORD) _
   AS DWORD
    FUNCTION = TreeView_GetNextItem(hwnd, hitem, %TVGN_PARENT)
END FUNCTION

FUNCTION TreeView_GetFirstVisible (BYVAL hwnd AS DWORD) AS DWORD
    FUNCTION = TreeView_GetNextItem(hwnd, %NULL, %TVGN_FIRSTVISIBLE)
END FUNCTION

FUNCTION TreeView_GetNextVisible (BYVAL hwnd AS DWORD, BYVAL hitem AS DWORD) _
   AS DWORD
    FUNCTION = TreeView_GetNextItem(hwnd, hitem, %TVGN_NEXTVISIBLE)
END FUNCTION

FUNCTION TreeView_GetPrevVisible (BYVAL hwnd AS DWORD, BYVAL hitem AS DWORD) _
   AS DWORD
    FUNCTION = TreeView_GetNextItem(hwnd, hitem, %TVGN_PREVIOUSVISIBLE)
END FUNCTION

FUNCTION TreeView_GetSelection (BYVAL hwnd AS DWORD) AS DWORD
    FUNCTION = TreeView_GetNextItem(hwnd, %NULL, %TVGN_CARET)
END FUNCTION

FUNCTION TreeView_GetDropHilight (BYVAL hwnd AS DWORD) AS DWORD
    FUNCTION = TreeView_GetNextItem(hwnd, %NULL, %TVGN_DROPHILITE)
END FUNCTION

FUNCTION TreeView_GetRoot (BYVAL hwnd AS DWORD) AS DWORD
    FUNCTION = TreeView_GetNextItem(hwnd, %NULL, %TVGN_ROOT)
END FUNCTION

FUNCTION TreeView_GetLastVisible (BYVAL hwnd AS DWORD) AS DWORD
    FUNCTION = TreeView_GetNextItem(hwnd, %NULL, %TVGN_LASTVISIBLE)
END FUNCTION

%TVM_SELECTITEM         = %TV_FIRST + 11

FUNCTION TreeView_Select (BYVAL hwnd AS DWORD, BYVAL hitem AS DWORD, _
   BYVAL code AS LONG) AS LONG
    FUNCTION = SendMessage(hwnd, %TVM_SELECTITEM, code, hitem)
END FUNCTION

FUNCTION TreeView_SelectItem (BYVAL hwnd AS DWORD, BYVAL hitem AS DWORD) _
   AS LONG
    FUNCTION = TreeView_Select(hwnd, hitem, %TVGN_CARET)
END FUNCTION

FUNCTION TreeView_SelectDropTarget (BYVAL hwnd AS DWORD, _
   BYVAL hitem AS DWORD) AS LONG
    FUNCTION = TreeView_Select(hwnd, hitem, %TVGN_DROPHILITE)
END FUNCTION

FUNCTION TreeView_SelectSetFirstVisible (BYVAL hwnd AS DWORD, _
   BYVAL hitem AS DWORD) AS LONG
    FUNCTION = TreeView_Select(hwnd, hitem, %TVGN_FIRSTVISIBLE)
END FUNCTION

%TVM_GETITEM            = %TV_FIRST + 12
%TVM_GETITEMW           = %TV_FIRST + 62

FUNCTION TreeView_GetItem (BYVAL hwnd AS DWORD, pitem AS TV_ITEM) AS LONG
    FUNCTION = SendMessage(hwnd, %TVM_GETITEM, 0, VARPTR(pitem))
END FUNCTION

%TVM_SETITEM            = %TV_FIRST + 13
%TVM_SETITEMW           = %TV_FIRST + 63

FUNCTION TreeView_SetItem (BYVAL hwnd AS DWORD, pitem AS TV_ITEM) AS LONG
    FUNCTION = SendMessage(hwnd, %TVM_SETITEM, 0, VARPTR(pitem))
END FUNCTION

%TVM_EDITLABEL          = %TV_FIRST + 14
%TVM_EDITLABELW         = %TV_FIRST + 65

FUNCTION TreeView_EditLabel (BYVAL hwnd AS DWORD, BYVAL hitem AS DWORD) _
   AS DWORD
    FUNCTION = SendMessage(hwnd, %TVM_EDITLABEL, 0, hitem)
END FUNCTION

%TVM_GETEDITCONTROL     = %TV_FIRST + 15

FUNCTION TreeView_GetEditControl (BYVAL hwnd AS DWORD) AS DWORD
    FUNCTION = SendMessage(hwnd, %TVM_GETEDITCONTROL, 0, 0)
END FUNCTION

%TVM_GETVISIBLECOUNT    = %TV_FIRST + 16

FUNCTION TreeView_GetVisibleCount (BYVAL hWnd AS DWORD) AS DWORD
    FUNCTION = SendMessage(hWnd, %TVM_GETVISIBLECOUNT, 0, 0)
END FUNCTION

%TVM_HITTEST            = %TV_FIRST + 17

TYPE TV_HITTESTINFO
    pt AS POINTAPI
    flags AS DWORD
    hItem AS DWORD
END TYPE

FUNCTION TreeView_HitTest (BYVAL hwnd AS DWORD, lpht AS TV_HITTESTINFO) _
   AS DWORD
    FUNCTION = SendMessage(hwnd, %TVM_HITTEST, 0, VARPTR(lpht))
END FUNCTION

%TVHT_NOWHERE           = &H0001
%TVHT_ONITEMICON        = &H0002
%TVHT_ONITEMLABEL       = &H0004
%TVHT_ONITEMINDENT      = &H0008
%TVHT_ONITEMBUTTON      = &H0010
%TVHT_ONITEMRIGHT       = &H0020
%TVHT_ONITEMSTATEICON   = &H0040
%TVHT_ABOVE             = &H0100
%TVHT_BELOW             = &H0200
%TVHT_TORIGHT           = &H0400
%TVHT_TOLEFT            = &H0800
%TVHT_ONITEM            = %TVHT_ONITEMICON OR %TVHT_ONITEMLABEL _
                          OR %TVHT_ONITEMSTATEICON

%TVM_CREATEDRAGIMAGE    = %TV_FIRST + 18

FUNCTION TreeView_CreateDragImage (BYVAL hwnd AS DWORD, BYVAL hitem AS DWORD) _
   AS DWORD
    FUNCTION = SendMessage(hwnd, %TVM_CREATEDRAGIMAGE, 0, hitem)
END FUNCTION

%TVM_SORTCHILDREN       = %TV_FIRST + 19

FUNCTION TreeView_SortChildren (BYVAL hwnd AS DWORD, BYVAL hitem AS DWORD, _
   BYVAL recurse AS DWORD) AS LONG
    FUNCTION = SendMessage(hwnd, %TVM_SORTCHILDREN, recurse, hitem)
END FUNCTION

%TVM_ENSUREVISIBLE      = %TV_FIRST + 20

FUNCTION TreeView_EnsureVisible (BYVAL hwnd AS DWORD, BYVAL hitem AS DWORD) _
   AS LONG
    FUNCTION = SendMessage(hwnd, %TVM_ENSUREVISIBLE, 0, hitem)
END FUNCTION

TYPE TV_SORTCB
    hParent     AS DWORD
    lpfnCompare AS DWORD
    lParam      AS LONG
END TYPE

%TVM_SORTCHILDRENCB     = %TV_FIRST + 21

FUNCTION TreeView_SortChildrenCB (BYVAL hwnd AS DWORD, psort AS TV_SORTCB, _
   recurse AS DWORD) AS LONG
    FUNCTION = SendMessage(hwnd, %TVM_SORTCHILDRENCB, recurse, VARPTR(psort))
END FUNCTION

%TVM_ENDEDITLABELNOW    = %TV_FIRST + 22

FUNCTION TreeView_EndEditLabelNow (BYVAL hwnd AS DWORD, _
   BYVAL fCancel AS DWORD) AS LONG
    FUNCTION = SendMessage(hwnd, %TVM_ENDEDITLABELNOW, fCancel, 0)
END FUNCTION

%TVM_GETISEARCHSTRING   = %TV_FIRST + 23

FUNCTION TreeView_GetISearchString (BYVAL hwndTV AS DWORD, lpsz AS ASCIIZ) _
   AS LONG
    FUNCTION = SendMessage(hwndTV, %TVM_GETISEARCHSTRING, 0, VARPTR(lpsz))
END FUNCTION

%TVM_SETTOOLTIPS        = %TV_FIRST + 24

FUNCTION TreeView_SetToolTips (BYVAL hwnd AS DWORD, BYVAL hwndTT AS DWORD) _
   AS DWORD
    FUNCTION = SendMessage(hwnd, %TVM_SETTOOLTIPS, hwndTT, 0)
END FUNCTION

%TVM_GETTOOLTIPS        = %TV_FIRST + 25

FUNCTION TreeView_GetToolTips (BYVAL hwnd AS DWORD) AS DWORD
    FUNCTION = SendMessage(hwnd, %TVM_GETTOOLTIPS, 0, 0)
END FUNCTION

%TVM_SETINSERTMARK      = %TV_FIRST + 26

FUNCTION TreeView_SetInsertMark (BYVAL hwnd AS DWORD, BYVAL hItem AS DWORD, _
   BYVAL fAfter AS DWORD) AS LONG
    FUNCTION = SendMessage(hwnd, %TVM_SETINSERTMARK, fAfter, hItem)
END FUNCTION

%TVM_SETUNICODEFORMAT   = %CCM_SETUNICODEFORMAT

FUNCTION TreeView_SetUnicodeFormat (BYVAL hwnd AS DWORD, _
   BYVAL fUnicode AS DWORD) AS LONG
    FUNCTION = SendMessage(hwnd, %TVM_SETUNICODEFORMAT, fUnicode, 0)
END FUNCTION

%TVM_GETUNICODEFORMAT   = %CCM_GETUNICODEFORMAT

FUNCTION TreeView_GetUnicodeFormat (BYVAL hwnd AS DWORD) AS LONG
    FUNCTION = SendMessage(hwnd, %TVM_GETUNICODEFORMAT, 0, 0)
END FUNCTION

%TVM_SETITEMHEIGHT      = %TV_FIRST + 27

FUNCTION TreeView_SetItemHeight (BYVAL hwnd AS DWORD, iHeight AS DWORD) AS LONG
    FUNCTION = SendMessage(hwnd, %TVM_SETITEMHEIGHT, iHeight, 0)
END FUNCTION

%TVM_GETITEMHEIGHT      = %TV_FIRST + 28

FUNCTION TreeView_GetItemHeight (BYVAL hwnd AS DWORD) AS LONG
    FUNCTION = SendMessage(hwnd, %TVM_GETITEMHEIGHT, 0, 0)
END FUNCTION

%TVM_SETBKCOLOR         = %TV_FIRST + 29

FUNCTION TreeView_SetBkColor (BYVAL hwnd AS DWORD, BYVAL clr AS DWORD) AS DWORD
    FUNCTION = SendMessage(hwnd, %TVM_SETBKCOLOR, 0, clr)
END FUNCTION

%TVM_SETTEXTCOLOR       = %TV_FIRST + 30

FUNCTION TreeView_SetTextColor (BYVAL hwnd AS DWORD, BYVAL clr AS DWORD) _
   AS DWORD
    FUNCTION = SendMessage(hwnd, %TVM_SETTEXTCOLOR, 0, clr)
END FUNCTION

%TVM_GETBKCOLOR         = %TV_FIRST + 31

FUNCTION TreeView_GetBkColor (BYVAL hwnd AS DWORD) AS DWORD
    FUNCTION = SendMessage(hwnd, %TVM_GETBKCOLOR, 0, 0)
END FUNCTION

%TVM_GETTEXTCOLOR       = %TV_FIRST + 32

FUNCTION TreeView_GetTextColor (BYVAL hwnd AS DWORD) AS DWORD
    FUNCTION = SendMessage(hwnd, %TVM_GETTEXTCOLOR, 0, 0)
END FUNCTION

%TVM_SETSCROLLTIME      = %TV_FIRST + 33

FUNCTION TreeView_SetScrollTime (BYVAL hwnd AS DWORD, BYVAL uTime AS DWORD) _
   AS DWORD
    FUNCTION = SendMessage(hwnd, %TVM_SETSCROLLTIME, uTime, 0)
END FUNCTION

%TVM_GETSCROLLTIME      = %TV_FIRST + 34

FUNCTION TreeView_GetScrollTime (BYVAL hwnd AS DWORD) AS DWORD
    FUNCTION = SendMessage(hwnd, %TVM_GETSCROLLTIME, 0, 0)
END FUNCTION

%TVM_SETINSERTMARKCOLOR = %TV_FIRST + 37

FUNCTION TreeView_SetInsertMarkColor (BYVAL hwnd AS DWORD, _
   BYVAL clr AS DWORD) AS DWORD
    FUNCTION = SendMessage(hwnd, %TVM_SETINSERTMARKCOLOR, 0, clr)
END FUNCTION

%TVM_GETINSERTMARKCOLOR = %TV_FIRST + 38

FUNCTION TreeView_GetInsertMarkColor (BYVAL hwnd AS DWORD) AS DWORD
    FUNCTION = SendMessage(hwnd, %TVM_GETINSERTMARKCOLOR, 0, 0)
END FUNCTION

' tvm_?etitemstate only uses mask, state and stateMask.
' so unicode or ansi is irrelevant.
FUNCTION TreeView_SetItemState (BYVAL hwndTV AS DWORD, BYVAL hti AS DWORD, _
   BYVAL STATE AS DWORD, BYVAL statemask AS DWORD) AS DWORD
    LOCAL ms_TVi AS TVITEM
    ms_TVi.mask  = %TVIF_STATE
    ms_TVi.hItem = hti
    ms_TVi.stateMask = statemask
    ms_TVi.state = state
    SendMessage hwndTV, %TVM_SETITEM, 0, VARPTR(ms_TVi)
    ' the return value is not used
END FUNCTION

#IF NOT %DEF(%ITSIM)
    %ITSIM = 1
    FUNCTION IndexToStateImageMask (BYVAL i AS LONG) AS LONG
        SHIFT LEFT i, 12
        FUNCTION = i
    END FUNCTION
#ENDIF

FUNCTION TreeView_SetCheckState (BYVAL hwndTV AS DWORD, BYVAL hti AS DWORD, _
   BYVAL fCheck AS LONG) AS DWORD
    LOCAL ix AS LONG
    IF fCheck THEN
        ix = IndexToStateImageMask(2)
    ELSE
        ix = IndexToStateImageMask(1)
    END IF
    TreeView_SetItemState hwndTV, hti, ix, %TVIS_STATEIMAGEMASK
    ' the return value is not used
END FUNCTION

%TVM_GETITEMSTATE = %TV_FIRST + 39

FUNCTION TreeView_GetItemState (BYVAL hwndTV AS DWORD, BYVAL hti AS DWORD, _
   BYVAL mask AS DWORD) AS DWORD
    FUNCTION = SendMessage(hwndTV, %TVM_GETITEMSTATE, hti, mask)
END FUNCTION

FUNCTION TreeView_GetCheckState (BYVAL hwndTV AS DWORD, BYVAL hti AS DWORD) _
   AS DWORD
    ' Despite this returning a DWORD, Microsoft documents one of the return
    ' values as being -1. What they mean is &HFFFFFFFF???, not &HFFFFFFFF&.
    LOCAL dTmp AS LONG
    dTmp = %TVIS_STATEIMAGEMASK
    SHIFT RIGHT dTmp, 12
    DECR dTmp
    FUNCTION = SendMessage(hwndTV, %TVM_GETITEMSTATE, hti, dTmp)
END FUNCTION

%TVM_SETLINECOLOR = %TV_FIRST + 40

FUNCTION TreeView_SetLineColor (BYVAL hwnd AS DWORD, BYVAL clr AS DWORD) _
   AS DWORD
    FUNCTION = SendMessage(hwnd, %TVM_SETLINECOLOR, 0, clr)
END FUNCTION

%TVM_GETLINECOLOR = %TV_FIRST + 41

FUNCTION TreeView_GetLineColor (BYVAL hwnd AS DWORD) AS DWORD
    FUNCTION = SendMessage(hwnd, %TVM_GETLINECOLOR, 0, 0)
END FUNCTION

TYPE NM_TREEVIEW
    hdr     AS NMHDR
    action  AS DWORD
    itemOld AS TV_ITEM
    itemNew AS TV_ITEM
    ptDrag  AS POINTAPI
END TYPE

%TVN_SELCHANGING        = %TVN_FIRST - 1
%TVN_SELCHANGINGW       = %TVN_FIRST - 50
%TVN_SELCHANGED         = %TVN_FIRST - 2
%TVN_SELCHANGEDW        = %TVN_FIRST - 51

%TVC_UNKNOWN            = &H0000
%TVC_BYMOUSE            = &H0001
%TVC_BYKEYBOARD         = &H0002

%TVN_GETDISPINFO        = %TVN_FIRST - 3
%TVN_GETDISPINFOW       = %TVN_FIRST - 52
%TVN_SETDISPINFO        = %TVN_FIRST - 4
%TVN_SETDISPINFOW       = %TVN_FIRST - 53

%TVIF_DI_SETITEM        = &H1000

TYPE TV_DISPINFO
    hdr  AS NMHDR
    item AS TV_ITEM
END TYPE

%TVN_ITEMEXPANDING      = %TVN_FIRST - 5
%TVN_ITEMEXPANDINGW     = %TVN_FIRST - 54
%TVN_ITEMEXPANDED       = %TVN_FIRST - 6
%TVN_ITEMEXPANDEDW      = %TVN_FIRST - 55
%TVN_BEGINDRAG          = %TVN_FIRST - 7
%TVN_BEGINDRAGW         = %TVN_FIRST - 56
%TVN_BEGINRDRAG         = %TVN_FIRST - 8
%TVN_BEGINRDRAGW        = %TVN_FIRST - 57
%TVN_DELETEITEM         = %TVN_FIRST - 9
%TVN_DELETEITEMW        = %TVN_FIRST - 58
%TVN_BEGINLABELEDIT     = %TVN_FIRST - 10
%TVN_BEGINLABELEDITW    = %TVN_FIRST - 59
%TVN_ENDLABELEDIT       = %TVN_FIRST - 11
%TVN_ENDLABELEDITW      = %TVN_FIRST - 60
%TVN_KEYDOWN            = %TVN_FIRST - 12
%TVN_GETINFOTIP         = %TVN_FIRST - 13
%TVN_GETINFOTIPW        = %TVN_FIRST - 14
%TVN_SINGLEEXPAND       = %TVN_FIRST - 15

%TVNRET_DEFAULT         = 0
%TVNRET_SKIPOLD         = 1
%TVNRET_SKIPNEW         = 2

TYPE TV_KEYDOWN BYTE
    hdr   AS NMHDR
    wVKey AS WORD
    flags AS DWORD
END TYPE

TYPE NMTVKEYDOWN BYTE
    hdr   AS NMHDR
    wVKey AS WORD
    flags AS DWORD
END TYPE

TYPE NMTVCUSTOMDRAW
    nmcd      AS NMCUSTOMDRAW
    clrText   AS DWORD
    clrTextBk AS DWORD
    iLevel    AS LONG
END TYPE

TYPE NMTVGETINFOTIP
    hdr        AS NMHDR
    pszText    AS ASCIIZ PTR
    cchTextMax AS LONG
    hItem      AS DWORD
    lParam     AS LONG
END TYPE

' treeview's customdraw return meaning don't draw images.
' valid on CDRF_NOTIFYITEMPREPAINT
%TVCDRF_NOIMAGES        = &H00010000

#ENDIF



'==============================================================================
' COMBOBOXEX Control

#IF NOT %DEF(%NOCOMBOEX)

$WC_COMBOBOXEX          = "ComboBoxEx32"

%CBEIF_TEXT             = &H00000001
%CBEIF_IMAGE            = &H00000002
%CBEIF_SELECTEDIMAGE    = &H00000004
%CBEIF_OVERLAY          = &H00000008
%CBEIF_INDENT           = &H00000010
%CBEIF_LPARAM           = &H00000020

%CBEIF_DI_SETITEM       = &H10000000

TYPE COMBOBOXEXITEM
    mask           AS DWORD
    iItem          AS LONG
    pszText        AS ASCIIZ PTR
    cchTextMax     AS LONG
    iImage         AS LONG
    iSelectedImage AS LONG
    iOverlay       AS LONG
    iIndent        AS LONG
    lParam         AS LONG
END TYPE

%CBEM_INSERTITEM        = %WM_USER + 1
%CBEM_SETIMAGELIST      = %WM_USER + 2
%CBEM_GETIMAGELIST      = %WM_USER + 3
%CBEM_GETITEM           = %WM_USER + 4
%CBEM_SETITEM           = %WM_USER + 5
%CBEM_DELETEITEM        = %CB_DELETESTRING
%CBEM_GETCOMBOCONTROL   = %WM_USER + 6
%CBEM_GETEDITCONTROL    = %WM_USER + 7
%CBEM_SETEXSTYLE        = %WM_USER + 8     ' use  SETEXTENDEDSTYLE instead
%CBEM_SETEXTENDEDSTYLE  = %WM_USER + 14    ' lparam == new style, wParam (optional) == mask
%CBEM_GETEXSTYLE        = %WM_USER + 9     ' use GETEXTENDEDSTYLE instead
%CBEM_GETEXTENDEDSTYLE  = %WM_USER + 9
%CBEM_SETUNICODEFORMAT  = %CCM_SETUNICODEFORMAT
%CBEM_GETUNICODEFORMAT  = %CCM_GETUNICODEFORMAT
%CBEM_HASEDITCHANGED    = %WM_USER + 10
%CBEM_INSERTITEMW       = %WM_USER + 11
%CBEM_SETITEMW          = %WM_USER + 12
%CBEM_GETITEMW          = %WM_USER + 13

%CBES_EX_NOEDITIMAGE         = &H00000001
%CBES_EX_NOEDITIMAGEINDENT   = &H00000002
%CBES_EX_PATHWORDBREAKPROC   = &H00000004
%CBES_EX_NOSIZELIMIT         = &H00000008
%CBES_EX_CASESENSITIVE       = &H00000010

TYPE NMCOMBOBOXEX
    hdr    AS NMHDR
    ceItem AS COMBOBOXEXITEM
END TYPE

%CBEN_GETDISPINFO        = %CBEN_FIRST - 0
%CBEN_INSERTITEM         = %CBEN_FIRST - 1
%CBEN_DELETEITEM         = %CBEN_FIRST - 2
%CBEN_BEGINEDIT          = %CBEN_FIRST - 4
%CBEN_ENDEDIT            = %CBEN_FIRST - 5
%CBEN_ENDEDITW           = %CBEN_FIRST - 6
%CBEN_GETDISPINFOW       = %CBEN_FIRST - 7
%CBEN_DRAGBEGIN          = %CBEN_FIRST - 8
%CBEN_DRAGBEGINW         = %CBEN_FIRST - 9

%CBENF_KILLFOCUS         = 1
%CBENF_RETURN            = 2
%CBENF_ESCAPE            = 3
%CBENF_DROPDOWN          = 4

%CBEMAXSTRLEN            = 260

' CBEN_DRAGBEGIN sends this information ...

TYPE NMCBEDRAGBEGIN
    hdr AS NMHDR
    iItemid AS LONG
    szText AS ASCIIZ * %CBEMAXSTRLEN
END TYPE

' CBEN_ENDEDIT sends this information...
' fChanged if the user actually did anything
' iNewSelection gives what would be the new selection unless the notify failed
'                      iNewSelection may be CB_ERR if there's no match
TYPE NMCBEENDEDIT
    hdr AS NMHDR
    fChanged AS LONG
    iNewSelection AS LONG
    szText AS ASCIIZ * %CBEMAXSTRLEN
    iWhy AS LONG
END TYPE

#ENDIF



'==============================================================================
' TAB CONTROL

#IF NOT %DEF(%NOTABCONTROL)

$WC_TABCONTROL           = "SysTabControl32"

' begin_r_commctrl

%TCS_SCROLLOPPOSITE      = &H0001  ' assumes multiline tab
%TCS_BOTTOM              = &H0002
%TCS_RIGHT               = &H0002
%TCS_MULTISELECT         = &H0004  ' allow multi-select in button mode
%TCS_FLATBUTTONS         = &H0008
%TCS_FORCEICONLEFT       = &H0010
%TCS_FORCELABELLEFT      = &H0020
%TCS_HOTTRACK            = &H0040
%TCS_VERTICAL            = &H0080
%TCS_TABS                = &H0000
%TCS_BUTTONS             = &H0100
%TCS_SINGLELINE          = &H0000
%TCS_MULTILINE           = &H0200
%TCS_RIGHTJUSTIFY        = &H0000
%TCS_FIXEDWIDTH          = &H0400
%TCS_RAGGEDRIGHT         = &H0800
%TCS_FOCUSONBUTTONDOWN   = &H1000
%TCS_OWNERDRAWFIXED      = &H2000
%TCS_TOOLTIPS            = &H4000
%TCS_FOCUSNEVER          = &H8000

' end_r_commctrl

' EX styles for use with TCM_SETEXTENDEDSTYLE
%TCS_EX_FLATSEPARATORS   = &H00000001
%TCS_EX_REGISTERDROP     = &H00000002

%TCM_GETIMAGELIST        = %TCM_FIRST + 2

FUNCTION TabCtrl_GetImageList (BYVAL hWnd AS DWORD) AS DWORD
    FUNCTION = SendMessage(hWnd, %TCM_GETIMAGELIST, 0, 0)
END FUNCTION

%TCM_SETIMAGELIST        = %TCM_FIRST + 3

FUNCTION TabCtrl_SetImageList (BYVAL hWnd AS DWORD, BYVAL himl AS DWORD) _
   AS DWORD
    FUNCTION = SendMessage(hWnd, %TCM_SETIMAGELIST, 0, himl)
END FUNCTION

%TCM_GETITEMCOUNT        = %TCM_FIRST + 4

FUNCTION TabCtrl_GetItemCount (BYVAL hWnd AS DWORD) AS LONG
    FUNCTION = SendMessage(hWnd, %TCM_GETITEMCOUNT, 0, 0)
END FUNCTION

%TCIF_TEXT               = &H0001
%TCIF_IMAGE              = &H0002
%TCIF_RTLREADING         = &H0004
%TCIF_PARAM              = &H0008
%TCIF_STATE              = &H0010

%TCIS_BUTTONPRESSED      = &H0001
%TCIS_HIGHLIGHTED        = &H0002

TYPE TC_ITEMHEADER
    Mask          AS DWORD
    lpReserved1   AS DWORD
    lpReserved2   AS DWORD
    pszText       AS ASCIIZ PTR
    cchTextMax    AS LONG
    iImage        AS LONG
END TYPE

TYPE TC_ITEM
    Mask          AS DWORD
    dwState       AS DWORD
    dwStateMask   AS DWORD
    pszText       AS ASCIIZ PTR
    cchTextMax    AS LONG
    iImage        AS LONG
    lParam        AS LONG
END TYPE

%TCM_GETITEM             = %TCM_FIRST + 5
%TCM_GETITEMW            = %TCM_FIRST + 60

FUNCTION TabCtrl_GetItem (BYVAL hwnd AS DWORD, BYVAL iItem AS DWORD, _
   pItem AS TC_ITEM) AS LONG
    FUNCTION = SendMessage(hwnd, %TCM_GETITEM, iItem, VARPTR(pItem))
END FUNCTION

%TCM_SETITEM            = %TCM_FIRST + 6
%TCM_SETITEMW           = %TCM_FIRST + 61

FUNCTION TabCtrl_SetItem (BYVAL hwnd AS DWORD, BYVAL iItem AS DWORD, _
   pItem AS TC_ITEM) AS LONG
    FUNCTION = SendMessage(hwnd, %TCM_SETITEM, iItem, VARPTR(pItem))
END FUNCTION

%TCM_INSERTITEM         = %TCM_FIRST + 7
%TCM_INSERTITEMW        = %TCM_FIRST + 62

FUNCTION TabCtrl_InsertItem (BYVAL hwnd AS DWORD, BYVAL iItem AS DWORD, _
   pItem AS TC_ITEM) AS LONG
    FUNCTION = SendMessage(hwnd, %TCM_INSERTITEM, iItem, VARPTR(pItem))
END FUNCTION

%TCM_DELETEITEM         = %TCM_FIRST + 8

FUNCTION TabCtrl_DeleteItem (BYVAL hwnd AS DWORD, BYVAL iItem AS DWORD) AS LONG
    FUNCTION = SendMessage(hwnd, %TCM_DELETEITEM, iItem, 0)
END FUNCTION

%TCM_DELETEALLITEMS      = %TCM_FIRST + 9

FUNCTION TabCtrl_DeleteAllItems (BYVAL hwnd AS DWORD) AS LONG
    FUNCTION = SendMessage(hwnd, %TCM_DELETEALLITEMS, 0, 0)
END FUNCTION

%TCM_GETITEMRECT         = %TCM_FIRST + 10

FUNCTION TabCtrl_GetItemRect (BYVAL hwnd AS DWORD, BYVAL i AS DWORD, _
   prc AS RECT) AS LONG
    FUNCTION = SendMessage(hwnd, %TCM_GETITEMRECT, i, VARPTR(prc))
END FUNCTION

%TCM_GETCURSEL           = %TCM_FIRST + 11

FUNCTION TabCtrl_GetCurSel (BYVAL hwnd AS DWORD) AS LONG
    FUNCTION = SendMessage(hwnd, %TCM_GETCURSEL, 0, 0)
END FUNCTION

%TCM_SETCURSEL           = %TCM_FIRST + 12

FUNCTION TabCtrl_SetCurSel (BYVAL hwnd AS DWORD, BYVAL i AS DWORD) AS LONG
    FUNCTION = SendMessage(hwnd, %TCM_SETCURSEL, i, 0)
END FUNCTION

%TCHT_NOWHERE            = &H0001
%TCHT_ONITEMICON         = &H0002
%TCHT_ONITEMLABEL        = &H0004
%TCHT_ONITEM             = %TCHT_ONITEMICON OR %TCHT_ONITEMLABEL

TYPE TC_HITTESTINFO
    pt AS POINTAPI
    flags AS DWORD
END TYPE

%TCM_HITTEST             = %TCM_FIRST + 13

FUNCTION TabCtrl_HitTest (BYVAL hwndTC AS DWORD, pinfo AS TC_HITTESTINFO) _
   AS LONG
    FUNCTION = SendMessage(hwndTC, %TCM_HITTEST, 0, VARPTR(pinfo))
END FUNCTION

%TCM_SETITEMEXTRA        = %TCM_FIRST + 14

FUNCTION TabCtrl_SetItemExtra (BYVAL hwndTC AS DWORD, BYVAL cb AS DWORD) _
   AS LONG
    FUNCTION = SendMessage(hwndTC, %TCM_SETITEMEXTRA, cb, 0)
END FUNCTION

%TCM_ADJUSTRECT          = %TCM_FIRST + 40

FUNCTION TabCtrl_AdjustRect (BYVAL hwnd AS DWORD, BYVAL bLarger AS DWORD, _
   prc AS RECT) AS LONG
    FUNCTION = SendMessage(hwnd, %TCM_ADJUSTRECT, bLarger, VARPTR(prc))
END FUNCTION

%TCM_SETITEMSIZE         = %TCM_FIRST + 41

FUNCTION TabCtrl_SetItemSize (BYVAL hwnd AS DWORD, BYVAL x AS INTEGER, _
   BYVAL y AS INTEGER) AS DWORD
    FUNCTION = SendMessage(hwnd, %TCM_SETITEMSIZE, 0, MAKLNG(x,y))
END FUNCTION

%TCM_REMOVEIMAGE         = %TCM_FIRST + 42

SUB TabCtrl_RemoveImage (BYVAL hwnd AS DWORD, BYVAL i AS DWORD)
    SendMessage hwnd, %TCM_REMOVEIMAGE, i, 0
END SUB

%TCM_SETPADDING          = %TCM_FIRST + 43

SUB TabCtrl_SetPadding (BYVAL hwnd AS DWORD, BYVAL cx AS INTEGER, BYVAL cy AS INTEGER)
    SendMessage hwnd, %TCM_SETPADDING, 0, MAKLNG(cx,cy)
END SUB

%TCM_GETROWCOUNT         = %TCM_FIRST + 44

FUNCTION TabCtrl_GetRowCount (BYVAL hwnd AS DWORD) AS LONG
    FUNCTION = SendMessage(hwnd, %TCM_GETROWCOUNT, 0, 0)
END FUNCTION

%TCM_GETTOOLTIPS         = %TCM_FIRST + 45

FUNCTION TabCtrl_GetToolTips (BYVAL hwnd AS DWORD) AS DWORD
    FUNCTION = SendMessage(hwnd, %TCM_GETTOOLTIPS, 0, 0)
END FUNCTION

%TCM_SETTOOLTIPS         = %TCM_FIRST + 46

SUB TabCtrl_SetToolTips (BYVAL hwnd AS DWORD, BYVAL hwndTT AS DWORD)
    SendMessage hwnd, %TCM_SETTOOLTIPS, hwndTT, 0
END SUB

%TCM_GETCURFOCUS         = %TCM_FIRST + 47

FUNCTION TabCtrl_GetCurFocus (BYVAL hwnd AS DWORD) AS LONG
    FUNCTION = SendMessage(hwnd, %TCM_GETCURFOCUS, 0, 0)
END FUNCTION

%TCM_SETCURFOCUS         = %TCM_FIRST + 48

SUB TabCtrl_SetCurFocus (BYVAL hwnd AS DWORD, BYVAL i AS DWORD)
    SendMessage hwnd, %TCM_SETCURFOCUS, i, 0
END SUB

%TCM_SETMINTABWIDTH      = %TCM_FIRST + 49

FUNCTION TabCtrl_SetMinTabWidth (BYVAL hwnd AS DWORD, BYVAL x AS LONG) AS LONG
    FUNCTION = SendMessage(hwnd, %TCM_SETMINTABWIDTH, 0, x)
END FUNCTION

%TCM_DESELECTALL         = %TCM_FIRST + 50

SUB TabCtrl_DeselectAll (BYVAL hwnd AS DWORD, BYVAL fExcludeFocus AS DWORD)
    SendMessage hwnd, %TCM_DESELECTALL, fExcludeFocus, 0
END SUB

%TCM_HIGHLIGHTITEM       = %TCM_FIRST + 51

FUNCTION TabCtrl_HighlightItem (BYVAL hwnd AS DWORD, BYVAL i AS DWORD, _
   BYVAL fHighlight AS INTEGER) AS LONG
    FUNCTION = SendMessage(hwnd, %TCM_HIGHLIGHTITEM, i, MAKLNG(fHighlight, 0))
END FUNCTION

%TCM_SETEXTENDEDSTYLE    = %TCM_FIRST + 52  ' optional wParam == mask

FUNCTION TabCtrl_SetExtendedStyle (BYVAL hwnd AS DWORD, BYVAL dw AS LONG) _
   AS DWORD
    FUNCTION = SendMessage(hwnd, %TCM_SETEXTENDEDSTYLE, 0, dw)
END FUNCTION

%TCM_GETEXTENDEDSTYLE    = %TCM_FIRST + 53

FUNCTION TabCtrl_GetExtendedStyle (BYVAL hwnd AS DWORD) AS DWORD
    FUNCTION = SendMessage(hwnd, %TCM_GETEXTENDEDSTYLE, 0, 0)
END FUNCTION

%TCM_SETUNICODEFORMAT    = %CCM_SETUNICODEFORMAT

FUNCTION TabCtrl_SetUnicodeFormat (BYVAL hwnd AS DWORD, _
   BYVAL fUnicode AS DWORD) AS LONG
    FUNCTION = SendMessage(hwnd, %TCM_SETUNICODEFORMAT, fUnicode, 0)
END FUNCTION

%TCM_GETUNICODEFORMAT    = %CCM_GETUNICODEFORMAT

FUNCTION TabCtrl_GetUnicodeFormat (BYVAL hwnd AS DWORD) AS LONG
    FUNCTION = SendMessage(hwnd, %TCM_GETUNICODEFORMAT, 0, 0)
END FUNCTION

%TCN_KEYDOWN             = %TCN_FIRST - 0

TYPE TC_KEYDOWN BYTE
    hdr    AS NMHDR
    wVKey  AS WORD
    flags  AS DWORD
END TYPE

%TCN_SELCHANGE   = %TCN_FIRST - 1
%TCN_SELCHANGING = %TCN_FIRST - 2
%TCN_GETOBJECT   = %TCN_FIRST - 3
%TCN_FOCUSCHANGE = %TCN_FIRST - 4

#ENDIF



'==============================================================================
' ANIMATE CONTROL

#IF NOT %DEF(%NOANIMATE)

$ANIMATE_CLASS          = "SysAnimate32"

' begin_r_commctrl

%ACS_CENTER             = &H0001
%ACS_TRANSPARENT        = &H0002
%ACS_AUTOPLAY           = &H0004
%ACS_TIMER              = &H0008  ' don't use threads... use timers

' end_r_commctrl

%ACM_OPEN               = %WM_USER + 100
%ACM_OPENW              = %WM_USER + 103

%ACM_PLAY               = %WM_USER + 101
%ACM_STOP               = %WM_USER + 102

%ACN_START              = 1
%ACN_STOP               = 2

SUB Animate_Create (BYVAL hWndP AS DWORD, BYVAL id AS DWORD, _
   BYVAL dwStyle AS DWORD, BYVAL hInstance AS DWORD)
    CreateWindow "SysAnimate32", BYVAL %NULL, dwStyle, 0, 0, 0, 0, hWndP, _
       id, hInstance, BYVAL %NULL
END SUB

FUNCTION Animate_Open (BYVAL hwnd AS DWORD, szName AS ASCIIZ) AS LONG
    FUNCTION = SendMessage(hwnd, %ACM_OPEN, 0, VARPTR(szName))
END FUNCTION

FUNCTION Animate_OpenEx (BYVAL hwnd AS DWORD, BYVAL hInst AS DWORD, _
   szName AS ASCIIZ) AS LONG
    FUNCTION = SendMessage(hwnd, %ACM_OPEN, hInst, VARPTR(szName))
END FUNCTION

FUNCTION Animate_Play (BYVAL hwnd AS DWORD, BYVAL nFrom AS INTEGER, _
   BYVAL nTo AS INTEGER, BYVAL rep AS DWORD) AS LONG
    FUNCTION = SendMessage(hwnd, %ACM_PLAY, rep, MAKLNG(nFrom, nTo))
END FUNCTION

FUNCTION Animate_Stop (BYVAL hwnd AS DWORD) AS LONG
    FUNCTION = SendMessage(hwnd, %ACM_STOP, 0, 0)
END FUNCTION

FUNCTION Animate_Close (BYVAL hwnd AS DWORD) AS LONG
    FUNCTION = Animate_Open(hwnd, BYVAL %NULL)
END FUNCTION

FUNCTION Animate_Seek (BYVAL hwnd AS DWORD, BYVAL FRAME AS LONG) AS LONG
    FUNCTION = Animate_Play(hwnd, FRAME, FRAME, 1)
END FUNCTION

#ENDIF



'====== MONTHCAL CONTROL ======================================================

#IF NOT %DEF(%NOMONTHCAL)

$MONTHCAL_CLASS = "SysMonthCal32"

' bit-packed array of "bold" info for a month
' if a bit is on, that day is drawn bold
' typedef DWORD MONTHDAYSTATE, FAR * LPMONTHDAYSTATE;


%MCM_FIRST = &H1000

' BOOL MonthCal_GetCurSel(HWND hmc, LPSYSTEMTIME pst)
'   returns FALSE if MCS_MULTISELECT
'   returns TRUE and sets *pst to the currently selected date otherwise
%MCM_GETCURSEL       = %MCM_FIRST + 1
FUNCTION MonthCal_GetCurSel (BYVAL hmc AS DWORD, pst AS SYSTEMTIME) AS LONG
    FUNCTION = SendMessage(hmc, %MCM_GETCURSEL, 0, VARPTR(pst))
END FUNCTION

' BOOL MonthCal_SetCurSel(HWND hmc, LPSYSTEMTIME pst)
'   returns FALSE if MCS_MULTISELECT
'   returns TRUE and sets the currently selected date to *pst otherwise
%MCM_SETCURSEL       = %MCM_FIRST + 2
FUNCTION MonthCal_SetCurSel (BYVAL hmc AS DWORD, pst AS SYSTEMTIME) AS LONG
    FUNCTION = SendMessage(hmc, %MCM_SETCURSEL, 0, VARPTR(pst))
END FUNCTION

' DWORD MonthCal_GetMaxSelCount(HWND hmc)
'   returns the maximum number of selectable days allowed
%MCM_GETMAXSELCOUNT  = %MCM_FIRST + 3
FUNCTION MonthCal_GetMaxSelCount (BYVAL hmc AS DWORD) AS DWORD
    FUNCTION = SendMessage(hmc, %MCM_GETMAXSELCOUNT, 0, 0)
END FUNCTION

' BOOL MonthCal_SetMaxSelCount(HWND hmc, UINT n)
'   sets the max number days that can be selected iff MCS_MULTISELECT
%MCM_SETMAXSELCOUNT  = %MCM_FIRST + 4
FUNCTION MonthCal_SetMaxSelCount (BYVAL hmc AS DWORD, BYVAL n AS DWORD) AS LONG
    FUNCTION = SendMessage(hmc, %MCM_SETMAXSELCOUNT, n, 0)
END FUNCTION

' BOOL MonthCal_GetSelRange(HWND hmc, LPSYSTEMTIME rgst)
'   sets rgst[0] to the first day of the selection range
'   sets rgst[1] to the last day of the selection range
%MCM_GETSELRANGE     = %MCM_FIRST + 5
FUNCTION MonthCal_GetSelRange (BYVAL hmc AS DWORD, rgst AS SYSTEMTIME) AS LONG
    FUNCTION = SendMessage(hmc, %MCM_GETSELRANGE, 0, VARPTR(rgst))
END FUNCTION

' BOOL MonthCal_SetSelRange(HWND hmc, LPSYSTEMTIME rgst)
'   selects the range of days from rgst[0] to rgst[1]
%MCM_SETSELRANGE     = %MCM_FIRST + 6
FUNCTION MonthCal_SetSelRange (BYVAL hmc AS DWORD, rgst AS SYSTEMTIME) AS LONG
    FUNCTION = SendMessage(hmc, %MCM_SETSELRANGE, 0, VARPTR(rgst))
END FUNCTION

' DWORD MonthCal_GetMonthRange(HWND hmc, DWORD gmr, LPSYSTEMTIME rgst)
'   if rgst specified, sets rgst[0] to the starting date and
'      and rgst[1] to the ending date of the the selectable (non-grayed)
'      days if GMR_VISIBLE or all the displayed days (including grayed)
'      if GMR_DAYSTATE.
'   returns the number of months spanned by the above range.
%MCM_GETMONTHRANGE   = %MCM_FIRST + 7
FUNCTION MonthCal_GetMonthRange (BYVAL hmc AS DWORD, BYVAL gmr AS DWORD, _
   rgst AS SYSTEMTIME) AS DWORD
    FUNCTION = SendMessage(hmc, %MCM_GETMONTHRANGE, gmr, VARPTR(rgst))
END FUNCTION

' BOOL MonthCal_SetDayState(HWND hmc, int cbds, DAYSTATE *rgds)
'   cbds is the count of DAYSTATE items in rgds and it must be equal
'   to the value returned from MonthCal_GetMonthRange(hmc, GMR_DAYSTATE, NULL)
'   This sets the DAYSTATE bits for each month (grayed and non-grayed
'   days) displayed in the calendar. The first bit in a month's DAYSTATE
'   corresponts to bolding day 1, the second bit affects day 2, etc.
' ** note: Microsoft's docs, above, are incorrect:
' ** DAYSTATE should actually be MONTHDAYSTATE, which is just a DWORD.
%MCM_SETDAYSTATE     = %MCM_FIRST + 8
FUNCTION MonthCal_SetDayState (BYVAL hmc AS DWORD, BYVAL cbds AS LONG, _
   rgds AS DWORD) AS LONG
    FUNCTION = SendMessage(hmc, %MCM_SETDAYSTATE, cbds, VARPTR(rgds))
END FUNCTION

' BOOL MonthCal_GetMinReqRect(HWND hmc, LPRECT prc)
'   sets *prc the minimal size needed to display one month
'   To display two months, undo the AdjustWindowRect calculation already done to
'   this rect, double the width, and redo the AdjustWindowRect calculation --
'   the monthcal control will display two calendars in this window (if you also
'   double the vertical size, you will get 4 calendars)
'   NOTE: if you want to gurantee that the "Today" string is not clipped,
'   get the MCM_GETMAXTODAYWIDTH and use the max of that width and this width
%MCM_GETMINREQRECT   = %MCM_FIRST + 9
FUNCTION MonthCal_GetMinReqRect (BYVAL hmc AS DWORD, prc AS RECT) AS LONG
    FUNCTION = SendMessage(hmc, %MCM_GETMINREQRECT, 0, VARPTR(prc))
END FUNCTION

' set colors to draw control with -- see MCSC_ bits below
%MCM_SETCOLOR            = %MCM_FIRST + 10
FUNCTION MonthCal_SetColor (BYVAL hmc AS DWORD, BYVAL iColor AS DWORD, _
   BYVAL clr AS DWORD) AS DWORD
    FUNCTION = SendMessage(hmc, %MCM_SETCOLOR, iColor, clr)
END FUNCTION

%MCM_GETCOLOR            = %MCM_FIRST + 11
FUNCTION MonthCal_GetColor (BYVAL hmc AS DWORD, BYVAL iColor AS DWORD) AS DWORD
    FUNCTION = SendMessage(hmc, %MCM_GETCOLOR, iColor, 0)
END FUNCTION

%MCSC_BACKGROUND   = 0   ' the background color (between months)
%MCSC_TEXT         = 1   ' the dates
%MCSC_TITLEBK      = 2   ' background of the title
%MCSC_TITLETEXT    = 3
%MCSC_MONTHBK      = 4   ' background within the month cal
%MCSC_TRAILINGTEXT = 5   ' the text color of header & trailing days

' set what day is "today"   send NULL to revert back to real date
%MCM_SETTODAY    = %MCM_FIRST + 12
FUNCTION MonthCal_SetToday (BYVAL hmc AS DWORD, pst AS SYSTEMTIME) AS LONG
    FUNCTION = SendMessage(hmc, %MCM_SETTODAY, 0, VARPTR(pst))
END FUNCTION

' get what day is "today"
' returns BOOL for success/failure
%MCM_GETTODAY    = %MCM_FIRST + 13
FUNCTION MonthCal_GetToday (BYVAL hmc AS DWORD, pst AS SYSTEMTIME) AS LONG
    FUNCTION = SendMessage(hmc, %MCM_GETTODAY, 0, VARPTR(pst))
END FUNCTION

TYPE MCHITTESTINFO
    cbSize AS DWORD
    pt     AS POINTAPI
    uHit   AS DWORD   ' out param
    st     AS SYSTEMTIME
END TYPE

' determine what pinfo->pt is over
%MCM_HITTEST          = %MCM_FIRST + 14
FUNCTION MonthCal_HitTest (BYVAL hmc AS DWORD, pinfo AS MCHITTESTINFO) AS DWORD
    FUNCTION = SendMessage(hmc, %MCM_HITTEST, 0, VARPTR(pinfo))
END FUNCTION

%MCHT_TITLE         = &H00010000
%MCHT_CALENDAR      = &H00020000
%MCHT_TODAYLINK     = &H00030000

%MCHT_NEXT          = &H01000000  ' these indicate that hitting
%MCHT_PREV          = &H02000000  ' here will go to the next/prev month
%MCHT_NOWHERE       = &H00000000

%MCHT_TITLEBK            = %MCHT_TITLE
%MCHT_TITLEMONTH         = %MCHT_TITLE OR &H0001
%MCHT_TITLEYEAR          = %MCHT_TITLE OR &H0002
%MCHT_TITLEBTNNEXT       = %MCHT_TITLE OR %MCHT_NEXT OR &H0003
%MCHT_TITLEBTNPREV       = %MCHT_TITLE OR %MCHT_PREV OR &H0003

%MCHT_CALENDARBK         = %MCHT_CALENDAR
%MCHT_CALENDARDATE       = %MCHT_CALENDAR OR &H0001
%MCHT_CALENDARDATENEXT   = %MCHT_CALENDARDATE OR %MCHT_NEXT
%MCHT_CALENDARDATEPREV   = %MCHT_CALENDARDATE OR %MCHT_PREV
%MCHT_CALENDARDAY        = %MCHT_CALENDAR OR &H0002
%MCHT_CALENDARWEEKNUM    = %MCHT_CALENDAR OR &H0003

' set first day of week to iDay:
' 0 for Monday, 1 for Tuesday, ..., 6 for Sunday
' -1 for means use locale info
%MCM_SETFIRSTDAYOFWEEK = %MCM_FIRST + 15
FUNCTION MonthCal_SetFirstDayOfWeek (BYVAL hmc AS DWORD, BYVAL iDay AS LONG) _
   AS DWORD
    FUNCTION = SendMessage(hmc, %MCM_SETFIRSTDAYOFWEEK, 0, iDay)
END FUNCTION

' DWORD result...  low word has the day.  high word is bool if this is app set
' or not (FALSE == using locale info)
%MCM_GETFIRSTDAYOFWEEK = %MCM_FIRST + 16
FUNCTION MonthCal_GetFirstDayOfWeek (BYVAL hmc AS DWORD) AS DWORD
    FUNCTION = SendMessage(hmc, %MCM_GETFIRSTDAYOFWEEK, 0, 0)
END FUNCTION

' DWORD MonthCal_GetRange(HWND hmc, LPSYSTEMTIME rgst)
'   modifies rgst[0] to be the minimum ALLOWABLE systemtime (0 if no minimum)
'   modifies rgst[1] to be the maximum ALLOWABLE systemtime (0 if no maximum)
'   returns GDTR_MIN or GDTR_MAX if there is a minimum or maximum limit
%MCM_GETRANGE = %MCM_FIRST + 17
FUNCTION MonthCal_GetRange (BYVAL hmc AS DWORD, rgst AS SYSTEMTIME) AS DWORD
    FUNCTION = SendMessage(hmc, %MCM_GETRANGE, 0, VARPTR(rgst))
END FUNCTION

' BOOL MonthCal_SetRange(HWND hmc, DWORD gdtr, LPSYSTEMTIME rgst)
'   if GDTR_MIN, sets the minimum ALLOWABLE systemtime to rgst[0], otherwise removes minimum
'   if GDTR_MAX, sets the maximum ALLOWABLE systemtime to rgst[1], otherwise removes maximum
'   returns TRUE on success, FALSE on error (such as invalid parameters)
%MCM_SETRANGE = %MCM_FIRST + 18
FUNCTION MonthCal_SetRange (BYVAL hmc AS DWORD, BYVAL gd AS DWORD, _
   rgst AS SYSTEMTIME) AS LONG
    FUNCTION = SendMessage(hmc, %MCM_SETRANGE, gd, VARPTR(rgst))
END FUNCTION

' int MonthCal_GetMonthDelta(HWND hmc)
'   returns the number of months one click on a next/prev button moves by
%MCM_GETMONTHDELTA = %MCM_FIRST + 19
FUNCTION MonthCal_GetMonthDelta (BYVAL hmc AS DWORD) AS LONG
    FUNCTION = SendMessage(hmc, %MCM_GETMONTHDELTA, 0, 0)
END FUNCTION

' int MonthCal_SetMonthDelta(HWND hmc, int n)
'   sets the month delta to n. n==0 reverts to moving by a page of months
'   returns the previous value of n.
%MCM_SETMONTHDELTA = %MCM_FIRST + 20
FUNCTION MonthCal_SetMonthDelta (BYVAL hmc AS DWORD, BYVAL n AS LONG) AS LONG
    FUNCTION = SendMessage(hmc, %MCM_SETMONTHDELTA, n, 0)
END FUNCTION

' DWORD MonthCal_GetMaxTodayWidth(HWND hmc, LPSIZE psz)
'   sets *psz to the maximum width/height of the "Today" string displayed
'   at the bottom of the calendar (as long as MCS_NOTODAY is not specified)
'   -- (the above bit of Microsoft documentation is flagrantly confused) --
%MCM_GETMAXTODAYWIDTH = %MCM_FIRST + 21
FUNCTION MonthCal_GetMaxTodayWidth (BYVAL hmc AS DWORD) AS DWORD
    FUNCTION = SendMessage(hmc, %MCM_GETMAXTODAYWIDTH, 0, 0)
END FUNCTION

%MCM_SETUNICODEFORMAT = %CCM_SETUNICODEFORMAT
FUNCTION MonthCal_SetUnicodeFormat (BYVAL hwnd AS DWORD, _
   BYVAL fUnicode AS DWORD) AS LONG
    FUNCTION = SendMessage(hwnd, %MCM_SETUNICODEFORMAT, fUnicode, 0)
END FUNCTION

%MCM_GETUNICODEFORMAT = %CCM_GETUNICODEFORMAT
FUNCTION MonthCal_GetUnicodeFormat (BYVAL hwnd AS DWORD) AS LONG
    FUNCTION = SendMessage(hwnd, %MCM_GETUNICODEFORMAT, 0, 0)
END FUNCTION

' MCN_SELCHANGE is sent whenever the currently displayed date changes
' via month change, year change, keyboard navigation, prev/next button
'
TYPE NMSELCHANGE
    hdr AS NMHDR          ' this must be first, so we don't break WM_NOTIFY
    stSelStart AS SYSTEMTIME
    stSelEnd AS SYSTEMTIME
END TYPE

TYPE NMSELECT
    hdr AS NMHDR          ' this must be first, so we don't break WM_NOTIFY
    stSelStart AS SYSTEMTIME
    stSelEnd AS SYSTEMTIME
END TYPE

%MCN_SELCHANGE       = %MCN_FIRST + 1

' MCN_GETDAYSTATE is sent for MCS_DAYSTATE controls whenever new daystate
' information is needed (month or year scroll) to draw bolding information.
' The app must fill in cDayState months worth of information starting from
' stStart date. The app may fill in the array at prgDayState or change
' prgDayState to point to a different array out of which the information
' will be copied. (similar to tooltips)
'
TYPE NMDAYSTATE
    hdr AS NMHDR          ' this must be first, so we don't break WM_NOTIFY
    stStart AS SYSTEMTIME
    cDayState AS LONG
    prgDayState AS DWORD PTR ' points to cDayState MONTHDAYSTATEs
END TYPE

%MCN_GETDAYSTATE     = %MCN_FIRST + 3

' MCN_SELECT is sent whenever a selection has occured (via mouse or keyboard)
'
%MCN_SELECT          = %MCN_FIRST + 4


' begin_r_commctrl

%MCS_DAYSTATE        = &H0001
%MCS_MULTISELECT     = &H0002
%MCS_WEEKNUMBERS     = &H0004
%MCS_NOTODAYCIRCLE   = &H0008
%MCS_NOTODAY         = &H0010

' end_r_commctrl

%GMR_VISIBLE     = 0       ' visible portion of display
%GMR_DAYSTATE    = 1       ' above plus the grayed out parts of
                           ' partially displayed months

#ENDIF ' NOMONTHCAL



'====== DATETIMEPICK CONTROL ==================================================

#IF NOT %DEF(%NODATETIMEPICK)

$DATETIMEPICK_CLASS = "SysDateTimePick32"

%DTM_FIRST        = &H1000

' DWORD DateTimePick_GetSystemtime(HWND hdp, LPSYSTEMTIME pst)
'   returns GDT_NONE if "none" is selected (DTS_SHOWNONE only)
'   returns GDT_VALID and modifies *pst to be the currently selected value
%DTM_GETSYSTEMTIME   = %DTM_FIRST + 1
FUNCTION DateTime_GetSystemtime (BYVAL hdp AS DWORD, pst AS SYSTEMTIME) _
   AS DWORD
    FUNCTION = SendMessage(hdp, %DTM_GETSYSTEMTIME, 0, VARPTR(pst))
END FUNCTION

' BOOL DateTime_SetSystemtime(HWND hdp, DWORD gd, LPSYSTEMTIME pst)
'   if gd==GDT_NONE, sets datetimepick to None (DTS_SHOWNONE only)
'   if gd==GDT_VALID, sets datetimepick to *pst
'   returns TRUE on success, FALSE on error (such as bad params)
%DTM_SETSYSTEMTIME   = %DTM_FIRST + 2
FUNCTION DateTime_SetSystemtime (BYVAL hdp AS DWORD, BYVAL gd AS DWORD, _
   pst AS SYSTEMTIME) AS LONG
    FUNCTION = SendMessage(hdp, %DTM_SETSYSTEMTIME, gd, VARPTR(pst))
END FUNCTION

' DWORD DateTime_GetRange(HWND hdp, LPSYSTEMTIME rgst)
'   modifies rgst[0] to be the minimum ALLOWABLE systemtime (or 0 if no minimum)
'   modifies rgst[1] to be the maximum ALLOWABLE systemtime (or 0 if no maximum)
'   returns GDTR_MIN or GDTR_MAX if there is a minimum or maximum limit
%DTM_GETRANGE = %DTM_FIRST + 3
FUNCTION DateTime_GetRange (BYVAL hdp AS DWORD, rgst AS SYSTEMTIME) AS DWORD
    FUNCTION = SendMessage(hdp, %DTM_GETRANGE, 0, VARPTR(rgst))
END FUNCTION

' BOOL DateTime_SetRange(HWND hdp, DWORD gdtr, LPSYSTEMTIME rgst)
'   if GDTR_MIN, sets the minimum ALLOWABLE systemtime to rgst[0],
'       otherwise removes minimum
'   if GDTR_MAX, sets the maximum ALLOWABLE systemtime to rgst[1],
'       otherwise removes maximum
'   returns TRUE on success, FALSE on error (such as invalid parameters)
%DTM_SETRANGE = %DTM_FIRST + 4
FUNCTION DateTime_SetRange (BYVAL hdp AS DWORD, BYVAL gd AS DWORD, _
   rgst AS SYSTEMTIME) AS LONG
    FUNCTION = SendMessage(hdp, %DTM_SETRANGE, gd, VARPTR(rgst))
END FUNCTION

' BOOL DateTime_SetFormat(HWND hdp, LPCTSTR sz)
'   sets the display formatting string to sz (see GetDateFormat and GetTimeFormat for valid formatting chars)
'   NOTE: 'X' is a valid formatting character which indicates that the application
'   will determine how to display information. Such apps must support DTN_WMKEYDOWN,
'   DTN_FORMAT, and DTN_FORMATQUERY.
%DTM_SETFORMAT  = %DTM_FIRST + 5
%DTM_SETFORMATW = %DTM_FIRST + 50
FUNCTION DateTime_SetFormat (BYVAL hdp AS DWORD, sz AS ASCIIZ) AS LONG
    FUNCTION = SendMessage(hdp, %DTM_SETFORMAT, 0, VARPTR(sz))
END FUNCTION


%DTM_SETMCCOLOR    = %DTM_FIRST + 6
FUNCTION DateTime_SetMonthCalColor (BYVAL hdp AS DWORD, _
   BYVAL iColor AS DWORD, BYVAL clr AS DWORD) AS DWORD
    FUNCTION = SendMessage(hdp, %DTM_SETMCCOLOR, iColor, clr)
END FUNCTION

%DTM_GETMCCOLOR    = %DTM_FIRST + 7
FUNCTION DateTime_GetMonthCalColor(BYVAL hdp AS DWORD, iColor AS DWORD) _
   AS DWORD
    FUNCTION = SendMessage(hdp, %DTM_GETMCCOLOR, iColor, 0)
END FUNCTION

' HWND DateTime_GetMonthCal(HWND hdp)
'   returns the HWND of the MonthCal popup window. Only valid
' between DTN_DROPDOWN and DTN_CLOSEUP notifications.
%DTM_GETMONTHCAL   = %DTM_FIRST + 8
FUNCTION DateTime_GetMonthCal (BYVAL hdp AS DWORD) AS DWORD
    FUNCTION = SendMessage(hdp, %DTM_GETMONTHCAL, 0, 0)
END FUNCTION

%DTM_SETMCFONT     = %DTM_FIRST + 9
SUB DateTime_SetMonthCalFont (BYVAL hdp AS DWORD, BYVAL hfont AS DWORD, _
   BYVAL fRedraw AS LONG)
    SendMessage hdp, %DTM_SETMCFONT, hfont, fRedraw
END SUB

%DTM_GETMCFONT     = %DTM_FIRST + 10
FUNCTION DateTime_GetMonthCalFont (BYVAL hdp AS DWORD) AS DWORD
    FUNCTION = SendMessage(hdp, %DTM_GETMCFONT, 0, 0)
END FUNCTION

' begin_r_commctrl

%DTS_UPDOWN          = &H0001 ' use UPDOWN instead of MONTHCAL
%DTS_SHOWNONE        = &H0002 ' allow a NONE selection
%DTS_SHORTDATEFORMAT = &H0000 ' use the short date format (app must forward WM_WININICHANGE messages)
%DTS_LONGDATEFORMAT  = &H0004 ' use the long date format (app must forward WM_WININICHANGE messages)
%DTS_SHORTDATECENTURYFORMAT = &H000C ' short date format with century (app must forward WM_WININICHANGE messages)
%DTS_TIMEFORMAT      = &H0009 ' use the time format (app must forward WM_WININICHANGE messages)
%DTS_APPCANPARSE     = &H0010 ' allow user entered strings (app MUST respond to DTN_USERSTRING)
%DTS_RIGHTALIGN      = &H0020 ' right-align popup instead of left-align it

' end_r_commctrl

%DTN_DATETIMECHANGE  = %DTN_FIRST + 1 ' the systemtime has changed

TYPE NMDATETIMECHANGE
    hdr     AS NMHDR
    dwFlags AS DWORD        ' GDT_VALID or GDT_NONE
    st      AS SYSTEMTIME   ' valid iff dwFlags==GDT_VALID
END TYPE

%DTN_USERSTRING   = %DTN_FIRST + 2  ' the user has entered a string
%DTN_USERSTRINGW  = %DTN_FIRST + 15

TYPE NMDATETIMESTRING
    hdr           AS NMHDR
    pszUserString AS ASCIIZ PTR  ' string user entered
    st            AS SYSTEMTIME  ' app fills this in
    dwFlags       AS DWORD       ' GDT_VALID or GDT_NONE
END TYPE

%DTN_WMKEYDOWN   = %DTN_FIRST + 3  ' modify keydown on app format field (X)
%DTN_WMKEYDOWNW  = %DTN_FIRST + 16

TYPE NMDATETIMEWMKEYDOWN
    hdr       AS NMHDR
    nVirtKey  AS LONG       ' virtual key code of WM_KEYDOWN which MODIFIES an X field
    pszFormat AS ASCIIZ PTR ' format substring
    st        AS SYSTEMTIME ' current systemtime, app should modify based on key
END TYPE

%DTN_FORMAT   = %DTN_FIRST + 4  ' query display for app format field (X)
%DTN_FORMATW  = %DTN_FIRST + 17

TYPE NMDATETIMEFORMAT
    hdr        AS NMHDR
    pszFormat  AS ASCIIZ PTR  ' format substring
    st         AS SYSTEMTIME  ' current systemtime
    pszDisplay AS ASCIIZ PTR  ' string to display
    szDisplay  AS ASCIIZ * 64 ' buffer pszDisplay originally points at
END TYPE

%DTN_FORMATQUERY  = %DTN_FIRST + 5  ' query formatting info for app format field (X)
%DTN_FORMATQUERYW = %DTN_FIRST + 18

TYPE NMDATETIMEFORMATQUERY
    hdr       AS NMHDR
    pszFormat AS ASCIIZ PTR ' format substring
    szMax     AS apiSIZE    ' max bounding rectangle app will use for this format string
END TYPE

%DTN_DROPDOWN   = %DTN_FIRST + 6  ' MonthCal has dropped down
%DTN_CLOSEUP    = %DTN_FIRST + 7  ' MonthCal is popping up

%GDTR_MIN       = &H0001
%GDTR_MAX       = &H0002

%GDT_ERROR      = -1
%GDT_VALID      = 0
%GDT_NONE       = 1

#ENDIF ' NODATETIMEPICK



'======= IP Address edit control ==============================================

#IF NOT %DEF(%NOIPADDRESS)


' Messages sent to IPAddress controls

%IPM_CLEARADDRESS  = %WM_USER + 100 ' no parameters
%IPM_SETADDRESS    = %WM_USER + 101 ' lparam = TCP/IP address
%IPM_GETADDRESS    = %WM_USER + 102 ' lresult = # of non black fields. lparam = LPDWORD for TCP/IP address
%IPM_SETRANGE      = %WM_USER + 103 ' wparam = field, lparam = range
%IPM_SETFOCUS      = %WM_USER + 104 ' wparam = field
%IPM_ISBLANK       = %WM_USER + 105 ' no parameters

$WC_IPADDRESS = "SysIPAddress32"

%IPN_FIELDCHANGED  = %IPN_FIRST

TYPE NMIPADDRESS
    hdr    AS NMHDR
    iField AS LONG
    iValue AS LONG
END TYPE

' The following is a useful macro for passing the range values in the
' IPM_SETRANGE message.

FUNCTION MAKEIPRANGE (BYVAL low AS BYTE, BYVAL high AS BYTE) AS LONG
    LOCAL dHigh AS DWORD
    dHigh = high
    SHIFT LEFT dHigh, 8
    dHigh = dHigh OR low
    FUNCTION = dHigh
END FUNCTION

' And this is a useful macro for making the IP Address to be passed
' as a LPARAM.

FUNCTION MAKEIPADDRESS (BYVAL b1 AS DWORD, BYVAL b2 AS DWORD, _
   BYVAL b3 AS DWORD, BYVAL b4 AS DWORD) AS LONG
    SHIFT LEFT b1, 24
    SHIFT LEFT b2, 16
    SHIFT LEFT b3, 8
    FUNCTION = b1 + b2 + b3 + b4
END FUNCTION

' Get individual number

FUNCTION FIRST_IPADDRESS (BYVAL x AS DWORD) AS DWORD
    SHIFT RIGHT x, 24
    FUNCTION = x AND &HFF???
END FUNCTION

FUNCTION SECOND_IPADDRESS (BYVAL x AS DWORD) AS DWORD
    SHIFT RIGHT x, 16
    FUNCTION = x AND &HFF???
END FUNCTION

FUNCTION THIRD_IPADDRESS (BYVAL x AS DWORD) AS DWORD
    SHIFT RIGHT x, 8
    FUNCTION = x AND &HFF???
END FUNCTION

FUNCTION FOURTH_IPADDRESS (BYVAL x AS DWORD) AS DWORD
    FUNCTION = x AND &HFF???
END FUNCTION

#ENDIF ' NOIPADDRESS



' ====================== Pager Control =============================

#IF NOT %DEF(%NOPAGESCROLLER)

'Pager Class Name

$WC_PAGESCROLLER = "SysPager"


'------------------------------------------------------------------------------
' Pager Control Styles
'------------------------------------------------------------------------------
' begin_r_commctrl
%PGS_VERT                = &H00000000
%PGS_HORZ                = &H00000001
%PGS_AUTOSCROLL          = &H00000002
%PGS_DRAGNDROP           = &H00000004
' end_r_commctrl


'------------------------------------------------------------------------------
' Pager Button State
'------------------------------------------------------------------------------
'The scroll can be in one of the following control State
%PGF_INVISIBLE       = 0      ' Scroll button is not visible
%PGF_NORMAL          = 1      ' Scroll button is in normal state
%PGF_GRAYED          = 2      ' Scroll button is in grayed state
%PGF_DEPRESSED       = 4      ' Scroll button is in depressed state
%PGF_HOT             = 8      ' Scroll button is in hot state


' The following identifiers specifies the button control
%PGB_TOPORLEFT       = 0
%PGB_BOTTOMORRIGHT   = 1

'------------------------------------------------------------------------------
' Pager Control  Messages
'------------------------------------------------------------------------------
%PGM_SETCHILD            = %PGM_FIRST + 1  ' lParam == hwnd
SUB Pager_SetChild (BYVAL hwnd AS DWORD, BYVAL hwndChild AS DWORD)
    SendMessage hwnd, %PGM_SETCHILD, 0, hwndChild
END SUB

%PGM_RECALCSIZE          = %PGM_FIRST + 2
SUB Pager_RecalcSize (BYVAL hwnd AS DWORD)
    SendMessage  hwnd, %PGM_RECALCSIZE, 0, 0
END SUB

%PGM_FORWARDMOUSE        = %PGM_FIRST + 3
SUB Pager_ForwardMouse (BYVAL hwnd AS DWORD, BYVAL bForward AS BYTE)
    SendMessage hwnd, %PGM_FORWARDMOUSE, bForward, 0
END SUB

%PGM_SETBKCOLOR          = %PGM_FIRST + 4
FUNCTION Pager_SetBkColor (BYVAL hwnd AS DWORD, BYVAL clr AS DWORD) AS DWORD
    FUNCTION = SendMessage(hwnd, %PGM_SETBKCOLOR, 0, clr)
END FUNCTION

%PGM_GETBKCOLOR          = %PGM_FIRST + 5
FUNCTION Pager_GetBkColor (BYVAL hwnd AS DWORD) AS DWORD
    FUNCTION = SendMessage(hwnd, %PGM_GETBKCOLOR, 0, 0)
END FUNCTION

%PGM_SETBORDER          = %PGM_FIRST + 6
FUNCTION Pager_SetBorder (BYVAL hwnd AS DWORD, BYVAL iBorder AS LONG) AS LONG
    FUNCTION = SendMessage(hwnd, %PGM_SETBORDER, 0, iBorder)
END FUNCTION

%PGM_GETBORDER          = %PGM_FIRST + 7
FUNCTION Pager_GetBorder (BYVAL hwnd AS DWORD) AS LONG
    FUNCTION = SendMessage(hwnd, %PGM_GETBORDER, 0, 0)
END FUNCTION

%PGM_SETPOS              = %PGM_FIRST + 8
FUNCTION Pager_SetPos (BYVAL hwnd AS DWORD, BYVAL iPos AS LONG) AS LONG
    FUNCTION = SendMessage(hwnd, %PGM_SETPOS, 0, iPos)
END FUNCTION

%PGM_GETPOS              = %PGM_FIRST + 9
FUNCTION Pager_GetPos (BYVAL hwnd AS DWORD) AS LONG
    FUNCTION = SendMessage(hwnd, %PGM_GETPOS, 0, 0)
END FUNCTION

%PGM_SETBUTTONSIZE       = %PGM_FIRST + 10
FUNCTION Pager_SetButtonSize (BYVAL hwnd AS DWORD, BYVAL iSize AS LONG) AS LONG
    FUNCTION = SendMessage(hwnd, %PGM_SETBUTTONSIZE, 0, iSize)
END FUNCTION

%PGM_GETBUTTONSIZE       = %PGM_FIRST + 11
FUNCTION Pager_GetButtonSize (BYVAL hwnd AS DWORD) AS LONG
    FUNCTION = SendMessage(hwnd, %PGM_GETBUTTONSIZE, 0, 0)
END FUNCTION

%PGM_GETBUTTONSTATE      = %PGM_FIRST + 12
FUNCTION Pager_GetButtonState (BYVAL hwnd AS DWORD, BYVAL iButton AS LONG) _
   AS DWORD
    FUNCTION = SendMessage(hwnd, %PGM_GETBUTTONSTATE, 0, iButton)
END FUNCTION

%PGM_GETDROPTARGET       = %CCM_GETDROPTARGET
SUB Pager_GetDropTarget (BYVAL hwnd AS DWORD, ppdt AS DWORD)
    SendMessage hwnd, %PGM_GETDROPTARGET, 0, VARPTR(ppdt)
END SUB

'---------------------------------------------------------------------------------------
'Pager Control Notification Messages
'---------------------------------------------------------------------------------------


' PGN_SCROLL Notification Message

%PGN_SCROLL          = %PGN_FIRST - 1

%PGF_SCROLLUP        = 1
%PGF_SCROLLDOWN      = 2
%PGF_SCROLLLEFT      = 4
%PGF_SCROLLRIGHT     = 8


'Keys down
%PGK_SHIFT           = 1
%PGK_CONTROL         = 2
%PGK_MENU            = 4


' This structure is sent along with PGN_SCROLL notifications

TYPE NMPGSCROLL BYTE
    hdr      AS NMHDR
    fwKeys   AS WORD  ' Specifies which keys are down when this notification is sent
    rcParent AS RECT  ' Contains Parent Window Rect
    iDir     AS LONG  ' Scrolling Direction
    iXpos    AS LONG  ' Horizontal scroll position
    iYpos    AS LONG  ' Vertical scroll position
    iScroll  AS LONG  ' [in/out] Amount to scroll
END TYPE


' PGN_CALCSIZE Notification Message

%PGN_CALCSIZE        = %PGN_FIRST - 2

%PGF_CALCWIDTH       = 1
%PGF_CALCHEIGHT      = 2

TYPE NMPGCALCSIZE
    hdr AS NMHDR
    dwFlag AS DWORD
    iWidth AS LONG
    iHeight AS LONG
END TYPE

#ENDIF ' NOPAGESCROLLER



'==============================================================================
' === Native Font Control ===

#IF NOT %DEF(%NONATIVEFONTCTL)

'NativeFont Class Name
$WC_NATIVEFONTCTL = "NativeFontCtl"

' begin_r_commctrl

' style definition
%NFS_EDIT                = &H0001
%NFS_STATIC              = &H0002
%NFS_LISTCOMBO           = &H0004
%NFS_BUTTON              = &H0008
%NFS_ALL                 = &H0010
%NFS_USEFONTASSOC        = &H0020

' end_r_commctrl

#ENDIF ' NONATIVEFONTCTL



'====== MUI APIs =============================================================

#IF NOT %DEF(%NOMUI)

DECLARE SUB InitMUILanguage LIB "COMCTL32.DLL" ALIAS "InitMUILanguage" _
    (BYVAL uiLang AS DWORD)

DECLARE FUNCTION GetMUILanguage LIB "COMCTL32.DLL" ALIAS "GetMUILanguage" () _
    AS DWORD

#ENDIF



'====== TrackMouseEvent  =====================================================

#IF NOT %DEF(%NOTRACKMOUSEEVENT)

' If the messages for TrackMouseEvent have not been defined then define them
' now.
'
#IF NOT %DEF(%WM_MOUSEHOVER)
%WM_MOUSEHOVER                 = &H02A1
%WM_MOUSELEAVE                 = &H02A3
#ENDIF  ' %WM_MOUSEHOVER

'
' If the TRACKMOUSEEVENT structure and associated flags havent been declared
' then declare them now.
'
#IF NOT %DEF(%TME_HOVER)
%TME_HOVER      = &H00000001
%TME_LEAVE      = &H00000002
%TME_NONCLIENT  = &H00000010
%TME_QUERY      = &H40000000
%TME_CANCEL     = &H80000000

%HOVER_DEFAULT  = &HFFFFFFFF

TYPE EVENTTRACK
    cbSize      AS DWORD
    dwFlags     AS DWORD
    hwndTrack   AS DWORD
    dwHoverTime AS DWORD
END TYPE

#ENDIF  ' %TME_HOVER

'
' Declare _TrackMouseEvent.  This API tries to use the window manager's
' implementation of TrackMouseEvent if it is present, otherwise it emulates.
'
DECLARE FUNCTION TrackMouseEvent LIB "USER32.DLL" ALIAS "TrackMouseEvent" _
   (lpEventTrack AS EVENTTRACK) AS LONG

#ENDIF  ' %NOTRACKMOUSEEVENT



'==============================================================================
' BUTTON CONTROL

#IF NOT %DEF(%NOBUTTON)


'------------------------------------------------------------------------------
'  TITLE: Button_Click
'   DESC: Simulate the user clicking a button. This causes the button to
'         receive a %WM_LBUTTONDOWN and a %WM_LBUTTONUP message, and the
'         button's parent window to receive a %BN_CLICKED notification message.
' SYNTAX: Button_Click hButton
'
SUB Button_Click (BYVAL hButton AS DWORD)
    SendMessage hButton, %BM_CLICK, 0, 0
END SUB

'------------------------------------------------------------------------------
'  TITLE: Button_GetCheck
'   DESC: Retrieve the check state of a radio button or check box.
' SYNTAX: state = Button_GetCheck(hButton)
'  NOTES: The return value from a button created with the %BS_AUTOCHECKBOX,
'         %BS_AUTORADIOBUTTON, %BS_AUTO3STATE, %BS_CHECKBOX, %BS_RADIOBUTTON,
'         or %BS_3STATE style can be one of the following:
'
'         Value               Meaning
'         -----               -------
'         0                   Button is unchecked
'         1                   Button is checked
'         2                   Button is grayed, indicating an indeterminate
'                             state (applies only if the button has the
'                             %BS_3STATE or %BS_AUTO3STATE style)
'         %BST_UNCHECKED      Button is unchecked
'         %BST_CHECKED        Button is checked
'         %BST_INDETERMINATE  Button is grayed, indicating an indeterminate
'                             state (applies only if the button has the
'                             %BS_3STATE or %BS_AUTO3STATE style)
'
'         If the button has any other style, the return value is zero.
'
FUNCTION Button_GetCheck (BYVAL hButton AS DWORD) AS LONG
    FUNCTION = SendMessage(hButton, %BM_GETCHECK, 0, 0)
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Button_GetImage
'   DESC: Retrieve the handle of the image (icon or bitmap) associated with
'         the button.
' SYNTAX: hImage = Button_GetImage(hButton)
'  NOTES: The return value is the handle of the image, if any; otherwise,
'         it is %NULL.
'
FUNCTION Button_GetImage (BYVAL hButton AS DWORD) AS LONG
    FUNCTION = SendMessage(hButton, %BM_GETIMAGE, 0, 0)
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Button_GetState
'   DESC: Determine the state of a button or check box.
' SYNTAX: state = Button_GetState(hButton)
'  NOTES: The return value specifies the current state of the button. You can
'         use the following bitmasks to extract information about the state:
'
'         Value              Meaning
'         -----              -------
'         &H0003             Specifies the check state (radio buttons and check
'                            boxes only). A value of zero indicates the button
'                            is unchecked; a value of 1 indicates the button is
'                            checked. A radio button is checked when it
'                            contains a dot; a check box is checked when it
'                            contains an X. A value of 2 indicates the check
'                            state is indeterminate (applies only if the button
'                            has the %BS_3STATE or %BS_AUTO3STATE style). A
'                            three-state check box is grayed when its state is
'                            indeterminate.
'         &H0004             Specifies the highlight state. A nonzero value
'                            indicates that the button is highlighted. A button
'                            is automatically highlighted when the user
'                            positions the cursor over it and presses and
'                            holds the left mouse button. The highlighting is
'                            removed when the user releases the mouse button.
'         &H0008             Specifies the focus state. A nonzero value
'                            indicates that the button has the keyboard focus.
'         %BST_CHECKED       Windows 95 only: Indicates the button is checked.
'                            Same as the Windows NT return value of 1.
'         %BST_FOCUS         Windows 95 only: Indicates the button has the
'                            keyboard focus. Same as the Windows NT return
'                            value of &H0008.
'         %BST_INDETERMINATE Windows 95 only: Indicates the button is grayed
'                            because the state of the button is indeterminate.
'                            This value applies only if the button has the
'                            %BS_3STATE or %BS_AUTO3STATE style. Same as the
'                            Windows NT return value of 2.
'         %BST_PUSHED        Windows 95 only: Indicates the button is
'                            highlighted as if the user had pushed it. Same as
'                            the Windows NT return value of &H0004.
'         %BST_UNCHECKED     Windows 95 only: Indicates the button is unchecked.
'                            Same as the Windows NT return value of zero.
'
FUNCTION Button_GetState (BYVAL hButton AS DWORD) AS LONG
    FUNCTION = SendMessage(hButton, %BM_GETSTATE, 0, 0)
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Button_SetCheck
'   DESC: Set the check state of a radio button or check box.
' SYNTAX: Button_GetState hButton, state
'  NOTES: see Button_GetCheck
'
SUB Button_SetCheck (BYVAL hButton AS DWORD, BYVAL STATE AS DWORD)
    SendMessage hButton, %BM_SETCHECK, STATE, 0
END SUB

'------------------------------------------------------------------------------
'  TITLE: Button_SetImage
'   DESC: Associate a new image (icon or bitmap) with the button.
' SYNTAX: hOldImage = Button_SetImage(hButton, hNewImage)
'  NOTES: The return value is the handle of the image previously associated
'         with the button, if any; otherwise, it is %NULL.
'
FUNCTION Button_SetImage (BYVAL hButton AS DWORD, BYVAL hImage AS DWORD) _
   AS LONG
    FUNCTION = SendMessage(hButton, %BM_SETIMAGE, 0, hImage)
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Button_SetState
'   DESC: Change the highlight state of a button. The highlight state indicates
'         whether the button is highlighted as if the user had pushed it.
' SYNTAX: Button_SetState hButton, state
'  NOTES: 'state' is TRUE to highlight the button or FALSE to remove any
'         highlighting.
'
FUNCTION Button_SetState (BYVAL hButton AS DWORD, BYVAL STATE AS DWORD) _
   AS DWORD
    FUNCTION = SendMessage(hButton, %BM_SETSTATE, ISTRUE(STATE) AND 1, 0)
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Button_SetStyle
'   DESC: Change the style of a button.
' SYNTAX: Button_SetStyle hButton, state, redraw
'  NOTES: Following are the available button styles:
'
'        Style                Meaning
'        -----                -------
'        %BS_3STATE           Creates a button that is the same as a check box,
'                             except that the box can be grayed as well as
'                             checked or unchecked. Use the grayed state to
'                             show that the state of the check box is not
'                             determined.
'        %BS_AUTO3STATE       Creates a button that is the same as a three-state
'                             check box, except that the box changes its state
'                             when the user selects it. The state cycles through
'                             checked, grayed, and unchecked.
'        %BS_AUTOCHECKBOX     Creates a button that is the same as a check box,
'                             except that the check state automatically toggles
'                             between checked and unchecked each time the user
'                             selects the check box.
'        %BS_AUTORADIOBUTTON  Creates a button that is the same as a radio
'                             button, except that when the user selects it,
'                             Windows automatically sets the button's check
'                             state to checked and automatically sets the check
'                             state for all other buttons in the same group to
'                             unchecked.
'        %BS_CHECKBOX         Creates a small, empty check box with text. By
'                             default, the text is displayed to the right of
'                             the check box. To display the text to the left of
'                             the check box, combine this flag with the
'                             %BS_LEFTTEXT style (or on Windows 95 only, with
'                             the equivalent %BS_RIGHTBUTTON style).
'        %BS_DEFPUSHBUTTON    Creates a push button that behaves like a
'                             %BS_PUSHBUTTON style button, but also has a heavy
'                             black border. If the button is in a dialog box,
'                             the user can select the button by pressing the
'                             ENTER key, even when the button does not have the
'                             input focus. This style is useful for enabling
'                             the user to quickly select the most likely
'                             (default) option.
'        %BS_GROUPBOX         Creates a rectangle in which other controls can
'                             be grouped. Any text associated with this style
'                             is displayed in the rectangle's upper left corner.
'        %BS_LEFTTEXT         Places text on the left side of the radio button
'                             or check box when combined with a radio button or
'                             check box style. Same as the Windows 95
'                             %BS_RIGHTBUTTON style.
'        %BS_OWNERDRAW        Creates an owner-drawn button. The owner window
'                             receives a %WM_MEASUREITEM message when the
'                             button is created and a %WM_DRAWITEM message
'                             when a visual aspect of the button has changed.
'                             Do not combine the %BS_OWNERDRAW style with any
'                             other button styles.
'        %BS_PUSHBUTTON       Creates a push button that posts a %WM_COMMAND
'                             message to the owner window when the user selects
'                             the button.
'        %BS_RADIOBUTTON      Creates a small circle with text. By default, the
'                             text is displayed to the right of the circle. To
'                             display the text to the left of the circle,
'                             combine this flag with the %BS_LEFTTEXT style (or
'                             on Windows 95 only, with the equivalent
'                             %BS_RIGHTBUTTON style). Use radio buttons for
'                             groups of related, but mutually exclusive choices.
'        %BS_BITMAP           Windows 95 only: Specifies that the button
'                             displays a bitmap.
'        %BS_BOTTOM           Windows 95 only: Places text at the bottom of the
'                             button rectangle.
'        %BS_CENTER           Windows 95 only: Centers text horizontally in the
'                             button rectangle.
'        %BS_ICON             Windows 95 only: Specifies that the button displays
'                             an icon.
'        %BS_LEFT             Windows 95 only: Left-justifies the text in the
'                             button rectangle. However, if the button is a
'                             check box or radio button that does not have the
'                             %BS_RIGHTBUTTON style, the text is left justified
'                             on the right side of the check box or radio button.
'        %BS_MULTILINE        Windows 95 only: Wraps the button text to multiple
'                             lines if the text string is too long to fit on a
'                             single line in the button rectangle.
'        %BS_NOTIFY           Windows 95 only: Enables a button to send
'                             %BN_DBLCLK, %BN_KILLFOCUS, and %BN_SETFOCUS
'                             notification messages to its parent window. Note
'                             that buttons send the %BN_CLICKED notification
'                             message regardless of whether it has this style.
'        %BS_PUSHLIKE         Windows 95 only: Makes a button (such as a check
'                             box, three-state check box, or radio button) look
'                             and act like a push button. The button looks raised
'                             when it isn't pushed or checked, and sunken when
'                             it is pushed or checked.
'        %BS_RIGHT            Windows 95 only: Right-justifies text in the
'                             button rectangle. However, if the button is a
'                             check box or radio button that does not have the
'                             %BS_RIGHTBUTTON style, the text is right justified
'                             on the right side of the check box or radio
'                             button.
'        %BS_RIGHTBUTTON      Windows 95 only: Positions a radio button's circle
'                             or a check box's square on the right side of the
'                             button rectangle. Same as the %BS_LEFTTEXT style.
'        %BS_TEXT             Windows 95 only: Specifies that the button displays
'                             text.
'        %BS_TOP              Windows 95 only: Places text at the top of the
'                             button rectangle.
'        %BS_VCENTER          Windows 95 only: Places text in the middle
'                             (vertically) of the button rectangle.
'
SUB Button_SetStyle (BYVAL hButton AS DWORD, BYVAL style AS DWORD, _
   BYVAL redraw AS LONG)
    SendMessage hButton, %BM_SETSTYLE, style, ISTRUE(redraw) AND 1
END SUB

'------------------------------------------------------------------------------
'  TITLE: Button_SetText
'   DESC: Change the text of a button.
' SYNTAX: Button_SetText hButton, text
'
SUB Button_SetText (BYVAL hButton AS DWORD, TEXT AS STRING)
    SetWindowText hButton, BYCOPY TEXT
END SUB

#ENDIF  ' %NOBUTTON

'==============================================================================
' EDIT CONTROL

#IF NOT %DEF(%NOEDIT)

'------------------------------------------------------------------------------
'  TITLE: Edit_CanUndo
'   DESC: Determine whether an edit-control operation can be undone; that is,
'         whether the control can respond to the %EM_UNDO message.
' SYNTAX: success = Edit_CanUndo(hEdit)
'
FUNCTION Edit_CanUndo (BYVAL hEdit AS DWORD) AS LONG
    FUNCTION = SendMessage(hEdit, %EM_CANUNDO, 0, 0)
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Edit_CharFromPos
'   DESC: Retrieve the zero-based character index and zero-based line index of
'         the character nearest the specified point in an edit control.
' SYNTAX: nPos = Edit_CharFromPos(hEdit, x, y)
'  NOTES: 'x' specifies the x-coordinate of a point in the edit control's
'         client area. The coordinate is relative to the upper-left corner of
'         the client area. 'y' specifies the y-coordinate of a point in the
'         edit control's client area. The coordinate is relative to the
'         upper-left corner of the client area. he return value specifies the
'         character index in the low-order word and the line index in the
'         high-order word. For single-line edit controls, the line index is
'         always 0. The return value is the last character in the edit control
'         if the given point is beyond the last character in the control. The
'         return value is -1 if the specified point is outside the client area
'         of the edit control.
'
FUNCTION Edit_CharFromPos (BYVAL hEdit AS DWORD, BYVAL x AS INTEGER, _
   BYVAL y AS INTEGER) AS LONG
    FUNCTION = SendMessage(hEdit, %EM_CHARFROMPOS, 0, MAKLNG(x, y))
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Edit_EmptyUndoBuffer
'   DESC: Reset the undo flag of an edit control. The undo flag is set whenever
'         an operation within the edit control can be undone.
' SYNTAX: Edit_ptyUndoBuffer hEdit
'  NOTES: The undo flag is automatically reset whenever the edit control
'         receives a %WM_SETTEXT or %EM_SETHANDLE message.
'
SUB Edit_EmptyUndoBuffer (BYVAL hEdit AS DWORD)
    SendMessage hEdit, %EM_EMPTYUNDOBUFFER, 0, 0
END SUB

'------------------------------------------------------------------------------
'  TITLE: Edit_FmtLines
'   DESC: Set the inclusion flag of soft linebreak characters on or off within
'         a multiline edit control. A soft linebreak consists of two carriage
'         returns and a linefeed and is inserted at the end of a line that is
'         broken because of wordwrapping.
' SYNTAX: Edit_FmtLines hEdit, AddEolFlag
'  NOTES: 'AddEolFlag' specifies whether soft-linebreak characters are to be
'         inserted. A value of TRUE inserts the characters; a value of FALSE
'         removes them. This message affects only the buffer returned by the
'         %EM_GETHANDLE message and the text returned by the %WM_GETTEXT
'         message. It has no effect on the display of the text within the edit
'         control. Edit_FmtLines does not affect a line that ends with a hard
'         linebreak. A hard linebreak consists of one carriage return and a
'         linefeed.
'
FUNCTION Edit_FmtLines(BYVAL hEdit AS LONG, BYVAL AddEolFlag AS LONG) AS LONG
    FUNCTION = SendMessage(hEdit, %EM_FMTLINES, ISTRUE(AddEolFlag) AND 1, 0)
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Edit_GetFirstVisibleLine
'   DESC: Determine the uppermost visible line in an edit control.
' SYNTAX: nLine = Edit_GetFirstVisibleLine(hEdit)
'  NOTES: The return value is the zero-based index of the uppermost visible
'         line in a multiline edit control. For single-line edit controls, the
'         return value is the zero-based index of the first visible character.
'
FUNCTION Edit_GetFirstVisibleLine (BYVAL hEdit AS DWORD) AS LONG
    FUNCTION = SendMEssage(hEdit, %EM_GETFIRSTVISIBLELINE, 0, 0)
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Edit_GetHandle
'   DESC: Retrieve a handle of the memory currently allocated for a multiline
'         edit control's text.
' SYNTAX: hMem = Edit_GetHandle(hEdit)
'  NOTES: The return value is a memory handle identifying the buffer that holds
'         the content of the edit control. If an error occurs, such as sending
'         the message to a single-line edit control, the return value is zero.
'
FUNCTION Edit_GetHandle (BYVAL hEdit AS DWORD) AS DWORD
    FUNCTION = SendMessage(hEdit, %EM_GETHANDLE, 0, 0)
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Edit_GetLimitText
'   DESC: Retrieve the current text limit, in characters, for an edit control.
' SYNTAX: nBytes = Edit_GetLimitText(hEdit)
'
FUNCTION Edit_GetLimitText (BYVAL hEdit AS DWORD) AS LONG
    FUNCTION = SendMessage(hEdit, %EM_GETLIMITTEXT, 0, 0)
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Edit_GetLine
'   DESC: Copy a line of text from an edit control
' SYNTAX: textline$ = Edit_GetLine(hEdit, which_line)
'
FUNCTION Edit_GetLine (BYVAL hEdit AS DWORD, BYVAL which AS DWORD) AS STRING

    LOCAL buffer AS STRING
    LOCAL n      AS LONG

    buffer = MKI$(32765) + STRING$(32765, 0)

    n = SendMessage(hEdit, %EM_GETLINE, which, STRPTR(buffer))

    FUNCTION = LEFT$(buffer, n)

END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Edit_GetLineCount
'   DESC: Retrieve the number of lines in a multiline edit control.
' SYNTAX: nLines = Edit_GetLineCount(hEdit)
'  NOTES: The return value is the number of lines in the multiline edit
'         control. If no text is in the edit control, the return value is 1.
'
FUNCTION Edit_GetLineCount (BYVAL hEdit AS DWORD) AS LONG
    FUNCTION = SendMessage(hEdit, %EM_GETLINECOUNT, 0, 0)
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Edit_GetMargins
'   DESC: Retrieve the widths of the left and right margins for an edit control.
' SYNTAX: nWidth = Edit_GetMargins(hEdit)
'  NOTES: Returns the width of the left margin in the low-order word, and the
'         width of the right margin in the high-order word.
'
FUNCTION Edit_GetMargins (BYVAL hEdit AS DWORD) AS LONG
    FUNCTION = SendMessage(hEdit, %EM_GETMARGINS, 0, 0)
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Edit_GetModify
'   DESC: Determine whether the content of an edit control has been modified.
' SYNTAX: fModify = Edit_GetModify(hEdit)
'  NOTES: If the content of edit control has been modified, the return value is
'         TRUE; otherwise, it is FALSE. Windows maintains an internal flag
'         indicating whether the content of the edit control has been changed.
'         This flag is cleared when the edit control is first created;
'         alternatively, an application can send an EM_SETMODIFY message to
'         the edit control to clear the flag.
'
FUNCTION Edit_GetModify (BYVAL hEdit AS DWORD) AS LONG
    FUNCTION = SendMessage(hEdit, %EM_GETMODIFY, 0, 0)
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Edit_GetPasswordChar
'   DESC: Retrieve the password character displayed in an edit control when
'         the user enters text.
' SYNTAX: nChar = Edit_GetPasswordChar(hEdit)
'  NOTES: The return value specifies the character to be displayed in place of
'         the character typed by the user. The return value is %NULL if no
'         password character exists. If the edit control is created with the
'         %ES_PASSWORD style, the default password character is set to an
'         asterisk (*).
'
FUNCTION Edit_GetPasswordChar (BYVAL hEdit AS DWORD) AS LONG
    FUNCTION = SendMessage(hEdit, %EM_GETPASSWORDCHAR, 0, 0)
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Edit_GetRect
'   DESC: Retrieve the formatting rectangle of an edit control.  The formatting
'         rectangle is the limiting rectangle of the text.  The limiting
'         rectangle is independant of the size of the edit-control window.
' SYNTAX: Edit_GetRect hEdit, r
'
SUB Edit_GetRect (BYVAL hEdit AS DWORD, r AS RECT)
    SendMessage hEdit, %EM_GETRECT, 0, VARPTR(r)
END SUB

'------------------------------------------------------------------------------
'  TITLE: Edit_GetSel
'   DESC: Get the starting and ending character positions of the current
'         selection in an edit control.
' SYNTAX: result = Edit_GetSel(hEdit)
'
FUNCTION Edit_GetSel (BYVAL hEdit AS DWORD) AS DWORD
    FUNCTION = SendMessage(hEdit, %EM_GETSEL, 0, 0)
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Edit_GetTextLength
'   DESC: Retrieve the length of all text in an edit control.
' SYNTAX: nLen = Edit_GetTextLength(hEdit)
'
FUNCTION Edit_GetTextLength (BYVAL hEdit AS DWORD) AS LONG
    FUNCTION = SendMessage(hEdit, %WM_GETTEXTLENGTH, 0, 0)
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Edit_GetText
'   DESC: Retrieve the text from an edit control.
' SYNTAX: Text$ = Edit_GetText(hEdit)
'
FUNCTION Edit_GetText (BYVAL hEdit AS LONG) AS STRING

    LOCAL  nLen   AS LONG
    STATIC buffer AS STRING

    nLen = Edit_GetTextLength(hEdit)
    Buffer = SPACE$(nLen + 1)
    GetWindowText hEdit, BYVAL STRPTR(Buffer), nLen + 1

    FUNCTION = LEFT$(Buffer, LEN(Buffer) - 1)

END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Edit_GetThumb
'   DESC: Retrieve the position of the scroll box (thumb) in a multiline edit
'         control.
' SYNTAX: nPos = Edit_GetThumb(hEdit)
'
FUNCTION Edit_GetThumb (BYVAL hEdit AS DWORD) AS LONG
    FUNCTION = SendMessage(hEdit, %EM_GETTHUMB, 0, 0)
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Edit_LimitText
'   DESC: Limit the amount of text the user may enter into an edit control.
' SYNTAX: Edit_LimitText nBytes
'  NOTES: Edit_LimitText limits only the text the user can enter. It has no effect
'         on any text already in the edit control when the message is sent,
'         nor does it affect the length of the text copied to the edit control
'         by the %WM_SETTEXT message. If an application uses the %WM_SETTEXT
'         message to place more text into an edit control than is specified by
'         Edit_LimitText, the user can edit the entire contents of the edit
'         control.
'
SUB Edit_LimitText (BYVAL hEdit AS DWORD, BYVAL chMax AS DWORD)
    SendMessage hEdit, %EM_LIMITTEXT, chMax, 0
END SUB

'------------------------------------------------------------------------------
'  TITLE: Edit_LineFromChar
'   DESC: Retrieve the index of the line that contains the specified character
'         index in a multiline edit control. A character index is the number of
'         characters from the beginning of the edit control.
' SYNTAX: nLine = Edit_LineFromChar(hEdit, index)
'  NOTES: 'index' specifies the character index of the character contained in
'         the line whose number is to be retrieved. If it is -1, either the line
'         number of the current line (the line containing the caret) is
'         retrieved or, if there is a selection, the line number of the line
'         containing the beginning of the selection is retrieved.
'
FUNCTION Edit_LineFromChar (BYVAL hEdit AS DWORD, BYVAL index AS DWORD) AS LONG
    FUNCTION = SendMessage(hEdit, %EM_LINEFROMCHAR, index, 0)
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Edit_LineIndex
'   DESC: Retrieve the character index of a line in a multiline edit control.
'         The character index is the number of characters from the beginning of
'         the edit control to the specified line.
' SYNTAX: nPos = Edit_LineIndex(hEdit, nLine)
'  NOTES: 'nLine' specifies the zero-based line number. A value of -1 specifies
'         the current line number (the line that contains the caret). The
'         return value is the character index of the line specified in the line
'         parameter, or it is -1 if the specified line number is greater than
'         the number of lines in the edit control.
'
FUNCTION Edit_LineIndex (BYVAL hEdit AS DWORD, BYVAL nLine AS LONG) AS LONG
    FUNCTION = SendMessage(hEdit, %EM_LINEINDEX, nLine, 0)
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Edit_LineLength
'   DESC: Retrieve the length of a line, in characters, in an edit control.
' SYNTAX: nLength = Edit_LineLength(hEdit, index)
'  NOTES: 'index' specifies the character index of a character in the line
'         whose length is to be retrieved. If this parameter is -1, the message
'         returns the number of unselected characters on lines containing
'         selected characters. For example, if the selection extended from the
'         fourth character of one line through the eighth character from the
'         end of the next line, the return value would be 10 (three characters
'         on the first line and seven on the next). The return value is the
'         length, in characters, of the line specified by the 'index' parameter.
'         The return value is the length, in characters, of the text in the
'         edit control when it is a single-line edit control.
'
FUNCTION Edit_LineLength (BYVAL hEdit AS DWORD, BYVAL index AS DWORD) AS LONG
    FUNCTION = SendMessage(hEdit, %EM_LINELENGTH, index, 0)
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Edit_LineScroll
'   DESC: Scroll the text vertically and/or horizontally in a multiline edit
'         control.
' SYNTAX: success = Edit_LineScroll(hEdit, x, y)
'  NOTES: If the message is sent to a multiline edit control, the return value
'         is TRUE; if the message is sent to a single-line edit control, the
'         return value is FALSE. The edit control does not scroll vertically
'         past the last line of text in the edit control. If the current line
'         plus the number of lines specified by the 'y' parameter exceeds the
'         total number of lines in the edit control, the value is adjusted so
'         that the last line of the edit control is scrolled to the top of the
'         edit-control window.
'
FUNCTION Edit_LineScroll (BYVAL hEdit AS DWORD, BYVAL x AS LONG, _
   BYVAL y AS LONG) AS LONG
    FUNCTION = SendMessage(hEdit, %EM_LINESCROLL, x, y)
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Edit_PosFromChar
'   DESC: Retrieve the coordinates of the specified character in an edit
'         control.
' SYNTAX: nPosd = Edit_PosFromChar(hEdit, index)
'  NOTES: The return value specifies the coordinates of the upper-left corner
'         of the character. If 'index' is greater than the index of the last
'         character in the control, the return value specifies the coordinates
'         of the position just past the last character in the control. The
'         x-coordinate is in the low-order word and the y-coordinate is in the
'         high-order word. The coordinates are relative to the upper-left
'         corner of the edit control's client area. For a single-line edit
'         control, the y-coordinate is always zero. A returned coordinate can
'         be negative if the character has been scrolled outside the edit
'         control's client area. The coordinates are truncated to integer
'         values.
'
FUNCTION Edit_PosFromChar (BYVAL hEdit AS DWORD, BYVAL index AS DWORD) AS LONG
    FUNCTION = SendMessage(hEdit, %EM_POSFROMCHAR, index, 0)
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Edit_SetText
'   DESC: Set the text of an edit control.
' SYNTAX: Edit_SetText hEdit, text$
'
FUNCTION Edit_SetText (BYVAL hEdit AS DWORD, BYVAL TEXT AS STRING) AS LONG
    FUNCTION = SetWindowText(hEdit, BYVAL STRPTR(TEXT))
END FUNCTION

#ENDIF  ' %NOEDIT

'==============================================================================
' LISTBOX CONTROL

#IF NOT %DEF(%NOLIST)

'------------------------------------------------------------------------------
'  TITLE: Listbox_AddFile
'   DESC: Add a specified filename to a listbox that contains a directory
'         listing.
' SYNTAX: RetVal = Listbox_AddFile(hListBox, Filename$)
'RETURNS: The return value is the zero-based index to the filename in the list
'         box. The return value is %LB_ERR if an error occurs; the return value
'         is %LB_ERRSPACE if insufficient space is available to store the new
'         filename.
'REMARKS: The listbox to which Filename$ is added must have been filled by
'         the Listbox_Dir call.
'
FUNCTION Listbox_AddFile (BYVAL hListBox AS DWORD, BYVAL FILENAME AS STRING) _
   AS LONG
    FUNCTION = SendMessage(hListBox, %LB_ADDFILE, 0, STRPTR(FILENAME))
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Listbox_AddString
'   DESC: Add a string to a listbox.
' SYNTAX: RetVal = Listbox_AddString(hListBox, Text$)
'RETURNS: The return value is the zero-based index to the string in the list
'         box. The return value is %LB_ERR if an error occurs; the return value
'         is %LB_ERRSPACE if insufficient space is available to store the new
'         string.
'REMARKS: If the listbox does not have the %LBS_SORT style, the string is
'         added to the end of the list. Otherwise, the string is inserted
'         into the list and the list is sorted.
'
FUNCTION Listbox_AddString (BYVAL hListBox AS DWORD, BYVAL TEXT AS STRING) _
   AS LONG
    FUNCTION = SendMessage(hListBox, %LB_ADDSTRING, 0, STRPTR(TEXT))
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Listbox_DeleteString
'   DESC: Delete a string from a listbox.
' SYNTAX: RetVal = Listbox_DeleteString(hListBox, Position)
'  PARAM: hListBox - Handle of the listbox.
'         Position - Zero based index of the string to delete in the listbox.
'RETURNS: The return value is a count of the strings remaining in the list.
'         The return value is %LB_ERR if the index parameter specifies an index
'         greater than the number of items in the list.
'
FUNCTION Listbox_DeleteString (BYVAL hListBox AS DWORD, BYVAL Index AS DWORD) _
   AS LONG
    FUNCTION = SendMessage(hListBox, %LB_DELETESTRING, Index, 0)
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Listbox_Dir
'   DESC: Fill the listbox with a file directory.
' SYNTAX: RetVal = Listbox_Dir(hListBox, FileAttribute, FileSpec$)
'
FUNCTION Listbox_Dir (BYVAL hListBox AS DWORD, BYVAL Attr AS DWORD, _
   BYVAL FileSpec AS STRING) AS LONG
    FUNCTION = SendMessage(hListBox, %LB_DIR, Attr, STRPTR(FileSpec))
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Listbox_FindString
'   DESC: Find the first string in a listbox that contains the specific prefix.
' SYNTAX: n = Listbox_FindString(hListBox, IndexStart, Prefix$)
'
FUNCTION Listbox_FindString (BYVAL hListBox AS DWORD, _
   BYVAL indexStart AS DWORD, BYVAL szCtStr AS STRING) AS LONG
    FUNCTION = SendMessage(hListBox, %LB_FINDSTRING, indexStart, _
       STRPTR(szCtStr))
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Listbox_FindStringExact
'   DESC: Find the first string in a listbox that matches the specified string.
' SYNTAX: n = Listbox_FindStringExact(hListBox, IndexStart, Prefix$)
'
FUNCTION Listbox_FindStringExact (BYVAL hListBox AS DWORD, _
   BYVAL indexStart AS DWORD, BYVAL szCtStr AS STRING) AS LONG
    FUNCTION = SendMessage(hListBox, %LB_FINDSTRINGEXACT, indexStart, _
       STRPTR(szCtStr))
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Listbox_GetAnchorIndex
'   DESC: Retrieve the index of the anchor item (the item from which a
'         multiple select starts).  A multiple selection spans all items
'         from the anchor item to the carent item.
' SYNTAX: n = Listbox_GetAnchorIndex(hListBox)
'
FUNCTION Listbox_GetAnchorIndex (BYVAL hListBox AS DWORD) AS LONG
    FUNCTION = SendMessage(hListBox, %LB_GETANCHORINDEX, 0, 0)
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Listbox_GetCaretIndex
'   DESC: Determine the index of the item that has the focus retangle in a
'         multiple-selection listbox.  The item may or may not be selected.
' SYNTAX: n = Listbox_GetCaretIndex(hListBox)
'
FUNCTION Listbox_GetCaretIndex (BYVAL hListBox AS DWORD) AS LONG
    FUNCTION = SendMessage(hListBox, %LB_GETCARETINDEX, 0, 0)
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Listbox_GetCount
'   DESC: Return the total number of items in a listbox.
' SYNTAX: n = Listbox_GetCount( hListBox )
'
FUNCTION Listbox_GetCount (BYVAL hListBox AS DWORD) AS LONG
    FUNCTION = SendMessage(hListBox, %LB_GETCOUNT, 0, 0)
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Listbox_GetCurSel
'   DESC: Get the current selection index of the listbox.
' SYNTAX: ItemPosition = Listbox_GetCurSel( hListBox )
'
FUNCTION Listbox_GetCurSel (BYVAL hListBox AS DWORD) AS LONG

    LOCAL Msg AS LONG

    IF (GetWindowLong(hListBox, %GWL_STYLE) AND %LBS_MULTIPLESEL) THEN
        Msg = %LB_GETCARETINDEX
    ELSE
        Msg = %LB_GETCURSEL
    END IF

    FUNCTION = SendMessage(hListBox, Msg, 0, 0)

END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Listbox_GetHorizontalExtent
'   DESC: Retrieve from a listbox the width, in pixels, by which the listbox
'         can be scrolled horizontally (the scrollable width) if the listbox
'         has a horizontal scroll bar.
' SYNTAX: Extent = Listbox_GetHorizontalExtent(hListBox)
'REMARKS: The return value is the scrollable width, in pixels, of the listbox.
'         The listbox must have been defined with the %WS_HSCROLL style.
'
FUNCTION Listbox_GetHorizontalExtent (BYVAL hListBox AS DWORD) AS LONG
    FUNCTION = SendMessage(hListBox, %LB_GETHORIZONTALEXTENT, 0, 0)
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Listbox_GetItemData
'   DESC: Retrieve the application-defined 32-bit value associated with the
'         specified list box item.
' SYNTAX: nData = Listbox_GetItenData(hListBox, index)
'REMARKS: The return value is the 32-bit value associated with the item, or
'         %LB_ERR if an error occurs.
'
FUNCTION Listbox_GetItemData (BYVAL hListBox AS DWORD, BYVAL index AS LONG) _
   AS LONG
    FUNCTION = SendMessage(hListBox, %LB_GETITEMDATA, index, 0)
END FUNCTION


'------------------------------------------------------------------------------
'  TITLE: Listbox_GetLocale
'   DESC: Retrieve the current locale of the listbox.
' SYNTAX: Locale = Listbox_GetLocale(hListBox)
'REMARKS: The return value is a 32-bit value that specifies the current locale
'         of the listbox. The high-order word contains the country code and
'         the low-order word contains the language identifier. You can use the
'         locale to determine the correct sorting order of displayed text (for
'         listboxes with the %LBS_SORT style) and text added by Listbox_AddString.
'
FUNCTION Listbox_GetLocale (BYVAL hListBox AS DWORD) AS LONG
    FUNCTION = SendMessage(hListBox, %LB_GETLOCALE, 0, 0)
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Listbox_GetSel
'   DESC: Returns the select status of the specified item.
' SYNTAX: Status = Listbox_GetSel(hListBox, ItemPosition)
'
FUNCTION Listbox_GetSel (BYVAL hListBox AS DWORD, BYVAL Index AS DWORD) AS LONG
    FUNCTION = ISTRUE(SendMessage(hListBox, %LB_GETSEL, Index, 0))
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Listbox_GetSelCount
'   DESC: Retrieve the number of selected items in a multi-selection listbox.
' SYNTAX: Count = Listbox_GetSelCount(hListBox)
'REMARKS: The return value is the count of selected items in the listbox. If
'         the listbox is single-selection, the return value is %LB_ERR.
'
FUNCTION Listbox_GetSelCount (BYVAL hListBox AS DWORD) AS LONG
    FUNCTION = SendMessage(hListBox, %LB_GETSELCOUNT, 0, 0)
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Listbox_GetSelItems
'   DESC: Fill a buffer with an array of integers that specify the item numbers
'         of selected items in a multiple-selection listbox.
' SYNTAX: items = Listbox_GetSelItems(hListBox, UBOUND(n()), n(1))
'REMARKS: The return value is the number of items placed in the buffer. If the
'         listbox is a single-selection listbox, the return value is %LB_ERR.
'
FUNCTION Listbox_GetSelItems (BYVAL hListBox AS DWORD, BYVAL items AS DWORD, _
   FirstItem AS LONG) AS LONG
    FUNCTION = SendMessage(hListBox, %LB_GETSELITEMS, items, VARPTR(FirstItem))
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Listbox_GetText
'   DESC: Return the text of the selected listbox item.
' SYNTAX: Text$ = Listbox_GetText( hListBox, ItemPosition )
'
FUNCTION Listbox_GetText (BYVAL hListBox AS DWORD, BYVAL Index AS DWORD) _
   AS STRING

    STATIC Buffer AS ASCIIZ * 256

    IF Index < 0 THEN
        Index = Listbox_GetCurSel(hListBox)
    END IF

    SendMessage hListBox, %LB_GETTEXT, Index, VARPTR(Buffer)

    FUNCTION = Buffer

END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Listbox_GetTopIndex
'   DESC: Retrieve the index of the first visible item in a listbox.
' SYNTAX: Which = Listbox_GetTopIndex
'REMARKS: Initially the item with index 0 is at the top of the listbox, but if
'         the contents have been scrolled another item may be at the top.
'
FUNCTION Listbox_GetTopIndex (BYVAL hListBox AS DWORD) AS LONG
    FUNCTION = SendMessage(hListBox, %LB_GETTOPINDEX, 0, 0)
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Listbox_InsertString
'   DESC: Insert a string into a listbox.
' SYNTAX: RetVal = Listbox_InsertString(hListBox, Position, Text$)
'RETURNS: The return value is the index of the position at which the string was
'         inserted. The return value is %LB_ERR if an error occurs.  The return
'         value is %LB_ERRSPACE if insufficient space is available to store the
'         new string.
'REMARKS: Unlike Listbox_AddString, Listbox_InsertString does not cause a list with the
'         %LBS_SORT style to be sorted.
'
FUNCTION Listbox_InsertString (BYVAL hListBox AS DWORD, BYVAL Index AS DWORD, _
   BYVAL TEXT AS STRING) AS LONG
    FUNCTION = SendMessage(hListBox, %LB_INSERTSTRING, Index, STRPTR(TEXT))
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Listbox_ResetContent
'   DESC: Clear the contents of a listbox.
' SYNTAX: Listbox_ResetContent hListBox
'REMARKS: If you create the listbox with an owner-drawn style but without the
'         %LBS_HASSTRINGS style, the owner of the listbox receives a
'         %WM_DELETEITEM message for each item in the listbox.
'
SUB Listbox_ResetContent (BYVAL hListBox AS DWORD)
    SendMessage hListBox, %LB_RESETCONTENT, 0, 0
END SUB

'------------------------------------------------------------------------------
'  TITLE: Listbox_SelectString
'   DESC: Select an item in a listbox by its text (or partial text).
' SYNTAX: RetVal = Listbox_SelectString(hListBox, StartPosition, Text$)
'REMARKS: The return value is the index of the selected item if the search was
'         successful.  The return value is %LB_ERR if the search was
'         unsuccessful and the current selection is not changed.
'
FUNCTION Listbox_SelectString (BYVAL hListBox AS DWORD, BYVAL Start AS DWORD, _
   BYVAL TEXT AS STRING) AS LONG
    FUNCTION = SendMessage(hListBox, %LB_SELECTSTRING, Start, STRPTR(TEXT))
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Listbox_SetAnchorIndex
'   DESC: Set the anchor item -- that is, the item from which a multiple
'         selection starts. A multiple selection spans all items from the
'         anchor item to the caret item.
' SYNTAX: Success = Listbox_SetAnchorIndex(hListBox, index)
'
FUNCTION Listbox_SetAnchorIndex (BYVAL hListBox AS DWORD, _
   BYVAL index AS DWORD) AS LONG
    FUNCTION = SendMessage(hListBox, %LB_SETANCHORINDEX, index, 0)
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Listbox_SetCurSel
'   DESC: Set the highlighted item in a listbox.
' SYNTAX: RetVal = Listbox_SetCurSel(hListBox, ItemPosition)
'RETURNS: The return value is %LB_ERR if an error occurs.  The return value
'         will be %LB_ERR even though no error has occurred if the index
'         parameter is -1.
'REMARKS: Listbox_SetCurSel selects a string and scrolls it into view, if necessary.
'         When the new string is selected, the listbox removes the highlight
'         from the previously selected string.  If the index parameter is -1,
'         the listbox is set to have no selection.
'
FUNCTION Listbox_SetCurSel (BYVAL hListBox AS DWORD, BYVAL Index AS DWORD) _
   AS LONG

    LOCAL Msg AS LONG

    IF (GetWindowLong(hListBox, %GWL_STYLE) AND %LBS_MULTIPLESEL) THEN
        Msg = %LB_SETSEL
    ELSE
        Msg = %LB_SETCURSEL
    END IF

    FUNCTION = SendMessage(hListBox, Msg, Index, 0)

END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Listbox_SetHorizontalExtent
'   DESC: Set the width, in pixels, by which a list box can be scrolled
'         horizontally (the scrollable width). If the width of the list box is
'         smaller than this value, the horizontal scroll bar horizontally
'         scrolls items in the list box. If the width of the list box is equal
'         to or greater than this value, the horizontal scroll bar is hidden.
' SYNTAX: Listbox_SetHorizontalExtent hListBox, cxExtent
'REMARKS: The list box must have been defined with the WS_HSCROLL style.
'
SUB Listbox_SetHorizontalExtent (BYVAL hListBox AS DWORD, _
   BYVAL cxExtent AS LONG)
    SendMessage hListBox, %LB_SETHORIZONTALEXTENT, cxExtent, 0
END SUB

'------------------------------------------------------------------------------
'  TITLE: Listbox_SetLocale
'   DESC: Set the current locale of the listbox.  You can use the locale to
'         determine the correct sorting order of displayed text (for listboxes
'         with the LBS_SORT style.
' SYNTAX: OldLocale = Listbox_SetLocale(hListBox, wLocaleID)
'REMARKS: The return value is the previous locale identifier. If the wLocaleID
'         parameter specifies a locale that is not installed, the return value
'         is LB_ERR and the current listbox locale is not changed.
'
FUNCTION Listbox_SetLocale (BYVAL hListBox AS DWORD, _
   BYVAL wLocaleID AS DWORD) AS LONG
    FUNCTION = SendMessage(hListBox, %LB_SETLOCALE, wLocaleID, 0)
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Listbox_SetSel
'   DESC: Select a string in a multiple-selection listbox.
' SYNTAX: Result = Listbox_SetSel(hListBox, fSelect, index)
'REMARKS: fSelect is the selection status for the string. index is the string
'         whose selection status is being changed.  %LB_ERR is returned if
'         is out of range.
'
FUNCTION Listbox_SetSel (BYVAL hListBox AS DWORD, BYVAL fSelect AS LONG, _
   BYVAL index AS LONG) AS LONG
    FUNCTION = SendMessage(hListBox, %LB_SETSEL, fSelect, index)
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Listbox_SetTabStops
'   DESC: Set the tab stops in a listbox.
' SYNTAX: Listbox_SetTabStops hListBox, TabStops(0), TotalTabStops
'REMARKS: TabStops() is a long integer array with each succeeding tab stop
'         greater than the previous.  The listbox must have been created with
'         the %LB_USETABSTOPS style.
'
SUB Listbox_SetTabStops (BYVAL hListBox AS DWORD, TabStops AS LONG, _
   BYVAL TabStopsCnt AS LONG)
    SendMessage hListBox, %LB_SETTABSTOPS, TabStopsCnt, VARPTR(TabStops)
END SUB

'------------------------------------------------------------------------------
'  TITLE: Listbox_SetTopIndex
'   DESC: Ensure that a particular item in a listbox is visible.
' SYNTAX: Result = Listbox_SetTopIndex(hListBox, index)
'REMARKS: The system scrolls the listbox contents so that either the specified
'         item appears at the top of the listbox or the maximum scroll range
'         has been reached.
'
FUNCTION Listbox_SetTopIndex (BYVAL hListBox AS DWORD, BYVAL index AS DWORD) _
   AS LONG
    FUNCTION = SendMessage(hListBox, %LB_SETTOPINDEX, index, 0)
END FUNCTION

#ENDIF

'==============================================================================
' COMBOBOX CONTROL

#IF NOT %DEF(%NOCOMBO)

'------------------------------------------------------------------------------
'  TITLE: Combo_AddString
'   DESC: Adds a string to the list box of a combo box.
' SYNTAX: Index = Combo_AddString(hComboBox, Text)
'  NOTES: If the combo box does not have the %CBS_SORT style, the string is
'         added to the end of the list.  Otherwise, the string is inserted
'         into the list and the list is sorted.  The return value is the
'         zero-based index to the string in the list box of the combo box.
'         The return value is %CB_ERR if an error occurs; the return value is
'         %CB_ERRSPACE if insufficient space is available to store the new
'         string.
'
FUNCTION Combo_AddString (BYVAL hComboBox AS DWORD, BYVAL TEXT AS STRING) _
   AS LONG
    FUNCTION = SendMessage(hComboBox, %CB_ADDSTRING, 0, STRPTR(TEXT))
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Combo_DeleteString
'   DESC: Deletes a string in the list box of a combo box.
' SYNTAX: Remaining = Combo_DeleteString(hComboBox, Index)
'  NOTES: The return value is a count of the strings remaining in the list.
'         The return value is %CB_ERR if the index parameter specifies an index
'         greater than the number of items in the list.
'
FUNCTION Combo_DeleteString (BYVAL hComboBox AS DWORD, BYVAL Index AS DWORD) _
   AS LONG
    FUNCTION = SendMessage(hComboBox, %CB_DELETESTRING, Index, 0)
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Combo_Dir
'   DESC: Adds filenames to the list box of a combo box.
' SYNTAX: Items = Combo_Dir(hComboBox, Attribute, FileSpec)
'  NOTES: The return value is the zero-based index of the last filename added
'         to the list. The return value is %CB_ERR if an error occurs. The
'         return value is %CB_ERRSPACE if insufficient space is available to
'         store the new strings.
'
FUNCTION Combo_Dir (BYVAL hComboBox AS DWORD, BYVAL Attr AS DWORD, _
   BYVAL FileSpec AS STRING) AS LONG
    FUNCTION = SendMessage(hComboBox, %CB_DIR, Attr, STRPTR(FileSpec))
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Combo_FindString
'   DESC: Finds prefix string in the list box of a combo box.
' SYNTAX: Index = Combo_FindString(hComboBox, Start, Text)
'  NOTES: Search the list box of a combo box for an item that begins with the
'         characters in a specified string.  The return value is the zero-based
'         index of the matching item, or it is %CB_ERR if the search was
'         unsuccessful.
'
FUNCTION Combo_FindString (BYVAL hComboBox AS DWORD, BYVAL Start AS LONG, _
   BYVAL TEXT AS STRING) AS LONG
    FUNCTION = SendMessage(hComboBox, %CB_FINDSTRING, Start, STRPTR(TEXT))
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Combo_FindStringExact
'   DESC: Finds exact string in the list box of a combo box.
' SYNTAX: Index = Combo_FindStringExact(hComboBox, Start, Text)
'  NOTES: Search the list box of a combo box for an item that begins with the
'         characters in a specified string.  The return value is the zero-based
'         index of the matching item, or it is %CB_ERR if the search was
'         unsuccessful.
'
FUNCTION Combo_FindStringExact (BYVAL hComboBox AS DWORD, _
   BYVAL Start AS LONG, BYVAL TEXT AS STRING) AS LONG
    FUNCTION = SendMessage(hComboBox, %CB_FINDSTRINGEXACT, Start, STRPTR(TEXT))
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Combo_GetCount
'   DESC: Gets the number of list-box items in a combo box.
' SYNTAX: Items = Combo_GetCount(hComboBox)
'  NOTES: Retrieve the number of items in the list box of a combo box.  The
'         return value is the number of items in the list box.
'
FUNCTION Combo_GetCount (BYVAL hComboBox AS DWORD) AS LONG
    FUNCTION = SendMessage(hComboBox, %CB_GETCOUNT, 0, 0)
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Combo_GetCurSel
'   DESC: Gets index of selected list-box item in combo box.
' SYNTAX: Index = Combo_GetCurSel(hComboBox)
'  NOTES: Retrieve the index of the currently selected item, if any, in the
'         list box of a combo box.  The return value is the zero-based index
'         of the currently selected item, or it is %CB_ERR if no item is
'         selected.
'
FUNCTION Combo_GetCurSel (BYVAL hComboBox AS DWORD) AS LONG
    FUNCTION = SendMessage(hComboBox, %CB_GETCURSEL, 0, 0)
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Combo_GetDroppedState
'   DESC: Determines if list box of combo box is visible.
' SYNTAX: State = Combo_GetDroppedState(hComboBox)
'  NOTES: Determine whether the list box of a combo box is visible (dropped
'         down).  The return value is nonzero if the list box is visible;
'         otherwise, it is zero.
'
FUNCTION Combo_GetDroppedState (BYVAL hComboBox AS DWORD) AS LONG
    FUNCTION = ISTRUE(SendMessage(hComboBox, %CB_GETDROPPEDSTATE, 0, 0))
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Combo_GetDroppedWidth
'   DESC: Retrieve the minimum allowable width, in pixels, of the list box of a
'         combo box with the %CBS_DROPDOWN or %CBS_DROPDOWNLIST style.
' SYNTAX: nWidth = Combo_GetDroppedWidth(hComboBox)
'  NOTES: By default, the minimum allowable width of the drop-down list box is
'         0. The width of the list box is either the minimum allowable width
'         or the combo box width, whichever is larger.
'
FUNCTION Combo_GetDroppedWidth (BYVAL hComboBox AS DWORD) AS LONG
    FUNCTION = SendMessage(hComboBox, %CB_GETDROPPEDWIDTH, 0, 0)
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Combo_GetEditSel
'   DESC: Get the starting and ending character positions of the current
'         selection in the edit control of a combo box.
' SYNTAX: nPos = Combo_GetEditSel(hComboBox, lpStart, lpEnd)
'  NOTES: lpStart and lpEnd are zero-based 32-bit values with the starting
'         position of the selection in the low-order word and with the ending
'         position of the first character after the last selected character
'         in the high-order word.
'
SUB Combo_GetEditSel (BYVAL hComboBox AS DWORD, lpStart AS LONG, lpEnd AS LONG)
    SendMessage hComboBox, %CB_GETEDITSEL, VARPTR(lpStart), VARPTR(lpEnd)
END SUB

'------------------------------------------------------------------------------
'  TITLE: Combo_GetExtendUi
'   DESC: Determine whether a combo box has the default user interface or the
'         extended user interface.
' SYNTAX: n = Combo_GetExtendUi(hComboBox)
'  NOTES: By default, the F4 key opens or closes the list and the DOWN ARROW
'         changes the current selection. In a combo box with the extended user
'         interface, the F4 key is disabled and pressing the DOWN ARROW key
'         opens the drop-down list.
'
FUNCTION Combo_GetExtendUi (BYVAL hComboBox AS DWORD) AS LONG
    FUNCTION = SendMessage(hComboBox, %CB_GETEXTENDEDUI, 0, 0)
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Combo_GetItemData
'   DESC: Retrieve the application-supplied 32-bit value associated with the
'         specified item in the combo box.
' SYNTAX: ItemData = Combo_GetItemData(hComboBox, index)
'  NOTES: The return value is the 32-bit value associated with the item. If
'         an error occurs, it is %CB_ERR.  If -1 is specified for the index,
'         the current selection is returned.
'
FUNCTION Combo_GetItemData (BYVAL hComboBox AS DWORD, BYVAL index AS LONG) _
   AS LONG

    IF index < 0 THEN
        index = Combo_GetCurSel(hComboBox)
    END IF

    FUNCTION = SendMessage(hComboBox, %CB_GETITEMDATA, index, 0)

END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Combo_GetLbText
'   DESC: Gets string from the list box of a combo box.
' SYNTAX: Text$ = Combo_GetLbText(hComboBox, Index)
'  NOTES: If the item does not exist a null string is returned.  If -1 is
'         specified for the index, the current selection is returned.
'
FUNCTION Combo_GetLbText (BYVAL hComboBox AS DWORD, BYVAL Index AS LONG) _
   AS STRING

    LOCAL zText AS STRING * 255

    IF Index < 0 THEN
        Index = Combo_GetCurSel(hComboBox)
    END IF

    SendMessage hComboBox, %CB_GETLBTEXT, Index, VARPTR(zText)

    FUNCTION = zText

END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Combo_GetTopIndex
'   DESC: Retrieve the zero-based index of the first visible item in the list
'         box portion of a combo box. Initially the item with index 0 is at
'         the top of the list box, but if the list box contents have been
'         scrolled, another item may be at the top.
' SYNTAX: index = Combo_GetTopIndex(hComboBox)
'  NOTES: If the message is successful, the return value is the index of the
'         first visible item in the list box of the combo box. If the message
'         fails, the return value is %CB_ERR.
'
FUNCTION Combo_GetTopIndex (BYVAL hComboBox AS DWORD) AS LONG
    FUNCTION = SendMessage(hComboBox, %CB_GETTOPINDEX, 0, 0)
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Combo_InitStorage
'   DESC: An application call Combo_InitStorage before adding a large number of
'         items to the list box portion of a combo box. This message allocates
'         memory for storing list box items.
' SYNTAX: Success = Combo_InitStorage(hComboBox, items, cb)
'  NOTES: 'items' is the number of items to add.  'cb' is the amount of memory
'         to allocate, in bytes.  If the message is successful, the return
'         value is the maximum number of items that the memory object can
'         store.  If the message fails, the return value is %CB_ERR.
'         This message helps speed up the initialization of combo boxes that
'         have a large number of items (over 100). It preallocates the
'         specified amount of memory so that subsequent Combo_AddString,
'         Combo_InsertString and Combo_Dir messages take the shortest possible time.
'
FUNCTION Combo_InitStorage (BYVAL hComboBox AS DWORD, BYVAL items AS LONG, _
   BYVAL cb AS LONG) AS LONG
    FUNCTION = SendMessage(hComboBox, %CB_INITSTORAGE, items, cb)
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Combo_InsertString
'   DESC: Inserts a string into the list box of a combo box.
' SYNTAX: Index = Combo_InsertString(hComboBox, Text)
'  NOTES: Insert a string into the list box of a combo box. Unlike Combo_AddString
'         Combo_InsertString does not cause a list with the %CBS_SORT style to be
'         sorted.  The return value is the index of the position at which the
'         string was inserted.  The return value is %CB_ERR if an error occurs.
'         The return value is %CB_ERRSPACE if insufficient space is available
'         to store the new string.
'
FUNCTION Combo_InsertString (BYVAL hComboBox AS DWORD, BYVAL TEXT AS STRING) _
   AS LONG
     FUNCTION = SendMessage(hComboBox, %CB_INSERTSTRING, 0, STRPTR(TEXT))
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Combo_LimitText
'   DESC: Limit the length of the text the user may type into the edit control
'         of a combo box
' SYNTAX: Combo_LimitText hComboBox, length
'  NOTES: If the combo box does not have the %CBS_AUTOHSCROLL style, setting
'         the text limit to be larger than the size of the edit control has
'         no effect. Combo_LimitText limits only the text the user can enter. It
'         has no effect on any text already in the edit control when the
'         message is sent, nor does it affect the length of the text copied to
'         the edit control when a string in the list box is selected. The
'         default limit to the text a user can enter in the edit control is
'         30,000 characters.
'
SUB Combo_LimitText (BYVAL hComboBox AS DWORD, BYVAL chLimit AS DWORD)
    SendMessage hComboBox, %CB_LIMITTEXT, chLimit, 0
END SUB

'------------------------------------------------------------------------------
'  TITLE: Combo_ResetContent
'   DESC: Removes all items from the list box of a combo box.
' SYNTAX: Combo_ResetContent hComboBox
'
SUB Combo_ResetContent (BYVAL hComboBox AS DWORD)
    SendMessage hComboBox, %CB_RESETCONTENT, 0, 0
END SUB

'------------------------------------------------------------------------------
'  TITLE: Combo_SelectString
'   DESC: Selects matching string in list box of combo box.
' SYNTAX: Index = Combo_SelectString(hComboBox, Index, Text)
'  NOTES: Search the list box of a combo box for an item that begins with the
'         characters in a specified string. If a matching item is found, the
'         item is selected and copied to the edit control.  The return value
'         is the index of the selected item if the string was found. The return
'         value is %CB_ERR and the current selection is not changed if the
'         search was unsuccessful.
'
FUNCTION Combo_SelectString (BYVAL hComboBox AS DWORD, BYVAL Index AS DWORD, _
   BYVAL TEXT AS STRING) AS LONG
    FUNCTION = SendMessage(hComboBox, %CB_SELECTSTRING, Index, STRPTR(TEXT))
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Combo_SetCurSel
'   DESC: Selects indexed string in list box of combo box.
' SYNTAX: Index = Combo_SetCurSel(hComboBox, Index)
'  NOTES: Select a string in the list box of a combo box. If necessary, the
'         list box scrolls the string into view (if the list box is visible).
'         The text in the edit control of the combo box is changed to reflect
'         the new selection. Any previous selection in the list box is removed.
'         The return value is the index of the item selected if the message is
'         successful. The return value is %CB_ERR if the index parameter is
'         greater than the number of items in the list or if index is set to
'         -1 (which clears the selection).
'
FUNCTION Combo_SetCurSel (BYVAL hComboBox AS DWORD, BYVAL Index AS DWORD) _
   AS LONG
    FUNCTION = SendMessage(hComboBox, %CB_SETCURSEL, Index, 0)
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Combo_SetEditSel
'   DESC: Select characters in the edit control of a combo box.
' SYNTAX: success = Combo_SetEditSel(hComboBox, nStart, nEnd)
'  NOTES: If the message succeeds, the return value is TRUE.  If the message is
'         sent to a combo box with the %CBS_DROPDOWNLIST style, it is %CB_ERR.
'         The positions are zero-based. The first character of the edit control
'         is in the zero position. The first character after the last selected
'         character is in the ending position. For example, to select the first
'         four characters of the edit control, use a starting position of 0 and
'         an ending position of 4.
'
FUNCTION Combo_SetEditSel (BYVAL hComboBox AS DWORD, BYVAL nStart AS INTEGER, _
   BYVAL nEnd AS INTEGER) AS LONG
    FUNCTION = SendMessage(hComboBox, %CB_SETEDITSEL, 0, MAKLNG(nStart, nEnd))
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Combo_SetItemData
'   DESC: Set the 32-bit value associated with the specified item in a combo
'         box.
' SYNTAX: success = Combo_SetItemData(hComboBox, index, nData)
'  NOTES: If the message fails, the return value is %CB_ERR.
'
FUNCTION Combo_SetItemData (BYVAL hComboBox AS DWORD, BYVAL index AS DWORD, _
   BYVAL nData AS LONG) AS LONG
    FUNCTION = SendMessage(hComboBox, %CB_SETITEMDATA, index, nData)
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Combo_SetTopIndex
'   DESC: An application calls Combo_SetTopIndex to ensure that a particular item
'         is visible in the list box of a combo box. The system scrolls the
'         list box contents so that either the specified item appears at the
'         top of the list box or the maximum scroll range has been reached.
' SYNTAX: success = Combo_SetTopIndex(hComboBox, index)
'  NOTES: If the message fails, the return value is %CB_ERR.
'
FUNCTION Combo_SetTopIndex (BYVAL hComboBox AS DWORD, BYVAL index AS DWORD) _
   AS LONG
    FUNCTION = SendMessage(hComboBox, %CB_SETTOPINDEX, index, 0)
END FUNCTION

'------------------------------------------------------------------------------
'  TITLE: Combo_ShowDropDown
'   DESC: Shows or hides the list box of a combo box.
' SYNTAX: Combo_ShowDropDown hComboBox, Show
'  NOTES: Show or hide the list box of a combo box that has the %CBS_DROPDOWN
'         or %CBS_DROPDOWNLIST style.
'
SUB Combo_ShowDropDown (BYVAL hComboBox AS DWORD, BYVAL nShow AS LONG)
    SendMessage hComboBox, %CB_SHOWDROPDOWN, ISTRUE(nShow) AND 1, 0
END SUB

#ENDIF



' ====== Flat Scrollbar APIs =========================================

#IF NOT %DEF(%NOFLATSBAPIS)

%WSB_PROP_CYVSCROLL  = &H00000001&
%WSB_PROP_CXHSCROLL  = &H00000002&
%WSB_PROP_CYHSCROLL  = &H00000004&
%WSB_PROP_CXVSCROLL  = &H00000008&
%WSB_PROP_CXHTHUMB   = &H00000010&
%WSB_PROP_CYVTHUMB   = &H00000020&
%WSB_PROP_VBKGCOLOR  = &H00000040&
%WSB_PROP_HBKGCOLOR  = &H00000080&
%WSB_PROP_VSTYLE     = &H00000100&
%WSB_PROP_HSTYLE     = &H00000200&
%WSB_PROP_WINSTYLE   = &H00000400&
%WSB_PROP_PALETTE    = &H00000800&
%WSB_PROP_MASK       = &H00000FFF&

%FSB_FLAT_MODE       = 2
%FSB_ENCARTA_MODE    = 1
%FSB_REGULAR_MODE    = 0

DECLARE FUNCTION FlatSB_EnableScrollBar LIB "COMCTL32.DLL" _
          ALIAS "FlatSB_EnableScrollBar" (BYVAL hWnd AS DWORD, _
          BYVAL wSBflags AS LONG, BYVAL dArrows AS DWORD) AS LONG

DECLARE FUNCTION FlatSB_ShowScrollBar LIB "COMCTL32.DLL" _
          ALIAS "FlatSB_ShowScrollBar" (BYVAL hWnd AS DWORD, _
          BYVAL typecode AS LONG, BYVAL fShow AS LONG) AS LONG

DECLARE FUNCTION FlatSB_GetScrollRange LIB "COMCTL32.DLL" _
          ALIAS "FlatSB_GetScrollRange" (BYVAL hWnd AS DWORD, _
          BYVAL typecode AS LONG, MinPos AS LONG, MaxPos AS LONG) AS LONG

DECLARE FUNCTION FlatSB_GetScrollInfo LIB "COMCTL32.DLL" _
          ALIAS "FlatSB_GetScrollInfo" (BYVAL hWnd AS DWORD, _
          BYVAL typecode AS LONG, si AS SCROLLINFO) AS LONG

DECLARE FUNCTION FlatSB_GetScrollPos LIB "COMCTL32.DLL" _
          ALIAS "FlatSB_GetScrollPos" (BYVAL hWnd AS DWORD, _
          BYVAL typecode AS LONG) AS LONG

DECLARE FUNCTION FlatSB_GetScrollProp LIB "COMCTL32.DLL" _
          ALIAS "FlatSB_GetScrollProp" (BYVAL hWnd AS DWORD, _
          BYVAL propIndex AS DWORD, BYVAL nValue AS LONG) AS LONG

DECLARE FUNCTION FlatSB_SetScrollPos LIB "COMCTL32.DLL" _
          ALIAS "FlatSB_SetScrollPos" (BYVAL hWnd AS DWORD, _
          BYVAL typecode AS LONG, BYVAL nPos AS LONG, BYVAL fRedraw AS LONG) _
          AS LONG

DECLARE FUNCTION FlatSB_SetScrollInfo LIB "COMCTL32.DLL" _
          ALIAS "FlatSB_SetScrollInfo" (BYVAL hWnd AS DWORD, _
          BYVAL typecode AS LONG, si AS SCROLLINFO, BYVAL fRedraw AS LONG) _
          AS LONG

DECLARE FUNCTION FlatSB_SetScrollRange LIB "COMCTL32.DLL" _
          ALIAS "FlatSB_SetScrollRange" (BYVAL hWnd AS DWORD, _
          BYVAL typecode AS LONG, BYVAL nMinPos AS LONG, _
          BYVAL nMaxPos AS LONG, BYVAL fRedraw AS LONG) AS LONG

DECLARE FUNCTION FlatSB_SetScrollProp LIB "COMCTL32.DLL" _
          ALIAS "FlatSB_SetScrollProp" (BYVAL hWnd AS DWORD, _
          BYVAL propIndex AS DWORD, BYVAL newValue AS DWORD, _
          BYVAL fRedraw AS LONG) AS LONG

DECLARE FUNCTION InitializeFlatSB LIB "COMCTL32.DLL" _
          ALIAS "InitializeFlatSB" (BYVAL hWnd AS DWORD) AS LONG

DECLARE FUNCTION UninitializeFlatSB LIB "COMCTL32.DLL" _
          ALIAS "UninitializeFlatSB" (BYVAL hWnd AS DWORD) AS LONG

#ENDIF  ' %NOFLATSBAPIS



#ENDIF  ' %COMMCTRL_INC
