'==============================================================================
'
' WINERR utility for PB/CC
'
' Copyright (c) 1998-2001 PowerBASIC, Inc.
' All Rights Reserved.
'
' This command line utility displays the text for a given Windows error code
' (see GetLastError() in your Windows API documentation).
'
'==============================================================================



#COMPILE EXE
#DIM ALL

#INCLUDE "WIN32API.INC"



FUNCTION WinErrMsg (BYVAL dError AS DWORD) AS STRING

    LOCAL pBuffer   AS ASCIIZ PTR
    LOCAL ncbBuffer AS DWORD

    ncbBuffer = FormatMessage( _
                    %FORMAT_MESSAGE_ALLOCATE_BUFFER _
                 OR %FORMAT_MESSAGE_FROM_SYSTEM _
                 OR %FORMAT_MESSAGE_IGNORE_INSERTS, _
                    BYVAL %NULL, _
                    dError, _
                    BYVAL MAKELANGID(%LANG_NEUTRAL, %SUBLANG_DEFAULT), _
                    BYVAL VARPTR(pBuffer), _
                    0, _
                    BYVAL %NULL)

    IF ncbBuffer THEN
        FUNCTION = PEEK$(pBuffer, ncbBuffer)
        LocalFree pBuffer
    ELSE
        FUNCTION = "Unknown error code: &H" + HEX$(dError, 8)
    END IF

END FUNCTION



FUNCTION PBMAIN () AS LONG

    LOCAL sCommand AS STRING

    STDOUT "WINERR 2.0 - Windows Error Messages"
    STDOUT "Copyright (c) 1998-2001 PowerBASIC, Inc."
    STDOUT "All Rights Reserved."
    STDOUT ""

    sCommand = TRIM$(COMMAND$)

    IF ASC(sCommand, 1) = 34 THEN
        sCommand = MID$(sCommand, 2)
        IF RIGHT$(sCommand, 1) = $DQ THEN
            sCommand = LEFT$(sCommand, LEN(sCommand) - 1)
        END IF
    END IF

    IF LEN(sCommand) THEN
        STDOUT WinErrMsg(VAL(sCommand))
    ELSE
        STDOUT "Usage:  WINERR errornumber"
    END IF

END FUNCTION
