'=============================================================================
'
'  Scan the PATH environment variable for a specified filespec.
'
'  Copyright (c) 1998-2001 PowerBASIC, Inc.
'  All Rights Reserved.
'
'=============================================================================

#COMPILE EXE
#DIM ALL



GLOBAL g_sBlank AS STRING



SUB GetOnePath (sPathList AS STRING, sPath AS STRING)

    LOCAL nCh     AS LONG
    LOCAL sWork   AS STRING
    LOCAL ix      AS LONG

    sPath = ""
    ' Skip leading whitespace.
    sPathList = LTRIM$(sPathList, ANY g_sBlank)

    IF LEN(sPathList) = 0 THEN
        ' Blank path, and we're at the end of the path list.
        EXIT SUB
    END IF

    IF LEFT$(sPathList, 1) = ";" THEN
        ' Empty path this time, but there's more after this.
        sPathList = MID$(sPathList, 2)
        EXIT SUB
    END IF

    ' Peel off a path. Parts of the path that must be preserved intact
    ' are stored in sPath. The rest goes in sWork, so we can remove
    ' any unquoted trailing whitespace when we're done.

    nCh = ASC(sPathList, 1)

    DO WHILE nCh >= 0

        SELECT CASE nCh

        CASE 59  ' ;  semicolon
            ' End of this section of the path. Clean up and exit.
            sPathList = MID$(sPathList, 2)
            nCh = -1

        CASE 34  ' "  quote
            ' Path section is quoted, in part or whole.
            ' Process the quoted part.
            sPath = sPath + sWork
            sWork = ""
            sPathList = MID$(sPathList, 2)
            ix = INSTR(sPathList, $DQ)
            IF ix THEN
                sPath = sPath + LEFT$(sPathList, ix - 1)
                sPathList = MID$(sPathList, ix + 1)
            ELSE
                sPath = sPath + sPathList
                sPathList = ""
            END IF
            nCh = ASC(sPathList, 1)

        CASE ELSE
            sWork = sWork + CHR$(nCh)
            sPathList = MID$(sPathList, 2)
            nCh = ASC(sPathList, 1)

        END SELECT

    LOOP

    sPath = sPath + RTRIM$(sWork, ANY g_sBlank)

    IF LEN(sPath) AND RIGHT$(sPath, 1) <> "\" THEN
        sPath = sPath + "\"
    END IF

END SUB



FUNCTION PBMAIN () AS LONG

    LOCAL sPathList AS STRING ' path list from PATH environment variable
    LOCAL sPath     AS STRING ' the single path we're currently looking at
    LOCAL sFileSpec AS STRING ' filespec to search for
    LOCAL sFile     AS STRING ' filespec returned from search

    g_sBlank = CHR$(0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21, _
                  22,23,24,25,26,27,28,29,30,31,32)

    sFileSpec = TRIM$(COMMAND$, ANY g_sBlank)

    IF LEN(sFileSpec) = 0 OR sFileSpec = "/?" OR sFileSpec = "-?" THEN
        STDOUT "SCANPATH 1.1 - Scan the PATH for a filespec"
        STDOUT "Copyright (c) 1998-2001 PowerBASIC, Inc."
        STDOUT "All Rights Reserved."
        STDOUT
        STDOUT "Usage: SCANPATH filespec"
        EXIT FUNCTION
    END IF

    ' Convert any path delimiters to standard DOS/Windows format.
    REPLACE "/" WITH "\" IN sFileSpec

    ' Remove quotes (if any) from filespec.
    IF ASC(sFileSpec, 1) = 34 THEN
        IF RIGHT$(sFileSpec, 1) = $DQ THEN
            sFileSpec = MID$(sFileSpec, 2, LEN(sFileSpec) - 2)
        ELSE
            sFileSpec = MID$(sFileSpec, 2)
        END IF
    END IF

    ' The default path is always searched before the PATH list.
    sPathList = ";" + TRIM$(ENVIRON$("PATH"))

    ' For all paths in the path list...
    DO WHILE LEN(sPathList)

        ' Peel a single path from the path list.
        GetOnePath sPathList, sPath

        ' Show all matches in the current path.
         sFile = DIR$(sPath + sFileSpec)
         DO WHILE LEN(sFile)
             IF sFile <> "." AND sFile <> ".." THEN
                 STDOUT sPath + sFile
             END IF
             sFile = DIR$
         LOOP

    LOOP

END FUNCTION
