'==============================================================================
'
'  Sort utility example for PowerBASIC Console Compiler
'
'  Copyright (c) 1998-2001 PowerBASIC, Inc.
'  All Rights Reserved.
'
'  Like the DOS SORT.EXE utility, this program accepts text via STDIN,
'  sorts it (case-insensitive) and writes the sorted text to STDOUT.
'
'==============================================================================

#COMPILE EXE

FUNCTION PBMAIN () AS LONG

    LOCAL count AS LONG
    LOCAL x     AS LONG

    DIM text(1 TO 200000) AS STRING   'up to 200,000 lines of text

    DO UNTIL STDEOF
        INCR count
        IF count > UBOUND(text) THEN
            STDERR "** too many lines! **
            EXIT FUNCTION
        END IF
        STDIN LINE text(count)
        IF ERR THEN
            STDERR "** input error " + FORMAT$(ERR) + " **"
            EXIT FUNCTION
        END IF
    LOOP

    ARRAY SORT text(1) FOR count, COLLATE UCASE

    FOR x = 1 TO count
        STDOUT text(x)
    NEXT

END FUNCTION
