'=============================================================================
'
'  LC : Count the number of lines in a text file.
'
'  Copyright (c) 2001 PowerBASIC, Inc.
'  All Rights Reserved.
'
'=============================================================================



#COMPILE EXE
#DIM ALL



FUNCTION PBMAIN() AS LONG

    LOCAL sFileName AS STRING
    LOCAL sText AS STRING
    LOCAL lc AS QUAD

    sFileName = TRIM$(COMMAND$)
    IF ASC(sFileName, 1) = 34 THEN
        sFileName = MID$(sFileName, 2)
        IF ASC(RIGHT$(sFileName, 1)) = 34 THEN
            sFileName = LEFT$(sFileName, LEN(sFileName) - 1)
        END IF
    END IF

    IF LEN(sFileName) = 0 OR sFileName = "/?" OR sFileName = "-?" THEN
        STDOUT ""
        STDOUT "LC 1.0  Copyright (c) 2001  PowerBASIC, Inc."
        STDOUT ""
        STDOUT "Purpose:"
        STDOUT "  Count the number of lines in a text file.
        STDOUT ""
        STDOUT "Syntax:"
        STDOUT "  LC filename"
        STDOUT ""
        EXIT FUNCTION
    END IF

    IF LEN(DIR$(sFileName)) = 0 THEN
        STDERR "Can't find file " + sFileName
        EXIT FUNCTION
    END IF

    OPEN sFileName FOR BINARY ACCESS READ LOCK WRITE AS #1
    GET$ 1, LOF(1), sText
    CLOSE #1

    IF ERR THEN
        STDERR "Error reading file " + sFileName
        EXIT FUNCTION
    END IF

    IF LEN(sText) THEN
        lc = Tally(sText, $LF)
        DO WHILE ASC(RIGHT$(sText, 1)) = 26
            sText = LEFT$(sText, LEN(sText) - 1)
        LOOP
    END IF

    IF LEN(sText) THEN
        IF RIGHT$(sText, 1) <> $LF THEN
            INCR lc
        END IF
    END IF

    STDOUT Format$(Tally(sText, $LF), "#,##0") + " lines"

END FUNCTION
