'==============================================================================
'
'  FileVer 1.0 - Display a file's version information.
'
'  Copyright (c) 2000-2001  PowerBASIC, Inc.
'  All Rights Reserved.
'
'==============================================================================


#DIM ALL
#COMPILE EXE

#INCLUDE "win32api.inc"



' Structure used to store enumerated languages and code pages.

TYPE LANGANDCODEPAGE
    wLanguage AS WORD
    wCodePage AS WORD
END TYPE



GLOBAL nExit AS LONG


SUB ShowHeader ()

    STDOUT "FileVer 1.0  Copyright (c) 2000-2001  PowerBASIC, Inc."
    STDOUT

END SUB



SUB ShowHelp ()

    ShowHeader
    STDOUT "Purpose:"
    STDOUT "   Display the string version information for a file."
    STDOUT
    STDOUT "Syntax:"
    STDOUT "   FILEVER filespec"

END SUB



SUB DeQuote (sFileName AS STRING)

    IF LEFT$(sFileName, 1) = $DQ THEN
        sFileName = MID$(sFileName, 2)
        IF RIGHT$(sFileName, 1) = $DQ THEN
            sFileName = LEFT$(sFileName, LEN(sFileName) - 1)
        END IF
    END IF

END SUB



SUB ShowNumericInfo (pData AS STRING)

    LOCAL dFlags AS DWORD
    LOCAL fSuccess AS LONG
    LOCAL pVerInfo AS VS_FIXEDFILEINFO PTR
    LOCAL sSubBlock AS ASCIIZ * 2

    sSubBlock = "\"

    fSuccess = VerQueryValue(STRPTR(pData), sSubBlock, pVerInfo, LEN(VS_FIXEDFILEINFO))
    IF ISFALSE fSuccess THEN
        STDOUT "VerQueryValue failed with root block"
        EXIT SUB
    END IF

    STDOUT "Numeric Version Information"
    STDOUT "   File Version   : ";
    STDOUT LTRIM$(STR$(HIWRD(@pVerInfo.dwFileVersionMS)));
    STDOUT ".";
    STDOUT LTRIM$(STR$(LOWRD(@pVerInfo.dwFileVersionMS)));
    STDOUT ".";
    STDOUT LTRIM$(STR$(HIWRD(@pVerInfo.dwFileVersionLS)));
    STDOUT ".";
    STDOUT LTRIM$(STR$(LOWRD(@pVerInfo.dwFileVersionLS)))

    STDOUT "   Product Version: ";
    STDOUT LTRIM$(STR$(HIWRD(@pVerInfo.dwProductVersionMS)));
    STDOUT ".";
    STDOUT LTRIM$(STR$(LOWRD(@pVerInfo.dwProductVersionMS)));
    STDOUT ".";
    STDOUT LTRIM$(STR$(HIWRD(@pVerInfo.dwProductVersionLS)));
    STDOUT ".";
    STDOUT LTRIM$(STR$(LOWRD(@pVerInfo.dwProductVersionLS)))

    dFlags = (@pVerInfo.dwFileFlags AND @pVerInfo.dwFileFlagsMask)
    IF dFlags AND %VS_FF_DEBUG THEN
        STDOUT "   Debug version"
    END IF
    IF dFlags AND %VS_FF_PATCHED THEN
        STDOUT "   Patched version"
    END IF
    IF dFlags AND %VS_FF_PRERELEASE THEN
        STDOUT "   Pre-release version"
    END IF
    IF dFlags AND %VS_FF_PRIVATEBUILD THEN
        STDOUT "   Private build"
    END IF
    IF dFlags AND %VS_FF_SPECIALBUILD THEN
        STDOUT "   Special build"
    END IF

    STDOUT "   Designed for operating system: ";
    SELECT CASE @pVerInfo.dwFileOS
        CASE %VOS_UNKNOWN
            STDOUT "unknown"
        CASE %VOS_DOS
            STDOUT "MS-DOS"
        CASE %VOS_OS216
            STDOUT "OS/2 16-bit"
        CASE %VOS_OS232
            STDOUT "OS/2 32-bit"
        CASE %VOS_NT
            STDOUT "NT / Windows 2000"
        CASE %VOS__WINDOWS16
            STDOUT "Windows 16-bit"
        CASE %VOS__PM16
            STDOUT "OS/2 Presentation Manager 16-bit"
        CASE %VOS__PM32
            STDOUT "OS/2 Presentation Manager 32-bit"
        CASE %VOS__WINDOWS32
            STDOUT "Windows (Win32 API)"
        CASE %VOS_DOS_WINDOWS16
            STDOUT "Windows 16-bit running on MS-DOS"
        CASE %VOS_DOS_WINDOWS32
            STDOUT "Windows 32-bit running on MS-DOS"
        CASE %VOS_OS216_PM16
            STDOUT "16-bit Presentation Manager on 16-bit OS/2"
        CASE %VOS_OS232_PM32
            STDOUT "32-bit Presentation Manager on 32-bit OS/2"
        CASE %VOS_NT_WINDOWS32
            STDOUT "NT / Windows 2000"
        CASE ELSE
            STDOUT "other"
    END SELECT

    STDOUT "   File type: ";
    SELECT CASE @pVerInfo.dwFileType
        CASE %VFT_UNKNOWN
            STDOUT "unknown"
        CASE %VFT_APP
            STDOUT "application"
        CASE %VFT_DLL
            STDOUT "dynamic link library"
        CASE %VFT_DRV
            STDOUT "device driver of type ";
            SELECT CASE @pVerInfo.dwFileSubtype
                CASE %VFT2_UNKNOWN
                    STDOUT "unknown"
                CASE %VFT2_DRV_PRINTER
                    STDOUT "printer"
                CASE %VFT2_DRV_KEYBOARD
                    STDOUT "keyboard"
                CASE %VFT2_DRV_LANGUAGE
                    STDOUT "language"
                CASE %VFT2_DRV_DISPLAY
                    STDOUT "display"
                CASE %VFT2_DRV_MOUSE
                    STDOUT "mouse"
                CASE %VFT2_DRV_NETWORK
                    STDOUT "network"
                CASE %VFT2_DRV_SYSTEM
                    STDOUT "system"
                CASE %VFT2_DRV_INSTALLABLE
                    STDOUT "installable"
                CASE %VFT2_DRV_SOUND
                    STDOUT "sound"
                CASE %VFT2_DRV_COMM
                    STDOUT "communications"
                CASE ELSE
                    STDOUT "other"
            END SELECT
        CASE %VFT_FONT
            STDOUT "font of type ";
            SELECT CASE @pVerInfo.dwFileSubtype
                CASE %VFT2_UNKNOWN
                    STDOUT "unknown"
                CASE %VFT2_FONT_RASTER
                    STDOUT "raster"
                CASE %VFT2_FONT_VECTOR
                    STDOUT "vector"
                CASE %VFT2_FONT_TRUETYPE
                    STDOUT "TrueType"
                CASE ELSE
                    STDOUT "other"
            END SELECT
        CASE %VFT_VXD
            STDOUT "virtual device"
        CASE %VFT_STATIC_LIB
            STDOUT "static link library"
        CASE ELSE
            STDOUT "other"
    END SELECT

    STDOUT

END SUB



SUB ShowStringInfo (pData AS STRING, dwLen AS DWORD)

    LOCAL ncLanguages AS LONG
    LOCAL ixLanguage AS LONG
    LOCAL ixField AS LONG
    LOCAL fSuccess AS LONG
    LOCAL wCode AS WORD
    LOCAL wLang AS WORD
    LOCAL sSubBlock AS ASCIIZ * 64
    LOCAL sFieldName AS STRING
    LOCAL pTranslate AS LANGANDCODEPAGE PTR
    LOCAL sResult AS ASCIIZ PTR

    sSubBlock = "\VarFileInfo\Translation"

    fSuccess = VerQueryValue(STRPTR(pData), sSubBlock, pTranslate, dwLen)
    IF ISFALSE fSuccess THEN
        STDOUT "VerQueryValue failed with sub-block ";
        STDOUT sSubBlock
        EXIT SUB
    END IF

    ' Read each version info field for each language and code page.

    ncLanguages = dwLen / LEN(LANGANDCODEPAGE)

    DATA "Comments", "CompanyName", "FileDescription", "FileVersion"
    DATA "InternalName", "LegalCopyright", "LegalTrademarks", "OriginalFilename"
    DATA "ProductName", "ProductVersion", "PrivateBuild", "SpecialBuild"

    FOR ixLanguage = 1 TO ncLanguages
        wLang = @pTranslate[ixLanguage - 1].wLanguage
        wCode = @pTranslate[ixLanguage - 1].wCodePage
        STDOUT "String Version Information for language &H";
        STDOUT HEX$(wLang);
        STDOUT " code page &H";
        STDOUT HEX$(wCode);
        STDOUT ":"
        FOR ixField = 1 TO DATACOUNT
            sFieldName = READ$(ixField)
            sSubBlock = "\StringFileInfo\" & HEX$(wLang, 4) & HEX$(wCode, 4) & "\" & sFieldName
            fSuccess = VerQueryValue(STRPTR(pData), sSubBlock, sResult, dwLen)
            IF fSuccess THEN
                STDOUT "   ";
                STDOUT sFieldName;
                STDOUT " = ";
                STDOUT LEFT$(@sResult, dwLen)
            END IF
        NEXT
    NEXT

END SUB



SUB ShowVersionInfo (sFileName AS STRING)

    LOCAL dwLen AS DWORD
    LOCAL dwHandle AS DWORD
    LOCAL fSuccess AS LONG
    LOCAL pData AS STRING

    ShowHeader

    ' Retrieve the size of the file version information block.

    dwLen = GetFileVersionInfoSize(BYCOPY sFileName, dwHandle)

    IF dwLen = 0 THEN
        STDOUT "No version information available."
        EXIT SUB
    END IF

    ' Read the file version information block.

    pData = SPACE$(dwLen)

    fSuccess = GetFileVersionInfo(BYCOPY sFileName, dwHandle, dwLen, BYVAL STRPTR(pData))

    IF ISFALSE fSuccess THEN
        STDOUT "Unable to read file version information."
        EXIT SUB
    END IF

    ' Read the numeric version info block. Display same.

    ShowNumericInfo pData

    ' Read the list of languages and code pages. Display same.

    ShowStringInfo pData, dwLen

END SUB



FUNCTION PBMAIN () AS LONG

    DIM sFileName AS STRING, Clicked&

    IF CURSORX * CURSORY = 1& THEN Clicked& = -1

    ' Get command line. If "/?" or blank, help 'em out.

    sFileName = TRIM$(COMMAND$)
    IF LEN(sFileName) = 0 OR INSTR(sFileName, "/?") > 0 THEN
        ShowHelp
        IF Clicked& THEN WAITKEY$
        EXIT FUNCTION
    END IF

    ' Command line is presumably our input filespec. Clean it up.

    DeQuote sFileName

    ' Show file version info.

    ShowVersionInfo sFileName

    IF Clicked& THEN WAITKEY$

END FUNCTION
