'==============================================================================
'
'  File Find example for the PowerBASIC Console Compiler
'
'  Copyright (c) 1997-2001 PowerBASIC, Inc.
'  All Rights Reserved.
'
'==============================================================================



#COMPILE EXE
#OPTION VERSION4

#DIM ALL

#INCLUDE "win32api.inc"



FUNCTION IsMatchingFile (BYVAL sFileSpec AS STRING, BYVAL sPattern AS STRING) _
         AS LONG

    LOCAL nPosition AS LONG
    LOCAL ncbLength AS LONG

    REGEXPR sPattern IN sFileSpec TO nPosition, ncbLength

    FUNCTION = (nPosition > 0)

END FUNCTION



FUNCTION FileDateTime (fd AS WIN32_FIND_DATA) AS STRING

    LOCAL szText AS ASCIIZ * 64
    LOCAL st    AS SYSTEMTIME
    LOCAL Temp  AS STRING

    ' Convert the file time from UTC to local time
    FileTimeToLocalFileTime fd.ftLastWriteTime, fd.ftLastWriteTime

    ' Convert the file time into a convenient system time
    FileTimeToSystemTime fd.ftLastWriteTime, st

    ' Create a date string using the local settings
    GetDateFormat %LOCALE_USER_DEFAULT, %DATE_SHORTDATE, st, BYVAL %NULL, szText, SIZEOF(szText)
    Temp = szText

    ' Create a time string using the local settings
    GetTimeFormat %LOCALE_USER_DEFAULT, 0, st, BYVAL %NULL, szText, SIZEOF(szText)

    ' Return the file date and time
    FUNCTION = Temp + "  " + szText

END FUNCTION



FUNCTION MAKQUD (BYVAL dLow AS DWORD, BYVAL dHigh AS DWORD) AS QUAD

    LOCAL qTmp AS QUAD

    qTmp = dHigh
    SHIFT LEFT qTmp, 32

    FUNCTION = qTmp OR dLow

END FUNCTION



FUNCTION PBMAIN () AS LONG

    LOCAL fd          AS WIN32_FIND_DATA
    LOCAL sSearchSpec AS STRING
    LOCAL ncPaths     AS LONG
    LOCAL hFind       AS LONG
    LOCAL qcbFileSize AS QUAD

    DIM asPathList(1 TO 1) AS STRING

    sSearchSpec = TRIM$(COMMAND$)

    ' See if they need help.

    SELECT CASE sSearchSpec

    CASE "", "/?", "-?", "/H", "/h"
        STDOUT "File Finder 2.0  Copyright (c) 1997-2001  PowerBASIC, Inc."
        STDOUT "All Rights Reserved."
        STDOUT
        STDOUT "Purpose:"
        STDOUT "  Search for a specified file on the default drive. Wildcards are supported"
        STDOUT "  with regular expressions."
        STDOUT
        STDOUT "Syntax:"
        STDOUT "  FILEFIND filespec"
        STDOUT
        EXIT FUNCTION

    END SELECT

    ' If filespec is quoted, remove the quotes.

    IF ASC(sSearchSpec, 1) = 34 THEN
        sSearchSpec = MID$(sSearchSpec, 2)
        IF RIGHT$(sSearchSpec, 1) = $DQ THEN
            sSearchSpec = LEFT$(sSearchSpec, LEN(sSearchSpec) - 1)
        END IF
    END IF

    ' Treat any periods as literals rather than as regex codes.

    REPLACE "." WITH "\." IN sSearchSpec

    ' Use the default drive or \\server\share as the initial search path.

    ncPaths = 1
    asPathList(ncPaths) = CURDIR$
    IF LEFT$(asPathList(ncPaths), 2) = "\\" THEN
        asPathList(ncPaths) = LEFT$(asPathList(ncPaths), _
                                    INSTR(3, asPathList(ncPaths), "\"))
    ELSE
        asPathList(ncPaths) = LEFT$(asPathList(ncPaths), 3)
    END IF

    ' Scan for matching files, one directory at a time.

    DO
        hFind = FindFirstFile(asPathList(1) + "*", fd)
        IF hFind <> BITS&(%INVALID_HANDLE_VALUE) THEN

            DO

                IF fd.cFilename <> "." AND fd.cFilename <> ".." THEN

                    ' If it's a directory, add it to the search list.
                    IF (fd.dwFileAttributes AND %FILE_ATTRIBUTE_DIRECTORY) THEN
                        INCR ncPaths
                        REDIM PRESERVE asPathList(1 TO ncPaths) AS STRING
                        asPathList(ncPaths) = asPathList(1) + fd.cFilename + "\"
                    END IF

                    ' If it's a matching file, display it.
                    IF IsMatchingFile(fd.cFilename, sSearchSpec) THEN
                        STDOUT
                        STDOUT asPathList(1) + fd.cFilename
                        STDOUT "  Last Modified: " + FileDateTime(fd)
                        ' Microsoft put the size fields in the wrong order, so
                        ' we need to convert 'em the slow way...
                        qcbFileSize = MAKQUD(fd.nFileSizeLow, fd.nFileSizeHigh)
                        STDOUT "  Bytes: " + FORMAT$(qcbFileSize, "#,##0")
                    END IF
                END IF

            LOOP WHILE FindNextFile(hFind, fd)

            FindClose hFind

        END IF

        ARRAY DELETE asPathList()
        DECR ncPaths

    LOOP WHILE ncPaths

END FUNCTION
