'=============================================================================
'
'  ASC2ANSI : Convert an OEM ASCII text file to an ANSI text file.
'
'  Copyright (c) 2001 PowerBASIC, Inc.
'  All Rights Reserved.
'
'=============================================================================

#COMPILE EXE

DECLARE FUNCTION OemToChar LIB "USER32.DLL" ALIAS "OemToCharA" (lpszSrc AS ASCIIZ, lpszDst AS ASCIIZ) AS LONG


FUNCTION PBMAIN() AS LONG

    LOCAL sFileName AS STRING
    LOCAL sText AS STRING

    sFileName = TRIM$(COMMAND$)
    IF ASC(sFileName, 1) = 34 THEN
        sFileName = MID$(sFileName, 2)
        IF ASC(RIGHT$(sFileName, 1)) = 34 THEN
            sFileName = LEFT$(sFileName, LEN(sFileName) - 1)
        END IF
    END IF

    IF LEN(sFileName) = 0 OR sFileName = "/?" OR sFileName = "-?" THEN
        STDOUT ""
        STDOUT "ASC2ANSI 1.0  Copyright (c) 2001  PowerBASIC, Inc."
        STDOUT ""
        STDOUT "Purpose:"
        STDOUT "  Convert an OEM ASCII text file to an ANSI text file."
        STDOUT "  The existing file is overwritten by the new file."
        STDOUT ""
        STDOUT "Syntax:"
        STDOUT "  ASC2ANSI filename"
        STDOUT ""
        EXIT FUNCTION
    END IF

    IF LEN(DIR$(sFileName)) = 0 THEN
        STDERR "Can't find file " + sFileName
        EXIT FUNCTION
    END IF

    OPEN sFileName FOR BINARY ACCESS READ LOCK WRITE AS #1
    GET$ 1, LOF(1), sText
    CLOSE #1

    IF ERR THEN
        STDERR "Error reading file " + sFileName
        EXIT FUNCTION
    END IF

    OemToChar BYVAL STRPTR(sText), BYVAL STRPTR(sText)

    OPEN sFileName FOR BINARY ACCESS READ WRITE LOCK READ WRITE AS #1
    PUT$ 1, sText
    CLOSE #1

    IF ERR THEN
        STDERR "Error writing file " + sFileName
        EXIT FUNCTION
    END IF

END FUNCTION
