'==============================================================================
'
'  UDP TIME Server for PB/CC
'
'  Copyright (c) 1999-2001 PowerBASIC, Inc.
'  All Rights Reserved.
'
'==============================================================================

' Creates a UDP server to monitor UDP broadcasts to port %UPort, and responds
' with this machines TIME$.

' We use a UDP Server since we can nominate the specific port we wish to
' listen to.

' Typical usage for this type of application:
' 1. Every PC runs the Server app, and the local time for each can be queried
'    remotely.
' 2. Only one server is running, and all clients set their time according to the
'    servers time.

%UPort = 16000

#COMPILE EXE
#DIM ALL

FUNCTION DottedIP$(ip AS LONG)
    LOCAL x AS BYTE PTR
    x = VARPTR(ip)
    FUNCTION = FORMAT$(@x) & "." & FORMAT$(@x[1]) & "." & FORMAT$(@x[2]) & "." & FORMAT$(@x[3])
END FUNCTION

FUNCTION PBMAIN() AS LONG
    LOCAL ip     AS LONG      ' This machines IP address
    LOCAL hUdp   AS LONG      ' UDP file number
    LOCAL Buffer AS STRING    ' UDP data received
    LOCAL ipAddr AS LONG      ' IP address of sending machine
    LOCAL ipPort AS LONG      ' UDP Port of sending machine to reply to

    PRINT "Starting UDP TIME server."

    ' Get this machines IP address
    HOST ADDR TO ip

    ' Open a specific UDP/IP port with a 60 second timeout
    hUdp = FREEFILE
    UDP OPEN PORT %UPort AS hUdp TIMEOUT 60
    IF ERR THEN BEEP : EXIT FUNCTION

    ' We opened the UDP/IP port Ok, so inform the user
    PRINT "Listening for broadcasts to " & DottedIP$(ip) & ":" & _
        FORMAT$(%UPort) & "..."

    DO

        ' Start listening to the UDP/IP port
        ERRCLEAR
        UDP RECV #hUdp, FROM ipAddr, ipPort, Buffer

        ' Ignore any timout or other errors
        IF ERR THEN ITERATE

        ' We got one, so update the status screen
        PRINT "Received from " & DottedIP$(ipAddr) & ":" & _
            FORMAT$(ipPort) & " at " & TIME$ & " -> " & $DQ & Buffer & $DQ

        ' Reply with our time
        UDP SEND #hUdp, AT ipAddr, ipPort, TIME$

    LOOP UNTIL INKEY$ = CHR$(27)

    CLOSE #hUdp

END FUNCTION
