'==============================================================================
'
'  UDP TIME Client for PB/CC
'
'  Copyright (c) 1999-2001 PowerBASIC, Inc.
'  All Rights Reserved.
'
'==============================================================================

' Creates a UDP client which does a UDP broadcast port %UPort of machines on
' the network segment.  After a broadcast, the client waits for responses from
' UDP servers listening to that specific port, and which are expected to reply
' with their local time in TIME$ format.

' The outgoing UDP port is irrelevent here, as the receiving machine (the server)
' will be automatically informed of the reply-to port number when the UDP
' broadcast is received from this machine.

' Typical uses for this type of application:
' 1. Every PC runs the Server app, and the local time for each can be queried
'    remotely.
' 2. Only one server is running, and all clients set their time according to the
'    servers time.

%UPort = 16000

#COMPILE EXE
#DIM ALL

FUNCTION DottedIP$(ip AS LONG)
    LOCAL x AS BYTE PTR
    x = VARPTR(ip)
    FUNCTION = FORMAT$(@x) & "." & FORMAT$(@x[1]) & "." & FORMAT$(@x[2]) & "." & FORMAT$(@x[3])
END FUNCTION

FUNCTION PBMAIN() AS LONG
    LOCAL ip     AS LONG      ' This machines IP address
    LOCAL bip    AS LONG      ' Broadcase IP address for this segment (class D)
    LOCAL hUdp   AS LONG      ' UDP file number
    LOCAL Buffer AS STRING    ' UDP data received
    LOCAL ipAddr AS LONG      ' IP address of sending machine
    LOCAL ipPort AS LONG      ' UDP Port of sending machine to reply to
    LOCAL t      AS SINGLE    ' Timer for reply monitoring

    PRINT "Starting UDP TIME Client."

    ' Get this machines IP address
    HOST ADDR TO ip

    ' Now we mask off the last section with 255.  Ideally, the submask for the
    ' network segment would give us the right value to use.
    bip = (ip OR &HFF000000)

    ' Open a UDP/IP channel with a 5 second timeout
    hUdp = FREEFILE
    UDP OPEN AS #hUdp TIMEOUT 5
    IF ERR THEN BEEP : EXIT FUNCTION

    DO

        ' We opened a UDP channel Ok, so inform the user
        PRINT "Broadcasting to " & DottedIP$(bip) & " from " & DottedIP$(ip)

        ' Initiate a broadcast to this segment
        Buffer = "What is your time?"
        UDP SEND hUdp, AT bip, %UPort, Buffer

        ' Update the status on the screen
        PRINT "-> " & $DQ & Buffer & $DQ & " " & TIME$

        ' We'll monitor replies for 5 seconds, then do another broadcast
        t = TIMER
        WHILE ABS(TIMER - t) < 5

            ERRCLEAR
            UDP RECV #hUdp, FROM ipAddr, ipPort, Buffer

            ' Ignore any timout or other errors
            IF ERR THEN ITERATE

            ' We got one!  Display the data (remote time)
            PRINT "     The time at " & DottedIP(ipAddr) & ":" & _
                FORMAT$(ipPort) & " is " & $DQ & Buffer & $DQ

        WEND

    LOOP UNTIL INKEY$ = CHR$(27)

    CLOSE #hUdp

END FUNCTION
