'=============================================================================
'
'  Multi-threading example for the PowerBASIC Console Compiler
'
'  Copyright (c) 1998-2001 PowerBASIC, Inc.
'  All Rights Reserved.
'
'=============================================================================



#INCLUDE "WIN32API.INC"



FUNCTION PBMAIN () AS LONG

    LOCAL x AS LONG
    LOCAL s AS LONG

    DIM idThread(10) AS LONG

    FOR x = 1 TO 10
        THREAD CREATE MyThread(x) TO idThread(x)
        SLEEP 750
    NEXT

    PRINT "10 Threads Started!"
    PRINT "Wait for them to finish!"

    DO
        SLEEP 500
        FOR x = 1 TO 10
            THREAD STATUS idThread(x) TO s
            IF s THEN ITERATE DO
        NEXT
    LOOP WHILE s

    PRINT "Finished!"

END FUNCTION



FUNCTION MyThread (BYVAL x AS LONG) AS LONG

    LOCAL n AS LONG
    LOCAL t AS SINGLE

    PRINT "Start Thread"; x
    t = TIMER

    FOR n = 1 TO 100
        SLEEP 100
    NEXT n

    t = TIMER - t
    PRINT "End Thread"; x
    PRINT "Elapsed time (100*100 ms) =" + STR$(t, 5)

END FUNCTION
