'==============================================================================
'
'  WHOIS  Example of retrieving domain information with PB/CC
'
'  Copyright (c) 1999-2001 PowerBASIC, Inc.
'  All Rights Reserved.
'
'  See RFC 954 (http://www.powerbasic.com/files/pub/docs/rfc/900/rfc954.zip)
'
'------------------------------------------------------------------------------
'
'  Server                 Domain suffix
'  ---------------------  -----------------------------------------------------
'  rs.internic.net        com, net, org
'  whois.nic.uk           co.uk, org.uk, net.uk, ltd.uk, plc.uk
'  whois.nic.gov          gov
'  whois.nic.mil          mil
'
'  whois.ripe.net         IP addresses
'
'==============================================================================



$DATABASE = "rs.internic.net"
%PORT     = 43



FUNCTION WhoIs (BYVAL serv AS STRING, BYVAL webhost AS STRING) AS STRING

    LOCAL sBuffer AS STRING
    LOCAL sResult AS STRING
    LOCAL ix      AS LONG

    TCP OPEN PORT %PORT AT serv AS #1
    IF ERR THEN
        EXIT FUNCTION
    END IF

    TCP PRINT #1, webhost

    DO
        TCP RECV #1, 4096, sBuffer
        sResult = sResult + sBuffer
    LOOP WHILE LEN(sBuffer)

    TCP CLOSE #1

    sResult = TRIM$(sResult, $LF)
    REPLACE $LF WITH $CRLF IN sResult

    ix = INSTR(sResult, "Whois Server:")
    IF ix THEN
        serv = EXTRACT$(MID$(sResult, ix + 14), ANY $CRLF)
        sResult = Whois(serv, webhost)
    END IF

    FUNCTION = sResult

END FUNCTION



FUNCTION PBMAIN () AS LONG

    LOCAL sWho AS STRING

    sWho = TRIM$(COMMAND$)

    IF LEN(sWho) = 0 THEN
        STDOUT "WHOIS 1.1 - Internic Domain Lookup Utility"
        STDOUT "Copyright (c) 1999-2001 PowerBASIC, Inc."
        STDOUT ""
        STDOUT "Usage: whois name"
        STDOUT ""
        STDOUT "Example: whois powerbasic.com"
        EXIT FUNCTION
    END IF

    STDOUT WhoIs($DATABASE, sWho)

END FUNCTION
