'==============================================================================
'
'  TCP communications for 32-bit PowerBASIC
'
'  Copyright (c) 1999-2001 PowerBASIC, Inc.
'  All Rights Reserved.
'
'  Contains encapsulation code for the following TCP protocols:
'
'    Simple Mail Transfer Protocol (SMTP) - RFC 821
'    Post Office Protocol 3 (POP3) - RFC 1725
'
'==============================================================================



' Helper function for TCP. Converts IP number to a dot string.
'
FUNCTION IpToString (BYVAL ip AS LONG) AS STRING

    LOCAL b AS BYTE PTR

    b = VARPTR(ip)
    FUNCTION = FORMAT$(@b[0]) + "." + FORMAT$(@b[1]) + "."  _
             + FORMAT$(@b[2]) + "." + FORMAT$(@b[3])

END FUNCTION



' Helper function for TCP. Returns zero if successful, error code if not.
'
FUNCTION TcpGetLine (BYVAL hTCP AS LONG, Buffer AS STRING) AS LONG

    Buffer = ""

    TCP LINE hTCP, Buffer

    FUNCTION = ERR

END FUNCTION



' Helper function for SMTP protocol.
'
FUNCTION SmtpGetLine (BYVAL hTCP AS LONG, Buffer AS STRING) AS LONG

  IF TcpGetLine(hTCP, Buffer) = 0 THEN
      FUNCTION = VAL(LEFT$(Buffer, 3))
      Buffer = MID$(Buffer, 5)
  END IF

END FUNCTION



' Send a text email message to a single recipient. Returns zero if successful.
'
FUNCTION SmtpSendMail (BYVAL SmtpHost AS STRING, BYVAL EmailFrom AS STRING, _
                       BYVAL EmailTo AS STRING, BYVAL Subject AS STRING, _
                       Message() AS STRING) AS LONG

    LOCAL hTCP      AS LONG
    LOCAL e         AS LONG
    LOCAL u         AS LONG
    LOCAL x         AS LONG
    LOCAL Buffer    AS STRING
    LOCAL localhost AS STRING

    ON ERROR GOTO SmtpError

    ' Get the local computer's name
    HOST NAME TO localhost

    ' Connect to the SMTP server
    hTCP = FREEFILE
    TCP OPEN "smtp" AT SmtpHost AS hTCP

    e = SmtpGetLine(hTCP, Buffer)
    IF e <> 220 THEN GOTO SmtpDone

    ' Meet & greet the SMTP host
    TCP PRINT hTCP, "HELO " & localhost
    e = SmtpGetLine(hTCP, Buffer)
    IF e <> 250 THEN GOTO SmtpDone

    TCP PRINT hTCP, "MAIL FROM:<" & EmailFrom & ">"
    e = SmtpGetLine(hTCP, Buffer)
    IF e <> 250 THEN GOTO SmtpDone

    TCP PRINT hTCP, "RCPT TO:<" & EmailTo & ">"
    e = SmtpGetLine(hTCP, Buffer)
    IF e <> 250 THEN GOTO SmtpDone

    TCP PRINT hTCP, "DATA"
    e = SmtpGetLine(hTCP, Buffer)
    IF e <> 354 THEN GOTO SmtpDone

    ' Message header
    TCP PRINT hTCP, "From: " & EmailFrom
    TCP PRINT hTCP, "To: " & EmailTo
    TCP PRINT hTCP, "Subject: " & Subject
    TCP PRINT hTCP, "X-Mailer: PowerBASIC DLL Compiler for Windows"
    TCP PRINT hTCP, ""

    ' Message text
    u = UBOUND(Message(1))
    FOR x = 1 TO u
        Buffer = Message(x)
        IF LEFT$(Buffer, 1) = "." THEN
            Buffer = "." + Buffer
        END IF
        TCP PRINT hTCP, Buffer
    NEXT x

    ' End of message
    TCP PRINT hTCP, "."
    e = SmtpGetLine(hTCP, Buffer)
    IF e <> 250 THEN GOTO SmtpDone

    TCP PRINT hTCP, "QUIT"
    e = SmtpGetLine(hTCP, Buffer)
    IF e <> 221 THEN GOTO SmtpDone

    e = 0  ' success!

SmtpDone:
    FUNCTION = e
    CLOSE hTCP
    EXIT FUNCTION

SmtpError:
    e = ERR
    RESUME SmtpDone

END FUNCTION



' Connect to POP3 mail server. Returns zero if error, else file number.
'
FUNCTION Pop3Connect (BYVAL Pop3Host AS STRING, BYVAL User AS STRING, _
                      BYVAL password AS STRING) AS LONG

    LOCAL hTCP   AS LONG
    LOCAL Buffer AS STRING

    ON ERROR GOTO Pop3Error

    hTCP = FREEFILE

    TCP OPEN "pop3" AT Pop3Host AS hTCP

    TCP LINE hTCP, Buffer
    IF LEFT$(Buffer, 3) <> "+OK" THEN GOTO Pop3Error

    TCP PRINT hTCP, "USER " & User
    TCP LINE hTCP, Buffer
    IF LEFT$(Buffer, 3) <> "+OK" THEN GOTO Pop3Error

    TCP PRINT hTCP, "PASS " & password
    TCP LINE hTCP, Buffer
    IF LEFT$(Buffer, 3) <> "+OK" THEN GOTO Pop3Error

    FUNCTION = hTCP
    EXIT FUNCTION

Pop3Error:
    CLOSE hTCP

END FUNCTION



' Disconnect from POP3 mail server. Returns -1 if error.
'
FUNCTION Pop3Quit (BYVAL hTCP AS LONG) AS LONG

    LOCAL Buffer AS STRING

    TCP PRINT hTCP, "QUIT"
    TCP LINE hTCP, Buffer

    FUNCTION = (LEFT$(Buffer, 3) <> "+OK")

END FUNCTION



' Get the status of the POP3 account. Returns -1 if error.
'
FUNCTION Pop3GetStat (BYVAL hTCP AS LONG, Messages AS LONG, MsgSize AS LONG) _
    AS LONG

    LOCAL Buffer AS STRING

    TCP PRINT hTCP, "STAT"
    TCP LINE hTCP, Buffer

    IF LEFT$(Buffer, 3) <> "+OK" THEN
        FUNCTION = -1
    ELSE
        Messages = VAL(PARSE$(Buffer, " ", 2))
        MsgSize  = VAL(PARSE$(Buffer, " ", 3))
    END IF

END FUNCTION


' Retrieve a message from a POP3 server.
'
FUNCTION Pop3RetrMessage (BYVAL hTCP AS LONG, BYVAL MsgNumber AS LONG, _
                          Msg() AS STRING) AS LONG

    LOCAL x      AS LONG
    LOCAL Buffer AS STRING

    ON ERROR GOTO Pop3RetrDone

    REDIM Msg(1 to 100) AS STRING

    TCP PRINT hTCP, "RETR" & STR$(MsgNumber)
    TCP LINE hTCP, Buffer

    IF LEFT$(Buffer, 3) <> "+OK" THEN GOTO Pop3RetrDone

    DO
        TCP LINE hTCP, Buffer
        IF Buffer = "." THEN
            EXIT DO
        END IF
        INCR x
        IF LEFT$(Buffer, 2) = ".." THEN
            Buffer = "." + MID$(Buffer, 3)
        END IF
        IF x > UBOUND(Msg(1)) THEN
            REDIM PRESERVE Msg(1 to x + 50) AS STRING
        END IF
        Msg(x) = Buffer
    LOOP

Pop3RetrDone:
    IF x = 0 THEN
        ERASE Msg()
    ELSE
        REDIM PRESERVE Msg(1 to x) AS STRING
        FUNCTION = x
    END IF

END FUNCTION
