'==============================================================================
'
'  TCP Echo Client for PB/CC 2.1
'
'  Copyright (c) 1999-2001 PowerBASIC, Inc.
'  All Rights Reserved.
'
'==============================================================================



#COMPILE EXE
#DIM ALL

%CCWIN = 1                ' Include GUI API calls
#INCLUDE "WIN32API.INC"

#INCLUDE "WSOCK32.INC"



%TCP_ACCEPT = %WM_USER + 4093
%TCP_ECHO   = %WM_USER + 4094



GLOBAL hEcho    AS LONG
GLOBAL hServer  AS LONG
GLOBAL hwndTCP  AS LONG
GLOBAL hThread  AS LONG



SUB LogEvent (BYVAL buffer AS STRING)

    Buffer = TIME$ + " - " + Buffer

    PRINT Buffer

END SUB



FUNCTION TcpProc (BYVAL hWnd AS LONG, BYVAL wMsg AS LONG, _
                  BYVAL wParam AS LONG, BYVAL lParam AS LONG) EXPORT AS LONG

    STATIC hEcho   AS LONG
    STATIC Buffer  AS STRING
    STATIC hServer AS LONG

    SELECT CASE wMsg

    CASE %WM_CREATE
        hServer = FREEFILE
        TCP OPEN SERVER PORT 7 AS hServer
        IF ERR THEN
            Buffer = "Couldn't create socket!"
        ELSE
            TCP NOTIFY hServer, ACCEPT TO hWnd AS %TCP_ACCEPT
            Buffer = "Connected to Port 7"
        END IF
        LogEvent Buffer
        hEcho = %INVALID_SOCKET
        FUNCTION = 1

    CASE %TCP_ACCEPT
        SELECT CASE LOWRD(lParam)

        CASE %FD_ACCEPT
            hEcho = FREEFILE
            TCP ACCEPT hServer AS hEcho
            TCP NOTIFY hEcho, RECV CLOSE TO hWnd AS %TCP_ECHO

        END SELECT
        FUNCTION = 1

    CASE %TCP_ECHO
        SELECT CASE LOWRD(lParam)

        CASE %FD_READ
            IF hEcho <> %INVALID_SOCKET THEN
                TCP RECV hEcho, 1024, buffer
                TCP SEND hEcho, buffer
                LogEvent $DQ + Buffer + $DQ
            ELSE
                LogEvent "* FD_READ Error!"
            END IF

        CASE %FD_CLOSE
            TCP CLOSE hEcho
            hEcho = %INVALID_SOCKET

        END SELECT
        FUNCTION = 1

    CASE %WM_DESTROY
        TCP CLOSE hServer

    END SELECT

    FUNCTION = DefWindowProc(hWnd, wMsg, wParam, lParam)

END FUNCTION



FUNCTION MakeWindow () AS LONG

    LOCAL wce         AS WndClassEx
    LOCAL szClassName AS ASCIIZ * 64
    LOCAL hWnd        AS LONG
    LOCAL hInst       AS LONG

    STATIC registered AS LONG

    hInst = GetModuleHandle(BYVAL %NULL)

    IF ISFALSE registered THEN
        szClassName          = "PBTCPCOMM"
        wce.cbSize           = SIZEOF(wce)
        wce.style            = %CS_HREDRAW OR %CS_VREDRAW
        wce.lpfnWndProc      = CODEPTR(TcpProc)
        wce.cbClsExtra       = 0
        wce.cbWndExtra       = 0
        wce.hInstance        = hInst
        wce.hIcon            = %NULL
        wce.hCursor          = %NULL
        wce.hbrBackground    = %NULL
        wce.lpszMenuName     = %NULL
        wce.lpszClassName    = VARPTR(szClassName)
        wce.hIconSm          = %NULL
        RegisterClassEx wce
        registered = %TRUE
    END IF

    hWnd = CreateWindow(szClassName, _
                        "TCP Handler", _
                        %WS_OVERLAPPEDWINDOW, _
                        5, 5, 10, 10, _
                        %NULL, _
                        %NULL, _
                        hInst, _
                        BYVAL %NULL)

    IF ISFALSE hWnd THEN
        hWnd = GetLastError
    ELSE
        ShowWindow hWnd, %SW_HIDE
        UpdateWindow hWnd
    END IF

    FUNCTION = hWnd

END FUNCTION



FUNCTION WindowThread (BYVAL nIgnored AS LONG) AS LONG

    LOCAL Msg AS tagMsg

    hwndTCP = MakeWindow

    DO WHILE IsWindow(hwndTCP) AND GetMessage(Msg, %NULL, 0, 0)
        TranslateMessage Msg
        DispatchMessage Msg
    LOOP

END FUNCTION



FUNCTION PBMAIN () AS LONG

    ' Process socket messages in a separate thread

    THREAD CREATE WindowThread(%NULL) TO hThread

    ' If the user presses the Esc key, exit the server
    PRINT "Press ESC to end the ECHO Server"
    DO UNTIL WAITKEY$ = $ESC
    LOOP

    SendMessage hwndTCP, %WM_CLOSE, 0, 0

END FUNCTION
