'==============================================================================
'
'  Parsing example for the PowerBASIC Console Compiler
'
'  Copyright (c) 1998-2001 PowerBASIC, Inc.
'  All Rights Reserved.
'
'  Demonstrates the PARSECOUNT and PARSE$ functions.
'
'==============================================================================



FUNCTION PBMAIN () AS LONG

    LOCAL ix    AS LONG
    LOCAL sList AS STRING

    PRINT "Demonstration of the PARSECOUNT and PARSE$ functions"
    PRINT

    PRINT "Enter a list of comma delimited numbers (e.g., 3,4,5,99)"
    LINE INPUT sList

    PRINT
    PRINT "You entered a total of";PARSECOUNT(sList);"numbers."

    FOR ix = 1 TO PARSECOUNT(sList)
        PRINT $DQ; PARSE$(sList, ix); $DQ
    NEXT ix

    PRINT
    PRINT "Press any key to continue..."

    WAITKEY$

    PRINT
    PRINT "Demonstration of the PARSECOUNT and PARSE$ functions"
    PRINT

    PRINT "Enter a set of delimited numbers using a comma or semicolon (ie: 3,4;5;42,99)"
    LINE INPUT sList

    PRINT
    PRINT "You entered a total of"; PARSECOUNT(sList, ANY ",;");"numbers."

    FOR ix = 1 TO PARSECOUNT(sList, ANY ",;")
        PRINT $DQ; PARSE$(sList, ANY ",;", ix); $DQ
    NEXT ix

    PRINT
    PRINT "Press any key to continue..."

    WAITKEY$

END FUNCTION
