'==============================================================================
'
' CGI code for the PowerBASIC Console Compiler
'
' Copyright (c) 1998-2001 PowerBASIC, Inc.
' All Rights Reserved.
'
' We have provided wrappers for many common CGI environment variables here.
' Which variables are actually available depends on your specific web server.
'
'==============================================================================



#IF NOT %DEF(%PBCGI_INC)

%PBCGI_INC = 1

#IF NOT %DEF(%WINAPI)
    #INCLUDE "Win32API.inc"
#ENDIF



' Auth_Type returns the authentication method used to validate a user. See
' Remote_Ident and Remote_User. Only applicable if the server supports user
' authentication and the script is protected.
'
FUNCTION Auth_Type () AS STRING

    FUNCTION = ENVIRON$("AUTH_TYPE")

END FUNCTION



' Content_Length returns the number of bytes or characters waiting as input.
' Used with queries such as POST and PUT.
'
FUNCTION Content_Length () AS LONG

    FUNCTION = VAL(ENVIRON$("CONTENT_LENGTH"))

END FUNCTION



' Content_Type returns the type of the query data, e.g., "text/html".
'
FUNCTION Content_Type () AS STRING

    FUNCTION = ENVIRON$("CONTENT_TYPE")

END FUNCTION



' Date_GMT returns the current time/date in UTC.
'
FUNCTION Date_GMT () AS STRING

    FUNCTION = ENVIRON$("DATE_GMT")

END FUNCTION



' Date_Local returns the current time/date in local time.
'
FUNCTION Date_Local () AS STRING

    FUNCTION = ENVIRON$("DATE_LOCAL")

END FUNCTION



' Gateway_Interface returns the CGI version supported by the server, e.g.,
' "CGI/1.1".
'
FUNCTION Gateway_Interface () AS STRING

    FUNCTION = ENVIRON$("GATEWAY_INTERFACE")

END FUNCTION



' Http_Accept returns a list of the MIME types accepted by the client. Values
' may contain wildcards and/or a list of types separated by commas, e.g.,
' "*/*".
'
FUNCTION Http_Accept () AS STRING

    FUNCTION = ENVIRON$("HTTP_ACCEPT")

END FUNCTION



' Http_Accept_Encoding returns a list of the encoding methods supported by the
' client, e.g., "gzip, deflate".
'
FUNCTION Http_Accept_Encoding () AS STRING

    FUNCTION = ENVIRON$("HTTP_ACCEPT_ENCODING")

END FUNCTION



' Http_Accept_Language returns a list of the (human) languages supported by
' the client, using ISO codes, e.g., "en-us".
'
FUNCTION Http_Accept_Language () AS STRING

    FUNCTION = ENVIRON$("HTTP_ACCEPT_LANGUAGE")

END FUNCTION



' Http_Connection returns the type of connection established, e.g.,
' "Keep-Alive".
'
FUNCTION Http_Connection () AS STRING

    FUNCTION = ENVIRON$("HTTP_CONNECTION")

END FUNCTION



' Http_Cookie returns the cookie string detected by the server.
'
FUNCTION Http_Cookie () AS STRING

    FUNCTION = ENVIRON$("HTTP_COOKIE")

END FUNCTION



' Http_From returns the user's email address. Rarely available.
'
FUNCTION Http_From () AS STRING

    FUNCTION = ENVIRON$("HTTP_FROM")

END FUNCTION



' Http_Host appears to return the web address of the server.
'
FUNCTION Http_Host () AS STRING

    FUNCTION = ENVIRON$("HTTP_HOST")

END FUNCTION



' Http_Referer returns the URL of the last document the client read before
' accessing the CGI program.
'
FUNCTION Http_Referer () AS STRING

    FUNCTION = ENVIRON$("HTTP_REFERER")

END FUNCTION



' Http_User_Agent returns the name of the client's browser software.
'
FUNCTION Http_User_Agent () AS STRING

    FUNCTION = ENVIRON$("HTTP_USER_AGENT")

END FUNCTION



' HttpS returns whether secure scripting is enabled, e.g., "off".
'
FUNCTION HttpS () AS STRING

    FUNCTION = ENVIRON$("HTTPS")

END FUNCTION



' Path_Info returns the extra path information passed to a CGI program. This
' is any trailing part of the URL after the script name.
'
FUNCTION Path_Info () AS STRING

    FUNCTION = ENVIRON$("PATH_INFO")

END FUNCTION



' Path_Translated returns the Path_Info as translated by the server into a full
' physical path.
'
FUNCTION Path_Translated () AS STRING

    FUNCTION = ENVIRON$("PATH_TRANSLATED")

END FUNCTION



' Query_String returns the query information passed to the CGI program. This is
' the part appended to the URL after the question mark.
'
FUNCTION Query_String () AS STRING

    FUNCTION = ENVIRON$("QUERY_STRING")

END FUNCTION



' Remote_Addr returns the client's IP address.
'
FUNCTION Remote_Addr () AS STRING

    FUNCTION = ENVIRON$("REMOTE_ADDR")

END FUNCTION



' Remote_Host returns the client's host name.
'
FUNCTION Remote_Host () AS STRING

    FUNCTION = ENVIRON$("REMOTE_HOST")

END FUNCTION



' Remote_Ident returns the identity of the user.
'
FUNCTION Remote_Ident () AS STRING

    FUNCTION = ENVIRON$("REMOTE_IDENT")

END FUNCTION



' Remote_User returns the authenticated name of the user, if available.
'
FUNCTION Remote_User () AS STRING

    FUNCTION = ENVIRON$("REMOTE_USER")

END FUNCTION



' Request_Method returns the method used to issue the information request,
' e.g., "GET".
'
FUNCTION Request_Method () AS STRING

    FUNCTION = ENVIRON$("REQUEST_METHOD")

END FUNCTION



' Script_Name returns the full filespec of the script being executed.
'
FUNCTION Script_Name () AS STRING

    FUNCTION = ENVIRON$("SCRIPT_NAME")

END FUNCTION



' Server_Name returns the name or IP address of the server.
'
FUNCTION Server_Name () AS STRING

    FUNCTION = ENVIRON$("SERVER_NAME")

END FUNCTION



' Server_Port returns the port number being used by the server, e.g., "80".
'
FUNCTION Server_Port () AS LONG

    FUNCTION = VAL(ENVIRON$("SERVER_PORT"))

END FUNCTION



' Server_Port_Secure returns whether the connection is secure.
'
FUNCTION Server_Port_Secure () AS LONG

    FUNCTION = (ENVIRON$("SERVER_PORT_SECURE") <> "0")

END FUNCTION



' Server_Protocol returns the name and version of the server protocol, e.g.,
' "HTTP/1.1".
'
FUNCTION Server_Protocol () AS STRING

    FUNCTION = ENVIRON$("SERVER_PROTOCOL")

END FUNCTION



' Server_Software returns the name and version of the server software, e.g.,
' "Microsoft-IIS/5.0".
'
FUNCTION Server_Software () AS STRING

    FUNCTION = ENVIRON$("SERVER_SOFTWARE")

END FUNCTION



' AppPath returns the path of the CGI program.
'
FUNCTION AppPath () AS STRING

    LOCAL sFileSpec AS ASCIIZ * %MAX_PATH

    GetModuleFileName 0, sFileSpec, SIZEOF(sFileSpec)

    FUNCTION = LEFT$(sFileSpec, INSTR(-1, sFileSpec, "\"))

END FUNCTION



' ReadCGI returns the input data for the CGI program.
'
FUNCTION ReadCGI () AS STRING

    LOCAL Temp AS STRING

    SELECT CASE Request_Method

    CASE "GET", "PUT", "HEAD"
        FUNCTION = ENVIRON$("QUERY_STRING")

    CASE "POST"
        STDIN LINE Temp
        FUNCTION = Temp

    CASE ELSE   'assume the command line
        FUNCTION = COMMAND$

    END SELECT

END FUNCTION



' WriteCGI writes an HTML string to the web server. It automatically takes care
' of the necessary header.
'
SUB WriteCGI (BYVAL st AS STRING)

    STATIC header AS LONG

    IF ISFALSE header THEN
        STDOUT "Content-type: text/html"
        STDOUT
        header = -1
    END IF

    REPLACE "''" WITH $DQ IN st

    STDOUT st

END SUB



' DecodeCGI decodes the special characters in a CGI string.
'
FUNCTION DecodeCGI (BYVAL t AS STRING) AS STRING

    DIM b_in  AS BYTE PTR
    DIM b_out AS BYTE PTR
    DIM h     AS STRING PTR * 2
    DIM a     AS ASCIIZ PTR

    IF LEN(t) THEN

        b_in  = STRPTR(t)
        b_out = b_in

        DO
            IF @b_in = 43 THEN          'convert plus to space
                @b_out = 32

            ELSEIF @b_in = 37 THEN      'process special chars
                h = b_in + 1
                @b_out = VAL("&H" + @h)
                b_in = b_in + 2

            ELSE
                @b_out = @b_in

            END IF

            INCR b_in
            INCR b_out
        LOOP UNTIL @b_in = 0

        @b_out = 0

        a = STRPTR(t)

        FUNCTION = @a

    END IF

END FUNCTION



' ParseParams parses the parameters passed to a CGI program. For best results,
' do not decode the params string first. The function returns the number of
' parameters parsed into the Param() array.
'
FUNCTION ParseParams (BYVAL params AS STRING, Param() AS STRING) AS LONG

    LOCAL ncParamCount AS LONG
    LOCAL ix AS LONG

    ncParamCount = PARSECOUNT(params, "&")

    REDIM Param(ncParamCount) AS STRING

    FOR ix = 1 TO ncParamCount
        Param(ix) = PARSE$(params, "&", ix)
    NEXT ix

    FUNCTION = ncParamCount

END FUNCTION



' CgiParam parses raw CGI data to return the parameter you specify.
'
FUNCTION CgiParam (BYVAL param AS STRING, BYVAL which AS STRING) AS STRING

    LOCAL ix AS LONG
    LOCAL p AS STRING

    which = which + "="

    FOR ix = 1 TO PARSECOUNT(param, "&")
        p = PARSE$(param, "&", ix)
        IF LEFT$(UCASE$(p), LEN(which)) = UCASE$(which) THEN
            FUNCTION = DecodeCGI(MID$(p, LEN(which) + 1))
            EXIT FOR
        END IF
    NEXT

END FUNCTION



#ENDIF  ' #IF NOT %DEF(%PBCGI_INC)
