'==============================================================================
'
'  CGI Example for PowerBASIC Console Compiler
'
'  Copyright (c) 1998-2001 PowerBASIC, Inc.
'  All Rights Reserved.
'
'  Uses the Windows API to retrieve the current local date and time and
'  display them using the preferred formats specified by the user and
'  country settings. Requires Win95 or later, or NT 3.5 or later.
'
'  Prints an HTTP header for HTML so that it can be used on a web server.
'
'==============================================================================



#DIM ALL

#INCLUDE "PBCGI.inc"
#INCLUDE "Win32API.inc"



FUNCTION PBMAIN () AS LONG

    LOCAL stTime       AS SYSTEMTIME
    LOCAL szLongDate   AS ASCIIZ * 64
    LOCAL szTime       AS ASCIIZ * 64
    LOCAL szShortDate  AS ASCIIZ * 64
    LOCAL sParams      AS STRING
    LOCAL ncParamCount AS LONG
    LOCAL ix           AS LONG

    DIM Param(1) AS STRING

    ' Get date and time
    GetLocalTime stTime

    GetDateFormat %LOCALE_USER_DEFAULT, %DATE_LONGDATE, stTime, BYVAL %NULL, szLongDate, 64
    GetDateFormat %LOCALE_USER_DEFAULT, %DATE_SHORTDATE, stTime, BYVAL %NULL, szShortDate, 64
    GetTimeFormat %LOCALE_USER_DEFAULT, %TIME_NOSECONDS, stTime, BYVAL %NULL, szTime, 64

    ' Read from STDIN
    sParams = ReadCGI

    ' Count and parse the parameters into an array
    ncParamCount = ParseParams(sParams, Param())

    ' Create a web page
    WriteCGI "<HTML>"

    WriteCGI "<p>At the tone the time will be <B>" + szTime + ", " _
           + szLongDate + " (" + szShortDate + ")</B></p>"

    WriteCGI "<p>REQUEST_METHOD = " + Request_Method + "</p>"
    WriteCGI "<p>CONTENT_LENGTH = " + FORMAT$(Content_Length) + "</p>"
    WriteCGI "<p>Form Data = " + $DQ + sParams + $DQ + "</p>"

    IF ncParamCount THEN
        FOR ix = 1 TO ncParamCount
            WriteCGI "<LI>" + DecodeCGI(Param(ix))
        NEXT ix
    END IF

    WriteCGI "</HTML>"

END FUNCTION
