'==============================================================================
'
'  MAILER demonstration of CGI programming with the PowerBASIC Console Compiler
'
'  Copyright (c) 1999-2001 PowerBASIC, Inc.
'  All Rights Reserved.
'
'  Allows a website to send an email message containing all FORM values to
'  a specified address.
'
'==============================================================================



#COMPILE EXE

#INCLUDE "PBCGI.INC"



' SMTP mail server
$mailhost = "smtp.yourserver.com"

' Default MAILTO address if none is specified in the form
$mailto   = "default@yourserver.com"

' From address for SMTP server
$mailfrom = "mailer@yourserver.com"



FUNCTION PBMAIN () AS LONG

    LOCAL nTCP      AS LONG
    LOCAL params    AS LONG
    LOCAL x         AS LONG

    LOCAL buffer    AS STRING
    LOCAL localhost AS STRING

    LOCAL mailto    AS STRING
    LOCAL mailfrom  AS STRING
    LOCAL mailhost  AS STRING
    LOCAL subject   AS STRING
    LOCAL redirect  AS STRING

    DIM param(1 TO 1) AS STRING

    ' Read CGI parameters from form
    buffer   = ReadCGI

    ' Parse all parameters into an array
    params = ParseParams(buffer, param())

    ' Read values to build email message
    mailto   = cgiParam(buffer, "mailto")
    mailfrom = cgiParam(buffer, "mailfrom")
    mailhost = cgiParam(buffer, "mailhost")
    subject  = cgiParam(buffer, "subject")
    redirect = cgiParam(buffer, "redirect")

    ' Use defaults if anything is missing from the form
    IF LEN(mailto) = 0 THEN
        mailto = $mailto
    END IF

    IF LEN(mailfrom) = 0 THEN
        mailfrom = $mailfrom
    END IF

    IF LEN(mailhost) = 0 THEN
        mailhost = $mailhost
    END IF

    IF LEN(redirect) = 0 THEN
        redirect = Http_Referer
    END IF

    IF LEN(subject) = 0 THEN
        subject = "mailer from " + redirect
    END IF

    ' Connect to mail server
    nTCP = FREEFILE
    TCP OPEN "smtp" AT mailhost AS nTCP
    IF ERR THEN
        Buffer = "Error connecting to mailhost"
        GOTO SendError
    ELSE
        TCP LINE nTCP, Buffer
        IF LEFT$(Buffer, 3) <> "220" THEN
            GOTO SendError
        END IF
    END IF

    ' Get the local host name
    HOST NAME TO localhost

    ' Greet the mailhost
    TCP PRINT nTCP, "HELO " + localhost
    TCP LINE nTCP, Buffer
    IF LEFT$(Buffer, 3) <> "250" THEN
        Buffer = "HELO error: " + Buffer
        GOTO SendError
    END IF

    ' Tell the mailhost who we are
    TCP PRINT nTCP, "MAIL FROM: <" + $mailfrom + ">"
    TCP LINE nTCP, Buffer
    IF LEFT$(Buffer, 3) <> "250" THEN
        Buffer = "MAIL FROM error: " + Buffer
        GOTO SendError
    END IF

    ' Tell the mailhost who the message is for
    TCP PRINT nTCP, "RCPT TO: <" + mailto + ">"
    TCP LINE nTCP, Buffer
    IF LEFT$(Buffer, 3) <> "250" THEN
        Buffer = "RCPT TO error: " + Buffer
        GOTO SendError
    END IF

    ' Send the message
    TCP PRINT nTCP, "DATA"
    TCP LINE nTCP, Buffer
    IF LEFT$(Buffer, 3) <> "354" THEN
        Buffer = "DATA error: " + Buffer
        GOTO SendError
    END IF

    TCP PRINT nTCP, "From: " + mailfrom
    TCP PRINT nTCP, "To: " + mailto
    TCP PRINT nTCP, "Subject: " + subject
    TCP PRINT nTCP, "X-Mailer: PowerBASIC mailer.exe (www.powerbasic.com)"
    TCP PRINT nTCP, ""

    FOR x = 1 TO params
        buffer = DecodeCGI(Param(x))
        IF ASC(buffer) = 46 THEN
            buffer = "." + buffer
        END IF
        TCP PRINT nTCP, buffer
    NEXT

    ' Add information about the user to the message
    TCP PRINT nTCP, ""
    TCP PRINT nTCP, "Referer: " + Http_Referer
    TCP PRINT nTCP, "Remote_Addr: " + Remote_Addr
    TCP PRINT nTCP, "Http_User_Agent: " + Http_User_Agent

    ' We're done sending the message
    TCP PRINT nTCP, "."
    TCP LINE nTCP, Buffer
    IF LEFT$(Buffer, 3) <> "250" THEN
        GOTO SendError
    END IF

    ' Say goodbye
    TCP PRINT nTCP, "QUIT"
    TCP LINE nTCP, Buffer
    IF LEFT$(Buffer, 3) <> "221" THEN
        Buffer = "QUIT error: " + Buffer
        GOTO SendError
    END IF

    TCP CLOSE nTCP

    ' Redirect the user's browser to the new page
    STDOUT "Location: " + redirect + $CRLF

    FUNCTION = -1

    EXIT FUNCTION

SendError:

    WriteCGI buffer
    TCP CLOSE nTCP

END FUNCTION
