'==============================================================================
'
'  HTML encapsulation for the PowerBASIC Console Compiler
'
'  Copyright (c) 1998-2001 PowerBASIC, Inc.
'  All Rights Reserved.
'
'==============================================================================



#DIM ALL



'------------------------------------------------------------------------------
' Surround the specified text with BOLD tags for HTML
'
FUNCTION htmlBold (BYVAL text AS STRING) AS STRING

    FUNCTION = "<B>" + text + "</B>"

END FUNCTION



'------------------------------------------------------------------------------
' Surround the specified text with ITALICS tags for HTML
'
FUNCTION htmlItalic (BYVAL text AS STRING) AS STRING

    FUNCTION = "<I>" + text + "</I>"

END FUNCTION



'------------------------------------------------------------------------------
' Create an HREF tag for the specified text with the specified URL
'
FUNCTION htmlHref (BYVAL text AS STRING, BYVAL url AS STRING) AS STRING

    FUNCTION = "<A HREF=" + $DQ + url + $DQ + ">" + text + "</A>"

END FUNCTION



'------------------------------------------------------------------------------
' Create a title for the page.  Must be in the Header.
'
FUNCTION htmlTitle (BYVAL title AS STRING) AS STRING

    FUNCTION = "<TITLE>" + title + "</TITLE>" + $CRLF

END FUNCTION



'------------------------------------------------------------------------------
' Start of HEAD section
'
FUNCTION htmlBeginHead () AS STRING

    FUNCTION = "<HEAD>" + $CRLF

END FUNCTION



'------------------------------------------------------------------------------
' End of HEAD section
'
FUNCTION htmlEndHead () AS STRING

    FUNCTION = "</HEAD>" + $CRLF

END FUNCTION



'------------------------------------------------------------------------------
' Begin of BODY section
'
FUNCTION htmlBeginBody () AS STRING

    FUNCTION = "<BODY>" + $CRLF

END FUNCTION



'------------------------------------------------------------------------------
' End of BODY section
'
FUNCTION htmlEndBody () AS STRING

    FUNCTION = "</BODY>" + $CRLF

END FUNCTION



'------------------------------------------------------------------------------
' Start of a paragraph
'
FUNCTION htmlBeginPara () AS STRING

    FUNCTION = "<P>"

END FUNCTION



'------------------------------------------------------------------------------
' End of a paragraph (not required, but recommended)
'
FUNCTION htmlEndPara () AS STRING

    FUNCTION = "</P>"

END FUNCTION



'------------------------------------------------------------------------------
' Create a text header label <Hn>
'
FUNCTION htmlTxtHdr (BYVAL txt AS STRING, BYVAL level AS LONG) AS STRING

    FUNCTION = "<H" + FORMAT$(level) + ">" + txt + "</H" + FORMAT$(level) + ">"

END FUNCTION



'------------------------------------------------------------------------------
' Create a text header label with alignment support
'
FUNCTION htmlTxtHdrAlign (BYVAL txt AS STRING, BYVAL level AS LONG, _
    BYVAL align AS STRING) AS STRING

    FUNCTION = "<H" + FORMAT$(level) + " ALIGN=" + align + ">" + txt + "</H" _
     + FORMAT$(level) + ">"

END FUNCTION



'------------------------------------------------------------------------------
' Quick and easy IMG tag
'
FUNCTION htmlImg (BYVAL file AS STRING) AS STRING

    FUNCTION = "<IMG SRC=" + $DQ + file + $DQ + ">"

END FUNCTION



'------------------------------------------------------------------------------
' Full IMG tag
'
FUNCTION htmlImgTag (BYVAL file AS STRING, BYVAL xWidth AS LONG, _
  BYVAL yHeight AS LONG, BYVAL border AS LONG, BYVAL align AS STRING) AS STRING

    LOCAL temp AS STRING

    temp = "<IMG SRC=" + $DQ + file + $DQ _
         + " HEIGHT=" + FORMAT$(yHeight) + " WIDTH=" + FORMAT$(xWidth) _
         + " BORDER=" + FORMAT$(border)

    IF LEN(align) THEN
        temp = temp + " ALIGN=" + align
    END IF

    FUNCTION = temp + ">"

END FUNCTION



'------------------------------------------------------------------------------
' Encode special characters in a text string with HTML codes so the text can
' be properly displayed
'
FUNCTION htmlEncode (BYVAL txt AS STRING) AS STRING

    LOCAL Result AS STRING
    LOCAL c      AS STRING
    LOCAL x      AS LONG

    FOR x = 1 TO LEN(txt)

        c = MID$(txt, x, 1)

        SELECT CASE c

        CASE $CR
            c = "<BR>"
            IF ASC(txt, x + 1) = 10 THEN
                INCR x
            END IF

        CASE $LF
            c = "<BR>"
            IF ASC(txt, x + 1) = 13 THEN
                INCR x
            END IF

        CASE " "
            IF ASC(txt, x - 1) = 32 THEN
                c = "&nbs;"
            END IF

        CASE "<"
            c = "&lt;"

        CASE ">"
            c = "&gt;"

        CASE "&"
            c = "&amp;"

        CASE "|"
            c = "&brvbar;"

        CASE $DQ
            c = "&quot;"

        END SELECT

        Result = Result + c
    NEXT

    FUNCTION = Result

END FUNCTION
