'==============================================================================
'
'  EZ Count CGI Application for PowerBASIC Console Compiler
'
'  Copyright (c) 1998-2001 PowerBASIC, Inc.
'  All Rights Reserved.
'
'  Usage:
'
'  You are visitor number: <!--#exec cgi="/cgi-bin/ezcount.exe?countername"-->
'
'  The count database is stored as EZCOUNT.INI. The program won't track any
'  new entries after EZCOUNT.INI exceeds 64K bytes.
'
'==============================================================================



#DIM ALL

#INCLUDE "PBCGI.INC"
#INCLUDE "Win32API.inc"



FUNCTION PBMAIN () AS LONG

    LOCAL IniFile   AS ASCIIZ * %MAX_PATH
    LOCAL count     AS ASCIIZ * 16
    LOCAL counterId AS ASCIIZ * 64
    LOCAL buffer    AS STRING
    LOCAL aptr      AS ASCIIZ PTR
    LOCAL e         AS LONG

    counterId = TRIM$(COMMAND$)

    count = "1"

    GetModuleFilename 0, IniFile, SIZEOF(IniFile)
    MID$(IniFile, LEN(IniFile) - 2, 3) = "ini"

    IF LEN(counterId) = 0 THEN
        STDOUT "<b>Error! No identifier specified</b>"
        EXIT FUNCTION
    END IF

    IF CounterId = "REPORT" THEN
        Buffer = STRING$(65536, 0)
        GetPrivateProfileSection "EZ Counter", BYVAL STRPTR(Buffer), LEN(Buffer), IniFile
        aptr = STRPTR(Buffer)
        WriteCGI "<HEAD>"
        WriteCGI "<TITLE>EZCOUNT v1.1 Counter Report for " & Server_Name & "</TITLE>"
        WriteCGI "</HEAD>"
        WriteCGI "<BODY>"
        WriteCGI "<H1 ALIGN=CENTER>Access Counter Report</H1>"
        WriteCGI "<P><CENTER><HR><B>"

        DO WHILE LEN(@aptr)
            counterId = @aptr
            counterId = EXTRACT$(counterId, "=") + " = " + MID$(counterId, INSTR(counterId, "=") + 1)
            WriteCGI counterid + "<BR>"
            aptr = aptr + LEN(@aptr) + 1
        LOOP

        WriteCGI "</B></P><HR><P>"
        WriteCGI "EZCOUNT 1.2 - EZ CGI Page Counter<BR>"
        WriteCGI "Copyright &copy; 1998-2001 <A HREF=''mailto:info@powerbasic.com''>PowerBASIC, Inc.</A>"
        WriteCGI "</P></CENTER>"
        WriteCGI "</BODY>"
        EXIT FUNCTION
    END IF

    GetPrivateProfileString "EZ Counter", counterId, "0", count, SIZEOF(count), IniFile

    count = FORMAT$(VAL(count) + 1)

    WritePrivateProfileString "EZ Counter", counterId, count, IniFile

    STDOUT FORMAT$(VAL(count),"#,##0");

END FUNCTION
