% ----------------------------  Functions -------------------------------- %

"menu"
(	getoption
	dup
	(	length
		3 ge?
		( 2 get eval )
		( pop <Sorry--not implemented> message )
		ifelse
	)
	( pop )
	ifelse
) def

"dbox"
(	xchg
	getinfo
	2 rol
	dialog
	0 eq?
	(putinfo) (pop pop) ifelse
)
def

"getExtn"
(	file_form
	0 eq?
	( (docextn) getinfo 0 get xchg pop )
	( <.*> )
	ifelse
) def

"read-this-doc"
(	dup 1 get -2 rol dirswitch putinfo dirswitch clearundo file_form readdoc
	"readdir" (dbxdir) getinfo xchg pop 0 get set
) def

"readFile"
(	mark-off
	file_form
	( (dname NIL dtabstop) )
	( (dname NIL NIL ) )
	ifelse
	(NIL 0 0)
	<                                        >
	copy xchg pop 0 put
	file_form 
	(	( dtabstop ) getinfo 0 get xchg pop 2 put
		0 1 put
		AscDoc
	)
	(ReadDocument) 
	ifelse 
	dup 1 get getExtn 1 put pop
	dialog
	dup 0 eq?
	(	pop dup 0 get finddoc 
		( <File already loaded!> message pop pop)
		(	docmodified?
			(	(	("No"		"Abandon document?" ())
					("Yes"	"Abandon document?" read-this-doc)
					("Write"	"Abandon document?" (0 0 writedoc pop read-this-doc))
				) menu
			)
			(read-this-doc)
			ifelse
		)
		ifelse
	)
	(	1 eq?
		(	wherecursor _intext eq?
			(	tmpdoc
				dup 1 get -2 rol 
				dirswitch putinfo dirswitch
				file_form readdoc
				blockHome mark blockEnd mark cut
				tmpdoc
				split split -1 blmove
				false paste updatebreak
			)
			(pop pop <Cannot merge inside a box or table> message beep)
			ifelse
		)
		(pop pop)
		ifelse
	)
	ifelse
) def

"readDoc"
( 	windowtype 0 ne? (endHF) if
 	"file_form" 0 set
	readFile
) def

"readAsc"
( 	windowtype 0 ne? (endHF) if
  	"file_form" 1 set
	readFile
) def

"new-this-doc"
( 	(dname)
	(NIL)
	<                                        >
	copy xchg pop 0 put
	(	(name		"New Document")
		(string	"Filename:")
		(button	(Ok Cancel))
	)
	dialog 0 eq?
	(	dup 0 get length xchg pop 0 eq? (pop getdefault) if
		putinfo
		newdoc
	)
	(pop pop)
	ifelse
) def

"do-newdoc"
( 	windowtype 0 ne? (endHF) if
	docmodified?
	(	(	("No"		"Abandon document?" ())
			("Yes"	"Abandon document?" (new-this-doc))
			("Write"	"Abandon document?" (0 0 writedoc pop new-this-doc))
		) menu
	)
	(new-this-doc)
	ifelse
) def

"writeFile"
(	( dname NIL ) getinfo 0 1 put
	file_form
	( ExpASC )
	( WriteDocument )
	ifelse
	dialog
	0 eq?
	(	dup 0 get checkname dup
		1 eq?
		( pop pop pop <File name was already used in another window!> message )
		( 	dup
			2 eq?
			( pop overwrite )
			if
			0 eq?
			( 	marked?
				( 	mark duplicate
					tmpdoc 
					false paste updatebreak
					dup 1 get -2 rol putinfo file_form writedoc pop
					tmpdoc
				)
				( dup 1 get -2 rol putinfo file_form writedoc ( clearundo ) if )
				ifelse
			)
			( pop pop )
			ifelse
		)
		ifelse
	) 
	(pop pop) 
	ifelse
) def

"writeDoc"
( 	windowtype 0 ne? (endHF) if
	"file_form" 0 set
	writeFile
) def

"writeAsc"
( 	windowtype 0 ne? (endHF) if
	"file_form" 1 set
	writeFile
) def

"changeName"
(	windowtype 0 ne? (endHF) if
	(dname) getinfo
	(	( name	"Change Filename")
		( string	"File name:")
		( button	(Ok Cancel))
	) 
	dialog
	0 eq?
	(	dup 0 get checkname dup
		0 eq?
		( pop putinfo )
		(	1 eq?
			( <File name was already used in another window!> message beep pop pop )
			( 	overwrite 
				0 eq? 
				( putinfo ) 
				( pop pop )
				ifelse
			)
			ifelse
		)
		ifelse
	)
	( pop pop )
	ifelse
) def

"domath"
(	( 0 )
	( 	(name "Math Box")
		(table "Box type" NIL 7 5)
		(button (Insert Cancel) )
	)
	dup 1 get
	mathbox
	2 put pop
	dialog
	0 eq?
	( 0 get mathbox xchg get createbox )
	( pop )
	ifelse
) def		

"bufList"
(	mark-off
 	windowtype 0 ne? (endHF) if
	( NIL ) curdoc 1 sub 0 put
	(	(name "Documents")
		NIL
		(button (Edit Write "write All" Cancel))
	)
	( table "" NIL 5 1 )
	doclist 2 put 1 put
	dialog
	xchg 0 get 1 add xchg
	dup 0 eq?
	(	pop switchdoc )
	( 	dup 1 eq?
		( pop switchdoc Write menu )
		(	xchg pop 2 eq?
			(writeall pop)
			if
		)
		ifelse
	)
	ifelse
) def

"parLayout" 
( graphpar?
  ( beep )
  ( (pformat plmrg prmrg pindent pspace) Paragraph dbox )
  ifelse
) def

"footLayout"
(	(dseptor fspace dfnote) getinfo 
	(	( name	"Footnote Style" )
		( buffer "Separator:" 1 4 34 )
		( list	"spAcing:" ( Single "1.5" Double Triple )	)
		( list	"Position:" ( "page Bottom" "under Text" Endnotes ) )
		( button	( Ok Cancel )	)
	)
	dialog
	0 eq?
	( putinfo )
	( pop pop )
	ifelse
) def

"docLayout2" 
(	( dorient ) getinfo 0 get
	(	dtmrg dbmrg dlmrg drmrg dpwid dplen dtabstop dhthres dorient ) 
	Document 
	dbox
	xchg getinfo xchg pop 0 get 
	ne? 
	( evalStyle ) if
) def

"docLayout"
(	mark-off
 	windowtype 0 ne? (endHF) if
	docLayout2
) def

"boxLayout" 
(	"tmp-cur" wherecursor set
	tmp-cur _intext eq?
	(<Cursor must be in a box/table> message beep)
	(	tmp-cur _inbox eq?
		((boxColAlign boxTabChar boxBline boxLevelX))
		((boxColAlign boxTabChar boxTabPos colWidth))
		ifelse
		getinfo
		tmp-cur _inbox eq? (BoxLay) (TableLay) ifelse
		dialog 0 eq?
		(	;switch to the following order: (width tabchar align tabpos...)
			copy xchg
			0 get xchg
			dup 3 get 0 put
			dup 2 get 3 put
			xchg 2 put
			xchg
			copy xchg
			0 get xchg
			dup 3 get 0 put
			dup 2 get 3 put
			xchg 2 put
			xchg
			putinfo
		)
		(pop pop)
		ifelse
	)
	ifelse
) def

"do-matrix"
(	(Det Left{ Matrix\[\] Matrix\(\) Plain Right} Table Table\[\])
	(0 2 2)
	(	(name "Create Matrix")
		NIL
		(int "# of Rows:")
		(int "# of Columns:")
		(button (Insert Cancel))
	)
	(table "Table/Matrix" NIL 2 4)
	3 ndup 2 put 1 put
	dialog 0 eq?
	(	dup 1 get
		1 ndup 2 get
		2 rol 0 get
		3 rol xchg get
		dup dup "Table[]" equ? xchg "Table" equ? or
		(newtable)
		(newmatrix)
		ifelse
	)
	(pop pop)
	ifelse
) def

"Chiscript"
(	()
	(	(msg <Chiscript Programming Language Version 1.0>)
		(msg <Written as an internal language for Chiwriter 4>)
		(msg "")
		(msg <WARNING: If you don't  know what you are doing,>)
		(msg <         using Chiscript can  seriously  damage>)
		(msg <         the  documents  in  memory  or totally>)
		(msg <         crash the system !!!>)
		(button (Ok Cancel))
	)
	dialog xchg pop 0 eq? (executive) if
) def

% ---------------------------- Variables ---------------------------------- %

"tempname" 
<                                                                              >
def

% ------------------------------  Menus ---------------------------------- %

"mainoptions"
(	( "Mark"             "Start/End" mark )
	( "Edit"					Edit )
	( "Read"					Read )
	( "Write"				Write )
	( "Layout"				Layout )
	( "View"             View )
	( "Options"				Options )	
	( "New" 					New )
	( "Print"				Print )
	( "Spell" 				Spell )
	( "Quit"					"Quit ChiWriter" do-quit )
	( "Help" 				"Display quick reminder. (To get help on a command, highlight it and hit [Alt-H])" showhelp )
) set

"Edit"
(	( "Format"		Change )
	( "Dup"			<Duplicate marked text> do-dup )
	( "Cut"   		<Cut marked text into paste buffer> do-cut )
	( "Paste"		<Insert text from paste buffer> do-paste)
	( "Add" 			add_level/spot )
	( "Box/Table"	Box  )
	( "Search"		<Search for pattern> isearch)
;	( "Last" 		<Repeat last search> search)
	( "Replace"		<Search and replace> search&replace )
	( "Undo"			<Undo the last command> undo )
	( "rEdo"			<Undo the last undo command> redo )
) set

% -- highlighted reformatting -- %
"Change"
( 	( "Spacing"			<Change spacing for marked paragraphs> hi_space)
	( "Just"				<Change justification for marked paragraphs> hi_just)
	( "Left margin"	<Change left margin for marked paragraphs> hi_lmrg )
	( "Right margin"	<Change right margin for marked paragraphs> hi_rmrg )
	( "inDent"			<Indent or outdent marked paragraphs> hi_indent)
	( "Case"				menu-case-change )
	( "Font"				<Change font for marked area> menu-font-change )
	( "Hyphen"			<Hyphenation> hyphenate )
	( "Inhibit"			<Inhibit page breaks in marked area> ihibreak) 
) set

"menu-case-change"
(	( "to Upper"	"Change marked area to upper case" (1 0 0 do-change) )
	( "to Lower"	"Change marked area to lower case" (-1 0 0 do-change) )
) set

"menu-font-change"
(	marked?
	(	<Change from font: ([Return] changes all)> message
		readkey
		dup 'Return' eq?
		(pop 0 do-font)
		(	getkeyfont dup 0 gt?
			(do-font)
			(pop beep)
			ifelse
		)
		ifelse
	)
	(warn-mark)
	ifelse
) def

"hi_space"
(	(pspace)
	(	( name	"Paragraph Format")
		( list	"Spacing:" ( Single "1.5" Double Triple )	)
		( button	( Go Cancel )	)
	)
	dbox
) def

"hi_just"
(	(pformat)
	(	( name	"Paragraph Format")
		( list	"Justification:"	( Left Right Center Full Grid Table ) )
		( button	( Go Cancel )	)
	)
	dbox
) def

"hi_indent"
(	(pindent)
	(	( name	"Paragraph Format")
		( unit	"Indent:"	)
		( button	( Go Cancel )	)
	)
	dbox
) def

"hi_lmrg"
(	(plmrg)
	(	( name	"Paragraph Format")
		( unit	"Left margin:")
		( button	( Go Cancel )	)
	)
	dbox
) def

"hi_rmrg"
(	(prmrg)
	(	( name	"Paragraph Format")
		( unit	"Right margin:")
		( button	( Go Cancel )	)
	)
	dbox
) def

"Box"
(	( "Add"	  			BoxAdd )
	( "Zap"    			BoxZap )
	( "Move"				BoxMove )
	( "Split"			"Split column" splitcol )
	( "Grow/Shrink"	"Resize column" (0 growcol) )
) set

"BoxAdd"
(	( "row Up"			<Add row of cells above> 				(0 -1 addrow) )
	( "row Down"		<Add row of cells below> 				(0 1 addrow) )
	( "column Left"	<Add column of cells to the left>	(-1 do-addcol) )
	( "column Right"	<Add column of cells to the right>	(1 do-addcol) )
	( "rubber Band"	<Add rubber band>							add-rub )
) set

"BoxZap"
(	( "Row"				<Delete row of cells> 		delRow )
	( "Column"			<Delete column of cells>	deletecol )
	( "rubber Band"	ZapRub )
) set

"ZapRub"
(	("Horizontal"	"Delete which rubber band?"	(0 deleterb))
	("Vertical"		"Delete which rubber band?"	(1 deleterb))
	("Both"			"Delete which rubber band?"	(2 deleterb))
) set

"BoxMove"
(	("Row"		<Move box row> ("Use arrow keys to move" message 0 moverow) )
	("Column"	<Move box column> ("Use arrow keys to move" message 0 movecol) )
) set

"Read"
(	( "Document"		 <Read document> 		readDoc)
	( "Import ASCII"	 <Import ASCII file> 	readAsc)
) set

"Write"
(	( "Document" 			<Write Document>	 		writeDoc )
	( "Export ASCII"		<Export file as ASCII> 	writeAsc)
	( "Change name"		<Change filename>			changeName )
) set

"Layout"
(	( "Document"	<Set document format> docLayout  )
	( "Paragraph"	<Set paragraph format>	parLayout )
	( "Box/Table"	<Box/table layout> boxLayout )
	( "Header"		<Edit header>	((openHeader) openHF) )
	( "Footer"		<Edit footer>	((openFooter) openHF) )
   ( "footNote"   <Set footnote style> footLayout )
	( "Graphics"	<Include graphics file in printing> Graphics )
) set

"New"
(	( "Box"				<Create box> domath )
	( "Table/Matrix"	<Create table/matrix> do-matrix )
	( "footNote"		<Open footnote> openfootnote ) 
	( "Counter"			<Insert page or footnote counter>	insertCtr )
	( "Page break"		<Enter hard page break> hardbreak )
	( "Document" 		<Edit a new document> do-newdoc )
) set

; "Counter"
; (	( "Insert"		<Insert a counter> insertCtr )
; 	( "Style"		<Modify a counter style> )
; ) set

%---------------------------------	PRINT MENU ---------------------------%

"do-print"
(	windowtype 0 ne? (endHF) if
	marked?
	( 	mark duplicate
		tmpdoc 
		false paste updatebreak
		print-doc
		tmpdoc
	)
	( print-doc )
	ifelse
) def

"Numbering"
(	windowtype 0 ne? (endHF) if
	( dpgstart dfnstart padcount dpgfont dfnfont ) getinfo
	(	( name "Print Numbering" )
		( int 	"first Page number:" )
		( int 	"first Footnote number:" )
		( list	"Advance counters:" ( No Yes ) )
		( msg "" )
		( table 	"Page number font" NIL 2 5 ) 
		( table 	"Footnote number font" NIL 2 5 ) 
		( button ( Ok Cancel ) )
	)
	dup 5 get 0 fontlist dup -3 rol 2 put pop
	dup 6 get 2 rol 2 put pop
	dialog 
	0 eq?
	( putinfo )
	( pop pop )
	ifelse
) def

"Print"
(	( "Go"				<Print document> do-print)
	( "Options"			<Printing options> PrnOpt) 
	( "Settings"		<Change printer settings>	PrnSett)
	( "Numbering"		<Numbering of pages and footnotes> Numbering)
) set

"whatnot"
(	putinfo
	( ppitch pquality ) getinfo xchg pop
	equal? not
	( resetprn style (ppitch) getinfo 0 get xchg pop get eval )
	if
) def

"PrnOpt"
(	( ppitch pquality ) getinfo xchg pop
	(dpmrg ppitch pquality pcopy ptofile pfrpage ptopage psheets) getinfo
	(	( name		"Print Options" )
		( unit		"Margin offset:" )
		( list		"Style:"  NIL )
		( list		"Quality:" 	(Draft Letter) )
		( int			"No. of copies:" )
		( list		"print tO file:" (No Yes) )
		( int 		"From page:" )
		( int 		"To page:" )
		( list		"sHeets:" (All Odd Even Single) )
		( button		( Print "Keep settings" Cancel ) )
	)
	dup 2 get style 2 put 2 put
	dialog 
	dup 0 eq?
	(	pop 
		windowtype 0 ne? (endHF) if
		marked?
		( 	mark duplicate
			tmpdoc 
			false paste updatebreak
			whatnot
			print-doc
			tmpdoc
		)
		( 	whatnot
			print-doc 
		)
		ifelse
	)
	( 	1 eq?
		( 	whatnot 
			checkFormat
			( formatDBX pop )
			if
		) 
		( pop pop pop )
		ifelse
	)
	ifelse
) def

"PrnSett"
(	(pdriver) getinfo 0 get xchg pop
	(pdriver pport pdnstate) getinfo 
	(	( name	"Printer Settings" )
		 NIL 
		( table	"Port:" ( LPT1 LPT2 LPT3 COM1 COM2 COM3 PRN XON1 XON2 AUX ) 1 9)
		( list 	"Download:"	( Automatic Manual ) )
		( button	( Ok Cancel ) )
	)
	(file "*.prn" NIL) 
	getsysdir 2 put 1 put
	dialog
	0 eq?
	( 	putinfo 
	   ( pdriver ) getinfo 0 get xchg pop dup -2 rol
		ne? 
		(	% READS IN PRINTER DRIVER AND EVALUATE THE PITCH PROCEDURE %
			resetstr
			read  
			( evalStyle )
			( <Can't open printer driver.  Hit any key to continue.> message wait )
			ifelse
		)
		( pop )
		ifelse 
	)
	( pop pop pop )
	ifelse
) def

%--------------------------------------------------------------------------%

"View"
(	( "Documents"		<List all documents> bufList )
	( "Box bounds"		<View box boundary> 		showbounds )
	( "Font chart" 	<Toggle font chart> 		showchart)
	( "Close"			<Close current window> 	endHF )
	( "Next"				<Change to next document or header/footer/footnote> (1 jumpNP) )
	( "Previous"		<Change to previous document or header/footer/footnote> (0 jumpNP) )
	( "Split"			<Split window> (wask dup NIL ne? (splitWin) (pop) ifelse) )
) set

%--------------------------------------------------------------------------%

"Options"
(	("Key sequences"		KSlst)
	("Global"				<Global default settings> Globdef)
	("Fonts"					<Assignment of fonts> Fntlst)
	("Configuration"		Config )
	("Run DOS"				<Exit to DOS temporarily> rundos )
   ("About"             <Information about ChiWriter> version )
) set												  

"KSlst"
(	( "Read"				<Read key sequence file>  ReadKey )
	( "Write"			<Write key sequence file> WrtKey )
	( "Define"			<Define a key sequence> keydef )
	( "Key sequence replay"			<Play back a key sequence> keyplay )
	( "ChiScript"		<Run ChiScript> Chiscript )
) set

"ReadKey" 
(	( <                                        > ) 
	(	( name	"Read Key Sequence File" )
		NIL
		( button	( Read Cancel )) 
	)
	(file NIL NIL) (keyextn) getinfo xchg pop 0 get 1 put
	getsysdir 2 put 1 put
	dialog
	0 eq?
	( 0 get read not (<Cannot open file> message beep) if )
	( pop )
	ifelse
) def

"WrtKey" 
(	( <                                        > )
	(	( name	"Write Key Sequence File")
		( string	"File name")
		( button	( Go Cancel )	)
	)
	dialog
	0 eq?
	( 0 get writekeyseq )
	( pop )
	ifelse
) def

"Config"
(  ("Read"		"Read configuration file"  	readCon )
	("Write"		"Write configuration file" 	writeCon )
) set

"readCon"
( 	windowtype 0 ne? (endHF) if
	( <                                        > )
	(	( name	"Configuration File" )
		NIL
		( button	( Read Cancel )) 
	)
	( file "*.par" NIL ) 
	getsysdir 2 put 1 put
	dialog
	0 eq?
	( 0 get readparam )
	( pop )
	ifelse
) def

"writeCon"
( 	windowtype 0 ne? (endHF) if
	( <CONFIG.PAR                              > )
	(	( name	"Configuration file")
		( string	"File name:")
		( button	( Write Cancel )	)
	)
	dialog
	0 eq?
	( 0 get writeparam )
	( pop )
	ifelse
) def

"Globdef"
(	(docdir) getinfo 0 get
	( defunit stline mnline defmode docdir docextn backdir backfreq auxdic ksfile )
	(  (name 	"Global Settings" )
		(list   	"default Unit:" ( Inch Centimeter "Line/column" ) )
		(list		"Status line:" (Hide Display) )
		(list 	"Menu line:" (Hide Display) )
		(list 	"Insert mode:" (Insert Overtype) )
  	 	(string 	"document Directory:" )
		(string 	"document Extension:")
		(string  "Backup directory:" )
		(int		"backup Frequency in min.:" )
	 	(string 	"AUX dictionary:" )
	 	(string 	"Key sequence file:" ) 
	 	(button 	(Ok Cancel) )
	) dbox
	xchg getinfo xchg pop 0 get dup 2 rol
	ne? ("readdir" xchg set) (pop) ifelse
) def

"fontFile"
(	( <                                        > 1 ) 
	(	( name	"Font Assignment" )
		NIL
		( list "Category:" ( Symbol Alphabet ) )
		( msg "" )
		( button	( Read Cancel )) 
	)
	( file NIL NIL) 
	fontExt 1 put 
	getsysdir 2 put 1 put
	dialog
  	0 eq?
	( dup 0 get dup 2 rol 1 get assignfont display )
	if
) def

"Fntlst"
( 	( 0 )
	( 	(name "Font List")
		(table "Available fonts" NIL 5 4 )
		(button (Read Delete Cancel) )
	)
	dup 1 get
	2 fontlist
	2 put pop
	dialog
	dup 0 eq?
	( xchg 0 get 2 add dup whichFont fontFile mainoptions setmenuline	pop )
	( 	1 eq?
	  	( 0 get 2 add deletefont display )
		if
	)
	ifelse
) def

"Spell"
(	( "Spell check"  <Start spell check> SpCheck )
	( "Read AUX Dictionary" <Read in auxiliary dictionary> readAux )
) set

"Correct"
( moveto
  mark
  moveto
  spChoose
  dup	0 eq?
  ( pop mark inbox? not ( 1 cmove )	if )
  ( 1 eq?
    ( kill true paste inbox? ( -1 cmove ) if ) 
    ( mark closewindow spfootend 1 eq? (pop) if ) 
    ifelse
  ) ifelse
) def

"SpCheck" 
(  mark-off 
   "spfoot" 0 set
   "spfootend" 0 set
   ( spellCheck dup )
   ( dup
     1 eq?
     ( pop Correct )
     ( 2 eq? 
       ( footend? ( "spfootend" 1 set dup -3 rol ) if
         moveto footnote "spfoot" 1 set Correct 
       )
       ( closewindow spfootend 1 eq? ( "spfootend" 0 set moveto ) if )
       ifelse
     )
     ifelse
   )
   while
   mark-off
   pop
)  def

"readAux"
( ( <                                        > ) 
  ( ( name   "Read AUX Dictionary" )
    NIL
    ( button ( Read Cancel ) )
  )
  ( file   "*.AUX" NIL )
  getsysdir 2 put 1 put
  dialog
  0 eq? ( 0 get Aread ) if
  pop 
) def

"GraphicsDBox"
(  ( name             "Import Graphics")
   ( file             "*.*" )
   ( button  ( Read Cancel ) )
) set

"GraphicsFname" ( <                                        > ) set

"Graphics"
( windowtype 0 eq?
  ( emptypar? not
    graphpar?
    or
    ( beep )
    ( GraphicsFname GraphicsDBox dialog
      0 eq? ( (pformat) (4) putinfo 0 get setgraphpar ) if
      pop
    ) ifelse
  )
  ( beep ) 
  ifelse
) def

% --------------------------  Dialog Boxes ------------------------------ %

"Paragraph"
(	( name	"Paragraph Format")
	( list	"Format:"	(Left Right Center Full Grid Table) )
	( unit	"Left margin:")
	( unit	"Right margin:")
	( unit	"Indent:"	)
	( list	"Spacing:" ( Single "1.5" Double Triple )	)
	( button	( Ok Cancel )	)
) set

"Document"
(	( name		"Document Format")
	( unit		"Top margin:" 'v')
	( unit		"Bottom margin:" 'v')
	( unit		"Left margin:" )
	( unit		"Right margin:" )
	( unit		"paper Width:")
	( unit		"paper leNgth:" 'v')
 	( unit		"tab Stops:")
 	( unit		"Hyphen threshold:")
 	( list		"orIentation:"	( Portrait Landscape )	)
	( button		( Ok Cancel )	)
) set

"BoxLay"
(	( name	"Box Format" )
	( list	"Column format:"	(Left Right Center Grid Decimal) )
	( string	"Tab character:" )
	( list 	"Alignment:"	(Top Bottom Center Row) )
	( int 	"align at Row:" )
	( button	(Ok Cancel) )
) set

"TableLay"
(	( name	"Table Format" )
	( list	"Column format:"	(Left Right Center Grid Decimal) )
	( string	"Tab character:" )
	( int		"tab Position:" )
	( int		"column Width:" )
	( button	(Ok Cancel) )
) set

"ReadDocument"
( 	( ( name 	"Read Document" )
	  NIL
	  ( button 	( Read Merge Cancel ) )
	)
	( file NIL NIL )
	readdir
	2 put 1 put
) def

"AscDoc"
( 	( ( name 	"Read ASCII File" )
	  NIL
	  ( list		"Returns:" ( Hard Soft ) )
	  ( unit		"Tab stops:" )
	  ( button 	( Import Merge Cancel ) )
	)
	( file NIL NIL )
	readdir
	2 put 1 put
) def

"WriteDocument"
(	( name				"Write Document")
	( string				"File name:")
	( button	( Write Cancel )	)
) set

"ExpASC"
(	( name		"Export ASCII")
	( string		"Filename:")
	( list		"Returns:" ( Hard Soft ))
	( button	( Export Cancel )	)
) set

"add_level/spot"
(	("level Up"		<Add level up>							(1 addlevel))
	("level Down"	<Add level down>						(-1 addlevel))
	("spot Left"	<Add insert spot to the left>		(-1 ispot))
	("spot Right"	<Add insert spot to the right>	(1 ispot))
	("lIne draw"	<Line draw>								linedraw)
) set

"SpellDbox"
( ( name "Spell Checker" )
  ( check )
  ( button ( Ok "Write to AUX" Cancel ) )
) set

"SpellVal"
( <                                        > )
set

"SpellRbox"
( ( name "Spell Checker" )
  ( msg <                                       > )
  ( msg <                                       > )
  ( msg <                                       > )
  ( msg <                                       > )
  ( msg <                                       > )
  ( button ( Ok ) )
) set

"SpellRval" ( ) set

"mnLineDraw"
(	(0 0)
	(	(name <Line Draw>)
		(list "Style:"		(Normal dOtted Bold Double))
		(list "Arrows:"	(None Left/Up Right/Down Both))
		(button (Ok Cancel))
	)
	dialog 0 eq?
	(dup 0 get xchg 1 get 16 mul add linedraw)
	(pop)
	ifelse
) def

