%---------------------------------------------------------------------------%

;DIRECTORY for reading document and ascii file
"readdir" (docdir) getinfo xchg pop 0 get set

%---------------------------------------------------------------------------%

"verbox"
(	(msg <ChiWriter 4.0>)
	(msg <Copyright (C) 1990>)
   (msg <Horstmann Software>)
	(msg <All Rights Reserved>)
	(msg <Programmed by:>)
	(msg <   Nhi Lam>)
	(msg <   Hin Man>)
	(msg <   Raymond Shum>)
	(msg <   Bing Chan>)
	(button (OK))
) set

"version" (() verbox dialog pop pop) def

%---------------------------------------------------------------------------%

"menu2"
(	getoption
	dup (2 get eval) if
) def

%---------------------------------------------------------------------------%

"case"

; x (x1 y1 x2 y2 ... NIL y0) case
; if( x == xi || xi == NIL ) eval yi

(	"tmp" undef
	length 0
	(dup 2 ndup lt?)
	(	2 ndup 1 ndup get
		dup NIL eq?
		(pop "tmp" xchg set dup)
		(4 ndup eq? ("tmp" xchg set dup) if)
		ifelse
		2 add
	) while
	pop pop xchg pop
	"tmp" def?
	(tmp 1 add get eval)
	(pop)
	ifelse
) def

%---------------------------------------------------------------------------%

"response"

; used in sr_srchNrpl()

(	(	("Yes"		"Replace?" 1)
		("No"			"Replace?" 0)
		("Global"	"Replace?" 2)
		("Cancel"	"Replace?" NIL)
	) menu2
) def

%---------------------------------------------------------------------------%

"yes/no/write"

; used in dy_ok()

(	(	("Yes"	"Memory is low.  Delete undos to get memory?" 1)
		("No"		"Memory is low.  Delete undos to get memory?" 0)
		("Write"	"Memory is low.  Delete undos to get memory?" (0 0 writedoc pop 1))
	) menu2
) def

%---------------------------------------------------------------------------%

"wask"
(	(	("1"	"Which document?" 1)
		("2"	"Which document?" 2)
		("3"	"Which document?" 3)
		("4"	"Which document?" 4)
		("5"	"Which document?" 5)
		("6"	"Which document?" 6)
		("7"	"Which document?" 7)
		("8"	"Which document?" 8)
		("9"	"Which document?" 9)
		("10"	"Which document?" 10)
	) menu2
) def

%---------------------------------------------------------------------------%

"overwrite"
(	(  ( "Yes"	"File name already existed.  Overwrite?" 0 )
		( "No"	"File name already existed.  Overwrite?" 1 )
	) menu2
) def

%---------------------------------------------------------------------------%

"wait" (beep (readkbd not) () while) def

%---------------------------------------------------------------------------%

"fontkey"
(	(0 do-font) copy xchg pop		% make fresh copy %
	1 ndup 0 put
	2 ndup xchg assign
	setfontkey
) def

%---------------------------------------------------------------------------%

"notyet"	(<Not implemented yet> message) def

%---------------------------------------------------------------------------%

"true" 1 set
"false" 0 set

% for quick-search feature: the font and char for the next search %
"_qsearch" 0 set
"_font" 0 set
"_char" 0 set

% used to access the info of a cursor list %
"_para" 0 set
"_line" 1 set
"_offset" 2 set
"_column" 3 set

% insert modes %
"_insert" 0 set
"_type" 1 set
"_strike" 2 set

% cursor position %
"_intext" 0 set
"_inbox" 1 set
"_intab" 2 set

"rubnames"
(	(	(HNormalH	HNormalF		HNormalN)
		(HBoldH		HBoldF		HBoldN)
		(HDoubleH	HDoubleF		HDoubleN)
		(HDottedH	HDottedF		HDottedN)
	)
	(	(VNormalH	VNormalF		VNormalN)
		(VBoldH		VBoldF		VBoldN)
		(VDoubleH	VDoubleF		VDoubleN)
		(VDottedH	VDottedF		VDottedN)
	)
) set

"mathbox" boxlist qsort set

%---------------------------------------------------------------------------%

"equal?"
(	length 2 rol length dup
	3 rol eq?
	(	true
		(1 ndup 1 ndup and)
		(	pop 1 sub
			2 ndup 1 ndup get
			2 ndup 2 ndup get
			eq?
		) while
		-3 rol -2 rol pop pop
		0 eq? and
	)
	(pop pop pop NIL)
	ifelse
) def

%---------------------------------------------------------------------------%

"kill" (mark cut pop) def

%---------------------------------------------------------------------------%

"delLine"
(	column
	getcur _line get
	home cmoveto
	grid?
	(	(height depth) getinfo xchg pop
		dup 0 get 3 sub newoffset
		1 get
	) if
	mark end cmoveto
	grid? (neg newoffset) (0 newoffset) ifelse
	kill
	emptypar?
	( pop deletepar )
	( getcur _line get gt? ( 1 lmove ) if ) ifelse
	cmoveto
) def

"delRow" (wherecursor _inbox eq? (deleterow) (delLine) ifelse) def

"delWord"
(	marked? (beep) (mark wordend moveto kill) ifelse
) def

%---------------------------------------------------------------------------%

"cmoveto" (column sub cmove) def

"newlevel" (baseline add newoffset) def

"newoffset"
(	getcur _offset get
	xchg sub
	dup (rmove) (pop) ifelse
) def

%---------------------------------------------------------------------------%

"blockHome"
(	(0 0 0 0) moveto
	home cmoveto
) def

"blockEnd"
(	(npars) getinfo xchg pop 0 get 1 sub
	(0 0 0 0)	% tmp cursor %
	xchg _para put
	moveto
	getcur
	(nlines) getinfo xchg pop 0 get 1 sub
	_line put
	moveto
	end cmoveto
) def

%---------------------------------------------------------------------------%

"gotopage"
(	"_fudge" ( dpgstart ) getinfo 0 get 1 sub xchg pop set
	( NIL ) NIL 0 put
	(	(name "Goto Page")
		(int "   Page number:")
		(button(Go Cancel))
	)
	dialog
	windowtype or
	( pop )
	( 0 get 1 sub _fudge sub pagetop moveto )
	ifelse
) def

"do-hardbreak"
( 	hardbreak	
	marked?
	( 	display ) if
) def

%---------------------------------------------------------------------------%

"SRdbox1"
(	(name		"Search")
	(buffer	"Search pattern:" 1 8 30 )
	(list		"Case:"		(Ignore Match))
	(list		"Font:"		(Ignore Match))
	(button	(Go Abort))
) set

"SRopts1" (0 0 0) set

"getSRopts1"
(	SRopts1 0 get
	SRopts1 1 get
	SRopts1 2 get
	0
) def

"do-search"
(	getSRopts1 match
	dup
	(moveto <Search completed> message)
	(<Pattern not found> message pop)
	ifelse
) def

"isearch"
% initial search %
(	SRopts1 SRdbox1 dialog xchg pop 0 eq?
	(do-search) if
) def

"search" (1 cmove do-search) def

%---------------------------------------------------------------------------%

"SRdbox2"
(	(name		"Search and Replace")
	(buffer	"Search pattern:" 1 8 30 )
	(buffer	"Replacement text:" 1 8 30 )
	(list		"Case:"		(Ignore Match))
	(list		"Font:"		(Ignore Match))
	(button	(Go Abort))
) set

"SRopts2" (0 0 0 0) set

"search&replace"
(	marked? not
	(	SRopts2
		; kills the search & replace buffers
		; later we can make a copy of of the replace buffer
		; but we cannot use the old one because the redo would mess up
		0 0 put 0 1 put
		SRdbox2 dialog xchg pop 0 eq?
		(	SRopts2 0 get
			SRopts2 1 get
			SRopts2 2 get
			SRopts2 3 get
			replace
		) if
	) if
) def

%---------------------------------------------------------------------------%

"quickSearch"

; direction quickSearch --> p
; does a one-letter search
; if direction == 'b' then the search is backwards, otherwise it is forward
; if the user enters a font for the character, then it is font sensitive
; if found, p is the cursor position, otherwise p = NIL

(	<Enter char, [F..] char, [PgUp], [PgDn], [Home], [End], [Ctrl-N], [Alt-+/-]> message
	readkey dup
	(	'PgUp'	(pop pageHome)
		'PgDn'	(pop pageEnd)
		'Home'	(pop parHome)
		'End'		(pop parEnd)
		'Return'	(pop parEnd)
		'Ctrl-N'	(pop "_font" 0 set "_char" 2 set findChar)
		'Alt-='	(pop _qsearch)
		'Alt--'	(pop _qsearch)
		'Esc'		(pop)
		NIL		(	dup getkeyfont
						(	getkeyfont
							"_font" xchg set
							"_char" readkey set
						)
						("_char" xchg set "_font" 0 set)
						ifelse
						findChar
					)
	) case
) def

"pagemove"
(	curpage add pagetop moveto
) def 

"pageHome"
(	"_qsearch" "pageHome" getbind set
	0 gt? (1) (0) ifelse
	pagemove
) def

"pageEnd"
(	"_qsearch" "pageEnd" getbind set
	0 gt? (1) (0) ifelse
	pagemove
	-1 lmove
) def

"parmove"
(	getcur 0 _line put
	dup _para get 2 rol add
	dup 0 lt? (pop 0) if
	(npars) getinfo xchg pop 0 get
	dup 2 ndup le? (1 sub xchg) if
	pop
	_para put
	moveto
) def

"parHome"
(	"_qsearch" "parHome" getbind set
	0 gt? (1 parmove) (getcur 0 _line put moveto) ifelse
	home cmoveto
) def

"parEnd"
(	"_qsearch" "parEnd" getbind set
	0 lt? (-1 parmove) if
	getcur
	(nlines) getinfo xchg pop 0 get 1 sub
	_line put
	moveto
	end cmoveto
) def

"findChar"
(	"_qsearch" "findChar" getbind set
	_char 256 lt?
	(_font _char qsearch dup (moveto) (pop) ifelse)
	(beep)
	ifelse
) def

%---------------------------------------------------------------------------%

"del"
(	marked?
	( kill )
	( delete ) ifelse
) def

%---------------------------------------------------------------------------%

"HFlist"
(	( "Default" "" 0 )
	( "Even"		"" 10 )
	( "1st"		"" 1 )
	( "2nd"		"" 2 )
	( "3rd"		"" 3 )
	( "4th"		"" 4 )
	( "5th"		"" 5 )
	( "6th"		"" 6 )
	( "7th"		"" 7 )
	( "8th"		"" 8 )
	( "9th"		"" 9 )
) set

"openHF"
(	HFlist menu2
	dup NIL ne? 2 rol (pop) ifelse
) def

"openfootnote" 
( windowtype 0 eq?
  graphpar? not
  and
  ( mark-off footnote ) 
  ( beep ) ifelse
) def

"openFooter"
( windowtype 2 eq?
  windowtype 3 eq?
  or
  ( endHF ) if
  windowtype 0 eq?
  ( mark-off footer ) 
  ( pop beep ) ifelse
) def

"openHeader" 
( windowtype 2 eq?
  windowtype 3 eq?
  or
  ( endHF ) if
  windowtype 0 eq?
  ( mark-off header ) 
  ( pop beep ) ifelse
) def

"splitWin"
( mark-off splitwindow )
def

"endHF"
( 
  mark-off
  windowtype 0 ge?
  windowtype 3 le?
  and
  ( closewindow )
  ( <No window to close> message ) 
  ifelse
) def

"jumpNP"
( 
  mark-off
  windowtype 0 ge?
  windowtype 3 le?
  and
  ( windowtype dup
    dup 0 ne? (endHF) if
    2 rol 1 eq? ( nextwindow ) ( prevwindow ) ifelse
    xchg 
    dup 3 eq? 
    ( pop openHeader )
    ( dup 2 eq?
      ( pop openFooter )
      ( 1 eq?
        ( moveto openfootnote ) 
        ( switchdoc )
        ifelse
      )
      ifelse
    ) 
    ifelse
  )
  ( pop )
  ifelse
) def
      
"insertCtr"
( windowtype 2 eq?
  windowtype 3 eq?
  or
  ( 0 'h' _insert insert )
  ( windowtype 1 eq? ( 1 newlevel 0 'x' _insert insert ) if )
  ifelse
) def

%---------------------------------------------------------------------------%

"formatDBX"
(	()
	(	( name	"")
		( msg		"Changes are detected in print style or driver.")
		( msg		"Your document must be reformatted before proceeding.")
		( msg		"" )
		( button	(Ok Cancel))
	) 
	dialog
	xchg pop
	0 eq?
	( 	globalFormat clearundo
	   1
;		printdoc
	)
	( 0 )
	ifelse
;	pop
) def

"print-doc"
(	checkFormat
	( 	formatDBX
		( printdoc )
		if
	)
	( printdoc )
	ifelse
) def

%---------------------------------------------------------------------------%

"keydef"
(	keyrec?
	(NIL keyseq)
	(	"keyname" get-name-or-key set
		keyname
		(	true keyname def?
			(	pop
				(	(Yes	"Overwrite previous assignment?" (keyname undef true))
					(No	"Overwrite previous assignment?" NIL)
				) menu2
			) if
			(keyname keyseq <Use [Ctrl-D] to end the key sequence> message) if
		) if
	)

	ifelse
) def

"keyplay"
(	keyseqlist qsort dup
	(	(0)
		(	(name "Key Sequence Playback")
			NIL
			(button	(Play Cancel))
		)
		(table "Key Sequence Names" NIL 4 5) 3 ndup 2 put 1 put
		dialog
		0 eq?
		(	0 get get getbind dup keyseq?
			(sendkeys)
			(pop <Not a key sequence name> message beep)
			ifelse
		)
		(pop pop)
		ifelse
	)
	(pop <No key sequence to play back> message beep)
	ifelse
) def

"get-name-or-key"
(	(	(Key  "Attach to a key or to a name?" getkey)
		(Name "Attach to a key or to a name?" getname)
	) menu2
) def

"getkey"
(	<Enter the key which you want to define ([Esc] to cancel)> message
	readkey
	dup 'Esc' eq?
	(pop NIL) if
) def

"getname"
(	(NIL)
	<                > copy xchg pop 0 put
	(	(name		"Enter the key sequence name")
		(string	"")
		(button	(Go Cancel))
	)
	dialog 0 eq?
	(0 get)
	(pop NIL)
	ifelse
) def

%---------------------------------------------------------------------------%

"set-lm"
(	(plmrg pindent)(NIL NIL) copy xchg pop
	collft 0 put <0> 1 put
	putinfo
) def

"set-rm"
(	(prmrg)(NIL) copy xchg pop
	colrgt 0 put
	putinfo
) def

"set-indent"
( 	(pindent)(NIL) copy xchg pop
	colindent 0 put 
	putinfo
) def

"lm&Ind"
(	( plmrg pindent ) getinfo xchg pop
	dup 0 get xchg 1 get addunit defHcode toUnit
) def

"set-outdent"
( 	( plmrg pindent ) (NIL NIL) copy xchg pop
	lm&Ind collft subunit 1 put collft 0 put
	putinfo
) def	

%---------------------------------------------------------------------------%

"createtab"
(	(pformat nlines) getinfo xchg pop
	dup 0 get dup 4 eq? xchg 5 eq? or
	xchg 1 get 1 gt? or
	(<Cannot create table paragraph here> message)
	(	column
		emptypar?
		(maketable)
		(	home cmoveto set-lm mark end cmoveto mark cut
			maketable true paste
		)
		ifelse
		cmoveto
	)
	ifelse
) def

"split-tab"
(	wherecursor _intext eq?
	((prmrg) getinfo createtab putinfo) if
	splitcol
) def

"PI-tab"
% createtab for putinfo -- called from gp_pformat
  redefines set-lm so that it doesn't interfere with the
  left margin in putinfo
%
(	"set-lm" getbind
	"set-lm" () def
	createtab
	"set-lm" xchg set
) def

"PI-create" (column maketable cmoveto) def

%---------------------------------------------------------------------------%

"do-paste"
(	marked? (kill) if
	restoreitem true paste
) def

"do-cut"
(	marked?
	(	mark cut saveitem
		<Block cut to paste buffer> message
	)
	(warn-mark)
	ifelse
) def

"do-dup"
(  marked?
	(  mark duplicate saveitem
		<Block copied to paste buffer> message
	)
	(warn-mark)
	ifelse
) def

%---------------------------------------------------------------------------%

"get-tab"
(	(dlmrg dtabstop) getinfo xchg pop
	dup 1 get toCol "tab-col" xchg set
	0 get toCol tab-col mod column xchg sub
	dup 0 lt? (tab-col add) if
	tab-col mod
) def

"tabbing"
(	atindent?
	(get-tab tab-move set-indent)
	(	wherecursor _intext eq?
		(get-tab tab-move)
		(0 tab-x cellmove)
		ifelse
	) ifelse
) def

"do-tab"
(	"tab-x" 1 set
	"tab-move" (tab-col xchg sub cmove) def
	tabbing
) def

"do-shift-tab"
(	"tab-x" -1 set
	"tab-move" (dup 0 eq? (pop tab-col) if neg cmove) def
	tabbing
) def

%---------------------------------------------------------------------------%

"mark-off" (marked? (mark) if) def

%---------------------------------------------------------------------------%

"warn-mark" ("Nothing marked!" message beep) def

%---------------------------------------------------------------------------%

"do-change" (marked? (change mark) (warn-mark) ifelse) def

%---------------------------------------------------------------------------%

"do-font"
(	marked?
	(	<Change to font:> message
		readkey getkeyfont
		dup 0 gt?
		(	dup 2 ndup eq? (xchg pop 0 xchg) if
			0 -2 rol do-change
		)
		(pop pop beep)
		ifelse
	)
	(changefont)
	ifelse
) def

%---------------------------------------------------------------------------%

"add-rub"
(	(0 0 0 0)
	(	(name "Add Rubber Band")
		(list "Direction:"		(Horizontal Vertical))
		(list "Style:"				(Normal Bold Double dOtted))
		(list "End segments:"	(Half Full None))
		(list "Fill:"				(Box Cell))
		(button (Insert Cancel) )
	)
	dialog
	0 eq?
	(	rubnames
		1 ndup 0 get get
		1 ndup 1 get get
		1 ndup 2 get get
		xchg 3 get neg -1 -1 1 -4 rol addrb
	)
	(pop)
	ifelse
) def

%---------------------------------------------------------------------------%

"do-quit"
(  windowtype 0 eq?
	(	1 quit
		(	(	("No"		<Do not quit--continue editing>			'n')
				("Yes"	<Abandon changed documents and quit>	'y')
				("Write"	<Write all changed documents and quit> 'w')
			) menu2
			dup 'y' eq?
			(NIL quit)
			('w' eq? (writeall (NIL quit) if ) if)
			ifelse
		) if
	)
   (beep)
	ifelse
) def

%---------------------------------------------------------------------------%

"getsysdir"
( 	( sysdir ) getinfo xchg pop 0 get )
def

%---------------------------------------------------------------------------%

"newmatrix"
(	0 setrefresh
	createbox
	(dup 1 gt?)
	(	0 -1 addcol
		1 "VBlank" 0 -1 -1 addrb
		0 -1 addcol
		1 sub
	)
	while
	pop
	(dup 1 gt?) (0 -1 addrow 1 sub) while
	pop
	1 setrefresh refresh
) def

"newtable"
(	0 setrefresh
	dup "Table" equ? ("VNormalF") ("VNormalH") ifelse
	"tmprb" xchg set
	createbox
	(dup 2 gt?)
	(	0 -1 addcol
		tmprb 0 -1 -1 1 -4 rol addrb
		0 -1 addcol
		1 sub
	)
	while
	pop
	1 0 cellmove
	(dup 2 gt?) (0 -1 addrow 1 sub) while
	pop
	-1 0 cellmove
	1 setrefresh refresh
) def

%---------------------------------------------------------------------------%

;	adds an extra separator column
;	puts a blank rubber band in the separator column
;	"addboxcol"
;	(	0 setrefresh
;		"tmp" protected? set
;		0 1 ndup addcol
;		tmp not (1 "VBlank" 0 -1 -1 addrb) if
;		0 1 ndup addcol
;		0 xchg addcol
;		tmp
;		(	1 "VBlank" 0 -1 -1 addrb
;			1 eq? (-1) (1) ifelse
;			0 xchg cellmove
;		)
;		(pop)
;		ifelse
;		1 setrefresh refresh
;	) def

"addboxcol"
;	adds an extra separator column
(	0 setrefresh
	0 1 ndup addcol
	0 xchg addcol
	1 setrefresh refresh
) def

"do-addcol"
(	wherecursor
	dup _inbox eq?
	(pop addboxcol)
	(	_intab eq?
		(0 xchg addcol)
		(<Cursor must be in a box or table> message)
		ifelse
	)
	ifelse
) def

%---------------------------------------------------------------------------%

"do-switchdoc" (mark-off switchdoc) def

%---------------------------------------------------------------------------%

"do-center"
(	wherecursor _intext eq? grid? and
	(	(dpwid dlmrg drmrg) getinfo xchg pop
		column neg cmove
		dup 1 get toCol cmove
		dup 0 get xchg dup 1 get xchg 2 get addunit subunit toCol
		end home sub
		sub 2 div
		cmove
		set-lm
	)
	(formatNxt (pformat) (2) putinfo)
	ifelse
) def

%---------------------------------------------------------------------------%

"forall"
(  xchg
   0
   ( dup 2 rol length 2 rol gt? )
   ( dup 2 rol dup -2 rol get 3 rol dup -4 rol eval 1 add )
   while
   pop pop pop
) def

%---------------------------------------------------------------------------%

"evalStyle"
(	resetprn
	style length
	(ppitch) getinfo xchg pop 0 get dup -2 rol
	le? ( pop (ppitch) (0) putinfo 0 ) if
	get eval
) def

%---------------------------------------------------------------------------%

(pdriver) getinfo 0 get xchg pop
resetstr
read not
( <Cannot open printer driver.  Hit any key to continue.> message wait )
if

"style" def?
( evalStyle ) if

"MENU.CS" read not (<Cannot find MENU.CS> error) if
"KEYS.CS" read not (<Cannot find KEYS.CS> error) if
mainoptions setmenuline

(ksfile) getinfo xchg pop 0 get read pop
"autoexec" getbind keyseq? (autoexec sendkeys) if

%---------------------------------------------------------------------------%

