#include <stdio.h>
#include <errno.h>
#include <bios.h>

#define sendbyte(x)	_bios_serialcom(_COM_SEND,1,x);

#define NULLCMD		0
#define READCMD		1
#define WRITECMD	2
#define FORMATCMD	4

FILE *disk=NULL;
unsigned char buf[256];
int tk,sc,slot,drv;
int byte, cmd;
int lastslot=-1, lastdrv=-1;

char *drvname=" ab";

getbyte()
 {
  int i;

  while(1)
    { i= _bios_serialcom(_COM_RECEIVE,1,0);
      if (i<256) return(i);
    }
 }

opendisk()
 {
  char name[16];

  if (disk) fclose(disk);
  sprintf(name,"disk_%d%c.dsk",slot,drvname[drv]);
  printf("Opening %s\n",name);
  errno=0;
  disk= fopen(name,"r+b");
  if (disk==NULL)
   { disk= fopen(name,"w+b");
     fseek(disk,143359L,SEEK_SET);
     fwrite(disk,1,1,disk);
   }
  lastslot=slot; lastdrv=drv;
 }

main()
 {
  int i,result;
  long offset;

  _bios_serialcom(_COM_INIT,1,_COM_CHR8|_COM_STOP1|_COM_NOPARITY|_COM_9600);

  while(1)
   {
    byte=getbyte();
    if (byte!=3) continue;
    slot=getbyte(); slot=slot/16;
    drv=getbyte();
    tk=getbyte();
    sc=getbyte();
    cmd=getbyte();
    if (cmd==WRITECMD) for (i=0;i<256;i++) buf[i]=getbyte();

    printf("3 %x %x %x %x %x\n",slot,drv,tk,sc,cmd);

    if (slot!=lastslot || drv != lastdrv) opendisk();
    offset= 4096L*tk + 256L*sc;
#ifdef NOT
    printf("offset is %ld %lx %x %x\n",offset,offset,tk,sc);
#endif
    fseek(disk,offset,SEEK_SET);


    switch(cmd)
     {
      case WRITECMD: fwrite(buf,1,256,disk);
		     result=0; goto null;
      case READCMD:  fread(buf,1,256,disk);
#ifdef NOT
		     printf("Buf is ");
		     for (i=0;i<16;i++) printf("%x ",buf[i]);
		     printf("\n");
#endif
		     result=0;
      case FORMATCMD:
      case NULLCMD:
null:
		     sendbyte(3);
		     sendbyte(result);
#ifdef NOT
		     printf("Sent 3 %x\n",result);
#endif
		     if (cmd==READCMD)
		       {
		        for(i=0;i<256;i++) sendbyte(buf[i]);
#ifdef NOT
			printf("Sent buffer\n");
#endif
		       }
     }
   }
 }
