/****************************************************************************
*
*  APPLE //E EMULATOR FOR WINDOWS                    
*
*  Copyright (C) 1994-96, Michael O'Brien.  All rights reserved.
*
***/

#include "stdhdr.h"
#pragma  hdrstop
#include "applewin.h"

BYTE asciicode[4] = {0x08,0x0B,0x15,0x0A};

BOOL  capslock        = 1;
int   lastvirtkey     = 0;
BYTE  keycode         = 0;
BOOL  keywaiting      = 0;
DWORD keyboardqueries = 0;

//
// ----- ALL GLOBALLY ACCESSIBLE FUNCTIONS ARE BELOW THIS LINE -----
//

//===========================================================================
void KeybGetCapsStatus (BOOL *status) {
  *status = capslock;
}

//===========================================================================
BYTE KeybGetKeycode () {
  return keycode;
}

//===========================================================================
DWORD KeybGetNumQueries () {
  DWORD result = keyboardqueries;
  keyboardqueries = 0;
  return result;
}

//===========================================================================
void KeybQueueKeypress (int key, BOOL ascii) {
  if (ascii) {
    if (key > 0x7F)
      return;
    if ((key >= 'a') && (key <= 'z') && (capslock || !apple2e))
      keycode = key - ('a'-'A');
    else
      keycode = key;
    lastvirtkey = LOBYTE(VkKeyScan(key));
  }
  else {
    if (((key == VK_CANCEL) || (key == VK_F12)) &&
        ((!apple2e) || (GetKeyState(VK_CONTROL) < 0))) {
      if (apple2e)
        MemResetPaging();
      DiskReset();
      regs.pc = *(LPWORD)(mem+0xFFFC);
      return;
    }
    if (!((key >= VK_LEFT) && (key <= VK_DOWN)))
      return;
    keycode = asciicode[key - VK_LEFT];
    lastvirtkey = key;
  }
  keywaiting = 1;
}

//===========================================================================
BYTE __stdcall KeybReadData (WORD, BYTE, BYTE, BYTE) {
  keyboardqueries++;
  return keycode | (keywaiting ? 0x80 : 0);
}

//===========================================================================
BYTE __stdcall KeybReadFlag (WORD, BYTE, BYTE, BYTE) {
  keyboardqueries++;
  keywaiting = 0;
  return keycode | ((GetKeyState(lastvirtkey) < 0) ? 0x80 : 0);
}

//===========================================================================
void KeybToggleCapsLock () {
  if (apple2e) {
    capslock = (GetKeyState(VK_CAPITAL) & 1);
    FrameRefreshStatus(DRAW_LEDS);
  }
}
