/****************************************************************************
*
*  APPLE //E EMULATOR FOR WINDOWS                    
*
*  Copyright (C) 1994-96, Michael O'Brien.  All rights reserved.
*
***/

#include "stdhdr.h"
#pragma  hdrstop
#include "applewin.h"

//
// ----- ALL GLOBALLY ACCESSIBLE FUNCTIONS ARE BELOW THIS LINE -----
//

//===========================================================================
BOOL RegLoadString (LPCTSTR section, LPCTSTR key, BOOL peruser,
                    LPTSTR buffer, DWORD chars) {
  BOOL  success = 0;
  TCHAR fullkeyname[256];
  wsprintf(fullkeyname,
           TEXT("Software\\AppleWin\\CurrentVersion\\%s"),
           (LPCTSTR)section);
  HKEY keyhandle;
  if (!RegOpenKeyEx((peruser ? HKEY_CURRENT_USER : HKEY_LOCAL_MACHINE),
                    fullkeyname,
                    0,
                    KEY_READ,
                    &keyhandle)) {
    DWORD type;
    DWORD size = chars;
    success = (!RegQueryValueEx(keyhandle,key,0,&type,(LPBYTE)buffer,&size)) &&
                                size;
    RegCloseKey(keyhandle);
  }
  return success;
}

//===========================================================================
BOOL RegLoadValue (LPCTSTR section, LPCTSTR key, BOOL peruser, DWORD *value) {
  if (!value)
    return 0;
  TCHAR buffer[32] = TEXT("");
  if (!RegLoadString(section,key,peruser,buffer,32))
    return 0;
  buffer[31] = 0;
  *value = (DWORD)_ttoi(buffer);
  return 1;
}

//===========================================================================
void RegSaveString (LPCTSTR section, LPCTSTR key, BOOL peruser, LPCTSTR buffer) {
  TCHAR fullkeyname[256];
  wsprintf(fullkeyname,
           TEXT("Software\\AppleWin\\CurrentVersion\\%s"),
           (LPCTSTR)section);
  HKEY  keyhandle;
  DWORD disposition;
  if (!RegCreateKeyEx((peruser ? HKEY_CURRENT_USER : HKEY_LOCAL_MACHINE),
                      fullkeyname,
                      0,
                      NULL,
                      REG_OPTION_NON_VOLATILE,
                      KEY_READ | KEY_WRITE,
                      (LPSECURITY_ATTRIBUTES)NULL,
                      &keyhandle,
                      &disposition)) {
    RegSetValueEx(keyhandle,
                  key,
                  0,
                  REG_SZ,
                  (CONST BYTE *)buffer,
                  (_tcslen(buffer)+1)*sizeof(TCHAR));
    RegCloseKey(keyhandle);
  }
}

//===========================================================================
void RegSaveValue (LPCTSTR section, LPCTSTR key, BOOL peruser, DWORD value) {
  TCHAR buffer[32] = TEXT("");
  _ultot(value,buffer,10);
  RegSaveString(section,key,peruser,buffer);
}
