/****************************************************************************
*
*  APPLE //E EMULATOR FOR WINDOWS                    
*
*  Copyright (C) 1994-96, Michael O'Brien.  All rights reserved.
*
***/

#include "stdhdr.h"
#pragma  hdrstop
#include "applewin.h"

#define  MAXSAVED  4

BYTE asciicode[0x70][4] = { {0x00,0x00,0x00,0x00},         // 0x00
                            {0x00,0x00,0x00,0x00},         // 0x01
                            {0x00,0x00,0x00,0x00},         // 0x02
                            {0x00,0x00,0x00,0x00},         // 0x03
                            {0x00,0x00,0x00,0x00},         // 0x04
                            {0x00,0x00,0x00,0x00},         // 0x05
                            {0x00,0x00,0x00,0x00},         // 0x06
                            {0x00,0x00,0x00,0x00},         // 0x07
                            {0x08,0x7F,0x08,0x7F},         // 0x08 VK_BACK
                            {0x09,0x09,0x09,0x09},         // 0x09 VK_TAB
                            {0x00,0x00,0x00,0x00},         // 0x0A
                            {0x00,0x00,0x00,0x00},         // 0x0B
                            {0x00,0x00,0x00,0x00},         // 0x0C
                            {0x0D,0x0D,0x0D,0x0D},         // 0x0D VK_RETURN
                            {0x00,0x00,0x00,0x00},         // 0x0E
                            {0x00,0x00,0x00,0x00},         // 0x0F
                            {0x00,0x00,0x00,0x00},         // 0x10
                            {0x00,0x00,0x00,0x00},         // 0x11
                            {0x00,0x00,0x00,0x00},         // 0x12
                            {0x00,0x00,0x00,0x00},         // 0x13
                            {0x00,0x00,0x00,0x00},         // 0x14
                            {0x00,0x00,0x00,0x00},         // 0x15
                            {0x00,0x00,0x00,0x00},         // 0x16
                            {0x00,0x00,0x00,0x00},         // 0x17
                            {0x00,0x00,0x00,0x00},         // 0x18
                            {0x00,0x00,0x00,0x00},         // 0x19
                            {0x00,0x00,0x00,0x00},         // 0x1A
                            {0x1B,0x1B,0x1B,0x1B},         // 0x1B VK_ESCAPE
                            {0x00,0x00,0x00,0x00},         // 0x1C
                            {0x00,0x00,0x00,0x00},         // 0x1D
                            {0x00,0x00,0x00,0x00},         // 0x1E
                            {0x00,0x00,0x00,0x00},         // 0x1F
                            {0x20,0x20,0x20,0x20},         // 0x20 VK_SPACE
                            {0x00,0x00,0x00,0x00},         // 0x21
                            {0x00,0x00,0x00,0x00},         // 0x22
                            {0x00,0x00,0x00,0x00},         // 0x23
                            {0x00,0x00,0x00,0x00},         // 0x24
                            {0x08,0x08,0x08,0x08},         // 0x25 VK_LEFT
                            {0x0B,0x0B,0x0B,0x0B},         // 0x26 VK_UP
                            {0x15,0x15,0x15,0x15},         // 0x27 VK_RIGHT
                            {0x0A,0x0A,0x0A,0x0A},         // 0x28 VK_DOWN
                            {0x00,0x00,0x00,0x00},         // 0x29
                            {0x00,0x00,0x00,0x00},         // 0x2A
                            {0x00,0x00,0x00,0x00},         // 0x2B
                            {0x00,0x00,0x00,0x00},         // 0x2C
                            {0x00,0x00,0x00,0x00},         // 0x2D
                            {0x7F,0x7F,0x7F,0x7F},         // 0x2E VK_DELETE
                            {0x00,0x00,0x00,0x00},         // 0x2F
                            {0x30,0x30,0x29,0x29},         // 0x30 VK_0
                            {0x31,0x31,0x21,0x21},         // 0x31 VK_1
                            {0x32,0x00,0x40,0x00},         // 0x32 VK_2
                            {0x33,0x33,0x23,0x23},         // 0x33 VK_3
                            {0x34,0x34,0x24,0x24},         // 0x34 VK_4
                            {0x35,0x35,0x25,0x25},         // 0x35 VK_5
                            {0x36,0x1E,0x5E,0x1E},         // 0x36 VK_6
                            {0x37,0x37,0x26,0x26},         // 0x37 VK_7
                            {0x38,0x38,0x2A,0x2A},         // 0x38 VK_8
                            {0x39,0x39,0x28,0x28},         // 0x39 VK_9
                            {0x3B,0x3B,0x3A,0x3A},         // 0x3A ; :
                            {0x3D,0x3D,0x2B,0x2B},         // 0x3B = +
                            {0x2C,0x2C,0x3C,0x3C},         // 0x3C , <
                            {0x2D,0x1F,0x5F,0x1F},         // 0x3D - _
                            {0x2E,0x2E,0x3E,0x3E},         // 0x3E . >
                            {0x2F,0x2F,0x3F,0x3F},         // 0x3F / ?
                            {0x60,0x60,0x7E,0x7E},         // 0x40 ` ~
                            {0x61,0x01,0x41,0x01},         // 0x41 VK_A
                            {0x62,0x02,0x42,0x02},         // 0x42 VK_B
                            {0x63,0x03,0x43,0x03},         // 0x43 VK_C
                            {0x64,0x04,0x44,0x04},         // 0x44 VK_D
                            {0x65,0x05,0x45,0x05},         // 0x45 VK_E
                            {0x66,0x06,0x46,0x06},         // 0x46 VK_F
                            {0x67,0x07,0x47,0x07},         // 0x47 VK_G
                            {0x68,0x08,0x48,0x08},         // 0x48 VK_H
                            {0x69,0x09,0x49,0x09},         // 0x49 VK_I
                            {0x6A,0x0A,0x4A,0x0A},         // 0x4A VK_J
                            {0x6B,0x0B,0x4B,0x0B},         // 0x4B VK_K
                            {0x6C,0x0C,0x4C,0x0C},         // 0x4C VK_L
                            {0x6D,0x0D,0x4D,0x0D},         // 0x4D VK_M
                            {0x6E,0x0E,0x4E,0x0E},         // 0x4E VK_N
                            {0x6F,0x0F,0x4F,0x0F},         // 0x4F VK_O
                            {0x70,0x10,0x50,0x10},         // 0x50 VK_P
                            {0x71,0x11,0x51,0x11},         // 0x51 VK_Q
                            {0x72,0x12,0x52,0x12},         // 0x52 VK_R
                            {0x73,0x13,0x53,0x13},         // 0x53 VK_S
                            {0x74,0x14,0x54,0x14},         // 0x54 VK_T
                            {0x75,0x15,0x55,0x15},         // 0x55 VK_U
                            {0x76,0x16,0x56,0x16},         // 0x56 VK_V
                            {0x77,0x17,0x57,0x17},         // 0x57 VK_W
                            {0x78,0x18,0x58,0x18},         // 0x58 VK_X
                            {0x79,0x19,0x59,0x19},         // 0x59 VK_Y
                            {0x7A,0x1A,0x5A,0x1A},         // 0x5A VK_Z
                            {0x5B,0x1B,0x7B,0x1B},         // 0x5B [ {
                            {0x5C,0x1C,0x7C,0x1C},         // 0x5C \ |
                            {0x5D,0x1D,0x7D,0x1D},         // 0x5D ] }
                            {0x27,0x27,0x22,0x20},         // 0x5E ' "
                            {0x00,0x00,0x00,0x00},         // 0x5F
                            {0x30,0x30,0x30,0x30},         // 0x60 VK_NUMPAD0
                            {0x31,0x31,0x31,0x31},         // 0x61 VK_NUMPAD1
                            {0x32,0x32,0x32,0x32},         // 0x62 VK_NUMPAD2
                            {0x33,0x33,0x33,0x33},         // 0x63 VK_NUMPAD3
                            {0x34,0x34,0x34,0x34},         // 0x64 VK_NUMPAD4
                            {0x35,0x35,0x35,0x35},         // 0x65 VK_NUMPAD5
                            {0x36,0x36,0x36,0x36},         // 0x66 VK_NUMPAD6
                            {0x37,0x37,0x37,0x37},         // 0x67 VK_NUMPAD7
                            {0x38,0x38,0x38,0x38},         // 0x68 VK_NUMPAD8
                            {0x39,0x39,0x39,0x39},         // 0x69 VK_NUMPAD9
                            {0x2A,0x2A,0x2A,0x2A},         // 0x6A VK_MULTIPLY
                            {0x2B,0x2B,0x2B,0x2B},         // 0x6B VK_ADD
                            {0x00,0x00,0x00,0x00},         // 0x6C
                            {0x2D,0x2D,0x2D,0x2D},         // 0x6D VK_SUBTRACT
                            {0x2E,0x2E,0x2E,0x2E},         // 0x6E VK_DECIMAL
                            {0x2F,0x2F,0x2F,0x2F} };       // 0x6F VK_DIVIDE

BOOL  capslock        = 1;
int   lastvirtkey     = 0;
BYTE  keycode         = 0;
BOOL  keywaiting      = 0;
DWORD keyboardqueries = 0;

//
// ----- ALL GLOBALLY ACCESSIBLE FUNCTIONS ARE BELOW THIS LINE -----
//

//===========================================================================
void KeybGetCapsStatus (BOOL *status) {
  *status = capslock;
}

//===========================================================================
BYTE KeybGetKeycode () {
  return keycode;
}

//===========================================================================
DWORD KeybGetNumQueries () {
  DWORD result = keyboardqueries;
  keyboardqueries = 0;
  return result;
}

//===========================================================================
BYTE __stdcall KeybReadData (WORD, BYTE, BYTE, BYTE) {
  keyboardqueries++;
  return keycode | (keywaiting ? 0x80 : 0);
}

//===========================================================================
BYTE __stdcall KeybReadFlag (WORD, BYTE, BYTE, BYTE) {
  keyboardqueries++;
  keywaiting = 0;
  return keycode | ((GetKeyState(lastvirtkey) < 0) ? 0x80 : 0);
}

//===========================================================================
void KeybQueueKeypress (int virtkey, BOOL extended) {
  if ((virtkey == VK_CAPITAL) && apple2e) {
    capslock = (GetKeyState(VK_CAPITAL) & 1);
    FrameRefreshStatus();
  }
  if (((virtkey == VK_CANCEL) || (virtkey == VK_F12)) &&
      ((!apple2e) || (GetKeyState(VK_CONTROL) < 0))) {
    if (apple2e)
      MemResetPaging();
    DiskReset();
    regs.pc = *(LPWORD)(mem+0xFFFC);
  }
  if ((virtkey & 0x7F) > 0x6F)
    return;
  lastvirtkey = virtkey;
  int ctrl  = (GetKeyState(VK_CONTROL) < 0);
  int shift = (GetKeyState(VK_SHIFT  ) < 0);
  if ((virtkey >= 'A') && (virtkey <= 'Z') && (capslock || !apple2e))
    shift = 1;
  keycode    = asciicode[virtkey & 0x7F][ctrl | (shift << 1)];
  keywaiting = (keycode != 0);
}
