#include "apple.h"
#include "gl.h"
#include "device.h"

/* Graphics globals */
#define SCREEN 107520  /* 560*192 */

short tpage[SCREEN];
short hgr1[SCREEN];
short hgr2[SCREEN]; 
short pri_charset[256][56];
short alt_charset[256][56];
int   hgr_tab[8192];
short Lres [16] =
		{0,1,4,13,2,15,14,12,11,9,8,5,10,3,6,7};

void makenoise()
{
	ringbell();
}

void init_graphics ()
{
	int y1,yr,y2,ys;
	int x,y,addr;
	FILE *fp;
	char temp[50];

/* read the primary character set */
        if ((fp = fopen ("pri.font", "r")) == NULL) exit(1);
	for (y=0;y<=255;y++) { /* for each of 256 chars */
		(void)fscanf(fp,"%d",&y1);
		if (y1 != y) exit(1);
		y2 = 0;
		for(x=0; x<=7; x++) {   /* for each of 8 lines */
			(void)fscanf(fp,"%s",temp);
			for (ys=0;ys<=6;ys++) {  /* for each of 7 chars */
				switch (temp[ys])
				{
				case '_' :
					yr = 0;
					break;
				case 'X' :
					yr = 7;
					break;
				case 'i' :
					yr = 7;
					break;
				case 'I' :
					yr = 0;
					break;
				case 'f' :
					yr = 4;
					break;
				case 'F' :
					yr = 3;
					break;
				}
				pri_charset[y1][y2++] = yr;
			}
		}
	}
	(void)fclose(fp);

/* read the alternate character set */
        if ((fp = fopen ("alt.font", "r")) == NULL) exit(1);
	for (y=0;y<=255;y++) { /* for each of 256 chars */
		(void)fscanf(fp,"%d",&y1);
		if (y1 != y) exit(1);
		y2 = 0;
		for(x=0; x<=7; x++) {   /* for each of 8 lines */
			(void)fscanf(fp,"%s",temp);
			for (ys=0;ys<=6;ys++) {  /* for each of 7 chars */
				switch (temp[ys])
				{
				case '_' :
					yr = 0;
					break;
				case 'X' :
					yr = 7;
					break;
				case 'i' :
					yr = 7;
					break;
				case 'I' :
					yr = 0;
					break;
				case 'f' :
					yr = 4;
					break;
				case 'F' :
					yr = 3;
					break;
				}
				alt_charset[y1][y2++] = yr;
			}
		}
	}
	(void)fclose(fp);


 
/* open a window  and start the queue */

	(void) foreground();
	(void) prefsize(560,384);
	(void) winopen("Apple //e");
	(void) cmode();
	(void) doublebuffer();
	(void) gconfig();
	(void) qdevice(KEYBD);
	(void) qdevice(F3KEY);
	(void) qdevice(TIMER0);
	(void) qdevice(MOUSE1);
	(void) qdevice(MOUSE2);
	(void) qdevice(MOUSE3);
	(void) qdevice(RIGHTARROWKEY);
	(void) qdevice(LEFTARROWKEY);
	(void) qdevice(UPARROWKEY);
	(void) qdevice(DOWNARROWKEY);
	(void) noise(TIMER0,30);  /* every 1/2 second */
	(void) qreset;
	(void) qenter(REDRAW,0); /* the initial draw screen command */
	
	

/* set up the HGR lookup table */
/* hgr_tab[addr] => the point in hgrx[] to place the graphic data */
	for (x=0; x < 8192; x++) hgr_tab[x] = -1; /* prime holes */
	for (y=0; y < 192; y++)
		{
			y1 = y / 8;
			yr = y - (y1 * 8);
			y2 = y1 / 8;
			ys = y1 - (y2 * 8);
			addr = (y2*40) + (ys*128) + (yr*1024);
/*			printf("%d:%x\n",y,addr); */
			for (x=0; x < 40; x++)
				hgr_tab[addr+x] = ((191-y)*560) + (x*14);
		}

/*	for (x=0; x < 8192; x++) printf("%x:%d",x,hgr_tab[x]); */
	
	
}

void do_event()
{
	long dev,x,y;
	short val; 

	if (qtest() > 0)  {

	   dev = qread(&val);   /* get the event */

	   switch (dev)
	   {
	   case TIMER0:  /* If the timer happens then redraw */
	   case REDRAW:
		reshapeviewport();
		rectzoom(1.0,2.0);
		if ((TEXT != 0)||(HIRES == 0)) {  /* this is for TEXT and LORES */
			rectwrite(0,0,559,191,tpage);
		} else if (MIXED) {
			if (PAGE2) {   /* HGR part */
				rectwrite(0,0,559,191,hgr2);
			} else {
				rectwrite(0,0,559,191,hgr1);
			}   /* TEXT part */
			rectwrite(0,0,559,31,tpage);
		} else {   /* pure HGR */
			if (PAGE2) {
				rectwrite(0,0,559,191,hgr2);
			} else {
				rectwrite(0,0,559,191,hgr1);
			}
		}
		swapbuffers();
		break;
	   case KEYBD:
		MegaLastKey = (int) val | 0x80;
		break;
	   case F3KEY:
		if (val == 1) MegaQuitDetect = 1;
		break;
	   case RIGHTMOUSE:
		(void) getorigin(&x,&y);
		(void) setvaluator(MOUSEX, (short)(x+280) , 0, 1279);
		(void) setvaluator(MOUSEY, (short)(y+192) , 0, 1023);
		break;
	   case RIGHTARROWKEY:
		if (val == 1) qenter(KEYBD,(short)21);
		break;
	   case LEFTARROWKEY:
		if (val == 1) qenter(KEYBD,(short)8);
		break;
	   case DOWNARROWKEY:
		if (val == 1) qenter(KEYBD,(short)10);
		break;
	   case UPARROWKEY:
		if (val == 1) qenter(KEYBD,(short)11);
		break;
	   }
	}
}

int grBUTTON (addr)
ADDR addr;
{
	switch (addr & 0xff)
	{
	case 0x61:
		return (getbutton(LEFTMOUSE) || getbutton(F1KEY));
		break;
	case 0x62:
		return (getbutton(MIDDLEMOUSE) || getbutton(F2KEY));
		break;
	}
	return (0);
}

void grC070 ()
{
	int x,y;
	(void) getorigin(&x, &y);
	x = getvaluator(MOUSEX) - x;
	y = getvaluator(MOUSEY) - y;
	if ( y > 384) y = 384;
	if ( x > 560) x = 560;
	paddle0 = x / 560.0;      
	paddle1 = (384 - y) / 384.0;      
	
}

void grHGR(addr,data)
BYTE	data;
ADDR	addr;
{
	int bddr,tdata,i;

	tdata = data;

	bddr = hgr_tab[addr & 0x1fff];
	if (bddr == -1) return;  /* screen holes */
	if (addr > 0x3fff) {  /* HGR2 */
		for(i=0; i <=6; i++) {
			if (tdata & 1) {
				hgr2[bddr++] = 7;
				hgr2[bddr++] = 7;
			} else {
				hgr2[bddr++] = 0;
				hgr2[bddr++] = 0;
			}
			tdata = tdata >> 1;
		}
	} else {   /* HGR1 */
		for(i=0; i <=6; i++) {
			if (tdata & 1) {
				hgr1[bddr++] = 7;
				hgr1[bddr++] = 7;
			} else {
				hgr1[bddr++] = 0;
				hgr1[bddr++] = 0;
			}
			tdata = tdata >> 1;
		}
	}
}

/* data = char, x,y=pos col80 = 1 is 80columns */ 
/* x=0-79  y=0-23 */
void grTEXT(data,y,x,col80)
int	data,x,y,col80;
{
	int addr,x1,y1,i,bddr,d;
	
	d = data & 0xff;

	addr = ((23 - y)*8+7) * 560;
	if (col80 != 0) {
		addr = addr + (7 * x); 
	} else {
		 addr = addr + (14 * x);
	}
	if (((!TEXT) && (!HIRES)) && ((y < 20) || (!MIXED))) {  
/* If (not in text mode and not in hires) and (y<20 or not mixed) LORES */
		i = d & 0xf;  /* bottom block is top 4 bits */
		for (y1=0; y1 <=3; y1++)  {
			bddr = addr;
			for (x1 = 0; x1 <=6; x1++) {
				if (col80 == 0) tpage[bddr++] = Lres[i];
				tpage[bddr++] = Lres[i];
			}
			addr = addr - 560;
		}
		i = d >> 4;   /* top block is bottom 4 bits */
		for (y1=0; y1 <=3; y1++)  {
			bddr = addr;
			for (x1 = 0; x1 <=6; x1++) {
				if (col80 == 0) tpage[bddr++] = Lres[i];
				tpage[bddr++] = Lres[i];
			}
			addr = addr - 560;
		}
	} else {
/* normal text */
	 if (ALTCHAR) {
	   i = 0;
	   for (y1 = 0; y1 <= 7; y1++) {
		bddr = addr;
		for (x1 = 0; x1 <= 6; x1++) {
			if (col80 == 0) tpage[bddr++] = alt_charset[d][i];
			tpage[bddr++] = alt_charset[d][i++];
			
		}
		addr = addr - 560;
	   }
	 } else {
	   i = 0;
	   for (y1 = 0; y1 <= 7; y1++) {
		bddr = addr;
		for (x1 = 0; x1 <= 6; x1++) {
			if (col80 == 0) tpage[bddr++] = pri_charset[d][i];
			tpage[bddr++] = pri_charset[d][i++];
			
		}
		addr = addr - 560;
	   }
	 }
	}
	
}
